# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 api: Optional[pulumi.Input['ApplicationApiArgs']] = None,
                 app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_only_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_public_client_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identifier_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logo_image: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 oauth2_post_response_required: Optional[pulumi.Input[builtins.bool]] = None,
                 optional_claims: Optional[pulumi.Input['ApplicationOptionalClaimsArgs']] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input['ApplicationPasswordArgs']] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 public_client: Optional[pulumi.Input['ApplicationPublicClientArgs']] = None,
                 required_resource_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 single_page_application: Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 web: Optional[pulumi.Input['ApplicationWebArgs']] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input['ApplicationApiArgs'] api: An `api` block as documented below, which configures API related settings for this application.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]] app_roles: A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.bool] device_only_auth_enabled: Specifies whether this application supports device authentication without a user. Defaults to `false`.
        :param pulumi.Input[builtins.bool] fallback_public_client_enabled: Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identifier_uris: A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        :param pulumi.Input[builtins.str] logo_image: A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        :param pulumi.Input[builtins.str] marketing_url: URL of the application's marketing page.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.bool] oauth2_post_response_required: Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        :param pulumi.Input['ApplicationOptionalClaimsArgs'] optional_claims: An `optional_claims` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the application
        :param pulumi.Input['ApplicationPasswordArgs'] password: A single `password` block as documented below. The password is generated during creation. By default, no password is generated.
               
               > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        :param pulumi.Input[builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the application's privacy statement.
        :param pulumi.Input['ApplicationPublicClientArgs'] public_client: A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]] required_resource_accesses: A collection of `required_resource_access` blocks as documented below.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
               
               > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        :param pulumi.Input['ApplicationSinglePageApplicationArgs'] single_page_application: A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        :param pulumi.Input[builtins.str] support_url: URL of the application's support page.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        :param pulumi.Input[builtins.str] template_id: Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.
               
               > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the application's terms of service statement.
        :param pulumi.Input['ApplicationWebArgs'] web: A `web` block as documented below, which configures web related settings for this application.
               
               > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        pulumi.set(__self__, "display_name", display_name)
        if api is not None:
            pulumi.set(__self__, "api", api)
        if app_roles is not None:
            pulumi.set(__self__, "app_roles", app_roles)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_only_auth_enabled is not None:
            pulumi.set(__self__, "device_only_auth_enabled", device_only_auth_enabled)
        if fallback_public_client_enabled is not None:
            pulumi.set(__self__, "fallback_public_client_enabled", fallback_public_client_enabled)
        if feature_tags is not None:
            pulumi.set(__self__, "feature_tags", feature_tags)
        if group_membership_claims is not None:
            pulumi.set(__self__, "group_membership_claims", group_membership_claims)
        if identifier_uris is not None:
            pulumi.set(__self__, "identifier_uris", identifier_uris)
        if logo_image is not None:
            pulumi.set(__self__, "logo_image", logo_image)
        if marketing_url is not None:
            pulumi.set(__self__, "marketing_url", marketing_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if oauth2_post_response_required is not None:
            pulumi.set(__self__, "oauth2_post_response_required", oauth2_post_response_required)
        if optional_claims is not None:
            pulumi.set(__self__, "optional_claims", optional_claims)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if prevent_duplicate_names is not None:
            pulumi.set(__self__, "prevent_duplicate_names", prevent_duplicate_names)
        if privacy_statement_url is not None:
            pulumi.set(__self__, "privacy_statement_url", privacy_statement_url)
        if public_client is not None:
            pulumi.set(__self__, "public_client", public_client)
        if required_resource_accesses is not None:
            pulumi.set(__self__, "required_resource_accesses", required_resource_accesses)
        if service_management_reference is not None:
            pulumi.set(__self__, "service_management_reference", service_management_reference)
        if sign_in_audience is not None:
            pulumi.set(__self__, "sign_in_audience", sign_in_audience)
        if single_page_application is not None:
            pulumi.set(__self__, "single_page_application", single_page_application)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)
        if web is not None:
            pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['ApplicationApiArgs']]:
        """
        An `api` block as documented below, which configures API related settings for this application.
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['ApplicationApiArgs']]):
        pulumi.set(self, "api", value)

    @property
    @pulumi.getter(name="appRoles")
    def app_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]]:
        """
        A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        """
        return pulumi.get(self, "app_roles")

    @app_roles.setter
    def app_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]]):
        pulumi.set(self, "app_roles", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceOnlyAuthEnabled")
    def device_only_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether this application supports device authentication without a user. Defaults to `false`.
        """
        return pulumi.get(self, "device_only_auth_enabled")

    @device_only_auth_enabled.setter
    def device_only_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "device_only_auth_enabled", value)

    @property
    @pulumi.getter(name="fallbackPublicClientEnabled")
    def fallback_public_client_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        """
        return pulumi.get(self, "fallback_public_client_enabled")

    @fallback_public_client_enabled.setter
    def fallback_public_client_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_public_client_enabled", value)

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "feature_tags")

    @feature_tags.setter
    def feature_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]]):
        pulumi.set(self, "feature_tags", value)

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @group_membership_claims.setter
    def group_membership_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_membership_claims", value)

    @property
    @pulumi.getter(name="identifierUris")
    def identifier_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        """
        return pulumi.get(self, "identifier_uris")

    @identifier_uris.setter
    def identifier_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identifier_uris", value)

    @property
    @pulumi.getter(name="logoImage")
    def logo_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        """
        return pulumi.get(self, "logo_image")

    @logo_image.setter
    def logo_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_image", value)

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's marketing page.
        """
        return pulumi.get(self, "marketing_url")

    @marketing_url.setter
    def marketing_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "marketing_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="oauth2PostResponseRequired")
    def oauth2_post_response_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        """
        return pulumi.get(self, "oauth2_post_response_required")

    @oauth2_post_response_required.setter
    def oauth2_post_response_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "oauth2_post_response_required", value)

    @property
    @pulumi.getter(name="optionalClaims")
    def optional_claims(self) -> Optional[pulumi.Input['ApplicationOptionalClaimsArgs']]:
        """
        An `optional_claims` block as documented below.
        """
        return pulumi.get(self, "optional_claims")

    @optional_claims.setter
    def optional_claims(self, value: Optional[pulumi.Input['ApplicationOptionalClaimsArgs']]):
        pulumi.set(self, "optional_claims", value)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of object IDs of principals that will be granted ownership of the application
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ApplicationPasswordArgs']]:
        """
        A single `password` block as documented below. The password is generated during creation. By default, no password is generated.

        > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ApplicationPasswordArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @prevent_duplicate_names.setter
    def prevent_duplicate_names(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prevent_duplicate_names", value)

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's privacy statement.
        """
        return pulumi.get(self, "privacy_statement_url")

    @privacy_statement_url.setter
    def privacy_statement_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_url", value)

    @property
    @pulumi.getter(name="publicClient")
    def public_client(self) -> Optional[pulumi.Input['ApplicationPublicClientArgs']]:
        """
        A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        """
        return pulumi.get(self, "public_client")

    @public_client.setter
    def public_client(self, value: Optional[pulumi.Input['ApplicationPublicClientArgs']]):
        pulumi.set(self, "public_client", value)

    @property
    @pulumi.getter(name="requiredResourceAccesses")
    def required_resource_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]]:
        """
        A collection of `required_resource_access` blocks as documented below.
        """
        return pulumi.get(self, "required_resource_accesses")

    @required_resource_accesses.setter
    def required_resource_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]]):
        pulumi.set(self, "required_resource_accesses", value)

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @service_management_reference.setter
    def service_management_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_management_reference", value)

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.

        > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        """
        return pulumi.get(self, "sign_in_audience")

    @sign_in_audience.setter
    def sign_in_audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_in_audience", value)

    @property
    @pulumi.getter(name="singlePageApplication")
    def single_page_application(self) -> Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']]:
        """
        A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        """
        return pulumi.get(self, "single_page_application")

    @single_page_application.setter
    def single_page_application(self, value: Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']]):
        pulumi.set(self, "single_page_application", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's support page.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.

        > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's terms of service statement.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApplicationWebArgs']]:
        """
        A `web` block as documented below, which configures web related settings for this application.

        > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApplicationWebArgs']]):
        pulumi.set(self, "web", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 api: Optional[pulumi.Input['ApplicationApiArgs']] = None,
                 app_role_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_only_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 disabled_by_microsoft: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_public_client_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identifier_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logo_image: Optional[pulumi.Input[builtins.str]] = None,
                 logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 oauth2_permission_scope_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 oauth2_post_response_required: Optional[pulumi.Input[builtins.bool]] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 optional_claims: Optional[pulumi.Input['ApplicationOptionalClaimsArgs']] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input['ApplicationPasswordArgs']] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 public_client: Optional[pulumi.Input['ApplicationPublicClientArgs']] = None,
                 publisher_domain: Optional[pulumi.Input[builtins.str]] = None,
                 required_resource_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 single_page_application: Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 web: Optional[pulumi.Input['ApplicationWebArgs']] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input['ApplicationApiArgs'] api: An `api` block as documented below, which configures API related settings for this application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_role_ids: A mapping of app role values to app role IDs, intended to be useful when referencing app roles in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]] app_roles: A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] client_id: The Client ID for the application.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.bool] device_only_auth_enabled: Specifies whether this application supports device authentication without a user. Defaults to `false`.
        :param pulumi.Input[builtins.str] disabled_by_microsoft: Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[builtins.bool] fallback_public_client_enabled: Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identifier_uris: A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        :param pulumi.Input[builtins.str] logo_image: A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        :param pulumi.Input[builtins.str] logo_url: CDN URL to the application's logo, as uploaded with the `logo_image` property.
        :param pulumi.Input[builtins.str] marketing_url: URL of the application's marketing page.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] oauth2_permission_scope_ids: A mapping of OAuth2.0 permission scope values to scope IDs, intended to be useful when referencing permission scopes in other resources in your configuration.
        :param pulumi.Input[builtins.bool] oauth2_post_response_required: Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        :param pulumi.Input[builtins.str] object_id: The application's object ID.
        :param pulumi.Input['ApplicationOptionalClaimsArgs'] optional_claims: An `optional_claims` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the application
        :param pulumi.Input['ApplicationPasswordArgs'] password: A single `password` block as documented below. The password is generated during creation. By default, no password is generated.
               
               > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        :param pulumi.Input[builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the application's privacy statement.
        :param pulumi.Input['ApplicationPublicClientArgs'] public_client: A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        :param pulumi.Input[builtins.str] publisher_domain: The verified publisher domain for the application.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]] required_resource_accesses: A collection of `required_resource_access` blocks as documented below.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
               
               > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        :param pulumi.Input['ApplicationSinglePageApplicationArgs'] single_page_application: A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        :param pulumi.Input[builtins.str] support_url: URL of the application's support page.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        :param pulumi.Input[builtins.str] template_id: Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.
               
               > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the application's terms of service statement.
        :param pulumi.Input['ApplicationWebArgs'] web: A `web` block as documented below, which configures web related settings for this application.
               
               > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if app_role_ids is not None:
            pulumi.set(__self__, "app_role_ids", app_role_ids)
        if app_roles is not None:
            pulumi.set(__self__, "app_roles", app_roles)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_only_auth_enabled is not None:
            pulumi.set(__self__, "device_only_auth_enabled", device_only_auth_enabled)
        if disabled_by_microsoft is not None:
            pulumi.set(__self__, "disabled_by_microsoft", disabled_by_microsoft)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fallback_public_client_enabled is not None:
            pulumi.set(__self__, "fallback_public_client_enabled", fallback_public_client_enabled)
        if feature_tags is not None:
            pulumi.set(__self__, "feature_tags", feature_tags)
        if group_membership_claims is not None:
            pulumi.set(__self__, "group_membership_claims", group_membership_claims)
        if identifier_uris is not None:
            pulumi.set(__self__, "identifier_uris", identifier_uris)
        if logo_image is not None:
            pulumi.set(__self__, "logo_image", logo_image)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if marketing_url is not None:
            pulumi.set(__self__, "marketing_url", marketing_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if oauth2_permission_scope_ids is not None:
            pulumi.set(__self__, "oauth2_permission_scope_ids", oauth2_permission_scope_ids)
        if oauth2_post_response_required is not None:
            pulumi.set(__self__, "oauth2_post_response_required", oauth2_post_response_required)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if optional_claims is not None:
            pulumi.set(__self__, "optional_claims", optional_claims)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if prevent_duplicate_names is not None:
            pulumi.set(__self__, "prevent_duplicate_names", prevent_duplicate_names)
        if privacy_statement_url is not None:
            pulumi.set(__self__, "privacy_statement_url", privacy_statement_url)
        if public_client is not None:
            pulumi.set(__self__, "public_client", public_client)
        if publisher_domain is not None:
            pulumi.set(__self__, "publisher_domain", publisher_domain)
        if required_resource_accesses is not None:
            pulumi.set(__self__, "required_resource_accesses", required_resource_accesses)
        if service_management_reference is not None:
            pulumi.set(__self__, "service_management_reference", service_management_reference)
        if sign_in_audience is not None:
            pulumi.set(__self__, "sign_in_audience", sign_in_audience)
        if single_page_application is not None:
            pulumi.set(__self__, "single_page_application", single_page_application)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)
        if web is not None:
            pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['ApplicationApiArgs']]:
        """
        An `api` block as documented below, which configures API related settings for this application.
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['ApplicationApiArgs']]):
        pulumi.set(self, "api", value)

    @property
    @pulumi.getter(name="appRoleIds")
    def app_role_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of app role values to app role IDs, intended to be useful when referencing app roles in other resources in your configuration.
        """
        return pulumi.get(self, "app_role_ids")

    @app_role_ids.setter
    def app_role_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_role_ids", value)

    @property
    @pulumi.getter(name="appRoles")
    def app_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]]:
        """
        A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        """
        return pulumi.get(self, "app_roles")

    @app_roles.setter
    def app_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppRoleArgs']]]]):
        pulumi.set(self, "app_roles", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID for the application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceOnlyAuthEnabled")
    def device_only_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether this application supports device authentication without a user. Defaults to `false`.
        """
        return pulumi.get(self, "device_only_auth_enabled")

    @device_only_auth_enabled.setter
    def device_only_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "device_only_auth_enabled", value)

    @property
    @pulumi.getter(name="disabledByMicrosoft")
    def disabled_by_microsoft(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        """
        return pulumi.get(self, "disabled_by_microsoft")

    @disabled_by_microsoft.setter
    def disabled_by_microsoft(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disabled_by_microsoft", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fallbackPublicClientEnabled")
    def fallback_public_client_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        """
        return pulumi.get(self, "fallback_public_client_enabled")

    @fallback_public_client_enabled.setter
    def fallback_public_client_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_public_client_enabled", value)

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "feature_tags")

    @feature_tags.setter
    def feature_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationFeatureTagArgs']]]]):
        pulumi.set(self, "feature_tags", value)

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @group_membership_claims.setter
    def group_membership_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_membership_claims", value)

    @property
    @pulumi.getter(name="identifierUris")
    def identifier_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        """
        return pulumi.get(self, "identifier_uris")

    @identifier_uris.setter
    def identifier_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identifier_uris", value)

    @property
    @pulumi.getter(name="logoImage")
    def logo_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        """
        return pulumi.get(self, "logo_image")

    @logo_image.setter
    def logo_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_image", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CDN URL to the application's logo, as uploaded with the `logo_image` property.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's marketing page.
        """
        return pulumi.get(self, "marketing_url")

    @marketing_url.setter
    def marketing_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "marketing_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="oauth2PermissionScopeIds")
    def oauth2_permission_scope_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of OAuth2.0 permission scope values to scope IDs, intended to be useful when referencing permission scopes in other resources in your configuration.
        """
        return pulumi.get(self, "oauth2_permission_scope_ids")

    @oauth2_permission_scope_ids.setter
    def oauth2_permission_scope_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "oauth2_permission_scope_ids", value)

    @property
    @pulumi.getter(name="oauth2PostResponseRequired")
    def oauth2_post_response_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        """
        return pulumi.get(self, "oauth2_post_response_required")

    @oauth2_post_response_required.setter
    def oauth2_post_response_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "oauth2_post_response_required", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application's object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="optionalClaims")
    def optional_claims(self) -> Optional[pulumi.Input['ApplicationOptionalClaimsArgs']]:
        """
        An `optional_claims` block as documented below.
        """
        return pulumi.get(self, "optional_claims")

    @optional_claims.setter
    def optional_claims(self, value: Optional[pulumi.Input['ApplicationOptionalClaimsArgs']]):
        pulumi.set(self, "optional_claims", value)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of object IDs of principals that will be granted ownership of the application
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ApplicationPasswordArgs']]:
        """
        A single `password` block as documented below. The password is generated during creation. By default, no password is generated.

        > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ApplicationPasswordArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @prevent_duplicate_names.setter
    def prevent_duplicate_names(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prevent_duplicate_names", value)

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's privacy statement.
        """
        return pulumi.get(self, "privacy_statement_url")

    @privacy_statement_url.setter
    def privacy_statement_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_url", value)

    @property
    @pulumi.getter(name="publicClient")
    def public_client(self) -> Optional[pulumi.Input['ApplicationPublicClientArgs']]:
        """
        A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        """
        return pulumi.get(self, "public_client")

    @public_client.setter
    def public_client(self, value: Optional[pulumi.Input['ApplicationPublicClientArgs']]):
        pulumi.set(self, "public_client", value)

    @property
    @pulumi.getter(name="publisherDomain")
    def publisher_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The verified publisher domain for the application.
        """
        return pulumi.get(self, "publisher_domain")

    @publisher_domain.setter
    def publisher_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_domain", value)

    @property
    @pulumi.getter(name="requiredResourceAccesses")
    def required_resource_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]]:
        """
        A collection of `required_resource_access` blocks as documented below.
        """
        return pulumi.get(self, "required_resource_accesses")

    @required_resource_accesses.setter
    def required_resource_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationRequiredResourceAccessArgs']]]]):
        pulumi.set(self, "required_resource_accesses", value)

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @service_management_reference.setter
    def service_management_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_management_reference", value)

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.

        > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        """
        return pulumi.get(self, "sign_in_audience")

    @sign_in_audience.setter
    def sign_in_audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_in_audience", value)

    @property
    @pulumi.getter(name="singlePageApplication")
    def single_page_application(self) -> Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']]:
        """
        A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        """
        return pulumi.get(self, "single_page_application")

    @single_page_application.setter
    def single_page_application(self, value: Optional[pulumi.Input['ApplicationSinglePageApplicationArgs']]):
        pulumi.set(self, "single_page_application", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's support page.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.

        > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the application's terms of service statement.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApplicationWebArgs']]:
        """
        A `web` block as documented below, which configures web related settings for this application.

        > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApplicationWebArgs']]):
        pulumi.set(self, "web", value)


@pulumi.type_token("azuread:index/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[Union['ApplicationApiArgs', 'ApplicationApiArgsDict']]] = None,
                 app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppRoleArgs', 'ApplicationAppRoleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_only_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_public_client_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationFeatureTagArgs', 'ApplicationFeatureTagArgsDict']]]]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identifier_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logo_image: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 oauth2_post_response_required: Optional[pulumi.Input[builtins.bool]] = None,
                 optional_claims: Optional[pulumi.Input[Union['ApplicationOptionalClaimsArgs', 'ApplicationOptionalClaimsArgsDict']]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[Union['ApplicationPasswordArgs', 'ApplicationPasswordArgsDict']]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 public_client: Optional[pulumi.Input[Union['ApplicationPublicClientArgs', 'ApplicationPublicClientArgsDict']]] = None,
                 required_resource_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRequiredResourceAccessArgs', 'ApplicationRequiredResourceAccessArgsDict']]]]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 single_page_application: Optional[pulumi.Input[Union['ApplicationSinglePageApplicationArgs', 'ApplicationSinglePageApplicationArgsDict']]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 web: Optional[pulumi.Input[Union['ApplicationWebArgs', 'ApplicationWebArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        *Create an application*

        ```python
        import pulumi
        import pulumi_azuread as azuread
        import pulumi_std as std

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            identifier_uris=["api://example-app"],
            logo_image=std.filebase64(input="/path/to/logo.png").result,
            owners=[current.object_id],
            sign_in_audience="AzureADMultipleOrgs",
            api={
                "mapped_claims_enabled": True,
                "requested_access_token_version": 2,
                "known_client_applications": [
                    known1["clientId"],
                    known2["clientId"],
                ],
                "oauth2_permission_scopes": [
                    {
                        "admin_consent_description": "Allow the application to access example on behalf of the signed-in user.",
                        "admin_consent_display_name": "Access example",
                        "enabled": True,
                        "id": "96183846-204b-4b43-82e1-5d2222eb4b9b",
                        "type": "User",
                        "user_consent_description": "Allow the application to access example on your behalf.",
                        "user_consent_display_name": "Access example",
                        "value": "user_impersonation",
                    },
                    {
                        "admin_consent_description": "Administer the example application",
                        "admin_consent_display_name": "Administer",
                        "enabled": True,
                        "id": "be98fa3e-ab5b-4b11-83d9-04ba2b7946bc",
                        "type": "Admin",
                        "value": "administer",
                    },
                ],
            },
            app_roles=[
                {
                    "allowed_member_types": [
                        "User",
                        "Application",
                    ],
                    "description": "Admins can manage roles and perform all task actions",
                    "display_name": "Admin",
                    "enabled": True,
                    "id": "1b19509b-32b1-4e9f-b71d-4992aa991967",
                    "value": "admin",
                },
                {
                    "allowed_member_types": ["User"],
                    "description": "ReadOnly roles have limited query access",
                    "display_name": "ReadOnly",
                    "enabled": True,
                    "id": "497406e4-012a-4267-bf18-45a1cb148a01",
                    "value": "User",
                },
            ],
            feature_tags=[{
                "enterprise": True,
                "gallery": True,
            }],
            optional_claims={
                "access_tokens": [
                    {
                        "name": "myclaim",
                    },
                    {
                        "name": "otherclaim",
                    },
                ],
                "id_tokens": [{
                    "name": "userclaim",
                    "source": "user",
                    "essential": True,
                    "additional_properties": ["emit_as_roles"],
                }],
                "saml2_tokens": [{
                    "name": "samlexample",
                }],
            },
            required_resource_accesses=[
                {
                    "resource_app_id": "00000003-0000-0000-c000-000000000000",
                    "resource_accesses": [
                        {
                            "id": "df021288-bdef-4463-88db-98f22de89214",
                            "type": "Role",
                        },
                        {
                            "id": "b4e74841-8e56-480b-be8b-910348b18b4c",
                            "type": "Scope",
                        },
                    ],
                },
                {
                    "resource_app_id": "c5393580-f805-4401-95e8-94b7a6ef2fc2",
                    "resource_accesses": [{
                        "id": "594c1fb6-4f81-4475-ae41-0c394909246c",
                        "type": "Role",
                    }],
                },
            ],
            web={
                "homepage_url": "https://app.example.net",
                "logout_url": "https://app.example.net/logout",
                "redirect_uris": ["https://app.example.net/account"],
                "implicit_grant": {
                    "access_token_issuance_enabled": True,
                    "id_token_issuance_enabled": True,
                },
            })
        ```

        *Create application and generate a password*

        ## Import

        Applications can be imported using the object ID of the application, in the following format.

        ```sh
        $ pulumi import azuread:index/application:Application example /applications/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationApiArgs', 'ApplicationApiArgsDict']] api: An `api` block as documented below, which configures API related settings for this application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppRoleArgs', 'ApplicationAppRoleArgsDict']]]] app_roles: A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.bool] device_only_auth_enabled: Specifies whether this application supports device authentication without a user. Defaults to `false`.
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[builtins.bool] fallback_public_client_enabled: Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationFeatureTagArgs', 'ApplicationFeatureTagArgsDict']]]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identifier_uris: A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        :param pulumi.Input[builtins.str] logo_image: A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        :param pulumi.Input[builtins.str] marketing_url: URL of the application's marketing page.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.bool] oauth2_post_response_required: Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        :param pulumi.Input[Union['ApplicationOptionalClaimsArgs', 'ApplicationOptionalClaimsArgsDict']] optional_claims: An `optional_claims` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the application
        :param pulumi.Input[Union['ApplicationPasswordArgs', 'ApplicationPasswordArgsDict']] password: A single `password` block as documented below. The password is generated during creation. By default, no password is generated.
               
               > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        :param pulumi.Input[builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the application's privacy statement.
        :param pulumi.Input[Union['ApplicationPublicClientArgs', 'ApplicationPublicClientArgsDict']] public_client: A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRequiredResourceAccessArgs', 'ApplicationRequiredResourceAccessArgsDict']]]] required_resource_accesses: A collection of `required_resource_access` blocks as documented below.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
               
               > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        :param pulumi.Input[Union['ApplicationSinglePageApplicationArgs', 'ApplicationSinglePageApplicationArgsDict']] single_page_application: A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        :param pulumi.Input[builtins.str] support_url: URL of the application's support page.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        :param pulumi.Input[builtins.str] template_id: Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.
               
               > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the application's terms of service statement.
        :param pulumi.Input[Union['ApplicationWebArgs', 'ApplicationWebArgsDict']] web: A `web` block as documented below, which configures web related settings for this application.
               
               > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        *Create an application*

        ```python
        import pulumi
        import pulumi_azuread as azuread
        import pulumi_std as std

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            identifier_uris=["api://example-app"],
            logo_image=std.filebase64(input="/path/to/logo.png").result,
            owners=[current.object_id],
            sign_in_audience="AzureADMultipleOrgs",
            api={
                "mapped_claims_enabled": True,
                "requested_access_token_version": 2,
                "known_client_applications": [
                    known1["clientId"],
                    known2["clientId"],
                ],
                "oauth2_permission_scopes": [
                    {
                        "admin_consent_description": "Allow the application to access example on behalf of the signed-in user.",
                        "admin_consent_display_name": "Access example",
                        "enabled": True,
                        "id": "96183846-204b-4b43-82e1-5d2222eb4b9b",
                        "type": "User",
                        "user_consent_description": "Allow the application to access example on your behalf.",
                        "user_consent_display_name": "Access example",
                        "value": "user_impersonation",
                    },
                    {
                        "admin_consent_description": "Administer the example application",
                        "admin_consent_display_name": "Administer",
                        "enabled": True,
                        "id": "be98fa3e-ab5b-4b11-83d9-04ba2b7946bc",
                        "type": "Admin",
                        "value": "administer",
                    },
                ],
            },
            app_roles=[
                {
                    "allowed_member_types": [
                        "User",
                        "Application",
                    ],
                    "description": "Admins can manage roles and perform all task actions",
                    "display_name": "Admin",
                    "enabled": True,
                    "id": "1b19509b-32b1-4e9f-b71d-4992aa991967",
                    "value": "admin",
                },
                {
                    "allowed_member_types": ["User"],
                    "description": "ReadOnly roles have limited query access",
                    "display_name": "ReadOnly",
                    "enabled": True,
                    "id": "497406e4-012a-4267-bf18-45a1cb148a01",
                    "value": "User",
                },
            ],
            feature_tags=[{
                "enterprise": True,
                "gallery": True,
            }],
            optional_claims={
                "access_tokens": [
                    {
                        "name": "myclaim",
                    },
                    {
                        "name": "otherclaim",
                    },
                ],
                "id_tokens": [{
                    "name": "userclaim",
                    "source": "user",
                    "essential": True,
                    "additional_properties": ["emit_as_roles"],
                }],
                "saml2_tokens": [{
                    "name": "samlexample",
                }],
            },
            required_resource_accesses=[
                {
                    "resource_app_id": "00000003-0000-0000-c000-000000000000",
                    "resource_accesses": [
                        {
                            "id": "df021288-bdef-4463-88db-98f22de89214",
                            "type": "Role",
                        },
                        {
                            "id": "b4e74841-8e56-480b-be8b-910348b18b4c",
                            "type": "Scope",
                        },
                    ],
                },
                {
                    "resource_app_id": "c5393580-f805-4401-95e8-94b7a6ef2fc2",
                    "resource_accesses": [{
                        "id": "594c1fb6-4f81-4475-ae41-0c394909246c",
                        "type": "Role",
                    }],
                },
            ],
            web={
                "homepage_url": "https://app.example.net",
                "logout_url": "https://app.example.net/logout",
                "redirect_uris": ["https://app.example.net/account"],
                "implicit_grant": {
                    "access_token_issuance_enabled": True,
                    "id_token_issuance_enabled": True,
                },
            })
        ```

        *Create application and generate a password*

        ## Import

        Applications can be imported using the object ID of the application, in the following format.

        ```sh
        $ pulumi import azuread:index/application:Application example /applications/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[Union['ApplicationApiArgs', 'ApplicationApiArgsDict']]] = None,
                 app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppRoleArgs', 'ApplicationAppRoleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_only_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_public_client_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationFeatureTagArgs', 'ApplicationFeatureTagArgsDict']]]]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identifier_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logo_image: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 oauth2_post_response_required: Optional[pulumi.Input[builtins.bool]] = None,
                 optional_claims: Optional[pulumi.Input[Union['ApplicationOptionalClaimsArgs', 'ApplicationOptionalClaimsArgsDict']]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[Union['ApplicationPasswordArgs', 'ApplicationPasswordArgsDict']]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 public_client: Optional[pulumi.Input[Union['ApplicationPublicClientArgs', 'ApplicationPublicClientArgsDict']]] = None,
                 required_resource_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRequiredResourceAccessArgs', 'ApplicationRequiredResourceAccessArgsDict']]]]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 single_page_application: Optional[pulumi.Input[Union['ApplicationSinglePageApplicationArgs', 'ApplicationSinglePageApplicationArgsDict']]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 web: Optional[pulumi.Input[Union['ApplicationWebArgs', 'ApplicationWebArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["api"] = api
            __props__.__dict__["app_roles"] = app_roles
            __props__.__dict__["description"] = description
            __props__.__dict__["device_only_auth_enabled"] = device_only_auth_enabled
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fallback_public_client_enabled"] = fallback_public_client_enabled
            __props__.__dict__["feature_tags"] = feature_tags
            __props__.__dict__["group_membership_claims"] = group_membership_claims
            __props__.__dict__["identifier_uris"] = identifier_uris
            __props__.__dict__["logo_image"] = logo_image
            __props__.__dict__["marketing_url"] = marketing_url
            __props__.__dict__["notes"] = notes
            __props__.__dict__["oauth2_post_response_required"] = oauth2_post_response_required
            __props__.__dict__["optional_claims"] = optional_claims
            __props__.__dict__["owners"] = owners
            __props__.__dict__["password"] = password
            __props__.__dict__["prevent_duplicate_names"] = prevent_duplicate_names
            __props__.__dict__["privacy_statement_url"] = privacy_statement_url
            __props__.__dict__["public_client"] = public_client
            __props__.__dict__["required_resource_accesses"] = required_resource_accesses
            __props__.__dict__["service_management_reference"] = service_management_reference
            __props__.__dict__["sign_in_audience"] = sign_in_audience
            __props__.__dict__["single_page_application"] = single_page_application
            __props__.__dict__["support_url"] = support_url
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["terms_of_service_url"] = terms_of_service_url
            __props__.__dict__["web"] = web
            __props__.__dict__["app_role_ids"] = None
            __props__.__dict__["client_id"] = None
            __props__.__dict__["disabled_by_microsoft"] = None
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["oauth2_permission_scope_ids"] = None
            __props__.__dict__["object_id"] = None
            __props__.__dict__["publisher_domain"] = None
        super(Application, __self__).__init__(
            'azuread:index/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api: Optional[pulumi.Input[Union['ApplicationApiArgs', 'ApplicationApiArgsDict']]] = None,
            app_role_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppRoleArgs', 'ApplicationAppRoleArgsDict']]]]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_only_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            disabled_by_microsoft: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            fallback_public_client_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationFeatureTagArgs', 'ApplicationFeatureTagArgsDict']]]]] = None,
            group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            identifier_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            logo_image: Optional[pulumi.Input[builtins.str]] = None,
            logo_url: Optional[pulumi.Input[builtins.str]] = None,
            marketing_url: Optional[pulumi.Input[builtins.str]] = None,
            notes: Optional[pulumi.Input[builtins.str]] = None,
            oauth2_permission_scope_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            oauth2_post_response_required: Optional[pulumi.Input[builtins.bool]] = None,
            object_id: Optional[pulumi.Input[builtins.str]] = None,
            optional_claims: Optional[pulumi.Input[Union['ApplicationOptionalClaimsArgs', 'ApplicationOptionalClaimsArgsDict']]] = None,
            owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            password: Optional[pulumi.Input[Union['ApplicationPasswordArgs', 'ApplicationPasswordArgsDict']]] = None,
            prevent_duplicate_names: Optional[pulumi.Input[builtins.bool]] = None,
            privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
            public_client: Optional[pulumi.Input[Union['ApplicationPublicClientArgs', 'ApplicationPublicClientArgsDict']]] = None,
            publisher_domain: Optional[pulumi.Input[builtins.str]] = None,
            required_resource_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRequiredResourceAccessArgs', 'ApplicationRequiredResourceAccessArgsDict']]]]] = None,
            service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
            sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
            single_page_application: Optional[pulumi.Input[Union['ApplicationSinglePageApplicationArgs', 'ApplicationSinglePageApplicationArgsDict']]] = None,
            support_url: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None,
            terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
            web: Optional[pulumi.Input[Union['ApplicationWebArgs', 'ApplicationWebArgsDict']]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationApiArgs', 'ApplicationApiArgsDict']] api: An `api` block as documented below, which configures API related settings for this application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_role_ids: A mapping of app role values to app role IDs, intended to be useful when referencing app roles in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppRoleArgs', 'ApplicationAppRoleArgsDict']]]] app_roles: A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] client_id: The Client ID for the application.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.bool] device_only_auth_enabled: Specifies whether this application supports device authentication without a user. Defaults to `false`.
        :param pulumi.Input[builtins.str] disabled_by_microsoft: Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[builtins.bool] fallback_public_client_enabled: Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationFeatureTagArgs', 'ApplicationFeatureTagArgsDict']]]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identifier_uris: A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        :param pulumi.Input[builtins.str] logo_image: A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        :param pulumi.Input[builtins.str] logo_url: CDN URL to the application's logo, as uploaded with the `logo_image` property.
        :param pulumi.Input[builtins.str] marketing_url: URL of the application's marketing page.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] oauth2_permission_scope_ids: A mapping of OAuth2.0 permission scope values to scope IDs, intended to be useful when referencing permission scopes in other resources in your configuration.
        :param pulumi.Input[builtins.bool] oauth2_post_response_required: Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        :param pulumi.Input[builtins.str] object_id: The application's object ID.
        :param pulumi.Input[Union['ApplicationOptionalClaimsArgs', 'ApplicationOptionalClaimsArgsDict']] optional_claims: An `optional_claims` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the application
        :param pulumi.Input[Union['ApplicationPasswordArgs', 'ApplicationPasswordArgsDict']] password: A single `password` block as documented below. The password is generated during creation. By default, no password is generated.
               
               > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        :param pulumi.Input[builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the application's privacy statement.
        :param pulumi.Input[Union['ApplicationPublicClientArgs', 'ApplicationPublicClientArgsDict']] public_client: A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        :param pulumi.Input[builtins.str] publisher_domain: The verified publisher domain for the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRequiredResourceAccessArgs', 'ApplicationRequiredResourceAccessArgsDict']]]] required_resource_accesses: A collection of `required_resource_access` blocks as documented below.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
               
               > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        :param pulumi.Input[Union['ApplicationSinglePageApplicationArgs', 'ApplicationSinglePageApplicationArgsDict']] single_page_application: A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        :param pulumi.Input[builtins.str] support_url: URL of the application's support page.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        :param pulumi.Input[builtins.str] template_id: Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.
               
               > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the application's terms of service statement.
        :param pulumi.Input[Union['ApplicationWebArgs', 'ApplicationWebArgsDict']] web: A `web` block as documented below, which configures web related settings for this application.
               
               > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["api"] = api
        __props__.__dict__["app_role_ids"] = app_role_ids
        __props__.__dict__["app_roles"] = app_roles
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["description"] = description
        __props__.__dict__["device_only_auth_enabled"] = device_only_auth_enabled
        __props__.__dict__["disabled_by_microsoft"] = disabled_by_microsoft
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fallback_public_client_enabled"] = fallback_public_client_enabled
        __props__.__dict__["feature_tags"] = feature_tags
        __props__.__dict__["group_membership_claims"] = group_membership_claims
        __props__.__dict__["identifier_uris"] = identifier_uris
        __props__.__dict__["logo_image"] = logo_image
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["marketing_url"] = marketing_url
        __props__.__dict__["notes"] = notes
        __props__.__dict__["oauth2_permission_scope_ids"] = oauth2_permission_scope_ids
        __props__.__dict__["oauth2_post_response_required"] = oauth2_post_response_required
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["optional_claims"] = optional_claims
        __props__.__dict__["owners"] = owners
        __props__.__dict__["password"] = password
        __props__.__dict__["prevent_duplicate_names"] = prevent_duplicate_names
        __props__.__dict__["privacy_statement_url"] = privacy_statement_url
        __props__.__dict__["public_client"] = public_client
        __props__.__dict__["publisher_domain"] = publisher_domain
        __props__.__dict__["required_resource_accesses"] = required_resource_accesses
        __props__.__dict__["service_management_reference"] = service_management_reference
        __props__.__dict__["sign_in_audience"] = sign_in_audience
        __props__.__dict__["single_page_application"] = single_page_application
        __props__.__dict__["support_url"] = support_url
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["terms_of_service_url"] = terms_of_service_url
        __props__.__dict__["web"] = web
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def api(self) -> pulumi.Output[Optional['outputs.ApplicationApi']]:
        """
        An `api` block as documented below, which configures API related settings for this application.
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="appRoleIds")
    def app_role_ids(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A mapping of app role values to app role IDs, intended to be useful when referencing app roles in other resources in your configuration.
        """
        return pulumi.get(self, "app_role_ids")

    @property
    @pulumi.getter(name="appRoles")
    def app_roles(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationAppRole']]]:
        """
        A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        """
        return pulumi.get(self, "app_roles")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        The Client ID for the application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceOnlyAuthEnabled")
    def device_only_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether this application supports device authentication without a user. Defaults to `false`.
        """
        return pulumi.get(self, "device_only_auth_enabled")

    @property
    @pulumi.getter(name="disabledByMicrosoft")
    def disabled_by_microsoft(self) -> pulumi.Output[builtins.str]:
        """
        Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        """
        return pulumi.get(self, "disabled_by_microsoft")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fallbackPublicClientEnabled")
    def fallback_public_client_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI. Defaults to `false`.
        """
        return pulumi.get(self, "fallback_public_client_enabled")

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> pulumi.Output[Sequence['outputs.ApplicationFeatureTag']]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for an application using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for an application at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "feature_tags")

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of strings containing membership claims issued in a user or OAuth 2.0 access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @property
    @pulumi.getter(name="identifierUris")
    def identifier_uris(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
        """
        return pulumi.get(self, "identifier_uris")

    @property
    @pulumi.getter(name="logoImage")
    def logo_image(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A logo image to upload for the application, as a raw base64-encoded string. The image should be in gif, jpeg or png format. Note that once an image has been uploaded, it is not possible to remove it without replacing it with another image.
        """
        return pulumi.get(self, "logo_image")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[builtins.str]:
        """
        CDN URL to the application's logo, as uploaded with the `logo_image` property.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the application's marketing page.
        """
        return pulumi.get(self, "marketing_url")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="oauth2PermissionScopeIds")
    def oauth2_permission_scope_ids(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A mapping of OAuth2.0 permission scope values to scope IDs, intended to be useful when referencing permission scopes in other resources in your configuration.
        """
        return pulumi.get(self, "oauth2_permission_scope_ids")

    @property
    @pulumi.getter(name="oauth2PostResponseRequired")
    def oauth2_post_response_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests. Defaults to `false`, which specifies that only GET requests are allowed.
        """
        return pulumi.get(self, "oauth2_post_response_required")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[builtins.str]:
        """
        The application's object ID.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="optionalClaims")
    def optional_claims(self) -> pulumi.Output[Optional['outputs.ApplicationOptionalClaims']]:
        """
        An `optional_claims` block as documented below.
        """
        return pulumi.get(self, "optional_claims")

    @property
    @pulumi.getter
    def owners(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of object IDs of principals that will be granted ownership of the application
        """
        return pulumi.get(self, "owners")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional['outputs.ApplicationPassword']]:
        """
        A single `password` block as documented below. The password is generated during creation. By default, no password is generated.

        > **Creating a Password** The `password` block supports a single password for the application, and is provided so that a password can be generated when a new application is created. This helps to make new applications available for authentication more quickly. To add additional passwords to an application, see the ApplicationPassword resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If `true`, will return an error if an existing application is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the application's privacy statement.
        """
        return pulumi.get(self, "privacy_statement_url")

    @property
    @pulumi.getter(name="publicClient")
    def public_client(self) -> pulumi.Output[Optional['outputs.ApplicationPublicClient']]:
        """
        A `public_client` block as documented below, which configures non-web app or non-web API application settings, for example mobile or other public clients such as an installed application running on a desktop device.
        """
        return pulumi.get(self, "public_client")

    @property
    @pulumi.getter(name="publisherDomain")
    def publisher_domain(self) -> pulumi.Output[builtins.str]:
        """
        The verified publisher domain for the application.
        """
        return pulumi.get(self, "publisher_domain")

    @property
    @pulumi.getter(name="requiredResourceAccesses")
    def required_resource_accesses(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationRequiredResourceAccess']]]:
        """
        A collection of `required_resource_access` blocks as documented below.
        """
        return pulumi.get(self, "required_resource_accesses")

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.

        > **Changing `sign_in_audience` for existing applications** When updating an existing application to use a `sign_in_audience` value of `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`, your configuration may no longer be valid. Refer to [official documentation](https://docs.microsoft.com/en-gb/azure/active-directory/develop/supported-accounts-validation) to understand the differences in supported configurations. Where possible, the provider will attempt to validate your configuration and try to avoid applying unsupported settings to your application.
        """
        return pulumi.get(self, "sign_in_audience")

    @property
    @pulumi.getter(name="singlePageApplication")
    def single_page_application(self) -> pulumi.Output[Optional['outputs.ApplicationSinglePageApplication']]:
        """
        A `single_page_application` block as documented below, which configures single-page application (SPA) related settings for this application.
        """
        return pulumi.get(self, "single_page_application")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the application's support page.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A set of tags to apply to the application for configuring specific behaviours of the application and linked service principals. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of applications. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values also propagate to any linked service principals.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique ID for a templated application in the Azure AD App Gallery, from which to create the application. Changing this forces a new resource to be created.

        > **Tip for Gallery Applications** This resource can  be used to instantiate a gallery application, however it will also attempt to manage the properties of the resulting application. If this is not desired, consider using the ApplicationRegistration resource instead.
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the application's terms of service statement.
        """
        return pulumi.get(self, "terms_of_service_url")

    @property
    @pulumi.getter
    def web(self) -> pulumi.Output[Optional['outputs.ApplicationWeb']]:
        """
        A `web` block as documented below, which configures web related settings for this application.

        > **Application Name Uniqueness** Application names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing applications if you want to avoid name collisions.
        """
        return pulumi.get(self, "web")

