# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApplicationPreAuthorizedArgs', 'ApplicationPreAuthorized']

@pulumi.input_type
class ApplicationPreAuthorizedArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 authorized_client_id: pulumi.Input[builtins.str],
                 permission_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        The set of arguments for constructing a ApplicationPreAuthorized resource.
        :param pulumi.Input[builtins.str] application_id: The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[builtins.str] authorized_client_id: The client ID of the application being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_ids: A set of permission scope IDs required by the authorized application.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "authorized_client_id", authorized_client_id)
        pulumi.set(__self__, "permission_ids", permission_ids)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authorizedClientId")
    def authorized_client_id(self) -> pulumi.Input[builtins.str]:
        """
        The client ID of the application being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "authorized_client_id")

    @authorized_client_id.setter
    def authorized_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorized_client_id", value)

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A set of permission scope IDs required by the authorized application.
        """
        return pulumi.get(self, "permission_ids")

    @permission_ids.setter
    def permission_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "permission_ids", value)


@pulumi.input_type
class _ApplicationPreAuthorizedState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 authorized_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApplicationPreAuthorized resources.
        :param pulumi.Input[builtins.str] application_id: The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[builtins.str] authorized_client_id: The client ID of the application being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_ids: A set of permission scope IDs required by the authorized application.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if authorized_client_id is not None:
            pulumi.set(__self__, "authorized_client_id", authorized_client_id)
        if permission_ids is not None:
            pulumi.set(__self__, "permission_ids", permission_ids)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authorizedClientId")
    def authorized_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client ID of the application being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "authorized_client_id")

    @authorized_client_id.setter
    def authorized_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorized_client_id", value)

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of permission scope IDs required by the authorized application.
        """
        return pulumi.get(self, "permission_ids")

    @permission_ids.setter
    def permission_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permission_ids", value)


@pulumi.type_token("azuread:index/applicationPreAuthorized:ApplicationPreAuthorized")
class ApplicationPreAuthorized(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 authorized_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        authorized = azuread.ApplicationRegistration("authorized", display_name="example-authorized-app")
        authorizer = azuread.Application("authorizer",
            display_name="example-authorizing-app",
            api={
                "oauth2_permission_scopes": [
                    {
                        "admin_consent_description": "Administer the application",
                        "admin_consent_display_name": "Administer",
                        "enabled": True,
                        "id": "00000000-0000-0000-0000-000000000000",
                        "type": "Admin",
                        "value": "administer",
                    },
                    {
                        "admin_consent_description": "Access the application",
                        "admin_consent_display_name": "Access",
                        "enabled": True,
                        "id": "11111111-1111-1111-1111-111111111111",
                        "type": "User",
                        "user_consent_description": "Access the application",
                        "user_consent_display_name": "Access",
                        "value": "user_impersonation",
                    },
                ],
            })
        example = azuread.ApplicationPreAuthorized("example",
            application_id=authorizer.id,
            authorized_client_id=authorized.client_id,
            permission_ids=[
                "00000000-0000-0000-0000-000000000000",
                "11111111-1111-1111-1111-111111111111",
            ])
        ```

        ## Import

        Pre-authorized applications can be imported using the object ID of the authorizing application and the application ID of the application being authorized, e.g.

        ```sh
        $ pulumi import azuread:index/applicationPreAuthorized:ApplicationPreAuthorized example 00000000-0000-0000-0000-000000000000/preAuthorizedApplication/11111111-1111-1111-1111-111111111111
        ```

        -> This ID format is unique to Terraform and is composed of the authorizing application's object ID, the string "preAuthorizedApplication" and the authorized application's application ID (client ID) in the format `{ObjectId}/preAuthorizedApplication/{ApplicationId}`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[builtins.str] authorized_client_id: The client ID of the application being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_ids: A set of permission scope IDs required by the authorized application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationPreAuthorizedArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        authorized = azuread.ApplicationRegistration("authorized", display_name="example-authorized-app")
        authorizer = azuread.Application("authorizer",
            display_name="example-authorizing-app",
            api={
                "oauth2_permission_scopes": [
                    {
                        "admin_consent_description": "Administer the application",
                        "admin_consent_display_name": "Administer",
                        "enabled": True,
                        "id": "00000000-0000-0000-0000-000000000000",
                        "type": "Admin",
                        "value": "administer",
                    },
                    {
                        "admin_consent_description": "Access the application",
                        "admin_consent_display_name": "Access",
                        "enabled": True,
                        "id": "11111111-1111-1111-1111-111111111111",
                        "type": "User",
                        "user_consent_description": "Access the application",
                        "user_consent_display_name": "Access",
                        "value": "user_impersonation",
                    },
                ],
            })
        example = azuread.ApplicationPreAuthorized("example",
            application_id=authorizer.id,
            authorized_client_id=authorized.client_id,
            permission_ids=[
                "00000000-0000-0000-0000-000000000000",
                "11111111-1111-1111-1111-111111111111",
            ])
        ```

        ## Import

        Pre-authorized applications can be imported using the object ID of the authorizing application and the application ID of the application being authorized, e.g.

        ```sh
        $ pulumi import azuread:index/applicationPreAuthorized:ApplicationPreAuthorized example 00000000-0000-0000-0000-000000000000/preAuthorizedApplication/11111111-1111-1111-1111-111111111111
        ```

        -> This ID format is unique to Terraform and is composed of the authorizing application's object ID, the string "preAuthorizedApplication" and the authorized application's application ID (client ID) in the format `{ObjectId}/preAuthorizedApplication/{ApplicationId}`.

        :param str resource_name: The name of the resource.
        :param ApplicationPreAuthorizedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationPreAuthorizedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 authorized_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationPreAuthorizedArgs.__new__(ApplicationPreAuthorizedArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if authorized_client_id is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_client_id'")
            __props__.__dict__["authorized_client_id"] = authorized_client_id
            if permission_ids is None and not opts.urn:
                raise TypeError("Missing required property 'permission_ids'")
            __props__.__dict__["permission_ids"] = permission_ids
        super(ApplicationPreAuthorized, __self__).__init__(
            'azuread:index/applicationPreAuthorized:ApplicationPreAuthorized',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            authorized_client_id: Optional[pulumi.Input[builtins.str]] = None,
            permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ApplicationPreAuthorized':
        """
        Get an existing ApplicationPreAuthorized resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[builtins.str] authorized_client_id: The client ID of the application being authorized. Changing this field forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_ids: A set of permission scope IDs required by the authorized application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationPreAuthorizedState.__new__(_ApplicationPreAuthorizedState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["authorized_client_id"] = authorized_client_id
        __props__.__dict__["permission_ids"] = permission_ids
        return ApplicationPreAuthorized(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID of the application for which permissions are being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="authorizedClientId")
    def authorized_client_id(self) -> pulumi.Output[builtins.str]:
        """
        The client ID of the application being authorized. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "authorized_client_id")

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A set of permission scope IDs required by the authorized application.
        """
        return pulumi.get(self, "permission_ids")

