# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClaimsMappingPolicyArgs', 'ClaimsMappingPolicy']

@pulumi.input_type
class ClaimsMappingPolicyArgs:
    def __init__(__self__, *,
                 definitions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 display_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ClaimsMappingPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] definitions: The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        :param pulumi.Input[builtins.str] display_name: The display name for this Claims Mapping Policy.
        """
        pulumi.set(__self__, "definitions", definitions)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for this Claims Mapping Policy.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _ClaimsMappingPolicyState:
    def __init__(__self__, *,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClaimsMappingPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] definitions: The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        :param pulumi.Input[builtins.str] display_name: The display name for this Claims Mapping Policy.
        """
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for this Claims Mapping Policy.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.type_token("azuread:index/claimsMappingPolicy:ClaimsMappingPolicy")
class ClaimsMappingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Claims Mapping Policy within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires the following application roles: `Policy.ReadWrite.ApplicationConfiguration` and `Policy.Read.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Application Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azuread as azuread

        my_policy = azuread.ClaimsMappingPolicy("my_policy",
            definitions=[json.dumps({
                "claimsMappingPolicy": {
                    "claimsSchema": [
                        {
                            "ID": "employeeid",
                            "jwtClaimType": "name",
                            "samlClaimType": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
                            "source": "user",
                        },
                        {
                            "ID": "tenantcountry",
                            "jwtClaimType": "country",
                            "samlClaimType": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country",
                            "source": "company",
                        },
                    ],
                    "includeBasicClaimSet": "true",
                    "version": 1,
                },
            })],
            display_name="My Policy")
        ```

        ## Import

        Claims Mapping Policy can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/claimsMappingPolicy:ClaimsMappingPolicy my_policy 00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] definitions: The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        :param pulumi.Input[builtins.str] display_name: The display name for this Claims Mapping Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClaimsMappingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Claims Mapping Policy within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires the following application roles: `Policy.ReadWrite.ApplicationConfiguration` and `Policy.Read.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Application Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azuread as azuread

        my_policy = azuread.ClaimsMappingPolicy("my_policy",
            definitions=[json.dumps({
                "claimsMappingPolicy": {
                    "claimsSchema": [
                        {
                            "ID": "employeeid",
                            "jwtClaimType": "name",
                            "samlClaimType": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
                            "source": "user",
                        },
                        {
                            "ID": "tenantcountry",
                            "jwtClaimType": "country",
                            "samlClaimType": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country",
                            "source": "company",
                        },
                    ],
                    "includeBasicClaimSet": "true",
                    "version": 1,
                },
            })],
            display_name="My Policy")
        ```

        ## Import

        Claims Mapping Policy can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/claimsMappingPolicy:ClaimsMappingPolicy my_policy 00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ClaimsMappingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClaimsMappingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClaimsMappingPolicyArgs.__new__(ClaimsMappingPolicyArgs)

            if definitions is None and not opts.urn:
                raise TypeError("Missing required property 'definitions'")
            __props__.__dict__["definitions"] = definitions
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
        super(ClaimsMappingPolicy, __self__).__init__(
            'azuread:index/claimsMappingPolicy:ClaimsMappingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            definitions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ClaimsMappingPolicy':
        """
        Get an existing ClaimsMappingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] definitions: The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        :param pulumi.Input[builtins.str] display_name: The display name for this Claims Mapping Policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClaimsMappingPolicyState.__new__(_ClaimsMappingPolicyState)

        __props__.__dict__["definitions"] = definitions
        __props__.__dict__["display_name"] = display_name
        return ClaimsMappingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The claims mapping policy. This is a JSON formatted string, for which the `jsonencode()` function can be used.
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for this Claims Mapping Policy.
        """
        return pulumi.get(self, "display_name")

