# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamedLocationArgs', 'NamedLocation']

@pulumi.input_type
class NamedLocationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 country: Optional[pulumi.Input['NamedLocationCountryArgs']] = None,
                 ip: Optional[pulumi.Input['NamedLocationIpArgs']] = None):
        """
        The set of arguments for constructing a NamedLocation resource.
        :param pulumi.Input[builtins.str] display_name: The friendly name for this named location.
        :param pulumi.Input['NamedLocationCountryArgs'] country: A `country` block as documented below, which configures a country-based named location.
        :param pulumi.Input['NamedLocationIpArgs'] ip: An `ip` block as documented below, which configures an IP-based named location.
               
               > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        pulumi.set(__self__, "display_name", display_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name for this named location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input['NamedLocationCountryArgs']]:
        """
        A `country` block as documented below, which configures a country-based named location.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input['NamedLocationCountryArgs']]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['NamedLocationIpArgs']]:
        """
        An `ip` block as documented below, which configures an IP-based named location.

        > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['NamedLocationIpArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class _NamedLocationState:
    def __init__(__self__, *,
                 country: Optional[pulumi.Input['NamedLocationCountryArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input['NamedLocationIpArgs']] = None):
        """
        Input properties used for looking up and filtering NamedLocation resources.
        :param pulumi.Input['NamedLocationCountryArgs'] country: A `country` block as documented below, which configures a country-based named location.
        :param pulumi.Input[builtins.str] display_name: The friendly name for this named location.
        :param pulumi.Input['NamedLocationIpArgs'] ip: An `ip` block as documented below, which configures an IP-based named location.
               
               > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        if country is not None:
            pulumi.set(__self__, "country", country)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input['NamedLocationCountryArgs']]:
        """
        A `country` block as documented below, which configures a country-based named location.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input['NamedLocationCountryArgs']]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name for this named location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['NamedLocationIpArgs']]:
        """
        An `ip` block as documented below, which configures an IP-based named location.

        > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['NamedLocationIpArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.type_token("azuread:index/namedLocation:NamedLocation")
class NamedLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[Union['NamedLocationCountryArgs', 'NamedLocationCountryArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[Union['NamedLocationIpArgs', 'NamedLocationIpArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example_ip = azuread.NamedLocation("example-ip",
            display_name="IP Named Location",
            ip={
                "ip_ranges": [
                    "1.1.1.1/32",
                    "2.2.2.2/32",
                ],
                "trusted": True,
            })
        example_country = azuread.NamedLocation("example-country",
            display_name="Country Named Location",
            country={
                "countries_and_regions": [
                    "GB",
                    "US",
                ],
                "include_unknown_countries_and_regions": False,
            })
        ```

        ## Import

        Named Locations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/namedLocation:NamedLocation my_location /identity/conditionalAccess/namedLocations/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamedLocationCountryArgs', 'NamedLocationCountryArgsDict']] country: A `country` block as documented below, which configures a country-based named location.
        :param pulumi.Input[builtins.str] display_name: The friendly name for this named location.
        :param pulumi.Input[Union['NamedLocationIpArgs', 'NamedLocationIpArgsDict']] ip: An `ip` block as documented below, which configures an IP-based named location.
               
               > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamedLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example_ip = azuread.NamedLocation("example-ip",
            display_name="IP Named Location",
            ip={
                "ip_ranges": [
                    "1.1.1.1/32",
                    "2.2.2.2/32",
                ],
                "trusted": True,
            })
        example_country = azuread.NamedLocation("example-country",
            display_name="Country Named Location",
            country={
                "countries_and_regions": [
                    "GB",
                    "US",
                ],
                "include_unknown_countries_and_regions": False,
            })
        ```

        ## Import

        Named Locations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/namedLocation:NamedLocation my_location /identity/conditionalAccess/namedLocations/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param NamedLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamedLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[Union['NamedLocationCountryArgs', 'NamedLocationCountryArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[Union['NamedLocationIpArgs', 'NamedLocationIpArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamedLocationArgs.__new__(NamedLocationArgs)

            __props__.__dict__["country"] = country
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ip"] = ip
        super(NamedLocation, __self__).__init__(
            'azuread:index/namedLocation:NamedLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            country: Optional[pulumi.Input[Union['NamedLocationCountryArgs', 'NamedLocationCountryArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            ip: Optional[pulumi.Input[Union['NamedLocationIpArgs', 'NamedLocationIpArgsDict']]] = None) -> 'NamedLocation':
        """
        Get an existing NamedLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamedLocationCountryArgs', 'NamedLocationCountryArgsDict']] country: A `country` block as documented below, which configures a country-based named location.
        :param pulumi.Input[builtins.str] display_name: The friendly name for this named location.
        :param pulumi.Input[Union['NamedLocationIpArgs', 'NamedLocationIpArgsDict']] ip: An `ip` block as documented below, which configures an IP-based named location.
               
               > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamedLocationState.__new__(_NamedLocationState)

        __props__.__dict__["country"] = country
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ip"] = ip
        return NamedLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional['outputs.NamedLocationCountry']]:
        """
        A `country` block as documented below, which configures a country-based named location.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The friendly name for this named location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[Optional['outputs.NamedLocationIp']]:
        """
        An `ip` block as documented below, which configures an IP-based named location.

        > Exactly one of `ip` or `country` must be specified. Changing between these forces a new resource to be created.
        """
        return pulumi.get(self, "ip")

