# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePrincipalArgs', 'ServicePrincipal']

@pulumi.input_type
class ServicePrincipalArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[builtins.str],
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_role_assignment_required: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 notification_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_single_sign_on_mode: Optional[pulumi.Input[builtins.str]] = None,
                 saml_single_sign_on: Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_existing: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ServicePrincipal resource.
        :param pulumi.Input[builtins.str] client_id: The client ID of the application for which to create a service principal.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the service principal account is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_names: A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        :param pulumi.Input[builtins.bool] app_role_assignment_required: Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: A description of the service principal provided for internal end-users.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]] features: Block of features to configure for this service principal using tags
        :param pulumi.Input[builtins.str] login_url: The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        :param pulumi.Input[builtins.str] notes: A free text field to capture information about the service principal, typically used for operational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_email_addresses: A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the service principal
        :param pulumi.Input[builtins.str] preferred_single_sign_on_mode: The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        :param pulumi.Input['ServicePrincipalSamlSingleSignOnArgs'] saml_single_sign_on: A `saml_single_sign_on` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        :param pulumi.Input[builtins.bool] use_existing: When true, the resource will return an existing service principal instead of failing with an error
        """
        pulumi.set(__self__, "client_id", client_id)
        if account_enabled is not None:
            pulumi.set(__self__, "account_enabled", account_enabled)
        if alternative_names is not None:
            pulumi.set(__self__, "alternative_names", alternative_names)
        if app_role_assignment_required is not None:
            pulumi.set(__self__, "app_role_assignment_required", app_role_assignment_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_tags is not None:
            pulumi.set(__self__, "feature_tags", feature_tags)
        if features is not None:
            warnings.warn("""This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""", DeprecationWarning)
            pulumi.log.warn("""features is deprecated: This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""")
        if features is not None:
            pulumi.set(__self__, "features", features)
        if login_url is not None:
            pulumi.set(__self__, "login_url", login_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if notification_email_addresses is not None:
            pulumi.set(__self__, "notification_email_addresses", notification_email_addresses)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if preferred_single_sign_on_mode is not None:
            pulumi.set(__self__, "preferred_single_sign_on_mode", preferred_single_sign_on_mode)
        if saml_single_sign_on is not None:
            pulumi.set(__self__, "saml_single_sign_on", saml_single_sign_on)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_existing is not None:
            pulumi.set(__self__, "use_existing", use_existing)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The client ID of the application for which to create a service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the service principal account is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "account_enabled")

    @account_enabled.setter
    def account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "account_enabled", value)

    @property
    @pulumi.getter(name="alternativeNames")
    def alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        """
        return pulumi.get(self, "alternative_names")

    @alternative_names.setter
    def alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_names", value)

    @property
    @pulumi.getter(name="appRoleAssignmentRequired")
    def app_role_assignment_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        """
        return pulumi.get(self, "app_role_assignment_required")

    @app_role_assignment_required.setter
    def app_role_assignment_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_role_assignment_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the service principal provided for internal end-users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        """
        return pulumi.get(self, "feature_tags")

    @feature_tags.setter
    def feature_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]]):
        pulumi.set(self, "feature_tags", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""")
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]]:
        """
        Block of features to configure for this service principal using tags
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        """
        return pulumi.get(self, "login_url")

    @login_url.setter
    def login_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free text field to capture information about the service principal, typically used for operational purposes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="notificationEmailAddresses")
    def notification_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        """
        return pulumi.get(self, "notification_email_addresses")

    @notification_email_addresses.setter
    def notification_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_email_addresses", value)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of object IDs of principals that will be granted ownership of the service principal
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter(name="preferredSingleSignOnMode")
    def preferred_single_sign_on_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "preferred_single_sign_on_mode")

    @preferred_single_sign_on_mode.setter
    def preferred_single_sign_on_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_single_sign_on_mode", value)

    @property
    @pulumi.getter(name="samlSingleSignOn")
    def saml_single_sign_on(self) -> Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']]:
        """
        A `saml_single_sign_on` block as documented below.
        """
        return pulumi.get(self, "saml_single_sign_on")

    @saml_single_sign_on.setter
    def saml_single_sign_on(self, value: Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']]):
        pulumi.set(self, "saml_single_sign_on", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useExisting")
    def use_existing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, the resource will return an existing service principal instead of failing with an error
        """
        return pulumi.get(self, "use_existing")

    @use_existing.setter
    def use_existing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_existing", value)


@pulumi.input_type
class _ServicePrincipalState:
    def __init__(__self__, *,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_role_assignment_required: Optional[pulumi.Input[builtins.bool]] = None,
                 app_role_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalAppRoleArgs']]]] = None,
                 application_tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]] = None,
                 homepage_url: Optional[pulumi.Input[builtins.str]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 notification_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 oauth2_permission_scope_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 oauth2_permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalOauth2PermissionScopeArgs']]]] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_single_sign_on_mode: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 saml_metadata_url: Optional[pulumi.Input[builtins.str]] = None,
                 saml_single_sign_on: Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']] = None,
                 service_principal_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 use_existing: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipal resources.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the service principal account is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_names: A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        :param pulumi.Input[builtins.bool] app_role_assignment_required: Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_role_ids: A mapping of app role values to app role IDs, as published by the associated application, intended to be useful when referencing app roles in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalAppRoleArgs']]] app_roles: A list of app roles published by the associated application, as documented below. For more information [official documentation](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] application_tenant_id: The tenant ID where the associated application is registered.
        :param pulumi.Input[builtins.str] client_id: The client ID of the application for which to create a service principal.
        :param pulumi.Input[builtins.str] description: A description of the service principal provided for internal end-users.
        :param pulumi.Input[builtins.str] display_name: Display name for the app role that appears during app role assignment and in consent experiences.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]] features: Block of features to configure for this service principal using tags
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the associated application.
        :param pulumi.Input[builtins.str] login_url: The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to log out an user using OpenId Connect front-channel, back-channel or SAML logout protocols, taken from the associated application.
        :param pulumi.Input[builtins.str] notes: A free text field to capture information about the service principal, typically used for operational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_email_addresses: A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] oauth2_permission_scope_ids: A mapping of OAuth2.0 permission scope values to scope IDs, as exposed by the associated application, intended to be useful when referencing permission scopes in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePrincipalOauth2PermissionScopeArgs']]] oauth2_permission_scopes: A list of OAuth 2.0 delegated permission scopes exposed by the associated application, as documented below.
        :param pulumi.Input[builtins.str] object_id: The object ID of the service principal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the service principal
        :param pulumi.Input[builtins.str] preferred_single_sign_on_mode: The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: A list of URLs where user tokens are sent for sign-in with the associated application, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent for the associated application.
        :param pulumi.Input[builtins.str] saml_metadata_url: The URL where the service exposes SAML metadata for federation.
        :param pulumi.Input['ServicePrincipalSamlSingleSignOnArgs'] saml_single_sign_on: A `saml_single_sign_on` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_principal_names: A list of identifier URI(s), copied over from the associated application.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the associated application. Possible values include `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        :param pulumi.Input[builtins.str] type: Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions. Possible values are `User` or `Admin`.
        :param pulumi.Input[builtins.bool] use_existing: When true, the resource will return an existing service principal instead of failing with an error
        """
        if account_enabled is not None:
            pulumi.set(__self__, "account_enabled", account_enabled)
        if alternative_names is not None:
            pulumi.set(__self__, "alternative_names", alternative_names)
        if app_role_assignment_required is not None:
            pulumi.set(__self__, "app_role_assignment_required", app_role_assignment_required)
        if app_role_ids is not None:
            pulumi.set(__self__, "app_role_ids", app_role_ids)
        if app_roles is not None:
            pulumi.set(__self__, "app_roles", app_roles)
        if application_tenant_id is not None:
            pulumi.set(__self__, "application_tenant_id", application_tenant_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if feature_tags is not None:
            pulumi.set(__self__, "feature_tags", feature_tags)
        if features is not None:
            warnings.warn("""This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""", DeprecationWarning)
            pulumi.log.warn("""features is deprecated: This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""")
        if features is not None:
            pulumi.set(__self__, "features", features)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if login_url is not None:
            pulumi.set(__self__, "login_url", login_url)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if notification_email_addresses is not None:
            pulumi.set(__self__, "notification_email_addresses", notification_email_addresses)
        if oauth2_permission_scope_ids is not None:
            pulumi.set(__self__, "oauth2_permission_scope_ids", oauth2_permission_scope_ids)
        if oauth2_permission_scopes is not None:
            pulumi.set(__self__, "oauth2_permission_scopes", oauth2_permission_scopes)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if preferred_single_sign_on_mode is not None:
            pulumi.set(__self__, "preferred_single_sign_on_mode", preferred_single_sign_on_mode)
        if redirect_uris is not None:
            pulumi.set(__self__, "redirect_uris", redirect_uris)
        if saml_metadata_url is not None:
            pulumi.set(__self__, "saml_metadata_url", saml_metadata_url)
        if saml_single_sign_on is not None:
            pulumi.set(__self__, "saml_single_sign_on", saml_single_sign_on)
        if service_principal_names is not None:
            pulumi.set(__self__, "service_principal_names", service_principal_names)
        if sign_in_audience is not None:
            pulumi.set(__self__, "sign_in_audience", sign_in_audience)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_existing is not None:
            pulumi.set(__self__, "use_existing", use_existing)

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the service principal account is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "account_enabled")

    @account_enabled.setter
    def account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "account_enabled", value)

    @property
    @pulumi.getter(name="alternativeNames")
    def alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        """
        return pulumi.get(self, "alternative_names")

    @alternative_names.setter
    def alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_names", value)

    @property
    @pulumi.getter(name="appRoleAssignmentRequired")
    def app_role_assignment_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        """
        return pulumi.get(self, "app_role_assignment_required")

    @app_role_assignment_required.setter
    def app_role_assignment_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_role_assignment_required", value)

    @property
    @pulumi.getter(name="appRoleIds")
    def app_role_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of app role values to app role IDs, as published by the associated application, intended to be useful when referencing app roles in other resources in your configuration.
        """
        return pulumi.get(self, "app_role_ids")

    @app_role_ids.setter
    def app_role_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_role_ids", value)

    @property
    @pulumi.getter(name="appRoles")
    def app_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalAppRoleArgs']]]]:
        """
        A list of app roles published by the associated application, as documented below. For more information [official documentation](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        """
        return pulumi.get(self, "app_roles")

    @app_roles.setter
    def app_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalAppRoleArgs']]]]):
        pulumi.set(self, "app_roles", value)

    @property
    @pulumi.getter(name="applicationTenantId")
    def application_tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenant ID where the associated application is registered.
        """
        return pulumi.get(self, "application_tenant_id")

    @application_tenant_id.setter
    def application_tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_tenant_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client ID of the application for which to create a service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the service principal provided for internal end-users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name for the app role that appears during app role assignment and in consent experiences.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        """
        return pulumi.get(self, "feature_tags")

    @feature_tags.setter
    def feature_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureTagArgs']]]]):
        pulumi.set(self, "feature_tags", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""")
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]]:
        """
        Block of features to configure for this service principal using tags
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Home page or landing page of the associated application.
        """
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        """
        return pulumi.get(self, "login_url")

    @login_url.setter
    def login_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_url", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL that will be used by Microsoft's authorization service to log out an user using OpenId Connect front-channel, back-channel or SAML logout protocols, taken from the associated application.
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free text field to capture information about the service principal, typically used for operational purposes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="notificationEmailAddresses")
    def notification_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        """
        return pulumi.get(self, "notification_email_addresses")

    @notification_email_addresses.setter
    def notification_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_email_addresses", value)

    @property
    @pulumi.getter(name="oauth2PermissionScopeIds")
    def oauth2_permission_scope_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of OAuth2.0 permission scope values to scope IDs, as exposed by the associated application, intended to be useful when referencing permission scopes in other resources in your configuration.
        """
        return pulumi.get(self, "oauth2_permission_scope_ids")

    @oauth2_permission_scope_ids.setter
    def oauth2_permission_scope_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "oauth2_permission_scope_ids", value)

    @property
    @pulumi.getter(name="oauth2PermissionScopes")
    def oauth2_permission_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalOauth2PermissionScopeArgs']]]]:
        """
        A list of OAuth 2.0 delegated permission scopes exposed by the associated application, as documented below.
        """
        return pulumi.get(self, "oauth2_permission_scopes")

    @oauth2_permission_scopes.setter
    def oauth2_permission_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePrincipalOauth2PermissionScopeArgs']]]]):
        pulumi.set(self, "oauth2_permission_scopes", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the service principal.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of object IDs of principals that will be granted ownership of the service principal
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter(name="preferredSingleSignOnMode")
    def preferred_single_sign_on_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "preferred_single_sign_on_mode")

    @preferred_single_sign_on_mode.setter
    def preferred_single_sign_on_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_single_sign_on_mode", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of URLs where user tokens are sent for sign-in with the associated application, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent for the associated application.
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL where the service exposes SAML metadata for federation.
        """
        return pulumi.get(self, "saml_metadata_url")

    @saml_metadata_url.setter
    def saml_metadata_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "saml_metadata_url", value)

    @property
    @pulumi.getter(name="samlSingleSignOn")
    def saml_single_sign_on(self) -> Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']]:
        """
        A `saml_single_sign_on` block as documented below.
        """
        return pulumi.get(self, "saml_single_sign_on")

    @saml_single_sign_on.setter
    def saml_single_sign_on(self, value: Optional[pulumi.Input['ServicePrincipalSamlSingleSignOnArgs']]):
        pulumi.set(self, "saml_single_sign_on", value)

    @property
    @pulumi.getter(name="servicePrincipalNames")
    def service_principal_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of identifier URI(s), copied over from the associated application.
        """
        return pulumi.get(self, "service_principal_names")

    @service_principal_names.setter
    def service_principal_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_principal_names", value)

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft account types that are supported for the associated application. Possible values include `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`.
        """
        return pulumi.get(self, "sign_in_audience")

    @sign_in_audience.setter
    def sign_in_audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_in_audience", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions. Possible values are `User` or `Admin`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="useExisting")
    def use_existing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, the resource will return an existing service principal instead of failing with an error
        """
        return pulumi.get(self, "use_existing")

    @use_existing.setter
    def use_existing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_existing", value)


@pulumi.type_token("azuread:index/servicePrincipal:ServicePrincipal")
class ServicePrincipal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_role_assignment_required: Optional[pulumi.Input[builtins.bool]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureTagArgs', 'ServicePrincipalFeatureTagArgsDict']]]]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureArgs', 'ServicePrincipalFeatureArgsDict']]]]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 notification_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_single_sign_on_mode: Optional[pulumi.Input[builtins.str]] = None,
                 saml_single_sign_on: Optional[pulumi.Input[Union['ServicePrincipalSamlSingleSignOnArgs', 'ServicePrincipalSamlSingleSignOnArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_existing: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        *Create a service principal for an application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            owners=[current.object_id])
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example.client_id,
            app_role_assignment_required=False,
            owners=[current.object_id])
        ```

        *Create a service principal for an enterprise application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            owners=[current.object_id])
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example.client_id,
            app_role_assignment_required=False,
            owners=[current.object_id],
            feature_tags=[{
                "enterprise": True,
                "gallery": True,
            }])
        ```

        *Manage a service principal for a first-party Microsoft application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        well_known = azuread.get_application_published_app_ids()
        msgraph = azuread.ServicePrincipal("msgraph",
            client_id=well_known.result["microsoftGraph"],
            use_existing=True)
        ```

        *Create a service principal for an application created from a gallery template*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.get_application_template(display_name="Marketo")
        example_application = azuread.Application("example",
            display_name="example",
            template_id=example.template_id)
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example_application.client_id,
            use_existing=True)
        ```

        ## Import

        Service principals can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/servicePrincipal:ServicePrincipal example /servicePrincipals/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the service principal account is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_names: A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        :param pulumi.Input[builtins.bool] app_role_assignment_required: Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        :param pulumi.Input[builtins.str] client_id: The client ID of the application for which to create a service principal.
        :param pulumi.Input[builtins.str] description: A description of the service principal provided for internal end-users.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureTagArgs', 'ServicePrincipalFeatureTagArgsDict']]]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureArgs', 'ServicePrincipalFeatureArgsDict']]]] features: Block of features to configure for this service principal using tags
        :param pulumi.Input[builtins.str] login_url: The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        :param pulumi.Input[builtins.str] notes: A free text field to capture information about the service principal, typically used for operational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_email_addresses: A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the service principal
        :param pulumi.Input[builtins.str] preferred_single_sign_on_mode: The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Union['ServicePrincipalSamlSingleSignOnArgs', 'ServicePrincipalSamlSingleSignOnArgsDict']] saml_single_sign_on: A `saml_single_sign_on` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        :param pulumi.Input[builtins.bool] use_existing: When true, the resource will return an existing service principal instead of failing with an error
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePrincipalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        *Create a service principal for an application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            owners=[current.object_id])
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example.client_id,
            app_role_assignment_required=False,
            owners=[current.object_id])
        ```

        *Create a service principal for an enterprise application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Application("example",
            display_name="example",
            owners=[current.object_id])
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example.client_id,
            app_role_assignment_required=False,
            owners=[current.object_id],
            feature_tags=[{
                "enterprise": True,
                "gallery": True,
            }])
        ```

        *Manage a service principal for a first-party Microsoft application*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        well_known = azuread.get_application_published_app_ids()
        msgraph = azuread.ServicePrincipal("msgraph",
            client_id=well_known.result["microsoftGraph"],
            use_existing=True)
        ```

        *Create a service principal for an application created from a gallery template*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.get_application_template(display_name="Marketo")
        example_application = azuread.Application("example",
            display_name="example",
            template_id=example.template_id)
        example_service_principal = azuread.ServicePrincipal("example",
            client_id=example_application.client_id,
            use_existing=True)
        ```

        ## Import

        Service principals can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/servicePrincipal:ServicePrincipal example /servicePrincipals/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServicePrincipalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_role_assignment_required: Optional[pulumi.Input[builtins.bool]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureTagArgs', 'ServicePrincipalFeatureTagArgsDict']]]]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureArgs', 'ServicePrincipalFeatureArgsDict']]]]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 notification_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_single_sign_on_mode: Optional[pulumi.Input[builtins.str]] = None,
                 saml_single_sign_on: Optional[pulumi.Input[Union['ServicePrincipalSamlSingleSignOnArgs', 'ServicePrincipalSamlSingleSignOnArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_existing: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalArgs.__new__(ServicePrincipalArgs)

            __props__.__dict__["account_enabled"] = account_enabled
            __props__.__dict__["alternative_names"] = alternative_names
            __props__.__dict__["app_role_assignment_required"] = app_role_assignment_required
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_tags"] = feature_tags
            __props__.__dict__["features"] = features
            __props__.__dict__["login_url"] = login_url
            __props__.__dict__["notes"] = notes
            __props__.__dict__["notification_email_addresses"] = notification_email_addresses
            __props__.__dict__["owners"] = owners
            __props__.__dict__["preferred_single_sign_on_mode"] = preferred_single_sign_on_mode
            __props__.__dict__["saml_single_sign_on"] = saml_single_sign_on
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_existing"] = use_existing
            __props__.__dict__["app_role_ids"] = None
            __props__.__dict__["app_roles"] = None
            __props__.__dict__["application_tenant_id"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["homepage_url"] = None
            __props__.__dict__["logout_url"] = None
            __props__.__dict__["oauth2_permission_scope_ids"] = None
            __props__.__dict__["oauth2_permission_scopes"] = None
            __props__.__dict__["object_id"] = None
            __props__.__dict__["redirect_uris"] = None
            __props__.__dict__["saml_metadata_url"] = None
            __props__.__dict__["service_principal_names"] = None
            __props__.__dict__["sign_in_audience"] = None
            __props__.__dict__["type"] = None
        super(ServicePrincipal, __self__).__init__(
            'azuread:index/servicePrincipal:ServicePrincipal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            app_role_assignment_required: Optional[pulumi.Input[builtins.bool]] = None,
            app_role_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalAppRoleArgs', 'ServicePrincipalAppRoleArgsDict']]]]] = None,
            application_tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            feature_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureTagArgs', 'ServicePrincipalFeatureTagArgsDict']]]]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureArgs', 'ServicePrincipalFeatureArgsDict']]]]] = None,
            homepage_url: Optional[pulumi.Input[builtins.str]] = None,
            login_url: Optional[pulumi.Input[builtins.str]] = None,
            logout_url: Optional[pulumi.Input[builtins.str]] = None,
            notes: Optional[pulumi.Input[builtins.str]] = None,
            notification_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            oauth2_permission_scope_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            oauth2_permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalOauth2PermissionScopeArgs', 'ServicePrincipalOauth2PermissionScopeArgsDict']]]]] = None,
            object_id: Optional[pulumi.Input[builtins.str]] = None,
            owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            preferred_single_sign_on_mode: Optional[pulumi.Input[builtins.str]] = None,
            redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            saml_metadata_url: Optional[pulumi.Input[builtins.str]] = None,
            saml_single_sign_on: Optional[pulumi.Input[Union['ServicePrincipalSamlSingleSignOnArgs', 'ServicePrincipalSamlSingleSignOnArgsDict']]] = None,
            service_principal_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            use_existing: Optional[pulumi.Input[builtins.bool]] = None) -> 'ServicePrincipal':
        """
        Get an existing ServicePrincipal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the service principal account is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_names: A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        :param pulumi.Input[builtins.bool] app_role_assignment_required: Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_role_ids: A mapping of app role values to app role IDs, as published by the associated application, intended to be useful when referencing app roles in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalAppRoleArgs', 'ServicePrincipalAppRoleArgsDict']]]] app_roles: A list of app roles published by the associated application, as documented below. For more information [official documentation](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        :param pulumi.Input[builtins.str] application_tenant_id: The tenant ID where the associated application is registered.
        :param pulumi.Input[builtins.str] client_id: The client ID of the application for which to create a service principal.
        :param pulumi.Input[builtins.str] description: A description of the service principal provided for internal end-users.
        :param pulumi.Input[builtins.str] display_name: Display name for the app role that appears during app role assignment and in consent experiences.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureTagArgs', 'ServicePrincipalFeatureTagArgsDict']]]] feature_tags: A `feature_tags` block as described below. Cannot be used together with the `tags` property.
               
               > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalFeatureArgs', 'ServicePrincipalFeatureArgsDict']]]] features: Block of features to configure for this service principal using tags
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the associated application.
        :param pulumi.Input[builtins.str] login_url: The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to log out an user using OpenId Connect front-channel, back-channel or SAML logout protocols, taken from the associated application.
        :param pulumi.Input[builtins.str] notes: A free text field to capture information about the service principal, typically used for operational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_email_addresses: A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] oauth2_permission_scope_ids: A mapping of OAuth2.0 permission scope values to scope IDs, as exposed by the associated application, intended to be useful when referencing permission scopes in other resources in your configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePrincipalOauth2PermissionScopeArgs', 'ServicePrincipalOauth2PermissionScopeArgsDict']]]] oauth2_permission_scopes: A list of OAuth 2.0 delegated permission scopes exposed by the associated application, as documented below.
        :param pulumi.Input[builtins.str] object_id: The object ID of the service principal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: A list of object IDs of principals that will be granted ownership of the service principal
        :param pulumi.Input[builtins.str] preferred_single_sign_on_mode: The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: A list of URLs where user tokens are sent for sign-in with the associated application, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent for the associated application.
        :param pulumi.Input[builtins.str] saml_metadata_url: The URL where the service exposes SAML metadata for federation.
        :param pulumi.Input[Union['ServicePrincipalSamlSingleSignOnArgs', 'ServicePrincipalSamlSingleSignOnArgsDict']] saml_single_sign_on: A `saml_single_sign_on` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_principal_names: A list of identifier URI(s), copied over from the associated application.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the associated application. Possible values include `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.
               
               > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        :param pulumi.Input[builtins.str] type: Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions. Possible values are `User` or `Admin`.
        :param pulumi.Input[builtins.bool] use_existing: When true, the resource will return an existing service principal instead of failing with an error
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalState.__new__(_ServicePrincipalState)

        __props__.__dict__["account_enabled"] = account_enabled
        __props__.__dict__["alternative_names"] = alternative_names
        __props__.__dict__["app_role_assignment_required"] = app_role_assignment_required
        __props__.__dict__["app_role_ids"] = app_role_ids
        __props__.__dict__["app_roles"] = app_roles
        __props__.__dict__["application_tenant_id"] = application_tenant_id
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["feature_tags"] = feature_tags
        __props__.__dict__["features"] = features
        __props__.__dict__["homepage_url"] = homepage_url
        __props__.__dict__["login_url"] = login_url
        __props__.__dict__["logout_url"] = logout_url
        __props__.__dict__["notes"] = notes
        __props__.__dict__["notification_email_addresses"] = notification_email_addresses
        __props__.__dict__["oauth2_permission_scope_ids"] = oauth2_permission_scope_ids
        __props__.__dict__["oauth2_permission_scopes"] = oauth2_permission_scopes
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["owners"] = owners
        __props__.__dict__["preferred_single_sign_on_mode"] = preferred_single_sign_on_mode
        __props__.__dict__["redirect_uris"] = redirect_uris
        __props__.__dict__["saml_metadata_url"] = saml_metadata_url
        __props__.__dict__["saml_single_sign_on"] = saml_single_sign_on
        __props__.__dict__["service_principal_names"] = service_principal_names
        __props__.__dict__["sign_in_audience"] = sign_in_audience
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["use_existing"] = use_existing
        return ServicePrincipal(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not the service principal account is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "account_enabled")

    @property
    @pulumi.getter(name="alternativeNames")
    def alternative_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
        """
        return pulumi.get(self, "alternative_names")

    @property
    @pulumi.getter(name="appRoleAssignmentRequired")
    def app_role_assignment_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application. Defaults to `false`.
        """
        return pulumi.get(self, "app_role_assignment_required")

    @property
    @pulumi.getter(name="appRoleIds")
    def app_role_ids(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A mapping of app role values to app role IDs, as published by the associated application, intended to be useful when referencing app roles in other resources in your configuration.
        """
        return pulumi.get(self, "app_role_ids")

    @property
    @pulumi.getter(name="appRoles")
    def app_roles(self) -> pulumi.Output[Sequence['outputs.ServicePrincipalAppRole']]:
        """
        A list of app roles published by the associated application, as documented below. For more information [official documentation](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
        """
        return pulumi.get(self, "app_roles")

    @property
    @pulumi.getter(name="applicationTenantId")
    def application_tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        The tenant ID where the associated application is registered.
        """
        return pulumi.get(self, "application_tenant_id")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        The client ID of the application for which to create a service principal.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the service principal provided for internal end-users.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name for the app role that appears during app role assignment and in consent experiences.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="featureTags")
    def feature_tags(self) -> pulumi.Output[Sequence['outputs.ServicePrincipalFeatureTag']]:
        """
        A `feature_tags` block as described below. Cannot be used together with the `tags` property.

        > **Features and Tags** Features are configured for a service principal using tags, and are provided as a shortcut to set the corresponding magic tag value for each feature. You cannot configure `feature_tags` and `tags` for a service principal at the same time, so if you need to assign additional custom tags it's recommended to use the `tags` property instead. Any tags configured for the linked application will propagate to this service principal.
        """
        return pulumi.get(self, "feature_tags")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This block has been renamed to `feature_tags` and will be removed in version 3.0 of the provider""")
    def features(self) -> pulumi.Output[Sequence['outputs.ServicePrincipalFeature']]:
        """
        Block of features to configure for this service principal using tags
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> pulumi.Output[builtins.str]:
        """
        Home page or landing page of the associated application.
        """
        return pulumi.get(self, "homepage_url")

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on.
        """
        return pulumi.get(self, "login_url")

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL that will be used by Microsoft's authorization service to log out an user using OpenId Connect front-channel, back-channel or SAML logout protocols, taken from the associated application.
        """
        return pulumi.get(self, "logout_url")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A free text field to capture information about the service principal, typically used for operational purposes.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="notificationEmailAddresses")
    def notification_email_addresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications.
        """
        return pulumi.get(self, "notification_email_addresses")

    @property
    @pulumi.getter(name="oauth2PermissionScopeIds")
    def oauth2_permission_scope_ids(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A mapping of OAuth2.0 permission scope values to scope IDs, as exposed by the associated application, intended to be useful when referencing permission scopes in other resources in your configuration.
        """
        return pulumi.get(self, "oauth2_permission_scope_ids")

    @property
    @pulumi.getter(name="oauth2PermissionScopes")
    def oauth2_permission_scopes(self) -> pulumi.Output[Sequence['outputs.ServicePrincipalOauth2PermissionScope']]:
        """
        A list of OAuth 2.0 delegated permission scopes exposed by the associated application, as documented below.
        """
        return pulumi.get(self, "oauth2_permission_scopes")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[builtins.str]:
        """
        The object ID of the service principal.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def owners(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of object IDs of principals that will be granted ownership of the service principal
        """
        return pulumi.get(self, "owners")

    @property
    @pulumi.getter(name="preferredSingleSignOnMode")
    def preferred_single_sign_on_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps. Supported values are `oidc`, `password`, `saml` or `notSupported`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "preferred_single_sign_on_mode")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of URLs where user tokens are sent for sign-in with the associated application, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent for the associated application.
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL where the service exposes SAML metadata for federation.
        """
        return pulumi.get(self, "saml_metadata_url")

    @property
    @pulumi.getter(name="samlSingleSignOn")
    def saml_single_sign_on(self) -> pulumi.Output[Optional['outputs.ServicePrincipalSamlSingleSignOn']]:
        """
        A `saml_single_sign_on` block as documented below.
        """
        return pulumi.get(self, "saml_single_sign_on")

    @property
    @pulumi.getter(name="servicePrincipalNames")
    def service_principal_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of identifier URI(s), copied over from the associated application.
        """
        return pulumi.get(self, "service_principal_names")

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> pulumi.Output[builtins.str]:
        """
        The Microsoft account types that are supported for the associated application. Possible values include `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`.
        """
        return pulumi.get(self, "sign_in_audience")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A set of tags to apply to the service principal for configuring specific behaviours of the service principal. Note that these are not provided for use by practitioners. Cannot be used together with the `feature_tags` block.

        > **Tags and Features** Azure Active Directory uses special tag values to configure the behavior of service principals. These can be specified using either the `tags` property or with the `feature_tags` block. If you need to set any custom tag values not supported by the `feature_tags` block, it's recommended to use the `tags` property. Tag values set for the linked application will also propagate to this service principal.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions. Possible values are `User` or `Admin`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useExisting")
    def use_existing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When true, the resource will return an existing service principal instead of failing with an error
        """
        return pulumi.get(self, "use_existing")

