# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 user_principal_name: pulumi.Input[builtins.str],
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 age_group: Optional[pulumi.Input[builtins.str]] = None,
                 business_phones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 company_name: Optional[pulumi.Input[builtins.str]] = None,
                 consent_provided_for_minor: Optional[pulumi.Input[builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[builtins.str]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 department: Optional[pulumi.Input[builtins.str]] = None,
                 disable_password_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_strong_password: Optional[pulumi.Input[builtins.bool]] = None,
                 division: Optional[pulumi.Input[builtins.str]] = None,
                 employee_hire_date: Optional[pulumi.Input[builtins.str]] = None,
                 employee_id: Optional[pulumi.Input[builtins.str]] = None,
                 employee_type: Optional[pulumi.Input[builtins.str]] = None,
                 fax_number: Optional[pulumi.Input[builtins.str]] = None,
                 force_password_change: Optional[pulumi.Input[builtins.bool]] = None,
                 given_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 mail: Optional[pulumi.Input[builtins.str]] = None,
                 mail_nickname: Optional[pulumi.Input[builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[builtins.str]] = None,
                 office_location: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_immutable_id: Optional[pulumi.Input[builtins.str]] = None,
                 other_mails: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[builtins.str]] = None,
                 show_in_address_list: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 street_address: Optional[pulumi.Input[builtins.str]] = None,
                 surname: Optional[pulumi.Input[builtins.str]] = None,
                 usage_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] display_name: The name to display in the address book for the user.
        :param pulumi.Input[builtins.str] user_principal_name: The user principal name (UPN) of the user.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the account should be enabled.
        :param pulumi.Input[builtins.str] age_group: The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] business_phones: A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        :param pulumi.Input[builtins.str] city: The city in which the user is located.
        :param pulumi.Input[builtins.str] company_name: The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        :param pulumi.Input[builtins.str] consent_provided_for_minor: Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[builtins.str] cost_center: The cost center associated with the user.
        :param pulumi.Input[builtins.str] country: The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        :param pulumi.Input[builtins.str] department: The name for the department in which the user works.
        :param pulumi.Input[builtins.bool] disable_password_expiration: Whether the user's password is exempt from expiring. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_strong_password: Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        :param pulumi.Input[builtins.str] division: The name of the division in which the user works.
        :param pulumi.Input[builtins.str] employee_hire_date: The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        :param pulumi.Input[builtins.str] employee_id: The employee identifier assigned to the user by the organisation.
        :param pulumi.Input[builtins.str] employee_type: Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        :param pulumi.Input[builtins.str] fax_number: The fax number of the user.
        :param pulumi.Input[builtins.bool] force_password_change: Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        :param pulumi.Input[builtins.str] given_name: The given name (first name) of the user.
        :param pulumi.Input[builtins.str] job_title: The user’s job title.
        :param pulumi.Input[builtins.str] mail: The SMTP address for the user. This property cannot be unset once specified.
        :param pulumi.Input[builtins.str] mail_nickname: The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        :param pulumi.Input[builtins.str] manager_id: The object ID of the user's manager.
        :param pulumi.Input[builtins.str] mobile_phone: The primary cellular telephone number for the user.
        :param pulumi.Input[builtins.str] office_location: The office location in the user's place of business.
        :param pulumi.Input[builtins.str] onpremises_immutable_id: The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] other_mails: A list of additional email addresses for the user.
        :param pulumi.Input[builtins.str] password: The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
               maximum length is 256 characters. This property is required when creating a new user
        :param pulumi.Input[builtins.str] postal_code: The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        :param pulumi.Input[builtins.str] preferred_language: The user's preferred language, in ISO 639-1 notation.
        :param pulumi.Input[builtins.bool] show_in_address_list: Whether or not the Outlook global address list should include this user. Defaults to `true`.
        :param pulumi.Input[builtins.str] state: The state or province in the user's address.
        :param pulumi.Input[builtins.str] street_address: The street address of the user's place of business.
        :param pulumi.Input[builtins.str] surname: The user's surname (family name or last name).
        :param pulumi.Input[builtins.str] usage_location: The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "user_principal_name", user_principal_name)
        if account_enabled is not None:
            pulumi.set(__self__, "account_enabled", account_enabled)
        if age_group is not None:
            pulumi.set(__self__, "age_group", age_group)
        if business_phones is not None:
            pulumi.set(__self__, "business_phones", business_phones)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if consent_provided_for_minor is not None:
            pulumi.set(__self__, "consent_provided_for_minor", consent_provided_for_minor)
        if cost_center is not None:
            pulumi.set(__self__, "cost_center", cost_center)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if disable_password_expiration is not None:
            pulumi.set(__self__, "disable_password_expiration", disable_password_expiration)
        if disable_strong_password is not None:
            pulumi.set(__self__, "disable_strong_password", disable_strong_password)
        if division is not None:
            pulumi.set(__self__, "division", division)
        if employee_hire_date is not None:
            pulumi.set(__self__, "employee_hire_date", employee_hire_date)
        if employee_id is not None:
            pulumi.set(__self__, "employee_id", employee_id)
        if employee_type is not None:
            pulumi.set(__self__, "employee_type", employee_type)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if force_password_change is not None:
            pulumi.set(__self__, "force_password_change", force_password_change)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if mail_nickname is not None:
            pulumi.set(__self__, "mail_nickname", mail_nickname)
        if manager_id is not None:
            pulumi.set(__self__, "manager_id", manager_id)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if office_location is not None:
            pulumi.set(__self__, "office_location", office_location)
        if onpremises_immutable_id is not None:
            pulumi.set(__self__, "onpremises_immutable_id", onpremises_immutable_id)
        if other_mails is not None:
            pulumi.set(__self__, "other_mails", other_mails)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if show_in_address_list is not None:
            pulumi.set(__self__, "show_in_address_list", show_in_address_list)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if usage_location is not None:
            pulumi.set(__self__, "usage_location", usage_location)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name to display in the address book for the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> pulumi.Input[builtins.str]:
        """
        The user principal name (UPN) of the user.
        """
        return pulumi.get(self, "user_principal_name")

    @user_principal_name.setter
    def user_principal_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_principal_name", value)

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the account should be enabled.
        """
        return pulumi.get(self, "account_enabled")

    @account_enabled.setter
    def account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "account_enabled", value)

    @property
    @pulumi.getter(name="ageGroup")
    def age_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "age_group")

    @age_group.setter
    def age_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "age_group", value)

    @property
    @pulumi.getter(name="businessPhones")
    def business_phones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        """
        return pulumi.get(self, "business_phones")

    @business_phones.setter
    def business_phones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "business_phones", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The city in which the user is located.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="consentProvidedForMinor")
    def consent_provided_for_minor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "consent_provided_for_minor")

    @consent_provided_for_minor.setter
    def consent_provided_for_minor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consent_provided_for_minor", value)

    @property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cost center associated with the user.
        """
        return pulumi.get(self, "cost_center")

    @cost_center.setter
    def cost_center(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cost_center", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the department in which the user works.
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "department", value)

    @property
    @pulumi.getter(name="disablePasswordExpiration")
    def disable_password_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user's password is exempt from expiring. Defaults to `false`.
        """
        return pulumi.get(self, "disable_password_expiration")

    @disable_password_expiration.setter
    def disable_password_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_password_expiration", value)

    @property
    @pulumi.getter(name="disableStrongPassword")
    def disable_strong_password(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        """
        return pulumi.get(self, "disable_strong_password")

    @disable_strong_password.setter
    def disable_strong_password(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_strong_password", value)

    @property
    @pulumi.getter
    def division(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the division in which the user works.
        """
        return pulumi.get(self, "division")

    @division.setter
    def division(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "division", value)

    @property
    @pulumi.getter(name="employeeHireDate")
    def employee_hire_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        """
        return pulumi.get(self, "employee_hire_date")

    @employee_hire_date.setter
    def employee_hire_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_hire_date", value)

    @property
    @pulumi.getter(name="employeeId")
    def employee_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The employee identifier assigned to the user by the organisation.
        """
        return pulumi.get(self, "employee_id")

    @employee_id.setter
    def employee_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_id", value)

    @property
    @pulumi.getter(name="employeeType")
    def employee_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        """
        return pulumi.get(self, "employee_type")

    @employee_type.setter
    def employee_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_type", value)

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fax number of the user.
        """
        return pulumi.get(self, "fax_number")

    @fax_number.setter
    def fax_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fax_number", value)

    @property
    @pulumi.getter(name="forcePasswordChange")
    def force_password_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        """
        return pulumi.get(self, "force_password_change")

    @force_password_change.setter
    def force_password_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_password_change", value)

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The given name (first name) of the user.
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "given_name", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user’s job title.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SMTP address for the user. This property cannot be unset once specified.
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mail", value)

    @property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        """
        return pulumi.get(self, "mail_nickname")

    @mail_nickname.setter
    def mail_nickname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mail_nickname", value)

    @property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the user's manager.
        """
        return pulumi.get(self, "manager_id")

    @manager_id.setter
    def manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manager_id", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary cellular telephone number for the user.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="officeLocation")
    def office_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The office location in the user's place of business.
        """
        return pulumi.get(self, "office_location")

    @office_location.setter
    def office_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "office_location", value)

    @property
    @pulumi.getter(name="onpremisesImmutableId")
    def onpremises_immutable_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        """
        return pulumi.get(self, "onpremises_immutable_id")

    @onpremises_immutable_id.setter
    def onpremises_immutable_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_immutable_id", value)

    @property
    @pulumi.getter(name="otherMails")
    def other_mails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of additional email addresses for the user.
        """
        return pulumi.get(self, "other_mails")

    @other_mails.setter
    def other_mails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "other_mails", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
        maximum length is 256 characters. This property is required when creating a new user
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's preferred language, in ISO 639-1 notation.
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="showInAddressList")
    def show_in_address_list(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the Outlook global address list should include this user. Defaults to `true`.
        """
        return pulumi.get(self, "show_in_address_list")

    @show_in_address_list.setter
    def show_in_address_list(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "show_in_address_list", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state or province in the user's address.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The street address of the user's place of business.
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter
    def surname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's surname (family name or last name).
        """
        return pulumi.get(self, "surname")

    @surname.setter
    def surname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "surname", value)

    @property
    @pulumi.getter(name="usageLocation")
    def usage_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        """
        return pulumi.get(self, "usage_location")

    @usage_location.setter
    def usage_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_location", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 about_me: Optional[pulumi.Input[builtins.str]] = None,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 age_group: Optional[pulumi.Input[builtins.str]] = None,
                 business_phones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 company_name: Optional[pulumi.Input[builtins.str]] = None,
                 consent_provided_for_minor: Optional[pulumi.Input[builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[builtins.str]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[builtins.str]] = None,
                 department: Optional[pulumi.Input[builtins.str]] = None,
                 disable_password_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_strong_password: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 division: Optional[pulumi.Input[builtins.str]] = None,
                 employee_hire_date: Optional[pulumi.Input[builtins.str]] = None,
                 employee_id: Optional[pulumi.Input[builtins.str]] = None,
                 employee_type: Optional[pulumi.Input[builtins.str]] = None,
                 external_user_state: Optional[pulumi.Input[builtins.str]] = None,
                 fax_number: Optional[pulumi.Input[builtins.str]] = None,
                 force_password_change: Optional[pulumi.Input[builtins.bool]] = None,
                 given_name: Optional[pulumi.Input[builtins.str]] = None,
                 im_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 mail: Optional[pulumi.Input[builtins.str]] = None,
                 mail_nickname: Optional[pulumi.Input[builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[builtins.str]] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 office_location: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_distinguished_name: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_immutable_id: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_sam_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_security_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_sync_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 onpremises_user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
                 other_mails: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 show_in_address_list: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 street_address: Optional[pulumi.Input[builtins.str]] = None,
                 surname: Optional[pulumi.Input[builtins.str]] = None,
                 usage_location: Optional[pulumi.Input[builtins.str]] = None,
                 user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] about_me: A freeform field for the user to describe themselves
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the account should be enabled.
        :param pulumi.Input[builtins.str] age_group: The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] business_phones: A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        :param pulumi.Input[builtins.str] city: The city in which the user is located.
        :param pulumi.Input[builtins.str] company_name: The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        :param pulumi.Input[builtins.str] consent_provided_for_minor: Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[builtins.str] cost_center: The cost center associated with the user.
        :param pulumi.Input[builtins.str] country: The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        :param pulumi.Input[builtins.str] creation_type: Indicates whether the user account was created as a regular school or work account (`null`), an external account (`Invitation`), a local account for an Azure Active Directory B2C tenant (`LocalAccount`) or self-service sign-up using email verification (`EmailVerified`).
        :param pulumi.Input[builtins.str] department: The name for the department in which the user works.
        :param pulumi.Input[builtins.bool] disable_password_expiration: Whether the user's password is exempt from expiring. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_strong_password: Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        :param pulumi.Input[builtins.str] display_name: The name to display in the address book for the user.
        :param pulumi.Input[builtins.str] division: The name of the division in which the user works.
        :param pulumi.Input[builtins.str] employee_hire_date: The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        :param pulumi.Input[builtins.str] employee_id: The employee identifier assigned to the user by the organisation.
        :param pulumi.Input[builtins.str] employee_type: Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        :param pulumi.Input[builtins.str] external_user_state: For an external user invited to the tenant, this property represents the invited user's invitation status. Possible values are `PendingAcceptance` or `Accepted`.
        :param pulumi.Input[builtins.str] fax_number: The fax number of the user.
        :param pulumi.Input[builtins.bool] force_password_change: Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        :param pulumi.Input[builtins.str] given_name: The given name (first name) of the user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] im_addresses: A list of instant message voice over IP (VOIP) session initiation protocol (SIP) addresses for the user.
        :param pulumi.Input[builtins.str] job_title: The user’s job title.
        :param pulumi.Input[builtins.str] mail: The SMTP address for the user. This property cannot be unset once specified.
        :param pulumi.Input[builtins.str] mail_nickname: The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        :param pulumi.Input[builtins.str] manager_id: The object ID of the user's manager.
        :param pulumi.Input[builtins.str] mobile_phone: The primary cellular telephone number for the user.
        :param pulumi.Input[builtins.str] object_id: The object ID of the user.
        :param pulumi.Input[builtins.str] office_location: The office location in the user's place of business.
        :param pulumi.Input[builtins.str] onpremises_distinguished_name: The on-premises distinguished name (DN) of the user, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.str] onpremises_domain_name: The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.str] onpremises_immutable_id: The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        :param pulumi.Input[builtins.str] onpremises_sam_account_name: The on-premise SAM account name of the user.
        :param pulumi.Input[builtins.str] onpremises_security_identifier: The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.bool] onpremises_sync_enabled: Whether this user is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        :param pulumi.Input[builtins.str] onpremises_user_principal_name: The on-premise user principal name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] other_mails: A list of additional email addresses for the user.
        :param pulumi.Input[builtins.str] password: The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
               maximum length is 256 characters. This property is required when creating a new user
        :param pulumi.Input[builtins.str] postal_code: The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        :param pulumi.Input[builtins.str] preferred_language: The user's preferred language, in ISO 639-1 notation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] proxy_addresses: List of email addresses for the user that direct to the same mailbox.
        :param pulumi.Input[builtins.bool] show_in_address_list: Whether or not the Outlook global address list should include this user. Defaults to `true`.
        :param pulumi.Input[builtins.str] state: The state or province in the user's address.
        :param pulumi.Input[builtins.str] street_address: The street address of the user's place of business.
        :param pulumi.Input[builtins.str] surname: The user's surname (family name or last name).
        :param pulumi.Input[builtins.str] usage_location: The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        :param pulumi.Input[builtins.str] user_principal_name: The user principal name (UPN) of the user.
        :param pulumi.Input[builtins.str] user_type: The user type in the directory. Possible values are `Guest` or `Member`.
        """
        if about_me is not None:
            pulumi.set(__self__, "about_me", about_me)
        if account_enabled is not None:
            pulumi.set(__self__, "account_enabled", account_enabled)
        if age_group is not None:
            pulumi.set(__self__, "age_group", age_group)
        if business_phones is not None:
            pulumi.set(__self__, "business_phones", business_phones)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if consent_provided_for_minor is not None:
            pulumi.set(__self__, "consent_provided_for_minor", consent_provided_for_minor)
        if cost_center is not None:
            pulumi.set(__self__, "cost_center", cost_center)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if creation_type is not None:
            pulumi.set(__self__, "creation_type", creation_type)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if disable_password_expiration is not None:
            pulumi.set(__self__, "disable_password_expiration", disable_password_expiration)
        if disable_strong_password is not None:
            pulumi.set(__self__, "disable_strong_password", disable_strong_password)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if division is not None:
            pulumi.set(__self__, "division", division)
        if employee_hire_date is not None:
            pulumi.set(__self__, "employee_hire_date", employee_hire_date)
        if employee_id is not None:
            pulumi.set(__self__, "employee_id", employee_id)
        if employee_type is not None:
            pulumi.set(__self__, "employee_type", employee_type)
        if external_user_state is not None:
            pulumi.set(__self__, "external_user_state", external_user_state)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if force_password_change is not None:
            pulumi.set(__self__, "force_password_change", force_password_change)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if im_addresses is not None:
            pulumi.set(__self__, "im_addresses", im_addresses)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if mail_nickname is not None:
            pulumi.set(__self__, "mail_nickname", mail_nickname)
        if manager_id is not None:
            pulumi.set(__self__, "manager_id", manager_id)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if office_location is not None:
            pulumi.set(__self__, "office_location", office_location)
        if onpremises_distinguished_name is not None:
            pulumi.set(__self__, "onpremises_distinguished_name", onpremises_distinguished_name)
        if onpremises_domain_name is not None:
            pulumi.set(__self__, "onpremises_domain_name", onpremises_domain_name)
        if onpremises_immutable_id is not None:
            pulumi.set(__self__, "onpremises_immutable_id", onpremises_immutable_id)
        if onpremises_sam_account_name is not None:
            pulumi.set(__self__, "onpremises_sam_account_name", onpremises_sam_account_name)
        if onpremises_security_identifier is not None:
            pulumi.set(__self__, "onpremises_security_identifier", onpremises_security_identifier)
        if onpremises_sync_enabled is not None:
            pulumi.set(__self__, "onpremises_sync_enabled", onpremises_sync_enabled)
        if onpremises_user_principal_name is not None:
            pulumi.set(__self__, "onpremises_user_principal_name", onpremises_user_principal_name)
        if other_mails is not None:
            pulumi.set(__self__, "other_mails", other_mails)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if proxy_addresses is not None:
            pulumi.set(__self__, "proxy_addresses", proxy_addresses)
        if show_in_address_list is not None:
            pulumi.set(__self__, "show_in_address_list", show_in_address_list)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if usage_location is not None:
            pulumi.set(__self__, "usage_location", usage_location)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @property
    @pulumi.getter(name="aboutMe")
    def about_me(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A freeform field for the user to describe themselves
        """
        return pulumi.get(self, "about_me")

    @about_me.setter
    def about_me(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "about_me", value)

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the account should be enabled.
        """
        return pulumi.get(self, "account_enabled")

    @account_enabled.setter
    def account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "account_enabled", value)

    @property
    @pulumi.getter(name="ageGroup")
    def age_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "age_group")

    @age_group.setter
    def age_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "age_group", value)

    @property
    @pulumi.getter(name="businessPhones")
    def business_phones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        """
        return pulumi.get(self, "business_phones")

    @business_phones.setter
    def business_phones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "business_phones", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The city in which the user is located.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="consentProvidedForMinor")
    def consent_provided_for_minor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "consent_provided_for_minor")

    @consent_provided_for_minor.setter
    def consent_provided_for_minor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consent_provided_for_minor", value)

    @property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cost center associated with the user.
        """
        return pulumi.get(self, "cost_center")

    @cost_center.setter
    def cost_center(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cost_center", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the user account was created as a regular school or work account (`null`), an external account (`Invitation`), a local account for an Azure Active Directory B2C tenant (`LocalAccount`) or self-service sign-up using email verification (`EmailVerified`).
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_type", value)

    @property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the department in which the user works.
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "department", value)

    @property
    @pulumi.getter(name="disablePasswordExpiration")
    def disable_password_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user's password is exempt from expiring. Defaults to `false`.
        """
        return pulumi.get(self, "disable_password_expiration")

    @disable_password_expiration.setter
    def disable_password_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_password_expiration", value)

    @property
    @pulumi.getter(name="disableStrongPassword")
    def disable_strong_password(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        """
        return pulumi.get(self, "disable_strong_password")

    @disable_strong_password.setter
    def disable_strong_password(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_strong_password", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name to display in the address book for the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def division(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the division in which the user works.
        """
        return pulumi.get(self, "division")

    @division.setter
    def division(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "division", value)

    @property
    @pulumi.getter(name="employeeHireDate")
    def employee_hire_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        """
        return pulumi.get(self, "employee_hire_date")

    @employee_hire_date.setter
    def employee_hire_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_hire_date", value)

    @property
    @pulumi.getter(name="employeeId")
    def employee_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The employee identifier assigned to the user by the organisation.
        """
        return pulumi.get(self, "employee_id")

    @employee_id.setter
    def employee_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_id", value)

    @property
    @pulumi.getter(name="employeeType")
    def employee_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        """
        return pulumi.get(self, "employee_type")

    @employee_type.setter
    def employee_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "employee_type", value)

    @property
    @pulumi.getter(name="externalUserState")
    def external_user_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For an external user invited to the tenant, this property represents the invited user's invitation status. Possible values are `PendingAcceptance` or `Accepted`.
        """
        return pulumi.get(self, "external_user_state")

    @external_user_state.setter
    def external_user_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_user_state", value)

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fax number of the user.
        """
        return pulumi.get(self, "fax_number")

    @fax_number.setter
    def fax_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fax_number", value)

    @property
    @pulumi.getter(name="forcePasswordChange")
    def force_password_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        """
        return pulumi.get(self, "force_password_change")

    @force_password_change.setter
    def force_password_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_password_change", value)

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The given name (first name) of the user.
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "given_name", value)

    @property
    @pulumi.getter(name="imAddresses")
    def im_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instant message voice over IP (VOIP) session initiation protocol (SIP) addresses for the user.
        """
        return pulumi.get(self, "im_addresses")

    @im_addresses.setter
    def im_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "im_addresses", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user’s job title.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SMTP address for the user. This property cannot be unset once specified.
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mail", value)

    @property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        """
        return pulumi.get(self, "mail_nickname")

    @mail_nickname.setter
    def mail_nickname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mail_nickname", value)

    @property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the user's manager.
        """
        return pulumi.get(self, "manager_id")

    @manager_id.setter
    def manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manager_id", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary cellular telephone number for the user.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="officeLocation")
    def office_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The office location in the user's place of business.
        """
        return pulumi.get(self, "office_location")

    @office_location.setter
    def office_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "office_location", value)

    @property
    @pulumi.getter(name="onpremisesDistinguishedName")
    def onpremises_distinguished_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The on-premises distinguished name (DN) of the user, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_distinguished_name")

    @onpremises_distinguished_name.setter
    def onpremises_distinguished_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_distinguished_name", value)

    @property
    @pulumi.getter(name="onpremisesDomainName")
    def onpremises_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_domain_name")

    @onpremises_domain_name.setter
    def onpremises_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_domain_name", value)

    @property
    @pulumi.getter(name="onpremisesImmutableId")
    def onpremises_immutable_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        """
        return pulumi.get(self, "onpremises_immutable_id")

    @onpremises_immutable_id.setter
    def onpremises_immutable_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_immutable_id", value)

    @property
    @pulumi.getter(name="onpremisesSamAccountName")
    def onpremises_sam_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The on-premise SAM account name of the user.
        """
        return pulumi.get(self, "onpremises_sam_account_name")

    @onpremises_sam_account_name.setter
    def onpremises_sam_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_sam_account_name", value)

    @property
    @pulumi.getter(name="onpremisesSecurityIdentifier")
    def onpremises_security_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_security_identifier")

    @onpremises_security_identifier.setter
    def onpremises_security_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_security_identifier", value)

    @property
    @pulumi.getter(name="onpremisesSyncEnabled")
    def onpremises_sync_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this user is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        """
        return pulumi.get(self, "onpremises_sync_enabled")

    @onpremises_sync_enabled.setter
    def onpremises_sync_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "onpremises_sync_enabled", value)

    @property
    @pulumi.getter(name="onpremisesUserPrincipalName")
    def onpremises_user_principal_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The on-premise user principal name of the user.
        """
        return pulumi.get(self, "onpremises_user_principal_name")

    @onpremises_user_principal_name.setter
    def onpremises_user_principal_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "onpremises_user_principal_name", value)

    @property
    @pulumi.getter(name="otherMails")
    def other_mails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of additional email addresses for the user.
        """
        return pulumi.get(self, "other_mails")

    @other_mails.setter
    def other_mails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "other_mails", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
        maximum length is 256 characters. This property is required when creating a new user
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's preferred language, in ISO 639-1 notation.
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="proxyAddresses")
    def proxy_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of email addresses for the user that direct to the same mailbox.
        """
        return pulumi.get(self, "proxy_addresses")

    @proxy_addresses.setter
    def proxy_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "proxy_addresses", value)

    @property
    @pulumi.getter(name="showInAddressList")
    def show_in_address_list(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the Outlook global address list should include this user. Defaults to `true`.
        """
        return pulumi.get(self, "show_in_address_list")

    @show_in_address_list.setter
    def show_in_address_list(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "show_in_address_list", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state or province in the user's address.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The street address of the user's place of business.
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter
    def surname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's surname (family name or last name).
        """
        return pulumi.get(self, "surname")

    @surname.setter
    def surname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "surname", value)

    @property
    @pulumi.getter(name="usageLocation")
    def usage_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        """
        return pulumi.get(self, "usage_location")

    @usage_location.setter
    def usage_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_location", value)

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user principal name (UPN) of the user.
        """
        return pulumi.get(self, "user_principal_name")

    @user_principal_name.setter
    def user_principal_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_principal_name", value)

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user type in the directory. Possible values are `Guest` or `Member`.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("azuread:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 age_group: Optional[pulumi.Input[builtins.str]] = None,
                 business_phones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 company_name: Optional[pulumi.Input[builtins.str]] = None,
                 consent_provided_for_minor: Optional[pulumi.Input[builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[builtins.str]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 department: Optional[pulumi.Input[builtins.str]] = None,
                 disable_password_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_strong_password: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 division: Optional[pulumi.Input[builtins.str]] = None,
                 employee_hire_date: Optional[pulumi.Input[builtins.str]] = None,
                 employee_id: Optional[pulumi.Input[builtins.str]] = None,
                 employee_type: Optional[pulumi.Input[builtins.str]] = None,
                 fax_number: Optional[pulumi.Input[builtins.str]] = None,
                 force_password_change: Optional[pulumi.Input[builtins.bool]] = None,
                 given_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 mail: Optional[pulumi.Input[builtins.str]] = None,
                 mail_nickname: Optional[pulumi.Input[builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[builtins.str]] = None,
                 office_location: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_immutable_id: Optional[pulumi.Input[builtins.str]] = None,
                 other_mails: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[builtins.str]] = None,
                 show_in_address_list: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 street_address: Optional[pulumi.Input[builtins.str]] = None,
                 surname: Optional[pulumi.Input[builtins.str]] = None,
                 usage_location: Optional[pulumi.Input[builtins.str]] = None,
                 user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a user within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `User.ReadWrite.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `User Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.User("example",
            user_principal_name="jdoe@example.com",
            display_name="J. Doe",
            mail_nickname="jdoe",
            password="SecretP@sswd99!")
        ```

        ## Import

        Users can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/user:User my_user /users/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the account should be enabled.
        :param pulumi.Input[builtins.str] age_group: The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] business_phones: A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        :param pulumi.Input[builtins.str] city: The city in which the user is located.
        :param pulumi.Input[builtins.str] company_name: The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        :param pulumi.Input[builtins.str] consent_provided_for_minor: Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[builtins.str] cost_center: The cost center associated with the user.
        :param pulumi.Input[builtins.str] country: The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        :param pulumi.Input[builtins.str] department: The name for the department in which the user works.
        :param pulumi.Input[builtins.bool] disable_password_expiration: Whether the user's password is exempt from expiring. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_strong_password: Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        :param pulumi.Input[builtins.str] display_name: The name to display in the address book for the user.
        :param pulumi.Input[builtins.str] division: The name of the division in which the user works.
        :param pulumi.Input[builtins.str] employee_hire_date: The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        :param pulumi.Input[builtins.str] employee_id: The employee identifier assigned to the user by the organisation.
        :param pulumi.Input[builtins.str] employee_type: Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        :param pulumi.Input[builtins.str] fax_number: The fax number of the user.
        :param pulumi.Input[builtins.bool] force_password_change: Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        :param pulumi.Input[builtins.str] given_name: The given name (first name) of the user.
        :param pulumi.Input[builtins.str] job_title: The user’s job title.
        :param pulumi.Input[builtins.str] mail: The SMTP address for the user. This property cannot be unset once specified.
        :param pulumi.Input[builtins.str] mail_nickname: The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        :param pulumi.Input[builtins.str] manager_id: The object ID of the user's manager.
        :param pulumi.Input[builtins.str] mobile_phone: The primary cellular telephone number for the user.
        :param pulumi.Input[builtins.str] office_location: The office location in the user's place of business.
        :param pulumi.Input[builtins.str] onpremises_immutable_id: The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] other_mails: A list of additional email addresses for the user.
        :param pulumi.Input[builtins.str] password: The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
               maximum length is 256 characters. This property is required when creating a new user
        :param pulumi.Input[builtins.str] postal_code: The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        :param pulumi.Input[builtins.str] preferred_language: The user's preferred language, in ISO 639-1 notation.
        :param pulumi.Input[builtins.bool] show_in_address_list: Whether or not the Outlook global address list should include this user. Defaults to `true`.
        :param pulumi.Input[builtins.str] state: The state or province in the user's address.
        :param pulumi.Input[builtins.str] street_address: The street address of the user's place of business.
        :param pulumi.Input[builtins.str] surname: The user's surname (family name or last name).
        :param pulumi.Input[builtins.str] usage_location: The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        :param pulumi.Input[builtins.str] user_principal_name: The user principal name (UPN) of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a user within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `User.ReadWrite.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `User Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.User("example",
            user_principal_name="jdoe@example.com",
            display_name="J. Doe",
            mail_nickname="jdoe",
            password="SecretP@sswd99!")
        ```

        ## Import

        Users can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/user:User my_user /users/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 age_group: Optional[pulumi.Input[builtins.str]] = None,
                 business_phones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 company_name: Optional[pulumi.Input[builtins.str]] = None,
                 consent_provided_for_minor: Optional[pulumi.Input[builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[builtins.str]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 department: Optional[pulumi.Input[builtins.str]] = None,
                 disable_password_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_strong_password: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 division: Optional[pulumi.Input[builtins.str]] = None,
                 employee_hire_date: Optional[pulumi.Input[builtins.str]] = None,
                 employee_id: Optional[pulumi.Input[builtins.str]] = None,
                 employee_type: Optional[pulumi.Input[builtins.str]] = None,
                 fax_number: Optional[pulumi.Input[builtins.str]] = None,
                 force_password_change: Optional[pulumi.Input[builtins.bool]] = None,
                 given_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 mail: Optional[pulumi.Input[builtins.str]] = None,
                 mail_nickname: Optional[pulumi.Input[builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[builtins.str]] = None,
                 office_location: Optional[pulumi.Input[builtins.str]] = None,
                 onpremises_immutable_id: Optional[pulumi.Input[builtins.str]] = None,
                 other_mails: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[builtins.str]] = None,
                 show_in_address_list: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 street_address: Optional[pulumi.Input[builtins.str]] = None,
                 surname: Optional[pulumi.Input[builtins.str]] = None,
                 usage_location: Optional[pulumi.Input[builtins.str]] = None,
                 user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["account_enabled"] = account_enabled
            __props__.__dict__["age_group"] = age_group
            __props__.__dict__["business_phones"] = business_phones
            __props__.__dict__["city"] = city
            __props__.__dict__["company_name"] = company_name
            __props__.__dict__["consent_provided_for_minor"] = consent_provided_for_minor
            __props__.__dict__["cost_center"] = cost_center
            __props__.__dict__["country"] = country
            __props__.__dict__["department"] = department
            __props__.__dict__["disable_password_expiration"] = disable_password_expiration
            __props__.__dict__["disable_strong_password"] = disable_strong_password
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["division"] = division
            __props__.__dict__["employee_hire_date"] = employee_hire_date
            __props__.__dict__["employee_id"] = employee_id
            __props__.__dict__["employee_type"] = employee_type
            __props__.__dict__["fax_number"] = fax_number
            __props__.__dict__["force_password_change"] = force_password_change
            __props__.__dict__["given_name"] = given_name
            __props__.__dict__["job_title"] = job_title
            __props__.__dict__["mail"] = mail
            __props__.__dict__["mail_nickname"] = mail_nickname
            __props__.__dict__["manager_id"] = manager_id
            __props__.__dict__["mobile_phone"] = mobile_phone
            __props__.__dict__["office_location"] = office_location
            __props__.__dict__["onpremises_immutable_id"] = onpremises_immutable_id
            __props__.__dict__["other_mails"] = other_mails
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["preferred_language"] = preferred_language
            __props__.__dict__["show_in_address_list"] = show_in_address_list
            __props__.__dict__["state"] = state
            __props__.__dict__["street_address"] = street_address
            __props__.__dict__["surname"] = surname
            __props__.__dict__["usage_location"] = usage_location
            if user_principal_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_principal_name'")
            __props__.__dict__["user_principal_name"] = user_principal_name
            __props__.__dict__["about_me"] = None
            __props__.__dict__["creation_type"] = None
            __props__.__dict__["external_user_state"] = None
            __props__.__dict__["im_addresses"] = None
            __props__.__dict__["object_id"] = None
            __props__.__dict__["onpremises_distinguished_name"] = None
            __props__.__dict__["onpremises_domain_name"] = None
            __props__.__dict__["onpremises_sam_account_name"] = None
            __props__.__dict__["onpremises_security_identifier"] = None
            __props__.__dict__["onpremises_sync_enabled"] = None
            __props__.__dict__["onpremises_user_principal_name"] = None
            __props__.__dict__["proxy_addresses"] = None
            __props__.__dict__["user_type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'azuread:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            about_me: Optional[pulumi.Input[builtins.str]] = None,
            account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            age_group: Optional[pulumi.Input[builtins.str]] = None,
            business_phones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            city: Optional[pulumi.Input[builtins.str]] = None,
            company_name: Optional[pulumi.Input[builtins.str]] = None,
            consent_provided_for_minor: Optional[pulumi.Input[builtins.str]] = None,
            cost_center: Optional[pulumi.Input[builtins.str]] = None,
            country: Optional[pulumi.Input[builtins.str]] = None,
            creation_type: Optional[pulumi.Input[builtins.str]] = None,
            department: Optional[pulumi.Input[builtins.str]] = None,
            disable_password_expiration: Optional[pulumi.Input[builtins.bool]] = None,
            disable_strong_password: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            division: Optional[pulumi.Input[builtins.str]] = None,
            employee_hire_date: Optional[pulumi.Input[builtins.str]] = None,
            employee_id: Optional[pulumi.Input[builtins.str]] = None,
            employee_type: Optional[pulumi.Input[builtins.str]] = None,
            external_user_state: Optional[pulumi.Input[builtins.str]] = None,
            fax_number: Optional[pulumi.Input[builtins.str]] = None,
            force_password_change: Optional[pulumi.Input[builtins.bool]] = None,
            given_name: Optional[pulumi.Input[builtins.str]] = None,
            im_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            job_title: Optional[pulumi.Input[builtins.str]] = None,
            mail: Optional[pulumi.Input[builtins.str]] = None,
            mail_nickname: Optional[pulumi.Input[builtins.str]] = None,
            manager_id: Optional[pulumi.Input[builtins.str]] = None,
            mobile_phone: Optional[pulumi.Input[builtins.str]] = None,
            object_id: Optional[pulumi.Input[builtins.str]] = None,
            office_location: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_distinguished_name: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_domain_name: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_immutable_id: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_sam_account_name: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_security_identifier: Optional[pulumi.Input[builtins.str]] = None,
            onpremises_sync_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            onpremises_user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
            other_mails: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            postal_code: Optional[pulumi.Input[builtins.str]] = None,
            preferred_language: Optional[pulumi.Input[builtins.str]] = None,
            proxy_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            show_in_address_list: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            street_address: Optional[pulumi.Input[builtins.str]] = None,
            surname: Optional[pulumi.Input[builtins.str]] = None,
            usage_location: Optional[pulumi.Input[builtins.str]] = None,
            user_principal_name: Optional[pulumi.Input[builtins.str]] = None,
            user_type: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] about_me: A freeform field for the user to describe themselves
        :param pulumi.Input[builtins.bool] account_enabled: Whether or not the account should be enabled.
        :param pulumi.Input[builtins.str] age_group: The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] business_phones: A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        :param pulumi.Input[builtins.str] city: The city in which the user is located.
        :param pulumi.Input[builtins.str] company_name: The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        :param pulumi.Input[builtins.str] consent_provided_for_minor: Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        :param pulumi.Input[builtins.str] cost_center: The cost center associated with the user.
        :param pulumi.Input[builtins.str] country: The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        :param pulumi.Input[builtins.str] creation_type: Indicates whether the user account was created as a regular school or work account (`null`), an external account (`Invitation`), a local account for an Azure Active Directory B2C tenant (`LocalAccount`) or self-service sign-up using email verification (`EmailVerified`).
        :param pulumi.Input[builtins.str] department: The name for the department in which the user works.
        :param pulumi.Input[builtins.bool] disable_password_expiration: Whether the user's password is exempt from expiring. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_strong_password: Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        :param pulumi.Input[builtins.str] display_name: The name to display in the address book for the user.
        :param pulumi.Input[builtins.str] division: The name of the division in which the user works.
        :param pulumi.Input[builtins.str] employee_hire_date: The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        :param pulumi.Input[builtins.str] employee_id: The employee identifier assigned to the user by the organisation.
        :param pulumi.Input[builtins.str] employee_type: Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        :param pulumi.Input[builtins.str] external_user_state: For an external user invited to the tenant, this property represents the invited user's invitation status. Possible values are `PendingAcceptance` or `Accepted`.
        :param pulumi.Input[builtins.str] fax_number: The fax number of the user.
        :param pulumi.Input[builtins.bool] force_password_change: Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        :param pulumi.Input[builtins.str] given_name: The given name (first name) of the user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] im_addresses: A list of instant message voice over IP (VOIP) session initiation protocol (SIP) addresses for the user.
        :param pulumi.Input[builtins.str] job_title: The user’s job title.
        :param pulumi.Input[builtins.str] mail: The SMTP address for the user. This property cannot be unset once specified.
        :param pulumi.Input[builtins.str] mail_nickname: The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        :param pulumi.Input[builtins.str] manager_id: The object ID of the user's manager.
        :param pulumi.Input[builtins.str] mobile_phone: The primary cellular telephone number for the user.
        :param pulumi.Input[builtins.str] object_id: The object ID of the user.
        :param pulumi.Input[builtins.str] office_location: The office location in the user's place of business.
        :param pulumi.Input[builtins.str] onpremises_distinguished_name: The on-premises distinguished name (DN) of the user, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.str] onpremises_domain_name: The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.str] onpremises_immutable_id: The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        :param pulumi.Input[builtins.str] onpremises_sam_account_name: The on-premise SAM account name of the user.
        :param pulumi.Input[builtins.str] onpremises_security_identifier: The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[builtins.bool] onpremises_sync_enabled: Whether this user is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        :param pulumi.Input[builtins.str] onpremises_user_principal_name: The on-premise user principal name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] other_mails: A list of additional email addresses for the user.
        :param pulumi.Input[builtins.str] password: The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
               maximum length is 256 characters. This property is required when creating a new user
        :param pulumi.Input[builtins.str] postal_code: The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        :param pulumi.Input[builtins.str] preferred_language: The user's preferred language, in ISO 639-1 notation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] proxy_addresses: List of email addresses for the user that direct to the same mailbox.
        :param pulumi.Input[builtins.bool] show_in_address_list: Whether or not the Outlook global address list should include this user. Defaults to `true`.
        :param pulumi.Input[builtins.str] state: The state or province in the user's address.
        :param pulumi.Input[builtins.str] street_address: The street address of the user's place of business.
        :param pulumi.Input[builtins.str] surname: The user's surname (family name or last name).
        :param pulumi.Input[builtins.str] usage_location: The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        :param pulumi.Input[builtins.str] user_principal_name: The user principal name (UPN) of the user.
        :param pulumi.Input[builtins.str] user_type: The user type in the directory. Possible values are `Guest` or `Member`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["about_me"] = about_me
        __props__.__dict__["account_enabled"] = account_enabled
        __props__.__dict__["age_group"] = age_group
        __props__.__dict__["business_phones"] = business_phones
        __props__.__dict__["city"] = city
        __props__.__dict__["company_name"] = company_name
        __props__.__dict__["consent_provided_for_minor"] = consent_provided_for_minor
        __props__.__dict__["cost_center"] = cost_center
        __props__.__dict__["country"] = country
        __props__.__dict__["creation_type"] = creation_type
        __props__.__dict__["department"] = department
        __props__.__dict__["disable_password_expiration"] = disable_password_expiration
        __props__.__dict__["disable_strong_password"] = disable_strong_password
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["division"] = division
        __props__.__dict__["employee_hire_date"] = employee_hire_date
        __props__.__dict__["employee_id"] = employee_id
        __props__.__dict__["employee_type"] = employee_type
        __props__.__dict__["external_user_state"] = external_user_state
        __props__.__dict__["fax_number"] = fax_number
        __props__.__dict__["force_password_change"] = force_password_change
        __props__.__dict__["given_name"] = given_name
        __props__.__dict__["im_addresses"] = im_addresses
        __props__.__dict__["job_title"] = job_title
        __props__.__dict__["mail"] = mail
        __props__.__dict__["mail_nickname"] = mail_nickname
        __props__.__dict__["manager_id"] = manager_id
        __props__.__dict__["mobile_phone"] = mobile_phone
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["office_location"] = office_location
        __props__.__dict__["onpremises_distinguished_name"] = onpremises_distinguished_name
        __props__.__dict__["onpremises_domain_name"] = onpremises_domain_name
        __props__.__dict__["onpremises_immutable_id"] = onpremises_immutable_id
        __props__.__dict__["onpremises_sam_account_name"] = onpremises_sam_account_name
        __props__.__dict__["onpremises_security_identifier"] = onpremises_security_identifier
        __props__.__dict__["onpremises_sync_enabled"] = onpremises_sync_enabled
        __props__.__dict__["onpremises_user_principal_name"] = onpremises_user_principal_name
        __props__.__dict__["other_mails"] = other_mails
        __props__.__dict__["password"] = password
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["proxy_addresses"] = proxy_addresses
        __props__.__dict__["show_in_address_list"] = show_in_address_list
        __props__.__dict__["state"] = state
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["surname"] = surname
        __props__.__dict__["usage_location"] = usage_location
        __props__.__dict__["user_principal_name"] = user_principal_name
        __props__.__dict__["user_type"] = user_type
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aboutMe")
    def about_me(self) -> pulumi.Output[builtins.str]:
        """
        A freeform field for the user to describe themselves
        """
        return pulumi.get(self, "about_me")

    @property
    @pulumi.getter(name="accountEnabled")
    def account_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not the account should be enabled.
        """
        return pulumi.get(self, "account_enabled")

    @property
    @pulumi.getter(name="ageGroup")
    def age_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The age group of the user. Supported values are `Adult`, `NotAdult` and `Minor`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "age_group")

    @property
    @pulumi.getter(name="businessPhones")
    def business_phones(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect.
        """
        return pulumi.get(self, "business_phones")

    @property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The city in which the user is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The company name which the user is associated. This property can be useful for describing the company that an external user comes from.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="consentProvidedForMinor")
    def consent_provided_for_minor(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether consent has been obtained for minors. Supported values are `Granted`, `Denied` and `NotRequired`. Omit this property or specify a blank string to unset.
        """
        return pulumi.get(self, "consent_provided_for_minor")

    @property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The cost center associated with the user.
        """
        return pulumi.get(self, "cost_center")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The country/region in which the user is located. Examples include: `NO`, `JP`, and `GB`.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether the user account was created as a regular school or work account (`null`), an external account (`Invitation`), a local account for an Azure Active Directory B2C tenant (`LocalAccount`) or self-service sign-up using email verification (`EmailVerified`).
        """
        return pulumi.get(self, "creation_type")

    @property
    @pulumi.getter
    def department(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name for the department in which the user works.
        """
        return pulumi.get(self, "department")

    @property
    @pulumi.getter(name="disablePasswordExpiration")
    def disable_password_expiration(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the user's password is exempt from expiring. Defaults to `false`.
        """
        return pulumi.get(self, "disable_password_expiration")

    @property
    @pulumi.getter(name="disableStrongPassword")
    def disable_strong_password(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the user is allowed weaker passwords than the default policy to be specified. Defaults to `false`.
        """
        return pulumi.get(self, "disable_strong_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name to display in the address book for the user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def division(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the division in which the user works.
        """
        return pulumi.get(self, "division")

    @property
    @pulumi.getter(name="employeeHireDate")
    def employee_hire_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hire date of the user, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`).
        """
        return pulumi.get(self, "employee_hire_date")

    @property
    @pulumi.getter(name="employeeId")
    def employee_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The employee identifier assigned to the user by the organisation.
        """
        return pulumi.get(self, "employee_id")

    @property
    @pulumi.getter(name="employeeType")
    def employee_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
        """
        return pulumi.get(self, "employee_type")

    @property
    @pulumi.getter(name="externalUserState")
    def external_user_state(self) -> pulumi.Output[builtins.str]:
        """
        For an external user invited to the tenant, this property represents the invited user's invitation status. Possible values are `PendingAcceptance` or `Accepted`.
        """
        return pulumi.get(self, "external_user_state")

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The fax number of the user.
        """
        return pulumi.get(self, "fax_number")

    @property
    @pulumi.getter(name="forcePasswordChange")
    def force_password_change(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password. Defaults to `false`.
        """
        return pulumi.get(self, "force_password_change")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The given name (first name) of the user.
        """
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter(name="imAddresses")
    def im_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of instant message voice over IP (VOIP) session initiation protocol (SIP) addresses for the user.
        """
        return pulumi.get(self, "im_addresses")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user’s job title.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter
    def mail(self) -> pulumi.Output[builtins.str]:
        """
        The SMTP address for the user. This property cannot be unset once specified.
        """
        return pulumi.get(self, "mail")

    @property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> pulumi.Output[builtins.str]:
        """
        The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
        """
        return pulumi.get(self, "mail_nickname")

    @property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The object ID of the user's manager.
        """
        return pulumi.get(self, "manager_id")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The primary cellular telephone number for the user.
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[builtins.str]:
        """
        The object ID of the user.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="officeLocation")
    def office_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The office location in the user's place of business.
        """
        return pulumi.get(self, "office_location")

    @property
    @pulumi.getter(name="onpremisesDistinguishedName")
    def onpremises_distinguished_name(self) -> pulumi.Output[builtins.str]:
        """
        The on-premises distinguished name (DN) of the user, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_distinguished_name")

    @property
    @pulumi.getter(name="onpremisesDomainName")
    def onpremises_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_domain_name")

    @property
    @pulumi.getter(name="onpremisesImmutableId")
    def onpremises_immutable_id(self) -> pulumi.Output[builtins.str]:
        """
        The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account.
        """
        return pulumi.get(self, "onpremises_immutable_id")

    @property
    @pulumi.getter(name="onpremisesSamAccountName")
    def onpremises_sam_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The on-premise SAM account name of the user.
        """
        return pulumi.get(self, "onpremises_sam_account_name")

    @property
    @pulumi.getter(name="onpremisesSecurityIdentifier")
    def onpremises_security_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_security_identifier")

    @property
    @pulumi.getter(name="onpremisesSyncEnabled")
    def onpremises_sync_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this user is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        """
        return pulumi.get(self, "onpremises_sync_enabled")

    @property
    @pulumi.getter(name="onpremisesUserPrincipalName")
    def onpremises_user_principal_name(self) -> pulumi.Output[builtins.str]:
        """
        The on-premise user principal name of the user.
        """
        return pulumi.get(self, "onpremises_user_principal_name")

    @property
    @pulumi.getter(name="otherMails")
    def other_mails(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of additional email addresses for the user.
        """
        return pulumi.get(self, "other_mails")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password for the user. The password must satisfy minimum requirements as specified by the password policy. The
        maximum length is 256 characters. This property is required when creating a new user
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user's preferred language, in ISO 639-1 notation.
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="proxyAddresses")
    def proxy_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of email addresses for the user that direct to the same mailbox.
        """
        return pulumi.get(self, "proxy_addresses")

    @property
    @pulumi.getter(name="showInAddressList")
    def show_in_address_list(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not the Outlook global address list should include this user. Defaults to `true`.
        """
        return pulumi.get(self, "show_in_address_list")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state or province in the user's address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The street address of the user's place of business.
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def surname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user's surname (family name or last name).
        """
        return pulumi.get(self, "surname")

    @property
    @pulumi.getter(name="usageLocation")
    def usage_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
        """
        return pulumi.get(self, "usage_location")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> pulumi.Output[builtins.str]:
        """
        The user principal name (UPN) of the user.
        """
        return pulumi.get(self, "user_principal_name")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[builtins.str]:
        """
        The user type in the directory. Possible values are `Guest` or `Member`.
        """
        return pulumi.get(self, "user_type")

