# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### DataIntegration <a name="DataIntegration" id="@cdktf/provider-spotinst.DataIntegration"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration spotinst_data_integration}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.DataIntegration.Initializer"></a>

```typescript
import { DataIntegration } from '@cdktf/provider-spotinst'

new DataIntegration(scope: Construct, id: string, config: DataIntegrationConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.DataIntegrationConfig">DataIntegrationConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.DataIntegration.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.DataIntegrationConfig">DataIntegrationConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.putS3">putS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.resetS3">resetS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.resetStatus">resetStatus</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.DataIntegration.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.DataIntegration.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.DataIntegration.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.DataIntegration.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.DataIntegration.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.DataIntegration.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.DataIntegration.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.DataIntegration.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.DataIntegration.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.DataIntegration.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.DataIntegration.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.DataIntegration.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.DataIntegration.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.DataIntegration.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.DataIntegration.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.DataIntegration.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.DataIntegration.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putS3` <a name="putS3" id="@cdktf/provider-spotinst.DataIntegration.putS3"></a>

```typescript
public putS3(value: DataIntegrationS3): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.DataIntegration.putS3.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.DataIntegrationS3">DataIntegrationS3</a>

---

##### `resetS3` <a name="resetS3" id="@cdktf/provider-spotinst.DataIntegration.resetS3"></a>

```typescript
public resetS3(): void
```

##### `resetStatus` <a name="resetStatus" id="@cdktf/provider-spotinst.DataIntegration.resetStatus"></a>

```typescript
public resetStatus(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.DataIntegration.isConstruct"></a>

```typescript
import { DataIntegration } from '@cdktf/provider-spotinst'

DataIntegration.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.DataIntegration.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-spotinst.DataIntegrationS3OutputReference">DataIntegrationS3OutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.s3Input">s3Input</a></code> | <code><a href="#@cdktf/provider-spotinst.DataIntegrationS3">DataIntegrationS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.statusInput">statusInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.status">status</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.DataIntegration.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.DataIntegration.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.DataIntegration.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.DataIntegration.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.DataIntegration.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.DataIntegration.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.DataIntegration.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.DataIntegration.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.DataIntegration.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.DataIntegration.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.DataIntegration.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.DataIntegration.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `s3`<sup>Required</sup> <a name="s3" id="@cdktf/provider-spotinst.DataIntegration.property.s3"></a>

```typescript
public readonly s3: DataIntegrationS3OutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.DataIntegrationS3OutputReference">DataIntegrationS3OutputReference</a>

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.DataIntegration.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `s3Input`<sup>Optional</sup> <a name="s3Input" id="@cdktf/provider-spotinst.DataIntegration.property.s3Input"></a>

```typescript
public readonly s3Input: DataIntegrationS3;
```

- *Type:* <a href="#@cdktf/provider-spotinst.DataIntegrationS3">DataIntegrationS3</a>

---

##### `statusInput`<sup>Optional</sup> <a name="statusInput" id="@cdktf/provider-spotinst.DataIntegration.property.statusInput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.DataIntegration.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `status`<sup>Required</sup> <a name="status" id="@cdktf/provider-spotinst.DataIntegration.property.status"></a>

```typescript
public readonly status: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.DataIntegration.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.DataIntegration.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupAws <a name="ElastigroupAws" id="@cdktf/provider-spotinst.ElastigroupAws"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws spotinst_elastigroup_aws}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupAws.Initializer"></a>

```typescript
import { ElastigroupAws } from '@cdktf/provider-spotinst'

new ElastigroupAws(scope: Construct, id: string, config: ElastigroupAwsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsConfig">ElastigroupAwsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupAws.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsConfig">ElastigroupAwsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putCpuOptions">putCpuOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationBeanstalk">putIntegrationBeanstalk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationCodedeploy">putIntegrationCodedeploy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationDockerSwarm">putIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationEcs">putIntegrationEcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationGitlab">putIntegrationGitlab</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationKubernetes">putIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMesosphere">putIntegrationMesosphere</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMultaiRuntime">putIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationNomad">putIntegrationNomad</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRancher">putIntegrationRancher</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRoute53">putIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putMetadataOptions">putMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putMultipleMetrics">putMultipleMetrics</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putRevertToSpot">putRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putStatefulDeallocation">putStatefulDeallocation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.putUpdatePolicy">putUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetAvailabilityZones">resetAvailabilityZones</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetBlockDevicesMode">resetBlockDevicesMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetCapacityUnit">resetCapacityUnit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetCpuCredits">resetCpuCredits</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetCpuOptions">resetCpuOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetDesiredCapacity">resetDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetEbsBlockDevice">resetEbsBlockDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetEbsOptimized">resetEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetElasticIps">resetElasticIps</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetElasticLoadBalancers">resetElasticLoadBalancers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetEnableMonitoring">resetEnableMonitoring</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetEphemeralBlockDevice">resetEphemeralBlockDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckGracePeriod">resetHealthCheckGracePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckType">resetHealthCheckType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckUnhealthyDurationBeforeReplacement">resetHealthCheckUnhealthyDurationBeforeReplacement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetImageId">resetImageId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetInstanceTypesPreferredSpot">resetInstanceTypesPreferredSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetInstanceTypesWeights">resetInstanceTypesWeights</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationBeanstalk">resetIntegrationBeanstalk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationCodedeploy">resetIntegrationCodedeploy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationDockerSwarm">resetIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationEcs">resetIntegrationEcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationGitlab">resetIntegrationGitlab</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationKubernetes">resetIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationMesosphere">resetIntegrationMesosphere</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationMultaiRuntime">resetIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationNomad">resetIntegrationNomad</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationRancher">resetIntegrationRancher</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationRoute53">resetIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetItf">resetItf</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetKeyName">resetKeyName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetLifetimePeriod">resetLifetimePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMetadataOptions">resetMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMinimumInstanceLifetime">resetMinimumInstanceLifetime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMultaiTargetSets">resetMultaiTargetSets</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetMultipleMetrics">resetMultipleMetrics</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetNetworkInterface">resetNetworkInterface</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetOndemandCount">resetOndemandCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPersistBlockDevices">resetPersistBlockDevices</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPersistPrivateIp">resetPersistPrivateIp</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPersistRootDevice">resetPersistRootDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPlacementTenancy">resetPlacementTenancy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPreferredAvailabilityZones">resetPreferredAvailabilityZones</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetPrivateIps">resetPrivateIps</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetRegion">resetRegion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetResourceTagSpecification">resetResourceTagSpecification</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetRevertToSpot">resetRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetScalingDownPolicy">resetScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetScalingStrategy">resetScalingStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetScalingTargetPolicy">resetScalingTargetPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetScalingUpPolicy">resetScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetShutdownScript">resetShutdownScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetSignal">resetSignal</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetSpotPercentage">resetSpotPercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetStatefulDeallocation">resetStatefulDeallocation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetStatefulInstanceAction">resetStatefulInstanceAction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetSubnetIds">resetSubnetIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetTargetGroupArns">resetTargetGroupArns</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetUpdatePolicy">resetUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetUserData">resetUserData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetUtilizeCommitments">resetUtilizeCommitments</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetUtilizeReservedInstances">resetUtilizeReservedInstances</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetWaitForCapacity">resetWaitForCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.resetWaitForCapacityTimeout">resetWaitForCapacityTimeout</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupAws.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupAws.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupAws.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAws.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupAws.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAws.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupAws.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupAws.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAws.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putCpuOptions` <a name="putCpuOptions" id="@cdktf/provider-spotinst.ElastigroupAws.putCpuOptions"></a>

```typescript
public putCpuOptions(value: ElastigroupAwsCpuOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putCpuOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsCpuOptions">ElastigroupAwsCpuOptions</a>

---

##### `putIntegrationBeanstalk` <a name="putIntegrationBeanstalk" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationBeanstalk"></a>

```typescript
public putIntegrationBeanstalk(value: ElastigroupAwsIntegrationBeanstalk): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationBeanstalk.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalk">ElastigroupAwsIntegrationBeanstalk</a>

---

##### `putIntegrationCodedeploy` <a name="putIntegrationCodedeploy" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationCodedeploy"></a>

```typescript
public putIntegrationCodedeploy(value: ElastigroupAwsIntegrationCodedeploy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationCodedeploy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeploy">ElastigroupAwsIntegrationCodedeploy</a>

---

##### `putIntegrationDockerSwarm` <a name="putIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationDockerSwarm"></a>

```typescript
public putIntegrationDockerSwarm(value: ElastigroupAwsIntegrationDockerSwarm): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationDockerSwarm.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarm">ElastigroupAwsIntegrationDockerSwarm</a>

---

##### `putIntegrationEcs` <a name="putIntegrationEcs" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationEcs"></a>

```typescript
public putIntegrationEcs(value: ElastigroupAwsIntegrationEcs): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationEcs.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcs">ElastigroupAwsIntegrationEcs</a>

---

##### `putIntegrationGitlab` <a name="putIntegrationGitlab" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationGitlab"></a>

```typescript
public putIntegrationGitlab(value: ElastigroupAwsIntegrationGitlab): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationGitlab.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlab">ElastigroupAwsIntegrationGitlab</a>

---

##### `putIntegrationKubernetes` <a name="putIntegrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationKubernetes"></a>

```typescript
public putIntegrationKubernetes(value: ElastigroupAwsIntegrationKubernetes): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationKubernetes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetes">ElastigroupAwsIntegrationKubernetes</a>

---

##### `putIntegrationMesosphere` <a name="putIntegrationMesosphere" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMesosphere"></a>

```typescript
public putIntegrationMesosphere(value: ElastigroupAwsIntegrationMesosphere): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMesosphere.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphere">ElastigroupAwsIntegrationMesosphere</a>

---

##### `putIntegrationMultaiRuntime` <a name="putIntegrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMultaiRuntime"></a>

```typescript
public putIntegrationMultaiRuntime(value: ElastigroupAwsIntegrationMultaiRuntime): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationMultaiRuntime.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntime">ElastigroupAwsIntegrationMultaiRuntime</a>

---

##### `putIntegrationNomad` <a name="putIntegrationNomad" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationNomad"></a>

```typescript
public putIntegrationNomad(value: ElastigroupAwsIntegrationNomad): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationNomad.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomad">ElastigroupAwsIntegrationNomad</a>

---

##### `putIntegrationRancher` <a name="putIntegrationRancher" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRancher"></a>

```typescript
public putIntegrationRancher(value: ElastigroupAwsIntegrationRancher): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRancher.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancher">ElastigroupAwsIntegrationRancher</a>

---

##### `putIntegrationRoute53` <a name="putIntegrationRoute53" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRoute53"></a>

```typescript
public putIntegrationRoute53(value: ElastigroupAwsIntegrationRoute53): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putIntegrationRoute53.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53">ElastigroupAwsIntegrationRoute53</a>

---

##### `putMetadataOptions` <a name="putMetadataOptions" id="@cdktf/provider-spotinst.ElastigroupAws.putMetadataOptions"></a>

```typescript
public putMetadataOptions(value: ElastigroupAwsMetadataOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putMetadataOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMetadataOptions">ElastigroupAwsMetadataOptions</a>

---

##### `putMultipleMetrics` <a name="putMultipleMetrics" id="@cdktf/provider-spotinst.ElastigroupAws.putMultipleMetrics"></a>

```typescript
public putMultipleMetrics(value: ElastigroupAwsMultipleMetrics): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putMultipleMetrics.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultipleMetrics">ElastigroupAwsMultipleMetrics</a>

---

##### `putRevertToSpot` <a name="putRevertToSpot" id="@cdktf/provider-spotinst.ElastigroupAws.putRevertToSpot"></a>

```typescript
public putRevertToSpot(value: ElastigroupAwsRevertToSpot): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putRevertToSpot.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsRevertToSpot">ElastigroupAwsRevertToSpot</a>

---

##### `putStatefulDeallocation` <a name="putStatefulDeallocation" id="@cdktf/provider-spotinst.ElastigroupAws.putStatefulDeallocation"></a>

```typescript
public putStatefulDeallocation(value: ElastigroupAwsStatefulDeallocation): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putStatefulDeallocation.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocation">ElastigroupAwsStatefulDeallocation</a>

---

##### `putUpdatePolicy` <a name="putUpdatePolicy" id="@cdktf/provider-spotinst.ElastigroupAws.putUpdatePolicy"></a>

```typescript
public putUpdatePolicy(value: ElastigroupAwsUpdatePolicy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAws.putUpdatePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicy">ElastigroupAwsUpdatePolicy</a>

---

##### `resetAvailabilityZones` <a name="resetAvailabilityZones" id="@cdktf/provider-spotinst.ElastigroupAws.resetAvailabilityZones"></a>

```typescript
public resetAvailabilityZones(): void
```

##### `resetBlockDevicesMode` <a name="resetBlockDevicesMode" id="@cdktf/provider-spotinst.ElastigroupAws.resetBlockDevicesMode"></a>

```typescript
public resetBlockDevicesMode(): void
```

##### `resetCapacityUnit` <a name="resetCapacityUnit" id="@cdktf/provider-spotinst.ElastigroupAws.resetCapacityUnit"></a>

```typescript
public resetCapacityUnit(): void
```

##### `resetCpuCredits` <a name="resetCpuCredits" id="@cdktf/provider-spotinst.ElastigroupAws.resetCpuCredits"></a>

```typescript
public resetCpuCredits(): void
```

##### `resetCpuOptions` <a name="resetCpuOptions" id="@cdktf/provider-spotinst.ElastigroupAws.resetCpuOptions"></a>

```typescript
public resetCpuOptions(): void
```

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-spotinst.ElastigroupAws.resetDescription"></a>

```typescript
public resetDescription(): void
```

##### `resetDesiredCapacity` <a name="resetDesiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAws.resetDesiredCapacity"></a>

```typescript
public resetDesiredCapacity(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.ElastigroupAws.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetEbsBlockDevice` <a name="resetEbsBlockDevice" id="@cdktf/provider-spotinst.ElastigroupAws.resetEbsBlockDevice"></a>

```typescript
public resetEbsBlockDevice(): void
```

##### `resetEbsOptimized` <a name="resetEbsOptimized" id="@cdktf/provider-spotinst.ElastigroupAws.resetEbsOptimized"></a>

```typescript
public resetEbsOptimized(): void
```

##### `resetElasticIps` <a name="resetElasticIps" id="@cdktf/provider-spotinst.ElastigroupAws.resetElasticIps"></a>

```typescript
public resetElasticIps(): void
```

##### `resetElasticLoadBalancers` <a name="resetElasticLoadBalancers" id="@cdktf/provider-spotinst.ElastigroupAws.resetElasticLoadBalancers"></a>

```typescript
public resetElasticLoadBalancers(): void
```

##### `resetEnableMonitoring` <a name="resetEnableMonitoring" id="@cdktf/provider-spotinst.ElastigroupAws.resetEnableMonitoring"></a>

```typescript
public resetEnableMonitoring(): void
```

##### `resetEphemeralBlockDevice` <a name="resetEphemeralBlockDevice" id="@cdktf/provider-spotinst.ElastigroupAws.resetEphemeralBlockDevice"></a>

```typescript
public resetEphemeralBlockDevice(): void
```

##### `resetHealthCheckGracePeriod` <a name="resetHealthCheckGracePeriod" id="@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckGracePeriod"></a>

```typescript
public resetHealthCheckGracePeriod(): void
```

##### `resetHealthCheckType` <a name="resetHealthCheckType" id="@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckType"></a>

```typescript
public resetHealthCheckType(): void
```

##### `resetHealthCheckUnhealthyDurationBeforeReplacement` <a name="resetHealthCheckUnhealthyDurationBeforeReplacement" id="@cdktf/provider-spotinst.ElastigroupAws.resetHealthCheckUnhealthyDurationBeforeReplacement"></a>

```typescript
public resetHealthCheckUnhealthyDurationBeforeReplacement(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.ElastigroupAws.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetImageId` <a name="resetImageId" id="@cdktf/provider-spotinst.ElastigroupAws.resetImageId"></a>

```typescript
public resetImageId(): void
```

##### `resetInstanceTypesPreferredSpot` <a name="resetInstanceTypesPreferredSpot" id="@cdktf/provider-spotinst.ElastigroupAws.resetInstanceTypesPreferredSpot"></a>

```typescript
public resetInstanceTypesPreferredSpot(): void
```

##### `resetInstanceTypesWeights` <a name="resetInstanceTypesWeights" id="@cdktf/provider-spotinst.ElastigroupAws.resetInstanceTypesWeights"></a>

```typescript
public resetInstanceTypesWeights(): void
```

##### `resetIntegrationBeanstalk` <a name="resetIntegrationBeanstalk" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationBeanstalk"></a>

```typescript
public resetIntegrationBeanstalk(): void
```

##### `resetIntegrationCodedeploy` <a name="resetIntegrationCodedeploy" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationCodedeploy"></a>

```typescript
public resetIntegrationCodedeploy(): void
```

##### `resetIntegrationDockerSwarm` <a name="resetIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationDockerSwarm"></a>

```typescript
public resetIntegrationDockerSwarm(): void
```

##### `resetIntegrationEcs` <a name="resetIntegrationEcs" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationEcs"></a>

```typescript
public resetIntegrationEcs(): void
```

##### `resetIntegrationGitlab` <a name="resetIntegrationGitlab" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationGitlab"></a>

```typescript
public resetIntegrationGitlab(): void
```

##### `resetIntegrationKubernetes` <a name="resetIntegrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationKubernetes"></a>

```typescript
public resetIntegrationKubernetes(): void
```

##### `resetIntegrationMesosphere` <a name="resetIntegrationMesosphere" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationMesosphere"></a>

```typescript
public resetIntegrationMesosphere(): void
```

##### `resetIntegrationMultaiRuntime` <a name="resetIntegrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationMultaiRuntime"></a>

```typescript
public resetIntegrationMultaiRuntime(): void
```

##### `resetIntegrationNomad` <a name="resetIntegrationNomad" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationNomad"></a>

```typescript
public resetIntegrationNomad(): void
```

##### `resetIntegrationRancher` <a name="resetIntegrationRancher" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationRancher"></a>

```typescript
public resetIntegrationRancher(): void
```

##### `resetIntegrationRoute53` <a name="resetIntegrationRoute53" id="@cdktf/provider-spotinst.ElastigroupAws.resetIntegrationRoute53"></a>

```typescript
public resetIntegrationRoute53(): void
```

##### `resetItf` <a name="resetItf" id="@cdktf/provider-spotinst.ElastigroupAws.resetItf"></a>

```typescript
public resetItf(): void
```

##### `resetKeyName` <a name="resetKeyName" id="@cdktf/provider-spotinst.ElastigroupAws.resetKeyName"></a>

```typescript
public resetKeyName(): void
```

##### `resetLifetimePeriod` <a name="resetLifetimePeriod" id="@cdktf/provider-spotinst.ElastigroupAws.resetLifetimePeriod"></a>

```typescript
public resetLifetimePeriod(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.ElastigroupAws.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMetadataOptions` <a name="resetMetadataOptions" id="@cdktf/provider-spotinst.ElastigroupAws.resetMetadataOptions"></a>

```typescript
public resetMetadataOptions(): void
```

##### `resetMinimumInstanceLifetime` <a name="resetMinimumInstanceLifetime" id="@cdktf/provider-spotinst.ElastigroupAws.resetMinimumInstanceLifetime"></a>

```typescript
public resetMinimumInstanceLifetime(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.ElastigroupAws.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetMultaiTargetSets` <a name="resetMultaiTargetSets" id="@cdktf/provider-spotinst.ElastigroupAws.resetMultaiTargetSets"></a>

```typescript
public resetMultaiTargetSets(): void
```

##### `resetMultipleMetrics` <a name="resetMultipleMetrics" id="@cdktf/provider-spotinst.ElastigroupAws.resetMultipleMetrics"></a>

```typescript
public resetMultipleMetrics(): void
```

##### `resetNetworkInterface` <a name="resetNetworkInterface" id="@cdktf/provider-spotinst.ElastigroupAws.resetNetworkInterface"></a>

```typescript
public resetNetworkInterface(): void
```

##### `resetOndemandCount` <a name="resetOndemandCount" id="@cdktf/provider-spotinst.ElastigroupAws.resetOndemandCount"></a>

```typescript
public resetOndemandCount(): void
```

##### `resetPersistBlockDevices` <a name="resetPersistBlockDevices" id="@cdktf/provider-spotinst.ElastigroupAws.resetPersistBlockDevices"></a>

```typescript
public resetPersistBlockDevices(): void
```

##### `resetPersistPrivateIp` <a name="resetPersistPrivateIp" id="@cdktf/provider-spotinst.ElastigroupAws.resetPersistPrivateIp"></a>

```typescript
public resetPersistPrivateIp(): void
```

##### `resetPersistRootDevice` <a name="resetPersistRootDevice" id="@cdktf/provider-spotinst.ElastigroupAws.resetPersistRootDevice"></a>

```typescript
public resetPersistRootDevice(): void
```

##### `resetPlacementTenancy` <a name="resetPlacementTenancy" id="@cdktf/provider-spotinst.ElastigroupAws.resetPlacementTenancy"></a>

```typescript
public resetPlacementTenancy(): void
```

##### `resetPreferredAvailabilityZones` <a name="resetPreferredAvailabilityZones" id="@cdktf/provider-spotinst.ElastigroupAws.resetPreferredAvailabilityZones"></a>

```typescript
public resetPreferredAvailabilityZones(): void
```

##### `resetPrivateIps` <a name="resetPrivateIps" id="@cdktf/provider-spotinst.ElastigroupAws.resetPrivateIps"></a>

```typescript
public resetPrivateIps(): void
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-spotinst.ElastigroupAws.resetRegion"></a>

```typescript
public resetRegion(): void
```

##### `resetResourceTagSpecification` <a name="resetResourceTagSpecification" id="@cdktf/provider-spotinst.ElastigroupAws.resetResourceTagSpecification"></a>

```typescript
public resetResourceTagSpecification(): void
```

##### `resetRevertToSpot` <a name="resetRevertToSpot" id="@cdktf/provider-spotinst.ElastigroupAws.resetRevertToSpot"></a>

```typescript
public resetRevertToSpot(): void
```

##### `resetScalingDownPolicy` <a name="resetScalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.resetScalingDownPolicy"></a>

```typescript
public resetScalingDownPolicy(): void
```

##### `resetScalingStrategy` <a name="resetScalingStrategy" id="@cdktf/provider-spotinst.ElastigroupAws.resetScalingStrategy"></a>

```typescript
public resetScalingStrategy(): void
```

##### `resetScalingTargetPolicy` <a name="resetScalingTargetPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.resetScalingTargetPolicy"></a>

```typescript
public resetScalingTargetPolicy(): void
```

##### `resetScalingUpPolicy` <a name="resetScalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.resetScalingUpPolicy"></a>

```typescript
public resetScalingUpPolicy(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.ElastigroupAws.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetShutdownScript` <a name="resetShutdownScript" id="@cdktf/provider-spotinst.ElastigroupAws.resetShutdownScript"></a>

```typescript
public resetShutdownScript(): void
```

##### `resetSignal` <a name="resetSignal" id="@cdktf/provider-spotinst.ElastigroupAws.resetSignal"></a>

```typescript
public resetSignal(): void
```

##### `resetSpotPercentage` <a name="resetSpotPercentage" id="@cdktf/provider-spotinst.ElastigroupAws.resetSpotPercentage"></a>

```typescript
public resetSpotPercentage(): void
```

##### `resetStatefulDeallocation` <a name="resetStatefulDeallocation" id="@cdktf/provider-spotinst.ElastigroupAws.resetStatefulDeallocation"></a>

```typescript
public resetStatefulDeallocation(): void
```

##### `resetStatefulInstanceAction` <a name="resetStatefulInstanceAction" id="@cdktf/provider-spotinst.ElastigroupAws.resetStatefulInstanceAction"></a>

```typescript
public resetStatefulInstanceAction(): void
```

##### `resetSubnetIds` <a name="resetSubnetIds" id="@cdktf/provider-spotinst.ElastigroupAws.resetSubnetIds"></a>

```typescript
public resetSubnetIds(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.ElastigroupAws.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetTargetGroupArns` <a name="resetTargetGroupArns" id="@cdktf/provider-spotinst.ElastigroupAws.resetTargetGroupArns"></a>

```typescript
public resetTargetGroupArns(): void
```

##### `resetUpdatePolicy` <a name="resetUpdatePolicy" id="@cdktf/provider-spotinst.ElastigroupAws.resetUpdatePolicy"></a>

```typescript
public resetUpdatePolicy(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.ElastigroupAws.resetUserData"></a>

```typescript
public resetUserData(): void
```

##### `resetUtilizeCommitments` <a name="resetUtilizeCommitments" id="@cdktf/provider-spotinst.ElastigroupAws.resetUtilizeCommitments"></a>

```typescript
public resetUtilizeCommitments(): void
```

##### `resetUtilizeReservedInstances` <a name="resetUtilizeReservedInstances" id="@cdktf/provider-spotinst.ElastigroupAws.resetUtilizeReservedInstances"></a>

```typescript
public resetUtilizeReservedInstances(): void
```

##### `resetWaitForCapacity` <a name="resetWaitForCapacity" id="@cdktf/provider-spotinst.ElastigroupAws.resetWaitForCapacity"></a>

```typescript
public resetWaitForCapacity(): void
```

##### `resetWaitForCapacityTimeout` <a name="resetWaitForCapacityTimeout" id="@cdktf/provider-spotinst.ElastigroupAws.resetWaitForCapacityTimeout"></a>

```typescript
public resetWaitForCapacityTimeout(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupAws.isConstruct"></a>

```typescript
import { ElastigroupAws } from '@cdktf/provider-spotinst'

ElastigroupAws.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupAws.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.cpuOptions">cpuOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsCpuOptionsOutputReference">ElastigroupAwsCpuOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationBeanstalk">integrationBeanstalk</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkOutputReference">ElastigroupAwsIntegrationBeanstalkOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationCodedeploy">integrationCodedeploy</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeployOutputReference">ElastigroupAwsIntegrationCodedeployOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationDockerSwarm">integrationDockerSwarm</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmOutputReference">ElastigroupAwsIntegrationDockerSwarmOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationEcs">integrationEcs</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsOutputReference">ElastigroupAwsIntegrationEcsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationGitlab">integrationGitlab</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlabOutputReference">ElastigroupAwsIntegrationGitlabOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationKubernetes">integrationKubernetes</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesOutputReference">ElastigroupAwsIntegrationKubernetesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationMesosphere">integrationMesosphere</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphereOutputReference">ElastigroupAwsIntegrationMesosphereOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationMultaiRuntime">integrationMultaiRuntime</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntimeOutputReference">ElastigroupAwsIntegrationMultaiRuntimeOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationNomad">integrationNomad</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadOutputReference">ElastigroupAwsIntegrationNomadOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationRancher">integrationRancher</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancherOutputReference">ElastigroupAwsIntegrationRancherOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationRoute53">integrationRoute53</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53OutputReference">ElastigroupAwsIntegrationRoute53OutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.metadataOptions">metadataOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsMetadataOptionsOutputReference">ElastigroupAwsMetadataOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.multipleMetrics">multipleMetrics</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsOutputReference">ElastigroupAwsMultipleMetricsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.revertToSpot">revertToSpot</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsRevertToSpotOutputReference">ElastigroupAwsRevertToSpotOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.statefulDeallocation">statefulDeallocation</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocationOutputReference">ElastigroupAwsStatefulDeallocationOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.updatePolicy">updatePolicy</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyOutputReference">ElastigroupAwsUpdatePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.availabilityZonesInput">availabilityZonesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.blockDevicesModeInput">blockDevicesModeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.capacityUnitInput">capacityUnitInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.cpuCreditsInput">cpuCreditsInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.cpuOptionsInput">cpuOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsCpuOptions">ElastigroupAwsCpuOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.descriptionInput">descriptionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ebsBlockDeviceInput">ebsBlockDeviceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsEbsBlockDevice">ElastigroupAwsEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ebsOptimizedInput">ebsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.elasticIpsInput">elasticIpsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.elasticLoadBalancersInput">elasticLoadBalancersInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.enableMonitoringInput">enableMonitoringInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ephemeralBlockDeviceInput">ephemeralBlockDeviceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsEphemeralBlockDevice">ElastigroupAwsEphemeralBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.fallbackToOndemandInput">fallbackToOndemandInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckGracePeriodInput">healthCheckGracePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckTypeInput">healthCheckTypeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckUnhealthyDurationBeforeReplacementInput">healthCheckUnhealthyDurationBeforeReplacementInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesOndemandInput">instanceTypesOndemandInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesPreferredSpotInput">instanceTypesPreferredSpotInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesSpotInput">instanceTypesSpotInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesWeightsInput">instanceTypesWeightsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsInstanceTypesWeights">ElastigroupAwsInstanceTypesWeights</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationBeanstalkInput">integrationBeanstalkInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalk">ElastigroupAwsIntegrationBeanstalk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationCodedeployInput">integrationCodedeployInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeploy">ElastigroupAwsIntegrationCodedeploy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationDockerSwarmInput">integrationDockerSwarmInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarm">ElastigroupAwsIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationEcsInput">integrationEcsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcs">ElastigroupAwsIntegrationEcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationGitlabInput">integrationGitlabInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlab">ElastigroupAwsIntegrationGitlab</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationKubernetesInput">integrationKubernetesInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetes">ElastigroupAwsIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationMesosphereInput">integrationMesosphereInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphere">ElastigroupAwsIntegrationMesosphere</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationMultaiRuntimeInput">integrationMultaiRuntimeInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntime">ElastigroupAwsIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationNomadInput">integrationNomadInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomad">ElastigroupAwsIntegrationNomad</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationRancherInput">integrationRancherInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancher">ElastigroupAwsIntegrationRancher</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.integrationRoute53Input">integrationRoute53Input</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53">ElastigroupAwsIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.itfInput">itfInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsItf">ElastigroupAwsItf</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.keyNameInput">keyNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.lifetimePeriodInput">lifetimePeriodInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.metadataOptionsInput">metadataOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsMetadataOptions">ElastigroupAwsMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.minimumInstanceLifetimeInput">minimumInstanceLifetimeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.multaiTargetSetsInput">multaiTargetSetsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultaiTargetSets">ElastigroupAwsMultaiTargetSets</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.multipleMetricsInput">multipleMetricsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsMultipleMetrics">ElastigroupAwsMultipleMetrics</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.networkInterfaceInput">networkInterfaceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsNetworkInterface">ElastigroupAwsNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ondemandCountInput">ondemandCountInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.orientationInput">orientationInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistBlockDevicesInput">persistBlockDevicesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistPrivateIpInput">persistPrivateIpInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistRootDeviceInput">persistRootDeviceInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.placementTenancyInput">placementTenancyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.preferredAvailabilityZonesInput">preferredAvailabilityZonesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.privateIpsInput">privateIpsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.productInput">productInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.resourceTagSpecificationInput">resourceTagSpecificationInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsResourceTagSpecification">ElastigroupAwsResourceTagSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.revertToSpotInput">revertToSpotInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsRevertToSpot">ElastigroupAwsRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingDownPolicyInput">scalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicy">ElastigroupAwsScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingStrategyInput">scalingStrategyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingStrategy">ElastigroupAwsScalingStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingTargetPolicyInput">scalingTargetPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicy">ElastigroupAwsScalingTargetPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingUpPolicyInput">scalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicy">ElastigroupAwsScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScheduledTask">ElastigroupAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.securityGroupsInput">securityGroupsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.shutdownScriptInput">shutdownScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.signalInput">signalInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsSignal">ElastigroupAwsSignal</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.spotPercentageInput">spotPercentageInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.statefulDeallocationInput">statefulDeallocationInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocation">ElastigroupAwsStatefulDeallocation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.statefulInstanceActionInput">statefulInstanceActionInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulInstanceAction">ElastigroupAwsStatefulInstanceAction</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.subnetIdsInput">subnetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsTags">ElastigroupAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.targetGroupArnsInput">targetGroupArnsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.updatePolicyInput">updatePolicyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicy">ElastigroupAwsUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.utilizeCommitmentsInput">utilizeCommitmentsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.utilizeReservedInstancesInput">utilizeReservedInstancesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityInput">waitForCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityTimeoutInput">waitForCapacityTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.availabilityZones">availabilityZones</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.blockDevicesMode">blockDevicesMode</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.capacityUnit">capacityUnit</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.cpuCredits">cpuCredits</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ebsBlockDevice">ebsBlockDevice</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsEbsBlockDevice">ElastigroupAwsEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ebsOptimized">ebsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.elasticIps">elasticIps</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.elasticLoadBalancers">elasticLoadBalancers</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.enableMonitoring">enableMonitoring</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ephemeralBlockDevice">ephemeralBlockDevice</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsEphemeralBlockDevice">ElastigroupAwsEphemeralBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.fallbackToOndemand">fallbackToOndemand</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckGracePeriod">healthCheckGracePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckType">healthCheckType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckUnhealthyDurationBeforeReplacement">healthCheckUnhealthyDurationBeforeReplacement</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.iamInstanceProfile">iamInstanceProfile</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.imageId">imageId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesOndemand">instanceTypesOndemand</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesPreferredSpot">instanceTypesPreferredSpot</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesSpot">instanceTypesSpot</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesWeights">instanceTypesWeights</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsInstanceTypesWeights">ElastigroupAwsInstanceTypesWeights</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.itf">itf</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsItf">ElastigroupAwsItf</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.keyName">keyName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.lifetimePeriod">lifetimePeriod</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.minimumInstanceLifetime">minimumInstanceLifetime</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.multaiTargetSets">multaiTargetSets</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultaiTargetSets">ElastigroupAwsMultaiTargetSets</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.networkInterface">networkInterface</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsNetworkInterface">ElastigroupAwsNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.ondemandCount">ondemandCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.orientation">orientation</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistBlockDevices">persistBlockDevices</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistPrivateIp">persistPrivateIp</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.persistRootDevice">persistRootDevice</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.placementTenancy">placementTenancy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.preferredAvailabilityZones">preferredAvailabilityZones</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.privateIps">privateIps</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.product">product</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.resourceTagSpecification">resourceTagSpecification</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsResourceTagSpecification">ElastigroupAwsResourceTagSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingDownPolicy">scalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicy">ElastigroupAwsScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingStrategy">scalingStrategy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingStrategy">ElastigroupAwsScalingStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingTargetPolicy">scalingTargetPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicy">ElastigroupAwsScalingTargetPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scalingUpPolicy">scalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicy">ElastigroupAwsScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsScheduledTask">ElastigroupAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.securityGroups">securityGroups</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.shutdownScript">shutdownScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.signal">signal</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsSignal">ElastigroupAwsSignal</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.spotPercentage">spotPercentage</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.statefulInstanceAction">statefulInstanceAction</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulInstanceAction">ElastigroupAwsStatefulInstanceAction</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.subnetIds">subnetIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsTags">ElastigroupAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.targetGroupArns">targetGroupArns</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.userData">userData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.utilizeCommitments">utilizeCommitments</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.utilizeReservedInstances">utilizeReservedInstances</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacity">waitForCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityTimeout">waitForCapacityTimeout</a></code> | <code>number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupAws.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupAws.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupAws.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupAws.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupAws.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupAws.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupAws.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupAws.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupAws.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupAws.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupAws.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `cpuOptions`<sup>Required</sup> <a name="cpuOptions" id="@cdktf/provider-spotinst.ElastigroupAws.property.cpuOptions"></a>

```typescript
public readonly cpuOptions: ElastigroupAwsCpuOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsCpuOptionsOutputReference">ElastigroupAwsCpuOptionsOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAws.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `integrationBeanstalk`<sup>Required</sup> <a name="integrationBeanstalk" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationBeanstalk"></a>

```typescript
public readonly integrationBeanstalk: ElastigroupAwsIntegrationBeanstalkOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkOutputReference">ElastigroupAwsIntegrationBeanstalkOutputReference</a>

---

##### `integrationCodedeploy`<sup>Required</sup> <a name="integrationCodedeploy" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationCodedeploy"></a>

```typescript
public readonly integrationCodedeploy: ElastigroupAwsIntegrationCodedeployOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeployOutputReference">ElastigroupAwsIntegrationCodedeployOutputReference</a>

---

##### `integrationDockerSwarm`<sup>Required</sup> <a name="integrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationDockerSwarm"></a>

```typescript
public readonly integrationDockerSwarm: ElastigroupAwsIntegrationDockerSwarmOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmOutputReference">ElastigroupAwsIntegrationDockerSwarmOutputReference</a>

---

##### `integrationEcs`<sup>Required</sup> <a name="integrationEcs" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationEcs"></a>

```typescript
public readonly integrationEcs: ElastigroupAwsIntegrationEcsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsOutputReference">ElastigroupAwsIntegrationEcsOutputReference</a>

---

##### `integrationGitlab`<sup>Required</sup> <a name="integrationGitlab" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationGitlab"></a>

```typescript
public readonly integrationGitlab: ElastigroupAwsIntegrationGitlabOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlabOutputReference">ElastigroupAwsIntegrationGitlabOutputReference</a>

---

##### `integrationKubernetes`<sup>Required</sup> <a name="integrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationKubernetes"></a>

```typescript
public readonly integrationKubernetes: ElastigroupAwsIntegrationKubernetesOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesOutputReference">ElastigroupAwsIntegrationKubernetesOutputReference</a>

---

##### `integrationMesosphere`<sup>Required</sup> <a name="integrationMesosphere" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationMesosphere"></a>

```typescript
public readonly integrationMesosphere: ElastigroupAwsIntegrationMesosphereOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphereOutputReference">ElastigroupAwsIntegrationMesosphereOutputReference</a>

---

##### `integrationMultaiRuntime`<sup>Required</sup> <a name="integrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationMultaiRuntime"></a>

```typescript
public readonly integrationMultaiRuntime: ElastigroupAwsIntegrationMultaiRuntimeOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntimeOutputReference">ElastigroupAwsIntegrationMultaiRuntimeOutputReference</a>

---

##### `integrationNomad`<sup>Required</sup> <a name="integrationNomad" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationNomad"></a>

```typescript
public readonly integrationNomad: ElastigroupAwsIntegrationNomadOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadOutputReference">ElastigroupAwsIntegrationNomadOutputReference</a>

---

##### `integrationRancher`<sup>Required</sup> <a name="integrationRancher" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationRancher"></a>

```typescript
public readonly integrationRancher: ElastigroupAwsIntegrationRancherOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancherOutputReference">ElastigroupAwsIntegrationRancherOutputReference</a>

---

##### `integrationRoute53`<sup>Required</sup> <a name="integrationRoute53" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationRoute53"></a>

```typescript
public readonly integrationRoute53: ElastigroupAwsIntegrationRoute53OutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53OutputReference">ElastigroupAwsIntegrationRoute53OutputReference</a>

---

##### `metadataOptions`<sup>Required</sup> <a name="metadataOptions" id="@cdktf/provider-spotinst.ElastigroupAws.property.metadataOptions"></a>

```typescript
public readonly metadataOptions: ElastigroupAwsMetadataOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMetadataOptionsOutputReference">ElastigroupAwsMetadataOptionsOutputReference</a>

---

##### `multipleMetrics`<sup>Required</sup> <a name="multipleMetrics" id="@cdktf/provider-spotinst.ElastigroupAws.property.multipleMetrics"></a>

```typescript
public readonly multipleMetrics: ElastigroupAwsMultipleMetricsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsOutputReference">ElastigroupAwsMultipleMetricsOutputReference</a>

---

##### `revertToSpot`<sup>Required</sup> <a name="revertToSpot" id="@cdktf/provider-spotinst.ElastigroupAws.property.revertToSpot"></a>

```typescript
public readonly revertToSpot: ElastigroupAwsRevertToSpotOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsRevertToSpotOutputReference">ElastigroupAwsRevertToSpotOutputReference</a>

---

##### `statefulDeallocation`<sup>Required</sup> <a name="statefulDeallocation" id="@cdktf/provider-spotinst.ElastigroupAws.property.statefulDeallocation"></a>

```typescript
public readonly statefulDeallocation: ElastigroupAwsStatefulDeallocationOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocationOutputReference">ElastigroupAwsStatefulDeallocationOutputReference</a>

---

##### `updatePolicy`<sup>Required</sup> <a name="updatePolicy" id="@cdktf/provider-spotinst.ElastigroupAws.property.updatePolicy"></a>

```typescript
public readonly updatePolicy: ElastigroupAwsUpdatePolicyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyOutputReference">ElastigroupAwsUpdatePolicyOutputReference</a>

---

##### `availabilityZonesInput`<sup>Optional</sup> <a name="availabilityZonesInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.availabilityZonesInput"></a>

```typescript
public readonly availabilityZonesInput: string[];
```

- *Type:* string[]

---

##### `blockDevicesModeInput`<sup>Optional</sup> <a name="blockDevicesModeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.blockDevicesModeInput"></a>

```typescript
public readonly blockDevicesModeInput: string;
```

- *Type:* string

---

##### `capacityUnitInput`<sup>Optional</sup> <a name="capacityUnitInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.capacityUnitInput"></a>

```typescript
public readonly capacityUnitInput: string;
```

- *Type:* string

---

##### `cpuCreditsInput`<sup>Optional</sup> <a name="cpuCreditsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.cpuCreditsInput"></a>

```typescript
public readonly cpuCreditsInput: string;
```

- *Type:* string

---

##### `cpuOptionsInput`<sup>Optional</sup> <a name="cpuOptionsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.cpuOptionsInput"></a>

```typescript
public readonly cpuOptionsInput: ElastigroupAwsCpuOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsCpuOptions">ElastigroupAwsCpuOptions</a>

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.descriptionInput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `ebsBlockDeviceInput`<sup>Optional</sup> <a name="ebsBlockDeviceInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.ebsBlockDeviceInput"></a>

```typescript
public readonly ebsBlockDeviceInput: IResolvable | ElastigroupAwsEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsEbsBlockDevice">ElastigroupAwsEbsBlockDevice</a>[]

---

##### `ebsOptimizedInput`<sup>Optional</sup> <a name="ebsOptimizedInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.ebsOptimizedInput"></a>

```typescript
public readonly ebsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticIpsInput`<sup>Optional</sup> <a name="elasticIpsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.elasticIpsInput"></a>

```typescript
public readonly elasticIpsInput: string[];
```

- *Type:* string[]

---

##### `elasticLoadBalancersInput`<sup>Optional</sup> <a name="elasticLoadBalancersInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.elasticLoadBalancersInput"></a>

```typescript
public readonly elasticLoadBalancersInput: string[];
```

- *Type:* string[]

---

##### `enableMonitoringInput`<sup>Optional</sup> <a name="enableMonitoringInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.enableMonitoringInput"></a>

```typescript
public readonly enableMonitoringInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `ephemeralBlockDeviceInput`<sup>Optional</sup> <a name="ephemeralBlockDeviceInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.ephemeralBlockDeviceInput"></a>

```typescript
public readonly ephemeralBlockDeviceInput: IResolvable | ElastigroupAwsEphemeralBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsEphemeralBlockDevice">ElastigroupAwsEphemeralBlockDevice</a>[]

---

##### `fallbackToOndemandInput`<sup>Optional</sup> <a name="fallbackToOndemandInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.fallbackToOndemandInput"></a>

```typescript
public readonly fallbackToOndemandInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `healthCheckGracePeriodInput`<sup>Optional</sup> <a name="healthCheckGracePeriodInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckGracePeriodInput"></a>

```typescript
public readonly healthCheckGracePeriodInput: number;
```

- *Type:* number

---

##### `healthCheckTypeInput`<sup>Optional</sup> <a name="healthCheckTypeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckTypeInput"></a>

```typescript
public readonly healthCheckTypeInput: string;
```

- *Type:* string

---

##### `healthCheckUnhealthyDurationBeforeReplacementInput`<sup>Optional</sup> <a name="healthCheckUnhealthyDurationBeforeReplacementInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckUnhealthyDurationBeforeReplacementInput"></a>

```typescript
public readonly healthCheckUnhealthyDurationBeforeReplacementInput: number;
```

- *Type:* number

---

##### `iamInstanceProfileInput`<sup>Optional</sup> <a name="iamInstanceProfileInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.iamInstanceProfileInput"></a>

```typescript
public readonly iamInstanceProfileInput: string;
```

- *Type:* string

---

##### `imageIdInput`<sup>Optional</sup> <a name="imageIdInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.imageIdInput"></a>

```typescript
public readonly imageIdInput: string;
```

- *Type:* string

---

##### `instanceTypesOndemandInput`<sup>Optional</sup> <a name="instanceTypesOndemandInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesOndemandInput"></a>

```typescript
public readonly instanceTypesOndemandInput: string;
```

- *Type:* string

---

##### `instanceTypesPreferredSpotInput`<sup>Optional</sup> <a name="instanceTypesPreferredSpotInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesPreferredSpotInput"></a>

```typescript
public readonly instanceTypesPreferredSpotInput: string[];
```

- *Type:* string[]

---

##### `instanceTypesSpotInput`<sup>Optional</sup> <a name="instanceTypesSpotInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesSpotInput"></a>

```typescript
public readonly instanceTypesSpotInput: string[];
```

- *Type:* string[]

---

##### `instanceTypesWeightsInput`<sup>Optional</sup> <a name="instanceTypesWeightsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesWeightsInput"></a>

```typescript
public readonly instanceTypesWeightsInput: IResolvable | ElastigroupAwsInstanceTypesWeights[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsInstanceTypesWeights">ElastigroupAwsInstanceTypesWeights</a>[]

---

##### `integrationBeanstalkInput`<sup>Optional</sup> <a name="integrationBeanstalkInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationBeanstalkInput"></a>

```typescript
public readonly integrationBeanstalkInput: ElastigroupAwsIntegrationBeanstalk;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalk">ElastigroupAwsIntegrationBeanstalk</a>

---

##### `integrationCodedeployInput`<sup>Optional</sup> <a name="integrationCodedeployInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationCodedeployInput"></a>

```typescript
public readonly integrationCodedeployInput: ElastigroupAwsIntegrationCodedeploy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeploy">ElastigroupAwsIntegrationCodedeploy</a>

---

##### `integrationDockerSwarmInput`<sup>Optional</sup> <a name="integrationDockerSwarmInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationDockerSwarmInput"></a>

```typescript
public readonly integrationDockerSwarmInput: ElastigroupAwsIntegrationDockerSwarm;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarm">ElastigroupAwsIntegrationDockerSwarm</a>

---

##### `integrationEcsInput`<sup>Optional</sup> <a name="integrationEcsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationEcsInput"></a>

```typescript
public readonly integrationEcsInput: ElastigroupAwsIntegrationEcs;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcs">ElastigroupAwsIntegrationEcs</a>

---

##### `integrationGitlabInput`<sup>Optional</sup> <a name="integrationGitlabInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationGitlabInput"></a>

```typescript
public readonly integrationGitlabInput: ElastigroupAwsIntegrationGitlab;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlab">ElastigroupAwsIntegrationGitlab</a>

---

##### `integrationKubernetesInput`<sup>Optional</sup> <a name="integrationKubernetesInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationKubernetesInput"></a>

```typescript
public readonly integrationKubernetesInput: ElastigroupAwsIntegrationKubernetes;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetes">ElastigroupAwsIntegrationKubernetes</a>

---

##### `integrationMesosphereInput`<sup>Optional</sup> <a name="integrationMesosphereInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationMesosphereInput"></a>

```typescript
public readonly integrationMesosphereInput: ElastigroupAwsIntegrationMesosphere;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphere">ElastigroupAwsIntegrationMesosphere</a>

---

##### `integrationMultaiRuntimeInput`<sup>Optional</sup> <a name="integrationMultaiRuntimeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationMultaiRuntimeInput"></a>

```typescript
public readonly integrationMultaiRuntimeInput: ElastigroupAwsIntegrationMultaiRuntime;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntime">ElastigroupAwsIntegrationMultaiRuntime</a>

---

##### `integrationNomadInput`<sup>Optional</sup> <a name="integrationNomadInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationNomadInput"></a>

```typescript
public readonly integrationNomadInput: ElastigroupAwsIntegrationNomad;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomad">ElastigroupAwsIntegrationNomad</a>

---

##### `integrationRancherInput`<sup>Optional</sup> <a name="integrationRancherInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationRancherInput"></a>

```typescript
public readonly integrationRancherInput: ElastigroupAwsIntegrationRancher;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancher">ElastigroupAwsIntegrationRancher</a>

---

##### `integrationRoute53Input`<sup>Optional</sup> <a name="integrationRoute53Input" id="@cdktf/provider-spotinst.ElastigroupAws.property.integrationRoute53Input"></a>

```typescript
public readonly integrationRoute53Input: ElastigroupAwsIntegrationRoute53;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53">ElastigroupAwsIntegrationRoute53</a>

---

##### `itfInput`<sup>Optional</sup> <a name="itfInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.itfInput"></a>

```typescript
public readonly itfInput: IResolvable | ElastigroupAwsItf[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsItf">ElastigroupAwsItf</a>[]

---

##### `keyNameInput`<sup>Optional</sup> <a name="keyNameInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.keyNameInput"></a>

```typescript
public readonly keyNameInput: string;
```

- *Type:* string

---

##### `lifetimePeriodInput`<sup>Optional</sup> <a name="lifetimePeriodInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.lifetimePeriodInput"></a>

```typescript
public readonly lifetimePeriodInput: string;
```

- *Type:* string

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `metadataOptionsInput`<sup>Optional</sup> <a name="metadataOptionsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.metadataOptionsInput"></a>

```typescript
public readonly metadataOptionsInput: ElastigroupAwsMetadataOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMetadataOptions">ElastigroupAwsMetadataOptions</a>

---

##### `minimumInstanceLifetimeInput`<sup>Optional</sup> <a name="minimumInstanceLifetimeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.minimumInstanceLifetimeInput"></a>

```typescript
public readonly minimumInstanceLifetimeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `multaiTargetSetsInput`<sup>Optional</sup> <a name="multaiTargetSetsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.multaiTargetSetsInput"></a>

```typescript
public readonly multaiTargetSetsInput: IResolvable | ElastigroupAwsMultaiTargetSets[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultaiTargetSets">ElastigroupAwsMultaiTargetSets</a>[]

---

##### `multipleMetricsInput`<sup>Optional</sup> <a name="multipleMetricsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.multipleMetricsInput"></a>

```typescript
public readonly multipleMetricsInput: ElastigroupAwsMultipleMetrics;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultipleMetrics">ElastigroupAwsMultipleMetrics</a>

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInterfaceInput`<sup>Optional</sup> <a name="networkInterfaceInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.networkInterfaceInput"></a>

```typescript
public readonly networkInterfaceInput: IResolvable | ElastigroupAwsNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsNetworkInterface">ElastigroupAwsNetworkInterface</a>[]

---

##### `ondemandCountInput`<sup>Optional</sup> <a name="ondemandCountInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.ondemandCountInput"></a>

```typescript
public readonly ondemandCountInput: number;
```

- *Type:* number

---

##### `orientationInput`<sup>Optional</sup> <a name="orientationInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.orientationInput"></a>

```typescript
public readonly orientationInput: string;
```

- *Type:* string

---

##### `persistBlockDevicesInput`<sup>Optional</sup> <a name="persistBlockDevicesInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistBlockDevicesInput"></a>

```typescript
public readonly persistBlockDevicesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistPrivateIpInput`<sup>Optional</sup> <a name="persistPrivateIpInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistPrivateIpInput"></a>

```typescript
public readonly persistPrivateIpInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistRootDeviceInput`<sup>Optional</sup> <a name="persistRootDeviceInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistRootDeviceInput"></a>

```typescript
public readonly persistRootDeviceInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `placementTenancyInput`<sup>Optional</sup> <a name="placementTenancyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.placementTenancyInput"></a>

```typescript
public readonly placementTenancyInput: string;
```

- *Type:* string

---

##### `preferredAvailabilityZonesInput`<sup>Optional</sup> <a name="preferredAvailabilityZonesInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.preferredAvailabilityZonesInput"></a>

```typescript
public readonly preferredAvailabilityZonesInput: string[];
```

- *Type:* string[]

---

##### `privateIpsInput`<sup>Optional</sup> <a name="privateIpsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.privateIpsInput"></a>

```typescript
public readonly privateIpsInput: string[];
```

- *Type:* string[]

---

##### `productInput`<sup>Optional</sup> <a name="productInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.productInput"></a>

```typescript
public readonly productInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `resourceTagSpecificationInput`<sup>Optional</sup> <a name="resourceTagSpecificationInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.resourceTagSpecificationInput"></a>

```typescript
public readonly resourceTagSpecificationInput: IResolvable | ElastigroupAwsResourceTagSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsResourceTagSpecification">ElastigroupAwsResourceTagSpecification</a>[]

---

##### `revertToSpotInput`<sup>Optional</sup> <a name="revertToSpotInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.revertToSpotInput"></a>

```typescript
public readonly revertToSpotInput: ElastigroupAwsRevertToSpot;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsRevertToSpot">ElastigroupAwsRevertToSpot</a>

---

##### `scalingDownPolicyInput`<sup>Optional</sup> <a name="scalingDownPolicyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingDownPolicyInput"></a>

```typescript
public readonly scalingDownPolicyInput: IResolvable | ElastigroupAwsScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicy">ElastigroupAwsScalingDownPolicy</a>[]

---

##### `scalingStrategyInput`<sup>Optional</sup> <a name="scalingStrategyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingStrategyInput"></a>

```typescript
public readonly scalingStrategyInput: IResolvable | ElastigroupAwsScalingStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingStrategy">ElastigroupAwsScalingStrategy</a>[]

---

##### `scalingTargetPolicyInput`<sup>Optional</sup> <a name="scalingTargetPolicyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingTargetPolicyInput"></a>

```typescript
public readonly scalingTargetPolicyInput: IResolvable | ElastigroupAwsScalingTargetPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicy">ElastigroupAwsScalingTargetPolicy</a>[]

---

##### `scalingUpPolicyInput`<sup>Optional</sup> <a name="scalingUpPolicyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingUpPolicyInput"></a>

```typescript
public readonly scalingUpPolicyInput: IResolvable | ElastigroupAwsScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicy">ElastigroupAwsScalingUpPolicy</a>[]

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | ElastigroupAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScheduledTask">ElastigroupAwsScheduledTask</a>[]

---

##### `securityGroupsInput`<sup>Optional</sup> <a name="securityGroupsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.securityGroupsInput"></a>

```typescript
public readonly securityGroupsInput: string[];
```

- *Type:* string[]

---

##### `shutdownScriptInput`<sup>Optional</sup> <a name="shutdownScriptInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.shutdownScriptInput"></a>

```typescript
public readonly shutdownScriptInput: string;
```

- *Type:* string

---

##### `signalInput`<sup>Optional</sup> <a name="signalInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.signalInput"></a>

```typescript
public readonly signalInput: IResolvable | ElastigroupAwsSignal[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsSignal">ElastigroupAwsSignal</a>[]

---

##### `spotPercentageInput`<sup>Optional</sup> <a name="spotPercentageInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.spotPercentageInput"></a>

```typescript
public readonly spotPercentageInput: number;
```

- *Type:* number

---

##### `statefulDeallocationInput`<sup>Optional</sup> <a name="statefulDeallocationInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.statefulDeallocationInput"></a>

```typescript
public readonly statefulDeallocationInput: ElastigroupAwsStatefulDeallocation;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocation">ElastigroupAwsStatefulDeallocation</a>

---

##### `statefulInstanceActionInput`<sup>Optional</sup> <a name="statefulInstanceActionInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.statefulInstanceActionInput"></a>

```typescript
public readonly statefulInstanceActionInput: IResolvable | ElastigroupAwsStatefulInstanceAction[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulInstanceAction">ElastigroupAwsStatefulInstanceAction</a>[]

---

##### `subnetIdsInput`<sup>Optional</sup> <a name="subnetIdsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.subnetIdsInput"></a>

```typescript
public readonly subnetIdsInput: string[];
```

- *Type:* string[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | ElastigroupAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsTags">ElastigroupAwsTags</a>[]

---

##### `targetGroupArnsInput`<sup>Optional</sup> <a name="targetGroupArnsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.targetGroupArnsInput"></a>

```typescript
public readonly targetGroupArnsInput: string[];
```

- *Type:* string[]

---

##### `updatePolicyInput`<sup>Optional</sup> <a name="updatePolicyInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.updatePolicyInput"></a>

```typescript
public readonly updatePolicyInput: ElastigroupAwsUpdatePolicy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicy">ElastigroupAwsUpdatePolicy</a>

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `utilizeCommitmentsInput`<sup>Optional</sup> <a name="utilizeCommitmentsInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.utilizeCommitmentsInput"></a>

```typescript
public readonly utilizeCommitmentsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstancesInput`<sup>Optional</sup> <a name="utilizeReservedInstancesInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.utilizeReservedInstancesInput"></a>

```typescript
public readonly utilizeReservedInstancesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `waitForCapacityInput`<sup>Optional</sup> <a name="waitForCapacityInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityInput"></a>

```typescript
public readonly waitForCapacityInput: number;
```

- *Type:* number

---

##### `waitForCapacityTimeoutInput`<sup>Optional</sup> <a name="waitForCapacityTimeoutInput" id="@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityTimeoutInput"></a>

```typescript
public readonly waitForCapacityTimeoutInput: number;
```

- *Type:* number

---

##### `availabilityZones`<sup>Required</sup> <a name="availabilityZones" id="@cdktf/provider-spotinst.ElastigroupAws.property.availabilityZones"></a>

```typescript
public readonly availabilityZones: string[];
```

- *Type:* string[]

---

##### `blockDevicesMode`<sup>Required</sup> <a name="blockDevicesMode" id="@cdktf/provider-spotinst.ElastigroupAws.property.blockDevicesMode"></a>

```typescript
public readonly blockDevicesMode: string;
```

- *Type:* string

---

##### `capacityUnit`<sup>Required</sup> <a name="capacityUnit" id="@cdktf/provider-spotinst.ElastigroupAws.property.capacityUnit"></a>

```typescript
public readonly capacityUnit: string;
```

- *Type:* string

---

##### `cpuCredits`<sup>Required</sup> <a name="cpuCredits" id="@cdktf/provider-spotinst.ElastigroupAws.property.cpuCredits"></a>

```typescript
public readonly cpuCredits: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-spotinst.ElastigroupAws.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAws.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.ElastigroupAws.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `ebsBlockDevice`<sup>Required</sup> <a name="ebsBlockDevice" id="@cdktf/provider-spotinst.ElastigroupAws.property.ebsBlockDevice"></a>

```typescript
public readonly ebsBlockDevice: IResolvable | ElastigroupAwsEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsEbsBlockDevice">ElastigroupAwsEbsBlockDevice</a>[]

---

##### `ebsOptimized`<sup>Required</sup> <a name="ebsOptimized" id="@cdktf/provider-spotinst.ElastigroupAws.property.ebsOptimized"></a>

```typescript
public readonly ebsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticIps`<sup>Required</sup> <a name="elasticIps" id="@cdktf/provider-spotinst.ElastigroupAws.property.elasticIps"></a>

```typescript
public readonly elasticIps: string[];
```

- *Type:* string[]

---

##### `elasticLoadBalancers`<sup>Required</sup> <a name="elasticLoadBalancers" id="@cdktf/provider-spotinst.ElastigroupAws.property.elasticLoadBalancers"></a>

```typescript
public readonly elasticLoadBalancers: string[];
```

- *Type:* string[]

---

##### `enableMonitoring`<sup>Required</sup> <a name="enableMonitoring" id="@cdktf/provider-spotinst.ElastigroupAws.property.enableMonitoring"></a>

```typescript
public readonly enableMonitoring: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `ephemeralBlockDevice`<sup>Required</sup> <a name="ephemeralBlockDevice" id="@cdktf/provider-spotinst.ElastigroupAws.property.ephemeralBlockDevice"></a>

```typescript
public readonly ephemeralBlockDevice: IResolvable | ElastigroupAwsEphemeralBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsEphemeralBlockDevice">ElastigroupAwsEphemeralBlockDevice</a>[]

---

##### `fallbackToOndemand`<sup>Required</sup> <a name="fallbackToOndemand" id="@cdktf/provider-spotinst.ElastigroupAws.property.fallbackToOndemand"></a>

```typescript
public readonly fallbackToOndemand: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `healthCheckGracePeriod`<sup>Required</sup> <a name="healthCheckGracePeriod" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckGracePeriod"></a>

```typescript
public readonly healthCheckGracePeriod: number;
```

- *Type:* number

---

##### `healthCheckType`<sup>Required</sup> <a name="healthCheckType" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckType"></a>

```typescript
public readonly healthCheckType: string;
```

- *Type:* string

---

##### `healthCheckUnhealthyDurationBeforeReplacement`<sup>Required</sup> <a name="healthCheckUnhealthyDurationBeforeReplacement" id="@cdktf/provider-spotinst.ElastigroupAws.property.healthCheckUnhealthyDurationBeforeReplacement"></a>

```typescript
public readonly healthCheckUnhealthyDurationBeforeReplacement: number;
```

- *Type:* number

---

##### `iamInstanceProfile`<sup>Required</sup> <a name="iamInstanceProfile" id="@cdktf/provider-spotinst.ElastigroupAws.property.iamInstanceProfile"></a>

```typescript
public readonly iamInstanceProfile: string;
```

- *Type:* string

---

##### `imageId`<sup>Required</sup> <a name="imageId" id="@cdktf/provider-spotinst.ElastigroupAws.property.imageId"></a>

```typescript
public readonly imageId: string;
```

- *Type:* string

---

##### `instanceTypesOndemand`<sup>Required</sup> <a name="instanceTypesOndemand" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesOndemand"></a>

```typescript
public readonly instanceTypesOndemand: string;
```

- *Type:* string

---

##### `instanceTypesPreferredSpot`<sup>Required</sup> <a name="instanceTypesPreferredSpot" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesPreferredSpot"></a>

```typescript
public readonly instanceTypesPreferredSpot: string[];
```

- *Type:* string[]

---

##### `instanceTypesSpot`<sup>Required</sup> <a name="instanceTypesSpot" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesSpot"></a>

```typescript
public readonly instanceTypesSpot: string[];
```

- *Type:* string[]

---

##### `instanceTypesWeights`<sup>Required</sup> <a name="instanceTypesWeights" id="@cdktf/provider-spotinst.ElastigroupAws.property.instanceTypesWeights"></a>

```typescript
public readonly instanceTypesWeights: IResolvable | ElastigroupAwsInstanceTypesWeights[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsInstanceTypesWeights">ElastigroupAwsInstanceTypesWeights</a>[]

---

##### `itf`<sup>Required</sup> <a name="itf" id="@cdktf/provider-spotinst.ElastigroupAws.property.itf"></a>

```typescript
public readonly itf: IResolvable | ElastigroupAwsItf[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsItf">ElastigroupAwsItf</a>[]

---

##### `keyName`<sup>Required</sup> <a name="keyName" id="@cdktf/provider-spotinst.ElastigroupAws.property.keyName"></a>

```typescript
public readonly keyName: string;
```

- *Type:* string

---

##### `lifetimePeriod`<sup>Required</sup> <a name="lifetimePeriod" id="@cdktf/provider-spotinst.ElastigroupAws.property.lifetimePeriod"></a>

```typescript
public readonly lifetimePeriod: string;
```

- *Type:* string

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupAws.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minimumInstanceLifetime`<sup>Required</sup> <a name="minimumInstanceLifetime" id="@cdktf/provider-spotinst.ElastigroupAws.property.minimumInstanceLifetime"></a>

```typescript
public readonly minimumInstanceLifetime: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupAws.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `multaiTargetSets`<sup>Required</sup> <a name="multaiTargetSets" id="@cdktf/provider-spotinst.ElastigroupAws.property.multaiTargetSets"></a>

```typescript
public readonly multaiTargetSets: IResolvable | ElastigroupAwsMultaiTargetSets[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsMultaiTargetSets">ElastigroupAwsMultaiTargetSets</a>[]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupAws.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `networkInterface`<sup>Required</sup> <a name="networkInterface" id="@cdktf/provider-spotinst.ElastigroupAws.property.networkInterface"></a>

```typescript
public readonly networkInterface: IResolvable | ElastigroupAwsNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsNetworkInterface">ElastigroupAwsNetworkInterface</a>[]

---

##### `ondemandCount`<sup>Required</sup> <a name="ondemandCount" id="@cdktf/provider-spotinst.ElastigroupAws.property.ondemandCount"></a>

```typescript
public readonly ondemandCount: number;
```

- *Type:* number

---

##### `orientation`<sup>Required</sup> <a name="orientation" id="@cdktf/provider-spotinst.ElastigroupAws.property.orientation"></a>

```typescript
public readonly orientation: string;
```

- *Type:* string

---

##### `persistBlockDevices`<sup>Required</sup> <a name="persistBlockDevices" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistBlockDevices"></a>

```typescript
public readonly persistBlockDevices: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistPrivateIp`<sup>Required</sup> <a name="persistPrivateIp" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistPrivateIp"></a>

```typescript
public readonly persistPrivateIp: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistRootDevice`<sup>Required</sup> <a name="persistRootDevice" id="@cdktf/provider-spotinst.ElastigroupAws.property.persistRootDevice"></a>

```typescript
public readonly persistRootDevice: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `placementTenancy`<sup>Required</sup> <a name="placementTenancy" id="@cdktf/provider-spotinst.ElastigroupAws.property.placementTenancy"></a>

```typescript
public readonly placementTenancy: string;
```

- *Type:* string

---

##### `preferredAvailabilityZones`<sup>Required</sup> <a name="preferredAvailabilityZones" id="@cdktf/provider-spotinst.ElastigroupAws.property.preferredAvailabilityZones"></a>

```typescript
public readonly preferredAvailabilityZones: string[];
```

- *Type:* string[]

---

##### `privateIps`<sup>Required</sup> <a name="privateIps" id="@cdktf/provider-spotinst.ElastigroupAws.property.privateIps"></a>

```typescript
public readonly privateIps: string[];
```

- *Type:* string[]

---

##### `product`<sup>Required</sup> <a name="product" id="@cdktf/provider-spotinst.ElastigroupAws.property.product"></a>

```typescript
public readonly product: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.ElastigroupAws.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `resourceTagSpecification`<sup>Required</sup> <a name="resourceTagSpecification" id="@cdktf/provider-spotinst.ElastigroupAws.property.resourceTagSpecification"></a>

```typescript
public readonly resourceTagSpecification: IResolvable | ElastigroupAwsResourceTagSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsResourceTagSpecification">ElastigroupAwsResourceTagSpecification</a>[]

---

##### `scalingDownPolicy`<sup>Required</sup> <a name="scalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingDownPolicy"></a>

```typescript
public readonly scalingDownPolicy: IResolvable | ElastigroupAwsScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicy">ElastigroupAwsScalingDownPolicy</a>[]

---

##### `scalingStrategy`<sup>Required</sup> <a name="scalingStrategy" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingStrategy"></a>

```typescript
public readonly scalingStrategy: IResolvable | ElastigroupAwsScalingStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingStrategy">ElastigroupAwsScalingStrategy</a>[]

---

##### `scalingTargetPolicy`<sup>Required</sup> <a name="scalingTargetPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingTargetPolicy"></a>

```typescript
public readonly scalingTargetPolicy: IResolvable | ElastigroupAwsScalingTargetPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicy">ElastigroupAwsScalingTargetPolicy</a>[]

---

##### `scalingUpPolicy`<sup>Required</sup> <a name="scalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupAws.property.scalingUpPolicy"></a>

```typescript
public readonly scalingUpPolicy: IResolvable | ElastigroupAwsScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicy">ElastigroupAwsScalingUpPolicy</a>[]

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.ElastigroupAws.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | ElastigroupAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsScheduledTask">ElastigroupAwsScheduledTask</a>[]

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="@cdktf/provider-spotinst.ElastigroupAws.property.securityGroups"></a>

```typescript
public readonly securityGroups: string[];
```

- *Type:* string[]

---

##### `shutdownScript`<sup>Required</sup> <a name="shutdownScript" id="@cdktf/provider-spotinst.ElastigroupAws.property.shutdownScript"></a>

```typescript
public readonly shutdownScript: string;
```

- *Type:* string

---

##### `signal`<sup>Required</sup> <a name="signal" id="@cdktf/provider-spotinst.ElastigroupAws.property.signal"></a>

```typescript
public readonly signal: IResolvable | ElastigroupAwsSignal[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsSignal">ElastigroupAwsSignal</a>[]

---

##### `spotPercentage`<sup>Required</sup> <a name="spotPercentage" id="@cdktf/provider-spotinst.ElastigroupAws.property.spotPercentage"></a>

```typescript
public readonly spotPercentage: number;
```

- *Type:* number

---

##### `statefulInstanceAction`<sup>Required</sup> <a name="statefulInstanceAction" id="@cdktf/provider-spotinst.ElastigroupAws.property.statefulInstanceAction"></a>

```typescript
public readonly statefulInstanceAction: IResolvable | ElastigroupAwsStatefulInstanceAction[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsStatefulInstanceAction">ElastigroupAwsStatefulInstanceAction</a>[]

---

##### `subnetIds`<sup>Required</sup> <a name="subnetIds" id="@cdktf/provider-spotinst.ElastigroupAws.property.subnetIds"></a>

```typescript
public readonly subnetIds: string[];
```

- *Type:* string[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.ElastigroupAws.property.tags"></a>

```typescript
public readonly tags: IResolvable | ElastigroupAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsTags">ElastigroupAwsTags</a>[]

---

##### `targetGroupArns`<sup>Required</sup> <a name="targetGroupArns" id="@cdktf/provider-spotinst.ElastigroupAws.property.targetGroupArns"></a>

```typescript
public readonly targetGroupArns: string[];
```

- *Type:* string[]

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.ElastigroupAws.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

##### `utilizeCommitments`<sup>Required</sup> <a name="utilizeCommitments" id="@cdktf/provider-spotinst.ElastigroupAws.property.utilizeCommitments"></a>

```typescript
public readonly utilizeCommitments: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstances`<sup>Required</sup> <a name="utilizeReservedInstances" id="@cdktf/provider-spotinst.ElastigroupAws.property.utilizeReservedInstances"></a>

```typescript
public readonly utilizeReservedInstances: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `waitForCapacity`<sup>Required</sup> <a name="waitForCapacity" id="@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacity"></a>

```typescript
public readonly waitForCapacity: number;
```

- *Type:* number

---

##### `waitForCapacityTimeout`<sup>Required</sup> <a name="waitForCapacityTimeout" id="@cdktf/provider-spotinst.ElastigroupAws.property.waitForCapacityTimeout"></a>

```typescript
public readonly waitForCapacityTimeout: number;
```

- *Type:* number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAws.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupAws.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupAwsBeanstalk <a name="ElastigroupAwsBeanstalk" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk spotinst_elastigroup_aws_beanstalk}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer"></a>

```typescript
import { ElastigroupAwsBeanstalk } from '@cdktf/provider-spotinst'

new ElastigroupAwsBeanstalk(scope: Construct, id: string, config: ElastigroupAwsBeanstalkConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkConfig">ElastigroupAwsBeanstalkConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkConfig">ElastigroupAwsBeanstalkConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putDeploymentPreferences">putDeploymentPreferences</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putManagedActions">putManagedActions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetBeanstalkEnvironmentId">resetBeanstalkEnvironmentId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetBeanstalkEnvironmentName">resetBeanstalkEnvironmentName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetDeploymentPreferences">resetDeploymentPreferences</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetMaintenance">resetMaintenance</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetManagedActions">resetManagedActions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putDeploymentPreferences` <a name="putDeploymentPreferences" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putDeploymentPreferences"></a>

```typescript
public putDeploymentPreferences(value: ElastigroupAwsBeanstalkDeploymentPreferences): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putDeploymentPreferences.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferences">ElastigroupAwsBeanstalkDeploymentPreferences</a>

---

##### `putManagedActions` <a name="putManagedActions" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putManagedActions"></a>

```typescript
public putManagedActions(value: ElastigroupAwsBeanstalkManagedActions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.putManagedActions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActions">ElastigroupAwsBeanstalkManagedActions</a>

---

##### `resetBeanstalkEnvironmentId` <a name="resetBeanstalkEnvironmentId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetBeanstalkEnvironmentId"></a>

```typescript
public resetBeanstalkEnvironmentId(): void
```

##### `resetBeanstalkEnvironmentName` <a name="resetBeanstalkEnvironmentName" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetBeanstalkEnvironmentName"></a>

```typescript
public resetBeanstalkEnvironmentName(): void
```

##### `resetDeploymentPreferences` <a name="resetDeploymentPreferences" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetDeploymentPreferences"></a>

```typescript
public resetDeploymentPreferences(): void
```

##### `resetMaintenance` <a name="resetMaintenance" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetMaintenance"></a>

```typescript
public resetMaintenance(): void
```

##### `resetManagedActions` <a name="resetManagedActions" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetManagedActions"></a>

```typescript
public resetManagedActions(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.isConstruct"></a>

```typescript
import { ElastigroupAwsBeanstalk } from '@cdktf/provider-spotinst'

ElastigroupAwsBeanstalk.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.deploymentPreferences">deploymentPreferences</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference">ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.managedActions">managedActions</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActionsOutputReference">ElastigroupAwsBeanstalkManagedActionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentIdInput">beanstalkEnvironmentIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentNameInput">beanstalkEnvironmentNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.deploymentPreferencesInput">deploymentPreferencesInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferences">ElastigroupAwsBeanstalkDeploymentPreferences</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.instanceTypesSpotInput">instanceTypesSpotInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maintenanceInput">maintenanceInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.managedActionsInput">managedActionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActions">ElastigroupAwsBeanstalkManagedActions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.productInput">productInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkScheduledTask">ElastigroupAwsBeanstalkScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentId">beanstalkEnvironmentId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentName">beanstalkEnvironmentName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.instanceTypesSpot">instanceTypesSpot</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maintenance">maintenance</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.product">product</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkScheduledTask">ElastigroupAwsBeanstalkScheduledTask</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `deploymentPreferences`<sup>Required</sup> <a name="deploymentPreferences" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.deploymentPreferences"></a>

```typescript
public readonly deploymentPreferences: ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference">ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `managedActions`<sup>Required</sup> <a name="managedActions" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.managedActions"></a>

```typescript
public readonly managedActions: ElastigroupAwsBeanstalkManagedActionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActionsOutputReference">ElastigroupAwsBeanstalkManagedActionsOutputReference</a>

---

##### `beanstalkEnvironmentIdInput`<sup>Optional</sup> <a name="beanstalkEnvironmentIdInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentIdInput"></a>

```typescript
public readonly beanstalkEnvironmentIdInput: string;
```

- *Type:* string

---

##### `beanstalkEnvironmentNameInput`<sup>Optional</sup> <a name="beanstalkEnvironmentNameInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentNameInput"></a>

```typescript
public readonly beanstalkEnvironmentNameInput: string;
```

- *Type:* string

---

##### `deploymentPreferencesInput`<sup>Optional</sup> <a name="deploymentPreferencesInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.deploymentPreferencesInput"></a>

```typescript
public readonly deploymentPreferencesInput: ElastigroupAwsBeanstalkDeploymentPreferences;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferences">ElastigroupAwsBeanstalkDeploymentPreferences</a>

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `instanceTypesSpotInput`<sup>Optional</sup> <a name="instanceTypesSpotInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.instanceTypesSpotInput"></a>

```typescript
public readonly instanceTypesSpotInput: string[];
```

- *Type:* string[]

---

##### `maintenanceInput`<sup>Optional</sup> <a name="maintenanceInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maintenanceInput"></a>

```typescript
public readonly maintenanceInput: string;
```

- *Type:* string

---

##### `managedActionsInput`<sup>Optional</sup> <a name="managedActionsInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.managedActionsInput"></a>

```typescript
public readonly managedActionsInput: ElastigroupAwsBeanstalkManagedActions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActions">ElastigroupAwsBeanstalkManagedActions</a>

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `productInput`<sup>Optional</sup> <a name="productInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.productInput"></a>

```typescript
public readonly productInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | ElastigroupAwsBeanstalkScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkScheduledTask">ElastigroupAwsBeanstalkScheduledTask</a>[]

---

##### `beanstalkEnvironmentId`<sup>Required</sup> <a name="beanstalkEnvironmentId" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentId"></a>

```typescript
public readonly beanstalkEnvironmentId: string;
```

- *Type:* string

---

##### `beanstalkEnvironmentName`<sup>Required</sup> <a name="beanstalkEnvironmentName" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.beanstalkEnvironmentName"></a>

```typescript
public readonly beanstalkEnvironmentName: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `instanceTypesSpot`<sup>Required</sup> <a name="instanceTypesSpot" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.instanceTypesSpot"></a>

```typescript
public readonly instanceTypesSpot: string[];
```

- *Type:* string[]

---

##### `maintenance`<sup>Required</sup> <a name="maintenance" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maintenance"></a>

```typescript
public readonly maintenance: string;
```

- *Type:* string

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `product`<sup>Required</sup> <a name="product" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.product"></a>

```typescript
public readonly product: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | ElastigroupAwsBeanstalkScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalkScheduledTask">ElastigroupAwsBeanstalkScheduledTask</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupAwsSuspension <a name="ElastigroupAwsSuspension" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer"></a>

```typescript
import { ElastigroupAwsSuspension } from '@cdktf/provider-spotinst'

new ElastigroupAwsSuspension(scope: Construct, id: string, config: ElastigroupAwsSuspensionConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionConfig">ElastigroupAwsSuspensionConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionConfig">ElastigroupAwsSuspensionConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.isConstruct"></a>

```typescript
import { ElastigroupAwsSuspension } from '@cdktf/provider-spotinst'

ElastigroupAwsSuspension.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.groupIdInput">groupIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.suspensionInput">suspensionInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionSuspension">ElastigroupAwsSuspensionSuspension</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.groupId">groupId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.suspension">suspension</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionSuspension">ElastigroupAwsSuspensionSuspension</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `groupIdInput`<sup>Optional</sup> <a name="groupIdInput" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.groupIdInput"></a>

```typescript
public readonly groupIdInput: string;
```

- *Type:* string

---

##### `suspensionInput`<sup>Optional</sup> <a name="suspensionInput" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.suspensionInput"></a>

```typescript
public readonly suspensionInput: IResolvable | ElastigroupAwsSuspensionSuspension[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionSuspension">ElastigroupAwsSuspensionSuspension</a>[]

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.groupId"></a>

```typescript
public readonly groupId: string;
```

- *Type:* string

---

##### `suspension`<sup>Required</sup> <a name="suspension" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.suspension"></a>

```typescript
public readonly suspension: IResolvable | ElastigroupAwsSuspensionSuspension[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspensionSuspension">ElastigroupAwsSuspensionSuspension</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupAwsSuspension.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupAzure <a name="ElastigroupAzure" id="@cdktf/provider-spotinst.ElastigroupAzure"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupAzure.Initializer"></a>

```typescript
import { ElastigroupAzure } from '@cdktf/provider-spotinst'

new ElastigroupAzure(scope: Construct, id: string, config: ElastigroupAzureConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureConfig">ElastigroupAzureConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupAzure.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureConfig">ElastigroupAzureConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putHealthCheck">putHealthCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationKubernetes">putIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationMultaiRuntime">putIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putLogin">putLogin</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putNetwork">putNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putStrategy">putStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.putUpdatePolicy">putUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetCustomData">resetCustomData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetDesiredCapacity">resetDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetHealthCheck">resetHealthCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetImage">resetImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetIntegrationKubernetes">resetIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetIntegrationMultaiRuntime">resetIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetLoadBalancers">resetLoadBalancers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetLogin">resetLogin</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetManagedServiceIdentities">resetManagedServiceIdentities</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetScalingDownPolicy">resetScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetScalingUpPolicy">resetScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetShutdownScript">resetShutdownScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetUpdatePolicy">resetUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.resetUserData">resetUserData</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupAzure.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupAzure.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupAzure.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzure.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzure.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzure.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupAzure.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupAzure.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzure.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putHealthCheck` <a name="putHealthCheck" id="@cdktf/provider-spotinst.ElastigroupAzure.putHealthCheck"></a>

```typescript
public putHealthCheck(value: ElastigroupAzureHealthCheck): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putHealthCheck.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureHealthCheck">ElastigroupAzureHealthCheck</a>

---

##### `putIntegrationKubernetes` <a name="putIntegrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationKubernetes"></a>

```typescript
public putIntegrationKubernetes(value: ElastigroupAzureIntegrationKubernetes): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationKubernetes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetes">ElastigroupAzureIntegrationKubernetes</a>

---

##### `putIntegrationMultaiRuntime` <a name="putIntegrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationMultaiRuntime"></a>

```typescript
public putIntegrationMultaiRuntime(value: ElastigroupAzureIntegrationMultaiRuntime): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putIntegrationMultaiRuntime.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntime">ElastigroupAzureIntegrationMultaiRuntime</a>

---

##### `putLogin` <a name="putLogin" id="@cdktf/provider-spotinst.ElastigroupAzure.putLogin"></a>

```typescript
public putLogin(value: ElastigroupAzureLogin): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putLogin.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureLogin">ElastigroupAzureLogin</a>

---

##### `putNetwork` <a name="putNetwork" id="@cdktf/provider-spotinst.ElastigroupAzure.putNetwork"></a>

```typescript
public putNetwork(value: ElastigroupAzureNetwork): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putNetwork.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureNetwork">ElastigroupAzureNetwork</a>

---

##### `putStrategy` <a name="putStrategy" id="@cdktf/provider-spotinst.ElastigroupAzure.putStrategy"></a>

```typescript
public putStrategy(value: ElastigroupAzureStrategy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putStrategy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureStrategy">ElastigroupAzureStrategy</a>

---

##### `putUpdatePolicy` <a name="putUpdatePolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.putUpdatePolicy"></a>

```typescript
public putUpdatePolicy(value: ElastigroupAzureUpdatePolicy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzure.putUpdatePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicy">ElastigroupAzureUpdatePolicy</a>

---

##### `resetCustomData` <a name="resetCustomData" id="@cdktf/provider-spotinst.ElastigroupAzure.resetCustomData"></a>

```typescript
public resetCustomData(): void
```

##### `resetDesiredCapacity` <a name="resetDesiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAzure.resetDesiredCapacity"></a>

```typescript
public resetDesiredCapacity(): void
```

##### `resetHealthCheck` <a name="resetHealthCheck" id="@cdktf/provider-spotinst.ElastigroupAzure.resetHealthCheck"></a>

```typescript
public resetHealthCheck(): void
```

##### `resetImage` <a name="resetImage" id="@cdktf/provider-spotinst.ElastigroupAzure.resetImage"></a>

```typescript
public resetImage(): void
```

##### `resetIntegrationKubernetes` <a name="resetIntegrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAzure.resetIntegrationKubernetes"></a>

```typescript
public resetIntegrationKubernetes(): void
```

##### `resetIntegrationMultaiRuntime` <a name="resetIntegrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAzure.resetIntegrationMultaiRuntime"></a>

```typescript
public resetIntegrationMultaiRuntime(): void
```

##### `resetLoadBalancers` <a name="resetLoadBalancers" id="@cdktf/provider-spotinst.ElastigroupAzure.resetLoadBalancers"></a>

```typescript
public resetLoadBalancers(): void
```

##### `resetLogin` <a name="resetLogin" id="@cdktf/provider-spotinst.ElastigroupAzure.resetLogin"></a>

```typescript
public resetLogin(): void
```

##### `resetManagedServiceIdentities` <a name="resetManagedServiceIdentities" id="@cdktf/provider-spotinst.ElastigroupAzure.resetManagedServiceIdentities"></a>

```typescript
public resetManagedServiceIdentities(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.ElastigroupAzure.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.ElastigroupAzure.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetScalingDownPolicy` <a name="resetScalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.resetScalingDownPolicy"></a>

```typescript
public resetScalingDownPolicy(): void
```

##### `resetScalingUpPolicy` <a name="resetScalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.resetScalingUpPolicy"></a>

```typescript
public resetScalingUpPolicy(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.ElastigroupAzure.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetShutdownScript` <a name="resetShutdownScript" id="@cdktf/provider-spotinst.ElastigroupAzure.resetShutdownScript"></a>

```typescript
public resetShutdownScript(): void
```

##### `resetUpdatePolicy` <a name="resetUpdatePolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.resetUpdatePolicy"></a>

```typescript
public resetUpdatePolicy(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.ElastigroupAzure.resetUserData"></a>

```typescript
public resetUserData(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupAzure.isConstruct"></a>

```typescript
import { ElastigroupAzure } from '@cdktf/provider-spotinst'

ElastigroupAzure.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupAzure.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.healthCheck">healthCheck</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureHealthCheckOutputReference">ElastigroupAzureHealthCheckOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.integrationKubernetes">integrationKubernetes</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetesOutputReference">ElastigroupAzureIntegrationKubernetesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.integrationMultaiRuntime">integrationMultaiRuntime</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntimeOutputReference">ElastigroupAzureIntegrationMultaiRuntimeOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.login">login</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureLoginOutputReference">ElastigroupAzureLoginOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.network">network</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureNetworkOutputReference">ElastigroupAzureNetworkOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.strategy">strategy</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureStrategyOutputReference">ElastigroupAzureStrategyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.updatePolicy">updatePolicy</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicyOutputReference">ElastigroupAzureUpdatePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.customDataInput">customDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.healthCheckInput">healthCheckInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureHealthCheck">ElastigroupAzureHealthCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.imageInput">imageInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureImage">ElastigroupAzureImage</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.integrationKubernetesInput">integrationKubernetesInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetes">ElastigroupAzureIntegrationKubernetes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.integrationMultaiRuntimeInput">integrationMultaiRuntimeInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntime">ElastigroupAzureIntegrationMultaiRuntime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.loadBalancersInput">loadBalancersInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureLoadBalancers">ElastigroupAzureLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.loginInput">loginInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureLogin">ElastigroupAzureLogin</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.lowPrioritySizesInput">lowPrioritySizesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.managedServiceIdentitiesInput">managedServiceIdentitiesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureManagedServiceIdentities">ElastigroupAzureManagedServiceIdentities</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.networkInput">networkInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureNetwork">ElastigroupAzureNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.odSizesInput">odSizesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.productInput">productInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.resourceGroupNameInput">resourceGroupNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scalingDownPolicyInput">scalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicy">ElastigroupAzureScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scalingUpPolicyInput">scalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicy">ElastigroupAzureScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScheduledTask">ElastigroupAzureScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.shutdownScriptInput">shutdownScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.strategyInput">strategyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureStrategy">ElastigroupAzureStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.updatePolicyInput">updatePolicyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicy">ElastigroupAzureUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.customData">customData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.image">image</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureImage">ElastigroupAzureImage</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.loadBalancers">loadBalancers</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureLoadBalancers">ElastigroupAzureLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.lowPrioritySizes">lowPrioritySizes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.managedServiceIdentities">managedServiceIdentities</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureManagedServiceIdentities">ElastigroupAzureManagedServiceIdentities</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.odSizes">odSizes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.product">product</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.resourceGroupName">resourceGroupName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scalingDownPolicy">scalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicy">ElastigroupAzureScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scalingUpPolicy">scalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicy">ElastigroupAzureScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureScheduledTask">ElastigroupAzureScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.shutdownScript">shutdownScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.userData">userData</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupAzure.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupAzure.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupAzure.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupAzure.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupAzure.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupAzure.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupAzure.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupAzure.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupAzure.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupAzure.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupAzure.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `healthCheck`<sup>Required</sup> <a name="healthCheck" id="@cdktf/provider-spotinst.ElastigroupAzure.property.healthCheck"></a>

```typescript
public readonly healthCheck: ElastigroupAzureHealthCheckOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureHealthCheckOutputReference">ElastigroupAzureHealthCheckOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAzure.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `integrationKubernetes`<sup>Required</sup> <a name="integrationKubernetes" id="@cdktf/provider-spotinst.ElastigroupAzure.property.integrationKubernetes"></a>

```typescript
public readonly integrationKubernetes: ElastigroupAzureIntegrationKubernetesOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetesOutputReference">ElastigroupAzureIntegrationKubernetesOutputReference</a>

---

##### `integrationMultaiRuntime`<sup>Required</sup> <a name="integrationMultaiRuntime" id="@cdktf/provider-spotinst.ElastigroupAzure.property.integrationMultaiRuntime"></a>

```typescript
public readonly integrationMultaiRuntime: ElastigroupAzureIntegrationMultaiRuntimeOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntimeOutputReference">ElastigroupAzureIntegrationMultaiRuntimeOutputReference</a>

---

##### `login`<sup>Required</sup> <a name="login" id="@cdktf/provider-spotinst.ElastigroupAzure.property.login"></a>

```typescript
public readonly login: ElastigroupAzureLoginOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureLoginOutputReference">ElastigroupAzureLoginOutputReference</a>

---

##### `network`<sup>Required</sup> <a name="network" id="@cdktf/provider-spotinst.ElastigroupAzure.property.network"></a>

```typescript
public readonly network: ElastigroupAzureNetworkOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureNetworkOutputReference">ElastigroupAzureNetworkOutputReference</a>

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.ElastigroupAzure.property.strategy"></a>

```typescript
public readonly strategy: ElastigroupAzureStrategyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureStrategyOutputReference">ElastigroupAzureStrategyOutputReference</a>

---

##### `updatePolicy`<sup>Required</sup> <a name="updatePolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.property.updatePolicy"></a>

```typescript
public readonly updatePolicy: ElastigroupAzureUpdatePolicyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicyOutputReference">ElastigroupAzureUpdatePolicyOutputReference</a>

---

##### `customDataInput`<sup>Optional</sup> <a name="customDataInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.customDataInput"></a>

```typescript
public readonly customDataInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `healthCheckInput`<sup>Optional</sup> <a name="healthCheckInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.healthCheckInput"></a>

```typescript
public readonly healthCheckInput: ElastigroupAzureHealthCheck;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureHealthCheck">ElastigroupAzureHealthCheck</a>

---

##### `imageInput`<sup>Optional</sup> <a name="imageInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.imageInput"></a>

```typescript
public readonly imageInput: IResolvable | ElastigroupAzureImage[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureImage">ElastigroupAzureImage</a>[]

---

##### `integrationKubernetesInput`<sup>Optional</sup> <a name="integrationKubernetesInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.integrationKubernetesInput"></a>

```typescript
public readonly integrationKubernetesInput: ElastigroupAzureIntegrationKubernetes;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetes">ElastigroupAzureIntegrationKubernetes</a>

---

##### `integrationMultaiRuntimeInput`<sup>Optional</sup> <a name="integrationMultaiRuntimeInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.integrationMultaiRuntimeInput"></a>

```typescript
public readonly integrationMultaiRuntimeInput: ElastigroupAzureIntegrationMultaiRuntime;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntime">ElastigroupAzureIntegrationMultaiRuntime</a>

---

##### `loadBalancersInput`<sup>Optional</sup> <a name="loadBalancersInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.loadBalancersInput"></a>

```typescript
public readonly loadBalancersInput: IResolvable | ElastigroupAzureLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureLoadBalancers">ElastigroupAzureLoadBalancers</a>[]

---

##### `loginInput`<sup>Optional</sup> <a name="loginInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.loginInput"></a>

```typescript
public readonly loginInput: ElastigroupAzureLogin;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureLogin">ElastigroupAzureLogin</a>

---

##### `lowPrioritySizesInput`<sup>Optional</sup> <a name="lowPrioritySizesInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.lowPrioritySizesInput"></a>

```typescript
public readonly lowPrioritySizesInput: string[];
```

- *Type:* string[]

---

##### `managedServiceIdentitiesInput`<sup>Optional</sup> <a name="managedServiceIdentitiesInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.managedServiceIdentitiesInput"></a>

```typescript
public readonly managedServiceIdentitiesInput: IResolvable | ElastigroupAzureManagedServiceIdentities[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureManagedServiceIdentities">ElastigroupAzureManagedServiceIdentities</a>[]

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInput`<sup>Optional</sup> <a name="networkInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.networkInput"></a>

```typescript
public readonly networkInput: ElastigroupAzureNetwork;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureNetwork">ElastigroupAzureNetwork</a>

---

##### `odSizesInput`<sup>Optional</sup> <a name="odSizesInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.odSizesInput"></a>

```typescript
public readonly odSizesInput: string[];
```

- *Type:* string[]

---

##### `productInput`<sup>Optional</sup> <a name="productInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.productInput"></a>

```typescript
public readonly productInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `resourceGroupNameInput`<sup>Optional</sup> <a name="resourceGroupNameInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.resourceGroupNameInput"></a>

```typescript
public readonly resourceGroupNameInput: string;
```

- *Type:* string

---

##### `scalingDownPolicyInput`<sup>Optional</sup> <a name="scalingDownPolicyInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scalingDownPolicyInput"></a>

```typescript
public readonly scalingDownPolicyInput: IResolvable | ElastigroupAzureScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicy">ElastigroupAzureScalingDownPolicy</a>[]

---

##### `scalingUpPolicyInput`<sup>Optional</sup> <a name="scalingUpPolicyInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scalingUpPolicyInput"></a>

```typescript
public readonly scalingUpPolicyInput: IResolvable | ElastigroupAzureScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicy">ElastigroupAzureScalingUpPolicy</a>[]

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | ElastigroupAzureScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScheduledTask">ElastigroupAzureScheduledTask</a>[]

---

##### `shutdownScriptInput`<sup>Optional</sup> <a name="shutdownScriptInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.shutdownScriptInput"></a>

```typescript
public readonly shutdownScriptInput: string;
```

- *Type:* string

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.strategyInput"></a>

```typescript
public readonly strategyInput: ElastigroupAzureStrategy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureStrategy">ElastigroupAzureStrategy</a>

---

##### `updatePolicyInput`<sup>Optional</sup> <a name="updatePolicyInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.updatePolicyInput"></a>

```typescript
public readonly updatePolicyInput: ElastigroupAzureUpdatePolicy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicy">ElastigroupAzureUpdatePolicy</a>

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.ElastigroupAzure.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `customData`<sup>Required</sup> <a name="customData" id="@cdktf/provider-spotinst.ElastigroupAzure.property.customData"></a>

```typescript
public readonly customData: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAzure.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `image`<sup>Required</sup> <a name="image" id="@cdktf/provider-spotinst.ElastigroupAzure.property.image"></a>

```typescript
public readonly image: IResolvable | ElastigroupAzureImage[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureImage">ElastigroupAzureImage</a>[]

---

##### `loadBalancers`<sup>Required</sup> <a name="loadBalancers" id="@cdktf/provider-spotinst.ElastigroupAzure.property.loadBalancers"></a>

```typescript
public readonly loadBalancers: IResolvable | ElastigroupAzureLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureLoadBalancers">ElastigroupAzureLoadBalancers</a>[]

---

##### `lowPrioritySizes`<sup>Required</sup> <a name="lowPrioritySizes" id="@cdktf/provider-spotinst.ElastigroupAzure.property.lowPrioritySizes"></a>

```typescript
public readonly lowPrioritySizes: string[];
```

- *Type:* string[]

---

##### `managedServiceIdentities`<sup>Required</sup> <a name="managedServiceIdentities" id="@cdktf/provider-spotinst.ElastigroupAzure.property.managedServiceIdentities"></a>

```typescript
public readonly managedServiceIdentities: IResolvable | ElastigroupAzureManagedServiceIdentities[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureManagedServiceIdentities">ElastigroupAzureManagedServiceIdentities</a>[]

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupAzure.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupAzure.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupAzure.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `odSizes`<sup>Required</sup> <a name="odSizes" id="@cdktf/provider-spotinst.ElastigroupAzure.property.odSizes"></a>

```typescript
public readonly odSizes: string[];
```

- *Type:* string[]

---

##### `product`<sup>Required</sup> <a name="product" id="@cdktf/provider-spotinst.ElastigroupAzure.property.product"></a>

```typescript
public readonly product: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.ElastigroupAzure.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `resourceGroupName`<sup>Required</sup> <a name="resourceGroupName" id="@cdktf/provider-spotinst.ElastigroupAzure.property.resourceGroupName"></a>

```typescript
public readonly resourceGroupName: string;
```

- *Type:* string

---

##### `scalingDownPolicy`<sup>Required</sup> <a name="scalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scalingDownPolicy"></a>

```typescript
public readonly scalingDownPolicy: IResolvable | ElastigroupAzureScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicy">ElastigroupAzureScalingDownPolicy</a>[]

---

##### `scalingUpPolicy`<sup>Required</sup> <a name="scalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scalingUpPolicy"></a>

```typescript
public readonly scalingUpPolicy: IResolvable | ElastigroupAzureScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicy">ElastigroupAzureScalingUpPolicy</a>[]

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.ElastigroupAzure.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | ElastigroupAzureScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureScheduledTask">ElastigroupAzureScheduledTask</a>[]

---

##### `shutdownScript`<sup>Required</sup> <a name="shutdownScript" id="@cdktf/provider-spotinst.ElastigroupAzure.property.shutdownScript"></a>

```typescript
public readonly shutdownScript: string;
```

- *Type:* string

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.ElastigroupAzure.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzure.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupAzure.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupAzureV3 <a name="ElastigroupAzureV3" id="@cdktf/provider-spotinst.ElastigroupAzureV3"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3 spotinst_elastigroup_azure_v3}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer"></a>

```typescript
import { ElastigroupAzureV3 } from '@cdktf/provider-spotinst'

new ElastigroupAzureV3(scope: Construct, id: string, config: ElastigroupAzureV3Config)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Config">ElastigroupAzureV3Config</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupAzureV3.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Config">ElastigroupAzureV3Config</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.putLogin">putLogin</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.putNetwork">putNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.putStrategy">putStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetCustomData">resetCustomData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetDesiredCapacity">resetDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetImage">resetImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetLogin">resetLogin</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetManagedServiceIdentity">resetManagedServiceIdentity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.resetMinSize">resetMinSize</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupAzureV3.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupAzureV3.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupAzureV3.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzureV3.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzureV3.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzureV3.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupAzureV3.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupAzureV3.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupAzureV3.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putLogin` <a name="putLogin" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putLogin"></a>

```typescript
public putLogin(value: ElastigroupAzureV3Login): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putLogin.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Login">ElastigroupAzureV3Login</a>

---

##### `putNetwork` <a name="putNetwork" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putNetwork"></a>

```typescript
public putNetwork(value: ElastigroupAzureV3Network): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putNetwork.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Network">ElastigroupAzureV3Network</a>

---

##### `putStrategy` <a name="putStrategy" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putStrategy"></a>

```typescript
public putStrategy(value: ElastigroupAzureV3Strategy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupAzureV3.putStrategy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Strategy">ElastigroupAzureV3Strategy</a>

---

##### `resetCustomData` <a name="resetCustomData" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetCustomData"></a>

```typescript
public resetCustomData(): void
```

##### `resetDesiredCapacity` <a name="resetDesiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetDesiredCapacity"></a>

```typescript
public resetDesiredCapacity(): void
```

##### `resetImage` <a name="resetImage" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetImage"></a>

```typescript
public resetImage(): void
```

##### `resetLogin` <a name="resetLogin" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetLogin"></a>

```typescript
public resetLogin(): void
```

##### `resetManagedServiceIdentity` <a name="resetManagedServiceIdentity" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetManagedServiceIdentity"></a>

```typescript
public resetManagedServiceIdentity(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.ElastigroupAzureV3.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupAzureV3.isConstruct"></a>

```typescript
import { ElastigroupAzureV3 } from '@cdktf/provider-spotinst'

ElastigroupAzureV3.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupAzureV3.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.login">login</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3LoginOutputReference">ElastigroupAzureV3LoginOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.network">network</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3NetworkOutputReference">ElastigroupAzureV3NetworkOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.strategy">strategy</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3StrategyOutputReference">ElastigroupAzureV3StrategyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.customDataInput">customDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.imageInput">imageInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Image">ElastigroupAzureV3Image</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.loginInput">loginInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Login">ElastigroupAzureV3Login</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.managedServiceIdentityInput">managedServiceIdentityInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3ManagedServiceIdentity">ElastigroupAzureV3ManagedServiceIdentity</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.networkInput">networkInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Network">ElastigroupAzureV3Network</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.odSizesInput">odSizesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.osInput">osInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.resourceGroupNameInput">resourceGroupNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.spotSizesInput">spotSizesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.strategyInput">strategyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Strategy">ElastigroupAzureV3Strategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.customData">customData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.image">image</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Image">ElastigroupAzureV3Image</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.managedServiceIdentity">managedServiceIdentity</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3ManagedServiceIdentity">ElastigroupAzureV3ManagedServiceIdentity</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.odSizes">odSizes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.os">os</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.resourceGroupName">resourceGroupName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.spotSizes">spotSizes</a></code> | <code>string[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `login`<sup>Required</sup> <a name="login" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.login"></a>

```typescript
public readonly login: ElastigroupAzureV3LoginOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3LoginOutputReference">ElastigroupAzureV3LoginOutputReference</a>

---

##### `network`<sup>Required</sup> <a name="network" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.network"></a>

```typescript
public readonly network: ElastigroupAzureV3NetworkOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3NetworkOutputReference">ElastigroupAzureV3NetworkOutputReference</a>

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.strategy"></a>

```typescript
public readonly strategy: ElastigroupAzureV3StrategyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3StrategyOutputReference">ElastigroupAzureV3StrategyOutputReference</a>

---

##### `customDataInput`<sup>Optional</sup> <a name="customDataInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.customDataInput"></a>

```typescript
public readonly customDataInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `imageInput`<sup>Optional</sup> <a name="imageInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.imageInput"></a>

```typescript
public readonly imageInput: IResolvable | ElastigroupAzureV3Image[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Image">ElastigroupAzureV3Image</a>[]

---

##### `loginInput`<sup>Optional</sup> <a name="loginInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.loginInput"></a>

```typescript
public readonly loginInput: ElastigroupAzureV3Login;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Login">ElastigroupAzureV3Login</a>

---

##### `managedServiceIdentityInput`<sup>Optional</sup> <a name="managedServiceIdentityInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.managedServiceIdentityInput"></a>

```typescript
public readonly managedServiceIdentityInput: IResolvable | ElastigroupAzureV3ManagedServiceIdentity[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3ManagedServiceIdentity">ElastigroupAzureV3ManagedServiceIdentity</a>[]

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInput`<sup>Optional</sup> <a name="networkInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.networkInput"></a>

```typescript
public readonly networkInput: ElastigroupAzureV3Network;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Network">ElastigroupAzureV3Network</a>

---

##### `odSizesInput`<sup>Optional</sup> <a name="odSizesInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.odSizesInput"></a>

```typescript
public readonly odSizesInput: string[];
```

- *Type:* string[]

---

##### `osInput`<sup>Optional</sup> <a name="osInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.osInput"></a>

```typescript
public readonly osInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `resourceGroupNameInput`<sup>Optional</sup> <a name="resourceGroupNameInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.resourceGroupNameInput"></a>

```typescript
public readonly resourceGroupNameInput: string;
```

- *Type:* string

---

##### `spotSizesInput`<sup>Optional</sup> <a name="spotSizesInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.spotSizesInput"></a>

```typescript
public readonly spotSizesInput: string[];
```

- *Type:* string[]

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.strategyInput"></a>

```typescript
public readonly strategyInput: ElastigroupAzureV3Strategy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Strategy">ElastigroupAzureV3Strategy</a>

---

##### `customData`<sup>Required</sup> <a name="customData" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.customData"></a>

```typescript
public readonly customData: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `image`<sup>Required</sup> <a name="image" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.image"></a>

```typescript
public readonly image: IResolvable | ElastigroupAzureV3Image[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3Image">ElastigroupAzureV3Image</a>[]

---

##### `managedServiceIdentity`<sup>Required</sup> <a name="managedServiceIdentity" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.managedServiceIdentity"></a>

```typescript
public readonly managedServiceIdentity: IResolvable | ElastigroupAzureV3ManagedServiceIdentity[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupAzureV3ManagedServiceIdentity">ElastigroupAzureV3ManagedServiceIdentity</a>[]

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `odSizes`<sup>Required</sup> <a name="odSizes" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.odSizes"></a>

```typescript
public readonly odSizes: string[];
```

- *Type:* string[]

---

##### `os`<sup>Required</sup> <a name="os" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.os"></a>

```typescript
public readonly os: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `resourceGroupName`<sup>Required</sup> <a name="resourceGroupName" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.resourceGroupName"></a>

```typescript
public readonly resourceGroupName: string;
```

- *Type:* string

---

##### `spotSizes`<sup>Required</sup> <a name="spotSizes" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.spotSizes"></a>

```typescript
public readonly spotSizes: string[];
```

- *Type:* string[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupAzureV3.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupAzureV3.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupGcp <a name="ElastigroupGcp" id="@cdktf/provider-spotinst.ElastigroupGcp"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupGcp.Initializer"></a>

```typescript
import { ElastigroupGcp } from '@cdktf/provider-spotinst'

new ElastigroupGcp(scope: Construct, id: string, config: ElastigroupGcpConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGcpConfig">ElastigroupGcpConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupGcp.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpConfig">ElastigroupGcpConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationDockerSwarm">putIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationGke">putIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetAutoHealing">resetAutoHealing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetAvailabilityZones">resetAvailabilityZones</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetBackendServices">resetBackendServices</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetDisk">resetDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetFallbackToOndemand">resetFallbackToOndemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetGpu">resetGpu</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetHealthCheckGracePeriod">resetHealthCheckGracePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetHealthCheckType">resetHealthCheckType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesCustom">resetInstanceTypesCustom</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesOndemand">resetInstanceTypesOndemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesPreemptible">resetInstanceTypesPreemptible</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetIntegrationDockerSwarm">resetIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetIntegrationGke">resetIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetIpForwarding">resetIpForwarding</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetLabels">resetLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetMetadata">resetMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetNetworkInterface">resetNetworkInterface</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetOndemandCount">resetOndemandCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetPreemptiblePercentage">resetPreemptiblePercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetProvisioningModel">resetProvisioningModel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetScalingDownPolicy">resetScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetScalingUpPolicy">resetScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetServiceAccount">resetServiceAccount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetShutdownScript">resetShutdownScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetStartupScript">resetStartupScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetSubnets">resetSubnets</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.resetUnhealthyDuration">resetUnhealthyDuration</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupGcp.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupGcp.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupGcp.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGcp.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupGcp.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupGcp.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupGcp.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupGcp.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupGcp.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGcp.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putIntegrationDockerSwarm` <a name="putIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationDockerSwarm"></a>

```typescript
public putIntegrationDockerSwarm(value: ElastigroupGcpIntegrationDockerSwarm): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationDockerSwarm.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarm">ElastigroupGcpIntegrationDockerSwarm</a>

---

##### `putIntegrationGke` <a name="putIntegrationGke" id="@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationGke"></a>

```typescript
public putIntegrationGke(value: ElastigroupGcpIntegrationGke): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGcp.putIntegrationGke.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationGke">ElastigroupGcpIntegrationGke</a>

---

##### `resetAutoHealing` <a name="resetAutoHealing" id="@cdktf/provider-spotinst.ElastigroupGcp.resetAutoHealing"></a>

```typescript
public resetAutoHealing(): void
```

##### `resetAvailabilityZones` <a name="resetAvailabilityZones" id="@cdktf/provider-spotinst.ElastigroupGcp.resetAvailabilityZones"></a>

```typescript
public resetAvailabilityZones(): void
```

##### `resetBackendServices` <a name="resetBackendServices" id="@cdktf/provider-spotinst.ElastigroupGcp.resetBackendServices"></a>

```typescript
public resetBackendServices(): void
```

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-spotinst.ElastigroupGcp.resetDescription"></a>

```typescript
public resetDescription(): void
```

##### `resetDisk` <a name="resetDisk" id="@cdktf/provider-spotinst.ElastigroupGcp.resetDisk"></a>

```typescript
public resetDisk(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.ElastigroupGcp.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetFallbackToOndemand` <a name="resetFallbackToOndemand" id="@cdktf/provider-spotinst.ElastigroupGcp.resetFallbackToOndemand"></a>

```typescript
public resetFallbackToOndemand(): void
```

##### `resetGpu` <a name="resetGpu" id="@cdktf/provider-spotinst.ElastigroupGcp.resetGpu"></a>

```typescript
public resetGpu(): void
```

##### `resetHealthCheckGracePeriod` <a name="resetHealthCheckGracePeriod" id="@cdktf/provider-spotinst.ElastigroupGcp.resetHealthCheckGracePeriod"></a>

```typescript
public resetHealthCheckGracePeriod(): void
```

##### `resetHealthCheckType` <a name="resetHealthCheckType" id="@cdktf/provider-spotinst.ElastigroupGcp.resetHealthCheckType"></a>

```typescript
public resetHealthCheckType(): void
```

##### `resetInstanceTypesCustom` <a name="resetInstanceTypesCustom" id="@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesCustom"></a>

```typescript
public resetInstanceTypesCustom(): void
```

##### `resetInstanceTypesOndemand` <a name="resetInstanceTypesOndemand" id="@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesOndemand"></a>

```typescript
public resetInstanceTypesOndemand(): void
```

##### `resetInstanceTypesPreemptible` <a name="resetInstanceTypesPreemptible" id="@cdktf/provider-spotinst.ElastigroupGcp.resetInstanceTypesPreemptible"></a>

```typescript
public resetInstanceTypesPreemptible(): void
```

##### `resetIntegrationDockerSwarm` <a name="resetIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGcp.resetIntegrationDockerSwarm"></a>

```typescript
public resetIntegrationDockerSwarm(): void
```

##### `resetIntegrationGke` <a name="resetIntegrationGke" id="@cdktf/provider-spotinst.ElastigroupGcp.resetIntegrationGke"></a>

```typescript
public resetIntegrationGke(): void
```

##### `resetIpForwarding` <a name="resetIpForwarding" id="@cdktf/provider-spotinst.ElastigroupGcp.resetIpForwarding"></a>

```typescript
public resetIpForwarding(): void
```

##### `resetLabels` <a name="resetLabels" id="@cdktf/provider-spotinst.ElastigroupGcp.resetLabels"></a>

```typescript
public resetLabels(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.ElastigroupGcp.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMetadata` <a name="resetMetadata" id="@cdktf/provider-spotinst.ElastigroupGcp.resetMetadata"></a>

```typescript
public resetMetadata(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.ElastigroupGcp.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetNetworkInterface` <a name="resetNetworkInterface" id="@cdktf/provider-spotinst.ElastigroupGcp.resetNetworkInterface"></a>

```typescript
public resetNetworkInterface(): void
```

##### `resetOndemandCount` <a name="resetOndemandCount" id="@cdktf/provider-spotinst.ElastigroupGcp.resetOndemandCount"></a>

```typescript
public resetOndemandCount(): void
```

##### `resetPreemptiblePercentage` <a name="resetPreemptiblePercentage" id="@cdktf/provider-spotinst.ElastigroupGcp.resetPreemptiblePercentage"></a>

```typescript
public resetPreemptiblePercentage(): void
```

##### `resetProvisioningModel` <a name="resetProvisioningModel" id="@cdktf/provider-spotinst.ElastigroupGcp.resetProvisioningModel"></a>

```typescript
public resetProvisioningModel(): void
```

##### `resetScalingDownPolicy` <a name="resetScalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupGcp.resetScalingDownPolicy"></a>

```typescript
public resetScalingDownPolicy(): void
```

##### `resetScalingUpPolicy` <a name="resetScalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupGcp.resetScalingUpPolicy"></a>

```typescript
public resetScalingUpPolicy(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.ElastigroupGcp.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetServiceAccount` <a name="resetServiceAccount" id="@cdktf/provider-spotinst.ElastigroupGcp.resetServiceAccount"></a>

```typescript
public resetServiceAccount(): void
```

##### `resetShutdownScript` <a name="resetShutdownScript" id="@cdktf/provider-spotinst.ElastigroupGcp.resetShutdownScript"></a>

```typescript
public resetShutdownScript(): void
```

##### `resetStartupScript` <a name="resetStartupScript" id="@cdktf/provider-spotinst.ElastigroupGcp.resetStartupScript"></a>

```typescript
public resetStartupScript(): void
```

##### `resetSubnets` <a name="resetSubnets" id="@cdktf/provider-spotinst.ElastigroupGcp.resetSubnets"></a>

```typescript
public resetSubnets(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.ElastigroupGcp.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetUnhealthyDuration` <a name="resetUnhealthyDuration" id="@cdktf/provider-spotinst.ElastigroupGcp.resetUnhealthyDuration"></a>

```typescript
public resetUnhealthyDuration(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupGcp.isConstruct"></a>

```typescript
import { ElastigroupGcp } from '@cdktf/provider-spotinst'

ElastigroupGcp.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupGcp.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.integrationDockerSwarm">integrationDockerSwarm</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarmOutputReference">ElastigroupGcpIntegrationDockerSwarmOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.integrationGke">integrationGke</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationGkeOutputReference">ElastigroupGcpIntegrationGkeOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.autoHealingInput">autoHealingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.availabilityZonesInput">availabilityZonesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.backendServicesInput">backendServicesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpBackendServices">ElastigroupGcpBackendServices</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.descriptionInput">descriptionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.diskInput">diskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpDisk">ElastigroupGcpDisk</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.fallbackToOndemandInput">fallbackToOndemandInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.gpuInput">gpuInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpGpu">ElastigroupGcpGpu</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckGracePeriodInput">healthCheckGracePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckTypeInput">healthCheckTypeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesCustomInput">instanceTypesCustomInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpInstanceTypesCustom">ElastigroupGcpInstanceTypesCustom</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesOndemandInput">instanceTypesOndemandInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesPreemptibleInput">instanceTypesPreemptibleInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.integrationDockerSwarmInput">integrationDockerSwarmInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarm">ElastigroupGcpIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.integrationGkeInput">integrationGkeInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationGke">ElastigroupGcpIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.ipForwardingInput">ipForwardingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.labelsInput">labelsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpLabels">ElastigroupGcpLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.metadataInput">metadataInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpMetadata">ElastigroupGcpMetadata</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.networkInterfaceInput">networkInterfaceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpNetworkInterface">ElastigroupGcpNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.ondemandCountInput">ondemandCountInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.preemptiblePercentageInput">preemptiblePercentageInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.provisioningModelInput">provisioningModelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scalingDownPolicyInput">scalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingDownPolicy">ElastigroupGcpScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scalingUpPolicyInput">scalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingUpPolicy">ElastigroupGcpScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScheduledTask">ElastigroupGcpScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.serviceAccountInput">serviceAccountInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.shutdownScriptInput">shutdownScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.startupScriptInput">startupScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.subnetsInput">subnetsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpSubnets">ElastigroupGcpSubnets</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.tagsInput">tagsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.unhealthyDurationInput">unhealthyDurationInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.autoHealing">autoHealing</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.availabilityZones">availabilityZones</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.backendServices">backendServices</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpBackendServices">ElastigroupGcpBackendServices</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.disk">disk</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpDisk">ElastigroupGcpDisk</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.fallbackToOndemand">fallbackToOndemand</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.gpu">gpu</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpGpu">ElastigroupGcpGpu</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckGracePeriod">healthCheckGracePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckType">healthCheckType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesCustom">instanceTypesCustom</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpInstanceTypesCustom">ElastigroupGcpInstanceTypesCustom</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesOndemand">instanceTypesOndemand</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesPreemptible">instanceTypesPreemptible</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.ipForwarding">ipForwarding</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.labels">labels</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpLabels">ElastigroupGcpLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.metadata">metadata</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpMetadata">ElastigroupGcpMetadata</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.networkInterface">networkInterface</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpNetworkInterface">ElastigroupGcpNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.ondemandCount">ondemandCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.preemptiblePercentage">preemptiblePercentage</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.provisioningModel">provisioningModel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scalingDownPolicy">scalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingDownPolicy">ElastigroupGcpScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scalingUpPolicy">scalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingUpPolicy">ElastigroupGcpScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpScheduledTask">ElastigroupGcpScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.serviceAccount">serviceAccount</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.shutdownScript">shutdownScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.startupScript">startupScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.subnets">subnets</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGcpSubnets">ElastigroupGcpSubnets</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.tags">tags</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.unhealthyDuration">unhealthyDuration</a></code> | <code>number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupGcp.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupGcp.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupGcp.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupGcp.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupGcp.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupGcp.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupGcp.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupGcp.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupGcp.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupGcp.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupGcp.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupGcp.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `integrationDockerSwarm`<sup>Required</sup> <a name="integrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGcp.property.integrationDockerSwarm"></a>

```typescript
public readonly integrationDockerSwarm: ElastigroupGcpIntegrationDockerSwarmOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarmOutputReference">ElastigroupGcpIntegrationDockerSwarmOutputReference</a>

---

##### `integrationGke`<sup>Required</sup> <a name="integrationGke" id="@cdktf/provider-spotinst.ElastigroupGcp.property.integrationGke"></a>

```typescript
public readonly integrationGke: ElastigroupGcpIntegrationGkeOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationGkeOutputReference">ElastigroupGcpIntegrationGkeOutputReference</a>

---

##### `autoHealingInput`<sup>Optional</sup> <a name="autoHealingInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.autoHealingInput"></a>

```typescript
public readonly autoHealingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `availabilityZonesInput`<sup>Optional</sup> <a name="availabilityZonesInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.availabilityZonesInput"></a>

```typescript
public readonly availabilityZonesInput: string[];
```

- *Type:* string[]

---

##### `backendServicesInput`<sup>Optional</sup> <a name="backendServicesInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.backendServicesInput"></a>

```typescript
public readonly backendServicesInput: IResolvable | ElastigroupGcpBackendServices[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpBackendServices">ElastigroupGcpBackendServices</a>[]

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.descriptionInput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `diskInput`<sup>Optional</sup> <a name="diskInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.diskInput"></a>

```typescript
public readonly diskInput: IResolvable | ElastigroupGcpDisk[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpDisk">ElastigroupGcpDisk</a>[]

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `fallbackToOndemandInput`<sup>Optional</sup> <a name="fallbackToOndemandInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.fallbackToOndemandInput"></a>

```typescript
public readonly fallbackToOndemandInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gpuInput`<sup>Optional</sup> <a name="gpuInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.gpuInput"></a>

```typescript
public readonly gpuInput: IResolvable | ElastigroupGcpGpu[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpGpu">ElastigroupGcpGpu</a>[]

---

##### `healthCheckGracePeriodInput`<sup>Optional</sup> <a name="healthCheckGracePeriodInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckGracePeriodInput"></a>

```typescript
public readonly healthCheckGracePeriodInput: number;
```

- *Type:* number

---

##### `healthCheckTypeInput`<sup>Optional</sup> <a name="healthCheckTypeInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckTypeInput"></a>

```typescript
public readonly healthCheckTypeInput: string;
```

- *Type:* string

---

##### `instanceTypesCustomInput`<sup>Optional</sup> <a name="instanceTypesCustomInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesCustomInput"></a>

```typescript
public readonly instanceTypesCustomInput: IResolvable | ElastigroupGcpInstanceTypesCustom[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpInstanceTypesCustom">ElastigroupGcpInstanceTypesCustom</a>[]

---

##### `instanceTypesOndemandInput`<sup>Optional</sup> <a name="instanceTypesOndemandInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesOndemandInput"></a>

```typescript
public readonly instanceTypesOndemandInput: string;
```

- *Type:* string

---

##### `instanceTypesPreemptibleInput`<sup>Optional</sup> <a name="instanceTypesPreemptibleInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesPreemptibleInput"></a>

```typescript
public readonly instanceTypesPreemptibleInput: string[];
```

- *Type:* string[]

---

##### `integrationDockerSwarmInput`<sup>Optional</sup> <a name="integrationDockerSwarmInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.integrationDockerSwarmInput"></a>

```typescript
public readonly integrationDockerSwarmInput: ElastigroupGcpIntegrationDockerSwarm;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarm">ElastigroupGcpIntegrationDockerSwarm</a>

---

##### `integrationGkeInput`<sup>Optional</sup> <a name="integrationGkeInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.integrationGkeInput"></a>

```typescript
public readonly integrationGkeInput: ElastigroupGcpIntegrationGke;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGcpIntegrationGke">ElastigroupGcpIntegrationGke</a>

---

##### `ipForwardingInput`<sup>Optional</sup> <a name="ipForwardingInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.ipForwardingInput"></a>

```typescript
public readonly ipForwardingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `labelsInput`<sup>Optional</sup> <a name="labelsInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.labelsInput"></a>

```typescript
public readonly labelsInput: IResolvable | ElastigroupGcpLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpLabels">ElastigroupGcpLabels</a>[]

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `metadataInput`<sup>Optional</sup> <a name="metadataInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.metadataInput"></a>

```typescript
public readonly metadataInput: IResolvable | ElastigroupGcpMetadata[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpMetadata">ElastigroupGcpMetadata</a>[]

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInterfaceInput`<sup>Optional</sup> <a name="networkInterfaceInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.networkInterfaceInput"></a>

```typescript
public readonly networkInterfaceInput: IResolvable | ElastigroupGcpNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpNetworkInterface">ElastigroupGcpNetworkInterface</a>[]

---

##### `ondemandCountInput`<sup>Optional</sup> <a name="ondemandCountInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.ondemandCountInput"></a>

```typescript
public readonly ondemandCountInput: number;
```

- *Type:* number

---

##### `preemptiblePercentageInput`<sup>Optional</sup> <a name="preemptiblePercentageInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.preemptiblePercentageInput"></a>

```typescript
public readonly preemptiblePercentageInput: number;
```

- *Type:* number

---

##### `provisioningModelInput`<sup>Optional</sup> <a name="provisioningModelInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.provisioningModelInput"></a>

```typescript
public readonly provisioningModelInput: string;
```

- *Type:* string

---

##### `scalingDownPolicyInput`<sup>Optional</sup> <a name="scalingDownPolicyInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scalingDownPolicyInput"></a>

```typescript
public readonly scalingDownPolicyInput: IResolvable | ElastigroupGcpScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingDownPolicy">ElastigroupGcpScalingDownPolicy</a>[]

---

##### `scalingUpPolicyInput`<sup>Optional</sup> <a name="scalingUpPolicyInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scalingUpPolicyInput"></a>

```typescript
public readonly scalingUpPolicyInput: IResolvable | ElastigroupGcpScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingUpPolicy">ElastigroupGcpScalingUpPolicy</a>[]

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | ElastigroupGcpScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScheduledTask">ElastigroupGcpScheduledTask</a>[]

---

##### `serviceAccountInput`<sup>Optional</sup> <a name="serviceAccountInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.serviceAccountInput"></a>

```typescript
public readonly serviceAccountInput: string;
```

- *Type:* string

---

##### `shutdownScriptInput`<sup>Optional</sup> <a name="shutdownScriptInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.shutdownScriptInput"></a>

```typescript
public readonly shutdownScriptInput: string;
```

- *Type:* string

---

##### `startupScriptInput`<sup>Optional</sup> <a name="startupScriptInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.startupScriptInput"></a>

```typescript
public readonly startupScriptInput: string;
```

- *Type:* string

---

##### `subnetsInput`<sup>Optional</sup> <a name="subnetsInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.subnetsInput"></a>

```typescript
public readonly subnetsInput: IResolvable | ElastigroupGcpSubnets[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpSubnets">ElastigroupGcpSubnets</a>[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.tagsInput"></a>

```typescript
public readonly tagsInput: string[];
```

- *Type:* string[]

---

##### `unhealthyDurationInput`<sup>Optional</sup> <a name="unhealthyDurationInput" id="@cdktf/provider-spotinst.ElastigroupGcp.property.unhealthyDurationInput"></a>

```typescript
public readonly unhealthyDurationInput: number;
```

- *Type:* number

---

##### `autoHealing`<sup>Required</sup> <a name="autoHealing" id="@cdktf/provider-spotinst.ElastigroupGcp.property.autoHealing"></a>

```typescript
public readonly autoHealing: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `availabilityZones`<sup>Required</sup> <a name="availabilityZones" id="@cdktf/provider-spotinst.ElastigroupGcp.property.availabilityZones"></a>

```typescript
public readonly availabilityZones: string[];
```

- *Type:* string[]

---

##### `backendServices`<sup>Required</sup> <a name="backendServices" id="@cdktf/provider-spotinst.ElastigroupGcp.property.backendServices"></a>

```typescript
public readonly backendServices: IResolvable | ElastigroupGcpBackendServices[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpBackendServices">ElastigroupGcpBackendServices</a>[]

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-spotinst.ElastigroupGcp.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupGcp.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `disk`<sup>Required</sup> <a name="disk" id="@cdktf/provider-spotinst.ElastigroupGcp.property.disk"></a>

```typescript
public readonly disk: IResolvable | ElastigroupGcpDisk[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpDisk">ElastigroupGcpDisk</a>[]

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.ElastigroupGcp.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `fallbackToOndemand`<sup>Required</sup> <a name="fallbackToOndemand" id="@cdktf/provider-spotinst.ElastigroupGcp.property.fallbackToOndemand"></a>

```typescript
public readonly fallbackToOndemand: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gpu`<sup>Required</sup> <a name="gpu" id="@cdktf/provider-spotinst.ElastigroupGcp.property.gpu"></a>

```typescript
public readonly gpu: IResolvable | ElastigroupGcpGpu[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpGpu">ElastigroupGcpGpu</a>[]

---

##### `healthCheckGracePeriod`<sup>Required</sup> <a name="healthCheckGracePeriod" id="@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckGracePeriod"></a>

```typescript
public readonly healthCheckGracePeriod: number;
```

- *Type:* number

---

##### `healthCheckType`<sup>Required</sup> <a name="healthCheckType" id="@cdktf/provider-spotinst.ElastigroupGcp.property.healthCheckType"></a>

```typescript
public readonly healthCheckType: string;
```

- *Type:* string

---

##### `instanceTypesCustom`<sup>Required</sup> <a name="instanceTypesCustom" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesCustom"></a>

```typescript
public readonly instanceTypesCustom: IResolvable | ElastigroupGcpInstanceTypesCustom[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpInstanceTypesCustom">ElastigroupGcpInstanceTypesCustom</a>[]

---

##### `instanceTypesOndemand`<sup>Required</sup> <a name="instanceTypesOndemand" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesOndemand"></a>

```typescript
public readonly instanceTypesOndemand: string;
```

- *Type:* string

---

##### `instanceTypesPreemptible`<sup>Required</sup> <a name="instanceTypesPreemptible" id="@cdktf/provider-spotinst.ElastigroupGcp.property.instanceTypesPreemptible"></a>

```typescript
public readonly instanceTypesPreemptible: string[];
```

- *Type:* string[]

---

##### `ipForwarding`<sup>Required</sup> <a name="ipForwarding" id="@cdktf/provider-spotinst.ElastigroupGcp.property.ipForwarding"></a>

```typescript
public readonly ipForwarding: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `labels`<sup>Required</sup> <a name="labels" id="@cdktf/provider-spotinst.ElastigroupGcp.property.labels"></a>

```typescript
public readonly labels: IResolvable | ElastigroupGcpLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpLabels">ElastigroupGcpLabels</a>[]

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupGcp.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="@cdktf/provider-spotinst.ElastigroupGcp.property.metadata"></a>

```typescript
public readonly metadata: IResolvable | ElastigroupGcpMetadata[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpMetadata">ElastigroupGcpMetadata</a>[]

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupGcp.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupGcp.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `networkInterface`<sup>Required</sup> <a name="networkInterface" id="@cdktf/provider-spotinst.ElastigroupGcp.property.networkInterface"></a>

```typescript
public readonly networkInterface: IResolvable | ElastigroupGcpNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpNetworkInterface">ElastigroupGcpNetworkInterface</a>[]

---

##### `ondemandCount`<sup>Required</sup> <a name="ondemandCount" id="@cdktf/provider-spotinst.ElastigroupGcp.property.ondemandCount"></a>

```typescript
public readonly ondemandCount: number;
```

- *Type:* number

---

##### `preemptiblePercentage`<sup>Required</sup> <a name="preemptiblePercentage" id="@cdktf/provider-spotinst.ElastigroupGcp.property.preemptiblePercentage"></a>

```typescript
public readonly preemptiblePercentage: number;
```

- *Type:* number

---

##### `provisioningModel`<sup>Required</sup> <a name="provisioningModel" id="@cdktf/provider-spotinst.ElastigroupGcp.property.provisioningModel"></a>

```typescript
public readonly provisioningModel: string;
```

- *Type:* string

---

##### `scalingDownPolicy`<sup>Required</sup> <a name="scalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scalingDownPolicy"></a>

```typescript
public readonly scalingDownPolicy: IResolvable | ElastigroupGcpScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingDownPolicy">ElastigroupGcpScalingDownPolicy</a>[]

---

##### `scalingUpPolicy`<sup>Required</sup> <a name="scalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scalingUpPolicy"></a>

```typescript
public readonly scalingUpPolicy: IResolvable | ElastigroupGcpScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScalingUpPolicy">ElastigroupGcpScalingUpPolicy</a>[]

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.ElastigroupGcp.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | ElastigroupGcpScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpScheduledTask">ElastigroupGcpScheduledTask</a>[]

---

##### `serviceAccount`<sup>Required</sup> <a name="serviceAccount" id="@cdktf/provider-spotinst.ElastigroupGcp.property.serviceAccount"></a>

```typescript
public readonly serviceAccount: string;
```

- *Type:* string

---

##### `shutdownScript`<sup>Required</sup> <a name="shutdownScript" id="@cdktf/provider-spotinst.ElastigroupGcp.property.shutdownScript"></a>

```typescript
public readonly shutdownScript: string;
```

- *Type:* string

---

##### `startupScript`<sup>Required</sup> <a name="startupScript" id="@cdktf/provider-spotinst.ElastigroupGcp.property.startupScript"></a>

```typescript
public readonly startupScript: string;
```

- *Type:* string

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="@cdktf/provider-spotinst.ElastigroupGcp.property.subnets"></a>

```typescript
public readonly subnets: IResolvable | ElastigroupGcpSubnets[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGcpSubnets">ElastigroupGcpSubnets</a>[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.ElastigroupGcp.property.tags"></a>

```typescript
public readonly tags: string[];
```

- *Type:* string[]

---

##### `unhealthyDuration`<sup>Required</sup> <a name="unhealthyDuration" id="@cdktf/provider-spotinst.ElastigroupGcp.property.unhealthyDuration"></a>

```typescript
public readonly unhealthyDuration: number;
```

- *Type:* number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGcp.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupGcp.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ElastigroupGke <a name="ElastigroupGke" id="@cdktf/provider-spotinst.ElastigroupGke"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke spotinst_elastigroup_gke}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ElastigroupGke.Initializer"></a>

```typescript
import { ElastigroupGke } from '@cdktf/provider-spotinst'

new ElastigroupGke(scope: Construct, id: string, config: ElastigroupGkeConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGkeConfig">ElastigroupGkeConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ElastigroupGke.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeConfig">ElastigroupGkeConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.putIntegrationDockerSwarm">putIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.putIntegrationGke">putIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetBackendServices">resetBackendServices</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetClusterId">resetClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetDisk">resetDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetFallbackToOndemand">resetFallbackToOndemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetGpu">resetGpu</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesCustom">resetInstanceTypesCustom</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesOndemand">resetInstanceTypesOndemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesPreemptible">resetInstanceTypesPreemptible</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetIntegrationDockerSwarm">resetIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetIntegrationGke">resetIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetIpForwarding">resetIpForwarding</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetLabels">resetLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetMetadata">resetMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetNetworkInterface">resetNetworkInterface</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetNodeImage">resetNodeImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetOndemandCount">resetOndemandCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetPreemptiblePercentage">resetPreemptiblePercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetProvisioningModel">resetProvisioningModel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetScalingDownPolicy">resetScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetScalingUpPolicy">resetScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetServiceAccount">resetServiceAccount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetShutdownScript">resetShutdownScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetStartupScript">resetStartupScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.resetTags">resetTags</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ElastigroupGke.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ElastigroupGke.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ElastigroupGke.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGke.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupGke.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ElastigroupGke.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ElastigroupGke.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ElastigroupGke.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ElastigroupGke.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ElastigroupGke.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putIntegrationDockerSwarm` <a name="putIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGke.putIntegrationDockerSwarm"></a>

```typescript
public putIntegrationDockerSwarm(value: ElastigroupGkeIntegrationDockerSwarm): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGke.putIntegrationDockerSwarm.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationDockerSwarm">ElastigroupGkeIntegrationDockerSwarm</a>

---

##### `putIntegrationGke` <a name="putIntegrationGke" id="@cdktf/provider-spotinst.ElastigroupGke.putIntegrationGke"></a>

```typescript
public putIntegrationGke(value: ElastigroupGkeIntegrationGke): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ElastigroupGke.putIntegrationGke.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationGke">ElastigroupGkeIntegrationGke</a>

---

##### `resetBackendServices` <a name="resetBackendServices" id="@cdktf/provider-spotinst.ElastigroupGke.resetBackendServices"></a>

```typescript
public resetBackendServices(): void
```

##### `resetClusterId` <a name="resetClusterId" id="@cdktf/provider-spotinst.ElastigroupGke.resetClusterId"></a>

```typescript
public resetClusterId(): void
```

##### `resetDisk` <a name="resetDisk" id="@cdktf/provider-spotinst.ElastigroupGke.resetDisk"></a>

```typescript
public resetDisk(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.ElastigroupGke.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetFallbackToOndemand` <a name="resetFallbackToOndemand" id="@cdktf/provider-spotinst.ElastigroupGke.resetFallbackToOndemand"></a>

```typescript
public resetFallbackToOndemand(): void
```

##### `resetGpu` <a name="resetGpu" id="@cdktf/provider-spotinst.ElastigroupGke.resetGpu"></a>

```typescript
public resetGpu(): void
```

##### `resetInstanceTypesCustom` <a name="resetInstanceTypesCustom" id="@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesCustom"></a>

```typescript
public resetInstanceTypesCustom(): void
```

##### `resetInstanceTypesOndemand` <a name="resetInstanceTypesOndemand" id="@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesOndemand"></a>

```typescript
public resetInstanceTypesOndemand(): void
```

##### `resetInstanceTypesPreemptible` <a name="resetInstanceTypesPreemptible" id="@cdktf/provider-spotinst.ElastigroupGke.resetInstanceTypesPreemptible"></a>

```typescript
public resetInstanceTypesPreemptible(): void
```

##### `resetIntegrationDockerSwarm` <a name="resetIntegrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGke.resetIntegrationDockerSwarm"></a>

```typescript
public resetIntegrationDockerSwarm(): void
```

##### `resetIntegrationGke` <a name="resetIntegrationGke" id="@cdktf/provider-spotinst.ElastigroupGke.resetIntegrationGke"></a>

```typescript
public resetIntegrationGke(): void
```

##### `resetIpForwarding` <a name="resetIpForwarding" id="@cdktf/provider-spotinst.ElastigroupGke.resetIpForwarding"></a>

```typescript
public resetIpForwarding(): void
```

##### `resetLabels` <a name="resetLabels" id="@cdktf/provider-spotinst.ElastigroupGke.resetLabels"></a>

```typescript
public resetLabels(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.ElastigroupGke.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMetadata` <a name="resetMetadata" id="@cdktf/provider-spotinst.ElastigroupGke.resetMetadata"></a>

```typescript
public resetMetadata(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.ElastigroupGke.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetNetworkInterface` <a name="resetNetworkInterface" id="@cdktf/provider-spotinst.ElastigroupGke.resetNetworkInterface"></a>

```typescript
public resetNetworkInterface(): void
```

##### `resetNodeImage` <a name="resetNodeImage" id="@cdktf/provider-spotinst.ElastigroupGke.resetNodeImage"></a>

```typescript
public resetNodeImage(): void
```

##### `resetOndemandCount` <a name="resetOndemandCount" id="@cdktf/provider-spotinst.ElastigroupGke.resetOndemandCount"></a>

```typescript
public resetOndemandCount(): void
```

##### `resetPreemptiblePercentage` <a name="resetPreemptiblePercentage" id="@cdktf/provider-spotinst.ElastigroupGke.resetPreemptiblePercentage"></a>

```typescript
public resetPreemptiblePercentage(): void
```

##### `resetProvisioningModel` <a name="resetProvisioningModel" id="@cdktf/provider-spotinst.ElastigroupGke.resetProvisioningModel"></a>

```typescript
public resetProvisioningModel(): void
```

##### `resetScalingDownPolicy` <a name="resetScalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupGke.resetScalingDownPolicy"></a>

```typescript
public resetScalingDownPolicy(): void
```

##### `resetScalingUpPolicy` <a name="resetScalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupGke.resetScalingUpPolicy"></a>

```typescript
public resetScalingUpPolicy(): void
```

##### `resetServiceAccount` <a name="resetServiceAccount" id="@cdktf/provider-spotinst.ElastigroupGke.resetServiceAccount"></a>

```typescript
public resetServiceAccount(): void
```

##### `resetShutdownScript` <a name="resetShutdownScript" id="@cdktf/provider-spotinst.ElastigroupGke.resetShutdownScript"></a>

```typescript
public resetShutdownScript(): void
```

##### `resetStartupScript` <a name="resetStartupScript" id="@cdktf/provider-spotinst.ElastigroupGke.resetStartupScript"></a>

```typescript
public resetStartupScript(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.ElastigroupGke.resetTags"></a>

```typescript
public resetTags(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ElastigroupGke.isConstruct"></a>

```typescript
import { ElastigroupGke } from '@cdktf/provider-spotinst'

ElastigroupGke.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ElastigroupGke.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.integrationDockerSwarm">integrationDockerSwarm</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationDockerSwarmOutputReference">ElastigroupGkeIntegrationDockerSwarmOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.integrationGke">integrationGke</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationGkeOutputReference">ElastigroupGkeIntegrationGkeOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.backendServicesInput">backendServicesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeBackendServices">ElastigroupGkeBackendServices</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.clusterIdInput">clusterIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.clusterZoneNameInput">clusterZoneNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.diskInput">diskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeDisk">ElastigroupGkeDisk</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.fallbackToOndemandInput">fallbackToOndemandInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.gpuInput">gpuInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeGpu">ElastigroupGkeGpu</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesCustomInput">instanceTypesCustomInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeInstanceTypesCustom">ElastigroupGkeInstanceTypesCustom</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesOndemandInput">instanceTypesOndemandInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesPreemptibleInput">instanceTypesPreemptibleInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.integrationDockerSwarmInput">integrationDockerSwarmInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationDockerSwarm">ElastigroupGkeIntegrationDockerSwarm</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.integrationGkeInput">integrationGkeInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationGke">ElastigroupGkeIntegrationGke</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.ipForwardingInput">ipForwardingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.labelsInput">labelsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeLabels">ElastigroupGkeLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.metadataInput">metadataInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeMetadata">ElastigroupGkeMetadata</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.networkInterfaceInput">networkInterfaceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeNetworkInterface">ElastigroupGkeNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.nodeImageInput">nodeImageInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.ondemandCountInput">ondemandCountInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.preemptiblePercentageInput">preemptiblePercentageInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.provisioningModelInput">provisioningModelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.scalingDownPolicyInput">scalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingDownPolicy">ElastigroupGkeScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.scalingUpPolicyInput">scalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingUpPolicy">ElastigroupGkeScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.serviceAccountInput">serviceAccountInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.shutdownScriptInput">shutdownScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.startupScriptInput">startupScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.tagsInput">tagsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.backendServices">backendServices</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeBackendServices">ElastigroupGkeBackendServices</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.clusterId">clusterId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.clusterZoneName">clusterZoneName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.disk">disk</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeDisk">ElastigroupGkeDisk</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.fallbackToOndemand">fallbackToOndemand</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.gpu">gpu</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeGpu">ElastigroupGkeGpu</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesCustom">instanceTypesCustom</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeInstanceTypesCustom">ElastigroupGkeInstanceTypesCustom</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesOndemand">instanceTypesOndemand</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesPreemptible">instanceTypesPreemptible</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.ipForwarding">ipForwarding</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.labels">labels</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeLabels">ElastigroupGkeLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.metadata">metadata</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeMetadata">ElastigroupGkeMetadata</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.networkInterface">networkInterface</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeNetworkInterface">ElastigroupGkeNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.nodeImage">nodeImage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.ondemandCount">ondemandCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.preemptiblePercentage">preemptiblePercentage</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.provisioningModel">provisioningModel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.scalingDownPolicy">scalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingDownPolicy">ElastigroupGkeScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.scalingUpPolicy">scalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingUpPolicy">ElastigroupGkeScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.serviceAccount">serviceAccount</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.shutdownScript">shutdownScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.startupScript">startupScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.tags">tags</a></code> | <code>string[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ElastigroupGke.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ElastigroupGke.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ElastigroupGke.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ElastigroupGke.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ElastigroupGke.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ElastigroupGke.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ElastigroupGke.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ElastigroupGke.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ElastigroupGke.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ElastigroupGke.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ElastigroupGke.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ElastigroupGke.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `integrationDockerSwarm`<sup>Required</sup> <a name="integrationDockerSwarm" id="@cdktf/provider-spotinst.ElastigroupGke.property.integrationDockerSwarm"></a>

```typescript
public readonly integrationDockerSwarm: ElastigroupGkeIntegrationDockerSwarmOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationDockerSwarmOutputReference">ElastigroupGkeIntegrationDockerSwarmOutputReference</a>

---

##### `integrationGke`<sup>Required</sup> <a name="integrationGke" id="@cdktf/provider-spotinst.ElastigroupGke.property.integrationGke"></a>

```typescript
public readonly integrationGke: ElastigroupGkeIntegrationGkeOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationGkeOutputReference">ElastigroupGkeIntegrationGkeOutputReference</a>

---

##### `backendServicesInput`<sup>Optional</sup> <a name="backendServicesInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.backendServicesInput"></a>

```typescript
public readonly backendServicesInput: IResolvable | ElastigroupGkeBackendServices[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeBackendServices">ElastigroupGkeBackendServices</a>[]

---

##### `clusterIdInput`<sup>Optional</sup> <a name="clusterIdInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.clusterIdInput"></a>

```typescript
public readonly clusterIdInput: string;
```

- *Type:* string

---

##### `clusterZoneNameInput`<sup>Optional</sup> <a name="clusterZoneNameInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.clusterZoneNameInput"></a>

```typescript
public readonly clusterZoneNameInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `diskInput`<sup>Optional</sup> <a name="diskInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.diskInput"></a>

```typescript
public readonly diskInput: IResolvable | ElastigroupGkeDisk[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeDisk">ElastigroupGkeDisk</a>[]

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `fallbackToOndemandInput`<sup>Optional</sup> <a name="fallbackToOndemandInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.fallbackToOndemandInput"></a>

```typescript
public readonly fallbackToOndemandInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gpuInput`<sup>Optional</sup> <a name="gpuInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.gpuInput"></a>

```typescript
public readonly gpuInput: IResolvable | ElastigroupGkeGpu[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeGpu">ElastigroupGkeGpu</a>[]

---

##### `instanceTypesCustomInput`<sup>Optional</sup> <a name="instanceTypesCustomInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesCustomInput"></a>

```typescript
public readonly instanceTypesCustomInput: IResolvable | ElastigroupGkeInstanceTypesCustom[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeInstanceTypesCustom">ElastigroupGkeInstanceTypesCustom</a>[]

---

##### `instanceTypesOndemandInput`<sup>Optional</sup> <a name="instanceTypesOndemandInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesOndemandInput"></a>

```typescript
public readonly instanceTypesOndemandInput: string;
```

- *Type:* string

---

##### `instanceTypesPreemptibleInput`<sup>Optional</sup> <a name="instanceTypesPreemptibleInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesPreemptibleInput"></a>

```typescript
public readonly instanceTypesPreemptibleInput: string[];
```

- *Type:* string[]

---

##### `integrationDockerSwarmInput`<sup>Optional</sup> <a name="integrationDockerSwarmInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.integrationDockerSwarmInput"></a>

```typescript
public readonly integrationDockerSwarmInput: ElastigroupGkeIntegrationDockerSwarm;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationDockerSwarm">ElastigroupGkeIntegrationDockerSwarm</a>

---

##### `integrationGkeInput`<sup>Optional</sup> <a name="integrationGkeInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.integrationGkeInput"></a>

```typescript
public readonly integrationGkeInput: ElastigroupGkeIntegrationGke;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ElastigroupGkeIntegrationGke">ElastigroupGkeIntegrationGke</a>

---

##### `ipForwardingInput`<sup>Optional</sup> <a name="ipForwardingInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.ipForwardingInput"></a>

```typescript
public readonly ipForwardingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `labelsInput`<sup>Optional</sup> <a name="labelsInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.labelsInput"></a>

```typescript
public readonly labelsInput: IResolvable | ElastigroupGkeLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeLabels">ElastigroupGkeLabels</a>[]

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `metadataInput`<sup>Optional</sup> <a name="metadataInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.metadataInput"></a>

```typescript
public readonly metadataInput: IResolvable | ElastigroupGkeMetadata[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeMetadata">ElastigroupGkeMetadata</a>[]

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInterfaceInput`<sup>Optional</sup> <a name="networkInterfaceInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.networkInterfaceInput"></a>

```typescript
public readonly networkInterfaceInput: IResolvable | ElastigroupGkeNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeNetworkInterface">ElastigroupGkeNetworkInterface</a>[]

---

##### `nodeImageInput`<sup>Optional</sup> <a name="nodeImageInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.nodeImageInput"></a>

```typescript
public readonly nodeImageInput: string;
```

- *Type:* string

---

##### `ondemandCountInput`<sup>Optional</sup> <a name="ondemandCountInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.ondemandCountInput"></a>

```typescript
public readonly ondemandCountInput: number;
```

- *Type:* number

---

##### `preemptiblePercentageInput`<sup>Optional</sup> <a name="preemptiblePercentageInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.preemptiblePercentageInput"></a>

```typescript
public readonly preemptiblePercentageInput: number;
```

- *Type:* number

---

##### `provisioningModelInput`<sup>Optional</sup> <a name="provisioningModelInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.provisioningModelInput"></a>

```typescript
public readonly provisioningModelInput: string;
```

- *Type:* string

---

##### `scalingDownPolicyInput`<sup>Optional</sup> <a name="scalingDownPolicyInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.scalingDownPolicyInput"></a>

```typescript
public readonly scalingDownPolicyInput: IResolvable | ElastigroupGkeScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingDownPolicy">ElastigroupGkeScalingDownPolicy</a>[]

---

##### `scalingUpPolicyInput`<sup>Optional</sup> <a name="scalingUpPolicyInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.scalingUpPolicyInput"></a>

```typescript
public readonly scalingUpPolicyInput: IResolvable | ElastigroupGkeScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingUpPolicy">ElastigroupGkeScalingUpPolicy</a>[]

---

##### `serviceAccountInput`<sup>Optional</sup> <a name="serviceAccountInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.serviceAccountInput"></a>

```typescript
public readonly serviceAccountInput: string;
```

- *Type:* string

---

##### `shutdownScriptInput`<sup>Optional</sup> <a name="shutdownScriptInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.shutdownScriptInput"></a>

```typescript
public readonly shutdownScriptInput: string;
```

- *Type:* string

---

##### `startupScriptInput`<sup>Optional</sup> <a name="startupScriptInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.startupScriptInput"></a>

```typescript
public readonly startupScriptInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.ElastigroupGke.property.tagsInput"></a>

```typescript
public readonly tagsInput: string[];
```

- *Type:* string[]

---

##### `backendServices`<sup>Required</sup> <a name="backendServices" id="@cdktf/provider-spotinst.ElastigroupGke.property.backendServices"></a>

```typescript
public readonly backendServices: IResolvable | ElastigroupGkeBackendServices[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeBackendServices">ElastigroupGkeBackendServices</a>[]

---

##### `clusterId`<sup>Required</sup> <a name="clusterId" id="@cdktf/provider-spotinst.ElastigroupGke.property.clusterId"></a>

```typescript
public readonly clusterId: string;
```

- *Type:* string

---

##### `clusterZoneName`<sup>Required</sup> <a name="clusterZoneName" id="@cdktf/provider-spotinst.ElastigroupGke.property.clusterZoneName"></a>

```typescript
public readonly clusterZoneName: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.ElastigroupGke.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `disk`<sup>Required</sup> <a name="disk" id="@cdktf/provider-spotinst.ElastigroupGke.property.disk"></a>

```typescript
public readonly disk: IResolvable | ElastigroupGkeDisk[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeDisk">ElastigroupGkeDisk</a>[]

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.ElastigroupGke.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `fallbackToOndemand`<sup>Required</sup> <a name="fallbackToOndemand" id="@cdktf/provider-spotinst.ElastigroupGke.property.fallbackToOndemand"></a>

```typescript
public readonly fallbackToOndemand: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gpu`<sup>Required</sup> <a name="gpu" id="@cdktf/provider-spotinst.ElastigroupGke.property.gpu"></a>

```typescript
public readonly gpu: IResolvable | ElastigroupGkeGpu[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeGpu">ElastigroupGkeGpu</a>[]

---

##### `instanceTypesCustom`<sup>Required</sup> <a name="instanceTypesCustom" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesCustom"></a>

```typescript
public readonly instanceTypesCustom: IResolvable | ElastigroupGkeInstanceTypesCustom[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeInstanceTypesCustom">ElastigroupGkeInstanceTypesCustom</a>[]

---

##### `instanceTypesOndemand`<sup>Required</sup> <a name="instanceTypesOndemand" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesOndemand"></a>

```typescript
public readonly instanceTypesOndemand: string;
```

- *Type:* string

---

##### `instanceTypesPreemptible`<sup>Required</sup> <a name="instanceTypesPreemptible" id="@cdktf/provider-spotinst.ElastigroupGke.property.instanceTypesPreemptible"></a>

```typescript
public readonly instanceTypesPreemptible: string[];
```

- *Type:* string[]

---

##### `ipForwarding`<sup>Required</sup> <a name="ipForwarding" id="@cdktf/provider-spotinst.ElastigroupGke.property.ipForwarding"></a>

```typescript
public readonly ipForwarding: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `labels`<sup>Required</sup> <a name="labels" id="@cdktf/provider-spotinst.ElastigroupGke.property.labels"></a>

```typescript
public readonly labels: IResolvable | ElastigroupGkeLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeLabels">ElastigroupGkeLabels</a>[]

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.ElastigroupGke.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="@cdktf/provider-spotinst.ElastigroupGke.property.metadata"></a>

```typescript
public readonly metadata: IResolvable | ElastigroupGkeMetadata[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeMetadata">ElastigroupGkeMetadata</a>[]

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.ElastigroupGke.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ElastigroupGke.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `networkInterface`<sup>Required</sup> <a name="networkInterface" id="@cdktf/provider-spotinst.ElastigroupGke.property.networkInterface"></a>

```typescript
public readonly networkInterface: IResolvable | ElastigroupGkeNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeNetworkInterface">ElastigroupGkeNetworkInterface</a>[]

---

##### `nodeImage`<sup>Required</sup> <a name="nodeImage" id="@cdktf/provider-spotinst.ElastigroupGke.property.nodeImage"></a>

```typescript
public readonly nodeImage: string;
```

- *Type:* string

---

##### `ondemandCount`<sup>Required</sup> <a name="ondemandCount" id="@cdktf/provider-spotinst.ElastigroupGke.property.ondemandCount"></a>

```typescript
public readonly ondemandCount: number;
```

- *Type:* number

---

##### `preemptiblePercentage`<sup>Required</sup> <a name="preemptiblePercentage" id="@cdktf/provider-spotinst.ElastigroupGke.property.preemptiblePercentage"></a>

```typescript
public readonly preemptiblePercentage: number;
```

- *Type:* number

---

##### `provisioningModel`<sup>Required</sup> <a name="provisioningModel" id="@cdktf/provider-spotinst.ElastigroupGke.property.provisioningModel"></a>

```typescript
public readonly provisioningModel: string;
```

- *Type:* string

---

##### `scalingDownPolicy`<sup>Required</sup> <a name="scalingDownPolicy" id="@cdktf/provider-spotinst.ElastigroupGke.property.scalingDownPolicy"></a>

```typescript
public readonly scalingDownPolicy: IResolvable | ElastigroupGkeScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingDownPolicy">ElastigroupGkeScalingDownPolicy</a>[]

---

##### `scalingUpPolicy`<sup>Required</sup> <a name="scalingUpPolicy" id="@cdktf/provider-spotinst.ElastigroupGke.property.scalingUpPolicy"></a>

```typescript
public readonly scalingUpPolicy: IResolvable | ElastigroupGkeScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ElastigroupGkeScalingUpPolicy">ElastigroupGkeScalingUpPolicy</a>[]

---

##### `serviceAccount`<sup>Required</sup> <a name="serviceAccount" id="@cdktf/provider-spotinst.ElastigroupGke.property.serviceAccount"></a>

```typescript
public readonly serviceAccount: string;
```

- *Type:* string

---

##### `shutdownScript`<sup>Required</sup> <a name="shutdownScript" id="@cdktf/provider-spotinst.ElastigroupGke.property.shutdownScript"></a>

```typescript
public readonly shutdownScript: string;
```

- *Type:* string

---

##### `startupScript`<sup>Required</sup> <a name="startupScript" id="@cdktf/provider-spotinst.ElastigroupGke.property.startupScript"></a>

```typescript
public readonly startupScript: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.ElastigroupGke.property.tags"></a>

```typescript
public readonly tags: string[];
```

- *Type:* string[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ElastigroupGke.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ElastigroupGke.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### HealthCheck <a name="HealthCheck" id="@cdktf/provider-spotinst.HealthCheck"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/health_check spotinst_health_check}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.HealthCheck.Initializer"></a>

```typescript
import { HealthCheck } from '@cdktf/provider-spotinst'

new HealthCheck(scope: Construct, id: string, config: HealthCheckConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.HealthCheckConfig">HealthCheckConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.HealthCheck.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.HealthCheckConfig">HealthCheckConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.putCheck">putCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.resetCheck">resetCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.resetProxyPort">resetProxyPort</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.HealthCheck.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.HealthCheck.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.HealthCheck.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.HealthCheck.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.HealthCheck.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.HealthCheck.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.HealthCheck.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.HealthCheck.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.HealthCheck.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.HealthCheck.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.HealthCheck.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.HealthCheck.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.HealthCheck.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.HealthCheck.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.HealthCheck.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.HealthCheck.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.HealthCheck.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putCheck` <a name="putCheck" id="@cdktf/provider-spotinst.HealthCheck.putCheck"></a>

```typescript
public putCheck(value: HealthCheckCheck): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.HealthCheck.putCheck.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.HealthCheckCheck">HealthCheckCheck</a>

---

##### `resetCheck` <a name="resetCheck" id="@cdktf/provider-spotinst.HealthCheck.resetCheck"></a>

```typescript
public resetCheck(): void
```

##### `resetName` <a name="resetName" id="@cdktf/provider-spotinst.HealthCheck.resetName"></a>

```typescript
public resetName(): void
```

##### `resetProxyPort` <a name="resetProxyPort" id="@cdktf/provider-spotinst.HealthCheck.resetProxyPort"></a>

```typescript
public resetProxyPort(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.HealthCheck.isConstruct"></a>

```typescript
import { HealthCheck } from '@cdktf/provider-spotinst'

HealthCheck.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.HealthCheck.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.check">check</a></code> | <code><a href="#@cdktf/provider-spotinst.HealthCheckCheckOutputReference">HealthCheckCheckOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.checkInput">checkInput</a></code> | <code><a href="#@cdktf/provider-spotinst.HealthCheckCheck">HealthCheckCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.proxyAddressInput">proxyAddressInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.proxyPortInput">proxyPortInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.resourceIdInput">resourceIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.proxyAddress">proxyAddress</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.proxyPort">proxyPort</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.resourceId">resourceId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.HealthCheck.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.HealthCheck.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.HealthCheck.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.HealthCheck.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.HealthCheck.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.HealthCheck.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.HealthCheck.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.HealthCheck.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.HealthCheck.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.HealthCheck.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.HealthCheck.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `check`<sup>Required</sup> <a name="check" id="@cdktf/provider-spotinst.HealthCheck.property.check"></a>

```typescript
public readonly check: HealthCheckCheckOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.HealthCheckCheckOutputReference">HealthCheckCheckOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.HealthCheck.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `checkInput`<sup>Optional</sup> <a name="checkInput" id="@cdktf/provider-spotinst.HealthCheck.property.checkInput"></a>

```typescript
public readonly checkInput: HealthCheckCheck;
```

- *Type:* <a href="#@cdktf/provider-spotinst.HealthCheckCheck">HealthCheckCheck</a>

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.HealthCheck.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `proxyAddressInput`<sup>Optional</sup> <a name="proxyAddressInput" id="@cdktf/provider-spotinst.HealthCheck.property.proxyAddressInput"></a>

```typescript
public readonly proxyAddressInput: string;
```

- *Type:* string

---

##### `proxyPortInput`<sup>Optional</sup> <a name="proxyPortInput" id="@cdktf/provider-spotinst.HealthCheck.property.proxyPortInput"></a>

```typescript
public readonly proxyPortInput: number;
```

- *Type:* number

---

##### `resourceIdInput`<sup>Optional</sup> <a name="resourceIdInput" id="@cdktf/provider-spotinst.HealthCheck.property.resourceIdInput"></a>

```typescript
public readonly resourceIdInput: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.HealthCheck.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `proxyAddress`<sup>Required</sup> <a name="proxyAddress" id="@cdktf/provider-spotinst.HealthCheck.property.proxyAddress"></a>

```typescript
public readonly proxyAddress: string;
```

- *Type:* string

---

##### `proxyPort`<sup>Required</sup> <a name="proxyPort" id="@cdktf/provider-spotinst.HealthCheck.property.proxyPort"></a>

```typescript
public readonly proxyPort: number;
```

- *Type:* number

---

##### `resourceId`<sup>Required</sup> <a name="resourceId" id="@cdktf/provider-spotinst.HealthCheck.property.resourceId"></a>

```typescript
public readonly resourceId: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.HealthCheck.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.HealthCheck.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ManagedInstanceAws <a name="ManagedInstanceAws" id="@cdktf/provider-spotinst.ManagedInstanceAws"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws spotinst_managed_instance_aws}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.ManagedInstanceAws.Initializer"></a>

```typescript
import { ManagedInstanceAws } from '@cdktf/provider-spotinst'

new ManagedInstanceAws(scope: Construct, id: string, config: ManagedInstanceAwsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsConfig">ManagedInstanceAwsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.ManagedInstanceAws.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsConfig">ManagedInstanceAwsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.putIntegrationRoute53">putIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.putManagedInstanceAction">putManagedInstanceAction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.putRevertToSpot">putRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetAutoHealing">resetAutoHealing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetBlockDeviceMappings">resetBlockDeviceMappings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetBlockDevicesMode">resetBlockDevicesMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetCpuCredits">resetCpuCredits</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetEbsOptimized">resetEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetElasticIp">resetElasticIp</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetEnableMonitoring">resetEnableMonitoring</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetFallBackToOd">resetFallBackToOd</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetGracePeriod">resetGracePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetHealthCheckType">resetHealthCheckType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetIntegrationRoute53">resetIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetKeyPair">resetKeyPair</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetLifeCycle">resetLifeCycle</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetLoadBalancers">resetLoadBalancers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetManagedInstanceAction">resetManagedInstanceAction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetMinimumInstanceLifetime">resetMinimumInstanceLifetime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetNetworkInterface">resetNetworkInterface</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetOptimizationWindows">resetOptimizationWindows</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetOrientation">resetOrientation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetPersistPrivateIp">resetPersistPrivateIp</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetPersistRootDevice">resetPersistRootDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetPlacementTenancy">resetPlacementTenancy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetPreferredType">resetPreferredType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetPrivateIp">resetPrivateIp</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetRegion">resetRegion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetResourceTagSpecification">resetResourceTagSpecification</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetRevertToSpot">resetRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetSecurityGroupIds">resetSecurityGroupIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetShutdownScript">resetShutdownScript</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetUnhealthyDuration">resetUnhealthyDuration</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetUserData">resetUserData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.resetUtilizeReservedInstances">resetUtilizeReservedInstances</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.ManagedInstanceAws.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.ManagedInstanceAws.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.ManagedInstanceAws.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ManagedInstanceAws.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.ManagedInstanceAws.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.ManagedInstanceAws.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.ManagedInstanceAws.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.ManagedInstanceAws.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.ManagedInstanceAws.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putIntegrationRoute53` <a name="putIntegrationRoute53" id="@cdktf/provider-spotinst.ManagedInstanceAws.putIntegrationRoute53"></a>

```typescript
public putIntegrationRoute53(value: ManagedInstanceAwsIntegrationRoute53): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ManagedInstanceAws.putIntegrationRoute53.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsIntegrationRoute53">ManagedInstanceAwsIntegrationRoute53</a>

---

##### `putManagedInstanceAction` <a name="putManagedInstanceAction" id="@cdktf/provider-spotinst.ManagedInstanceAws.putManagedInstanceAction"></a>

```typescript
public putManagedInstanceAction(value: ManagedInstanceAwsManagedInstanceAction): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ManagedInstanceAws.putManagedInstanceAction.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsManagedInstanceAction">ManagedInstanceAwsManagedInstanceAction</a>

---

##### `putRevertToSpot` <a name="putRevertToSpot" id="@cdktf/provider-spotinst.ManagedInstanceAws.putRevertToSpot"></a>

```typescript
public putRevertToSpot(value: ManagedInstanceAwsRevertToSpot): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.ManagedInstanceAws.putRevertToSpot.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsRevertToSpot">ManagedInstanceAwsRevertToSpot</a>

---

##### `resetAutoHealing` <a name="resetAutoHealing" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetAutoHealing"></a>

```typescript
public resetAutoHealing(): void
```

##### `resetBlockDeviceMappings` <a name="resetBlockDeviceMappings" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetBlockDeviceMappings"></a>

```typescript
public resetBlockDeviceMappings(): void
```

##### `resetBlockDevicesMode` <a name="resetBlockDevicesMode" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetBlockDevicesMode"></a>

```typescript
public resetBlockDevicesMode(): void
```

##### `resetCpuCredits` <a name="resetCpuCredits" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetCpuCredits"></a>

```typescript
public resetCpuCredits(): void
```

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetDescription"></a>

```typescript
public resetDescription(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetEbsOptimized` <a name="resetEbsOptimized" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetEbsOptimized"></a>

```typescript
public resetEbsOptimized(): void
```

##### `resetElasticIp` <a name="resetElasticIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetElasticIp"></a>

```typescript
public resetElasticIp(): void
```

##### `resetEnableMonitoring` <a name="resetEnableMonitoring" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetEnableMonitoring"></a>

```typescript
public resetEnableMonitoring(): void
```

##### `resetFallBackToOd` <a name="resetFallBackToOd" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetFallBackToOd"></a>

```typescript
public resetFallBackToOd(): void
```

##### `resetGracePeriod` <a name="resetGracePeriod" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetGracePeriod"></a>

```typescript
public resetGracePeriod(): void
```

##### `resetHealthCheckType` <a name="resetHealthCheckType" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetHealthCheckType"></a>

```typescript
public resetHealthCheckType(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetIntegrationRoute53` <a name="resetIntegrationRoute53" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetIntegrationRoute53"></a>

```typescript
public resetIntegrationRoute53(): void
```

##### `resetKeyPair` <a name="resetKeyPair" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetKeyPair"></a>

```typescript
public resetKeyPair(): void
```

##### `resetLifeCycle` <a name="resetLifeCycle" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetLifeCycle"></a>

```typescript
public resetLifeCycle(): void
```

##### `resetLoadBalancers` <a name="resetLoadBalancers" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetLoadBalancers"></a>

```typescript
public resetLoadBalancers(): void
```

##### `resetManagedInstanceAction` <a name="resetManagedInstanceAction" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetManagedInstanceAction"></a>

```typescript
public resetManagedInstanceAction(): void
```

##### `resetMinimumInstanceLifetime` <a name="resetMinimumInstanceLifetime" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetMinimumInstanceLifetime"></a>

```typescript
public resetMinimumInstanceLifetime(): void
```

##### `resetNetworkInterface` <a name="resetNetworkInterface" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetNetworkInterface"></a>

```typescript
public resetNetworkInterface(): void
```

##### `resetOptimizationWindows` <a name="resetOptimizationWindows" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetOptimizationWindows"></a>

```typescript
public resetOptimizationWindows(): void
```

##### `resetOrientation` <a name="resetOrientation" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetOrientation"></a>

```typescript
public resetOrientation(): void
```

##### `resetPersistPrivateIp` <a name="resetPersistPrivateIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetPersistPrivateIp"></a>

```typescript
public resetPersistPrivateIp(): void
```

##### `resetPersistRootDevice` <a name="resetPersistRootDevice" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetPersistRootDevice"></a>

```typescript
public resetPersistRootDevice(): void
```

##### `resetPlacementTenancy` <a name="resetPlacementTenancy" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetPlacementTenancy"></a>

```typescript
public resetPlacementTenancy(): void
```

##### `resetPreferredType` <a name="resetPreferredType" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetPreferredType"></a>

```typescript
public resetPreferredType(): void
```

##### `resetPrivateIp` <a name="resetPrivateIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetPrivateIp"></a>

```typescript
public resetPrivateIp(): void
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetRegion"></a>

```typescript
public resetRegion(): void
```

##### `resetResourceTagSpecification` <a name="resetResourceTagSpecification" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetResourceTagSpecification"></a>

```typescript
public resetResourceTagSpecification(): void
```

##### `resetRevertToSpot` <a name="resetRevertToSpot" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetRevertToSpot"></a>

```typescript
public resetRevertToSpot(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetSecurityGroupIds` <a name="resetSecurityGroupIds" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetSecurityGroupIds"></a>

```typescript
public resetSecurityGroupIds(): void
```

##### `resetShutdownScript` <a name="resetShutdownScript" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetShutdownScript"></a>

```typescript
public resetShutdownScript(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetUnhealthyDuration` <a name="resetUnhealthyDuration" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetUnhealthyDuration"></a>

```typescript
public resetUnhealthyDuration(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetUserData"></a>

```typescript
public resetUserData(): void
```

##### `resetUtilizeReservedInstances` <a name="resetUtilizeReservedInstances" id="@cdktf/provider-spotinst.ManagedInstanceAws.resetUtilizeReservedInstances"></a>

```typescript
public resetUtilizeReservedInstances(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.ManagedInstanceAws.isConstruct"></a>

```typescript
import { ManagedInstanceAws } from '@cdktf/provider-spotinst'

ManagedInstanceAws.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.ManagedInstanceAws.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.integrationRoute53">integrationRoute53</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsIntegrationRoute53OutputReference">ManagedInstanceAwsIntegrationRoute53OutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.managedInstanceAction">managedInstanceAction</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsManagedInstanceActionOutputReference">ManagedInstanceAwsManagedInstanceActionOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.revertToSpot">revertToSpot</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsRevertToSpotOutputReference">ManagedInstanceAwsRevertToSpotOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.autoHealingInput">autoHealingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDeviceMappingsInput">blockDeviceMappingsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsBlockDeviceMappings">ManagedInstanceAwsBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDevicesModeInput">blockDevicesModeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.cpuCreditsInput">cpuCreditsInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.descriptionInput">descriptionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.ebsOptimizedInput">ebsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.elasticIpInput">elasticIpInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.enableMonitoringInput">enableMonitoringInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.fallBackToOdInput">fallBackToOdInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.gracePeriodInput">gracePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.healthCheckTypeInput">healthCheckTypeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.instanceTypesInput">instanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.integrationRoute53Input">integrationRoute53Input</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsIntegrationRoute53">ManagedInstanceAwsIntegrationRoute53</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.keyPairInput">keyPairInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.lifeCycleInput">lifeCycleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.loadBalancersInput">loadBalancersInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsLoadBalancers">ManagedInstanceAwsLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.managedInstanceActionInput">managedInstanceActionInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsManagedInstanceAction">ManagedInstanceAwsManagedInstanceAction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.minimumInstanceLifetimeInput">minimumInstanceLifetimeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.networkInterfaceInput">networkInterfaceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsNetworkInterface">ManagedInstanceAwsNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.optimizationWindowsInput">optimizationWindowsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.orientationInput">orientationInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistBlockDevicesInput">persistBlockDevicesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistPrivateIpInput">persistPrivateIpInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistRootDeviceInput">persistRootDeviceInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.placementTenancyInput">placementTenancyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.preferredTypeInput">preferredTypeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.privateIpInput">privateIpInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.productInput">productInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.resourceTagSpecificationInput">resourceTagSpecificationInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsResourceTagSpecification">ManagedInstanceAwsResourceTagSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.revertToSpotInput">revertToSpotInput</a></code> | <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAwsRevertToSpot">ManagedInstanceAwsRevertToSpot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsScheduledTask">ManagedInstanceAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.securityGroupIdsInput">securityGroupIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.shutdownScriptInput">shutdownScriptInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.subnetIdsInput">subnetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsTags">ManagedInstanceAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.unhealthyDurationInput">unhealthyDurationInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.utilizeReservedInstancesInput">utilizeReservedInstancesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.vpcIdInput">vpcIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.autoHealing">autoHealing</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDeviceMappings">blockDeviceMappings</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsBlockDeviceMappings">ManagedInstanceAwsBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDevicesMode">blockDevicesMode</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.cpuCredits">cpuCredits</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.ebsOptimized">ebsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.elasticIp">elasticIp</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.enableMonitoring">enableMonitoring</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.fallBackToOd">fallBackToOd</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.gracePeriod">gracePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.healthCheckType">healthCheckType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.iamInstanceProfile">iamInstanceProfile</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.imageId">imageId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.instanceTypes">instanceTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.keyPair">keyPair</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.lifeCycle">lifeCycle</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.loadBalancers">loadBalancers</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsLoadBalancers">ManagedInstanceAwsLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.minimumInstanceLifetime">minimumInstanceLifetime</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.networkInterface">networkInterface</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsNetworkInterface">ManagedInstanceAwsNetworkInterface</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.optimizationWindows">optimizationWindows</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.orientation">orientation</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistBlockDevices">persistBlockDevices</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistPrivateIp">persistPrivateIp</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.persistRootDevice">persistRootDevice</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.placementTenancy">placementTenancy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.preferredType">preferredType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.privateIp">privateIp</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.product">product</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.resourceTagSpecification">resourceTagSpecification</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsResourceTagSpecification">ManagedInstanceAwsResourceTagSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsScheduledTask">ManagedInstanceAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.securityGroupIds">securityGroupIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.shutdownScript">shutdownScript</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.subnetIds">subnetIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsTags">ManagedInstanceAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.unhealthyDuration">unhealthyDuration</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.userData">userData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.utilizeReservedInstances">utilizeReservedInstances</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.vpcId">vpcId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `integrationRoute53`<sup>Required</sup> <a name="integrationRoute53" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.integrationRoute53"></a>

```typescript
public readonly integrationRoute53: ManagedInstanceAwsIntegrationRoute53OutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsIntegrationRoute53OutputReference">ManagedInstanceAwsIntegrationRoute53OutputReference</a>

---

##### `managedInstanceAction`<sup>Required</sup> <a name="managedInstanceAction" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.managedInstanceAction"></a>

```typescript
public readonly managedInstanceAction: ManagedInstanceAwsManagedInstanceActionOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsManagedInstanceActionOutputReference">ManagedInstanceAwsManagedInstanceActionOutputReference</a>

---

##### `revertToSpot`<sup>Required</sup> <a name="revertToSpot" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.revertToSpot"></a>

```typescript
public readonly revertToSpot: ManagedInstanceAwsRevertToSpotOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsRevertToSpotOutputReference">ManagedInstanceAwsRevertToSpotOutputReference</a>

---

##### `autoHealingInput`<sup>Optional</sup> <a name="autoHealingInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.autoHealingInput"></a>

```typescript
public readonly autoHealingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `blockDeviceMappingsInput`<sup>Optional</sup> <a name="blockDeviceMappingsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDeviceMappingsInput"></a>

```typescript
public readonly blockDeviceMappingsInput: IResolvable | ManagedInstanceAwsBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsBlockDeviceMappings">ManagedInstanceAwsBlockDeviceMappings</a>[]

---

##### `blockDevicesModeInput`<sup>Optional</sup> <a name="blockDevicesModeInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDevicesModeInput"></a>

```typescript
public readonly blockDevicesModeInput: string;
```

- *Type:* string

---

##### `cpuCreditsInput`<sup>Optional</sup> <a name="cpuCreditsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.cpuCreditsInput"></a>

```typescript
public readonly cpuCreditsInput: string;
```

- *Type:* string

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.descriptionInput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* string

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `ebsOptimizedInput`<sup>Optional</sup> <a name="ebsOptimizedInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.ebsOptimizedInput"></a>

```typescript
public readonly ebsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticIpInput`<sup>Optional</sup> <a name="elasticIpInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.elasticIpInput"></a>

```typescript
public readonly elasticIpInput: string;
```

- *Type:* string

---

##### `enableMonitoringInput`<sup>Optional</sup> <a name="enableMonitoringInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.enableMonitoringInput"></a>

```typescript
public readonly enableMonitoringInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `fallBackToOdInput`<sup>Optional</sup> <a name="fallBackToOdInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.fallBackToOdInput"></a>

```typescript
public readonly fallBackToOdInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gracePeriodInput`<sup>Optional</sup> <a name="gracePeriodInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.gracePeriodInput"></a>

```typescript
public readonly gracePeriodInput: number;
```

- *Type:* number

---

##### `healthCheckTypeInput`<sup>Optional</sup> <a name="healthCheckTypeInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.healthCheckTypeInput"></a>

```typescript
public readonly healthCheckTypeInput: string;
```

- *Type:* string

---

##### `iamInstanceProfileInput`<sup>Optional</sup> <a name="iamInstanceProfileInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.iamInstanceProfileInput"></a>

```typescript
public readonly iamInstanceProfileInput: string;
```

- *Type:* string

---

##### `imageIdInput`<sup>Optional</sup> <a name="imageIdInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.imageIdInput"></a>

```typescript
public readonly imageIdInput: string;
```

- *Type:* string

---

##### `instanceTypesInput`<sup>Optional</sup> <a name="instanceTypesInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.instanceTypesInput"></a>

```typescript
public readonly instanceTypesInput: string[];
```

- *Type:* string[]

---

##### `integrationRoute53Input`<sup>Optional</sup> <a name="integrationRoute53Input" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.integrationRoute53Input"></a>

```typescript
public readonly integrationRoute53Input: ManagedInstanceAwsIntegrationRoute53;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsIntegrationRoute53">ManagedInstanceAwsIntegrationRoute53</a>

---

##### `keyPairInput`<sup>Optional</sup> <a name="keyPairInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.keyPairInput"></a>

```typescript
public readonly keyPairInput: string;
```

- *Type:* string

---

##### `lifeCycleInput`<sup>Optional</sup> <a name="lifeCycleInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.lifeCycleInput"></a>

```typescript
public readonly lifeCycleInput: string;
```

- *Type:* string

---

##### `loadBalancersInput`<sup>Optional</sup> <a name="loadBalancersInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.loadBalancersInput"></a>

```typescript
public readonly loadBalancersInput: IResolvable | ManagedInstanceAwsLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsLoadBalancers">ManagedInstanceAwsLoadBalancers</a>[]

---

##### `managedInstanceActionInput`<sup>Optional</sup> <a name="managedInstanceActionInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.managedInstanceActionInput"></a>

```typescript
public readonly managedInstanceActionInput: ManagedInstanceAwsManagedInstanceAction;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsManagedInstanceAction">ManagedInstanceAwsManagedInstanceAction</a>

---

##### `minimumInstanceLifetimeInput`<sup>Optional</sup> <a name="minimumInstanceLifetimeInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.minimumInstanceLifetimeInput"></a>

```typescript
public readonly minimumInstanceLifetimeInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInterfaceInput`<sup>Optional</sup> <a name="networkInterfaceInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.networkInterfaceInput"></a>

```typescript
public readonly networkInterfaceInput: IResolvable | ManagedInstanceAwsNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsNetworkInterface">ManagedInstanceAwsNetworkInterface</a>[]

---

##### `optimizationWindowsInput`<sup>Optional</sup> <a name="optimizationWindowsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.optimizationWindowsInput"></a>

```typescript
public readonly optimizationWindowsInput: string[];
```

- *Type:* string[]

---

##### `orientationInput`<sup>Optional</sup> <a name="orientationInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.orientationInput"></a>

```typescript
public readonly orientationInput: string;
```

- *Type:* string

---

##### `persistBlockDevicesInput`<sup>Optional</sup> <a name="persistBlockDevicesInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistBlockDevicesInput"></a>

```typescript
public readonly persistBlockDevicesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistPrivateIpInput`<sup>Optional</sup> <a name="persistPrivateIpInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistPrivateIpInput"></a>

```typescript
public readonly persistPrivateIpInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistRootDeviceInput`<sup>Optional</sup> <a name="persistRootDeviceInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistRootDeviceInput"></a>

```typescript
public readonly persistRootDeviceInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `placementTenancyInput`<sup>Optional</sup> <a name="placementTenancyInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.placementTenancyInput"></a>

```typescript
public readonly placementTenancyInput: string;
```

- *Type:* string

---

##### `preferredTypeInput`<sup>Optional</sup> <a name="preferredTypeInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.preferredTypeInput"></a>

```typescript
public readonly preferredTypeInput: string;
```

- *Type:* string

---

##### `privateIpInput`<sup>Optional</sup> <a name="privateIpInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.privateIpInput"></a>

```typescript
public readonly privateIpInput: string;
```

- *Type:* string

---

##### `productInput`<sup>Optional</sup> <a name="productInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.productInput"></a>

```typescript
public readonly productInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `resourceTagSpecificationInput`<sup>Optional</sup> <a name="resourceTagSpecificationInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.resourceTagSpecificationInput"></a>

```typescript
public readonly resourceTagSpecificationInput: IResolvable | ManagedInstanceAwsResourceTagSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsResourceTagSpecification">ManagedInstanceAwsResourceTagSpecification</a>[]

---

##### `revertToSpotInput`<sup>Optional</sup> <a name="revertToSpotInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.revertToSpotInput"></a>

```typescript
public readonly revertToSpotInput: ManagedInstanceAwsRevertToSpot;
```

- *Type:* <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsRevertToSpot">ManagedInstanceAwsRevertToSpot</a>

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | ManagedInstanceAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsScheduledTask">ManagedInstanceAwsScheduledTask</a>[]

---

##### `securityGroupIdsInput`<sup>Optional</sup> <a name="securityGroupIdsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.securityGroupIdsInput"></a>

```typescript
public readonly securityGroupIdsInput: string[];
```

- *Type:* string[]

---

##### `shutdownScriptInput`<sup>Optional</sup> <a name="shutdownScriptInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.shutdownScriptInput"></a>

```typescript
public readonly shutdownScriptInput: string;
```

- *Type:* string

---

##### `subnetIdsInput`<sup>Optional</sup> <a name="subnetIdsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.subnetIdsInput"></a>

```typescript
public readonly subnetIdsInput: string[];
```

- *Type:* string[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | ManagedInstanceAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsTags">ManagedInstanceAwsTags</a>[]

---

##### `unhealthyDurationInput`<sup>Optional</sup> <a name="unhealthyDurationInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.unhealthyDurationInput"></a>

```typescript
public readonly unhealthyDurationInput: number;
```

- *Type:* number

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `utilizeReservedInstancesInput`<sup>Optional</sup> <a name="utilizeReservedInstancesInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.utilizeReservedInstancesInput"></a>

```typescript
public readonly utilizeReservedInstancesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `vpcIdInput`<sup>Optional</sup> <a name="vpcIdInput" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.vpcIdInput"></a>

```typescript
public readonly vpcIdInput: string;
```

- *Type:* string

---

##### `autoHealing`<sup>Required</sup> <a name="autoHealing" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.autoHealing"></a>

```typescript
public readonly autoHealing: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `blockDeviceMappings`<sup>Required</sup> <a name="blockDeviceMappings" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDeviceMappings"></a>

```typescript
public readonly blockDeviceMappings: IResolvable | ManagedInstanceAwsBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsBlockDeviceMappings">ManagedInstanceAwsBlockDeviceMappings</a>[]

---

##### `blockDevicesMode`<sup>Required</sup> <a name="blockDevicesMode" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.blockDevicesMode"></a>

```typescript
public readonly blockDevicesMode: string;
```

- *Type:* string

---

##### `cpuCredits`<sup>Required</sup> <a name="cpuCredits" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.cpuCredits"></a>

```typescript
public readonly cpuCredits: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `ebsOptimized`<sup>Required</sup> <a name="ebsOptimized" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.ebsOptimized"></a>

```typescript
public readonly ebsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticIp`<sup>Required</sup> <a name="elasticIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.elasticIp"></a>

```typescript
public readonly elasticIp: string;
```

- *Type:* string

---

##### `enableMonitoring`<sup>Required</sup> <a name="enableMonitoring" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.enableMonitoring"></a>

```typescript
public readonly enableMonitoring: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `fallBackToOd`<sup>Required</sup> <a name="fallBackToOd" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.fallBackToOd"></a>

```typescript
public readonly fallBackToOd: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gracePeriod`<sup>Required</sup> <a name="gracePeriod" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.gracePeriod"></a>

```typescript
public readonly gracePeriod: number;
```

- *Type:* number

---

##### `healthCheckType`<sup>Required</sup> <a name="healthCheckType" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.healthCheckType"></a>

```typescript
public readonly healthCheckType: string;
```

- *Type:* string

---

##### `iamInstanceProfile`<sup>Required</sup> <a name="iamInstanceProfile" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.iamInstanceProfile"></a>

```typescript
public readonly iamInstanceProfile: string;
```

- *Type:* string

---

##### `imageId`<sup>Required</sup> <a name="imageId" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.imageId"></a>

```typescript
public readonly imageId: string;
```

- *Type:* string

---

##### `instanceTypes`<sup>Required</sup> <a name="instanceTypes" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.instanceTypes"></a>

```typescript
public readonly instanceTypes: string[];
```

- *Type:* string[]

---

##### `keyPair`<sup>Required</sup> <a name="keyPair" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.keyPair"></a>

```typescript
public readonly keyPair: string;
```

- *Type:* string

---

##### `lifeCycle`<sup>Required</sup> <a name="lifeCycle" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.lifeCycle"></a>

```typescript
public readonly lifeCycle: string;
```

- *Type:* string

---

##### `loadBalancers`<sup>Required</sup> <a name="loadBalancers" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.loadBalancers"></a>

```typescript
public readonly loadBalancers: IResolvable | ManagedInstanceAwsLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsLoadBalancers">ManagedInstanceAwsLoadBalancers</a>[]

---

##### `minimumInstanceLifetime`<sup>Required</sup> <a name="minimumInstanceLifetime" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.minimumInstanceLifetime"></a>

```typescript
public readonly minimumInstanceLifetime: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `networkInterface`<sup>Required</sup> <a name="networkInterface" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.networkInterface"></a>

```typescript
public readonly networkInterface: IResolvable | ManagedInstanceAwsNetworkInterface[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsNetworkInterface">ManagedInstanceAwsNetworkInterface</a>[]

---

##### `optimizationWindows`<sup>Required</sup> <a name="optimizationWindows" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.optimizationWindows"></a>

```typescript
public readonly optimizationWindows: string[];
```

- *Type:* string[]

---

##### `orientation`<sup>Required</sup> <a name="orientation" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.orientation"></a>

```typescript
public readonly orientation: string;
```

- *Type:* string

---

##### `persistBlockDevices`<sup>Required</sup> <a name="persistBlockDevices" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistBlockDevices"></a>

```typescript
public readonly persistBlockDevices: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistPrivateIp`<sup>Required</sup> <a name="persistPrivateIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistPrivateIp"></a>

```typescript
public readonly persistPrivateIp: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `persistRootDevice`<sup>Required</sup> <a name="persistRootDevice" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.persistRootDevice"></a>

```typescript
public readonly persistRootDevice: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `placementTenancy`<sup>Required</sup> <a name="placementTenancy" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.placementTenancy"></a>

```typescript
public readonly placementTenancy: string;
```

- *Type:* string

---

##### `preferredType`<sup>Required</sup> <a name="preferredType" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.preferredType"></a>

```typescript
public readonly preferredType: string;
```

- *Type:* string

---

##### `privateIp`<sup>Required</sup> <a name="privateIp" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.privateIp"></a>

```typescript
public readonly privateIp: string;
```

- *Type:* string

---

##### `product`<sup>Required</sup> <a name="product" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.product"></a>

```typescript
public readonly product: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `resourceTagSpecification`<sup>Required</sup> <a name="resourceTagSpecification" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.resourceTagSpecification"></a>

```typescript
public readonly resourceTagSpecification: IResolvable | ManagedInstanceAwsResourceTagSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsResourceTagSpecification">ManagedInstanceAwsResourceTagSpecification</a>[]

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | ManagedInstanceAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsScheduledTask">ManagedInstanceAwsScheduledTask</a>[]

---

##### `securityGroupIds`<sup>Required</sup> <a name="securityGroupIds" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.securityGroupIds"></a>

```typescript
public readonly securityGroupIds: string[];
```

- *Type:* string[]

---

##### `shutdownScript`<sup>Required</sup> <a name="shutdownScript" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.shutdownScript"></a>

```typescript
public readonly shutdownScript: string;
```

- *Type:* string

---

##### `subnetIds`<sup>Required</sup> <a name="subnetIds" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.subnetIds"></a>

```typescript
public readonly subnetIds: string[];
```

- *Type:* string[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.tags"></a>

```typescript
public readonly tags: IResolvable | ManagedInstanceAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.ManagedInstanceAwsTags">ManagedInstanceAwsTags</a>[]

---

##### `unhealthyDuration`<sup>Required</sup> <a name="unhealthyDuration" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.unhealthyDuration"></a>

```typescript
public readonly unhealthyDuration: number;
```

- *Type:* number

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

##### `utilizeReservedInstances`<sup>Required</sup> <a name="utilizeReservedInstances" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.utilizeReservedInstances"></a>

```typescript
public readonly utilizeReservedInstances: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `vpcId`<sup>Required</sup> <a name="vpcId" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.vpcId"></a>

```typescript
public readonly vpcId: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.ManagedInstanceAws.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.ManagedInstanceAws.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MrscalerAws <a name="MrscalerAws" id="@cdktf/provider-spotinst.MrscalerAws"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws spotinst_mrscaler_aws}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MrscalerAws.Initializer"></a>

```typescript
import { MrscalerAws } from '@cdktf/provider-spotinst'

new MrscalerAws(scope: Construct, id: string, config: MrscalerAwsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MrscalerAwsConfig">MrscalerAwsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MrscalerAws.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MrscalerAwsConfig">MrscalerAwsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.putProvisioningTimeout">putProvisioningTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetAdditionalInfo">resetAdditionalInfo</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetAdditionalPrimarySecurityGroups">resetAdditionalPrimarySecurityGroups</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetAdditionalReplicaSecurityGroups">resetAdditionalReplicaSecurityGroups</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetApplications">resetApplications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetAvailabilityZones">resetAvailabilityZones</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetBootstrapActionsFile">resetBootstrapActionsFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetClusterId">resetClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetConfigurationsFile">resetConfigurationsFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreDesiredCapacity">resetCoreDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreEbsBlockDevice">resetCoreEbsBlockDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreEbsOptimized">resetCoreEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreInstanceTypes">resetCoreInstanceTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreLifecycle">resetCoreLifecycle</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreMaxSize">resetCoreMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreMinSize">resetCoreMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreScalingDownPolicy">resetCoreScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreScalingUpPolicy">resetCoreScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCoreUnit">resetCoreUnit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetCustomAmiId">resetCustomAmiId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetEbsRootVolumeSize">resetEbsRootVolumeSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetEc2KeyName">resetEc2KeyName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetExposeClusterId">resetExposeClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetInstanceWeights">resetInstanceWeights</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetJobFlowRole">resetJobFlowRole</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetKeepJobFlowAlive">resetKeepJobFlowAlive</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetLogUri">resetLogUri</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetManagedPrimarySecurityGroup">resetManagedPrimarySecurityGroup</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetManagedReplicaSecurityGroup">resetManagedReplicaSecurityGroup</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetMasterEbsBlockDevice">resetMasterEbsBlockDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetMasterEbsOptimized">resetMasterEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetMasterInstanceTypes">resetMasterInstanceTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetMasterLifecycle">resetMasterLifecycle</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetMasterTarget">resetMasterTarget</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetProvisioningTimeout">resetProvisioningTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetRegion">resetRegion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetReleaseLabel">resetReleaseLabel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetRepoUpgradeOnBoot">resetRepoUpgradeOnBoot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetRetries">resetRetries</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetSecurityConfig">resetSecurityConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetServiceAccessSecurityGroup">resetServiceAccessSecurityGroup</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetServiceRole">resetServiceRole</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetStepsFile">resetStepsFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskDesiredCapacity">resetTaskDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskEbsBlockDevice">resetTaskEbsBlockDevice</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskEbsOptimized">resetTaskEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskInstanceTypes">resetTaskInstanceTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskLifecycle">resetTaskLifecycle</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskMaxSize">resetTaskMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskMinSize">resetTaskMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskScalingDownPolicy">resetTaskScalingDownPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskScalingUpPolicy">resetTaskScalingUpPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTaskUnit">resetTaskUnit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTerminationPolicies">resetTerminationPolicies</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetTerminationProtected">resetTerminationProtected</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.resetVisibleToAllUsers">resetVisibleToAllUsers</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MrscalerAws.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MrscalerAws.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MrscalerAws.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MrscalerAws.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MrscalerAws.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MrscalerAws.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MrscalerAws.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MrscalerAws.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MrscalerAws.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MrscalerAws.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MrscalerAws.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putProvisioningTimeout` <a name="putProvisioningTimeout" id="@cdktf/provider-spotinst.MrscalerAws.putProvisioningTimeout"></a>

```typescript
public putProvisioningTimeout(value: MrscalerAwsProvisioningTimeout): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MrscalerAws.putProvisioningTimeout.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MrscalerAwsProvisioningTimeout">MrscalerAwsProvisioningTimeout</a>

---

##### `resetAdditionalInfo` <a name="resetAdditionalInfo" id="@cdktf/provider-spotinst.MrscalerAws.resetAdditionalInfo"></a>

```typescript
public resetAdditionalInfo(): void
```

##### `resetAdditionalPrimarySecurityGroups` <a name="resetAdditionalPrimarySecurityGroups" id="@cdktf/provider-spotinst.MrscalerAws.resetAdditionalPrimarySecurityGroups"></a>

```typescript
public resetAdditionalPrimarySecurityGroups(): void
```

##### `resetAdditionalReplicaSecurityGroups` <a name="resetAdditionalReplicaSecurityGroups" id="@cdktf/provider-spotinst.MrscalerAws.resetAdditionalReplicaSecurityGroups"></a>

```typescript
public resetAdditionalReplicaSecurityGroups(): void
```

##### `resetApplications` <a name="resetApplications" id="@cdktf/provider-spotinst.MrscalerAws.resetApplications"></a>

```typescript
public resetApplications(): void
```

##### `resetAvailabilityZones` <a name="resetAvailabilityZones" id="@cdktf/provider-spotinst.MrscalerAws.resetAvailabilityZones"></a>

```typescript
public resetAvailabilityZones(): void
```

##### `resetBootstrapActionsFile` <a name="resetBootstrapActionsFile" id="@cdktf/provider-spotinst.MrscalerAws.resetBootstrapActionsFile"></a>

```typescript
public resetBootstrapActionsFile(): void
```

##### `resetClusterId` <a name="resetClusterId" id="@cdktf/provider-spotinst.MrscalerAws.resetClusterId"></a>

```typescript
public resetClusterId(): void
```

##### `resetConfigurationsFile` <a name="resetConfigurationsFile" id="@cdktf/provider-spotinst.MrscalerAws.resetConfigurationsFile"></a>

```typescript
public resetConfigurationsFile(): void
```

##### `resetCoreDesiredCapacity` <a name="resetCoreDesiredCapacity" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreDesiredCapacity"></a>

```typescript
public resetCoreDesiredCapacity(): void
```

##### `resetCoreEbsBlockDevice` <a name="resetCoreEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreEbsBlockDevice"></a>

```typescript
public resetCoreEbsBlockDevice(): void
```

##### `resetCoreEbsOptimized` <a name="resetCoreEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreEbsOptimized"></a>

```typescript
public resetCoreEbsOptimized(): void
```

##### `resetCoreInstanceTypes` <a name="resetCoreInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreInstanceTypes"></a>

```typescript
public resetCoreInstanceTypes(): void
```

##### `resetCoreLifecycle` <a name="resetCoreLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreLifecycle"></a>

```typescript
public resetCoreLifecycle(): void
```

##### `resetCoreMaxSize` <a name="resetCoreMaxSize" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreMaxSize"></a>

```typescript
public resetCoreMaxSize(): void
```

##### `resetCoreMinSize` <a name="resetCoreMinSize" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreMinSize"></a>

```typescript
public resetCoreMinSize(): void
```

##### `resetCoreScalingDownPolicy` <a name="resetCoreScalingDownPolicy" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreScalingDownPolicy"></a>

```typescript
public resetCoreScalingDownPolicy(): void
```

##### `resetCoreScalingUpPolicy` <a name="resetCoreScalingUpPolicy" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreScalingUpPolicy"></a>

```typescript
public resetCoreScalingUpPolicy(): void
```

##### `resetCoreUnit` <a name="resetCoreUnit" id="@cdktf/provider-spotinst.MrscalerAws.resetCoreUnit"></a>

```typescript
public resetCoreUnit(): void
```

##### `resetCustomAmiId` <a name="resetCustomAmiId" id="@cdktf/provider-spotinst.MrscalerAws.resetCustomAmiId"></a>

```typescript
public resetCustomAmiId(): void
```

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-spotinst.MrscalerAws.resetDescription"></a>

```typescript
public resetDescription(): void
```

##### `resetEbsRootVolumeSize` <a name="resetEbsRootVolumeSize" id="@cdktf/provider-spotinst.MrscalerAws.resetEbsRootVolumeSize"></a>

```typescript
public resetEbsRootVolumeSize(): void
```

##### `resetEc2KeyName` <a name="resetEc2KeyName" id="@cdktf/provider-spotinst.MrscalerAws.resetEc2KeyName"></a>

```typescript
public resetEc2KeyName(): void
```

##### `resetExposeClusterId` <a name="resetExposeClusterId" id="@cdktf/provider-spotinst.MrscalerAws.resetExposeClusterId"></a>

```typescript
public resetExposeClusterId(): void
```

##### `resetInstanceWeights` <a name="resetInstanceWeights" id="@cdktf/provider-spotinst.MrscalerAws.resetInstanceWeights"></a>

```typescript
public resetInstanceWeights(): void
```

##### `resetJobFlowRole` <a name="resetJobFlowRole" id="@cdktf/provider-spotinst.MrscalerAws.resetJobFlowRole"></a>

```typescript
public resetJobFlowRole(): void
```

##### `resetKeepJobFlowAlive` <a name="resetKeepJobFlowAlive" id="@cdktf/provider-spotinst.MrscalerAws.resetKeepJobFlowAlive"></a>

```typescript
public resetKeepJobFlowAlive(): void
```

##### `resetLogUri` <a name="resetLogUri" id="@cdktf/provider-spotinst.MrscalerAws.resetLogUri"></a>

```typescript
public resetLogUri(): void
```

##### `resetManagedPrimarySecurityGroup` <a name="resetManagedPrimarySecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.resetManagedPrimarySecurityGroup"></a>

```typescript
public resetManagedPrimarySecurityGroup(): void
```

##### `resetManagedReplicaSecurityGroup` <a name="resetManagedReplicaSecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.resetManagedReplicaSecurityGroup"></a>

```typescript
public resetManagedReplicaSecurityGroup(): void
```

##### `resetMasterEbsBlockDevice` <a name="resetMasterEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.resetMasterEbsBlockDevice"></a>

```typescript
public resetMasterEbsBlockDevice(): void
```

##### `resetMasterEbsOptimized` <a name="resetMasterEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.resetMasterEbsOptimized"></a>

```typescript
public resetMasterEbsOptimized(): void
```

##### `resetMasterInstanceTypes` <a name="resetMasterInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.resetMasterInstanceTypes"></a>

```typescript
public resetMasterInstanceTypes(): void
```

##### `resetMasterLifecycle` <a name="resetMasterLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.resetMasterLifecycle"></a>

```typescript
public resetMasterLifecycle(): void
```

##### `resetMasterTarget` <a name="resetMasterTarget" id="@cdktf/provider-spotinst.MrscalerAws.resetMasterTarget"></a>

```typescript
public resetMasterTarget(): void
```

##### `resetProvisioningTimeout` <a name="resetProvisioningTimeout" id="@cdktf/provider-spotinst.MrscalerAws.resetProvisioningTimeout"></a>

```typescript
public resetProvisioningTimeout(): void
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-spotinst.MrscalerAws.resetRegion"></a>

```typescript
public resetRegion(): void
```

##### `resetReleaseLabel` <a name="resetReleaseLabel" id="@cdktf/provider-spotinst.MrscalerAws.resetReleaseLabel"></a>

```typescript
public resetReleaseLabel(): void
```

##### `resetRepoUpgradeOnBoot` <a name="resetRepoUpgradeOnBoot" id="@cdktf/provider-spotinst.MrscalerAws.resetRepoUpgradeOnBoot"></a>

```typescript
public resetRepoUpgradeOnBoot(): void
```

##### `resetRetries` <a name="resetRetries" id="@cdktf/provider-spotinst.MrscalerAws.resetRetries"></a>

```typescript
public resetRetries(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.MrscalerAws.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetSecurityConfig` <a name="resetSecurityConfig" id="@cdktf/provider-spotinst.MrscalerAws.resetSecurityConfig"></a>

```typescript
public resetSecurityConfig(): void
```

##### `resetServiceAccessSecurityGroup` <a name="resetServiceAccessSecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.resetServiceAccessSecurityGroup"></a>

```typescript
public resetServiceAccessSecurityGroup(): void
```

##### `resetServiceRole` <a name="resetServiceRole" id="@cdktf/provider-spotinst.MrscalerAws.resetServiceRole"></a>

```typescript
public resetServiceRole(): void
```

##### `resetStepsFile` <a name="resetStepsFile" id="@cdktf/provider-spotinst.MrscalerAws.resetStepsFile"></a>

```typescript
public resetStepsFile(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MrscalerAws.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetTaskDesiredCapacity` <a name="resetTaskDesiredCapacity" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskDesiredCapacity"></a>

```typescript
public resetTaskDesiredCapacity(): void
```

##### `resetTaskEbsBlockDevice` <a name="resetTaskEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskEbsBlockDevice"></a>

```typescript
public resetTaskEbsBlockDevice(): void
```

##### `resetTaskEbsOptimized` <a name="resetTaskEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskEbsOptimized"></a>

```typescript
public resetTaskEbsOptimized(): void
```

##### `resetTaskInstanceTypes` <a name="resetTaskInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskInstanceTypes"></a>

```typescript
public resetTaskInstanceTypes(): void
```

##### `resetTaskLifecycle` <a name="resetTaskLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskLifecycle"></a>

```typescript
public resetTaskLifecycle(): void
```

##### `resetTaskMaxSize` <a name="resetTaskMaxSize" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskMaxSize"></a>

```typescript
public resetTaskMaxSize(): void
```

##### `resetTaskMinSize` <a name="resetTaskMinSize" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskMinSize"></a>

```typescript
public resetTaskMinSize(): void
```

##### `resetTaskScalingDownPolicy` <a name="resetTaskScalingDownPolicy" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskScalingDownPolicy"></a>

```typescript
public resetTaskScalingDownPolicy(): void
```

##### `resetTaskScalingUpPolicy` <a name="resetTaskScalingUpPolicy" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskScalingUpPolicy"></a>

```typescript
public resetTaskScalingUpPolicy(): void
```

##### `resetTaskUnit` <a name="resetTaskUnit" id="@cdktf/provider-spotinst.MrscalerAws.resetTaskUnit"></a>

```typescript
public resetTaskUnit(): void
```

##### `resetTerminationPolicies` <a name="resetTerminationPolicies" id="@cdktf/provider-spotinst.MrscalerAws.resetTerminationPolicies"></a>

```typescript
public resetTerminationPolicies(): void
```

##### `resetTerminationProtected` <a name="resetTerminationProtected" id="@cdktf/provider-spotinst.MrscalerAws.resetTerminationProtected"></a>

```typescript
public resetTerminationProtected(): void
```

##### `resetVisibleToAllUsers` <a name="resetVisibleToAllUsers" id="@cdktf/provider-spotinst.MrscalerAws.resetVisibleToAllUsers"></a>

```typescript
public resetVisibleToAllUsers(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MrscalerAws.isConstruct"></a>

```typescript
import { MrscalerAws } from '@cdktf/provider-spotinst'

MrscalerAws.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MrscalerAws.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.outputClusterId">outputClusterId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.provisioningTimeout">provisioningTimeout</a></code> | <code><a href="#@cdktf/provider-spotinst.MrscalerAwsProvisioningTimeoutOutputReference">MrscalerAwsProvisioningTimeoutOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalInfoInput">additionalInfoInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalPrimarySecurityGroupsInput">additionalPrimarySecurityGroupsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalReplicaSecurityGroupsInput">additionalReplicaSecurityGroupsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.applicationsInput">applicationsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsApplications">MrscalerAwsApplications</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.availabilityZonesInput">availabilityZonesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.bootstrapActionsFileInput">bootstrapActionsFileInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsBootstrapActionsFile">MrscalerAwsBootstrapActionsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.clusterIdInput">clusterIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.configurationsFileInput">configurationsFileInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsConfigurationsFile">MrscalerAwsConfigurationsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreDesiredCapacityInput">coreDesiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreEbsBlockDeviceInput">coreEbsBlockDeviceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreEbsBlockDevice">MrscalerAwsCoreEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreEbsOptimizedInput">coreEbsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreInstanceTypesInput">coreInstanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreLifecycleInput">coreLifecycleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreMaxSizeInput">coreMaxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreMinSizeInput">coreMinSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreScalingDownPolicyInput">coreScalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingDownPolicy">MrscalerAwsCoreScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreScalingUpPolicyInput">coreScalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingUpPolicy">MrscalerAwsCoreScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreUnitInput">coreUnitInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.customAmiIdInput">customAmiIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.descriptionInput">descriptionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.ebsRootVolumeSizeInput">ebsRootVolumeSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.ec2KeyNameInput">ec2KeyNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.exposeClusterIdInput">exposeClusterIdInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.instanceWeightsInput">instanceWeightsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsInstanceWeights">MrscalerAwsInstanceWeights</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.jobFlowRoleInput">jobFlowRoleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.keepJobFlowAliveInput">keepJobFlowAliveInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.logUriInput">logUriInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.managedPrimarySecurityGroupInput">managedPrimarySecurityGroupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.managedReplicaSecurityGroupInput">managedReplicaSecurityGroupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterEbsBlockDeviceInput">masterEbsBlockDeviceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsMasterEbsBlockDevice">MrscalerAwsMasterEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterEbsOptimizedInput">masterEbsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterInstanceTypesInput">masterInstanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterLifecycleInput">masterLifecycleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterTargetInput">masterTargetInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.provisioningTimeoutInput">provisioningTimeoutInput</a></code> | <code><a href="#@cdktf/provider-spotinst.MrscalerAwsProvisioningTimeout">MrscalerAwsProvisioningTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.releaseLabelInput">releaseLabelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.repoUpgradeOnBootInput">repoUpgradeOnBootInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.retriesInput">retriesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsScheduledTask">MrscalerAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.securityConfigInput">securityConfigInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.serviceAccessSecurityGroupInput">serviceAccessSecurityGroupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.serviceRoleInput">serviceRoleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.stepsFileInput">stepsFileInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsStepsFile">MrscalerAwsStepsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.strategyInput">strategyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTags">MrscalerAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskDesiredCapacityInput">taskDesiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskEbsBlockDeviceInput">taskEbsBlockDeviceInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskEbsBlockDevice">MrscalerAwsTaskEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskEbsOptimizedInput">taskEbsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskInstanceTypesInput">taskInstanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskLifecycleInput">taskLifecycleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskMaxSizeInput">taskMaxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskMinSizeInput">taskMinSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskScalingDownPolicyInput">taskScalingDownPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingDownPolicy">MrscalerAwsTaskScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskScalingUpPolicyInput">taskScalingUpPolicyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingUpPolicy">MrscalerAwsTaskScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskUnitInput">taskUnitInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terminationPoliciesInput">terminationPoliciesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTerminationPolicies">MrscalerAwsTerminationPolicies</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terminationProtectedInput">terminationProtectedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.visibleToAllUsersInput">visibleToAllUsersInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalInfo">additionalInfo</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalPrimarySecurityGroups">additionalPrimarySecurityGroups</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.additionalReplicaSecurityGroups">additionalReplicaSecurityGroups</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.applications">applications</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsApplications">MrscalerAwsApplications</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.availabilityZones">availabilityZones</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.bootstrapActionsFile">bootstrapActionsFile</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsBootstrapActionsFile">MrscalerAwsBootstrapActionsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.clusterId">clusterId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.configurationsFile">configurationsFile</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsConfigurationsFile">MrscalerAwsConfigurationsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreDesiredCapacity">coreDesiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreEbsBlockDevice">coreEbsBlockDevice</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreEbsBlockDevice">MrscalerAwsCoreEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreEbsOptimized">coreEbsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreInstanceTypes">coreInstanceTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreLifecycle">coreLifecycle</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreMaxSize">coreMaxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreMinSize">coreMinSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreScalingDownPolicy">coreScalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingDownPolicy">MrscalerAwsCoreScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreScalingUpPolicy">coreScalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingUpPolicy">MrscalerAwsCoreScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.coreUnit">coreUnit</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.customAmiId">customAmiId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.ebsRootVolumeSize">ebsRootVolumeSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.ec2KeyName">ec2KeyName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.exposeClusterId">exposeClusterId</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.instanceWeights">instanceWeights</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsInstanceWeights">MrscalerAwsInstanceWeights</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.jobFlowRole">jobFlowRole</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.keepJobFlowAlive">keepJobFlowAlive</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.logUri">logUri</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.managedPrimarySecurityGroup">managedPrimarySecurityGroup</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.managedReplicaSecurityGroup">managedReplicaSecurityGroup</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterEbsBlockDevice">masterEbsBlockDevice</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsMasterEbsBlockDevice">MrscalerAwsMasterEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterEbsOptimized">masterEbsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterInstanceTypes">masterInstanceTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterLifecycle">masterLifecycle</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.masterTarget">masterTarget</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.releaseLabel">releaseLabel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.repoUpgradeOnBoot">repoUpgradeOnBoot</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.retries">retries</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsScheduledTask">MrscalerAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.securityConfig">securityConfig</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.serviceAccessSecurityGroup">serviceAccessSecurityGroup</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.serviceRole">serviceRole</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.stepsFile">stepsFile</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsStepsFile">MrscalerAwsStepsFile</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.strategy">strategy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTags">MrscalerAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskDesiredCapacity">taskDesiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskEbsBlockDevice">taskEbsBlockDevice</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskEbsBlockDevice">MrscalerAwsTaskEbsBlockDevice</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskEbsOptimized">taskEbsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskInstanceTypes">taskInstanceTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskLifecycle">taskLifecycle</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskMaxSize">taskMaxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskMinSize">taskMinSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskScalingDownPolicy">taskScalingDownPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingDownPolicy">MrscalerAwsTaskScalingDownPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskScalingUpPolicy">taskScalingUpPolicy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingUpPolicy">MrscalerAwsTaskScalingUpPolicy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.taskUnit">taskUnit</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terminationPolicies">terminationPolicies</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MrscalerAwsTerminationPolicies">MrscalerAwsTerminationPolicies</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.terminationProtected">terminationProtected</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.visibleToAllUsers">visibleToAllUsers</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MrscalerAws.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MrscalerAws.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MrscalerAws.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MrscalerAws.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MrscalerAws.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MrscalerAws.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MrscalerAws.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MrscalerAws.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MrscalerAws.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MrscalerAws.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MrscalerAws.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MrscalerAws.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `outputClusterId`<sup>Required</sup> <a name="outputClusterId" id="@cdktf/provider-spotinst.MrscalerAws.property.outputClusterId"></a>

```typescript
public readonly outputClusterId: string;
```

- *Type:* string

---

##### `provisioningTimeout`<sup>Required</sup> <a name="provisioningTimeout" id="@cdktf/provider-spotinst.MrscalerAws.property.provisioningTimeout"></a>

```typescript
public readonly provisioningTimeout: MrscalerAwsProvisioningTimeoutOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MrscalerAwsProvisioningTimeoutOutputReference">MrscalerAwsProvisioningTimeoutOutputReference</a>

---

##### `additionalInfoInput`<sup>Optional</sup> <a name="additionalInfoInput" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalInfoInput"></a>

```typescript
public readonly additionalInfoInput: string;
```

- *Type:* string

---

##### `additionalPrimarySecurityGroupsInput`<sup>Optional</sup> <a name="additionalPrimarySecurityGroupsInput" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalPrimarySecurityGroupsInput"></a>

```typescript
public readonly additionalPrimarySecurityGroupsInput: string[];
```

- *Type:* string[]

---

##### `additionalReplicaSecurityGroupsInput`<sup>Optional</sup> <a name="additionalReplicaSecurityGroupsInput" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalReplicaSecurityGroupsInput"></a>

```typescript
public readonly additionalReplicaSecurityGroupsInput: string[];
```

- *Type:* string[]

---

##### `applicationsInput`<sup>Optional</sup> <a name="applicationsInput" id="@cdktf/provider-spotinst.MrscalerAws.property.applicationsInput"></a>

```typescript
public readonly applicationsInput: IResolvable | MrscalerAwsApplications[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsApplications">MrscalerAwsApplications</a>[]

---

##### `availabilityZonesInput`<sup>Optional</sup> <a name="availabilityZonesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.availabilityZonesInput"></a>

```typescript
public readonly availabilityZonesInput: string[];
```

- *Type:* string[]

---

##### `bootstrapActionsFileInput`<sup>Optional</sup> <a name="bootstrapActionsFileInput" id="@cdktf/provider-spotinst.MrscalerAws.property.bootstrapActionsFileInput"></a>

```typescript
public readonly bootstrapActionsFileInput: IResolvable | MrscalerAwsBootstrapActionsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsBootstrapActionsFile">MrscalerAwsBootstrapActionsFile</a>[]

---

##### `clusterIdInput`<sup>Optional</sup> <a name="clusterIdInput" id="@cdktf/provider-spotinst.MrscalerAws.property.clusterIdInput"></a>

```typescript
public readonly clusterIdInput: string;
```

- *Type:* string

---

##### `configurationsFileInput`<sup>Optional</sup> <a name="configurationsFileInput" id="@cdktf/provider-spotinst.MrscalerAws.property.configurationsFileInput"></a>

```typescript
public readonly configurationsFileInput: IResolvable | MrscalerAwsConfigurationsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsConfigurationsFile">MrscalerAwsConfigurationsFile</a>[]

---

##### `coreDesiredCapacityInput`<sup>Optional</sup> <a name="coreDesiredCapacityInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreDesiredCapacityInput"></a>

```typescript
public readonly coreDesiredCapacityInput: number;
```

- *Type:* number

---

##### `coreEbsBlockDeviceInput`<sup>Optional</sup> <a name="coreEbsBlockDeviceInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreEbsBlockDeviceInput"></a>

```typescript
public readonly coreEbsBlockDeviceInput: IResolvable | MrscalerAwsCoreEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreEbsBlockDevice">MrscalerAwsCoreEbsBlockDevice</a>[]

---

##### `coreEbsOptimizedInput`<sup>Optional</sup> <a name="coreEbsOptimizedInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreEbsOptimizedInput"></a>

```typescript
public readonly coreEbsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `coreInstanceTypesInput`<sup>Optional</sup> <a name="coreInstanceTypesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreInstanceTypesInput"></a>

```typescript
public readonly coreInstanceTypesInput: string[];
```

- *Type:* string[]

---

##### `coreLifecycleInput`<sup>Optional</sup> <a name="coreLifecycleInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreLifecycleInput"></a>

```typescript
public readonly coreLifecycleInput: string;
```

- *Type:* string

---

##### `coreMaxSizeInput`<sup>Optional</sup> <a name="coreMaxSizeInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreMaxSizeInput"></a>

```typescript
public readonly coreMaxSizeInput: number;
```

- *Type:* number

---

##### `coreMinSizeInput`<sup>Optional</sup> <a name="coreMinSizeInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreMinSizeInput"></a>

```typescript
public readonly coreMinSizeInput: number;
```

- *Type:* number

---

##### `coreScalingDownPolicyInput`<sup>Optional</sup> <a name="coreScalingDownPolicyInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreScalingDownPolicyInput"></a>

```typescript
public readonly coreScalingDownPolicyInput: IResolvable | MrscalerAwsCoreScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingDownPolicy">MrscalerAwsCoreScalingDownPolicy</a>[]

---

##### `coreScalingUpPolicyInput`<sup>Optional</sup> <a name="coreScalingUpPolicyInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreScalingUpPolicyInput"></a>

```typescript
public readonly coreScalingUpPolicyInput: IResolvable | MrscalerAwsCoreScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingUpPolicy">MrscalerAwsCoreScalingUpPolicy</a>[]

---

##### `coreUnitInput`<sup>Optional</sup> <a name="coreUnitInput" id="@cdktf/provider-spotinst.MrscalerAws.property.coreUnitInput"></a>

```typescript
public readonly coreUnitInput: string;
```

- *Type:* string

---

##### `customAmiIdInput`<sup>Optional</sup> <a name="customAmiIdInput" id="@cdktf/provider-spotinst.MrscalerAws.property.customAmiIdInput"></a>

```typescript
public readonly customAmiIdInput: string;
```

- *Type:* string

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-spotinst.MrscalerAws.property.descriptionInput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* string

---

##### `ebsRootVolumeSizeInput`<sup>Optional</sup> <a name="ebsRootVolumeSizeInput" id="@cdktf/provider-spotinst.MrscalerAws.property.ebsRootVolumeSizeInput"></a>

```typescript
public readonly ebsRootVolumeSizeInput: number;
```

- *Type:* number

---

##### `ec2KeyNameInput`<sup>Optional</sup> <a name="ec2KeyNameInput" id="@cdktf/provider-spotinst.MrscalerAws.property.ec2KeyNameInput"></a>

```typescript
public readonly ec2KeyNameInput: string;
```

- *Type:* string

---

##### `exposeClusterIdInput`<sup>Optional</sup> <a name="exposeClusterIdInput" id="@cdktf/provider-spotinst.MrscalerAws.property.exposeClusterIdInput"></a>

```typescript
public readonly exposeClusterIdInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `instanceWeightsInput`<sup>Optional</sup> <a name="instanceWeightsInput" id="@cdktf/provider-spotinst.MrscalerAws.property.instanceWeightsInput"></a>

```typescript
public readonly instanceWeightsInput: IResolvable | MrscalerAwsInstanceWeights[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsInstanceWeights">MrscalerAwsInstanceWeights</a>[]

---

##### `jobFlowRoleInput`<sup>Optional</sup> <a name="jobFlowRoleInput" id="@cdktf/provider-spotinst.MrscalerAws.property.jobFlowRoleInput"></a>

```typescript
public readonly jobFlowRoleInput: string;
```

- *Type:* string

---

##### `keepJobFlowAliveInput`<sup>Optional</sup> <a name="keepJobFlowAliveInput" id="@cdktf/provider-spotinst.MrscalerAws.property.keepJobFlowAliveInput"></a>

```typescript
public readonly keepJobFlowAliveInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `logUriInput`<sup>Optional</sup> <a name="logUriInput" id="@cdktf/provider-spotinst.MrscalerAws.property.logUriInput"></a>

```typescript
public readonly logUriInput: string;
```

- *Type:* string

---

##### `managedPrimarySecurityGroupInput`<sup>Optional</sup> <a name="managedPrimarySecurityGroupInput" id="@cdktf/provider-spotinst.MrscalerAws.property.managedPrimarySecurityGroupInput"></a>

```typescript
public readonly managedPrimarySecurityGroupInput: string;
```

- *Type:* string

---

##### `managedReplicaSecurityGroupInput`<sup>Optional</sup> <a name="managedReplicaSecurityGroupInput" id="@cdktf/provider-spotinst.MrscalerAws.property.managedReplicaSecurityGroupInput"></a>

```typescript
public readonly managedReplicaSecurityGroupInput: string;
```

- *Type:* string

---

##### `masterEbsBlockDeviceInput`<sup>Optional</sup> <a name="masterEbsBlockDeviceInput" id="@cdktf/provider-spotinst.MrscalerAws.property.masterEbsBlockDeviceInput"></a>

```typescript
public readonly masterEbsBlockDeviceInput: IResolvable | MrscalerAwsMasterEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsMasterEbsBlockDevice">MrscalerAwsMasterEbsBlockDevice</a>[]

---

##### `masterEbsOptimizedInput`<sup>Optional</sup> <a name="masterEbsOptimizedInput" id="@cdktf/provider-spotinst.MrscalerAws.property.masterEbsOptimizedInput"></a>

```typescript
public readonly masterEbsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `masterInstanceTypesInput`<sup>Optional</sup> <a name="masterInstanceTypesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.masterInstanceTypesInput"></a>

```typescript
public readonly masterInstanceTypesInput: string[];
```

- *Type:* string[]

---

##### `masterLifecycleInput`<sup>Optional</sup> <a name="masterLifecycleInput" id="@cdktf/provider-spotinst.MrscalerAws.property.masterLifecycleInput"></a>

```typescript
public readonly masterLifecycleInput: string;
```

- *Type:* string

---

##### `masterTargetInput`<sup>Optional</sup> <a name="masterTargetInput" id="@cdktf/provider-spotinst.MrscalerAws.property.masterTargetInput"></a>

```typescript
public readonly masterTargetInput: number;
```

- *Type:* number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.MrscalerAws.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `provisioningTimeoutInput`<sup>Optional</sup> <a name="provisioningTimeoutInput" id="@cdktf/provider-spotinst.MrscalerAws.property.provisioningTimeoutInput"></a>

```typescript
public readonly provisioningTimeoutInput: MrscalerAwsProvisioningTimeout;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MrscalerAwsProvisioningTimeout">MrscalerAwsProvisioningTimeout</a>

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.MrscalerAws.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `releaseLabelInput`<sup>Optional</sup> <a name="releaseLabelInput" id="@cdktf/provider-spotinst.MrscalerAws.property.releaseLabelInput"></a>

```typescript
public readonly releaseLabelInput: string;
```

- *Type:* string

---

##### `repoUpgradeOnBootInput`<sup>Optional</sup> <a name="repoUpgradeOnBootInput" id="@cdktf/provider-spotinst.MrscalerAws.property.repoUpgradeOnBootInput"></a>

```typescript
public readonly repoUpgradeOnBootInput: string;
```

- *Type:* string

---

##### `retriesInput`<sup>Optional</sup> <a name="retriesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.retriesInput"></a>

```typescript
public readonly retriesInput: number;
```

- *Type:* number

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.MrscalerAws.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | MrscalerAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsScheduledTask">MrscalerAwsScheduledTask</a>[]

---

##### `securityConfigInput`<sup>Optional</sup> <a name="securityConfigInput" id="@cdktf/provider-spotinst.MrscalerAws.property.securityConfigInput"></a>

```typescript
public readonly securityConfigInput: string;
```

- *Type:* string

---

##### `serviceAccessSecurityGroupInput`<sup>Optional</sup> <a name="serviceAccessSecurityGroupInput" id="@cdktf/provider-spotinst.MrscalerAws.property.serviceAccessSecurityGroupInput"></a>

```typescript
public readonly serviceAccessSecurityGroupInput: string;
```

- *Type:* string

---

##### `serviceRoleInput`<sup>Optional</sup> <a name="serviceRoleInput" id="@cdktf/provider-spotinst.MrscalerAws.property.serviceRoleInput"></a>

```typescript
public readonly serviceRoleInput: string;
```

- *Type:* string

---

##### `stepsFileInput`<sup>Optional</sup> <a name="stepsFileInput" id="@cdktf/provider-spotinst.MrscalerAws.property.stepsFileInput"></a>

```typescript
public readonly stepsFileInput: IResolvable | MrscalerAwsStepsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsStepsFile">MrscalerAwsStepsFile</a>[]

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.MrscalerAws.property.strategyInput"></a>

```typescript
public readonly strategyInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MrscalerAws.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MrscalerAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTags">MrscalerAwsTags</a>[]

---

##### `taskDesiredCapacityInput`<sup>Optional</sup> <a name="taskDesiredCapacityInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskDesiredCapacityInput"></a>

```typescript
public readonly taskDesiredCapacityInput: number;
```

- *Type:* number

---

##### `taskEbsBlockDeviceInput`<sup>Optional</sup> <a name="taskEbsBlockDeviceInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskEbsBlockDeviceInput"></a>

```typescript
public readonly taskEbsBlockDeviceInput: IResolvable | MrscalerAwsTaskEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskEbsBlockDevice">MrscalerAwsTaskEbsBlockDevice</a>[]

---

##### `taskEbsOptimizedInput`<sup>Optional</sup> <a name="taskEbsOptimizedInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskEbsOptimizedInput"></a>

```typescript
public readonly taskEbsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `taskInstanceTypesInput`<sup>Optional</sup> <a name="taskInstanceTypesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskInstanceTypesInput"></a>

```typescript
public readonly taskInstanceTypesInput: string[];
```

- *Type:* string[]

---

##### `taskLifecycleInput`<sup>Optional</sup> <a name="taskLifecycleInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskLifecycleInput"></a>

```typescript
public readonly taskLifecycleInput: string;
```

- *Type:* string

---

##### `taskMaxSizeInput`<sup>Optional</sup> <a name="taskMaxSizeInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskMaxSizeInput"></a>

```typescript
public readonly taskMaxSizeInput: number;
```

- *Type:* number

---

##### `taskMinSizeInput`<sup>Optional</sup> <a name="taskMinSizeInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskMinSizeInput"></a>

```typescript
public readonly taskMinSizeInput: number;
```

- *Type:* number

---

##### `taskScalingDownPolicyInput`<sup>Optional</sup> <a name="taskScalingDownPolicyInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskScalingDownPolicyInput"></a>

```typescript
public readonly taskScalingDownPolicyInput: IResolvable | MrscalerAwsTaskScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingDownPolicy">MrscalerAwsTaskScalingDownPolicy</a>[]

---

##### `taskScalingUpPolicyInput`<sup>Optional</sup> <a name="taskScalingUpPolicyInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskScalingUpPolicyInput"></a>

```typescript
public readonly taskScalingUpPolicyInput: IResolvable | MrscalerAwsTaskScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingUpPolicy">MrscalerAwsTaskScalingUpPolicy</a>[]

---

##### `taskUnitInput`<sup>Optional</sup> <a name="taskUnitInput" id="@cdktf/provider-spotinst.MrscalerAws.property.taskUnitInput"></a>

```typescript
public readonly taskUnitInput: string;
```

- *Type:* string

---

##### `terminationPoliciesInput`<sup>Optional</sup> <a name="terminationPoliciesInput" id="@cdktf/provider-spotinst.MrscalerAws.property.terminationPoliciesInput"></a>

```typescript
public readonly terminationPoliciesInput: IResolvable | MrscalerAwsTerminationPolicies[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTerminationPolicies">MrscalerAwsTerminationPolicies</a>[]

---

##### `terminationProtectedInput`<sup>Optional</sup> <a name="terminationProtectedInput" id="@cdktf/provider-spotinst.MrscalerAws.property.terminationProtectedInput"></a>

```typescript
public readonly terminationProtectedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `visibleToAllUsersInput`<sup>Optional</sup> <a name="visibleToAllUsersInput" id="@cdktf/provider-spotinst.MrscalerAws.property.visibleToAllUsersInput"></a>

```typescript
public readonly visibleToAllUsersInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `additionalInfo`<sup>Required</sup> <a name="additionalInfo" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalInfo"></a>

```typescript
public readonly additionalInfo: string;
```

- *Type:* string

---

##### `additionalPrimarySecurityGroups`<sup>Required</sup> <a name="additionalPrimarySecurityGroups" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalPrimarySecurityGroups"></a>

```typescript
public readonly additionalPrimarySecurityGroups: string[];
```

- *Type:* string[]

---

##### `additionalReplicaSecurityGroups`<sup>Required</sup> <a name="additionalReplicaSecurityGroups" id="@cdktf/provider-spotinst.MrscalerAws.property.additionalReplicaSecurityGroups"></a>

```typescript
public readonly additionalReplicaSecurityGroups: string[];
```

- *Type:* string[]

---

##### `applications`<sup>Required</sup> <a name="applications" id="@cdktf/provider-spotinst.MrscalerAws.property.applications"></a>

```typescript
public readonly applications: IResolvable | MrscalerAwsApplications[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsApplications">MrscalerAwsApplications</a>[]

---

##### `availabilityZones`<sup>Required</sup> <a name="availabilityZones" id="@cdktf/provider-spotinst.MrscalerAws.property.availabilityZones"></a>

```typescript
public readonly availabilityZones: string[];
```

- *Type:* string[]

---

##### `bootstrapActionsFile`<sup>Required</sup> <a name="bootstrapActionsFile" id="@cdktf/provider-spotinst.MrscalerAws.property.bootstrapActionsFile"></a>

```typescript
public readonly bootstrapActionsFile: IResolvable | MrscalerAwsBootstrapActionsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsBootstrapActionsFile">MrscalerAwsBootstrapActionsFile</a>[]

---

##### `clusterId`<sup>Required</sup> <a name="clusterId" id="@cdktf/provider-spotinst.MrscalerAws.property.clusterId"></a>

```typescript
public readonly clusterId: string;
```

- *Type:* string

---

##### `configurationsFile`<sup>Required</sup> <a name="configurationsFile" id="@cdktf/provider-spotinst.MrscalerAws.property.configurationsFile"></a>

```typescript
public readonly configurationsFile: IResolvable | MrscalerAwsConfigurationsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsConfigurationsFile">MrscalerAwsConfigurationsFile</a>[]

---

##### `coreDesiredCapacity`<sup>Required</sup> <a name="coreDesiredCapacity" id="@cdktf/provider-spotinst.MrscalerAws.property.coreDesiredCapacity"></a>

```typescript
public readonly coreDesiredCapacity: number;
```

- *Type:* number

---

##### `coreEbsBlockDevice`<sup>Required</sup> <a name="coreEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.property.coreEbsBlockDevice"></a>

```typescript
public readonly coreEbsBlockDevice: IResolvable | MrscalerAwsCoreEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreEbsBlockDevice">MrscalerAwsCoreEbsBlockDevice</a>[]

---

##### `coreEbsOptimized`<sup>Required</sup> <a name="coreEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.property.coreEbsOptimized"></a>

```typescript
public readonly coreEbsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `coreInstanceTypes`<sup>Required</sup> <a name="coreInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.property.coreInstanceTypes"></a>

```typescript
public readonly coreInstanceTypes: string[];
```

- *Type:* string[]

---

##### `coreLifecycle`<sup>Required</sup> <a name="coreLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.property.coreLifecycle"></a>

```typescript
public readonly coreLifecycle: string;
```

- *Type:* string

---

##### `coreMaxSize`<sup>Required</sup> <a name="coreMaxSize" id="@cdktf/provider-spotinst.MrscalerAws.property.coreMaxSize"></a>

```typescript
public readonly coreMaxSize: number;
```

- *Type:* number

---

##### `coreMinSize`<sup>Required</sup> <a name="coreMinSize" id="@cdktf/provider-spotinst.MrscalerAws.property.coreMinSize"></a>

```typescript
public readonly coreMinSize: number;
```

- *Type:* number

---

##### `coreScalingDownPolicy`<sup>Required</sup> <a name="coreScalingDownPolicy" id="@cdktf/provider-spotinst.MrscalerAws.property.coreScalingDownPolicy"></a>

```typescript
public readonly coreScalingDownPolicy: IResolvable | MrscalerAwsCoreScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingDownPolicy">MrscalerAwsCoreScalingDownPolicy</a>[]

---

##### `coreScalingUpPolicy`<sup>Required</sup> <a name="coreScalingUpPolicy" id="@cdktf/provider-spotinst.MrscalerAws.property.coreScalingUpPolicy"></a>

```typescript
public readonly coreScalingUpPolicy: IResolvable | MrscalerAwsCoreScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsCoreScalingUpPolicy">MrscalerAwsCoreScalingUpPolicy</a>[]

---

##### `coreUnit`<sup>Required</sup> <a name="coreUnit" id="@cdktf/provider-spotinst.MrscalerAws.property.coreUnit"></a>

```typescript
public readonly coreUnit: string;
```

- *Type:* string

---

##### `customAmiId`<sup>Required</sup> <a name="customAmiId" id="@cdktf/provider-spotinst.MrscalerAws.property.customAmiId"></a>

```typescript
public readonly customAmiId: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-spotinst.MrscalerAws.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `ebsRootVolumeSize`<sup>Required</sup> <a name="ebsRootVolumeSize" id="@cdktf/provider-spotinst.MrscalerAws.property.ebsRootVolumeSize"></a>

```typescript
public readonly ebsRootVolumeSize: number;
```

- *Type:* number

---

##### `ec2KeyName`<sup>Required</sup> <a name="ec2KeyName" id="@cdktf/provider-spotinst.MrscalerAws.property.ec2KeyName"></a>

```typescript
public readonly ec2KeyName: string;
```

- *Type:* string

---

##### `exposeClusterId`<sup>Required</sup> <a name="exposeClusterId" id="@cdktf/provider-spotinst.MrscalerAws.property.exposeClusterId"></a>

```typescript
public readonly exposeClusterId: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `instanceWeights`<sup>Required</sup> <a name="instanceWeights" id="@cdktf/provider-spotinst.MrscalerAws.property.instanceWeights"></a>

```typescript
public readonly instanceWeights: IResolvable | MrscalerAwsInstanceWeights[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsInstanceWeights">MrscalerAwsInstanceWeights</a>[]

---

##### `jobFlowRole`<sup>Required</sup> <a name="jobFlowRole" id="@cdktf/provider-spotinst.MrscalerAws.property.jobFlowRole"></a>

```typescript
public readonly jobFlowRole: string;
```

- *Type:* string

---

##### `keepJobFlowAlive`<sup>Required</sup> <a name="keepJobFlowAlive" id="@cdktf/provider-spotinst.MrscalerAws.property.keepJobFlowAlive"></a>

```typescript
public readonly keepJobFlowAlive: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `logUri`<sup>Required</sup> <a name="logUri" id="@cdktf/provider-spotinst.MrscalerAws.property.logUri"></a>

```typescript
public readonly logUri: string;
```

- *Type:* string

---

##### `managedPrimarySecurityGroup`<sup>Required</sup> <a name="managedPrimarySecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.property.managedPrimarySecurityGroup"></a>

```typescript
public readonly managedPrimarySecurityGroup: string;
```

- *Type:* string

---

##### `managedReplicaSecurityGroup`<sup>Required</sup> <a name="managedReplicaSecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.property.managedReplicaSecurityGroup"></a>

```typescript
public readonly managedReplicaSecurityGroup: string;
```

- *Type:* string

---

##### `masterEbsBlockDevice`<sup>Required</sup> <a name="masterEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.property.masterEbsBlockDevice"></a>

```typescript
public readonly masterEbsBlockDevice: IResolvable | MrscalerAwsMasterEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsMasterEbsBlockDevice">MrscalerAwsMasterEbsBlockDevice</a>[]

---

##### `masterEbsOptimized`<sup>Required</sup> <a name="masterEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.property.masterEbsOptimized"></a>

```typescript
public readonly masterEbsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `masterInstanceTypes`<sup>Required</sup> <a name="masterInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.property.masterInstanceTypes"></a>

```typescript
public readonly masterInstanceTypes: string[];
```

- *Type:* string[]

---

##### `masterLifecycle`<sup>Required</sup> <a name="masterLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.property.masterLifecycle"></a>

```typescript
public readonly masterLifecycle: string;
```

- *Type:* string

---

##### `masterTarget`<sup>Required</sup> <a name="masterTarget" id="@cdktf/provider-spotinst.MrscalerAws.property.masterTarget"></a>

```typescript
public readonly masterTarget: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.MrscalerAws.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.MrscalerAws.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `releaseLabel`<sup>Required</sup> <a name="releaseLabel" id="@cdktf/provider-spotinst.MrscalerAws.property.releaseLabel"></a>

```typescript
public readonly releaseLabel: string;
```

- *Type:* string

---

##### `repoUpgradeOnBoot`<sup>Required</sup> <a name="repoUpgradeOnBoot" id="@cdktf/provider-spotinst.MrscalerAws.property.repoUpgradeOnBoot"></a>

```typescript
public readonly repoUpgradeOnBoot: string;
```

- *Type:* string

---

##### `retries`<sup>Required</sup> <a name="retries" id="@cdktf/provider-spotinst.MrscalerAws.property.retries"></a>

```typescript
public readonly retries: number;
```

- *Type:* number

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.MrscalerAws.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | MrscalerAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsScheduledTask">MrscalerAwsScheduledTask</a>[]

---

##### `securityConfig`<sup>Required</sup> <a name="securityConfig" id="@cdktf/provider-spotinst.MrscalerAws.property.securityConfig"></a>

```typescript
public readonly securityConfig: string;
```

- *Type:* string

---

##### `serviceAccessSecurityGroup`<sup>Required</sup> <a name="serviceAccessSecurityGroup" id="@cdktf/provider-spotinst.MrscalerAws.property.serviceAccessSecurityGroup"></a>

```typescript
public readonly serviceAccessSecurityGroup: string;
```

- *Type:* string

---

##### `serviceRole`<sup>Required</sup> <a name="serviceRole" id="@cdktf/provider-spotinst.MrscalerAws.property.serviceRole"></a>

```typescript
public readonly serviceRole: string;
```

- *Type:* string

---

##### `stepsFile`<sup>Required</sup> <a name="stepsFile" id="@cdktf/provider-spotinst.MrscalerAws.property.stepsFile"></a>

```typescript
public readonly stepsFile: IResolvable | MrscalerAwsStepsFile[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsStepsFile">MrscalerAwsStepsFile</a>[]

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.MrscalerAws.property.strategy"></a>

```typescript
public readonly strategy: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MrscalerAws.property.tags"></a>

```typescript
public readonly tags: IResolvable | MrscalerAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTags">MrscalerAwsTags</a>[]

---

##### `taskDesiredCapacity`<sup>Required</sup> <a name="taskDesiredCapacity" id="@cdktf/provider-spotinst.MrscalerAws.property.taskDesiredCapacity"></a>

```typescript
public readonly taskDesiredCapacity: number;
```

- *Type:* number

---

##### `taskEbsBlockDevice`<sup>Required</sup> <a name="taskEbsBlockDevice" id="@cdktf/provider-spotinst.MrscalerAws.property.taskEbsBlockDevice"></a>

```typescript
public readonly taskEbsBlockDevice: IResolvable | MrscalerAwsTaskEbsBlockDevice[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskEbsBlockDevice">MrscalerAwsTaskEbsBlockDevice</a>[]

---

##### `taskEbsOptimized`<sup>Required</sup> <a name="taskEbsOptimized" id="@cdktf/provider-spotinst.MrscalerAws.property.taskEbsOptimized"></a>

```typescript
public readonly taskEbsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `taskInstanceTypes`<sup>Required</sup> <a name="taskInstanceTypes" id="@cdktf/provider-spotinst.MrscalerAws.property.taskInstanceTypes"></a>

```typescript
public readonly taskInstanceTypes: string[];
```

- *Type:* string[]

---

##### `taskLifecycle`<sup>Required</sup> <a name="taskLifecycle" id="@cdktf/provider-spotinst.MrscalerAws.property.taskLifecycle"></a>

```typescript
public readonly taskLifecycle: string;
```

- *Type:* string

---

##### `taskMaxSize`<sup>Required</sup> <a name="taskMaxSize" id="@cdktf/provider-spotinst.MrscalerAws.property.taskMaxSize"></a>

```typescript
public readonly taskMaxSize: number;
```

- *Type:* number

---

##### `taskMinSize`<sup>Required</sup> <a name="taskMinSize" id="@cdktf/provider-spotinst.MrscalerAws.property.taskMinSize"></a>

```typescript
public readonly taskMinSize: number;
```

- *Type:* number

---

##### `taskScalingDownPolicy`<sup>Required</sup> <a name="taskScalingDownPolicy" id="@cdktf/provider-spotinst.MrscalerAws.property.taskScalingDownPolicy"></a>

```typescript
public readonly taskScalingDownPolicy: IResolvable | MrscalerAwsTaskScalingDownPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingDownPolicy">MrscalerAwsTaskScalingDownPolicy</a>[]

---

##### `taskScalingUpPolicy`<sup>Required</sup> <a name="taskScalingUpPolicy" id="@cdktf/provider-spotinst.MrscalerAws.property.taskScalingUpPolicy"></a>

```typescript
public readonly taskScalingUpPolicy: IResolvable | MrscalerAwsTaskScalingUpPolicy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTaskScalingUpPolicy">MrscalerAwsTaskScalingUpPolicy</a>[]

---

##### `taskUnit`<sup>Required</sup> <a name="taskUnit" id="@cdktf/provider-spotinst.MrscalerAws.property.taskUnit"></a>

```typescript
public readonly taskUnit: string;
```

- *Type:* string

---

##### `terminationPolicies`<sup>Required</sup> <a name="terminationPolicies" id="@cdktf/provider-spotinst.MrscalerAws.property.terminationPolicies"></a>

```typescript
public readonly terminationPolicies: IResolvable | MrscalerAwsTerminationPolicies[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MrscalerAwsTerminationPolicies">MrscalerAwsTerminationPolicies</a>[]

---

##### `terminationProtected`<sup>Required</sup> <a name="terminationProtected" id="@cdktf/provider-spotinst.MrscalerAws.property.terminationProtected"></a>

```typescript
public readonly terminationProtected: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `visibleToAllUsers`<sup>Required</sup> <a name="visibleToAllUsers" id="@cdktf/provider-spotinst.MrscalerAws.property.visibleToAllUsers"></a>

```typescript
public readonly visibleToAllUsers: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MrscalerAws.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MrscalerAws.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiBalancer <a name="MultaiBalancer" id="@cdktf/provider-spotinst.MultaiBalancer"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer spotinst_multai_balancer}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiBalancer.Initializer"></a>

```typescript
import { MultaiBalancer } from '@cdktf/provider-spotinst'

new MultaiBalancer(scope: Construct, id: string, config: MultaiBalancerConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiBalancerConfig">MultaiBalancerConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiBalancer.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiBalancerConfig">MultaiBalancerConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.putConnectionTimeouts">putConnectionTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.resetConnectionTimeouts">resetConnectionTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.resetDnsCnameAliases">resetDnsCnameAliases</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.resetScheme">resetScheme</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.resetTags">resetTags</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiBalancer.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiBalancer.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiBalancer.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiBalancer.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiBalancer.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiBalancer.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiBalancer.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiBalancer.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiBalancer.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiBalancer.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putConnectionTimeouts` <a name="putConnectionTimeouts" id="@cdktf/provider-spotinst.MultaiBalancer.putConnectionTimeouts"></a>

```typescript
public putConnectionTimeouts(value: MultaiBalancerConnectionTimeouts): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiBalancer.putConnectionTimeouts.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiBalancerConnectionTimeouts">MultaiBalancerConnectionTimeouts</a>

---

##### `resetConnectionTimeouts` <a name="resetConnectionTimeouts" id="@cdktf/provider-spotinst.MultaiBalancer.resetConnectionTimeouts"></a>

```typescript
public resetConnectionTimeouts(): void
```

##### `resetDnsCnameAliases` <a name="resetDnsCnameAliases" id="@cdktf/provider-spotinst.MultaiBalancer.resetDnsCnameAliases"></a>

```typescript
public resetDnsCnameAliases(): void
```

##### `resetScheme` <a name="resetScheme" id="@cdktf/provider-spotinst.MultaiBalancer.resetScheme"></a>

```typescript
public resetScheme(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MultaiBalancer.resetTags"></a>

```typescript
public resetTags(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiBalancer.isConstruct"></a>

```typescript
import { MultaiBalancer } from '@cdktf/provider-spotinst'

MultaiBalancer.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiBalancer.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.connectionTimeouts">connectionTimeouts</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiBalancerConnectionTimeoutsOutputReference">MultaiBalancerConnectionTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.connectionTimeoutsInput">connectionTimeoutsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiBalancerConnectionTimeouts">MultaiBalancerConnectionTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.dnsCnameAliasesInput">dnsCnameAliasesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.schemeInput">schemeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiBalancerTags">MultaiBalancerTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.dnsCnameAliases">dnsCnameAliases</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.scheme">scheme</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiBalancerTags">MultaiBalancerTags</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiBalancer.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiBalancer.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiBalancer.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiBalancer.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiBalancer.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiBalancer.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiBalancer.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiBalancer.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiBalancer.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiBalancer.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiBalancer.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `connectionTimeouts`<sup>Required</sup> <a name="connectionTimeouts" id="@cdktf/provider-spotinst.MultaiBalancer.property.connectionTimeouts"></a>

```typescript
public readonly connectionTimeouts: MultaiBalancerConnectionTimeoutsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiBalancerConnectionTimeoutsOutputReference">MultaiBalancerConnectionTimeoutsOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiBalancer.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `connectionTimeoutsInput`<sup>Optional</sup> <a name="connectionTimeoutsInput" id="@cdktf/provider-spotinst.MultaiBalancer.property.connectionTimeoutsInput"></a>

```typescript
public readonly connectionTimeoutsInput: MultaiBalancerConnectionTimeouts;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiBalancerConnectionTimeouts">MultaiBalancerConnectionTimeouts</a>

---

##### `dnsCnameAliasesInput`<sup>Optional</sup> <a name="dnsCnameAliasesInput" id="@cdktf/provider-spotinst.MultaiBalancer.property.dnsCnameAliasesInput"></a>

```typescript
public readonly dnsCnameAliasesInput: string[];
```

- *Type:* string[]

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.MultaiBalancer.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `schemeInput`<sup>Optional</sup> <a name="schemeInput" id="@cdktf/provider-spotinst.MultaiBalancer.property.schemeInput"></a>

```typescript
public readonly schemeInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MultaiBalancer.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MultaiBalancerTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiBalancerTags">MultaiBalancerTags</a>[]

---

##### `dnsCnameAliases`<sup>Required</sup> <a name="dnsCnameAliases" id="@cdktf/provider-spotinst.MultaiBalancer.property.dnsCnameAliases"></a>

```typescript
public readonly dnsCnameAliases: string[];
```

- *Type:* string[]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.MultaiBalancer.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `scheme`<sup>Required</sup> <a name="scheme" id="@cdktf/provider-spotinst.MultaiBalancer.property.scheme"></a>

```typescript
public readonly scheme: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MultaiBalancer.property.tags"></a>

```typescript
public readonly tags: IResolvable | MultaiBalancerTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiBalancerTags">MultaiBalancerTags</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiBalancer.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiBalancer.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiDeployment <a name="MultaiDeployment" id="@cdktf/provider-spotinst.MultaiDeployment"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_deployment spotinst_multai_deployment}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiDeployment.Initializer"></a>

```typescript
import { MultaiDeployment } from '@cdktf/provider-spotinst'

new MultaiDeployment(scope: Construct, id: string, config: MultaiDeploymentConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiDeploymentConfig">MultaiDeploymentConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiDeployment.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiDeploymentConfig">MultaiDeploymentConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiDeployment.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiDeployment.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiDeployment.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiDeployment.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiDeployment.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiDeployment.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiDeployment.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiDeployment.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiDeployment.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiDeployment.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiDeployment.isConstruct"></a>

```typescript
import { MultaiDeployment } from '@cdktf/provider-spotinst'

MultaiDeployment.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiDeployment.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.name">name</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiDeployment.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiDeployment.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiDeployment.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiDeployment.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiDeployment.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiDeployment.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiDeployment.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiDeployment.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiDeployment.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiDeployment.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiDeployment.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiDeployment.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.MultaiDeployment.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.MultaiDeployment.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiDeployment.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiDeployment.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiListener <a name="MultaiListener" id="@cdktf/provider-spotinst.MultaiListener"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener spotinst_multai_listener}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiListener.Initializer"></a>

```typescript
import { MultaiListener } from '@cdktf/provider-spotinst'

new MultaiListener(scope: Construct, id: string, config: MultaiListenerConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiListenerConfig">MultaiListenerConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiListener.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiListenerConfig">MultaiListenerConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.putTlsConfig">putTlsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.resetTlsConfig">resetTlsConfig</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiListener.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiListener.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiListener.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiListener.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiListener.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiListener.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiListener.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiListener.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiListener.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiListener.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiListener.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiListener.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiListener.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiListener.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiListener.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiListener.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiListener.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putTlsConfig` <a name="putTlsConfig" id="@cdktf/provider-spotinst.MultaiListener.putTlsConfig"></a>

```typescript
public putTlsConfig(value: MultaiListenerTlsConfig): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiListener.putTlsConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiListenerTlsConfig">MultaiListenerTlsConfig</a>

---

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MultaiListener.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetTlsConfig` <a name="resetTlsConfig" id="@cdktf/provider-spotinst.MultaiListener.resetTlsConfig"></a>

```typescript
public resetTlsConfig(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiListener.isConstruct"></a>

```typescript
import { MultaiListener } from '@cdktf/provider-spotinst'

MultaiListener.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiListener.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.tlsConfig">tlsConfig</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiListenerTlsConfigOutputReference">MultaiListenerTlsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.balancerIdInput">balancerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.portInput">portInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.protocolInput">protocolInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiListenerTags">MultaiListenerTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.tlsConfigInput">tlsConfigInput</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiListenerTlsConfig">MultaiListenerTlsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.balancerId">balancerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.port">port</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.protocol">protocol</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiListenerTags">MultaiListenerTags</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiListener.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiListener.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiListener.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiListener.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiListener.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiListener.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiListener.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiListener.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiListener.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiListener.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiListener.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiListener.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `tlsConfig`<sup>Required</sup> <a name="tlsConfig" id="@cdktf/provider-spotinst.MultaiListener.property.tlsConfig"></a>

```typescript
public readonly tlsConfig: MultaiListenerTlsConfigOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiListenerTlsConfigOutputReference">MultaiListenerTlsConfigOutputReference</a>

---

##### `balancerIdInput`<sup>Optional</sup> <a name="balancerIdInput" id="@cdktf/provider-spotinst.MultaiListener.property.balancerIdInput"></a>

```typescript
public readonly balancerIdInput: string;
```

- *Type:* string

---

##### `portInput`<sup>Optional</sup> <a name="portInput" id="@cdktf/provider-spotinst.MultaiListener.property.portInput"></a>

```typescript
public readonly portInput: number;
```

- *Type:* number

---

##### `protocolInput`<sup>Optional</sup> <a name="protocolInput" id="@cdktf/provider-spotinst.MultaiListener.property.protocolInput"></a>

```typescript
public readonly protocolInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MultaiListener.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MultaiListenerTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiListenerTags">MultaiListenerTags</a>[]

---

##### `tlsConfigInput`<sup>Optional</sup> <a name="tlsConfigInput" id="@cdktf/provider-spotinst.MultaiListener.property.tlsConfigInput"></a>

```typescript
public readonly tlsConfigInput: MultaiListenerTlsConfig;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiListenerTlsConfig">MultaiListenerTlsConfig</a>

---

##### `balancerId`<sup>Required</sup> <a name="balancerId" id="@cdktf/provider-spotinst.MultaiListener.property.balancerId"></a>

```typescript
public readonly balancerId: string;
```

- *Type:* string

---

##### `port`<sup>Required</sup> <a name="port" id="@cdktf/provider-spotinst.MultaiListener.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

##### `protocol`<sup>Required</sup> <a name="protocol" id="@cdktf/provider-spotinst.MultaiListener.property.protocol"></a>

```typescript
public readonly protocol: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MultaiListener.property.tags"></a>

```typescript
public readonly tags: IResolvable | MultaiListenerTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiListenerTags">MultaiListenerTags</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiListener.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiListener.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiRoutingRule <a name="MultaiRoutingRule" id="@cdktf/provider-spotinst.MultaiRoutingRule"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule spotinst_multai_routing_rule}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiRoutingRule.Initializer"></a>

```typescript
import { MultaiRoutingRule } from '@cdktf/provider-spotinst'

new MultaiRoutingRule(scope: Construct, id: string, config: MultaiRoutingRuleConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRuleConfig">MultaiRoutingRuleConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiRoutingRule.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiRoutingRuleConfig">MultaiRoutingRuleConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.resetMiddlewareIds">resetMiddlewareIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.resetPriority">resetPriority</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.resetStrategy">resetStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.resetTags">resetTags</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiRoutingRule.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiRoutingRule.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiRoutingRule.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiRoutingRule.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiRoutingRule.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiRoutingRule.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiRoutingRule.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiRoutingRule.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiRoutingRule.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiRoutingRule.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetMiddlewareIds` <a name="resetMiddlewareIds" id="@cdktf/provider-spotinst.MultaiRoutingRule.resetMiddlewareIds"></a>

```typescript
public resetMiddlewareIds(): void
```

##### `resetPriority` <a name="resetPriority" id="@cdktf/provider-spotinst.MultaiRoutingRule.resetPriority"></a>

```typescript
public resetPriority(): void
```

##### `resetStrategy` <a name="resetStrategy" id="@cdktf/provider-spotinst.MultaiRoutingRule.resetStrategy"></a>

```typescript
public resetStrategy(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MultaiRoutingRule.resetTags"></a>

```typescript
public resetTags(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiRoutingRule.isConstruct"></a>

```typescript
import { MultaiRoutingRule } from '@cdktf/provider-spotinst'

MultaiRoutingRule.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiRoutingRule.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.balancerIdInput">balancerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.listenerIdInput">listenerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.middlewareIdsInput">middlewareIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.priorityInput">priorityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.routeInput">routeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.strategyInput">strategyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiRoutingRuleTags">MultaiRoutingRuleTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.targetSetIdsInput">targetSetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.balancerId">balancerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.listenerId">listenerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.middlewareIds">middlewareIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.priority">priority</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.route">route</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.strategy">strategy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiRoutingRuleTags">MultaiRoutingRuleTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.targetSetIds">targetSetIds</a></code> | <code>string[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `balancerIdInput`<sup>Optional</sup> <a name="balancerIdInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.balancerIdInput"></a>

```typescript
public readonly balancerIdInput: string;
```

- *Type:* string

---

##### `listenerIdInput`<sup>Optional</sup> <a name="listenerIdInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.listenerIdInput"></a>

```typescript
public readonly listenerIdInput: string;
```

- *Type:* string

---

##### `middlewareIdsInput`<sup>Optional</sup> <a name="middlewareIdsInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.middlewareIdsInput"></a>

```typescript
public readonly middlewareIdsInput: string[];
```

- *Type:* string[]

---

##### `priorityInput`<sup>Optional</sup> <a name="priorityInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.priorityInput"></a>

```typescript
public readonly priorityInput: number;
```

- *Type:* number

---

##### `routeInput`<sup>Optional</sup> <a name="routeInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.routeInput"></a>

```typescript
public readonly routeInput: string;
```

- *Type:* string

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.strategyInput"></a>

```typescript
public readonly strategyInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MultaiRoutingRuleTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiRoutingRuleTags">MultaiRoutingRuleTags</a>[]

---

##### `targetSetIdsInput`<sup>Optional</sup> <a name="targetSetIdsInput" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.targetSetIdsInput"></a>

```typescript
public readonly targetSetIdsInput: string[];
```

- *Type:* string[]

---

##### `balancerId`<sup>Required</sup> <a name="balancerId" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.balancerId"></a>

```typescript
public readonly balancerId: string;
```

- *Type:* string

---

##### `listenerId`<sup>Required</sup> <a name="listenerId" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.listenerId"></a>

```typescript
public readonly listenerId: string;
```

- *Type:* string

---

##### `middlewareIds`<sup>Required</sup> <a name="middlewareIds" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.middlewareIds"></a>

```typescript
public readonly middlewareIds: string[];
```

- *Type:* string[]

---

##### `priority`<sup>Required</sup> <a name="priority" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.priority"></a>

```typescript
public readonly priority: number;
```

- *Type:* number

---

##### `route`<sup>Required</sup> <a name="route" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.route"></a>

```typescript
public readonly route: string;
```

- *Type:* string

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.strategy"></a>

```typescript
public readonly strategy: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.tags"></a>

```typescript
public readonly tags: IResolvable | MultaiRoutingRuleTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiRoutingRuleTags">MultaiRoutingRuleTags</a>[]

---

##### `targetSetIds`<sup>Required</sup> <a name="targetSetIds" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.targetSetIds"></a>

```typescript
public readonly targetSetIds: string[];
```

- *Type:* string[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiRoutingRule.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiRoutingRule.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiTarget <a name="MultaiTarget" id="@cdktf/provider-spotinst.MultaiTarget"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target spotinst_multai_target}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiTarget.Initializer"></a>

```typescript
import { MultaiTarget } from '@cdktf/provider-spotinst'

new MultaiTarget(scope: Construct, id: string, config: MultaiTargetConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiTargetConfig">MultaiTargetConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiTarget.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiTargetConfig">MultaiTargetConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.resetPort">resetPort</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.resetTags">resetTags</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiTarget.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiTarget.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiTarget.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiTarget.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiTarget.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiTarget.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiTarget.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiTarget.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiTarget.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiTarget.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTarget.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetName` <a name="resetName" id="@cdktf/provider-spotinst.MultaiTarget.resetName"></a>

```typescript
public resetName(): void
```

##### `resetPort` <a name="resetPort" id="@cdktf/provider-spotinst.MultaiTarget.resetPort"></a>

```typescript
public resetPort(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MultaiTarget.resetTags"></a>

```typescript
public resetTags(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiTarget.isConstruct"></a>

```typescript
import { MultaiTarget } from '@cdktf/provider-spotinst'

MultaiTarget.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiTarget.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.balancerIdInput">balancerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.hostInput">hostInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.portInput">portInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiTargetTags">MultaiTargetTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.targetSetIdInput">targetSetIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.weightInput">weightInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.balancerId">balancerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.host">host</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.port">port</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiTargetTags">MultaiTargetTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.targetSetId">targetSetId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.weight">weight</a></code> | <code>number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiTarget.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiTarget.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiTarget.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiTarget.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiTarget.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiTarget.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiTarget.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiTarget.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiTarget.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiTarget.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiTarget.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiTarget.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `balancerIdInput`<sup>Optional</sup> <a name="balancerIdInput" id="@cdktf/provider-spotinst.MultaiTarget.property.balancerIdInput"></a>

```typescript
public readonly balancerIdInput: string;
```

- *Type:* string

---

##### `hostInput`<sup>Optional</sup> <a name="hostInput" id="@cdktf/provider-spotinst.MultaiTarget.property.hostInput"></a>

```typescript
public readonly hostInput: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.MultaiTarget.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `portInput`<sup>Optional</sup> <a name="portInput" id="@cdktf/provider-spotinst.MultaiTarget.property.portInput"></a>

```typescript
public readonly portInput: number;
```

- *Type:* number

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MultaiTarget.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MultaiTargetTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiTargetTags">MultaiTargetTags</a>[]

---

##### `targetSetIdInput`<sup>Optional</sup> <a name="targetSetIdInput" id="@cdktf/provider-spotinst.MultaiTarget.property.targetSetIdInput"></a>

```typescript
public readonly targetSetIdInput: string;
```

- *Type:* string

---

##### `weightInput`<sup>Optional</sup> <a name="weightInput" id="@cdktf/provider-spotinst.MultaiTarget.property.weightInput"></a>

```typescript
public readonly weightInput: number;
```

- *Type:* number

---

##### `balancerId`<sup>Required</sup> <a name="balancerId" id="@cdktf/provider-spotinst.MultaiTarget.property.balancerId"></a>

```typescript
public readonly balancerId: string;
```

- *Type:* string

---

##### `host`<sup>Required</sup> <a name="host" id="@cdktf/provider-spotinst.MultaiTarget.property.host"></a>

```typescript
public readonly host: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.MultaiTarget.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `port`<sup>Required</sup> <a name="port" id="@cdktf/provider-spotinst.MultaiTarget.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MultaiTarget.property.tags"></a>

```typescript
public readonly tags: IResolvable | MultaiTargetTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiTargetTags">MultaiTargetTags</a>[]

---

##### `targetSetId`<sup>Required</sup> <a name="targetSetId" id="@cdktf/provider-spotinst.MultaiTarget.property.targetSetId"></a>

```typescript
public readonly targetSetId: string;
```

- *Type:* string

---

##### `weight`<sup>Required</sup> <a name="weight" id="@cdktf/provider-spotinst.MultaiTarget.property.weight"></a>

```typescript
public readonly weight: number;
```

- *Type:* number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTarget.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiTarget.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### MultaiTargetSet <a name="MultaiTargetSet" id="@cdktf/provider-spotinst.MultaiTargetSet"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target_set spotinst_multai_target_set}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.MultaiTargetSet.Initializer"></a>

```typescript
import { MultaiTargetSet } from '@cdktf/provider-spotinst'

new MultaiTargetSet(scope: Construct, id: string, config: MultaiTargetSetConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiTargetSetConfig">MultaiTargetSetConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.MultaiTargetSet.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiTargetSetConfig">MultaiTargetSetConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.putHealthCheck">putHealthCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.resetPort">resetPort</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.resetTags">resetTags</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.MultaiTargetSet.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.MultaiTargetSet.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.MultaiTargetSet.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiTargetSet.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.MultaiTargetSet.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.MultaiTargetSet.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.MultaiTargetSet.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.MultaiTargetSet.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.MultaiTargetSet.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.MultaiTargetSet.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putHealthCheck` <a name="putHealthCheck" id="@cdktf/provider-spotinst.MultaiTargetSet.putHealthCheck"></a>

```typescript
public putHealthCheck(value: MultaiTargetSetHealthCheck): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.MultaiTargetSet.putHealthCheck.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiTargetSetHealthCheck">MultaiTargetSetHealthCheck</a>

---

##### `resetName` <a name="resetName" id="@cdktf/provider-spotinst.MultaiTargetSet.resetName"></a>

```typescript
public resetName(): void
```

##### `resetPort` <a name="resetPort" id="@cdktf/provider-spotinst.MultaiTargetSet.resetPort"></a>

```typescript
public resetPort(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.MultaiTargetSet.resetTags"></a>

```typescript
public resetTags(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.MultaiTargetSet.isConstruct"></a>

```typescript
import { MultaiTargetSet } from '@cdktf/provider-spotinst'

MultaiTargetSet.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.MultaiTargetSet.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.healthCheck">healthCheck</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiTargetSetHealthCheckOutputReference">MultaiTargetSetHealthCheckOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.balancerIdInput">balancerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.deploymentIdInput">deploymentIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.healthCheckInput">healthCheckInput</a></code> | <code><a href="#@cdktf/provider-spotinst.MultaiTargetSetHealthCheck">MultaiTargetSetHealthCheck</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.portInput">portInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.protocolInput">protocolInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiTargetSetTags">MultaiTargetSetTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.weightInput">weightInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.balancerId">balancerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.deploymentId">deploymentId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.port">port</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.protocol">protocol</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.MultaiTargetSetTags">MultaiTargetSetTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.weight">weight</a></code> | <code>number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.MultaiTargetSet.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.MultaiTargetSet.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.MultaiTargetSet.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.MultaiTargetSet.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.MultaiTargetSet.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.MultaiTargetSet.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.MultaiTargetSet.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.MultaiTargetSet.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.MultaiTargetSet.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.MultaiTargetSet.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.MultaiTargetSet.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `healthCheck`<sup>Required</sup> <a name="healthCheck" id="@cdktf/provider-spotinst.MultaiTargetSet.property.healthCheck"></a>

```typescript
public readonly healthCheck: MultaiTargetSetHealthCheckOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiTargetSetHealthCheckOutputReference">MultaiTargetSetHealthCheckOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.MultaiTargetSet.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `balancerIdInput`<sup>Optional</sup> <a name="balancerIdInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.balancerIdInput"></a>

```typescript
public readonly balancerIdInput: string;
```

- *Type:* string

---

##### `deploymentIdInput`<sup>Optional</sup> <a name="deploymentIdInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.deploymentIdInput"></a>

```typescript
public readonly deploymentIdInput: string;
```

- *Type:* string

---

##### `healthCheckInput`<sup>Optional</sup> <a name="healthCheckInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.healthCheckInput"></a>

```typescript
public readonly healthCheckInput: MultaiTargetSetHealthCheck;
```

- *Type:* <a href="#@cdktf/provider-spotinst.MultaiTargetSetHealthCheck">MultaiTargetSetHealthCheck</a>

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `portInput`<sup>Optional</sup> <a name="portInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.portInput"></a>

```typescript
public readonly portInput: number;
```

- *Type:* number

---

##### `protocolInput`<sup>Optional</sup> <a name="protocolInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.protocolInput"></a>

```typescript
public readonly protocolInput: string;
```

- *Type:* string

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | MultaiTargetSetTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiTargetSetTags">MultaiTargetSetTags</a>[]

---

##### `weightInput`<sup>Optional</sup> <a name="weightInput" id="@cdktf/provider-spotinst.MultaiTargetSet.property.weightInput"></a>

```typescript
public readonly weightInput: number;
```

- *Type:* number

---

##### `balancerId`<sup>Required</sup> <a name="balancerId" id="@cdktf/provider-spotinst.MultaiTargetSet.property.balancerId"></a>

```typescript
public readonly balancerId: string;
```

- *Type:* string

---

##### `deploymentId`<sup>Required</sup> <a name="deploymentId" id="@cdktf/provider-spotinst.MultaiTargetSet.property.deploymentId"></a>

```typescript
public readonly deploymentId: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.MultaiTargetSet.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `port`<sup>Required</sup> <a name="port" id="@cdktf/provider-spotinst.MultaiTargetSet.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

##### `protocol`<sup>Required</sup> <a name="protocol" id="@cdktf/provider-spotinst.MultaiTargetSet.property.protocol"></a>

```typescript
public readonly protocol: string;
```

- *Type:* string

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.MultaiTargetSet.property.tags"></a>

```typescript
public readonly tags: IResolvable | MultaiTargetSetTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.MultaiTargetSetTags">MultaiTargetSetTags</a>[]

---

##### `weight`<sup>Required</sup> <a name="weight" id="@cdktf/provider-spotinst.MultaiTargetSet.property.weight"></a>

```typescript
public readonly weight: number;
```

- *Type:* number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.MultaiTargetSet.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.MultaiTargetSet.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanAks <a name="OceanAks" id="@cdktf/provider-spotinst.OceanAks"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks spotinst_ocean_aks}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanAks.Initializer"></a>

```typescript
import { OceanAks } from '@cdktf/provider-spotinst'

new OceanAks(scope: Construct, id: string, config: OceanAksConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksConfig">OceanAksConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanAks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAks.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanAks.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksConfig">OceanAksConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.putAutoscaler">putAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.putHealth">putHealth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.putNetwork">putNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.putOsDisk">putOsDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetAutoscaler">resetAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetControllerClusterId">resetControllerClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetCustomData">resetCustomData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetExtension">resetExtension</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetHealth">resetHealth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetImage">resetImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetLoadBalancer">resetLoadBalancer</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetManagedServiceIdentity">resetManagedServiceIdentity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetNetwork">resetNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetOsDisk">resetOsDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetResourceGroupName">resetResourceGroupName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetStrategy">resetStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetTag">resetTag</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetUserName">resetUserName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.resetVmSizes">resetVmSizes</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanAks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanAks.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanAks.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAks.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanAks.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanAks.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanAks.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanAks.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanAks.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanAks.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanAks.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanAks.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanAks.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanAks.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanAks.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanAks.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAks.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putAutoscaler` <a name="putAutoscaler" id="@cdktf/provider-spotinst.OceanAks.putAutoscaler"></a>

```typescript
public putAutoscaler(value: OceanAksAutoscaler): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAks.putAutoscaler.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksAutoscaler">OceanAksAutoscaler</a>

---

##### `putHealth` <a name="putHealth" id="@cdktf/provider-spotinst.OceanAks.putHealth"></a>

```typescript
public putHealth(value: OceanAksHealth): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAks.putHealth.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksHealth">OceanAksHealth</a>

---

##### `putNetwork` <a name="putNetwork" id="@cdktf/provider-spotinst.OceanAks.putNetwork"></a>

```typescript
public putNetwork(value: OceanAksNetwork): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAks.putNetwork.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksNetwork">OceanAksNetwork</a>

---

##### `putOsDisk` <a name="putOsDisk" id="@cdktf/provider-spotinst.OceanAks.putOsDisk"></a>

```typescript
public putOsDisk(value: OceanAksOsDisk): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAks.putOsDisk.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksOsDisk">OceanAksOsDisk</a>

---

##### `resetAutoscaler` <a name="resetAutoscaler" id="@cdktf/provider-spotinst.OceanAks.resetAutoscaler"></a>

```typescript
public resetAutoscaler(): void
```

##### `resetControllerClusterId` <a name="resetControllerClusterId" id="@cdktf/provider-spotinst.OceanAks.resetControllerClusterId"></a>

```typescript
public resetControllerClusterId(): void
```

##### `resetCustomData` <a name="resetCustomData" id="@cdktf/provider-spotinst.OceanAks.resetCustomData"></a>

```typescript
public resetCustomData(): void
```

##### `resetExtension` <a name="resetExtension" id="@cdktf/provider-spotinst.OceanAks.resetExtension"></a>

```typescript
public resetExtension(): void
```

##### `resetHealth` <a name="resetHealth" id="@cdktf/provider-spotinst.OceanAks.resetHealth"></a>

```typescript
public resetHealth(): void
```

##### `resetImage` <a name="resetImage" id="@cdktf/provider-spotinst.OceanAks.resetImage"></a>

```typescript
public resetImage(): void
```

##### `resetLoadBalancer` <a name="resetLoadBalancer" id="@cdktf/provider-spotinst.OceanAks.resetLoadBalancer"></a>

```typescript
public resetLoadBalancer(): void
```

##### `resetManagedServiceIdentity` <a name="resetManagedServiceIdentity" id="@cdktf/provider-spotinst.OceanAks.resetManagedServiceIdentity"></a>

```typescript
public resetManagedServiceIdentity(): void
```

##### `resetNetwork` <a name="resetNetwork" id="@cdktf/provider-spotinst.OceanAks.resetNetwork"></a>

```typescript
public resetNetwork(): void
```

##### `resetOsDisk` <a name="resetOsDisk" id="@cdktf/provider-spotinst.OceanAks.resetOsDisk"></a>

```typescript
public resetOsDisk(): void
```

##### `resetResourceGroupName` <a name="resetResourceGroupName" id="@cdktf/provider-spotinst.OceanAks.resetResourceGroupName"></a>

```typescript
public resetResourceGroupName(): void
```

##### `resetStrategy` <a name="resetStrategy" id="@cdktf/provider-spotinst.OceanAks.resetStrategy"></a>

```typescript
public resetStrategy(): void
```

##### `resetTag` <a name="resetTag" id="@cdktf/provider-spotinst.OceanAks.resetTag"></a>

```typescript
public resetTag(): void
```

##### `resetUserName` <a name="resetUserName" id="@cdktf/provider-spotinst.OceanAks.resetUserName"></a>

```typescript
public resetUserName(): void
```

##### `resetVmSizes` <a name="resetVmSizes" id="@cdktf/provider-spotinst.OceanAks.resetVmSizes"></a>

```typescript
public resetVmSizes(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanAks.isConstruct"></a>

```typescript
import { OceanAks } from '@cdktf/provider-spotinst'

OceanAks.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanAks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.autoscaler">autoscaler</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksAutoscalerOutputReference">OceanAksAutoscalerOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.health">health</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksHealthOutputReference">OceanAksHealthOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.network">network</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksNetworkOutputReference">OceanAksNetworkOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.osDisk">osDisk</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksOsDiskOutputReference">OceanAksOsDiskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.acdIdentifierInput">acdIdentifierInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.aksNameInput">aksNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.aksResourceGroupNameInput">aksResourceGroupNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.autoscalerInput">autoscalerInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksAutoscaler">OceanAksAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.controllerClusterIdInput">controllerClusterIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.customDataInput">customDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.extensionInput">extensionInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksExtension">OceanAksExtension</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.healthInput">healthInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksHealth">OceanAksHealth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.imageInput">imageInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksImage">OceanAksImage</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.loadBalancerInput">loadBalancerInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksLoadBalancer">OceanAksLoadBalancer</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.managedServiceIdentityInput">managedServiceIdentityInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksManagedServiceIdentity">OceanAksManagedServiceIdentity</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.networkInput">networkInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksNetwork">OceanAksNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.osDiskInput">osDiskInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksOsDisk">OceanAksOsDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.resourceGroupNameInput">resourceGroupNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.sshPublicKeyInput">sshPublicKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.strategyInput">strategyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksStrategy">OceanAksStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.tagInput">tagInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksTag">OceanAksTag</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.userNameInput">userNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.vmSizesInput">vmSizesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVmSizes">OceanAksVmSizes</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.acdIdentifier">acdIdentifier</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.aksName">aksName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.aksResourceGroupName">aksResourceGroupName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.controllerClusterId">controllerClusterId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.customData">customData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.extension">extension</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksExtension">OceanAksExtension</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.image">image</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksImage">OceanAksImage</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.loadBalancer">loadBalancer</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksLoadBalancer">OceanAksLoadBalancer</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.managedServiceIdentity">managedServiceIdentity</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksManagedServiceIdentity">OceanAksManagedServiceIdentity</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.resourceGroupName">resourceGroupName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.sshPublicKey">sshPublicKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.strategy">strategy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksStrategy">OceanAksStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.tag">tag</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksTag">OceanAksTag</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.userName">userName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.vmSizes">vmSizes</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVmSizes">OceanAksVmSizes</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanAks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanAks.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanAks.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanAks.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanAks.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanAks.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanAks.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanAks.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanAks.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanAks.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanAks.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `autoscaler`<sup>Required</sup> <a name="autoscaler" id="@cdktf/provider-spotinst.OceanAks.property.autoscaler"></a>

```typescript
public readonly autoscaler: OceanAksAutoscalerOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksAutoscalerOutputReference">OceanAksAutoscalerOutputReference</a>

---

##### `health`<sup>Required</sup> <a name="health" id="@cdktf/provider-spotinst.OceanAks.property.health"></a>

```typescript
public readonly health: OceanAksHealthOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksHealthOutputReference">OceanAksHealthOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAks.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `network`<sup>Required</sup> <a name="network" id="@cdktf/provider-spotinst.OceanAks.property.network"></a>

```typescript
public readonly network: OceanAksNetworkOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksNetworkOutputReference">OceanAksNetworkOutputReference</a>

---

##### `osDisk`<sup>Required</sup> <a name="osDisk" id="@cdktf/provider-spotinst.OceanAks.property.osDisk"></a>

```typescript
public readonly osDisk: OceanAksOsDiskOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksOsDiskOutputReference">OceanAksOsDiskOutputReference</a>

---

##### `acdIdentifierInput`<sup>Optional</sup> <a name="acdIdentifierInput" id="@cdktf/provider-spotinst.OceanAks.property.acdIdentifierInput"></a>

```typescript
public readonly acdIdentifierInput: string;
```

- *Type:* string

---

##### `aksNameInput`<sup>Optional</sup> <a name="aksNameInput" id="@cdktf/provider-spotinst.OceanAks.property.aksNameInput"></a>

```typescript
public readonly aksNameInput: string;
```

- *Type:* string

---

##### `aksResourceGroupNameInput`<sup>Optional</sup> <a name="aksResourceGroupNameInput" id="@cdktf/provider-spotinst.OceanAks.property.aksResourceGroupNameInput"></a>

```typescript
public readonly aksResourceGroupNameInput: string;
```

- *Type:* string

---

##### `autoscalerInput`<sup>Optional</sup> <a name="autoscalerInput" id="@cdktf/provider-spotinst.OceanAks.property.autoscalerInput"></a>

```typescript
public readonly autoscalerInput: OceanAksAutoscaler;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksAutoscaler">OceanAksAutoscaler</a>

---

##### `controllerClusterIdInput`<sup>Optional</sup> <a name="controllerClusterIdInput" id="@cdktf/provider-spotinst.OceanAks.property.controllerClusterIdInput"></a>

```typescript
public readonly controllerClusterIdInput: string;
```

- *Type:* string

---

##### `customDataInput`<sup>Optional</sup> <a name="customDataInput" id="@cdktf/provider-spotinst.OceanAks.property.customDataInput"></a>

```typescript
public readonly customDataInput: string;
```

- *Type:* string

---

##### `extensionInput`<sup>Optional</sup> <a name="extensionInput" id="@cdktf/provider-spotinst.OceanAks.property.extensionInput"></a>

```typescript
public readonly extensionInput: IResolvable | OceanAksExtension[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksExtension">OceanAksExtension</a>[]

---

##### `healthInput`<sup>Optional</sup> <a name="healthInput" id="@cdktf/provider-spotinst.OceanAks.property.healthInput"></a>

```typescript
public readonly healthInput: OceanAksHealth;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksHealth">OceanAksHealth</a>

---

##### `imageInput`<sup>Optional</sup> <a name="imageInput" id="@cdktf/provider-spotinst.OceanAks.property.imageInput"></a>

```typescript
public readonly imageInput: IResolvable | OceanAksImage[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksImage">OceanAksImage</a>[]

---

##### `loadBalancerInput`<sup>Optional</sup> <a name="loadBalancerInput" id="@cdktf/provider-spotinst.OceanAks.property.loadBalancerInput"></a>

```typescript
public readonly loadBalancerInput: IResolvable | OceanAksLoadBalancer[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksLoadBalancer">OceanAksLoadBalancer</a>[]

---

##### `managedServiceIdentityInput`<sup>Optional</sup> <a name="managedServiceIdentityInput" id="@cdktf/provider-spotinst.OceanAks.property.managedServiceIdentityInput"></a>

```typescript
public readonly managedServiceIdentityInput: IResolvable | OceanAksManagedServiceIdentity[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksManagedServiceIdentity">OceanAksManagedServiceIdentity</a>[]

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanAks.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `networkInput`<sup>Optional</sup> <a name="networkInput" id="@cdktf/provider-spotinst.OceanAks.property.networkInput"></a>

```typescript
public readonly networkInput: OceanAksNetwork;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksNetwork">OceanAksNetwork</a>

---

##### `osDiskInput`<sup>Optional</sup> <a name="osDiskInput" id="@cdktf/provider-spotinst.OceanAks.property.osDiskInput"></a>

```typescript
public readonly osDiskInput: OceanAksOsDisk;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksOsDisk">OceanAksOsDisk</a>

---

##### `resourceGroupNameInput`<sup>Optional</sup> <a name="resourceGroupNameInput" id="@cdktf/provider-spotinst.OceanAks.property.resourceGroupNameInput"></a>

```typescript
public readonly resourceGroupNameInput: string;
```

- *Type:* string

---

##### `sshPublicKeyInput`<sup>Optional</sup> <a name="sshPublicKeyInput" id="@cdktf/provider-spotinst.OceanAks.property.sshPublicKeyInput"></a>

```typescript
public readonly sshPublicKeyInput: string;
```

- *Type:* string

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.OceanAks.property.strategyInput"></a>

```typescript
public readonly strategyInput: IResolvable | OceanAksStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksStrategy">OceanAksStrategy</a>[]

---

##### `tagInput`<sup>Optional</sup> <a name="tagInput" id="@cdktf/provider-spotinst.OceanAks.property.tagInput"></a>

```typescript
public readonly tagInput: IResolvable | OceanAksTag[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksTag">OceanAksTag</a>[]

---

##### `userNameInput`<sup>Optional</sup> <a name="userNameInput" id="@cdktf/provider-spotinst.OceanAks.property.userNameInput"></a>

```typescript
public readonly userNameInput: string;
```

- *Type:* string

---

##### `vmSizesInput`<sup>Optional</sup> <a name="vmSizesInput" id="@cdktf/provider-spotinst.OceanAks.property.vmSizesInput"></a>

```typescript
public readonly vmSizesInput: IResolvable | OceanAksVmSizes[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVmSizes">OceanAksVmSizes</a>[]

---

##### `acdIdentifier`<sup>Required</sup> <a name="acdIdentifier" id="@cdktf/provider-spotinst.OceanAks.property.acdIdentifier"></a>

```typescript
public readonly acdIdentifier: string;
```

- *Type:* string

---

##### `aksName`<sup>Required</sup> <a name="aksName" id="@cdktf/provider-spotinst.OceanAks.property.aksName"></a>

```typescript
public readonly aksName: string;
```

- *Type:* string

---

##### `aksResourceGroupName`<sup>Required</sup> <a name="aksResourceGroupName" id="@cdktf/provider-spotinst.OceanAks.property.aksResourceGroupName"></a>

```typescript
public readonly aksResourceGroupName: string;
```

- *Type:* string

---

##### `controllerClusterId`<sup>Required</sup> <a name="controllerClusterId" id="@cdktf/provider-spotinst.OceanAks.property.controllerClusterId"></a>

```typescript
public readonly controllerClusterId: string;
```

- *Type:* string

---

##### `customData`<sup>Required</sup> <a name="customData" id="@cdktf/provider-spotinst.OceanAks.property.customData"></a>

```typescript
public readonly customData: string;
```

- *Type:* string

---

##### `extension`<sup>Required</sup> <a name="extension" id="@cdktf/provider-spotinst.OceanAks.property.extension"></a>

```typescript
public readonly extension: IResolvable | OceanAksExtension[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksExtension">OceanAksExtension</a>[]

---

##### `image`<sup>Required</sup> <a name="image" id="@cdktf/provider-spotinst.OceanAks.property.image"></a>

```typescript
public readonly image: IResolvable | OceanAksImage[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksImage">OceanAksImage</a>[]

---

##### `loadBalancer`<sup>Required</sup> <a name="loadBalancer" id="@cdktf/provider-spotinst.OceanAks.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: IResolvable | OceanAksLoadBalancer[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksLoadBalancer">OceanAksLoadBalancer</a>[]

---

##### `managedServiceIdentity`<sup>Required</sup> <a name="managedServiceIdentity" id="@cdktf/provider-spotinst.OceanAks.property.managedServiceIdentity"></a>

```typescript
public readonly managedServiceIdentity: IResolvable | OceanAksManagedServiceIdentity[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksManagedServiceIdentity">OceanAksManagedServiceIdentity</a>[]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanAks.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `resourceGroupName`<sup>Required</sup> <a name="resourceGroupName" id="@cdktf/provider-spotinst.OceanAks.property.resourceGroupName"></a>

```typescript
public readonly resourceGroupName: string;
```

- *Type:* string

---

##### `sshPublicKey`<sup>Required</sup> <a name="sshPublicKey" id="@cdktf/provider-spotinst.OceanAks.property.sshPublicKey"></a>

```typescript
public readonly sshPublicKey: string;
```

- *Type:* string

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.OceanAks.property.strategy"></a>

```typescript
public readonly strategy: IResolvable | OceanAksStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksStrategy">OceanAksStrategy</a>[]

---

##### `tag`<sup>Required</sup> <a name="tag" id="@cdktf/provider-spotinst.OceanAks.property.tag"></a>

```typescript
public readonly tag: IResolvable | OceanAksTag[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksTag">OceanAksTag</a>[]

---

##### `userName`<sup>Required</sup> <a name="userName" id="@cdktf/provider-spotinst.OceanAks.property.userName"></a>

```typescript
public readonly userName: string;
```

- *Type:* string

---

##### `vmSizes`<sup>Required</sup> <a name="vmSizes" id="@cdktf/provider-spotinst.OceanAks.property.vmSizes"></a>

```typescript
public readonly vmSizes: IResolvable | OceanAksVmSizes[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVmSizes">OceanAksVmSizes</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAks.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanAks.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanAksVirtualNodeGroup <a name="OceanAksVirtualNodeGroup" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group spotinst_ocean_aks_virtual_node_group}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer"></a>

```typescript
import { OceanAksVirtualNodeGroup } from '@cdktf/provider-spotinst'

new OceanAksVirtualNodeGroup(scope: Construct, id: string, config: OceanAksVirtualNodeGroupConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupConfig">OceanAksVirtualNodeGroupConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupConfig">OceanAksVirtualNodeGroupConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetAutoscale">resetAutoscale</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetLabel">resetLabel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetLaunchSpecification">resetLaunchSpecification</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetResourceLimits">resetResourceLimits</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetTaint">resetTaint</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetAutoscale` <a name="resetAutoscale" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetAutoscale"></a>

```typescript
public resetAutoscale(): void
```

##### `resetLabel` <a name="resetLabel" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetLabel"></a>

```typescript
public resetLabel(): void
```

##### `resetLaunchSpecification` <a name="resetLaunchSpecification" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetLaunchSpecification"></a>

```typescript
public resetLaunchSpecification(): void
```

##### `resetResourceLimits` <a name="resetResourceLimits" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetResourceLimits"></a>

```typescript
public resetResourceLimits(): void
```

##### `resetTaint` <a name="resetTaint" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.resetTaint"></a>

```typescript
public resetTaint(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.isConstruct"></a>

```typescript
import { OceanAksVirtualNodeGroup } from '@cdktf/provider-spotinst'

OceanAksVirtualNodeGroup.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.autoscaleInput">autoscaleInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupAutoscale">OceanAksVirtualNodeGroupAutoscale</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.labelInput">labelInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLabel">OceanAksVirtualNodeGroupLabel</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.launchSpecificationInput">launchSpecificationInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLaunchSpecification">OceanAksVirtualNodeGroupLaunchSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.oceanIdInput">oceanIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.resourceLimitsInput">resourceLimitsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupResourceLimits">OceanAksVirtualNodeGroupResourceLimits</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.taintInput">taintInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupTaint">OceanAksVirtualNodeGroupTaint</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.autoscale">autoscale</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupAutoscale">OceanAksVirtualNodeGroupAutoscale</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.label">label</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLabel">OceanAksVirtualNodeGroupLabel</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.launchSpecification">launchSpecification</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLaunchSpecification">OceanAksVirtualNodeGroupLaunchSpecification</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.oceanId">oceanId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.resourceLimits">resourceLimits</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupResourceLimits">OceanAksVirtualNodeGroupResourceLimits</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.taint">taint</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupTaint">OceanAksVirtualNodeGroupTaint</a>[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `autoscaleInput`<sup>Optional</sup> <a name="autoscaleInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.autoscaleInput"></a>

```typescript
public readonly autoscaleInput: IResolvable | OceanAksVirtualNodeGroupAutoscale[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupAutoscale">OceanAksVirtualNodeGroupAutoscale</a>[]

---

##### `labelInput`<sup>Optional</sup> <a name="labelInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.labelInput"></a>

```typescript
public readonly labelInput: IResolvable | OceanAksVirtualNodeGroupLabel[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLabel">OceanAksVirtualNodeGroupLabel</a>[]

---

##### `launchSpecificationInput`<sup>Optional</sup> <a name="launchSpecificationInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.launchSpecificationInput"></a>

```typescript
public readonly launchSpecificationInput: IResolvable | OceanAksVirtualNodeGroupLaunchSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLaunchSpecification">OceanAksVirtualNodeGroupLaunchSpecification</a>[]

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `oceanIdInput`<sup>Optional</sup> <a name="oceanIdInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.oceanIdInput"></a>

```typescript
public readonly oceanIdInput: string;
```

- *Type:* string

---

##### `resourceLimitsInput`<sup>Optional</sup> <a name="resourceLimitsInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.resourceLimitsInput"></a>

```typescript
public readonly resourceLimitsInput: IResolvable | OceanAksVirtualNodeGroupResourceLimits[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupResourceLimits">OceanAksVirtualNodeGroupResourceLimits</a>[]

---

##### `taintInput`<sup>Optional</sup> <a name="taintInput" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.taintInput"></a>

```typescript
public readonly taintInput: IResolvable | OceanAksVirtualNodeGroupTaint[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupTaint">OceanAksVirtualNodeGroupTaint</a>[]

---

##### `autoscale`<sup>Required</sup> <a name="autoscale" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.autoscale"></a>

```typescript
public readonly autoscale: IResolvable | OceanAksVirtualNodeGroupAutoscale[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupAutoscale">OceanAksVirtualNodeGroupAutoscale</a>[]

---

##### `label`<sup>Required</sup> <a name="label" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.label"></a>

```typescript
public readonly label: IResolvable | OceanAksVirtualNodeGroupLabel[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLabel">OceanAksVirtualNodeGroupLabel</a>[]

---

##### `launchSpecification`<sup>Required</sup> <a name="launchSpecification" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.launchSpecification"></a>

```typescript
public readonly launchSpecification: IResolvable | OceanAksVirtualNodeGroupLaunchSpecification[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupLaunchSpecification">OceanAksVirtualNodeGroupLaunchSpecification</a>[]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `oceanId`<sup>Required</sup> <a name="oceanId" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.oceanId"></a>

```typescript
public readonly oceanId: string;
```

- *Type:* string

---

##### `resourceLimits`<sup>Required</sup> <a name="resourceLimits" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.resourceLimits"></a>

```typescript
public readonly resourceLimits: IResolvable | OceanAksVirtualNodeGroupResourceLimits[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupResourceLimits">OceanAksVirtualNodeGroupResourceLimits</a>[]

---

##### `taint`<sup>Required</sup> <a name="taint" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.taint"></a>

```typescript
public readonly taint: IResolvable | OceanAksVirtualNodeGroupTaint[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroupTaint">OceanAksVirtualNodeGroupTaint</a>[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanAksVirtualNodeGroup.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanAws <a name="OceanAws" id="@cdktf/provider-spotinst.OceanAws"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws spotinst_ocean_aws}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanAws.Initializer"></a>

```typescript
import { OceanAws } from '@cdktf/provider-spotinst'

new OceanAws(scope: Construct, id: string, config: OceanAwsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsConfig">OceanAwsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanAws.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAws.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanAws.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsConfig">OceanAwsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.putAutoscaler">putAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.putInstanceMetadataOptions">putInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.putLogging">putLogging</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.putUpdatePolicy">putUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetAssociatePublicIpAddress">resetAssociatePublicIpAddress</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetAutoscaler">resetAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetBlacklist">resetBlacklist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetControllerId">resetControllerId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetDesiredCapacity">resetDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetEbsOptimized">resetEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetFallbackToOndemand">resetFallbackToOndemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetGracePeriod">resetGracePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetImageId">resetImageId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetInstanceMetadataOptions">resetInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetKeyName">resetKeyName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetLoadBalancers">resetLoadBalancers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetLogging">resetLogging</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetMonitoring">resetMonitoring</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetRegion">resetRegion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetRootVolumeSize">resetRootVolumeSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetSpotPercentage">resetSpotPercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetUpdatePolicy">resetUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetUseAsTemplateOnly">resetUseAsTemplateOnly</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetUserData">resetUserData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetUtilizeCommitments">resetUtilizeCommitments</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetUtilizeReservedInstances">resetUtilizeReservedInstances</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.resetWhitelist">resetWhitelist</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanAws.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanAws.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanAws.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAws.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanAws.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanAws.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanAws.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanAws.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanAws.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanAws.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanAws.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanAws.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanAws.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanAws.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanAws.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanAws.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAws.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putAutoscaler` <a name="putAutoscaler" id="@cdktf/provider-spotinst.OceanAws.putAutoscaler"></a>

```typescript
public putAutoscaler(value: OceanAwsAutoscaler): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAws.putAutoscaler.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsAutoscaler">OceanAwsAutoscaler</a>

---

##### `putInstanceMetadataOptions` <a name="putInstanceMetadataOptions" id="@cdktf/provider-spotinst.OceanAws.putInstanceMetadataOptions"></a>

```typescript
public putInstanceMetadataOptions(value: OceanAwsInstanceMetadataOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAws.putInstanceMetadataOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsInstanceMetadataOptions">OceanAwsInstanceMetadataOptions</a>

---

##### `putLogging` <a name="putLogging" id="@cdktf/provider-spotinst.OceanAws.putLogging"></a>

```typescript
public putLogging(value: OceanAwsLogging): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAws.putLogging.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLogging">OceanAwsLogging</a>

---

##### `putUpdatePolicy` <a name="putUpdatePolicy" id="@cdktf/provider-spotinst.OceanAws.putUpdatePolicy"></a>

```typescript
public putUpdatePolicy(value: OceanAwsUpdatePolicy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAws.putUpdatePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsUpdatePolicy">OceanAwsUpdatePolicy</a>

---

##### `resetAssociatePublicIpAddress` <a name="resetAssociatePublicIpAddress" id="@cdktf/provider-spotinst.OceanAws.resetAssociatePublicIpAddress"></a>

```typescript
public resetAssociatePublicIpAddress(): void
```

##### `resetAutoscaler` <a name="resetAutoscaler" id="@cdktf/provider-spotinst.OceanAws.resetAutoscaler"></a>

```typescript
public resetAutoscaler(): void
```

##### `resetBlacklist` <a name="resetBlacklist" id="@cdktf/provider-spotinst.OceanAws.resetBlacklist"></a>

```typescript
public resetBlacklist(): void
```

##### `resetControllerId` <a name="resetControllerId" id="@cdktf/provider-spotinst.OceanAws.resetControllerId"></a>

```typescript
public resetControllerId(): void
```

##### `resetDesiredCapacity` <a name="resetDesiredCapacity" id="@cdktf/provider-spotinst.OceanAws.resetDesiredCapacity"></a>

```typescript
public resetDesiredCapacity(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.OceanAws.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetEbsOptimized` <a name="resetEbsOptimized" id="@cdktf/provider-spotinst.OceanAws.resetEbsOptimized"></a>

```typescript
public resetEbsOptimized(): void
```

##### `resetFallbackToOndemand` <a name="resetFallbackToOndemand" id="@cdktf/provider-spotinst.OceanAws.resetFallbackToOndemand"></a>

```typescript
public resetFallbackToOndemand(): void
```

##### `resetGracePeriod` <a name="resetGracePeriod" id="@cdktf/provider-spotinst.OceanAws.resetGracePeriod"></a>

```typescript
public resetGracePeriod(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.OceanAws.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetImageId` <a name="resetImageId" id="@cdktf/provider-spotinst.OceanAws.resetImageId"></a>

```typescript
public resetImageId(): void
```

##### `resetInstanceMetadataOptions` <a name="resetInstanceMetadataOptions" id="@cdktf/provider-spotinst.OceanAws.resetInstanceMetadataOptions"></a>

```typescript
public resetInstanceMetadataOptions(): void
```

##### `resetKeyName` <a name="resetKeyName" id="@cdktf/provider-spotinst.OceanAws.resetKeyName"></a>

```typescript
public resetKeyName(): void
```

##### `resetLoadBalancers` <a name="resetLoadBalancers" id="@cdktf/provider-spotinst.OceanAws.resetLoadBalancers"></a>

```typescript
public resetLoadBalancers(): void
```

##### `resetLogging` <a name="resetLogging" id="@cdktf/provider-spotinst.OceanAws.resetLogging"></a>

```typescript
public resetLogging(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.OceanAws.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.OceanAws.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetMonitoring` <a name="resetMonitoring" id="@cdktf/provider-spotinst.OceanAws.resetMonitoring"></a>

```typescript
public resetMonitoring(): void
```

##### `resetName` <a name="resetName" id="@cdktf/provider-spotinst.OceanAws.resetName"></a>

```typescript
public resetName(): void
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-spotinst.OceanAws.resetRegion"></a>

```typescript
public resetRegion(): void
```

##### `resetRootVolumeSize` <a name="resetRootVolumeSize" id="@cdktf/provider-spotinst.OceanAws.resetRootVolumeSize"></a>

```typescript
public resetRootVolumeSize(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.OceanAws.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetSpotPercentage` <a name="resetSpotPercentage" id="@cdktf/provider-spotinst.OceanAws.resetSpotPercentage"></a>

```typescript
public resetSpotPercentage(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.OceanAws.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetUpdatePolicy` <a name="resetUpdatePolicy" id="@cdktf/provider-spotinst.OceanAws.resetUpdatePolicy"></a>

```typescript
public resetUpdatePolicy(): void
```

##### `resetUseAsTemplateOnly` <a name="resetUseAsTemplateOnly" id="@cdktf/provider-spotinst.OceanAws.resetUseAsTemplateOnly"></a>

```typescript
public resetUseAsTemplateOnly(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.OceanAws.resetUserData"></a>

```typescript
public resetUserData(): void
```

##### `resetUtilizeCommitments` <a name="resetUtilizeCommitments" id="@cdktf/provider-spotinst.OceanAws.resetUtilizeCommitments"></a>

```typescript
public resetUtilizeCommitments(): void
```

##### `resetUtilizeReservedInstances` <a name="resetUtilizeReservedInstances" id="@cdktf/provider-spotinst.OceanAws.resetUtilizeReservedInstances"></a>

```typescript
public resetUtilizeReservedInstances(): void
```

##### `resetWhitelist` <a name="resetWhitelist" id="@cdktf/provider-spotinst.OceanAws.resetWhitelist"></a>

```typescript
public resetWhitelist(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanAws.isConstruct"></a>

```typescript
import { OceanAws } from '@cdktf/provider-spotinst'

OceanAws.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanAws.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.autoscaler">autoscaler</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsAutoscalerOutputReference">OceanAwsAutoscalerOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.instanceMetadataOptions">instanceMetadataOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsInstanceMetadataOptionsOutputReference">OceanAwsInstanceMetadataOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.logging">logging</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLoggingOutputReference">OceanAwsLoggingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.updatePolicy">updatePolicy</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsUpdatePolicyOutputReference">OceanAwsUpdatePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.associatePublicIpAddressInput">associatePublicIpAddressInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.autoscalerInput">autoscalerInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsAutoscaler">OceanAwsAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.blacklistInput">blacklistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.controllerIdInput">controllerIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.ebsOptimizedInput">ebsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.fallbackToOndemandInput">fallbackToOndemandInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.gracePeriodInput">gracePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.instanceMetadataOptionsInput">instanceMetadataOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsInstanceMetadataOptions">OceanAwsInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.keyNameInput">keyNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.loadBalancersInput">loadBalancersInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLoadBalancers">OceanAwsLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.loggingInput">loggingInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLogging">OceanAwsLogging</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.monitoringInput">monitoringInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.rootVolumeSizeInput">rootVolumeSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsScheduledTask">OceanAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.securityGroupsInput">securityGroupsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.spotPercentageInput">spotPercentageInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.subnetIdsInput">subnetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsTags">OceanAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.updatePolicyInput">updatePolicyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsUpdatePolicy">OceanAwsUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.useAsTemplateOnlyInput">useAsTemplateOnlyInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.utilizeCommitmentsInput">utilizeCommitmentsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.utilizeReservedInstancesInput">utilizeReservedInstancesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.whitelistInput">whitelistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.associatePublicIpAddress">associatePublicIpAddress</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.blacklist">blacklist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.controllerId">controllerId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.ebsOptimized">ebsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.fallbackToOndemand">fallbackToOndemand</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.gracePeriod">gracePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.iamInstanceProfile">iamInstanceProfile</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.imageId">imageId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.keyName">keyName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.loadBalancers">loadBalancers</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLoadBalancers">OceanAwsLoadBalancers</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.monitoring">monitoring</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.rootVolumeSize">rootVolumeSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsScheduledTask">OceanAwsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.securityGroups">securityGroups</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.spotPercentage">spotPercentage</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.subnetIds">subnetIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsTags">OceanAwsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.useAsTemplateOnly">useAsTemplateOnly</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.userData">userData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.utilizeCommitments">utilizeCommitments</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.utilizeReservedInstances">utilizeReservedInstances</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.whitelist">whitelist</a></code> | <code>string[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanAws.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanAws.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanAws.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanAws.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanAws.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanAws.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanAws.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanAws.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanAws.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanAws.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanAws.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `autoscaler`<sup>Required</sup> <a name="autoscaler" id="@cdktf/provider-spotinst.OceanAws.property.autoscaler"></a>

```typescript
public readonly autoscaler: OceanAwsAutoscalerOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsAutoscalerOutputReference">OceanAwsAutoscalerOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAws.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `instanceMetadataOptions`<sup>Required</sup> <a name="instanceMetadataOptions" id="@cdktf/provider-spotinst.OceanAws.property.instanceMetadataOptions"></a>

```typescript
public readonly instanceMetadataOptions: OceanAwsInstanceMetadataOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsInstanceMetadataOptionsOutputReference">OceanAwsInstanceMetadataOptionsOutputReference</a>

---

##### `logging`<sup>Required</sup> <a name="logging" id="@cdktf/provider-spotinst.OceanAws.property.logging"></a>

```typescript
public readonly logging: OceanAwsLoggingOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLoggingOutputReference">OceanAwsLoggingOutputReference</a>

---

##### `updatePolicy`<sup>Required</sup> <a name="updatePolicy" id="@cdktf/provider-spotinst.OceanAws.property.updatePolicy"></a>

```typescript
public readonly updatePolicy: OceanAwsUpdatePolicyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsUpdatePolicyOutputReference">OceanAwsUpdatePolicyOutputReference</a>

---

##### `associatePublicIpAddressInput`<sup>Optional</sup> <a name="associatePublicIpAddressInput" id="@cdktf/provider-spotinst.OceanAws.property.associatePublicIpAddressInput"></a>

```typescript
public readonly associatePublicIpAddressInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoscalerInput`<sup>Optional</sup> <a name="autoscalerInput" id="@cdktf/provider-spotinst.OceanAws.property.autoscalerInput"></a>

```typescript
public readonly autoscalerInput: OceanAwsAutoscaler;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsAutoscaler">OceanAwsAutoscaler</a>

---

##### `blacklistInput`<sup>Optional</sup> <a name="blacklistInput" id="@cdktf/provider-spotinst.OceanAws.property.blacklistInput"></a>

```typescript
public readonly blacklistInput: string[];
```

- *Type:* string[]

---

##### `controllerIdInput`<sup>Optional</sup> <a name="controllerIdInput" id="@cdktf/provider-spotinst.OceanAws.property.controllerIdInput"></a>

```typescript
public readonly controllerIdInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.OceanAws.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.OceanAws.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `ebsOptimizedInput`<sup>Optional</sup> <a name="ebsOptimizedInput" id="@cdktf/provider-spotinst.OceanAws.property.ebsOptimizedInput"></a>

```typescript
public readonly ebsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `fallbackToOndemandInput`<sup>Optional</sup> <a name="fallbackToOndemandInput" id="@cdktf/provider-spotinst.OceanAws.property.fallbackToOndemandInput"></a>

```typescript
public readonly fallbackToOndemandInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gracePeriodInput`<sup>Optional</sup> <a name="gracePeriodInput" id="@cdktf/provider-spotinst.OceanAws.property.gracePeriodInput"></a>

```typescript
public readonly gracePeriodInput: number;
```

- *Type:* number

---

##### `iamInstanceProfileInput`<sup>Optional</sup> <a name="iamInstanceProfileInput" id="@cdktf/provider-spotinst.OceanAws.property.iamInstanceProfileInput"></a>

```typescript
public readonly iamInstanceProfileInput: string;
```

- *Type:* string

---

##### `imageIdInput`<sup>Optional</sup> <a name="imageIdInput" id="@cdktf/provider-spotinst.OceanAws.property.imageIdInput"></a>

```typescript
public readonly imageIdInput: string;
```

- *Type:* string

---

##### `instanceMetadataOptionsInput`<sup>Optional</sup> <a name="instanceMetadataOptionsInput" id="@cdktf/provider-spotinst.OceanAws.property.instanceMetadataOptionsInput"></a>

```typescript
public readonly instanceMetadataOptionsInput: OceanAwsInstanceMetadataOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsInstanceMetadataOptions">OceanAwsInstanceMetadataOptions</a>

---

##### `keyNameInput`<sup>Optional</sup> <a name="keyNameInput" id="@cdktf/provider-spotinst.OceanAws.property.keyNameInput"></a>

```typescript
public readonly keyNameInput: string;
```

- *Type:* string

---

##### `loadBalancersInput`<sup>Optional</sup> <a name="loadBalancersInput" id="@cdktf/provider-spotinst.OceanAws.property.loadBalancersInput"></a>

```typescript
public readonly loadBalancersInput: IResolvable | OceanAwsLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLoadBalancers">OceanAwsLoadBalancers</a>[]

---

##### `loggingInput`<sup>Optional</sup> <a name="loggingInput" id="@cdktf/provider-spotinst.OceanAws.property.loggingInput"></a>

```typescript
public readonly loggingInput: OceanAwsLogging;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLogging">OceanAwsLogging</a>

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.OceanAws.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.OceanAws.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `monitoringInput`<sup>Optional</sup> <a name="monitoringInput" id="@cdktf/provider-spotinst.OceanAws.property.monitoringInput"></a>

```typescript
public readonly monitoringInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanAws.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.OceanAws.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `rootVolumeSizeInput`<sup>Optional</sup> <a name="rootVolumeSizeInput" id="@cdktf/provider-spotinst.OceanAws.property.rootVolumeSizeInput"></a>

```typescript
public readonly rootVolumeSizeInput: number;
```

- *Type:* number

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.OceanAws.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | OceanAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsScheduledTask">OceanAwsScheduledTask</a>[]

---

##### `securityGroupsInput`<sup>Optional</sup> <a name="securityGroupsInput" id="@cdktf/provider-spotinst.OceanAws.property.securityGroupsInput"></a>

```typescript
public readonly securityGroupsInput: string[];
```

- *Type:* string[]

---

##### `spotPercentageInput`<sup>Optional</sup> <a name="spotPercentageInput" id="@cdktf/provider-spotinst.OceanAws.property.spotPercentageInput"></a>

```typescript
public readonly spotPercentageInput: number;
```

- *Type:* number

---

##### `subnetIdsInput`<sup>Optional</sup> <a name="subnetIdsInput" id="@cdktf/provider-spotinst.OceanAws.property.subnetIdsInput"></a>

```typescript
public readonly subnetIdsInput: string[];
```

- *Type:* string[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.OceanAws.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | OceanAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsTags">OceanAwsTags</a>[]

---

##### `updatePolicyInput`<sup>Optional</sup> <a name="updatePolicyInput" id="@cdktf/provider-spotinst.OceanAws.property.updatePolicyInput"></a>

```typescript
public readonly updatePolicyInput: OceanAwsUpdatePolicy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsUpdatePolicy">OceanAwsUpdatePolicy</a>

---

##### `useAsTemplateOnlyInput`<sup>Optional</sup> <a name="useAsTemplateOnlyInput" id="@cdktf/provider-spotinst.OceanAws.property.useAsTemplateOnlyInput"></a>

```typescript
public readonly useAsTemplateOnlyInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.OceanAws.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `utilizeCommitmentsInput`<sup>Optional</sup> <a name="utilizeCommitmentsInput" id="@cdktf/provider-spotinst.OceanAws.property.utilizeCommitmentsInput"></a>

```typescript
public readonly utilizeCommitmentsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstancesInput`<sup>Optional</sup> <a name="utilizeReservedInstancesInput" id="@cdktf/provider-spotinst.OceanAws.property.utilizeReservedInstancesInput"></a>

```typescript
public readonly utilizeReservedInstancesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whitelistInput`<sup>Optional</sup> <a name="whitelistInput" id="@cdktf/provider-spotinst.OceanAws.property.whitelistInput"></a>

```typescript
public readonly whitelistInput: string[];
```

- *Type:* string[]

---

##### `associatePublicIpAddress`<sup>Required</sup> <a name="associatePublicIpAddress" id="@cdktf/provider-spotinst.OceanAws.property.associatePublicIpAddress"></a>

```typescript
public readonly associatePublicIpAddress: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `blacklist`<sup>Required</sup> <a name="blacklist" id="@cdktf/provider-spotinst.OceanAws.property.blacklist"></a>

```typescript
public readonly blacklist: string[];
```

- *Type:* string[]

---

##### `controllerId`<sup>Required</sup> <a name="controllerId" id="@cdktf/provider-spotinst.OceanAws.property.controllerId"></a>

```typescript
public readonly controllerId: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.OceanAws.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.OceanAws.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `ebsOptimized`<sup>Required</sup> <a name="ebsOptimized" id="@cdktf/provider-spotinst.OceanAws.property.ebsOptimized"></a>

```typescript
public readonly ebsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `fallbackToOndemand`<sup>Required</sup> <a name="fallbackToOndemand" id="@cdktf/provider-spotinst.OceanAws.property.fallbackToOndemand"></a>

```typescript
public readonly fallbackToOndemand: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `gracePeriod`<sup>Required</sup> <a name="gracePeriod" id="@cdktf/provider-spotinst.OceanAws.property.gracePeriod"></a>

```typescript
public readonly gracePeriod: number;
```

- *Type:* number

---

##### `iamInstanceProfile`<sup>Required</sup> <a name="iamInstanceProfile" id="@cdktf/provider-spotinst.OceanAws.property.iamInstanceProfile"></a>

```typescript
public readonly iamInstanceProfile: string;
```

- *Type:* string

---

##### `imageId`<sup>Required</sup> <a name="imageId" id="@cdktf/provider-spotinst.OceanAws.property.imageId"></a>

```typescript
public readonly imageId: string;
```

- *Type:* string

---

##### `keyName`<sup>Required</sup> <a name="keyName" id="@cdktf/provider-spotinst.OceanAws.property.keyName"></a>

```typescript
public readonly keyName: string;
```

- *Type:* string

---

##### `loadBalancers`<sup>Required</sup> <a name="loadBalancers" id="@cdktf/provider-spotinst.OceanAws.property.loadBalancers"></a>

```typescript
public readonly loadBalancers: IResolvable | OceanAwsLoadBalancers[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLoadBalancers">OceanAwsLoadBalancers</a>[]

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.OceanAws.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.OceanAws.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `monitoring`<sup>Required</sup> <a name="monitoring" id="@cdktf/provider-spotinst.OceanAws.property.monitoring"></a>

```typescript
public readonly monitoring: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanAws.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.OceanAws.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `rootVolumeSize`<sup>Required</sup> <a name="rootVolumeSize" id="@cdktf/provider-spotinst.OceanAws.property.rootVolumeSize"></a>

```typescript
public readonly rootVolumeSize: number;
```

- *Type:* number

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.OceanAws.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | OceanAwsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsScheduledTask">OceanAwsScheduledTask</a>[]

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="@cdktf/provider-spotinst.OceanAws.property.securityGroups"></a>

```typescript
public readonly securityGroups: string[];
```

- *Type:* string[]

---

##### `spotPercentage`<sup>Required</sup> <a name="spotPercentage" id="@cdktf/provider-spotinst.OceanAws.property.spotPercentage"></a>

```typescript
public readonly spotPercentage: number;
```

- *Type:* number

---

##### `subnetIds`<sup>Required</sup> <a name="subnetIds" id="@cdktf/provider-spotinst.OceanAws.property.subnetIds"></a>

```typescript
public readonly subnetIds: string[];
```

- *Type:* string[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.OceanAws.property.tags"></a>

```typescript
public readonly tags: IResolvable | OceanAwsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsTags">OceanAwsTags</a>[]

---

##### `useAsTemplateOnly`<sup>Required</sup> <a name="useAsTemplateOnly" id="@cdktf/provider-spotinst.OceanAws.property.useAsTemplateOnly"></a>

```typescript
public readonly useAsTemplateOnly: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.OceanAws.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

##### `utilizeCommitments`<sup>Required</sup> <a name="utilizeCommitments" id="@cdktf/provider-spotinst.OceanAws.property.utilizeCommitments"></a>

```typescript
public readonly utilizeCommitments: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstances`<sup>Required</sup> <a name="utilizeReservedInstances" id="@cdktf/provider-spotinst.OceanAws.property.utilizeReservedInstances"></a>

```typescript
public readonly utilizeReservedInstances: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whitelist`<sup>Required</sup> <a name="whitelist" id="@cdktf/provider-spotinst.OceanAws.property.whitelist"></a>

```typescript
public readonly whitelist: string[];
```

- *Type:* string[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAws.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanAws.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanAwsExtendedResourceDefinition <a name="OceanAwsExtendedResourceDefinition" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_extended_resource_definition spotinst_ocean_aws_extended_resource_definition}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer"></a>

```typescript
import { OceanAwsExtendedResourceDefinition } from '@cdktf/provider-spotinst'

new OceanAwsExtendedResourceDefinition(scope: Construct, id: string, config: OceanAwsExtendedResourceDefinitionConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinitionConfig">OceanAwsExtendedResourceDefinitionConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinitionConfig">OceanAwsExtendedResourceDefinitionConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.isConstruct"></a>

```typescript
import { OceanAwsExtendedResourceDefinition } from '@cdktf/provider-spotinst'

OceanAwsExtendedResourceDefinition.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.resourceMappingInput">resourceMappingInput</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.resourceMapping">resourceMapping</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `resourceMappingInput`<sup>Optional</sup> <a name="resourceMappingInput" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.resourceMappingInput"></a>

```typescript
public readonly resourceMappingInput: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `resourceMapping`<sup>Required</sup> <a name="resourceMapping" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.resourceMapping"></a>

```typescript
public readonly resourceMapping: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanAwsExtendedResourceDefinition.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanAwsLaunchSpec <a name="OceanAwsLaunchSpec" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec spotinst_ocean_aws_launch_spec}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer"></a>

```typescript
import { OceanAwsLaunchSpec } from '@cdktf/provider-spotinst'

new OceanAwsLaunchSpec(scope: Construct, id: string, config: OceanAwsLaunchSpecConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecConfig">OceanAwsLaunchSpecConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecConfig">OceanAwsLaunchSpecConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.putCreateOptions">putCreateOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.putDeleteOptions">putDeleteOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.putSchedulingShutdownHours">putSchedulingShutdownHours</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.putUpdatePolicy">putUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAssociatePublicIpAddress">resetAssociatePublicIpAddress</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAutoscaleHeadrooms">resetAutoscaleHeadrooms</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAutoscaleHeadroomsAutomatic">resetAutoscaleHeadroomsAutomatic</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetBlockDeviceMappings">resetBlockDeviceMappings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetCreateOptions">resetCreateOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetDeleteOptions">resetDeleteOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetElasticIpPool">resetElasticIpPool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetImageId">resetImageId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetInstanceTypes">resetInstanceTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetLabels">resetLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetPreferredSpotTypes">resetPreferredSpotTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetResourceLimits">resetResourceLimits</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetRestrictScaleDown">resetRestrictScaleDown</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetRootVolumeSize">resetRootVolumeSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSchedulingShutdownHours">resetSchedulingShutdownHours</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSchedulingTask">resetSchedulingTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSecurityGroups">resetSecurityGroups</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetStrategy">resetStrategy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSubnetIds">resetSubnetIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetTaints">resetTaints</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetUpdatePolicy">resetUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetUserData">resetUserData</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putCreateOptions` <a name="putCreateOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putCreateOptions"></a>

```typescript
public putCreateOptions(value: OceanAwsLaunchSpecCreateOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putCreateOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecCreateOptions">OceanAwsLaunchSpecCreateOptions</a>

---

##### `putDeleteOptions` <a name="putDeleteOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putDeleteOptions"></a>

```typescript
public putDeleteOptions(value: OceanAwsLaunchSpecDeleteOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putDeleteOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecDeleteOptions">OceanAwsLaunchSpecDeleteOptions</a>

---

##### `putSchedulingShutdownHours` <a name="putSchedulingShutdownHours" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putSchedulingShutdownHours"></a>

```typescript
public putSchedulingShutdownHours(value: OceanAwsLaunchSpecSchedulingShutdownHours): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putSchedulingShutdownHours.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingShutdownHours">OceanAwsLaunchSpecSchedulingShutdownHours</a>

---

##### `putUpdatePolicy` <a name="putUpdatePolicy" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putUpdatePolicy"></a>

```typescript
public putUpdatePolicy(value: OceanAwsLaunchSpecUpdatePolicy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.putUpdatePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecUpdatePolicy">OceanAwsLaunchSpecUpdatePolicy</a>

---

##### `resetAssociatePublicIpAddress` <a name="resetAssociatePublicIpAddress" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAssociatePublicIpAddress"></a>

```typescript
public resetAssociatePublicIpAddress(): void
```

##### `resetAutoscaleHeadrooms` <a name="resetAutoscaleHeadrooms" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAutoscaleHeadrooms"></a>

```typescript
public resetAutoscaleHeadrooms(): void
```

##### `resetAutoscaleHeadroomsAutomatic` <a name="resetAutoscaleHeadroomsAutomatic" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetAutoscaleHeadroomsAutomatic"></a>

```typescript
public resetAutoscaleHeadroomsAutomatic(): void
```

##### `resetBlockDeviceMappings` <a name="resetBlockDeviceMappings" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetBlockDeviceMappings"></a>

```typescript
public resetBlockDeviceMappings(): void
```

##### `resetCreateOptions` <a name="resetCreateOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetCreateOptions"></a>

```typescript
public resetCreateOptions(): void
```

##### `resetDeleteOptions` <a name="resetDeleteOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetDeleteOptions"></a>

```typescript
public resetDeleteOptions(): void
```

##### `resetElasticIpPool` <a name="resetElasticIpPool" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetElasticIpPool"></a>

```typescript
public resetElasticIpPool(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetImageId` <a name="resetImageId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetImageId"></a>

```typescript
public resetImageId(): void
```

##### `resetInstanceTypes` <a name="resetInstanceTypes" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetInstanceTypes"></a>

```typescript
public resetInstanceTypes(): void
```

##### `resetLabels` <a name="resetLabels" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetLabels"></a>

```typescript
public resetLabels(): void
```

##### `resetName` <a name="resetName" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetName"></a>

```typescript
public resetName(): void
```

##### `resetPreferredSpotTypes` <a name="resetPreferredSpotTypes" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetPreferredSpotTypes"></a>

```typescript
public resetPreferredSpotTypes(): void
```

##### `resetResourceLimits` <a name="resetResourceLimits" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetResourceLimits"></a>

```typescript
public resetResourceLimits(): void
```

##### `resetRestrictScaleDown` <a name="resetRestrictScaleDown" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetRestrictScaleDown"></a>

```typescript
public resetRestrictScaleDown(): void
```

##### `resetRootVolumeSize` <a name="resetRootVolumeSize" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetRootVolumeSize"></a>

```typescript
public resetRootVolumeSize(): void
```

##### `resetSchedulingShutdownHours` <a name="resetSchedulingShutdownHours" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSchedulingShutdownHours"></a>

```typescript
public resetSchedulingShutdownHours(): void
```

##### `resetSchedulingTask` <a name="resetSchedulingTask" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSchedulingTask"></a>

```typescript
public resetSchedulingTask(): void
```

##### `resetSecurityGroups` <a name="resetSecurityGroups" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSecurityGroups"></a>

```typescript
public resetSecurityGroups(): void
```

##### `resetStrategy` <a name="resetStrategy" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetStrategy"></a>

```typescript
public resetStrategy(): void
```

##### `resetSubnetIds` <a name="resetSubnetIds" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetSubnetIds"></a>

```typescript
public resetSubnetIds(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetTaints` <a name="resetTaints" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetTaints"></a>

```typescript
public resetTaints(): void
```

##### `resetUpdatePolicy` <a name="resetUpdatePolicy" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetUpdatePolicy"></a>

```typescript
public resetUpdatePolicy(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.resetUserData"></a>

```typescript
public resetUserData(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.isConstruct"></a>

```typescript
import { OceanAwsLaunchSpec } from '@cdktf/provider-spotinst'

OceanAwsLaunchSpec.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.createOptions">createOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecCreateOptionsOutputReference">OceanAwsLaunchSpecCreateOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.deleteOptions">deleteOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecDeleteOptionsOutputReference">OceanAwsLaunchSpecDeleteOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingShutdownHours">schedulingShutdownHours</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference">OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.updatePolicy">updatePolicy</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecUpdatePolicyOutputReference">OceanAwsLaunchSpecUpdatePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.associatePublicIpAddressInput">associatePublicIpAddressInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsAutomaticInput">autoscaleHeadroomsAutomaticInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic">OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsInput">autoscaleHeadroomsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadrooms">OceanAwsLaunchSpecAutoscaleHeadrooms</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.blockDeviceMappingsInput">blockDeviceMappingsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecBlockDeviceMappings">OceanAwsLaunchSpecBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.createOptionsInput">createOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecCreateOptions">OceanAwsLaunchSpecCreateOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.deleteOptionsInput">deleteOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecDeleteOptions">OceanAwsLaunchSpecDeleteOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.elasticIpPoolInput">elasticIpPoolInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecElasticIpPool">OceanAwsLaunchSpecElasticIpPool</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.instanceTypesInput">instanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.labelsInput">labelsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecLabels">OceanAwsLaunchSpecLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.oceanIdInput">oceanIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.preferredSpotTypesInput">preferredSpotTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.resourceLimitsInput">resourceLimitsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecResourceLimits">OceanAwsLaunchSpecResourceLimits</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.restrictScaleDownInput">restrictScaleDownInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.rootVolumeSizeInput">rootVolumeSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingShutdownHoursInput">schedulingShutdownHoursInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingShutdownHours">OceanAwsLaunchSpecSchedulingShutdownHours</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingTaskInput">schedulingTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingTask">OceanAwsLaunchSpecSchedulingTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.securityGroupsInput">securityGroupsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.strategyInput">strategyInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecStrategy">OceanAwsLaunchSpecStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.subnetIdsInput">subnetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTags">OceanAwsLaunchSpecTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.taintsInput">taintsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTaints">OceanAwsLaunchSpecTaints</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.updatePolicyInput">updatePolicyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecUpdatePolicy">OceanAwsLaunchSpecUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.associatePublicIpAddress">associatePublicIpAddress</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadrooms">autoscaleHeadrooms</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadrooms">OceanAwsLaunchSpecAutoscaleHeadrooms</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsAutomatic">autoscaleHeadroomsAutomatic</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic">OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.blockDeviceMappings">blockDeviceMappings</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecBlockDeviceMappings">OceanAwsLaunchSpecBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.elasticIpPool">elasticIpPool</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecElasticIpPool">OceanAwsLaunchSpecElasticIpPool</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.iamInstanceProfile">iamInstanceProfile</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.imageId">imageId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.instanceTypes">instanceTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.labels">labels</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecLabels">OceanAwsLaunchSpecLabels</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.oceanId">oceanId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.preferredSpotTypes">preferredSpotTypes</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.resourceLimits">resourceLimits</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecResourceLimits">OceanAwsLaunchSpecResourceLimits</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.restrictScaleDown">restrictScaleDown</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.rootVolumeSize">rootVolumeSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingTask">schedulingTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingTask">OceanAwsLaunchSpecSchedulingTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.securityGroups">securityGroups</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.strategy">strategy</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecStrategy">OceanAwsLaunchSpecStrategy</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.subnetIds">subnetIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTags">OceanAwsLaunchSpecTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.taints">taints</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTaints">OceanAwsLaunchSpecTaints</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.userData">userData</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `createOptions`<sup>Required</sup> <a name="createOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.createOptions"></a>

```typescript
public readonly createOptions: OceanAwsLaunchSpecCreateOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecCreateOptionsOutputReference">OceanAwsLaunchSpecCreateOptionsOutputReference</a>

---

##### `deleteOptions`<sup>Required</sup> <a name="deleteOptions" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.deleteOptions"></a>

```typescript
public readonly deleteOptions: OceanAwsLaunchSpecDeleteOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecDeleteOptionsOutputReference">OceanAwsLaunchSpecDeleteOptionsOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `schedulingShutdownHours`<sup>Required</sup> <a name="schedulingShutdownHours" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingShutdownHours"></a>

```typescript
public readonly schedulingShutdownHours: OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference">OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference</a>

---

##### `updatePolicy`<sup>Required</sup> <a name="updatePolicy" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.updatePolicy"></a>

```typescript
public readonly updatePolicy: OceanAwsLaunchSpecUpdatePolicyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecUpdatePolicyOutputReference">OceanAwsLaunchSpecUpdatePolicyOutputReference</a>

---

##### `associatePublicIpAddressInput`<sup>Optional</sup> <a name="associatePublicIpAddressInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.associatePublicIpAddressInput"></a>

```typescript
public readonly associatePublicIpAddressInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoscaleHeadroomsAutomaticInput`<sup>Optional</sup> <a name="autoscaleHeadroomsAutomaticInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsAutomaticInput"></a>

```typescript
public readonly autoscaleHeadroomsAutomaticInput: IResolvable | OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic">OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic</a>[]

---

##### `autoscaleHeadroomsInput`<sup>Optional</sup> <a name="autoscaleHeadroomsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsInput"></a>

```typescript
public readonly autoscaleHeadroomsInput: IResolvable | OceanAwsLaunchSpecAutoscaleHeadrooms[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadrooms">OceanAwsLaunchSpecAutoscaleHeadrooms</a>[]

---

##### `blockDeviceMappingsInput`<sup>Optional</sup> <a name="blockDeviceMappingsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.blockDeviceMappingsInput"></a>

```typescript
public readonly blockDeviceMappingsInput: IResolvable | OceanAwsLaunchSpecBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecBlockDeviceMappings">OceanAwsLaunchSpecBlockDeviceMappings</a>[]

---

##### `createOptionsInput`<sup>Optional</sup> <a name="createOptionsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.createOptionsInput"></a>

```typescript
public readonly createOptionsInput: OceanAwsLaunchSpecCreateOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecCreateOptions">OceanAwsLaunchSpecCreateOptions</a>

---

##### `deleteOptionsInput`<sup>Optional</sup> <a name="deleteOptionsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.deleteOptionsInput"></a>

```typescript
public readonly deleteOptionsInput: OceanAwsLaunchSpecDeleteOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecDeleteOptions">OceanAwsLaunchSpecDeleteOptions</a>

---

##### `elasticIpPoolInput`<sup>Optional</sup> <a name="elasticIpPoolInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.elasticIpPoolInput"></a>

```typescript
public readonly elasticIpPoolInput: IResolvable | OceanAwsLaunchSpecElasticIpPool[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecElasticIpPool">OceanAwsLaunchSpecElasticIpPool</a>[]

---

##### `iamInstanceProfileInput`<sup>Optional</sup> <a name="iamInstanceProfileInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.iamInstanceProfileInput"></a>

```typescript
public readonly iamInstanceProfileInput: string;
```

- *Type:* string

---

##### `imageIdInput`<sup>Optional</sup> <a name="imageIdInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.imageIdInput"></a>

```typescript
public readonly imageIdInput: string;
```

- *Type:* string

---

##### `instanceTypesInput`<sup>Optional</sup> <a name="instanceTypesInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.instanceTypesInput"></a>

```typescript
public readonly instanceTypesInput: string[];
```

- *Type:* string[]

---

##### `labelsInput`<sup>Optional</sup> <a name="labelsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.labelsInput"></a>

```typescript
public readonly labelsInput: IResolvable | OceanAwsLaunchSpecLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecLabels">OceanAwsLaunchSpecLabels</a>[]

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `oceanIdInput`<sup>Optional</sup> <a name="oceanIdInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.oceanIdInput"></a>

```typescript
public readonly oceanIdInput: string;
```

- *Type:* string

---

##### `preferredSpotTypesInput`<sup>Optional</sup> <a name="preferredSpotTypesInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.preferredSpotTypesInput"></a>

```typescript
public readonly preferredSpotTypesInput: string[];
```

- *Type:* string[]

---

##### `resourceLimitsInput`<sup>Optional</sup> <a name="resourceLimitsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.resourceLimitsInput"></a>

```typescript
public readonly resourceLimitsInput: IResolvable | OceanAwsLaunchSpecResourceLimits[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecResourceLimits">OceanAwsLaunchSpecResourceLimits</a>[]

---

##### `restrictScaleDownInput`<sup>Optional</sup> <a name="restrictScaleDownInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.restrictScaleDownInput"></a>

```typescript
public readonly restrictScaleDownInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `rootVolumeSizeInput`<sup>Optional</sup> <a name="rootVolumeSizeInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.rootVolumeSizeInput"></a>

```typescript
public readonly rootVolumeSizeInput: number;
```

- *Type:* number

---

##### `schedulingShutdownHoursInput`<sup>Optional</sup> <a name="schedulingShutdownHoursInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingShutdownHoursInput"></a>

```typescript
public readonly schedulingShutdownHoursInput: OceanAwsLaunchSpecSchedulingShutdownHours;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingShutdownHours">OceanAwsLaunchSpecSchedulingShutdownHours</a>

---

##### `schedulingTaskInput`<sup>Optional</sup> <a name="schedulingTaskInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingTaskInput"></a>

```typescript
public readonly schedulingTaskInput: IResolvable | OceanAwsLaunchSpecSchedulingTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingTask">OceanAwsLaunchSpecSchedulingTask</a>[]

---

##### `securityGroupsInput`<sup>Optional</sup> <a name="securityGroupsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.securityGroupsInput"></a>

```typescript
public readonly securityGroupsInput: string[];
```

- *Type:* string[]

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.strategyInput"></a>

```typescript
public readonly strategyInput: IResolvable | OceanAwsLaunchSpecStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecStrategy">OceanAwsLaunchSpecStrategy</a>[]

---

##### `subnetIdsInput`<sup>Optional</sup> <a name="subnetIdsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.subnetIdsInput"></a>

```typescript
public readonly subnetIdsInput: string[];
```

- *Type:* string[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | OceanAwsLaunchSpecTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTags">OceanAwsLaunchSpecTags</a>[]

---

##### `taintsInput`<sup>Optional</sup> <a name="taintsInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.taintsInput"></a>

```typescript
public readonly taintsInput: IResolvable | OceanAwsLaunchSpecTaints[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTaints">OceanAwsLaunchSpecTaints</a>[]

---

##### `updatePolicyInput`<sup>Optional</sup> <a name="updatePolicyInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.updatePolicyInput"></a>

```typescript
public readonly updatePolicyInput: OceanAwsLaunchSpecUpdatePolicy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecUpdatePolicy">OceanAwsLaunchSpecUpdatePolicy</a>

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `associatePublicIpAddress`<sup>Required</sup> <a name="associatePublicIpAddress" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.associatePublicIpAddress"></a>

```typescript
public readonly associatePublicIpAddress: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoscaleHeadrooms`<sup>Required</sup> <a name="autoscaleHeadrooms" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadrooms"></a>

```typescript
public readonly autoscaleHeadrooms: IResolvable | OceanAwsLaunchSpecAutoscaleHeadrooms[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadrooms">OceanAwsLaunchSpecAutoscaleHeadrooms</a>[]

---

##### `autoscaleHeadroomsAutomatic`<sup>Required</sup> <a name="autoscaleHeadroomsAutomatic" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.autoscaleHeadroomsAutomatic"></a>

```typescript
public readonly autoscaleHeadroomsAutomatic: IResolvable | OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic">OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic</a>[]

---

##### `blockDeviceMappings`<sup>Required</sup> <a name="blockDeviceMappings" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.blockDeviceMappings"></a>

```typescript
public readonly blockDeviceMappings: IResolvable | OceanAwsLaunchSpecBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecBlockDeviceMappings">OceanAwsLaunchSpecBlockDeviceMappings</a>[]

---

##### `elasticIpPool`<sup>Required</sup> <a name="elasticIpPool" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.elasticIpPool"></a>

```typescript
public readonly elasticIpPool: IResolvable | OceanAwsLaunchSpecElasticIpPool[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecElasticIpPool">OceanAwsLaunchSpecElasticIpPool</a>[]

---

##### `iamInstanceProfile`<sup>Required</sup> <a name="iamInstanceProfile" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.iamInstanceProfile"></a>

```typescript
public readonly iamInstanceProfile: string;
```

- *Type:* string

---

##### `imageId`<sup>Required</sup> <a name="imageId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.imageId"></a>

```typescript
public readonly imageId: string;
```

- *Type:* string

---

##### `instanceTypes`<sup>Required</sup> <a name="instanceTypes" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.instanceTypes"></a>

```typescript
public readonly instanceTypes: string[];
```

- *Type:* string[]

---

##### `labels`<sup>Required</sup> <a name="labels" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.labels"></a>

```typescript
public readonly labels: IResolvable | OceanAwsLaunchSpecLabels[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecLabels">OceanAwsLaunchSpecLabels</a>[]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `oceanId`<sup>Required</sup> <a name="oceanId" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.oceanId"></a>

```typescript
public readonly oceanId: string;
```

- *Type:* string

---

##### `preferredSpotTypes`<sup>Required</sup> <a name="preferredSpotTypes" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.preferredSpotTypes"></a>

```typescript
public readonly preferredSpotTypes: string[];
```

- *Type:* string[]

---

##### `resourceLimits`<sup>Required</sup> <a name="resourceLimits" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.resourceLimits"></a>

```typescript
public readonly resourceLimits: IResolvable | OceanAwsLaunchSpecResourceLimits[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecResourceLimits">OceanAwsLaunchSpecResourceLimits</a>[]

---

##### `restrictScaleDown`<sup>Required</sup> <a name="restrictScaleDown" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.restrictScaleDown"></a>

```typescript
public readonly restrictScaleDown: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `rootVolumeSize`<sup>Required</sup> <a name="rootVolumeSize" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.rootVolumeSize"></a>

```typescript
public readonly rootVolumeSize: number;
```

- *Type:* number

---

##### `schedulingTask`<sup>Required</sup> <a name="schedulingTask" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.schedulingTask"></a>

```typescript
public readonly schedulingTask: IResolvable | OceanAwsLaunchSpecSchedulingTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecSchedulingTask">OceanAwsLaunchSpecSchedulingTask</a>[]

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.securityGroups"></a>

```typescript
public readonly securityGroups: string[];
```

- *Type:* string[]

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.strategy"></a>

```typescript
public readonly strategy: IResolvable | OceanAwsLaunchSpecStrategy[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecStrategy">OceanAwsLaunchSpecStrategy</a>[]

---

##### `subnetIds`<sup>Required</sup> <a name="subnetIds" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.subnetIds"></a>

```typescript
public readonly subnetIds: string[];
```

- *Type:* string[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tags"></a>

```typescript
public readonly tags: IResolvable | OceanAwsLaunchSpecTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTags">OceanAwsLaunchSpecTags</a>[]

---

##### `taints`<sup>Required</sup> <a name="taints" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.taints"></a>

```typescript
public readonly taints: IResolvable | OceanAwsLaunchSpecTaints[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpecTaints">OceanAwsLaunchSpecTaints</a>[]

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanAwsLaunchSpec.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanEcs <a name="OceanEcs" id="@cdktf/provider-spotinst.OceanEcs"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs spotinst_ocean_ecs}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanEcs.Initializer"></a>

```typescript
import { OceanEcs } from '@cdktf/provider-spotinst'

new OceanEcs(scope: Construct, id: string, config: OceanEcsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsConfig">OceanEcsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanEcs.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsConfig">OceanEcsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.putAutoscaler">putAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.putInstanceMetadataOptions">putInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.putOptimizeImages">putOptimizeImages</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.putUpdatePolicy">putUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetAssociatePublicIpAddress">resetAssociatePublicIpAddress</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetAutoscaler">resetAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetBlockDeviceMappings">resetBlockDeviceMappings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetDesiredCapacity">resetDesiredCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetDrainingTimeout">resetDrainingTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetEbsOptimized">resetEbsOptimized</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetImageId">resetImageId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetInstanceMetadataOptions">resetInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetKeyPair">resetKeyPair</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetMaxSize">resetMaxSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetMinSize">resetMinSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetMonitoring">resetMonitoring</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetOptimizeImages">resetOptimizeImages</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetScheduledTask">resetScheduledTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetSpotPercentage">resetSpotPercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetUpdatePolicy">resetUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetUserData">resetUserData</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetUtilizeCommitments">resetUtilizeCommitments</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetUtilizeReservedInstances">resetUtilizeReservedInstances</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.resetWhitelist">resetWhitelist</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanEcs.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanEcs.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanEcs.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcs.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanEcs.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanEcs.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanEcs.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanEcs.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanEcs.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanEcs.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanEcs.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanEcs.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanEcs.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanEcs.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanEcs.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanEcs.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcs.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putAutoscaler` <a name="putAutoscaler" id="@cdktf/provider-spotinst.OceanEcs.putAutoscaler"></a>

```typescript
public putAutoscaler(value: OceanEcsAutoscaler): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcs.putAutoscaler.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsAutoscaler">OceanEcsAutoscaler</a>

---

##### `putInstanceMetadataOptions` <a name="putInstanceMetadataOptions" id="@cdktf/provider-spotinst.OceanEcs.putInstanceMetadataOptions"></a>

```typescript
public putInstanceMetadataOptions(value: OceanEcsInstanceMetadataOptions): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcs.putInstanceMetadataOptions.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsInstanceMetadataOptions">OceanEcsInstanceMetadataOptions</a>

---

##### `putOptimizeImages` <a name="putOptimizeImages" id="@cdktf/provider-spotinst.OceanEcs.putOptimizeImages"></a>

```typescript
public putOptimizeImages(value: OceanEcsOptimizeImages): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcs.putOptimizeImages.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsOptimizeImages">OceanEcsOptimizeImages</a>

---

##### `putUpdatePolicy` <a name="putUpdatePolicy" id="@cdktf/provider-spotinst.OceanEcs.putUpdatePolicy"></a>

```typescript
public putUpdatePolicy(value: OceanEcsUpdatePolicy): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcs.putUpdatePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsUpdatePolicy">OceanEcsUpdatePolicy</a>

---

##### `resetAssociatePublicIpAddress` <a name="resetAssociatePublicIpAddress" id="@cdktf/provider-spotinst.OceanEcs.resetAssociatePublicIpAddress"></a>

```typescript
public resetAssociatePublicIpAddress(): void
```

##### `resetAutoscaler` <a name="resetAutoscaler" id="@cdktf/provider-spotinst.OceanEcs.resetAutoscaler"></a>

```typescript
public resetAutoscaler(): void
```

##### `resetBlockDeviceMappings` <a name="resetBlockDeviceMappings" id="@cdktf/provider-spotinst.OceanEcs.resetBlockDeviceMappings"></a>

```typescript
public resetBlockDeviceMappings(): void
```

##### `resetDesiredCapacity` <a name="resetDesiredCapacity" id="@cdktf/provider-spotinst.OceanEcs.resetDesiredCapacity"></a>

```typescript
public resetDesiredCapacity(): void
```

##### `resetDrainingTimeout` <a name="resetDrainingTimeout" id="@cdktf/provider-spotinst.OceanEcs.resetDrainingTimeout"></a>

```typescript
public resetDrainingTimeout(): void
```

##### `resetEbsOptimized` <a name="resetEbsOptimized" id="@cdktf/provider-spotinst.OceanEcs.resetEbsOptimized"></a>

```typescript
public resetEbsOptimized(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.OceanEcs.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetImageId` <a name="resetImageId" id="@cdktf/provider-spotinst.OceanEcs.resetImageId"></a>

```typescript
public resetImageId(): void
```

##### `resetInstanceMetadataOptions` <a name="resetInstanceMetadataOptions" id="@cdktf/provider-spotinst.OceanEcs.resetInstanceMetadataOptions"></a>

```typescript
public resetInstanceMetadataOptions(): void
```

##### `resetKeyPair` <a name="resetKeyPair" id="@cdktf/provider-spotinst.OceanEcs.resetKeyPair"></a>

```typescript
public resetKeyPair(): void
```

##### `resetMaxSize` <a name="resetMaxSize" id="@cdktf/provider-spotinst.OceanEcs.resetMaxSize"></a>

```typescript
public resetMaxSize(): void
```

##### `resetMinSize` <a name="resetMinSize" id="@cdktf/provider-spotinst.OceanEcs.resetMinSize"></a>

```typescript
public resetMinSize(): void
```

##### `resetMonitoring` <a name="resetMonitoring" id="@cdktf/provider-spotinst.OceanEcs.resetMonitoring"></a>

```typescript
public resetMonitoring(): void
```

##### `resetOptimizeImages` <a name="resetOptimizeImages" id="@cdktf/provider-spotinst.OceanEcs.resetOptimizeImages"></a>

```typescript
public resetOptimizeImages(): void
```

##### `resetScheduledTask` <a name="resetScheduledTask" id="@cdktf/provider-spotinst.OceanEcs.resetScheduledTask"></a>

```typescript
public resetScheduledTask(): void
```

##### `resetSpotPercentage` <a name="resetSpotPercentage" id="@cdktf/provider-spotinst.OceanEcs.resetSpotPercentage"></a>

```typescript
public resetSpotPercentage(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.OceanEcs.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetUpdatePolicy` <a name="resetUpdatePolicy" id="@cdktf/provider-spotinst.OceanEcs.resetUpdatePolicy"></a>

```typescript
public resetUpdatePolicy(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.OceanEcs.resetUserData"></a>

```typescript
public resetUserData(): void
```

##### `resetUtilizeCommitments` <a name="resetUtilizeCommitments" id="@cdktf/provider-spotinst.OceanEcs.resetUtilizeCommitments"></a>

```typescript
public resetUtilizeCommitments(): void
```

##### `resetUtilizeReservedInstances` <a name="resetUtilizeReservedInstances" id="@cdktf/provider-spotinst.OceanEcs.resetUtilizeReservedInstances"></a>

```typescript
public resetUtilizeReservedInstances(): void
```

##### `resetWhitelist` <a name="resetWhitelist" id="@cdktf/provider-spotinst.OceanEcs.resetWhitelist"></a>

```typescript
public resetWhitelist(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanEcs.isConstruct"></a>

```typescript
import { OceanEcs } from '@cdktf/provider-spotinst'

OceanEcs.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanEcs.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.autoscaler">autoscaler</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsAutoscalerOutputReference">OceanEcsAutoscalerOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.instanceMetadataOptions">instanceMetadataOptions</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsInstanceMetadataOptionsOutputReference">OceanEcsInstanceMetadataOptionsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.optimizeImages">optimizeImages</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsOptimizeImagesOutputReference">OceanEcsOptimizeImagesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.updatePolicy">updatePolicy</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsUpdatePolicyOutputReference">OceanEcsUpdatePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.associatePublicIpAddressInput">associatePublicIpAddressInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.autoscalerInput">autoscalerInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsAutoscaler">OceanEcsAutoscaler</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.blockDeviceMappingsInput">blockDeviceMappingsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsBlockDeviceMappings">OceanEcsBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.clusterNameInput">clusterNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.desiredCapacityInput">desiredCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.drainingTimeoutInput">drainingTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.ebsOptimizedInput">ebsOptimizedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.instanceMetadataOptionsInput">instanceMetadataOptionsInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsInstanceMetadataOptions">OceanEcsInstanceMetadataOptions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.keyPairInput">keyPairInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.maxSizeInput">maxSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.minSizeInput">minSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.monitoringInput">monitoringInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.optimizeImagesInput">optimizeImagesInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsOptimizeImages">OceanEcsOptimizeImages</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.regionInput">regionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.scheduledTaskInput">scheduledTaskInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsScheduledTask">OceanEcsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.securityGroupIdsInput">securityGroupIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.spotPercentageInput">spotPercentageInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.subnetIdsInput">subnetIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.tagsInput">tagsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsTags">OceanEcsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.updatePolicyInput">updatePolicyInput</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsUpdatePolicy">OceanEcsUpdatePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.userDataInput">userDataInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.utilizeCommitmentsInput">utilizeCommitmentsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.utilizeReservedInstancesInput">utilizeReservedInstancesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.whitelistInput">whitelistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.associatePublicIpAddress">associatePublicIpAddress</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.blockDeviceMappings">blockDeviceMappings</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsBlockDeviceMappings">OceanEcsBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.clusterName">clusterName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.desiredCapacity">desiredCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.drainingTimeout">drainingTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.ebsOptimized">ebsOptimized</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.iamInstanceProfile">iamInstanceProfile</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.imageId">imageId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.keyPair">keyPair</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.maxSize">maxSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.minSize">minSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.monitoring">monitoring</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.scheduledTask">scheduledTask</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsScheduledTask">OceanEcsScheduledTask</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.securityGroupIds">securityGroupIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.spotPercentage">spotPercentage</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.subnetIds">subnetIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.tags">tags</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsTags">OceanEcsTags</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.userData">userData</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.utilizeCommitments">utilizeCommitments</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.utilizeReservedInstances">utilizeReservedInstances</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.whitelist">whitelist</a></code> | <code>string[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-spotinst.OceanEcs.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-spotinst.OceanEcs.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-spotinst.OceanEcs.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-spotinst.OceanEcs.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-spotinst.OceanEcs.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-spotinst.OceanEcs.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-spotinst.OceanEcs.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-spotinst.OceanEcs.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-spotinst.OceanEcs.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-spotinst.OceanEcs.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-spotinst.OceanEcs.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `autoscaler`<sup>Required</sup> <a name="autoscaler" id="@cdktf/provider-spotinst.OceanEcs.property.autoscaler"></a>

```typescript
public readonly autoscaler: OceanEcsAutoscalerOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsAutoscalerOutputReference">OceanEcsAutoscalerOutputReference</a>

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanEcs.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `instanceMetadataOptions`<sup>Required</sup> <a name="instanceMetadataOptions" id="@cdktf/provider-spotinst.OceanEcs.property.instanceMetadataOptions"></a>

```typescript
public readonly instanceMetadataOptions: OceanEcsInstanceMetadataOptionsOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsInstanceMetadataOptionsOutputReference">OceanEcsInstanceMetadataOptionsOutputReference</a>

---

##### `optimizeImages`<sup>Required</sup> <a name="optimizeImages" id="@cdktf/provider-spotinst.OceanEcs.property.optimizeImages"></a>

```typescript
public readonly optimizeImages: OceanEcsOptimizeImagesOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsOptimizeImagesOutputReference">OceanEcsOptimizeImagesOutputReference</a>

---

##### `updatePolicy`<sup>Required</sup> <a name="updatePolicy" id="@cdktf/provider-spotinst.OceanEcs.property.updatePolicy"></a>

```typescript
public readonly updatePolicy: OceanEcsUpdatePolicyOutputReference;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsUpdatePolicyOutputReference">OceanEcsUpdatePolicyOutputReference</a>

---

##### `associatePublicIpAddressInput`<sup>Optional</sup> <a name="associatePublicIpAddressInput" id="@cdktf/provider-spotinst.OceanEcs.property.associatePublicIpAddressInput"></a>

```typescript
public readonly associatePublicIpAddressInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoscalerInput`<sup>Optional</sup> <a name="autoscalerInput" id="@cdktf/provider-spotinst.OceanEcs.property.autoscalerInput"></a>

```typescript
public readonly autoscalerInput: OceanEcsAutoscaler;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsAutoscaler">OceanEcsAutoscaler</a>

---

##### `blockDeviceMappingsInput`<sup>Optional</sup> <a name="blockDeviceMappingsInput" id="@cdktf/provider-spotinst.OceanEcs.property.blockDeviceMappingsInput"></a>

```typescript
public readonly blockDeviceMappingsInput: IResolvable | OceanEcsBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsBlockDeviceMappings">OceanEcsBlockDeviceMappings</a>[]

---

##### `clusterNameInput`<sup>Optional</sup> <a name="clusterNameInput" id="@cdktf/provider-spotinst.OceanEcs.property.clusterNameInput"></a>

```typescript
public readonly clusterNameInput: string;
```

- *Type:* string

---

##### `desiredCapacityInput`<sup>Optional</sup> <a name="desiredCapacityInput" id="@cdktf/provider-spotinst.OceanEcs.property.desiredCapacityInput"></a>

```typescript
public readonly desiredCapacityInput: number;
```

- *Type:* number

---

##### `drainingTimeoutInput`<sup>Optional</sup> <a name="drainingTimeoutInput" id="@cdktf/provider-spotinst.OceanEcs.property.drainingTimeoutInput"></a>

```typescript
public readonly drainingTimeoutInput: number;
```

- *Type:* number

---

##### `ebsOptimizedInput`<sup>Optional</sup> <a name="ebsOptimizedInput" id="@cdktf/provider-spotinst.OceanEcs.property.ebsOptimizedInput"></a>

```typescript
public readonly ebsOptimizedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `iamInstanceProfileInput`<sup>Optional</sup> <a name="iamInstanceProfileInput" id="@cdktf/provider-spotinst.OceanEcs.property.iamInstanceProfileInput"></a>

```typescript
public readonly iamInstanceProfileInput: string;
```

- *Type:* string

---

##### `imageIdInput`<sup>Optional</sup> <a name="imageIdInput" id="@cdktf/provider-spotinst.OceanEcs.property.imageIdInput"></a>

```typescript
public readonly imageIdInput: string;
```

- *Type:* string

---

##### `instanceMetadataOptionsInput`<sup>Optional</sup> <a name="instanceMetadataOptionsInput" id="@cdktf/provider-spotinst.OceanEcs.property.instanceMetadataOptionsInput"></a>

```typescript
public readonly instanceMetadataOptionsInput: OceanEcsInstanceMetadataOptions;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsInstanceMetadataOptions">OceanEcsInstanceMetadataOptions</a>

---

##### `keyPairInput`<sup>Optional</sup> <a name="keyPairInput" id="@cdktf/provider-spotinst.OceanEcs.property.keyPairInput"></a>

```typescript
public readonly keyPairInput: string;
```

- *Type:* string

---

##### `maxSizeInput`<sup>Optional</sup> <a name="maxSizeInput" id="@cdktf/provider-spotinst.OceanEcs.property.maxSizeInput"></a>

```typescript
public readonly maxSizeInput: number;
```

- *Type:* number

---

##### `minSizeInput`<sup>Optional</sup> <a name="minSizeInput" id="@cdktf/provider-spotinst.OceanEcs.property.minSizeInput"></a>

```typescript
public readonly minSizeInput: number;
```

- *Type:* number

---

##### `monitoringInput`<sup>Optional</sup> <a name="monitoringInput" id="@cdktf/provider-spotinst.OceanEcs.property.monitoringInput"></a>

```typescript
public readonly monitoringInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-spotinst.OceanEcs.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `optimizeImagesInput`<sup>Optional</sup> <a name="optimizeImagesInput" id="@cdktf/provider-spotinst.OceanEcs.property.optimizeImagesInput"></a>

```typescript
public readonly optimizeImagesInput: OceanEcsOptimizeImages;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsOptimizeImages">OceanEcsOptimizeImages</a>

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-spotinst.OceanEcs.property.regionInput"></a>

```typescript
public readonly regionInput: string;
```

- *Type:* string

---

##### `scheduledTaskInput`<sup>Optional</sup> <a name="scheduledTaskInput" id="@cdktf/provider-spotinst.OceanEcs.property.scheduledTaskInput"></a>

```typescript
public readonly scheduledTaskInput: IResolvable | OceanEcsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsScheduledTask">OceanEcsScheduledTask</a>[]

---

##### `securityGroupIdsInput`<sup>Optional</sup> <a name="securityGroupIdsInput" id="@cdktf/provider-spotinst.OceanEcs.property.securityGroupIdsInput"></a>

```typescript
public readonly securityGroupIdsInput: string[];
```

- *Type:* string[]

---

##### `spotPercentageInput`<sup>Optional</sup> <a name="spotPercentageInput" id="@cdktf/provider-spotinst.OceanEcs.property.spotPercentageInput"></a>

```typescript
public readonly spotPercentageInput: number;
```

- *Type:* number

---

##### `subnetIdsInput`<sup>Optional</sup> <a name="subnetIdsInput" id="@cdktf/provider-spotinst.OceanEcs.property.subnetIdsInput"></a>

```typescript
public readonly subnetIdsInput: string[];
```

- *Type:* string[]

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-spotinst.OceanEcs.property.tagsInput"></a>

```typescript
public readonly tagsInput: IResolvable | OceanEcsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsTags">OceanEcsTags</a>[]

---

##### `updatePolicyInput`<sup>Optional</sup> <a name="updatePolicyInput" id="@cdktf/provider-spotinst.OceanEcs.property.updatePolicyInput"></a>

```typescript
public readonly updatePolicyInput: OceanEcsUpdatePolicy;
```

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsUpdatePolicy">OceanEcsUpdatePolicy</a>

---

##### `userDataInput`<sup>Optional</sup> <a name="userDataInput" id="@cdktf/provider-spotinst.OceanEcs.property.userDataInput"></a>

```typescript
public readonly userDataInput: string;
```

- *Type:* string

---

##### `utilizeCommitmentsInput`<sup>Optional</sup> <a name="utilizeCommitmentsInput" id="@cdktf/provider-spotinst.OceanEcs.property.utilizeCommitmentsInput"></a>

```typescript
public readonly utilizeCommitmentsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstancesInput`<sup>Optional</sup> <a name="utilizeReservedInstancesInput" id="@cdktf/provider-spotinst.OceanEcs.property.utilizeReservedInstancesInput"></a>

```typescript
public readonly utilizeReservedInstancesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whitelistInput`<sup>Optional</sup> <a name="whitelistInput" id="@cdktf/provider-spotinst.OceanEcs.property.whitelistInput"></a>

```typescript
public readonly whitelistInput: string[];
```

- *Type:* string[]

---

##### `associatePublicIpAddress`<sup>Required</sup> <a name="associatePublicIpAddress" id="@cdktf/provider-spotinst.OceanEcs.property.associatePublicIpAddress"></a>

```typescript
public readonly associatePublicIpAddress: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `blockDeviceMappings`<sup>Required</sup> <a name="blockDeviceMappings" id="@cdktf/provider-spotinst.OceanEcs.property.blockDeviceMappings"></a>

```typescript
public readonly blockDeviceMappings: IResolvable | OceanEcsBlockDeviceMappings[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsBlockDeviceMappings">OceanEcsBlockDeviceMappings</a>[]

---

##### `clusterName`<sup>Required</sup> <a name="clusterName" id="@cdktf/provider-spotinst.OceanEcs.property.clusterName"></a>

```typescript
public readonly clusterName: string;
```

- *Type:* string

---

##### `desiredCapacity`<sup>Required</sup> <a name="desiredCapacity" id="@cdktf/provider-spotinst.OceanEcs.property.desiredCapacity"></a>

```typescript
public readonly desiredCapacity: number;
```

- *Type:* number

---

##### `drainingTimeout`<sup>Required</sup> <a name="drainingTimeout" id="@cdktf/provider-spotinst.OceanEcs.property.drainingTimeout"></a>

```typescript
public readonly drainingTimeout: number;
```

- *Type:* number

---

##### `ebsOptimized`<sup>Required</sup> <a name="ebsOptimized" id="@cdktf/provider-spotinst.OceanEcs.property.ebsOptimized"></a>

```typescript
public readonly ebsOptimized: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `iamInstanceProfile`<sup>Required</sup> <a name="iamInstanceProfile" id="@cdktf/provider-spotinst.OceanEcs.property.iamInstanceProfile"></a>

```typescript
public readonly iamInstanceProfile: string;
```

- *Type:* string

---

##### `imageId`<sup>Required</sup> <a name="imageId" id="@cdktf/provider-spotinst.OceanEcs.property.imageId"></a>

```typescript
public readonly imageId: string;
```

- *Type:* string

---

##### `keyPair`<sup>Required</sup> <a name="keyPair" id="@cdktf/provider-spotinst.OceanEcs.property.keyPair"></a>

```typescript
public readonly keyPair: string;
```

- *Type:* string

---

##### `maxSize`<sup>Required</sup> <a name="maxSize" id="@cdktf/provider-spotinst.OceanEcs.property.maxSize"></a>

```typescript
public readonly maxSize: number;
```

- *Type:* number

---

##### `minSize`<sup>Required</sup> <a name="minSize" id="@cdktf/provider-spotinst.OceanEcs.property.minSize"></a>

```typescript
public readonly minSize: number;
```

- *Type:* number

---

##### `monitoring`<sup>Required</sup> <a name="monitoring" id="@cdktf/provider-spotinst.OceanEcs.property.monitoring"></a>

```typescript
public readonly monitoring: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-spotinst.OceanEcs.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-spotinst.OceanEcs.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `scheduledTask`<sup>Required</sup> <a name="scheduledTask" id="@cdktf/provider-spotinst.OceanEcs.property.scheduledTask"></a>

```typescript
public readonly scheduledTask: IResolvable | OceanEcsScheduledTask[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsScheduledTask">OceanEcsScheduledTask</a>[]

---

##### `securityGroupIds`<sup>Required</sup> <a name="securityGroupIds" id="@cdktf/provider-spotinst.OceanEcs.property.securityGroupIds"></a>

```typescript
public readonly securityGroupIds: string[];
```

- *Type:* string[]

---

##### `spotPercentage`<sup>Required</sup> <a name="spotPercentage" id="@cdktf/provider-spotinst.OceanEcs.property.spotPercentage"></a>

```typescript
public readonly spotPercentage: number;
```

- *Type:* number

---

##### `subnetIds`<sup>Required</sup> <a name="subnetIds" id="@cdktf/provider-spotinst.OceanEcs.property.subnetIds"></a>

```typescript
public readonly subnetIds: string[];
```

- *Type:* string[]

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-spotinst.OceanEcs.property.tags"></a>

```typescript
public readonly tags: IResolvable | OceanEcsTags[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-spotinst.OceanEcsTags">OceanEcsTags</a>[]

---

##### `userData`<sup>Required</sup> <a name="userData" id="@cdktf/provider-spotinst.OceanEcs.property.userData"></a>

```typescript
public readonly userData: string;
```

- *Type:* string

---

##### `utilizeCommitments`<sup>Required</sup> <a name="utilizeCommitments" id="@cdktf/provider-spotinst.OceanEcs.property.utilizeCommitments"></a>

```typescript
public readonly utilizeCommitments: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `utilizeReservedInstances`<sup>Required</sup> <a name="utilizeReservedInstances" id="@cdktf/provider-spotinst.OceanEcs.property.utilizeReservedInstances"></a>

```typescript
public readonly utilizeReservedInstances: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whitelist`<sup>Required</sup> <a name="whitelist" id="@cdktf/provider-spotinst.OceanEcs.property.whitelist"></a>

```typescript
public readonly whitelist: string[];
```

- *Type:* string[]

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcs.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-spotinst.OceanEcs.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### OceanEcsLaunchSpec <a name="OceanEcsLaunchSpec" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec"></a>

Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec spotinst_ocean_ecs_launch_spec}.

#### Initializers <a name="Initializers" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer"></a>

```typescript
import { OceanEcsLaunchSpec } from '@cdktf/provider-spotinst'

new OceanEcsLaunchSpec(scope: Construct, id: string, config: OceanEcsLaunchSpecConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpecConfig">OceanEcsLaunchSpecConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpecConfig">OceanEcsLaunchSpecConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetAttributes">resetAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetAutoscaleHeadrooms">resetAutoscaleHeadrooms</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetBlockDeviceMappings">resetBlockDeviceMappings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetIamInstanceProfile">resetIamInstanceProfile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetImageId">resetImageId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetInstanceTypes">resetInstanceTypes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetRestrictScaleDown">resetRestrictScaleDown</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSchedulingTask">resetSchedulingTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSecurityGroupIds">resetSecurityGroupIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSubnetIds">resetSubnetIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetUserData">resetUserData</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetAttributes` <a name="resetAttributes" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetAttributes"></a>

```typescript
public resetAttributes(): void
```

##### `resetAutoscaleHeadrooms` <a name="resetAutoscaleHeadrooms" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetAutoscaleHeadrooms"></a>

```typescript
public resetAutoscaleHeadrooms(): void
```

##### `resetBlockDeviceMappings` <a name="resetBlockDeviceMappings" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetBlockDeviceMappings"></a>

```typescript
public resetBlockDeviceMappings(): void
```

##### `resetIamInstanceProfile` <a name="resetIamInstanceProfile" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetIamInstanceProfile"></a>

```typescript
public resetIamInstanceProfile(): void
```

##### `resetImageId` <a name="resetImageId" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetImageId"></a>

```typescript
public resetImageId(): void
```

##### `resetInstanceTypes` <a name="resetInstanceTypes" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetInstanceTypes"></a>

```typescript
public resetInstanceTypes(): void
```

##### `resetRestrictScaleDown` <a name="resetRestrictScaleDown" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetRestrictScaleDown"></a>

```typescript
public resetRestrictScaleDown(): void
```

##### `resetSchedulingTask` <a name="resetSchedulingTask" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSchedulingTask"></a>

```typescript
public resetSchedulingTask(): void
```

##### `resetSecurityGroupIds` <a name="resetSecurityGroupIds" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSecurityGroupIds"></a>

```typescript
public resetSecurityGroupIds(): void
```

##### `resetSubnetIds` <a name="resetSubnetIds" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetSubnetIds"></a>

```typescript
public resetSubnetIds(): void
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetTags"></a>

```typescript
public resetTags(): void
```

##### `resetUserData` <a name="resetUserData" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.resetUserData"></a>

```typescript
public resetUserData(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.isConstruct"></a>

```typescript
import { OceanEcsLaunchSpec } from '@cdktf/provider-spotinst'

OceanEcsLaunchSpec.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-spotinst.OceanEcsLaunchSpec.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.attributesInput">attributesInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpecAttributes">OceanEcsLaunchSpecAttributes</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.autoscaleHeadroomsInput">autoscaleHeadroomsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpecAutoscaleHeadrooms">OceanEcsLaunchSpecAutoscaleHeadrooms</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.blockDeviceMappingsInput">blockDeviceMappingsInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpecBlockDeviceMappings">OceanEcsLaunchSpecBlockDeviceMappings</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.iamInstanceProfileInput">iamInstanceProfileInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.imageIdInput">imageIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.instanceTypesInput">instanceTypesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-spotinst.OceanEcsLaunchSpec.property.nameInput">nameInput</a></