import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#name DataIntegration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#status DataIntegration#status}
    */
    readonly status?: string;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#s3 DataIntegration#s3}
    */
    readonly s3?: DataIntegrationS3;
}
export interface DataIntegrationS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#bucket_name DataIntegration#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#subdir DataIntegration#subdir}
    */
    readonly subdir?: string;
}
export declare function dataIntegrationS3ToTerraform(struct?: DataIntegrationS3OutputReference | DataIntegrationS3): any;
export declare class DataIntegrationS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIntegrationS3 | undefined;
    set internalValue(value: DataIntegrationS3 | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _subdir?;
    get subdir(): string;
    set subdir(value: string);
    resetSubdir(): void;
    get subdirInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration spotinst_data_integration}
*/
export declare class DataIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_data_integration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration spotinst_data_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: DataIntegrationConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _s3;
    get s3(): DataIntegrationS3OutputReference;
    putS3(value: DataIntegrationS3): void;
    resetS3(): void;
    get s3Input(): DataIntegrationS3 | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
