import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAwsBeanstalkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_id ElastigroupAwsBeanstalk#beanstalk_environment_id}
    */
    readonly beanstalkEnvironmentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_name ElastigroupAwsBeanstalk#beanstalk_environment_name}
    */
    readonly beanstalkEnvironmentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#desired_capacity ElastigroupAwsBeanstalk#desired_capacity}
    */
    readonly desiredCapacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#instance_types_spot ElastigroupAwsBeanstalk#instance_types_spot}
    */
    readonly instanceTypesSpot: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#maintenance ElastigroupAwsBeanstalk#maintenance}
    */
    readonly maintenance?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_size ElastigroupAwsBeanstalk#max_size}
    */
    readonly maxSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_size ElastigroupAwsBeanstalk#min_size}
    */
    readonly minSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#name ElastigroupAwsBeanstalk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#product ElastigroupAwsBeanstalk#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#region ElastigroupAwsBeanstalk#region}
    */
    readonly region: string;
    /**
    * deployment_preferences block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#deployment_preferences ElastigroupAwsBeanstalk#deployment_preferences}
    */
    readonly deploymentPreferences?: ElastigroupAwsBeanstalkDeploymentPreferences;
    /**
    * managed_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#managed_actions ElastigroupAwsBeanstalk#managed_actions}
    */
    readonly managedActions?: ElastigroupAwsBeanstalkManagedActions;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scheduled_task ElastigroupAwsBeanstalk#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupAwsBeanstalkScheduledTask[] | cdktf.IResolvable;
}
export interface ElastigroupAwsBeanstalkDeploymentPreferencesStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#action ElastigroupAwsBeanstalk#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#should_drain_instances ElastigroupAwsBeanstalk#should_drain_instances}
    */
    readonly shouldDrainInstances?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsBeanstalkDeploymentPreferencesStrategyToTerraform(struct?: ElastigroupAwsBeanstalkDeploymentPreferencesStrategy | cdktf.IResolvable): any;
export interface ElastigroupAwsBeanstalkDeploymentPreferences {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#automatic_roll ElastigroupAwsBeanstalk#automatic_roll}
    */
    readonly automaticRoll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}
    */
    readonly batchSizePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#strategy ElastigroupAwsBeanstalk#strategy}
    */
    readonly strategy?: ElastigroupAwsBeanstalkDeploymentPreferencesStrategy[] | cdktf.IResolvable;
}
export declare function elastigroupAwsBeanstalkDeploymentPreferencesToTerraform(struct?: ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference | ElastigroupAwsBeanstalkDeploymentPreferences): any;
export declare class ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsBeanstalkDeploymentPreferences | undefined;
    set internalValue(value: ElastigroupAwsBeanstalkDeploymentPreferences | undefined);
    private _automaticRoll?;
    get automaticRoll(): boolean | cdktf.IResolvable;
    set automaticRoll(value: boolean | cdktf.IResolvable);
    resetAutomaticRoll(): void;
    get automaticRollInput(): boolean | cdktf.IResolvable | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    resetBatchSizePercentage(): void;
    get batchSizePercentageInput(): number | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _strategy?;
    get strategy(): ElastigroupAwsBeanstalkDeploymentPreferencesStrategy[] | cdktf.IResolvable;
    set strategy(value: ElastigroupAwsBeanstalkDeploymentPreferencesStrategy[] | cdktf.IResolvable);
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | ElastigroupAwsBeanstalkDeploymentPreferencesStrategy[] | undefined;
}
export interface ElastigroupAwsBeanstalkManagedActionsPlatformUpdate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#perform_at ElastigroupAwsBeanstalk#perform_at}
    */
    readonly performAt?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#time_window ElastigroupAwsBeanstalk#time_window}
    */
    readonly timeWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#update_level ElastigroupAwsBeanstalk#update_level}
    */
    readonly updateLevel?: string;
}
export declare function elastigroupAwsBeanstalkManagedActionsPlatformUpdateToTerraform(struct?: ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference | ElastigroupAwsBeanstalkManagedActionsPlatformUpdate): any;
export declare class ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsBeanstalkManagedActionsPlatformUpdate | undefined;
    set internalValue(value: ElastigroupAwsBeanstalkManagedActionsPlatformUpdate | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    resetPerformAt(): void;
    get performAtInput(): string | undefined;
    private _timeWindow?;
    get timeWindow(): string;
    set timeWindow(value: string);
    resetTimeWindow(): void;
    get timeWindowInput(): string | undefined;
    private _updateLevel?;
    get updateLevel(): string;
    set updateLevel(value: string);
    resetUpdateLevel(): void;
    get updateLevelInput(): string | undefined;
}
export interface ElastigroupAwsBeanstalkManagedActions {
    /**
    * platform_update block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#platform_update ElastigroupAwsBeanstalk#platform_update}
    */
    readonly platformUpdate?: ElastigroupAwsBeanstalkManagedActionsPlatformUpdate;
}
export declare function elastigroupAwsBeanstalkManagedActionsToTerraform(struct?: ElastigroupAwsBeanstalkManagedActionsOutputReference | ElastigroupAwsBeanstalkManagedActions): any;
export declare class ElastigroupAwsBeanstalkManagedActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsBeanstalkManagedActions | undefined;
    set internalValue(value: ElastigroupAwsBeanstalkManagedActions | undefined);
    private _platformUpdate;
    get platformUpdate(): ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference;
    putPlatformUpdate(value: ElastigroupAwsBeanstalkManagedActionsPlatformUpdate): void;
    resetPlatformUpdate(): void;
    get platformUpdateInput(): ElastigroupAwsBeanstalkManagedActionsPlatformUpdate | undefined;
}
export interface ElastigroupAwsBeanstalkScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment ElastigroupAwsBeanstalk#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment_percentage ElastigroupAwsBeanstalk#adjustment_percentage}
    */
    readonly adjustmentPercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}
    */
    readonly batchSizePercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#cron_expression ElastigroupAwsBeanstalk#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#frequency ElastigroupAwsBeanstalk#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}
    */
    readonly gracePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#is_enabled ElastigroupAwsBeanstalk#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_capacity ElastigroupAwsBeanstalk#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_capacity ElastigroupAwsBeanstalk#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_max_capacity ElastigroupAwsBeanstalk#scale_max_capacity}
    */
    readonly scaleMaxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_min_capacity ElastigroupAwsBeanstalk#scale_min_capacity}
    */
    readonly scaleMinCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_target_capacity ElastigroupAwsBeanstalk#scale_target_capacity}
    */
    readonly scaleTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#start_time ElastigroupAwsBeanstalk#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#target_capacity ElastigroupAwsBeanstalk#target_capacity}
    */
    readonly targetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#task_type ElastigroupAwsBeanstalk#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupAwsBeanstalkScheduledTaskToTerraform(struct?: ElastigroupAwsBeanstalkScheduledTask | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk spotinst_elastigroup_aws_beanstalk}
*/
export declare class ElastigroupAwsBeanstalk extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_aws_beanstalk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk spotinst_elastigroup_aws_beanstalk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAwsBeanstalkConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAwsBeanstalkConfig);
    private _beanstalkEnvironmentId?;
    get beanstalkEnvironmentId(): string;
    set beanstalkEnvironmentId(value: string);
    resetBeanstalkEnvironmentId(): void;
    get beanstalkEnvironmentIdInput(): string | undefined;
    private _beanstalkEnvironmentName?;
    get beanstalkEnvironmentName(): string;
    set beanstalkEnvironmentName(value: string);
    resetBeanstalkEnvironmentName(): void;
    get beanstalkEnvironmentNameInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    get desiredCapacityInput(): number | undefined;
    get id(): string;
    private _instanceTypesSpot?;
    get instanceTypesSpot(): string[];
    set instanceTypesSpot(value: string[]);
    get instanceTypesSpotInput(): string[] | undefined;
    private _maintenance?;
    get maintenance(): string;
    set maintenance(value: string);
    resetMaintenance(): void;
    get maintenanceInput(): string | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _deploymentPreferences;
    get deploymentPreferences(): ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference;
    putDeploymentPreferences(value: ElastigroupAwsBeanstalkDeploymentPreferences): void;
    resetDeploymentPreferences(): void;
    get deploymentPreferencesInput(): ElastigroupAwsBeanstalkDeploymentPreferences | undefined;
    private _managedActions;
    get managedActions(): ElastigroupAwsBeanstalkManagedActionsOutputReference;
    putManagedActions(value: ElastigroupAwsBeanstalkManagedActions): void;
    resetManagedActions(): void;
    get managedActionsInput(): ElastigroupAwsBeanstalkManagedActions | undefined;
    private _scheduledTask?;
    get scheduledTask(): ElastigroupAwsBeanstalkScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: ElastigroupAwsBeanstalkScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupAwsBeanstalkScheduledTask[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
