import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAwsSuspensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#group_id ElastigroupAwsSuspension#group_id}
    */
    readonly groupId: string;
    /**
    * suspension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#suspension ElastigroupAwsSuspension#suspension}
    */
    readonly suspension: ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable;
}
export interface ElastigroupAwsSuspensionSuspension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#name ElastigroupAwsSuspension#name}
    */
    readonly name: string;
}
export declare function elastigroupAwsSuspensionSuspensionToTerraform(struct?: ElastigroupAwsSuspensionSuspension | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension}
*/
export declare class ElastigroupAwsSuspension extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_aws_suspension";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAwsSuspensionConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAwsSuspensionConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _suspension?;
    get suspension(): ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable;
    set suspension(value: ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable);
    get suspensionInput(): cdktf.IResolvable | ElastigroupAwsSuspensionSuspension[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
