import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#availability_zones ElastigroupAws#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#block_devices_mode ElastigroupAws#block_devices_mode}
    */
    readonly blockDevicesMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#capacity_unit ElastigroupAws#capacity_unit}
    */
    readonly capacityUnit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_credits ElastigroupAws#cpu_credits}
    */
    readonly cpuCredits?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#desired_capacity ElastigroupAws#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_optimized ElastigroupAws#ebs_optimized}
    */
    readonly ebsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_ips ElastigroupAws#elastic_ips}
    */
    readonly elasticIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_load_balancers ElastigroupAws#elastic_load_balancers}
    */
    readonly elasticLoadBalancers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#enable_monitoring ElastigroupAws#enable_monitoring}
    */
    readonly enableMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fallback_to_ondemand ElastigroupAws#fallback_to_ondemand}
    */
    readonly fallbackToOndemand: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_grace_period ElastigroupAws#health_check_grace_period}
    */
    readonly healthCheckGracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_unhealthy_duration_before_replacement ElastigroupAws#health_check_unhealthy_duration_before_replacement}
    */
    readonly healthCheckUnhealthyDurationBeforeReplacement?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iam_instance_profile ElastigroupAws#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#image_id ElastigroupAws#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_ondemand ElastigroupAws#instance_types_ondemand}
    */
    readonly instanceTypesOndemand: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_preferred_spot ElastigroupAws#instance_types_preferred_spot}
    */
    readonly instanceTypesPreferredSpot?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_spot ElastigroupAws#instance_types_spot}
    */
    readonly instanceTypesSpot: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key_name ElastigroupAws#key_name}
    */
    readonly keyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#lifetime_period ElastigroupAws#lifetime_period}
    */
    readonly lifetimePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_size ElastigroupAws#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_size ElastigroupAws#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum_instance_lifetime ElastigroupAws#minimum_instance_lifetime}
    */
    readonly minimumInstanceLifetime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ondemand_count ElastigroupAws#ondemand_count}
    */
    readonly ondemandCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#orientation ElastigroupAws#orientation}
    */
    readonly orientation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_block_devices ElastigroupAws#persist_block_devices}
    */
    readonly persistBlockDevices?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_private_ip ElastigroupAws#persist_private_ip}
    */
    readonly persistPrivateIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_root_device ElastigroupAws#persist_root_device}
    */
    readonly persistRootDevice?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#placement_tenancy ElastigroupAws#placement_tenancy}
    */
    readonly placementTenancy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#preferred_availability_zones ElastigroupAws#preferred_availability_zones}
    */
    readonly preferredAvailabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ips ElastigroupAws#private_ips}
    */
    readonly privateIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#product ElastigroupAws#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#region ElastigroupAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#security_groups ElastigroupAws#security_groups}
    */
    readonly securityGroups: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#shutdown_script ElastigroupAws#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spot_percentage ElastigroupAws#spot_percentage}
    */
    readonly spotPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#subnet_ids ElastigroupAws#subnet_ids}
    */
    readonly subnetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_arns ElastigroupAws#target_group_arns}
    */
    readonly targetGroupArns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#user_data ElastigroupAws#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_commitments ElastigroupAws#utilize_commitments}
    */
    readonly utilizeCommitments?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_reserved_instances ElastigroupAws#utilize_reserved_instances}
    */
    readonly utilizeReservedInstances?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity ElastigroupAws#wait_for_capacity}
    */
    readonly waitForCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity_timeout ElastigroupAws#wait_for_capacity_timeout}
    */
    readonly waitForCapacityTimeout?: number;
    /**
    * cpu_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_options ElastigroupAws#cpu_options}
    */
    readonly cpuOptions?: ElastigroupAwsCpuOptions;
    /**
    * ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_block_device ElastigroupAws#ebs_block_device}
    */
    readonly ebsBlockDevice?: ElastigroupAwsEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * ephemeral_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ephemeral_block_device ElastigroupAws#ephemeral_block_device}
    */
    readonly ephemeralBlockDevice?: ElastigroupAwsEphemeralBlockDevice[] | cdktf.IResolvable;
    /**
    * instance_types_weights block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_weights ElastigroupAws#instance_types_weights}
    */
    readonly instanceTypesWeights?: ElastigroupAwsInstanceTypesWeights[] | cdktf.IResolvable;
    /**
    * integration_beanstalk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_beanstalk ElastigroupAws#integration_beanstalk}
    */
    readonly integrationBeanstalk?: ElastigroupAwsIntegrationBeanstalk;
    /**
    * integration_codedeploy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_codedeploy ElastigroupAws#integration_codedeploy}
    */
    readonly integrationCodedeploy?: ElastigroupAwsIntegrationCodedeploy;
    /**
    * integration_docker_swarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_docker_swarm ElastigroupAws#integration_docker_swarm}
    */
    readonly integrationDockerSwarm?: ElastigroupAwsIntegrationDockerSwarm;
    /**
    * integration_ecs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_ecs ElastigroupAws#integration_ecs}
    */
    readonly integrationEcs?: ElastigroupAwsIntegrationEcs;
    /**
    * integration_gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_gitlab ElastigroupAws#integration_gitlab}
    */
    readonly integrationGitlab?: ElastigroupAwsIntegrationGitlab;
    /**
    * integration_kubernetes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_kubernetes ElastigroupAws#integration_kubernetes}
    */
    readonly integrationKubernetes?: ElastigroupAwsIntegrationKubernetes;
    /**
    * integration_mesosphere block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mesosphere ElastigroupAws#integration_mesosphere}
    */
    readonly integrationMesosphere?: ElastigroupAwsIntegrationMesosphere;
    /**
    * integration_multai_runtime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_multai_runtime ElastigroupAws#integration_multai_runtime}
    */
    readonly integrationMultaiRuntime?: ElastigroupAwsIntegrationMultaiRuntime;
    /**
    * integration_nomad block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_nomad ElastigroupAws#integration_nomad}
    */
    readonly integrationNomad?: ElastigroupAwsIntegrationNomad;
    /**
    * integration_rancher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_rancher ElastigroupAws#integration_rancher}
    */
    readonly integrationRancher?: ElastigroupAwsIntegrationRancher;
    /**
    * integration_route53 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_route53 ElastigroupAws#integration_route53}
    */
    readonly integrationRoute53?: ElastigroupAwsIntegrationRoute53;
    /**
    * itf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#itf ElastigroupAws#itf}
    */
    readonly itf?: ElastigroupAwsItf[] | cdktf.IResolvable;
    /**
    * metadata_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metadata_options ElastigroupAws#metadata_options}
    */
    readonly metadataOptions?: ElastigroupAwsMetadataOptions;
    /**
    * multai_target_sets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multai_target_sets ElastigroupAws#multai_target_sets}
    */
    readonly multaiTargetSets?: ElastigroupAwsMultaiTargetSets[] | cdktf.IResolvable;
    /**
    * multiple_metrics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multiple_metrics ElastigroupAws#multiple_metrics}
    */
    readonly multipleMetrics?: ElastigroupAwsMultipleMetrics;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface ElastigroupAws#network_interface}
    */
    readonly networkInterface?: ElastigroupAwsNetworkInterface[] | cdktf.IResolvable;
    /**
    * resource_tag_specification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#resource_tag_specification ElastigroupAws#resource_tag_specification}
    */
    readonly resourceTagSpecification?: ElastigroupAwsResourceTagSpecification[] | cdktf.IResolvable;
    /**
    * revert_to_spot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#revert_to_spot ElastigroupAws#revert_to_spot}
    */
    readonly revertToSpot?: ElastigroupAwsRevertToSpot;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_down_policy ElastigroupAws#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupAwsScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_strategy ElastigroupAws#scaling_strategy}
    */
    readonly scalingStrategy?: ElastigroupAwsScalingStrategy[] | cdktf.IResolvable;
    /**
    * scaling_target_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_target_policy ElastigroupAws#scaling_target_policy}
    */
    readonly scalingTargetPolicy?: ElastigroupAwsScalingTargetPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_up_policy ElastigroupAws#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupAwsScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scheduled_task ElastigroupAws#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * signal block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#signal ElastigroupAws#signal}
    */
    readonly signal?: ElastigroupAwsSignal[] | cdktf.IResolvable;
    /**
    * stateful_deallocation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_deallocation ElastigroupAws#stateful_deallocation}
    */
    readonly statefulDeallocation?: ElastigroupAwsStatefulDeallocation;
    /**
    * stateful_instance_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_action ElastigroupAws#stateful_instance_action}
    */
    readonly statefulInstanceAction?: ElastigroupAwsStatefulInstanceAction[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
    */
    readonly tags?: ElastigroupAwsTags[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_policy ElastigroupAws#update_policy}
    */
    readonly updatePolicy?: ElastigroupAwsUpdatePolicy;
}
export interface ElastigroupAwsCpuOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threads_per_core ElastigroupAws#threads_per_core}
    */
    readonly threadsPerCore: number;
}
export declare function elastigroupAwsCpuOptionsToTerraform(struct?: ElastigroupAwsCpuOptionsOutputReference | ElastigroupAwsCpuOptions): any;
export declare class ElastigroupAwsCpuOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsCpuOptions | undefined;
    set internalValue(value: ElastigroupAwsCpuOptions | undefined);
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    get threadsPerCoreInput(): number | undefined;
}
export interface ElastigroupAwsEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#encrypted ElastigroupAws#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iops ElastigroupAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#kms_key_id ElastigroupAws#kms_key_id}
    */
    readonly kmsKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#snapshot_id ElastigroupAws#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#throughput ElastigroupAws#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_size ElastigroupAws#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_type ElastigroupAws#volume_type}
    */
    readonly volumeType?: string;
}
export declare function elastigroupAwsEbsBlockDeviceToTerraform(struct?: ElastigroupAwsEbsBlockDevice | cdktf.IResolvable): any;
export interface ElastigroupAwsEphemeralBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#virtual_name ElastigroupAws#virtual_name}
    */
    readonly virtualName: string;
}
export declare function elastigroupAwsEphemeralBlockDeviceToTerraform(struct?: ElastigroupAwsEphemeralBlockDevice | cdktf.IResolvable): any;
export interface ElastigroupAwsInstanceTypesWeights {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_type ElastigroupAws#instance_type}
    */
    readonly instanceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight ElastigroupAws#weight}
    */
    readonly weight: number;
}
export declare function elastigroupAwsInstanceTypesWeightsToTerraform(struct?: ElastigroupAwsInstanceTypesWeights | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}
    */
    readonly shouldDrainInstances?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyToTerraform(struct?: ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference | ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy): any;
export declare class ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy | undefined;
    set internalValue(value: ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _shouldDrainInstances?;
    get shouldDrainInstances(): boolean | cdktf.IResolvable;
    set shouldDrainInstances(value: boolean | cdktf.IResolvable);
    resetShouldDrainInstances(): void;
    get shouldDrainInstancesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ElastigroupAwsIntegrationBeanstalkDeploymentPreferences {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#automatic_roll ElastigroupAws#automatic_roll}
    */
    readonly automaticRoll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}
    */
    readonly batchSizePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
    */
    readonly strategy?: ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy;
}
export declare function elastigroupAwsIntegrationBeanstalkDeploymentPreferencesToTerraform(struct?: ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference | ElastigroupAwsIntegrationBeanstalkDeploymentPreferences): any;
export declare class ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferences | undefined;
    set internalValue(value: ElastigroupAwsIntegrationBeanstalkDeploymentPreferences | undefined);
    private _automaticRoll?;
    get automaticRoll(): boolean | cdktf.IResolvable;
    set automaticRoll(value: boolean | cdktf.IResolvable);
    resetAutomaticRoll(): void;
    get automaticRollInput(): boolean | cdktf.IResolvable | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    resetBatchSizePercentage(): void;
    get batchSizePercentageInput(): number | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _strategy;
    get strategy(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference;
    putStrategy(value: ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy): void;
    resetStrategy(): void;
    get strategyInput(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy | undefined;
}
export interface ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}
    */
    readonly performAt?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_window ElastigroupAws#time_window}
    */
    readonly timeWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_level ElastigroupAws#update_level}
    */
    readonly updateLevel?: string;
}
export declare function elastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateToTerraform(struct?: ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference | ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate): any;
export declare class ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate | undefined;
    set internalValue(value: ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    resetPerformAt(): void;
    get performAtInput(): string | undefined;
    private _timeWindow?;
    get timeWindow(): string;
    set timeWindow(value: string);
    resetTimeWindow(): void;
    get timeWindowInput(): string | undefined;
    private _updateLevel?;
    get updateLevel(): string;
    set updateLevel(value: string);
    resetUpdateLevel(): void;
    get updateLevelInput(): string | undefined;
}
export interface ElastigroupAwsIntegrationBeanstalkManagedActions {
    /**
    * platform_update block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#platform_update ElastigroupAws#platform_update}
    */
    readonly platformUpdate?: ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate;
}
export declare function elastigroupAwsIntegrationBeanstalkManagedActionsToTerraform(struct?: ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference | ElastigroupAwsIntegrationBeanstalkManagedActions): any;
export declare class ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationBeanstalkManagedActions | undefined;
    set internalValue(value: ElastigroupAwsIntegrationBeanstalkManagedActions | undefined);
    private _platformUpdate;
    get platformUpdate(): ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference;
    putPlatformUpdate(value: ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate): void;
    resetPlatformUpdate(): void;
    get platformUpdateInput(): ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate | undefined;
}
export interface ElastigroupAwsIntegrationBeanstalk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#environment_id ElastigroupAws#environment_id}
    */
    readonly environmentId?: string;
    /**
    * deployment_preferences block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_preferences ElastigroupAws#deployment_preferences}
    */
    readonly deploymentPreferences?: ElastigroupAwsIntegrationBeanstalkDeploymentPreferences;
    /**
    * managed_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#managed_actions ElastigroupAws#managed_actions}
    */
    readonly managedActions?: ElastigroupAwsIntegrationBeanstalkManagedActions;
}
export declare function elastigroupAwsIntegrationBeanstalkToTerraform(struct?: ElastigroupAwsIntegrationBeanstalkOutputReference | ElastigroupAwsIntegrationBeanstalk): any;
export declare class ElastigroupAwsIntegrationBeanstalkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationBeanstalk | undefined;
    set internalValue(value: ElastigroupAwsIntegrationBeanstalk | undefined);
    private _environmentId?;
    get environmentId(): string;
    set environmentId(value: string);
    resetEnvironmentId(): void;
    get environmentIdInput(): string | undefined;
    private _deploymentPreferences;
    get deploymentPreferences(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference;
    putDeploymentPreferences(value: ElastigroupAwsIntegrationBeanstalkDeploymentPreferences): void;
    resetDeploymentPreferences(): void;
    get deploymentPreferencesInput(): ElastigroupAwsIntegrationBeanstalkDeploymentPreferences | undefined;
    private _managedActions;
    get managedActions(): ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference;
    putManagedActions(value: ElastigroupAwsIntegrationBeanstalkManagedActions): void;
    resetManagedActions(): void;
    get managedActionsInput(): ElastigroupAwsIntegrationBeanstalkManagedActions | undefined;
}
export interface ElastigroupAwsIntegrationCodedeployDeploymentGroups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#application_name ElastigroupAws#application_name}
    */
    readonly applicationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_group_name ElastigroupAws#deployment_group_name}
    */
    readonly deploymentGroupName: string;
}
export declare function elastigroupAwsIntegrationCodedeployDeploymentGroupsToTerraform(struct?: ElastigroupAwsIntegrationCodedeployDeploymentGroups | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationCodedeploy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cleanup_on_failure ElastigroupAws#cleanup_on_failure}
    */
    readonly cleanupOnFailure: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_instance_on_failure ElastigroupAws#terminate_instance_on_failure}
    */
    readonly terminateInstanceOnFailure: boolean | cdktf.IResolvable;
    /**
    * deployment_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_groups ElastigroupAws#deployment_groups}
    */
    readonly deploymentGroups: ElastigroupAwsIntegrationCodedeployDeploymentGroups[] | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationCodedeployToTerraform(struct?: ElastigroupAwsIntegrationCodedeployOutputReference | ElastigroupAwsIntegrationCodedeploy): any;
export declare class ElastigroupAwsIntegrationCodedeployOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationCodedeploy | undefined;
    set internalValue(value: ElastigroupAwsIntegrationCodedeploy | undefined);
    private _cleanupOnFailure?;
    get cleanupOnFailure(): boolean | cdktf.IResolvable;
    set cleanupOnFailure(value: boolean | cdktf.IResolvable);
    get cleanupOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _terminateInstanceOnFailure?;
    get terminateInstanceOnFailure(): boolean | cdktf.IResolvable;
    set terminateInstanceOnFailure(value: boolean | cdktf.IResolvable);
    get terminateInstanceOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _deploymentGroups?;
    get deploymentGroups(): ElastigroupAwsIntegrationCodedeployDeploymentGroups[] | cdktf.IResolvable;
    set deploymentGroups(value: ElastigroupAwsIntegrationCodedeployDeploymentGroups[] | cdktf.IResolvable);
    get deploymentGroupsInput(): cdktf.IResolvable | ElastigroupAwsIntegrationCodedeployDeploymentGroups[] | undefined;
}
export interface ElastigroupAwsIntegrationDockerSwarmAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function elastigroupAwsIntegrationDockerSwarmAutoscaleDownToTerraform(struct?: ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference | ElastigroupAwsIntegrationDockerSwarmAutoscaleDown): any;
export declare class ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationDockerSwarmAutoscaleDown | undefined;
    set internalValue(value: ElastigroupAwsIntegrationDockerSwarmAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomToTerraform(struct?: ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference | ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom): any;
export declare class ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationDockerSwarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}
    */
    readonly masterPort: number;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupAwsIntegrationDockerSwarmAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom;
}
export declare function elastigroupAwsIntegrationDockerSwarmToTerraform(struct?: ElastigroupAwsIntegrationDockerSwarmOutputReference | ElastigroupAwsIntegrationDockerSwarm): any;
export declare class ElastigroupAwsIntegrationDockerSwarmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationDockerSwarm | undefined;
    set internalValue(value: ElastigroupAwsIntegrationDockerSwarm | undefined);
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _masterPort?;
    get masterPort(): number;
    set masterPort(value: number);
    get masterPortInput(): number | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupAwsIntegrationDockerSwarmAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupAwsIntegrationDockerSwarmAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom | undefined;
}
export interface ElastigroupAwsIntegrationEcsAutoscaleAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value: string;
}
export declare function elastigroupAwsIntegrationEcsAutoscaleAttributesToTerraform(struct?: ElastigroupAwsIntegrationEcsAutoscaleAttributes | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationEcsAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function elastigroupAwsIntegrationEcsAutoscaleDownToTerraform(struct?: ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference | ElastigroupAwsIntegrationEcsAutoscaleDown): any;
export declare class ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationEcsAutoscaleDown | undefined;
    set internalValue(value: ElastigroupAwsIntegrationEcsAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationEcsAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupAwsIntegrationEcsAutoscaleHeadroomToTerraform(struct?: ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference | ElastigroupAwsIntegrationEcsAutoscaleHeadroom): any;
export declare class ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationEcsAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupAwsIntegrationEcsAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationEcsBatch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#job_queue_names ElastigroupAws#job_queue_names}
    */
    readonly jobQueueNames: string[];
}
export declare function elastigroupAwsIntegrationEcsBatchToTerraform(struct?: ElastigroupAwsIntegrationEcsBatchOutputReference | ElastigroupAwsIntegrationEcsBatch): any;
export declare class ElastigroupAwsIntegrationEcsBatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationEcsBatch | undefined;
    set internalValue(value: ElastigroupAwsIntegrationEcsBatch | undefined);
    private _jobQueueNames?;
    get jobQueueNames(): string[];
    set jobQueueNames(value: string[]);
    get jobQueueNamesInput(): string[] | undefined;
}
export interface ElastigroupAwsIntegrationEcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_scale_down_non_service_tasks ElastigroupAws#autoscale_scale_down_non_service_tasks}
    */
    readonly autoscaleScaleDownNonServiceTasks?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_name ElastigroupAws#cluster_name}
    */
    readonly clusterName: string;
    /**
    * autoscale_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_attributes ElastigroupAws#autoscale_attributes}
    */
    readonly autoscaleAttributes?: ElastigroupAwsIntegrationEcsAutoscaleAttributes[] | cdktf.IResolvable;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupAwsIntegrationEcsAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupAwsIntegrationEcsAutoscaleHeadroom;
    /**
    * batch block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch ElastigroupAws#batch}
    */
    readonly batch?: ElastigroupAwsIntegrationEcsBatch;
}
export declare function elastigroupAwsIntegrationEcsToTerraform(struct?: ElastigroupAwsIntegrationEcsOutputReference | ElastigroupAwsIntegrationEcs): any;
export declare class ElastigroupAwsIntegrationEcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationEcs | undefined;
    set internalValue(value: ElastigroupAwsIntegrationEcs | undefined);
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleScaleDownNonServiceTasks?;
    get autoscaleScaleDownNonServiceTasks(): boolean | cdktf.IResolvable;
    set autoscaleScaleDownNonServiceTasks(value: boolean | cdktf.IResolvable);
    resetAutoscaleScaleDownNonServiceTasks(): void;
    get autoscaleScaleDownNonServiceTasksInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _autoscaleAttributes?;
    get autoscaleAttributes(): ElastigroupAwsIntegrationEcsAutoscaleAttributes[] | cdktf.IResolvable;
    set autoscaleAttributes(value: ElastigroupAwsIntegrationEcsAutoscaleAttributes[] | cdktf.IResolvable);
    resetAutoscaleAttributes(): void;
    get autoscaleAttributesInput(): cdktf.IResolvable | ElastigroupAwsIntegrationEcsAutoscaleAttributes[] | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupAwsIntegrationEcsAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupAwsIntegrationEcsAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupAwsIntegrationEcsAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupAwsIntegrationEcsAutoscaleHeadroom | undefined;
    private _batch;
    get batch(): ElastigroupAwsIntegrationEcsBatchOutputReference;
    putBatch(value: ElastigroupAwsIntegrationEcsBatch): void;
    resetBatch(): void;
    get batchInput(): ElastigroupAwsIntegrationEcsBatch | undefined;
}
export interface ElastigroupAwsIntegrationGitlabRunner {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationGitlabRunnerToTerraform(struct?: ElastigroupAwsIntegrationGitlabRunnerOutputReference | ElastigroupAwsIntegrationGitlabRunner): any;
export declare class ElastigroupAwsIntegrationGitlabRunnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationGitlabRunner | undefined;
    set internalValue(value: ElastigroupAwsIntegrationGitlabRunner | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ElastigroupAwsIntegrationGitlab {
    /**
    * runner block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#runner ElastigroupAws#runner}
    */
    readonly runner?: ElastigroupAwsIntegrationGitlabRunner;
}
export declare function elastigroupAwsIntegrationGitlabToTerraform(struct?: ElastigroupAwsIntegrationGitlabOutputReference | ElastigroupAwsIntegrationGitlab): any;
export declare class ElastigroupAwsIntegrationGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationGitlab | undefined;
    set internalValue(value: ElastigroupAwsIntegrationGitlab | undefined);
    private _runner;
    get runner(): ElastigroupAwsIntegrationGitlabRunnerOutputReference;
    putRunner(value: ElastigroupAwsIntegrationGitlabRunner): void;
    resetRunner(): void;
    get runnerInput(): ElastigroupAwsIntegrationGitlabRunner | undefined;
}
export interface ElastigroupAwsIntegrationKubernetesAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
}
export declare function elastigroupAwsIntegrationKubernetesAutoscaleDownToTerraform(struct?: ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference | ElastigroupAwsIntegrationKubernetesAutoscaleDown): any;
export declare class ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationKubernetesAutoscaleDown | undefined;
    set internalValue(value: ElastigroupAwsIntegrationKubernetesAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupAwsIntegrationKubernetesAutoscaleHeadroomToTerraform(struct?: ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference | ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom): any;
export declare class ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationKubernetesAutoscaleLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value: string;
}
export declare function elastigroupAwsIntegrationKubernetesAutoscaleLabelsToTerraform(struct?: ElastigroupAwsIntegrationKubernetesAutoscaleLabels | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationKubernetes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}
    */
    readonly apiServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_identifier ElastigroupAws#cluster_identifier}
    */
    readonly clusterIdentifier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mode ElastigroupAws#integration_mode}
    */
    readonly integrationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#token ElastigroupAws#token}
    */
    readonly token?: string;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupAwsIntegrationKubernetesAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom;
    /**
    * autoscale_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_labels ElastigroupAws#autoscale_labels}
    */
    readonly autoscaleLabels?: ElastigroupAwsIntegrationKubernetesAutoscaleLabels[] | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationKubernetesToTerraform(struct?: ElastigroupAwsIntegrationKubernetesOutputReference | ElastigroupAwsIntegrationKubernetes): any;
export declare class ElastigroupAwsIntegrationKubernetesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationKubernetes | undefined;
    set internalValue(value: ElastigroupAwsIntegrationKubernetes | undefined);
    private _apiServer?;
    get apiServer(): string;
    set apiServer(value: string);
    resetApiServer(): void;
    get apiServerInput(): string | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterIdentifier?;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    resetClusterIdentifier(): void;
    get clusterIdentifierInput(): string | undefined;
    private _integrationMode?;
    get integrationMode(): string;
    set integrationMode(value: string);
    resetIntegrationMode(): void;
    get integrationModeInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupAwsIntegrationKubernetesAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupAwsIntegrationKubernetesAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom | undefined;
    private _autoscaleLabels?;
    get autoscaleLabels(): ElastigroupAwsIntegrationKubernetesAutoscaleLabels[] | cdktf.IResolvable;
    set autoscaleLabels(value: ElastigroupAwsIntegrationKubernetesAutoscaleLabels[] | cdktf.IResolvable);
    resetAutoscaleLabels(): void;
    get autoscaleLabelsInput(): cdktf.IResolvable | ElastigroupAwsIntegrationKubernetesAutoscaleLabels[] | undefined;
}
export interface ElastigroupAwsIntegrationMesosphere {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}
    */
    readonly apiServer: string;
}
export declare function elastigroupAwsIntegrationMesosphereToTerraform(struct?: ElastigroupAwsIntegrationMesosphereOutputReference | ElastigroupAwsIntegrationMesosphere): any;
export declare class ElastigroupAwsIntegrationMesosphereOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationMesosphere | undefined;
    set internalValue(value: ElastigroupAwsIntegrationMesosphere | undefined);
    private _apiServer?;
    get apiServer(): string;
    set apiServer(value: string);
    get apiServerInput(): string | undefined;
}
export interface ElastigroupAwsIntegrationMultaiRuntime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_id ElastigroupAws#deployment_id}
    */
    readonly deploymentId: string;
}
export declare function elastigroupAwsIntegrationMultaiRuntimeToTerraform(struct?: ElastigroupAwsIntegrationMultaiRuntimeOutputReference | ElastigroupAwsIntegrationMultaiRuntime): any;
export declare class ElastigroupAwsIntegrationMultaiRuntimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationMultaiRuntime | undefined;
    set internalValue(value: ElastigroupAwsIntegrationMultaiRuntime | undefined);
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
}
export interface ElastigroupAwsIntegrationNomadAutoscaleConstraints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value: string;
}
export declare function elastigroupAwsIntegrationNomadAutoscaleConstraintsToTerraform(struct?: ElastigroupAwsIntegrationNomadAutoscaleConstraints | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationNomadAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
}
export declare function elastigroupAwsIntegrationNomadAutoscaleDownToTerraform(struct?: ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference | ElastigroupAwsIntegrationNomadAutoscaleDown): any;
export declare class ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationNomadAutoscaleDown | undefined;
    set internalValue(value: ElastigroupAwsIntegrationNomadAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationNomadAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupAwsIntegrationNomadAutoscaleHeadroomToTerraform(struct?: ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference | ElastigroupAwsIntegrationNomadAutoscaleHeadroom): any;
export declare class ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationNomadAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupAwsIntegrationNomadAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupAwsIntegrationNomad {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#acl_token ElastigroupAws#acl_token}
    */
    readonly aclToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}
    */
    readonly masterPort: number;
    /**
    * autoscale_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_constraints ElastigroupAws#autoscale_constraints}
    */
    readonly autoscaleConstraints?: ElastigroupAwsIntegrationNomadAutoscaleConstraints[] | cdktf.IResolvable;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupAwsIntegrationNomadAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupAwsIntegrationNomadAutoscaleHeadroom;
}
export declare function elastigroupAwsIntegrationNomadToTerraform(struct?: ElastigroupAwsIntegrationNomadOutputReference | ElastigroupAwsIntegrationNomad): any;
export declare class ElastigroupAwsIntegrationNomadOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationNomad | undefined;
    set internalValue(value: ElastigroupAwsIntegrationNomad | undefined);
    private _aclToken?;
    get aclToken(): string;
    set aclToken(value: string);
    resetAclToken(): void;
    get aclTokenInput(): string | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _masterPort?;
    get masterPort(): number;
    set masterPort(value: number);
    get masterPortInput(): number | undefined;
    private _autoscaleConstraints?;
    get autoscaleConstraints(): ElastigroupAwsIntegrationNomadAutoscaleConstraints[] | cdktf.IResolvable;
    set autoscaleConstraints(value: ElastigroupAwsIntegrationNomadAutoscaleConstraints[] | cdktf.IResolvable);
    resetAutoscaleConstraints(): void;
    get autoscaleConstraintsInput(): cdktf.IResolvable | ElastigroupAwsIntegrationNomadAutoscaleConstraints[] | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupAwsIntegrationNomadAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupAwsIntegrationNomadAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupAwsIntegrationNomadAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupAwsIntegrationNomadAutoscaleHeadroom | undefined;
}
export interface ElastigroupAwsIntegrationRancher {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#access_key ElastigroupAws#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secret_key ElastigroupAws#secret_key}
    */
    readonly secretKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#version ElastigroupAws#version}
    */
    readonly version?: string;
}
export declare function elastigroupAwsIntegrationRancherToTerraform(struct?: ElastigroupAwsIntegrationRancherOutputReference | ElastigroupAwsIntegrationRancher): any;
export declare class ElastigroupAwsIntegrationRancherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationRancher | undefined;
    set internalValue(value: ElastigroupAwsIntegrationRancher | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface ElastigroupAwsIntegrationRoute53DomainsRecordSets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_dns ElastigroupAws#use_public_dns}
    */
    readonly usePublicDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_ip ElastigroupAws#use_public_ip}
    */
    readonly usePublicIp?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationRoute53DomainsRecordSetsToTerraform(struct?: ElastigroupAwsIntegrationRoute53DomainsRecordSets | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationRoute53Domains {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#hosted_zone_id ElastigroupAws#hosted_zone_id}
    */
    readonly hostedZoneId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_set_type ElastigroupAws#record_set_type}
    */
    readonly recordSetType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spotinst_acct_id ElastigroupAws#spotinst_acct_id}
    */
    readonly spotinstAcctId?: string;
    /**
    * record_sets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_sets ElastigroupAws#record_sets}
    */
    readonly recordSets: ElastigroupAwsIntegrationRoute53DomainsRecordSets[] | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationRoute53DomainsToTerraform(struct?: ElastigroupAwsIntegrationRoute53Domains | cdktf.IResolvable): any;
export interface ElastigroupAwsIntegrationRoute53 {
    /**
    * domains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#domains ElastigroupAws#domains}
    */
    readonly domains: ElastigroupAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
}
export declare function elastigroupAwsIntegrationRoute53ToTerraform(struct?: ElastigroupAwsIntegrationRoute53OutputReference | ElastigroupAwsIntegrationRoute53): any;
export declare class ElastigroupAwsIntegrationRoute53OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsIntegrationRoute53 | undefined;
    set internalValue(value: ElastigroupAwsIntegrationRoute53 | undefined);
    private _domains?;
    get domains(): ElastigroupAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
    set domains(value: ElastigroupAwsIntegrationRoute53Domains[] | cdktf.IResolvable);
    get domainsInput(): cdktf.IResolvable | ElastigroupAwsIntegrationRoute53Domains[] | undefined;
}
export interface ElastigroupAwsItfDefaultStaticTargetGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}
    */
    readonly percentage: number;
}
export declare function elastigroupAwsItfDefaultStaticTargetGroupToTerraform(struct?: ElastigroupAwsItfDefaultStaticTargetGroupOutputReference | ElastigroupAwsItfDefaultStaticTargetGroup): any;
export declare class ElastigroupAwsItfDefaultStaticTargetGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsItfDefaultStaticTargetGroup | undefined;
    set internalValue(value: ElastigroupAwsItfDefaultStaticTargetGroup | undefined);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}
    */
    readonly percentage: number;
}
export declare function elastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroupToTerraform(struct?: ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroupOutputReference | ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup): any;
export declare class ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup | undefined;
    set internalValue(value: ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup | undefined);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface ElastigroupAwsItfLoadBalancerListenerRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#rule_arn ElastigroupAws#rule_arn}
    */
    readonly ruleArn: string;
    /**
    * static_target_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#static_target_group ElastigroupAws#static_target_group}
    */
    readonly staticTargetGroup?: ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup;
}
export declare function elastigroupAwsItfLoadBalancerListenerRuleToTerraform(struct?: ElastigroupAwsItfLoadBalancerListenerRule | cdktf.IResolvable): any;
export interface ElastigroupAwsItfLoadBalancer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer_arn ElastigroupAws#load_balancer_arn}
    */
    readonly loadBalancerArn: string;
    /**
    * listener_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#listener_rule ElastigroupAws#listener_rule}
    */
    readonly listenerRule: ElastigroupAwsItfLoadBalancerListenerRule[] | cdktf.IResolvable;
}
export declare function elastigroupAwsItfLoadBalancerToTerraform(struct?: ElastigroupAwsItfLoadBalancer | cdktf.IResolvable): any;
export interface ElastigroupAwsItfTargetGroupConfigMatcher {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grpc_code ElastigroupAws#grpc_code}
    */
    readonly grpcCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_code ElastigroupAws#http_code}
    */
    readonly httpCode?: string;
}
export declare function elastigroupAwsItfTargetGroupConfigMatcherToTerraform(struct?: ElastigroupAwsItfTargetGroupConfigMatcher | cdktf.IResolvable): any;
export interface ElastigroupAwsItfTargetGroupConfigTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_key ElastigroupAws#tag_key}
    */
    readonly tagKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_value ElastigroupAws#tag_value}
    */
    readonly tagValue?: string;
}
export declare function elastigroupAwsItfTargetGroupConfigTagsToTerraform(struct?: ElastigroupAwsItfTargetGroupConfigTags | cdktf.IResolvable): any;
export interface ElastigroupAwsItfTargetGroupConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_interval_seconds ElastigroupAws#health_check_interval_seconds}
    */
    readonly healthCheckIntervalSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_path ElastigroupAws#health_check_path}
    */
    readonly healthCheckPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_port ElastigroupAws#health_check_port}
    */
    readonly healthCheckPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_protocol ElastigroupAws#health_check_protocol}
    */
    readonly healthCheckProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_timeout_seconds ElastigroupAws#health_check_timeout_seconds}
    */
    readonly healthCheckTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#healthy_threshold_count ElastigroupAws#healthy_threshold_count}
    */
    readonly healthyThresholdCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#port ElastigroupAws#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol ElastigroupAws#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol_version ElastigroupAws#protocol_version}
    */
    readonly protocolVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unhealthy_threshold_count ElastigroupAws#unhealthy_threshold_count}
    */
    readonly unhealthyThresholdCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#vpc_id ElastigroupAws#vpc_id}
    */
    readonly vpcId: string;
    /**
    * matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#matcher ElastigroupAws#matcher}
    */
    readonly matcher?: ElastigroupAwsItfTargetGroupConfigMatcher[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
    */
    readonly tags?: ElastigroupAwsItfTargetGroupConfigTags[] | cdktf.IResolvable;
}
export declare function elastigroupAwsItfTargetGroupConfigToTerraform(struct?: ElastigroupAwsItfTargetGroupConfig | cdktf.IResolvable): any;
export interface ElastigroupAwsItf {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fixed_target_groups ElastigroupAws#fixed_target_groups}
    */
    readonly fixedTargetGroups: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#migration_healthiness_threshold ElastigroupAws#migration_healthiness_threshold}
    */
    readonly migrationHealthinessThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight_strategy ElastigroupAws#weight_strategy}
    */
    readonly weightStrategy: string;
    /**
    * default_static_target_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#default_static_target_group ElastigroupAws#default_static_target_group}
    */
    readonly defaultStaticTargetGroup?: ElastigroupAwsItfDefaultStaticTargetGroup;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer ElastigroupAws#load_balancer}
    */
    readonly loadBalancer: ElastigroupAwsItfLoadBalancer[] | cdktf.IResolvable;
    /**
    * target_group_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_config ElastigroupAws#target_group_config}
    */
    readonly targetGroupConfig: ElastigroupAwsItfTargetGroupConfig[] | cdktf.IResolvable;
}
export declare function elastigroupAwsItfToTerraform(struct?: ElastigroupAwsItf | cdktf.IResolvable): any;
export interface ElastigroupAwsMetadataOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_put_response_hop_limit ElastigroupAws#http_put_response_hop_limit}
    */
    readonly httpPutResponseHopLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_tokens ElastigroupAws#http_tokens}
    */
    readonly httpTokens: string;
}
export declare function elastigroupAwsMetadataOptionsToTerraform(struct?: ElastigroupAwsMetadataOptionsOutputReference | ElastigroupAwsMetadataOptions): any;
export declare class ElastigroupAwsMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsMetadataOptions | undefined;
    set internalValue(value: ElastigroupAwsMetadataOptions | undefined);
    private _httpPutResponseHopLimit?;
    get httpPutResponseHopLimit(): number;
    set httpPutResponseHopLimit(value: number);
    resetHttpPutResponseHopLimit(): void;
    get httpPutResponseHopLimitInput(): number | undefined;
    private _httpTokens?;
    get httpTokens(): string;
    set httpTokens(value: string);
    get httpTokensInput(): string | undefined;
}
export interface ElastigroupAwsMultaiTargetSets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#balancer_id ElastigroupAws#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_set_id ElastigroupAws#target_set_id}
    */
    readonly targetSetId: string;
}
export declare function elastigroupAwsMultaiTargetSetsToTerraform(struct?: ElastigroupAwsMultaiTargetSets | cdktf.IResolvable): any;
export interface ElastigroupAwsMultipleMetricsExpressions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expression ElastigroupAws#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
}
export declare function elastigroupAwsMultipleMetricsExpressionsToTerraform(struct?: ElastigroupAwsMultipleMetricsExpressions | cdktf.IResolvable): any;
export interface ElastigroupAwsMultipleMetricsMetricsDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value?: string;
}
export declare function elastigroupAwsMultipleMetricsMetricsDimensionsToTerraform(struct?: ElastigroupAwsMultipleMetricsMetricsDimensions | cdktf.IResolvable): any;
export interface ElastigroupAwsMultipleMetricsMetrics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#extended_statistic ElastigroupAws#extended_statistic}
    */
    readonly extendedStatistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
    */
    readonly dimensions?: ElastigroupAwsMultipleMetricsMetricsDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAwsMultipleMetricsMetricsToTerraform(struct?: ElastigroupAwsMultipleMetricsMetrics | cdktf.IResolvable): any;
export interface ElastigroupAwsMultipleMetrics {
    /**
    * expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expressions ElastigroupAws#expressions}
    */
    readonly expressions?: ElastigroupAwsMultipleMetricsExpressions[] | cdktf.IResolvable;
    /**
    * metrics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metrics ElastigroupAws#metrics}
    */
    readonly metrics?: ElastigroupAwsMultipleMetricsMetrics[] | cdktf.IResolvable;
}
export declare function elastigroupAwsMultipleMetricsToTerraform(struct?: ElastigroupAwsMultipleMetricsOutputReference | ElastigroupAwsMultipleMetrics): any;
export declare class ElastigroupAwsMultipleMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsMultipleMetrics | undefined;
    set internalValue(value: ElastigroupAwsMultipleMetrics | undefined);
    private _expressions?;
    get expressions(): ElastigroupAwsMultipleMetricsExpressions[] | cdktf.IResolvable;
    set expressions(value: ElastigroupAwsMultipleMetricsExpressions[] | cdktf.IResolvable);
    resetExpressions(): void;
    get expressionsInput(): cdktf.IResolvable | ElastigroupAwsMultipleMetricsExpressions[] | undefined;
    private _metrics?;
    get metrics(): ElastigroupAwsMultipleMetricsMetrics[] | cdktf.IResolvable;
    set metrics(value: ElastigroupAwsMultipleMetricsMetrics[] | cdktf.IResolvable);
    resetMetrics(): void;
    get metricsInput(): cdktf.IResolvable | ElastigroupAwsMultipleMetricsMetrics[] | undefined;
}
export interface ElastigroupAwsNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_ipv6_address ElastigroupAws#associate_ipv6_address}
    */
    readonly associateIpv6Address?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_public_ip_address ElastigroupAws#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_index ElastigroupAws#device_index}
    */
    readonly deviceIndex: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface_id ElastigroupAws#network_interface_id}
    */
    readonly networkInterfaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ip_address ElastigroupAws#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secondary_private_ip_address_count ElastigroupAws#secondary_private_ip_address_count}
    */
    readonly secondaryPrivateIpAddressCount?: string;
}
export declare function elastigroupAwsNetworkInterfaceToTerraform(struct?: ElastigroupAwsNetworkInterface | cdktf.IResolvable): any;
export interface ElastigroupAwsResourceTagSpecification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_amis ElastigroupAws#should_tag_amis}
    */
    readonly shouldTagAmis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_enis ElastigroupAws#should_tag_enis}
    */
    readonly shouldTagEnis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_snapshots ElastigroupAws#should_tag_snapshots}
    */
    readonly shouldTagSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_volumes ElastigroupAws#should_tag_volumes}
    */
    readonly shouldTagVolumes?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsResourceTagSpecificationToTerraform(struct?: ElastigroupAwsResourceTagSpecification | cdktf.IResolvable): any;
export interface ElastigroupAwsRevertToSpot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}
    */
    readonly performAt: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_windows ElastigroupAws#time_windows}
    */
    readonly timeWindows?: string[];
}
export declare function elastigroupAwsRevertToSpotToTerraform(struct?: ElastigroupAwsRevertToSpotOutputReference | ElastigroupAwsRevertToSpot): any;
export declare class ElastigroupAwsRevertToSpotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsRevertToSpot | undefined;
    set internalValue(value: ElastigroupAwsRevertToSpot | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    get performAtInput(): string | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    resetTimeWindows(): void;
    get timeWindowsInput(): string[] | undefined;
}
export interface ElastigroupAwsScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value?: string;
}
export declare function elastigroupAwsScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupAwsScalingDownPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingDownPolicyStepAdjustmentsAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}
    */
    readonly type: string;
}
export declare function elastigroupAwsScalingDownPolicyStepAdjustmentsActionToTerraform(struct?: ElastigroupAwsScalingDownPolicyStepAdjustmentsActionOutputReference | ElastigroupAwsScalingDownPolicyStepAdjustmentsAction): any;
export declare class ElastigroupAwsScalingDownPolicyStepAdjustmentsActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsScalingDownPolicyStepAdjustmentsAction | undefined;
    set internalValue(value: ElastigroupAwsScalingDownPolicyStepAdjustmentsAction | undefined);
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ElastigroupAwsScalingDownPolicyStepAdjustments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}
    */
    readonly threshold: number;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
    */
    readonly action: ElastigroupAwsScalingDownPolicyStepAdjustmentsAction;
}
export declare function elastigroupAwsScalingDownPolicyStepAdjustmentsToTerraform(struct?: ElastigroupAwsScalingDownPolicyStepAdjustments | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}
    */
    readonly threshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
    */
    readonly dimensions?: ElastigroupAwsScalingDownPolicyDimensions[] | cdktf.IResolvable;
    /**
    * step_adjustments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
    */
    readonly stepAdjustments?: ElastigroupAwsScalingDownPolicyStepAdjustments[] | cdktf.IResolvable;
}
export declare function elastigroupAwsScalingDownPolicyToTerraform(struct?: ElastigroupAwsScalingDownPolicy | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_at_end_of_billing_hour ElastigroupAws#terminate_at_end_of_billing_hour}
    */
    readonly terminateAtEndOfBillingHour?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#termination_policy ElastigroupAws#termination_policy}
    */
    readonly terminationPolicy?: string;
}
export declare function elastigroupAwsScalingStrategyToTerraform(struct?: ElastigroupAwsScalingStrategy | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingTargetPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value?: string;
}
export declare function elastigroupAwsScalingTargetPolicyDimensionsToTerraform(struct?: ElastigroupAwsScalingTargetPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingTargetPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity_per_scale ElastigroupAws#max_capacity_per_scale}
    */
    readonly maxCapacityPerScale?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#predictive_mode ElastigroupAws#predictive_mode}
    */
    readonly predictiveMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}
    */
    readonly target: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
    */
    readonly dimensions?: ElastigroupAwsScalingTargetPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAwsScalingTargetPolicyToTerraform(struct?: ElastigroupAwsScalingTargetPolicy | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value?: string;
}
export declare function elastigroupAwsScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupAwsScalingUpPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingUpPolicyStepAdjustmentsAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}
    */
    readonly type: string;
}
export declare function elastigroupAwsScalingUpPolicyStepAdjustmentsActionToTerraform(struct?: ElastigroupAwsScalingUpPolicyStepAdjustmentsActionOutputReference | ElastigroupAwsScalingUpPolicyStepAdjustmentsAction): any;
export declare class ElastigroupAwsScalingUpPolicyStepAdjustmentsActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsScalingUpPolicyStepAdjustmentsAction | undefined;
    set internalValue(value: ElastigroupAwsScalingUpPolicyStepAdjustmentsAction | undefined);
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ElastigroupAwsScalingUpPolicyStepAdjustments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}
    */
    readonly threshold: number;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
    */
    readonly action: ElastigroupAwsScalingUpPolicyStepAdjustmentsAction;
}
export declare function elastigroupAwsScalingUpPolicyStepAdjustmentsToTerraform(struct?: ElastigroupAwsScalingUpPolicyStepAdjustments | cdktf.IResolvable): any;
export interface ElastigroupAwsScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}
    */
    readonly threshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
    */
    readonly dimensions?: ElastigroupAwsScalingUpPolicyDimensions[] | cdktf.IResolvable;
    /**
    * step_adjustments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
    */
    readonly stepAdjustments?: ElastigroupAwsScalingUpPolicyStepAdjustments[] | cdktf.IResolvable;
}
export declare function elastigroupAwsScalingUpPolicyToTerraform(struct?: ElastigroupAwsScalingUpPolicy | cdktf.IResolvable): any;
export interface ElastigroupAwsScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment_percentage ElastigroupAws#adjustment_percentage}
    */
    readonly adjustmentPercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}
    */
    readonly batchSizePercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cron_expression ElastigroupAws#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#frequency ElastigroupAws#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}
    */
    readonly gracePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity ElastigroupAws#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_capacity ElastigroupAws#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_max_capacity ElastigroupAws#scale_max_capacity}
    */
    readonly scaleMaxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_min_capacity ElastigroupAws#scale_min_capacity}
    */
    readonly scaleMinCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_target_capacity ElastigroupAws#scale_target_capacity}
    */
    readonly scaleTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#start_time ElastigroupAws#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_capacity ElastigroupAws#target_capacity}
    */
    readonly targetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#task_type ElastigroupAws#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupAwsScheduledTaskToTerraform(struct?: ElastigroupAwsScheduledTask | cdktf.IResolvable): any;
export interface ElastigroupAwsSignal {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#timeout ElastigroupAws#timeout}
    */
    readonly timeout?: number;
}
export declare function elastigroupAwsSignalToTerraform(struct?: ElastigroupAwsSignal | cdktf.IResolvable): any;
export interface ElastigroupAwsStatefulDeallocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_images ElastigroupAws#should_delete_images}
    */
    readonly shouldDeleteImages?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_network_interfaces ElastigroupAws#should_delete_network_interfaces}
    */
    readonly shouldDeleteNetworkInterfaces?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_snapshots ElastigroupAws#should_delete_snapshots}
    */
    readonly shouldDeleteSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_volumes ElastigroupAws#should_delete_volumes}
    */
    readonly shouldDeleteVolumes?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsStatefulDeallocationToTerraform(struct?: ElastigroupAwsStatefulDeallocationOutputReference | ElastigroupAwsStatefulDeallocation): any;
export declare class ElastigroupAwsStatefulDeallocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsStatefulDeallocation | undefined;
    set internalValue(value: ElastigroupAwsStatefulDeallocation | undefined);
    private _shouldDeleteImages?;
    get shouldDeleteImages(): boolean | cdktf.IResolvable;
    set shouldDeleteImages(value: boolean | cdktf.IResolvable);
    resetShouldDeleteImages(): void;
    get shouldDeleteImagesInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldDeleteNetworkInterfaces?;
    get shouldDeleteNetworkInterfaces(): boolean | cdktf.IResolvable;
    set shouldDeleteNetworkInterfaces(value: boolean | cdktf.IResolvable);
    resetShouldDeleteNetworkInterfaces(): void;
    get shouldDeleteNetworkInterfacesInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldDeleteSnapshots?;
    get shouldDeleteSnapshots(): boolean | cdktf.IResolvable;
    set shouldDeleteSnapshots(value: boolean | cdktf.IResolvable);
    resetShouldDeleteSnapshots(): void;
    get shouldDeleteSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldDeleteVolumes?;
    get shouldDeleteVolumes(): boolean | cdktf.IResolvable;
    set shouldDeleteVolumes(value: boolean | cdktf.IResolvable);
    resetShouldDeleteVolumes(): void;
    get shouldDeleteVolumesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ElastigroupAwsStatefulInstanceAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_id ElastigroupAws#stateful_instance_id}
    */
    readonly statefulInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}
    */
    readonly type: string;
}
export declare function elastigroupAwsStatefulInstanceActionToTerraform(struct?: ElastigroupAwsStatefulInstanceAction | cdktf.IResolvable): any;
export interface ElastigroupAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}
    */
    readonly value?: string;
}
export declare function elastigroupAwsTagsToTerraform(struct?: ElastigroupAwsTags | cdktf.IResolvable): any;
export interface ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_num ElastigroupAws#batch_num}
    */
    readonly batchNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_decrement_target_capacity ElastigroupAws#should_decrement_target_capacity}
    */
    readonly shouldDecrementTargetCapacity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_handle_all_batches ElastigroupAws#should_handle_all_batches}
    */
    readonly shouldHandleAllBatches?: boolean | cdktf.IResolvable;
}
export declare function elastigroupAwsUpdatePolicyRollConfigStrategyOnFailureToTerraform(struct?: ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference | ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure): any;
export declare class ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure | undefined;
    set internalValue(value: ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _batchNum?;
    get batchNum(): number;
    set batchNum(value: number);
    resetBatchNum(): void;
    get batchNumInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _shouldDecrementTargetCapacity?;
    get shouldDecrementTargetCapacity(): boolean | cdktf.IResolvable;
    set shouldDecrementTargetCapacity(value: boolean | cdktf.IResolvable);
    resetShouldDecrementTargetCapacity(): void;
    get shouldDecrementTargetCapacityInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldHandleAllBatches?;
    get shouldHandleAllBatches(): boolean | cdktf.IResolvable;
    set shouldHandleAllBatches(value: boolean | cdktf.IResolvable);
    resetShouldHandleAllBatches(): void;
    get shouldHandleAllBatchesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ElastigroupAwsUpdatePolicyRollConfigStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_min_healthy_percentage ElastigroupAws#batch_min_healthy_percentage}
    */
    readonly batchMinHealthyPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}
    */
    readonly shouldDrainInstances?: boolean | cdktf.IResolvable;
    /**
    * on_failure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#on_failure ElastigroupAws#on_failure}
    */
    readonly onFailure?: ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure;
}
export declare function elastigroupAwsUpdatePolicyRollConfigStrategyToTerraform(struct?: ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference | ElastigroupAwsUpdatePolicyRollConfigStrategy): any;
export declare class ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsUpdatePolicyRollConfigStrategy | undefined;
    set internalValue(value: ElastigroupAwsUpdatePolicyRollConfigStrategy | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _batchMinHealthyPercentage?;
    get batchMinHealthyPercentage(): number;
    set batchMinHealthyPercentage(value: number);
    resetBatchMinHealthyPercentage(): void;
    get batchMinHealthyPercentageInput(): number | undefined;
    private _shouldDrainInstances?;
    get shouldDrainInstances(): boolean | cdktf.IResolvable;
    set shouldDrainInstances(value: boolean | cdktf.IResolvable);
    resetShouldDrainInstances(): void;
    get shouldDrainInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _onFailure;
    get onFailure(): ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference;
    putOnFailure(value: ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure): void;
    resetOnFailure(): void;
    get onFailureInput(): ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure | undefined;
}
export interface ElastigroupAwsUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_percentage ElastigroupAws#wait_for_roll_percentage}
    */
    readonly waitForRollPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_timeout ElastigroupAws#wait_for_roll_timeout}
    */
    readonly waitForRollTimeout?: number;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
    */
    readonly strategy?: ElastigroupAwsUpdatePolicyRollConfigStrategy;
}
export declare function elastigroupAwsUpdatePolicyRollConfigToTerraform(struct?: ElastigroupAwsUpdatePolicyRollConfigOutputReference | ElastigroupAwsUpdatePolicyRollConfig): any;
export declare class ElastigroupAwsUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsUpdatePolicyRollConfig | undefined;
    set internalValue(value: ElastigroupAwsUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _waitForRollPercentage?;
    get waitForRollPercentage(): number;
    set waitForRollPercentage(value: number);
    resetWaitForRollPercentage(): void;
    get waitForRollPercentageInput(): number | undefined;
    private _waitForRollTimeout?;
    get waitForRollTimeout(): number;
    set waitForRollTimeout(value: number);
    resetWaitForRollTimeout(): void;
    get waitForRollTimeoutInput(): number | undefined;
    private _strategy;
    get strategy(): ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference;
    putStrategy(value: ElastigroupAwsUpdatePolicyRollConfigStrategy): void;
    resetStrategy(): void;
    get strategyInput(): ElastigroupAwsUpdatePolicyRollConfigStrategy | undefined;
}
export interface ElastigroupAwsUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#auto_apply_tags ElastigroupAws#auto_apply_tags}
    */
    readonly autoApplyTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_resume_stateful ElastigroupAws#should_resume_stateful}
    */
    readonly shouldResumeStateful: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_roll ElastigroupAws#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#roll_config ElastigroupAws#roll_config}
    */
    readonly rollConfig?: ElastigroupAwsUpdatePolicyRollConfig;
}
export declare function elastigroupAwsUpdatePolicyToTerraform(struct?: ElastigroupAwsUpdatePolicyOutputReference | ElastigroupAwsUpdatePolicy): any;
export declare class ElastigroupAwsUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAwsUpdatePolicy | undefined;
    set internalValue(value: ElastigroupAwsUpdatePolicy | undefined);
    private _autoApplyTags?;
    get autoApplyTags(): boolean | cdktf.IResolvable;
    set autoApplyTags(value: boolean | cdktf.IResolvable);
    resetAutoApplyTags(): void;
    get autoApplyTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldResumeStateful?;
    get shouldResumeStateful(): boolean | cdktf.IResolvable;
    set shouldResumeStateful(value: boolean | cdktf.IResolvable);
    get shouldResumeStatefulInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): ElastigroupAwsUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: ElastigroupAwsUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): ElastigroupAwsUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws spotinst_elastigroup_aws}
*/
export declare class ElastigroupAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws spotinst_elastigroup_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAwsConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAwsConfig);
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _blockDevicesMode?;
    get blockDevicesMode(): string;
    set blockDevicesMode(value: string);
    resetBlockDevicesMode(): void;
    get blockDevicesModeInput(): string | undefined;
    private _capacityUnit?;
    get capacityUnit(): string;
    set capacityUnit(value: string);
    resetCapacityUnit(): void;
    get capacityUnitInput(): string | undefined;
    private _cpuCredits?;
    get cpuCredits(): string;
    set cpuCredits(value: string);
    resetCpuCredits(): void;
    get cpuCreditsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _ebsOptimized?;
    get ebsOptimized(): boolean | cdktf.IResolvable;
    set ebsOptimized(value: boolean | cdktf.IResolvable);
    resetEbsOptimized(): void;
    get ebsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticIps?;
    get elasticIps(): string[];
    set elasticIps(value: string[]);
    resetElasticIps(): void;
    get elasticIpsInput(): string[] | undefined;
    private _elasticLoadBalancers?;
    get elasticLoadBalancers(): string[];
    set elasticLoadBalancers(value: string[]);
    resetElasticLoadBalancers(): void;
    get elasticLoadBalancersInput(): string[] | undefined;
    private _enableMonitoring?;
    get enableMonitoring(): boolean | cdktf.IResolvable;
    set enableMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableMonitoring(): void;
    get enableMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheckGracePeriod?;
    get healthCheckGracePeriod(): number;
    set healthCheckGracePeriod(value: number);
    resetHealthCheckGracePeriod(): void;
    get healthCheckGracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _healthCheckUnhealthyDurationBeforeReplacement?;
    get healthCheckUnhealthyDurationBeforeReplacement(): number;
    set healthCheckUnhealthyDurationBeforeReplacement(value: number);
    resetHealthCheckUnhealthyDurationBeforeReplacement(): void;
    get healthCheckUnhealthyDurationBeforeReplacementInput(): number | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _instanceTypesOndemand?;
    get instanceTypesOndemand(): string;
    set instanceTypesOndemand(value: string);
    get instanceTypesOndemandInput(): string | undefined;
    private _instanceTypesPreferredSpot?;
    get instanceTypesPreferredSpot(): string[];
    set instanceTypesPreferredSpot(value: string[]);
    resetInstanceTypesPreferredSpot(): void;
    get instanceTypesPreferredSpotInput(): string[] | undefined;
    private _instanceTypesSpot?;
    get instanceTypesSpot(): string[];
    set instanceTypesSpot(value: string[]);
    get instanceTypesSpotInput(): string[] | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _lifetimePeriod?;
    get lifetimePeriod(): string;
    set lifetimePeriod(value: string);
    resetLifetimePeriod(): void;
    get lifetimePeriodInput(): string | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _minimumInstanceLifetime?;
    get minimumInstanceLifetime(): number;
    set minimumInstanceLifetime(value: number);
    resetMinimumInstanceLifetime(): void;
    get minimumInstanceLifetimeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ondemandCount?;
    get ondemandCount(): number;
    set ondemandCount(value: number);
    resetOndemandCount(): void;
    get ondemandCountInput(): number | undefined;
    private _orientation?;
    get orientation(): string;
    set orientation(value: string);
    get orientationInput(): string | undefined;
    private _persistBlockDevices?;
    get persistBlockDevices(): boolean | cdktf.IResolvable;
    set persistBlockDevices(value: boolean | cdktf.IResolvable);
    resetPersistBlockDevices(): void;
    get persistBlockDevicesInput(): boolean | cdktf.IResolvable | undefined;
    private _persistPrivateIp?;
    get persistPrivateIp(): boolean | cdktf.IResolvable;
    set persistPrivateIp(value: boolean | cdktf.IResolvable);
    resetPersistPrivateIp(): void;
    get persistPrivateIpInput(): boolean | cdktf.IResolvable | undefined;
    private _persistRootDevice?;
    get persistRootDevice(): boolean | cdktf.IResolvable;
    set persistRootDevice(value: boolean | cdktf.IResolvable);
    resetPersistRootDevice(): void;
    get persistRootDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _placementTenancy?;
    get placementTenancy(): string;
    set placementTenancy(value: string);
    resetPlacementTenancy(): void;
    get placementTenancyInput(): string | undefined;
    private _preferredAvailabilityZones?;
    get preferredAvailabilityZones(): string[];
    set preferredAvailabilityZones(value: string[]);
    resetPreferredAvailabilityZones(): void;
    get preferredAvailabilityZonesInput(): string[] | undefined;
    private _privateIps?;
    get privateIps(): string[];
    set privateIps(value: string[]);
    resetPrivateIps(): void;
    get privateIpsInput(): string[] | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    get securityGroupsInput(): string[] | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    resetSubnetIds(): void;
    get subnetIdsInput(): string[] | undefined;
    private _targetGroupArns?;
    get targetGroupArns(): string[];
    set targetGroupArns(value: string[]);
    resetTargetGroupArns(): void;
    get targetGroupArnsInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _utilizeCommitments?;
    get utilizeCommitments(): boolean | cdktf.IResolvable;
    set utilizeCommitments(value: boolean | cdktf.IResolvable);
    resetUtilizeCommitments(): void;
    get utilizeCommitmentsInput(): boolean | cdktf.IResolvable | undefined;
    private _utilizeReservedInstances?;
    get utilizeReservedInstances(): boolean | cdktf.IResolvable;
    set utilizeReservedInstances(value: boolean | cdktf.IResolvable);
    resetUtilizeReservedInstances(): void;
    get utilizeReservedInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForCapacity?;
    get waitForCapacity(): number;
    set waitForCapacity(value: number);
    resetWaitForCapacity(): void;
    get waitForCapacityInput(): number | undefined;
    private _waitForCapacityTimeout?;
    get waitForCapacityTimeout(): number;
    set waitForCapacityTimeout(value: number);
    resetWaitForCapacityTimeout(): void;
    get waitForCapacityTimeoutInput(): number | undefined;
    private _cpuOptions;
    get cpuOptions(): ElastigroupAwsCpuOptionsOutputReference;
    putCpuOptions(value: ElastigroupAwsCpuOptions): void;
    resetCpuOptions(): void;
    get cpuOptionsInput(): ElastigroupAwsCpuOptions | undefined;
    private _ebsBlockDevice?;
    get ebsBlockDevice(): ElastigroupAwsEbsBlockDevice[] | cdktf.IResolvable;
    set ebsBlockDevice(value: ElastigroupAwsEbsBlockDevice[] | cdktf.IResolvable);
    resetEbsBlockDevice(): void;
    get ebsBlockDeviceInput(): cdktf.IResolvable | ElastigroupAwsEbsBlockDevice[] | undefined;
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): ElastigroupAwsEphemeralBlockDevice[] | cdktf.IResolvable;
    set ephemeralBlockDevice(value: ElastigroupAwsEphemeralBlockDevice[] | cdktf.IResolvable);
    resetEphemeralBlockDevice(): void;
    get ephemeralBlockDeviceInput(): cdktf.IResolvable | ElastigroupAwsEphemeralBlockDevice[] | undefined;
    private _instanceTypesWeights?;
    get instanceTypesWeights(): ElastigroupAwsInstanceTypesWeights[] | cdktf.IResolvable;
    set instanceTypesWeights(value: ElastigroupAwsInstanceTypesWeights[] | cdktf.IResolvable);
    resetInstanceTypesWeights(): void;
    get instanceTypesWeightsInput(): cdktf.IResolvable | ElastigroupAwsInstanceTypesWeights[] | undefined;
    private _integrationBeanstalk;
    get integrationBeanstalk(): ElastigroupAwsIntegrationBeanstalkOutputReference;
    putIntegrationBeanstalk(value: ElastigroupAwsIntegrationBeanstalk): void;
    resetIntegrationBeanstalk(): void;
    get integrationBeanstalkInput(): ElastigroupAwsIntegrationBeanstalk | undefined;
    private _integrationCodedeploy;
    get integrationCodedeploy(): ElastigroupAwsIntegrationCodedeployOutputReference;
    putIntegrationCodedeploy(value: ElastigroupAwsIntegrationCodedeploy): void;
    resetIntegrationCodedeploy(): void;
    get integrationCodedeployInput(): ElastigroupAwsIntegrationCodedeploy | undefined;
    private _integrationDockerSwarm;
    get integrationDockerSwarm(): ElastigroupAwsIntegrationDockerSwarmOutputReference;
    putIntegrationDockerSwarm(value: ElastigroupAwsIntegrationDockerSwarm): void;
    resetIntegrationDockerSwarm(): void;
    get integrationDockerSwarmInput(): ElastigroupAwsIntegrationDockerSwarm | undefined;
    private _integrationEcs;
    get integrationEcs(): ElastigroupAwsIntegrationEcsOutputReference;
    putIntegrationEcs(value: ElastigroupAwsIntegrationEcs): void;
    resetIntegrationEcs(): void;
    get integrationEcsInput(): ElastigroupAwsIntegrationEcs | undefined;
    private _integrationGitlab;
    get integrationGitlab(): ElastigroupAwsIntegrationGitlabOutputReference;
    putIntegrationGitlab(value: ElastigroupAwsIntegrationGitlab): void;
    resetIntegrationGitlab(): void;
    get integrationGitlabInput(): ElastigroupAwsIntegrationGitlab | undefined;
    private _integrationKubernetes;
    get integrationKubernetes(): ElastigroupAwsIntegrationKubernetesOutputReference;
    putIntegrationKubernetes(value: ElastigroupAwsIntegrationKubernetes): void;
    resetIntegrationKubernetes(): void;
    get integrationKubernetesInput(): ElastigroupAwsIntegrationKubernetes | undefined;
    private _integrationMesosphere;
    get integrationMesosphere(): ElastigroupAwsIntegrationMesosphereOutputReference;
    putIntegrationMesosphere(value: ElastigroupAwsIntegrationMesosphere): void;
    resetIntegrationMesosphere(): void;
    get integrationMesosphereInput(): ElastigroupAwsIntegrationMesosphere | undefined;
    private _integrationMultaiRuntime;
    get integrationMultaiRuntime(): ElastigroupAwsIntegrationMultaiRuntimeOutputReference;
    putIntegrationMultaiRuntime(value: ElastigroupAwsIntegrationMultaiRuntime): void;
    resetIntegrationMultaiRuntime(): void;
    get integrationMultaiRuntimeInput(): ElastigroupAwsIntegrationMultaiRuntime | undefined;
    private _integrationNomad;
    get integrationNomad(): ElastigroupAwsIntegrationNomadOutputReference;
    putIntegrationNomad(value: ElastigroupAwsIntegrationNomad): void;
    resetIntegrationNomad(): void;
    get integrationNomadInput(): ElastigroupAwsIntegrationNomad | undefined;
    private _integrationRancher;
    get integrationRancher(): ElastigroupAwsIntegrationRancherOutputReference;
    putIntegrationRancher(value: ElastigroupAwsIntegrationRancher): void;
    resetIntegrationRancher(): void;
    get integrationRancherInput(): ElastigroupAwsIntegrationRancher | undefined;
    private _integrationRoute53;
    get integrationRoute53(): ElastigroupAwsIntegrationRoute53OutputReference;
    putIntegrationRoute53(value: ElastigroupAwsIntegrationRoute53): void;
    resetIntegrationRoute53(): void;
    get integrationRoute53Input(): ElastigroupAwsIntegrationRoute53 | undefined;
    private _itf?;
    get itf(): ElastigroupAwsItf[] | cdktf.IResolvable;
    set itf(value: ElastigroupAwsItf[] | cdktf.IResolvable);
    resetItf(): void;
    get itfInput(): cdktf.IResolvable | ElastigroupAwsItf[] | undefined;
    private _metadataOptions;
    get metadataOptions(): ElastigroupAwsMetadataOptionsOutputReference;
    putMetadataOptions(value: ElastigroupAwsMetadataOptions): void;
    resetMetadataOptions(): void;
    get metadataOptionsInput(): ElastigroupAwsMetadataOptions | undefined;
    private _multaiTargetSets?;
    get multaiTargetSets(): ElastigroupAwsMultaiTargetSets[] | cdktf.IResolvable;
    set multaiTargetSets(value: ElastigroupAwsMultaiTargetSets[] | cdktf.IResolvable);
    resetMultaiTargetSets(): void;
    get multaiTargetSetsInput(): cdktf.IResolvable | ElastigroupAwsMultaiTargetSets[] | undefined;
    private _multipleMetrics;
    get multipleMetrics(): ElastigroupAwsMultipleMetricsOutputReference;
    putMultipleMetrics(value: ElastigroupAwsMultipleMetrics): void;
    resetMultipleMetrics(): void;
    get multipleMetricsInput(): ElastigroupAwsMultipleMetrics | undefined;
    private _networkInterface?;
    get networkInterface(): ElastigroupAwsNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: ElastigroupAwsNetworkInterface[] | cdktf.IResolvable);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ElastigroupAwsNetworkInterface[] | undefined;
    private _resourceTagSpecification?;
    get resourceTagSpecification(): ElastigroupAwsResourceTagSpecification[] | cdktf.IResolvable;
    set resourceTagSpecification(value: ElastigroupAwsResourceTagSpecification[] | cdktf.IResolvable);
    resetResourceTagSpecification(): void;
    get resourceTagSpecificationInput(): cdktf.IResolvable | ElastigroupAwsResourceTagSpecification[] | undefined;
    private _revertToSpot;
    get revertToSpot(): ElastigroupAwsRevertToSpotOutputReference;
    putRevertToSpot(value: ElastigroupAwsRevertToSpot): void;
    resetRevertToSpot(): void;
    get revertToSpotInput(): ElastigroupAwsRevertToSpot | undefined;
    private _scalingDownPolicy?;
    get scalingDownPolicy(): ElastigroupAwsScalingDownPolicy[] | cdktf.IResolvable;
    set scalingDownPolicy(value: ElastigroupAwsScalingDownPolicy[] | cdktf.IResolvable);
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupAwsScalingDownPolicy[] | undefined;
    private _scalingStrategy?;
    get scalingStrategy(): ElastigroupAwsScalingStrategy[] | cdktf.IResolvable;
    set scalingStrategy(value: ElastigroupAwsScalingStrategy[] | cdktf.IResolvable);
    resetScalingStrategy(): void;
    get scalingStrategyInput(): cdktf.IResolvable | ElastigroupAwsScalingStrategy[] | undefined;
    private _scalingTargetPolicy?;
    get scalingTargetPolicy(): ElastigroupAwsScalingTargetPolicy[] | cdktf.IResolvable;
    set scalingTargetPolicy(value: ElastigroupAwsScalingTargetPolicy[] | cdktf.IResolvable);
    resetScalingTargetPolicy(): void;
    get scalingTargetPolicyInput(): cdktf.IResolvable | ElastigroupAwsScalingTargetPolicy[] | undefined;
    private _scalingUpPolicy?;
    get scalingUpPolicy(): ElastigroupAwsScalingUpPolicy[] | cdktf.IResolvable;
    set scalingUpPolicy(value: ElastigroupAwsScalingUpPolicy[] | cdktf.IResolvable);
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupAwsScalingUpPolicy[] | undefined;
    private _scheduledTask?;
    get scheduledTask(): ElastigroupAwsScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: ElastigroupAwsScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupAwsScheduledTask[] | undefined;
    private _signal?;
    get signal(): ElastigroupAwsSignal[] | cdktf.IResolvable;
    set signal(value: ElastigroupAwsSignal[] | cdktf.IResolvable);
    resetSignal(): void;
    get signalInput(): cdktf.IResolvable | ElastigroupAwsSignal[] | undefined;
    private _statefulDeallocation;
    get statefulDeallocation(): ElastigroupAwsStatefulDeallocationOutputReference;
    putStatefulDeallocation(value: ElastigroupAwsStatefulDeallocation): void;
    resetStatefulDeallocation(): void;
    get statefulDeallocationInput(): ElastigroupAwsStatefulDeallocation | undefined;
    private _statefulInstanceAction?;
    get statefulInstanceAction(): ElastigroupAwsStatefulInstanceAction[] | cdktf.IResolvable;
    set statefulInstanceAction(value: ElastigroupAwsStatefulInstanceAction[] | cdktf.IResolvable);
    resetStatefulInstanceAction(): void;
    get statefulInstanceActionInput(): cdktf.IResolvable | ElastigroupAwsStatefulInstanceAction[] | undefined;
    private _tags?;
    get tags(): ElastigroupAwsTags[] | cdktf.IResolvable;
    set tags(value: ElastigroupAwsTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | ElastigroupAwsTags[] | undefined;
    private _updatePolicy;
    get updatePolicy(): ElastigroupAwsUpdatePolicyOutputReference;
    putUpdatePolicy(value: ElastigroupAwsUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): ElastigroupAwsUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
