import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom_data ElastigroupAzure#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#desired_capacity ElastigroupAzure#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_sizes ElastigroupAzure#low_priority_sizes}
    */
    readonly lowPrioritySizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_size ElastigroupAzure#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_size ElastigroupAzure#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_sizes ElastigroupAzure#od_sizes}
    */
    readonly odSizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#product ElastigroupAzure#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#region ElastigroupAzure#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#shutdown_script ElastigroupAzure#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_data ElastigroupAzure#user_data}
    */
    readonly userData?: string;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check ElastigroupAzure#health_check}
    */
    readonly healthCheck?: ElastigroupAzureHealthCheck;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image ElastigroupAzure#image}
    */
    readonly image?: ElastigroupAzureImage[] | cdktf.IResolvable;
    /**
    * integration_kubernetes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_kubernetes ElastigroupAzure#integration_kubernetes}
    */
    readonly integrationKubernetes?: ElastigroupAzureIntegrationKubernetes;
    /**
    * integration_multai_runtime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_multai_runtime ElastigroupAzure#integration_multai_runtime}
    */
    readonly integrationMultaiRuntime?: ElastigroupAzureIntegrationMultaiRuntime;
    /**
    * load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#load_balancers ElastigroupAzure#load_balancers}
    */
    readonly loadBalancers?: ElastigroupAzureLoadBalancers[] | cdktf.IResolvable;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#login ElastigroupAzure#login}
    */
    readonly login?: ElastigroupAzureLogin;
    /**
    * managed_service_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#managed_service_identities ElastigroupAzure#managed_service_identities}
    */
    readonly managedServiceIdentities?: ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#network ElastigroupAzure#network}
    */
    readonly network: ElastigroupAzureNetwork;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_down_policy ElastigroupAzure#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_up_policy ElastigroupAzure#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scheduled_task ElastigroupAzure#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupAzureScheduledTask[] | cdktf.IResolvable;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#strategy ElastigroupAzure#strategy}
    */
    readonly strategy: ElastigroupAzureStrategy;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#update_policy ElastigroupAzure#update_policy}
    */
    readonly updatePolicy?: ElastigroupAzureUpdatePolicy;
}
export interface ElastigroupAzureHealthCheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_healing ElastigroupAzure#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}
    */
    readonly healthCheckType: string;
}
export declare function elastigroupAzureHealthCheckToTerraform(struct?: ElastigroupAzureHealthCheckOutputReference | ElastigroupAzureHealthCheck): any;
export declare class ElastigroupAzureHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureHealthCheck | undefined;
    set internalValue(value: ElastigroupAzureHealthCheck | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    get healthCheckTypeInput(): string | undefined;
}
export interface ElastigroupAzureImageCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image_name ElastigroupAzure#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function elastigroupAzureImageCustomToTerraform(struct?: ElastigroupAzureImageCustom | cdktf.IResolvable): any;
export interface ElastigroupAzureImageMarketplace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#offer ElastigroupAzure#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#publisher ElastigroupAzure#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#sku ElastigroupAzure#sku}
    */
    readonly sku: string;
}
export declare function elastigroupAzureImageMarketplaceToTerraform(struct?: ElastigroupAzureImageMarketplace | cdktf.IResolvable): any;
export interface ElastigroupAzureImage {
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom ElastigroupAzure#custom}
    */
    readonly custom?: ElastigroupAzureImageCustom[] | cdktf.IResolvable;
    /**
    * marketplace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#marketplace ElastigroupAzure#marketplace}
    */
    readonly marketplace?: ElastigroupAzureImageMarketplace[] | cdktf.IResolvable;
}
export declare function elastigroupAzureImageToTerraform(struct?: ElastigroupAzureImage | cdktf.IResolvable): any;
export interface ElastigroupAzureIntegrationKubernetes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cluster_identifier ElastigroupAzure#cluster_identifier}
    */
    readonly clusterIdentifier: string;
}
export declare function elastigroupAzureIntegrationKubernetesToTerraform(struct?: ElastigroupAzureIntegrationKubernetesOutputReference | ElastigroupAzureIntegrationKubernetes): any;
export declare class ElastigroupAzureIntegrationKubernetesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureIntegrationKubernetes | undefined;
    set internalValue(value: ElastigroupAzureIntegrationKubernetes | undefined);
    private _clusterIdentifier?;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get clusterIdentifierInput(): string | undefined;
}
export interface ElastigroupAzureIntegrationMultaiRuntime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#deployment_id ElastigroupAzure#deployment_id}
    */
    readonly deploymentId: string;
}
export declare function elastigroupAzureIntegrationMultaiRuntimeToTerraform(struct?: ElastigroupAzureIntegrationMultaiRuntimeOutputReference | ElastigroupAzureIntegrationMultaiRuntime): any;
export declare class ElastigroupAzureIntegrationMultaiRuntimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureIntegrationMultaiRuntime | undefined;
    set internalValue(value: ElastigroupAzureIntegrationMultaiRuntime | undefined);
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
}
export interface ElastigroupAzureLoadBalancers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_weight ElastigroupAzure#auto_weight}
    */
    readonly autoWeight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#balancer_id ElastigroupAzure#balancer_id}
    */
    readonly balancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target_set_id ElastigroupAzure#target_set_id}
    */
    readonly targetSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#type ElastigroupAzure#type}
    */
    readonly type: string;
}
export declare function elastigroupAzureLoadBalancersToTerraform(struct?: ElastigroupAzureLoadBalancers | cdktf.IResolvable): any;
export interface ElastigroupAzureLogin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#password ElastigroupAzure#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#ssh_public_key ElastigroupAzure#ssh_public_key}
    */
    readonly sshPublicKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_name ElastigroupAzure#user_name}
    */
    readonly userName: string;
}
export declare function elastigroupAzureLoginToTerraform(struct?: ElastigroupAzureLoginOutputReference | ElastigroupAzureLogin): any;
export declare class ElastigroupAzureLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureLogin | undefined;
    set internalValue(value: ElastigroupAzureLogin | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    resetSshPublicKey(): void;
    get sshPublicKeyInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
}
export interface ElastigroupAzureManagedServiceIdentities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function elastigroupAzureManagedServiceIdentitiesToTerraform(struct?: ElastigroupAzureManagedServiceIdentities | cdktf.IResolvable): any;
export interface ElastigroupAzureNetworkAdditionalIpConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#private_ip_version ElastigroupAzure#private_ip_version}
    */
    readonly privateIpVersion?: string;
}
export declare function elastigroupAzureNetworkAdditionalIpConfigsToTerraform(struct?: ElastigroupAzureNetworkAdditionalIpConfigs | cdktf.IResolvable): any;
export interface ElastigroupAzureNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#assign_public_ip ElastigroupAzure#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#subnet_name ElastigroupAzure#subnet_name}
    */
    readonly subnetName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#virtual_network_name ElastigroupAzure#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * additional_ip_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#additional_ip_configs ElastigroupAzure#additional_ip_configs}
    */
    readonly additionalIpConfigs?: ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable;
}
export declare function elastigroupAzureNetworkToTerraform(struct?: ElastigroupAzureNetworkOutputReference | ElastigroupAzureNetwork): any;
export declare class ElastigroupAzureNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureNetwork | undefined;
    set internalValue(value: ElastigroupAzureNetwork | undefined);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    get subnetNameInput(): string | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _additionalIpConfigs?;
    get additionalIpConfigs(): ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable;
    set additionalIpConfigs(value: ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable);
    resetAdditionalIpConfigs(): void;
    get additionalIpConfigsInput(): cdktf.IResolvable | ElastigroupAzureNetworkAdditionalIpConfigs[] | undefined;
}
export interface ElastigroupAzureScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}
    */
    readonly value?: string;
}
export declare function elastigroupAzureScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupAzureScalingDownPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupAzureScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
    */
    readonly dimensions?: ElastigroupAzureScalingDownPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAzureScalingDownPolicyToTerraform(struct?: ElastigroupAzureScalingDownPolicy | cdktf.IResolvable): any;
export interface ElastigroupAzureScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}
    */
    readonly value?: string;
}
export declare function elastigroupAzureScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupAzureScalingUpPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupAzureScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
    */
    readonly dimensions?: ElastigroupAzureScalingUpPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAzureScalingUpPolicyToTerraform(struct?: ElastigroupAzureScalingUpPolicy | cdktf.IResolvable): any;
export interface ElastigroupAzureScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment_percentage ElastigroupAzure#adjustment_percentage}
    */
    readonly adjustmentPercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}
    */
    readonly batchSizePercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cron_expression ElastigroupAzure#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#is_enabled ElastigroupAzure#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_max_capacity ElastigroupAzure#scale_max_capacity}
    */
    readonly scaleMaxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_min_capacity ElastigroupAzure#scale_min_capacity}
    */
    readonly scaleMinCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_target_capacity ElastigroupAzure#scale_target_capacity}
    */
    readonly scaleTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#task_type ElastigroupAzure#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupAzureScheduledTaskToTerraform(struct?: ElastigroupAzureScheduledTask | cdktf.IResolvable): any;
export interface ElastigroupAzureStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#draining_timeout ElastigroupAzure#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_percentage ElastigroupAzure#low_priority_percentage}
    */
    readonly lowPriorityPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_count ElastigroupAzure#od_count}
    */
    readonly odCount?: number;
}
export declare function elastigroupAzureStrategyToTerraform(struct?: ElastigroupAzureStrategyOutputReference | ElastigroupAzureStrategy): any;
export declare class ElastigroupAzureStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureStrategy | undefined;
    set internalValue(value: ElastigroupAzureStrategy | undefined);
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _lowPriorityPercentage?;
    get lowPriorityPercentage(): number;
    set lowPriorityPercentage(value: number);
    resetLowPriorityPercentage(): void;
    get lowPriorityPercentageInput(): number | undefined;
    private _odCount?;
    get odCount(): number;
    set odCount(value: number);
    resetOdCount(): void;
    get odCountInput(): number | undefined;
}
export interface ElastigroupAzureUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}
    */
    readonly healthCheckType?: string;
}
export declare function elastigroupAzureUpdatePolicyRollConfigToTerraform(struct?: ElastigroupAzureUpdatePolicyRollConfigOutputReference | ElastigroupAzureUpdatePolicyRollConfig): any;
export declare class ElastigroupAzureUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureUpdatePolicyRollConfig | undefined;
    set internalValue(value: ElastigroupAzureUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
}
export interface ElastigroupAzureUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#should_roll ElastigroupAzure#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#roll_config ElastigroupAzure#roll_config}
    */
    readonly rollConfig?: ElastigroupAzureUpdatePolicyRollConfig;
}
export declare function elastigroupAzureUpdatePolicyToTerraform(struct?: ElastigroupAzureUpdatePolicyOutputReference | ElastigroupAzureUpdatePolicy): any;
export declare class ElastigroupAzureUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureUpdatePolicy | undefined;
    set internalValue(value: ElastigroupAzureUpdatePolicy | undefined);
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): ElastigroupAzureUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: ElastigroupAzureUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): ElastigroupAzureUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure}
*/
export declare class ElastigroupAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_azure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAzureConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAzureConfig);
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    get id(): string;
    private _lowPrioritySizes?;
    get lowPrioritySizes(): string[];
    set lowPrioritySizes(value: string[]);
    get lowPrioritySizesInput(): string[] | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _odSizes?;
    get odSizes(): string[];
    set odSizes(value: string[]);
    get odSizesInput(): string[] | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _healthCheck;
    get healthCheck(): ElastigroupAzureHealthCheckOutputReference;
    putHealthCheck(value: ElastigroupAzureHealthCheck): void;
    resetHealthCheck(): void;
    get healthCheckInput(): ElastigroupAzureHealthCheck | undefined;
    private _image?;
    get image(): ElastigroupAzureImage[] | cdktf.IResolvable;
    set image(value: ElastigroupAzureImage[] | cdktf.IResolvable);
    resetImage(): void;
    get imageInput(): cdktf.IResolvable | ElastigroupAzureImage[] | undefined;
    private _integrationKubernetes;
    get integrationKubernetes(): ElastigroupAzureIntegrationKubernetesOutputReference;
    putIntegrationKubernetes(value: ElastigroupAzureIntegrationKubernetes): void;
    resetIntegrationKubernetes(): void;
    get integrationKubernetesInput(): ElastigroupAzureIntegrationKubernetes | undefined;
    private _integrationMultaiRuntime;
    get integrationMultaiRuntime(): ElastigroupAzureIntegrationMultaiRuntimeOutputReference;
    putIntegrationMultaiRuntime(value: ElastigroupAzureIntegrationMultaiRuntime): void;
    resetIntegrationMultaiRuntime(): void;
    get integrationMultaiRuntimeInput(): ElastigroupAzureIntegrationMultaiRuntime | undefined;
    private _loadBalancers?;
    get loadBalancers(): ElastigroupAzureLoadBalancers[] | cdktf.IResolvable;
    set loadBalancers(value: ElastigroupAzureLoadBalancers[] | cdktf.IResolvable);
    resetLoadBalancers(): void;
    get loadBalancersInput(): cdktf.IResolvable | ElastigroupAzureLoadBalancers[] | undefined;
    private _login;
    get login(): ElastigroupAzureLoginOutputReference;
    putLogin(value: ElastigroupAzureLogin): void;
    resetLogin(): void;
    get loginInput(): ElastigroupAzureLogin | undefined;
    private _managedServiceIdentities?;
    get managedServiceIdentities(): ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable;
    set managedServiceIdentities(value: ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable);
    resetManagedServiceIdentities(): void;
    get managedServiceIdentitiesInput(): cdktf.IResolvable | ElastigroupAzureManagedServiceIdentities[] | undefined;
    private _network;
    get network(): ElastigroupAzureNetworkOutputReference;
    putNetwork(value: ElastigroupAzureNetwork): void;
    get networkInput(): ElastigroupAzureNetwork | undefined;
    private _scalingDownPolicy?;
    get scalingDownPolicy(): ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable;
    set scalingDownPolicy(value: ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable);
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupAzureScalingDownPolicy[] | undefined;
    private _scalingUpPolicy?;
    get scalingUpPolicy(): ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable;
    set scalingUpPolicy(value: ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable);
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupAzureScalingUpPolicy[] | undefined;
    private _scheduledTask?;
    get scheduledTask(): ElastigroupAzureScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: ElastigroupAzureScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupAzureScheduledTask[] | undefined;
    private _strategy;
    get strategy(): ElastigroupAzureStrategyOutputReference;
    putStrategy(value: ElastigroupAzureStrategy): void;
    get strategyInput(): ElastigroupAzureStrategy | undefined;
    private _updatePolicy;
    get updatePolicy(): ElastigroupAzureUpdatePolicyOutputReference;
    putUpdatePolicy(value: ElastigroupAzureUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): ElastigroupAzureUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
