import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_healing ElastigroupGcp#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#availability_zones ElastigroupGcp#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#description ElastigroupGcp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#desired_capacity ElastigroupGcp#desired_capacity}
    */
    readonly desiredCapacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#draining_timeout ElastigroupGcp#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#fallback_to_ondemand ElastigroupGcp#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_grace_period ElastigroupGcp#health_check_grace_period}
    */
    readonly healthCheckGracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_type ElastigroupGcp#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_ondemand ElastigroupGcp#instance_types_ondemand}
    */
    readonly instanceTypesOndemand?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_preemptible ElastigroupGcp#instance_types_preemptible}
    */
    readonly instanceTypesPreemptible?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ip_forwarding ElastigroupGcp#ip_forwarding}
    */
    readonly ipForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#max_size ElastigroupGcp#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#min_size ElastigroupGcp#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ondemand_count ElastigroupGcp#ondemand_count}
    */
    readonly ondemandCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#preemptible_percentage ElastigroupGcp#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#provisioning_model ElastigroupGcp#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#service_account ElastigroupGcp#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#shutdown_script ElastigroupGcp#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#startup_script ElastigroupGcp#startup_script}
    */
    readonly startupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#tags ElastigroupGcp#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unhealthy_duration ElastigroupGcp#unhealthy_duration}
    */
    readonly unhealthyDuration?: number;
    /**
    * backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#backend_services ElastigroupGcp#backend_services}
    */
    readonly backendServices?: ElastigroupGcpBackendServices[] | cdktf.IResolvable;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk ElastigroupGcp#disk}
    */
    readonly disk?: ElastigroupGcpDisk[] | cdktf.IResolvable;
    /**
    * gpu block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#gpu ElastigroupGcp#gpu}
    */
    readonly gpu?: ElastigroupGcpGpu[] | cdktf.IResolvable;
    /**
    * instance_types_custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_custom ElastigroupGcp#instance_types_custom}
    */
    readonly instanceTypesCustom?: ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable;
    /**
    * integration_docker_swarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_docker_swarm ElastigroupGcp#integration_docker_swarm}
    */
    readonly integrationDockerSwarm?: ElastigroupGcpIntegrationDockerSwarm;
    /**
    * integration_gke block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_gke ElastigroupGcp#integration_gke}
    */
    readonly integrationGke?: ElastigroupGcpIntegrationGke;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#labels ElastigroupGcp#labels}
    */
    readonly labels?: ElastigroupGcpLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metadata ElastigroupGcp#metadata}
    */
    readonly metadata?: ElastigroupGcpMetadata[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#network_interface ElastigroupGcp#network_interface}
    */
    readonly networkInterface?: ElastigroupGcpNetworkInterface[] | cdktf.IResolvable;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_down_policy ElastigroupGcp#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_up_policy ElastigroupGcp#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scheduled_task ElastigroupGcp#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupGcpScheduledTask[] | cdktf.IResolvable;
    /**
    * subnets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnets ElastigroupGcp#subnets}
    */
    readonly subnets?: ElastigroupGcpSubnets[] | cdktf.IResolvable;
}
export interface ElastigroupGcpBackendServicesNamedPorts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ports ElastigroupGcp#ports}
    */
    readonly ports: string[];
}
export declare function elastigroupGcpBackendServicesNamedPortsToTerraform(struct?: ElastigroupGcpBackendServicesNamedPorts | cdktf.IResolvable): any;
export interface ElastigroupGcpBackendServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#location_type ElastigroupGcp#location_type}
    */
    readonly locationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scheme ElastigroupGcp#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#service_name ElastigroupGcp#service_name}
    */
    readonly serviceName: string;
    /**
    * named_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#named_ports ElastigroupGcp#named_ports}
    */
    readonly namedPorts?: ElastigroupGcpBackendServicesNamedPorts[] | cdktf.IResolvable;
}
export declare function elastigroupGcpBackendServicesToTerraform(struct?: ElastigroupGcpBackendServices | cdktf.IResolvable): any;
export interface ElastigroupGcpDiskInitializeParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk_size_gb ElastigroupGcp#disk_size_gb}
    */
    readonly diskSizeGb?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk_type ElastigroupGcp#disk_type}
    */
    readonly diskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source_image ElastigroupGcp#source_image}
    */
    readonly sourceImage: string;
}
export declare function elastigroupGcpDiskInitializeParamsToTerraform(struct?: ElastigroupGcpDiskInitializeParams | cdktf.IResolvable): any;
export interface ElastigroupGcpDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_delete ElastigroupGcp#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#boot ElastigroupGcp#boot}
    */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#device_name ElastigroupGcp#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#interface ElastigroupGcp#interface}
    */
    readonly interface?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#mode ElastigroupGcp#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#initialize_params ElastigroupGcp#initialize_params}
    */
    readonly initializeParams?: ElastigroupGcpDiskInitializeParams[] | cdktf.IResolvable;
}
export declare function elastigroupGcpDiskToTerraform(struct?: ElastigroupGcpDisk | cdktf.IResolvable): any;
export interface ElastigroupGcpGpu {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#count ElastigroupGcp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type: string;
}
export declare function elastigroupGcpGpuToTerraform(struct?: ElastigroupGcpGpu | cdktf.IResolvable): any;
export interface ElastigroupGcpInstanceTypesCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#memory_gib ElastigroupGcp#memory_gib}
    */
    readonly memoryGib: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#vcpu ElastigroupGcp#vcpu}
    */
    readonly vcpu: number;
}
export declare function elastigroupGcpInstanceTypesCustomToTerraform(struct?: ElastigroupGcpInstanceTypesCustom | cdktf.IResolvable): any;
export interface ElastigroupGcpIntegrationDockerSwarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_host ElastigroupGcp#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_port ElastigroupGcp#master_port}
    */
    readonly masterPort: number;
}
export declare function elastigroupGcpIntegrationDockerSwarmToTerraform(struct?: ElastigroupGcpIntegrationDockerSwarmOutputReference | ElastigroupGcpIntegrationDockerSwarm): any;
export declare class ElastigroupGcpIntegrationDockerSwarmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationDockerSwarm | undefined;
    set internalValue(value: ElastigroupGcpIntegrationDockerSwarm | undefined);
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _masterPort?;
    get masterPort(): number;
    set masterPort(value: number);
    get masterPortInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleDownToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference | ElastigroupGcpIntegrationGkeAutoscaleDown): any;
export declare class ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGkeAutoscaleDown | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGkeAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cpu_per_unit ElastigroupGcp#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#memory_per_unit ElastigroupGcp#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#num_of_units ElastigroupGcp#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference | ElastigroupGcpIntegrationGkeAutoscaleHeadroom): any;
export declare class ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleLabels | cdktf.IResolvable): any;
export interface ElastigroupGcpIntegrationGke {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_update ElastigroupGcp#auto_update}
    */
    readonly autoUpdate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_cooldown ElastigroupGcp#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_auto_config ElastigroupGcp#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_enabled ElastigroupGcp#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cluster_id ElastigroupGcp#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#location ElastigroupGcp#location}
    */
    readonly location?: string;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_down ElastigroupGcp#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupGcpIntegrationGkeAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_headroom ElastigroupGcp#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupGcpIntegrationGkeAutoscaleHeadroom;
    /**
    * autoscale_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_labels ElastigroupGcp#autoscale_labels}
    */
    readonly autoscaleLabels?: ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
}
export declare function elastigroupGcpIntegrationGkeToTerraform(struct?: ElastigroupGcpIntegrationGkeOutputReference | ElastigroupGcpIntegrationGke): any;
export declare class ElastigroupGcpIntegrationGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGke | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGke | undefined);
    private _autoUpdate?;
    get autoUpdate(): boolean | cdktf.IResolvable;
    set autoUpdate(value: boolean | cdktf.IResolvable);
    resetAutoUpdate(): void;
    get autoUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupGcpIntegrationGkeAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupGcpIntegrationGkeAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupGcpIntegrationGkeAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined;
    private _autoscaleLabels?;
    get autoscaleLabels(): ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
    set autoscaleLabels(value: ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable);
    resetAutoscaleLabels(): void;
    get autoscaleLabelsInput(): cdktf.IResolvable | ElastigroupGcpIntegrationGkeAutoscaleLabels[] | undefined;
}
export interface ElastigroupGcpLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpLabelsToTerraform(struct?: ElastigroupGcpLabels | cdktf.IResolvable): any;
export interface ElastigroupGcpMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpMetadataToTerraform(struct?: ElastigroupGcpMetadata | cdktf.IResolvable): any;
export interface ElastigroupGcpNetworkInterfaceAccessConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type?: string;
}
export declare function elastigroupGcpNetworkInterfaceAccessConfigsToTerraform(struct?: ElastigroupGcpNetworkInterfaceAccessConfigs | cdktf.IResolvable): any;
export interface ElastigroupGcpNetworkInterfaceAliasIpRanges {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ip_cidr_range ElastigroupGcp#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnetwork_range_name ElastigroupGcp#subnetwork_range_name}
    */
    readonly subnetworkRangeName: string;
}
export declare function elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform(struct?: ElastigroupGcpNetworkInterfaceAliasIpRanges | cdktf.IResolvable): any;
export interface ElastigroupGcpNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#network ElastigroupGcp#network}
    */
    readonly network: string;
    /**
    * access_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#access_configs ElastigroupGcp#access_configs}
    */
    readonly accessConfigs?: ElastigroupGcpNetworkInterfaceAccessConfigs[] | cdktf.IResolvable;
    /**
    * alias_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#alias_ip_ranges ElastigroupGcp#alias_ip_ranges}
    */
    readonly aliasIpRanges?: ElastigroupGcpNetworkInterfaceAliasIpRanges[] | cdktf.IResolvable;
}
export declare function elastigroupGcpNetworkInterfaceToTerraform(struct?: ElastigroupGcpNetworkInterface | cdktf.IResolvable): any;
export interface ElastigroupGcpScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value?: string;
}
export declare function elastigroupGcpScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupGcpScalingDownPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupGcpScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#action_type ElastigroupGcp#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#adjustment ElastigroupGcp#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cooldown ElastigroupGcp#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metric_name ElastigroupGcp#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#namespace ElastigroupGcp#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#operator ElastigroupGcp#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#period ElastigroupGcp#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#policy_name ElastigroupGcp#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#statistic ElastigroupGcp#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#threshold ElastigroupGcp#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unit ElastigroupGcp#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#dimensions ElastigroupGcp#dimensions}
    */
    readonly dimensions?: ElastigroupGcpScalingDownPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGcpScalingDownPolicyToTerraform(struct?: ElastigroupGcpScalingDownPolicy | cdktf.IResolvable): any;
export interface ElastigroupGcpScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value?: string;
}
export declare function elastigroupGcpScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupGcpScalingUpPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupGcpScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#action_type ElastigroupGcp#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#adjustment ElastigroupGcp#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cooldown ElastigroupGcp#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metric_name ElastigroupGcp#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#namespace ElastigroupGcp#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#operator ElastigroupGcp#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#period ElastigroupGcp#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#policy_name ElastigroupGcp#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#statistic ElastigroupGcp#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#threshold ElastigroupGcp#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unit ElastigroupGcp#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#dimensions ElastigroupGcp#dimensions}
    */
    readonly dimensions?: ElastigroupGcpScalingUpPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGcpScalingUpPolicyToTerraform(struct?: ElastigroupGcpScalingUpPolicy | cdktf.IResolvable): any;
export interface ElastigroupGcpScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cron_expression ElastigroupGcp#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#is_enabled ElastigroupGcp#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#max_capacity ElastigroupGcp#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#min_capacity ElastigroupGcp#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#target_capacity ElastigroupGcp#target_capacity}
    */
    readonly targetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#task_type ElastigroupGcp#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupGcpScheduledTaskToTerraform(struct?: ElastigroupGcpScheduledTask | cdktf.IResolvable): any;
export interface ElastigroupGcpSubnets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#region ElastigroupGcp#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnet_names ElastigroupGcp#subnet_names}
    */
    readonly subnetNames: string[];
}
export declare function elastigroupGcpSubnetsToTerraform(struct?: ElastigroupGcpSubnets | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp}
*/
export declare class ElastigroupGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_gcp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupGcpConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupGcpConfig);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheckGracePeriod?;
    get healthCheckGracePeriod(): number;
    set healthCheckGracePeriod(value: number);
    resetHealthCheckGracePeriod(): void;
    get healthCheckGracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    get id(): string;
    private _instanceTypesOndemand?;
    get instanceTypesOndemand(): string;
    set instanceTypesOndemand(value: string);
    resetInstanceTypesOndemand(): void;
    get instanceTypesOndemandInput(): string | undefined;
    private _instanceTypesPreemptible?;
    get instanceTypesPreemptible(): string[];
    set instanceTypesPreemptible(value: string[]);
    resetInstanceTypesPreemptible(): void;
    get instanceTypesPreemptibleInput(): string[] | undefined;
    private _ipForwarding?;
    get ipForwarding(): boolean | cdktf.IResolvable;
    set ipForwarding(value: boolean | cdktf.IResolvable);
    resetIpForwarding(): void;
    get ipForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ondemandCount?;
    get ondemandCount(): number;
    set ondemandCount(value: number);
    resetOndemandCount(): void;
    get ondemandCountInput(): number | undefined;
    private _preemptiblePercentage?;
    get preemptiblePercentage(): number;
    set preemptiblePercentage(value: number);
    resetPreemptiblePercentage(): void;
    get preemptiblePercentageInput(): number | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _startupScript?;
    get startupScript(): string;
    set startupScript(value: string);
    resetStartupScript(): void;
    get startupScriptInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _unhealthyDuration?;
    get unhealthyDuration(): number;
    set unhealthyDuration(value: number);
    resetUnhealthyDuration(): void;
    get unhealthyDurationInput(): number | undefined;
    private _backendServices?;
    get backendServices(): ElastigroupGcpBackendServices[] | cdktf.IResolvable;
    set backendServices(value: ElastigroupGcpBackendServices[] | cdktf.IResolvable);
    resetBackendServices(): void;
    get backendServicesInput(): cdktf.IResolvable | ElastigroupGcpBackendServices[] | undefined;
    private _disk?;
    get disk(): ElastigroupGcpDisk[] | cdktf.IResolvable;
    set disk(value: ElastigroupGcpDisk[] | cdktf.IResolvable);
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | ElastigroupGcpDisk[] | undefined;
    private _gpu?;
    get gpu(): ElastigroupGcpGpu[] | cdktf.IResolvable;
    set gpu(value: ElastigroupGcpGpu[] | cdktf.IResolvable);
    resetGpu(): void;
    get gpuInput(): cdktf.IResolvable | ElastigroupGcpGpu[] | undefined;
    private _instanceTypesCustom?;
    get instanceTypesCustom(): ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable;
    set instanceTypesCustom(value: ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable);
    resetInstanceTypesCustom(): void;
    get instanceTypesCustomInput(): cdktf.IResolvable | ElastigroupGcpInstanceTypesCustom[] | undefined;
    private _integrationDockerSwarm;
    get integrationDockerSwarm(): ElastigroupGcpIntegrationDockerSwarmOutputReference;
    putIntegrationDockerSwarm(value: ElastigroupGcpIntegrationDockerSwarm): void;
    resetIntegrationDockerSwarm(): void;
    get integrationDockerSwarmInput(): ElastigroupGcpIntegrationDockerSwarm | undefined;
    private _integrationGke;
    get integrationGke(): ElastigroupGcpIntegrationGkeOutputReference;
    putIntegrationGke(value: ElastigroupGcpIntegrationGke): void;
    resetIntegrationGke(): void;
    get integrationGkeInput(): ElastigroupGcpIntegrationGke | undefined;
    private _labels?;
    get labels(): ElastigroupGcpLabels[] | cdktf.IResolvable;
    set labels(value: ElastigroupGcpLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ElastigroupGcpLabels[] | undefined;
    private _metadata?;
    get metadata(): ElastigroupGcpMetadata[] | cdktf.IResolvable;
    set metadata(value: ElastigroupGcpMetadata[] | cdktf.IResolvable);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | ElastigroupGcpMetadata[] | undefined;
    private _networkInterface?;
    get networkInterface(): ElastigroupGcpNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: ElastigroupGcpNetworkInterface[] | cdktf.IResolvable);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ElastigroupGcpNetworkInterface[] | undefined;
    private _scalingDownPolicy?;
    get scalingDownPolicy(): ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable;
    set scalingDownPolicy(value: ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable);
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupGcpScalingDownPolicy[] | undefined;
    private _scalingUpPolicy?;
    get scalingUpPolicy(): ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable;
    set scalingUpPolicy(value: ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable);
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupGcpScalingUpPolicy[] | undefined;
    private _scheduledTask?;
    get scheduledTask(): ElastigroupGcpScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: ElastigroupGcpScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupGcpScheduledTask[] | undefined;
    private _subnets?;
    get subnets(): ElastigroupGcpSubnets[] | cdktf.IResolvable;
    set subnets(value: ElastigroupGcpSubnets[] | cdktf.IResolvable);
    resetSubnets(): void;
    get subnetsInput(): cdktf.IResolvable | ElastigroupGcpSubnets[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
