"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastigroupGcp = exports.elastigroupGcpSubnetsToTerraform = exports.elastigroupGcpScheduledTaskToTerraform = exports.elastigroupGcpScalingUpPolicyToTerraform = exports.elastigroupGcpScalingUpPolicyDimensionsToTerraform = exports.elastigroupGcpScalingDownPolicyToTerraform = exports.elastigroupGcpScalingDownPolicyDimensionsToTerraform = exports.elastigroupGcpNetworkInterfaceToTerraform = exports.elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform = exports.elastigroupGcpNetworkInterfaceAccessConfigsToTerraform = exports.elastigroupGcpMetadataToTerraform = exports.elastigroupGcpLabelsToTerraform = exports.ElastigroupGcpIntegrationGkeOutputReference = exports.elastigroupGcpIntegrationGkeToTerraform = exports.elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform = exports.ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference = exports.elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform = exports.ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference = exports.elastigroupGcpIntegrationGkeAutoscaleDownToTerraform = exports.ElastigroupGcpIntegrationDockerSwarmOutputReference = exports.elastigroupGcpIntegrationDockerSwarmToTerraform = exports.elastigroupGcpInstanceTypesCustomToTerraform = exports.elastigroupGcpGpuToTerraform = exports.elastigroupGcpDiskToTerraform = exports.elastigroupGcpDiskInitializeParamsToTerraform = exports.elastigroupGcpBackendServicesToTerraform = exports.elastigroupGcpBackendServicesNamedPortsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function elastigroupGcpBackendServicesNamedPortsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        ports: cdktf.listMapper(cdktf.stringToTerraform)(struct.ports),
    };
}
exports.elastigroupGcpBackendServicesNamedPortsToTerraform = elastigroupGcpBackendServicesNamedPortsToTerraform;
function elastigroupGcpBackendServicesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        location_type: cdktf.stringToTerraform(struct.locationType),
        scheme: cdktf.stringToTerraform(struct.scheme),
        service_name: cdktf.stringToTerraform(struct.serviceName),
        named_ports: cdktf.listMapper(elastigroupGcpBackendServicesNamedPortsToTerraform)(struct.namedPorts),
    };
}
exports.elastigroupGcpBackendServicesToTerraform = elastigroupGcpBackendServicesToTerraform;
function elastigroupGcpDiskInitializeParamsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disk_size_gb: cdktf.stringToTerraform(struct.diskSizeGb),
        disk_type: cdktf.stringToTerraform(struct.diskType),
        source_image: cdktf.stringToTerraform(struct.sourceImage),
    };
}
exports.elastigroupGcpDiskInitializeParamsToTerraform = elastigroupGcpDiskInitializeParamsToTerraform;
function elastigroupGcpDiskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auto_delete: cdktf.booleanToTerraform(struct.autoDelete),
        boot: cdktf.booleanToTerraform(struct.boot),
        device_name: cdktf.stringToTerraform(struct.deviceName),
        interface: cdktf.stringToTerraform(struct.interface),
        mode: cdktf.stringToTerraform(struct.mode),
        source: cdktf.stringToTerraform(struct.source),
        type: cdktf.stringToTerraform(struct.type),
        initialize_params: cdktf.listMapper(elastigroupGcpDiskInitializeParamsToTerraform)(struct.initializeParams),
    };
}
exports.elastigroupGcpDiskToTerraform = elastigroupGcpDiskToTerraform;
function elastigroupGcpGpuToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        count: cdktf.numberToTerraform(struct.count),
        type: cdktf.stringToTerraform(struct.type),
    };
}
exports.elastigroupGcpGpuToTerraform = elastigroupGcpGpuToTerraform;
function elastigroupGcpInstanceTypesCustomToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        memory_gib: cdktf.numberToTerraform(struct.memoryGib),
        vcpu: cdktf.numberToTerraform(struct.vcpu),
    };
}
exports.elastigroupGcpInstanceTypesCustomToTerraform = elastigroupGcpInstanceTypesCustomToTerraform;
function elastigroupGcpIntegrationDockerSwarmToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        master_host: cdktf.stringToTerraform(struct.masterHost),
        master_port: cdktf.numberToTerraform(struct.masterPort),
    };
}
exports.elastigroupGcpIntegrationDockerSwarmToTerraform = elastigroupGcpIntegrationDockerSwarmToTerraform;
class ElastigroupGcpIntegrationDockerSwarmOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._masterHost !== undefined) {
            hasAnyValues = true;
            internalValueResult.masterHost = this._masterHost;
        }
        if (this._masterPort !== undefined) {
            hasAnyValues = true;
            internalValueResult.masterPort = this._masterPort;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._masterHost = undefined;
            this._masterPort = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._masterHost = value.masterHost;
            this._masterPort = value.masterPort;
        }
    }
    get masterHost() {
        return this.getStringAttribute('master_host');
    }
    set masterHost(value) {
        this._masterHost = value;
    }
    // Temporarily expose input value. Use with caution.
    get masterHostInput() {
        return this._masterHost;
    }
    get masterPort() {
        return this.getNumberAttribute('master_port');
    }
    set masterPort(value) {
        this._masterPort = value;
    }
    // Temporarily expose input value. Use with caution.
    get masterPortInput() {
        return this._masterPort;
    }
}
exports.ElastigroupGcpIntegrationDockerSwarmOutputReference = ElastigroupGcpIntegrationDockerSwarmOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ElastigroupGcpIntegrationDockerSwarmOutputReference[_a] = { fqn: "@cdktf/provider-spotinst.ElastigroupGcpIntegrationDockerSwarmOutputReference", version: "0.0.4" };
function elastigroupGcpIntegrationGkeAutoscaleDownToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        evaluation_periods: cdktf.numberToTerraform(struct.evaluationPeriods),
    };
}
exports.elastigroupGcpIntegrationGkeAutoscaleDownToTerraform = elastigroupGcpIntegrationGkeAutoscaleDownToTerraform;
class ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._evaluationPeriods !== undefined) {
            hasAnyValues = true;
            internalValueResult.evaluationPeriods = this._evaluationPeriods;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._evaluationPeriods = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._evaluationPeriods = value.evaluationPeriods;
        }
    }
    get evaluationPeriods() {
        return this.getNumberAttribute('evaluation_periods');
    }
    set evaluationPeriods(value) {
        this._evaluationPeriods = value;
    }
    resetEvaluationPeriods() {
        this._evaluationPeriods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evaluationPeriodsInput() {
        return this._evaluationPeriods;
    }
}
exports.ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference = ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference[_b] = { fqn: "@cdktf/provider-spotinst.ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference", version: "0.0.4" };
function elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cpu_per_unit: cdktf.numberToTerraform(struct.cpuPerUnit),
        memory_per_unit: cdktf.numberToTerraform(struct.memoryPerUnit),
        num_of_units: cdktf.numberToTerraform(struct.numOfUnits),
    };
}
exports.elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform = elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform;
class ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cpuPerUnit !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuPerUnit = this._cpuPerUnit;
        }
        if (this._memoryPerUnit !== undefined) {
            hasAnyValues = true;
            internalValueResult.memoryPerUnit = this._memoryPerUnit;
        }
        if (this._numOfUnits !== undefined) {
            hasAnyValues = true;
            internalValueResult.numOfUnits = this._numOfUnits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cpuPerUnit = undefined;
            this._memoryPerUnit = undefined;
            this._numOfUnits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cpuPerUnit = value.cpuPerUnit;
            this._memoryPerUnit = value.memoryPerUnit;
            this._numOfUnits = value.numOfUnits;
        }
    }
    get cpuPerUnit() {
        return this.getNumberAttribute('cpu_per_unit');
    }
    set cpuPerUnit(value) {
        this._cpuPerUnit = value;
    }
    resetCpuPerUnit() {
        this._cpuPerUnit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerUnitInput() {
        return this._cpuPerUnit;
    }
    get memoryPerUnit() {
        return this.getNumberAttribute('memory_per_unit');
    }
    set memoryPerUnit(value) {
        this._memoryPerUnit = value;
    }
    resetMemoryPerUnit() {
        this._memoryPerUnit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryPerUnitInput() {
        return this._memoryPerUnit;
    }
    get numOfUnits() {
        return this.getNumberAttribute('num_of_units');
    }
    set numOfUnits(value) {
        this._numOfUnits = value;
    }
    resetNumOfUnits() {
        this._numOfUnits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numOfUnitsInput() {
        return this._numOfUnits;
    }
}
exports.ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference = ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference[_c] = { fqn: "@cdktf/provider-spotinst.ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference", version: "0.0.4" };
function elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform = elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform;
function elastigroupGcpIntegrationGkeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auto_update: cdktf.booleanToTerraform(struct.autoUpdate),
        autoscale_cooldown: cdktf.numberToTerraform(struct.autoscaleCooldown),
        autoscale_is_auto_config: cdktf.booleanToTerraform(struct.autoscaleIsAutoConfig),
        autoscale_is_enabled: cdktf.booleanToTerraform(struct.autoscaleIsEnabled),
        cluster_id: cdktf.stringToTerraform(struct.clusterId),
        location: cdktf.stringToTerraform(struct.location),
        autoscale_down: elastigroupGcpIntegrationGkeAutoscaleDownToTerraform(struct.autoscaleDown),
        autoscale_headroom: elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform(struct.autoscaleHeadroom),
        autoscale_labels: cdktf.listMapper(elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform)(struct.autoscaleLabels),
    };
}
exports.elastigroupGcpIntegrationGkeToTerraform = elastigroupGcpIntegrationGkeToTerraform;
class ElastigroupGcpIntegrationGkeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // autoscale_down - computed: false, optional: true, required: false
        this._autoscaleDown = new ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference(this, "autoscale_down");
        // autoscale_headroom - computed: false, optional: true, required: false
        this._autoscaleHeadroom = new ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference(this, "autoscale_headroom");
    }
    get internalValue() {
        var _f, _g, _h, _j;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._autoUpdate !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoUpdate = this._autoUpdate;
        }
        if (this._autoscaleCooldown !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleCooldown = this._autoscaleCooldown;
        }
        if (this._autoscaleIsAutoConfig !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleIsAutoConfig = this._autoscaleIsAutoConfig;
        }
        if (this._autoscaleIsEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleIsEnabled = this._autoscaleIsEnabled;
        }
        if (this._clusterId !== undefined) {
            hasAnyValues = true;
            internalValueResult.clusterId = this._clusterId;
        }
        if (this._location !== undefined) {
            hasAnyValues = true;
            internalValueResult.location = this._location;
        }
        if (((_f = this._autoscaleDown) === null || _f === void 0 ? void 0 : _f.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleDown = (_g = this._autoscaleDown) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        if (((_h = this._autoscaleHeadroom) === null || _h === void 0 ? void 0 : _h.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleHeadroom = (_j = this._autoscaleHeadroom) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        if (this._autoscaleLabels !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoscaleLabels = this._autoscaleLabels;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._autoUpdate = undefined;
            this._autoscaleCooldown = undefined;
            this._autoscaleIsAutoConfig = undefined;
            this._autoscaleIsEnabled = undefined;
            this._clusterId = undefined;
            this._location = undefined;
            this._autoscaleDown.internalValue = undefined;
            this._autoscaleHeadroom.internalValue = undefined;
            this._autoscaleLabels = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._autoUpdate = value.autoUpdate;
            this._autoscaleCooldown = value.autoscaleCooldown;
            this._autoscaleIsAutoConfig = value.autoscaleIsAutoConfig;
            this._autoscaleIsEnabled = value.autoscaleIsEnabled;
            this._clusterId = value.clusterId;
            this._location = value.location;
            this._autoscaleDown.internalValue = value.autoscaleDown;
            this._autoscaleHeadroom.internalValue = value.autoscaleHeadroom;
            this._autoscaleLabels = value.autoscaleLabels;
        }
    }
    get autoUpdate() {
        return this.getBooleanAttribute('auto_update');
    }
    set autoUpdate(value) {
        this._autoUpdate = value;
    }
    resetAutoUpdate() {
        this._autoUpdate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoUpdateInput() {
        return this._autoUpdate;
    }
    get autoscaleCooldown() {
        return this.getNumberAttribute('autoscale_cooldown');
    }
    set autoscaleCooldown(value) {
        this._autoscaleCooldown = value;
    }
    resetAutoscaleCooldown() {
        this._autoscaleCooldown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleCooldownInput() {
        return this._autoscaleCooldown;
    }
    get autoscaleIsAutoConfig() {
        return this.getBooleanAttribute('autoscale_is_auto_config');
    }
    set autoscaleIsAutoConfig(value) {
        this._autoscaleIsAutoConfig = value;
    }
    resetAutoscaleIsAutoConfig() {
        this._autoscaleIsAutoConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleIsAutoConfigInput() {
        return this._autoscaleIsAutoConfig;
    }
    get autoscaleIsEnabled() {
        return this.getBooleanAttribute('autoscale_is_enabled');
    }
    set autoscaleIsEnabled(value) {
        this._autoscaleIsEnabled = value;
    }
    resetAutoscaleIsEnabled() {
        this._autoscaleIsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleIsEnabledInput() {
        return this._autoscaleIsEnabled;
    }
    get clusterId() {
        return this.getStringAttribute('cluster_id');
    }
    set clusterId(value) {
        this._clusterId = value;
    }
    resetClusterId() {
        this._clusterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterIdInput() {
        return this._clusterId;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    resetLocation() {
        this._location = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get autoscaleDown() {
        return this._autoscaleDown;
    }
    putAutoscaleDown(value) {
        this._autoscaleDown.internalValue = value;
    }
    resetAutoscaleDown() {
        this._autoscaleDown.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleDownInput() {
        return this._autoscaleDown.internalValue;
    }
    get autoscaleHeadroom() {
        return this._autoscaleHeadroom;
    }
    putAutoscaleHeadroom(value) {
        this._autoscaleHeadroom.internalValue = value;
    }
    resetAutoscaleHeadroom() {
        this._autoscaleHeadroom.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleHeadroomInput() {
        return this._autoscaleHeadroom.internalValue;
    }
    get autoscaleLabels() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('autoscale_labels')));
    }
    set autoscaleLabels(value) {
        this._autoscaleLabels = value;
    }
    resetAutoscaleLabels() {
        this._autoscaleLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleLabelsInput() {
        return this._autoscaleLabels;
    }
}
exports.ElastigroupGcpIntegrationGkeOutputReference = ElastigroupGcpIntegrationGkeOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ElastigroupGcpIntegrationGkeOutputReference[_d] = { fqn: "@cdktf/provider-spotinst.ElastigroupGcpIntegrationGkeOutputReference", version: "0.0.4" };
function elastigroupGcpLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.elastigroupGcpLabelsToTerraform = elastigroupGcpLabelsToTerraform;
function elastigroupGcpMetadataToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.elastigroupGcpMetadataToTerraform = elastigroupGcpMetadataToTerraform;
function elastigroupGcpNetworkInterfaceAccessConfigsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        type: cdktf.stringToTerraform(struct.type),
    };
}
exports.elastigroupGcpNetworkInterfaceAccessConfigsToTerraform = elastigroupGcpNetworkInterfaceAccessConfigsToTerraform;
function elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ip_cidr_range: cdktf.stringToTerraform(struct.ipCidrRange),
        subnetwork_range_name: cdktf.stringToTerraform(struct.subnetworkRangeName),
    };
}
exports.elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform = elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform;
function elastigroupGcpNetworkInterfaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        network: cdktf.stringToTerraform(struct.network),
        access_configs: cdktf.listMapper(elastigroupGcpNetworkInterfaceAccessConfigsToTerraform)(struct.accessConfigs),
        alias_ip_ranges: cdktf.listMapper(elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform)(struct.aliasIpRanges),
    };
}
exports.elastigroupGcpNetworkInterfaceToTerraform = elastigroupGcpNetworkInterfaceToTerraform;
function elastigroupGcpScalingDownPolicyDimensionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.elastigroupGcpScalingDownPolicyDimensionsToTerraform = elastigroupGcpScalingDownPolicyDimensionsToTerraform;
function elastigroupGcpScalingDownPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        action_type: cdktf.stringToTerraform(struct.actionType),
        adjustment: cdktf.numberToTerraform(struct.adjustment),
        cooldown: cdktf.numberToTerraform(struct.cooldown),
        evaluation_periods: cdktf.numberToTerraform(struct.evaluationPeriods),
        metric_name: cdktf.stringToTerraform(struct.metricName),
        namespace: cdktf.stringToTerraform(struct.namespace),
        operator: cdktf.stringToTerraform(struct.operator),
        period: cdktf.numberToTerraform(struct.period),
        policy_name: cdktf.stringToTerraform(struct.policyName),
        source: cdktf.stringToTerraform(struct.source),
        statistic: cdktf.stringToTerraform(struct.statistic),
        threshold: cdktf.numberToTerraform(struct.threshold),
        unit: cdktf.stringToTerraform(struct.unit),
        dimensions: cdktf.listMapper(elastigroupGcpScalingDownPolicyDimensionsToTerraform)(struct.dimensions),
    };
}
exports.elastigroupGcpScalingDownPolicyToTerraform = elastigroupGcpScalingDownPolicyToTerraform;
function elastigroupGcpScalingUpPolicyDimensionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.elastigroupGcpScalingUpPolicyDimensionsToTerraform = elastigroupGcpScalingUpPolicyDimensionsToTerraform;
function elastigroupGcpScalingUpPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        action_type: cdktf.stringToTerraform(struct.actionType),
        adjustment: cdktf.numberToTerraform(struct.adjustment),
        cooldown: cdktf.numberToTerraform(struct.cooldown),
        evaluation_periods: cdktf.numberToTerraform(struct.evaluationPeriods),
        metric_name: cdktf.stringToTerraform(struct.metricName),
        namespace: cdktf.stringToTerraform(struct.namespace),
        operator: cdktf.stringToTerraform(struct.operator),
        period: cdktf.numberToTerraform(struct.period),
        policy_name: cdktf.stringToTerraform(struct.policyName),
        source: cdktf.stringToTerraform(struct.source),
        statistic: cdktf.stringToTerraform(struct.statistic),
        threshold: cdktf.numberToTerraform(struct.threshold),
        unit: cdktf.stringToTerraform(struct.unit),
        dimensions: cdktf.listMapper(elastigroupGcpScalingUpPolicyDimensionsToTerraform)(struct.dimensions),
    };
}
exports.elastigroupGcpScalingUpPolicyToTerraform = elastigroupGcpScalingUpPolicyToTerraform;
function elastigroupGcpScheduledTaskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cron_expression: cdktf.stringToTerraform(struct.cronExpression),
        is_enabled: cdktf.booleanToTerraform(struct.isEnabled),
        max_capacity: cdktf.stringToTerraform(struct.maxCapacity),
        min_capacity: cdktf.stringToTerraform(struct.minCapacity),
        target_capacity: cdktf.stringToTerraform(struct.targetCapacity),
        task_type: cdktf.stringToTerraform(struct.taskType),
    };
}
exports.elastigroupGcpScheduledTaskToTerraform = elastigroupGcpScheduledTaskToTerraform;
function elastigroupGcpSubnetsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        region: cdktf.stringToTerraform(struct.region),
        subnet_names: cdktf.listMapper(cdktf.stringToTerraform)(struct.subnetNames),
    };
}
exports.elastigroupGcpSubnetsToTerraform = elastigroupGcpSubnetsToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp}
*/
class ElastigroupGcp extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupGcpConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'spotinst_elastigroup_gcp',
            terraformGeneratorMetadata: {
                providerName: 'spotinst',
                providerVersion: '1.73.3',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // integration_docker_swarm - computed: false, optional: true, required: false
        this._integrationDockerSwarm = new ElastigroupGcpIntegrationDockerSwarmOutputReference(this, "integration_docker_swarm");
        // integration_gke - computed: false, optional: true, required: false
        this._integrationGke = new ElastigroupGcpIntegrationGkeOutputReference(this, "integration_gke");
        this._autoHealing = config.autoHealing;
        this._availabilityZones = config.availabilityZones;
        this._description = config.description;
        this._desiredCapacity = config.desiredCapacity;
        this._drainingTimeout = config.drainingTimeout;
        this._fallbackToOndemand = config.fallbackToOndemand;
        this._healthCheckGracePeriod = config.healthCheckGracePeriod;
        this._healthCheckType = config.healthCheckType;
        this._instanceTypesOndemand = config.instanceTypesOndemand;
        this._instanceTypesPreemptible = config.instanceTypesPreemptible;
        this._ipForwarding = config.ipForwarding;
        this._maxSize = config.maxSize;
        this._minSize = config.minSize;
        this._name = config.name;
        this._ondemandCount = config.ondemandCount;
        this._preemptiblePercentage = config.preemptiblePercentage;
        this._provisioningModel = config.provisioningModel;
        this._serviceAccount = config.serviceAccount;
        this._shutdownScript = config.shutdownScript;
        this._startupScript = config.startupScript;
        this._tags = config.tags;
        this._unhealthyDuration = config.unhealthyDuration;
        this._backendServices = config.backendServices;
        this._disk = config.disk;
        this._gpu = config.gpu;
        this._instanceTypesCustom = config.instanceTypesCustom;
        this._integrationDockerSwarm.internalValue = config.integrationDockerSwarm;
        this._integrationGke.internalValue = config.integrationGke;
        this._labels = config.labels;
        this._metadata = config.metadata;
        this._networkInterface = config.networkInterface;
        this._scalingDownPolicy = config.scalingDownPolicy;
        this._scalingUpPolicy = config.scalingUpPolicy;
        this._scheduledTask = config.scheduledTask;
        this._subnets = config.subnets;
    }
    get autoHealing() {
        return this.getBooleanAttribute('auto_healing');
    }
    set autoHealing(value) {
        this._autoHealing = value;
    }
    resetAutoHealing() {
        this._autoHealing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoHealingInput() {
        return this._autoHealing;
    }
    get availabilityZones() {
        return this.getListAttribute('availability_zones');
    }
    set availabilityZones(value) {
        this._availabilityZones = value;
    }
    resetAvailabilityZones() {
        this._availabilityZones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availabilityZonesInput() {
        return this._availabilityZones;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get desiredCapacity() {
        return this.getNumberAttribute('desired_capacity');
    }
    set desiredCapacity(value) {
        this._desiredCapacity = value;
    }
    // Temporarily expose input value. Use with caution.
    get desiredCapacityInput() {
        return this._desiredCapacity;
    }
    get drainingTimeout() {
        return this.getNumberAttribute('draining_timeout');
    }
    set drainingTimeout(value) {
        this._drainingTimeout = value;
    }
    resetDrainingTimeout() {
        this._drainingTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drainingTimeoutInput() {
        return this._drainingTimeout;
    }
    get fallbackToOndemand() {
        return this.getBooleanAttribute('fallback_to_ondemand');
    }
    set fallbackToOndemand(value) {
        this._fallbackToOndemand = value;
    }
    resetFallbackToOndemand() {
        this._fallbackToOndemand = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fallbackToOndemandInput() {
        return this._fallbackToOndemand;
    }
    get healthCheckGracePeriod() {
        return this.getNumberAttribute('health_check_grace_period');
    }
    set healthCheckGracePeriod(value) {
        this._healthCheckGracePeriod = value;
    }
    resetHealthCheckGracePeriod() {
        this._healthCheckGracePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthCheckGracePeriodInput() {
        return this._healthCheckGracePeriod;
    }
    get healthCheckType() {
        return this.getStringAttribute('health_check_type');
    }
    set healthCheckType(value) {
        this._healthCheckType = value;
    }
    resetHealthCheckType() {
        this._healthCheckType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthCheckTypeInput() {
        return this._healthCheckType;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get instanceTypesOndemand() {
        return this.getStringAttribute('instance_types_ondemand');
    }
    set instanceTypesOndemand(value) {
        this._instanceTypesOndemand = value;
    }
    resetInstanceTypesOndemand() {
        this._instanceTypesOndemand = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceTypesOndemandInput() {
        return this._instanceTypesOndemand;
    }
    get instanceTypesPreemptible() {
        return this.getListAttribute('instance_types_preemptible');
    }
    set instanceTypesPreemptible(value) {
        this._instanceTypesPreemptible = value;
    }
    resetInstanceTypesPreemptible() {
        this._instanceTypesPreemptible = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceTypesPreemptibleInput() {
        return this._instanceTypesPreemptible;
    }
    get ipForwarding() {
        return this.getBooleanAttribute('ip_forwarding');
    }
    set ipForwarding(value) {
        this._ipForwarding = value;
    }
    resetIpForwarding() {
        this._ipForwarding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipForwardingInput() {
        return this._ipForwarding;
    }
    get maxSize() {
        return this.getNumberAttribute('max_size');
    }
    set maxSize(value) {
        this._maxSize = value;
    }
    resetMaxSize() {
        this._maxSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSizeInput() {
        return this._maxSize;
    }
    get minSize() {
        return this.getNumberAttribute('min_size');
    }
    set minSize(value) {
        this._minSize = value;
    }
    resetMinSize() {
        this._minSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minSizeInput() {
        return this._minSize;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get ondemandCount() {
        return this.getNumberAttribute('ondemand_count');
    }
    set ondemandCount(value) {
        this._ondemandCount = value;
    }
    resetOndemandCount() {
        this._ondemandCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ondemandCountInput() {
        return this._ondemandCount;
    }
    get preemptiblePercentage() {
        return this.getNumberAttribute('preemptible_percentage');
    }
    set preemptiblePercentage(value) {
        this._preemptiblePercentage = value;
    }
    resetPreemptiblePercentage() {
        this._preemptiblePercentage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preemptiblePercentageInput() {
        return this._preemptiblePercentage;
    }
    get provisioningModel() {
        return this.getStringAttribute('provisioning_model');
    }
    set provisioningModel(value) {
        this._provisioningModel = value;
    }
    resetProvisioningModel() {
        this._provisioningModel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get provisioningModelInput() {
        return this._provisioningModel;
    }
    get serviceAccount() {
        return this.getStringAttribute('service_account');
    }
    set serviceAccount(value) {
        this._serviceAccount = value;
    }
    resetServiceAccount() {
        this._serviceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountInput() {
        return this._serviceAccount;
    }
    get shutdownScript() {
        return this.getStringAttribute('shutdown_script');
    }
    set shutdownScript(value) {
        this._shutdownScript = value;
    }
    resetShutdownScript() {
        this._shutdownScript = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shutdownScriptInput() {
        return this._shutdownScript;
    }
    get startupScript() {
        return this.getStringAttribute('startup_script');
    }
    set startupScript(value) {
        this._startupScript = value;
    }
    resetStartupScript() {
        this._startupScript = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get startupScriptInput() {
        return this._startupScript;
    }
    get tags() {
        return this.getListAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get unhealthyDuration() {
        return this.getNumberAttribute('unhealthy_duration');
    }
    set unhealthyDuration(value) {
        this._unhealthyDuration = value;
    }
    resetUnhealthyDuration() {
        this._unhealthyDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unhealthyDurationInput() {
        return this._unhealthyDuration;
    }
    get backendServices() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('backend_services')));
    }
    set backendServices(value) {
        this._backendServices = value;
    }
    resetBackendServices() {
        this._backendServices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendServicesInput() {
        return this._backendServices;
    }
    get disk() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('disk')));
    }
    set disk(value) {
        this._disk = value;
    }
    resetDisk() {
        this._disk = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diskInput() {
        return this._disk;
    }
    get gpu() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('gpu')));
    }
    set gpu(value) {
        this._gpu = value;
    }
    resetGpu() {
        this._gpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gpuInput() {
        return this._gpu;
    }
    get instanceTypesCustom() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('instance_types_custom');
    }
    set instanceTypesCustom(value) {
        this._instanceTypesCustom = value;
    }
    resetInstanceTypesCustom() {
        this._instanceTypesCustom = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceTypesCustomInput() {
        return this._instanceTypesCustom;
    }
    get integrationDockerSwarm() {
        return this._integrationDockerSwarm;
    }
    putIntegrationDockerSwarm(value) {
        this._integrationDockerSwarm.internalValue = value;
    }
    resetIntegrationDockerSwarm() {
        this._integrationDockerSwarm.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get integrationDockerSwarmInput() {
        return this._integrationDockerSwarm.internalValue;
    }
    get integrationGke() {
        return this._integrationGke;
    }
    putIntegrationGke(value) {
        this._integrationGke.internalValue = value;
    }
    resetIntegrationGke() {
        this._integrationGke.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get integrationGkeInput() {
        return this._integrationGke.internalValue;
    }
    get labels() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('labels')));
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get metadata() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('metadata')));
    }
    set metadata(value) {
        this._metadata = value;
    }
    resetMetadata() {
        this._metadata = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataInput() {
        return this._metadata;
    }
    get networkInterface() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('network_interface');
    }
    set networkInterface(value) {
        this._networkInterface = value;
    }
    resetNetworkInterface() {
        this._networkInterface = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkInterfaceInput() {
        return this._networkInterface;
    }
    get scalingDownPolicy() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('scaling_down_policy')));
    }
    set scalingDownPolicy(value) {
        this._scalingDownPolicy = value;
    }
    resetScalingDownPolicy() {
        this._scalingDownPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scalingDownPolicyInput() {
        return this._scalingDownPolicy;
    }
    get scalingUpPolicy() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('scaling_up_policy')));
    }
    set scalingUpPolicy(value) {
        this._scalingUpPolicy = value;
    }
    resetScalingUpPolicy() {
        this._scalingUpPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scalingUpPolicyInput() {
        return this._scalingUpPolicy;
    }
    get scheduledTask() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('scheduled_task')));
    }
    set scheduledTask(value) {
        this._scheduledTask = value;
    }
    resetScheduledTask() {
        this._scheduledTask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scheduledTaskInput() {
        return this._scheduledTask;
    }
    get subnets() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('subnets')));
    }
    set subnets(value) {
        this._subnets = value;
    }
    resetSubnets() {
        this._subnets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetsInput() {
        return this._subnets;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_healing: cdktf.booleanToTerraform(this._autoHealing),
            availability_zones: cdktf.listMapper(cdktf.stringToTerraform)(this._availabilityZones),
            description: cdktf.stringToTerraform(this._description),
            desired_capacity: cdktf.numberToTerraform(this._desiredCapacity),
            draining_timeout: cdktf.numberToTerraform(this._drainingTimeout),
            fallback_to_ondemand: cdktf.booleanToTerraform(this._fallbackToOndemand),
            health_check_grace_period: cdktf.numberToTerraform(this._healthCheckGracePeriod),
            health_check_type: cdktf.stringToTerraform(this._healthCheckType),
            instance_types_ondemand: cdktf.stringToTerraform(this._instanceTypesOndemand),
            instance_types_preemptible: cdktf.listMapper(cdktf.stringToTerraform)(this._instanceTypesPreemptible),
            ip_forwarding: cdktf.booleanToTerraform(this._ipForwarding),
            max_size: cdktf.numberToTerraform(this._maxSize),
            min_size: cdktf.numberToTerraform(this._minSize),
            name: cdktf.stringToTerraform(this._name),
            ondemand_count: cdktf.numberToTerraform(this._ondemandCount),
            preemptible_percentage: cdktf.numberToTerraform(this._preemptiblePercentage),
            provisioning_model: cdktf.stringToTerraform(this._provisioningModel),
            service_account: cdktf.stringToTerraform(this._serviceAccount),
            shutdown_script: cdktf.stringToTerraform(this._shutdownScript),
            startup_script: cdktf.stringToTerraform(this._startupScript),
            tags: cdktf.listMapper(cdktf.stringToTerraform)(this._tags),
            unhealthy_duration: cdktf.numberToTerraform(this._unhealthyDuration),
            backend_services: cdktf.listMapper(elastigroupGcpBackendServicesToTerraform)(this._backendServices),
            disk: cdktf.listMapper(elastigroupGcpDiskToTerraform)(this._disk),
            gpu: cdktf.listMapper(elastigroupGcpGpuToTerraform)(this._gpu),
            instance_types_custom: cdktf.listMapper(elastigroupGcpInstanceTypesCustomToTerraform)(this._instanceTypesCustom),
            integration_docker_swarm: elastigroupGcpIntegrationDockerSwarmToTerraform(this._integrationDockerSwarm.internalValue),
            integration_gke: elastigroupGcpIntegrationGkeToTerraform(this._integrationGke.internalValue),
            labels: cdktf.listMapper(elastigroupGcpLabelsToTerraform)(this._labels),
            metadata: cdktf.listMapper(elastigroupGcpMetadataToTerraform)(this._metadata),
            network_interface: cdktf.listMapper(elastigroupGcpNetworkInterfaceToTerraform)(this._networkInterface),
            scaling_down_policy: cdktf.listMapper(elastigroupGcpScalingDownPolicyToTerraform)(this._scalingDownPolicy),
            scaling_up_policy: cdktf.listMapper(elastigroupGcpScalingUpPolicyToTerraform)(this._scalingUpPolicy),
            scheduled_task: cdktf.listMapper(elastigroupGcpScheduledTaskToTerraform)(this._scheduledTask),
            subnets: cdktf.listMapper(elastigroupGcpSubnetsToTerraform)(this._subnets),
        };
    }
}
exports.ElastigroupGcp = ElastigroupGcp;
_e = JSII_RTTI_SYMBOL_1;
ElastigroupGcp[_e] = { fqn: "@cdktf/provider-spotinst.ElastigroupGcp", version: "0.0.4" };
// =================
// STATIC PROPERTIES
// =================
ElastigroupGcp.tfResourceType = "spotinst_elastigroup_gcp";
//# sourceMappingURL=data:application/json;base64,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