import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupGkeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cluster_id ElastigroupGke#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cluster_zone_name ElastigroupGke#cluster_zone_name}
    */
    readonly clusterZoneName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#desired_capacity ElastigroupGke#desired_capacity}
    */
    readonly desiredCapacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#draining_timeout ElastigroupGke#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#fallback_to_ondemand ElastigroupGke#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#instance_types_ondemand ElastigroupGke#instance_types_ondemand}
    */
    readonly instanceTypesOndemand?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#instance_types_preemptible ElastigroupGke#instance_types_preemptible}
    */
    readonly instanceTypesPreemptible?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#ip_forwarding ElastigroupGke#ip_forwarding}
    */
    readonly ipForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#max_size ElastigroupGke#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#min_size ElastigroupGke#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#name ElastigroupGke#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#node_image ElastigroupGke#node_image}
    */
    readonly nodeImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#ondemand_count ElastigroupGke#ondemand_count}
    */
    readonly ondemandCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#preemptible_percentage ElastigroupGke#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#provisioning_model ElastigroupGke#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#service_account ElastigroupGke#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#shutdown_script ElastigroupGke#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#startup_script ElastigroupGke#startup_script}
    */
    readonly startupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#tags ElastigroupGke#tags}
    */
    readonly tags?: string[];
    /**
    * backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#backend_services ElastigroupGke#backend_services}
    */
    readonly backendServices?: ElastigroupGkeBackendServices[] | cdktf.IResolvable;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#disk ElastigroupGke#disk}
    */
    readonly disk?: ElastigroupGkeDisk[] | cdktf.IResolvable;
    /**
    * gpu block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#gpu ElastigroupGke#gpu}
    */
    readonly gpu?: ElastigroupGkeGpu[] | cdktf.IResolvable;
    /**
    * instance_types_custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#instance_types_custom ElastigroupGke#instance_types_custom}
    */
    readonly instanceTypesCustom?: ElastigroupGkeInstanceTypesCustom[] | cdktf.IResolvable;
    /**
    * integration_docker_swarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#integration_docker_swarm ElastigroupGke#integration_docker_swarm}
    */
    readonly integrationDockerSwarm?: ElastigroupGkeIntegrationDockerSwarm;
    /**
    * integration_gke block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#integration_gke ElastigroupGke#integration_gke}
    */
    readonly integrationGke?: ElastigroupGkeIntegrationGke;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#labels ElastigroupGke#labels}
    */
    readonly labels?: ElastigroupGkeLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#metadata ElastigroupGke#metadata}
    */
    readonly metadata?: ElastigroupGkeMetadata[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#network_interface ElastigroupGke#network_interface}
    */
    readonly networkInterface?: ElastigroupGkeNetworkInterface[] | cdktf.IResolvable;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#scaling_down_policy ElastigroupGke#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupGkeScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#scaling_up_policy ElastigroupGke#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupGkeScalingUpPolicy[] | cdktf.IResolvable;
}
export interface ElastigroupGkeBackendServicesNamedPorts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#name ElastigroupGke#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#ports ElastigroupGke#ports}
    */
    readonly ports: string[];
}
export declare function elastigroupGkeBackendServicesNamedPortsToTerraform(struct?: ElastigroupGkeBackendServicesNamedPorts | cdktf.IResolvable): any;
export interface ElastigroupGkeBackendServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#location_type ElastigroupGke#location_type}
    */
    readonly locationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#scheme ElastigroupGke#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#service_name ElastigroupGke#service_name}
    */
    readonly serviceName: string;
    /**
    * named_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#named_ports ElastigroupGke#named_ports}
    */
    readonly namedPorts?: ElastigroupGkeBackendServicesNamedPorts[] | cdktf.IResolvable;
}
export declare function elastigroupGkeBackendServicesToTerraform(struct?: ElastigroupGkeBackendServices | cdktf.IResolvable): any;
export interface ElastigroupGkeDiskInitializeParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#disk_size_gb ElastigroupGke#disk_size_gb}
    */
    readonly diskSizeGb?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#disk_type ElastigroupGke#disk_type}
    */
    readonly diskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#source_image ElastigroupGke#source_image}
    */
    readonly sourceImage: string;
}
export declare function elastigroupGkeDiskInitializeParamsToTerraform(struct?: ElastigroupGkeDiskInitializeParams | cdktf.IResolvable): any;
export interface ElastigroupGkeDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#auto_delete ElastigroupGke#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#boot ElastigroupGke#boot}
    */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#device_name ElastigroupGke#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#interface ElastigroupGke#interface}
    */
    readonly interface?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#mode ElastigroupGke#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#source ElastigroupGke#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#type ElastigroupGke#type}
    */
    readonly type?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#initialize_params ElastigroupGke#initialize_params}
    */
    readonly initializeParams?: ElastigroupGkeDiskInitializeParams[] | cdktf.IResolvable;
}
export declare function elastigroupGkeDiskToTerraform(struct?: ElastigroupGkeDisk | cdktf.IResolvable): any;
export interface ElastigroupGkeGpu {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#count ElastigroupGke#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#type ElastigroupGke#type}
    */
    readonly type: string;
}
export declare function elastigroupGkeGpuToTerraform(struct?: ElastigroupGkeGpu | cdktf.IResolvable): any;
export interface ElastigroupGkeInstanceTypesCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#memory_gib ElastigroupGke#memory_gib}
    */
    readonly memoryGib: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#vcpu ElastigroupGke#vcpu}
    */
    readonly vcpu: number;
}
export declare function elastigroupGkeInstanceTypesCustomToTerraform(struct?: ElastigroupGkeInstanceTypesCustom | cdktf.IResolvable): any;
export interface ElastigroupGkeIntegrationDockerSwarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#master_host ElastigroupGke#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#master_port ElastigroupGke#master_port}
    */
    readonly masterPort: number;
}
export declare function elastigroupGkeIntegrationDockerSwarmToTerraform(struct?: ElastigroupGkeIntegrationDockerSwarmOutputReference | ElastigroupGkeIntegrationDockerSwarm): any;
export declare class ElastigroupGkeIntegrationDockerSwarmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGkeIntegrationDockerSwarm | undefined;
    set internalValue(value: ElastigroupGkeIntegrationDockerSwarm | undefined);
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _masterPort?;
    get masterPort(): number;
    set masterPort(value: number);
    get masterPortInput(): number | undefined;
}
export interface ElastigroupGkeIntegrationGkeAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#evaluation_periods ElastigroupGke#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
}
export declare function elastigroupGkeIntegrationGkeAutoscaleDownToTerraform(struct?: ElastigroupGkeIntegrationGkeAutoscaleDownOutputReference | ElastigroupGkeIntegrationGkeAutoscaleDown): any;
export declare class ElastigroupGkeIntegrationGkeAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGkeIntegrationGkeAutoscaleDown | undefined;
    set internalValue(value: ElastigroupGkeIntegrationGkeAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
}
export interface ElastigroupGkeIntegrationGkeAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cpu_per_unit ElastigroupGke#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#memory_per_unit ElastigroupGke#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#num_of_units ElastigroupGke#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupGkeIntegrationGkeAutoscaleHeadroomToTerraform(struct?: ElastigroupGkeIntegrationGkeAutoscaleHeadroomOutputReference | ElastigroupGkeIntegrationGkeAutoscaleHeadroom): any;
export declare class ElastigroupGkeIntegrationGkeAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGkeIntegrationGkeAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupGkeIntegrationGkeAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupGkeIntegrationGkeAutoscaleLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#key ElastigroupGke#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#value ElastigroupGke#value}
    */
    readonly value: string;
}
export declare function elastigroupGkeIntegrationGkeAutoscaleLabelsToTerraform(struct?: ElastigroupGkeIntegrationGkeAutoscaleLabels | cdktf.IResolvable): any;
export interface ElastigroupGkeIntegrationGke {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#auto_update ElastigroupGke#auto_update}
    */
    readonly autoUpdate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_cooldown ElastigroupGke#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_is_auto_config ElastigroupGke#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_is_enabled ElastigroupGke#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cluster_id ElastigroupGke#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#location ElastigroupGke#location}
    */
    readonly location?: string;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_down ElastigroupGke#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupGkeIntegrationGkeAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_headroom ElastigroupGke#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupGkeIntegrationGkeAutoscaleHeadroom;
    /**
    * autoscale_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#autoscale_labels ElastigroupGke#autoscale_labels}
    */
    readonly autoscaleLabels?: ElastigroupGkeIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
}
export declare function elastigroupGkeIntegrationGkeToTerraform(struct?: ElastigroupGkeIntegrationGkeOutputReference | ElastigroupGkeIntegrationGke): any;
export declare class ElastigroupGkeIntegrationGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGkeIntegrationGke | undefined;
    set internalValue(value: ElastigroupGkeIntegrationGke | undefined);
    private _autoUpdate?;
    get autoUpdate(): boolean | cdktf.IResolvable;
    set autoUpdate(value: boolean | cdktf.IResolvable);
    resetAutoUpdate(): void;
    get autoUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupGkeIntegrationGkeAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupGkeIntegrationGkeAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupGkeIntegrationGkeAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupGkeIntegrationGkeAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupGkeIntegrationGkeAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupGkeIntegrationGkeAutoscaleHeadroom | undefined;
    private _autoscaleLabels?;
    get autoscaleLabels(): ElastigroupGkeIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
    set autoscaleLabels(value: ElastigroupGkeIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable);
    resetAutoscaleLabels(): void;
    get autoscaleLabelsInput(): cdktf.IResolvable | ElastigroupGkeIntegrationGkeAutoscaleLabels[] | undefined;
}
export interface ElastigroupGkeLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#key ElastigroupGke#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#value ElastigroupGke#value}
    */
    readonly value: string;
}
export declare function elastigroupGkeLabelsToTerraform(struct?: ElastigroupGkeLabels | cdktf.IResolvable): any;
export interface ElastigroupGkeMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#key ElastigroupGke#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#value ElastigroupGke#value}
    */
    readonly value: string;
}
export declare function elastigroupGkeMetadataToTerraform(struct?: ElastigroupGkeMetadata | cdktf.IResolvable): any;
export interface ElastigroupGkeNetworkInterfaceAccessConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#name ElastigroupGke#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#type ElastigroupGke#type}
    */
    readonly type?: string;
}
export declare function elastigroupGkeNetworkInterfaceAccessConfigsToTerraform(struct?: ElastigroupGkeNetworkInterfaceAccessConfigs | cdktf.IResolvable): any;
export interface ElastigroupGkeNetworkInterfaceAliasIpRanges {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#ip_cidr_range ElastigroupGke#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#subnetwork_range_name ElastigroupGke#subnetwork_range_name}
    */
    readonly subnetworkRangeName: string;
}
export declare function elastigroupGkeNetworkInterfaceAliasIpRangesToTerraform(struct?: ElastigroupGkeNetworkInterfaceAliasIpRanges | cdktf.IResolvable): any;
export interface ElastigroupGkeNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#network ElastigroupGke#network}
    */
    readonly network: string;
    /**
    * access_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#access_configs ElastigroupGke#access_configs}
    */
    readonly accessConfigs?: ElastigroupGkeNetworkInterfaceAccessConfigs[] | cdktf.IResolvable;
    /**
    * alias_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#alias_ip_ranges ElastigroupGke#alias_ip_ranges}
    */
    readonly aliasIpRanges?: ElastigroupGkeNetworkInterfaceAliasIpRanges[] | cdktf.IResolvable;
}
export declare function elastigroupGkeNetworkInterfaceToTerraform(struct?: ElastigroupGkeNetworkInterface | cdktf.IResolvable): any;
export interface ElastigroupGkeScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#name ElastigroupGke#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#value ElastigroupGke#value}
    */
    readonly value?: string;
}
export declare function elastigroupGkeScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupGkeScalingDownPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupGkeScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#action_type ElastigroupGke#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#adjustment ElastigroupGke#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cooldown ElastigroupGke#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#evaluation_periods ElastigroupGke#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#metric_name ElastigroupGke#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#namespace ElastigroupGke#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#operator ElastigroupGke#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#period ElastigroupGke#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#policy_name ElastigroupGke#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#source ElastigroupGke#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#statistic ElastigroupGke#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#threshold ElastigroupGke#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#unit ElastigroupGke#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#dimensions ElastigroupGke#dimensions}
    */
    readonly dimensions?: ElastigroupGkeScalingDownPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGkeScalingDownPolicyToTerraform(struct?: ElastigroupGkeScalingDownPolicy | cdktf.IResolvable): any;
export interface ElastigroupGkeScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#name ElastigroupGke#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#value ElastigroupGke#value}
    */
    readonly value?: string;
}
export declare function elastigroupGkeScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupGkeScalingUpPolicyDimensions | cdktf.IResolvable): any;
export interface ElastigroupGkeScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#action_type ElastigroupGke#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#adjustment ElastigroupGke#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#cooldown ElastigroupGke#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#evaluation_periods ElastigroupGke#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#metric_name ElastigroupGke#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#namespace ElastigroupGke#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#operator ElastigroupGke#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#period ElastigroupGke#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#policy_name ElastigroupGke#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#source ElastigroupGke#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#statistic ElastigroupGke#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#threshold ElastigroupGke#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#unit ElastigroupGke#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke#dimensions ElastigroupGke#dimensions}
    */
    readonly dimensions?: ElastigroupGkeScalingUpPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGkeScalingUpPolicyToTerraform(struct?: ElastigroupGkeScalingUpPolicy | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke spotinst_elastigroup_gke}
*/
export declare class ElastigroupGke extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_gke";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gke spotinst_elastigroup_gke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupGkeConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupGkeConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterZoneName?;
    get clusterZoneName(): string;
    set clusterZoneName(value: string);
    get clusterZoneNameInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _instanceTypesOndemand?;
    get instanceTypesOndemand(): string;
    set instanceTypesOndemand(value: string);
    resetInstanceTypesOndemand(): void;
    get instanceTypesOndemandInput(): string | undefined;
    private _instanceTypesPreemptible?;
    get instanceTypesPreemptible(): string[];
    set instanceTypesPreemptible(value: string[]);
    resetInstanceTypesPreemptible(): void;
    get instanceTypesPreemptibleInput(): string[] | undefined;
    private _ipForwarding?;
    get ipForwarding(): boolean | cdktf.IResolvable;
    set ipForwarding(value: boolean | cdktf.IResolvable);
    resetIpForwarding(): void;
    get ipForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeImage?;
    get nodeImage(): string;
    set nodeImage(value: string);
    resetNodeImage(): void;
    get nodeImageInput(): string | undefined;
    private _ondemandCount?;
    get ondemandCount(): number;
    set ondemandCount(value: number);
    resetOndemandCount(): void;
    get ondemandCountInput(): number | undefined;
    private _preemptiblePercentage?;
    get preemptiblePercentage(): number;
    set preemptiblePercentage(value: number);
    resetPreemptiblePercentage(): void;
    get preemptiblePercentageInput(): number | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _startupScript?;
    get startupScript(): string;
    set startupScript(value: string);
    resetStartupScript(): void;
    get startupScriptInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _backendServices?;
    get backendServices(): ElastigroupGkeBackendServices[] | cdktf.IResolvable;
    set backendServices(value: ElastigroupGkeBackendServices[] | cdktf.IResolvable);
    resetBackendServices(): void;
    get backendServicesInput(): cdktf.IResolvable | ElastigroupGkeBackendServices[] | undefined;
    private _disk?;
    get disk(): ElastigroupGkeDisk[] | cdktf.IResolvable;
    set disk(value: ElastigroupGkeDisk[] | cdktf.IResolvable);
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | ElastigroupGkeDisk[] | undefined;
    private _gpu?;
    get gpu(): ElastigroupGkeGpu[] | cdktf.IResolvable;
    set gpu(value: ElastigroupGkeGpu[] | cdktf.IResolvable);
    resetGpu(): void;
    get gpuInput(): cdktf.IResolvable | ElastigroupGkeGpu[] | undefined;
    private _instanceTypesCustom?;
    get instanceTypesCustom(): ElastigroupGkeInstanceTypesCustom[] | cdktf.IResolvable;
    set instanceTypesCustom(value: ElastigroupGkeInstanceTypesCustom[] | cdktf.IResolvable);
    resetInstanceTypesCustom(): void;
    get instanceTypesCustomInput(): cdktf.IResolvable | ElastigroupGkeInstanceTypesCustom[] | undefined;
    private _integrationDockerSwarm;
    get integrationDockerSwarm(): ElastigroupGkeIntegrationDockerSwarmOutputReference;
    putIntegrationDockerSwarm(value: ElastigroupGkeIntegrationDockerSwarm): void;
    resetIntegrationDockerSwarm(): void;
    get integrationDockerSwarmInput(): ElastigroupGkeIntegrationDockerSwarm | undefined;
    private _integrationGke;
    get integrationGke(): ElastigroupGkeIntegrationGkeOutputReference;
    putIntegrationGke(value: ElastigroupGkeIntegrationGke): void;
    resetIntegrationGke(): void;
    get integrationGkeInput(): ElastigroupGkeIntegrationGke | undefined;
    private _labels?;
    get labels(): ElastigroupGkeLabels[] | cdktf.IResolvable;
    set labels(value: ElastigroupGkeLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ElastigroupGkeLabels[] | undefined;
    private _metadata?;
    get metadata(): ElastigroupGkeMetadata[] | cdktf.IResolvable;
    set metadata(value: ElastigroupGkeMetadata[] | cdktf.IResolvable);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | ElastigroupGkeMetadata[] | undefined;
    private _networkInterface?;
    get networkInterface(): ElastigroupGkeNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: ElastigroupGkeNetworkInterface[] | cdktf.IResolvable);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ElastigroupGkeNetworkInterface[] | undefined;
    private _scalingDownPolicy?;
    get scalingDownPolicy(): ElastigroupGkeScalingDownPolicy[] | cdktf.IResolvable;
    set scalingDownPolicy(value: ElastigroupGkeScalingDownPolicy[] | cdktf.IResolvable);
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupGkeScalingDownPolicy[] | undefined;
    private _scalingUpPolicy?;
    get scalingUpPolicy(): ElastigroupGkeScalingUpPolicy[] | cdktf.IResolvable;
    set scalingUpPolicy(value: ElastigroupGkeScalingUpPolicy[] | cdktf.IResolvable);
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupGkeScalingUpPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
