import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#name HealthCheck#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#proxy_address HealthCheck#proxy_address}
    */
    readonly proxyAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#proxy_port HealthCheck#proxy_port}
    */
    readonly proxyPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#resource_id HealthCheck#resource_id}
    */
    readonly resourceId: string;
    /**
    * check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#check HealthCheck#check}
    */
    readonly check?: HealthCheckCheck;
}
export interface HealthCheckCheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#end_point HealthCheck#end_point}
    */
    readonly endPoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#endpoint HealthCheck#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#healthy HealthCheck#healthy}
    */
    readonly healthy: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#interval HealthCheck#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#port HealthCheck#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#protocol HealthCheck#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#time_out HealthCheck#time_out}
    */
    readonly timeOut?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#timeout HealthCheck#timeout}
    */
    readonly timeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/health_check#unhealthy HealthCheck#unhealthy}
    */
    readonly unhealthy: number;
}
export declare function healthCheckCheckToTerraform(struct?: HealthCheckCheckOutputReference | HealthCheckCheck): any;
export declare class HealthCheckCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthCheckCheck | undefined;
    set internalValue(value: HealthCheckCheck | undefined);
    private _endPoint?;
    get endPoint(): string;
    set endPoint(value: string);
    resetEndPoint(): void;
    get endPointInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _healthy?;
    get healthy(): number;
    set healthy(value: number);
    get healthyInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _timeOut?;
    get timeOut(): number;
    set timeOut(value: number);
    resetTimeOut(): void;
    get timeOutInput(): number | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _unhealthy?;
    get unhealthy(): number;
    set unhealthy(value: number);
    get unhealthyInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/health_check spotinst_health_check}
*/
export declare class HealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_health_check";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/health_check spotinst_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: HealthCheckConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _proxyAddress?;
    get proxyAddress(): string;
    set proxyAddress(value: string);
    get proxyAddressInput(): string | undefined;
    private _proxyPort?;
    get proxyPort(): number;
    set proxyPort(value: number);
    resetProxyPort(): void;
    get proxyPortInput(): number | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _check;
    get check(): HealthCheckCheckOutputReference;
    putCheck(value: HealthCheckCheck): void;
    resetCheck(): void;
    get checkInput(): HealthCheckCheck | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
