import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedInstanceAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#auto_healing ManagedInstanceAws#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#block_devices_mode ManagedInstanceAws#block_devices_mode}
    */
    readonly blockDevicesMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#cpu_credits ManagedInstanceAws#cpu_credits}
    */
    readonly cpuCredits?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#description ManagedInstanceAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#draining_timeout ManagedInstanceAws#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#ebs_optimized ManagedInstanceAws#ebs_optimized}
    */
    readonly ebsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#elastic_ip ManagedInstanceAws#elastic_ip}
    */
    readonly elasticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#enable_monitoring ManagedInstanceAws#enable_monitoring}
    */
    readonly enableMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#fall_back_to_od ManagedInstanceAws#fall_back_to_od}
    */
    readonly fallBackToOd?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#grace_period ManagedInstanceAws#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#health_check_type ManagedInstanceAws#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#iam_instance_profile ManagedInstanceAws#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#image_id ManagedInstanceAws#image_id}
    */
    readonly imageId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#instance_types ManagedInstanceAws#instance_types}
    */
    readonly instanceTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#key_pair ManagedInstanceAws#key_pair}
    */
    readonly keyPair?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#life_cycle ManagedInstanceAws#life_cycle}
    */
    readonly lifeCycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#minimum_instance_lifetime ManagedInstanceAws#minimum_instance_lifetime}
    */
    readonly minimumInstanceLifetime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#optimization_windows ManagedInstanceAws#optimization_windows}
    */
    readonly optimizationWindows?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#orientation ManagedInstanceAws#orientation}
    */
    readonly orientation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_block_devices ManagedInstanceAws#persist_block_devices}
    */
    readonly persistBlockDevices: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_private_ip ManagedInstanceAws#persist_private_ip}
    */
    readonly persistPrivateIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_root_device ManagedInstanceAws#persist_root_device}
    */
    readonly persistRootDevice?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#placement_tenancy ManagedInstanceAws#placement_tenancy}
    */
    readonly placementTenancy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#preferred_type ManagedInstanceAws#preferred_type}
    */
    readonly preferredType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#private_ip ManagedInstanceAws#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#product ManagedInstanceAws#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#region ManagedInstanceAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#security_group_ids ManagedInstanceAws#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#shutdown_script ManagedInstanceAws#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#subnet_ids ManagedInstanceAws#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#unhealthy_duration ManagedInstanceAws#unhealthy_duration}
    */
    readonly unhealthyDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#user_data ManagedInstanceAws#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#utilize_reserved_instances ManagedInstanceAws#utilize_reserved_instances}
    */
    readonly utilizeReservedInstances?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#vpc_id ManagedInstanceAws#vpc_id}
    */
    readonly vpcId: string;
    /**
    * block_device_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#block_device_mappings ManagedInstanceAws#block_device_mappings}
    */
    readonly blockDeviceMappings?: ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * integration_route53 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#integration_route53 ManagedInstanceAws#integration_route53}
    */
    readonly integrationRoute53?: ManagedInstanceAwsIntegrationRoute53;
    /**
    * load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#load_balancers ManagedInstanceAws#load_balancers}
    */
    readonly loadBalancers?: ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable;
    /**
    * managed_instance_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#managed_instance_action ManagedInstanceAws#managed_instance_action}
    */
    readonly managedInstanceAction?: ManagedInstanceAwsManagedInstanceAction;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#network_interface ManagedInstanceAws#network_interface}
    */
    readonly networkInterface?: ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable;
    /**
    * resource_tag_specification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#resource_tag_specification ManagedInstanceAws#resource_tag_specification}
    */
    readonly resourceTagSpecification?: ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable;
    /**
    * revert_to_spot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#revert_to_spot ManagedInstanceAws#revert_to_spot}
    */
    readonly revertToSpot?: ManagedInstanceAwsRevertToSpot;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#scheduled_task ManagedInstanceAws#scheduled_task}
    */
    readonly scheduledTask?: ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#tags ManagedInstanceAws#tags}
    */
    readonly tags?: ManagedInstanceAwsTags[] | cdktf.IResolvable;
}
export interface ManagedInstanceAwsBlockDeviceMappingsEbs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#delete_on_termination ManagedInstanceAws#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#iops ManagedInstanceAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#throughput ManagedInstanceAws#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#volume_size ManagedInstanceAws#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#volume_type ManagedInstanceAws#volume_type}
    */
    readonly volumeType?: string;
}
export declare function managedInstanceAwsBlockDeviceMappingsEbsToTerraform(struct?: ManagedInstanceAwsBlockDeviceMappingsEbsOutputReference | ManagedInstanceAwsBlockDeviceMappingsEbs): any;
export declare class ManagedInstanceAwsBlockDeviceMappingsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsBlockDeviceMappingsEbs | undefined;
    set internalValue(value: ManagedInstanceAwsBlockDeviceMappingsEbs | undefined);
    private _deleteOnTermination?;
    get deleteOnTermination(): boolean | cdktf.IResolvable;
    set deleteOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOnTermination(): void;
    get deleteOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface ManagedInstanceAwsBlockDeviceMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#device_name ManagedInstanceAws#device_name}
    */
    readonly deviceName: string;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#ebs ManagedInstanceAws#ebs}
    */
    readonly ebs?: ManagedInstanceAwsBlockDeviceMappingsEbs;
}
export declare function managedInstanceAwsBlockDeviceMappingsToTerraform(struct?: ManagedInstanceAwsBlockDeviceMappings | cdktf.IResolvable): any;
export interface ManagedInstanceAwsIntegrationRoute53DomainsRecordSets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#use_public_dns ManagedInstanceAws#use_public_dns}
    */
    readonly usePublicDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#use_public_ip ManagedInstanceAws#use_public_ip}
    */
    readonly usePublicIp?: boolean | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53DomainsRecordSetsToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets | cdktf.IResolvable): any;
export interface ManagedInstanceAwsIntegrationRoute53Domains {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#hosted_zone_id ManagedInstanceAws#hosted_zone_id}
    */
    readonly hostedZoneId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#record_set_type ManagedInstanceAws#record_set_type}
    */
    readonly recordSetType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#spotinst_acct_id ManagedInstanceAws#spotinst_acct_id}
    */
    readonly spotinstAcctId?: string;
    /**
    * record_sets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#record_sets ManagedInstanceAws#record_sets}
    */
    readonly recordSets: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets[] | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53DomainsToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53Domains | cdktf.IResolvable): any;
export interface ManagedInstanceAwsIntegrationRoute53 {
    /**
    * domains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#domains ManagedInstanceAws#domains}
    */
    readonly domains: ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53ToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53OutputReference | ManagedInstanceAwsIntegrationRoute53): any;
export declare class ManagedInstanceAwsIntegrationRoute53OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsIntegrationRoute53 | undefined;
    set internalValue(value: ManagedInstanceAwsIntegrationRoute53 | undefined);
    private _domains?;
    get domains(): ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
    set domains(value: ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable);
    get domainsInput(): cdktf.IResolvable | ManagedInstanceAwsIntegrationRoute53Domains[] | undefined;
}
export interface ManagedInstanceAwsLoadBalancers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#arn ManagedInstanceAws#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#auto_weight ManagedInstanceAws#auto_weight}
    */
    readonly autoWeight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#az_awareness ManagedInstanceAws#az_awareness}
    */
    readonly azAwareness?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#balancer_id ManagedInstanceAws#balancer_id}
    */
    readonly balancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#target_set_id ManagedInstanceAws#target_set_id}
    */
    readonly targetSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#type ManagedInstanceAws#type}
    */
    readonly type: string;
}
export declare function managedInstanceAwsLoadBalancersToTerraform(struct?: ManagedInstanceAwsLoadBalancers | cdktf.IResolvable): any;
export interface ManagedInstanceAwsManagedInstanceAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#type ManagedInstanceAws#type}
    */
    readonly type: string;
}
export declare function managedInstanceAwsManagedInstanceActionToTerraform(struct?: ManagedInstanceAwsManagedInstanceActionOutputReference | ManagedInstanceAwsManagedInstanceAction): any;
export declare class ManagedInstanceAwsManagedInstanceActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsManagedInstanceAction | undefined;
    set internalValue(value: ManagedInstanceAwsManagedInstanceAction | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ManagedInstanceAwsNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#associate_ipv6_address ManagedInstanceAws#associate_ipv6_address}
    */
    readonly associateIpv6Address?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#associate_public_ip_address ManagedInstanceAws#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#device_index ManagedInstanceAws#device_index}
    */
    readonly deviceIndex: string;
}
export declare function managedInstanceAwsNetworkInterfaceToTerraform(struct?: ManagedInstanceAwsNetworkInterface | cdktf.IResolvable): any;
export interface ManagedInstanceAwsResourceTagSpecification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_amis ManagedInstanceAws#should_tag_amis}
    */
    readonly shouldTagAmis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_enis ManagedInstanceAws#should_tag_enis}
    */
    readonly shouldTagEnis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_snapshots ManagedInstanceAws#should_tag_snapshots}
    */
    readonly shouldTagSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_volumes ManagedInstanceAws#should_tag_volumes}
    */
    readonly shouldTagVolumes?: boolean | cdktf.IResolvable;
}
export declare function managedInstanceAwsResourceTagSpecificationToTerraform(struct?: ManagedInstanceAwsResourceTagSpecification | cdktf.IResolvable): any;
export interface ManagedInstanceAwsRevertToSpot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#perform_at ManagedInstanceAws#perform_at}
    */
    readonly performAt: string;
}
export declare function managedInstanceAwsRevertToSpotToTerraform(struct?: ManagedInstanceAwsRevertToSpotOutputReference | ManagedInstanceAwsRevertToSpot): any;
export declare class ManagedInstanceAwsRevertToSpotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsRevertToSpot | undefined;
    set internalValue(value: ManagedInstanceAwsRevertToSpot | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    get performAtInput(): string | undefined;
}
export interface ManagedInstanceAwsScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#cron_expression ManagedInstanceAws#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#frequency ManagedInstanceAws#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#is_enabled ManagedInstanceAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#start_time ManagedInstanceAws#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#task_type ManagedInstanceAws#task_type}
    */
    readonly taskType: string;
}
export declare function managedInstanceAwsScheduledTaskToTerraform(struct?: ManagedInstanceAwsScheduledTask | cdktf.IResolvable): any;
export interface ManagedInstanceAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#key ManagedInstanceAws#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#value ManagedInstanceAws#value}
    */
    readonly value?: string;
}
export declare function managedInstanceAwsTagsToTerraform(struct?: ManagedInstanceAwsTags | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws spotinst_managed_instance_aws}
*/
export declare class ManagedInstanceAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_managed_instance_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws spotinst_managed_instance_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedInstanceAwsConfig
    */
    constructor(scope: Construct, id: string, config: ManagedInstanceAwsConfig);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _blockDevicesMode?;
    get blockDevicesMode(): string;
    set blockDevicesMode(value: string);
    resetBlockDevicesMode(): void;
    get blockDevicesModeInput(): string | undefined;
    private _cpuCredits?;
    get cpuCredits(): string;
    set cpuCredits(value: string);
    resetCpuCredits(): void;
    get cpuCreditsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _ebsOptimized?;
    get ebsOptimized(): boolean | cdktf.IResolvable;
    set ebsOptimized(value: boolean | cdktf.IResolvable);
    resetEbsOptimized(): void;
    get ebsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticIp?;
    get elasticIp(): string;
    set elasticIp(value: string);
    resetElasticIp(): void;
    get elasticIpInput(): string | undefined;
    private _enableMonitoring?;
    get enableMonitoring(): boolean | cdktf.IResolvable;
    set enableMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableMonitoring(): void;
    get enableMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _fallBackToOd?;
    get fallBackToOd(): boolean | cdktf.IResolvable;
    set fallBackToOd(value: boolean | cdktf.IResolvable);
    resetFallBackToOd(): void;
    get fallBackToOdInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    get imageIdInput(): string | undefined;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    get instanceTypesInput(): string[] | undefined;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    resetKeyPair(): void;
    get keyPairInput(): string | undefined;
    private _lifeCycle?;
    get lifeCycle(): string;
    set lifeCycle(value: string);
    resetLifeCycle(): void;
    get lifeCycleInput(): string | undefined;
    private _minimumInstanceLifetime?;
    get minimumInstanceLifetime(): number;
    set minimumInstanceLifetime(value: number);
    resetMinimumInstanceLifetime(): void;
    get minimumInstanceLifetimeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optimizationWindows?;
    get optimizationWindows(): string[];
    set optimizationWindows(value: string[]);
    resetOptimizationWindows(): void;
    get optimizationWindowsInput(): string[] | undefined;
    private _orientation?;
    get orientation(): string;
    set orientation(value: string);
    resetOrientation(): void;
    get orientationInput(): string | undefined;
    private _persistBlockDevices?;
    get persistBlockDevices(): boolean | cdktf.IResolvable;
    set persistBlockDevices(value: boolean | cdktf.IResolvable);
    get persistBlockDevicesInput(): boolean | cdktf.IResolvable | undefined;
    private _persistPrivateIp?;
    get persistPrivateIp(): boolean | cdktf.IResolvable;
    set persistPrivateIp(value: boolean | cdktf.IResolvable);
    resetPersistPrivateIp(): void;
    get persistPrivateIpInput(): boolean | cdktf.IResolvable | undefined;
    private _persistRootDevice?;
    get persistRootDevice(): boolean | cdktf.IResolvable;
    set persistRootDevice(value: boolean | cdktf.IResolvable);
    resetPersistRootDevice(): void;
    get persistRootDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _placementTenancy?;
    get placementTenancy(): string;
    set placementTenancy(value: string);
    resetPlacementTenancy(): void;
    get placementTenancyInput(): string | undefined;
    private _preferredType?;
    get preferredType(): string;
    set preferredType(value: string);
    resetPreferredType(): void;
    get preferredTypeInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _unhealthyDuration?;
    get unhealthyDuration(): number;
    set unhealthyDuration(value: number);
    resetUnhealthyDuration(): void;
    get unhealthyDurationInput(): number | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _utilizeReservedInstances?;
    get utilizeReservedInstances(): boolean | cdktf.IResolvable;
    set utilizeReservedInstances(value: boolean | cdktf.IResolvable);
    resetUtilizeReservedInstances(): void;
    get utilizeReservedInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _blockDeviceMappings?;
    get blockDeviceMappings(): ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable;
    set blockDeviceMappings(value: ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable);
    resetBlockDeviceMappings(): void;
    get blockDeviceMappingsInput(): cdktf.IResolvable | ManagedInstanceAwsBlockDeviceMappings[] | undefined;
    private _integrationRoute53;
    get integrationRoute53(): ManagedInstanceAwsIntegrationRoute53OutputReference;
    putIntegrationRoute53(value: ManagedInstanceAwsIntegrationRoute53): void;
    resetIntegrationRoute53(): void;
    get integrationRoute53Input(): ManagedInstanceAwsIntegrationRoute53 | undefined;
    private _loadBalancers?;
    get loadBalancers(): ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable;
    set loadBalancers(value: ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable);
    resetLoadBalancers(): void;
    get loadBalancersInput(): cdktf.IResolvable | ManagedInstanceAwsLoadBalancers[] | undefined;
    private _managedInstanceAction;
    get managedInstanceAction(): ManagedInstanceAwsManagedInstanceActionOutputReference;
    putManagedInstanceAction(value: ManagedInstanceAwsManagedInstanceAction): void;
    resetManagedInstanceAction(): void;
    get managedInstanceActionInput(): ManagedInstanceAwsManagedInstanceAction | undefined;
    private _networkInterface?;
    get networkInterface(): ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ManagedInstanceAwsNetworkInterface[] | undefined;
    private _resourceTagSpecification?;
    get resourceTagSpecification(): ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable;
    set resourceTagSpecification(value: ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable);
    resetResourceTagSpecification(): void;
    get resourceTagSpecificationInput(): cdktf.IResolvable | ManagedInstanceAwsResourceTagSpecification[] | undefined;
    private _revertToSpot;
    get revertToSpot(): ManagedInstanceAwsRevertToSpotOutputReference;
    putRevertToSpot(value: ManagedInstanceAwsRevertToSpot): void;
    resetRevertToSpot(): void;
    get revertToSpotInput(): ManagedInstanceAwsRevertToSpot | undefined;
    private _scheduledTask?;
    get scheduledTask(): ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ManagedInstanceAwsScheduledTask[] | undefined;
    private _tags?;
    get tags(): ManagedInstanceAwsTags[] | cdktf.IResolvable;
    set tags(value: ManagedInstanceAwsTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | ManagedInstanceAwsTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
