import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MrscalerAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_info MrscalerAws#additional_info}
    */
    readonly additionalInfo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_primary_security_groups MrscalerAws#additional_primary_security_groups}
    */
    readonly additionalPrimarySecurityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_replica_security_groups MrscalerAws#additional_replica_security_groups}
    */
    readonly additionalReplicaSecurityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#availability_zones MrscalerAws#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cluster_id MrscalerAws#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_desired_capacity MrscalerAws#core_desired_capacity}
    */
    readonly coreDesiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_ebs_optimized MrscalerAws#core_ebs_optimized}
    */
    readonly coreEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_instance_types MrscalerAws#core_instance_types}
    */
    readonly coreInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_lifecycle MrscalerAws#core_lifecycle}
    */
    readonly coreLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_max_size MrscalerAws#core_max_size}
    */
    readonly coreMaxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_min_size MrscalerAws#core_min_size}
    */
    readonly coreMinSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_unit MrscalerAws#core_unit}
    */
    readonly coreUnit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#custom_ami_id MrscalerAws#custom_ami_id}
    */
    readonly customAmiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#description MrscalerAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#ebs_root_volume_size MrscalerAws#ebs_root_volume_size}
    */
    readonly ebsRootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#ec2_key_name MrscalerAws#ec2_key_name}
    */
    readonly ec2KeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#expose_cluster_id MrscalerAws#expose_cluster_id}
    */
    readonly exposeClusterId?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#job_flow_role MrscalerAws#job_flow_role}
    */
    readonly jobFlowRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#keep_job_flow_alive MrscalerAws#keep_job_flow_alive}
    */
    readonly keepJobFlowAlive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#log_uri MrscalerAws#log_uri}
    */
    readonly logUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#managed_primary_security_group MrscalerAws#managed_primary_security_group}
    */
    readonly managedPrimarySecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#managed_replica_security_group MrscalerAws#managed_replica_security_group}
    */
    readonly managedReplicaSecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_ebs_optimized MrscalerAws#master_ebs_optimized}
    */
    readonly masterEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_instance_types MrscalerAws#master_instance_types}
    */
    readonly masterInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_lifecycle MrscalerAws#master_lifecycle}
    */
    readonly masterLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_target MrscalerAws#master_target}
    */
    readonly masterTarget?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#name MrscalerAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#region MrscalerAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#release_label MrscalerAws#release_label}
    */
    readonly releaseLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#repo_upgrade_on_boot MrscalerAws#repo_upgrade_on_boot}
    */
    readonly repoUpgradeOnBoot?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#retries MrscalerAws#retries}
    */
    readonly retries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#security_config MrscalerAws#security_config}
    */
    readonly securityConfig?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#service_access_security_group MrscalerAws#service_access_security_group}
    */
    readonly serviceAccessSecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#service_role MrscalerAws#service_role}
    */
    readonly serviceRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#strategy MrscalerAws#strategy}
    */
    readonly strategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_desired_capacity MrscalerAws#task_desired_capacity}
    */
    readonly taskDesiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_ebs_optimized MrscalerAws#task_ebs_optimized}
    */
    readonly taskEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_instance_types MrscalerAws#task_instance_types}
    */
    readonly taskInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_lifecycle MrscalerAws#task_lifecycle}
    */
    readonly taskLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_max_size MrscalerAws#task_max_size}
    */
    readonly taskMaxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_min_size MrscalerAws#task_min_size}
    */
    readonly taskMinSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_unit MrscalerAws#task_unit}
    */
    readonly taskUnit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#termination_protected MrscalerAws#termination_protected}
    */
    readonly terminationProtected?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#visible_to_all_users MrscalerAws#visible_to_all_users}
    */
    readonly visibleToAllUsers?: boolean | cdktf.IResolvable;
    /**
    * applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#applications MrscalerAws#applications}
    */
    readonly applications?: MrscalerAwsApplications[] | cdktf.IResolvable;
    /**
    * bootstrap_actions_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bootstrap_actions_file MrscalerAws#bootstrap_actions_file}
    */
    readonly bootstrapActionsFile?: MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable;
    /**
    * configurations_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#configurations_file MrscalerAws#configurations_file}
    */
    readonly configurationsFile?: MrscalerAwsConfigurationsFile[] | cdktf.IResolvable;
    /**
    * core_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_ebs_block_device MrscalerAws#core_ebs_block_device}
    */
    readonly coreEbsBlockDevice?: MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * core_scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_scaling_down_policy MrscalerAws#core_scaling_down_policy}
    */
    readonly coreScalingDownPolicy?: MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * core_scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_scaling_up_policy MrscalerAws#core_scaling_up_policy}
    */
    readonly coreScalingUpPolicy?: MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * instance_weights block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_weights MrscalerAws#instance_weights}
    */
    readonly instanceWeights?: MrscalerAwsInstanceWeights[] | cdktf.IResolvable;
    /**
    * master_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_ebs_block_device MrscalerAws#master_ebs_block_device}
    */
    readonly masterEbsBlockDevice?: MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * provisioning_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#provisioning_timeout MrscalerAws#provisioning_timeout}
    */
    readonly provisioningTimeout?: MrscalerAwsProvisioningTimeout;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#scheduled_task MrscalerAws#scheduled_task}
    */
    readonly scheduledTask?: MrscalerAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * steps_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#steps_file MrscalerAws#steps_file}
    */
    readonly stepsFile?: MrscalerAwsStepsFile[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#tags MrscalerAws#tags}
    */
    readonly tags?: MrscalerAwsTags[] | cdktf.IResolvable;
    /**
    * task_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_ebs_block_device MrscalerAws#task_ebs_block_device}
    */
    readonly taskEbsBlockDevice?: MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * task_scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_scaling_down_policy MrscalerAws#task_scaling_down_policy}
    */
    readonly taskScalingDownPolicy?: MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * task_scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_scaling_up_policy MrscalerAws#task_scaling_up_policy}
    */
    readonly taskScalingUpPolicy?: MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * termination_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#termination_policies MrscalerAws#termination_policies}
    */
    readonly terminationPolicies?: MrscalerAwsTerminationPolicies[] | cdktf.IResolvable;
}
export interface MrscalerAwsApplications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#args MrscalerAws#args}
    */
    readonly args?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#name MrscalerAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#version MrscalerAws#version}
    */
    readonly version?: string;
}
export declare function mrscalerAwsApplicationsToTerraform(struct?: MrscalerAwsApplications | cdktf.IResolvable): any;
export interface MrscalerAwsBootstrapActionsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsBootstrapActionsFileToTerraform(struct?: MrscalerAwsBootstrapActionsFile | cdktf.IResolvable): any;
export interface MrscalerAwsConfigurationsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsConfigurationsFileToTerraform(struct?: MrscalerAwsConfigurationsFile | cdktf.IResolvable): any;
export interface MrscalerAwsCoreEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsCoreEbsBlockDeviceToTerraform(struct?: MrscalerAwsCoreEbsBlockDevice | cdktf.IResolvable): any;
export interface MrscalerAwsCoreScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsCoreScalingDownPolicyToTerraform(struct?: MrscalerAwsCoreScalingDownPolicy | cdktf.IResolvable): any;
export interface MrscalerAwsCoreScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsCoreScalingUpPolicyToTerraform(struct?: MrscalerAwsCoreScalingUpPolicy | cdktf.IResolvable): any;
export interface MrscalerAwsInstanceWeights {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_type MrscalerAws#instance_type}
    */
    readonly instanceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#weighted_capacity MrscalerAws#weighted_capacity}
    */
    readonly weightedCapacity: number;
}
export declare function mrscalerAwsInstanceWeightsToTerraform(struct?: MrscalerAwsInstanceWeights | cdktf.IResolvable): any;
export interface MrscalerAwsMasterEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsMasterEbsBlockDeviceToTerraform(struct?: MrscalerAwsMasterEbsBlockDevice | cdktf.IResolvable): any;
export interface MrscalerAwsProvisioningTimeout {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#timeout MrscalerAws#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#timeout_action MrscalerAws#timeout_action}
    */
    readonly timeoutAction: string;
}
export declare function mrscalerAwsProvisioningTimeoutToTerraform(struct?: MrscalerAwsProvisioningTimeoutOutputReference | MrscalerAwsProvisioningTimeout): any;
export declare class MrscalerAwsProvisioningTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MrscalerAwsProvisioningTimeout | undefined;
    set internalValue(value: MrscalerAwsProvisioningTimeout | undefined);
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _timeoutAction?;
    get timeoutAction(): string;
    set timeoutAction(value: string);
    get timeoutActionInput(): string | undefined;
}
export interface MrscalerAwsScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cron MrscalerAws#cron}
    */
    readonly cron: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#desired_capacity MrscalerAws#desired_capacity}
    */
    readonly desiredCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_group_type MrscalerAws#instance_group_type}
    */
    readonly instanceGroupType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#is_enabled MrscalerAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_capacity MrscalerAws#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_capacity MrscalerAws#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_type MrscalerAws#task_type}
    */
    readonly taskType: string;
}
export declare function mrscalerAwsScheduledTaskToTerraform(struct?: MrscalerAwsScheduledTask | cdktf.IResolvable): any;
export interface MrscalerAwsStepsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsStepsFileToTerraform(struct?: MrscalerAwsStepsFile | cdktf.IResolvable): any;
export interface MrscalerAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#value MrscalerAws#value}
    */
    readonly value: string;
}
export declare function mrscalerAwsTagsToTerraform(struct?: MrscalerAwsTags | cdktf.IResolvable): any;
export interface MrscalerAwsTaskEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsTaskEbsBlockDeviceToTerraform(struct?: MrscalerAwsTaskEbsBlockDevice | cdktf.IResolvable): any;
export interface MrscalerAwsTaskScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsTaskScalingDownPolicyToTerraform(struct?: MrscalerAwsTaskScalingDownPolicy | cdktf.IResolvable): any;
export interface MrscalerAwsTaskScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsTaskScalingUpPolicyToTerraform(struct?: MrscalerAwsTaskScalingUpPolicy | cdktf.IResolvable): any;
export interface MrscalerAwsTerminationPoliciesStatements {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit?: string;
}
export declare function mrscalerAwsTerminationPoliciesStatementsToTerraform(struct?: MrscalerAwsTerminationPoliciesStatements | cdktf.IResolvable): any;
export interface MrscalerAwsTerminationPolicies {
    /**
    * statements block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statements MrscalerAws#statements}
    */
    readonly statements: MrscalerAwsTerminationPoliciesStatements[] | cdktf.IResolvable;
}
export declare function mrscalerAwsTerminationPoliciesToTerraform(struct?: MrscalerAwsTerminationPolicies | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws spotinst_mrscaler_aws}
*/
export declare class MrscalerAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_mrscaler_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws spotinst_mrscaler_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MrscalerAwsConfig
    */
    constructor(scope: Construct, id: string, config: MrscalerAwsConfig);
    private _additionalInfo?;
    get additionalInfo(): string;
    set additionalInfo(value: string);
    resetAdditionalInfo(): void;
    get additionalInfoInput(): string | undefined;
    private _additionalPrimarySecurityGroups?;
    get additionalPrimarySecurityGroups(): string[];
    set additionalPrimarySecurityGroups(value: string[]);
    resetAdditionalPrimarySecurityGroups(): void;
    get additionalPrimarySecurityGroupsInput(): string[] | undefined;
    private _additionalReplicaSecurityGroups?;
    get additionalReplicaSecurityGroups(): string[];
    set additionalReplicaSecurityGroups(value: string[]);
    resetAdditionalReplicaSecurityGroups(): void;
    get additionalReplicaSecurityGroupsInput(): string[] | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _coreDesiredCapacity?;
    get coreDesiredCapacity(): number;
    set coreDesiredCapacity(value: number);
    resetCoreDesiredCapacity(): void;
    get coreDesiredCapacityInput(): number | undefined;
    private _coreEbsOptimized?;
    get coreEbsOptimized(): boolean | cdktf.IResolvable;
    set coreEbsOptimized(value: boolean | cdktf.IResolvable);
    resetCoreEbsOptimized(): void;
    get coreEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _coreInstanceTypes?;
    get coreInstanceTypes(): string[];
    set coreInstanceTypes(value: string[]);
    resetCoreInstanceTypes(): void;
    get coreInstanceTypesInput(): string[] | undefined;
    private _coreLifecycle?;
    get coreLifecycle(): string;
    set coreLifecycle(value: string);
    resetCoreLifecycle(): void;
    get coreLifecycleInput(): string | undefined;
    private _coreMaxSize?;
    get coreMaxSize(): number;
    set coreMaxSize(value: number);
    resetCoreMaxSize(): void;
    get coreMaxSizeInput(): number | undefined;
    private _coreMinSize?;
    get coreMinSize(): number;
    set coreMinSize(value: number);
    resetCoreMinSize(): void;
    get coreMinSizeInput(): number | undefined;
    private _coreUnit?;
    get coreUnit(): string;
    set coreUnit(value: string);
    resetCoreUnit(): void;
    get coreUnitInput(): string | undefined;
    private _customAmiId?;
    get customAmiId(): string;
    set customAmiId(value: string);
    resetCustomAmiId(): void;
    get customAmiIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _ebsRootVolumeSize?;
    get ebsRootVolumeSize(): number;
    set ebsRootVolumeSize(value: number);
    resetEbsRootVolumeSize(): void;
    get ebsRootVolumeSizeInput(): number | undefined;
    private _ec2KeyName?;
    get ec2KeyName(): string;
    set ec2KeyName(value: string);
    resetEc2KeyName(): void;
    get ec2KeyNameInput(): string | undefined;
    private _exposeClusterId?;
    get exposeClusterId(): boolean | cdktf.IResolvable;
    set exposeClusterId(value: boolean | cdktf.IResolvable);
    resetExposeClusterId(): void;
    get exposeClusterIdInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _jobFlowRole?;
    get jobFlowRole(): string;
    set jobFlowRole(value: string);
    resetJobFlowRole(): void;
    get jobFlowRoleInput(): string | undefined;
    private _keepJobFlowAlive?;
    get keepJobFlowAlive(): boolean | cdktf.IResolvable;
    set keepJobFlowAlive(value: boolean | cdktf.IResolvable);
    resetKeepJobFlowAlive(): void;
    get keepJobFlowAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _logUri?;
    get logUri(): string;
    set logUri(value: string);
    resetLogUri(): void;
    get logUriInput(): string | undefined;
    private _managedPrimarySecurityGroup?;
    get managedPrimarySecurityGroup(): string;
    set managedPrimarySecurityGroup(value: string);
    resetManagedPrimarySecurityGroup(): void;
    get managedPrimarySecurityGroupInput(): string | undefined;
    private _managedReplicaSecurityGroup?;
    get managedReplicaSecurityGroup(): string;
    set managedReplicaSecurityGroup(value: string);
    resetManagedReplicaSecurityGroup(): void;
    get managedReplicaSecurityGroupInput(): string | undefined;
    private _masterEbsOptimized?;
    get masterEbsOptimized(): boolean | cdktf.IResolvable;
    set masterEbsOptimized(value: boolean | cdktf.IResolvable);
    resetMasterEbsOptimized(): void;
    get masterEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _masterInstanceTypes?;
    get masterInstanceTypes(): string[];
    set masterInstanceTypes(value: string[]);
    resetMasterInstanceTypes(): void;
    get masterInstanceTypesInput(): string[] | undefined;
    private _masterLifecycle?;
    get masterLifecycle(): string;
    set masterLifecycle(value: string);
    resetMasterLifecycle(): void;
    get masterLifecycleInput(): string | undefined;
    private _masterTarget?;
    get masterTarget(): number;
    set masterTarget(value: number);
    resetMasterTarget(): void;
    get masterTargetInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputClusterId(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _releaseLabel?;
    get releaseLabel(): string;
    set releaseLabel(value: string);
    resetReleaseLabel(): void;
    get releaseLabelInput(): string | undefined;
    private _repoUpgradeOnBoot?;
    get repoUpgradeOnBoot(): string;
    set repoUpgradeOnBoot(value: string);
    resetRepoUpgradeOnBoot(): void;
    get repoUpgradeOnBootInput(): string | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    resetRetries(): void;
    get retriesInput(): number | undefined;
    private _securityConfig?;
    get securityConfig(): string;
    set securityConfig(value: string);
    resetSecurityConfig(): void;
    get securityConfigInput(): string | undefined;
    private _serviceAccessSecurityGroup?;
    get serviceAccessSecurityGroup(): string;
    set serviceAccessSecurityGroup(value: string);
    resetServiceAccessSecurityGroup(): void;
    get serviceAccessSecurityGroupInput(): string | undefined;
    private _serviceRole?;
    get serviceRole(): string;
    set serviceRole(value: string);
    resetServiceRole(): void;
    get serviceRoleInput(): string | undefined;
    private _strategy?;
    get strategy(): string;
    set strategy(value: string);
    get strategyInput(): string | undefined;
    private _taskDesiredCapacity?;
    get taskDesiredCapacity(): number;
    set taskDesiredCapacity(value: number);
    resetTaskDesiredCapacity(): void;
    get taskDesiredCapacityInput(): number | undefined;
    private _taskEbsOptimized?;
    get taskEbsOptimized(): boolean | cdktf.IResolvable;
    set taskEbsOptimized(value: boolean | cdktf.IResolvable);
    resetTaskEbsOptimized(): void;
    get taskEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _taskInstanceTypes?;
    get taskInstanceTypes(): string[];
    set taskInstanceTypes(value: string[]);
    resetTaskInstanceTypes(): void;
    get taskInstanceTypesInput(): string[] | undefined;
    private _taskLifecycle?;
    get taskLifecycle(): string;
    set taskLifecycle(value: string);
    resetTaskLifecycle(): void;
    get taskLifecycleInput(): string | undefined;
    private _taskMaxSize?;
    get taskMaxSize(): number;
    set taskMaxSize(value: number);
    resetTaskMaxSize(): void;
    get taskMaxSizeInput(): number | undefined;
    private _taskMinSize?;
    get taskMinSize(): number;
    set taskMinSize(value: number);
    resetTaskMinSize(): void;
    get taskMinSizeInput(): number | undefined;
    private _taskUnit?;
    get taskUnit(): string;
    set taskUnit(value: string);
    resetTaskUnit(): void;
    get taskUnitInput(): string | undefined;
    private _terminationProtected?;
    get terminationProtected(): boolean | cdktf.IResolvable;
    set terminationProtected(value: boolean | cdktf.IResolvable);
    resetTerminationProtected(): void;
    get terminationProtectedInput(): boolean | cdktf.IResolvable | undefined;
    private _visibleToAllUsers?;
    get visibleToAllUsers(): boolean | cdktf.IResolvable;
    set visibleToAllUsers(value: boolean | cdktf.IResolvable);
    resetVisibleToAllUsers(): void;
    get visibleToAllUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _applications?;
    get applications(): MrscalerAwsApplications[] | cdktf.IResolvable;
    set applications(value: MrscalerAwsApplications[] | cdktf.IResolvable);
    resetApplications(): void;
    get applicationsInput(): cdktf.IResolvable | MrscalerAwsApplications[] | undefined;
    private _bootstrapActionsFile?;
    get bootstrapActionsFile(): MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable;
    set bootstrapActionsFile(value: MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable);
    resetBootstrapActionsFile(): void;
    get bootstrapActionsFileInput(): cdktf.IResolvable | MrscalerAwsBootstrapActionsFile[] | undefined;
    private _configurationsFile?;
    get configurationsFile(): MrscalerAwsConfigurationsFile[] | cdktf.IResolvable;
    set configurationsFile(value: MrscalerAwsConfigurationsFile[] | cdktf.IResolvable);
    resetConfigurationsFile(): void;
    get configurationsFileInput(): cdktf.IResolvable | MrscalerAwsConfigurationsFile[] | undefined;
    private _coreEbsBlockDevice?;
    get coreEbsBlockDevice(): MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable;
    set coreEbsBlockDevice(value: MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable);
    resetCoreEbsBlockDevice(): void;
    get coreEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsCoreEbsBlockDevice[] | undefined;
    private _coreScalingDownPolicy?;
    get coreScalingDownPolicy(): MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable;
    set coreScalingDownPolicy(value: MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable);
    resetCoreScalingDownPolicy(): void;
    get coreScalingDownPolicyInput(): cdktf.IResolvable | MrscalerAwsCoreScalingDownPolicy[] | undefined;
    private _coreScalingUpPolicy?;
    get coreScalingUpPolicy(): MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable;
    set coreScalingUpPolicy(value: MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable);
    resetCoreScalingUpPolicy(): void;
    get coreScalingUpPolicyInput(): cdktf.IResolvable | MrscalerAwsCoreScalingUpPolicy[] | undefined;
    private _instanceWeights?;
    get instanceWeights(): MrscalerAwsInstanceWeights[] | cdktf.IResolvable;
    set instanceWeights(value: MrscalerAwsInstanceWeights[] | cdktf.IResolvable);
    resetInstanceWeights(): void;
    get instanceWeightsInput(): cdktf.IResolvable | MrscalerAwsInstanceWeights[] | undefined;
    private _masterEbsBlockDevice?;
    get masterEbsBlockDevice(): MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable;
    set masterEbsBlockDevice(value: MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable);
    resetMasterEbsBlockDevice(): void;
    get masterEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsMasterEbsBlockDevice[] | undefined;
    private _provisioningTimeout;
    get provisioningTimeout(): MrscalerAwsProvisioningTimeoutOutputReference;
    putProvisioningTimeout(value: MrscalerAwsProvisioningTimeout): void;
    resetProvisioningTimeout(): void;
    get provisioningTimeoutInput(): MrscalerAwsProvisioningTimeout | undefined;
    private _scheduledTask?;
    get scheduledTask(): MrscalerAwsScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: MrscalerAwsScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | MrscalerAwsScheduledTask[] | undefined;
    private _stepsFile?;
    get stepsFile(): MrscalerAwsStepsFile[] | cdktf.IResolvable;
    set stepsFile(value: MrscalerAwsStepsFile[] | cdktf.IResolvable);
    resetStepsFile(): void;
    get stepsFileInput(): cdktf.IResolvable | MrscalerAwsStepsFile[] | undefined;
    private _tags?;
    get tags(): MrscalerAwsTags[] | cdktf.IResolvable;
    set tags(value: MrscalerAwsTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MrscalerAwsTags[] | undefined;
    private _taskEbsBlockDevice?;
    get taskEbsBlockDevice(): MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable;
    set taskEbsBlockDevice(value: MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable);
    resetTaskEbsBlockDevice(): void;
    get taskEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsTaskEbsBlockDevice[] | undefined;
    private _taskScalingDownPolicy?;
    get taskScalingDownPolicy(): MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable;
    set taskScalingDownPolicy(value: MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable);
    resetTaskScalingDownPolicy(): void;
    get taskScalingDownPolicyInput(): cdktf.IResolvable | MrscalerAwsTaskScalingDownPolicy[] | undefined;
    private _taskScalingUpPolicy?;
    get taskScalingUpPolicy(): MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable;
    set taskScalingUpPolicy(value: MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable);
    resetTaskScalingUpPolicy(): void;
    get taskScalingUpPolicyInput(): cdktf.IResolvable | MrscalerAwsTaskScalingUpPolicy[] | undefined;
    private _terminationPolicies?;
    get terminationPolicies(): MrscalerAwsTerminationPolicies[] | cdktf.IResolvable;
    set terminationPolicies(value: MrscalerAwsTerminationPolicies[] | cdktf.IResolvable);
    resetTerminationPolicies(): void;
    get terminationPoliciesInput(): cdktf.IResolvable | MrscalerAwsTerminationPolicies[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
