import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiBalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#dns_cname_aliases MultaiBalancer#dns_cname_aliases}
    */
    readonly dnsCnameAliases?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#name MultaiBalancer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#scheme MultaiBalancer#scheme}
    */
    readonly scheme?: string;
    /**
    * connection_timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#connection_timeouts MultaiBalancer#connection_timeouts}
    */
    readonly connectionTimeouts?: MultaiBalancerConnectionTimeouts;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#tags MultaiBalancer#tags}
    */
    readonly tags?: MultaiBalancerTags[] | cdktf.IResolvable;
}
export interface MultaiBalancerConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#draining MultaiBalancer#draining}
    */
    readonly draining?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#idle MultaiBalancer#idle}
    */
    readonly idle?: number;
}
export declare function multaiBalancerConnectionTimeoutsToTerraform(struct?: MultaiBalancerConnectionTimeoutsOutputReference | MultaiBalancerConnectionTimeouts): any;
export declare class MultaiBalancerConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MultaiBalancerConnectionTimeouts | undefined;
    set internalValue(value: MultaiBalancerConnectionTimeouts | undefined);
    private _draining?;
    get draining(): number;
    set draining(value: number);
    resetDraining(): void;
    get drainingInput(): number | undefined;
    private _idle?;
    get idle(): number;
    set idle(value: number);
    resetIdle(): void;
    get idleInput(): number | undefined;
}
export interface MultaiBalancerTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#key MultaiBalancer#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#value MultaiBalancer#value}
    */
    readonly value: string;
}
export declare function multaiBalancerTagsToTerraform(struct?: MultaiBalancerTags | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer spotinst_multai_balancer}
*/
export declare class MultaiBalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_balancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer spotinst_multai_balancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiBalancerConfig
    */
    constructor(scope: Construct, id: string, config: MultaiBalancerConfig);
    private _dnsCnameAliases?;
    get dnsCnameAliases(): string[];
    set dnsCnameAliases(value: string[]);
    resetDnsCnameAliases(): void;
    get dnsCnameAliasesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _connectionTimeouts;
    get connectionTimeouts(): MultaiBalancerConnectionTimeoutsOutputReference;
    putConnectionTimeouts(value: MultaiBalancerConnectionTimeouts): void;
    resetConnectionTimeouts(): void;
    get connectionTimeoutsInput(): MultaiBalancerConnectionTimeouts | undefined;
    private _tags?;
    get tags(): MultaiBalancerTags[] | cdktf.IResolvable;
    set tags(value: MultaiBalancerTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiBalancerTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
