import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiListenerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#balancer_id MultaiListener#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#port MultaiListener#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#protocol MultaiListener#protocol}
    */
    readonly protocol: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#tags MultaiListener#tags}
    */
    readonly tags?: MultaiListenerTags[] | cdktf.IResolvable;
    /**
    * tls_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#tls_config MultaiListener#tls_config}
    */
    readonly tlsConfig?: MultaiListenerTlsConfig;
}
export interface MultaiListenerTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#key MultaiListener#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#value MultaiListener#value}
    */
    readonly value: string;
}
export declare function multaiListenerTagsToTerraform(struct?: MultaiListenerTags | cdktf.IResolvable): any;
export interface MultaiListenerTlsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#certificate_ids MultaiListener#certificate_ids}
    */
    readonly certificateIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#cipher_suites MultaiListener#cipher_suites}
    */
    readonly cipherSuites: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#max_version MultaiListener#max_version}
    */
    readonly maxVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#min_version MultaiListener#min_version}
    */
    readonly minVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#prefer_server_cipher_suites MultaiListener#prefer_server_cipher_suites}
    */
    readonly preferServerCipherSuites: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#session_tickets_disabled MultaiListener#session_tickets_disabled}
    */
    readonly sessionTicketsDisabled: boolean | cdktf.IResolvable;
}
export declare function multaiListenerTlsConfigToTerraform(struct?: MultaiListenerTlsConfigOutputReference | MultaiListenerTlsConfig): any;
export declare class MultaiListenerTlsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MultaiListenerTlsConfig | undefined;
    set internalValue(value: MultaiListenerTlsConfig | undefined);
    private _certificateIds?;
    get certificateIds(): string[];
    set certificateIds(value: string[]);
    get certificateIdsInput(): string[] | undefined;
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    get cipherSuitesInput(): string[] | undefined;
    private _maxVersion?;
    get maxVersion(): string;
    set maxVersion(value: string);
    get maxVersionInput(): string | undefined;
    private _minVersion?;
    get minVersion(): string;
    set minVersion(value: string);
    get minVersionInput(): string | undefined;
    private _preferServerCipherSuites?;
    get preferServerCipherSuites(): boolean | cdktf.IResolvable;
    set preferServerCipherSuites(value: boolean | cdktf.IResolvable);
    get preferServerCipherSuitesInput(): boolean | cdktf.IResolvable | undefined;
    private _sessionTicketsDisabled?;
    get sessionTicketsDisabled(): boolean | cdktf.IResolvable;
    set sessionTicketsDisabled(value: boolean | cdktf.IResolvable);
    get sessionTicketsDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener spotinst_multai_listener}
*/
export declare class MultaiListener extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_listener";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener spotinst_multai_listener} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiListenerConfig
    */
    constructor(scope: Construct, id: string, config: MultaiListenerConfig);
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    get balancerIdInput(): string | undefined;
    get id(): string;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _tags?;
    get tags(): MultaiListenerTags[] | cdktf.IResolvable;
    set tags(value: MultaiListenerTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiListenerTags[] | undefined;
    private _tlsConfig;
    get tlsConfig(): MultaiListenerTlsConfigOutputReference;
    putTlsConfig(value: MultaiListenerTlsConfig): void;
    resetTlsConfig(): void;
    get tlsConfigInput(): MultaiListenerTlsConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
