import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#balancer_id MultaiTarget#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#host MultaiTarget#host}
    */
    readonly host: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#name MultaiTarget#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#port MultaiTarget#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#target_set_id MultaiTarget#target_set_id}
    */
    readonly targetSetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#weight MultaiTarget#weight}
    */
    readonly weight: number;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#tags MultaiTarget#tags}
    */
    readonly tags?: MultaiTargetTags[] | cdktf.IResolvable;
}
export interface MultaiTargetTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#key MultaiTarget#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#value MultaiTarget#value}
    */
    readonly value: string;
}
export declare function multaiTargetTagsToTerraform(struct?: MultaiTargetTags | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target spotinst_multai_target}
*/
export declare class MultaiTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target spotinst_multai_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiTargetConfig
    */
    constructor(scope: Construct, id: string, config: MultaiTargetConfig);
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    get balancerIdInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _targetSetId?;
    get targetSetId(): string;
    set targetSetId(value: string);
    get targetSetIdInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _tags?;
    get tags(): MultaiTargetTags[] | cdktf.IResolvable;
    set tags(value: MultaiTargetTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiTargetTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
