import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAksVirtualNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#name OceanAksVirtualNodeGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#ocean_id OceanAksVirtualNodeGroup#ocean_id}
    */
    readonly oceanId: string;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#autoscale OceanAksVirtualNodeGroup#autoscale}
    */
    readonly autoscale?: OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable;
    /**
    * label block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#label OceanAksVirtualNodeGroup#label}
    */
    readonly label?: OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable;
    /**
    * launch_specification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#launch_specification OceanAksVirtualNodeGroup#launch_specification}
    */
    readonly launchSpecification?: OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#resource_limits OceanAksVirtualNodeGroup#resource_limits}
    */
    readonly resourceLimits?: OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable;
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#taint OceanAksVirtualNodeGroup#taint}
    */
    readonly taint?: OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable;
}
export interface OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#cpu_per_unit OceanAksVirtualNodeGroup#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#gpu_per_unit OceanAksVirtualNodeGroup#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#memory_per_unit OceanAksVirtualNodeGroup#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#num_of_units OceanAksVirtualNodeGroup#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomToTerraform(struct?: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#auto_headroom_percentage OceanAksVirtualNodeGroup#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#autoscale_headroom OceanAksVirtualNodeGroup#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom[] | cdktf.IResolvable;
}
export declare function oceanAksVirtualNodeGroupAutoscaleToTerraform(struct?: OceanAksVirtualNodeGroupAutoscale | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupLabel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value?: string;
}
export declare function oceanAksVirtualNodeGroupLabelToTerraform(struct?: OceanAksVirtualNodeGroupLabel | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupLaunchSpecificationOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#size_gb OceanAksVirtualNodeGroup#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#type OceanAksVirtualNodeGroup#type}
    */
    readonly type?: string;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationOsDiskToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecificationOsDiskOutputReference | OceanAksVirtualNodeGroupLaunchSpecificationOsDisk): any;
export declare class OceanAksVirtualNodeGroupLaunchSpecificationOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksVirtualNodeGroupLaunchSpecificationOsDisk | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupLaunchSpecificationOsDisk | undefined);
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface OceanAksVirtualNodeGroupLaunchSpecificationTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value?: string;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationTagToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecificationTag | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupLaunchSpecification {
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#os_disk OceanAksVirtualNodeGroup#os_disk}
    */
    readonly osDisk?: OceanAksVirtualNodeGroupLaunchSpecificationOsDisk;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#tag OceanAksVirtualNodeGroup#tag}
    */
    readonly tag?: OceanAksVirtualNodeGroupLaunchSpecificationTag[] | cdktf.IResolvable;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecification | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#max_instance_count OceanAksVirtualNodeGroup#max_instance_count}
    */
    readonly maxInstanceCount?: number;
}
export declare function oceanAksVirtualNodeGroupResourceLimitsToTerraform(struct?: OceanAksVirtualNodeGroupResourceLimits | cdktf.IResolvable): any;
export interface OceanAksVirtualNodeGroupTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#effect OceanAksVirtualNodeGroup#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value: string;
}
export declare function oceanAksVirtualNodeGroupTaintToTerraform(struct?: OceanAksVirtualNodeGroupTaint | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group spotinst_ocean_aks_virtual_node_group}
*/
export declare class OceanAksVirtualNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aks_virtual_node_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group spotinst_ocean_aks_virtual_node_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAksVirtualNodeGroupConfig
    */
    constructor(scope: Construct, id: string, config: OceanAksVirtualNodeGroupConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _autoscale?;
    get autoscale(): OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable;
    set autoscale(value: OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable);
    resetAutoscale(): void;
    get autoscaleInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupAutoscale[] | undefined;
    private _label?;
    get label(): OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable;
    set label(value: OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable);
    resetLabel(): void;
    get labelInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupLabel[] | undefined;
    private _launchSpecification?;
    get launchSpecification(): OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable;
    set launchSpecification(value: OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable);
    resetLaunchSpecification(): void;
    get launchSpecificationInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupLaunchSpecification[] | undefined;
    private _resourceLimits?;
    get resourceLimits(): OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable;
    set resourceLimits(value: OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable);
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupResourceLimits[] | undefined;
    private _taint?;
    get taint(): OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable;
    set taint(value: OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable);
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupTaint[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
