import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAwsExtendedResourceDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_extended_resource_definition#name OceanAwsExtendedResourceDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_extended_resource_definition#resource_mapping OceanAwsExtendedResourceDefinition#resource_mapping}
    */
    readonly resourceMapping: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_extended_resource_definition spotinst_ocean_aws_extended_resource_definition}
*/
export declare class OceanAwsExtendedResourceDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aws_extended_resource_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_extended_resource_definition spotinst_ocean_aws_extended_resource_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAwsExtendedResourceDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: OceanAwsExtendedResourceDefinitionConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceMapping?;
    get resourceMapping(): {
        [key: string]: string;
    };
    set resourceMapping(value: {
        [key: string]: string;
    });
    get resourceMappingInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
