import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#associate_public_ip_address OceanAws#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#blacklist OceanAws#blacklist}
    */
    readonly blacklist?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#controller_id OceanAws#controller_id}
    */
    readonly controllerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#desired_capacity OceanAws#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#draining_timeout OceanAws#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#ebs_optimized OceanAws#ebs_optimized}
    */
    readonly ebsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#fallback_to_ondemand OceanAws#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#grace_period OceanAws#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#iam_instance_profile OceanAws#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#image_id OceanAws#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#key_name OceanAws#key_name}
    */
    readonly keyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#max_size OceanAws#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#min_size OceanAws#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#monitoring OceanAws#monitoring}
    */
    readonly monitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#name OceanAws#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#region OceanAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#root_volume_size OceanAws#root_volume_size}
    */
    readonly rootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#security_groups OceanAws#security_groups}
    */
    readonly securityGroups: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#spot_percentage OceanAws#spot_percentage}
    */
    readonly spotPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#subnet_ids OceanAws#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#use_as_template_only OceanAws#use_as_template_only}
    */
    readonly useAsTemplateOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#user_data OceanAws#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#utilize_commitments OceanAws#utilize_commitments}
    */
    readonly utilizeCommitments?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#utilize_reserved_instances OceanAws#utilize_reserved_instances}
    */
    readonly utilizeReservedInstances?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#whitelist OceanAws#whitelist}
    */
    readonly whitelist?: string[];
    /**
    * autoscaler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscaler OceanAws#autoscaler}
    */
    readonly autoscaler?: OceanAwsAutoscaler;
    /**
    * instance_metadata_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#instance_metadata_options OceanAws#instance_metadata_options}
    */
    readonly instanceMetadataOptions?: OceanAwsInstanceMetadataOptions;
    /**
    * load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#load_balancers OceanAws#load_balancers}
    */
    readonly loadBalancers?: OceanAwsLoadBalancers[] | cdktf.IResolvable;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#logging OceanAws#logging}
    */
    readonly logging?: OceanAwsLogging;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#scheduled_task OceanAws#scheduled_task}
    */
    readonly scheduledTask?: OceanAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#tags OceanAws#tags}
    */
    readonly tags?: OceanAwsTags[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#update_policy OceanAws#update_policy}
    */
    readonly updatePolicy?: OceanAwsUpdatePolicy;
}
export interface OceanAwsAutoscalerAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#evaluation_periods OceanAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#max_scale_down_percentage OceanAws#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanAwsAutoscalerAutoscaleDownToTerraform(struct?: OceanAwsAutoscalerAutoscaleDownOutputReference | OceanAwsAutoscalerAutoscaleDown): any;
export declare class OceanAwsAutoscalerAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsAutoscalerAutoscaleDown | undefined;
    set internalValue(value: OceanAwsAutoscalerAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface OceanAwsAutoscalerAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#cpu_per_unit OceanAws#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#gpu_per_unit OceanAws#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#memory_per_unit OceanAws#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#num_of_units OceanAws#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function oceanAwsAutoscalerAutoscaleHeadroomToTerraform(struct?: OceanAwsAutoscalerAutoscaleHeadroomOutputReference | OceanAwsAutoscalerAutoscaleHeadroom): any;
export declare class OceanAwsAutoscalerAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsAutoscalerAutoscaleHeadroom | undefined;
    set internalValue(value: OceanAwsAutoscalerAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface OceanAwsAutoscalerResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#max_memory_gib OceanAws#max_memory_gib}
    */
    readonly maxMemoryGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#max_vcpu OceanAws#max_vcpu}
    */
    readonly maxVcpu?: number;
}
export declare function oceanAwsAutoscalerResourceLimitsToTerraform(struct?: OceanAwsAutoscalerResourceLimitsOutputReference | OceanAwsAutoscalerResourceLimits): any;
export declare class OceanAwsAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsAutoscalerResourceLimits | undefined;
    set internalValue(value: OceanAwsAutoscalerResourceLimits | undefined);
    private _maxMemoryGib?;
    get maxMemoryGib(): number;
    set maxMemoryGib(value: number);
    resetMaxMemoryGib(): void;
    get maxMemoryGibInput(): number | undefined;
    private _maxVcpu?;
    get maxVcpu(): number;
    set maxVcpu(value: number);
    resetMaxVcpu(): void;
    get maxVcpuInput(): number | undefined;
}
export interface OceanAwsAutoscaler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#auto_headroom_percentage OceanAws#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscale_cooldown OceanAws#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscale_is_auto_config OceanAws#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscale_is_enabled OceanAws#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#enable_automatic_and_manual_headroom OceanAws#enable_automatic_and_manual_headroom}
    */
    readonly enableAutomaticAndManualHeadroom?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#extended_resource_definitions OceanAws#extended_resource_definitions}
    */
    readonly extendedResourceDefinitions?: string[];
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscale_down OceanAws#autoscale_down}
    */
    readonly autoscaleDown?: OceanAwsAutoscalerAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#autoscale_headroom OceanAws#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: OceanAwsAutoscalerAutoscaleHeadroom;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#resource_limits OceanAws#resource_limits}
    */
    readonly resourceLimits?: OceanAwsAutoscalerResourceLimits;
}
export declare function oceanAwsAutoscalerToTerraform(struct?: OceanAwsAutoscalerOutputReference | OceanAwsAutoscaler): any;
export declare class OceanAwsAutoscalerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsAutoscaler | undefined;
    set internalValue(value: OceanAwsAutoscaler | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticAndManualHeadroom?;
    get enableAutomaticAndManualHeadroom(): boolean | cdktf.IResolvable;
    set enableAutomaticAndManualHeadroom(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticAndManualHeadroom(): void;
    get enableAutomaticAndManualHeadroomInput(): boolean | cdktf.IResolvable | undefined;
    private _extendedResourceDefinitions?;
    get extendedResourceDefinitions(): string[];
    set extendedResourceDefinitions(value: string[]);
    resetExtendedResourceDefinitions(): void;
    get extendedResourceDefinitionsInput(): string[] | undefined;
    private _autoscaleDown;
    get autoscaleDown(): OceanAwsAutoscalerAutoscaleDownOutputReference;
    putAutoscaleDown(value: OceanAwsAutoscalerAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): OceanAwsAutoscalerAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): OceanAwsAutoscalerAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: OceanAwsAutoscalerAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): OceanAwsAutoscalerAutoscaleHeadroom | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanAwsAutoscalerResourceLimitsOutputReference;
    putResourceLimits(value: OceanAwsAutoscalerResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanAwsAutoscalerResourceLimits | undefined;
}
export interface OceanAwsInstanceMetadataOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#http_put_response_hop_limit OceanAws#http_put_response_hop_limit}
    */
    readonly httpPutResponseHopLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#http_tokens OceanAws#http_tokens}
    */
    readonly httpTokens: string;
}
export declare function oceanAwsInstanceMetadataOptionsToTerraform(struct?: OceanAwsInstanceMetadataOptionsOutputReference | OceanAwsInstanceMetadataOptions): any;
export declare class OceanAwsInstanceMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsInstanceMetadataOptions | undefined;
    set internalValue(value: OceanAwsInstanceMetadataOptions | undefined);
    private _httpPutResponseHopLimit?;
    get httpPutResponseHopLimit(): number;
    set httpPutResponseHopLimit(value: number);
    resetHttpPutResponseHopLimit(): void;
    get httpPutResponseHopLimitInput(): number | undefined;
    private _httpTokens?;
    get httpTokens(): string;
    set httpTokens(value: string);
    get httpTokensInput(): string | undefined;
}
export interface OceanAwsLoadBalancers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#arn OceanAws#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#name OceanAws#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#type OceanAws#type}
    */
    readonly type?: string;
}
export declare function oceanAwsLoadBalancersToTerraform(struct?: OceanAwsLoadBalancers | cdktf.IResolvable): any;
export interface OceanAwsLoggingExportS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#id OceanAws#id}
    */
    readonly id: string;
}
export declare function oceanAwsLoggingExportS3ToTerraform(struct?: OceanAwsLoggingExportS3 | cdktf.IResolvable): any;
export interface OceanAwsLoggingExport {
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#s3 OceanAws#s3}
    */
    readonly s3?: OceanAwsLoggingExportS3[] | cdktf.IResolvable;
}
export declare function oceanAwsLoggingExportToTerraform(struct?: OceanAwsLoggingExportOutputReference | OceanAwsLoggingExport): any;
export declare class OceanAwsLoggingExportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLoggingExport | undefined;
    set internalValue(value: OceanAwsLoggingExport | undefined);
    private _s3?;
    get s3(): OceanAwsLoggingExportS3[] | cdktf.IResolvable;
    set s3(value: OceanAwsLoggingExportS3[] | cdktf.IResolvable);
    resetS3(): void;
    get s3Input(): cdktf.IResolvable | OceanAwsLoggingExportS3[] | undefined;
}
export interface OceanAwsLogging {
    /**
    * export block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#export OceanAws#export}
    */
    readonly export?: OceanAwsLoggingExport;
}
export declare function oceanAwsLoggingToTerraform(struct?: OceanAwsLoggingOutputReference | OceanAwsLogging): any;
export declare class OceanAwsLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLogging | undefined;
    set internalValue(value: OceanAwsLogging | undefined);
    private _export;
    get export(): OceanAwsLoggingExportOutputReference;
    putExport(value: OceanAwsLoggingExport): void;
    resetExport(): void;
    get exportInput(): OceanAwsLoggingExport | undefined;
}
export interface OceanAwsScheduledTaskShutdownHours {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#is_enabled OceanAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#time_windows OceanAws#time_windows}
    */
    readonly timeWindows: string[];
}
export declare function oceanAwsScheduledTaskShutdownHoursToTerraform(struct?: OceanAwsScheduledTaskShutdownHoursOutputReference | OceanAwsScheduledTaskShutdownHours): any;
export declare class OceanAwsScheduledTaskShutdownHoursOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsScheduledTaskShutdownHours | undefined;
    set internalValue(value: OceanAwsScheduledTaskShutdownHours | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    get timeWindowsInput(): string[] | undefined;
}
export interface OceanAwsScheduledTaskTasks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#cron_expression OceanAws#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#is_enabled OceanAws#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#task_type OceanAws#task_type}
    */
    readonly taskType: string;
}
export declare function oceanAwsScheduledTaskTasksToTerraform(struct?: OceanAwsScheduledTaskTasks | cdktf.IResolvable): any;
export interface OceanAwsScheduledTask {
    /**
    * shutdown_hours block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#shutdown_hours OceanAws#shutdown_hours}
    */
    readonly shutdownHours?: OceanAwsScheduledTaskShutdownHours;
    /**
    * tasks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#tasks OceanAws#tasks}
    */
    readonly tasks?: OceanAwsScheduledTaskTasks[] | cdktf.IResolvable;
}
export declare function oceanAwsScheduledTaskToTerraform(struct?: OceanAwsScheduledTask | cdktf.IResolvable): any;
export interface OceanAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#key OceanAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#value OceanAws#value}
    */
    readonly value: string;
}
export declare function oceanAwsTagsToTerraform(struct?: OceanAwsTags | cdktf.IResolvable): any;
export interface OceanAwsUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#batch_min_healthy_percentage OceanAws#batch_min_healthy_percentage}
    */
    readonly batchMinHealthyPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#batch_size_percentage OceanAws#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#launch_spec_ids OceanAws#launch_spec_ids}
    */
    readonly launchSpecIds?: string[];
}
export declare function oceanAwsUpdatePolicyRollConfigToTerraform(struct?: OceanAwsUpdatePolicyRollConfigOutputReference | OceanAwsUpdatePolicyRollConfig): any;
export declare class OceanAwsUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanAwsUpdatePolicyRollConfig | undefined);
    private _batchMinHealthyPercentage?;
    get batchMinHealthyPercentage(): number;
    set batchMinHealthyPercentage(value: number);
    resetBatchMinHealthyPercentage(): void;
    get batchMinHealthyPercentageInput(): number | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
    private _launchSpecIds?;
    get launchSpecIds(): string[];
    set launchSpecIds(value: string[]);
    resetLaunchSpecIds(): void;
    get launchSpecIdsInput(): string[] | undefined;
}
export interface OceanAwsUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#auto_apply_tags OceanAws#auto_apply_tags}
    */
    readonly autoApplyTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#conditioned_roll OceanAws#conditioned_roll}
    */
    readonly conditionedRoll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#should_roll OceanAws#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws#roll_config OceanAws#roll_config}
    */
    readonly rollConfig?: OceanAwsUpdatePolicyRollConfig;
}
export declare function oceanAwsUpdatePolicyToTerraform(struct?: OceanAwsUpdatePolicyOutputReference | OceanAwsUpdatePolicy): any;
export declare class OceanAwsUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsUpdatePolicy | undefined;
    set internalValue(value: OceanAwsUpdatePolicy | undefined);
    private _autoApplyTags?;
    get autoApplyTags(): boolean | cdktf.IResolvable;
    set autoApplyTags(value: boolean | cdktf.IResolvable);
    resetAutoApplyTags(): void;
    get autoApplyTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _conditionedRoll?;
    get conditionedRoll(): boolean | cdktf.IResolvable;
    set conditionedRoll(value: boolean | cdktf.IResolvable);
    resetConditionedRoll(): void;
    get conditionedRollInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanAwsUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanAwsUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanAwsUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws spotinst_ocean_aws}
*/
export declare class OceanAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws spotinst_ocean_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAwsConfig
    */
    constructor(scope: Construct, id: string, config: OceanAwsConfig);
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | cdktf.IResolvable;
    set associatePublicIpAddress(value: boolean | cdktf.IResolvable);
    resetAssociatePublicIpAddress(): void;
    get associatePublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    private _blacklist?;
    get blacklist(): string[];
    set blacklist(value: string[]);
    resetBlacklist(): void;
    get blacklistInput(): string[] | undefined;
    private _controllerId?;
    get controllerId(): string;
    set controllerId(value: string);
    resetControllerId(): void;
    get controllerIdInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _ebsOptimized?;
    get ebsOptimized(): boolean | cdktf.IResolvable;
    set ebsOptimized(value: boolean | cdktf.IResolvable);
    resetEbsOptimized(): void;
    get ebsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _monitoring?;
    get monitoring(): boolean | cdktf.IResolvable;
    set monitoring(value: boolean | cdktf.IResolvable);
    resetMonitoring(): void;
    get monitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rootVolumeSize?;
    get rootVolumeSize(): number;
    set rootVolumeSize(value: number);
    resetRootVolumeSize(): void;
    get rootVolumeSizeInput(): number | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    get securityGroupsInput(): string[] | undefined;
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _useAsTemplateOnly?;
    get useAsTemplateOnly(): boolean | cdktf.IResolvable;
    set useAsTemplateOnly(value: boolean | cdktf.IResolvable);
    resetUseAsTemplateOnly(): void;
    get useAsTemplateOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _utilizeCommitments?;
    get utilizeCommitments(): boolean | cdktf.IResolvable;
    set utilizeCommitments(value: boolean | cdktf.IResolvable);
    resetUtilizeCommitments(): void;
    get utilizeCommitmentsInput(): boolean | cdktf.IResolvable | undefined;
    private _utilizeReservedInstances?;
    get utilizeReservedInstances(): boolean | cdktf.IResolvable;
    set utilizeReservedInstances(value: boolean | cdktf.IResolvable);
    resetUtilizeReservedInstances(): void;
    get utilizeReservedInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _whitelist?;
    get whitelist(): string[];
    set whitelist(value: string[]);
    resetWhitelist(): void;
    get whitelistInput(): string[] | undefined;
    private _autoscaler;
    get autoscaler(): OceanAwsAutoscalerOutputReference;
    putAutoscaler(value: OceanAwsAutoscaler): void;
    resetAutoscaler(): void;
    get autoscalerInput(): OceanAwsAutoscaler | undefined;
    private _instanceMetadataOptions;
    get instanceMetadataOptions(): OceanAwsInstanceMetadataOptionsOutputReference;
    putInstanceMetadataOptions(value: OceanAwsInstanceMetadataOptions): void;
    resetInstanceMetadataOptions(): void;
    get instanceMetadataOptionsInput(): OceanAwsInstanceMetadataOptions | undefined;
    private _loadBalancers?;
    get loadBalancers(): OceanAwsLoadBalancers[] | cdktf.IResolvable;
    set loadBalancers(value: OceanAwsLoadBalancers[] | cdktf.IResolvable);
    resetLoadBalancers(): void;
    get loadBalancersInput(): cdktf.IResolvable | OceanAwsLoadBalancers[] | undefined;
    private _logging;
    get logging(): OceanAwsLoggingOutputReference;
    putLogging(value: OceanAwsLogging): void;
    resetLogging(): void;
    get loggingInput(): OceanAwsLogging | undefined;
    private _scheduledTask?;
    get scheduledTask(): OceanAwsScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: OceanAwsScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | OceanAwsScheduledTask[] | undefined;
    private _tags?;
    get tags(): OceanAwsTags[] | cdktf.IResolvable;
    set tags(value: OceanAwsTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | OceanAwsTags[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanAwsUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanAwsUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanAwsUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
