import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanEcsLaunchSpecConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#iam_instance_profile OceanEcsLaunchSpec#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#image_id OceanEcsLaunchSpec#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#instance_types OceanEcsLaunchSpec#instance_types}
    */
    readonly instanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#name OceanEcsLaunchSpec#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#ocean_id OceanEcsLaunchSpec#ocean_id}
    */
    readonly oceanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#restrict_scale_down OceanEcsLaunchSpec#restrict_scale_down}
    */
    readonly restrictScaleDown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#security_group_ids OceanEcsLaunchSpec#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#subnet_ids OceanEcsLaunchSpec#subnet_ids}
    */
    readonly subnetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#user_data OceanEcsLaunchSpec#user_data}
    */
    readonly userData?: string;
    /**
    * attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#attributes OceanEcsLaunchSpec#attributes}
    */
    readonly attributes?: OceanEcsLaunchSpecAttributes[] | cdktf.IResolvable;
    /**
    * autoscale_headrooms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#autoscale_headrooms OceanEcsLaunchSpec#autoscale_headrooms}
    */
    readonly autoscaleHeadrooms?: OceanEcsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * block_device_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#block_device_mappings OceanEcsLaunchSpec#block_device_mappings}
    */
    readonly blockDeviceMappings?: OceanEcsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * scheduling_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#scheduling_task OceanEcsLaunchSpec#scheduling_task}
    */
    readonly schedulingTask?: OceanEcsLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#tags OceanEcsLaunchSpec#tags}
    */
    readonly tags?: OceanEcsLaunchSpecTags[] | cdktf.IResolvable;
}
export interface OceanEcsLaunchSpecAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#key OceanEcsLaunchSpec#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#value OceanEcsLaunchSpec#value}
    */
    readonly value: string;
}
export declare function oceanEcsLaunchSpecAttributesToTerraform(struct?: OceanEcsLaunchSpecAttributes | cdktf.IResolvable): any;
export interface OceanEcsLaunchSpecAutoscaleHeadrooms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#cpu_per_unit OceanEcsLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#memory_per_unit OceanEcsLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#num_of_units OceanEcsLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanEcsLaunchSpecAutoscaleHeadroomsToTerraform(struct?: OceanEcsLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable): any;
export interface OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#base_size OceanEcsLaunchSpec#base_size}
    */
    readonly baseSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#resource OceanEcsLaunchSpec#resource}
    */
    readonly resource: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#size_per_resource_unit OceanEcsLaunchSpec#size_per_resource_unit}
    */
    readonly sizePerResourceUnit: number;
}
export declare function oceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeToTerraform(struct?: OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference | OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize): any;
export declare class OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
    set internalValue(value: OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined);
    private _baseSize?;
    get baseSize(): number;
    set baseSize(value: number);
    get baseSizeInput(): number | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _sizePerResourceUnit?;
    get sizePerResourceUnit(): number;
    set sizePerResourceUnit(value: number);
    get sizePerResourceUnitInput(): number | undefined;
}
export interface OceanEcsLaunchSpecBlockDeviceMappingsEbs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#delete_on_termination OceanEcsLaunchSpec#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#encrypted OceanEcsLaunchSpec#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#iops OceanEcsLaunchSpec#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#kms_key_id OceanEcsLaunchSpec#kms_key_id}
    */
    readonly kmsKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#snapshot_id OceanEcsLaunchSpec#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#throughput OceanEcsLaunchSpec#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#volume_size OceanEcsLaunchSpec#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#volume_type OceanEcsLaunchSpec#volume_type}
    */
    readonly volumeType?: string;
    /**
    * dynamic_volume_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#dynamic_volume_size OceanEcsLaunchSpec#dynamic_volume_size}
    */
    readonly dynamicVolumeSize?: OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize;
}
export declare function oceanEcsLaunchSpecBlockDeviceMappingsEbsToTerraform(struct?: OceanEcsLaunchSpecBlockDeviceMappingsEbsOutputReference | OceanEcsLaunchSpecBlockDeviceMappingsEbs): any;
export declare class OceanEcsLaunchSpecBlockDeviceMappingsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsLaunchSpecBlockDeviceMappingsEbs | undefined;
    set internalValue(value: OceanEcsLaunchSpecBlockDeviceMappingsEbs | undefined);
    private _deleteOnTermination?;
    get deleteOnTermination(): boolean | cdktf.IResolvable;
    set deleteOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOnTermination(): void;
    get deleteOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    get encrypted(): boolean | cdktf.IResolvable;
    set encrypted(value: boolean | cdktf.IResolvable);
    resetEncrypted(): void;
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    resetKmsKeyId(): void;
    get kmsKeyIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _dynamicVolumeSize;
    get dynamicVolumeSize(): OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference;
    putDynamicVolumeSize(value: OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize): void;
    resetDynamicVolumeSize(): void;
    get dynamicVolumeSizeInput(): OceanEcsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
}
export interface OceanEcsLaunchSpecBlockDeviceMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#device_name OceanEcsLaunchSpec#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#no_device OceanEcsLaunchSpec#no_device}
    */
    readonly noDevice?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#virtual_name OceanEcsLaunchSpec#virtual_name}
    */
    readonly virtualName?: string;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#ebs OceanEcsLaunchSpec#ebs}
    */
    readonly ebs?: OceanEcsLaunchSpecBlockDeviceMappingsEbs;
}
export declare function oceanEcsLaunchSpecBlockDeviceMappingsToTerraform(struct?: OceanEcsLaunchSpecBlockDeviceMappings | cdktf.IResolvable): any;
export interface OceanEcsLaunchSpecSchedulingTaskTaskHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#cpu_per_unit OceanEcsLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#memory_per_unit OceanEcsLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#num_of_units OceanEcsLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanEcsLaunchSpecSchedulingTaskTaskHeadroomToTerraform(struct?: OceanEcsLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable): any;
export interface OceanEcsLaunchSpecSchedulingTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#cron_expression OceanEcsLaunchSpec#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#is_enabled OceanEcsLaunchSpec#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#task_type OceanEcsLaunchSpec#task_type}
    */
    readonly taskType: string;
    /**
    * task_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#task_headroom OceanEcsLaunchSpec#task_headroom}
    */
    readonly taskHeadroom?: OceanEcsLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
}
export declare function oceanEcsLaunchSpecSchedulingTaskToTerraform(struct?: OceanEcsLaunchSpecSchedulingTask | cdktf.IResolvable): any;
export interface OceanEcsLaunchSpecTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#key OceanEcsLaunchSpec#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec#value OceanEcsLaunchSpec#value}
    */
    readonly value: string;
}
export declare function oceanEcsLaunchSpecTagsToTerraform(struct?: OceanEcsLaunchSpecTags | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec spotinst_ocean_ecs_launch_spec}
*/
export declare class OceanEcsLaunchSpec extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_ecs_launch_spec";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs_launch_spec spotinst_ocean_ecs_launch_spec} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanEcsLaunchSpecConfig
    */
    constructor(scope: Construct, id: string, config: OceanEcsLaunchSpecConfig);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    resetInstanceTypes(): void;
    get instanceTypesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _restrictScaleDown?;
    get restrictScaleDown(): boolean | cdktf.IResolvable;
    set restrictScaleDown(value: boolean | cdktf.IResolvable);
    resetRestrictScaleDown(): void;
    get restrictScaleDownInput(): boolean | cdktf.IResolvable | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    resetSubnetIds(): void;
    get subnetIdsInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _attributes?;
    get attributes(): OceanEcsLaunchSpecAttributes[] | cdktf.IResolvable;
    set attributes(value: OceanEcsLaunchSpecAttributes[] | cdktf.IResolvable);
    resetAttributes(): void;
    get attributesInput(): cdktf.IResolvable | OceanEcsLaunchSpecAttributes[] | undefined;
    private _autoscaleHeadrooms?;
    get autoscaleHeadrooms(): OceanEcsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    set autoscaleHeadrooms(value: OceanEcsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable);
    resetAutoscaleHeadrooms(): void;
    get autoscaleHeadroomsInput(): cdktf.IResolvable | OceanEcsLaunchSpecAutoscaleHeadrooms[] | undefined;
    private _blockDeviceMappings?;
    get blockDeviceMappings(): OceanEcsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable;
    set blockDeviceMappings(value: OceanEcsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable);
    resetBlockDeviceMappings(): void;
    get blockDeviceMappingsInput(): cdktf.IResolvable | OceanEcsLaunchSpecBlockDeviceMappings[] | undefined;
    private _schedulingTask?;
    get schedulingTask(): OceanEcsLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    set schedulingTask(value: OceanEcsLaunchSpecSchedulingTask[] | cdktf.IResolvable);
    resetSchedulingTask(): void;
    get schedulingTaskInput(): cdktf.IResolvable | OceanEcsLaunchSpecSchedulingTask[] | undefined;
    private _tags?;
    get tags(): OceanEcsLaunchSpecTags[] | cdktf.IResolvable;
    set tags(value: OceanEcsLaunchSpecTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | OceanEcsLaunchSpecTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
