import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanEcsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#associate_public_ip_address OceanEcs#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#cluster_name OceanEcs#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#desired_capacity OceanEcs#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#draining_timeout OceanEcs#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#ebs_optimized OceanEcs#ebs_optimized}
    */
    readonly ebsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#iam_instance_profile OceanEcs#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#image_id OceanEcs#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#key_pair OceanEcs#key_pair}
    */
    readonly keyPair?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#max_size OceanEcs#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#min_size OceanEcs#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#monitoring OceanEcs#monitoring}
    */
    readonly monitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#name OceanEcs#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#region OceanEcs#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#security_group_ids OceanEcs#security_group_ids}
    */
    readonly securityGroupIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#spot_percentage OceanEcs#spot_percentage}
    */
    readonly spotPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#subnet_ids OceanEcs#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#user_data OceanEcs#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#utilize_commitments OceanEcs#utilize_commitments}
    */
    readonly utilizeCommitments?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#utilize_reserved_instances OceanEcs#utilize_reserved_instances}
    */
    readonly utilizeReservedInstances?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#whitelist OceanEcs#whitelist}
    */
    readonly whitelist?: string[];
    /**
    * autoscaler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#autoscaler OceanEcs#autoscaler}
    */
    readonly autoscaler?: OceanEcsAutoscaler;
    /**
    * block_device_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#block_device_mappings OceanEcs#block_device_mappings}
    */
    readonly blockDeviceMappings?: OceanEcsBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * instance_metadata_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#instance_metadata_options OceanEcs#instance_metadata_options}
    */
    readonly instanceMetadataOptions?: OceanEcsInstanceMetadataOptions;
    /**
    * optimize_images block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#optimize_images OceanEcs#optimize_images}
    */
    readonly optimizeImages?: OceanEcsOptimizeImages;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#scheduled_task OceanEcs#scheduled_task}
    */
    readonly scheduledTask?: OceanEcsScheduledTask[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#tags OceanEcs#tags}
    */
    readonly tags?: OceanEcsTags[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#update_policy OceanEcs#update_policy}
    */
    readonly updatePolicy?: OceanEcsUpdatePolicy;
}
export interface OceanEcsAutoscalerDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#max_scale_down_percentage OceanEcs#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanEcsAutoscalerDownToTerraform(struct?: OceanEcsAutoscalerDownOutputReference | OceanEcsAutoscalerDown): any;
export declare class OceanEcsAutoscalerDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsAutoscalerDown | undefined;
    set internalValue(value: OceanEcsAutoscalerDown | undefined);
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface OceanEcsAutoscalerHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#cpu_per_unit OceanEcs#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#memory_per_unit OceanEcs#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#num_of_units OceanEcs#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function oceanEcsAutoscalerHeadroomToTerraform(struct?: OceanEcsAutoscalerHeadroomOutputReference | OceanEcsAutoscalerHeadroom): any;
export declare class OceanEcsAutoscalerHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsAutoscalerHeadroom | undefined;
    set internalValue(value: OceanEcsAutoscalerHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface OceanEcsAutoscalerResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#max_memory_gib OceanEcs#max_memory_gib}
    */
    readonly maxMemoryGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#max_vcpu OceanEcs#max_vcpu}
    */
    readonly maxVcpu?: number;
}
export declare function oceanEcsAutoscalerResourceLimitsToTerraform(struct?: OceanEcsAutoscalerResourceLimitsOutputReference | OceanEcsAutoscalerResourceLimits): any;
export declare class OceanEcsAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsAutoscalerResourceLimits | undefined;
    set internalValue(value: OceanEcsAutoscalerResourceLimits | undefined);
    private _maxMemoryGib?;
    get maxMemoryGib(): number;
    set maxMemoryGib(value: number);
    resetMaxMemoryGib(): void;
    get maxMemoryGibInput(): number | undefined;
    private _maxVcpu?;
    get maxVcpu(): number;
    set maxVcpu(value: number);
    resetMaxVcpu(): void;
    get maxVcpuInput(): number | undefined;
}
export interface OceanEcsAutoscaler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#auto_headroom_percentage OceanEcs#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#cooldown OceanEcs#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#is_auto_config OceanEcs#is_auto_config}
    */
    readonly isAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#is_enabled OceanEcs#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#down OceanEcs#down}
    */
    readonly down?: OceanEcsAutoscalerDown;
    /**
    * headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#headroom OceanEcs#headroom}
    */
    readonly headroom?: OceanEcsAutoscalerHeadroom;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#resource_limits OceanEcs#resource_limits}
    */
    readonly resourceLimits?: OceanEcsAutoscalerResourceLimits;
}
export declare function oceanEcsAutoscalerToTerraform(struct?: OceanEcsAutoscalerOutputReference | OceanEcsAutoscaler): any;
export declare class OceanEcsAutoscalerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsAutoscaler | undefined;
    set internalValue(value: OceanEcsAutoscaler | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _isAutoConfig?;
    get isAutoConfig(): boolean | cdktf.IResolvable;
    set isAutoConfig(value: boolean | cdktf.IResolvable);
    resetIsAutoConfig(): void;
    get isAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _down;
    get down(): OceanEcsAutoscalerDownOutputReference;
    putDown(value: OceanEcsAutoscalerDown): void;
    resetDown(): void;
    get downInput(): OceanEcsAutoscalerDown | undefined;
    private _headroom;
    get headroom(): OceanEcsAutoscalerHeadroomOutputReference;
    putHeadroom(value: OceanEcsAutoscalerHeadroom): void;
    resetHeadroom(): void;
    get headroomInput(): OceanEcsAutoscalerHeadroom | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanEcsAutoscalerResourceLimitsOutputReference;
    putResourceLimits(value: OceanEcsAutoscalerResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanEcsAutoscalerResourceLimits | undefined;
}
export interface OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#base_size OceanEcs#base_size}
    */
    readonly baseSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#resource OceanEcs#resource}
    */
    readonly resource: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#size_per_resource_unit OceanEcs#size_per_resource_unit}
    */
    readonly sizePerResourceUnit: number;
}
export declare function oceanEcsBlockDeviceMappingsEbsDynamicVolumeSizeToTerraform(struct?: OceanEcsBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference | OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize): any;
export declare class OceanEcsBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
    set internalValue(value: OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize | undefined);
    private _baseSize?;
    get baseSize(): number;
    set baseSize(value: number);
    get baseSizeInput(): number | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _sizePerResourceUnit?;
    get sizePerResourceUnit(): number;
    set sizePerResourceUnit(value: number);
    get sizePerResourceUnitInput(): number | undefined;
}
export interface OceanEcsBlockDeviceMappingsEbs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#delete_on_termination OceanEcs#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#encrypted OceanEcs#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#iops OceanEcs#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#kms_key_id OceanEcs#kms_key_id}
    */
    readonly kmsKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#snapshot_id OceanEcs#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#throughput OceanEcs#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#volume_size OceanEcs#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#volume_type OceanEcs#volume_type}
    */
    readonly volumeType?: string;
    /**
    * dynamic_volume_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#dynamic_volume_size OceanEcs#dynamic_volume_size}
    */
    readonly dynamicVolumeSize?: OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize;
}
export declare function oceanEcsBlockDeviceMappingsEbsToTerraform(struct?: OceanEcsBlockDeviceMappingsEbsOutputReference | OceanEcsBlockDeviceMappingsEbs): any;
export declare class OceanEcsBlockDeviceMappingsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsBlockDeviceMappingsEbs | undefined;
    set internalValue(value: OceanEcsBlockDeviceMappingsEbs | undefined);
    private _deleteOnTermination?;
    get deleteOnTermination(): boolean | cdktf.IResolvable;
    set deleteOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOnTermination(): void;
    get deleteOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    get encrypted(): boolean | cdktf.IResolvable;
    set encrypted(value: boolean | cdktf.IResolvable);
    resetEncrypted(): void;
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    resetKmsKeyId(): void;
    get kmsKeyIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _dynamicVolumeSize;
    get dynamicVolumeSize(): OceanEcsBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference;
    putDynamicVolumeSize(value: OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize): void;
    resetDynamicVolumeSize(): void;
    get dynamicVolumeSizeInput(): OceanEcsBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
}
export interface OceanEcsBlockDeviceMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#device_name OceanEcs#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#no_device OceanEcs#no_device}
    */
    readonly noDevice?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#virtual_name OceanEcs#virtual_name}
    */
    readonly virtualName?: string;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#ebs OceanEcs#ebs}
    */
    readonly ebs?: OceanEcsBlockDeviceMappingsEbs;
}
export declare function oceanEcsBlockDeviceMappingsToTerraform(struct?: OceanEcsBlockDeviceMappings | cdktf.IResolvable): any;
export interface OceanEcsInstanceMetadataOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#http_put_response_hop_limit OceanEcs#http_put_response_hop_limit}
    */
    readonly httpPutResponseHopLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#http_tokens OceanEcs#http_tokens}
    */
    readonly httpTokens: string;
}
export declare function oceanEcsInstanceMetadataOptionsToTerraform(struct?: OceanEcsInstanceMetadataOptionsOutputReference | OceanEcsInstanceMetadataOptions): any;
export declare class OceanEcsInstanceMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsInstanceMetadataOptions | undefined;
    set internalValue(value: OceanEcsInstanceMetadataOptions | undefined);
    private _httpPutResponseHopLimit?;
    get httpPutResponseHopLimit(): number;
    set httpPutResponseHopLimit(value: number);
    resetHttpPutResponseHopLimit(): void;
    get httpPutResponseHopLimitInput(): number | undefined;
    private _httpTokens?;
    get httpTokens(): string;
    set httpTokens(value: string);
    get httpTokensInput(): string | undefined;
}
export interface OceanEcsOptimizeImages {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#perform_at OceanEcs#perform_at}
    */
    readonly performAt: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#should_optimize_ecs_ami OceanEcs#should_optimize_ecs_ami}
    */
    readonly shouldOptimizeEcsAmi: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#time_windows OceanEcs#time_windows}
    */
    readonly timeWindows?: string[];
}
export declare function oceanEcsOptimizeImagesToTerraform(struct?: OceanEcsOptimizeImagesOutputReference | OceanEcsOptimizeImages): any;
export declare class OceanEcsOptimizeImagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsOptimizeImages | undefined;
    set internalValue(value: OceanEcsOptimizeImages | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    get performAtInput(): string | undefined;
    private _shouldOptimizeEcsAmi?;
    get shouldOptimizeEcsAmi(): boolean | cdktf.IResolvable;
    set shouldOptimizeEcsAmi(value: boolean | cdktf.IResolvable);
    get shouldOptimizeEcsAmiInput(): boolean | cdktf.IResolvable | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    resetTimeWindows(): void;
    get timeWindowsInput(): string[] | undefined;
}
export interface OceanEcsScheduledTaskShutdownHours {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#is_enabled OceanEcs#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#time_windows OceanEcs#time_windows}
    */
    readonly timeWindows: string[];
}
export declare function oceanEcsScheduledTaskShutdownHoursToTerraform(struct?: OceanEcsScheduledTaskShutdownHoursOutputReference | OceanEcsScheduledTaskShutdownHours): any;
export declare class OceanEcsScheduledTaskShutdownHoursOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsScheduledTaskShutdownHours | undefined;
    set internalValue(value: OceanEcsScheduledTaskShutdownHours | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    get timeWindowsInput(): string[] | undefined;
}
export interface OceanEcsScheduledTaskTasks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#cron_expression OceanEcs#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#is_enabled OceanEcs#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#task_type OceanEcs#task_type}
    */
    readonly taskType: string;
}
export declare function oceanEcsScheduledTaskTasksToTerraform(struct?: OceanEcsScheduledTaskTasks | cdktf.IResolvable): any;
export interface OceanEcsScheduledTask {
    /**
    * shutdown_hours block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#shutdown_hours OceanEcs#shutdown_hours}
    */
    readonly shutdownHours?: OceanEcsScheduledTaskShutdownHours;
    /**
    * tasks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#tasks OceanEcs#tasks}
    */
    readonly tasks?: OceanEcsScheduledTaskTasks[] | cdktf.IResolvable;
}
export declare function oceanEcsScheduledTaskToTerraform(struct?: OceanEcsScheduledTask | cdktf.IResolvable): any;
export interface OceanEcsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#key OceanEcs#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#value OceanEcs#value}
    */
    readonly value: string;
}
export declare function oceanEcsTagsToTerraform(struct?: OceanEcsTags | cdktf.IResolvable): any;
export interface OceanEcsUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#batch_min_healthy_percentage OceanEcs#batch_min_healthy_percentage}
    */
    readonly batchMinHealthyPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#batch_size_percentage OceanEcs#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
}
export declare function oceanEcsUpdatePolicyRollConfigToTerraform(struct?: OceanEcsUpdatePolicyRollConfigOutputReference | OceanEcsUpdatePolicyRollConfig): any;
export declare class OceanEcsUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanEcsUpdatePolicyRollConfig | undefined);
    private _batchMinHealthyPercentage?;
    get batchMinHealthyPercentage(): number;
    set batchMinHealthyPercentage(value: number);
    resetBatchMinHealthyPercentage(): void;
    get batchMinHealthyPercentageInput(): number | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
}
export interface OceanEcsUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#auto_apply_tags OceanEcs#auto_apply_tags}
    */
    readonly autoApplyTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#conditioned_roll OceanEcs#conditioned_roll}
    */
    readonly conditionedRoll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#should_roll OceanEcs#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs#roll_config OceanEcs#roll_config}
    */
    readonly rollConfig?: OceanEcsUpdatePolicyRollConfig;
}
export declare function oceanEcsUpdatePolicyToTerraform(struct?: OceanEcsUpdatePolicyOutputReference | OceanEcsUpdatePolicy): any;
export declare class OceanEcsUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanEcsUpdatePolicy | undefined;
    set internalValue(value: OceanEcsUpdatePolicy | undefined);
    private _autoApplyTags?;
    get autoApplyTags(): boolean | cdktf.IResolvable;
    set autoApplyTags(value: boolean | cdktf.IResolvable);
    resetAutoApplyTags(): void;
    get autoApplyTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _conditionedRoll?;
    get conditionedRoll(): boolean | cdktf.IResolvable;
    set conditionedRoll(value: boolean | cdktf.IResolvable);
    resetConditionedRoll(): void;
    get conditionedRollInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanEcsUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanEcsUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanEcsUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs spotinst_ocean_ecs}
*/
export declare class OceanEcs extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_ecs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_ecs spotinst_ocean_ecs} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanEcsConfig
    */
    constructor(scope: Construct, id: string, config: OceanEcsConfig);
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | cdktf.IResolvable;
    set associatePublicIpAddress(value: boolean | cdktf.IResolvable);
    resetAssociatePublicIpAddress(): void;
    get associatePublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _ebsOptimized?;
    get ebsOptimized(): boolean | cdktf.IResolvable;
    set ebsOptimized(value: boolean | cdktf.IResolvable);
    resetEbsOptimized(): void;
    get ebsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    resetKeyPair(): void;
    get keyPairInput(): string | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _monitoring?;
    get monitoring(): boolean | cdktf.IResolvable;
    set monitoring(value: boolean | cdktf.IResolvable);
    resetMonitoring(): void;
    get monitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    get securityGroupIdsInput(): string[] | undefined;
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _utilizeCommitments?;
    get utilizeCommitments(): boolean | cdktf.IResolvable;
    set utilizeCommitments(value: boolean | cdktf.IResolvable);
    resetUtilizeCommitments(): void;
    get utilizeCommitmentsInput(): boolean | cdktf.IResolvable | undefined;
    private _utilizeReservedInstances?;
    get utilizeReservedInstances(): boolean | cdktf.IResolvable;
    set utilizeReservedInstances(value: boolean | cdktf.IResolvable);
    resetUtilizeReservedInstances(): void;
    get utilizeReservedInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _whitelist?;
    get whitelist(): string[];
    set whitelist(value: string[]);
    resetWhitelist(): void;
    get whitelistInput(): string[] | undefined;
    private _autoscaler;
    get autoscaler(): OceanEcsAutoscalerOutputReference;
    putAutoscaler(value: OceanEcsAutoscaler): void;
    resetAutoscaler(): void;
    get autoscalerInput(): OceanEcsAutoscaler | undefined;
    private _blockDeviceMappings?;
    get blockDeviceMappings(): OceanEcsBlockDeviceMappings[] | cdktf.IResolvable;
    set blockDeviceMappings(value: OceanEcsBlockDeviceMappings[] | cdktf.IResolvable);
    resetBlockDeviceMappings(): void;
    get blockDeviceMappingsInput(): cdktf.IResolvable | OceanEcsBlockDeviceMappings[] | undefined;
    private _instanceMetadataOptions;
    get instanceMetadataOptions(): OceanEcsInstanceMetadataOptionsOutputReference;
    putInstanceMetadataOptions(value: OceanEcsInstanceMetadataOptions): void;
    resetInstanceMetadataOptions(): void;
    get instanceMetadataOptionsInput(): OceanEcsInstanceMetadataOptions | undefined;
    private _optimizeImages;
    get optimizeImages(): OceanEcsOptimizeImagesOutputReference;
    putOptimizeImages(value: OceanEcsOptimizeImages): void;
    resetOptimizeImages(): void;
    get optimizeImagesInput(): OceanEcsOptimizeImages | undefined;
    private _scheduledTask?;
    get scheduledTask(): OceanEcsScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: OceanEcsScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | OceanEcsScheduledTask[] | undefined;
    private _tags?;
    get tags(): OceanEcsTags[] | cdktf.IResolvable;
    set tags(value: OceanEcsTags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | OceanEcsTags[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanEcsUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanEcsUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanEcsUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
