import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanGkeImportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#cluster_name OceanGkeImport#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#controller_cluster_id OceanGkeImport#controller_cluster_id}
    */
    readonly controllerClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#desired_capacity OceanGkeImport#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#location OceanGkeImport#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#max_size OceanGkeImport#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#min_size OceanGkeImport#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#root_volume_type OceanGkeImport#root_volume_type}
    */
    readonly rootVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#whitelist OceanGkeImport#whitelist}
    */
    readonly whitelist?: string[];
    /**
    * autoscaler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#autoscaler OceanGkeImport#autoscaler}
    */
    readonly autoscaler?: OceanGkeImportAutoscaler;
    /**
    * backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#backend_services OceanGkeImport#backend_services}
    */
    readonly backendServices?: OceanGkeImportBackendServices[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#scheduled_task OceanGkeImport#scheduled_task}
    */
    readonly scheduledTask?: OceanGkeImportScheduledTask[] | cdktf.IResolvable;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#shielded_instance_config OceanGkeImport#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: OceanGkeImportShieldedInstanceConfig;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#strategy OceanGkeImport#strategy}
    */
    readonly strategy?: OceanGkeImportStrategy[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#update_policy OceanGkeImport#update_policy}
    */
    readonly updatePolicy?: OceanGkeImportUpdatePolicy;
}
export interface OceanGkeImportAutoscalerDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#evaluation_periods OceanGkeImport#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#max_scale_down_percentage OceanGkeImport#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanGkeImportAutoscalerDownToTerraform(struct?: OceanGkeImportAutoscalerDownOutputReference | OceanGkeImportAutoscalerDown): any;
export declare class OceanGkeImportAutoscalerDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportAutoscalerDown | undefined;
    set internalValue(value: OceanGkeImportAutoscalerDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface OceanGkeImportAutoscalerHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#cpu_per_unit OceanGkeImport#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#gpu_per_unit OceanGkeImport#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#memory_per_unit OceanGkeImport#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#num_of_units OceanGkeImport#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function oceanGkeImportAutoscalerHeadroomToTerraform(struct?: OceanGkeImportAutoscalerHeadroomOutputReference | OceanGkeImportAutoscalerHeadroom): any;
export declare class OceanGkeImportAutoscalerHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportAutoscalerHeadroom | undefined;
    set internalValue(value: OceanGkeImportAutoscalerHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface OceanGkeImportAutoscalerResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#max_memory_gib OceanGkeImport#max_memory_gib}
    */
    readonly maxMemoryGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#max_vcpu OceanGkeImport#max_vcpu}
    */
    readonly maxVcpu?: number;
}
export declare function oceanGkeImportAutoscalerResourceLimitsToTerraform(struct?: OceanGkeImportAutoscalerResourceLimitsOutputReference | OceanGkeImportAutoscalerResourceLimits): any;
export declare class OceanGkeImportAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportAutoscalerResourceLimits | undefined;
    set internalValue(value: OceanGkeImportAutoscalerResourceLimits | undefined);
    private _maxMemoryGib?;
    get maxMemoryGib(): number;
    set maxMemoryGib(value: number);
    resetMaxMemoryGib(): void;
    get maxMemoryGibInput(): number | undefined;
    private _maxVcpu?;
    get maxVcpu(): number;
    set maxVcpu(value: number);
    resetMaxVcpu(): void;
    get maxVcpuInput(): number | undefined;
}
export interface OceanGkeImportAutoscaler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#auto_headroom_percentage OceanGkeImport#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#cooldown OceanGkeImport#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#enable_automatic_and_manual_headroom OceanGkeImport#enable_automatic_and_manual_headroom}
    */
    readonly enableAutomaticAndManualHeadroom?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#is_auto_config OceanGkeImport#is_auto_config}
    */
    readonly isAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#is_enabled OceanGkeImport#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#down OceanGkeImport#down}
    */
    readonly down?: OceanGkeImportAutoscalerDown;
    /**
    * headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#headroom OceanGkeImport#headroom}
    */
    readonly headroom?: OceanGkeImportAutoscalerHeadroom;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#resource_limits OceanGkeImport#resource_limits}
    */
    readonly resourceLimits?: OceanGkeImportAutoscalerResourceLimits;
}
export declare function oceanGkeImportAutoscalerToTerraform(struct?: OceanGkeImportAutoscalerOutputReference | OceanGkeImportAutoscaler): any;
export declare class OceanGkeImportAutoscalerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportAutoscaler | undefined;
    set internalValue(value: OceanGkeImportAutoscaler | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _enableAutomaticAndManualHeadroom?;
    get enableAutomaticAndManualHeadroom(): boolean | cdktf.IResolvable;
    set enableAutomaticAndManualHeadroom(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticAndManualHeadroom(): void;
    get enableAutomaticAndManualHeadroomInput(): boolean | cdktf.IResolvable | undefined;
    private _isAutoConfig?;
    get isAutoConfig(): boolean | cdktf.IResolvable;
    set isAutoConfig(value: boolean | cdktf.IResolvable);
    resetIsAutoConfig(): void;
    get isAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _down;
    get down(): OceanGkeImportAutoscalerDownOutputReference;
    putDown(value: OceanGkeImportAutoscalerDown): void;
    resetDown(): void;
    get downInput(): OceanGkeImportAutoscalerDown | undefined;
    private _headroom;
    get headroom(): OceanGkeImportAutoscalerHeadroomOutputReference;
    putHeadroom(value: OceanGkeImportAutoscalerHeadroom): void;
    resetHeadroom(): void;
    get headroomInput(): OceanGkeImportAutoscalerHeadroom | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanGkeImportAutoscalerResourceLimitsOutputReference;
    putResourceLimits(value: OceanGkeImportAutoscalerResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanGkeImportAutoscalerResourceLimits | undefined;
}
export interface OceanGkeImportBackendServicesNamedPorts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#name OceanGkeImport#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#ports OceanGkeImport#ports}
    */
    readonly ports: string[];
}
export declare function oceanGkeImportBackendServicesNamedPortsToTerraform(struct?: OceanGkeImportBackendServicesNamedPorts | cdktf.IResolvable): any;
export interface OceanGkeImportBackendServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#location_type OceanGkeImport#location_type}
    */
    readonly locationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#scheme OceanGkeImport#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#service_name OceanGkeImport#service_name}
    */
    readonly serviceName: string;
    /**
    * named_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#named_ports OceanGkeImport#named_ports}
    */
    readonly namedPorts?: OceanGkeImportBackendServicesNamedPorts[] | cdktf.IResolvable;
}
export declare function oceanGkeImportBackendServicesToTerraform(struct?: OceanGkeImportBackendServices | cdktf.IResolvable): any;
export interface OceanGkeImportScheduledTaskShutdownHours {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#is_enabled OceanGkeImport#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#time_windows OceanGkeImport#time_windows}
    */
    readonly timeWindows: string[];
}
export declare function oceanGkeImportScheduledTaskShutdownHoursToTerraform(struct?: OceanGkeImportScheduledTaskShutdownHoursOutputReference | OceanGkeImportScheduledTaskShutdownHours): any;
export declare class OceanGkeImportScheduledTaskShutdownHoursOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportScheduledTaskShutdownHours | undefined;
    set internalValue(value: OceanGkeImportScheduledTaskShutdownHours | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    get timeWindowsInput(): string[] | undefined;
}
export interface OceanGkeImportScheduledTaskTasks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#batch_size_percentage OceanGkeImport#batch_size_percentage}
    */
    readonly batchSizePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#cron_expression OceanGkeImport#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#is_enabled OceanGkeImport#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#task_type OceanGkeImport#task_type}
    */
    readonly taskType: string;
}
export declare function oceanGkeImportScheduledTaskTasksToTerraform(struct?: OceanGkeImportScheduledTaskTasks | cdktf.IResolvable): any;
export interface OceanGkeImportScheduledTask {
    /**
    * shutdown_hours block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#shutdown_hours OceanGkeImport#shutdown_hours}
    */
    readonly shutdownHours?: OceanGkeImportScheduledTaskShutdownHours;
    /**
    * tasks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#tasks OceanGkeImport#tasks}
    */
    readonly tasks?: OceanGkeImportScheduledTaskTasks[] | cdktf.IResolvable;
}
export declare function oceanGkeImportScheduledTaskToTerraform(struct?: OceanGkeImportScheduledTask | cdktf.IResolvable): any;
export interface OceanGkeImportShieldedInstanceConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#enable_integrity_monitoring OceanGkeImport#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#enable_secure_boot OceanGkeImport#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function oceanGkeImportShieldedInstanceConfigToTerraform(struct?: OceanGkeImportShieldedInstanceConfigOutputReference | OceanGkeImportShieldedInstanceConfig): any;
export declare class OceanGkeImportShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportShieldedInstanceConfig | undefined;
    set internalValue(value: OceanGkeImportShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanGkeImportStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#draining_timeout OceanGkeImport#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#preemptible_percentage OceanGkeImport#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#provisioning_model OceanGkeImport#provisioning_model}
    */
    readonly provisioningModel?: string;
}
export declare function oceanGkeImportStrategyToTerraform(struct?: OceanGkeImportStrategy | cdktf.IResolvable): any;
export interface OceanGkeImportUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#batch_min_healthy_percentage OceanGkeImport#batch_min_healthy_percentage}
    */
    readonly batchMinHealthyPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#batch_size_percentage OceanGkeImport#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#launch_spec_ids OceanGkeImport#launch_spec_ids}
    */
    readonly launchSpecIds?: string[];
}
export declare function oceanGkeImportUpdatePolicyRollConfigToTerraform(struct?: OceanGkeImportUpdatePolicyRollConfigOutputReference | OceanGkeImportUpdatePolicyRollConfig): any;
export declare class OceanGkeImportUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanGkeImportUpdatePolicyRollConfig | undefined);
    private _batchMinHealthyPercentage?;
    get batchMinHealthyPercentage(): number;
    set batchMinHealthyPercentage(value: number);
    resetBatchMinHealthyPercentage(): void;
    get batchMinHealthyPercentageInput(): number | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
    private _launchSpecIds?;
    get launchSpecIds(): string[];
    set launchSpecIds(value: string[]);
    resetLaunchSpecIds(): void;
    get launchSpecIdsInput(): string[] | undefined;
}
export interface OceanGkeImportUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#conditioned_roll OceanGkeImport#conditioned_roll}
    */
    readonly conditionedRoll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#should_roll OceanGkeImport#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import#roll_config OceanGkeImport#roll_config}
    */
    readonly rollConfig?: OceanGkeImportUpdatePolicyRollConfig;
}
export declare function oceanGkeImportUpdatePolicyToTerraform(struct?: OceanGkeImportUpdatePolicyOutputReference | OceanGkeImportUpdatePolicy): any;
export declare class OceanGkeImportUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeImportUpdatePolicy | undefined;
    set internalValue(value: OceanGkeImportUpdatePolicy | undefined);
    private _conditionedRoll?;
    get conditionedRoll(): boolean | cdktf.IResolvable;
    set conditionedRoll(value: boolean | cdktf.IResolvable);
    resetConditionedRoll(): void;
    get conditionedRollInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanGkeImportUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanGkeImportUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanGkeImportUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import spotinst_ocean_gke_import}
*/
export declare class OceanGkeImport extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_gke_import";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import spotinst_ocean_gke_import} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanGkeImportConfig
    */
    constructor(scope: Construct, id: string, config: OceanGkeImportConfig);
    get clusterControllerId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _controllerClusterId?;
    get controllerClusterId(): string;
    set controllerClusterId(value: string);
    resetControllerClusterId(): void;
    get controllerClusterIdInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _rootVolumeType?;
    get rootVolumeType(): string;
    set rootVolumeType(value: string);
    resetRootVolumeType(): void;
    get rootVolumeTypeInput(): string | undefined;
    private _whitelist?;
    get whitelist(): string[];
    set whitelist(value: string[]);
    resetWhitelist(): void;
    get whitelistInput(): string[] | undefined;
    private _autoscaler;
    get autoscaler(): OceanGkeImportAutoscalerOutputReference;
    putAutoscaler(value: OceanGkeImportAutoscaler): void;
    resetAutoscaler(): void;
    get autoscalerInput(): OceanGkeImportAutoscaler | undefined;
    private _backendServices?;
    get backendServices(): OceanGkeImportBackendServices[] | cdktf.IResolvable;
    set backendServices(value: OceanGkeImportBackendServices[] | cdktf.IResolvable);
    resetBackendServices(): void;
    get backendServicesInput(): cdktf.IResolvable | OceanGkeImportBackendServices[] | undefined;
    private _scheduledTask?;
    get scheduledTask(): OceanGkeImportScheduledTask[] | cdktf.IResolvable;
    set scheduledTask(value: OceanGkeImportScheduledTask[] | cdktf.IResolvable);
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | OceanGkeImportScheduledTask[] | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): OceanGkeImportShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: OceanGkeImportShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): OceanGkeImportShieldedInstanceConfig | undefined;
    private _strategy?;
    get strategy(): OceanGkeImportStrategy[] | cdktf.IResolvable;
    set strategy(value: OceanGkeImportStrategy[] | cdktf.IResolvable);
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | OceanGkeImportStrategy[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanGkeImportUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanGkeImportUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanGkeImportUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
