"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OceanGkeImport = exports.OceanGkeImportUpdatePolicyOutputReference = exports.oceanGkeImportUpdatePolicyToTerraform = exports.OceanGkeImportUpdatePolicyRollConfigOutputReference = exports.oceanGkeImportUpdatePolicyRollConfigToTerraform = exports.oceanGkeImportStrategyToTerraform = exports.OceanGkeImportShieldedInstanceConfigOutputReference = exports.oceanGkeImportShieldedInstanceConfigToTerraform = exports.oceanGkeImportScheduledTaskToTerraform = exports.oceanGkeImportScheduledTaskTasksToTerraform = exports.OceanGkeImportScheduledTaskShutdownHoursOutputReference = exports.oceanGkeImportScheduledTaskShutdownHoursToTerraform = exports.oceanGkeImportBackendServicesToTerraform = exports.oceanGkeImportBackendServicesNamedPortsToTerraform = exports.OceanGkeImportAutoscalerOutputReference = exports.oceanGkeImportAutoscalerToTerraform = exports.OceanGkeImportAutoscalerResourceLimitsOutputReference = exports.oceanGkeImportAutoscalerResourceLimitsToTerraform = exports.OceanGkeImportAutoscalerHeadroomOutputReference = exports.oceanGkeImportAutoscalerHeadroomToTerraform = exports.OceanGkeImportAutoscalerDownOutputReference = exports.oceanGkeImportAutoscalerDownToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function oceanGkeImportAutoscalerDownToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        evaluation_periods: cdktf.numberToTerraform(struct.evaluationPeriods),
        max_scale_down_percentage: cdktf.numberToTerraform(struct.maxScaleDownPercentage),
    };
}
exports.oceanGkeImportAutoscalerDownToTerraform = oceanGkeImportAutoscalerDownToTerraform;
class OceanGkeImportAutoscalerDownOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._evaluationPeriods !== undefined) {
            hasAnyValues = true;
            internalValueResult.evaluationPeriods = this._evaluationPeriods;
        }
        if (this._maxScaleDownPercentage !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxScaleDownPercentage = this._maxScaleDownPercentage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._evaluationPeriods = undefined;
            this._maxScaleDownPercentage = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._evaluationPeriods = value.evaluationPeriods;
            this._maxScaleDownPercentage = value.maxScaleDownPercentage;
        }
    }
    get evaluationPeriods() {
        return this.getNumberAttribute('evaluation_periods');
    }
    set evaluationPeriods(value) {
        this._evaluationPeriods = value;
    }
    resetEvaluationPeriods() {
        this._evaluationPeriods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evaluationPeriodsInput() {
        return this._evaluationPeriods;
    }
    get maxScaleDownPercentage() {
        return this.getNumberAttribute('max_scale_down_percentage');
    }
    set maxScaleDownPercentage(value) {
        this._maxScaleDownPercentage = value;
    }
    resetMaxScaleDownPercentage() {
        this._maxScaleDownPercentage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxScaleDownPercentageInput() {
        return this._maxScaleDownPercentage;
    }
}
exports.OceanGkeImportAutoscalerDownOutputReference = OceanGkeImportAutoscalerDownOutputReference;
_a = JSII_RTTI_SYMBOL_1;
OceanGkeImportAutoscalerDownOutputReference[_a] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportAutoscalerDownOutputReference", version: "0.0.4" };
function oceanGkeImportAutoscalerHeadroomToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cpu_per_unit: cdktf.numberToTerraform(struct.cpuPerUnit),
        gpu_per_unit: cdktf.numberToTerraform(struct.gpuPerUnit),
        memory_per_unit: cdktf.numberToTerraform(struct.memoryPerUnit),
        num_of_units: cdktf.numberToTerraform(struct.numOfUnits),
    };
}
exports.oceanGkeImportAutoscalerHeadroomToTerraform = oceanGkeImportAutoscalerHeadroomToTerraform;
class OceanGkeImportAutoscalerHeadroomOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cpuPerUnit !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuPerUnit = this._cpuPerUnit;
        }
        if (this._gpuPerUnit !== undefined) {
            hasAnyValues = true;
            internalValueResult.gpuPerUnit = this._gpuPerUnit;
        }
        if (this._memoryPerUnit !== undefined) {
            hasAnyValues = true;
            internalValueResult.memoryPerUnit = this._memoryPerUnit;
        }
        if (this._numOfUnits !== undefined) {
            hasAnyValues = true;
            internalValueResult.numOfUnits = this._numOfUnits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cpuPerUnit = undefined;
            this._gpuPerUnit = undefined;
            this._memoryPerUnit = undefined;
            this._numOfUnits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cpuPerUnit = value.cpuPerUnit;
            this._gpuPerUnit = value.gpuPerUnit;
            this._memoryPerUnit = value.memoryPerUnit;
            this._numOfUnits = value.numOfUnits;
        }
    }
    get cpuPerUnit() {
        return this.getNumberAttribute('cpu_per_unit');
    }
    set cpuPerUnit(value) {
        this._cpuPerUnit = value;
    }
    resetCpuPerUnit() {
        this._cpuPerUnit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerUnitInput() {
        return this._cpuPerUnit;
    }
    get gpuPerUnit() {
        return this.getNumberAttribute('gpu_per_unit');
    }
    set gpuPerUnit(value) {
        this._gpuPerUnit = value;
    }
    resetGpuPerUnit() {
        this._gpuPerUnit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gpuPerUnitInput() {
        return this._gpuPerUnit;
    }
    get memoryPerUnit() {
        return this.getNumberAttribute('memory_per_unit');
    }
    set memoryPerUnit(value) {
        this._memoryPerUnit = value;
    }
    resetMemoryPerUnit() {
        this._memoryPerUnit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryPerUnitInput() {
        return this._memoryPerUnit;
    }
    get numOfUnits() {
        return this.getNumberAttribute('num_of_units');
    }
    set numOfUnits(value) {
        this._numOfUnits = value;
    }
    resetNumOfUnits() {
        this._numOfUnits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numOfUnitsInput() {
        return this._numOfUnits;
    }
}
exports.OceanGkeImportAutoscalerHeadroomOutputReference = OceanGkeImportAutoscalerHeadroomOutputReference;
_b = JSII_RTTI_SYMBOL_1;
OceanGkeImportAutoscalerHeadroomOutputReference[_b] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportAutoscalerHeadroomOutputReference", version: "0.0.4" };
function oceanGkeImportAutoscalerResourceLimitsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_memory_gib: cdktf.numberToTerraform(struct.maxMemoryGib),
        max_vcpu: cdktf.numberToTerraform(struct.maxVcpu),
    };
}
exports.oceanGkeImportAutoscalerResourceLimitsToTerraform = oceanGkeImportAutoscalerResourceLimitsToTerraform;
class OceanGkeImportAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxMemoryGib !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxMemoryGib = this._maxMemoryGib;
        }
        if (this._maxVcpu !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxVcpu = this._maxVcpu;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxMemoryGib = undefined;
            this._maxVcpu = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxMemoryGib = value.maxMemoryGib;
            this._maxVcpu = value.maxVcpu;
        }
    }
    get maxMemoryGib() {
        return this.getNumberAttribute('max_memory_gib');
    }
    set maxMemoryGib(value) {
        this._maxMemoryGib = value;
    }
    resetMaxMemoryGib() {
        this._maxMemoryGib = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxMemoryGibInput() {
        return this._maxMemoryGib;
    }
    get maxVcpu() {
        return this.getNumberAttribute('max_vcpu');
    }
    set maxVcpu(value) {
        this._maxVcpu = value;
    }
    resetMaxVcpu() {
        this._maxVcpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxVcpuInput() {
        return this._maxVcpu;
    }
}
exports.OceanGkeImportAutoscalerResourceLimitsOutputReference = OceanGkeImportAutoscalerResourceLimitsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
OceanGkeImportAutoscalerResourceLimitsOutputReference[_c] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportAutoscalerResourceLimitsOutputReference", version: "0.0.4" };
function oceanGkeImportAutoscalerToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auto_headroom_percentage: cdktf.numberToTerraform(struct.autoHeadroomPercentage),
        cooldown: cdktf.numberToTerraform(struct.cooldown),
        enable_automatic_and_manual_headroom: cdktf.booleanToTerraform(struct.enableAutomaticAndManualHeadroom),
        is_auto_config: cdktf.booleanToTerraform(struct.isAutoConfig),
        is_enabled: cdktf.booleanToTerraform(struct.isEnabled),
        down: oceanGkeImportAutoscalerDownToTerraform(struct.down),
        headroom: oceanGkeImportAutoscalerHeadroomToTerraform(struct.headroom),
        resource_limits: oceanGkeImportAutoscalerResourceLimitsToTerraform(struct.resourceLimits),
    };
}
exports.oceanGkeImportAutoscalerToTerraform = oceanGkeImportAutoscalerToTerraform;
class OceanGkeImportAutoscalerOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // down - computed: false, optional: true, required: false
        this._down = new OceanGkeImportAutoscalerDownOutputReference(this, "down");
        // headroom - computed: false, optional: true, required: false
        this._headroom = new OceanGkeImportAutoscalerHeadroomOutputReference(this, "headroom");
        // resource_limits - computed: false, optional: true, required: false
        this._resourceLimits = new OceanGkeImportAutoscalerResourceLimitsOutputReference(this, "resource_limits");
    }
    get internalValue() {
        var _k, _l, _m, _o, _p, _q;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._autoHeadroomPercentage !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoHeadroomPercentage = this._autoHeadroomPercentage;
        }
        if (this._cooldown !== undefined) {
            hasAnyValues = true;
            internalValueResult.cooldown = this._cooldown;
        }
        if (this._enableAutomaticAndManualHeadroom !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableAutomaticAndManualHeadroom = this._enableAutomaticAndManualHeadroom;
        }
        if (this._isAutoConfig !== undefined) {
            hasAnyValues = true;
            internalValueResult.isAutoConfig = this._isAutoConfig;
        }
        if (this._isEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.isEnabled = this._isEnabled;
        }
        if (((_k = this._down) === null || _k === void 0 ? void 0 : _k.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.down = (_l = this._down) === null || _l === void 0 ? void 0 : _l.internalValue;
        }
        if (((_m = this._headroom) === null || _m === void 0 ? void 0 : _m.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.headroom = (_o = this._headroom) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        if (((_p = this._resourceLimits) === null || _p === void 0 ? void 0 : _p.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.resourceLimits = (_q = this._resourceLimits) === null || _q === void 0 ? void 0 : _q.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._autoHeadroomPercentage = undefined;
            this._cooldown = undefined;
            this._enableAutomaticAndManualHeadroom = undefined;
            this._isAutoConfig = undefined;
            this._isEnabled = undefined;
            this._down.internalValue = undefined;
            this._headroom.internalValue = undefined;
            this._resourceLimits.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._autoHeadroomPercentage = value.autoHeadroomPercentage;
            this._cooldown = value.cooldown;
            this._enableAutomaticAndManualHeadroom = value.enableAutomaticAndManualHeadroom;
            this._isAutoConfig = value.isAutoConfig;
            this._isEnabled = value.isEnabled;
            this._down.internalValue = value.down;
            this._headroom.internalValue = value.headroom;
            this._resourceLimits.internalValue = value.resourceLimits;
        }
    }
    get autoHeadroomPercentage() {
        return this.getNumberAttribute('auto_headroom_percentage');
    }
    set autoHeadroomPercentage(value) {
        this._autoHeadroomPercentage = value;
    }
    resetAutoHeadroomPercentage() {
        this._autoHeadroomPercentage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoHeadroomPercentageInput() {
        return this._autoHeadroomPercentage;
    }
    get cooldown() {
        return this.getNumberAttribute('cooldown');
    }
    set cooldown(value) {
        this._cooldown = value;
    }
    resetCooldown() {
        this._cooldown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cooldownInput() {
        return this._cooldown;
    }
    get enableAutomaticAndManualHeadroom() {
        return this.getBooleanAttribute('enable_automatic_and_manual_headroom');
    }
    set enableAutomaticAndManualHeadroom(value) {
        this._enableAutomaticAndManualHeadroom = value;
    }
    resetEnableAutomaticAndManualHeadroom() {
        this._enableAutomaticAndManualHeadroom = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutomaticAndManualHeadroomInput() {
        return this._enableAutomaticAndManualHeadroom;
    }
    get isAutoConfig() {
        return this.getBooleanAttribute('is_auto_config');
    }
    set isAutoConfig(value) {
        this._isAutoConfig = value;
    }
    resetIsAutoConfig() {
        this._isAutoConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isAutoConfigInput() {
        return this._isAutoConfig;
    }
    get isEnabled() {
        return this.getBooleanAttribute('is_enabled');
    }
    set isEnabled(value) {
        this._isEnabled = value;
    }
    resetIsEnabled() {
        this._isEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isEnabledInput() {
        return this._isEnabled;
    }
    get down() {
        return this._down;
    }
    putDown(value) {
        this._down.internalValue = value;
    }
    resetDown() {
        this._down.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get downInput() {
        return this._down.internalValue;
    }
    get headroom() {
        return this._headroom;
    }
    putHeadroom(value) {
        this._headroom.internalValue = value;
    }
    resetHeadroom() {
        this._headroom.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get headroomInput() {
        return this._headroom.internalValue;
    }
    get resourceLimits() {
        return this._resourceLimits;
    }
    putResourceLimits(value) {
        this._resourceLimits.internalValue = value;
    }
    resetResourceLimits() {
        this._resourceLimits.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceLimitsInput() {
        return this._resourceLimits.internalValue;
    }
}
exports.OceanGkeImportAutoscalerOutputReference = OceanGkeImportAutoscalerOutputReference;
_d = JSII_RTTI_SYMBOL_1;
OceanGkeImportAutoscalerOutputReference[_d] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportAutoscalerOutputReference", version: "0.0.4" };
function oceanGkeImportBackendServicesNamedPortsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        ports: cdktf.listMapper(cdktf.stringToTerraform)(struct.ports),
    };
}
exports.oceanGkeImportBackendServicesNamedPortsToTerraform = oceanGkeImportBackendServicesNamedPortsToTerraform;
function oceanGkeImportBackendServicesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        location_type: cdktf.stringToTerraform(struct.locationType),
        scheme: cdktf.stringToTerraform(struct.scheme),
        service_name: cdktf.stringToTerraform(struct.serviceName),
        named_ports: cdktf.listMapper(oceanGkeImportBackendServicesNamedPortsToTerraform)(struct.namedPorts),
    };
}
exports.oceanGkeImportBackendServicesToTerraform = oceanGkeImportBackendServicesToTerraform;
function oceanGkeImportScheduledTaskShutdownHoursToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        is_enabled: cdktf.booleanToTerraform(struct.isEnabled),
        time_windows: cdktf.listMapper(cdktf.stringToTerraform)(struct.timeWindows),
    };
}
exports.oceanGkeImportScheduledTaskShutdownHoursToTerraform = oceanGkeImportScheduledTaskShutdownHoursToTerraform;
class OceanGkeImportScheduledTaskShutdownHoursOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._isEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.isEnabled = this._isEnabled;
        }
        if (this._timeWindows !== undefined) {
            hasAnyValues = true;
            internalValueResult.timeWindows = this._timeWindows;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._isEnabled = undefined;
            this._timeWindows = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._isEnabled = value.isEnabled;
            this._timeWindows = value.timeWindows;
        }
    }
    get isEnabled() {
        return this.getBooleanAttribute('is_enabled');
    }
    set isEnabled(value) {
        this._isEnabled = value;
    }
    resetIsEnabled() {
        this._isEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isEnabledInput() {
        return this._isEnabled;
    }
    get timeWindows() {
        return this.getListAttribute('time_windows');
    }
    set timeWindows(value) {
        this._timeWindows = value;
    }
    // Temporarily expose input value. Use with caution.
    get timeWindowsInput() {
        return this._timeWindows;
    }
}
exports.OceanGkeImportScheduledTaskShutdownHoursOutputReference = OceanGkeImportScheduledTaskShutdownHoursOutputReference;
_e = JSII_RTTI_SYMBOL_1;
OceanGkeImportScheduledTaskShutdownHoursOutputReference[_e] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportScheduledTaskShutdownHoursOutputReference", version: "0.0.4" };
function oceanGkeImportScheduledTaskTasksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        batch_size_percentage: cdktf.numberToTerraform(struct.batchSizePercentage),
        cron_expression: cdktf.stringToTerraform(struct.cronExpression),
        is_enabled: cdktf.booleanToTerraform(struct.isEnabled),
        task_type: cdktf.stringToTerraform(struct.taskType),
    };
}
exports.oceanGkeImportScheduledTaskTasksToTerraform = oceanGkeImportScheduledTaskTasksToTerraform;
function oceanGkeImportScheduledTaskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        shutdown_hours: oceanGkeImportScheduledTaskShutdownHoursToTerraform(struct.shutdownHours),
        tasks: cdktf.listMapper(oceanGkeImportScheduledTaskTasksToTerraform)(struct.tasks),
    };
}
exports.oceanGkeImportScheduledTaskToTerraform = oceanGkeImportScheduledTaskToTerraform;
function oceanGkeImportShieldedInstanceConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_integrity_monitoring: cdktf.booleanToTerraform(struct.enableIntegrityMonitoring),
        enable_secure_boot: cdktf.booleanToTerraform(struct.enableSecureBoot),
    };
}
exports.oceanGkeImportShieldedInstanceConfigToTerraform = oceanGkeImportShieldedInstanceConfigToTerraform;
class OceanGkeImportShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enableIntegrityMonitoring !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableIntegrityMonitoring = this._enableIntegrityMonitoring;
        }
        if (this._enableSecureBoot !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableSecureBoot = this._enableSecureBoot;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enableIntegrityMonitoring = undefined;
            this._enableSecureBoot = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enableIntegrityMonitoring = value.enableIntegrityMonitoring;
            this._enableSecureBoot = value.enableSecureBoot;
        }
    }
    get enableIntegrityMonitoring() {
        return this.getBooleanAttribute('enable_integrity_monitoring');
    }
    set enableIntegrityMonitoring(value) {
        this._enableIntegrityMonitoring = value;
    }
    resetEnableIntegrityMonitoring() {
        this._enableIntegrityMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableIntegrityMonitoringInput() {
        return this._enableIntegrityMonitoring;
    }
    get enableSecureBoot() {
        return this.getBooleanAttribute('enable_secure_boot');
    }
    set enableSecureBoot(value) {
        this._enableSecureBoot = value;
    }
    resetEnableSecureBoot() {
        this._enableSecureBoot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableSecureBootInput() {
        return this._enableSecureBoot;
    }
}
exports.OceanGkeImportShieldedInstanceConfigOutputReference = OceanGkeImportShieldedInstanceConfigOutputReference;
_f = JSII_RTTI_SYMBOL_1;
OceanGkeImportShieldedInstanceConfigOutputReference[_f] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportShieldedInstanceConfigOutputReference", version: "0.0.4" };
function oceanGkeImportStrategyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        draining_timeout: cdktf.numberToTerraform(struct.drainingTimeout),
        preemptible_percentage: cdktf.numberToTerraform(struct.preemptiblePercentage),
        provisioning_model: cdktf.stringToTerraform(struct.provisioningModel),
    };
}
exports.oceanGkeImportStrategyToTerraform = oceanGkeImportStrategyToTerraform;
function oceanGkeImportUpdatePolicyRollConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        batch_min_healthy_percentage: cdktf.numberToTerraform(struct.batchMinHealthyPercentage),
        batch_size_percentage: cdktf.numberToTerraform(struct.batchSizePercentage),
        launch_spec_ids: cdktf.listMapper(cdktf.stringToTerraform)(struct.launchSpecIds),
    };
}
exports.oceanGkeImportUpdatePolicyRollConfigToTerraform = oceanGkeImportUpdatePolicyRollConfigToTerraform;
class OceanGkeImportUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._batchMinHealthyPercentage !== undefined) {
            hasAnyValues = true;
            internalValueResult.batchMinHealthyPercentage = this._batchMinHealthyPercentage;
        }
        if (this._batchSizePercentage !== undefined) {
            hasAnyValues = true;
            internalValueResult.batchSizePercentage = this._batchSizePercentage;
        }
        if (this._launchSpecIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.launchSpecIds = this._launchSpecIds;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._batchMinHealthyPercentage = undefined;
            this._batchSizePercentage = undefined;
            this._launchSpecIds = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._batchMinHealthyPercentage = value.batchMinHealthyPercentage;
            this._batchSizePercentage = value.batchSizePercentage;
            this._launchSpecIds = value.launchSpecIds;
        }
    }
    get batchMinHealthyPercentage() {
        return this.getNumberAttribute('batch_min_healthy_percentage');
    }
    set batchMinHealthyPercentage(value) {
        this._batchMinHealthyPercentage = value;
    }
    resetBatchMinHealthyPercentage() {
        this._batchMinHealthyPercentage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get batchMinHealthyPercentageInput() {
        return this._batchMinHealthyPercentage;
    }
    get batchSizePercentage() {
        return this.getNumberAttribute('batch_size_percentage');
    }
    set batchSizePercentage(value) {
        this._batchSizePercentage = value;
    }
    // Temporarily expose input value. Use with caution.
    get batchSizePercentageInput() {
        return this._batchSizePercentage;
    }
    get launchSpecIds() {
        return this.getListAttribute('launch_spec_ids');
    }
    set launchSpecIds(value) {
        this._launchSpecIds = value;
    }
    resetLaunchSpecIds() {
        this._launchSpecIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get launchSpecIdsInput() {
        return this._launchSpecIds;
    }
}
exports.OceanGkeImportUpdatePolicyRollConfigOutputReference = OceanGkeImportUpdatePolicyRollConfigOutputReference;
_g = JSII_RTTI_SYMBOL_1;
OceanGkeImportUpdatePolicyRollConfigOutputReference[_g] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportUpdatePolicyRollConfigOutputReference", version: "0.0.4" };
function oceanGkeImportUpdatePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        conditioned_roll: cdktf.booleanToTerraform(struct.conditionedRoll),
        should_roll: cdktf.booleanToTerraform(struct.shouldRoll),
        roll_config: oceanGkeImportUpdatePolicyRollConfigToTerraform(struct.rollConfig),
    };
}
exports.oceanGkeImportUpdatePolicyToTerraform = oceanGkeImportUpdatePolicyToTerraform;
class OceanGkeImportUpdatePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // roll_config - computed: false, optional: true, required: false
        this._rollConfig = new OceanGkeImportUpdatePolicyRollConfigOutputReference(this, "roll_config");
    }
    get internalValue() {
        var _k, _l;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._conditionedRoll !== undefined) {
            hasAnyValues = true;
            internalValueResult.conditionedRoll = this._conditionedRoll;
        }
        if (this._shouldRoll !== undefined) {
            hasAnyValues = true;
            internalValueResult.shouldRoll = this._shouldRoll;
        }
        if (((_k = this._rollConfig) === null || _k === void 0 ? void 0 : _k.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.rollConfig = (_l = this._rollConfig) === null || _l === void 0 ? void 0 : _l.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._conditionedRoll = undefined;
            this._shouldRoll = undefined;
            this._rollConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._conditionedRoll = value.conditionedRoll;
            this._shouldRoll = value.shouldRoll;
            this._rollConfig.internalValue = value.rollConfig;
        }
    }
    get conditionedRoll() {
        return this.getBooleanAttribute('conditioned_roll');
    }
    set conditionedRoll(value) {
        this._conditionedRoll = value;
    }
    resetConditionedRoll() {
        this._conditionedRoll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get conditionedRollInput() {
        return this._conditionedRoll;
    }
    get shouldRoll() {
        return this.getBooleanAttribute('should_roll');
    }
    set shouldRoll(value) {
        this._shouldRoll = value;
    }
    // Temporarily expose input value. Use with caution.
    get shouldRollInput() {
        return this._shouldRoll;
    }
    get rollConfig() {
        return this._rollConfig;
    }
    putRollConfig(value) {
        this._rollConfig.internalValue = value;
    }
    resetRollConfig() {
        this._rollConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rollConfigInput() {
        return this._rollConfig.internalValue;
    }
}
exports.OceanGkeImportUpdatePolicyOutputReference = OceanGkeImportUpdatePolicyOutputReference;
_h = JSII_RTTI_SYMBOL_1;
OceanGkeImportUpdatePolicyOutputReference[_h] = { fqn: "@cdktf/provider-spotinst.OceanGkeImportUpdatePolicyOutputReference", version: "0.0.4" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import spotinst_ocean_gke_import}
*/
class OceanGkeImport extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_import spotinst_ocean_gke_import} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanGkeImportConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'spotinst_ocean_gke_import',
            terraformGeneratorMetadata: {
                providerName: 'spotinst',
                providerVersion: '1.73.3',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // autoscaler - computed: false, optional: true, required: false
        this._autoscaler = new OceanGkeImportAutoscalerOutputReference(this, "autoscaler");
        // shielded_instance_config - computed: false, optional: true, required: false
        this._shieldedInstanceConfig = new OceanGkeImportShieldedInstanceConfigOutputReference(this, "shielded_instance_config");
        // update_policy - computed: false, optional: true, required: false
        this._updatePolicy = new OceanGkeImportUpdatePolicyOutputReference(this, "update_policy");
        this._clusterName = config.clusterName;
        this._controllerClusterId = config.controllerClusterId;
        this._desiredCapacity = config.desiredCapacity;
        this._location = config.location;
        this._maxSize = config.maxSize;
        this._minSize = config.minSize;
        this._rootVolumeType = config.rootVolumeType;
        this._whitelist = config.whitelist;
        this._autoscaler.internalValue = config.autoscaler;
        this._backendServices = config.backendServices;
        this._scheduledTask = config.scheduledTask;
        this._shieldedInstanceConfig.internalValue = config.shieldedInstanceConfig;
        this._strategy = config.strategy;
        this._updatePolicy.internalValue = config.updatePolicy;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // cluster_controller_id - computed: true, optional: false, required: false
    get clusterControllerId() {
        return this.getStringAttribute('cluster_controller_id');
    }
    get clusterName() {
        return this.getStringAttribute('cluster_name');
    }
    set clusterName(value) {
        this._clusterName = value;
    }
    // Temporarily expose input value. Use with caution.
    get clusterNameInput() {
        return this._clusterName;
    }
    get controllerClusterId() {
        return this.getStringAttribute('controller_cluster_id');
    }
    set controllerClusterId(value) {
        this._controllerClusterId = value;
    }
    resetControllerClusterId() {
        this._controllerClusterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get controllerClusterIdInput() {
        return this._controllerClusterId;
    }
    get desiredCapacity() {
        return this.getNumberAttribute('desired_capacity');
    }
    set desiredCapacity(value) {
        this._desiredCapacity = value;
    }
    resetDesiredCapacity() {
        this._desiredCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get desiredCapacityInput() {
        return this._desiredCapacity;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get maxSize() {
        return this.getNumberAttribute('max_size');
    }
    set maxSize(value) {
        this._maxSize = value;
    }
    resetMaxSize() {
        this._maxSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSizeInput() {
        return this._maxSize;
    }
    get minSize() {
        return this.getNumberAttribute('min_size');
    }
    set minSize(value) {
        this._minSize = value;
    }
    resetMinSize() {
        this._minSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minSizeInput() {
        return this._minSize;
    }
    get rootVolumeType() {
        return this.getStringAttribute('root_volume_type');
    }
    set rootVolumeType(value) {
        this._rootVolumeType = value;
    }
    resetRootVolumeType() {
        this._rootVolumeType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rootVolumeTypeInput() {
        return this._rootVolumeType;
    }
    get whitelist() {
        return this.getListAttribute('whitelist');
    }
    set whitelist(value) {
        this._whitelist = value;
    }
    resetWhitelist() {
        this._whitelist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whitelistInput() {
        return this._whitelist;
    }
    get autoscaler() {
        return this._autoscaler;
    }
    putAutoscaler(value) {
        this._autoscaler.internalValue = value;
    }
    resetAutoscaler() {
        this._autoscaler.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscalerInput() {
        return this._autoscaler.internalValue;
    }
    get backendServices() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('backend_services')));
    }
    set backendServices(value) {
        this._backendServices = value;
    }
    resetBackendServices() {
        this._backendServices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendServicesInput() {
        return this._backendServices;
    }
    get scheduledTask() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('scheduled_task')));
    }
    set scheduledTask(value) {
        this._scheduledTask = value;
    }
    resetScheduledTask() {
        this._scheduledTask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scheduledTaskInput() {
        return this._scheduledTask;
    }
    get shieldedInstanceConfig() {
        return this._shieldedInstanceConfig;
    }
    putShieldedInstanceConfig(value) {
        this._shieldedInstanceConfig.internalValue = value;
    }
    resetShieldedInstanceConfig() {
        this._shieldedInstanceConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shieldedInstanceConfigInput() {
        return this._shieldedInstanceConfig.internalValue;
    }
    get strategy() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('strategy');
    }
    set strategy(value) {
        this._strategy = value;
    }
    resetStrategy() {
        this._strategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get strategyInput() {
        return this._strategy;
    }
    get updatePolicy() {
        return this._updatePolicy;
    }
    putUpdatePolicy(value) {
        this._updatePolicy.internalValue = value;
    }
    resetUpdatePolicy() {
        this._updatePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updatePolicyInput() {
        return this._updatePolicy.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cluster_name: cdktf.stringToTerraform(this._clusterName),
            controller_cluster_id: cdktf.stringToTerraform(this._controllerClusterId),
            desired_capacity: cdktf.numberToTerraform(this._desiredCapacity),
            location: cdktf.stringToTerraform(this._location),
            max_size: cdktf.numberToTerraform(this._maxSize),
            min_size: cdktf.numberToTerraform(this._minSize),
            root_volume_type: cdktf.stringToTerraform(this._rootVolumeType),
            whitelist: cdktf.listMapper(cdktf.stringToTerraform)(this._whitelist),
            autoscaler: oceanGkeImportAutoscalerToTerraform(this._autoscaler.internalValue),
            backend_services: cdktf.listMapper(oceanGkeImportBackendServicesToTerraform)(this._backendServices),
            scheduled_task: cdktf.listMapper(oceanGkeImportScheduledTaskToTerraform)(this._scheduledTask),
            shielded_instance_config: oceanGkeImportShieldedInstanceConfigToTerraform(this._shieldedInstanceConfig.internalValue),
            strategy: cdktf.listMapper(oceanGkeImportStrategyToTerraform)(this._strategy),
            update_policy: oceanGkeImportUpdatePolicyToTerraform(this._updatePolicy.internalValue),
        };
    }
}
exports.OceanGkeImport = OceanGkeImport;
_j = JSII_RTTI_SYMBOL_1;
OceanGkeImport[_j] = { fqn: "@cdktf/provider-spotinst.OceanGkeImport", version: "0.0.4" };
// =================
// STATIC PROPERTIES
// =================
OceanGkeImport.tfResourceType = "spotinst_ocean_gke_import";
//# sourceMappingURL=data:application/json;base64,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