import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanGkeLaunchSpecConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#instance_types OceanGkeLaunchSpec#instance_types}
    */
    readonly instanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#name OceanGkeLaunchSpec#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#node_pool_name OceanGkeLaunchSpec#node_pool_name}
    */
    readonly nodePoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#ocean_id OceanGkeLaunchSpec#ocean_id}
    */
    readonly oceanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#restrict_scale_down OceanGkeLaunchSpec#restrict_scale_down}
    */
    readonly restrictScaleDown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#root_volume_size OceanGkeLaunchSpec#root_volume_size}
    */
    readonly rootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#root_volume_type OceanGkeLaunchSpec#root_volume_type}
    */
    readonly rootVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#service_account OceanGkeLaunchSpec#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#source_image OceanGkeLaunchSpec#source_image}
    */
    readonly sourceImage?: string;
    /**
    * autoscale_headrooms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#autoscale_headrooms OceanGkeLaunchSpec#autoscale_headrooms}
    */
    readonly autoscaleHeadrooms?: OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * autoscale_headrooms_automatic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#autoscale_headrooms_automatic OceanGkeLaunchSpec#autoscale_headrooms_automatic}
    */
    readonly autoscaleHeadroomsAutomatic?: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#labels OceanGkeLaunchSpec#labels}
    */
    readonly labels?: OceanGkeLaunchSpecLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#metadata OceanGkeLaunchSpec#metadata}
    */
    readonly metadata?: OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#resource_limits OceanGkeLaunchSpec#resource_limits}
    */
    readonly resourceLimits?: OceanGkeLaunchSpecResourceLimits;
    /**
    * scheduling_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#scheduling_task OceanGkeLaunchSpec#scheduling_task}
    */
    readonly schedulingTask?: OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#shielded_instance_config OceanGkeLaunchSpec#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: OceanGkeLaunchSpecShieldedInstanceConfig;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#storage OceanGkeLaunchSpec#storage}
    */
    readonly storage?: OceanGkeLaunchSpecStorage;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#strategy OceanGkeLaunchSpec#strategy}
    */
    readonly strategy?: OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#taints OceanGkeLaunchSpec#taints}
    */
    readonly taints?: OceanGkeLaunchSpecTaints[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#update_policy OceanGkeLaunchSpec#update_policy}
    */
    readonly updatePolicy?: OceanGkeLaunchSpecUpdatePolicy;
}
export interface OceanGkeLaunchSpecAutoscaleHeadrooms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cpu_per_unit OceanGkeLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#gpu_per_unit OceanGkeLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#memory_per_unit OceanGkeLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#num_of_units OceanGkeLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanGkeLaunchSpecAutoscaleHeadroomsToTerraform(struct?: OceanGkeLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#auto_headroom_percentage OceanGkeLaunchSpec#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
}
export declare function oceanGkeLaunchSpecAutoscaleHeadroomsAutomaticToTerraform(struct?: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecLabelsToTerraform(struct?: OceanGkeLaunchSpecLabels | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecMetadataToTerraform(struct?: OceanGkeLaunchSpecMetadata | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#max_instance_count OceanGkeLaunchSpec#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#min_instance_count OceanGkeLaunchSpec#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function oceanGkeLaunchSpecResourceLimitsToTerraform(struct?: OceanGkeLaunchSpecResourceLimitsOutputReference | OceanGkeLaunchSpecResourceLimits): any;
export declare class OceanGkeLaunchSpecResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecResourceLimits | undefined;
    set internalValue(value: OceanGkeLaunchSpecResourceLimits | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export interface OceanGkeLaunchSpecSchedulingTaskTaskHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cpu_per_unit OceanGkeLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#gpu_per_unit OceanGkeLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#memory_per_unit OceanGkeLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#num_of_units OceanGkeLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanGkeLaunchSpecSchedulingTaskTaskHeadroomToTerraform(struct?: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecSchedulingTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cron_expression OceanGkeLaunchSpec#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#is_enabled OceanGkeLaunchSpec#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#task_type OceanGkeLaunchSpec#task_type}
    */
    readonly taskType: string;
    /**
    * task_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#task_headroom OceanGkeLaunchSpec#task_headroom}
    */
    readonly taskHeadroom?: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
}
export declare function oceanGkeLaunchSpecSchedulingTaskToTerraform(struct?: OceanGkeLaunchSpecSchedulingTask | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecShieldedInstanceConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#enable_integrity_monitoring OceanGkeLaunchSpec#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#enable_secure_boot OceanGkeLaunchSpec#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function oceanGkeLaunchSpecShieldedInstanceConfigToTerraform(struct?: OceanGkeLaunchSpecShieldedInstanceConfigOutputReference | OceanGkeLaunchSpecShieldedInstanceConfig): any;
export declare class OceanGkeLaunchSpecShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecShieldedInstanceConfig | undefined;
    set internalValue(value: OceanGkeLaunchSpecShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanGkeLaunchSpecStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#local_ssd_count OceanGkeLaunchSpec#local_ssd_count}
    */
    readonly localSsdCount?: number;
}
export declare function oceanGkeLaunchSpecStorageToTerraform(struct?: OceanGkeLaunchSpecStorageOutputReference | OceanGkeLaunchSpecStorage): any;
export declare class OceanGkeLaunchSpecStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecStorage | undefined;
    set internalValue(value: OceanGkeLaunchSpecStorage | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
}
export interface OceanGkeLaunchSpecStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#preemptible_percentage OceanGkeLaunchSpec#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
}
export declare function oceanGkeLaunchSpecStrategyToTerraform(struct?: OceanGkeLaunchSpecStrategy | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecTaints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#effect OceanGkeLaunchSpec#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecTaintsToTerraform(struct?: OceanGkeLaunchSpecTaints | cdktf.IResolvable): any;
export interface OceanGkeLaunchSpecUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#batch_size_percentage OceanGkeLaunchSpec#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
}
export declare function oceanGkeLaunchSpecUpdatePolicyRollConfigToTerraform(struct?: OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference | OceanGkeLaunchSpecUpdatePolicyRollConfig): any;
export declare class OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
}
export interface OceanGkeLaunchSpecUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#should_roll OceanGkeLaunchSpec#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#roll_config OceanGkeLaunchSpec#roll_config}
    */
    readonly rollConfig?: OceanGkeLaunchSpecUpdatePolicyRollConfig;
}
export declare function oceanGkeLaunchSpecUpdatePolicyToTerraform(struct?: OceanGkeLaunchSpecUpdatePolicyOutputReference | OceanGkeLaunchSpecUpdatePolicy): any;
export declare class OceanGkeLaunchSpecUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecUpdatePolicy | undefined;
    set internalValue(value: OceanGkeLaunchSpecUpdatePolicy | undefined);
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanGkeLaunchSpecUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec spotinst_ocean_gke_launch_spec}
*/
export declare class OceanGkeLaunchSpec extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_gke_launch_spec";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec spotinst_ocean_gke_launch_spec} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanGkeLaunchSpecConfig
    */
    constructor(scope: Construct, id: string, config: OceanGkeLaunchSpecConfig);
    get id(): string;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    resetInstanceTypes(): void;
    get instanceTypesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodePoolName?;
    get nodePoolName(): string;
    set nodePoolName(value: string);
    resetNodePoolName(): void;
    get nodePoolNameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _restrictScaleDown?;
    get restrictScaleDown(): boolean | cdktf.IResolvable;
    set restrictScaleDown(value: boolean | cdktf.IResolvable);
    resetRestrictScaleDown(): void;
    get restrictScaleDownInput(): boolean | cdktf.IResolvable | undefined;
    private _rootVolumeSize?;
    get rootVolumeSize(): number;
    set rootVolumeSize(value: number);
    resetRootVolumeSize(): void;
    get rootVolumeSizeInput(): number | undefined;
    private _rootVolumeType?;
    get rootVolumeType(): string;
    set rootVolumeType(value: string);
    resetRootVolumeType(): void;
    get rootVolumeTypeInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _autoscaleHeadrooms?;
    get autoscaleHeadrooms(): OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    set autoscaleHeadrooms(value: OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable);
    resetAutoscaleHeadrooms(): void;
    get autoscaleHeadroomsInput(): cdktf.IResolvable | OceanGkeLaunchSpecAutoscaleHeadrooms[] | undefined;
    private _autoscaleHeadroomsAutomatic?;
    get autoscaleHeadroomsAutomatic(): OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    set autoscaleHeadroomsAutomatic(value: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable);
    resetAutoscaleHeadroomsAutomatic(): void;
    get autoscaleHeadroomsAutomaticInput(): cdktf.IResolvable | OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | undefined;
    private _labels?;
    get labels(): OceanGkeLaunchSpecLabels[] | cdktf.IResolvable;
    set labels(value: OceanGkeLaunchSpecLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | OceanGkeLaunchSpecLabels[] | undefined;
    private _metadata?;
    get metadata(): OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable;
    set metadata(value: OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | OceanGkeLaunchSpecMetadata[] | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanGkeLaunchSpecResourceLimitsOutputReference;
    putResourceLimits(value: OceanGkeLaunchSpecResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanGkeLaunchSpecResourceLimits | undefined;
    private _schedulingTask?;
    get schedulingTask(): OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    set schedulingTask(value: OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable);
    resetSchedulingTask(): void;
    get schedulingTaskInput(): cdktf.IResolvable | OceanGkeLaunchSpecSchedulingTask[] | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): OceanGkeLaunchSpecShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: OceanGkeLaunchSpecShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): OceanGkeLaunchSpecShieldedInstanceConfig | undefined;
    private _storage;
    get storage(): OceanGkeLaunchSpecStorageOutputReference;
    putStorage(value: OceanGkeLaunchSpecStorage): void;
    resetStorage(): void;
    get storageInput(): OceanGkeLaunchSpecStorage | undefined;
    private _strategy?;
    get strategy(): OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable;
    set strategy(value: OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable);
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | OceanGkeLaunchSpecStrategy[] | undefined;
    private _taints?;
    get taints(): OceanGkeLaunchSpecTaints[] | cdktf.IResolvable;
    set taints(value: OceanGkeLaunchSpecTaints[] | cdktf.IResolvable);
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | OceanGkeLaunchSpecTaints[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanGkeLaunchSpecUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanGkeLaunchSpecUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanGkeLaunchSpecUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
