import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/subscription#endpoint Subscription#endpoint}
    */
    readonly endpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/subscription#event_type Subscription#event_type}
    */
    readonly eventType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/subscription#format Subscription#format}
    */
    readonly format?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/subscription#protocol Subscription#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/subscription#resource_id Subscription#resource_id}
    */
    readonly resourceId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/subscription spotinst_subscription}
*/
export declare class Subscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/subscription spotinst_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionConfig);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    get eventTypeInput(): string | undefined;
    private _format?;
    get format(): {
        [key: string]: string;
    };
    set format(value: {
        [key: string]: string;
    });
    resetFormat(): void;
    get formatInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
