'''
# Terraform CDK spotinst Provider ~> 1.0

This repo builds and publishes the Terraform spotinst Provider bindings for [cdktf](https://cdk.tf).

## Available Packages

### NPM

The npm package is available at [https://www.npmjs.com/package/@cdktf/provider-spotinst](https://www.npmjs.com/package/@cdktf/provider-spotinst).

`npm install @cdktf/provider-spotinst`

### PyPI

The PyPI package is available at [https://pypi.org/project/cdktf-cdktf-provider-spotinst](https://pypi.org/project/cdktf-cdktf-provider-spotinst).

`pipenv install cdktf-cdktf-provider-spotinst`

### Nuget

The Nuget package is available at [https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Spotinst](https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Spotinst).

`dotnet add package HashiCorp.Cdktf.Providers.Spotinst`

### Maven

The Maven package is available at [https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-spotinst](https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-spotinst).

```
<dependency>
    <groupId>com.hashicorp</groupId>
    <artifactId>cdktf-provider-spotinst</artifactId>
    <version>[REPLACE WITH DESIRED VERSION]</version>
</dependency>
```

## Docs

Find auto-generated docs for this provider here: [./API.md](./API.md)

## Versioning

This project is explicitly not tracking the Terraform spotinst Provider version 1:1. In fact, it always tracks `latest` of `~> 1.0` with every release. If there are scenarios where you explicitly have to pin your provider version, you can do so by generating the [provider constructs manually](https://cdk.tf/imports).

These are the upstream dependencies:

* [Terraform CDK](https://cdk.tf)
* [Terraform spotinst Provider](https://github.com/terraform-providers/terraform-provider-spotinst)
* [Terraform Engine](https://terraform.io)

If there are breaking changes (backward incompatible) in any of the above, the major version of this project will be bumped. While the Terraform Engine and the Terraform spotinst Provider are relatively stable, the Terraform CDK is in an early stage. Therefore, it's likely that there will be breaking changes.

## Features / Issues / Bugs

Please report bugs and issues to the [terraform cdk](https://cdk.tf) project:

* [Create bug report](https://cdk.tf/bug)
* [Create feature request](https://cdk.tf/feature)

## Contributing

### projen

This is mostly based on [projen](https://github.com/eladb/projen), which takes care of generating the entire repository.

### cdktf-provider-project based on projen

There's a custom [project builder](https://github.com/hashicorp/cdktf-provider-project) which encapsulate the common settings for all `cdktf` providers.

### Provider Version

The provider version can be adjusted in [./.projenrc.js](./.projenrc.js).

### Repository Management

The repository is managed by [Repository Manager](https://github.com/hashicorp/cdktf-repository-manager/)
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import cdktf
import constructs


class DataIntegration(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.DataIntegration",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration spotinst_data_integration}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        s3: typing.Optional["DataIntegrationS3"] = None,
        status: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration spotinst_data_integration} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#name DataIntegration#name}.
        :param s3: s3 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#s3 DataIntegration#s3}
        :param status: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#status DataIntegration#status}.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = DataIntegrationConfig(
            name=name,
            s3=s3,
            status=status,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putS3")
    def put_s3(
        self,
        *,
        bucket_name: builtins.str,
        subdir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param bucket_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#bucket_name DataIntegration#bucket_name}.
        :param subdir: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#subdir DataIntegration#subdir}.
        '''
        value = DataIntegrationS3(bucket_name=bucket_name, subdir=subdir)

        return typing.cast(None, jsii.invoke(self, "putS3", [value]))

    @jsii.member(jsii_name="resetS3")
    def reset_s3(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetS3", []))

    @jsii.member(jsii_name="resetStatus")
    def reset_status(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStatus", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="s3")
    def s3(self) -> "DataIntegrationS3OutputReference":
        return typing.cast("DataIntegrationS3OutputReference", jsii.get(self, "s3"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="s3Input")
    def s3_input(self) -> typing.Optional["DataIntegrationS3"]:
        return typing.cast(typing.Optional["DataIntegrationS3"], jsii.get(self, "s3Input"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statusInput")
    def status_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statusInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="status")
    def status(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "status"))

    @status.setter
    def status(self, value: builtins.str) -> None:
        jsii.set(self, "status", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.DataIntegrationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "s3": "s3",
        "status": "status",
    },
)
class DataIntegrationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
        s3: typing.Optional["DataIntegrationS3"] = None,
        status: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#name DataIntegration#name}.
        :param s3: s3 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#s3 DataIntegration#s3}
        :param status: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#status DataIntegration#status}.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(s3, dict):
            s3 = DataIntegrationS3(**s3)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if s3 is not None:
            self._values["s3"] = s3
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#name DataIntegration#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def s3(self) -> typing.Optional["DataIntegrationS3"]:
        '''s3 block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#s3 DataIntegration#s3}
        '''
        result = self._values.get("s3")
        return typing.cast(typing.Optional["DataIntegrationS3"], result)

    @builtins.property
    def status(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#status DataIntegration#status}.'''
        result = self._values.get("status")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataIntegrationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.DataIntegrationS3",
    jsii_struct_bases=[],
    name_mapping={"bucket_name": "bucketName", "subdir": "subdir"},
)
class DataIntegrationS3:
    def __init__(
        self,
        *,
        bucket_name: builtins.str,
        subdir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param bucket_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#bucket_name DataIntegration#bucket_name}.
        :param subdir: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#subdir DataIntegration#subdir}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "bucket_name": bucket_name,
        }
        if subdir is not None:
            self._values["subdir"] = subdir

    @builtins.property
    def bucket_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#bucket_name DataIntegration#bucket_name}.'''
        result = self._values.get("bucket_name")
        assert result is not None, "Required property 'bucket_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subdir(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/data_integration#subdir DataIntegration#subdir}.'''
        result = self._values.get("subdir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataIntegrationS3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataIntegrationS3OutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.DataIntegrationS3OutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetSubdir")
    def reset_subdir(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSubdir", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bucketNameInput")
    def bucket_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "bucketNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subdirInput")
    def subdir_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subdirInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bucketName")
    def bucket_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "bucketName"))

    @bucket_name.setter
    def bucket_name(self, value: builtins.str) -> None:
        jsii.set(self, "bucketName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subdir")
    def subdir(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "subdir"))

    @subdir.setter
    def subdir(self, value: builtins.str) -> None:
        jsii.set(self, "subdir", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DataIntegrationS3]:
        return typing.cast(typing.Optional[DataIntegrationS3], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[DataIntegrationS3]) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAws(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAws",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws spotinst_elastigroup_aws}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        fallback_to_ondemand: typing.Union[builtins.bool, cdktf.IResolvable],
        instance_types_ondemand: builtins.str,
        instance_types_spot: typing.Sequence[builtins.str],
        name: builtins.str,
        orientation: builtins.str,
        product: builtins.str,
        security_groups: typing.Sequence[builtins.str],
        availability_zones: typing.Optional[typing.Sequence[builtins.str]] = None,
        block_devices_mode: typing.Optional[builtins.str] = None,
        capacity_unit: typing.Optional[builtins.str] = None,
        cpu_credits: typing.Optional[builtins.str] = None,
        cpu_options: typing.Optional["ElastigroupAwsCpuOptions"] = None,
        description: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        draining_timeout: typing.Optional[jsii.Number] = None,
        ebs_block_device: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsEbsBlockDevice"]]] = None,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        elastic_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
        elastic_load_balancers: typing.Optional[typing.Sequence[builtins.str]] = None,
        enable_monitoring: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        ephemeral_block_device: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsEphemeralBlockDevice"]]] = None,
        health_check_grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        health_check_unhealthy_duration_before_replacement: typing.Optional[jsii.Number] = None,
        iam_instance_profile: typing.Optional[builtins.str] = None,
        image_id: typing.Optional[builtins.str] = None,
        instance_types_preferred_spot: typing.Optional[typing.Sequence[builtins.str]] = None,
        instance_types_weights: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsInstanceTypesWeights"]]] = None,
        integration_beanstalk: typing.Optional["ElastigroupAwsIntegrationBeanstalk"] = None,
        integration_codedeploy: typing.Optional["ElastigroupAwsIntegrationCodedeploy"] = None,
        integration_docker_swarm: typing.Optional["ElastigroupAwsIntegrationDockerSwarm"] = None,
        integration_ecs: typing.Optional["ElastigroupAwsIntegrationEcs"] = None,
        integration_gitlab: typing.Optional["ElastigroupAwsIntegrationGitlab"] = None,
        integration_kubernetes: typing.Optional["ElastigroupAwsIntegrationKubernetes"] = None,
        integration_mesosphere: typing.Optional["ElastigroupAwsIntegrationMesosphere"] = None,
        integration_multai_runtime: typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"] = None,
        integration_nomad: typing.Optional["ElastigroupAwsIntegrationNomad"] = None,
        integration_rancher: typing.Optional["ElastigroupAwsIntegrationRancher"] = None,
        integration_route53: typing.Optional["ElastigroupAwsIntegrationRoute53"] = None,
        itf: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItf"]]] = None,
        key_name: typing.Optional[builtins.str] = None,
        lifetime_period: typing.Optional[builtins.str] = None,
        max_size: typing.Optional[jsii.Number] = None,
        metadata_options: typing.Optional["ElastigroupAwsMetadataOptions"] = None,
        minimum_instance_lifetime: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        multai_target_sets: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultaiTargetSets"]]] = None,
        multiple_metrics: typing.Optional["ElastigroupAwsMultipleMetrics"] = None,
        network_interface: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsNetworkInterface"]]] = None,
        ondemand_count: typing.Optional[jsii.Number] = None,
        persist_block_devices: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        persist_private_ip: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        persist_root_device: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        placement_tenancy: typing.Optional[builtins.str] = None,
        preferred_availability_zones: typing.Optional[typing.Sequence[builtins.str]] = None,
        private_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
        region: typing.Optional[builtins.str] = None,
        resource_tag_specification: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsResourceTagSpecification"]]] = None,
        revert_to_spot: typing.Optional["ElastigroupAwsRevertToSpot"] = None,
        scaling_down_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingDownPolicy"]]] = None,
        scaling_strategy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingStrategy"]]] = None,
        scaling_target_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingTargetPolicy"]]] = None,
        scaling_up_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingUpPolicy"]]] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScheduledTask"]]] = None,
        shutdown_script: typing.Optional[builtins.str] = None,
        signal: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsSignal"]]] = None,
        spot_percentage: typing.Optional[jsii.Number] = None,
        stateful_deallocation: typing.Optional["ElastigroupAwsStatefulDeallocation"] = None,
        stateful_instance_action: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsStatefulInstanceAction"]]] = None,
        subnet_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        tags: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsTags"]]] = None,
        target_group_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        update_policy: typing.Optional["ElastigroupAwsUpdatePolicy"] = None,
        user_data: typing.Optional[builtins.str] = None,
        utilize_commitments: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        utilize_reserved_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        wait_for_capacity: typing.Optional[jsii.Number] = None,
        wait_for_capacity_timeout: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws spotinst_elastigroup_aws} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param fallback_to_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fallback_to_ondemand ElastigroupAws#fallback_to_ondemand}.
        :param instance_types_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_ondemand ElastigroupAws#instance_types_ondemand}.
        :param instance_types_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_spot ElastigroupAws#instance_types_spot}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param orientation: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#orientation ElastigroupAws#orientation}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#product ElastigroupAws#product}.
        :param security_groups: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#security_groups ElastigroupAws#security_groups}.
        :param availability_zones: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#availability_zones ElastigroupAws#availability_zones}.
        :param block_devices_mode: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#block_devices_mode ElastigroupAws#block_devices_mode}.
        :param capacity_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#capacity_unit ElastigroupAws#capacity_unit}.
        :param cpu_credits: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_credits ElastigroupAws#cpu_credits}.
        :param cpu_options: cpu_options block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_options ElastigroupAws#cpu_options}
        :param description: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#desired_capacity ElastigroupAws#desired_capacity}.
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.
        :param ebs_block_device: ebs_block_device block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_block_device ElastigroupAws#ebs_block_device}
        :param ebs_optimized: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_optimized ElastigroupAws#ebs_optimized}.
        :param elastic_ips: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_ips ElastigroupAws#elastic_ips}.
        :param elastic_load_balancers: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_load_balancers ElastigroupAws#elastic_load_balancers}.
        :param enable_monitoring: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#enable_monitoring ElastigroupAws#enable_monitoring}.
        :param ephemeral_block_device: ephemeral_block_device block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ephemeral_block_device ElastigroupAws#ephemeral_block_device}
        :param health_check_grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_grace_period ElastigroupAws#health_check_grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.
        :param health_check_unhealthy_duration_before_replacement: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_unhealthy_duration_before_replacement ElastigroupAws#health_check_unhealthy_duration_before_replacement}.
        :param iam_instance_profile: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iam_instance_profile ElastigroupAws#iam_instance_profile}.
        :param image_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#image_id ElastigroupAws#image_id}.
        :param instance_types_preferred_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_preferred_spot ElastigroupAws#instance_types_preferred_spot}.
        :param instance_types_weights: instance_types_weights block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_weights ElastigroupAws#instance_types_weights}
        :param integration_beanstalk: integration_beanstalk block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_beanstalk ElastigroupAws#integration_beanstalk}
        :param integration_codedeploy: integration_codedeploy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_codedeploy ElastigroupAws#integration_codedeploy}
        :param integration_docker_swarm: integration_docker_swarm block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_docker_swarm ElastigroupAws#integration_docker_swarm}
        :param integration_ecs: integration_ecs block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_ecs ElastigroupAws#integration_ecs}
        :param integration_gitlab: integration_gitlab block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_gitlab ElastigroupAws#integration_gitlab}
        :param integration_kubernetes: integration_kubernetes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_kubernetes ElastigroupAws#integration_kubernetes}
        :param integration_mesosphere: integration_mesosphere block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mesosphere ElastigroupAws#integration_mesosphere}
        :param integration_multai_runtime: integration_multai_runtime block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_multai_runtime ElastigroupAws#integration_multai_runtime}
        :param integration_nomad: integration_nomad block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_nomad ElastigroupAws#integration_nomad}
        :param integration_rancher: integration_rancher block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_rancher ElastigroupAws#integration_rancher}
        :param integration_route53: integration_route53 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_route53 ElastigroupAws#integration_route53}
        :param itf: itf block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#itf ElastigroupAws#itf}
        :param key_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key_name ElastigroupAws#key_name}.
        :param lifetime_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#lifetime_period ElastigroupAws#lifetime_period}.
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_size ElastigroupAws#max_size}.
        :param metadata_options: metadata_options block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metadata_options ElastigroupAws#metadata_options}
        :param minimum_instance_lifetime: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum_instance_lifetime ElastigroupAws#minimum_instance_lifetime}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_size ElastigroupAws#min_size}.
        :param multai_target_sets: multai_target_sets block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multai_target_sets ElastigroupAws#multai_target_sets}
        :param multiple_metrics: multiple_metrics block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multiple_metrics ElastigroupAws#multiple_metrics}
        :param network_interface: network_interface block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface ElastigroupAws#network_interface}
        :param ondemand_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ondemand_count ElastigroupAws#ondemand_count}.
        :param persist_block_devices: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_block_devices ElastigroupAws#persist_block_devices}.
        :param persist_private_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_private_ip ElastigroupAws#persist_private_ip}.
        :param persist_root_device: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_root_device ElastigroupAws#persist_root_device}.
        :param placement_tenancy: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#placement_tenancy ElastigroupAws#placement_tenancy}.
        :param preferred_availability_zones: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#preferred_availability_zones ElastigroupAws#preferred_availability_zones}.
        :param private_ips: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ips ElastigroupAws#private_ips}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#region ElastigroupAws#region}.
        :param resource_tag_specification: resource_tag_specification block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#resource_tag_specification ElastigroupAws#resource_tag_specification}
        :param revert_to_spot: revert_to_spot block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#revert_to_spot ElastigroupAws#revert_to_spot}
        :param scaling_down_policy: scaling_down_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_down_policy ElastigroupAws#scaling_down_policy}
        :param scaling_strategy: scaling_strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_strategy ElastigroupAws#scaling_strategy}
        :param scaling_target_policy: scaling_target_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_target_policy ElastigroupAws#scaling_target_policy}
        :param scaling_up_policy: scaling_up_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_up_policy ElastigroupAws#scaling_up_policy}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scheduled_task ElastigroupAws#scheduled_task}
        :param shutdown_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#shutdown_script ElastigroupAws#shutdown_script}.
        :param signal: signal block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#signal ElastigroupAws#signal}
        :param spot_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spot_percentage ElastigroupAws#spot_percentage}.
        :param stateful_deallocation: stateful_deallocation block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_deallocation ElastigroupAws#stateful_deallocation}
        :param stateful_instance_action: stateful_instance_action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_action ElastigroupAws#stateful_instance_action}
        :param subnet_ids: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#subnet_ids ElastigroupAws#subnet_ids}.
        :param tags: tags block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
        :param target_group_arns: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_arns ElastigroupAws#target_group_arns}.
        :param update_policy: update_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_policy ElastigroupAws#update_policy}
        :param user_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#user_data ElastigroupAws#user_data}.
        :param utilize_commitments: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_commitments ElastigroupAws#utilize_commitments}.
        :param utilize_reserved_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_reserved_instances ElastigroupAws#utilize_reserved_instances}.
        :param wait_for_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity ElastigroupAws#wait_for_capacity}.
        :param wait_for_capacity_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity_timeout ElastigroupAws#wait_for_capacity_timeout}.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupAwsConfig(
            fallback_to_ondemand=fallback_to_ondemand,
            instance_types_ondemand=instance_types_ondemand,
            instance_types_spot=instance_types_spot,
            name=name,
            orientation=orientation,
            product=product,
            security_groups=security_groups,
            availability_zones=availability_zones,
            block_devices_mode=block_devices_mode,
            capacity_unit=capacity_unit,
            cpu_credits=cpu_credits,
            cpu_options=cpu_options,
            description=description,
            desired_capacity=desired_capacity,
            draining_timeout=draining_timeout,
            ebs_block_device=ebs_block_device,
            ebs_optimized=ebs_optimized,
            elastic_ips=elastic_ips,
            elastic_load_balancers=elastic_load_balancers,
            enable_monitoring=enable_monitoring,
            ephemeral_block_device=ephemeral_block_device,
            health_check_grace_period=health_check_grace_period,
            health_check_type=health_check_type,
            health_check_unhealthy_duration_before_replacement=health_check_unhealthy_duration_before_replacement,
            iam_instance_profile=iam_instance_profile,
            image_id=image_id,
            instance_types_preferred_spot=instance_types_preferred_spot,
            instance_types_weights=instance_types_weights,
            integration_beanstalk=integration_beanstalk,
            integration_codedeploy=integration_codedeploy,
            integration_docker_swarm=integration_docker_swarm,
            integration_ecs=integration_ecs,
            integration_gitlab=integration_gitlab,
            integration_kubernetes=integration_kubernetes,
            integration_mesosphere=integration_mesosphere,
            integration_multai_runtime=integration_multai_runtime,
            integration_nomad=integration_nomad,
            integration_rancher=integration_rancher,
            integration_route53=integration_route53,
            itf=itf,
            key_name=key_name,
            lifetime_period=lifetime_period,
            max_size=max_size,
            metadata_options=metadata_options,
            minimum_instance_lifetime=minimum_instance_lifetime,
            min_size=min_size,
            multai_target_sets=multai_target_sets,
            multiple_metrics=multiple_metrics,
            network_interface=network_interface,
            ondemand_count=ondemand_count,
            persist_block_devices=persist_block_devices,
            persist_private_ip=persist_private_ip,
            persist_root_device=persist_root_device,
            placement_tenancy=placement_tenancy,
            preferred_availability_zones=preferred_availability_zones,
            private_ips=private_ips,
            region=region,
            resource_tag_specification=resource_tag_specification,
            revert_to_spot=revert_to_spot,
            scaling_down_policy=scaling_down_policy,
            scaling_strategy=scaling_strategy,
            scaling_target_policy=scaling_target_policy,
            scaling_up_policy=scaling_up_policy,
            scheduled_task=scheduled_task,
            shutdown_script=shutdown_script,
            signal=signal,
            spot_percentage=spot_percentage,
            stateful_deallocation=stateful_deallocation,
            stateful_instance_action=stateful_instance_action,
            subnet_ids=subnet_ids,
            tags=tags,
            target_group_arns=target_group_arns,
            update_policy=update_policy,
            user_data=user_data,
            utilize_commitments=utilize_commitments,
            utilize_reserved_instances=utilize_reserved_instances,
            wait_for_capacity=wait_for_capacity,
            wait_for_capacity_timeout=wait_for_capacity_timeout,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putCpuOptions")
    def put_cpu_options(self, *, threads_per_core: jsii.Number) -> None:
        '''
        :param threads_per_core: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threads_per_core ElastigroupAws#threads_per_core}.
        '''
        value = ElastigroupAwsCpuOptions(threads_per_core=threads_per_core)

        return typing.cast(None, jsii.invoke(self, "putCpuOptions", [value]))

    @jsii.member(jsii_name="putIntegrationBeanstalk")
    def put_integration_beanstalk(
        self,
        *,
        deployment_preferences: typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferences"] = None,
        environment_id: typing.Optional[builtins.str] = None,
        managed_actions: typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActions"] = None,
    ) -> None:
        '''
        :param deployment_preferences: deployment_preferences block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_preferences ElastigroupAws#deployment_preferences}
        :param environment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#environment_id ElastigroupAws#environment_id}.
        :param managed_actions: managed_actions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#managed_actions ElastigroupAws#managed_actions}
        '''
        value = ElastigroupAwsIntegrationBeanstalk(
            deployment_preferences=deployment_preferences,
            environment_id=environment_id,
            managed_actions=managed_actions,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationBeanstalk", [value]))

    @jsii.member(jsii_name="putIntegrationCodedeploy")
    def put_integration_codedeploy(
        self,
        *,
        cleanup_on_failure: typing.Union[builtins.bool, cdktf.IResolvable],
        deployment_groups: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationCodedeployDeploymentGroups"]],
        terminate_instance_on_failure: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        '''
        :param cleanup_on_failure: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cleanup_on_failure ElastigroupAws#cleanup_on_failure}.
        :param deployment_groups: deployment_groups block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_groups ElastigroupAws#deployment_groups}
        :param terminate_instance_on_failure: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_instance_on_failure ElastigroupAws#terminate_instance_on_failure}.
        '''
        value = ElastigroupAwsIntegrationCodedeploy(
            cleanup_on_failure=cleanup_on_failure,
            deployment_groups=deployment_groups,
            terminate_instance_on_failure=terminate_instance_on_failure,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationCodedeploy", [value]))

    @jsii.member(jsii_name="putIntegrationDockerSwarm")
    def put_integration_docker_swarm(
        self,
        *,
        master_host: builtins.str,
        master_port: jsii.Number,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom"] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param master_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        '''
        value = ElastigroupAwsIntegrationDockerSwarm(
            master_host=master_host,
            master_port=master_port,
            autoscale_cooldown=autoscale_cooldown,
            autoscale_down=autoscale_down,
            autoscale_headroom=autoscale_headroom,
            autoscale_is_enabled=autoscale_is_enabled,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationDockerSwarm", [value]))

    @jsii.member(jsii_name="putIntegrationEcs")
    def put_integration_ecs(
        self,
        *,
        cluster_name: builtins.str,
        autoscale_attributes: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationEcsAutoscaleAttributes"]]] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleHeadroom"] = None,
        autoscale_is_auto_config: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_scale_down_non_service_tasks: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch: typing.Optional["ElastigroupAwsIntegrationEcsBatch"] = None,
    ) -> None:
        '''
        :param cluster_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_name ElastigroupAws#cluster_name}.
        :param autoscale_attributes: autoscale_attributes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_attributes ElastigroupAws#autoscale_attributes}
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_auto_config: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        :param autoscale_scale_down_non_service_tasks: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_scale_down_non_service_tasks ElastigroupAws#autoscale_scale_down_non_service_tasks}.
        :param batch: batch block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch ElastigroupAws#batch}
        '''
        value = ElastigroupAwsIntegrationEcs(
            cluster_name=cluster_name,
            autoscale_attributes=autoscale_attributes,
            autoscale_cooldown=autoscale_cooldown,
            autoscale_down=autoscale_down,
            autoscale_headroom=autoscale_headroom,
            autoscale_is_auto_config=autoscale_is_auto_config,
            autoscale_is_enabled=autoscale_is_enabled,
            autoscale_scale_down_non_service_tasks=autoscale_scale_down_non_service_tasks,
            batch=batch,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationEcs", [value]))

    @jsii.member(jsii_name="putIntegrationGitlab")
    def put_integration_gitlab(
        self,
        *,
        runner: typing.Optional["ElastigroupAwsIntegrationGitlabRunner"] = None,
    ) -> None:
        '''
        :param runner: runner block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#runner ElastigroupAws#runner}
        '''
        value = ElastigroupAwsIntegrationGitlab(runner=runner)

        return typing.cast(None, jsii.invoke(self, "putIntegrationGitlab", [value]))

    @jsii.member(jsii_name="putIntegrationKubernetes")
    def put_integration_kubernetes(
        self,
        *,
        api_server: typing.Optional[builtins.str] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom"] = None,
        autoscale_is_auto_config: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_labels: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationKubernetesAutoscaleLabels"]]] = None,
        cluster_identifier: typing.Optional[builtins.str] = None,
        integration_mode: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param api_server: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_auto_config: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        :param autoscale_labels: autoscale_labels block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_labels ElastigroupAws#autoscale_labels}
        :param cluster_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_identifier ElastigroupAws#cluster_identifier}.
        :param integration_mode: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mode ElastigroupAws#integration_mode}.
        :param token: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#token ElastigroupAws#token}.
        '''
        value = ElastigroupAwsIntegrationKubernetes(
            api_server=api_server,
            autoscale_cooldown=autoscale_cooldown,
            autoscale_down=autoscale_down,
            autoscale_headroom=autoscale_headroom,
            autoscale_is_auto_config=autoscale_is_auto_config,
            autoscale_is_enabled=autoscale_is_enabled,
            autoscale_labels=autoscale_labels,
            cluster_identifier=cluster_identifier,
            integration_mode=integration_mode,
            token=token,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationKubernetes", [value]))

    @jsii.member(jsii_name="putIntegrationMesosphere")
    def put_integration_mesosphere(self, *, api_server: builtins.str) -> None:
        '''
        :param api_server: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.
        '''
        value = ElastigroupAwsIntegrationMesosphere(api_server=api_server)

        return typing.cast(None, jsii.invoke(self, "putIntegrationMesosphere", [value]))

    @jsii.member(jsii_name="putIntegrationMultaiRuntime")
    def put_integration_multai_runtime(self, *, deployment_id: builtins.str) -> None:
        '''
        :param deployment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_id ElastigroupAws#deployment_id}.
        '''
        value = ElastigroupAwsIntegrationMultaiRuntime(deployment_id=deployment_id)

        return typing.cast(None, jsii.invoke(self, "putIntegrationMultaiRuntime", [value]))

    @jsii.member(jsii_name="putIntegrationNomad")
    def put_integration_nomad(
        self,
        *,
        master_host: builtins.str,
        master_port: jsii.Number,
        acl_token: typing.Optional[builtins.str] = None,
        autoscale_constraints: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationNomadAutoscaleConstraints"]]] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleHeadroom"] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param master_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.
        :param acl_token: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#acl_token ElastigroupAws#acl_token}.
        :param autoscale_constraints: autoscale_constraints block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_constraints ElastigroupAws#autoscale_constraints}
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        '''
        value = ElastigroupAwsIntegrationNomad(
            master_host=master_host,
            master_port=master_port,
            acl_token=acl_token,
            autoscale_constraints=autoscale_constraints,
            autoscale_cooldown=autoscale_cooldown,
            autoscale_down=autoscale_down,
            autoscale_headroom=autoscale_headroom,
            autoscale_is_enabled=autoscale_is_enabled,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationNomad", [value]))

    @jsii.member(jsii_name="putIntegrationRancher")
    def put_integration_rancher(
        self,
        *,
        access_key: builtins.str,
        master_host: builtins.str,
        secret_key: builtins.str,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#access_key ElastigroupAws#access_key}.
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param secret_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secret_key ElastigroupAws#secret_key}.
        :param version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#version ElastigroupAws#version}.
        '''
        value = ElastigroupAwsIntegrationRancher(
            access_key=access_key,
            master_host=master_host,
            secret_key=secret_key,
            version=version,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationRancher", [value]))

    @jsii.member(jsii_name="putIntegrationRoute53")
    def put_integration_route53(
        self,
        *,
        domains: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationRoute53Domains"]],
    ) -> None:
        '''
        :param domains: domains block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#domains ElastigroupAws#domains}
        '''
        value = ElastigroupAwsIntegrationRoute53(domains=domains)

        return typing.cast(None, jsii.invoke(self, "putIntegrationRoute53", [value]))

    @jsii.member(jsii_name="putMetadataOptions")
    def put_metadata_options(
        self,
        *,
        http_tokens: builtins.str,
        http_put_response_hop_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param http_tokens: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_tokens ElastigroupAws#http_tokens}.
        :param http_put_response_hop_limit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_put_response_hop_limit ElastigroupAws#http_put_response_hop_limit}.
        '''
        value = ElastigroupAwsMetadataOptions(
            http_tokens=http_tokens,
            http_put_response_hop_limit=http_put_response_hop_limit,
        )

        return typing.cast(None, jsii.invoke(self, "putMetadataOptions", [value]))

    @jsii.member(jsii_name="putMultipleMetrics")
    def put_multiple_metrics(
        self,
        *,
        expressions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultipleMetricsExpressions"]]] = None,
        metrics: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultipleMetricsMetrics"]]] = None,
    ) -> None:
        '''
        :param expressions: expressions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expressions ElastigroupAws#expressions}
        :param metrics: metrics block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metrics ElastigroupAws#metrics}
        '''
        value = ElastigroupAwsMultipleMetrics(expressions=expressions, metrics=metrics)

        return typing.cast(None, jsii.invoke(self, "putMultipleMetrics", [value]))

    @jsii.member(jsii_name="putRevertToSpot")
    def put_revert_to_spot(
        self,
        *,
        perform_at: builtins.str,
        time_windows: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.
        :param time_windows: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_windows ElastigroupAws#time_windows}.
        '''
        value = ElastigroupAwsRevertToSpot(
            perform_at=perform_at, time_windows=time_windows
        )

        return typing.cast(None, jsii.invoke(self, "putRevertToSpot", [value]))

    @jsii.member(jsii_name="putStatefulDeallocation")
    def put_stateful_deallocation(
        self,
        *,
        should_delete_images: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_network_interfaces: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_snapshots: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_volumes: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param should_delete_images: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_images ElastigroupAws#should_delete_images}.
        :param should_delete_network_interfaces: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_network_interfaces ElastigroupAws#should_delete_network_interfaces}.
        :param should_delete_snapshots: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_snapshots ElastigroupAws#should_delete_snapshots}.
        :param should_delete_volumes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_volumes ElastigroupAws#should_delete_volumes}.
        '''
        value = ElastigroupAwsStatefulDeallocation(
            should_delete_images=should_delete_images,
            should_delete_network_interfaces=should_delete_network_interfaces,
            should_delete_snapshots=should_delete_snapshots,
            should_delete_volumes=should_delete_volumes,
        )

        return typing.cast(None, jsii.invoke(self, "putStatefulDeallocation", [value]))

    @jsii.member(jsii_name="putUpdatePolicy")
    def put_update_policy(
        self,
        *,
        should_resume_stateful: typing.Union[builtins.bool, cdktf.IResolvable],
        should_roll: typing.Union[builtins.bool, cdktf.IResolvable],
        auto_apply_tags: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        roll_config: typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"] = None,
    ) -> None:
        '''
        :param should_resume_stateful: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_resume_stateful ElastigroupAws#should_resume_stateful}.
        :param should_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_roll ElastigroupAws#should_roll}.
        :param auto_apply_tags: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#auto_apply_tags ElastigroupAws#auto_apply_tags}.
        :param roll_config: roll_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#roll_config ElastigroupAws#roll_config}
        '''
        value = ElastigroupAwsUpdatePolicy(
            should_resume_stateful=should_resume_stateful,
            should_roll=should_roll,
            auto_apply_tags=auto_apply_tags,
            roll_config=roll_config,
        )

        return typing.cast(None, jsii.invoke(self, "putUpdatePolicy", [value]))

    @jsii.member(jsii_name="resetAvailabilityZones")
    def reset_availability_zones(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAvailabilityZones", []))

    @jsii.member(jsii_name="resetBlockDevicesMode")
    def reset_block_devices_mode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBlockDevicesMode", []))

    @jsii.member(jsii_name="resetCapacityUnit")
    def reset_capacity_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCapacityUnit", []))

    @jsii.member(jsii_name="resetCpuCredits")
    def reset_cpu_credits(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuCredits", []))

    @jsii.member(jsii_name="resetCpuOptions")
    def reset_cpu_options(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuOptions", []))

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDescription", []))

    @jsii.member(jsii_name="resetDesiredCapacity")
    def reset_desired_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDesiredCapacity", []))

    @jsii.member(jsii_name="resetDrainingTimeout")
    def reset_draining_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDrainingTimeout", []))

    @jsii.member(jsii_name="resetEbsBlockDevice")
    def reset_ebs_block_device(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEbsBlockDevice", []))

    @jsii.member(jsii_name="resetEbsOptimized")
    def reset_ebs_optimized(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEbsOptimized", []))

    @jsii.member(jsii_name="resetElasticIps")
    def reset_elastic_ips(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetElasticIps", []))

    @jsii.member(jsii_name="resetElasticLoadBalancers")
    def reset_elastic_load_balancers(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetElasticLoadBalancers", []))

    @jsii.member(jsii_name="resetEnableMonitoring")
    def reset_enable_monitoring(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnableMonitoring", []))

    @jsii.member(jsii_name="resetEphemeralBlockDevice")
    def reset_ephemeral_block_device(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEphemeralBlockDevice", []))

    @jsii.member(jsii_name="resetHealthCheckGracePeriod")
    def reset_health_check_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckGracePeriod", []))

    @jsii.member(jsii_name="resetHealthCheckType")
    def reset_health_check_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckType", []))

    @jsii.member(jsii_name="resetHealthCheckUnhealthyDurationBeforeReplacement")
    def reset_health_check_unhealthy_duration_before_replacement(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckUnhealthyDurationBeforeReplacement", []))

    @jsii.member(jsii_name="resetIamInstanceProfile")
    def reset_iam_instance_profile(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIamInstanceProfile", []))

    @jsii.member(jsii_name="resetImageId")
    def reset_image_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetImageId", []))

    @jsii.member(jsii_name="resetInstanceTypesPreferredSpot")
    def reset_instance_types_preferred_spot(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInstanceTypesPreferredSpot", []))

    @jsii.member(jsii_name="resetInstanceTypesWeights")
    def reset_instance_types_weights(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInstanceTypesWeights", []))

    @jsii.member(jsii_name="resetIntegrationBeanstalk")
    def reset_integration_beanstalk(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationBeanstalk", []))

    @jsii.member(jsii_name="resetIntegrationCodedeploy")
    def reset_integration_codedeploy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationCodedeploy", []))

    @jsii.member(jsii_name="resetIntegrationDockerSwarm")
    def reset_integration_docker_swarm(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationDockerSwarm", []))

    @jsii.member(jsii_name="resetIntegrationEcs")
    def reset_integration_ecs(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationEcs", []))

    @jsii.member(jsii_name="resetIntegrationGitlab")
    def reset_integration_gitlab(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationGitlab", []))

    @jsii.member(jsii_name="resetIntegrationKubernetes")
    def reset_integration_kubernetes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationKubernetes", []))

    @jsii.member(jsii_name="resetIntegrationMesosphere")
    def reset_integration_mesosphere(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationMesosphere", []))

    @jsii.member(jsii_name="resetIntegrationMultaiRuntime")
    def reset_integration_multai_runtime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationMultaiRuntime", []))

    @jsii.member(jsii_name="resetIntegrationNomad")
    def reset_integration_nomad(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationNomad", []))

    @jsii.member(jsii_name="resetIntegrationRancher")
    def reset_integration_rancher(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationRancher", []))

    @jsii.member(jsii_name="resetIntegrationRoute53")
    def reset_integration_route53(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationRoute53", []))

    @jsii.member(jsii_name="resetItf")
    def reset_itf(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetItf", []))

    @jsii.member(jsii_name="resetKeyName")
    def reset_key_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetKeyName", []))

    @jsii.member(jsii_name="resetLifetimePeriod")
    def reset_lifetime_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLifetimePeriod", []))

    @jsii.member(jsii_name="resetMaxSize")
    def reset_max_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxSize", []))

    @jsii.member(jsii_name="resetMetadataOptions")
    def reset_metadata_options(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetadataOptions", []))

    @jsii.member(jsii_name="resetMinimumInstanceLifetime")
    def reset_minimum_instance_lifetime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinimumInstanceLifetime", []))

    @jsii.member(jsii_name="resetMinSize")
    def reset_min_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinSize", []))

    @jsii.member(jsii_name="resetMultaiTargetSets")
    def reset_multai_target_sets(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultaiTargetSets", []))

    @jsii.member(jsii_name="resetMultipleMetrics")
    def reset_multiple_metrics(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultipleMetrics", []))

    @jsii.member(jsii_name="resetNetworkInterface")
    def reset_network_interface(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNetworkInterface", []))

    @jsii.member(jsii_name="resetOndemandCount")
    def reset_ondemand_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOndemandCount", []))

    @jsii.member(jsii_name="resetPersistBlockDevices")
    def reset_persist_block_devices(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPersistBlockDevices", []))

    @jsii.member(jsii_name="resetPersistPrivateIp")
    def reset_persist_private_ip(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPersistPrivateIp", []))

    @jsii.member(jsii_name="resetPersistRootDevice")
    def reset_persist_root_device(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPersistRootDevice", []))

    @jsii.member(jsii_name="resetPlacementTenancy")
    def reset_placement_tenancy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPlacementTenancy", []))

    @jsii.member(jsii_name="resetPreferredAvailabilityZones")
    def reset_preferred_availability_zones(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPreferredAvailabilityZones", []))

    @jsii.member(jsii_name="resetPrivateIps")
    def reset_private_ips(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrivateIps", []))

    @jsii.member(jsii_name="resetRegion")
    def reset_region(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRegion", []))

    @jsii.member(jsii_name="resetResourceTagSpecification")
    def reset_resource_tag_specification(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResourceTagSpecification", []))

    @jsii.member(jsii_name="resetRevertToSpot")
    def reset_revert_to_spot(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRevertToSpot", []))

    @jsii.member(jsii_name="resetScalingDownPolicy")
    def reset_scaling_down_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingDownPolicy", []))

    @jsii.member(jsii_name="resetScalingStrategy")
    def reset_scaling_strategy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingStrategy", []))

    @jsii.member(jsii_name="resetScalingTargetPolicy")
    def reset_scaling_target_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingTargetPolicy", []))

    @jsii.member(jsii_name="resetScalingUpPolicy")
    def reset_scaling_up_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingUpPolicy", []))

    @jsii.member(jsii_name="resetScheduledTask")
    def reset_scheduled_task(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScheduledTask", []))

    @jsii.member(jsii_name="resetShutdownScript")
    def reset_shutdown_script(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShutdownScript", []))

    @jsii.member(jsii_name="resetSignal")
    def reset_signal(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSignal", []))

    @jsii.member(jsii_name="resetSpotPercentage")
    def reset_spot_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSpotPercentage", []))

    @jsii.member(jsii_name="resetStatefulDeallocation")
    def reset_stateful_deallocation(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStatefulDeallocation", []))

    @jsii.member(jsii_name="resetStatefulInstanceAction")
    def reset_stateful_instance_action(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStatefulInstanceAction", []))

    @jsii.member(jsii_name="resetSubnetIds")
    def reset_subnet_ids(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSubnetIds", []))

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTags", []))

    @jsii.member(jsii_name="resetTargetGroupArns")
    def reset_target_group_arns(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTargetGroupArns", []))

    @jsii.member(jsii_name="resetUpdatePolicy")
    def reset_update_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdatePolicy", []))

    @jsii.member(jsii_name="resetUserData")
    def reset_user_data(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUserData", []))

    @jsii.member(jsii_name="resetUtilizeCommitments")
    def reset_utilize_commitments(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUtilizeCommitments", []))

    @jsii.member(jsii_name="resetUtilizeReservedInstances")
    def reset_utilize_reserved_instances(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUtilizeReservedInstances", []))

    @jsii.member(jsii_name="resetWaitForCapacity")
    def reset_wait_for_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWaitForCapacity", []))

    @jsii.member(jsii_name="resetWaitForCapacityTimeout")
    def reset_wait_for_capacity_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWaitForCapacityTimeout", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuOptions")
    def cpu_options(self) -> "ElastigroupAwsCpuOptionsOutputReference":
        return typing.cast("ElastigroupAwsCpuOptionsOutputReference", jsii.get(self, "cpuOptions"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationBeanstalk")
    def integration_beanstalk(
        self,
    ) -> "ElastigroupAwsIntegrationBeanstalkOutputReference":
        return typing.cast("ElastigroupAwsIntegrationBeanstalkOutputReference", jsii.get(self, "integrationBeanstalk"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationCodedeploy")
    def integration_codedeploy(
        self,
    ) -> "ElastigroupAwsIntegrationCodedeployOutputReference":
        return typing.cast("ElastigroupAwsIntegrationCodedeployOutputReference", jsii.get(self, "integrationCodedeploy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationDockerSwarm")
    def integration_docker_swarm(
        self,
    ) -> "ElastigroupAwsIntegrationDockerSwarmOutputReference":
        return typing.cast("ElastigroupAwsIntegrationDockerSwarmOutputReference", jsii.get(self, "integrationDockerSwarm"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationEcs")
    def integration_ecs(self) -> "ElastigroupAwsIntegrationEcsOutputReference":
        return typing.cast("ElastigroupAwsIntegrationEcsOutputReference", jsii.get(self, "integrationEcs"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationGitlab")
    def integration_gitlab(self) -> "ElastigroupAwsIntegrationGitlabOutputReference":
        return typing.cast("ElastigroupAwsIntegrationGitlabOutputReference", jsii.get(self, "integrationGitlab"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationKubernetes")
    def integration_kubernetes(
        self,
    ) -> "ElastigroupAwsIntegrationKubernetesOutputReference":
        return typing.cast("ElastigroupAwsIntegrationKubernetesOutputReference", jsii.get(self, "integrationKubernetes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMesosphere")
    def integration_mesosphere(
        self,
    ) -> "ElastigroupAwsIntegrationMesosphereOutputReference":
        return typing.cast("ElastigroupAwsIntegrationMesosphereOutputReference", jsii.get(self, "integrationMesosphere"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMultaiRuntime")
    def integration_multai_runtime(
        self,
    ) -> "ElastigroupAwsIntegrationMultaiRuntimeOutputReference":
        return typing.cast("ElastigroupAwsIntegrationMultaiRuntimeOutputReference", jsii.get(self, "integrationMultaiRuntime"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationNomad")
    def integration_nomad(self) -> "ElastigroupAwsIntegrationNomadOutputReference":
        return typing.cast("ElastigroupAwsIntegrationNomadOutputReference", jsii.get(self, "integrationNomad"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationRancher")
    def integration_rancher(self) -> "ElastigroupAwsIntegrationRancherOutputReference":
        return typing.cast("ElastigroupAwsIntegrationRancherOutputReference", jsii.get(self, "integrationRancher"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationRoute53")
    def integration_route53(self) -> "ElastigroupAwsIntegrationRoute53OutputReference":
        return typing.cast("ElastigroupAwsIntegrationRoute53OutputReference", jsii.get(self, "integrationRoute53"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metadataOptions")
    def metadata_options(self) -> "ElastigroupAwsMetadataOptionsOutputReference":
        return typing.cast("ElastigroupAwsMetadataOptionsOutputReference", jsii.get(self, "metadataOptions"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multipleMetrics")
    def multiple_metrics(self) -> "ElastigroupAwsMultipleMetricsOutputReference":
        return typing.cast("ElastigroupAwsMultipleMetricsOutputReference", jsii.get(self, "multipleMetrics"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="revertToSpot")
    def revert_to_spot(self) -> "ElastigroupAwsRevertToSpotOutputReference":
        return typing.cast("ElastigroupAwsRevertToSpotOutputReference", jsii.get(self, "revertToSpot"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statefulDeallocation")
    def stateful_deallocation(
        self,
    ) -> "ElastigroupAwsStatefulDeallocationOutputReference":
        return typing.cast("ElastigroupAwsStatefulDeallocationOutputReference", jsii.get(self, "statefulDeallocation"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updatePolicy")
    def update_policy(self) -> "ElastigroupAwsUpdatePolicyOutputReference":
        return typing.cast("ElastigroupAwsUpdatePolicyOutputReference", jsii.get(self, "updatePolicy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="availabilityZonesInput")
    def availability_zones_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "availabilityZonesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="blockDevicesModeInput")
    def block_devices_mode_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "blockDevicesModeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="capacityUnitInput")
    def capacity_unit_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "capacityUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuCreditsInput")
    def cpu_credits_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "cpuCreditsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuOptionsInput")
    def cpu_options_input(self) -> typing.Optional["ElastigroupAwsCpuOptions"]:
        return typing.cast(typing.Optional["ElastigroupAwsCpuOptions"], jsii.get(self, "cpuOptionsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "descriptionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacityInput")
    def desired_capacity_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "desiredCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeoutInput")
    def draining_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "drainingTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ebsBlockDeviceInput")
    def ebs_block_device_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]]], jsii.get(self, "ebsBlockDeviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ebsOptimizedInput")
    def ebs_optimized_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "ebsOptimizedInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="elasticIpsInput")
    def elastic_ips_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "elasticIpsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="elasticLoadBalancersInput")
    def elastic_load_balancers_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "elasticLoadBalancersInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enableMonitoringInput")
    def enable_monitoring_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "enableMonitoringInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ephemeralBlockDeviceInput")
    def ephemeral_block_device_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]]], jsii.get(self, "ephemeralBlockDeviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fallbackToOndemandInput")
    def fallback_to_ondemand_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "fallbackToOndemandInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckGracePeriodInput")
    def health_check_grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckGracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckTypeInput")
    def health_check_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckUnhealthyDurationBeforeReplacementInput")
    def health_check_unhealthy_duration_before_replacement_input(
        self,
    ) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "healthCheckUnhealthyDurationBeforeReplacementInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="iamInstanceProfileInput")
    def iam_instance_profile_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "iamInstanceProfileInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="imageIdInput")
    def image_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesOndemandInput")
    def instance_types_ondemand_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "instanceTypesOndemandInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesPreferredSpotInput")
    def instance_types_preferred_spot_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "instanceTypesPreferredSpotInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesSpotInput")
    def instance_types_spot_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "instanceTypesSpotInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesWeightsInput")
    def instance_types_weights_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]]], jsii.get(self, "instanceTypesWeightsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationBeanstalkInput")
    def integration_beanstalk_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalk"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalk"], jsii.get(self, "integrationBeanstalkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationCodedeployInput")
    def integration_codedeploy_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationCodedeploy"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationCodedeploy"], jsii.get(self, "integrationCodedeployInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationDockerSwarmInput")
    def integration_docker_swarm_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationDockerSwarm"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationDockerSwarm"], jsii.get(self, "integrationDockerSwarmInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationEcsInput")
    def integration_ecs_input(self) -> typing.Optional["ElastigroupAwsIntegrationEcs"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationEcs"], jsii.get(self, "integrationEcsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationGitlabInput")
    def integration_gitlab_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationGitlab"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationGitlab"], jsii.get(self, "integrationGitlabInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationKubernetesInput")
    def integration_kubernetes_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationKubernetes"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationKubernetes"], jsii.get(self, "integrationKubernetesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMesosphereInput")
    def integration_mesosphere_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationMesosphere"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationMesosphere"], jsii.get(self, "integrationMesosphereInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMultaiRuntimeInput")
    def integration_multai_runtime_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"], jsii.get(self, "integrationMultaiRuntimeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationNomadInput")
    def integration_nomad_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationNomad"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationNomad"], jsii.get(self, "integrationNomadInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationRancherInput")
    def integration_rancher_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationRancher"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationRancher"], jsii.get(self, "integrationRancherInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationRoute53Input")
    def integration_route53_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationRoute53"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationRoute53"], jsii.get(self, "integrationRoute53Input"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="itfInput")
    def itf_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]]], jsii.get(self, "itfInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="keyNameInput")
    def key_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "keyNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lifetimePeriodInput")
    def lifetime_period_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "lifetimePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSizeInput")
    def max_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metadataOptionsInput")
    def metadata_options_input(
        self,
    ) -> typing.Optional["ElastigroupAwsMetadataOptions"]:
        return typing.cast(typing.Optional["ElastigroupAwsMetadataOptions"], jsii.get(self, "metadataOptionsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimumInstanceLifetimeInput")
    def minimum_instance_lifetime_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "minimumInstanceLifetimeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSizeInput")
    def min_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "minSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multaiTargetSetsInput")
    def multai_target_sets_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]]], jsii.get(self, "multaiTargetSetsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multipleMetricsInput")
    def multiple_metrics_input(
        self,
    ) -> typing.Optional["ElastigroupAwsMultipleMetrics"]:
        return typing.cast(typing.Optional["ElastigroupAwsMultipleMetrics"], jsii.get(self, "multipleMetricsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInterfaceInput")
    def network_interface_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]]], jsii.get(self, "networkInterfaceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ondemandCountInput")
    def ondemand_count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "ondemandCountInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orientationInput")
    def orientation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orientationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistBlockDevicesInput")
    def persist_block_devices_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "persistBlockDevicesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistPrivateIpInput")
    def persist_private_ip_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "persistPrivateIpInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistRootDeviceInput")
    def persist_root_device_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "persistRootDeviceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="placementTenancyInput")
    def placement_tenancy_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "placementTenancyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="preferredAvailabilityZonesInput")
    def preferred_availability_zones_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "preferredAvailabilityZonesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="privateIpsInput")
    def private_ips_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "privateIpsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="productInput")
    def product_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "productInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="regionInput")
    def region_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceTagSpecificationInput")
    def resource_tag_specification_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]]], jsii.get(self, "resourceTagSpecificationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="revertToSpotInput")
    def revert_to_spot_input(self) -> typing.Optional["ElastigroupAwsRevertToSpot"]:
        return typing.cast(typing.Optional["ElastigroupAwsRevertToSpot"], jsii.get(self, "revertToSpotInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingDownPolicyInput")
    def scaling_down_policy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]]], jsii.get(self, "scalingDownPolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingStrategyInput")
    def scaling_strategy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]]], jsii.get(self, "scalingStrategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingTargetPolicyInput")
    def scaling_target_policy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]]], jsii.get(self, "scalingTargetPolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingUpPolicyInput")
    def scaling_up_policy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]]], jsii.get(self, "scalingUpPolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTaskInput")
    def scheduled_task_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]]], jsii.get(self, "scheduledTaskInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="securityGroupsInput")
    def security_groups_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "securityGroupsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shutdownScriptInput")
    def shutdown_script_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "shutdownScriptInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="signalInput")
    def signal_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]]], jsii.get(self, "signalInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotPercentageInput")
    def spot_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "spotPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statefulDeallocationInput")
    def stateful_deallocation_input(
        self,
    ) -> typing.Optional["ElastigroupAwsStatefulDeallocation"]:
        return typing.cast(typing.Optional["ElastigroupAwsStatefulDeallocation"], jsii.get(self, "statefulDeallocationInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statefulInstanceActionInput")
    def stateful_instance_action_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]]], jsii.get(self, "statefulInstanceActionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subnetIdsInput")
    def subnet_ids_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "subnetIdsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tagsInput")
    def tags_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]]], jsii.get(self, "tagsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="targetGroupArnsInput")
    def target_group_arns_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "targetGroupArnsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updatePolicyInput")
    def update_policy_input(self) -> typing.Optional["ElastigroupAwsUpdatePolicy"]:
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicy"], jsii.get(self, "updatePolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userDataInput")
    def user_data_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "userDataInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="utilizeCommitmentsInput")
    def utilize_commitments_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "utilizeCommitmentsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="utilizeReservedInstancesInput")
    def utilize_reserved_instances_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "utilizeReservedInstancesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForCapacityInput")
    def wait_for_capacity_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "waitForCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForCapacityTimeoutInput")
    def wait_for_capacity_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "waitForCapacityTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="availabilityZones")
    def availability_zones(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "availabilityZones"))

    @availability_zones.setter
    def availability_zones(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "availabilityZones", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="blockDevicesMode")
    def block_devices_mode(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "blockDevicesMode"))

    @block_devices_mode.setter
    def block_devices_mode(self, value: builtins.str) -> None:
        jsii.set(self, "blockDevicesMode", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="capacityUnit")
    def capacity_unit(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "capacityUnit"))

    @capacity_unit.setter
    def capacity_unit(self, value: builtins.str) -> None:
        jsii.set(self, "capacityUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuCredits")
    def cpu_credits(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "cpuCredits"))

    @cpu_credits.setter
    def cpu_credits(self, value: builtins.str) -> None:
        jsii.set(self, "cpuCredits", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "description"))

    @description.setter
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "desiredCapacity"))

    @desired_capacity.setter
    def desired_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeout")
    def draining_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "drainingTimeout"))

    @draining_timeout.setter
    def draining_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "drainingTimeout", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ebsBlockDevice")
    def ebs_block_device(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]], jsii.get(self, "ebsBlockDevice"))

    @ebs_block_device.setter
    def ebs_block_device(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]],
    ) -> None:
        jsii.set(self, "ebsBlockDevice", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ebsOptimized")
    def ebs_optimized(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "ebsOptimized"))

    @ebs_optimized.setter
    def ebs_optimized(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "ebsOptimized", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="elasticIps")
    def elastic_ips(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "elasticIps"))

    @elastic_ips.setter
    def elastic_ips(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "elasticIps", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="elasticLoadBalancers")
    def elastic_load_balancers(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "elasticLoadBalancers"))

    @elastic_load_balancers.setter
    def elastic_load_balancers(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "elasticLoadBalancers", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="enableMonitoring")
    def enable_monitoring(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "enableMonitoring"))

    @enable_monitoring.setter
    def enable_monitoring(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "enableMonitoring", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ephemeralBlockDevice")
    def ephemeral_block_device(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]], jsii.get(self, "ephemeralBlockDevice"))

    @ephemeral_block_device.setter
    def ephemeral_block_device(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]],
    ) -> None:
        jsii.set(self, "ephemeralBlockDevice", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "fallbackToOndemand"))

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "fallbackToOndemand", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckGracePeriod"))

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "healthCheckGracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckType"))

    @health_check_type.setter
    def health_check_type(self, value: builtins.str) -> None:
        jsii.set(self, "healthCheckType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "healthCheckUnhealthyDurationBeforeReplacement"))

    @health_check_unhealthy_duration_before_replacement.setter
    def health_check_unhealthy_duration_before_replacement(
        self,
        value: jsii.Number,
    ) -> None:
        jsii.set(self, "healthCheckUnhealthyDurationBeforeReplacement", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="iamInstanceProfile")
    def iam_instance_profile(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "iamInstanceProfile"))

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: builtins.str) -> None:
        jsii.set(self, "iamInstanceProfile", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="imageId")
    def image_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "imageId"))

    @image_id.setter
    def image_id(self, value: builtins.str) -> None:
        jsii.set(self, "imageId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "instanceTypesOndemand"))

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: builtins.str) -> None:
        jsii.set(self, "instanceTypesOndemand", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesPreferredSpot")
    def instance_types_preferred_spot(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "instanceTypesPreferredSpot"))

    @instance_types_preferred_spot.setter
    def instance_types_preferred_spot(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "instanceTypesPreferredSpot", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesSpot")
    def instance_types_spot(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "instanceTypesSpot"))

    @instance_types_spot.setter
    def instance_types_spot(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "instanceTypesSpot", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesWeights")
    def instance_types_weights(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]], jsii.get(self, "instanceTypesWeights"))

    @instance_types_weights.setter
    def instance_types_weights(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]],
    ) -> None:
        jsii.set(self, "instanceTypesWeights", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="itf")
    def itf(self) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]], jsii.get(self, "itf"))

    @itf.setter
    def itf(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]],
    ) -> None:
        jsii.set(self, "itf", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="keyName")
    def key_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "keyName"))

    @key_name.setter
    def key_name(self, value: builtins.str) -> None:
        jsii.set(self, "keyName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lifetimePeriod")
    def lifetime_period(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "lifetimePeriod"))

    @lifetime_period.setter
    def lifetime_period(self, value: builtins.str) -> None:
        jsii.set(self, "lifetimePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxSize"))

    @max_size.setter
    def max_size(self, value: jsii.Number) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimumInstanceLifetime")
    def minimum_instance_lifetime(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minimumInstanceLifetime"))

    @minimum_instance_lifetime.setter
    def minimum_instance_lifetime(self, value: jsii.Number) -> None:
        jsii.set(self, "minimumInstanceLifetime", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minSize"))

    @min_size.setter
    def min_size(self, value: jsii.Number) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="multaiTargetSets")
    def multai_target_sets(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]], jsii.get(self, "multaiTargetSets"))

    @multai_target_sets.setter
    def multai_target_sets(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]],
    ) -> None:
        jsii.set(self, "multaiTargetSets", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInterface")
    def network_interface(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]], jsii.get(self, "networkInterface"))

    @network_interface.setter
    def network_interface(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]],
    ) -> None:
        jsii.set(self, "networkInterface", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="ondemandCount")
    def ondemand_count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "ondemandCount"))

    @ondemand_count.setter
    def ondemand_count(self, value: jsii.Number) -> None:
        jsii.set(self, "ondemandCount", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="orientation")
    def orientation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "orientation"))

    @orientation.setter
    def orientation(self, value: builtins.str) -> None:
        jsii.set(self, "orientation", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistBlockDevices")
    def persist_block_devices(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "persistBlockDevices"))

    @persist_block_devices.setter
    def persist_block_devices(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "persistBlockDevices", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistPrivateIp")
    def persist_private_ip(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "persistPrivateIp"))

    @persist_private_ip.setter
    def persist_private_ip(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "persistPrivateIp", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="persistRootDevice")
    def persist_root_device(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "persistRootDevice"))

    @persist_root_device.setter
    def persist_root_device(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "persistRootDevice", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="placementTenancy")
    def placement_tenancy(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "placementTenancy"))

    @placement_tenancy.setter
    def placement_tenancy(self, value: builtins.str) -> None:
        jsii.set(self, "placementTenancy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "preferredAvailabilityZones"))

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "preferredAvailabilityZones", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="privateIps")
    def private_ips(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "privateIps"))

    @private_ips.setter
    def private_ips(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "privateIps", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="product")
    def product(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "product"))

    @product.setter
    def product(self, value: builtins.str) -> None:
        jsii.set(self, "product", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="region")
    def region(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "region"))

    @region.setter
    def region(self, value: builtins.str) -> None:
        jsii.set(self, "region", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceTagSpecification")
    def resource_tag_specification(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]], jsii.get(self, "resourceTagSpecification"))

    @resource_tag_specification.setter
    def resource_tag_specification(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]],
    ) -> None:
        jsii.set(self, "resourceTagSpecification", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingDownPolicy")
    def scaling_down_policy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]], jsii.get(self, "scalingDownPolicy"))

    @scaling_down_policy.setter
    def scaling_down_policy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]],
    ) -> None:
        jsii.set(self, "scalingDownPolicy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingStrategy")
    def scaling_strategy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]], jsii.get(self, "scalingStrategy"))

    @scaling_strategy.setter
    def scaling_strategy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]],
    ) -> None:
        jsii.set(self, "scalingStrategy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingTargetPolicy")
    def scaling_target_policy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]], jsii.get(self, "scalingTargetPolicy"))

    @scaling_target_policy.setter
    def scaling_target_policy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]],
    ) -> None:
        jsii.set(self, "scalingTargetPolicy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingUpPolicy")
    def scaling_up_policy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]], jsii.get(self, "scalingUpPolicy"))

    @scaling_up_policy.setter
    def scaling_up_policy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]],
    ) -> None:
        jsii.set(self, "scalingUpPolicy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTask")
    def scheduled_task(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]], jsii.get(self, "scheduledTask"))

    @scheduled_task.setter
    def scheduled_task(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]],
    ) -> None:
        jsii.set(self, "scheduledTask", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="securityGroups")
    def security_groups(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "securityGroups"))

    @security_groups.setter
    def security_groups(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "securityGroups", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shutdownScript")
    def shutdown_script(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "shutdownScript"))

    @shutdown_script.setter
    def shutdown_script(self, value: builtins.str) -> None:
        jsii.set(self, "shutdownScript", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="signal")
    def signal(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]], jsii.get(self, "signal"))

    @signal.setter
    def signal(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]],
    ) -> None:
        jsii.set(self, "signal", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotPercentage")
    def spot_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "spotPercentage"))

    @spot_percentage.setter
    def spot_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "spotPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="statefulInstanceAction")
    def stateful_instance_action(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]], jsii.get(self, "statefulInstanceAction"))

    @stateful_instance_action.setter
    def stateful_instance_action(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]],
    ) -> None:
        jsii.set(self, "statefulInstanceAction", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "subnetIds"))

    @subnet_ids.setter
    def subnet_ids(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "subnetIds", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tags")
    def tags(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]], jsii.get(self, "tags"))

    @tags.setter
    def tags(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]],
    ) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="targetGroupArns")
    def target_group_arns(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "targetGroupArns"))

    @target_group_arns.setter
    def target_group_arns(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "targetGroupArns", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userData")
    def user_data(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "userData"))

    @user_data.setter
    def user_data(self, value: builtins.str) -> None:
        jsii.set(self, "userData", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="utilizeCommitments")
    def utilize_commitments(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "utilizeCommitments"))

    @utilize_commitments.setter
    def utilize_commitments(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "utilizeCommitments", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="utilizeReservedInstances")
    def utilize_reserved_instances(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "utilizeReservedInstances"))

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "utilizeReservedInstances", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForCapacity")
    def wait_for_capacity(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "waitForCapacity"))

    @wait_for_capacity.setter
    def wait_for_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "waitForCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "waitForCapacityTimeout"))

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "waitForCapacityTimeout", value)


class ElastigroupAwsBeanstalk(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalk",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk spotinst_elastigroup_aws_beanstalk}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        desired_capacity: jsii.Number,
        instance_types_spot: typing.Sequence[builtins.str],
        max_size: jsii.Number,
        min_size: jsii.Number,
        name: builtins.str,
        product: builtins.str,
        region: builtins.str,
        beanstalk_environment_id: typing.Optional[builtins.str] = None,
        beanstalk_environment_name: typing.Optional[builtins.str] = None,
        deployment_preferences: typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"] = None,
        maintenance: typing.Optional[builtins.str] = None,
        managed_actions: typing.Optional["ElastigroupAwsBeanstalkManagedActions"] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsBeanstalkScheduledTask"]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk spotinst_elastigroup_aws_beanstalk} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#desired_capacity ElastigroupAwsBeanstalk#desired_capacity}.
        :param instance_types_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#instance_types_spot ElastigroupAwsBeanstalk#instance_types_spot}.
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_size ElastigroupAwsBeanstalk#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_size ElastigroupAwsBeanstalk#min_size}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#name ElastigroupAwsBeanstalk#name}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#product ElastigroupAwsBeanstalk#product}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#region ElastigroupAwsBeanstalk#region}.
        :param beanstalk_environment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_id ElastigroupAwsBeanstalk#beanstalk_environment_id}.
        :param beanstalk_environment_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_name ElastigroupAwsBeanstalk#beanstalk_environment_name}.
        :param deployment_preferences: deployment_preferences block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#deployment_preferences ElastigroupAwsBeanstalk#deployment_preferences}
        :param maintenance: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#maintenance ElastigroupAwsBeanstalk#maintenance}.
        :param managed_actions: managed_actions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#managed_actions ElastigroupAwsBeanstalk#managed_actions}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scheduled_task ElastigroupAwsBeanstalk#scheduled_task}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupAwsBeanstalkConfig(
            desired_capacity=desired_capacity,
            instance_types_spot=instance_types_spot,
            max_size=max_size,
            min_size=min_size,
            name=name,
            product=product,
            region=region,
            beanstalk_environment_id=beanstalk_environment_id,
            beanstalk_environment_name=beanstalk_environment_name,
            deployment_preferences=deployment_preferences,
            maintenance=maintenance,
            managed_actions=managed_actions,
            scheduled_task=scheduled_task,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putDeploymentPreferences")
    def put_deployment_preferences(
        self,
        *,
        automatic_roll: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch_size_percentage: typing.Optional[jsii.Number] = None,
        grace_period: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]] = None,
    ) -> None:
        '''
        :param automatic_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#automatic_roll ElastigroupAwsBeanstalk#automatic_roll}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#strategy ElastigroupAwsBeanstalk#strategy}
        '''
        value = ElastigroupAwsBeanstalkDeploymentPreferences(
            automatic_roll=automatic_roll,
            batch_size_percentage=batch_size_percentage,
            grace_period=grace_period,
            strategy=strategy,
        )

        return typing.cast(None, jsii.invoke(self, "putDeploymentPreferences", [value]))

    @jsii.member(jsii_name="putManagedActions")
    def put_managed_actions(
        self,
        *,
        platform_update: typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"] = None,
    ) -> None:
        '''
        :param platform_update: platform_update block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#platform_update ElastigroupAwsBeanstalk#platform_update}
        '''
        value = ElastigroupAwsBeanstalkManagedActions(platform_update=platform_update)

        return typing.cast(None, jsii.invoke(self, "putManagedActions", [value]))

    @jsii.member(jsii_name="resetBeanstalkEnvironmentId")
    def reset_beanstalk_environment_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBeanstalkEnvironmentId", []))

    @jsii.member(jsii_name="resetBeanstalkEnvironmentName")
    def reset_beanstalk_environment_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBeanstalkEnvironmentName", []))

    @jsii.member(jsii_name="resetDeploymentPreferences")
    def reset_deployment_preferences(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDeploymentPreferences", []))

    @jsii.member(jsii_name="resetMaintenance")
    def reset_maintenance(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaintenance", []))

    @jsii.member(jsii_name="resetManagedActions")
    def reset_managed_actions(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManagedActions", []))

    @jsii.member(jsii_name="resetScheduledTask")
    def reset_scheduled_task(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScheduledTask", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentPreferences")
    def deployment_preferences(
        self,
    ) -> "ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference":
        return typing.cast("ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference", jsii.get(self, "deploymentPreferences"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedActions")
    def managed_actions(self) -> "ElastigroupAwsBeanstalkManagedActionsOutputReference":
        return typing.cast("ElastigroupAwsBeanstalkManagedActionsOutputReference", jsii.get(self, "managedActions"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="beanstalkEnvironmentIdInput")
    def beanstalk_environment_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "beanstalkEnvironmentIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="beanstalkEnvironmentNameInput")
    def beanstalk_environment_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "beanstalkEnvironmentNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentPreferencesInput")
    def deployment_preferences_input(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"]:
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"], jsii.get(self, "deploymentPreferencesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacityInput")
    def desired_capacity_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "desiredCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesSpotInput")
    def instance_types_spot_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "instanceTypesSpotInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maintenanceInput")
    def maintenance_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "maintenanceInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedActionsInput")
    def managed_actions_input(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkManagedActions"]:
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkManagedActions"], jsii.get(self, "managedActionsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSizeInput")
    def max_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSizeInput")
    def min_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "minSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="productInput")
    def product_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "productInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="regionInput")
    def region_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTaskInput")
    def scheduled_task_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]]], jsii.get(self, "scheduledTaskInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="beanstalkEnvironmentId")
    def beanstalk_environment_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "beanstalkEnvironmentId"))

    @beanstalk_environment_id.setter
    def beanstalk_environment_id(self, value: builtins.str) -> None:
        jsii.set(self, "beanstalkEnvironmentId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="beanstalkEnvironmentName")
    def beanstalk_environment_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "beanstalkEnvironmentName"))

    @beanstalk_environment_name.setter
    def beanstalk_environment_name(self, value: builtins.str) -> None:
        jsii.set(self, "beanstalkEnvironmentName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "desiredCapacity"))

    @desired_capacity.setter
    def desired_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="instanceTypesSpot")
    def instance_types_spot(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "instanceTypesSpot"))

    @instance_types_spot.setter
    def instance_types_spot(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "instanceTypesSpot", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maintenance")
    def maintenance(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "maintenance"))

    @maintenance.setter
    def maintenance(self, value: builtins.str) -> None:
        jsii.set(self, "maintenance", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxSize"))

    @max_size.setter
    def max_size(self, value: jsii.Number) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minSize"))

    @min_size.setter
    def min_size(self, value: jsii.Number) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="product")
    def product(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "product"))

    @product.setter
    def product(self, value: builtins.str) -> None:
        jsii.set(self, "product", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="region")
    def region(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "region"))

    @region.setter
    def region(self, value: builtins.str) -> None:
        jsii.set(self, "region", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTask")
    def scheduled_task(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]], jsii.get(self, "scheduledTask"))

    @scheduled_task.setter
    def scheduled_task(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]],
    ) -> None:
        jsii.set(self, "scheduledTask", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "desired_capacity": "desiredCapacity",
        "instance_types_spot": "instanceTypesSpot",
        "max_size": "maxSize",
        "min_size": "minSize",
        "name": "name",
        "product": "product",
        "region": "region",
        "beanstalk_environment_id": "beanstalkEnvironmentId",
        "beanstalk_environment_name": "beanstalkEnvironmentName",
        "deployment_preferences": "deploymentPreferences",
        "maintenance": "maintenance",
        "managed_actions": "managedActions",
        "scheduled_task": "scheduledTask",
    },
)
class ElastigroupAwsBeanstalkConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        desired_capacity: jsii.Number,
        instance_types_spot: typing.Sequence[builtins.str],
        max_size: jsii.Number,
        min_size: jsii.Number,
        name: builtins.str,
        product: builtins.str,
        region: builtins.str,
        beanstalk_environment_id: typing.Optional[builtins.str] = None,
        beanstalk_environment_name: typing.Optional[builtins.str] = None,
        deployment_preferences: typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"] = None,
        maintenance: typing.Optional[builtins.str] = None,
        managed_actions: typing.Optional["ElastigroupAwsBeanstalkManagedActions"] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsBeanstalkScheduledTask"]]] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#desired_capacity ElastigroupAwsBeanstalk#desired_capacity}.
        :param instance_types_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#instance_types_spot ElastigroupAwsBeanstalk#instance_types_spot}.
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_size ElastigroupAwsBeanstalk#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_size ElastigroupAwsBeanstalk#min_size}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#name ElastigroupAwsBeanstalk#name}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#product ElastigroupAwsBeanstalk#product}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#region ElastigroupAwsBeanstalk#region}.
        :param beanstalk_environment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_id ElastigroupAwsBeanstalk#beanstalk_environment_id}.
        :param beanstalk_environment_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_name ElastigroupAwsBeanstalk#beanstalk_environment_name}.
        :param deployment_preferences: deployment_preferences block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#deployment_preferences ElastigroupAwsBeanstalk#deployment_preferences}
        :param maintenance: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#maintenance ElastigroupAwsBeanstalk#maintenance}.
        :param managed_actions: managed_actions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#managed_actions ElastigroupAwsBeanstalk#managed_actions}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scheduled_task ElastigroupAwsBeanstalk#scheduled_task}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(deployment_preferences, dict):
            deployment_preferences = ElastigroupAwsBeanstalkDeploymentPreferences(**deployment_preferences)
        if isinstance(managed_actions, dict):
            managed_actions = ElastigroupAwsBeanstalkManagedActions(**managed_actions)
        self._values: typing.Dict[str, typing.Any] = {
            "desired_capacity": desired_capacity,
            "instance_types_spot": instance_types_spot,
            "max_size": max_size,
            "min_size": min_size,
            "name": name,
            "product": product,
            "region": region,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if beanstalk_environment_id is not None:
            self._values["beanstalk_environment_id"] = beanstalk_environment_id
        if beanstalk_environment_name is not None:
            self._values["beanstalk_environment_name"] = beanstalk_environment_name
        if deployment_preferences is not None:
            self._values["deployment_preferences"] = deployment_preferences
        if maintenance is not None:
            self._values["maintenance"] = maintenance
        if managed_actions is not None:
            self._values["managed_actions"] = managed_actions
        if scheduled_task is not None:
            self._values["scheduled_task"] = scheduled_task

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def desired_capacity(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#desired_capacity ElastigroupAwsBeanstalk#desired_capacity}.'''
        result = self._values.get("desired_capacity")
        assert result is not None, "Required property 'desired_capacity' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def instance_types_spot(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#instance_types_spot ElastigroupAwsBeanstalk#instance_types_spot}.'''
        result = self._values.get("instance_types_spot")
        assert result is not None, "Required property 'instance_types_spot' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def max_size(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_size ElastigroupAwsBeanstalk#max_size}.'''
        result = self._values.get("max_size")
        assert result is not None, "Required property 'max_size' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def min_size(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_size ElastigroupAwsBeanstalk#min_size}.'''
        result = self._values.get("min_size")
        assert result is not None, "Required property 'min_size' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#name ElastigroupAwsBeanstalk#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def product(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#product ElastigroupAwsBeanstalk#product}.'''
        result = self._values.get("product")
        assert result is not None, "Required property 'product' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def region(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#region ElastigroupAwsBeanstalk#region}.'''
        result = self._values.get("region")
        assert result is not None, "Required property 'region' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def beanstalk_environment_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_id ElastigroupAwsBeanstalk#beanstalk_environment_id}.'''
        result = self._values.get("beanstalk_environment_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def beanstalk_environment_name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#beanstalk_environment_name ElastigroupAwsBeanstalk#beanstalk_environment_name}.'''
        result = self._values.get("beanstalk_environment_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def deployment_preferences(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"]:
        '''deployment_preferences block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#deployment_preferences ElastigroupAwsBeanstalk#deployment_preferences}
        '''
        result = self._values.get("deployment_preferences")
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkDeploymentPreferences"], result)

    @builtins.property
    def maintenance(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#maintenance ElastigroupAwsBeanstalk#maintenance}.'''
        result = self._values.get("maintenance")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def managed_actions(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkManagedActions"]:
        '''managed_actions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#managed_actions ElastigroupAwsBeanstalk#managed_actions}
        '''
        result = self._values.get("managed_actions")
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkManagedActions"], result)

    @builtins.property
    def scheduled_task(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]]]:
        '''scheduled_task block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scheduled_task ElastigroupAwsBeanstalk#scheduled_task}
        '''
        result = self._values.get("scheduled_task")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkScheduledTask"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferences",
    jsii_struct_bases=[],
    name_mapping={
        "automatic_roll": "automaticRoll",
        "batch_size_percentage": "batchSizePercentage",
        "grace_period": "gracePeriod",
        "strategy": "strategy",
    },
)
class ElastigroupAwsBeanstalkDeploymentPreferences:
    def __init__(
        self,
        *,
        automatic_roll: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch_size_percentage: typing.Optional[jsii.Number] = None,
        grace_period: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]] = None,
    ) -> None:
        '''
        :param automatic_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#automatic_roll ElastigroupAwsBeanstalk#automatic_roll}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#strategy ElastigroupAwsBeanstalk#strategy}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if automatic_roll is not None:
            self._values["automatic_roll"] = automatic_roll
        if batch_size_percentage is not None:
            self._values["batch_size_percentage"] = batch_size_percentage
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def automatic_roll(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#automatic_roll ElastigroupAwsBeanstalk#automatic_roll}.'''
        result = self._values.get("automatic_roll")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def batch_size_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]]:
        '''strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#strategy ElastigroupAwsBeanstalk#strategy}
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkDeploymentPreferences(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferencesOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAutomaticRoll")
    def reset_automatic_roll(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutomaticRoll", []))

    @jsii.member(jsii_name="resetBatchSizePercentage")
    def reset_batch_size_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBatchSizePercentage", []))

    @jsii.member(jsii_name="resetGracePeriod")
    def reset_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGracePeriod", []))

    @jsii.member(jsii_name="resetStrategy")
    def reset_strategy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStrategy", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="automaticRollInput")
    def automatic_roll_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "automaticRollInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentageInput")
    def batch_size_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchSizePercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriodInput")
    def grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "gracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategyInput")
    def strategy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]], jsii.get(self, "strategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="automaticRoll")
    def automatic_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "automaticRoll"))

    @automatic_roll.setter
    def automatic_roll(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "automaticRoll", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentage")
    def batch_size_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchSizePercentage"))

    @batch_size_percentage.setter
    def batch_size_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "batchSizePercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriod")
    def grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "gracePeriod"))

    @grace_period.setter
    def grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "gracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def strategy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]], jsii.get(self, "strategy"))

    @strategy.setter
    def strategy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsBeanstalkDeploymentPreferencesStrategy"]],
    ) -> None:
        jsii.set(self, "strategy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsBeanstalkDeploymentPreferences]:
        return typing.cast(typing.Optional[ElastigroupAwsBeanstalkDeploymentPreferences], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsBeanstalkDeploymentPreferences],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkDeploymentPreferencesStrategy",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "should_drain_instances": "shouldDrainInstances",
    },
)
class ElastigroupAwsBeanstalkDeploymentPreferencesStrategy:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        should_drain_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#action ElastigroupAwsBeanstalk#action}.
        :param should_drain_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#should_drain_instances ElastigroupAwsBeanstalk#should_drain_instances}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if should_drain_instances is not None:
            self._values["should_drain_instances"] = should_drain_instances

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#action ElastigroupAwsBeanstalk#action}.'''
        result = self._values.get("action")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def should_drain_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#should_drain_instances ElastigroupAwsBeanstalk#should_drain_instances}.'''
        result = self._values.get("should_drain_instances")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkDeploymentPreferencesStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActions",
    jsii_struct_bases=[],
    name_mapping={"platform_update": "platformUpdate"},
)
class ElastigroupAwsBeanstalkManagedActions:
    def __init__(
        self,
        *,
        platform_update: typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"] = None,
    ) -> None:
        '''
        :param platform_update: platform_update block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#platform_update ElastigroupAwsBeanstalk#platform_update}
        '''
        if isinstance(platform_update, dict):
            platform_update = ElastigroupAwsBeanstalkManagedActionsPlatformUpdate(**platform_update)
        self._values: typing.Dict[str, typing.Any] = {}
        if platform_update is not None:
            self._values["platform_update"] = platform_update

    @builtins.property
    def platform_update(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"]:
        '''platform_update block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#platform_update ElastigroupAwsBeanstalk#platform_update}
        '''
        result = self._values.get("platform_update")
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkManagedActions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsBeanstalkManagedActionsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putPlatformUpdate")
    def put_platform_update(
        self,
        *,
        perform_at: typing.Optional[builtins.str] = None,
        time_window: typing.Optional[builtins.str] = None,
        update_level: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#perform_at ElastigroupAwsBeanstalk#perform_at}.
        :param time_window: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#time_window ElastigroupAwsBeanstalk#time_window}.
        :param update_level: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#update_level ElastigroupAwsBeanstalk#update_level}.
        '''
        value = ElastigroupAwsBeanstalkManagedActionsPlatformUpdate(
            perform_at=perform_at, time_window=time_window, update_level=update_level
        )

        return typing.cast(None, jsii.invoke(self, "putPlatformUpdate", [value]))

    @jsii.member(jsii_name="resetPlatformUpdate")
    def reset_platform_update(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPlatformUpdate", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="platformUpdate")
    def platform_update(
        self,
    ) -> "ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference":
        return typing.cast("ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference", jsii.get(self, "platformUpdate"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="platformUpdateInput")
    def platform_update_input(
        self,
    ) -> typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"]:
        return typing.cast(typing.Optional["ElastigroupAwsBeanstalkManagedActionsPlatformUpdate"], jsii.get(self, "platformUpdateInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsBeanstalkManagedActions]:
        return typing.cast(typing.Optional[ElastigroupAwsBeanstalkManagedActions], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsBeanstalkManagedActions],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActionsPlatformUpdate",
    jsii_struct_bases=[],
    name_mapping={
        "perform_at": "performAt",
        "time_window": "timeWindow",
        "update_level": "updateLevel",
    },
)
class ElastigroupAwsBeanstalkManagedActionsPlatformUpdate:
    def __init__(
        self,
        *,
        perform_at: typing.Optional[builtins.str] = None,
        time_window: typing.Optional[builtins.str] = None,
        update_level: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#perform_at ElastigroupAwsBeanstalk#perform_at}.
        :param time_window: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#time_window ElastigroupAwsBeanstalk#time_window}.
        :param update_level: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#update_level ElastigroupAwsBeanstalk#update_level}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if perform_at is not None:
            self._values["perform_at"] = perform_at
        if time_window is not None:
            self._values["time_window"] = time_window
        if update_level is not None:
            self._values["update_level"] = update_level

    @builtins.property
    def perform_at(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#perform_at ElastigroupAwsBeanstalk#perform_at}.'''
        result = self._values.get("perform_at")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def time_window(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#time_window ElastigroupAwsBeanstalk#time_window}.'''
        result = self._values.get("time_window")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_level(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#update_level ElastigroupAwsBeanstalk#update_level}.'''
        result = self._values.get("update_level")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkManagedActionsPlatformUpdate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkManagedActionsPlatformUpdateOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPerformAt")
    def reset_perform_at(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPerformAt", []))

    @jsii.member(jsii_name="resetTimeWindow")
    def reset_time_window(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeWindow", []))

    @jsii.member(jsii_name="resetUpdateLevel")
    def reset_update_level(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdateLevel", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAtInput")
    def perform_at_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "performAtInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindowInput")
    def time_window_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "timeWindowInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updateLevelInput")
    def update_level_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "updateLevelInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAt")
    def perform_at(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "performAt"))

    @perform_at.setter
    def perform_at(self, value: builtins.str) -> None:
        jsii.set(self, "performAt", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindow")
    def time_window(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "timeWindow"))

    @time_window.setter
    def time_window(self, value: builtins.str) -> None:
        jsii.set(self, "timeWindow", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updateLevel")
    def update_level(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "updateLevel"))

    @update_level.setter
    def update_level(self, value: builtins.str) -> None:
        jsii.set(self, "updateLevel", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsBeanstalkManagedActionsPlatformUpdate]:
        return typing.cast(typing.Optional[ElastigroupAwsBeanstalkManagedActionsPlatformUpdate], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsBeanstalkManagedActionsPlatformUpdate],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsBeanstalkScheduledTask",
    jsii_struct_bases=[],
    name_mapping={
        "task_type": "taskType",
        "adjustment": "adjustment",
        "adjustment_percentage": "adjustmentPercentage",
        "batch_size_percentage": "batchSizePercentage",
        "cron_expression": "cronExpression",
        "frequency": "frequency",
        "grace_period": "gracePeriod",
        "is_enabled": "isEnabled",
        "max_capacity": "maxCapacity",
        "min_capacity": "minCapacity",
        "scale_max_capacity": "scaleMaxCapacity",
        "scale_min_capacity": "scaleMinCapacity",
        "scale_target_capacity": "scaleTargetCapacity",
        "start_time": "startTime",
        "target_capacity": "targetCapacity",
    },
)
class ElastigroupAwsBeanstalkScheduledTask:
    def __init__(
        self,
        *,
        task_type: builtins.str,
        adjustment: typing.Optional[builtins.str] = None,
        adjustment_percentage: typing.Optional[builtins.str] = None,
        batch_size_percentage: typing.Optional[builtins.str] = None,
        cron_expression: typing.Optional[builtins.str] = None,
        frequency: typing.Optional[builtins.str] = None,
        grace_period: typing.Optional[builtins.str] = None,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        max_capacity: typing.Optional[builtins.str] = None,
        min_capacity: typing.Optional[builtins.str] = None,
        scale_max_capacity: typing.Optional[builtins.str] = None,
        scale_min_capacity: typing.Optional[builtins.str] = None,
        scale_target_capacity: typing.Optional[builtins.str] = None,
        start_time: typing.Optional[builtins.str] = None,
        target_capacity: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param task_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#task_type ElastigroupAwsBeanstalk#task_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment ElastigroupAwsBeanstalk#adjustment}.
        :param adjustment_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment_percentage ElastigroupAwsBeanstalk#adjustment_percentage}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}.
        :param cron_expression: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#cron_expression ElastigroupAwsBeanstalk#cron_expression}.
        :param frequency: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#frequency ElastigroupAwsBeanstalk#frequency}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}.
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#is_enabled ElastigroupAwsBeanstalk#is_enabled}.
        :param max_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_capacity ElastigroupAwsBeanstalk#max_capacity}.
        :param min_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_capacity ElastigroupAwsBeanstalk#min_capacity}.
        :param scale_max_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_max_capacity ElastigroupAwsBeanstalk#scale_max_capacity}.
        :param scale_min_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_min_capacity ElastigroupAwsBeanstalk#scale_min_capacity}.
        :param scale_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_target_capacity ElastigroupAwsBeanstalk#scale_target_capacity}.
        :param start_time: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#start_time ElastigroupAwsBeanstalk#start_time}.
        :param target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#target_capacity ElastigroupAwsBeanstalk#target_capacity}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "task_type": task_type,
        }
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if adjustment_percentage is not None:
            self._values["adjustment_percentage"] = adjustment_percentage
        if batch_size_percentage is not None:
            self._values["batch_size_percentage"] = batch_size_percentage
        if cron_expression is not None:
            self._values["cron_expression"] = cron_expression
        if frequency is not None:
            self._values["frequency"] = frequency
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled
        if max_capacity is not None:
            self._values["max_capacity"] = max_capacity
        if min_capacity is not None:
            self._values["min_capacity"] = min_capacity
        if scale_max_capacity is not None:
            self._values["scale_max_capacity"] = scale_max_capacity
        if scale_min_capacity is not None:
            self._values["scale_min_capacity"] = scale_min_capacity
        if scale_target_capacity is not None:
            self._values["scale_target_capacity"] = scale_target_capacity
        if start_time is not None:
            self._values["start_time"] = start_time
        if target_capacity is not None:
            self._values["target_capacity"] = target_capacity

    @builtins.property
    def task_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#task_type ElastigroupAwsBeanstalk#task_type}.'''
        result = self._values.get("task_type")
        assert result is not None, "Required property 'task_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment ElastigroupAwsBeanstalk#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#adjustment_percentage ElastigroupAwsBeanstalk#adjustment_percentage}.'''
        result = self._values.get("adjustment_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def batch_size_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#batch_size_percentage ElastigroupAwsBeanstalk#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cron_expression(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#cron_expression ElastigroupAwsBeanstalk#cron_expression}.'''
        result = self._values.get("cron_expression")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def frequency(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#frequency ElastigroupAwsBeanstalk#frequency}.'''
        result = self._values.get("frequency")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#grace_period ElastigroupAwsBeanstalk#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#is_enabled ElastigroupAwsBeanstalk#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def max_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#max_capacity ElastigroupAwsBeanstalk#max_capacity}.'''
        result = self._values.get("max_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#min_capacity ElastigroupAwsBeanstalk#min_capacity}.'''
        result = self._values.get("min_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_max_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_max_capacity ElastigroupAwsBeanstalk#scale_max_capacity}.'''
        result = self._values.get("scale_max_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_min_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_min_capacity ElastigroupAwsBeanstalk#scale_min_capacity}.'''
        result = self._values.get("scale_min_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#scale_target_capacity ElastigroupAwsBeanstalk#scale_target_capacity}.'''
        result = self._values.get("scale_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def start_time(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#start_time ElastigroupAwsBeanstalk#start_time}.'''
        result = self._values.get("start_time")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_beanstalk#target_capacity ElastigroupAwsBeanstalk#target_capacity}.'''
        result = self._values.get("target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsBeanstalkScheduledTask(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "fallback_to_ondemand": "fallbackToOndemand",
        "instance_types_ondemand": "instanceTypesOndemand",
        "instance_types_spot": "instanceTypesSpot",
        "name": "name",
        "orientation": "orientation",
        "product": "product",
        "security_groups": "securityGroups",
        "availability_zones": "availabilityZones",
        "block_devices_mode": "blockDevicesMode",
        "capacity_unit": "capacityUnit",
        "cpu_credits": "cpuCredits",
        "cpu_options": "cpuOptions",
        "description": "description",
        "desired_capacity": "desiredCapacity",
        "draining_timeout": "drainingTimeout",
        "ebs_block_device": "ebsBlockDevice",
        "ebs_optimized": "ebsOptimized",
        "elastic_ips": "elasticIps",
        "elastic_load_balancers": "elasticLoadBalancers",
        "enable_monitoring": "enableMonitoring",
        "ephemeral_block_device": "ephemeralBlockDevice",
        "health_check_grace_period": "healthCheckGracePeriod",
        "health_check_type": "healthCheckType",
        "health_check_unhealthy_duration_before_replacement": "healthCheckUnhealthyDurationBeforeReplacement",
        "iam_instance_profile": "iamInstanceProfile",
        "image_id": "imageId",
        "instance_types_preferred_spot": "instanceTypesPreferredSpot",
        "instance_types_weights": "instanceTypesWeights",
        "integration_beanstalk": "integrationBeanstalk",
        "integration_codedeploy": "integrationCodedeploy",
        "integration_docker_swarm": "integrationDockerSwarm",
        "integration_ecs": "integrationEcs",
        "integration_gitlab": "integrationGitlab",
        "integration_kubernetes": "integrationKubernetes",
        "integration_mesosphere": "integrationMesosphere",
        "integration_multai_runtime": "integrationMultaiRuntime",
        "integration_nomad": "integrationNomad",
        "integration_rancher": "integrationRancher",
        "integration_route53": "integrationRoute53",
        "itf": "itf",
        "key_name": "keyName",
        "lifetime_period": "lifetimePeriod",
        "max_size": "maxSize",
        "metadata_options": "metadataOptions",
        "minimum_instance_lifetime": "minimumInstanceLifetime",
        "min_size": "minSize",
        "multai_target_sets": "multaiTargetSets",
        "multiple_metrics": "multipleMetrics",
        "network_interface": "networkInterface",
        "ondemand_count": "ondemandCount",
        "persist_block_devices": "persistBlockDevices",
        "persist_private_ip": "persistPrivateIp",
        "persist_root_device": "persistRootDevice",
        "placement_tenancy": "placementTenancy",
        "preferred_availability_zones": "preferredAvailabilityZones",
        "private_ips": "privateIps",
        "region": "region",
        "resource_tag_specification": "resourceTagSpecification",
        "revert_to_spot": "revertToSpot",
        "scaling_down_policy": "scalingDownPolicy",
        "scaling_strategy": "scalingStrategy",
        "scaling_target_policy": "scalingTargetPolicy",
        "scaling_up_policy": "scalingUpPolicy",
        "scheduled_task": "scheduledTask",
        "shutdown_script": "shutdownScript",
        "signal": "signal",
        "spot_percentage": "spotPercentage",
        "stateful_deallocation": "statefulDeallocation",
        "stateful_instance_action": "statefulInstanceAction",
        "subnet_ids": "subnetIds",
        "tags": "tags",
        "target_group_arns": "targetGroupArns",
        "update_policy": "updatePolicy",
        "user_data": "userData",
        "utilize_commitments": "utilizeCommitments",
        "utilize_reserved_instances": "utilizeReservedInstances",
        "wait_for_capacity": "waitForCapacity",
        "wait_for_capacity_timeout": "waitForCapacityTimeout",
    },
)
class ElastigroupAwsConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        fallback_to_ondemand: typing.Union[builtins.bool, cdktf.IResolvable],
        instance_types_ondemand: builtins.str,
        instance_types_spot: typing.Sequence[builtins.str],
        name: builtins.str,
        orientation: builtins.str,
        product: builtins.str,
        security_groups: typing.Sequence[builtins.str],
        availability_zones: typing.Optional[typing.Sequence[builtins.str]] = None,
        block_devices_mode: typing.Optional[builtins.str] = None,
        capacity_unit: typing.Optional[builtins.str] = None,
        cpu_credits: typing.Optional[builtins.str] = None,
        cpu_options: typing.Optional["ElastigroupAwsCpuOptions"] = None,
        description: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        draining_timeout: typing.Optional[jsii.Number] = None,
        ebs_block_device: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsEbsBlockDevice"]]] = None,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        elastic_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
        elastic_load_balancers: typing.Optional[typing.Sequence[builtins.str]] = None,
        enable_monitoring: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        ephemeral_block_device: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsEphemeralBlockDevice"]]] = None,
        health_check_grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        health_check_unhealthy_duration_before_replacement: typing.Optional[jsii.Number] = None,
        iam_instance_profile: typing.Optional[builtins.str] = None,
        image_id: typing.Optional[builtins.str] = None,
        instance_types_preferred_spot: typing.Optional[typing.Sequence[builtins.str]] = None,
        instance_types_weights: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsInstanceTypesWeights"]]] = None,
        integration_beanstalk: typing.Optional["ElastigroupAwsIntegrationBeanstalk"] = None,
        integration_codedeploy: typing.Optional["ElastigroupAwsIntegrationCodedeploy"] = None,
        integration_docker_swarm: typing.Optional["ElastigroupAwsIntegrationDockerSwarm"] = None,
        integration_ecs: typing.Optional["ElastigroupAwsIntegrationEcs"] = None,
        integration_gitlab: typing.Optional["ElastigroupAwsIntegrationGitlab"] = None,
        integration_kubernetes: typing.Optional["ElastigroupAwsIntegrationKubernetes"] = None,
        integration_mesosphere: typing.Optional["ElastigroupAwsIntegrationMesosphere"] = None,
        integration_multai_runtime: typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"] = None,
        integration_nomad: typing.Optional["ElastigroupAwsIntegrationNomad"] = None,
        integration_rancher: typing.Optional["ElastigroupAwsIntegrationRancher"] = None,
        integration_route53: typing.Optional["ElastigroupAwsIntegrationRoute53"] = None,
        itf: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItf"]]] = None,
        key_name: typing.Optional[builtins.str] = None,
        lifetime_period: typing.Optional[builtins.str] = None,
        max_size: typing.Optional[jsii.Number] = None,
        metadata_options: typing.Optional["ElastigroupAwsMetadataOptions"] = None,
        minimum_instance_lifetime: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        multai_target_sets: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultaiTargetSets"]]] = None,
        multiple_metrics: typing.Optional["ElastigroupAwsMultipleMetrics"] = None,
        network_interface: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsNetworkInterface"]]] = None,
        ondemand_count: typing.Optional[jsii.Number] = None,
        persist_block_devices: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        persist_private_ip: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        persist_root_device: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        placement_tenancy: typing.Optional[builtins.str] = None,
        preferred_availability_zones: typing.Optional[typing.Sequence[builtins.str]] = None,
        private_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
        region: typing.Optional[builtins.str] = None,
        resource_tag_specification: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsResourceTagSpecification"]]] = None,
        revert_to_spot: typing.Optional["ElastigroupAwsRevertToSpot"] = None,
        scaling_down_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingDownPolicy"]]] = None,
        scaling_strategy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingStrategy"]]] = None,
        scaling_target_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingTargetPolicy"]]] = None,
        scaling_up_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingUpPolicy"]]] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScheduledTask"]]] = None,
        shutdown_script: typing.Optional[builtins.str] = None,
        signal: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsSignal"]]] = None,
        spot_percentage: typing.Optional[jsii.Number] = None,
        stateful_deallocation: typing.Optional["ElastigroupAwsStatefulDeallocation"] = None,
        stateful_instance_action: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsStatefulInstanceAction"]]] = None,
        subnet_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        tags: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsTags"]]] = None,
        target_group_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        update_policy: typing.Optional["ElastigroupAwsUpdatePolicy"] = None,
        user_data: typing.Optional[builtins.str] = None,
        utilize_commitments: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        utilize_reserved_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        wait_for_capacity: typing.Optional[jsii.Number] = None,
        wait_for_capacity_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param fallback_to_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fallback_to_ondemand ElastigroupAws#fallback_to_ondemand}.
        :param instance_types_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_ondemand ElastigroupAws#instance_types_ondemand}.
        :param instance_types_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_spot ElastigroupAws#instance_types_spot}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param orientation: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#orientation ElastigroupAws#orientation}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#product ElastigroupAws#product}.
        :param security_groups: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#security_groups ElastigroupAws#security_groups}.
        :param availability_zones: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#availability_zones ElastigroupAws#availability_zones}.
        :param block_devices_mode: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#block_devices_mode ElastigroupAws#block_devices_mode}.
        :param capacity_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#capacity_unit ElastigroupAws#capacity_unit}.
        :param cpu_credits: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_credits ElastigroupAws#cpu_credits}.
        :param cpu_options: cpu_options block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_options ElastigroupAws#cpu_options}
        :param description: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#desired_capacity ElastigroupAws#desired_capacity}.
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.
        :param ebs_block_device: ebs_block_device block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_block_device ElastigroupAws#ebs_block_device}
        :param ebs_optimized: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_optimized ElastigroupAws#ebs_optimized}.
        :param elastic_ips: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_ips ElastigroupAws#elastic_ips}.
        :param elastic_load_balancers: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_load_balancers ElastigroupAws#elastic_load_balancers}.
        :param enable_monitoring: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#enable_monitoring ElastigroupAws#enable_monitoring}.
        :param ephemeral_block_device: ephemeral_block_device block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ephemeral_block_device ElastigroupAws#ephemeral_block_device}
        :param health_check_grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_grace_period ElastigroupAws#health_check_grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.
        :param health_check_unhealthy_duration_before_replacement: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_unhealthy_duration_before_replacement ElastigroupAws#health_check_unhealthy_duration_before_replacement}.
        :param iam_instance_profile: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iam_instance_profile ElastigroupAws#iam_instance_profile}.
        :param image_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#image_id ElastigroupAws#image_id}.
        :param instance_types_preferred_spot: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_preferred_spot ElastigroupAws#instance_types_preferred_spot}.
        :param instance_types_weights: instance_types_weights block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_weights ElastigroupAws#instance_types_weights}
        :param integration_beanstalk: integration_beanstalk block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_beanstalk ElastigroupAws#integration_beanstalk}
        :param integration_codedeploy: integration_codedeploy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_codedeploy ElastigroupAws#integration_codedeploy}
        :param integration_docker_swarm: integration_docker_swarm block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_docker_swarm ElastigroupAws#integration_docker_swarm}
        :param integration_ecs: integration_ecs block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_ecs ElastigroupAws#integration_ecs}
        :param integration_gitlab: integration_gitlab block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_gitlab ElastigroupAws#integration_gitlab}
        :param integration_kubernetes: integration_kubernetes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_kubernetes ElastigroupAws#integration_kubernetes}
        :param integration_mesosphere: integration_mesosphere block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mesosphere ElastigroupAws#integration_mesosphere}
        :param integration_multai_runtime: integration_multai_runtime block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_multai_runtime ElastigroupAws#integration_multai_runtime}
        :param integration_nomad: integration_nomad block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_nomad ElastigroupAws#integration_nomad}
        :param integration_rancher: integration_rancher block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_rancher ElastigroupAws#integration_rancher}
        :param integration_route53: integration_route53 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_route53 ElastigroupAws#integration_route53}
        :param itf: itf block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#itf ElastigroupAws#itf}
        :param key_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key_name ElastigroupAws#key_name}.
        :param lifetime_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#lifetime_period ElastigroupAws#lifetime_period}.
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_size ElastigroupAws#max_size}.
        :param metadata_options: metadata_options block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metadata_options ElastigroupAws#metadata_options}
        :param minimum_instance_lifetime: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum_instance_lifetime ElastigroupAws#minimum_instance_lifetime}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_size ElastigroupAws#min_size}.
        :param multai_target_sets: multai_target_sets block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multai_target_sets ElastigroupAws#multai_target_sets}
        :param multiple_metrics: multiple_metrics block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multiple_metrics ElastigroupAws#multiple_metrics}
        :param network_interface: network_interface block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface ElastigroupAws#network_interface}
        :param ondemand_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ondemand_count ElastigroupAws#ondemand_count}.
        :param persist_block_devices: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_block_devices ElastigroupAws#persist_block_devices}.
        :param persist_private_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_private_ip ElastigroupAws#persist_private_ip}.
        :param persist_root_device: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_root_device ElastigroupAws#persist_root_device}.
        :param placement_tenancy: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#placement_tenancy ElastigroupAws#placement_tenancy}.
        :param preferred_availability_zones: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#preferred_availability_zones ElastigroupAws#preferred_availability_zones}.
        :param private_ips: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ips ElastigroupAws#private_ips}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#region ElastigroupAws#region}.
        :param resource_tag_specification: resource_tag_specification block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#resource_tag_specification ElastigroupAws#resource_tag_specification}
        :param revert_to_spot: revert_to_spot block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#revert_to_spot ElastigroupAws#revert_to_spot}
        :param scaling_down_policy: scaling_down_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_down_policy ElastigroupAws#scaling_down_policy}
        :param scaling_strategy: scaling_strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_strategy ElastigroupAws#scaling_strategy}
        :param scaling_target_policy: scaling_target_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_target_policy ElastigroupAws#scaling_target_policy}
        :param scaling_up_policy: scaling_up_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_up_policy ElastigroupAws#scaling_up_policy}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scheduled_task ElastigroupAws#scheduled_task}
        :param shutdown_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#shutdown_script ElastigroupAws#shutdown_script}.
        :param signal: signal block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#signal ElastigroupAws#signal}
        :param spot_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spot_percentage ElastigroupAws#spot_percentage}.
        :param stateful_deallocation: stateful_deallocation block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_deallocation ElastigroupAws#stateful_deallocation}
        :param stateful_instance_action: stateful_instance_action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_action ElastigroupAws#stateful_instance_action}
        :param subnet_ids: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#subnet_ids ElastigroupAws#subnet_ids}.
        :param tags: tags block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
        :param target_group_arns: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_arns ElastigroupAws#target_group_arns}.
        :param update_policy: update_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_policy ElastigroupAws#update_policy}
        :param user_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#user_data ElastigroupAws#user_data}.
        :param utilize_commitments: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_commitments ElastigroupAws#utilize_commitments}.
        :param utilize_reserved_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_reserved_instances ElastigroupAws#utilize_reserved_instances}.
        :param wait_for_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity ElastigroupAws#wait_for_capacity}.
        :param wait_for_capacity_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity_timeout ElastigroupAws#wait_for_capacity_timeout}.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(cpu_options, dict):
            cpu_options = ElastigroupAwsCpuOptions(**cpu_options)
        if isinstance(integration_beanstalk, dict):
            integration_beanstalk = ElastigroupAwsIntegrationBeanstalk(**integration_beanstalk)
        if isinstance(integration_codedeploy, dict):
            integration_codedeploy = ElastigroupAwsIntegrationCodedeploy(**integration_codedeploy)
        if isinstance(integration_docker_swarm, dict):
            integration_docker_swarm = ElastigroupAwsIntegrationDockerSwarm(**integration_docker_swarm)
        if isinstance(integration_ecs, dict):
            integration_ecs = ElastigroupAwsIntegrationEcs(**integration_ecs)
        if isinstance(integration_gitlab, dict):
            integration_gitlab = ElastigroupAwsIntegrationGitlab(**integration_gitlab)
        if isinstance(integration_kubernetes, dict):
            integration_kubernetes = ElastigroupAwsIntegrationKubernetes(**integration_kubernetes)
        if isinstance(integration_mesosphere, dict):
            integration_mesosphere = ElastigroupAwsIntegrationMesosphere(**integration_mesosphere)
        if isinstance(integration_multai_runtime, dict):
            integration_multai_runtime = ElastigroupAwsIntegrationMultaiRuntime(**integration_multai_runtime)
        if isinstance(integration_nomad, dict):
            integration_nomad = ElastigroupAwsIntegrationNomad(**integration_nomad)
        if isinstance(integration_rancher, dict):
            integration_rancher = ElastigroupAwsIntegrationRancher(**integration_rancher)
        if isinstance(integration_route53, dict):
            integration_route53 = ElastigroupAwsIntegrationRoute53(**integration_route53)
        if isinstance(metadata_options, dict):
            metadata_options = ElastigroupAwsMetadataOptions(**metadata_options)
        if isinstance(multiple_metrics, dict):
            multiple_metrics = ElastigroupAwsMultipleMetrics(**multiple_metrics)
        if isinstance(revert_to_spot, dict):
            revert_to_spot = ElastigroupAwsRevertToSpot(**revert_to_spot)
        if isinstance(stateful_deallocation, dict):
            stateful_deallocation = ElastigroupAwsStatefulDeallocation(**stateful_deallocation)
        if isinstance(update_policy, dict):
            update_policy = ElastigroupAwsUpdatePolicy(**update_policy)
        self._values: typing.Dict[str, typing.Any] = {
            "fallback_to_ondemand": fallback_to_ondemand,
            "instance_types_ondemand": instance_types_ondemand,
            "instance_types_spot": instance_types_spot,
            "name": name,
            "orientation": orientation,
            "product": product,
            "security_groups": security_groups,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if availability_zones is not None:
            self._values["availability_zones"] = availability_zones
        if block_devices_mode is not None:
            self._values["block_devices_mode"] = block_devices_mode
        if capacity_unit is not None:
            self._values["capacity_unit"] = capacity_unit
        if cpu_credits is not None:
            self._values["cpu_credits"] = cpu_credits
        if cpu_options is not None:
            self._values["cpu_options"] = cpu_options
        if description is not None:
            self._values["description"] = description
        if desired_capacity is not None:
            self._values["desired_capacity"] = desired_capacity
        if draining_timeout is not None:
            self._values["draining_timeout"] = draining_timeout
        if ebs_block_device is not None:
            self._values["ebs_block_device"] = ebs_block_device
        if ebs_optimized is not None:
            self._values["ebs_optimized"] = ebs_optimized
        if elastic_ips is not None:
            self._values["elastic_ips"] = elastic_ips
        if elastic_load_balancers is not None:
            self._values["elastic_load_balancers"] = elastic_load_balancers
        if enable_monitoring is not None:
            self._values["enable_monitoring"] = enable_monitoring
        if ephemeral_block_device is not None:
            self._values["ephemeral_block_device"] = ephemeral_block_device
        if health_check_grace_period is not None:
            self._values["health_check_grace_period"] = health_check_grace_period
        if health_check_type is not None:
            self._values["health_check_type"] = health_check_type
        if health_check_unhealthy_duration_before_replacement is not None:
            self._values["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
        if iam_instance_profile is not None:
            self._values["iam_instance_profile"] = iam_instance_profile
        if image_id is not None:
            self._values["image_id"] = image_id
        if instance_types_preferred_spot is not None:
            self._values["instance_types_preferred_spot"] = instance_types_preferred_spot
        if instance_types_weights is not None:
            self._values["instance_types_weights"] = instance_types_weights
        if integration_beanstalk is not None:
            self._values["integration_beanstalk"] = integration_beanstalk
        if integration_codedeploy is not None:
            self._values["integration_codedeploy"] = integration_codedeploy
        if integration_docker_swarm is not None:
            self._values["integration_docker_swarm"] = integration_docker_swarm
        if integration_ecs is not None:
            self._values["integration_ecs"] = integration_ecs
        if integration_gitlab is not None:
            self._values["integration_gitlab"] = integration_gitlab
        if integration_kubernetes is not None:
            self._values["integration_kubernetes"] = integration_kubernetes
        if integration_mesosphere is not None:
            self._values["integration_mesosphere"] = integration_mesosphere
        if integration_multai_runtime is not None:
            self._values["integration_multai_runtime"] = integration_multai_runtime
        if integration_nomad is not None:
            self._values["integration_nomad"] = integration_nomad
        if integration_rancher is not None:
            self._values["integration_rancher"] = integration_rancher
        if integration_route53 is not None:
            self._values["integration_route53"] = integration_route53
        if itf is not None:
            self._values["itf"] = itf
        if key_name is not None:
            self._values["key_name"] = key_name
        if lifetime_period is not None:
            self._values["lifetime_period"] = lifetime_period
        if max_size is not None:
            self._values["max_size"] = max_size
        if metadata_options is not None:
            self._values["metadata_options"] = metadata_options
        if minimum_instance_lifetime is not None:
            self._values["minimum_instance_lifetime"] = minimum_instance_lifetime
        if min_size is not None:
            self._values["min_size"] = min_size
        if multai_target_sets is not None:
            self._values["multai_target_sets"] = multai_target_sets
        if multiple_metrics is not None:
            self._values["multiple_metrics"] = multiple_metrics
        if network_interface is not None:
            self._values["network_interface"] = network_interface
        if ondemand_count is not None:
            self._values["ondemand_count"] = ondemand_count
        if persist_block_devices is not None:
            self._values["persist_block_devices"] = persist_block_devices
        if persist_private_ip is not None:
            self._values["persist_private_ip"] = persist_private_ip
        if persist_root_device is not None:
            self._values["persist_root_device"] = persist_root_device
        if placement_tenancy is not None:
            self._values["placement_tenancy"] = placement_tenancy
        if preferred_availability_zones is not None:
            self._values["preferred_availability_zones"] = preferred_availability_zones
        if private_ips is not None:
            self._values["private_ips"] = private_ips
        if region is not None:
            self._values["region"] = region
        if resource_tag_specification is not None:
            self._values["resource_tag_specification"] = resource_tag_specification
        if revert_to_spot is not None:
            self._values["revert_to_spot"] = revert_to_spot
        if scaling_down_policy is not None:
            self._values["scaling_down_policy"] = scaling_down_policy
        if scaling_strategy is not None:
            self._values["scaling_strategy"] = scaling_strategy
        if scaling_target_policy is not None:
            self._values["scaling_target_policy"] = scaling_target_policy
        if scaling_up_policy is not None:
            self._values["scaling_up_policy"] = scaling_up_policy
        if scheduled_task is not None:
            self._values["scheduled_task"] = scheduled_task
        if shutdown_script is not None:
            self._values["shutdown_script"] = shutdown_script
        if signal is not None:
            self._values["signal"] = signal
        if spot_percentage is not None:
            self._values["spot_percentage"] = spot_percentage
        if stateful_deallocation is not None:
            self._values["stateful_deallocation"] = stateful_deallocation
        if stateful_instance_action is not None:
            self._values["stateful_instance_action"] = stateful_instance_action
        if subnet_ids is not None:
            self._values["subnet_ids"] = subnet_ids
        if tags is not None:
            self._values["tags"] = tags
        if target_group_arns is not None:
            self._values["target_group_arns"] = target_group_arns
        if update_policy is not None:
            self._values["update_policy"] = update_policy
        if user_data is not None:
            self._values["user_data"] = user_data
        if utilize_commitments is not None:
            self._values["utilize_commitments"] = utilize_commitments
        if utilize_reserved_instances is not None:
            self._values["utilize_reserved_instances"] = utilize_reserved_instances
        if wait_for_capacity is not None:
            self._values["wait_for_capacity"] = wait_for_capacity
        if wait_for_capacity_timeout is not None:
            self._values["wait_for_capacity_timeout"] = wait_for_capacity_timeout

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def fallback_to_ondemand(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fallback_to_ondemand ElastigroupAws#fallback_to_ondemand}.'''
        result = self._values.get("fallback_to_ondemand")
        assert result is not None, "Required property 'fallback_to_ondemand' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def instance_types_ondemand(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_ondemand ElastigroupAws#instance_types_ondemand}.'''
        result = self._values.get("instance_types_ondemand")
        assert result is not None, "Required property 'instance_types_ondemand' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def instance_types_spot(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_spot ElastigroupAws#instance_types_spot}.'''
        result = self._values.get("instance_types_spot")
        assert result is not None, "Required property 'instance_types_spot' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def orientation(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#orientation ElastigroupAws#orientation}.'''
        result = self._values.get("orientation")
        assert result is not None, "Required property 'orientation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def product(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#product ElastigroupAws#product}.'''
        result = self._values.get("product")
        assert result is not None, "Required property 'product' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def security_groups(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#security_groups ElastigroupAws#security_groups}.'''
        result = self._values.get("security_groups")
        assert result is not None, "Required property 'security_groups' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def availability_zones(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#availability_zones ElastigroupAws#availability_zones}.'''
        result = self._values.get("availability_zones")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def block_devices_mode(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#block_devices_mode ElastigroupAws#block_devices_mode}.'''
        result = self._values.get("block_devices_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def capacity_unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#capacity_unit ElastigroupAws#capacity_unit}.'''
        result = self._values.get("capacity_unit")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cpu_credits(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_credits ElastigroupAws#cpu_credits}.'''
        result = self._values.get("cpu_credits")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cpu_options(self) -> typing.Optional["ElastigroupAwsCpuOptions"]:
        '''cpu_options block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_options ElastigroupAws#cpu_options}
        '''
        result = self._values.get("cpu_options")
        return typing.cast(typing.Optional["ElastigroupAwsCpuOptions"], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}.'''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#desired_capacity ElastigroupAws#desired_capacity}.'''
        result = self._values.get("desired_capacity")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def draining_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.'''
        result = self._values.get("draining_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ebs_block_device(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]]]:
        '''ebs_block_device block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_block_device ElastigroupAws#ebs_block_device}
        '''
        result = self._values.get("ebs_block_device")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEbsBlockDevice"]]], result)

    @builtins.property
    def ebs_optimized(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ebs_optimized ElastigroupAws#ebs_optimized}.'''
        result = self._values.get("ebs_optimized")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def elastic_ips(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_ips ElastigroupAws#elastic_ips}.'''
        result = self._values.get("elastic_ips")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def elastic_load_balancers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#elastic_load_balancers ElastigroupAws#elastic_load_balancers}.'''
        result = self._values.get("elastic_load_balancers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def enable_monitoring(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#enable_monitoring ElastigroupAws#enable_monitoring}.'''
        result = self._values.get("enable_monitoring")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]]]:
        '''ephemeral_block_device block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ephemeral_block_device ElastigroupAws#ephemeral_block_device}
        '''
        result = self._values.get("ephemeral_block_device")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsEphemeralBlockDevice"]]], result)

    @builtins.property
    def health_check_grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_grace_period ElastigroupAws#health_check_grace_period}.'''
        result = self._values.get("health_check_grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.'''
        result = self._values.get("health_check_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def health_check_unhealthy_duration_before_replacement(
        self,
    ) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_unhealthy_duration_before_replacement ElastigroupAws#health_check_unhealthy_duration_before_replacement}.'''
        result = self._values.get("health_check_unhealthy_duration_before_replacement")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def iam_instance_profile(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iam_instance_profile ElastigroupAws#iam_instance_profile}.'''
        result = self._values.get("iam_instance_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#image_id ElastigroupAws#image_id}.'''
        result = self._values.get("image_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def instance_types_preferred_spot(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_preferred_spot ElastigroupAws#instance_types_preferred_spot}.'''
        result = self._values.get("instance_types_preferred_spot")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def instance_types_weights(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]]]:
        '''instance_types_weights block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_types_weights ElastigroupAws#instance_types_weights}
        '''
        result = self._values.get("instance_types_weights")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsInstanceTypesWeights"]]], result)

    @builtins.property
    def integration_beanstalk(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalk"]:
        '''integration_beanstalk block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_beanstalk ElastigroupAws#integration_beanstalk}
        '''
        result = self._values.get("integration_beanstalk")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalk"], result)

    @builtins.property
    def integration_codedeploy(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationCodedeploy"]:
        '''integration_codedeploy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_codedeploy ElastigroupAws#integration_codedeploy}
        '''
        result = self._values.get("integration_codedeploy")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationCodedeploy"], result)

    @builtins.property
    def integration_docker_swarm(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationDockerSwarm"]:
        '''integration_docker_swarm block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_docker_swarm ElastigroupAws#integration_docker_swarm}
        '''
        result = self._values.get("integration_docker_swarm")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationDockerSwarm"], result)

    @builtins.property
    def integration_ecs(self) -> typing.Optional["ElastigroupAwsIntegrationEcs"]:
        '''integration_ecs block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_ecs ElastigroupAws#integration_ecs}
        '''
        result = self._values.get("integration_ecs")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationEcs"], result)

    @builtins.property
    def integration_gitlab(self) -> typing.Optional["ElastigroupAwsIntegrationGitlab"]:
        '''integration_gitlab block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_gitlab ElastigroupAws#integration_gitlab}
        '''
        result = self._values.get("integration_gitlab")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationGitlab"], result)

    @builtins.property
    def integration_kubernetes(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationKubernetes"]:
        '''integration_kubernetes block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_kubernetes ElastigroupAws#integration_kubernetes}
        '''
        result = self._values.get("integration_kubernetes")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationKubernetes"], result)

    @builtins.property
    def integration_mesosphere(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationMesosphere"]:
        '''integration_mesosphere block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mesosphere ElastigroupAws#integration_mesosphere}
        '''
        result = self._values.get("integration_mesosphere")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationMesosphere"], result)

    @builtins.property
    def integration_multai_runtime(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"]:
        '''integration_multai_runtime block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_multai_runtime ElastigroupAws#integration_multai_runtime}
        '''
        result = self._values.get("integration_multai_runtime")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationMultaiRuntime"], result)

    @builtins.property
    def integration_nomad(self) -> typing.Optional["ElastigroupAwsIntegrationNomad"]:
        '''integration_nomad block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_nomad ElastigroupAws#integration_nomad}
        '''
        result = self._values.get("integration_nomad")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationNomad"], result)

    @builtins.property
    def integration_rancher(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationRancher"]:
        '''integration_rancher block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_rancher ElastigroupAws#integration_rancher}
        '''
        result = self._values.get("integration_rancher")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationRancher"], result)

    @builtins.property
    def integration_route53(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationRoute53"]:
        '''integration_route53 block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_route53 ElastigroupAws#integration_route53}
        '''
        result = self._values.get("integration_route53")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationRoute53"], result)

    @builtins.property
    def itf(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]]]:
        '''itf block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#itf ElastigroupAws#itf}
        '''
        result = self._values.get("itf")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItf"]]], result)

    @builtins.property
    def key_name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key_name ElastigroupAws#key_name}.'''
        result = self._values.get("key_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifetime_period(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#lifetime_period ElastigroupAws#lifetime_period}.'''
        result = self._values.get("lifetime_period")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_size ElastigroupAws#max_size}.'''
        result = self._values.get("max_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def metadata_options(self) -> typing.Optional["ElastigroupAwsMetadataOptions"]:
        '''metadata_options block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metadata_options ElastigroupAws#metadata_options}
        '''
        result = self._values.get("metadata_options")
        return typing.cast(typing.Optional["ElastigroupAwsMetadataOptions"], result)

    @builtins.property
    def minimum_instance_lifetime(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum_instance_lifetime ElastigroupAws#minimum_instance_lifetime}.'''
        result = self._values.get("minimum_instance_lifetime")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_size ElastigroupAws#min_size}.'''
        result = self._values.get("min_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def multai_target_sets(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]]]:
        '''multai_target_sets block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multai_target_sets ElastigroupAws#multai_target_sets}
        '''
        result = self._values.get("multai_target_sets")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultaiTargetSets"]]], result)

    @builtins.property
    def multiple_metrics(self) -> typing.Optional["ElastigroupAwsMultipleMetrics"]:
        '''multiple_metrics block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#multiple_metrics ElastigroupAws#multiple_metrics}
        '''
        result = self._values.get("multiple_metrics")
        return typing.cast(typing.Optional["ElastigroupAwsMultipleMetrics"], result)

    @builtins.property
    def network_interface(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]]]:
        '''network_interface block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface ElastigroupAws#network_interface}
        '''
        result = self._values.get("network_interface")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsNetworkInterface"]]], result)

    @builtins.property
    def ondemand_count(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#ondemand_count ElastigroupAws#ondemand_count}.'''
        result = self._values.get("ondemand_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def persist_block_devices(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_block_devices ElastigroupAws#persist_block_devices}.'''
        result = self._values.get("persist_block_devices")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def persist_private_ip(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_private_ip ElastigroupAws#persist_private_ip}.'''
        result = self._values.get("persist_private_ip")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def persist_root_device(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#persist_root_device ElastigroupAws#persist_root_device}.'''
        result = self._values.get("persist_root_device")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def placement_tenancy(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#placement_tenancy ElastigroupAws#placement_tenancy}.'''
        result = self._values.get("placement_tenancy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def preferred_availability_zones(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#preferred_availability_zones ElastigroupAws#preferred_availability_zones}.'''
        result = self._values.get("preferred_availability_zones")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def private_ips(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ips ElastigroupAws#private_ips}.'''
        result = self._values.get("private_ips")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#region ElastigroupAws#region}.'''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_tag_specification(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]]]:
        '''resource_tag_specification block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#resource_tag_specification ElastigroupAws#resource_tag_specification}
        '''
        result = self._values.get("resource_tag_specification")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsResourceTagSpecification"]]], result)

    @builtins.property
    def revert_to_spot(self) -> typing.Optional["ElastigroupAwsRevertToSpot"]:
        '''revert_to_spot block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#revert_to_spot ElastigroupAws#revert_to_spot}
        '''
        result = self._values.get("revert_to_spot")
        return typing.cast(typing.Optional["ElastigroupAwsRevertToSpot"], result)

    @builtins.property
    def scaling_down_policy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]]]:
        '''scaling_down_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_down_policy ElastigroupAws#scaling_down_policy}
        '''
        result = self._values.get("scaling_down_policy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicy"]]], result)

    @builtins.property
    def scaling_strategy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]]]:
        '''scaling_strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_strategy ElastigroupAws#scaling_strategy}
        '''
        result = self._values.get("scaling_strategy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingStrategy"]]], result)

    @builtins.property
    def scaling_target_policy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]]]:
        '''scaling_target_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_target_policy ElastigroupAws#scaling_target_policy}
        '''
        result = self._values.get("scaling_target_policy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicy"]]], result)

    @builtins.property
    def scaling_up_policy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]]]:
        '''scaling_up_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scaling_up_policy ElastigroupAws#scaling_up_policy}
        '''
        result = self._values.get("scaling_up_policy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicy"]]], result)

    @builtins.property
    def scheduled_task(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]]]:
        '''scheduled_task block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scheduled_task ElastigroupAws#scheduled_task}
        '''
        result = self._values.get("scheduled_task")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScheduledTask"]]], result)

    @builtins.property
    def shutdown_script(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#shutdown_script ElastigroupAws#shutdown_script}.'''
        result = self._values.get("shutdown_script")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def signal(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]]]:
        '''signal block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#signal ElastigroupAws#signal}
        '''
        result = self._values.get("signal")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSignal"]]], result)

    @builtins.property
    def spot_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spot_percentage ElastigroupAws#spot_percentage}.'''
        result = self._values.get("spot_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def stateful_deallocation(
        self,
    ) -> typing.Optional["ElastigroupAwsStatefulDeallocation"]:
        '''stateful_deallocation block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_deallocation ElastigroupAws#stateful_deallocation}
        '''
        result = self._values.get("stateful_deallocation")
        return typing.cast(typing.Optional["ElastigroupAwsStatefulDeallocation"], result)

    @builtins.property
    def stateful_instance_action(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]]]:
        '''stateful_instance_action block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_action ElastigroupAws#stateful_instance_action}
        '''
        result = self._values.get("stateful_instance_action")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsStatefulInstanceAction"]]], result)

    @builtins.property
    def subnet_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#subnet_ids ElastigroupAws#subnet_ids}.'''
        result = self._values.get("subnet_ids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def tags(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]]]:
        '''tags block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsTags"]]], result)

    @builtins.property
    def target_group_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_arns ElastigroupAws#target_group_arns}.'''
        result = self._values.get("target_group_arns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def update_policy(self) -> typing.Optional["ElastigroupAwsUpdatePolicy"]:
        '''update_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_policy ElastigroupAws#update_policy}
        '''
        result = self._values.get("update_policy")
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicy"], result)

    @builtins.property
    def user_data(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#user_data ElastigroupAws#user_data}.'''
        result = self._values.get("user_data")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def utilize_commitments(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_commitments ElastigroupAws#utilize_commitments}.'''
        result = self._values.get("utilize_commitments")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def utilize_reserved_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#utilize_reserved_instances ElastigroupAws#utilize_reserved_instances}.'''
        result = self._values.get("utilize_reserved_instances")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def wait_for_capacity(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity ElastigroupAws#wait_for_capacity}.'''
        result = self._values.get("wait_for_capacity")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def wait_for_capacity_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_capacity_timeout ElastigroupAws#wait_for_capacity_timeout}.'''
        result = self._values.get("wait_for_capacity_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsCpuOptions",
    jsii_struct_bases=[],
    name_mapping={"threads_per_core": "threadsPerCore"},
)
class ElastigroupAwsCpuOptions:
    def __init__(self, *, threads_per_core: jsii.Number) -> None:
        '''
        :param threads_per_core: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threads_per_core ElastigroupAws#threads_per_core}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "threads_per_core": threads_per_core,
        }

    @builtins.property
    def threads_per_core(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threads_per_core ElastigroupAws#threads_per_core}.'''
        result = self._values.get("threads_per_core")
        assert result is not None, "Required property 'threads_per_core' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsCpuOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsCpuOptionsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsCpuOptionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="threadsPerCoreInput")
    def threads_per_core_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "threadsPerCoreInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="threadsPerCore")
    def threads_per_core(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "threadsPerCore"))

    @threads_per_core.setter
    def threads_per_core(self, value: jsii.Number) -> None:
        jsii.set(self, "threadsPerCore", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsCpuOptions]:
        return typing.cast(typing.Optional[ElastigroupAwsCpuOptions], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAwsCpuOptions]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsEbsBlockDevice",
    jsii_struct_bases=[],
    name_mapping={
        "device_name": "deviceName",
        "delete_on_termination": "deleteOnTermination",
        "encrypted": "encrypted",
        "iops": "iops",
        "kms_key_id": "kmsKeyId",
        "snapshot_id": "snapshotId",
        "throughput": "throughput",
        "volume_size": "volumeSize",
        "volume_type": "volumeType",
    },
)
class ElastigroupAwsEbsBlockDevice:
    def __init__(
        self,
        *,
        device_name: builtins.str,
        delete_on_termination: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        encrypted: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        iops: typing.Optional[jsii.Number] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        snapshot_id: typing.Optional[builtins.str] = None,
        throughput: typing.Optional[jsii.Number] = None,
        volume_size: typing.Optional[jsii.Number] = None,
        volume_type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param device_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}.
        :param delete_on_termination: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}.
        :param encrypted: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#encrypted ElastigroupAws#encrypted}.
        :param iops: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iops ElastigroupAws#iops}.
        :param kms_key_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#kms_key_id ElastigroupAws#kms_key_id}.
        :param snapshot_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#snapshot_id ElastigroupAws#snapshot_id}.
        :param throughput: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#throughput ElastigroupAws#throughput}.
        :param volume_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_size ElastigroupAws#volume_size}.
        :param volume_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_type ElastigroupAws#volume_type}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "device_name": device_name,
        }
        if delete_on_termination is not None:
            self._values["delete_on_termination"] = delete_on_termination
        if encrypted is not None:
            self._values["encrypted"] = encrypted
        if iops is not None:
            self._values["iops"] = iops
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if snapshot_id is not None:
            self._values["snapshot_id"] = snapshot_id
        if throughput is not None:
            self._values["throughput"] = throughput
        if volume_size is not None:
            self._values["volume_size"] = volume_size
        if volume_type is not None:
            self._values["volume_type"] = volume_type

    @builtins.property
    def device_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}.'''
        result = self._values.get("device_name")
        assert result is not None, "Required property 'device_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def delete_on_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}.'''
        result = self._values.get("delete_on_termination")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def encrypted(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#encrypted ElastigroupAws#encrypted}.'''
        result = self._values.get("encrypted")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def iops(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#iops ElastigroupAws#iops}.'''
        result = self._values.get("iops")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#kms_key_id ElastigroupAws#kms_key_id}.'''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def snapshot_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#snapshot_id ElastigroupAws#snapshot_id}.'''
        result = self._values.get("snapshot_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def throughput(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#throughput ElastigroupAws#throughput}.'''
        result = self._values.get("throughput")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def volume_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_size ElastigroupAws#volume_size}.'''
        result = self._values.get("volume_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def volume_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#volume_type ElastigroupAws#volume_type}.'''
        result = self._values.get("volume_type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsEbsBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsEphemeralBlockDevice",
    jsii_struct_bases=[],
    name_mapping={"device_name": "deviceName", "virtual_name": "virtualName"},
)
class ElastigroupAwsEphemeralBlockDevice:
    def __init__(
        self,
        *,
        device_name: builtins.str,
        virtual_name: builtins.str,
    ) -> None:
        '''
        :param device_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}.
        :param virtual_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#virtual_name ElastigroupAws#virtual_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "device_name": device_name,
            "virtual_name": virtual_name,
        }

    @builtins.property
    def device_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_name ElastigroupAws#device_name}.'''
        result = self._values.get("device_name")
        assert result is not None, "Required property 'device_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def virtual_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#virtual_name ElastigroupAws#virtual_name}.'''
        result = self._values.get("virtual_name")
        assert result is not None, "Required property 'virtual_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsEphemeralBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsInstanceTypesWeights",
    jsii_struct_bases=[],
    name_mapping={"instance_type": "instanceType", "weight": "weight"},
)
class ElastigroupAwsInstanceTypesWeights:
    def __init__(self, *, instance_type: builtins.str, weight: jsii.Number) -> None:
        '''
        :param instance_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_type ElastigroupAws#instance_type}.
        :param weight: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight ElastigroupAws#weight}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "instance_type": instance_type,
            "weight": weight,
        }

    @builtins.property
    def instance_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#instance_type ElastigroupAws#instance_type}.'''
        result = self._values.get("instance_type")
        assert result is not None, "Required property 'instance_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight ElastigroupAws#weight}.'''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsInstanceTypesWeights(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalk",
    jsii_struct_bases=[],
    name_mapping={
        "deployment_preferences": "deploymentPreferences",
        "environment_id": "environmentId",
        "managed_actions": "managedActions",
    },
)
class ElastigroupAwsIntegrationBeanstalk:
    def __init__(
        self,
        *,
        deployment_preferences: typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferences"] = None,
        environment_id: typing.Optional[builtins.str] = None,
        managed_actions: typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActions"] = None,
    ) -> None:
        '''
        :param deployment_preferences: deployment_preferences block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_preferences ElastigroupAws#deployment_preferences}
        :param environment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#environment_id ElastigroupAws#environment_id}.
        :param managed_actions: managed_actions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#managed_actions ElastigroupAws#managed_actions}
        '''
        if isinstance(deployment_preferences, dict):
            deployment_preferences = ElastigroupAwsIntegrationBeanstalkDeploymentPreferences(**deployment_preferences)
        if isinstance(managed_actions, dict):
            managed_actions = ElastigroupAwsIntegrationBeanstalkManagedActions(**managed_actions)
        self._values: typing.Dict[str, typing.Any] = {}
        if deployment_preferences is not None:
            self._values["deployment_preferences"] = deployment_preferences
        if environment_id is not None:
            self._values["environment_id"] = environment_id
        if managed_actions is not None:
            self._values["managed_actions"] = managed_actions

    @builtins.property
    def deployment_preferences(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferences"]:
        '''deployment_preferences block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_preferences ElastigroupAws#deployment_preferences}
        '''
        result = self._values.get("deployment_preferences")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferences"], result)

    @builtins.property
    def environment_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#environment_id ElastigroupAws#environment_id}.'''
        result = self._values.get("environment_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def managed_actions(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActions"]:
        '''managed_actions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#managed_actions ElastigroupAws#managed_actions}
        '''
        result = self._values.get("managed_actions")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationBeanstalk(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkDeploymentPreferences",
    jsii_struct_bases=[],
    name_mapping={
        "automatic_roll": "automaticRoll",
        "batch_size_percentage": "batchSizePercentage",
        "grace_period": "gracePeriod",
        "strategy": "strategy",
    },
)
class ElastigroupAwsIntegrationBeanstalkDeploymentPreferences:
    def __init__(
        self,
        *,
        automatic_roll: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch_size_percentage: typing.Optional[jsii.Number] = None,
        grace_period: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy"] = None,
    ) -> None:
        '''
        :param automatic_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#automatic_roll ElastigroupAws#automatic_roll}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        '''
        if isinstance(strategy, dict):
            strategy = ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy(**strategy)
        self._values: typing.Dict[str, typing.Any] = {}
        if automatic_roll is not None:
            self._values["automatic_roll"] = automatic_roll
        if batch_size_percentage is not None:
            self._values["batch_size_percentage"] = batch_size_percentage
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def automatic_roll(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#automatic_roll ElastigroupAws#automatic_roll}.'''
        result = self._values.get("automatic_roll")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def batch_size_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy"]:
        '''strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationBeanstalkDeploymentPreferences(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putStrategy")
    def put_strategy(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        should_drain_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.
        :param should_drain_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.
        '''
        value = ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy(
            action=action, should_drain_instances=should_drain_instances
        )

        return typing.cast(None, jsii.invoke(self, "putStrategy", [value]))

    @jsii.member(jsii_name="resetAutomaticRoll")
    def reset_automatic_roll(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutomaticRoll", []))

    @jsii.member(jsii_name="resetBatchSizePercentage")
    def reset_batch_size_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBatchSizePercentage", []))

    @jsii.member(jsii_name="resetGracePeriod")
    def reset_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGracePeriod", []))

    @jsii.member(jsii_name="resetStrategy")
    def reset_strategy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStrategy", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def strategy(
        self,
    ) -> "ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference":
        return typing.cast("ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference", jsii.get(self, "strategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="automaticRollInput")
    def automatic_roll_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "automaticRollInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentageInput")
    def batch_size_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchSizePercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriodInput")
    def grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "gracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategyInput")
    def strategy_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy"], jsii.get(self, "strategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="automaticRoll")
    def automatic_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "automaticRoll"))

    @automatic_roll.setter
    def automatic_roll(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "automaticRoll", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentage")
    def batch_size_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchSizePercentage"))

    @batch_size_percentage.setter
    def batch_size_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "batchSizePercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriod")
    def grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "gracePeriod"))

    @grace_period.setter
    def grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "gracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferences]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferences], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferences],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "should_drain_instances": "shouldDrainInstances",
    },
)
class ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        should_drain_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.
        :param should_drain_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if should_drain_instances is not None:
            self._values["should_drain_instances"] = should_drain_instances

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.'''
        result = self._values.get("action")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def should_drain_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.'''
        result = self._values.get("should_drain_instances")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAction")
    def reset_action(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAction", []))

    @jsii.member(jsii_name="resetShouldDrainInstances")
    def reset_should_drain_instances(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDrainInstances", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="actionInput")
    def action_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "actionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDrainInstancesInput")
    def should_drain_instances_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDrainInstancesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="action")
    def action(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "action"))

    @action.setter
    def action(self, value: builtins.str) -> None:
        jsii.set(self, "action", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDrainInstances")
    def should_drain_instances(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDrainInstances"))

    @should_drain_instances.setter
    def should_drain_instances(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDrainInstances", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkManagedActions",
    jsii_struct_bases=[],
    name_mapping={"platform_update": "platformUpdate"},
)
class ElastigroupAwsIntegrationBeanstalkManagedActions:
    def __init__(
        self,
        *,
        platform_update: typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate"] = None,
    ) -> None:
        '''
        :param platform_update: platform_update block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#platform_update ElastigroupAws#platform_update}
        '''
        if isinstance(platform_update, dict):
            platform_update = ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate(**platform_update)
        self._values: typing.Dict[str, typing.Any] = {}
        if platform_update is not None:
            self._values["platform_update"] = platform_update

    @builtins.property
    def platform_update(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate"]:
        '''platform_update block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#platform_update ElastigroupAws#platform_update}
        '''
        result = self._values.get("platform_update")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationBeanstalkManagedActions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putPlatformUpdate")
    def put_platform_update(
        self,
        *,
        perform_at: typing.Optional[builtins.str] = None,
        time_window: typing.Optional[builtins.str] = None,
        update_level: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.
        :param time_window: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_window ElastigroupAws#time_window}.
        :param update_level: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_level ElastigroupAws#update_level}.
        '''
        value = ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate(
            perform_at=perform_at, time_window=time_window, update_level=update_level
        )

        return typing.cast(None, jsii.invoke(self, "putPlatformUpdate", [value]))

    @jsii.member(jsii_name="resetPlatformUpdate")
    def reset_platform_update(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPlatformUpdate", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="platformUpdate")
    def platform_update(
        self,
    ) -> "ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference":
        return typing.cast("ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference", jsii.get(self, "platformUpdate"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="platformUpdateInput")
    def platform_update_input(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate"], jsii.get(self, "platformUpdateInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActions]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActions], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActions],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate",
    jsii_struct_bases=[],
    name_mapping={
        "perform_at": "performAt",
        "time_window": "timeWindow",
        "update_level": "updateLevel",
    },
)
class ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate:
    def __init__(
        self,
        *,
        perform_at: typing.Optional[builtins.str] = None,
        time_window: typing.Optional[builtins.str] = None,
        update_level: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.
        :param time_window: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_window ElastigroupAws#time_window}.
        :param update_level: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_level ElastigroupAws#update_level}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if perform_at is not None:
            self._values["perform_at"] = perform_at
        if time_window is not None:
            self._values["time_window"] = time_window
        if update_level is not None:
            self._values["update_level"] = update_level

    @builtins.property
    def perform_at(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.'''
        result = self._values.get("perform_at")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def time_window(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_window ElastigroupAws#time_window}.'''
        result = self._values.get("time_window")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_level(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#update_level ElastigroupAws#update_level}.'''
        result = self._values.get("update_level")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdateOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPerformAt")
    def reset_perform_at(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPerformAt", []))

    @jsii.member(jsii_name="resetTimeWindow")
    def reset_time_window(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeWindow", []))

    @jsii.member(jsii_name="resetUpdateLevel")
    def reset_update_level(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdateLevel", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAtInput")
    def perform_at_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "performAtInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindowInput")
    def time_window_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "timeWindowInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updateLevelInput")
    def update_level_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "updateLevelInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAt")
    def perform_at(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "performAt"))

    @perform_at.setter
    def perform_at(self, value: builtins.str) -> None:
        jsii.set(self, "performAt", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindow")
    def time_window(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "timeWindow"))

    @time_window.setter
    def time_window(self, value: builtins.str) -> None:
        jsii.set(self, "timeWindow", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updateLevel")
    def update_level(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "updateLevel"))

    @update_level.setter
    def update_level(self, value: builtins.str) -> None:
        jsii.set(self, "updateLevel", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAwsIntegrationBeanstalkOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationBeanstalkOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putDeploymentPreferences")
    def put_deployment_preferences(
        self,
        *,
        automatic_roll: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch_size_percentage: typing.Optional[jsii.Number] = None,
        grace_period: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesStrategy] = None,
    ) -> None:
        '''
        :param automatic_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#automatic_roll ElastigroupAws#automatic_roll}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        '''
        value = ElastigroupAwsIntegrationBeanstalkDeploymentPreferences(
            automatic_roll=automatic_roll,
            batch_size_percentage=batch_size_percentage,
            grace_period=grace_period,
            strategy=strategy,
        )

        return typing.cast(None, jsii.invoke(self, "putDeploymentPreferences", [value]))

    @jsii.member(jsii_name="putManagedActions")
    def put_managed_actions(
        self,
        *,
        platform_update: typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActionsPlatformUpdate] = None,
    ) -> None:
        '''
        :param platform_update: platform_update block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#platform_update ElastigroupAws#platform_update}
        '''
        value = ElastigroupAwsIntegrationBeanstalkManagedActions(
            platform_update=platform_update
        )

        return typing.cast(None, jsii.invoke(self, "putManagedActions", [value]))

    @jsii.member(jsii_name="resetDeploymentPreferences")
    def reset_deployment_preferences(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDeploymentPreferences", []))

    @jsii.member(jsii_name="resetEnvironmentId")
    def reset_environment_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnvironmentId", []))

    @jsii.member(jsii_name="resetManagedActions")
    def reset_managed_actions(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManagedActions", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentPreferences")
    def deployment_preferences(
        self,
    ) -> ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference:
        return typing.cast(ElastigroupAwsIntegrationBeanstalkDeploymentPreferencesOutputReference, jsii.get(self, "deploymentPreferences"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedActions")
    def managed_actions(
        self,
    ) -> ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference:
        return typing.cast(ElastigroupAwsIntegrationBeanstalkManagedActionsOutputReference, jsii.get(self, "managedActions"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentPreferencesInput")
    def deployment_preferences_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferences]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkDeploymentPreferences], jsii.get(self, "deploymentPreferencesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="environmentIdInput")
    def environment_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "environmentIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedActionsInput")
    def managed_actions_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActions]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalkManagedActions], jsii.get(self, "managedActionsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="environmentId")
    def environment_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "environmentId"))

    @environment_id.setter
    def environment_id(self, value: builtins.str) -> None:
        jsii.set(self, "environmentId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationBeanstalk]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationBeanstalk], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationBeanstalk],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeploy",
    jsii_struct_bases=[],
    name_mapping={
        "cleanup_on_failure": "cleanupOnFailure",
        "deployment_groups": "deploymentGroups",
        "terminate_instance_on_failure": "terminateInstanceOnFailure",
    },
)
class ElastigroupAwsIntegrationCodedeploy:
    def __init__(
        self,
        *,
        cleanup_on_failure: typing.Union[builtins.bool, cdktf.IResolvable],
        deployment_groups: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationCodedeployDeploymentGroups"]],
        terminate_instance_on_failure: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        '''
        :param cleanup_on_failure: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cleanup_on_failure ElastigroupAws#cleanup_on_failure}.
        :param deployment_groups: deployment_groups block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_groups ElastigroupAws#deployment_groups}
        :param terminate_instance_on_failure: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_instance_on_failure ElastigroupAws#terminate_instance_on_failure}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "cleanup_on_failure": cleanup_on_failure,
            "deployment_groups": deployment_groups,
            "terminate_instance_on_failure": terminate_instance_on_failure,
        }

    @builtins.property
    def cleanup_on_failure(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cleanup_on_failure ElastigroupAws#cleanup_on_failure}.'''
        result = self._values.get("cleanup_on_failure")
        assert result is not None, "Required property 'cleanup_on_failure' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def deployment_groups(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationCodedeployDeploymentGroups"]]:
        '''deployment_groups block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_groups ElastigroupAws#deployment_groups}
        '''
        result = self._values.get("deployment_groups")
        assert result is not None, "Required property 'deployment_groups' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationCodedeployDeploymentGroups"]], result)

    @builtins.property
    def terminate_instance_on_failure(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_instance_on_failure ElastigroupAws#terminate_instance_on_failure}.'''
        result = self._values.get("terminate_instance_on_failure")
        assert result is not None, "Required property 'terminate_instance_on_failure' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationCodedeploy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeployDeploymentGroups",
    jsii_struct_bases=[],
    name_mapping={
        "application_name": "applicationName",
        "deployment_group_name": "deploymentGroupName",
    },
)
class ElastigroupAwsIntegrationCodedeployDeploymentGroups:
    def __init__(
        self,
        *,
        application_name: builtins.str,
        deployment_group_name: builtins.str,
    ) -> None:
        '''
        :param application_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#application_name ElastigroupAws#application_name}.
        :param deployment_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_group_name ElastigroupAws#deployment_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "application_name": application_name,
            "deployment_group_name": deployment_group_name,
        }

    @builtins.property
    def application_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#application_name ElastigroupAws#application_name}.'''
        result = self._values.get("application_name")
        assert result is not None, "Required property 'application_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def deployment_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_group_name ElastigroupAws#deployment_group_name}.'''
        result = self._values.get("deployment_group_name")
        assert result is not None, "Required property 'deployment_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationCodedeployDeploymentGroups(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationCodedeployOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationCodedeployOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cleanupOnFailureInput")
    def cleanup_on_failure_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "cleanupOnFailureInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentGroupsInput")
    def deployment_groups_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationCodedeployDeploymentGroups]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationCodedeployDeploymentGroups]]], jsii.get(self, "deploymentGroupsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="terminateInstanceOnFailureInput")
    def terminate_instance_on_failure_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "terminateInstanceOnFailureInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cleanupOnFailure")
    def cleanup_on_failure(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "cleanupOnFailure"))

    @cleanup_on_failure.setter
    def cleanup_on_failure(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "cleanupOnFailure", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentGroups")
    def deployment_groups(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationCodedeployDeploymentGroups]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationCodedeployDeploymentGroups]], jsii.get(self, "deploymentGroups"))

    @deployment_groups.setter
    def deployment_groups(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationCodedeployDeploymentGroups]],
    ) -> None:
        jsii.set(self, "deploymentGroups", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "terminateInstanceOnFailure"))

    @terminate_instance_on_failure.setter
    def terminate_instance_on_failure(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "terminateInstanceOnFailure", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationCodedeploy]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationCodedeploy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationCodedeploy],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarm",
    jsii_struct_bases=[],
    name_mapping={
        "master_host": "masterHost",
        "master_port": "masterPort",
        "autoscale_cooldown": "autoscaleCooldown",
        "autoscale_down": "autoscaleDown",
        "autoscale_headroom": "autoscaleHeadroom",
        "autoscale_is_enabled": "autoscaleIsEnabled",
    },
)
class ElastigroupAwsIntegrationDockerSwarm:
    def __init__(
        self,
        *,
        master_host: builtins.str,
        master_port: jsii.Number,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom"] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param master_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        '''
        if isinstance(autoscale_down, dict):
            autoscale_down = ElastigroupAwsIntegrationDockerSwarmAutoscaleDown(**autoscale_down)
        if isinstance(autoscale_headroom, dict):
            autoscale_headroom = ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom(**autoscale_headroom)
        self._values: typing.Dict[str, typing.Any] = {
            "master_host": master_host,
            "master_port": master_port,
        }
        if autoscale_cooldown is not None:
            self._values["autoscale_cooldown"] = autoscale_cooldown
        if autoscale_down is not None:
            self._values["autoscale_down"] = autoscale_down
        if autoscale_headroom is not None:
            self._values["autoscale_headroom"] = autoscale_headroom
        if autoscale_is_enabled is not None:
            self._values["autoscale_is_enabled"] = autoscale_is_enabled

    @builtins.property
    def master_host(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.'''
        result = self._values.get("master_host")
        assert result is not None, "Required property 'master_host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def master_port(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.'''
        result = self._values.get("master_port")
        assert result is not None, "Required property 'master_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def autoscale_cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.'''
        result = self._values.get("autoscale_cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def autoscale_down(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleDown"]:
        '''autoscale_down block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        '''
        result = self._values.get("autoscale_down")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleDown"], result)

    @builtins.property
    def autoscale_headroom(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom"]:
        '''autoscale_headroom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        '''
        result = self._values.get("autoscale_headroom")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom"], result)

    @builtins.property
    def autoscale_is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.'''
        result = self._values.get("autoscale_is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationDockerSwarm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmAutoscaleDown",
    jsii_struct_bases=[],
    name_mapping={
        "evaluation_periods": "evaluationPeriods",
        "max_scale_down_percentage": "maxScaleDownPercentage",
    },
)
class ElastigroupAwsIntegrationDockerSwarmAutoscaleDown:
    def __init__(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        max_scale_down_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param max_scale_down_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if max_scale_down_percentage is not None:
            self._values["max_scale_down_percentage"] = max_scale_down_percentage

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_scale_down_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.'''
        result = self._values.get("max_scale_down_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationDockerSwarmAutoscaleDown(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetEvaluationPeriods")
    def reset_evaluation_periods(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEvaluationPeriods", []))

    @jsii.member(jsii_name="resetMaxScaleDownPercentage")
    def reset_max_scale_down_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxScaleDownPercentage", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriodsInput")
    def evaluation_periods_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "evaluationPeriodsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxScaleDownPercentageInput")
    def max_scale_down_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxScaleDownPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriods")
    def evaluation_periods(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "evaluationPeriods"))

    @evaluation_periods.setter
    def evaluation_periods(self, value: jsii.Number) -> None:
        jsii.set(self, "evaluationPeriods", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxScaleDownPercentage"))

    @max_scale_down_percentage.setter
    def max_scale_down_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "maxScaleDownPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleDown], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleDown],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_per_unit": "cpuPerUnit",
        "memory_per_unit": "memoryPerUnit",
        "num_of_units": "numOfUnits",
    },
)
class ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom:
    def __init__(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cpu_per_unit is not None:
            self._values["cpu_per_unit"] = cpu_per_unit
        if memory_per_unit is not None:
            self._values["memory_per_unit"] = memory_per_unit
        if num_of_units is not None:
            self._values["num_of_units"] = num_of_units

    @builtins.property
    def cpu_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.'''
        result = self._values.get("cpu_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def memory_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.'''
        result = self._values.get("memory_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def num_of_units(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.'''
        result = self._values.get("num_of_units")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCpuPerUnit")
    def reset_cpu_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuPerUnit", []))

    @jsii.member(jsii_name="resetMemoryPerUnit")
    def reset_memory_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMemoryPerUnit", []))

    @jsii.member(jsii_name="resetNumOfUnits")
    def reset_num_of_units(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNumOfUnits", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnitInput")
    def cpu_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "cpuPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnitInput")
    def memory_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "memoryPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnitsInput")
    def num_of_units_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "numOfUnitsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnit")
    def cpu_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "cpuPerUnit"))

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "cpuPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnit")
    def memory_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "memoryPerUnit"))

    @memory_per_unit.setter
    def memory_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "memoryPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnits")
    def num_of_units(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "numOfUnits"))

    @num_of_units.setter
    def num_of_units(self, value: jsii.Number) -> None:
        jsii.set(self, "numOfUnits", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAwsIntegrationDockerSwarmOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationDockerSwarmOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putAutoscaleDown")
    def put_autoscale_down(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        max_scale_down_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param max_scale_down_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.
        '''
        value = ElastigroupAwsIntegrationDockerSwarmAutoscaleDown(
            evaluation_periods=evaluation_periods,
            max_scale_down_percentage=max_scale_down_percentage,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleDown", [value]))

    @jsii.member(jsii_name="putAutoscaleHeadroom")
    def put_autoscale_headroom(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        value = ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom(
            cpu_per_unit=cpu_per_unit,
            memory_per_unit=memory_per_unit,
            num_of_units=num_of_units,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleHeadroom", [value]))

    @jsii.member(jsii_name="resetAutoscaleCooldown")
    def reset_autoscale_cooldown(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleCooldown", []))

    @jsii.member(jsii_name="resetAutoscaleDown")
    def reset_autoscale_down(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleDown", []))

    @jsii.member(jsii_name="resetAutoscaleHeadroom")
    def reset_autoscale_headroom(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleHeadroom", []))

    @jsii.member(jsii_name="resetAutoscaleIsEnabled")
    def reset_autoscale_is_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsEnabled", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDown")
    def autoscale_down(
        self,
    ) -> ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference:
        return typing.cast(ElastigroupAwsIntegrationDockerSwarmAutoscaleDownOutputReference, jsii.get(self, "autoscaleDown"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroom")
    def autoscale_headroom(
        self,
    ) -> ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference:
        return typing.cast(ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroomOutputReference, jsii.get(self, "autoscaleHeadroom"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldownInput")
    def autoscale_cooldown_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "autoscaleCooldownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDownInput")
    def autoscale_down_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleDown], jsii.get(self, "autoscaleDownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroomInput")
    def autoscale_headroom_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationDockerSwarmAutoscaleHeadroom], jsii.get(self, "autoscaleHeadroomInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabledInput")
    def autoscale_is_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsEnabledInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHostInput")
    def master_host_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "masterHostInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterPortInput")
    def master_port_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "masterPortInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldown")
    def autoscale_cooldown(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "autoscaleCooldown"))

    @autoscale_cooldown.setter
    def autoscale_cooldown(self, value: jsii.Number) -> None:
        jsii.set(self, "autoscaleCooldown", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsEnabled"))

    @autoscale_is_enabled.setter
    def autoscale_is_enabled(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsEnabled", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHost")
    def master_host(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "masterHost"))

    @master_host.setter
    def master_host(self, value: builtins.str) -> None:
        jsii.set(self, "masterHost", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterPort")
    def master_port(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "masterPort"))

    @master_port.setter
    def master_port(self, value: jsii.Number) -> None:
        jsii.set(self, "masterPort", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationDockerSwarm]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationDockerSwarm], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationDockerSwarm],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcs",
    jsii_struct_bases=[],
    name_mapping={
        "cluster_name": "clusterName",
        "autoscale_attributes": "autoscaleAttributes",
        "autoscale_cooldown": "autoscaleCooldown",
        "autoscale_down": "autoscaleDown",
        "autoscale_headroom": "autoscaleHeadroom",
        "autoscale_is_auto_config": "autoscaleIsAutoConfig",
        "autoscale_is_enabled": "autoscaleIsEnabled",
        "autoscale_scale_down_non_service_tasks": "autoscaleScaleDownNonServiceTasks",
        "batch": "batch",
    },
)
class ElastigroupAwsIntegrationEcs:
    def __init__(
        self,
        *,
        cluster_name: builtins.str,
        autoscale_attributes: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationEcsAutoscaleAttributes"]]] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleHeadroom"] = None,
        autoscale_is_auto_config: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_scale_down_non_service_tasks: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        batch: typing.Optional["ElastigroupAwsIntegrationEcsBatch"] = None,
    ) -> None:
        '''
        :param cluster_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_name ElastigroupAws#cluster_name}.
        :param autoscale_attributes: autoscale_attributes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_attributes ElastigroupAws#autoscale_attributes}
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_auto_config: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        :param autoscale_scale_down_non_service_tasks: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_scale_down_non_service_tasks ElastigroupAws#autoscale_scale_down_non_service_tasks}.
        :param batch: batch block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch ElastigroupAws#batch}
        '''
        if isinstance(autoscale_down, dict):
            autoscale_down = ElastigroupAwsIntegrationEcsAutoscaleDown(**autoscale_down)
        if isinstance(autoscale_headroom, dict):
            autoscale_headroom = ElastigroupAwsIntegrationEcsAutoscaleHeadroom(**autoscale_headroom)
        if isinstance(batch, dict):
            batch = ElastigroupAwsIntegrationEcsBatch(**batch)
        self._values: typing.Dict[str, typing.Any] = {
            "cluster_name": cluster_name,
        }
        if autoscale_attributes is not None:
            self._values["autoscale_attributes"] = autoscale_attributes
        if autoscale_cooldown is not None:
            self._values["autoscale_cooldown"] = autoscale_cooldown
        if autoscale_down is not None:
            self._values["autoscale_down"] = autoscale_down
        if autoscale_headroom is not None:
            self._values["autoscale_headroom"] = autoscale_headroom
        if autoscale_is_auto_config is not None:
            self._values["autoscale_is_auto_config"] = autoscale_is_auto_config
        if autoscale_is_enabled is not None:
            self._values["autoscale_is_enabled"] = autoscale_is_enabled
        if autoscale_scale_down_non_service_tasks is not None:
            self._values["autoscale_scale_down_non_service_tasks"] = autoscale_scale_down_non_service_tasks
        if batch is not None:
            self._values["batch"] = batch

    @builtins.property
    def cluster_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_name ElastigroupAws#cluster_name}.'''
        result = self._values.get("cluster_name")
        assert result is not None, "Required property 'cluster_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def autoscale_attributes(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationEcsAutoscaleAttributes"]]]:
        '''autoscale_attributes block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_attributes ElastigroupAws#autoscale_attributes}
        '''
        result = self._values.get("autoscale_attributes")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationEcsAutoscaleAttributes"]]], result)

    @builtins.property
    def autoscale_cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.'''
        result = self._values.get("autoscale_cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def autoscale_down(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleDown"]:
        '''autoscale_down block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        '''
        result = self._values.get("autoscale_down")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleDown"], result)

    @builtins.property
    def autoscale_headroom(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleHeadroom"]:
        '''autoscale_headroom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        '''
        result = self._values.get("autoscale_headroom")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationEcsAutoscaleHeadroom"], result)

    @builtins.property
    def autoscale_is_auto_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.'''
        result = self._values.get("autoscale_is_auto_config")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def autoscale_is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.'''
        result = self._values.get("autoscale_is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def autoscale_scale_down_non_service_tasks(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_scale_down_non_service_tasks ElastigroupAws#autoscale_scale_down_non_service_tasks}.'''
        result = self._values.get("autoscale_scale_down_non_service_tasks")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def batch(self) -> typing.Optional["ElastigroupAwsIntegrationEcsBatch"]:
        '''batch block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch ElastigroupAws#batch}
        '''
        result = self._values.get("batch")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationEcsBatch"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationEcs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsAutoscaleAttributes",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class ElastigroupAwsIntegrationEcsAutoscaleAttributes:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationEcsAutoscaleAttributes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsAutoscaleDown",
    jsii_struct_bases=[],
    name_mapping={
        "evaluation_periods": "evaluationPeriods",
        "max_scale_down_percentage": "maxScaleDownPercentage",
    },
)
class ElastigroupAwsIntegrationEcsAutoscaleDown:
    def __init__(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        max_scale_down_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param max_scale_down_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if max_scale_down_percentage is not None:
            self._values["max_scale_down_percentage"] = max_scale_down_percentage

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_scale_down_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.'''
        result = self._values.get("max_scale_down_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationEcsAutoscaleDown(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetEvaluationPeriods")
    def reset_evaluation_periods(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEvaluationPeriods", []))

    @jsii.member(jsii_name="resetMaxScaleDownPercentage")
    def reset_max_scale_down_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxScaleDownPercentage", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriodsInput")
    def evaluation_periods_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "evaluationPeriodsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxScaleDownPercentageInput")
    def max_scale_down_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxScaleDownPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriods")
    def evaluation_periods(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "evaluationPeriods"))

    @evaluation_periods.setter
    def evaluation_periods(self, value: jsii.Number) -> None:
        jsii.set(self, "evaluationPeriods", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxScaleDownPercentage"))

    @max_scale_down_percentage.setter
    def max_scale_down_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "maxScaleDownPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleDown], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleDown],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsAutoscaleHeadroom",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_per_unit": "cpuPerUnit",
        "memory_per_unit": "memoryPerUnit",
        "num_of_units": "numOfUnits",
    },
)
class ElastigroupAwsIntegrationEcsAutoscaleHeadroom:
    def __init__(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cpu_per_unit is not None:
            self._values["cpu_per_unit"] = cpu_per_unit
        if memory_per_unit is not None:
            self._values["memory_per_unit"] = memory_per_unit
        if num_of_units is not None:
            self._values["num_of_units"] = num_of_units

    @builtins.property
    def cpu_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.'''
        result = self._values.get("cpu_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def memory_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.'''
        result = self._values.get("memory_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def num_of_units(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.'''
        result = self._values.get("num_of_units")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationEcsAutoscaleHeadroom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCpuPerUnit")
    def reset_cpu_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuPerUnit", []))

    @jsii.member(jsii_name="resetMemoryPerUnit")
    def reset_memory_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMemoryPerUnit", []))

    @jsii.member(jsii_name="resetNumOfUnits")
    def reset_num_of_units(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNumOfUnits", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnitInput")
    def cpu_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "cpuPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnitInput")
    def memory_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "memoryPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnitsInput")
    def num_of_units_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "numOfUnitsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnit")
    def cpu_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "cpuPerUnit"))

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "cpuPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnit")
    def memory_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "memoryPerUnit"))

    @memory_per_unit.setter
    def memory_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "memoryPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnits")
    def num_of_units(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "numOfUnits"))

    @num_of_units.setter
    def num_of_units(self, value: jsii.Number) -> None:
        jsii.set(self, "numOfUnits", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleHeadroom], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleHeadroom],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsBatch",
    jsii_struct_bases=[],
    name_mapping={"job_queue_names": "jobQueueNames"},
)
class ElastigroupAwsIntegrationEcsBatch:
    def __init__(self, *, job_queue_names: typing.Sequence[builtins.str]) -> None:
        '''
        :param job_queue_names: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#job_queue_names ElastigroupAws#job_queue_names}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "job_queue_names": job_queue_names,
        }

    @builtins.property
    def job_queue_names(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#job_queue_names ElastigroupAws#job_queue_names}.'''
        result = self._values.get("job_queue_names")
        assert result is not None, "Required property 'job_queue_names' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationEcsBatch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationEcsBatchOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsBatchOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="jobQueueNamesInput")
    def job_queue_names_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "jobQueueNamesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="jobQueueNames")
    def job_queue_names(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "jobQueueNames"))

    @job_queue_names.setter
    def job_queue_names(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "jobQueueNames", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationEcsBatch]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsBatch], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationEcsBatch],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAwsIntegrationEcsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationEcsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putAutoscaleDown")
    def put_autoscale_down(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        max_scale_down_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param max_scale_down_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_scale_down_percentage ElastigroupAws#max_scale_down_percentage}.
        '''
        value = ElastigroupAwsIntegrationEcsAutoscaleDown(
            evaluation_periods=evaluation_periods,
            max_scale_down_percentage=max_scale_down_percentage,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleDown", [value]))

    @jsii.member(jsii_name="putAutoscaleHeadroom")
    def put_autoscale_headroom(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        value = ElastigroupAwsIntegrationEcsAutoscaleHeadroom(
            cpu_per_unit=cpu_per_unit,
            memory_per_unit=memory_per_unit,
            num_of_units=num_of_units,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleHeadroom", [value]))

    @jsii.member(jsii_name="putBatch")
    def put_batch(self, *, job_queue_names: typing.Sequence[builtins.str]) -> None:
        '''
        :param job_queue_names: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#job_queue_names ElastigroupAws#job_queue_names}.
        '''
        value = ElastigroupAwsIntegrationEcsBatch(job_queue_names=job_queue_names)

        return typing.cast(None, jsii.invoke(self, "putBatch", [value]))

    @jsii.member(jsii_name="resetAutoscaleAttributes")
    def reset_autoscale_attributes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleAttributes", []))

    @jsii.member(jsii_name="resetAutoscaleCooldown")
    def reset_autoscale_cooldown(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleCooldown", []))

    @jsii.member(jsii_name="resetAutoscaleDown")
    def reset_autoscale_down(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleDown", []))

    @jsii.member(jsii_name="resetAutoscaleHeadroom")
    def reset_autoscale_headroom(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleHeadroom", []))

    @jsii.member(jsii_name="resetAutoscaleIsAutoConfig")
    def reset_autoscale_is_auto_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsAutoConfig", []))

    @jsii.member(jsii_name="resetAutoscaleIsEnabled")
    def reset_autoscale_is_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsEnabled", []))

    @jsii.member(jsii_name="resetAutoscaleScaleDownNonServiceTasks")
    def reset_autoscale_scale_down_non_service_tasks(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleScaleDownNonServiceTasks", []))

    @jsii.member(jsii_name="resetBatch")
    def reset_batch(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBatch", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDown")
    def autoscale_down(
        self,
    ) -> ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference:
        return typing.cast(ElastigroupAwsIntegrationEcsAutoscaleDownOutputReference, jsii.get(self, "autoscaleDown"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroom")
    def autoscale_headroom(
        self,
    ) -> ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference:
        return typing.cast(ElastigroupAwsIntegrationEcsAutoscaleHeadroomOutputReference, jsii.get(self, "autoscaleHeadroom"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batch")
    def batch(self) -> ElastigroupAwsIntegrationEcsBatchOutputReference:
        return typing.cast(ElastigroupAwsIntegrationEcsBatchOutputReference, jsii.get(self, "batch"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleAttributesInput")
    def autoscale_attributes_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationEcsAutoscaleAttributes]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationEcsAutoscaleAttributes]]], jsii.get(self, "autoscaleAttributesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldownInput")
    def autoscale_cooldown_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "autoscaleCooldownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDownInput")
    def autoscale_down_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleDown], jsii.get(self, "autoscaleDownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroomInput")
    def autoscale_headroom_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsAutoscaleHeadroom], jsii.get(self, "autoscaleHeadroomInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsAutoConfigInput")
    def autoscale_is_auto_config_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsAutoConfigInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabledInput")
    def autoscale_is_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsEnabledInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleScaleDownNonServiceTasksInput")
    def autoscale_scale_down_non_service_tasks_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleScaleDownNonServiceTasksInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchInput")
    def batch_input(self) -> typing.Optional[ElastigroupAwsIntegrationEcsBatch]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcsBatch], jsii.get(self, "batchInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterNameInput")
    def cluster_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleAttributes")
    def autoscale_attributes(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationEcsAutoscaleAttributes]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationEcsAutoscaleAttributes]], jsii.get(self, "autoscaleAttributes"))

    @autoscale_attributes.setter
    def autoscale_attributes(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationEcsAutoscaleAttributes]],
    ) -> None:
        jsii.set(self, "autoscaleAttributes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldown")
    def autoscale_cooldown(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "autoscaleCooldown"))

    @autoscale_cooldown.setter
    def autoscale_cooldown(self, value: jsii.Number) -> None:
        jsii.set(self, "autoscaleCooldown", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsAutoConfig"))

    @autoscale_is_auto_config.setter
    def autoscale_is_auto_config(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsAutoConfig", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsEnabled"))

    @autoscale_is_enabled.setter
    def autoscale_is_enabled(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsEnabled", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleScaleDownNonServiceTasks")
    def autoscale_scale_down_non_service_tasks(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleScaleDownNonServiceTasks"))

    @autoscale_scale_down_non_service_tasks.setter
    def autoscale_scale_down_non_service_tasks(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleScaleDownNonServiceTasks", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterName")
    def cluster_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "clusterName"))

    @cluster_name.setter
    def cluster_name(self, value: builtins.str) -> None:
        jsii.set(self, "clusterName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationEcs]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationEcs], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationEcs],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlab",
    jsii_struct_bases=[],
    name_mapping={"runner": "runner"},
)
class ElastigroupAwsIntegrationGitlab:
    def __init__(
        self,
        *,
        runner: typing.Optional["ElastigroupAwsIntegrationGitlabRunner"] = None,
    ) -> None:
        '''
        :param runner: runner block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#runner ElastigroupAws#runner}
        '''
        if isinstance(runner, dict):
            runner = ElastigroupAwsIntegrationGitlabRunner(**runner)
        self._values: typing.Dict[str, typing.Any] = {}
        if runner is not None:
            self._values["runner"] = runner

    @builtins.property
    def runner(self) -> typing.Optional["ElastigroupAwsIntegrationGitlabRunner"]:
        '''runner block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#runner ElastigroupAws#runner}
        '''
        result = self._values.get("runner")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationGitlabRunner"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationGitlab(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationGitlabOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlabOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putRunner")
    def put_runner(
        self,
        *,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.
        '''
        value = ElastigroupAwsIntegrationGitlabRunner(is_enabled=is_enabled)

        return typing.cast(None, jsii.invoke(self, "putRunner", [value]))

    @jsii.member(jsii_name="resetRunner")
    def reset_runner(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRunner", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="runner")
    def runner(self) -> "ElastigroupAwsIntegrationGitlabRunnerOutputReference":
        return typing.cast("ElastigroupAwsIntegrationGitlabRunnerOutputReference", jsii.get(self, "runner"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="runnerInput")
    def runner_input(self) -> typing.Optional["ElastigroupAwsIntegrationGitlabRunner"]:
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationGitlabRunner"], jsii.get(self, "runnerInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationGitlab]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationGitlab], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationGitlab],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlabRunner",
    jsii_struct_bases=[],
    name_mapping={"is_enabled": "isEnabled"},
)
class ElastigroupAwsIntegrationGitlabRunner:
    def __init__(
        self,
        *,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationGitlabRunner(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationGitlabRunnerOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationGitlabRunnerOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetIsEnabled")
    def reset_is_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsEnabled", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isEnabledInput")
    def is_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "isEnabledInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="isEnabled")
    def is_enabled(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "isEnabled"))

    @is_enabled.setter
    def is_enabled(self, value: typing.Union[builtins.bool, cdktf.IResolvable]) -> None:
        jsii.set(self, "isEnabled", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationGitlabRunner]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationGitlabRunner], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationGitlabRunner],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetes",
    jsii_struct_bases=[],
    name_mapping={
        "api_server": "apiServer",
        "autoscale_cooldown": "autoscaleCooldown",
        "autoscale_down": "autoscaleDown",
        "autoscale_headroom": "autoscaleHeadroom",
        "autoscale_is_auto_config": "autoscaleIsAutoConfig",
        "autoscale_is_enabled": "autoscaleIsEnabled",
        "autoscale_labels": "autoscaleLabels",
        "cluster_identifier": "clusterIdentifier",
        "integration_mode": "integrationMode",
        "token": "token",
    },
)
class ElastigroupAwsIntegrationKubernetes:
    def __init__(
        self,
        *,
        api_server: typing.Optional[builtins.str] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom"] = None,
        autoscale_is_auto_config: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_labels: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationKubernetesAutoscaleLabels"]]] = None,
        cluster_identifier: typing.Optional[builtins.str] = None,
        integration_mode: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param api_server: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_auto_config: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        :param autoscale_labels: autoscale_labels block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_labels ElastigroupAws#autoscale_labels}
        :param cluster_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_identifier ElastigroupAws#cluster_identifier}.
        :param integration_mode: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mode ElastigroupAws#integration_mode}.
        :param token: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#token ElastigroupAws#token}.
        '''
        if isinstance(autoscale_down, dict):
            autoscale_down = ElastigroupAwsIntegrationKubernetesAutoscaleDown(**autoscale_down)
        if isinstance(autoscale_headroom, dict):
            autoscale_headroom = ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom(**autoscale_headroom)
        self._values: typing.Dict[str, typing.Any] = {}
        if api_server is not None:
            self._values["api_server"] = api_server
        if autoscale_cooldown is not None:
            self._values["autoscale_cooldown"] = autoscale_cooldown
        if autoscale_down is not None:
            self._values["autoscale_down"] = autoscale_down
        if autoscale_headroom is not None:
            self._values["autoscale_headroom"] = autoscale_headroom
        if autoscale_is_auto_config is not None:
            self._values["autoscale_is_auto_config"] = autoscale_is_auto_config
        if autoscale_is_enabled is not None:
            self._values["autoscale_is_enabled"] = autoscale_is_enabled
        if autoscale_labels is not None:
            self._values["autoscale_labels"] = autoscale_labels
        if cluster_identifier is not None:
            self._values["cluster_identifier"] = cluster_identifier
        if integration_mode is not None:
            self._values["integration_mode"] = integration_mode
        if token is not None:
            self._values["token"] = token

    @builtins.property
    def api_server(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.'''
        result = self._values.get("api_server")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def autoscale_cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.'''
        result = self._values.get("autoscale_cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def autoscale_down(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleDown"]:
        '''autoscale_down block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        '''
        result = self._values.get("autoscale_down")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleDown"], result)

    @builtins.property
    def autoscale_headroom(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom"]:
        '''autoscale_headroom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        '''
        result = self._values.get("autoscale_headroom")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom"], result)

    @builtins.property
    def autoscale_is_auto_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_auto_config ElastigroupAws#autoscale_is_auto_config}.'''
        result = self._values.get("autoscale_is_auto_config")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def autoscale_is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.'''
        result = self._values.get("autoscale_is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def autoscale_labels(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationKubernetesAutoscaleLabels"]]]:
        '''autoscale_labels block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_labels ElastigroupAws#autoscale_labels}
        '''
        result = self._values.get("autoscale_labels")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationKubernetesAutoscaleLabels"]]], result)

    @builtins.property
    def cluster_identifier(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cluster_identifier ElastigroupAws#cluster_identifier}.'''
        result = self._values.get("cluster_identifier")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def integration_mode(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#integration_mode ElastigroupAws#integration_mode}.'''
        result = self._values.get("integration_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#token ElastigroupAws#token}.'''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationKubernetes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesAutoscaleDown",
    jsii_struct_bases=[],
    name_mapping={"evaluation_periods": "evaluationPeriods"},
)
class ElastigroupAwsIntegrationKubernetesAutoscaleDown:
    def __init__(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationKubernetesAutoscaleDown(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetEvaluationPeriods")
    def reset_evaluation_periods(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEvaluationPeriods", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriodsInput")
    def evaluation_periods_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "evaluationPeriodsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriods")
    def evaluation_periods(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "evaluationPeriods"))

    @evaluation_periods.setter
    def evaluation_periods(self, value: jsii.Number) -> None:
        jsii.set(self, "evaluationPeriods", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleDown], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleDown],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_per_unit": "cpuPerUnit",
        "memory_per_unit": "memoryPerUnit",
        "num_of_units": "numOfUnits",
    },
)
class ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom:
    def __init__(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cpu_per_unit is not None:
            self._values["cpu_per_unit"] = cpu_per_unit
        if memory_per_unit is not None:
            self._values["memory_per_unit"] = memory_per_unit
        if num_of_units is not None:
            self._values["num_of_units"] = num_of_units

    @builtins.property
    def cpu_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.'''
        result = self._values.get("cpu_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def memory_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.'''
        result = self._values.get("memory_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def num_of_units(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.'''
        result = self._values.get("num_of_units")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCpuPerUnit")
    def reset_cpu_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuPerUnit", []))

    @jsii.member(jsii_name="resetMemoryPerUnit")
    def reset_memory_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMemoryPerUnit", []))

    @jsii.member(jsii_name="resetNumOfUnits")
    def reset_num_of_units(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNumOfUnits", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnitInput")
    def cpu_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "cpuPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnitInput")
    def memory_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "memoryPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnitsInput")
    def num_of_units_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "numOfUnitsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnit")
    def cpu_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "cpuPerUnit"))

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "cpuPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnit")
    def memory_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "memoryPerUnit"))

    @memory_per_unit.setter
    def memory_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "memoryPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnits")
    def num_of_units(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "numOfUnits"))

    @num_of_units.setter
    def num_of_units(self, value: jsii.Number) -> None:
        jsii.set(self, "numOfUnits", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesAutoscaleLabels",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class ElastigroupAwsIntegrationKubernetesAutoscaleLabels:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationKubernetesAutoscaleLabels(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationKubernetesOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationKubernetesOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putAutoscaleDown")
    def put_autoscale_down(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        '''
        value = ElastigroupAwsIntegrationKubernetesAutoscaleDown(
            evaluation_periods=evaluation_periods
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleDown", [value]))

    @jsii.member(jsii_name="putAutoscaleHeadroom")
    def put_autoscale_headroom(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        value = ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom(
            cpu_per_unit=cpu_per_unit,
            memory_per_unit=memory_per_unit,
            num_of_units=num_of_units,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleHeadroom", [value]))

    @jsii.member(jsii_name="resetApiServer")
    def reset_api_server(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApiServer", []))

    @jsii.member(jsii_name="resetAutoscaleCooldown")
    def reset_autoscale_cooldown(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleCooldown", []))

    @jsii.member(jsii_name="resetAutoscaleDown")
    def reset_autoscale_down(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleDown", []))

    @jsii.member(jsii_name="resetAutoscaleHeadroom")
    def reset_autoscale_headroom(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleHeadroom", []))

    @jsii.member(jsii_name="resetAutoscaleIsAutoConfig")
    def reset_autoscale_is_auto_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsAutoConfig", []))

    @jsii.member(jsii_name="resetAutoscaleIsEnabled")
    def reset_autoscale_is_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsEnabled", []))

    @jsii.member(jsii_name="resetAutoscaleLabels")
    def reset_autoscale_labels(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleLabels", []))

    @jsii.member(jsii_name="resetClusterIdentifier")
    def reset_cluster_identifier(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetClusterIdentifier", []))

    @jsii.member(jsii_name="resetIntegrationMode")
    def reset_integration_mode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationMode", []))

    @jsii.member(jsii_name="resetToken")
    def reset_token(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetToken", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDown")
    def autoscale_down(
        self,
    ) -> ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference:
        return typing.cast(ElastigroupAwsIntegrationKubernetesAutoscaleDownOutputReference, jsii.get(self, "autoscaleDown"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroom")
    def autoscale_headroom(
        self,
    ) -> ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference:
        return typing.cast(ElastigroupAwsIntegrationKubernetesAutoscaleHeadroomOutputReference, jsii.get(self, "autoscaleHeadroom"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="apiServerInput")
    def api_server_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiServerInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldownInput")
    def autoscale_cooldown_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "autoscaleCooldownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDownInput")
    def autoscale_down_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleDown], jsii.get(self, "autoscaleDownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroomInput")
    def autoscale_headroom_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationKubernetesAutoscaleHeadroom], jsii.get(self, "autoscaleHeadroomInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsAutoConfigInput")
    def autoscale_is_auto_config_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsAutoConfigInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabledInput")
    def autoscale_is_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsEnabledInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleLabelsInput")
    def autoscale_labels_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationKubernetesAutoscaleLabels]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationKubernetesAutoscaleLabels]]], jsii.get(self, "autoscaleLabelsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterIdentifierInput")
    def cluster_identifier_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterIdentifierInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationModeInput")
    def integration_mode_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "integrationModeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tokenInput")
    def token_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tokenInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="apiServer")
    def api_server(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "apiServer"))

    @api_server.setter
    def api_server(self, value: builtins.str) -> None:
        jsii.set(self, "apiServer", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldown")
    def autoscale_cooldown(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "autoscaleCooldown"))

    @autoscale_cooldown.setter
    def autoscale_cooldown(self, value: jsii.Number) -> None:
        jsii.set(self, "autoscaleCooldown", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsAutoConfig"))

    @autoscale_is_auto_config.setter
    def autoscale_is_auto_config(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsAutoConfig", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsEnabled"))

    @autoscale_is_enabled.setter
    def autoscale_is_enabled(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsEnabled", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleLabels")
    def autoscale_labels(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationKubernetesAutoscaleLabels]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationKubernetesAutoscaleLabels]], jsii.get(self, "autoscaleLabels"))

    @autoscale_labels.setter
    def autoscale_labels(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationKubernetesAutoscaleLabels]],
    ) -> None:
        jsii.set(self, "autoscaleLabels", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterIdentifier")
    def cluster_identifier(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "clusterIdentifier"))

    @cluster_identifier.setter
    def cluster_identifier(self, value: builtins.str) -> None:
        jsii.set(self, "clusterIdentifier", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMode")
    def integration_mode(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "integrationMode"))

    @integration_mode.setter
    def integration_mode(self, value: builtins.str) -> None:
        jsii.set(self, "integrationMode", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="token")
    def token(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "token"))

    @token.setter
    def token(self, value: builtins.str) -> None:
        jsii.set(self, "token", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationKubernetes]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationKubernetes], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationKubernetes],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphere",
    jsii_struct_bases=[],
    name_mapping={"api_server": "apiServer"},
)
class ElastigroupAwsIntegrationMesosphere:
    def __init__(self, *, api_server: builtins.str) -> None:
        '''
        :param api_server: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "api_server": api_server,
        }

    @builtins.property
    def api_server(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#api_server ElastigroupAws#api_server}.'''
        result = self._values.get("api_server")
        assert result is not None, "Required property 'api_server' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationMesosphere(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationMesosphereOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationMesosphereOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="apiServerInput")
    def api_server_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiServerInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="apiServer")
    def api_server(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "apiServer"))

    @api_server.setter
    def api_server(self, value: builtins.str) -> None:
        jsii.set(self, "apiServer", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationMesosphere]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationMesosphere], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationMesosphere],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntime",
    jsii_struct_bases=[],
    name_mapping={"deployment_id": "deploymentId"},
)
class ElastigroupAwsIntegrationMultaiRuntime:
    def __init__(self, *, deployment_id: builtins.str) -> None:
        '''
        :param deployment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_id ElastigroupAws#deployment_id}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "deployment_id": deployment_id,
        }

    @builtins.property
    def deployment_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#deployment_id ElastigroupAws#deployment_id}.'''
        result = self._values.get("deployment_id")
        assert result is not None, "Required property 'deployment_id' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationMultaiRuntime(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationMultaiRuntimeOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationMultaiRuntimeOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentIdInput")
    def deployment_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "deploymentIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "deploymentId"))

    @deployment_id.setter
    def deployment_id(self, value: builtins.str) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationMultaiRuntime]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationMultaiRuntime], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationMultaiRuntime],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomad",
    jsii_struct_bases=[],
    name_mapping={
        "master_host": "masterHost",
        "master_port": "masterPort",
        "acl_token": "aclToken",
        "autoscale_constraints": "autoscaleConstraints",
        "autoscale_cooldown": "autoscaleCooldown",
        "autoscale_down": "autoscaleDown",
        "autoscale_headroom": "autoscaleHeadroom",
        "autoscale_is_enabled": "autoscaleIsEnabled",
    },
)
class ElastigroupAwsIntegrationNomad:
    def __init__(
        self,
        *,
        master_host: builtins.str,
        master_port: jsii.Number,
        acl_token: typing.Optional[builtins.str] = None,
        autoscale_constraints: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationNomadAutoscaleConstraints"]]] = None,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleHeadroom"] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param master_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.
        :param acl_token: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#acl_token ElastigroupAws#acl_token}.
        :param autoscale_constraints: autoscale_constraints block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_constraints ElastigroupAws#autoscale_constraints}
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.
        '''
        if isinstance(autoscale_down, dict):
            autoscale_down = ElastigroupAwsIntegrationNomadAutoscaleDown(**autoscale_down)
        if isinstance(autoscale_headroom, dict):
            autoscale_headroom = ElastigroupAwsIntegrationNomadAutoscaleHeadroom(**autoscale_headroom)
        self._values: typing.Dict[str, typing.Any] = {
            "master_host": master_host,
            "master_port": master_port,
        }
        if acl_token is not None:
            self._values["acl_token"] = acl_token
        if autoscale_constraints is not None:
            self._values["autoscale_constraints"] = autoscale_constraints
        if autoscale_cooldown is not None:
            self._values["autoscale_cooldown"] = autoscale_cooldown
        if autoscale_down is not None:
            self._values["autoscale_down"] = autoscale_down
        if autoscale_headroom is not None:
            self._values["autoscale_headroom"] = autoscale_headroom
        if autoscale_is_enabled is not None:
            self._values["autoscale_is_enabled"] = autoscale_is_enabled

    @builtins.property
    def master_host(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.'''
        result = self._values.get("master_host")
        assert result is not None, "Required property 'master_host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def master_port(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_port ElastigroupAws#master_port}.'''
        result = self._values.get("master_port")
        assert result is not None, "Required property 'master_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def acl_token(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#acl_token ElastigroupAws#acl_token}.'''
        result = self._values.get("acl_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def autoscale_constraints(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationNomadAutoscaleConstraints"]]]:
        '''autoscale_constraints block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_constraints ElastigroupAws#autoscale_constraints}
        '''
        result = self._values.get("autoscale_constraints")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationNomadAutoscaleConstraints"]]], result)

    @builtins.property
    def autoscale_cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_cooldown ElastigroupAws#autoscale_cooldown}.'''
        result = self._values.get("autoscale_cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def autoscale_down(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleDown"]:
        '''autoscale_down block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_down ElastigroupAws#autoscale_down}
        '''
        result = self._values.get("autoscale_down")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleDown"], result)

    @builtins.property
    def autoscale_headroom(
        self,
    ) -> typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleHeadroom"]:
        '''autoscale_headroom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_headroom ElastigroupAws#autoscale_headroom}
        '''
        result = self._values.get("autoscale_headroom")
        return typing.cast(typing.Optional["ElastigroupAwsIntegrationNomadAutoscaleHeadroom"], result)

    @builtins.property
    def autoscale_is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#autoscale_is_enabled ElastigroupAws#autoscale_is_enabled}.'''
        result = self._values.get("autoscale_is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationNomad(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadAutoscaleConstraints",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class ElastigroupAwsIntegrationNomadAutoscaleConstraints:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationNomadAutoscaleConstraints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadAutoscaleDown",
    jsii_struct_bases=[],
    name_mapping={"evaluation_periods": "evaluationPeriods"},
)
class ElastigroupAwsIntegrationNomadAutoscaleDown:
    def __init__(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationNomadAutoscaleDown(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetEvaluationPeriods")
    def reset_evaluation_periods(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEvaluationPeriods", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriodsInput")
    def evaluation_periods_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "evaluationPeriodsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="evaluationPeriods")
    def evaluation_periods(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "evaluationPeriods"))

    @evaluation_periods.setter
    def evaluation_periods(self, value: jsii.Number) -> None:
        jsii.set(self, "evaluationPeriods", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleDown], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleDown],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadAutoscaleHeadroom",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_per_unit": "cpuPerUnit",
        "memory_per_unit": "memoryPerUnit",
        "num_of_units": "numOfUnits",
    },
)
class ElastigroupAwsIntegrationNomadAutoscaleHeadroom:
    def __init__(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cpu_per_unit is not None:
            self._values["cpu_per_unit"] = cpu_per_unit
        if memory_per_unit is not None:
            self._values["memory_per_unit"] = memory_per_unit
        if num_of_units is not None:
            self._values["num_of_units"] = num_of_units

    @builtins.property
    def cpu_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.'''
        result = self._values.get("cpu_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def memory_per_unit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.'''
        result = self._values.get("memory_per_unit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def num_of_units(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.'''
        result = self._values.get("num_of_units")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationNomadAutoscaleHeadroom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCpuPerUnit")
    def reset_cpu_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCpuPerUnit", []))

    @jsii.member(jsii_name="resetMemoryPerUnit")
    def reset_memory_per_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMemoryPerUnit", []))

    @jsii.member(jsii_name="resetNumOfUnits")
    def reset_num_of_units(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNumOfUnits", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnitInput")
    def cpu_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "cpuPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnitInput")
    def memory_per_unit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "memoryPerUnitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnitsInput")
    def num_of_units_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "numOfUnitsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cpuPerUnit")
    def cpu_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "cpuPerUnit"))

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "cpuPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="memoryPerUnit")
    def memory_per_unit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "memoryPerUnit"))

    @memory_per_unit.setter
    def memory_per_unit(self, value: jsii.Number) -> None:
        jsii.set(self, "memoryPerUnit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="numOfUnits")
    def num_of_units(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "numOfUnits"))

    @num_of_units.setter
    def num_of_units(self, value: jsii.Number) -> None:
        jsii.set(self, "numOfUnits", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleHeadroom], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleHeadroom],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAwsIntegrationNomadOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationNomadOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putAutoscaleDown")
    def put_autoscale_down(
        self,
        *,
        evaluation_periods: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        '''
        value = ElastigroupAwsIntegrationNomadAutoscaleDown(
            evaluation_periods=evaluation_periods
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleDown", [value]))

    @jsii.member(jsii_name="putAutoscaleHeadroom")
    def put_autoscale_headroom(
        self,
        *,
        cpu_per_unit: typing.Optional[jsii.Number] = None,
        memory_per_unit: typing.Optional[jsii.Number] = None,
        num_of_units: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param cpu_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cpu_per_unit ElastigroupAws#cpu_per_unit}.
        :param memory_per_unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#memory_per_unit ElastigroupAws#memory_per_unit}.
        :param num_of_units: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#num_of_units ElastigroupAws#num_of_units}.
        '''
        value = ElastigroupAwsIntegrationNomadAutoscaleHeadroom(
            cpu_per_unit=cpu_per_unit,
            memory_per_unit=memory_per_unit,
            num_of_units=num_of_units,
        )

        return typing.cast(None, jsii.invoke(self, "putAutoscaleHeadroom", [value]))

    @jsii.member(jsii_name="resetAclToken")
    def reset_acl_token(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAclToken", []))

    @jsii.member(jsii_name="resetAutoscaleConstraints")
    def reset_autoscale_constraints(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleConstraints", []))

    @jsii.member(jsii_name="resetAutoscaleCooldown")
    def reset_autoscale_cooldown(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleCooldown", []))

    @jsii.member(jsii_name="resetAutoscaleDown")
    def reset_autoscale_down(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleDown", []))

    @jsii.member(jsii_name="resetAutoscaleHeadroom")
    def reset_autoscale_headroom(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleHeadroom", []))

    @jsii.member(jsii_name="resetAutoscaleIsEnabled")
    def reset_autoscale_is_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoscaleIsEnabled", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDown")
    def autoscale_down(
        self,
    ) -> ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference:
        return typing.cast(ElastigroupAwsIntegrationNomadAutoscaleDownOutputReference, jsii.get(self, "autoscaleDown"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroom")
    def autoscale_headroom(
        self,
    ) -> ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference:
        return typing.cast(ElastigroupAwsIntegrationNomadAutoscaleHeadroomOutputReference, jsii.get(self, "autoscaleHeadroom"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aclTokenInput")
    def acl_token_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aclTokenInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleConstraintsInput")
    def autoscale_constraints_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationNomadAutoscaleConstraints]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationNomadAutoscaleConstraints]]], jsii.get(self, "autoscaleConstraintsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldownInput")
    def autoscale_cooldown_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "autoscaleCooldownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleDownInput")
    def autoscale_down_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleDown]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleDown], jsii.get(self, "autoscaleDownInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleHeadroomInput")
    def autoscale_headroom_input(
        self,
    ) -> typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleHeadroom]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationNomadAutoscaleHeadroom], jsii.get(self, "autoscaleHeadroomInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabledInput")
    def autoscale_is_enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoscaleIsEnabledInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHostInput")
    def master_host_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "masterHostInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterPortInput")
    def master_port_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "masterPortInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="aclToken")
    def acl_token(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aclToken"))

    @acl_token.setter
    def acl_token(self, value: builtins.str) -> None:
        jsii.set(self, "aclToken", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleConstraints")
    def autoscale_constraints(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationNomadAutoscaleConstraints]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationNomadAutoscaleConstraints]], jsii.get(self, "autoscaleConstraints"))

    @autoscale_constraints.setter
    def autoscale_constraints(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationNomadAutoscaleConstraints]],
    ) -> None:
        jsii.set(self, "autoscaleConstraints", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleCooldown")
    def autoscale_cooldown(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "autoscaleCooldown"))

    @autoscale_cooldown.setter
    def autoscale_cooldown(self, value: jsii.Number) -> None:
        jsii.set(self, "autoscaleCooldown", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoscaleIsEnabled"))

    @autoscale_is_enabled.setter
    def autoscale_is_enabled(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoscaleIsEnabled", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHost")
    def master_host(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "masterHost"))

    @master_host.setter
    def master_host(self, value: builtins.str) -> None:
        jsii.set(self, "masterHost", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterPort")
    def master_port(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "masterPort"))

    @master_port.setter
    def master_port(self, value: jsii.Number) -> None:
        jsii.set(self, "masterPort", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationNomad]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationNomad], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationNomad],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancher",
    jsii_struct_bases=[],
    name_mapping={
        "access_key": "accessKey",
        "master_host": "masterHost",
        "secret_key": "secretKey",
        "version": "version",
    },
)
class ElastigroupAwsIntegrationRancher:
    def __init__(
        self,
        *,
        access_key: builtins.str,
        master_host: builtins.str,
        secret_key: builtins.str,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#access_key ElastigroupAws#access_key}.
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.
        :param secret_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secret_key ElastigroupAws#secret_key}.
        :param version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#version ElastigroupAws#version}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "access_key": access_key,
            "master_host": master_host,
            "secret_key": secret_key,
        }
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def access_key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#access_key ElastigroupAws#access_key}.'''
        result = self._values.get("access_key")
        assert result is not None, "Required property 'access_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def master_host(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#master_host ElastigroupAws#master_host}.'''
        result = self._values.get("master_host")
        assert result is not None, "Required property 'master_host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def secret_key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secret_key ElastigroupAws#secret_key}.'''
        result = self._values.get("secret_key")
        assert result is not None, "Required property 'secret_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#version ElastigroupAws#version}.'''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationRancher(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationRancherOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRancherOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetVersion")
    def reset_version(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetVersion", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="accessKeyInput")
    def access_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "accessKeyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHostInput")
    def master_host_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "masterHostInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="secretKeyInput")
    def secret_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "secretKeyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="versionInput")
    def version_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "versionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="accessKey")
    def access_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "accessKey"))

    @access_key.setter
    def access_key(self, value: builtins.str) -> None:
        jsii.set(self, "accessKey", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="masterHost")
    def master_host(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "masterHost"))

    @master_host.setter
    def master_host(self, value: builtins.str) -> None:
        jsii.set(self, "masterHost", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="secretKey")
    def secret_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "secretKey"))

    @secret_key.setter
    def secret_key(self, value: builtins.str) -> None:
        jsii.set(self, "secretKey", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "version"))

    @version.setter
    def version(self, value: builtins.str) -> None:
        jsii.set(self, "version", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationRancher]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationRancher], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationRancher],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53",
    jsii_struct_bases=[],
    name_mapping={"domains": "domains"},
)
class ElastigroupAwsIntegrationRoute53:
    def __init__(
        self,
        *,
        domains: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationRoute53Domains"]],
    ) -> None:
        '''
        :param domains: domains block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#domains ElastigroupAws#domains}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "domains": domains,
        }

    @builtins.property
    def domains(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationRoute53Domains"]]:
        '''domains block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#domains ElastigroupAws#domains}
        '''
        result = self._values.get("domains")
        assert result is not None, "Required property 'domains' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationRoute53Domains"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationRoute53(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53Domains",
    jsii_struct_bases=[],
    name_mapping={
        "hosted_zone_id": "hostedZoneId",
        "record_sets": "recordSets",
        "record_set_type": "recordSetType",
        "spotinst_acct_id": "spotinstAcctId",
    },
)
class ElastigroupAwsIntegrationRoute53Domains:
    def __init__(
        self,
        *,
        hosted_zone_id: builtins.str,
        record_sets: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsIntegrationRoute53DomainsRecordSets"]],
        record_set_type: typing.Optional[builtins.str] = None,
        spotinst_acct_id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param hosted_zone_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#hosted_zone_id ElastigroupAws#hosted_zone_id}.
        :param record_sets: record_sets block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_sets ElastigroupAws#record_sets}
        :param record_set_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_set_type ElastigroupAws#record_set_type}.
        :param spotinst_acct_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spotinst_acct_id ElastigroupAws#spotinst_acct_id}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "hosted_zone_id": hosted_zone_id,
            "record_sets": record_sets,
        }
        if record_set_type is not None:
            self._values["record_set_type"] = record_set_type
        if spotinst_acct_id is not None:
            self._values["spotinst_acct_id"] = spotinst_acct_id

    @builtins.property
    def hosted_zone_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#hosted_zone_id ElastigroupAws#hosted_zone_id}.'''
        result = self._values.get("hosted_zone_id")
        assert result is not None, "Required property 'hosted_zone_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def record_sets(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationRoute53DomainsRecordSets"]]:
        '''record_sets block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_sets ElastigroupAws#record_sets}
        '''
        result = self._values.get("record_sets")
        assert result is not None, "Required property 'record_sets' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsIntegrationRoute53DomainsRecordSets"]], result)

    @builtins.property
    def record_set_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#record_set_type ElastigroupAws#record_set_type}.'''
        result = self._values.get("record_set_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def spotinst_acct_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#spotinst_acct_id ElastigroupAws#spotinst_acct_id}.'''
        result = self._values.get("spotinst_acct_id")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationRoute53Domains(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53DomainsRecordSets",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "use_public_dns": "usePublicDns",
        "use_public_ip": "usePublicIp",
    },
)
class ElastigroupAwsIntegrationRoute53DomainsRecordSets:
    def __init__(
        self,
        *,
        name: builtins.str,
        use_public_dns: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        use_public_ip: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param use_public_dns: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_dns ElastigroupAws#use_public_dns}.
        :param use_public_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_ip ElastigroupAws#use_public_ip}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if use_public_dns is not None:
            self._values["use_public_dns"] = use_public_dns
        if use_public_ip is not None:
            self._values["use_public_ip"] = use_public_ip

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def use_public_dns(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_dns ElastigroupAws#use_public_dns}.'''
        result = self._values.get("use_public_dns")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def use_public_ip(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#use_public_ip ElastigroupAws#use_public_ip}.'''
        result = self._values.get("use_public_ip")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsIntegrationRoute53DomainsRecordSets(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsIntegrationRoute53OutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsIntegrationRoute53OutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="domainsInput")
    def domains_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationRoute53Domains]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationRoute53Domains]]], jsii.get(self, "domainsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="domains")
    def domains(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationRoute53Domains]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationRoute53Domains]], jsii.get(self, "domains"))

    @domains.setter
    def domains(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsIntegrationRoute53Domains]],
    ) -> None:
        jsii.set(self, "domains", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsIntegrationRoute53]:
        return typing.cast(typing.Optional[ElastigroupAwsIntegrationRoute53], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsIntegrationRoute53],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItf",
    jsii_struct_bases=[],
    name_mapping={
        "fixed_target_groups": "fixedTargetGroups",
        "load_balancer": "loadBalancer",
        "target_group_config": "targetGroupConfig",
        "weight_strategy": "weightStrategy",
        "default_static_target_group": "defaultStaticTargetGroup",
        "migration_healthiness_threshold": "migrationHealthinessThreshold",
    },
)
class ElastigroupAwsItf:
    def __init__(
        self,
        *,
        fixed_target_groups: typing.Union[builtins.bool, cdktf.IResolvable],
        load_balancer: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItfLoadBalancer"]],
        target_group_config: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItfTargetGroupConfig"]],
        weight_strategy: builtins.str,
        default_static_target_group: typing.Optional["ElastigroupAwsItfDefaultStaticTargetGroup"] = None,
        migration_healthiness_threshold: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param fixed_target_groups: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fixed_target_groups ElastigroupAws#fixed_target_groups}.
        :param load_balancer: load_balancer block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer ElastigroupAws#load_balancer}
        :param target_group_config: target_group_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_config ElastigroupAws#target_group_config}
        :param weight_strategy: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight_strategy ElastigroupAws#weight_strategy}.
        :param default_static_target_group: default_static_target_group block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#default_static_target_group ElastigroupAws#default_static_target_group}
        :param migration_healthiness_threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#migration_healthiness_threshold ElastigroupAws#migration_healthiness_threshold}.
        '''
        if isinstance(default_static_target_group, dict):
            default_static_target_group = ElastigroupAwsItfDefaultStaticTargetGroup(**default_static_target_group)
        self._values: typing.Dict[str, typing.Any] = {
            "fixed_target_groups": fixed_target_groups,
            "load_balancer": load_balancer,
            "target_group_config": target_group_config,
            "weight_strategy": weight_strategy,
        }
        if default_static_target_group is not None:
            self._values["default_static_target_group"] = default_static_target_group
        if migration_healthiness_threshold is not None:
            self._values["migration_healthiness_threshold"] = migration_healthiness_threshold

    @builtins.property
    def fixed_target_groups(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#fixed_target_groups ElastigroupAws#fixed_target_groups}.'''
        result = self._values.get("fixed_target_groups")
        assert result is not None, "Required property 'fixed_target_groups' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def load_balancer(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfLoadBalancer"]]:
        '''load_balancer block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer ElastigroupAws#load_balancer}
        '''
        result = self._values.get("load_balancer")
        assert result is not None, "Required property 'load_balancer' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfLoadBalancer"]], result)

    @builtins.property
    def target_group_config(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfig"]]:
        '''target_group_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_group_config ElastigroupAws#target_group_config}
        '''
        result = self._values.get("target_group_config")
        assert result is not None, "Required property 'target_group_config' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfig"]], result)

    @builtins.property
    def weight_strategy(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#weight_strategy ElastigroupAws#weight_strategy}.'''
        result = self._values.get("weight_strategy")
        assert result is not None, "Required property 'weight_strategy' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def default_static_target_group(
        self,
    ) -> typing.Optional["ElastigroupAwsItfDefaultStaticTargetGroup"]:
        '''default_static_target_group block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#default_static_target_group ElastigroupAws#default_static_target_group}
        '''
        result = self._values.get("default_static_target_group")
        return typing.cast(typing.Optional["ElastigroupAwsItfDefaultStaticTargetGroup"], result)

    @builtins.property
    def migration_healthiness_threshold(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#migration_healthiness_threshold ElastigroupAws#migration_healthiness_threshold}.'''
        result = self._values.get("migration_healthiness_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItf(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfDefaultStaticTargetGroup",
    jsii_struct_bases=[],
    name_mapping={"arn": "arn", "percentage": "percentage"},
)
class ElastigroupAwsItfDefaultStaticTargetGroup:
    def __init__(self, *, arn: builtins.str, percentage: jsii.Number) -> None:
        '''
        :param arn: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}.
        :param percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "arn": arn,
            "percentage": percentage,
        }

    @builtins.property
    def arn(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}.'''
        result = self._values.get("arn")
        assert result is not None, "Required property 'arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def percentage(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}.'''
        result = self._values.get("percentage")
        assert result is not None, "Required property 'percentage' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfDefaultStaticTargetGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsItfDefaultStaticTargetGroupOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfDefaultStaticTargetGroupOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="arnInput")
    def arn_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "arnInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="percentageInput")
    def percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "percentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="arn")
    def arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "arn"))

    @arn.setter
    def arn(self, value: builtins.str) -> None:
        jsii.set(self, "arn", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="percentage")
    def percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "percentage"))

    @percentage.setter
    def percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "percentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsItfDefaultStaticTargetGroup]:
        return typing.cast(typing.Optional[ElastigroupAwsItfDefaultStaticTargetGroup], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsItfDefaultStaticTargetGroup],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfLoadBalancer",
    jsii_struct_bases=[],
    name_mapping={
        "listener_rule": "listenerRule",
        "load_balancer_arn": "loadBalancerArn",
    },
)
class ElastigroupAwsItfLoadBalancer:
    def __init__(
        self,
        *,
        listener_rule: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItfLoadBalancerListenerRule"]],
        load_balancer_arn: builtins.str,
    ) -> None:
        '''
        :param listener_rule: listener_rule block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#listener_rule ElastigroupAws#listener_rule}
        :param load_balancer_arn: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer_arn ElastigroupAws#load_balancer_arn}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "listener_rule": listener_rule,
            "load_balancer_arn": load_balancer_arn,
        }

    @builtins.property
    def listener_rule(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfLoadBalancerListenerRule"]]:
        '''listener_rule block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#listener_rule ElastigroupAws#listener_rule}
        '''
        result = self._values.get("listener_rule")
        assert result is not None, "Required property 'listener_rule' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfLoadBalancerListenerRule"]], result)

    @builtins.property
    def load_balancer_arn(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#load_balancer_arn ElastigroupAws#load_balancer_arn}.'''
        result = self._values.get("load_balancer_arn")
        assert result is not None, "Required property 'load_balancer_arn' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfLoadBalancer(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfLoadBalancerListenerRule",
    jsii_struct_bases=[],
    name_mapping={"rule_arn": "ruleArn", "static_target_group": "staticTargetGroup"},
)
class ElastigroupAwsItfLoadBalancerListenerRule:
    def __init__(
        self,
        *,
        rule_arn: builtins.str,
        static_target_group: typing.Optional["ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup"] = None,
    ) -> None:
        '''
        :param rule_arn: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#rule_arn ElastigroupAws#rule_arn}.
        :param static_target_group: static_target_group block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#static_target_group ElastigroupAws#static_target_group}
        '''
        if isinstance(static_target_group, dict):
            static_target_group = ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup(**static_target_group)
        self._values: typing.Dict[str, typing.Any] = {
            "rule_arn": rule_arn,
        }
        if static_target_group is not None:
            self._values["static_target_group"] = static_target_group

    @builtins.property
    def rule_arn(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#rule_arn ElastigroupAws#rule_arn}.'''
        result = self._values.get("rule_arn")
        assert result is not None, "Required property 'rule_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def static_target_group(
        self,
    ) -> typing.Optional["ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup"]:
        '''static_target_group block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#static_target_group ElastigroupAws#static_target_group}
        '''
        result = self._values.get("static_target_group")
        return typing.cast(typing.Optional["ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfLoadBalancerListenerRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup",
    jsii_struct_bases=[],
    name_mapping={"arn": "arn", "percentage": "percentage"},
)
class ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup:
    def __init__(self, *, arn: builtins.str, percentage: jsii.Number) -> None:
        '''
        :param arn: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}.
        :param percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "arn": arn,
            "percentage": percentage,
        }

    @builtins.property
    def arn(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#arn ElastigroupAws#arn}.'''
        result = self._values.get("arn")
        assert result is not None, "Required property 'arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def percentage(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#percentage ElastigroupAws#percentage}.'''
        result = self._values.get("percentage")
        assert result is not None, "Required property 'percentage' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroupOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroupOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="arnInput")
    def arn_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "arnInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="percentageInput")
    def percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "percentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="arn")
    def arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "arn"))

    @arn.setter
    def arn(self, value: builtins.str) -> None:
        jsii.set(self, "arn", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="percentage")
    def percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "percentage"))

    @percentage.setter
    def percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "percentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup]:
        return typing.cast(typing.Optional[ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsItfLoadBalancerListenerRuleStaticTargetGroup],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfTargetGroupConfig",
    jsii_struct_bases=[],
    name_mapping={
        "health_check_path": "healthCheckPath",
        "port": "port",
        "protocol": "protocol",
        "vpc_id": "vpcId",
        "health_check_interval_seconds": "healthCheckIntervalSeconds",
        "health_check_port": "healthCheckPort",
        "health_check_protocol": "healthCheckProtocol",
        "health_check_timeout_seconds": "healthCheckTimeoutSeconds",
        "healthy_threshold_count": "healthyThresholdCount",
        "matcher": "matcher",
        "protocol_version": "protocolVersion",
        "tags": "tags",
        "unhealthy_threshold_count": "unhealthyThresholdCount",
    },
)
class ElastigroupAwsItfTargetGroupConfig:
    def __init__(
        self,
        *,
        health_check_path: builtins.str,
        port: jsii.Number,
        protocol: builtins.str,
        vpc_id: builtins.str,
        health_check_interval_seconds: typing.Optional[jsii.Number] = None,
        health_check_port: typing.Optional[builtins.str] = None,
        health_check_protocol: typing.Optional[builtins.str] = None,
        health_check_timeout_seconds: typing.Optional[jsii.Number] = None,
        healthy_threshold_count: typing.Optional[jsii.Number] = None,
        matcher: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItfTargetGroupConfigMatcher"]]] = None,
        protocol_version: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsItfTargetGroupConfigTags"]]] = None,
        unhealthy_threshold_count: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param health_check_path: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_path ElastigroupAws#health_check_path}.
        :param port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#port ElastigroupAws#port}.
        :param protocol: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol ElastigroupAws#protocol}.
        :param vpc_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#vpc_id ElastigroupAws#vpc_id}.
        :param health_check_interval_seconds: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_interval_seconds ElastigroupAws#health_check_interval_seconds}.
        :param health_check_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_port ElastigroupAws#health_check_port}.
        :param health_check_protocol: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_protocol ElastigroupAws#health_check_protocol}.
        :param health_check_timeout_seconds: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_timeout_seconds ElastigroupAws#health_check_timeout_seconds}.
        :param healthy_threshold_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#healthy_threshold_count ElastigroupAws#healthy_threshold_count}.
        :param matcher: matcher block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#matcher ElastigroupAws#matcher}
        :param protocol_version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol_version ElastigroupAws#protocol_version}.
        :param tags: tags block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
        :param unhealthy_threshold_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unhealthy_threshold_count ElastigroupAws#unhealthy_threshold_count}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "health_check_path": health_check_path,
            "port": port,
            "protocol": protocol,
            "vpc_id": vpc_id,
        }
        if health_check_interval_seconds is not None:
            self._values["health_check_interval_seconds"] = health_check_interval_seconds
        if health_check_port is not None:
            self._values["health_check_port"] = health_check_port
        if health_check_protocol is not None:
            self._values["health_check_protocol"] = health_check_protocol
        if health_check_timeout_seconds is not None:
            self._values["health_check_timeout_seconds"] = health_check_timeout_seconds
        if healthy_threshold_count is not None:
            self._values["healthy_threshold_count"] = healthy_threshold_count
        if matcher is not None:
            self._values["matcher"] = matcher
        if protocol_version is not None:
            self._values["protocol_version"] = protocol_version
        if tags is not None:
            self._values["tags"] = tags
        if unhealthy_threshold_count is not None:
            self._values["unhealthy_threshold_count"] = unhealthy_threshold_count

    @builtins.property
    def health_check_path(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_path ElastigroupAws#health_check_path}.'''
        result = self._values.get("health_check_path")
        assert result is not None, "Required property 'health_check_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def port(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#port ElastigroupAws#port}.'''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def protocol(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol ElastigroupAws#protocol}.'''
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def vpc_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#vpc_id ElastigroupAws#vpc_id}.'''
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def health_check_interval_seconds(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_interval_seconds ElastigroupAws#health_check_interval_seconds}.'''
        result = self._values.get("health_check_interval_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_port(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_port ElastigroupAws#health_check_port}.'''
        result = self._values.get("health_check_port")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def health_check_protocol(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_protocol ElastigroupAws#health_check_protocol}.'''
        result = self._values.get("health_check_protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def health_check_timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_timeout_seconds ElastigroupAws#health_check_timeout_seconds}.'''
        result = self._values.get("health_check_timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def healthy_threshold_count(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#healthy_threshold_count ElastigroupAws#healthy_threshold_count}.'''
        result = self._values.get("healthy_threshold_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def matcher(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfigMatcher"]]]:
        '''matcher block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#matcher ElastigroupAws#matcher}
        '''
        result = self._values.get("matcher")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfigMatcher"]]], result)

    @builtins.property
    def protocol_version(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#protocol_version ElastigroupAws#protocol_version}.'''
        result = self._values.get("protocol_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfigTags"]]]:
        '''tags block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tags ElastigroupAws#tags}
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsItfTargetGroupConfigTags"]]], result)

    @builtins.property
    def unhealthy_threshold_count(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unhealthy_threshold_count ElastigroupAws#unhealthy_threshold_count}.'''
        result = self._values.get("unhealthy_threshold_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfTargetGroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfTargetGroupConfigMatcher",
    jsii_struct_bases=[],
    name_mapping={"grpc_code": "grpcCode", "http_code": "httpCode"},
)
class ElastigroupAwsItfTargetGroupConfigMatcher:
    def __init__(
        self,
        *,
        grpc_code: typing.Optional[builtins.str] = None,
        http_code: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param grpc_code: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grpc_code ElastigroupAws#grpc_code}.
        :param http_code: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_code ElastigroupAws#http_code}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if grpc_code is not None:
            self._values["grpc_code"] = grpc_code
        if http_code is not None:
            self._values["http_code"] = http_code

    @builtins.property
    def grpc_code(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grpc_code ElastigroupAws#grpc_code}.'''
        result = self._values.get("grpc_code")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_code(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_code ElastigroupAws#http_code}.'''
        result = self._values.get("http_code")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfTargetGroupConfigMatcher(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsItfTargetGroupConfigTags",
    jsii_struct_bases=[],
    name_mapping={"tag_key": "tagKey", "tag_value": "tagValue"},
)
class ElastigroupAwsItfTargetGroupConfigTags:
    def __init__(
        self,
        *,
        tag_key: builtins.str,
        tag_value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param tag_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_key ElastigroupAws#tag_key}.
        :param tag_value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_value ElastigroupAws#tag_value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "tag_key": tag_key,
        }
        if tag_value is not None:
            self._values["tag_value"] = tag_value

    @builtins.property
    def tag_key(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_key ElastigroupAws#tag_key}.'''
        result = self._values.get("tag_key")
        assert result is not None, "Required property 'tag_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def tag_value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#tag_value ElastigroupAws#tag_value}.'''
        result = self._values.get("tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsItfTargetGroupConfigTags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMetadataOptions",
    jsii_struct_bases=[],
    name_mapping={
        "http_tokens": "httpTokens",
        "http_put_response_hop_limit": "httpPutResponseHopLimit",
    },
)
class ElastigroupAwsMetadataOptions:
    def __init__(
        self,
        *,
        http_tokens: builtins.str,
        http_put_response_hop_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param http_tokens: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_tokens ElastigroupAws#http_tokens}.
        :param http_put_response_hop_limit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_put_response_hop_limit ElastigroupAws#http_put_response_hop_limit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "http_tokens": http_tokens,
        }
        if http_put_response_hop_limit is not None:
            self._values["http_put_response_hop_limit"] = http_put_response_hop_limit

    @builtins.property
    def http_tokens(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_tokens ElastigroupAws#http_tokens}.'''
        result = self._values.get("http_tokens")
        assert result is not None, "Required property 'http_tokens' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def http_put_response_hop_limit(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#http_put_response_hop_limit ElastigroupAws#http_put_response_hop_limit}.'''
        result = self._values.get("http_put_response_hop_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMetadataOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsMetadataOptionsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMetadataOptionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetHttpPutResponseHopLimit")
    def reset_http_put_response_hop_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHttpPutResponseHopLimit", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="httpPutResponseHopLimitInput")
    def http_put_response_hop_limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "httpPutResponseHopLimitInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="httpTokensInput")
    def http_tokens_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "httpTokensInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "httpPutResponseHopLimit"))

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: jsii.Number) -> None:
        jsii.set(self, "httpPutResponseHopLimit", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="httpTokens")
    def http_tokens(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "httpTokens"))

    @http_tokens.setter
    def http_tokens(self, value: builtins.str) -> None:
        jsii.set(self, "httpTokens", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsMetadataOptions]:
        return typing.cast(typing.Optional[ElastigroupAwsMetadataOptions], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsMetadataOptions],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultaiTargetSets",
    jsii_struct_bases=[],
    name_mapping={"balancer_id": "balancerId", "target_set_id": "targetSetId"},
)
class ElastigroupAwsMultaiTargetSets:
    def __init__(
        self,
        *,
        balancer_id: builtins.str,
        target_set_id: builtins.str,
    ) -> None:
        '''
        :param balancer_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#balancer_id ElastigroupAws#balancer_id}.
        :param target_set_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_set_id ElastigroupAws#target_set_id}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "balancer_id": balancer_id,
            "target_set_id": target_set_id,
        }

    @builtins.property
    def balancer_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#balancer_id ElastigroupAws#balancer_id}.'''
        result = self._values.get("balancer_id")
        assert result is not None, "Required property 'balancer_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target_set_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_set_id ElastigroupAws#target_set_id}.'''
        result = self._values.get("target_set_id")
        assert result is not None, "Required property 'target_set_id' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMultaiTargetSets(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultipleMetrics",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "metrics": "metrics"},
)
class ElastigroupAwsMultipleMetrics:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultipleMetricsExpressions"]]] = None,
        metrics: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultipleMetricsMetrics"]]] = None,
    ) -> None:
        '''
        :param expressions: expressions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expressions ElastigroupAws#expressions}
        :param metrics: metrics block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metrics ElastigroupAws#metrics}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if metrics is not None:
            self._values["metrics"] = metrics

    @builtins.property
    def expressions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsExpressions"]]]:
        '''expressions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expressions ElastigroupAws#expressions}
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsExpressions"]]], result)

    @builtins.property
    def metrics(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsMetrics"]]]:
        '''metrics block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metrics ElastigroupAws#metrics}
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsMetrics"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMultipleMetrics(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsExpressions",
    jsii_struct_bases=[],
    name_mapping={"expression": "expression", "name": "name"},
)
class ElastigroupAwsMultipleMetricsExpressions:
    def __init__(self, *, expression: builtins.str, name: builtins.str) -> None:
        '''
        :param expression: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expression ElastigroupAws#expression}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "expression": expression,
            "name": name,
        }

    @builtins.property
    def expression(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#expression ElastigroupAws#expression}.'''
        result = self._values.get("expression")
        assert result is not None, "Required property 'expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMultipleMetricsExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsMetrics",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "name": "name",
        "namespace": "namespace",
        "dimensions": "dimensions",
        "extended_statistic": "extendedStatistic",
        "statistic": "statistic",
        "unit": "unit",
    },
)
class ElastigroupAwsMultipleMetricsMetrics:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        name: builtins.str,
        namespace: builtins.str,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsMultipleMetricsMetricsDimensions"]]] = None,
        extended_statistic: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        :param extended_statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#extended_statistic ElastigroupAws#extended_statistic}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "name": name,
            "namespace": namespace,
        }
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if extended_statistic is not None:
            self._values["extended_statistic"] = extended_statistic
        if statistic is not None:
            self._values["statistic"] = statistic
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsMetricsDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsMultipleMetricsMetricsDimensions"]]], result)

    @builtins.property
    def extended_statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#extended_statistic ElastigroupAws#extended_statistic}.'''
        result = self._values.get("extended_statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMultipleMetricsMetrics(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsMetricsDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAwsMultipleMetricsMetricsDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsMultipleMetricsMetricsDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsMultipleMetricsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsMultipleMetricsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetExpressions")
    def reset_expressions(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetExpressions", []))

    @jsii.member(jsii_name="resetMetrics")
    def reset_metrics(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetrics", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="expressionsInput")
    def expressions_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsExpressions]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsExpressions]]], jsii.get(self, "expressionsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricsInput")
    def metrics_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsMetrics]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsMetrics]]], jsii.get(self, "metricsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="expressions")
    def expressions(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsExpressions]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsExpressions]], jsii.get(self, "expressions"))

    @expressions.setter
    def expressions(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsExpressions]],
    ) -> None:
        jsii.set(self, "expressions", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metrics")
    def metrics(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsMetrics]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsMetrics]], jsii.get(self, "metrics"))

    @metrics.setter
    def metrics(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAwsMultipleMetricsMetrics]],
    ) -> None:
        jsii.set(self, "metrics", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsMultipleMetrics]:
        return typing.cast(typing.Optional[ElastigroupAwsMultipleMetrics], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsMultipleMetrics],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsNetworkInterface",
    jsii_struct_bases=[],
    name_mapping={
        "device_index": "deviceIndex",
        "associate_ipv6_address": "associateIpv6Address",
        "associate_public_ip_address": "associatePublicIpAddress",
        "delete_on_termination": "deleteOnTermination",
        "description": "description",
        "network_interface_id": "networkInterfaceId",
        "private_ip_address": "privateIpAddress",
        "secondary_private_ip_address_count": "secondaryPrivateIpAddressCount",
    },
)
class ElastigroupAwsNetworkInterface:
    def __init__(
        self,
        *,
        device_index: builtins.str,
        associate_ipv6_address: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        associate_public_ip_address: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        delete_on_termination: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        description: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
        secondary_private_ip_address_count: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param device_index: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_index ElastigroupAws#device_index}.
        :param associate_ipv6_address: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_ipv6_address ElastigroupAws#associate_ipv6_address}.
        :param associate_public_ip_address: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_public_ip_address ElastigroupAws#associate_public_ip_address}.
        :param delete_on_termination: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}.
        :param description: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}.
        :param network_interface_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface_id ElastigroupAws#network_interface_id}.
        :param private_ip_address: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ip_address ElastigroupAws#private_ip_address}.
        :param secondary_private_ip_address_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secondary_private_ip_address_count ElastigroupAws#secondary_private_ip_address_count}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "device_index": device_index,
        }
        if associate_ipv6_address is not None:
            self._values["associate_ipv6_address"] = associate_ipv6_address
        if associate_public_ip_address is not None:
            self._values["associate_public_ip_address"] = associate_public_ip_address
        if delete_on_termination is not None:
            self._values["delete_on_termination"] = delete_on_termination
        if description is not None:
            self._values["description"] = description
        if network_interface_id is not None:
            self._values["network_interface_id"] = network_interface_id
        if private_ip_address is not None:
            self._values["private_ip_address"] = private_ip_address
        if secondary_private_ip_address_count is not None:
            self._values["secondary_private_ip_address_count"] = secondary_private_ip_address_count

    @builtins.property
    def device_index(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#device_index ElastigroupAws#device_index}.'''
        result = self._values.get("device_index")
        assert result is not None, "Required property 'device_index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def associate_ipv6_address(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_ipv6_address ElastigroupAws#associate_ipv6_address}.'''
        result = self._values.get("associate_ipv6_address")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def associate_public_ip_address(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#associate_public_ip_address ElastigroupAws#associate_public_ip_address}.'''
        result = self._values.get("associate_public_ip_address")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def delete_on_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#delete_on_termination ElastigroupAws#delete_on_termination}.'''
        result = self._values.get("delete_on_termination")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#description ElastigroupAws#description}.'''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#network_interface_id ElastigroupAws#network_interface_id}.'''
        result = self._values.get("network_interface_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#private_ip_address ElastigroupAws#private_ip_address}.'''
        result = self._values.get("private_ip_address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secondary_private_ip_address_count(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#secondary_private_ip_address_count ElastigroupAws#secondary_private_ip_address_count}.'''
        result = self._values.get("secondary_private_ip_address_count")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsNetworkInterface(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsResourceTagSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "should_tag_amis": "shouldTagAmis",
        "should_tag_enis": "shouldTagEnis",
        "should_tag_snapshots": "shouldTagSnapshots",
        "should_tag_volumes": "shouldTagVolumes",
    },
)
class ElastigroupAwsResourceTagSpecification:
    def __init__(
        self,
        *,
        should_tag_amis: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_tag_enis: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_tag_snapshots: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_tag_volumes: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param should_tag_amis: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_amis ElastigroupAws#should_tag_amis}.
        :param should_tag_enis: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_enis ElastigroupAws#should_tag_enis}.
        :param should_tag_snapshots: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_snapshots ElastigroupAws#should_tag_snapshots}.
        :param should_tag_volumes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_volumes ElastigroupAws#should_tag_volumes}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if should_tag_amis is not None:
            self._values["should_tag_amis"] = should_tag_amis
        if should_tag_enis is not None:
            self._values["should_tag_enis"] = should_tag_enis
        if should_tag_snapshots is not None:
            self._values["should_tag_snapshots"] = should_tag_snapshots
        if should_tag_volumes is not None:
            self._values["should_tag_volumes"] = should_tag_volumes

    @builtins.property
    def should_tag_amis(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_amis ElastigroupAws#should_tag_amis}.'''
        result = self._values.get("should_tag_amis")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_tag_enis(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_enis ElastigroupAws#should_tag_enis}.'''
        result = self._values.get("should_tag_enis")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_tag_snapshots(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_snapshots ElastigroupAws#should_tag_snapshots}.'''
        result = self._values.get("should_tag_snapshots")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_tag_volumes(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_tag_volumes ElastigroupAws#should_tag_volumes}.'''
        result = self._values.get("should_tag_volumes")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsResourceTagSpecification(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsRevertToSpot",
    jsii_struct_bases=[],
    name_mapping={"perform_at": "performAt", "time_windows": "timeWindows"},
)
class ElastigroupAwsRevertToSpot:
    def __init__(
        self,
        *,
        perform_at: builtins.str,
        time_windows: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param perform_at: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.
        :param time_windows: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_windows ElastigroupAws#time_windows}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "perform_at": perform_at,
        }
        if time_windows is not None:
            self._values["time_windows"] = time_windows

    @builtins.property
    def perform_at(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#perform_at ElastigroupAws#perform_at}.'''
        result = self._values.get("perform_at")
        assert result is not None, "Required property 'perform_at' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def time_windows(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#time_windows ElastigroupAws#time_windows}.'''
        result = self._values.get("time_windows")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsRevertToSpot(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsRevertToSpotOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsRevertToSpotOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetTimeWindows")
    def reset_time_windows(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeWindows", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAtInput")
    def perform_at_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "performAtInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindowsInput")
    def time_windows_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "timeWindowsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="performAt")
    def perform_at(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "performAt"))

    @perform_at.setter
    def perform_at(self, value: builtins.str) -> None:
        jsii.set(self, "performAt", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="timeWindows")
    def time_windows(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "timeWindows"))

    @time_windows.setter
    def time_windows(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "timeWindows", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsRevertToSpot]:
        return typing.cast(typing.Optional[ElastigroupAwsRevertToSpot], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsRevertToSpot],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "policy_name": "policyName",
        "action_type": "actionType",
        "adjustment": "adjustment",
        "cooldown": "cooldown",
        "dimensions": "dimensions",
        "evaluation_periods": "evaluationPeriods",
        "is_enabled": "isEnabled",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "operator": "operator",
        "period": "period",
        "source": "source",
        "statistic": "statistic",
        "step_adjustments": "stepAdjustments",
        "target": "target",
        "threshold": "threshold",
        "unit": "unit",
    },
)
class ElastigroupAwsScalingDownPolicy:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        namespace: builtins.str,
        policy_name: builtins.str,
        action_type: typing.Optional[builtins.str] = None,
        adjustment: typing.Optional[builtins.str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingDownPolicyDimensions"]]] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        period: typing.Optional[jsii.Number] = None,
        source: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        step_adjustments: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingDownPolicyStepAdjustments"]]] = None,
        target: typing.Optional[builtins.str] = None,
        threshold: typing.Optional[jsii.Number] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.
        :param policy_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.
        :param cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.
        :param operator: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}.
        :param period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.
        :param source: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.
        :param step_adjustments: step_adjustments block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "namespace": namespace,
            "policy_name": policy_name,
        }
        if action_type is not None:
            self._values["action_type"] = action_type
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if operator is not None:
            self._values["operator"] = operator
        if period is not None:
            self._values["period"] = period
        if source is not None:
            self._values["source"] = source
        if statistic is not None:
            self._values["statistic"] = statistic
        if step_adjustments is not None:
            self._values["step_adjustments"] = step_adjustments
        if target is not None:
            self._values["target"] = target
        if threshold is not None:
            self._values["threshold"] = threshold
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.'''
        result = self._values.get("policy_name")
        assert result is not None, "Required property 'policy_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def action_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.'''
        result = self._values.get("action_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.'''
        result = self._values.get("cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicyDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicyDimensions"]]], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}.'''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.'''
        result = self._values.get("period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def source(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.'''
        result = self._values.get("source")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def step_adjustments(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicyStepAdjustments"]]]:
        '''step_adjustments block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
        '''
        result = self._values.get("step_adjustments")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingDownPolicyStepAdjustments"]]], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def threshold(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.'''
        result = self._values.get("threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingDownPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicyDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAwsScalingDownPolicyDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingDownPolicyDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicyStepAdjustments",
    jsii_struct_bases=[],
    name_mapping={"action": "action", "threshold": "threshold"},
)
class ElastigroupAwsScalingDownPolicyStepAdjustments:
    def __init__(
        self,
        *,
        action: "ElastigroupAwsScalingDownPolicyStepAdjustmentsAction",
        threshold: jsii.Number,
    ) -> None:
        '''
        :param action: action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.
        '''
        if isinstance(action, dict):
            action = ElastigroupAwsScalingDownPolicyStepAdjustmentsAction(**action)
        self._values: typing.Dict[str, typing.Any] = {
            "action": action,
            "threshold": threshold,
        }

    @builtins.property
    def action(self) -> "ElastigroupAwsScalingDownPolicyStepAdjustmentsAction":
        '''action block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
        '''
        result = self._values.get("action")
        assert result is not None, "Required property 'action' is missing"
        return typing.cast("ElastigroupAwsScalingDownPolicyStepAdjustmentsAction", result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.'''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingDownPolicyStepAdjustments(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicyStepAdjustmentsAction",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "adjustment": "adjustment",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "target": "target",
    },
)
class ElastigroupAwsScalingDownPolicyStepAdjustmentsAction:
    def __init__(
        self,
        *,
        type: builtins.str,
        adjustment: typing.Optional[builtins.str] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if target is not None:
            self._values["target"] = target

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingDownPolicyStepAdjustmentsAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsScalingDownPolicyStepAdjustmentsActionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingDownPolicyStepAdjustmentsActionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAdjustment")
    def reset_adjustment(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAdjustment", []))

    @jsii.member(jsii_name="resetMaximum")
    def reset_maximum(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaximum", []))

    @jsii.member(jsii_name="resetMaxTargetCapacity")
    def reset_max_target_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxTargetCapacity", []))

    @jsii.member(jsii_name="resetMinimum")
    def reset_minimum(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinimum", []))

    @jsii.member(jsii_name="resetMinTargetCapacity")
    def reset_min_target_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinTargetCapacity", []))

    @jsii.member(jsii_name="resetTarget")
    def reset_target(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTarget", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="adjustmentInput")
    def adjustment_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "adjustmentInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maximumInput")
    def maximum_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "maximumInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxTargetCapacityInput")
    def max_target_capacity_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "maxTargetCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimumInput")
    def minimum_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "minimumInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minTargetCapacityInput")
    def min_target_capacity_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "minTargetCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="targetInput")
    def target_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "targetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="adjustment")
    def adjustment(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "adjustment"))

    @adjustment.setter
    def adjustment(self, value: builtins.str) -> None:
        jsii.set(self, "adjustment", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maximum")
    def maximum(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "maximum"))

    @maximum.setter
    def maximum(self, value: builtins.str) -> None:
        jsii.set(self, "maximum", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxTargetCapacity")
    def max_target_capacity(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "maxTargetCapacity"))

    @max_target_capacity.setter
    def max_target_capacity(self, value: builtins.str) -> None:
        jsii.set(self, "maxTargetCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimum")
    def minimum(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "minimum"))

    @minimum.setter
    def minimum(self, value: builtins.str) -> None:
        jsii.set(self, "minimum", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minTargetCapacity")
    def min_target_capacity(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "minTargetCapacity"))

    @min_target_capacity.setter
    def min_target_capacity(self, value: builtins.str) -> None:
        jsii.set(self, "minTargetCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="target")
    def target(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "target"))

    @target.setter
    def target(self, value: builtins.str) -> None:
        jsii.set(self, "target", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsScalingDownPolicyStepAdjustmentsAction]:
        return typing.cast(typing.Optional[ElastigroupAwsScalingDownPolicyStepAdjustmentsAction], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsScalingDownPolicyStepAdjustmentsAction],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingStrategy",
    jsii_struct_bases=[],
    name_mapping={
        "terminate_at_end_of_billing_hour": "terminateAtEndOfBillingHour",
        "termination_policy": "terminationPolicy",
    },
)
class ElastigroupAwsScalingStrategy:
    def __init__(
        self,
        *,
        terminate_at_end_of_billing_hour: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        termination_policy: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param terminate_at_end_of_billing_hour: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_at_end_of_billing_hour ElastigroupAws#terminate_at_end_of_billing_hour}.
        :param termination_policy: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#termination_policy ElastigroupAws#termination_policy}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if terminate_at_end_of_billing_hour is not None:
            self._values["terminate_at_end_of_billing_hour"] = terminate_at_end_of_billing_hour
        if termination_policy is not None:
            self._values["termination_policy"] = termination_policy

    @builtins.property
    def terminate_at_end_of_billing_hour(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#terminate_at_end_of_billing_hour ElastigroupAws#terminate_at_end_of_billing_hour}.'''
        result = self._values.get("terminate_at_end_of_billing_hour")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def termination_policy(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#termination_policy ElastigroupAws#termination_policy}.'''
        result = self._values.get("termination_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "policy_name": "policyName",
        "target": "target",
        "cooldown": "cooldown",
        "dimensions": "dimensions",
        "evaluation_periods": "evaluationPeriods",
        "max_capacity_per_scale": "maxCapacityPerScale",
        "period": "period",
        "predictive_mode": "predictiveMode",
        "source": "source",
        "statistic": "statistic",
        "unit": "unit",
    },
)
class ElastigroupAwsScalingTargetPolicy:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        namespace: builtins.str,
        policy_name: builtins.str,
        target: jsii.Number,
        cooldown: typing.Optional[jsii.Number] = None,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingTargetPolicyDimensions"]]] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        max_capacity_per_scale: typing.Optional[builtins.str] = None,
        period: typing.Optional[jsii.Number] = None,
        predictive_mode: typing.Optional[builtins.str] = None,
        source: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.
        :param policy_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.
        :param cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param max_capacity_per_scale: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity_per_scale ElastigroupAws#max_capacity_per_scale}.
        :param period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.
        :param predictive_mode: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#predictive_mode ElastigroupAws#predictive_mode}.
        :param source: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "namespace": namespace,
            "policy_name": policy_name,
            "target": target,
        }
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if max_capacity_per_scale is not None:
            self._values["max_capacity_per_scale"] = max_capacity_per_scale
        if period is not None:
            self._values["period"] = period
        if predictive_mode is not None:
            self._values["predictive_mode"] = predictive_mode
        if source is not None:
            self._values["source"] = source
        if statistic is not None:
            self._values["statistic"] = statistic
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.'''
        result = self._values.get("policy_name")
        assert result is not None, "Required property 'policy_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.'''
        result = self._values.get("cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicyDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingTargetPolicyDimensions"]]], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_capacity_per_scale(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity_per_scale ElastigroupAws#max_capacity_per_scale}.'''
        result = self._values.get("max_capacity_per_scale")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.'''
        result = self._values.get("period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def predictive_mode(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#predictive_mode ElastigroupAws#predictive_mode}.'''
        result = self._values.get("predictive_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def source(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.'''
        result = self._values.get("source")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingTargetPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingTargetPolicyDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAwsScalingTargetPolicyDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingTargetPolicyDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "policy_name": "policyName",
        "action_type": "actionType",
        "adjustment": "adjustment",
        "cooldown": "cooldown",
        "dimensions": "dimensions",
        "evaluation_periods": "evaluationPeriods",
        "is_enabled": "isEnabled",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "operator": "operator",
        "period": "period",
        "source": "source",
        "statistic": "statistic",
        "step_adjustments": "stepAdjustments",
        "target": "target",
        "threshold": "threshold",
        "unit": "unit",
    },
)
class ElastigroupAwsScalingUpPolicy:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        namespace: builtins.str,
        policy_name: builtins.str,
        action_type: typing.Optional[builtins.str] = None,
        adjustment: typing.Optional[builtins.str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingUpPolicyDimensions"]]] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        period: typing.Optional[jsii.Number] = None,
        source: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        step_adjustments: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsScalingUpPolicyStepAdjustments"]]] = None,
        target: typing.Optional[builtins.str] = None,
        threshold: typing.Optional[jsii.Number] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.
        :param policy_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.
        :param cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.
        :param operator: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}.
        :param period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.
        :param source: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.
        :param step_adjustments: step_adjustments block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "namespace": namespace,
            "policy_name": policy_name,
        }
        if action_type is not None:
            self._values["action_type"] = action_type
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if operator is not None:
            self._values["operator"] = operator
        if period is not None:
            self._values["period"] = period
        if source is not None:
            self._values["source"] = source
        if statistic is not None:
            self._values["statistic"] = statistic
        if step_adjustments is not None:
            self._values["step_adjustments"] = step_adjustments
        if target is not None:
            self._values["target"] = target
        if threshold is not None:
            self._values["threshold"] = threshold
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#metric_name ElastigroupAws#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#namespace ElastigroupAws#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#policy_name ElastigroupAws#policy_name}.'''
        result = self._values.get("policy_name")
        assert result is not None, "Required property 'policy_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def action_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.'''
        result = self._values.get("action_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cooldown ElastigroupAws#cooldown}.'''
        result = self._values.get("cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicyDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#dimensions ElastigroupAws#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicyDimensions"]]], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#evaluation_periods ElastigroupAws#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#operator ElastigroupAws#operator}.'''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#period ElastigroupAws#period}.'''
        result = self._values.get("period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def source(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#source ElastigroupAws#source}.'''
        result = self._values.get("source")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#statistic ElastigroupAws#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def step_adjustments(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicyStepAdjustments"]]]:
        '''step_adjustments block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#step_adjustments ElastigroupAws#step_adjustments}
        '''
        result = self._values.get("step_adjustments")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsScalingUpPolicyStepAdjustments"]]], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def threshold(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.'''
        result = self._values.get("threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#unit ElastigroupAws#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingUpPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicyDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAwsScalingUpPolicyDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingUpPolicyDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicyStepAdjustments",
    jsii_struct_bases=[],
    name_mapping={"action": "action", "threshold": "threshold"},
)
class ElastigroupAwsScalingUpPolicyStepAdjustments:
    def __init__(
        self,
        *,
        action: "ElastigroupAwsScalingUpPolicyStepAdjustmentsAction",
        threshold: jsii.Number,
    ) -> None:
        '''
        :param action: action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.
        '''
        if isinstance(action, dict):
            action = ElastigroupAwsScalingUpPolicyStepAdjustmentsAction(**action)
        self._values: typing.Dict[str, typing.Any] = {
            "action": action,
            "threshold": threshold,
        }

    @builtins.property
    def action(self) -> "ElastigroupAwsScalingUpPolicyStepAdjustmentsAction":
        '''action block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}
        '''
        result = self._values.get("action")
        assert result is not None, "Required property 'action' is missing"
        return typing.cast("ElastigroupAwsScalingUpPolicyStepAdjustmentsAction", result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#threshold ElastigroupAws#threshold}.'''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingUpPolicyStepAdjustments(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicyStepAdjustmentsAction",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "adjustment": "adjustment",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "target": "target",
    },
)
class ElastigroupAwsScalingUpPolicyStepAdjustmentsAction:
    def __init__(
        self,
        *,
        type: builtins.str,
        adjustment: typing.Optional[builtins.str] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if target is not None:
            self._values["target"] = target

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#maximum ElastigroupAws#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_target_capacity ElastigroupAws#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#minimum ElastigroupAws#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_target_capacity ElastigroupAws#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target ElastigroupAws#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScalingUpPolicyStepAdjustmentsAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsScalingUpPolicyStepAdjustmentsActionOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScalingUpPolicyStepAdjustmentsActionOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAdjustment")
    def reset_adjustment(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAdjustment", []))

    @jsii.member(jsii_name="resetMaximum")
    def reset_maximum(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaximum", []))

    @jsii.member(jsii_name="resetMaxTargetCapacity")
    def reset_max_target_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxTargetCapacity", []))

    @jsii.member(jsii_name="resetMinimum")
    def reset_minimum(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinimum", []))

    @jsii.member(jsii_name="resetMinTargetCapacity")
    def reset_min_target_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinTargetCapacity", []))

    @jsii.member(jsii_name="resetTarget")
    def reset_target(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTarget", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="adjustmentInput")
    def adjustment_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "adjustmentInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maximumInput")
    def maximum_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "maximumInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxTargetCapacityInput")
    def max_target_capacity_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "maxTargetCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimumInput")
    def minimum_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "minimumInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minTargetCapacityInput")
    def min_target_capacity_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "minTargetCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="targetInput")
    def target_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "targetInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="adjustment")
    def adjustment(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "adjustment"))

    @adjustment.setter
    def adjustment(self, value: builtins.str) -> None:
        jsii.set(self, "adjustment", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maximum")
    def maximum(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "maximum"))

    @maximum.setter
    def maximum(self, value: builtins.str) -> None:
        jsii.set(self, "maximum", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxTargetCapacity")
    def max_target_capacity(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "maxTargetCapacity"))

    @max_target_capacity.setter
    def max_target_capacity(self, value: builtins.str) -> None:
        jsii.set(self, "maxTargetCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minimum")
    def minimum(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "minimum"))

    @minimum.setter
    def minimum(self, value: builtins.str) -> None:
        jsii.set(self, "minimum", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minTargetCapacity")
    def min_target_capacity(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "minTargetCapacity"))

    @min_target_capacity.setter
    def min_target_capacity(self, value: builtins.str) -> None:
        jsii.set(self, "minTargetCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="target")
    def target(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "target"))

    @target.setter
    def target(self, value: builtins.str) -> None:
        jsii.set(self, "target", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsScalingUpPolicyStepAdjustmentsAction]:
        return typing.cast(typing.Optional[ElastigroupAwsScalingUpPolicyStepAdjustmentsAction], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsScalingUpPolicyStepAdjustmentsAction],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsScheduledTask",
    jsii_struct_bases=[],
    name_mapping={
        "task_type": "taskType",
        "adjustment": "adjustment",
        "adjustment_percentage": "adjustmentPercentage",
        "batch_size_percentage": "batchSizePercentage",
        "cron_expression": "cronExpression",
        "frequency": "frequency",
        "grace_period": "gracePeriod",
        "is_enabled": "isEnabled",
        "max_capacity": "maxCapacity",
        "min_capacity": "minCapacity",
        "scale_max_capacity": "scaleMaxCapacity",
        "scale_min_capacity": "scaleMinCapacity",
        "scale_target_capacity": "scaleTargetCapacity",
        "start_time": "startTime",
        "target_capacity": "targetCapacity",
    },
)
class ElastigroupAwsScheduledTask:
    def __init__(
        self,
        *,
        task_type: builtins.str,
        adjustment: typing.Optional[builtins.str] = None,
        adjustment_percentage: typing.Optional[builtins.str] = None,
        batch_size_percentage: typing.Optional[builtins.str] = None,
        cron_expression: typing.Optional[builtins.str] = None,
        frequency: typing.Optional[builtins.str] = None,
        grace_period: typing.Optional[builtins.str] = None,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        max_capacity: typing.Optional[builtins.str] = None,
        min_capacity: typing.Optional[builtins.str] = None,
        scale_max_capacity: typing.Optional[builtins.str] = None,
        scale_min_capacity: typing.Optional[builtins.str] = None,
        scale_target_capacity: typing.Optional[builtins.str] = None,
        start_time: typing.Optional[builtins.str] = None,
        target_capacity: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param task_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#task_type ElastigroupAws#task_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.
        :param adjustment_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment_percentage ElastigroupAws#adjustment_percentage}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.
        :param cron_expression: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cron_expression ElastigroupAws#cron_expression}.
        :param frequency: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#frequency ElastigroupAws#frequency}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.
        :param max_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity ElastigroupAws#max_capacity}.
        :param min_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_capacity ElastigroupAws#min_capacity}.
        :param scale_max_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_max_capacity ElastigroupAws#scale_max_capacity}.
        :param scale_min_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_min_capacity ElastigroupAws#scale_min_capacity}.
        :param scale_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_target_capacity ElastigroupAws#scale_target_capacity}.
        :param start_time: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#start_time ElastigroupAws#start_time}.
        :param target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_capacity ElastigroupAws#target_capacity}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "task_type": task_type,
        }
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if adjustment_percentage is not None:
            self._values["adjustment_percentage"] = adjustment_percentage
        if batch_size_percentage is not None:
            self._values["batch_size_percentage"] = batch_size_percentage
        if cron_expression is not None:
            self._values["cron_expression"] = cron_expression
        if frequency is not None:
            self._values["frequency"] = frequency
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled
        if max_capacity is not None:
            self._values["max_capacity"] = max_capacity
        if min_capacity is not None:
            self._values["min_capacity"] = min_capacity
        if scale_max_capacity is not None:
            self._values["scale_max_capacity"] = scale_max_capacity
        if scale_min_capacity is not None:
            self._values["scale_min_capacity"] = scale_min_capacity
        if scale_target_capacity is not None:
            self._values["scale_target_capacity"] = scale_target_capacity
        if start_time is not None:
            self._values["start_time"] = start_time
        if target_capacity is not None:
            self._values["target_capacity"] = target_capacity

    @builtins.property
    def task_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#task_type ElastigroupAws#task_type}.'''
        result = self._values.get("task_type")
        assert result is not None, "Required property 'task_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment ElastigroupAws#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#adjustment_percentage ElastigroupAws#adjustment_percentage}.'''
        result = self._values.get("adjustment_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def batch_size_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cron_expression(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#cron_expression ElastigroupAws#cron_expression}.'''
        result = self._values.get("cron_expression")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def frequency(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#frequency ElastigroupAws#frequency}.'''
        result = self._values.get("frequency")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#is_enabled ElastigroupAws#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def max_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#max_capacity ElastigroupAws#max_capacity}.'''
        result = self._values.get("max_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#min_capacity ElastigroupAws#min_capacity}.'''
        result = self._values.get("min_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_max_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_max_capacity ElastigroupAws#scale_max_capacity}.'''
        result = self._values.get("scale_max_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_min_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_min_capacity ElastigroupAws#scale_min_capacity}.'''
        result = self._values.get("scale_min_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#scale_target_capacity ElastigroupAws#scale_target_capacity}.'''
        result = self._values.get("scale_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def start_time(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#start_time ElastigroupAws#start_time}.'''
        result = self._values.get("start_time")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#target_capacity ElastigroupAws#target_capacity}.'''
        result = self._values.get("target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsScheduledTask(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsSignal",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "timeout": "timeout"},
)
class ElastigroupAwsSignal:
    def __init__(
        self,
        *,
        name: builtins.str,
        timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.
        :param timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#timeout ElastigroupAws#timeout}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if timeout is not None:
            self._values["timeout"] = timeout

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#name ElastigroupAws#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#timeout ElastigroupAws#timeout}.'''
        result = self._values.get("timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsSignal(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocation",
    jsii_struct_bases=[],
    name_mapping={
        "should_delete_images": "shouldDeleteImages",
        "should_delete_network_interfaces": "shouldDeleteNetworkInterfaces",
        "should_delete_snapshots": "shouldDeleteSnapshots",
        "should_delete_volumes": "shouldDeleteVolumes",
    },
)
class ElastigroupAwsStatefulDeallocation:
    def __init__(
        self,
        *,
        should_delete_images: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_network_interfaces: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_snapshots: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_delete_volumes: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param should_delete_images: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_images ElastigroupAws#should_delete_images}.
        :param should_delete_network_interfaces: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_network_interfaces ElastigroupAws#should_delete_network_interfaces}.
        :param should_delete_snapshots: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_snapshots ElastigroupAws#should_delete_snapshots}.
        :param should_delete_volumes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_volumes ElastigroupAws#should_delete_volumes}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if should_delete_images is not None:
            self._values["should_delete_images"] = should_delete_images
        if should_delete_network_interfaces is not None:
            self._values["should_delete_network_interfaces"] = should_delete_network_interfaces
        if should_delete_snapshots is not None:
            self._values["should_delete_snapshots"] = should_delete_snapshots
        if should_delete_volumes is not None:
            self._values["should_delete_volumes"] = should_delete_volumes

    @builtins.property
    def should_delete_images(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_images ElastigroupAws#should_delete_images}.'''
        result = self._values.get("should_delete_images")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_delete_network_interfaces(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_network_interfaces ElastigroupAws#should_delete_network_interfaces}.'''
        result = self._values.get("should_delete_network_interfaces")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_delete_snapshots(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_snapshots ElastigroupAws#should_delete_snapshots}.'''
        result = self._values.get("should_delete_snapshots")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_delete_volumes(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_delete_volumes ElastigroupAws#should_delete_volumes}.'''
        result = self._values.get("should_delete_volumes")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsStatefulDeallocation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsStatefulDeallocationOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsStatefulDeallocationOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetShouldDeleteImages")
    def reset_should_delete_images(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDeleteImages", []))

    @jsii.member(jsii_name="resetShouldDeleteNetworkInterfaces")
    def reset_should_delete_network_interfaces(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDeleteNetworkInterfaces", []))

    @jsii.member(jsii_name="resetShouldDeleteSnapshots")
    def reset_should_delete_snapshots(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDeleteSnapshots", []))

    @jsii.member(jsii_name="resetShouldDeleteVolumes")
    def reset_should_delete_volumes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDeleteVolumes", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteImagesInput")
    def should_delete_images_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDeleteImagesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteNetworkInterfacesInput")
    def should_delete_network_interfaces_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDeleteNetworkInterfacesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteSnapshotsInput")
    def should_delete_snapshots_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDeleteSnapshotsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteVolumesInput")
    def should_delete_volumes_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDeleteVolumesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteImages")
    def should_delete_images(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDeleteImages"))

    @should_delete_images.setter
    def should_delete_images(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDeleteImages", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteNetworkInterfaces")
    def should_delete_network_interfaces(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDeleteNetworkInterfaces"))

    @should_delete_network_interfaces.setter
    def should_delete_network_interfaces(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDeleteNetworkInterfaces", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteSnapshots")
    def should_delete_snapshots(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDeleteSnapshots"))

    @should_delete_snapshots.setter
    def should_delete_snapshots(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDeleteSnapshots", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDeleteVolumes")
    def should_delete_volumes(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDeleteVolumes"))

    @should_delete_volumes.setter
    def should_delete_volumes(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDeleteVolumes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsStatefulDeallocation]:
        return typing.cast(typing.Optional[ElastigroupAwsStatefulDeallocation], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsStatefulDeallocation],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsStatefulInstanceAction",
    jsii_struct_bases=[],
    name_mapping={"stateful_instance_id": "statefulInstanceId", "type": "type"},
)
class ElastigroupAwsStatefulInstanceAction:
    def __init__(
        self,
        *,
        stateful_instance_id: builtins.str,
        type: builtins.str,
    ) -> None:
        '''
        :param stateful_instance_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_id ElastigroupAws#stateful_instance_id}.
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "stateful_instance_id": stateful_instance_id,
            "type": type,
        }

    @builtins.property
    def stateful_instance_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#stateful_instance_id ElastigroupAws#stateful_instance_id}.'''
        result = self._values.get("stateful_instance_id")
        assert result is not None, "Required property 'stateful_instance_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#type ElastigroupAws#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsStatefulInstanceAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsSuspension(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsSuspension",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        group_id: builtins.str,
        suspension: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsSuspensionSuspension"]],
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param group_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#group_id ElastigroupAwsSuspension#group_id}.
        :param suspension: suspension block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#suspension ElastigroupAwsSuspension#suspension}
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupAwsSuspensionConfig(
            group_id=group_id,
            suspension=suspension,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupIdInput")
    def group_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "groupIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="suspensionInput")
    def suspension_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]]], jsii.get(self, "suspensionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="groupId")
    def group_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "groupId"))

    @group_id.setter
    def group_id(self, value: builtins.str) -> None:
        jsii.set(self, "groupId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="suspension")
    def suspension(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]], jsii.get(self, "suspension"))

    @suspension.setter
    def suspension(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]],
    ) -> None:
        jsii.set(self, "suspension", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsSuspensionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "group_id": "groupId",
        "suspension": "suspension",
    },
)
class ElastigroupAwsSuspensionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        group_id: builtins.str,
        suspension: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAwsSuspensionSuspension"]],
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param group_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#group_id ElastigroupAwsSuspension#group_id}.
        :param suspension: suspension block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#suspension ElastigroupAwsSuspension#suspension}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values: typing.Dict[str, typing.Any] = {
            "group_id": group_id,
            "suspension": suspension,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def group_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#group_id ElastigroupAwsSuspension#group_id}.'''
        result = self._values.get("group_id")
        assert result is not None, "Required property 'group_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def suspension(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]]:
        '''suspension block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#suspension ElastigroupAwsSuspension#suspension}
        '''
        result = self._values.get("suspension")
        assert result is not None, "Required property 'suspension' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAwsSuspensionSuspension"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsSuspensionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsSuspensionSuspension",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class ElastigroupAwsSuspensionSuspension:
    def __init__(self, *, name: builtins.str) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#name ElastigroupAwsSuspension#name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#name ElastigroupAwsSuspension#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsSuspensionSuspension(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsTags",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class ElastigroupAwsTags:
    def __init__(
        self,
        *,
        key: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if key is not None:
            self._values["key"] = key
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#key ElastigroupAws#key}.'''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#value ElastigroupAws#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsTags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicy",
    jsii_struct_bases=[],
    name_mapping={
        "should_resume_stateful": "shouldResumeStateful",
        "should_roll": "shouldRoll",
        "auto_apply_tags": "autoApplyTags",
        "roll_config": "rollConfig",
    },
)
class ElastigroupAwsUpdatePolicy:
    def __init__(
        self,
        *,
        should_resume_stateful: typing.Union[builtins.bool, cdktf.IResolvable],
        should_roll: typing.Union[builtins.bool, cdktf.IResolvable],
        auto_apply_tags: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        roll_config: typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"] = None,
    ) -> None:
        '''
        :param should_resume_stateful: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_resume_stateful ElastigroupAws#should_resume_stateful}.
        :param should_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_roll ElastigroupAws#should_roll}.
        :param auto_apply_tags: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#auto_apply_tags ElastigroupAws#auto_apply_tags}.
        :param roll_config: roll_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#roll_config ElastigroupAws#roll_config}
        '''
        if isinstance(roll_config, dict):
            roll_config = ElastigroupAwsUpdatePolicyRollConfig(**roll_config)
        self._values: typing.Dict[str, typing.Any] = {
            "should_resume_stateful": should_resume_stateful,
            "should_roll": should_roll,
        }
        if auto_apply_tags is not None:
            self._values["auto_apply_tags"] = auto_apply_tags
        if roll_config is not None:
            self._values["roll_config"] = roll_config

    @builtins.property
    def should_resume_stateful(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_resume_stateful ElastigroupAws#should_resume_stateful}.'''
        result = self._values.get("should_resume_stateful")
        assert result is not None, "Required property 'should_resume_stateful' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def should_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_roll ElastigroupAws#should_roll}.'''
        result = self._values.get("should_roll")
        assert result is not None, "Required property 'should_roll' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def auto_apply_tags(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#auto_apply_tags ElastigroupAws#auto_apply_tags}.'''
        result = self._values.get("auto_apply_tags")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def roll_config(self) -> typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"]:
        '''roll_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#roll_config ElastigroupAws#roll_config}
        '''
        result = self._values.get("roll_config")
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsUpdatePolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsUpdatePolicyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putRollConfig")
    def put_roll_config(
        self,
        *,
        batch_size_percentage: jsii.Number,
        grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        strategy: typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"] = None,
        wait_for_roll_percentage: typing.Optional[jsii.Number] = None,
        wait_for_roll_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        :param wait_for_roll_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_percentage ElastigroupAws#wait_for_roll_percentage}.
        :param wait_for_roll_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_timeout ElastigroupAws#wait_for_roll_timeout}.
        '''
        value = ElastigroupAwsUpdatePolicyRollConfig(
            batch_size_percentage=batch_size_percentage,
            grace_period=grace_period,
            health_check_type=health_check_type,
            strategy=strategy,
            wait_for_roll_percentage=wait_for_roll_percentage,
            wait_for_roll_timeout=wait_for_roll_timeout,
        )

        return typing.cast(None, jsii.invoke(self, "putRollConfig", [value]))

    @jsii.member(jsii_name="resetAutoApplyTags")
    def reset_auto_apply_tags(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoApplyTags", []))

    @jsii.member(jsii_name="resetRollConfig")
    def reset_roll_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRollConfig", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rollConfig")
    def roll_config(self) -> "ElastigroupAwsUpdatePolicyRollConfigOutputReference":
        return typing.cast("ElastigroupAwsUpdatePolicyRollConfigOutputReference", jsii.get(self, "rollConfig"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoApplyTagsInput")
    def auto_apply_tags_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoApplyTagsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rollConfigInput")
    def roll_config_input(
        self,
    ) -> typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"]:
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicyRollConfig"], jsii.get(self, "rollConfigInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldResumeStatefulInput")
    def should_resume_stateful_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldResumeStatefulInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldRollInput")
    def should_roll_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldRollInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoApplyTags")
    def auto_apply_tags(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoApplyTags"))

    @auto_apply_tags.setter
    def auto_apply_tags(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoApplyTags", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldResumeStateful")
    def should_resume_stateful(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldResumeStateful"))

    @should_resume_stateful.setter
    def should_resume_stateful(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldResumeStateful", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldRoll")
    def should_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldRoll"))

    @should_roll.setter
    def should_roll(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldRoll", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsUpdatePolicy]:
        return typing.cast(typing.Optional[ElastigroupAwsUpdatePolicy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsUpdatePolicy],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfig",
    jsii_struct_bases=[],
    name_mapping={
        "batch_size_percentage": "batchSizePercentage",
        "grace_period": "gracePeriod",
        "health_check_type": "healthCheckType",
        "strategy": "strategy",
        "wait_for_roll_percentage": "waitForRollPercentage",
        "wait_for_roll_timeout": "waitForRollTimeout",
    },
)
class ElastigroupAwsUpdatePolicyRollConfig:
    def __init__(
        self,
        *,
        batch_size_percentage: jsii.Number,
        grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        strategy: typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"] = None,
        wait_for_roll_percentage: typing.Optional[jsii.Number] = None,
        wait_for_roll_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        :param wait_for_roll_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_percentage ElastigroupAws#wait_for_roll_percentage}.
        :param wait_for_roll_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_timeout ElastigroupAws#wait_for_roll_timeout}.
        '''
        if isinstance(strategy, dict):
            strategy = ElastigroupAwsUpdatePolicyRollConfigStrategy(**strategy)
        self._values: typing.Dict[str, typing.Any] = {
            "batch_size_percentage": batch_size_percentage,
        }
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if health_check_type is not None:
            self._values["health_check_type"] = health_check_type
        if strategy is not None:
            self._values["strategy"] = strategy
        if wait_for_roll_percentage is not None:
            self._values["wait_for_roll_percentage"] = wait_for_roll_percentage
        if wait_for_roll_timeout is not None:
            self._values["wait_for_roll_timeout"] = wait_for_roll_timeout

    @builtins.property
    def batch_size_percentage(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_size_percentage ElastigroupAws#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        assert result is not None, "Required property 'batch_size_percentage' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#grace_period ElastigroupAws#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#health_check_type ElastigroupAws#health_check_type}.'''
        result = self._values.get("health_check_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def strategy(
        self,
    ) -> typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"]:
        '''strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#strategy ElastigroupAws#strategy}
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"], result)

    @builtins.property
    def wait_for_roll_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_percentage ElastigroupAws#wait_for_roll_percentage}.'''
        result = self._values.get("wait_for_roll_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def wait_for_roll_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#wait_for_roll_timeout ElastigroupAws#wait_for_roll_timeout}.'''
        result = self._values.get("wait_for_roll_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsUpdatePolicyRollConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsUpdatePolicyRollConfigOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfigOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putStrategy")
    def put_strategy(
        self,
        *,
        action: builtins.str,
        batch_min_healthy_percentage: typing.Optional[jsii.Number] = None,
        on_failure: typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure"] = None,
        should_drain_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.
        :param batch_min_healthy_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_min_healthy_percentage ElastigroupAws#batch_min_healthy_percentage}.
        :param on_failure: on_failure block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#on_failure ElastigroupAws#on_failure}
        :param should_drain_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.
        '''
        value = ElastigroupAwsUpdatePolicyRollConfigStrategy(
            action=action,
            batch_min_healthy_percentage=batch_min_healthy_percentage,
            on_failure=on_failure,
            should_drain_instances=should_drain_instances,
        )

        return typing.cast(None, jsii.invoke(self, "putStrategy", [value]))

    @jsii.member(jsii_name="resetGracePeriod")
    def reset_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGracePeriod", []))

    @jsii.member(jsii_name="resetHealthCheckType")
    def reset_health_check_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckType", []))

    @jsii.member(jsii_name="resetStrategy")
    def reset_strategy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStrategy", []))

    @jsii.member(jsii_name="resetWaitForRollPercentage")
    def reset_wait_for_roll_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWaitForRollPercentage", []))

    @jsii.member(jsii_name="resetWaitForRollTimeout")
    def reset_wait_for_roll_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWaitForRollTimeout", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> "ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference":
        return typing.cast("ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference", jsii.get(self, "strategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentageInput")
    def batch_size_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchSizePercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriodInput")
    def grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "gracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckTypeInput")
    def health_check_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategyInput")
    def strategy_input(
        self,
    ) -> typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"]:
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategy"], jsii.get(self, "strategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForRollPercentageInput")
    def wait_for_roll_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "waitForRollPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForRollTimeoutInput")
    def wait_for_roll_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "waitForRollTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentage")
    def batch_size_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchSizePercentage"))

    @batch_size_percentage.setter
    def batch_size_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "batchSizePercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriod")
    def grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "gracePeriod"))

    @grace_period.setter
    def grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "gracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckType"))

    @health_check_type.setter
    def health_check_type(self, value: builtins.str) -> None:
        jsii.set(self, "healthCheckType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForRollPercentage")
    def wait_for_roll_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "waitForRollPercentage"))

    @wait_for_roll_percentage.setter
    def wait_for_roll_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "waitForRollPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="waitForRollTimeout")
    def wait_for_roll_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "waitForRollTimeout"))

    @wait_for_roll_timeout.setter
    def wait_for_roll_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "waitForRollTimeout", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAwsUpdatePolicyRollConfig]:
        return typing.cast(typing.Optional[ElastigroupAwsUpdatePolicyRollConfig], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsUpdatePolicyRollConfig],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfigStrategy",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "batch_min_healthy_percentage": "batchMinHealthyPercentage",
        "on_failure": "onFailure",
        "should_drain_instances": "shouldDrainInstances",
    },
)
class ElastigroupAwsUpdatePolicyRollConfigStrategy:
    def __init__(
        self,
        *,
        action: builtins.str,
        batch_min_healthy_percentage: typing.Optional[jsii.Number] = None,
        on_failure: typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure"] = None,
        should_drain_instances: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.
        :param batch_min_healthy_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_min_healthy_percentage ElastigroupAws#batch_min_healthy_percentage}.
        :param on_failure: on_failure block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#on_failure ElastigroupAws#on_failure}
        :param should_drain_instances: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.
        '''
        if isinstance(on_failure, dict):
            on_failure = ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure(**on_failure)
        self._values: typing.Dict[str, typing.Any] = {
            "action": action,
        }
        if batch_min_healthy_percentage is not None:
            self._values["batch_min_healthy_percentage"] = batch_min_healthy_percentage
        if on_failure is not None:
            self._values["on_failure"] = on_failure
        if should_drain_instances is not None:
            self._values["should_drain_instances"] = should_drain_instances

    @builtins.property
    def action(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action ElastigroupAws#action}.'''
        result = self._values.get("action")
        assert result is not None, "Required property 'action' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def batch_min_healthy_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_min_healthy_percentage ElastigroupAws#batch_min_healthy_percentage}.'''
        result = self._values.get("batch_min_healthy_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def on_failure(
        self,
    ) -> typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure"]:
        '''on_failure block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#on_failure ElastigroupAws#on_failure}
        '''
        result = self._values.get("on_failure")
        return typing.cast(typing.Optional["ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure"], result)

    @builtins.property
    def should_drain_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_drain_instances ElastigroupAws#should_drain_instances}.'''
        result = self._values.get("should_drain_instances")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsUpdatePolicyRollConfigStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure",
    jsii_struct_bases=[],
    name_mapping={
        "action_type": "actionType",
        "batch_num": "batchNum",
        "draining_timeout": "drainingTimeout",
        "should_decrement_target_capacity": "shouldDecrementTargetCapacity",
        "should_handle_all_batches": "shouldHandleAllBatches",
    },
)
class ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure:
    def __init__(
        self,
        *,
        action_type: builtins.str,
        batch_num: typing.Optional[jsii.Number] = None,
        draining_timeout: typing.Optional[jsii.Number] = None,
        should_decrement_target_capacity: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_handle_all_batches: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.
        :param batch_num: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_num ElastigroupAws#batch_num}.
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.
        :param should_decrement_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_decrement_target_capacity ElastigroupAws#should_decrement_target_capacity}.
        :param should_handle_all_batches: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_handle_all_batches ElastigroupAws#should_handle_all_batches}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "action_type": action_type,
        }
        if batch_num is not None:
            self._values["batch_num"] = batch_num
        if draining_timeout is not None:
            self._values["draining_timeout"] = draining_timeout
        if should_decrement_target_capacity is not None:
            self._values["should_decrement_target_capacity"] = should_decrement_target_capacity
        if should_handle_all_batches is not None:
            self._values["should_handle_all_batches"] = should_handle_all_batches

    @builtins.property
    def action_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.'''
        result = self._values.get("action_type")
        assert result is not None, "Required property 'action_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def batch_num(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_num ElastigroupAws#batch_num}.'''
        result = self._values.get("batch_num")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def draining_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.'''
        result = self._values.get("draining_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def should_decrement_target_capacity(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_decrement_target_capacity ElastigroupAws#should_decrement_target_capacity}.'''
        result = self._values.get("should_decrement_target_capacity")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def should_handle_all_batches(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_handle_all_batches ElastigroupAws#should_handle_all_batches}.'''
        result = self._values.get("should_handle_all_batches")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetBatchNum")
    def reset_batch_num(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBatchNum", []))

    @jsii.member(jsii_name="resetDrainingTimeout")
    def reset_draining_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDrainingTimeout", []))

    @jsii.member(jsii_name="resetShouldDecrementTargetCapacity")
    def reset_should_decrement_target_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDecrementTargetCapacity", []))

    @jsii.member(jsii_name="resetShouldHandleAllBatches")
    def reset_should_handle_all_batches(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldHandleAllBatches", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="actionTypeInput")
    def action_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "actionTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchNumInput")
    def batch_num_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchNumInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeoutInput")
    def draining_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "drainingTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDecrementTargetCapacityInput")
    def should_decrement_target_capacity_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDecrementTargetCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldHandleAllBatchesInput")
    def should_handle_all_batches_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldHandleAllBatchesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="actionType")
    def action_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "actionType"))

    @action_type.setter
    def action_type(self, value: builtins.str) -> None:
        jsii.set(self, "actionType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchNum")
    def batch_num(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchNum"))

    @batch_num.setter
    def batch_num(self, value: jsii.Number) -> None:
        jsii.set(self, "batchNum", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeout")
    def draining_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "drainingTimeout"))

    @draining_timeout.setter
    def draining_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "drainingTimeout", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDecrementTargetCapacity")
    def should_decrement_target_capacity(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDecrementTargetCapacity"))

    @should_decrement_target_capacity.setter
    def should_decrement_target_capacity(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDecrementTargetCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldHandleAllBatches")
    def should_handle_all_batches(
        self,
    ) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldHandleAllBatches"))

    @should_handle_all_batches.setter
    def should_handle_all_batches(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldHandleAllBatches", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure]:
        return typing.cast(typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAwsUpdatePolicyRollConfigStrategyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putOnFailure")
    def put_on_failure(
        self,
        *,
        action_type: builtins.str,
        batch_num: typing.Optional[jsii.Number] = None,
        draining_timeout: typing.Optional[jsii.Number] = None,
        should_decrement_target_capacity: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        should_handle_all_batches: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#action_type ElastigroupAws#action_type}.
        :param batch_num: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#batch_num ElastigroupAws#batch_num}.
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#draining_timeout ElastigroupAws#draining_timeout}.
        :param should_decrement_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_decrement_target_capacity ElastigroupAws#should_decrement_target_capacity}.
        :param should_handle_all_batches: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws#should_handle_all_batches ElastigroupAws#should_handle_all_batches}.
        '''
        value = ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure(
            action_type=action_type,
            batch_num=batch_num,
            draining_timeout=draining_timeout,
            should_decrement_target_capacity=should_decrement_target_capacity,
            should_handle_all_batches=should_handle_all_batches,
        )

        return typing.cast(None, jsii.invoke(self, "putOnFailure", [value]))

    @jsii.member(jsii_name="resetBatchMinHealthyPercentage")
    def reset_batch_min_healthy_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBatchMinHealthyPercentage", []))

    @jsii.member(jsii_name="resetOnFailure")
    def reset_on_failure(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOnFailure", []))

    @jsii.member(jsii_name="resetShouldDrainInstances")
    def reset_should_drain_instances(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShouldDrainInstances", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="onFailure")
    def on_failure(
        self,
    ) -> ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference:
        return typing.cast(ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailureOutputReference, jsii.get(self, "onFailure"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="actionInput")
    def action_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "actionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchMinHealthyPercentageInput")
    def batch_min_healthy_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchMinHealthyPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="onFailureInput")
    def on_failure_input(
        self,
    ) -> typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure]:
        return typing.cast(typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategyOnFailure], jsii.get(self, "onFailureInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDrainInstancesInput")
    def should_drain_instances_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldDrainInstancesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="action")
    def action(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "action"))

    @action.setter
    def action(self, value: builtins.str) -> None:
        jsii.set(self, "action", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchMinHealthyPercentage"))

    @batch_min_healthy_percentage.setter
    def batch_min_healthy_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "batchMinHealthyPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldDrainInstances")
    def should_drain_instances(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldDrainInstances"))

    @should_drain_instances.setter
    def should_drain_instances(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldDrainInstances", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategy]:
        return typing.cast(typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAwsUpdatePolicyRollConfigStrategy],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAzure(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzure",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        low_priority_sizes: typing.Sequence[builtins.str],
        name: builtins.str,
        network: "ElastigroupAzureNetwork",
        od_sizes: typing.Sequence[builtins.str],
        product: builtins.str,
        region: builtins.str,
        resource_group_name: builtins.str,
        strategy: "ElastigroupAzureStrategy",
        custom_data: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        health_check: typing.Optional["ElastigroupAzureHealthCheck"] = None,
        image: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureImage"]]] = None,
        integration_kubernetes: typing.Optional["ElastigroupAzureIntegrationKubernetes"] = None,
        integration_multai_runtime: typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"] = None,
        load_balancers: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureLoadBalancers"]]] = None,
        login: typing.Optional["ElastigroupAzureLogin"] = None,
        managed_service_identities: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureManagedServiceIdentities"]]] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        scaling_down_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingDownPolicy"]]] = None,
        scaling_up_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingUpPolicy"]]] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScheduledTask"]]] = None,
        shutdown_script: typing.Optional[builtins.str] = None,
        update_policy: typing.Optional["ElastigroupAzureUpdatePolicy"] = None,
        user_data: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param low_priority_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_sizes ElastigroupAzure#low_priority_sizes}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param network: network block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#network ElastigroupAzure#network}
        :param od_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_sizes ElastigroupAzure#od_sizes}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#product ElastigroupAzure#product}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#region ElastigroupAzure#region}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#strategy ElastigroupAzure#strategy}
        :param custom_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom_data ElastigroupAzure#custom_data}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#desired_capacity ElastigroupAzure#desired_capacity}.
        :param health_check: health_check block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check ElastigroupAzure#health_check}
        :param image: image block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image ElastigroupAzure#image}
        :param integration_kubernetes: integration_kubernetes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_kubernetes ElastigroupAzure#integration_kubernetes}
        :param integration_multai_runtime: integration_multai_runtime block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_multai_runtime ElastigroupAzure#integration_multai_runtime}
        :param load_balancers: load_balancers block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#load_balancers ElastigroupAzure#load_balancers}
        :param login: login block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#login ElastigroupAzure#login}
        :param managed_service_identities: managed_service_identities block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#managed_service_identities ElastigroupAzure#managed_service_identities}
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_size ElastigroupAzure#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_size ElastigroupAzure#min_size}.
        :param scaling_down_policy: scaling_down_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_down_policy ElastigroupAzure#scaling_down_policy}
        :param scaling_up_policy: scaling_up_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_up_policy ElastigroupAzure#scaling_up_policy}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scheduled_task ElastigroupAzure#scheduled_task}
        :param shutdown_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#shutdown_script ElastigroupAzure#shutdown_script}.
        :param update_policy: update_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#update_policy ElastigroupAzure#update_policy}
        :param user_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_data ElastigroupAzure#user_data}.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupAzureConfig(
            low_priority_sizes=low_priority_sizes,
            name=name,
            network=network,
            od_sizes=od_sizes,
            product=product,
            region=region,
            resource_group_name=resource_group_name,
            strategy=strategy,
            custom_data=custom_data,
            desired_capacity=desired_capacity,
            health_check=health_check,
            image=image,
            integration_kubernetes=integration_kubernetes,
            integration_multai_runtime=integration_multai_runtime,
            load_balancers=load_balancers,
            login=login,
            managed_service_identities=managed_service_identities,
            max_size=max_size,
            min_size=min_size,
            scaling_down_policy=scaling_down_policy,
            scaling_up_policy=scaling_up_policy,
            scheduled_task=scheduled_task,
            shutdown_script=shutdown_script,
            update_policy=update_policy,
            user_data=user_data,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putHealthCheck")
    def put_health_check(
        self,
        *,
        health_check_type: builtins.str,
        auto_healing: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        grace_period: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.
        :param auto_healing: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_healing ElastigroupAzure#auto_healing}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.
        '''
        value = ElastigroupAzureHealthCheck(
            health_check_type=health_check_type,
            auto_healing=auto_healing,
            grace_period=grace_period,
        )

        return typing.cast(None, jsii.invoke(self, "putHealthCheck", [value]))

    @jsii.member(jsii_name="putIntegrationKubernetes")
    def put_integration_kubernetes(self, *, cluster_identifier: builtins.str) -> None:
        '''
        :param cluster_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cluster_identifier ElastigroupAzure#cluster_identifier}.
        '''
        value = ElastigroupAzureIntegrationKubernetes(
            cluster_identifier=cluster_identifier
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationKubernetes", [value]))

    @jsii.member(jsii_name="putIntegrationMultaiRuntime")
    def put_integration_multai_runtime(self, *, deployment_id: builtins.str) -> None:
        '''
        :param deployment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#deployment_id ElastigroupAzure#deployment_id}.
        '''
        value = ElastigroupAzureIntegrationMultaiRuntime(deployment_id=deployment_id)

        return typing.cast(None, jsii.invoke(self, "putIntegrationMultaiRuntime", [value]))

    @jsii.member(jsii_name="putLogin")
    def put_login(
        self,
        *,
        user_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        ssh_public_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param user_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_name ElastigroupAzure#user_name}.
        :param password: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#password ElastigroupAzure#password}.
        :param ssh_public_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#ssh_public_key ElastigroupAzure#ssh_public_key}.
        '''
        value = ElastigroupAzureLogin(
            user_name=user_name, password=password, ssh_public_key=ssh_public_key
        )

        return typing.cast(None, jsii.invoke(self, "putLogin", [value]))

    @jsii.member(jsii_name="putNetwork")
    def put_network(
        self,
        *,
        resource_group_name: builtins.str,
        subnet_name: builtins.str,
        virtual_network_name: builtins.str,
        additional_ip_configs: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureNetworkAdditionalIpConfigs"]]] = None,
        assign_public_ip: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        :param subnet_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#subnet_name ElastigroupAzure#subnet_name}.
        :param virtual_network_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#virtual_network_name ElastigroupAzure#virtual_network_name}.
        :param additional_ip_configs: additional_ip_configs block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#additional_ip_configs ElastigroupAzure#additional_ip_configs}
        :param assign_public_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#assign_public_ip ElastigroupAzure#assign_public_ip}.
        '''
        value = ElastigroupAzureNetwork(
            resource_group_name=resource_group_name,
            subnet_name=subnet_name,
            virtual_network_name=virtual_network_name,
            additional_ip_configs=additional_ip_configs,
            assign_public_ip=assign_public_ip,
        )

        return typing.cast(None, jsii.invoke(self, "putNetwork", [value]))

    @jsii.member(jsii_name="putStrategy")
    def put_strategy(
        self,
        *,
        draining_timeout: typing.Optional[jsii.Number] = None,
        low_priority_percentage: typing.Optional[jsii.Number] = None,
        od_count: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#draining_timeout ElastigroupAzure#draining_timeout}.
        :param low_priority_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_percentage ElastigroupAzure#low_priority_percentage}.
        :param od_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_count ElastigroupAzure#od_count}.
        '''
        value = ElastigroupAzureStrategy(
            draining_timeout=draining_timeout,
            low_priority_percentage=low_priority_percentage,
            od_count=od_count,
        )

        return typing.cast(None, jsii.invoke(self, "putStrategy", [value]))

    @jsii.member(jsii_name="putUpdatePolicy")
    def put_update_policy(
        self,
        *,
        should_roll: typing.Union[builtins.bool, cdktf.IResolvable],
        roll_config: typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"] = None,
    ) -> None:
        '''
        :param should_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#should_roll ElastigroupAzure#should_roll}.
        :param roll_config: roll_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#roll_config ElastigroupAzure#roll_config}
        '''
        value = ElastigroupAzureUpdatePolicy(
            should_roll=should_roll, roll_config=roll_config
        )

        return typing.cast(None, jsii.invoke(self, "putUpdatePolicy", [value]))

    @jsii.member(jsii_name="resetCustomData")
    def reset_custom_data(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomData", []))

    @jsii.member(jsii_name="resetDesiredCapacity")
    def reset_desired_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDesiredCapacity", []))

    @jsii.member(jsii_name="resetHealthCheck")
    def reset_health_check(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheck", []))

    @jsii.member(jsii_name="resetImage")
    def reset_image(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetImage", []))

    @jsii.member(jsii_name="resetIntegrationKubernetes")
    def reset_integration_kubernetes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationKubernetes", []))

    @jsii.member(jsii_name="resetIntegrationMultaiRuntime")
    def reset_integration_multai_runtime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationMultaiRuntime", []))

    @jsii.member(jsii_name="resetLoadBalancers")
    def reset_load_balancers(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLoadBalancers", []))

    @jsii.member(jsii_name="resetLogin")
    def reset_login(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLogin", []))

    @jsii.member(jsii_name="resetManagedServiceIdentities")
    def reset_managed_service_identities(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManagedServiceIdentities", []))

    @jsii.member(jsii_name="resetMaxSize")
    def reset_max_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxSize", []))

    @jsii.member(jsii_name="resetMinSize")
    def reset_min_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinSize", []))

    @jsii.member(jsii_name="resetScalingDownPolicy")
    def reset_scaling_down_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingDownPolicy", []))

    @jsii.member(jsii_name="resetScalingUpPolicy")
    def reset_scaling_up_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScalingUpPolicy", []))

    @jsii.member(jsii_name="resetScheduledTask")
    def reset_scheduled_task(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScheduledTask", []))

    @jsii.member(jsii_name="resetShutdownScript")
    def reset_shutdown_script(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShutdownScript", []))

    @jsii.member(jsii_name="resetUpdatePolicy")
    def reset_update_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdatePolicy", []))

    @jsii.member(jsii_name="resetUserData")
    def reset_user_data(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUserData", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheck")
    def health_check(self) -> "ElastigroupAzureHealthCheckOutputReference":
        return typing.cast("ElastigroupAzureHealthCheckOutputReference", jsii.get(self, "healthCheck"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationKubernetes")
    def integration_kubernetes(
        self,
    ) -> "ElastigroupAzureIntegrationKubernetesOutputReference":
        return typing.cast("ElastigroupAzureIntegrationKubernetesOutputReference", jsii.get(self, "integrationKubernetes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMultaiRuntime")
    def integration_multai_runtime(
        self,
    ) -> "ElastigroupAzureIntegrationMultaiRuntimeOutputReference":
        return typing.cast("ElastigroupAzureIntegrationMultaiRuntimeOutputReference", jsii.get(self, "integrationMultaiRuntime"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="login")
    def login(self) -> "ElastigroupAzureLoginOutputReference":
        return typing.cast("ElastigroupAzureLoginOutputReference", jsii.get(self, "login"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="network")
    def network(self) -> "ElastigroupAzureNetworkOutputReference":
        return typing.cast("ElastigroupAzureNetworkOutputReference", jsii.get(self, "network"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> "ElastigroupAzureStrategyOutputReference":
        return typing.cast("ElastigroupAzureStrategyOutputReference", jsii.get(self, "strategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updatePolicy")
    def update_policy(self) -> "ElastigroupAzureUpdatePolicyOutputReference":
        return typing.cast("ElastigroupAzureUpdatePolicyOutputReference", jsii.get(self, "updatePolicy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customDataInput")
    def custom_data_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customDataInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacityInput")
    def desired_capacity_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "desiredCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckInput")
    def health_check_input(self) -> typing.Optional["ElastigroupAzureHealthCheck"]:
        return typing.cast(typing.Optional["ElastigroupAzureHealthCheck"], jsii.get(self, "healthCheckInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="imageInput")
    def image_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]]], jsii.get(self, "imageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationKubernetesInput")
    def integration_kubernetes_input(
        self,
    ) -> typing.Optional["ElastigroupAzureIntegrationKubernetes"]:
        return typing.cast(typing.Optional["ElastigroupAzureIntegrationKubernetes"], jsii.get(self, "integrationKubernetesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="integrationMultaiRuntimeInput")
    def integration_multai_runtime_input(
        self,
    ) -> typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"]:
        return typing.cast(typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"], jsii.get(self, "integrationMultaiRuntimeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="loadBalancersInput")
    def load_balancers_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]]], jsii.get(self, "loadBalancersInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="loginInput")
    def login_input(self) -> typing.Optional["ElastigroupAzureLogin"]:
        return typing.cast(typing.Optional["ElastigroupAzureLogin"], jsii.get(self, "loginInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lowPrioritySizesInput")
    def low_priority_sizes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "lowPrioritySizesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedServiceIdentitiesInput")
    def managed_service_identities_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]]], jsii.get(self, "managedServiceIdentitiesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSizeInput")
    def max_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSizeInput")
    def min_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "minSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInput")
    def network_input(self) -> typing.Optional["ElastigroupAzureNetwork"]:
        return typing.cast(typing.Optional["ElastigroupAzureNetwork"], jsii.get(self, "networkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odSizesInput")
    def od_sizes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "odSizesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="productInput")
    def product_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "productInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="regionInput")
    def region_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceGroupNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingDownPolicyInput")
    def scaling_down_policy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]]], jsii.get(self, "scalingDownPolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingUpPolicyInput")
    def scaling_up_policy_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]]], jsii.get(self, "scalingUpPolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTaskInput")
    def scheduled_task_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]]], jsii.get(self, "scheduledTaskInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shutdownScriptInput")
    def shutdown_script_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "shutdownScriptInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategyInput")
    def strategy_input(self) -> typing.Optional["ElastigroupAzureStrategy"]:
        return typing.cast(typing.Optional["ElastigroupAzureStrategy"], jsii.get(self, "strategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="updatePolicyInput")
    def update_policy_input(self) -> typing.Optional["ElastigroupAzureUpdatePolicy"]:
        return typing.cast(typing.Optional["ElastigroupAzureUpdatePolicy"], jsii.get(self, "updatePolicyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userDataInput")
    def user_data_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "userDataInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customData")
    def custom_data(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customData"))

    @custom_data.setter
    def custom_data(self, value: builtins.str) -> None:
        jsii.set(self, "customData", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "desiredCapacity"))

    @desired_capacity.setter
    def desired_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="image")
    def image(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]], jsii.get(self, "image"))

    @image.setter
    def image(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]],
    ) -> None:
        jsii.set(self, "image", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="loadBalancers")
    def load_balancers(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]], jsii.get(self, "loadBalancers"))

    @load_balancers.setter
    def load_balancers(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]],
    ) -> None:
        jsii.set(self, "loadBalancers", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lowPrioritySizes")
    def low_priority_sizes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "lowPrioritySizes"))

    @low_priority_sizes.setter
    def low_priority_sizes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "lowPrioritySizes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedServiceIdentities")
    def managed_service_identities(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]], jsii.get(self, "managedServiceIdentities"))

    @managed_service_identities.setter
    def managed_service_identities(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]],
    ) -> None:
        jsii.set(self, "managedServiceIdentities", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxSize"))

    @max_size.setter
    def max_size(self, value: jsii.Number) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minSize"))

    @min_size.setter
    def min_size(self, value: jsii.Number) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odSizes")
    def od_sizes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "odSizes"))

    @od_sizes.setter
    def od_sizes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "odSizes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="product")
    def product(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "product"))

    @product.setter
    def product(self, value: builtins.str) -> None:
        jsii.set(self, "product", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="region")
    def region(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "region"))

    @region.setter
    def region(self, value: builtins.str) -> None:
        jsii.set(self, "region", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceGroupName"))

    @resource_group_name.setter
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingDownPolicy")
    def scaling_down_policy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]], jsii.get(self, "scalingDownPolicy"))

    @scaling_down_policy.setter
    def scaling_down_policy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]],
    ) -> None:
        jsii.set(self, "scalingDownPolicy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scalingUpPolicy")
    def scaling_up_policy(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]], jsii.get(self, "scalingUpPolicy"))

    @scaling_up_policy.setter
    def scaling_up_policy(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]],
    ) -> None:
        jsii.set(self, "scalingUpPolicy", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scheduledTask")
    def scheduled_task(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]], jsii.get(self, "scheduledTask"))

    @scheduled_task.setter
    def scheduled_task(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]],
    ) -> None:
        jsii.set(self, "scheduledTask", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shutdownScript")
    def shutdown_script(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "shutdownScript"))

    @shutdown_script.setter
    def shutdown_script(self, value: builtins.str) -> None:
        jsii.set(self, "shutdownScript", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userData")
    def user_data(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "userData"))

    @user_data.setter
    def user_data(self, value: builtins.str) -> None:
        jsii.set(self, "userData", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "low_priority_sizes": "lowPrioritySizes",
        "name": "name",
        "network": "network",
        "od_sizes": "odSizes",
        "product": "product",
        "region": "region",
        "resource_group_name": "resourceGroupName",
        "strategy": "strategy",
        "custom_data": "customData",
        "desired_capacity": "desiredCapacity",
        "health_check": "healthCheck",
        "image": "image",
        "integration_kubernetes": "integrationKubernetes",
        "integration_multai_runtime": "integrationMultaiRuntime",
        "load_balancers": "loadBalancers",
        "login": "login",
        "managed_service_identities": "managedServiceIdentities",
        "max_size": "maxSize",
        "min_size": "minSize",
        "scaling_down_policy": "scalingDownPolicy",
        "scaling_up_policy": "scalingUpPolicy",
        "scheduled_task": "scheduledTask",
        "shutdown_script": "shutdownScript",
        "update_policy": "updatePolicy",
        "user_data": "userData",
    },
)
class ElastigroupAzureConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        low_priority_sizes: typing.Sequence[builtins.str],
        name: builtins.str,
        network: "ElastigroupAzureNetwork",
        od_sizes: typing.Sequence[builtins.str],
        product: builtins.str,
        region: builtins.str,
        resource_group_name: builtins.str,
        strategy: "ElastigroupAzureStrategy",
        custom_data: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        health_check: typing.Optional["ElastigroupAzureHealthCheck"] = None,
        image: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureImage"]]] = None,
        integration_kubernetes: typing.Optional["ElastigroupAzureIntegrationKubernetes"] = None,
        integration_multai_runtime: typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"] = None,
        load_balancers: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureLoadBalancers"]]] = None,
        login: typing.Optional["ElastigroupAzureLogin"] = None,
        managed_service_identities: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureManagedServiceIdentities"]]] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        scaling_down_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingDownPolicy"]]] = None,
        scaling_up_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingUpPolicy"]]] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScheduledTask"]]] = None,
        shutdown_script: typing.Optional[builtins.str] = None,
        update_policy: typing.Optional["ElastigroupAzureUpdatePolicy"] = None,
        user_data: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param low_priority_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_sizes ElastigroupAzure#low_priority_sizes}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param network: network block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#network ElastigroupAzure#network}
        :param od_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_sizes ElastigroupAzure#od_sizes}.
        :param product: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#product ElastigroupAzure#product}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#region ElastigroupAzure#region}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#strategy ElastigroupAzure#strategy}
        :param custom_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom_data ElastigroupAzure#custom_data}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#desired_capacity ElastigroupAzure#desired_capacity}.
        :param health_check: health_check block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check ElastigroupAzure#health_check}
        :param image: image block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image ElastigroupAzure#image}
        :param integration_kubernetes: integration_kubernetes block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_kubernetes ElastigroupAzure#integration_kubernetes}
        :param integration_multai_runtime: integration_multai_runtime block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_multai_runtime ElastigroupAzure#integration_multai_runtime}
        :param load_balancers: load_balancers block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#load_balancers ElastigroupAzure#load_balancers}
        :param login: login block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#login ElastigroupAzure#login}
        :param managed_service_identities: managed_service_identities block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#managed_service_identities ElastigroupAzure#managed_service_identities}
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_size ElastigroupAzure#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_size ElastigroupAzure#min_size}.
        :param scaling_down_policy: scaling_down_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_down_policy ElastigroupAzure#scaling_down_policy}
        :param scaling_up_policy: scaling_up_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_up_policy ElastigroupAzure#scaling_up_policy}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scheduled_task ElastigroupAzure#scheduled_task}
        :param shutdown_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#shutdown_script ElastigroupAzure#shutdown_script}.
        :param update_policy: update_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#update_policy ElastigroupAzure#update_policy}
        :param user_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_data ElastigroupAzure#user_data}.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(network, dict):
            network = ElastigroupAzureNetwork(**network)
        if isinstance(strategy, dict):
            strategy = ElastigroupAzureStrategy(**strategy)
        if isinstance(health_check, dict):
            health_check = ElastigroupAzureHealthCheck(**health_check)
        if isinstance(integration_kubernetes, dict):
            integration_kubernetes = ElastigroupAzureIntegrationKubernetes(**integration_kubernetes)
        if isinstance(integration_multai_runtime, dict):
            integration_multai_runtime = ElastigroupAzureIntegrationMultaiRuntime(**integration_multai_runtime)
        if isinstance(login, dict):
            login = ElastigroupAzureLogin(**login)
        if isinstance(update_policy, dict):
            update_policy = ElastigroupAzureUpdatePolicy(**update_policy)
        self._values: typing.Dict[str, typing.Any] = {
            "low_priority_sizes": low_priority_sizes,
            "name": name,
            "network": network,
            "od_sizes": od_sizes,
            "product": product,
            "region": region,
            "resource_group_name": resource_group_name,
            "strategy": strategy,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if custom_data is not None:
            self._values["custom_data"] = custom_data
        if desired_capacity is not None:
            self._values["desired_capacity"] = desired_capacity
        if health_check is not None:
            self._values["health_check"] = health_check
        if image is not None:
            self._values["image"] = image
        if integration_kubernetes is not None:
            self._values["integration_kubernetes"] = integration_kubernetes
        if integration_multai_runtime is not None:
            self._values["integration_multai_runtime"] = integration_multai_runtime
        if load_balancers is not None:
            self._values["load_balancers"] = load_balancers
        if login is not None:
            self._values["login"] = login
        if managed_service_identities is not None:
            self._values["managed_service_identities"] = managed_service_identities
        if max_size is not None:
            self._values["max_size"] = max_size
        if min_size is not None:
            self._values["min_size"] = min_size
        if scaling_down_policy is not None:
            self._values["scaling_down_policy"] = scaling_down_policy
        if scaling_up_policy is not None:
            self._values["scaling_up_policy"] = scaling_up_policy
        if scheduled_task is not None:
            self._values["scheduled_task"] = scheduled_task
        if shutdown_script is not None:
            self._values["shutdown_script"] = shutdown_script
        if update_policy is not None:
            self._values["update_policy"] = update_policy
        if user_data is not None:
            self._values["user_data"] = user_data

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def low_priority_sizes(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_sizes ElastigroupAzure#low_priority_sizes}.'''
        result = self._values.get("low_priority_sizes")
        assert result is not None, "Required property 'low_priority_sizes' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def network(self) -> "ElastigroupAzureNetwork":
        '''network block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#network ElastigroupAzure#network}
        '''
        result = self._values.get("network")
        assert result is not None, "Required property 'network' is missing"
        return typing.cast("ElastigroupAzureNetwork", result)

    @builtins.property
    def od_sizes(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_sizes ElastigroupAzure#od_sizes}.'''
        result = self._values.get("od_sizes")
        assert result is not None, "Required property 'od_sizes' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def product(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#product ElastigroupAzure#product}.'''
        result = self._values.get("product")
        assert result is not None, "Required property 'product' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def region(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#region ElastigroupAzure#region}.'''
        result = self._values.get("region")
        assert result is not None, "Required property 'region' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def strategy(self) -> "ElastigroupAzureStrategy":
        '''strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#strategy ElastigroupAzure#strategy}
        '''
        result = self._values.get("strategy")
        assert result is not None, "Required property 'strategy' is missing"
        return typing.cast("ElastigroupAzureStrategy", result)

    @builtins.property
    def custom_data(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom_data ElastigroupAzure#custom_data}.'''
        result = self._values.get("custom_data")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#desired_capacity ElastigroupAzure#desired_capacity}.'''
        result = self._values.get("desired_capacity")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check(self) -> typing.Optional["ElastigroupAzureHealthCheck"]:
        '''health_check block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check ElastigroupAzure#health_check}
        '''
        result = self._values.get("health_check")
        return typing.cast(typing.Optional["ElastigroupAzureHealthCheck"], result)

    @builtins.property
    def image(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]]]:
        '''image block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image ElastigroupAzure#image}
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImage"]]], result)

    @builtins.property
    def integration_kubernetes(
        self,
    ) -> typing.Optional["ElastigroupAzureIntegrationKubernetes"]:
        '''integration_kubernetes block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_kubernetes ElastigroupAzure#integration_kubernetes}
        '''
        result = self._values.get("integration_kubernetes")
        return typing.cast(typing.Optional["ElastigroupAzureIntegrationKubernetes"], result)

    @builtins.property
    def integration_multai_runtime(
        self,
    ) -> typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"]:
        '''integration_multai_runtime block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_multai_runtime ElastigroupAzure#integration_multai_runtime}
        '''
        result = self._values.get("integration_multai_runtime")
        return typing.cast(typing.Optional["ElastigroupAzureIntegrationMultaiRuntime"], result)

    @builtins.property
    def load_balancers(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]]]:
        '''load_balancers block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#load_balancers ElastigroupAzure#load_balancers}
        '''
        result = self._values.get("load_balancers")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureLoadBalancers"]]], result)

    @builtins.property
    def login(self) -> typing.Optional["ElastigroupAzureLogin"]:
        '''login block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#login ElastigroupAzure#login}
        '''
        result = self._values.get("login")
        return typing.cast(typing.Optional["ElastigroupAzureLogin"], result)

    @builtins.property
    def managed_service_identities(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]]]:
        '''managed_service_identities block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#managed_service_identities ElastigroupAzure#managed_service_identities}
        '''
        result = self._values.get("managed_service_identities")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureManagedServiceIdentities"]]], result)

    @builtins.property
    def max_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_size ElastigroupAzure#max_size}.'''
        result = self._values.get("max_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_size ElastigroupAzure#min_size}.'''
        result = self._values.get("min_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scaling_down_policy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]]]:
        '''scaling_down_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_down_policy ElastigroupAzure#scaling_down_policy}
        '''
        result = self._values.get("scaling_down_policy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicy"]]], result)

    @builtins.property
    def scaling_up_policy(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]]]:
        '''scaling_up_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_up_policy ElastigroupAzure#scaling_up_policy}
        '''
        result = self._values.get("scaling_up_policy")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicy"]]], result)

    @builtins.property
    def scheduled_task(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]]]:
        '''scheduled_task block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scheduled_task ElastigroupAzure#scheduled_task}
        '''
        result = self._values.get("scheduled_task")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScheduledTask"]]], result)

    @builtins.property
    def shutdown_script(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#shutdown_script ElastigroupAzure#shutdown_script}.'''
        result = self._values.get("shutdown_script")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_policy(self) -> typing.Optional["ElastigroupAzureUpdatePolicy"]:
        '''update_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#update_policy ElastigroupAzure#update_policy}
        '''
        result = self._values.get("update_policy")
        return typing.cast(typing.Optional["ElastigroupAzureUpdatePolicy"], result)

    @builtins.property
    def user_data(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_data ElastigroupAzure#user_data}.'''
        result = self._values.get("user_data")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureHealthCheck",
    jsii_struct_bases=[],
    name_mapping={
        "health_check_type": "healthCheckType",
        "auto_healing": "autoHealing",
        "grace_period": "gracePeriod",
    },
)
class ElastigroupAzureHealthCheck:
    def __init__(
        self,
        *,
        health_check_type: builtins.str,
        auto_healing: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        grace_period: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.
        :param auto_healing: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_healing ElastigroupAzure#auto_healing}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "health_check_type": health_check_type,
        }
        if auto_healing is not None:
            self._values["auto_healing"] = auto_healing
        if grace_period is not None:
            self._values["grace_period"] = grace_period

    @builtins.property
    def health_check_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.'''
        result = self._values.get("health_check_type")
        assert result is not None, "Required property 'health_check_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def auto_healing(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_healing ElastigroupAzure#auto_healing}.'''
        result = self._values.get("auto_healing")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureHealthCheck(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureHealthCheckOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureHealthCheckOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAutoHealing")
    def reset_auto_healing(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoHealing", []))

    @jsii.member(jsii_name="resetGracePeriod")
    def reset_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGracePeriod", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoHealingInput")
    def auto_healing_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoHealingInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriodInput")
    def grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "gracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckTypeInput")
    def health_check_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="autoHealing")
    def auto_healing(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoHealing"))

    @auto_healing.setter
    def auto_healing(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "autoHealing", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriod")
    def grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "gracePeriod"))

    @grace_period.setter
    def grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "gracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckType"))

    @health_check_type.setter
    def health_check_type(self, value: builtins.str) -> None:
        jsii.set(self, "healthCheckType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureHealthCheck]:
        return typing.cast(typing.Optional[ElastigroupAzureHealthCheck], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureHealthCheck],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureImage",
    jsii_struct_bases=[],
    name_mapping={"custom": "custom", "marketplace": "marketplace"},
)
class ElastigroupAzureImage:
    def __init__(
        self,
        *,
        custom: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureImageCustom"]]] = None,
        marketplace: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureImageMarketplace"]]] = None,
    ) -> None:
        '''
        :param custom: custom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom ElastigroupAzure#custom}
        :param marketplace: marketplace block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#marketplace ElastigroupAzure#marketplace}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if custom is not None:
            self._values["custom"] = custom
        if marketplace is not None:
            self._values["marketplace"] = marketplace

    @builtins.property
    def custom(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImageCustom"]]]:
        '''custom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom ElastigroupAzure#custom}
        '''
        result = self._values.get("custom")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImageCustom"]]], result)

    @builtins.property
    def marketplace(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImageMarketplace"]]]:
        '''marketplace block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#marketplace ElastigroupAzure#marketplace}
        '''
        result = self._values.get("marketplace")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureImageMarketplace"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureImage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureImageCustom",
    jsii_struct_bases=[],
    name_mapping={
        "image_name": "imageName",
        "resource_group_name": "resourceGroupName",
    },
)
class ElastigroupAzureImageCustom:
    def __init__(
        self,
        *,
        image_name: builtins.str,
        resource_group_name: builtins.str,
    ) -> None:
        '''
        :param image_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image_name ElastigroupAzure#image_name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "image_name": image_name,
            "resource_group_name": resource_group_name,
        }

    @builtins.property
    def image_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image_name ElastigroupAzure#image_name}.'''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureImageCustom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureImageMarketplace",
    jsii_struct_bases=[],
    name_mapping={"offer": "offer", "publisher": "publisher", "sku": "sku"},
)
class ElastigroupAzureImageMarketplace:
    def __init__(
        self,
        *,
        offer: builtins.str,
        publisher: builtins.str,
        sku: builtins.str,
    ) -> None:
        '''
        :param offer: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#offer ElastigroupAzure#offer}.
        :param publisher: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#publisher ElastigroupAzure#publisher}.
        :param sku: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#sku ElastigroupAzure#sku}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "offer": offer,
            "publisher": publisher,
            "sku": sku,
        }

    @builtins.property
    def offer(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#offer ElastigroupAzure#offer}.'''
        result = self._values.get("offer")
        assert result is not None, "Required property 'offer' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def publisher(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#publisher ElastigroupAzure#publisher}.'''
        result = self._values.get("publisher")
        assert result is not None, "Required property 'publisher' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sku(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#sku ElastigroupAzure#sku}.'''
        result = self._values.get("sku")
        assert result is not None, "Required property 'sku' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureImageMarketplace(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetes",
    jsii_struct_bases=[],
    name_mapping={"cluster_identifier": "clusterIdentifier"},
)
class ElastigroupAzureIntegrationKubernetes:
    def __init__(self, *, cluster_identifier: builtins.str) -> None:
        '''
        :param cluster_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cluster_identifier ElastigroupAzure#cluster_identifier}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "cluster_identifier": cluster_identifier,
        }

    @builtins.property
    def cluster_identifier(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cluster_identifier ElastigroupAzure#cluster_identifier}.'''
        result = self._values.get("cluster_identifier")
        assert result is not None, "Required property 'cluster_identifier' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureIntegrationKubernetes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureIntegrationKubernetesOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureIntegrationKubernetesOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterIdentifierInput")
    def cluster_identifier_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterIdentifierInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="clusterIdentifier")
    def cluster_identifier(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "clusterIdentifier"))

    @cluster_identifier.setter
    def cluster_identifier(self, value: builtins.str) -> None:
        jsii.set(self, "clusterIdentifier", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureIntegrationKubernetes]:
        return typing.cast(typing.Optional[ElastigroupAzureIntegrationKubernetes], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureIntegrationKubernetes],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntime",
    jsii_struct_bases=[],
    name_mapping={"deployment_id": "deploymentId"},
)
class ElastigroupAzureIntegrationMultaiRuntime:
    def __init__(self, *, deployment_id: builtins.str) -> None:
        '''
        :param deployment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#deployment_id ElastigroupAzure#deployment_id}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "deployment_id": deployment_id,
        }

    @builtins.property
    def deployment_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#deployment_id ElastigroupAzure#deployment_id}.'''
        result = self._values.get("deployment_id")
        assert result is not None, "Required property 'deployment_id' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureIntegrationMultaiRuntime(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureIntegrationMultaiRuntimeOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureIntegrationMultaiRuntimeOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentIdInput")
    def deployment_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "deploymentIdInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "deploymentId"))

    @deployment_id.setter
    def deployment_id(self, value: builtins.str) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[ElastigroupAzureIntegrationMultaiRuntime]:
        return typing.cast(typing.Optional[ElastigroupAzureIntegrationMultaiRuntime], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureIntegrationMultaiRuntime],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureLoadBalancers",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "auto_weight": "autoWeight",
        "balancer_id": "balancerId",
        "target_set_id": "targetSetId",
    },
)
class ElastigroupAzureLoadBalancers:
    def __init__(
        self,
        *,
        type: builtins.str,
        auto_weight: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        balancer_id: typing.Optional[builtins.str] = None,
        target_set_id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#type ElastigroupAzure#type}.
        :param auto_weight: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_weight ElastigroupAzure#auto_weight}.
        :param balancer_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#balancer_id ElastigroupAzure#balancer_id}.
        :param target_set_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target_set_id ElastigroupAzure#target_set_id}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if auto_weight is not None:
            self._values["auto_weight"] = auto_weight
        if balancer_id is not None:
            self._values["balancer_id"] = balancer_id
        if target_set_id is not None:
            self._values["target_set_id"] = target_set_id

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#type ElastigroupAzure#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def auto_weight(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_weight ElastigroupAzure#auto_weight}.'''
        result = self._values.get("auto_weight")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def balancer_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#balancer_id ElastigroupAzure#balancer_id}.'''
        result = self._values.get("balancer_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_set_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target_set_id ElastigroupAzure#target_set_id}.'''
        result = self._values.get("target_set_id")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureLoadBalancers(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureLogin",
    jsii_struct_bases=[],
    name_mapping={
        "user_name": "userName",
        "password": "password",
        "ssh_public_key": "sshPublicKey",
    },
)
class ElastigroupAzureLogin:
    def __init__(
        self,
        *,
        user_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        ssh_public_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param user_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_name ElastigroupAzure#user_name}.
        :param password: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#password ElastigroupAzure#password}.
        :param ssh_public_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#ssh_public_key ElastigroupAzure#ssh_public_key}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "user_name": user_name,
        }
        if password is not None:
            self._values["password"] = password
        if ssh_public_key is not None:
            self._values["ssh_public_key"] = ssh_public_key

    @builtins.property
    def user_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_name ElastigroupAzure#user_name}.'''
        result = self._values.get("user_name")
        assert result is not None, "Required property 'user_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#password ElastigroupAzure#password}.'''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ssh_public_key(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#ssh_public_key ElastigroupAzure#ssh_public_key}.'''
        result = self._values.get("ssh_public_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureLogin(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureLoginOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureLoginOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @jsii.member(jsii_name="resetSshPublicKey")
    def reset_ssh_public_key(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSshPublicKey", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sshPublicKeyInput")
    def ssh_public_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sshPublicKeyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userNameInput")
    def user_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "userNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        jsii.set(self, "password", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sshPublicKey")
    def ssh_public_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sshPublicKey"))

    @ssh_public_key.setter
    def ssh_public_key(self, value: builtins.str) -> None:
        jsii.set(self, "sshPublicKey", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userName")
    def user_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "userName"))

    @user_name.setter
    def user_name(self, value: builtins.str) -> None:
        jsii.set(self, "userName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureLogin]:
        return typing.cast(typing.Optional[ElastigroupAzureLogin], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAzureLogin]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureManagedServiceIdentities",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "resource_group_name": "resourceGroupName"},
)
class ElastigroupAzureManagedServiceIdentities:
    def __init__(
        self,
        *,
        name: builtins.str,
        resource_group_name: builtins.str,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "resource_group_name": resource_group_name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureManagedServiceIdentities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureNetwork",
    jsii_struct_bases=[],
    name_mapping={
        "resource_group_name": "resourceGroupName",
        "subnet_name": "subnetName",
        "virtual_network_name": "virtualNetworkName",
        "additional_ip_configs": "additionalIpConfigs",
        "assign_public_ip": "assignPublicIp",
    },
)
class ElastigroupAzureNetwork:
    def __init__(
        self,
        *,
        resource_group_name: builtins.str,
        subnet_name: builtins.str,
        virtual_network_name: builtins.str,
        additional_ip_configs: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureNetworkAdditionalIpConfigs"]]] = None,
        assign_public_ip: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
    ) -> None:
        '''
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.
        :param subnet_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#subnet_name ElastigroupAzure#subnet_name}.
        :param virtual_network_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#virtual_network_name ElastigroupAzure#virtual_network_name}.
        :param additional_ip_configs: additional_ip_configs block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#additional_ip_configs ElastigroupAzure#additional_ip_configs}
        :param assign_public_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#assign_public_ip ElastigroupAzure#assign_public_ip}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "resource_group_name": resource_group_name,
            "subnet_name": subnet_name,
            "virtual_network_name": virtual_network_name,
        }
        if additional_ip_configs is not None:
            self._values["additional_ip_configs"] = additional_ip_configs
        if assign_public_ip is not None:
            self._values["assign_public_ip"] = assign_public_ip

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subnet_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#subnet_name ElastigroupAzure#subnet_name}.'''
        result = self._values.get("subnet_name")
        assert result is not None, "Required property 'subnet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def virtual_network_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#virtual_network_name ElastigroupAzure#virtual_network_name}.'''
        result = self._values.get("virtual_network_name")
        assert result is not None, "Required property 'virtual_network_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def additional_ip_configs(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureNetworkAdditionalIpConfigs"]]]:
        '''additional_ip_configs block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#additional_ip_configs ElastigroupAzure#additional_ip_configs}
        '''
        result = self._values.get("additional_ip_configs")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureNetworkAdditionalIpConfigs"]]], result)

    @builtins.property
    def assign_public_ip(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#assign_public_ip ElastigroupAzure#assign_public_ip}.'''
        result = self._values.get("assign_public_ip")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureNetwork(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureNetworkAdditionalIpConfigs",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "private_ip_version": "privateIpVersion"},
)
class ElastigroupAzureNetworkAdditionalIpConfigs:
    def __init__(
        self,
        *,
        name: builtins.str,
        private_ip_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param private_ip_version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#private_ip_version ElastigroupAzure#private_ip_version}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if private_ip_version is not None:
            self._values["private_ip_version"] = private_ip_version

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def private_ip_version(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#private_ip_version ElastigroupAzure#private_ip_version}.'''
        result = self._values.get("private_ip_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureNetworkAdditionalIpConfigs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureNetworkOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureNetworkOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAdditionalIpConfigs")
    def reset_additional_ip_configs(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAdditionalIpConfigs", []))

    @jsii.member(jsii_name="resetAssignPublicIp")
    def reset_assign_public_ip(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAssignPublicIp", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="additionalIpConfigsInput")
    def additional_ip_configs_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureNetworkAdditionalIpConfigs]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureNetworkAdditionalIpConfigs]]], jsii.get(self, "additionalIpConfigsInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="assignPublicIpInput")
    def assign_public_ip_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "assignPublicIpInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceGroupNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subnetNameInput")
    def subnet_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subnetNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="virtualNetworkNameInput")
    def virtual_network_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "virtualNetworkNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="additionalIpConfigs")
    def additional_ip_configs(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureNetworkAdditionalIpConfigs]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureNetworkAdditionalIpConfigs]], jsii.get(self, "additionalIpConfigs"))

    @additional_ip_configs.setter
    def additional_ip_configs(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureNetworkAdditionalIpConfigs]],
    ) -> None:
        jsii.set(self, "additionalIpConfigs", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="assignPublicIp")
    def assign_public_ip(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "assignPublicIp"))

    @assign_public_ip.setter
    def assign_public_ip(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "assignPublicIp", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceGroupName"))

    @resource_group_name.setter
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="subnetName")
    def subnet_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "subnetName"))

    @subnet_name.setter
    def subnet_name(self, value: builtins.str) -> None:
        jsii.set(self, "subnetName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="virtualNetworkName")
    def virtual_network_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "virtualNetworkName"))

    @virtual_network_name.setter
    def virtual_network_name(self, value: builtins.str) -> None:
        jsii.set(self, "virtualNetworkName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureNetwork]:
        return typing.cast(typing.Optional[ElastigroupAzureNetwork], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAzureNetwork]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "policy_name": "policyName",
        "threshold": "threshold",
        "action_type": "actionType",
        "adjustment": "adjustment",
        "cooldown": "cooldown",
        "dimensions": "dimensions",
        "evaluation_periods": "evaluationPeriods",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "operator": "operator",
        "period": "period",
        "statistic": "statistic",
        "target": "target",
        "unit": "unit",
    },
)
class ElastigroupAzureScalingDownPolicy:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        namespace: builtins.str,
        policy_name: builtins.str,
        threshold: jsii.Number,
        action_type: typing.Optional[builtins.str] = None,
        adjustment: typing.Optional[builtins.str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingDownPolicyDimensions"]]] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        period: typing.Optional[jsii.Number] = None,
        statistic: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}.
        :param policy_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}.
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}.
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.
        :param cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}.
        :param operator: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}.
        :param period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}.
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "namespace": namespace,
            "policy_name": policy_name,
            "threshold": threshold,
        }
        if action_type is not None:
            self._values["action_type"] = action_type
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if operator is not None:
            self._values["operator"] = operator
        if period is not None:
            self._values["period"] = period
        if statistic is not None:
            self._values["statistic"] = statistic
        if target is not None:
            self._values["target"] = target
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}.'''
        result = self._values.get("policy_name")
        assert result is not None, "Required property 'policy_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}.'''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def action_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}.'''
        result = self._values.get("action_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}.'''
        result = self._values.get("cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicyDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingDownPolicyDimensions"]]], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}.'''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}.'''
        result = self._values.get("period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureScalingDownPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureScalingDownPolicyDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAzureScalingDownPolicyDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureScalingDownPolicyDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "policy_name": "policyName",
        "threshold": "threshold",
        "action_type": "actionType",
        "adjustment": "adjustment",
        "cooldown": "cooldown",
        "dimensions": "dimensions",
        "evaluation_periods": "evaluationPeriods",
        "maximum": "maximum",
        "max_target_capacity": "maxTargetCapacity",
        "minimum": "minimum",
        "min_target_capacity": "minTargetCapacity",
        "operator": "operator",
        "period": "period",
        "statistic": "statistic",
        "target": "target",
        "unit": "unit",
    },
)
class ElastigroupAzureScalingUpPolicy:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        namespace: builtins.str,
        policy_name: builtins.str,
        threshold: jsii.Number,
        action_type: typing.Optional[builtins.str] = None,
        adjustment: typing.Optional[builtins.str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        dimensions: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureScalingUpPolicyDimensions"]]] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        maximum: typing.Optional[builtins.str] = None,
        max_target_capacity: typing.Optional[builtins.str] = None,
        minimum: typing.Optional[builtins.str] = None,
        min_target_capacity: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        period: typing.Optional[jsii.Number] = None,
        statistic: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}.
        :param namespace: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}.
        :param policy_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}.
        :param threshold: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}.
        :param action_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.
        :param cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}.
        :param dimensions: dimensions block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
        :param evaluation_periods: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}.
        :param maximum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}.
        :param max_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}.
        :param minimum: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}.
        :param min_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}.
        :param operator: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}.
        :param period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}.
        :param statistic: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}.
        :param target: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}.
        :param unit: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "metric_name": metric_name,
            "namespace": namespace,
            "policy_name": policy_name,
            "threshold": threshold,
        }
        if action_type is not None:
            self._values["action_type"] = action_type
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_target_capacity is not None:
            self._values["max_target_capacity"] = max_target_capacity
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_target_capacity is not None:
            self._values["min_target_capacity"] = min_target_capacity
        if operator is not None:
            self._values["operator"] = operator
        if period is not None:
            self._values["period"] = period
        if statistic is not None:
            self._values["statistic"] = statistic
        if target is not None:
            self._values["target"] = target
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}.'''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}.'''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}.'''
        result = self._values.get("policy_name")
        assert result is not None, "Required property 'policy_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}.'''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def action_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}.'''
        result = self._values.get("action_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}.'''
        result = self._values.get("cooldown")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicyDimensions"]]]:
        '''dimensions block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
        '''
        result = self._values.get("dimensions")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureScalingUpPolicyDimensions"]]], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}.'''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def maximum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}.'''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}.'''
        result = self._values.get("max_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def minimum(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}.'''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def min_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}.'''
        result = self._values.get("min_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}.'''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}.'''
        result = self._values.get("period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def statistic(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}.'''
        result = self._values.get("statistic")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}.'''
        result = self._values.get("target")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}.'''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureScalingUpPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureScalingUpPolicyDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ElastigroupAzureScalingUpPolicyDimensions:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.
        :param value: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}.'''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureScalingUpPolicyDimensions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureScheduledTask",
    jsii_struct_bases=[],
    name_mapping={
        "cron_expression": "cronExpression",
        "task_type": "taskType",
        "adjustment": "adjustment",
        "adjustment_percentage": "adjustmentPercentage",
        "batch_size_percentage": "batchSizePercentage",
        "grace_period": "gracePeriod",
        "is_enabled": "isEnabled",
        "scale_max_capacity": "scaleMaxCapacity",
        "scale_min_capacity": "scaleMinCapacity",
        "scale_target_capacity": "scaleTargetCapacity",
    },
)
class ElastigroupAzureScheduledTask:
    def __init__(
        self,
        *,
        cron_expression: builtins.str,
        task_type: builtins.str,
        adjustment: typing.Optional[builtins.str] = None,
        adjustment_percentage: typing.Optional[builtins.str] = None,
        batch_size_percentage: typing.Optional[builtins.str] = None,
        grace_period: typing.Optional[builtins.str] = None,
        is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        scale_max_capacity: typing.Optional[builtins.str] = None,
        scale_min_capacity: typing.Optional[builtins.str] = None,
        scale_target_capacity: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param cron_expression: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cron_expression ElastigroupAzure#cron_expression}.
        :param task_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#task_type ElastigroupAzure#task_type}.
        :param adjustment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.
        :param adjustment_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment_percentage ElastigroupAzure#adjustment_percentage}.
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.
        :param is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#is_enabled ElastigroupAzure#is_enabled}.
        :param scale_max_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_max_capacity ElastigroupAzure#scale_max_capacity}.
        :param scale_min_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_min_capacity ElastigroupAzure#scale_min_capacity}.
        :param scale_target_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_target_capacity ElastigroupAzure#scale_target_capacity}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "cron_expression": cron_expression,
            "task_type": task_type,
        }
        if adjustment is not None:
            self._values["adjustment"] = adjustment
        if adjustment_percentage is not None:
            self._values["adjustment_percentage"] = adjustment_percentage
        if batch_size_percentage is not None:
            self._values["batch_size_percentage"] = batch_size_percentage
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if is_enabled is not None:
            self._values["is_enabled"] = is_enabled
        if scale_max_capacity is not None:
            self._values["scale_max_capacity"] = scale_max_capacity
        if scale_min_capacity is not None:
            self._values["scale_min_capacity"] = scale_min_capacity
        if scale_target_capacity is not None:
            self._values["scale_target_capacity"] = scale_target_capacity

    @builtins.property
    def cron_expression(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cron_expression ElastigroupAzure#cron_expression}.'''
        result = self._values.get("cron_expression")
        assert result is not None, "Required property 'cron_expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def task_type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#task_type ElastigroupAzure#task_type}.'''
        result = self._values.get("task_type")
        assert result is not None, "Required property 'task_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def adjustment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}.'''
        result = self._values.get("adjustment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def adjustment_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment_percentage ElastigroupAzure#adjustment_percentage}.'''
        result = self._values.get("adjustment_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def batch_size_percentage(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def grace_period(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#is_enabled ElastigroupAzure#is_enabled}.'''
        result = self._values.get("is_enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def scale_max_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_max_capacity ElastigroupAzure#scale_max_capacity}.'''
        result = self._values.get("scale_max_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_min_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_min_capacity ElastigroupAzure#scale_min_capacity}.'''
        result = self._values.get("scale_min_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scale_target_capacity(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_target_capacity ElastigroupAzure#scale_target_capacity}.'''
        result = self._values.get("scale_target_capacity")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureScheduledTask(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureStrategy",
    jsii_struct_bases=[],
    name_mapping={
        "draining_timeout": "drainingTimeout",
        "low_priority_percentage": "lowPriorityPercentage",
        "od_count": "odCount",
    },
)
class ElastigroupAzureStrategy:
    def __init__(
        self,
        *,
        draining_timeout: typing.Optional[jsii.Number] = None,
        low_priority_percentage: typing.Optional[jsii.Number] = None,
        od_count: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#draining_timeout ElastigroupAzure#draining_timeout}.
        :param low_priority_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_percentage ElastigroupAzure#low_priority_percentage}.
        :param od_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_count ElastigroupAzure#od_count}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if draining_timeout is not None:
            self._values["draining_timeout"] = draining_timeout
        if low_priority_percentage is not None:
            self._values["low_priority_percentage"] = low_priority_percentage
        if od_count is not None:
            self._values["od_count"] = od_count

    @builtins.property
    def draining_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#draining_timeout ElastigroupAzure#draining_timeout}.'''
        result = self._values.get("draining_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def low_priority_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_percentage ElastigroupAzure#low_priority_percentage}.'''
        result = self._values.get("low_priority_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def od_count(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_count ElastigroupAzure#od_count}.'''
        result = self._values.get("od_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureStrategyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureStrategyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetDrainingTimeout")
    def reset_draining_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDrainingTimeout", []))

    @jsii.member(jsii_name="resetLowPriorityPercentage")
    def reset_low_priority_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLowPriorityPercentage", []))

    @jsii.member(jsii_name="resetOdCount")
    def reset_od_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOdCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeoutInput")
    def draining_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "drainingTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lowPriorityPercentageInput")
    def low_priority_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "lowPriorityPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odCountInput")
    def od_count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "odCountInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeout")
    def draining_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "drainingTimeout"))

    @draining_timeout.setter
    def draining_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "drainingTimeout", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lowPriorityPercentage")
    def low_priority_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "lowPriorityPercentage"))

    @low_priority_percentage.setter
    def low_priority_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "lowPriorityPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odCount")
    def od_count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "odCount"))

    @od_count.setter
    def od_count(self, value: jsii.Number) -> None:
        jsii.set(self, "odCount", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureStrategy]:
        return typing.cast(typing.Optional[ElastigroupAzureStrategy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAzureStrategy]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicy",
    jsii_struct_bases=[],
    name_mapping={"should_roll": "shouldRoll", "roll_config": "rollConfig"},
)
class ElastigroupAzureUpdatePolicy:
    def __init__(
        self,
        *,
        should_roll: typing.Union[builtins.bool, cdktf.IResolvable],
        roll_config: typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"] = None,
    ) -> None:
        '''
        :param should_roll: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#should_roll ElastigroupAzure#should_roll}.
        :param roll_config: roll_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#roll_config ElastigroupAzure#roll_config}
        '''
        if isinstance(roll_config, dict):
            roll_config = ElastigroupAzureUpdatePolicyRollConfig(**roll_config)
        self._values: typing.Dict[str, typing.Any] = {
            "should_roll": should_roll,
        }
        if roll_config is not None:
            self._values["roll_config"] = roll_config

    @builtins.property
    def should_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#should_roll ElastigroupAzure#should_roll}.'''
        result = self._values.get("should_roll")
        assert result is not None, "Required property 'should_roll' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def roll_config(self) -> typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"]:
        '''roll_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#roll_config ElastigroupAzure#roll_config}
        '''
        result = self._values.get("roll_config")
        return typing.cast(typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureUpdatePolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureUpdatePolicyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putRollConfig")
    def put_roll_config(
        self,
        *,
        batch_size_percentage: jsii.Number,
        grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.
        '''
        value = ElastigroupAzureUpdatePolicyRollConfig(
            batch_size_percentage=batch_size_percentage,
            grace_period=grace_period,
            health_check_type=health_check_type,
        )

        return typing.cast(None, jsii.invoke(self, "putRollConfig", [value]))

    @jsii.member(jsii_name="resetRollConfig")
    def reset_roll_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRollConfig", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rollConfig")
    def roll_config(self) -> "ElastigroupAzureUpdatePolicyRollConfigOutputReference":
        return typing.cast("ElastigroupAzureUpdatePolicyRollConfigOutputReference", jsii.get(self, "rollConfig"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rollConfigInput")
    def roll_config_input(
        self,
    ) -> typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"]:
        return typing.cast(typing.Optional["ElastigroupAzureUpdatePolicyRollConfig"], jsii.get(self, "rollConfigInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldRollInput")
    def should_roll_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "shouldRollInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldRoll")
    def should_roll(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "shouldRoll"))

    @should_roll.setter
    def should_roll(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "shouldRoll", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureUpdatePolicy]:
        return typing.cast(typing.Optional[ElastigroupAzureUpdatePolicy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureUpdatePolicy],
    ) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicyRollConfig",
    jsii_struct_bases=[],
    name_mapping={
        "batch_size_percentage": "batchSizePercentage",
        "grace_period": "gracePeriod",
        "health_check_type": "healthCheckType",
    },
)
class ElastigroupAzureUpdatePolicyRollConfig:
    def __init__(
        self,
        *,
        batch_size_percentage: jsii.Number,
        grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param batch_size_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}.
        :param grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "batch_size_percentage": batch_size_percentage,
        }
        if grace_period is not None:
            self._values["grace_period"] = grace_period
        if health_check_type is not None:
            self._values["health_check_type"] = health_check_type

    @builtins.property
    def batch_size_percentage(self) -> jsii.Number:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}.'''
        result = self._values.get("batch_size_percentage")
        assert result is not None, "Required property 'batch_size_percentage' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def grace_period(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}.'''
        result = self._values.get("grace_period")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def health_check_type(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}.'''
        result = self._values.get("health_check_type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureUpdatePolicyRollConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureUpdatePolicyRollConfigOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureUpdatePolicyRollConfigOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetGracePeriod")
    def reset_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGracePeriod", []))

    @jsii.member(jsii_name="resetHealthCheckType")
    def reset_health_check_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckType", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentageInput")
    def batch_size_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "batchSizePercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriodInput")
    def grace_period_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "gracePeriodInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckTypeInput")
    def health_check_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "healthCheckTypeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="batchSizePercentage")
    def batch_size_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "batchSizePercentage"))

    @batch_size_percentage.setter
    def batch_size_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "batchSizePercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="gracePeriod")
    def grace_period(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "gracePeriod"))

    @grace_period.setter
    def grace_period(self, value: jsii.Number) -> None:
        jsii.set(self, "gracePeriod", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "healthCheckType"))

    @health_check_type.setter
    def health_check_type(self, value: builtins.str) -> None:
        jsii.set(self, "healthCheckType", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureUpdatePolicyRollConfig]:
        return typing.cast(typing.Optional[ElastigroupAzureUpdatePolicyRollConfig], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureUpdatePolicyRollConfig],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupAzureV3(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3 spotinst_elastigroup_azure_v3}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        network: "ElastigroupAzureV3Network",
        od_sizes: typing.Sequence[builtins.str],
        os: builtins.str,
        region: builtins.str,
        resource_group_name: builtins.str,
        spot_sizes: typing.Sequence[builtins.str],
        strategy: "ElastigroupAzureV3Strategy",
        custom_data: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        image: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3Image"]]] = None,
        login: typing.Optional["ElastigroupAzureV3Login"] = None,
        managed_service_identity: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3ManagedServiceIdentity"]]] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3 spotinst_elastigroup_azure_v3} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.
        :param network: network block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network ElastigroupAzureV3#network}
        :param od_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_sizes ElastigroupAzureV3#od_sizes}.
        :param os: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#os ElastigroupAzureV3#os}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#region ElastigroupAzureV3#region}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        :param spot_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_sizes ElastigroupAzureV3#spot_sizes}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#strategy ElastigroupAzureV3#strategy}
        :param custom_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#custom_data ElastigroupAzureV3#custom_data}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#desired_capacity ElastigroupAzureV3#desired_capacity}.
        :param image: image block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#image ElastigroupAzureV3#image}
        :param login: login block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#login ElastigroupAzureV3#login}
        :param managed_service_identity: managed_service_identity block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#managed_service_identity ElastigroupAzureV3#managed_service_identity}
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#max_size ElastigroupAzureV3#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#min_size ElastigroupAzureV3#min_size}.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupAzureV3Config(
            name=name,
            network=network,
            od_sizes=od_sizes,
            os=os,
            region=region,
            resource_group_name=resource_group_name,
            spot_sizes=spot_sizes,
            strategy=strategy,
            custom_data=custom_data,
            desired_capacity=desired_capacity,
            image=image,
            login=login,
            managed_service_identity=managed_service_identity,
            max_size=max_size,
            min_size=min_size,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putLogin")
    def put_login(
        self,
        *,
        user_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        ssh_public_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param user_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#user_name ElastigroupAzureV3#user_name}.
        :param password: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#password ElastigroupAzureV3#password}.
        :param ssh_public_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#ssh_public_key ElastigroupAzureV3#ssh_public_key}.
        '''
        value = ElastigroupAzureV3Login(
            user_name=user_name, password=password, ssh_public_key=ssh_public_key
        )

        return typing.cast(None, jsii.invoke(self, "putLogin", [value]))

    @jsii.member(jsii_name="putNetwork")
    def put_network(
        self,
        *,
        network_interfaces: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3NetworkNetworkInterfaces"]],
        resource_group_name: builtins.str,
        virtual_network_name: builtins.str,
    ) -> None:
        '''
        :param network_interfaces: network_interfaces block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network_interfaces ElastigroupAzureV3#network_interfaces}
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        :param virtual_network_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#virtual_network_name ElastigroupAzureV3#virtual_network_name}.
        '''
        value = ElastigroupAzureV3Network(
            network_interfaces=network_interfaces,
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
        )

        return typing.cast(None, jsii.invoke(self, "putNetwork", [value]))

    @jsii.member(jsii_name="putStrategy")
    def put_strategy(
        self,
        *,
        draining_timeout: typing.Optional[jsii.Number] = None,
        fallback_to_on_demand: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        od_count: typing.Optional[jsii.Number] = None,
        spot_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#draining_timeout ElastigroupAzureV3#draining_timeout}.
        :param fallback_to_on_demand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#fallback_to_on_demand ElastigroupAzureV3#fallback_to_on_demand}.
        :param od_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_count ElastigroupAzureV3#od_count}.
        :param spot_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_percentage ElastigroupAzureV3#spot_percentage}.
        '''
        value = ElastigroupAzureV3Strategy(
            draining_timeout=draining_timeout,
            fallback_to_on_demand=fallback_to_on_demand,
            od_count=od_count,
            spot_percentage=spot_percentage,
        )

        return typing.cast(None, jsii.invoke(self, "putStrategy", [value]))

    @jsii.member(jsii_name="resetCustomData")
    def reset_custom_data(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomData", []))

    @jsii.member(jsii_name="resetDesiredCapacity")
    def reset_desired_capacity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDesiredCapacity", []))

    @jsii.member(jsii_name="resetImage")
    def reset_image(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetImage", []))

    @jsii.member(jsii_name="resetLogin")
    def reset_login(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLogin", []))

    @jsii.member(jsii_name="resetManagedServiceIdentity")
    def reset_managed_service_identity(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManagedServiceIdentity", []))

    @jsii.member(jsii_name="resetMaxSize")
    def reset_max_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaxSize", []))

    @jsii.member(jsii_name="resetMinSize")
    def reset_min_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMinSize", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="login")
    def login(self) -> "ElastigroupAzureV3LoginOutputReference":
        return typing.cast("ElastigroupAzureV3LoginOutputReference", jsii.get(self, "login"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="network")
    def network(self) -> "ElastigroupAzureV3NetworkOutputReference":
        return typing.cast("ElastigroupAzureV3NetworkOutputReference", jsii.get(self, "network"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> "ElastigroupAzureV3StrategyOutputReference":
        return typing.cast("ElastigroupAzureV3StrategyOutputReference", jsii.get(self, "strategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customDataInput")
    def custom_data_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customDataInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacityInput")
    def desired_capacity_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "desiredCapacityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="imageInput")
    def image_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]]], jsii.get(self, "imageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="loginInput")
    def login_input(self) -> typing.Optional["ElastigroupAzureV3Login"]:
        return typing.cast(typing.Optional["ElastigroupAzureV3Login"], jsii.get(self, "loginInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedServiceIdentityInput")
    def managed_service_identity_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]]], jsii.get(self, "managedServiceIdentityInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSizeInput")
    def max_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maxSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSizeInput")
    def min_size_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "minSizeInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInput")
    def network_input(self) -> typing.Optional["ElastigroupAzureV3Network"]:
        return typing.cast(typing.Optional["ElastigroupAzureV3Network"], jsii.get(self, "networkInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odSizesInput")
    def od_sizes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "odSizesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="osInput")
    def os_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "osInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="regionInput")
    def region_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceGroupNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotSizesInput")
    def spot_sizes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "spotSizesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategyInput")
    def strategy_input(self) -> typing.Optional["ElastigroupAzureV3Strategy"]:
        return typing.cast(typing.Optional["ElastigroupAzureV3Strategy"], jsii.get(self, "strategyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="customData")
    def custom_data(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customData"))

    @custom_data.setter
    def custom_data(self, value: builtins.str) -> None:
        jsii.set(self, "customData", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "desiredCapacity"))

    @desired_capacity.setter
    def desired_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="image")
    def image(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]], jsii.get(self, "image"))

    @image.setter
    def image(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]],
    ) -> None:
        jsii.set(self, "image", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="managedServiceIdentity")
    def managed_service_identity(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]], jsii.get(self, "managedServiceIdentity"))

    @managed_service_identity.setter
    def managed_service_identity(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]],
    ) -> None:
        jsii.set(self, "managedServiceIdentity", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maxSize"))

    @max_size.setter
    def max_size(self, value: jsii.Number) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minSize"))

    @min_size.setter
    def min_size(self, value: jsii.Number) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odSizes")
    def od_sizes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "odSizes"))

    @od_sizes.setter
    def od_sizes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "odSizes", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="os")
    def os(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "os"))

    @os.setter
    def os(self, value: builtins.str) -> None:
        jsii.set(self, "os", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="region")
    def region(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "region"))

    @region.setter
    def region(self, value: builtins.str) -> None:
        jsii.set(self, "region", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceGroupName"))

    @resource_group_name.setter
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotSizes")
    def spot_sizes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "spotSizes"))

    @spot_sizes.setter
    def spot_sizes(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "spotSizes", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3Config",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "network": "network",
        "od_sizes": "odSizes",
        "os": "os",
        "region": "region",
        "resource_group_name": "resourceGroupName",
        "spot_sizes": "spotSizes",
        "strategy": "strategy",
        "custom_data": "customData",
        "desired_capacity": "desiredCapacity",
        "image": "image",
        "login": "login",
        "managed_service_identity": "managedServiceIdentity",
        "max_size": "maxSize",
        "min_size": "minSize",
    },
)
class ElastigroupAzureV3Config(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
        network: "ElastigroupAzureV3Network",
        od_sizes: typing.Sequence[builtins.str],
        os: builtins.str,
        region: builtins.str,
        resource_group_name: builtins.str,
        spot_sizes: typing.Sequence[builtins.str],
        strategy: "ElastigroupAzureV3Strategy",
        custom_data: typing.Optional[builtins.str] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        image: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3Image"]]] = None,
        login: typing.Optional["ElastigroupAzureV3Login"] = None,
        managed_service_identity: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3ManagedServiceIdentity"]]] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.
        :param network: network block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network ElastigroupAzureV3#network}
        :param od_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_sizes ElastigroupAzureV3#od_sizes}.
        :param os: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#os ElastigroupAzureV3#os}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#region ElastigroupAzureV3#region}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        :param spot_sizes: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_sizes ElastigroupAzureV3#spot_sizes}.
        :param strategy: strategy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#strategy ElastigroupAzureV3#strategy}
        :param custom_data: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#custom_data ElastigroupAzureV3#custom_data}.
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#desired_capacity ElastigroupAzureV3#desired_capacity}.
        :param image: image block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#image ElastigroupAzureV3#image}
        :param login: login block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#login ElastigroupAzureV3#login}
        :param managed_service_identity: managed_service_identity block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#managed_service_identity ElastigroupAzureV3#managed_service_identity}
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#max_size ElastigroupAzureV3#max_size}.
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#min_size ElastigroupAzureV3#min_size}.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(network, dict):
            network = ElastigroupAzureV3Network(**network)
        if isinstance(strategy, dict):
            strategy = ElastigroupAzureV3Strategy(**strategy)
        if isinstance(login, dict):
            login = ElastigroupAzureV3Login(**login)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "network": network,
            "od_sizes": od_sizes,
            "os": os,
            "region": region,
            "resource_group_name": resource_group_name,
            "spot_sizes": spot_sizes,
            "strategy": strategy,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if custom_data is not None:
            self._values["custom_data"] = custom_data
        if desired_capacity is not None:
            self._values["desired_capacity"] = desired_capacity
        if image is not None:
            self._values["image"] = image
        if login is not None:
            self._values["login"] = login
        if managed_service_identity is not None:
            self._values["managed_service_identity"] = managed_service_identity
        if max_size is not None:
            self._values["max_size"] = max_size
        if min_size is not None:
            self._values["min_size"] = min_size

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def network(self) -> "ElastigroupAzureV3Network":
        '''network block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network ElastigroupAzureV3#network}
        '''
        result = self._values.get("network")
        assert result is not None, "Required property 'network' is missing"
        return typing.cast("ElastigroupAzureV3Network", result)

    @builtins.property
    def od_sizes(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_sizes ElastigroupAzureV3#od_sizes}.'''
        result = self._values.get("od_sizes")
        assert result is not None, "Required property 'od_sizes' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def os(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#os ElastigroupAzureV3#os}.'''
        result = self._values.get("os")
        assert result is not None, "Required property 'os' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def region(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#region ElastigroupAzureV3#region}.'''
        result = self._values.get("region")
        assert result is not None, "Required property 'region' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def spot_sizes(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_sizes ElastigroupAzureV3#spot_sizes}.'''
        result = self._values.get("spot_sizes")
        assert result is not None, "Required property 'spot_sizes' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def strategy(self) -> "ElastigroupAzureV3Strategy":
        '''strategy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#strategy ElastigroupAzureV3#strategy}
        '''
        result = self._values.get("strategy")
        assert result is not None, "Required property 'strategy' is missing"
        return typing.cast("ElastigroupAzureV3Strategy", result)

    @builtins.property
    def custom_data(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#custom_data ElastigroupAzureV3#custom_data}.'''
        result = self._values.get("custom_data")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#desired_capacity ElastigroupAzureV3#desired_capacity}.'''
        result = self._values.get("desired_capacity")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def image(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]]]:
        '''image block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#image ElastigroupAzureV3#image}
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3Image"]]], result)

    @builtins.property
    def login(self) -> typing.Optional["ElastigroupAzureV3Login"]:
        '''login block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#login ElastigroupAzureV3#login}
        '''
        result = self._values.get("login")
        return typing.cast(typing.Optional["ElastigroupAzureV3Login"], result)

    @builtins.property
    def managed_service_identity(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]]]:
        '''managed_service_identity block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#managed_service_identity ElastigroupAzureV3#managed_service_identity}
        '''
        result = self._values.get("managed_service_identity")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ManagedServiceIdentity"]]], result)

    @builtins.property
    def max_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#max_size ElastigroupAzureV3#max_size}.'''
        result = self._values.get("max_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_size(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#min_size ElastigroupAzureV3#min_size}.'''
        result = self._values.get("min_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3Config(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3Image",
    jsii_struct_bases=[],
    name_mapping={"custom": "custom", "marketplace": "marketplace"},
)
class ElastigroupAzureV3Image:
    def __init__(
        self,
        *,
        custom: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3ImageCustom"]]] = None,
        marketplace: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3ImageMarketplace"]]] = None,
    ) -> None:
        '''
        :param custom: custom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#custom ElastigroupAzureV3#custom}
        :param marketplace: marketplace block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#marketplace ElastigroupAzureV3#marketplace}
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if custom is not None:
            self._values["custom"] = custom
        if marketplace is not None:
            self._values["marketplace"] = marketplace

    @builtins.property
    def custom(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ImageCustom"]]]:
        '''custom block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#custom ElastigroupAzureV3#custom}
        '''
        result = self._values.get("custom")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ImageCustom"]]], result)

    @builtins.property
    def marketplace(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ImageMarketplace"]]]:
        '''marketplace block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#marketplace ElastigroupAzureV3#marketplace}
        '''
        result = self._values.get("marketplace")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3ImageMarketplace"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3Image(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3ImageCustom",
    jsii_struct_bases=[],
    name_mapping={
        "image_name": "imageName",
        "resource_group_name": "resourceGroupName",
    },
)
class ElastigroupAzureV3ImageCustom:
    def __init__(
        self,
        *,
        image_name: builtins.str,
        resource_group_name: builtins.str,
    ) -> None:
        '''
        :param image_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#image_name ElastigroupAzureV3#image_name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "image_name": image_name,
            "resource_group_name": resource_group_name,
        }

    @builtins.property
    def image_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#image_name ElastigroupAzureV3#image_name}.'''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3ImageCustom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3ImageMarketplace",
    jsii_struct_bases=[],
    name_mapping={
        "offer": "offer",
        "publisher": "publisher",
        "sku": "sku",
        "version": "version",
    },
)
class ElastigroupAzureV3ImageMarketplace:
    def __init__(
        self,
        *,
        offer: builtins.str,
        publisher: builtins.str,
        sku: builtins.str,
        version: builtins.str,
    ) -> None:
        '''
        :param offer: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#offer ElastigroupAzureV3#offer}.
        :param publisher: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#publisher ElastigroupAzureV3#publisher}.
        :param sku: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#sku ElastigroupAzureV3#sku}.
        :param version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#version ElastigroupAzureV3#version}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "offer": offer,
            "publisher": publisher,
            "sku": sku,
            "version": version,
        }

    @builtins.property
    def offer(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#offer ElastigroupAzureV3#offer}.'''
        result = self._values.get("offer")
        assert result is not None, "Required property 'offer' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def publisher(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#publisher ElastigroupAzureV3#publisher}.'''
        result = self._values.get("publisher")
        assert result is not None, "Required property 'publisher' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sku(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#sku ElastigroupAzureV3#sku}.'''
        result = self._values.get("sku")
        assert result is not None, "Required property 'sku' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def version(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#version ElastigroupAzureV3#version}.'''
        result = self._values.get("version")
        assert result is not None, "Required property 'version' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3ImageMarketplace(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3Login",
    jsii_struct_bases=[],
    name_mapping={
        "user_name": "userName",
        "password": "password",
        "ssh_public_key": "sshPublicKey",
    },
)
class ElastigroupAzureV3Login:
    def __init__(
        self,
        *,
        user_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        ssh_public_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param user_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#user_name ElastigroupAzureV3#user_name}.
        :param password: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#password ElastigroupAzureV3#password}.
        :param ssh_public_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#ssh_public_key ElastigroupAzureV3#ssh_public_key}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "user_name": user_name,
        }
        if password is not None:
            self._values["password"] = password
        if ssh_public_key is not None:
            self._values["ssh_public_key"] = ssh_public_key

    @builtins.property
    def user_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#user_name ElastigroupAzureV3#user_name}.'''
        result = self._values.get("user_name")
        assert result is not None, "Required property 'user_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#password ElastigroupAzureV3#password}.'''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ssh_public_key(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#ssh_public_key ElastigroupAzureV3#ssh_public_key}.'''
        result = self._values.get("ssh_public_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3Login(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureV3LoginOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3LoginOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @jsii.member(jsii_name="resetSshPublicKey")
    def reset_ssh_public_key(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSshPublicKey", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sshPublicKeyInput")
    def ssh_public_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sshPublicKeyInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userNameInput")
    def user_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "userNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        jsii.set(self, "password", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="sshPublicKey")
    def ssh_public_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sshPublicKey"))

    @ssh_public_key.setter
    def ssh_public_key(self, value: builtins.str) -> None:
        jsii.set(self, "sshPublicKey", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="userName")
    def user_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "userName"))

    @user_name.setter
    def user_name(self, value: builtins.str) -> None:
        jsii.set(self, "userName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureV3Login]:
        return typing.cast(typing.Optional[ElastigroupAzureV3Login], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAzureV3Login]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3ManagedServiceIdentity",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "resource_group_name": "resourceGroupName"},
)
class ElastigroupAzureV3ManagedServiceIdentity:
    def __init__(
        self,
        *,
        name: builtins.str,
        resource_group_name: builtins.str,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "resource_group_name": resource_group_name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3ManagedServiceIdentity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3Network",
    jsii_struct_bases=[],
    name_mapping={
        "network_interfaces": "networkInterfaces",
        "resource_group_name": "resourceGroupName",
        "virtual_network_name": "virtualNetworkName",
    },
)
class ElastigroupAzureV3Network:
    def __init__(
        self,
        *,
        network_interfaces: typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3NetworkNetworkInterfaces"]],
        resource_group_name: builtins.str,
        virtual_network_name: builtins.str,
    ) -> None:
        '''
        :param network_interfaces: network_interfaces block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network_interfaces ElastigroupAzureV3#network_interfaces}
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        :param virtual_network_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#virtual_network_name ElastigroupAzureV3#virtual_network_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "network_interfaces": network_interfaces,
            "resource_group_name": resource_group_name,
            "virtual_network_name": virtual_network_name,
        }

    @builtins.property
    def network_interfaces(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfaces"]]:
        '''network_interfaces block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#network_interfaces ElastigroupAzureV3#network_interfaces}
        '''
        result = self._values.get("network_interfaces")
        assert result is not None, "Required property 'network_interfaces' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfaces"]], result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def virtual_network_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#virtual_network_name ElastigroupAzureV3#virtual_network_name}.'''
        result = self._values.get("virtual_network_name")
        assert result is not None, "Required property 'virtual_network_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3Network(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3NetworkNetworkInterfaces",
    jsii_struct_bases=[],
    name_mapping={
        "assign_public_ip": "assignPublicIp",
        "is_primary": "isPrimary",
        "subnet_name": "subnetName",
        "additional_ip_configs": "additionalIpConfigs",
        "application_security_group": "applicationSecurityGroup",
    },
)
class ElastigroupAzureV3NetworkNetworkInterfaces:
    def __init__(
        self,
        *,
        assign_public_ip: typing.Union[builtins.bool, cdktf.IResolvable],
        is_primary: typing.Union[builtins.bool, cdktf.IResolvable],
        subnet_name: builtins.str,
        additional_ip_configs: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs"]]] = None,
        application_security_group: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup"]]] = None,
    ) -> None:
        '''
        :param assign_public_ip: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#assign_public_ip ElastigroupAzureV3#assign_public_ip}.
        :param is_primary: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#is_primary ElastigroupAzureV3#is_primary}.
        :param subnet_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#subnet_name ElastigroupAzureV3#subnet_name}.
        :param additional_ip_configs: additional_ip_configs block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#additional_ip_configs ElastigroupAzureV3#additional_ip_configs}
        :param application_security_group: application_security_group block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#application_security_group ElastigroupAzureV3#application_security_group}
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "assign_public_ip": assign_public_ip,
            "is_primary": is_primary,
            "subnet_name": subnet_name,
        }
        if additional_ip_configs is not None:
            self._values["additional_ip_configs"] = additional_ip_configs
        if application_security_group is not None:
            self._values["application_security_group"] = application_security_group

    @builtins.property
    def assign_public_ip(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#assign_public_ip ElastigroupAzureV3#assign_public_ip}.'''
        result = self._values.get("assign_public_ip")
        assert result is not None, "Required property 'assign_public_ip' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def is_primary(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#is_primary ElastigroupAzureV3#is_primary}.'''
        result = self._values.get("is_primary")
        assert result is not None, "Required property 'is_primary' is missing"
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], result)

    @builtins.property
    def subnet_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#subnet_name ElastigroupAzureV3#subnet_name}.'''
        result = self._values.get("subnet_name")
        assert result is not None, "Required property 'subnet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def additional_ip_configs(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs"]]]:
        '''additional_ip_configs block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#additional_ip_configs ElastigroupAzureV3#additional_ip_configs}
        '''
        result = self._values.get("additional_ip_configs")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs"]]], result)

    @builtins.property
    def application_security_group(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup"]]]:
        '''application_security_group block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#application_security_group ElastigroupAzureV3#application_security_group}
        '''
        result = self._values.get("application_security_group")
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3NetworkNetworkInterfaces(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "private_ip_version": "privateIpVersion"},
)
class ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs:
    def __init__(
        self,
        *,
        name: builtins.str,
        private_ip_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.
        :param private_ip_version: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#private_ip_version ElastigroupAzureV3#private_ip_version}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if private_ip_version is not None:
            self._values["private_ip_version"] = private_ip_version

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def private_ip_version(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#private_ip_version ElastigroupAzureV3#private_ip_version}.'''
        result = self._values.get("private_ip_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3NetworkNetworkInterfacesAdditionalIpConfigs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "resource_group_name": "resourceGroupName"},
)
class ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup:
    def __init__(
        self,
        *,
        name: builtins.str,
        resource_group_name: builtins.str,
    ) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "resource_group_name": resource_group_name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#name ElastigroupAzureV3#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#resource_group_name ElastigroupAzureV3#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3NetworkNetworkInterfacesApplicationSecurityGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureV3NetworkOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3NetworkOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInterfacesInput")
    def network_interfaces_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureV3NetworkNetworkInterfaces]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureV3NetworkNetworkInterfaces]]], jsii.get(self, "networkInterfacesInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceGroupNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="virtualNetworkNameInput")
    def virtual_network_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "virtualNetworkNameInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkInterfaces")
    def network_interfaces(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureV3NetworkNetworkInterfaces]]:
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureV3NetworkNetworkInterfaces]], jsii.get(self, "networkInterfaces"))

    @network_interfaces.setter
    def network_interfaces(
        self,
        value: typing.Union[cdktf.IResolvable, typing.List[ElastigroupAzureV3NetworkNetworkInterfaces]],
    ) -> None:
        jsii.set(self, "networkInterfaces", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceGroupName"))

    @resource_group_name.setter
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="virtualNetworkName")
    def virtual_network_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "virtualNetworkName"))

    @virtual_network_name.setter
    def virtual_network_name(self, value: builtins.str) -> None:
        jsii.set(self, "virtualNetworkName", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureV3Network]:
        return typing.cast(typing.Optional[ElastigroupAzureV3Network], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[ElastigroupAzureV3Network]) -> None:
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3Strategy",
    jsii_struct_bases=[],
    name_mapping={
        "draining_timeout": "drainingTimeout",
        "fallback_to_on_demand": "fallbackToOnDemand",
        "od_count": "odCount",
        "spot_percentage": "spotPercentage",
    },
)
class ElastigroupAzureV3Strategy:
    def __init__(
        self,
        *,
        draining_timeout: typing.Optional[jsii.Number] = None,
        fallback_to_on_demand: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        od_count: typing.Optional[jsii.Number] = None,
        spot_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#draining_timeout ElastigroupAzureV3#draining_timeout}.
        :param fallback_to_on_demand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#fallback_to_on_demand ElastigroupAzureV3#fallback_to_on_demand}.
        :param od_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_count ElastigroupAzureV3#od_count}.
        :param spot_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_percentage ElastigroupAzureV3#spot_percentage}.
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if draining_timeout is not None:
            self._values["draining_timeout"] = draining_timeout
        if fallback_to_on_demand is not None:
            self._values["fallback_to_on_demand"] = fallback_to_on_demand
        if od_count is not None:
            self._values["od_count"] = od_count
        if spot_percentage is not None:
            self._values["spot_percentage"] = spot_percentage

    @builtins.property
    def draining_timeout(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#draining_timeout ElastigroupAzureV3#draining_timeout}.'''
        result = self._values.get("draining_timeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fallback_to_on_demand(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#fallback_to_on_demand ElastigroupAzureV3#fallback_to_on_demand}.'''
        result = self._values.get("fallback_to_on_demand")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def od_count(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#od_count ElastigroupAzureV3#od_count}.'''
        result = self._values.get("od_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def spot_percentage(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure_v3#spot_percentage ElastigroupAzureV3#spot_percentage}.'''
        result = self._values.get("spot_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastigroupAzureV3Strategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastigroupAzureV3StrategyOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupAzureV3StrategyOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetDrainingTimeout")
    def reset_draining_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDrainingTimeout", []))

    @jsii.member(jsii_name="resetFallbackToOnDemand")
    def reset_fallback_to_on_demand(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFallbackToOnDemand", []))

    @jsii.member(jsii_name="resetOdCount")
    def reset_od_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOdCount", []))

    @jsii.member(jsii_name="resetSpotPercentage")
    def reset_spot_percentage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSpotPercentage", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeoutInput")
    def draining_timeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "drainingTimeoutInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fallbackToOnDemandInput")
    def fallback_to_on_demand_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "fallbackToOnDemandInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odCountInput")
    def od_count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "odCountInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotPercentageInput")
    def spot_percentage_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "spotPercentageInput"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="drainingTimeout")
    def draining_timeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "drainingTimeout"))

    @draining_timeout.setter
    def draining_timeout(self, value: jsii.Number) -> None:
        jsii.set(self, "drainingTimeout", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fallbackToOnDemand")
    def fallback_to_on_demand(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "fallbackToOnDemand"))

    @fallback_to_on_demand.setter
    def fallback_to_on_demand(
        self,
        value: typing.Union[builtins.bool, cdktf.IResolvable],
    ) -> None:
        jsii.set(self, "fallbackToOnDemand", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="odCount")
    def od_count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "odCount"))

    @od_count.setter
    def od_count(self, value: jsii.Number) -> None:
        jsii.set(self, "odCount", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="spotPercentage")
    def spot_percentage(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "spotPercentage"))

    @spot_percentage.setter
    def spot_percentage(self, value: jsii.Number) -> None:
        jsii.set(self, "spotPercentage", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[ElastigroupAzureV3Strategy]:
        return typing.cast(typing.Optional[ElastigroupAzureV3Strategy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[ElastigroupAzureV3Strategy],
    ) -> None:
        jsii.set(self, "internalValue", value)


class ElastigroupGcp(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-spotinst.ElastigroupGcp",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        desired_capacity: jsii.Number,
        name: builtins.str,
        auto_healing: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        availability_zones: typing.Optional[typing.Sequence[builtins.str]] = None,
        backend_services: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpBackendServices"]]] = None,
        description: typing.Optional[builtins.str] = None,
        disk: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpDisk"]]] = None,
        draining_timeout: typing.Optional[jsii.Number] = None,
        fallback_to_ondemand: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        gpu: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpGpu"]]] = None,
        health_check_grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[builtins.str] = None,
        instance_types_custom: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpInstanceTypesCustom"]]] = None,
        instance_types_ondemand: typing.Optional[builtins.str] = None,
        instance_types_preemptible: typing.Optional[typing.Sequence[builtins.str]] = None,
        integration_docker_swarm: typing.Optional["ElastigroupGcpIntegrationDockerSwarm"] = None,
        integration_gke: typing.Optional["ElastigroupGcpIntegrationGke"] = None,
        ip_forwarding: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        labels: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpLabels"]]] = None,
        max_size: typing.Optional[jsii.Number] = None,
        metadata: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpMetadata"]]] = None,
        min_size: typing.Optional[jsii.Number] = None,
        network_interface: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpNetworkInterface"]]] = None,
        ondemand_count: typing.Optional[jsii.Number] = None,
        preemptible_percentage: typing.Optional[jsii.Number] = None,
        provisioning_model: typing.Optional[builtins.str] = None,
        scaling_down_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpScalingDownPolicy"]]] = None,
        scaling_up_policy: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpScalingUpPolicy"]]] = None,
        scheduled_task: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpScheduledTask"]]] = None,
        service_account: typing.Optional[builtins.str] = None,
        shutdown_script: typing.Optional[builtins.str] = None,
        startup_script: typing.Optional[builtins.str] = None,
        subnets: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpSubnets"]]] = None,
        tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        unhealthy_duration: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp} Resource.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param desired_capacity: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#desired_capacity ElastigroupGcp#desired_capacity}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}.
        :param auto_healing: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_healing ElastigroupGcp#auto_healing}.
        :param availability_zones: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#availability_zones ElastigroupGcp#availability_zones}.
        :param backend_services: backend_services block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#backend_services ElastigroupGcp#backend_services}
        :param description: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#description ElastigroupGcp#description}.
        :param disk: disk block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk ElastigroupGcp#disk}
        :param draining_timeout: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#draining_timeout ElastigroupGcp#draining_timeout}.
        :param fallback_to_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#fallback_to_ondemand ElastigroupGcp#fallback_to_ondemand}.
        :param gpu: gpu block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#gpu ElastigroupGcp#gpu}
        :param health_check_grace_period: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_grace_period ElastigroupGcp#health_check_grace_period}.
        :param health_check_type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_type ElastigroupGcp#health_check_type}.
        :param instance_types_custom: instance_types_custom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_custom ElastigroupGcp#instance_types_custom}
        :param instance_types_ondemand: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_ondemand ElastigroupGcp#instance_types_ondemand}.
        :param instance_types_preemptible: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_preemptible ElastigroupGcp#instance_types_preemptible}.
        :param integration_docker_swarm: integration_docker_swarm block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_docker_swarm ElastigroupGcp#integration_docker_swarm}
        :param integration_gke: integration_gke block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_gke ElastigroupGcp#integration_gke}
        :param ip_forwarding: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ip_forwarding ElastigroupGcp#ip_forwarding}.
        :param labels: labels block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#labels ElastigroupGcp#labels}
        :param max_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#max_size ElastigroupGcp#max_size}.
        :param metadata: metadata block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metadata ElastigroupGcp#metadata}
        :param min_size: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#min_size ElastigroupGcp#min_size}.
        :param network_interface: network_interface block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#network_interface ElastigroupGcp#network_interface}
        :param ondemand_count: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ondemand_count ElastigroupGcp#ondemand_count}.
        :param preemptible_percentage: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#preemptible_percentage ElastigroupGcp#preemptible_percentage}.
        :param provisioning_model: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#provisioning_model ElastigroupGcp#provisioning_model}.
        :param scaling_down_policy: scaling_down_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_down_policy ElastigroupGcp#scaling_down_policy}
        :param scaling_up_policy: scaling_up_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_up_policy ElastigroupGcp#scaling_up_policy}
        :param scheduled_task: scheduled_task block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scheduled_task ElastigroupGcp#scheduled_task}
        :param service_account: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#service_account ElastigroupGcp#service_account}.
        :param shutdown_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#shutdown_script ElastigroupGcp#shutdown_script}.
        :param startup_script: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#startup_script ElastigroupGcp#startup_script}.
        :param subnets: subnets block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnets ElastigroupGcp#subnets}
        :param tags: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#tags ElastigroupGcp#tags}.
        :param unhealthy_duration: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unhealthy_duration ElastigroupGcp#unhealthy_duration}.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        '''
        config = ElastigroupGcpConfig(
            desired_capacity=desired_capacity,
            name=name,
            auto_healing=auto_healing,
            availability_zones=availability_zones,
            backend_services=backend_services,
            description=description,
            disk=disk,
            draining_timeout=draining_timeout,
            fallback_to_ondemand=fallback_to_ondemand,
            gpu=gpu,
            health_check_grace_period=health_check_grace_period,
            health_check_type=health_check_type,
            instance_types_custom=instance_types_custom,
            instance_types_ondemand=instance_types_ondemand,
            instance_types_preemptible=instance_types_preemptible,
            integration_docker_swarm=integration_docker_swarm,
            integration_gke=integration_gke,
            ip_forwarding=ip_forwarding,
            labels=labels,
            max_size=max_size,
            metadata=metadata,
            min_size=min_size,
            network_interface=network_interface,
            ondemand_count=ondemand_count,
            preemptible_percentage=preemptible_percentage,
            provisioning_model=provisioning_model,
            scaling_down_policy=scaling_down_policy,
            scaling_up_policy=scaling_up_policy,
            scheduled_task=scheduled_task,
            service_account=service_account,
            shutdown_script=shutdown_script,
            startup_script=startup_script,
            subnets=subnets,
            tags=tags,
            unhealthy_duration=unhealthy_duration,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="putIntegrationDockerSwarm")
    def put_integration_docker_swarm(
        self,
        *,
        master_host: builtins.str,
        master_port: jsii.Number,
    ) -> None:
        '''
        :param master_host: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_host ElastigroupGcp#master_host}.
        :param master_port: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_port ElastigroupGcp#master_port}.
        '''
        value = ElastigroupGcpIntegrationDockerSwarm(
            master_host=master_host, master_port=master_port
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationDockerSwarm", [value]))

    @jsii.member(jsii_name="putIntegrationGke")
    def put_integration_gke(
        self,
        *,
        autoscale_cooldown: typing.Optional[jsii.Number] = None,
        autoscale_down: typing.Optional["ElastigroupGcpIntegrationGkeAutoscaleDown"] = None,
        autoscale_headroom: typing.Optional["ElastigroupGcpIntegrationGkeAutoscaleHeadroom"] = None,
        autoscale_is_auto_config: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_is_enabled: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        autoscale_labels: typing.Optional[typing.Union[cdktf.IResolvable, typing.Sequence["ElastigroupGcpIntegrationGkeAutoscaleLabels"]]] = None,
        auto_update: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        cluster_id: typing.Optional[builtins.str] = None,
        location: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param autoscale_cooldown: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_cooldown ElastigroupGcp#autoscale_cooldown}.
        :param autoscale_down: autoscale_down block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_down ElastigroupGcp#autoscale_down}
        :param autoscale_headroom: autoscale_headroom block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_headroom ElastigroupGcp#autoscale_headroom}
        :param autoscale_is_auto_config: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_auto_config ElastigroupGcp#autoscale_is_auto_config}.
        :param autoscale_is_enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_enabled ElastigroupGcp#autoscale_is_enabled}.
        :param autoscale_labels: autoscale_labels block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_labels ElastigroupGcp#autoscale_labels}
        :param auto_update: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_update ElastigroupGcp#auto_update}.
        :param cluster_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cluster_id ElastigroupGcp#cluster_id}.
        :param location: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#location ElastigroupGcp#location}.
        '''
        value = ElastigroupGcpIntegrationGke(
            autoscale_cooldown=autoscale_cooldown,
            autoscale_down=autoscale_down,
            autoscale_headroom=autoscale_headroom,
            autoscale_is_auto_config=autoscale_is_auto_config,
            autoscale_is_enabled=autoscale_is_enabled,
            autoscale_labels=autoscale_labels,
            auto_update=auto_update,
            cluster_id=cluster_id,
            location=location,
        )

        return typing.cast(None, jsii.invoke(self, "putIntegrationGke", [value]))

    @jsii.member(jsii_name="resetAutoHealing")
    def reset_auto_healing(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoHealing", []))

    @jsii.member(jsii_name="resetAvailabilityZones")
    def reset_availability_zones(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAvailabilityZones", []))

    @jsii.member(jsii_name="resetBackendServices")
    def reset_backend_services(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBackendServices", []))

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDescription", []))

    @jsii.member(jsii_name="resetDisk")
    def reset_disk(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDisk", []))

    @jsii.member(jsii_name="resetDrainingTimeout")
    def reset_draining_timeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDrainingTimeout", []))

    @jsii.member(jsii_name="resetFallbackToOndemand")
    def reset_fallback_to_ondemand(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFallbackToOndemand", []))

    @jsii.member(jsii_name="resetGpu")
    def reset_gpu(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGpu", []))

    @jsii.member(jsii_name="resetHealthCheckGracePeriod")
    def reset_health_check_grace_period(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckGracePeriod", []))

    @jsii.member(jsii_name="resetHealthCheckType")
    def reset_health_check_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHealthCheckType", []))

    @jsii.member(jsii_name="resetInstanceTypesCustom")
    def reset_instance_types_custom(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInstanceTypesCustom", []))

    @jsii.member(jsii_name="resetInstanceTypesOndemand")
    def reset_instance_types_ondemand(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInstanceTypesOndemand", []))

    @jsii.member(jsii_name="resetInstanceTypesPreemptible")
    def reset_instance_types_preemptible(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInstanceTypesPreemptible", []))

    @jsii.member(jsii_name="resetIntegrationDockerSwarm")
    def reset_integration_docker_swarm(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationDockerSwarm", []))

    @jsii.member(jsii_name="resetIntegrationGke")
    def reset_integration_gke(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIntegrationGke", []))

    @jsii.member(jsii_name="resetIpForwarding")
    def reset_ip_forwarding(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIpForwarding", []))

    @jsii.member(jsii_name="resetLabels")
    def re