import FWCore.ParameterSet.Config as cms

process = cms.Process("HLT")

process.source = cms.Source("PoolSource",
    fileNames = cms.untracked.vstring('REDIGI_SIM.root'),
    inputCommands = cms.untracked.vstring('drop *',
        'keep *_g4SimHits_*_*',
        'keep edmHepMCProduct_source_*_*',
        'keep LHERunInfoProduct_source_*_*',
        'keep LHEEventProduct_source_*_*',
        'keep GenRunInfoProduct_generator_*_*',
        'keep GenEventInfoProduct_generator_*_*',
        'keep edmHepMCProduct_generator_*_*',
        'keep GenFilterInfo_*_*_*',
        'keep *_randomEngineStateProducer_*_*'),
    dropDescendantsOfDroppedBranches = cms.untracked.bool(False)
)
process.MEtoEDMConverter = cms.EDProducer("MEtoEDMConverter",
    deleteAfterCopy = cms.untracked.bool(True),
    Verbosity = cms.untracked.int32(0),
    Frequency = cms.untracked.int32(50),
    Name = cms.untracked.string('MEtoEDMConverter'),
    MEPathToSave = cms.untracked.string('')
)


process.SiStripDigiToRaw = cms.EDProducer("SiStripDigiToRawModule",
    InputDigiLabel = cms.string('ZeroSuppressed'),
    FedReadoutMode = cms.string('ZERO_SUPPRESSED'),
    UseWrongDigiType = cms.bool(False),
    UseFedKey = cms.bool(False),
    InputModuleLabel = cms.string('simSiStripDigis')
)


process.addPileupInfo = cms.EDProducer("PileupInformation",
    TrackingParticlesLabel = cms.string('mergedtruth'),
    simHitLabel = cms.string('g4SimHits'),
    volumeRadius = cms.double(1200.0),
    vertexDistanceCut = cms.double(0.003),
    pTcut_2 = cms.double(0.5),
    pTcut_1 = cms.double(0.1),
    volumeZ = cms.double(3000.0)
)


process.ak3HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('AntiKt'),
    rParam = cms.double(0.3)
)


process.ak4HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('AntiKt'),
    rParam = cms.double(0.4)
)


process.ak5GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('AntiKt'),
    rParam = cms.double(0.5)
)


process.ak5GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ak5GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ak5HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('AntiKt'),
    rParam = cms.double(0.5)
)


process.ak7GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJets"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ak7GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ak7GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ak7HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('AntiKt'),
    rParam = cms.double(0.7)
)


process.ca4GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('CambridgeAachen'),
    rParam = cms.double(0.4)
)


process.ca4GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('CambridgeAachen'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.4),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ca4GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('CambridgeAachen'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.4),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ca6GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('CambridgeAachen'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJets"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ca6GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('CambridgeAachen'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.ca6GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('CambridgeAachen'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.castorRawData = cms.EDProducer("CastorDigiToRaw",
    CASTOR = cms.untracked.InputTag("simCastorDigis")
)


process.cscpacker = cms.EDProducer("CSCDigiToRawModule",
    clctDigiTag = cms.InputTag("simCscTriggerPrimitiveDigis"),
    requirePreTrigger = cms.bool(True),
    requireCLCTForComparators = cms.bool(True),
    preTriggerTag = cms.InputTag("simCscTriggerPrimitiveDigis"),
    stripDigiTag = cms.InputTag("simMuonCSCDigis","MuonCSCStripDigi"),
    comparatorDigiTag = cms.InputTag("simMuonCSCDigis","MuonCSCComparatorDigi"),
    wireDigiTag = cms.InputTag("simMuonCSCDigis","MuonCSCWireDigi"),
    correlatedLCTDigiTag = cms.InputTag("simCscTriggerPrimitiveDigis","MPCSORTED"),
    alctDigiTag = cms.InputTag("simCscTriggerPrimitiveDigis")
)


process.csctfpacker = cms.EDProducer("CSCTFPacker",
    MaxBX = cms.int32(9),
    MinBX = cms.int32(3),
    zeroSuppression = cms.bool(True),
    outputFile = cms.string(''),
    lctProducer = cms.InputTag("simCscTriggerPrimitiveDigis","MPCSORTED"),
    trackProducer = cms.InputTag("simCsctfTrackDigis"),
    putBufferToEvent = cms.bool(True),
    activeSectors = cms.int32(4095),
    nTBINs = cms.int32(7),
    swapME1strips = cms.bool(False),
    mbProducer = cms.InputTag("null")
)


process.dtTriggerPrimitiveDigis = cms.EDProducer("DTTrigProd",
    lutDumpFlag = cms.untracked.bool(False),
    debug = cms.untracked.bool(False),
    lutBtic = cms.untracked.int32(31),
    digiTag = cms.InputTag("muonDTDigis"),
    DTTFSectorNumbering = cms.bool(True)
)


process.dtpacker = cms.EDProducer("DTDigiToRawModule",
    digibytype = cms.untracked.bool(True),
    debugMode = cms.untracked.bool(False),
    maxFEDid = cms.untracked.int32(775),
    useStandardFEDid = cms.untracked.bool(True),
    minFEDid = cms.untracked.int32(770)
)


process.dttfpacker = cms.EDProducer("DTTFFEDSim",
    DTTracks_Source = cms.InputTag("simDttfDigis","DTTF"),
    DTDigi_Source = cms.InputTag("simDtTriggerPrimitiveDigis")
)


process.ecalPacker = cms.EDProducer("EcalDigiToRaw",
    InstanceEB = cms.string('ebDigis'),
    InstanceEE = cms.string('eeDigis'),
    DoEndCap = cms.untracked.bool(True),
    labelTT = cms.InputTag("simEcalTriggerPrimitiveDigis"),
    Label = cms.string('simEcalDigis'),
    WriteTowerBlock = cms.untracked.bool(True),
    labelEESRFlags = cms.InputTag("simEcalDigis","eeSrFlags"),
    WriteSRFlags = cms.untracked.bool(True),
    debug = cms.untracked.bool(False),
    labelEBSRFlags = cms.InputTag("simEcalDigis","ebSrFlags"),
    listDCCId = cms.untracked.vint32(1, 2, 3, 4, 5,
        6, 7, 8, 9, 10,
        11, 12, 13, 14, 15,
        16, 17, 18, 19, 20,
        21, 22, 23, 24, 25,
        26, 27, 28, 29, 30,
        31, 32, 33, 34, 35,
        36, 37, 38, 39, 40,
        41, 42, 43, 44, 45,
        46, 47, 48, 49, 50,
        51, 52, 53, 54),
    WriteTCCBlock = cms.untracked.bool(True),
    DoBarrel = cms.untracked.bool(True)
)


process.esDigiToRaw = cms.EDProducer("ESDigiToRaw",
    debugMode = cms.untracked.bool(False),
    InstanceES = cms.string(''),
    LookupTable = cms.untracked.FileInPath('EventFilter/ESDigiToRaw/data/ES_lookup_table.dat'),
    Label = cms.string('simEcalPreshowerDigis')
)


process.gctDigiToRaw = cms.EDProducer("GctDigiToRaw",
    verbose = cms.untracked.bool(False),
    packRctCalo = cms.untracked.bool(True),
    gctFedId = cms.int32(745),
    packRctEm = cms.untracked.bool(True),
    rctInputLabel = cms.InputTag("simRctDigis"),
    gctInputLabel = cms.InputTag("simGctDigis")
)


process.genCandidatesForMET = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("genParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39, 12, 13, 14, 16),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(False),
    excludeFromResonancePids = cms.vuint32(),
    tausAsJets = cms.bool(False)
)


process.genMetCalo = cms.EDProducer("METProducer",
    src = cms.InputTag("genCandidatesForMET"),
    METType = cms.string('GenMET'),
    usePt = cms.untracked.bool(True),
    alias = cms.string('GenMETCalo'),
    onlyFiducialParticles = cms.bool(True),
    globalThreshold = cms.double(0.0),
    InputType = cms.string('CandidateCollection')
)


process.genMetCaloAndNonPrompt = cms.EDProducer("METProducer",
    src = cms.InputTag("genParticlesForJets"),
    METType = cms.string('GenMET'),
    alias = cms.string('GenMETCaloAndNonPrompt'),
    onlyFiducialParticles = cms.bool(True),
    globalThreshold = cms.double(0.0),
    InputType = cms.string('CandidateCollection')
)


process.genMetIC5GenJets = cms.EDProducer("METProducer",
    src = cms.InputTag("iterativeCone5GenJets"),
    METType = cms.string('MET'),
    alias = cms.string('GenMETIC5'),
    noHF = cms.bool(False),
    globalThreshold = cms.double(0.0),
    InputType = cms.string('CandidateCollection')
)


process.genMetTrue = cms.EDProducer("METProducer",
    src = cms.InputTag("genParticlesForMETAllVisible"),
    METType = cms.string('GenMET'),
    usePt = cms.untracked.bool(True),
    alias = cms.string('GenMETAllVisible'),
    onlyFiducialParticles = cms.bool(False),
    globalThreshold = cms.double(0.0),
    InputType = cms.string('CandidateCollection')
)


process.genParticleCandidates = cms.EDProducer("FastGenParticleCandidateProducer",
    saveBarCodes = cms.untracked.bool(False),
    src = cms.InputTag("generator"),
    abortOnUnknownPDGCode = cms.untracked.bool(False)
)


process.genParticles = cms.EDProducer("GenParticleProducer",
    saveBarCodes = cms.untracked.bool(True),
    src = cms.InputTag("generator"),
    abortOnUnknownPDGCode = cms.untracked.bool(False)
)


process.genParticlesForJets = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("genParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(True),
    excludeFromResonancePids = cms.vuint32(12, 13, 14, 16),
    tausAsJets = cms.bool(False)
)


process.genParticlesForJetsNoMuNoNu = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("genParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39, 12, 13, 14, 16),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(True),
    excludeFromResonancePids = cms.vuint32(12, 13, 14, 16),
    tausAsJets = cms.bool(False)
)


process.genParticlesForJetsNoNu = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("genParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39, 12, 14, 16),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(True),
    excludeFromResonancePids = cms.vuint32(12, 13, 14, 16),
    tausAsJets = cms.bool(False)
)


process.genParticlesForMETAllVisible = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("genParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39, 12, 14, 16),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(False),
    excludeFromResonancePids = cms.vuint32(),
    tausAsJets = cms.bool(False)
)


process.gk5GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('GeneralizedKt'),
    rParam = cms.double(0.5)
)


process.gk5GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('GeneralizedKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.gk5GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('GeneralizedKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.gk7GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('GeneralizedKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJets"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.gk7GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('GeneralizedKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.gk7GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('GeneralizedKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hcalRawData = cms.EDProducer("HcalDigiToRaw",
    HBHE = cms.untracked.InputTag("simHcalDigis"),
    HF = cms.untracked.InputTag("simHcalDigis"),
    HO = cms.untracked.InputTag("simHcalDigis"),
    ZDC = cms.untracked.InputTag("simHcalUnsuppressedDigis")
)


process.hiGenParticles = cms.EDProducer("GenParticleProducer",
    saveBarCodes = cms.untracked.bool(True),
    doSubEvent = cms.untracked.bool(True),
    useCrossingFrame = cms.untracked.bool(False),
    srcVector = cms.vstring('generator')
)


process.hiGenParticlesForJets = cms.EDProducer("InputGenJetsParticleSelector",
    src = cms.InputTag("hiGenParticles"),
    ignoreParticleIDs = cms.vuint32(1000022, 1000012, 1000014, 1000016, 2000012,
        2000014, 2000016, 1000039, 5100039, 4000012,
        4000014, 4000016, 9900012, 9900014, 9900016,
        39),
    partonicFinalState = cms.bool(False),
    excludeResonances = cms.bool(True),
    excludeFromResonancePids = cms.vuint32(12, 13, 14, 16),
    tausAsJets = cms.bool(False)
)


process.hlt3HitElectronActivityDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hlt3HitElectronActivityTrackIsol = cms.EDProducer("EgammaHLTElectronTrackIsolationProducers",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoVetoConeSize = cms.double(0.03),
    trackProducer = cms.InputTag("hltEcalActivityEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    egTrkIsoConeSize = cms.double(0.3),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(0.15)
)


process.hlt3HitElectronL1IsoDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hlt3HitElectronL1NonIsoDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hltActivityPhotonClusterShape = cms.EDProducer("EgammaHLTClusterShapeProducer",
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE"),
    isIeta = cms.bool(True)
)


process.hltActivityPhotonEcalIsol = cms.EDProducer("EgammaHLTEcalRecIsolationProducer",
    useNumCrystals = cms.bool(True),
    etMinBarrel = cms.double(-9999.0),
    etMinEndcap = cms.double(0.1),
    tryBoth = cms.bool(True),
    eMinEndcap = cms.double(-9999.0),
    ecalEndcapRecHitCollection = cms.InputTag("EcalRecHitsEE"),
    intRadiusEndcap = cms.double(3.0),
    ecalEndcapRecHitProducer = cms.InputTag("hltEcalRecHitAll"),
    jurassicWidth = cms.double(3.0),
    ecalBarrelRecHitProducer = cms.InputTag("hltEcalRecHitAll"),
    extRadius = cms.double(0.3),
    useIsolEt = cms.bool(True),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    ecalBarrelRecHitCollection = cms.InputTag("EcalRecHitsEB"),
    intRadiusBarrel = cms.double(3.0),
    subtract = cms.bool(False),
    eMinBarrel = cms.double(0.08)
)


process.hltActivityPhotonHcalForHE = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.14),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.0),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    doEtSum = cms.bool(False)
)


process.hltActivityPhotonHcalIsol = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.29),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.16),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    doEtSum = cms.bool(True)
)


process.hltActivityPhotonHollowTrackIsol = cms.EDProducer("EgammaHLTPhotonTrackIsolationProducersRegional",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoConeSize = cms.double(0.29),
    trackProducer = cms.InputTag("hltEcalActivityEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    countTracks = cms.bool(False),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoVetoConeSize = cms.double(0.06),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(999999.0)
)


process.hltActivityR9ID = cms.EDProducer("EgammaHLTR9IDProducer",
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE")
)


process.hltActivityStartUpElectronPixelSeeds = cms.EDProducer("ElectronSeedProducer",
    endcapSuperClusters = cms.InputTag("hltCorrectedMulti5x5SuperClustersWithPreshowerActivity"),
    SeedConfiguration = cms.PSet(
        searchInTIDTEC = cms.bool(True),
        HighPtThreshold = cms.double(35.0),
        r2MinF = cms.double(-0.15),
        OrderedHitsFactoryPSet = cms.PSet(
            maxElement = cms.uint32(0),
            ComponentName = cms.string('StandardHitPairGenerator'),
            SeedingLayers = cms.string('hltESPMixedLayerPairs'),
            useOnDemandTracker = cms.untracked.int32(0)
        ),
        DeltaPhi1Low = cms.double(0.23),
        DeltaPhi1High = cms.double(0.08),
        ePhiMin1 = cms.double(-0.08),
        PhiMin2 = cms.double(-0.004),
        LowPtThreshold = cms.double(3.0),
        RegionPSet = cms.PSet(
            deltaPhiRegion = cms.double(0.4),
            originHalfLength = cms.double(15.0),
            useZInVertex = cms.bool(True),
            deltaEtaRegion = cms.double(0.1),
            ptMin = cms.double(1.5),
            originRadius = cms.double(0.2),
            VertexProducer = cms.InputTag("dummyVertices")
        ),
        maxHOverE = cms.double(999999.0),
        dynamicPhiRoad = cms.bool(False),
        ePhiMax1 = cms.double(0.04),
        DeltaPhi2 = cms.double(0.004),
        measurementTrackerName = cms.string('hltESPMeasurementTracker'),
        SizeWindowENeg = cms.double(0.675),
        nSigmasDeltaZ1 = cms.double(5.0),
        rMaxI = cms.double(0.2),
        PhiMax2 = cms.double(0.004),
        preFilteredSeeds = cms.bool(True),
        r2MaxF = cms.double(0.15),
        pPhiMin1 = cms.double(-0.04),
        initialSeeds = cms.InputTag("noSeedsHere"),
        pPhiMax1 = cms.double(0.08),
        hbheModule = cms.string('hbhereco'),
        SCEtCut = cms.double(3.0),
        z2MaxB = cms.double(0.09),
        fromTrackerSeeds = cms.bool(True),
        hcalRecHits = cms.InputTag("hltHbhereco"),
        z2MinB = cms.double(-0.09),
        hbheInstance = cms.string(''),
        rMinI = cms.double(-0.2),
        hOverEConeSize = cms.double(0.0),
        hOverEHBMinE = cms.double(999999.0),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        applyHOverECut = cms.bool(False),
        hOverEHFMinE = cms.double(999999.0)
    ),
    barrelSuperClusters = cms.InputTag("hltCorrectedHybridSuperClustersActivity")
)


process.hltAntiKT5CaloJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.5),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltTowerMakerForAll"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltAntiKT5CaloJetsRegional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.5),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltTowerMakerForJets"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltAntiKT5ConvPFJets = cms.EDProducer("PFJetToCaloProducer",
    Source = cms.InputTag("hltAntiKT5PFJets")
)


process.hltAntiKT5L2L3CaloJetsEle8CaloIdLCaloIsoVLRemoved = cms.EDProducer("JetCollectionForEleHT",
    SourceJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minDeltaR = cms.double(0.5),
    HltElectronTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLPixelMatchFilter")
)


process.hltAntiKT5L2L3CorrCaloJets = cms.EDProducer("CaloJetCorrectionProducer",
    alias = cms.untracked.string('JetCorJetAntiKT5'),
    correctors = cms.vstring('hltESSAK5CaloL2L3'),
    verbose = cms.untracked.bool(False),
    src = cms.InputTag("hltAntiKT5CaloJets")
)


process.hltAntiKT5L2L3CorrCaloJetsRegional = cms.EDProducer("CaloJetCorrectionProducer",
    alias = cms.untracked.string('JetCorJetAntiKT5'),
    correctors = cms.vstring('hltESSAK5CaloL2L3'),
    verbose = cms.untracked.bool(False),
    src = cms.InputTag("hltAntiKT5CaloJetsRegional")
)


process.hltAntiKT5PFJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('PFJet'),
    MinVtxNdof = cms.int32(0),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('AntiKt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.5),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltParticleFlow"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag("hltPixelVertices"),
    jetPtMin = cms.double(15.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltBLifetimeL25Associator = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL25Jets"),
    tracks = cms.InputTag("hltPixelTracks"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL25AssociatorEleJetSingleTop = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL25JetsEleJetSingleTop"),
    tracks = cms.InputTag("hltPixelTracks"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL25AssociatorSingleTop = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL25JetsSingleTop"),
    tracks = cms.InputTag("hltPixelTracks"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL25BJetTags = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL25TagInfos")
)


process.hltBLifetimeL25BJetTagsEleJetSingleTop = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL25TagInfosEleJetSingleTop")
)


process.hltBLifetimeL25BJetTagsSingleTop = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL25TagInfosSingleTop")
)


process.hltBLifetimeL25TagInfos = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(3),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL25Associator"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(5.0)
)


process.hltBLifetimeL25TagInfosEleJetSingleTop = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(3),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL25AssociatorEleJetSingleTop"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(5.0)
)


process.hltBLifetimeL25TagInfosSingleTop = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(3),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL25AssociatorSingleTop"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(5.0)
)


process.hltBLifetimeL3Associator = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL25Jets"),
    tracks = cms.InputTag("hltBLifetimeRegionalCtfWithMaterialTracks"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL3AssociatorEleJetSingleTop = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL3EleJetsSingleTop"),
    tracks = cms.InputTag("hltBLifetimeRegionalCtfWithMaterialTracksEleJetSingleTop"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL3AssociatorSingleTop = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltBLifetimeL3JetsSingleTop"),
    tracks = cms.InputTag("hltBLifetimeRegionalCtfWithMaterialTracksSingleTop"),
    coneSize = cms.double(0.5)
)


process.hltBLifetimeL3BJetTags = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL3TagInfos")
)


process.hltBLifetimeL3BJetTagsEleJetSingleTop = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL3TagInfosEleJetSingleTop")
)


process.hltBLifetimeL3BJetTagsSingleTop = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPTrackCounting3D2nd'),
    tagInfos = cms.VInputTag("hltBLifetimeL3TagInfosSingleTop")
)


process.hltBLifetimeL3EleJetsSingleTop = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBLifetimeL25FilterEleJetSingleTop")
)


process.hltBLifetimeL3JetsSingleTop = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBLifetimeL25FilterSingleTop")
)


process.hltBLifetimeL3TagInfos = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(8),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL3Associator"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(20.0)
)


process.hltBLifetimeL3TagInfosEleJetSingleTop = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(8),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL3AssociatorEleJetSingleTop"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(20.0)
)


process.hltBLifetimeL3TagInfosSingleTop = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.2),
    minimumNumberOfHits = cms.int32(8),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(17.0),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltBLifetimeL3AssociatorSingleTop"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(20.0)
)


process.hltBLifetimeRegionalCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltBLifetimeRegionalPixelSeedGenerator"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPbJetRegionalTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltBLifetimeRegionalCkfTrackCandidatesEleJetSingleTop = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltBLifetimeRegionalPixelSeedGeneratorEleJetSingleTop"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPbJetRegionalTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltBLifetimeRegionalCkfTrackCandidatesSingleTop = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltBLifetimeRegionalPixelSeedGeneratorSingleTop"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPbJetRegionalTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltBLifetimeRegionalCtfWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltBLifetimeRegionalCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltBLifetimeRegionalCtfWithMaterialTracksEleJetSingleTop = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltBLifetimeRegionalCkfTrackCandidatesEleJetSingleTop"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltBLifetimeRegionalCtfWithMaterialTracksSingleTop = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltBLifetimeRegionalCkfTrackCandidatesSingleTop"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltBLifetimeRegionalPixelSeedGenerator = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('TauRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            deltaPhiRegion = cms.double(0.5),
            originHalfLength = cms.double(0.2),
            originRadius = cms.double(0.2),
            deltaEtaRegion = cms.double(0.5),
            ptMin = cms.double(1.0),
            JetSrc = cms.InputTag("hltBLifetimeL25Jets"),
            originZPos = cms.double(0.0),
            vertexSrc = cms.InputTag("hltPixelVertices")
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltBLifetimeRegionalPixelSeedGeneratorEleJetSingleTop = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('TauRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            deltaPhiRegion = cms.double(0.5),
            originHalfLength = cms.double(0.2),
            originRadius = cms.double(0.2),
            deltaEtaRegion = cms.double(0.5),
            ptMin = cms.double(1.0),
            JetSrc = cms.InputTag("hltBLifetimeL3EleJetsSingleTop"),
            originZPos = cms.double(0.0),
            vertexSrc = cms.InputTag("hltPixelVertices")
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltBLifetimeRegionalPixelSeedGeneratorSingleTop = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('TauRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            deltaPhiRegion = cms.double(0.5),
            originHalfLength = cms.double(0.2),
            originRadius = cms.double(0.2),
            deltaEtaRegion = cms.double(0.5),
            ptMin = cms.double(1.0),
            JetSrc = cms.InputTag("hltBLifetimeL3JetsSingleTop"),
            originZPos = cms.double(0.0),
            vertexSrc = cms.InputTag("hltPixelVertices")
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltBSoftMuonDiJet100L25BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet100L25TagInfos")
)


process.hltBSoftMuonDiJet100L25TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltL2Muons"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet100L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet100Mu9SelL3BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet100Mu9SelL3TagInfos")
)


process.hltBSoftMuonDiJet100Mu9SelL3TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltBSoftMuonDiJet100Mu9L3"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet100L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet20L25BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet20L25TagInfos")
)


process.hltBSoftMuonDiJet20L25TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltL2Muons"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet20L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet20Mu5SelL3BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet20Mu5SelL3TagInfos")
)


process.hltBSoftMuonDiJet20Mu5SelL3TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltBSoftMuonDiJet20Mu5L3"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet20L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet60L25BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet60L25TagInfos")
)


process.hltBSoftMuonDiJet60L25TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltL2Muons"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet60L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet60Mu7SelL3BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet60Mu7SelL3TagInfos")
)


process.hltBSoftMuonDiJet60Mu7SelL3TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltBSoftMuonDiJet60Mu7L3"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet60L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet80L25BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet80L25TagInfos")
)


process.hltBSoftMuonDiJet80L25TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltL2Muons"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet80L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonDiJet80Mu9SelL3BJetTagsByDR = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPSoftLeptonByDistance'),
    tagInfos = cms.VInputTag("hltBSoftMuonDiJet80Mu9SelL3TagInfos")
)


process.hltBSoftMuonDiJet80Mu9SelL3TagInfos = cms.EDProducer("SoftLepton",
    muonSelection = cms.uint32(0),
    leptons = cms.InputTag("hltBSoftMuonDiJet80Mu9L3"),
    primaryVertex = cms.InputTag("nominal"),
    leptonCands = cms.InputTag(""),
    leptonId = cms.InputTag(""),
    refineJetAxis = cms.uint32(0),
    jets = cms.InputTag("hltBSoftMuonDiJet80L25Jets"),
    leptonDeltaRCut = cms.double(0.4),
    leptonChi2Cut = cms.double(0.0)
)


process.hltBSoftMuonGetJetsFromDiJet100 = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBDiJet100Central")
)


process.hltBSoftMuonGetJetsFromDiJet20 = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBDiJet20Central")
)


process.hltBSoftMuonGetJetsFromDiJet60 = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBDiJet60Central")
)


process.hltBSoftMuonGetJetsFromDiJet80 = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBDiJet80Central")
)


process.hltCaloTowersCentral1Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(0),
    TauTrigger = cms.InputTag("hltL1extraParticles","Central"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersCentral2Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(1),
    TauTrigger = cms.InputTag("hltL1extraParticles","Central"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersCentral3Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(2),
    TauTrigger = cms.InputTag("hltL1extraParticles","Central"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersCentral4Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(3),
    TauTrigger = cms.InputTag("hltL1extraParticles","Central"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersTau1Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(0),
    TauTrigger = cms.InputTag("hltL1extraParticles","Tau"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersTau2Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(1),
    TauTrigger = cms.InputTag("hltL1extraParticles","Tau"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersTau3Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(2),
    TauTrigger = cms.InputTag("hltL1extraParticles","Tau"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCaloTowersTau4Regional = cms.EDProducer("CaloTowerCreatorForTauHLT",
    towers = cms.InputTag("hltTowerMakerForJets"),
    TauId = cms.int32(3),
    TauTrigger = cms.InputTag("hltL1extraParticles","Tau"),
    minimumE = cms.double(0.8),
    UseTowersInCone = cms.double(0.8),
    minimumEt = cms.double(0.5)
)


process.hltCkf3HitActivityTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkf3HitTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCkf3HitL1IsoTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkf3HitTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCkf3HitL1NonIsoTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkf3HitTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCkfActivityTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCkfL1IsoTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCkfL1NonIsoTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets = cms.EDProducer("JetCollectionForEleHT",
    SourceJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minDeltaR = cms.double(0.3),
    HltElectronTag = cms.InputTag("hltEle25CaloIdVTTrkIdTDphiFilter")
)


process.hltConvPFTauTightIsoTrackPt20 = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTauTightIsoTrackPt20")
)


process.hltConvPFTauTightIsoTrackPt20Isolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTauTightIsoTrackPt20Isolation")
)


process.hltConvPFTaus = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltPFTaus")
)


process.hltConvPFTausTightIso = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltPFTausTightIso")
)


process.hltConvPFTausTightIsoTrackFinding = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTightIsoTrackFinding")
)


process.hltConvPFTausTightIsoTrackFindingIsolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTightIsoTrackFindingIsolation")
)


process.hltConvPFTausTightIsoTrackPt5 = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTightIsoTrackPt5")
)


process.hltConvPFTausTightIsoTrackPt5Isolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTightIsoTrackPt5Isolation")
)


process.hltConvPFTausTrackFinding = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTrackFinding")
)


process.hltConvPFTausTrackFindingIsolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTrackFindingIsolation")
)


process.hltConvPFTausTrackFindingLooseIsolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTrackFindingLooseIsolation")
)


process.hltConvPFTausTrackPt5 = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTrackPt5")
)


process.hltConvPFTausTrackPt5Isolation = cms.EDProducer("PFTauToJetProducer",
    Source = cms.InputTag("hltSelectedPFTausTrackPt5Isolation")
)


process.hltCorrectedHybridSuperClustersActivity = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.15),
    superClusterAlgo = cms.string('Hybrid'),
    etThresh = cms.double(0.0),
    rawSuperClusterProducer = cms.InputTag("hltHybridSuperClustersActivity"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(

    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(1.1),
        fBremVec = cms.vdouble(-0.04382, 0.1169, 0.9267, -0.0009413, 1.419),
        brLinearHighThr = cms.double(8.0),
        fEtEtaVec = cms.vdouble(0.0, 1.00121, -0.63672, 0.0, 0.0,
            0.0, 0.5655, 6.457, 0.5081, 8.0,
            1.023, -0.00181)
    ),
    recHitProducer = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB")
)


process.hltCorrectedHybridSuperClustersL1Isolated = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.03),
    superClusterAlgo = cms.string('Hybrid'),
    etThresh = cms.double(1.0),
    rawSuperClusterProducer = cms.InputTag("hltHybridSuperClustersL1Isolated"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(

    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(1.1),
        fEtEtaVec = cms.vdouble(1.0012, -0.5714, 0.0, 0.0, 0.0,
            0.5549, 12.74, 1.0448, 0.0, 0.0,
            0.0, 0.0, 8.0, 1.023, -0.00181,
            0.0, 0.0),
        brLinearHighThr = cms.double(8.0),
        fBremVec = cms.vdouble(-0.05208, 0.1331, 0.9196, -0.0005735, 1.343)
    ),
    recHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB")
)


process.hltCorrectedHybridSuperClustersL1NonIsolated = cms.EDProducer("EgammaHLTRemoveDuplicatedSC",
    L1NonIsoSkimmedCollection = cms.string(''),
    L1IsoSC = cms.InputTag("hltCorrectedHybridSuperClustersL1Isolated"),
    L1NonIsoUskimmedSC = cms.InputTag("hltCorrectedHybridSuperClustersL1NonIsolatedTemp")
)


process.hltCorrectedHybridSuperClustersL1NonIsolatedTemp = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.03),
    superClusterAlgo = cms.string('Hybrid'),
    etThresh = cms.double(1.0),
    rawSuperClusterProducer = cms.InputTag("hltHybridSuperClustersL1NonIsolated"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(

    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(1.1),
        fEtEtaVec = cms.vdouble(1.0012, -0.5714, 0.0, 0.0, 0.0,
            0.5549, 12.74, 1.0448, 0.0, 0.0,
            0.0, 0.0, 8.0, 1.023, -0.00181,
            0.0, 0.0),
        brLinearHighThr = cms.double(8.0),
        fBremVec = cms.vdouble(-0.05208, 0.1331, 0.9196, -0.0005735, 1.343)
    ),
    recHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB")
)


process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1Isolated = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.15),
    superClusterAlgo = cms.string('Multi5x5'),
    etThresh = cms.double(1.0),
    rawSuperClusterProducer = cms.InputTag("hltMulti5x5EndcapSuperClustersWithPreshowerL1Isolated"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(0.6),
        fEtEtaVec = cms.vdouble(0.9746, -6.512, 0.0, 0.0, 0.02771,
            4.983, 0.0, 0.0, -0.007288, -0.9446,
            0.0, 0.0, 0.0, 0.0, 0.0,
            1.0, 1.0),
        brLinearHighThr = cms.double(6.0),
        fBremVec = cms.vdouble(-0.04163, 0.08552, 0.95048, -0.002308, 1.077)
    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(

    ),
    recHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE")
)


process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated = cms.EDProducer("EgammaHLTRemoveDuplicatedSC",
    L1NonIsoSkimmedCollection = cms.string(''),
    L1IsoSC = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1Isolated"),
    L1NonIsoUskimmedSC = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolatedTemp")
)


process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolatedTemp = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.15),
    superClusterAlgo = cms.string('Multi5x5'),
    etThresh = cms.double(1.0),
    rawSuperClusterProducer = cms.InputTag("hltMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(0.6),
        fEtEtaVec = cms.vdouble(0.9746, -6.512, 0.0, 0.0, 0.02771,
            4.983, 0.0, 0.0, -0.007288, -0.9446,
            0.0, 0.0, 0.0, 0.0, 0.0,
            1.0, 1.0),
        brLinearHighThr = cms.double(6.0),
        fBremVec = cms.vdouble(-0.04163, 0.08552, 0.95048, -0.002308, 1.077)
    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(

    ),
    recHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE")
)


process.hltCorrectedMulti5x5SuperClustersWithPreshowerActivity = cms.EDProducer("EgammaSCCorrectionMaker",
    corectedSuperClusterCollection = cms.string(''),
    sigmaElectronicNoise = cms.double(0.15),
    superClusterAlgo = cms.string('Multi5x5'),
    etThresh = cms.double(0.0),
    rawSuperClusterProducer = cms.InputTag("hltMulti5x5SuperClustersWithPreshowerActivity"),
    applyEnergyCorrection = cms.bool(True),
    fix_fCorrPset = cms.PSet(
        brLinearLowThr = cms.double(0.9),
        fBremVec = cms.vdouble(-0.05228, 0.08738, 0.9508, 0.002677, 1.221),
        brLinearHighThr = cms.double(6.0),
        fEtEtaVec = cms.vdouble(1.0, -0.4386, -32.38, 0.6372, 15.67,
            -0.0928, -2.462, 1.138, 20.93)
    ),
    isl_fCorrPset = cms.PSet(

    ),
    VerbosityLevel = cms.string('ERROR'),
    applyCrackCorrection = cms.bool(False),
    dyn_fCorrPset = cms.PSet(

    ),
    hyb_fCorrPset = cms.PSet(

    ),
    recHitProducer = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE")
)


process.hltCosmicTrackSelector = cms.EDProducer("CosmicTrackSelector",
    keepAllTracks = cms.bool(False),
    maxNumberLostLayers = cms.uint32(999),
    max_d0 = cms.double(999.0),
    minNumber3DLayers = cms.uint32(0),
    src = cms.InputTag("hltRegionalCosmicTracks"),
    min_pt = cms.double(5.0),
    qualityBit = cms.string(''),
    minNumberLayers = cms.uint32(0),
    chi2n_par = cms.double(10.0),
    max_eta = cms.double(2.0),
    min_nPixelHit = cms.uint32(0),
    min_nHit = cms.uint32(6),
    max_z0 = cms.double(999.0),
    beamspot = cms.InputTag("hltOnlineBeamSpot")
)


process.hltCsc2DRecHits = cms.EDProducer("CSCRecHitDProducer",
    XTasymmetry_ME1b = cms.double(0.0),
    XTasymmetry_ME1a = cms.double(0.0),
    XTasymmetry_ME41 = cms.double(0.0),
    ConstSyst_ME1b = cms.double(0.007),
    CSCStripxtalksOffset = cms.double(0.03),
    CSCUseCalibrations = cms.bool(True),
    CSCUseTimingCorrections = cms.bool(True),
    CSCNoOfTimeBinsForDynamicPedestal = cms.int32(2),
    XTasymmetry_ME22 = cms.double(0.0),
    UseFivePoleFit = cms.bool(True),
    XTasymmetry_ME21 = cms.double(0.0),
    ConstSyst_ME21 = cms.double(0.0),
    ConstSyst_ME31 = cms.double(0.0),
    CSCStripClusterChargeCut = cms.double(25.0),
    ConstSyst_ME32 = cms.double(0.0),
    ConstSyst_ME1a = cms.double(0.022),
    readBadChambers = cms.bool(True),
    NoiseLevel_ME13 = cms.double(8.0),
    NoiseLevel_ME12 = cms.double(9.0),
    NoiseLevel_ME32 = cms.double(9.0),
    NoiseLevel_ME31 = cms.double(9.0),
    ConstSyst_ME22 = cms.double(0.0),
    ConstSyst_ME41 = cms.double(0.0),
    CSCStripPeakThreshold = cms.double(10.0),
    readBadChannels = cms.bool(True),
    UseParabolaFit = cms.bool(False),
    XTasymmetry_ME13 = cms.double(0.0),
    XTasymmetry_ME12 = cms.double(0.0),
    wireDigiTag = cms.InputTag("hltMuonCSCDigis","MuonCSCWireDigi"),
    ConstSyst_ME12 = cms.double(0.0),
    ConstSyst_ME13 = cms.double(0.0),
    XTasymmetry_ME31 = cms.double(0.0),
    XTasymmetry_ME32 = cms.double(0.0),
    UseAverageTime = cms.bool(False),
    NoiseLevel_ME1a = cms.double(7.0),
    NoiseLevel_ME1b = cms.double(8.0),
    CSCWireClusterDeltaT = cms.int32(1),
    CSCUseStaticPedestals = cms.bool(False),
    stripDigiTag = cms.InputTag("hltMuonCSCDigis","MuonCSCStripDigi"),
    CSCstripWireDeltaTime = cms.int32(8),
    NoiseLevel_ME21 = cms.double(9.0),
    NoiseLevel_ME22 = cms.double(9.0),
    NoiseLevel_ME41 = cms.double(9.0)
)


process.hltCscSegments = cms.EDProducer("CSCSegmentProducer",
    inputObjects = cms.InputTag("hltCsc2DRecHits"),
    algo_psets = cms.VPSet(cms.PSet(
        chamber_types = cms.vstring('ME1/a',
            'ME1/b',
            'ME1/2',
            'ME1/3',
            'ME2/1',
            'ME2/2',
            'ME3/1',
            'ME3/2',
            'ME4/1',
            'ME4/2'),
        algo_name = cms.string('CSCSegAlgoST'),
        algo_psets = cms.VPSet(cms.PSet(
            maxRatioResidualPrune = cms.double(3.0),
            yweightPenalty = cms.double(1.5),
            maxRecHitsInCluster = cms.int32(20),
            dPhiFineMax = cms.double(0.025),
            preClusteringUseChaining = cms.bool(True),
            ForceCovariance = cms.bool(False),
            hitDropLimit6Hits = cms.double(0.3333),
            NormChi2Cut2D = cms.double(20.0),
            BPMinImprovement = cms.double(10000.0),
            Covariance = cms.double(0.0),
            tanPhiMax = cms.double(0.5),
            onlyBestSegment = cms.bool(False),
            SeedBig = cms.double(0.0015),
            dRPhiFineMax = cms.double(8.0),
            SeedSmall = cms.double(0.0002),
            curvePenalty = cms.double(2.0),
            dXclusBoxMax = cms.double(4.0),
            BrutePruning = cms.bool(True),
            tanThetaMax = cms.double(1.2),
            CorrectTheErrors = cms.bool(True),
            hitDropLimit4Hits = cms.double(0.6),
            useShowering = cms.bool(False),
            CSCDebug = cms.untracked.bool(False),
            curvePenaltyThreshold = cms.double(0.85),
            NormChi2Cut3D = cms.double(10.0),
            minHitsPerSegment = cms.int32(3),
            ForceCovarianceAll = cms.bool(False),
            yweightPenaltyThreshold = cms.double(1.0),
            prePrunLimit = cms.double(3.17),
            hitDropLimit5Hits = cms.double(0.8),
            preClustering = cms.bool(True),
            prePrun = cms.bool(True),
            maxDPhi = cms.double(999.0),
            maxDTheta = cms.double(999.0),
            Pruning = cms.bool(True),
            dYclusBoxMax = cms.double(8.0)
        ),
            cms.PSet(
                maxRatioResidualPrune = cms.double(3.0),
                yweightPenalty = cms.double(1.5),
                maxRecHitsInCluster = cms.int32(24),
                dPhiFineMax = cms.double(0.025),
                preClusteringUseChaining = cms.bool(True),
                ForceCovariance = cms.bool(False),
                hitDropLimit6Hits = cms.double(0.3333),
                NormChi2Cut2D = cms.double(20.0),
                BPMinImprovement = cms.double(10000.0),
                Covariance = cms.double(0.0),
                tanPhiMax = cms.double(0.5),
                onlyBestSegment = cms.bool(False),
                SeedBig = cms.double(0.0015),
                dRPhiFineMax = cms.double(8.0),
                SeedSmall = cms.double(0.0002),
                curvePenalty = cms.double(2.0),
                dXclusBoxMax = cms.double(4.0),
                BrutePruning = cms.bool(True),
                tanThetaMax = cms.double(1.2),
                CorrectTheErrors = cms.bool(True),
                hitDropLimit4Hits = cms.double(0.6),
                useShowering = cms.bool(False),
                CSCDebug = cms.untracked.bool(False),
                curvePenaltyThreshold = cms.double(0.85),
                NormChi2Cut3D = cms.double(10.0),
                minHitsPerSegment = cms.int32(3),
                ForceCovarianceAll = cms.bool(False),
                yweightPenaltyThreshold = cms.double(1.0),
                prePrunLimit = cms.double(3.17),
                hitDropLimit5Hits = cms.double(0.8),
                preClustering = cms.bool(True),
                prePrun = cms.bool(True),
                maxDPhi = cms.double(999.0),
                maxDTheta = cms.double(999.0),
                Pruning = cms.bool(True),
                dYclusBoxMax = cms.double(8.0)
            )),
        parameters_per_chamber_type = cms.vint32(2, 1, 1, 1, 1,
            1, 1, 1, 1, 1)
    )),
    algo_type = cms.int32(1)
)


process.hltCtf3HitActivityWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkf3HitActivityTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltCtf3HitL1IsoWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkf3HitL1IsoTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltCtf3HitL1NonIsoWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkf3HitL1NonIsoTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltCtfActivityWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkfActivityTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltCtfL1IsoWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkfL1IsoTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltCtfL1NonIsoWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltCkfL1NonIsoTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltDTDQMEvF = cms.EDProducer("DTUnpackingModule",
    useStandardFEDid = cms.bool(True),
    inputLabel = cms.InputTag("rawDataCollector"),
    dataType = cms.string('DDU'),
    fedbyType = cms.bool(False),
    readOutParameters = cms.PSet(
        debug = cms.untracked.bool(False),
        rosParameters = cms.PSet(
            writeSC = cms.untracked.bool(True),
            readingDDU = cms.untracked.bool(True),
            performDataIntegrityMonitor = cms.untracked.bool(True),
            readDDUIDfromDDU = cms.untracked.bool(True),
            debug = cms.untracked.bool(False),
            localDAQ = cms.untracked.bool(False)
        ),
        localDAQ = cms.untracked.bool(False),
        performDataIntegrityMonitor = cms.untracked.bool(True)
    ),
    rosParameters = cms.PSet(

    ),
    dqmOnly = cms.bool(True)
)


process.hltDisplacedHT250L25Associator = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltAntiKT5L2L3CorrCaloJetsPt60Eta2"),
    tracks = cms.InputTag("hltPixelTracks"),
    coneSize = cms.double(0.5)
)


process.hltDisplacedHT250L25JetTags = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPPromptTrackCountingESProducer'),
    tagInfos = cms.VInputTag("hltDisplacedHT250L25TagInfos")
)


process.hltDisplacedHT250L25TagInfos = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.1),
    minimumNumberOfHits = cms.int32(3),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(0.1),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltDisplacedHT250L25Associator"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(5.0)
)


process.hltDisplacedHT250L3Associator = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltAntiKT5L2L3CorrCaloJetsPt60Eta2"),
    tracks = cms.InputTag("hltDisplacedHT250RegionalCtfWithMaterialTracks"),
    coneSize = cms.double(0.5)
)


process.hltDisplacedHT250L3JetTags = cms.EDProducer("JetTagProducer",
    jetTagComputer = cms.string('hltESPPromptTrackCountingESProducer'),
    tagInfos = cms.VInputTag("hltDisplacedHT250L3TagInfos")
)


process.hltDisplacedHT250L3TagInfos = cms.EDProducer("TrackIPProducer",
    maximumTransverseImpactParameter = cms.double(0.1),
    minimumNumberOfHits = cms.int32(8),
    minimumTransverseMomentum = cms.double(1.0),
    primaryVertex = cms.InputTag("hltPixelVertices"),
    maximumLongitudinalImpactParameter = cms.double(0.1),
    computeProbabilities = cms.bool(False),
    ghostTrackPriorDeltaR = cms.double(0.03),
    jetTracks = cms.InputTag("hltDisplacedHT250L3Associator"),
    jetDirectionUsingGhostTrack = cms.bool(False),
    minimumNumberOfPixelHits = cms.int32(2),
    jetDirectionUsingTracks = cms.bool(False),
    computeGhostTrack = cms.bool(False),
    useTrackQuality = cms.bool(False),
    maximumChiSquared = cms.double(20.0)
)


process.hltDisplacedHT250RegionalCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltDisplacedHT250RegionalPixelSeedGenerator"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPbJetRegionalTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltDisplacedHT250RegionalCtfWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltDisplacedHT250RegionalCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltDisplacedHT250RegionalPixelSeedGenerator = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('TauRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            deltaPhiRegion = cms.double(0.5),
            originHalfLength = cms.double(0.2),
            originRadius = cms.double(0.2),
            deltaEtaRegion = cms.double(0.5),
            ptMin = cms.double(1.0),
            JetSrc = cms.InputTag("hltAntiKT5L2L3CorrCaloJetsPt60Eta2"),
            originZPos = cms.double(0.0),
            vertexSrc = cms.InputTag("hltPixelVertices")
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltDt1DRecHits = cms.EDProducer("DTRecHitProducer",
    recAlgo = cms.string('DTLinearDriftFromDBAlgo'),
    dtDigiLabel = cms.InputTag("hltMuonDTDigis"),
    recAlgoConfig = cms.PSet(
        tTrigMode = cms.string('DTTTrigSyncFromDB'),
        minTime = cms.double(-3.0),
        stepTwoFromDigi = cms.bool(False),
        doVdriftCorr = cms.bool(False),
        debug = cms.untracked.bool(False),
        tTrigModeConfig = cms.PSet(
            vPropWire = cms.double(24.4),
            doTOFCorrection = cms.bool(True),
            tofCorrType = cms.int32(0),
            wirePropCorrType = cms.int32(0),
            tTrigLabel = cms.string(''),
            doWirePropCorrection = cms.bool(True),
            doT0Correction = cms.bool(True),
            debug = cms.untracked.bool(False)
        ),
        maxTime = cms.double(420.0)
    )
)


process.hltDt4DSegments = cms.EDProducer("DTRecSegment4DProducer",
    debug = cms.untracked.bool(False),
    Reco4DAlgoName = cms.string('DTCombinatorialPatternReco4D'),
    recHits2DLabel = cms.InputTag("dt2DSegments"),
    Reco4DAlgoConfig = cms.PSet(
        segmCleanerMode = cms.int32(2),
        Reco2DAlgoName = cms.string('DTCombinatorialPatternReco'),
        recAlgo = cms.string('DTLinearDriftFromDBAlgo'),
        nSharedHitsMax = cms.int32(2),
        hit_afterT0_resolution = cms.double(0.03),
        Reco2DAlgoConfig = cms.PSet(
            segmCleanerMode = cms.int32(2),
            recAlgo = cms.string('DTLinearDriftFromDBAlgo'),
            nSharedHitsMax = cms.int32(2),
            AlphaMaxPhi = cms.double(1.0),
            hit_afterT0_resolution = cms.double(0.03),
            MaxAllowedHits = cms.uint32(50),
            performT0_vdriftSegCorrection = cms.bool(False),
            AlphaMaxTheta = cms.double(0.9),
            debug = cms.untracked.bool(False),
            recAlgoConfig = cms.PSet(
                tTrigMode = cms.string('DTTTrigSyncFromDB'),
                minTime = cms.double(-3.0),
                stepTwoFromDigi = cms.bool(False),
                doVdriftCorr = cms.bool(False),
                debug = cms.untracked.bool(False),
                tTrigModeConfig = cms.PSet(
                    vPropWire = cms.double(24.4),
                    doTOFCorrection = cms.bool(True),
                    tofCorrType = cms.int32(0),
                    wirePropCorrType = cms.int32(0),
                    tTrigLabel = cms.string(''),
                    doWirePropCorrection = cms.bool(True),
                    doT0Correction = cms.bool(True),
                    debug = cms.untracked.bool(False)
                ),
                maxTime = cms.double(420.0)
            ),
            nUnSharedHitsMin = cms.int32(2),
            performT0SegCorrection = cms.bool(False)
        ),
        performT0_vdriftSegCorrection = cms.bool(False),
        debug = cms.untracked.bool(False),
        recAlgoConfig = cms.PSet(
            tTrigMode = cms.string('DTTTrigSyncFromDB'),
            minTime = cms.double(-3.0),
            stepTwoFromDigi = cms.bool(False),
            doVdriftCorr = cms.bool(False),
            debug = cms.untracked.bool(False),
            tTrigModeConfig = cms.PSet(
                vPropWire = cms.double(24.4),
                doTOFCorrection = cms.bool(True),
                tofCorrType = cms.int32(0),
                wirePropCorrType = cms.int32(0),
                tTrigLabel = cms.string(''),
                doWirePropCorrection = cms.bool(True),
                doT0Correction = cms.bool(True),
                debug = cms.untracked.bool(False)
            ),
            maxTime = cms.double(420.0)
        ),
        nUnSharedHitsMin = cms.int32(2),
        AllDTRecHits = cms.bool(True),
        performT0SegCorrection = cms.bool(False)
    ),
    recHits1DLabel = cms.InputTag("hltDt1DRecHits")
)


process.hltESRawToRecHitFacility = cms.EDProducer("EcalRawToRecHitFacility",
    sourceTag = cms.InputTag("rawDataCollector"),
    workerName = cms.string('hltESPESUnpackerWorker')
)


process.hltESRecHitAll = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(False),
    rechitCollection = cms.string('EcalRecHitsES'),
    EErechitCollection = cms.string(''),
    EBrechitCollection = cms.string(''),
    lazyGetterTag = cms.InputTag("hltESRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalESRestFEDs","es")
)


process.hltESRegionalEgammaRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(False),
    rechitCollection = cms.string('EcalRecHitsES'),
    EErechitCollection = cms.string(''),
    EBrechitCollection = cms.string(''),
    lazyGetterTag = cms.InputTag("hltESRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalEgammaFEDs","es")
)


process.hltESRegionalPi0EtaRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(False),
    rechitCollection = cms.string('EcalRecHitsES'),
    EErechitCollection = cms.string(''),
    EBrechitCollection = cms.string(''),
    lazyGetterTag = cms.InputTag("hltESRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalPi0EtaFEDs","es")
)


process.hltEcalActivityEgammaRegionalCTFFinalFitWithMaterial = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltEcalActivityEgammaRegionalCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltEcalActivityEgammaRegionalCTFFinalFitWithMaterial'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltEcalActivityEgammaRegionalCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltEcalActivityEgammaRegionalPixelSeedGenerator"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltEcalActivityEgammaRegionalPixelSeedGenerator = cms.EDProducer("EgammaHLTRegionalPixelSeedGeneratorProducers",
    deltaPhiRegion = cms.double(0.3),
    vertexZ = cms.double(0.0),
    originHalfLength = cms.double(15.0),
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    UseZInVertex = cms.bool(False),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    deltaEtaRegion = cms.double(0.3),
    ptMin = cms.double(1.5),
    candTag = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    candTagEle = cms.InputTag("pixelMatchElectrons"),
    originRadius = cms.double(0.02)
)


process.hltEcalCalibrationRaw = cms.EDProducer("EvFFEDSelector",
    inputTag = cms.InputTag("rawDataCollector"),
    fedList = cms.vuint32(601, 602, 603, 604, 605,
        606, 607, 608, 609, 610,
        611, 612, 613, 614, 615,
        616, 617, 618, 619, 620,
        621, 622, 623, 624, 625,
        626, 627, 628, 629, 630,
        631, 632, 633, 634, 635,
        636, 637, 638, 639, 640,
        641, 642, 643, 644, 645,
        646, 647, 648, 649, 650,
        651, 652, 653, 654)
)


process.hltEcalRawToRecHitByproductProducer = cms.EDProducer("EcalRawToRecHitByproductProducer",
    workerName = cms.string('')
)


process.hltEcalRawToRecHitFacility = cms.EDProducer("EcalRawToRecHitFacility",
    sourceTag = cms.InputTag("rawDataCollector"),
    workerName = cms.string('')
)


process.hltEcalRecHitAll = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(True),
    rechitCollection = cms.string('NotNeededsplitOutputTrue'),
    EErechitCollection = cms.string('EcalRecHitsEE'),
    EBrechitCollection = cms.string('EcalRecHitsEB'),
    lazyGetterTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalRestFEDs")
)


process.hltEcalRegionalESRestFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(),
    doES = cms.bool(True),
    type = cms.string('all'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(),
    sourceTag_es = cms.InputTag("hltESRawToRecHitFacility")
)


process.hltEcalRegionalEgammaFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(),
    doES = cms.bool(True),
    type = cms.string('egamma'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(cms.PSet(
        Source = cms.InputTag("hltL1extraParticles","Isolated"),
        regionPhiMargin = cms.double(0.4),
        Ptmin = cms.double(5.0),
        regionEtaMargin = cms.double(0.25)
    ),
        cms.PSet(
            Source = cms.InputTag("hltL1extraParticles","NonIsolated"),
            regionPhiMargin = cms.double(0.4),
            Ptmin = cms.double(5.0),
            regionEtaMargin = cms.double(0.25)
        )),
    sourceTag_es = cms.InputTag("hltESRawToRecHitFacility")
)


process.hltEcalRegionalEgammaRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(True),
    rechitCollection = cms.string('NotNeededsplitOutputTrue'),
    EErechitCollection = cms.string('EcalRecHitsEE'),
    EBrechitCollection = cms.string('EcalRecHitsEB'),
    lazyGetterTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalEgammaFEDs")
)


process.hltEcalRegionalJetsFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(cms.PSet(
        Source = cms.InputTag("hltL1extraParticles","Central"),
        regionPhiMargin = cms.double(1.0),
        Ptmin = cms.double(14.0),
        regionEtaMargin = cms.double(1.0)
    ),
        cms.PSet(
            Source = cms.InputTag("hltL1extraParticles","Forward"),
            regionPhiMargin = cms.double(1.0),
            Ptmin = cms.double(20.0),
            regionEtaMargin = cms.double(1.0)
        ),
        cms.PSet(
            Source = cms.InputTag("hltL1extraParticles","Tau"),
            regionPhiMargin = cms.double(1.0),
            Ptmin = cms.double(14.0),
            regionEtaMargin = cms.double(1.0)
        )),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(),
    doES = cms.bool(False),
    type = cms.string('jet'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(),
    sourceTag_es = cms.InputTag("NotNeededoESfalse")
)


process.hltEcalRegionalJetsRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(True),
    rechitCollection = cms.string('NotNeededsplitOutputTrue'),
    EErechitCollection = cms.string('EcalRecHitsEE'),
    EBrechitCollection = cms.string('EcalRecHitsEB'),
    lazyGetterTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalJetsFEDs")
)


process.hltEcalRegionalMuonsFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(cms.PSet(
        bePrecise = cms.bool(False),
        propagatorNameToBePrecise = cms.string(''),
        epsilon = cms.double(0.01),
        regionPhiMargin = cms.double(0.3),
        cType = cms.string('chargedcandidate'),
        Source = cms.InputTag("hltL2MuonCandidates"),
        Ptmin = cms.double(0.0),
        regionEtaMargin = cms.double(0.3)
    )),
    doES = cms.bool(False),
    type = cms.string('candidate'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(),
    sourceTag_es = cms.InputTag("NotNeededoESfalse")
)


process.hltEcalRegionalMuonsRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(True),
    rechitCollection = cms.string('NotNeededsplitOutputTrue'),
    EErechitCollection = cms.string('EcalRecHitsEE'),
    EBrechitCollection = cms.string('EcalRecHitsEB'),
    lazyGetterTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalMuonsFEDs")
)


process.hltEcalRegionalPi0EtaFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(),
    doES = cms.bool(True),
    type = cms.string('egamma'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(cms.PSet(
        Source = cms.InputTag("hltL1extraParticles","Isolated"),
        regionPhiMargin = cms.double(0.4),
        Ptmin = cms.double(2.0),
        regionEtaMargin = cms.double(0.25)
    ),
        cms.PSet(
            Source = cms.InputTag("hltL1extraParticles","NonIsolated"),
            regionPhiMargin = cms.double(0.4),
            Ptmin = cms.double(2.0),
            regionEtaMargin = cms.double(0.25)
        )),
    sourceTag_es = cms.InputTag("hltESRawToRecHitFacility")
)


process.hltEcalRegionalPi0EtaRecHit = cms.EDProducer("EcalRawToRecHitProducer",
    splitOutput = cms.bool(True),
    rechitCollection = cms.string(''),
    EErechitCollection = cms.string('EcalRecHitsEE'),
    EBrechitCollection = cms.string('EcalRecHitsEB'),
    lazyGetterTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    sourceTag = cms.InputTag("hltEcalRegionalPi0EtaFEDs")
)


process.hltEcalRegionalRestFEDs = cms.EDProducer("EcalRawToRecHitRoI",
    JetJobPSet = cms.VPSet(),
    MuJobPSet = cms.PSet(

    ),
    CandJobPSet = cms.VPSet(),
    doES = cms.bool(False),
    type = cms.string('all'),
    sourceTag = cms.InputTag("hltEcalRawToRecHitFacility"),
    EmJobPSet = cms.VPSet(),
    sourceTag_es = cms.InputTag("NotNeededoESfalse")
)


process.hltEgammaEcalActivityR9Shape = cms.EDProducer("EgammaHLTR9Producer",
    ecalRechitEE = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE"),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB"),
    useSwissCross = cms.bool(False)
)


process.hltElectronActivityDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatchElectronsActivity"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hltElectronL1IsoDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hltElectronL1NonIsoDetaDphi = cms.EDProducer("EgammaHLTElectronDetaDphiProducer",
    electronProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    BSProducer = cms.InputTag("hltOnlineBeamSpot")
)


process.hltFEDSelector = cms.EDProducer("EvFFEDSelector",
    inputTag = cms.InputTag("rawDataCollector"),
    fedList = cms.vuint32(1023)
)


process.hltFilterPFTauTrack5TightIsoL1QuadJet20Central = cms.EDProducer("L1HLTJetsMatching",
    JetSrc = cms.InputTag("hltConvPFTausTightIsoTrackPt5Isolation"),
    EtMin = cms.double(0.0),
    L1TauTrigger = cms.InputTag("hltL1sL1QuadJet20Central")
)


process.hltGctDigis = cms.EDProducer("GctRawToDigi",
    numberOfRctSamplesToUnpack = cms.uint32(1),
    numberOfGctSamplesToUnpack = cms.uint32(1),
    unpackSharedRegions = cms.bool(False),
    inputLabel = cms.InputTag("rawDataCollector"),
    unpackerVersion = cms.uint32(0),
    gctFedId = cms.untracked.int32(745),
    hltMode = cms.bool(True)
)


process.hltGetJetsfrom1EleCleanBJet40Central = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltSingleEleCleanBJet40Central")
)


process.hltGetJetsfromBJet40Central = cms.EDProducer("GetJetsFromHLTobject",
    jets = cms.InputTag("hltBJet40Central")
)


process.hltGtDigis = cms.EDProducer("L1GlobalTriggerRawToDigi",
    DaqGtFedId = cms.untracked.int32(813),
    Verbosity = cms.untracked.int32(0),
    UnpackBxInEvent = cms.int32(5),
    ActiveBoardsMask = cms.uint32(65535),
    DaqGtInputTag = cms.InputTag("rawDataCollector")
)


process.hltHFEMClusters = cms.EDProducer("HFEMClusterProducer",
    hits = cms.InputTag("hltHfreco"),
    usePMTFlag = cms.bool(True),
    minTowerEnergy = cms.double(4.0),
    maximumRenergy = cms.double(50.0),
    maximumSL = cms.double(0.98),
    usePulseFlag = cms.bool(True),
    forcePulseFlagMC = cms.bool(False),
    correctionType = cms.int32(1),
    seedThresholdET = cms.double(5.0)
)


process.hltHFRecoEcalCandidate = cms.EDProducer("HFRecoEcalCandidateProducer",
    hfclusters = cms.InputTag("hltHFEMClusters"),
    e9e25Cut = cms.double(0.9),
    eSeLCut = cms.vdouble(-1.0, 99.9),
    eCOREe9Cut = cms.vdouble(-1.0, 99.0),
    e1e9Cut = cms.vdouble(-1.0, 99.0),
    Correct = cms.bool(True),
    intercept2DCut = cms.double(0.2)
)


process.hltHITCkfTrackCandidatesHB = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltHITPixelTripletSeedGeneratorHB"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltHITCkfTrackCandidatesHE = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltHITPixelTripletSeedGeneratorHE"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltHITCtfWithMaterialTracksHB = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltHITCkfTrackCandidatesHB"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltHITCtfWithMaterialTracksHB8E29'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltHITCtfWithMaterialTracksHE = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltHITCkfTrackCandidatesHE"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltHITCtfWithMaterialTracksHE8E29'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltHITIPTCorrectorHB = cms.EDProducer("IPTCorrector",
    corTracksLabel = cms.InputTag("hltHITCtfWithMaterialTracksHB"),
    filterLabel = cms.InputTag("hltIsolPixelTrackL2FilterHB"),
    associationCone = cms.double(0.2)
)


process.hltHITIPTCorrectorHE = cms.EDProducer("IPTCorrector",
    corTracksLabel = cms.InputTag("hltHITCtfWithMaterialTracksHE"),
    filterLabel = cms.InputTag("hltIsolPixelTrackL2FilterHE"),
    associationCone = cms.double(0.2)
)


process.hltHITPixelTracksHB = cms.EDProducer("PixelTrackProducer",
    FilterPSet = cms.PSet(
        nSigmaTipMaxTolerance = cms.double(0.0),
        chi2 = cms.double(1000.0),
        ComponentName = cms.string('PixelTrackFilterByKinematics'),
        nSigmaInvPtTolerance = cms.double(0.0),
        ptMin = cms.double(0.7),
        tipMax = cms.double(1.0)
    ),
    useFilterWithES = cms.bool(False),
    FitterPSet = cms.PSet(
        ComponentName = cms.string('PixelFitterByConformalMappingAndLine'),
        TTRHBuilder = cms.string('hltESPTTRHBuilderPixelOnly'),
        fixImpactParameter = cms.double(0.0)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('GlobalRegionProducerFromBeamSpot'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            originRadius = cms.double(0.0015),
            nSigmaZ = cms.double(3.0),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            ptMin = cms.double(0.7)
        )
    ),
    CleanerPSet = cms.PSet(
        ComponentName = cms.string('PixelTrackCleanerBySharedHits')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            phiPreFiltering = cms.double(0.3),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTripletsHITHB')
    )
)


process.hltHITPixelTracksHE = cms.EDProducer("PixelTrackProducer",
    FilterPSet = cms.PSet(
        nSigmaTipMaxTolerance = cms.double(0.0),
        chi2 = cms.double(1000.0),
        ComponentName = cms.string('PixelTrackFilterByKinematics'),
        nSigmaInvPtTolerance = cms.double(0.0),
        ptMin = cms.double(0.35),
        tipMax = cms.double(1.0)
    ),
    useFilterWithES = cms.bool(False),
    FitterPSet = cms.PSet(
        ComponentName = cms.string('PixelFitterByConformalMappingAndLine'),
        TTRHBuilder = cms.string('hltESPTTRHBuilderPixelOnly'),
        fixImpactParameter = cms.double(0.0)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('GlobalRegionProducerFromBeamSpot'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            originRadius = cms.double(0.0015),
            nSigmaZ = cms.double(3.0),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            ptMin = cms.double(0.35)
        )
    ),
    CleanerPSet = cms.PSet(
        ComponentName = cms.string('PixelTrackCleanerBySharedHits')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            phiPreFiltering = cms.double(0.3),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTripletsHITHE')
    )
)


process.hltHITPixelTripletSeedGeneratorHB = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('HITRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            useIsoTracks = cms.bool(True),
            trackSrc = cms.InputTag("hltHITPixelTracksHB"),
            l1tjetSrc = cms.InputTag("hltL1extraParticles","Tau"),
            isoTrackSrc = cms.InputTag("hltIsolPixelTrackL2FilterHB"),
            precise = cms.bool(True),
            deltaEtaL1JetRegion = cms.double(0.3),
            useTracks = cms.bool(False),
            originRadius = cms.double(0.6),
            originHalfLength = cms.double(15.0),
            useL1Jets = cms.bool(False),
            deltaPhiTrackRegion = cms.double(0.05),
            deltaPhiL1JetRegion = cms.double(0.3),
            ptMin = cms.double(1.0),
            fixedReg = cms.bool(False),
            etaCenter = cms.double(0.0),
            phiCenter = cms.double(0.0),
            originZPos = cms.double(0.0),
            deltaEtaTrackRegion = cms.double(0.05),
            vertexSrc = cms.string('hltHITPixelVerticesHB')
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            phiPreFiltering = cms.double(0.3),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTriplets')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltHITPixelTripletSeedGeneratorHE = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('HITRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            useIsoTracks = cms.bool(True),
            trackSrc = cms.InputTag("hltHITPixelTracksHE"),
            l1tjetSrc = cms.InputTag("hltL1extraParticles","Tau"),
            isoTrackSrc = cms.InputTag("hltIsolPixelTrackL2FilterHE"),
            precise = cms.bool(True),
            deltaEtaL1JetRegion = cms.double(0.3),
            useTracks = cms.bool(False),
            originRadius = cms.double(0.6),
            originHalfLength = cms.double(15.0),
            useL1Jets = cms.bool(False),
            deltaPhiTrackRegion = cms.double(0.05),
            deltaPhiL1JetRegion = cms.double(0.3),
            ptMin = cms.double(0.5),
            fixedReg = cms.bool(False),
            etaCenter = cms.double(0.0),
            phiCenter = cms.double(0.0),
            originZPos = cms.double(0.0),
            deltaEtaTrackRegion = cms.double(0.05),
            vertexSrc = cms.string('hltHITPixelVerticesHE')
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            phiPreFiltering = cms.double(0.3),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTriplets')
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltHITPixelVerticesHB = cms.EDProducer("PixelVertexProducer",
    WtAverage = cms.bool(True),
    Method2 = cms.bool(True),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Verbosity = cms.int32(0),
    UseError = cms.bool(True),
    TrackCollection = cms.InputTag("hltHITPixelTracksHB"),
    ZSeparation = cms.double(0.05),
    NTrkMin = cms.int32(2),
    ZOffset = cms.double(5.0),
    Finder = cms.string('DivisiveVertexFinder'),
    PtMin = cms.double(1.0)
)


process.hltHITPixelVerticesHE = cms.EDProducer("PixelVertexProducer",
    WtAverage = cms.bool(True),
    Method2 = cms.bool(True),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Verbosity = cms.int32(0),
    UseError = cms.bool(True),
    TrackCollection = cms.InputTag("hltHITPixelTracksHE"),
    ZSeparation = cms.double(0.05),
    NTrkMin = cms.int32(2),
    ZOffset = cms.double(5.0),
    Finder = cms.string('DivisiveVertexFinder'),
    PtMin = cms.double(1.0)
)


process.hltHbhereco = cms.EDProducer("HcalHitReconstructor",
    setTimingShapedCutsFlags = cms.bool(False),
    S9S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(24),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        isS8S1 = cms.bool(False)
    ),
    firstAuxOffset = cms.int32(0),
    saturationParameters = cms.PSet(
        maxADCvalue = cms.int32(127)
    ),
    tsFromDB = cms.bool(True),
    samplesToAdd = cms.int32(4),
    correctionPhaseNS = cms.double(13.0),
    HFInWindowStat = cms.PSet(

    ),
    pulseShapeParameters = cms.PSet(

    ),
    digiLabel = cms.InputTag("hltHcalDigis"),
    timingshapedcutsParameters = cms.PSet(
        ignorelowest = cms.bool(True),
        win_offset = cms.double(0.0),
        ignorehighest = cms.bool(False),
        win_gain = cms.double(1.0),
        tfilterEnvelope = cms.vdouble(4.0, 12.04, 13.0, 10.56, 23.5,
            8.82, 37.0, 7.38, 56.0, 6.3,
            81.0, 5.64, 114.5, 5.44, 175.5,
            5.38, 350.5, 5.14)
    ),
    setHSCPFlags = cms.bool(False),
    firstAuxTS = cms.int32(4),
    digistat = cms.PSet(

    ),
    hfTimingTrustParameters = cms.PSet(
        hfTimingTrustLevel2 = cms.int32(4),
        hfTimingTrustLevel1 = cms.int32(1)
    ),
    PETstat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_R_29 = cms.vdouble(0.8),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(0),
        short_R = cms.vdouble(0.8),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        long_R_29 = cms.vdouble(0.8),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_R = cms.vdouble(0.98)
    ),
    setSaturationFlags = cms.bool(False),
    flagParameters = cms.PSet(
        nominalPedestal = cms.double(3.0),
        hitMultiplicityThreshold = cms.int32(17),
        hitEnergyMinimum = cms.double(1.0),
        pulseShapeParameterSets = cms.VPSet(cms.PSet(
            pulseShapeParameters = cms.vdouble(0.0, 100.0, -50.0, 0.0, -15.0,
                0.15)
        ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(100.0, 2000.0, -50.0, 0.0, -5.0,
                    0.05)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(2000.0, 1000000.0, -50.0, 0.0, 95.0,
                    0.0)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(-1000000.0, 1000000.0, 45.0, 0.1, 1000000.0,
                    0.0)
            ))
    ),
    setTimingTrustFlags = cms.bool(False),
    S8S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        flagsToSkip = cms.int32(16),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        longEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        long_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        isS8S1 = cms.bool(True)
    ),
    correctForPhaseContainment = cms.bool(True),
    correctForTimeslew = cms.bool(True),
    setNoiseFlags = cms.bool(False),
    correctTiming = cms.bool(False),
    Subdetector = cms.string('HBHE'),
    hscpParameters = cms.PSet(
        slopeMax = cms.double(-0.6),
        r1Max = cms.double(1.0),
        r1Min = cms.double(0.15),
        fracLeaderMax = cms.double(0.7),
        slopeMin = cms.double(-1.5),
        outerMin = cms.double(0.0),
        outerMax = cms.double(0.1),
        fracLeaderMin = cms.double(0.4),
        r2Min = cms.double(0.1),
        r2Max = cms.double(0.5),
        TimingEnergyThreshold = cms.double(30.0)
    ),
    dropZSmarkedPassed = cms.bool(True),
    setPulseShapeFlags = cms.bool(False),
    firstSample = cms.int32(4)
)


process.hltHcalDigis = cms.EDProducer("HcalRawToDigi",
    UnpackZDC = cms.untracked.bool(True),
    FilterDataQuality = cms.bool(True),
    InputLabel = cms.InputTag("rawDataCollector"),
    UnpackCalib = cms.untracked.bool(True),
    lastSample = cms.int32(9),
    firstSample = cms.int32(0)
)


process.hltHfreco = cms.EDProducer("HcalHitReconstructor",
    setTimingShapedCutsFlags = cms.bool(False),
    S9S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(24),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        isS8S1 = cms.bool(False)
    ),
    firstAuxOffset = cms.int32(0),
    saturationParameters = cms.PSet(
        maxADCvalue = cms.int32(127)
    ),
    tsFromDB = cms.bool(True),
    samplesToAdd = cms.int32(2),
    correctionPhaseNS = cms.double(0.0),
    HFInWindowStat = cms.PSet(
        hflongEthresh = cms.double(40.0),
        hflongMinWindowTime = cms.vdouble(-10.0),
        hfshortEthresh = cms.double(40.0),
        hflongMaxWindowTime = cms.vdouble(10.0),
        hfshortMaxWindowTime = cms.vdouble(10.0),
        hfshortMinWindowTime = cms.vdouble(-12.0)
    ),
    pulseShapeParameters = cms.PSet(

    ),
    digiLabel = cms.InputTag("hltHcalDigis"),
    timingshapedcutsParameters = cms.PSet(
        ignorelowest = cms.bool(True),
        win_offset = cms.double(0.0),
        ignorehighest = cms.bool(False),
        win_gain = cms.double(1.0),
        tfilterEnvelope = cms.vdouble(4.0, 12.04, 13.0, 10.56, 23.5,
            8.82, 37.0, 7.38, 56.0, 6.3,
            81.0, 5.64, 114.5, 5.44, 175.5,
            5.38, 350.5, 5.14)
    ),
    setHSCPFlags = cms.bool(False),
    firstAuxTS = cms.int32(4),
    digistat = cms.PSet(
        HFdigiflagFirstSample = cms.int32(3),
        HFdigiflagMinEthreshold = cms.double(40.0),
        HFdigiflagSamplesToAdd = cms.int32(4),
        HFdigiflagCoef0 = cms.double(0.93),
        HFdigiflagCoef2 = cms.double(-0.012667),
        HFdigiflagCoef1 = cms.double(-0.38275),
        HFdigiflagExpectedPeak = cms.int32(4)
    ),
    hfTimingTrustParameters = cms.PSet(
        hfTimingTrustLevel2 = cms.int32(4),
        hfTimingTrustLevel1 = cms.int32(1)
    ),
    PETstat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_R_29 = cms.vdouble(0.8),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(0),
        short_R = cms.vdouble(0.8),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        long_R_29 = cms.vdouble(0.8),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_R = cms.vdouble(0.98)
    ),
    setSaturationFlags = cms.bool(False),
    flagParameters = cms.PSet(
        nominalPedestal = cms.double(3.0),
        hitMultiplicityThreshold = cms.int32(17),
        hitEnergyMinimum = cms.double(1.0),
        pulseShapeParameterSets = cms.VPSet(cms.PSet(
            pulseShapeParameters = cms.vdouble(0.0, 100.0, -50.0, 0.0, -15.0,
                0.15)
        ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(100.0, 2000.0, -50.0, 0.0, -5.0,
                    0.05)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(2000.0, 1000000.0, -50.0, 0.0, 95.0,
                    0.0)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(-1000000.0, 1000000.0, 45.0, 0.1, 1000000.0,
                    0.0)
            ))
    ),
    setTimingTrustFlags = cms.bool(False),
    S8S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        flagsToSkip = cms.int32(16),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        longEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        long_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        isS8S1 = cms.bool(True)
    ),
    correctForPhaseContainment = cms.bool(False),
    correctForTimeslew = cms.bool(False),
    setNoiseFlags = cms.bool(False),
    correctTiming = cms.bool(False),
    Subdetector = cms.string('HF'),
    hscpParameters = cms.PSet(
        slopeMax = cms.double(-0.6),
        r1Max = cms.double(1.0),
        r1Min = cms.double(0.15),
        fracLeaderMax = cms.double(0.7),
        slopeMin = cms.double(-1.5),
        outerMin = cms.double(0.0),
        outerMax = cms.double(0.1),
        fracLeaderMin = cms.double(0.4),
        r2Min = cms.double(0.1),
        r2Max = cms.double(0.5),
        TimingEnergyThreshold = cms.double(30.0)
    ),
    dropZSmarkedPassed = cms.bool(True),
    setPulseShapeFlags = cms.bool(False),
    firstSample = cms.int32(4)
)


process.hltHoreco = cms.EDProducer("HcalHitReconstructor",
    setTimingShapedCutsFlags = cms.bool(False),
    S9S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(24),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_optimumSlope = cms.vdouble(-99999.0, 0.0164905, 0.0238698, 0.0321383, 0.041296,
            0.0513428, 0.0622789, 0.0741041, 0.0868186, 0.100422,
            0.135313, 0.136289, 0.0589927),
        isS8S1 = cms.bool(False)
    ),
    firstAuxOffset = cms.int32(0),
    saturationParameters = cms.PSet(
        maxADCvalue = cms.int32(127)
    ),
    tsFromDB = cms.bool(True),
    samplesToAdd = cms.int32(4),
    correctionPhaseNS = cms.double(13.0),
    HFInWindowStat = cms.PSet(

    ),
    pulseShapeParameters = cms.PSet(

    ),
    digiLabel = cms.InputTag("hltHcalDigis"),
    timingshapedcutsParameters = cms.PSet(
        ignorelowest = cms.bool(True),
        win_offset = cms.double(0.0),
        ignorehighest = cms.bool(False),
        win_gain = cms.double(1.0),
        tfilterEnvelope = cms.vdouble(4.0, 12.04, 13.0, 10.56, 23.5,
            8.82, 37.0, 7.38, 56.0, 6.3,
            81.0, 5.64, 114.5, 5.44, 175.5,
            5.38, 350.5, 5.14)
    ),
    setHSCPFlags = cms.bool(False),
    firstAuxTS = cms.int32(4),
    digistat = cms.PSet(

    ),
    hfTimingTrustParameters = cms.PSet(
        hfTimingTrustLevel2 = cms.int32(4),
        hfTimingTrustLevel1 = cms.int32(1)
    ),
    PETstat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_R_29 = cms.vdouble(0.8),
        shortEnergyParams = cms.vdouble(35.1773, 35.37, 35.7933, 36.4472, 37.3317,
            38.4468, 39.7925, 41.3688, 43.1757, 45.2132,
            47.4813, 49.98, 52.7093),
        flagsToSkip = cms.int32(0),
        short_R = cms.vdouble(0.8),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        long_R_29 = cms.vdouble(0.8),
        longEnergyParams = cms.vdouble(43.5, 45.7, 48.32, 51.36, 54.82,
            58.7, 63.0, 67.72, 72.86, 78.42,
            84.4, 90.8, 97.62),
        long_R = cms.vdouble(0.98)
    ),
    setSaturationFlags = cms.bool(False),
    flagParameters = cms.PSet(
        nominalPedestal = cms.double(3.0),
        hitMultiplicityThreshold = cms.int32(17),
        hitEnergyMinimum = cms.double(1.0),
        pulseShapeParameterSets = cms.VPSet(cms.PSet(
            pulseShapeParameters = cms.vdouble(0.0, 100.0, -50.0, 0.0, -15.0,
                0.15)
        ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(100.0, 2000.0, -50.0, 0.0, -5.0,
                    0.05)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(2000.0, 1000000.0, -50.0, 0.0, 95.0,
                    0.0)
            ),
            cms.PSet(
                pulseShapeParameters = cms.vdouble(-1000000.0, 1000000.0, 45.0, 0.1, 1000000.0,
                    0.0)
            ))
    ),
    setTimingTrustFlags = cms.bool(False),
    S8S1stat = cms.PSet(
        longETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        shortEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        flagsToSkip = cms.int32(16),
        shortETParams = cms.vdouble(0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0),
        short_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        longEnergyParams = cms.vdouble(40.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0, 100.0, 100.0,
            100.0, 100.0, 100.0),
        long_optimumSlope = cms.vdouble(0.3, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.1),
        isS8S1 = cms.bool(True)
    ),
    correctForPhaseContainment = cms.bool(True),
    correctForTimeslew = cms.bool(True),
    setNoiseFlags = cms.bool(False),
    correctTiming = cms.bool(False),
    Subdetector = cms.string('HO'),
    hscpParameters = cms.PSet(
        slopeMax = cms.double(-0.6),
        r1Max = cms.double(1.0),
        r1Min = cms.double(0.15),
        fracLeaderMax = cms.double(0.7),
        slopeMin = cms.double(-1.5),
        outerMin = cms.double(0.0),
        outerMax = cms.double(0.1),
        fracLeaderMin = cms.double(0.4),
        r2Min = cms.double(0.1),
        r2Max = cms.double(0.5),
        TimingEnergyThreshold = cms.double(30.0)
    ),
    dropZSmarkedPassed = cms.bool(True),
    setPulseShapeFlags = cms.bool(False),
    firstSample = cms.int32(4)
)


process.hltHybridSuperClustersActivity = cms.EDProducer("HybridClusterProducer",
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    ),
    severityRecHitThreshold = cms.double(4.0),
    RecHitFlagToBeExcluded = cms.vint32(),
    ecalhitcollection = cms.string('EcalRecHitsEB'),
    eThreshA = cms.double(0.003),
    basicclusterCollection = cms.string('hybridBarrelBasicClusters'),
    eThreshB = cms.double(0.1),
    dynamicPhiRoad = cms.bool(False),
    severitySpikeId = cms.int32(2),
    excludeFlagged = cms.bool(False),
    eseed = cms.double(0.35),
    ethresh = cms.double(0.1),
    ewing = cms.double(0.0),
    RecHitSeverityToBeExcluded = cms.vint32(999),
    step = cms.int32(17),
    debugLevel = cms.string('ERROR'),
    dynamicEThresh = cms.bool(False),
    superclusterCollection = cms.string(''),
    HybridBarrelSeedThr = cms.double(1.0),
    bremRecoveryPset = cms.PSet(

    ),
    severitySpikeThreshold = cms.double(0.95),
    ecalhitproducer = cms.string('hltEcalRecHitAll')
)


process.hltHybridSuperClustersL1Isolated = cms.EDProducer("EgammaHLTHybridClusterProducer",
    regionEtaMargin = cms.double(0.14),
    regionPhiMargin = cms.double(0.4),
    severityRecHitThreshold = cms.double(4.0),
    RecHitFlagToBeExcluded = cms.vint32(),
    ecalhitcollection = cms.string('EcalRecHitsEB'),
    eThreshA = cms.double(0.003),
    basicclusterCollection = cms.string(''),
    eThreshB = cms.double(0.1),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    ),
    l1UpperThr = cms.double(999.0),
    excludeFlagged = cms.bool(False),
    severitySpikeId = cms.int32(2),
    l1LowerThr = cms.double(5.0),
    doIsolated = cms.bool(True),
    eseed = cms.double(0.35),
    ethresh = cms.double(0.1),
    ewing = cms.double(0.0),
    RecHitSeverityToBeExcluded = cms.vint32(999),
    dynamicPhiRoad = cms.bool(False),
    step = cms.int32(17),
    debugLevel = cms.string('INFO'),
    dynamicEThresh = cms.bool(False),
    l1TagIsolated = cms.InputTag("hltL1extraParticles","Isolated"),
    superclusterCollection = cms.string(''),
    HybridBarrelSeedThr = cms.double(1.5),
    l1TagNonIsolated = cms.InputTag("hltL1extraParticles","NonIsolated"),
    l1LowerThrIgnoreIsolation = cms.double(999.0),
    ecalhitproducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    severitySpikeThreshold = cms.double(0.95),
    bremRecoveryPset = cms.PSet(

    )
)


process.hltHybridSuperClustersL1NonIsolated = cms.EDProducer("EgammaHLTHybridClusterProducer",
    regionEtaMargin = cms.double(0.14),
    regionPhiMargin = cms.double(0.4),
    severityRecHitThreshold = cms.double(4.0),
    RecHitFlagToBeExcluded = cms.vint32(),
    ecalhitcollection = cms.string('EcalRecHitsEB'),
    eThreshA = cms.double(0.003),
    basicclusterCollection = cms.string(''),
    eThreshB = cms.double(0.1),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    ),
    l1UpperThr = cms.double(999.0),
    excludeFlagged = cms.bool(False),
    severitySpikeId = cms.int32(2),
    l1LowerThr = cms.double(5.0),
    doIsolated = cms.bool(False),
    eseed = cms.double(0.35),
    ethresh = cms.double(0.1),
    ewing = cms.double(0.0),
    RecHitSeverityToBeExcluded = cms.vint32(999),
    dynamicPhiRoad = cms.bool(False),
    step = cms.int32(17),
    debugLevel = cms.string('INFO'),
    dynamicEThresh = cms.bool(False),
    l1TagIsolated = cms.InputTag("hltL1extraParticles","Isolated"),
    superclusterCollection = cms.string(''),
    HybridBarrelSeedThr = cms.double(1.5),
    l1TagNonIsolated = cms.InputTag("hltL1extraParticles","NonIsolated"),
    l1LowerThrIgnoreIsolation = cms.double(999.0),
    ecalhitproducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    severitySpikeThreshold = cms.double(0.95),
    bremRecoveryPset = cms.PSet(

    )
)


process.hltIconeCentral1Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersCentral1Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeCentral2Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersCentral2Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeCentral3Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersCentral3Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeCentral4Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersCentral4Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeTau1Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersTau1Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeTau2Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersTau2Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeTau3Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersTau3Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIconeTau4Regional = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.2),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltCaloTowersTau4Regional"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltIsolPixelTrackProdHB = cms.EDProducer("IsolatedPixelTrackCandidateProducer",
    EBEtaBoundary = cms.double(1.479),
    L1eTauJetsSource = cms.InputTag("hltL1extraParticles","Tau"),
    MaxVtxDXYSeed = cms.double(101.0),
    tauUnbiasCone = cms.double(1.2),
    PixelIsolationConeSizeAtEC = cms.double(40.0),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    minPTrack = cms.double(5.0),
    maxPTrackForIsolation = cms.double(3.0),
    MagFieldRecordName = cms.string('VolumeBasedMagneticField'),
    VertexLabel = cms.InputTag("hltHITPixelVerticesHB"),
    PixelTracksSources = cms.VInputTag("hltHITPixelTracksHB"),
    MaxVtxDXYIsol = cms.double(101.0),
    tauAssociationCone = cms.double(0.0),
    ExtrapolationConeSize = cms.double(1.0)
)


process.hltIsolPixelTrackProdHE = cms.EDProducer("IsolatedPixelTrackCandidateProducer",
    EBEtaBoundary = cms.double(1.479),
    L1eTauJetsSource = cms.InputTag("hltL1extraParticles","Tau"),
    MaxVtxDXYSeed = cms.double(101.0),
    tauUnbiasCone = cms.double(1.2),
    PixelIsolationConeSizeAtEC = cms.double(40.0),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    minPTrack = cms.double(5.0),
    maxPTrackForIsolation = cms.double(3.0),
    MagFieldRecordName = cms.string('VolumeBasedMagneticField'),
    VertexLabel = cms.InputTag("hltHITPixelVerticesHE"),
    PixelTracksSources = cms.VInputTag("hltHITPixelTracksHB", "hltHITPixelTracksHE"),
    MaxVtxDXYIsol = cms.double(101.0),
    tauAssociationCone = cms.double(0.0),
    ExtrapolationConeSize = cms.double(1.0)
)


process.hltJet40Ht = cms.EDProducer("METProducer",
    HB_EtResPar = cms.vdouble(0.0, 1.22, 0.05),
    EE_EtResPar = cms.vdouble(0.2, 0.03, 0.005),
    HF_PhiResPar = cms.vdouble(0.05022),
    HE_PhiResPar = cms.vdouble(0.02511),
    HB_PhiResPar = cms.vdouble(0.02511),
    onlyFiducialParticles = cms.bool(False),
    noHF = cms.bool(True),
    HF_EtResPar = cms.vdouble(0.0, 1.82, 0.09),
    InputType = cms.string('CaloJetCollection'),
    METType = cms.string('MET'),
    correctShowerTracks = cms.bool(False),
    EB_EtResPar = cms.vdouble(0.2, 0.03, 0.005),
    rf_type = cms.int32(0),
    jets = cms.InputTag("unused"),
    EB_PhiResPar = cms.vdouble(0.00502),
    src = cms.InputTag("hltJetIDPassedCorrJets"),
    HO_PhiResPar = cms.vdouble(0.02511),
    calculateSignificance = cms.bool(False),
    EE_PhiResPar = cms.vdouble(0.02511),
    HO_EtResPar = cms.vdouble(0.0, 1.3, 0.005),
    alias = cms.string('HTMET'),
    globalThreshold = cms.double(40.0),
    HE_EtResPar = cms.vdouble(0.0, 1.3, 0.05)
)


process.hltJetIDPassedAK5Jets = cms.EDProducer("HLTJetIDProducer",
    jetsInput = cms.InputTag("hltAntiKT5CaloJets"),
    min_EMF = cms.double(1e-06),
    min_N90 = cms.int32(2),
    max_EMF = cms.double(999.0)
)


process.hltJetIDPassedCorrJets = cms.EDProducer("HLTJetIDProducer",
    jetsInput = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    min_EMF = cms.double(1e-06),
    min_N90 = cms.int32(2),
    max_EMF = cms.double(999.0)
)


process.hltJetIDPassedJetsRegional = cms.EDProducer("HLTJetIDProducer",
    jetsInput = cms.InputTag("hltL1MatchedJetsRegional"),
    min_EMF = cms.double(1e-06),
    min_N90 = cms.int32(2),
    max_EMF = cms.double(999.0)
)


process.hltL1GtObjectMap = cms.EDProducer("L1GlobalTrigger",
    CastorInputTag = cms.InputTag("castorL1Digis"),
    EmulateBxInEvent = cms.int32(1),
    ProduceL1GtDaqRecord = cms.bool(False),
    ReadTechnicalTriggerRecords = cms.bool(True),
    RecordLength = cms.vint32(3, 0),
    ProduceL1GtEvmRecord = cms.bool(False),
    GmtInputTag = cms.InputTag("hltGtDigis"),
    AlternativeNrBxBoardEvm = cms.uint32(0),
    TechnicalTriggersInputTags = cms.VInputTag("simBscDigis"),
    ProduceL1GtObjectMapRecord = cms.bool(True),
    GctInputTag = cms.InputTag("hltGctDigis"),
    AlternativeNrBxBoardDaq = cms.uint32(0),
    WritePsbL1GtDaqRecord = cms.bool(False),
    BstLengthBytes = cms.int32(-1)
)


process.hltL1HLTDoubleIsoPFTau20Trk5JetsMatch = cms.EDProducer("L1HLTJetsMatching",
    JetSrc = cms.InputTag("hltConvPFTausTightIsoTrackPt5Isolation"),
    EtMin = cms.double(0.0),
    L1TauTrigger = cms.InputTag("hltL1sDoubleIsoTau20Trk5")
)


process.hltL1HLTSingleIsoPFTau35Trk20Met45JetsMatch = cms.EDProducer("L1HLTJetsMatching",
    JetSrc = cms.InputTag("hltConvPFTauTightIsoTrackPt20Isolation"),
    EtMin = cms.double(0.0),
    L1TauTrigger = cms.InputTag("hltL1sSingleIsoTau35Trk20MET45")
)


process.hltL1Iso3HitElectronTrackIsol = cms.EDProducer("EgammaHLTElectronTrackIsolationProducers",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoVetoConeSize = cms.double(0.03),
    trackProducer = cms.InputTag("hltL1IsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    egTrkIsoConeSize = cms.double(0.3),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(0.15)
)


process.hltL1IsoEgammaRegionalCTFFinalFitWithMaterial = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL1IsoEgammaRegionalCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltEgammaRegionalCTFFinalFitWithMaterial'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL1IsoEgammaRegionalCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1IsoEgammaRegionalPixelSeedGenerator"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltL1IsoEgammaRegionalPixelSeedGenerator = cms.EDProducer("EgammaHLTRegionalPixelSeedGeneratorProducers",
    deltaPhiRegion = cms.double(0.3),
    vertexZ = cms.double(0.0),
    originHalfLength = cms.double(15.0),
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    UseZInVertex = cms.bool(False),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    deltaEtaRegion = cms.double(0.3),
    ptMin = cms.double(1.5),
    candTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    candTagEle = cms.InputTag("pixelMatchElectrons"),
    originRadius = cms.double(0.02)
)


process.hltL1IsoElectronTrackIsol = cms.EDProducer("EgammaHLTElectronTrackIsolationProducers",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoVetoConeSize = cms.double(0.03),
    trackProducer = cms.InputTag("hltL1IsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    electronProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    egTrkIsoConeSize = cms.double(0.3),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(0.15)
)


process.hltL1IsoHLTClusterShape = cms.EDProducer("EgammaHLTClusterShapeProducer",
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE"),
    isIeta = cms.bool(True)
)


process.hltL1IsoR9ID = cms.EDProducer("EgammaHLTR9IDProducer",
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE")
)


process.hltL1IsoR9shape = cms.EDProducer("EgammaHLTR9Producer",
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE"),
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    useSwissCross = cms.bool(False)
)


process.hltL1IsoRecoEcalCandidate = cms.EDProducer("EgammaHLTRecoEcalCandidateProducers",
    scIslandEndcapProducer = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1Isolated"),
    scHybridBarrelProducer = cms.InputTag("hltCorrectedHybridSuperClustersL1Isolated"),
    recoEcalCandidateCollection = cms.string('')
)


process.hltL1IsoStartUpElectronPixelSeeds = cms.EDProducer("ElectronSeedProducer",
    endcapSuperClusters = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1Isolated"),
    SeedConfiguration = cms.PSet(
        searchInTIDTEC = cms.bool(True),
        HighPtThreshold = cms.double(35.0),
        r2MinF = cms.double(-0.15),
        OrderedHitsFactoryPSet = cms.PSet(
            maxElement = cms.uint32(0),
            ComponentName = cms.string('StandardHitPairGenerator'),
            SeedingLayers = cms.string('hltESPMixedLayerPairs'),
            useOnDemandTracker = cms.untracked.int32(0)
        ),
        DeltaPhi1Low = cms.double(0.23),
        DeltaPhi1High = cms.double(0.08),
        ePhiMin1 = cms.double(-0.08),
        PhiMin2 = cms.double(-0.004),
        LowPtThreshold = cms.double(3.0),
        RegionPSet = cms.PSet(
            deltaPhiRegion = cms.double(0.4),
            originHalfLength = cms.double(15.0),
            useZInVertex = cms.bool(True),
            deltaEtaRegion = cms.double(0.1),
            ptMin = cms.double(1.5),
            originRadius = cms.double(0.2),
            VertexProducer = cms.InputTag("dummyVertices")
        ),
        maxHOverE = cms.double(999999.0),
        dynamicPhiRoad = cms.bool(False),
        ePhiMax1 = cms.double(0.04),
        DeltaPhi2 = cms.double(0.004),
        measurementTrackerName = cms.string('hltESPMeasurementTracker'),
        SizeWindowENeg = cms.double(0.675),
        nSigmasDeltaZ1 = cms.double(5.0),
        rMaxI = cms.double(0.2),
        rMinI = cms.double(-0.2),
        preFilteredSeeds = cms.bool(True),
        r2MaxF = cms.double(0.15),
        pPhiMin1 = cms.double(-0.04),
        initialSeeds = cms.InputTag("noSeedsHere"),
        pPhiMax1 = cms.double(0.08),
        hbheModule = cms.string('hbhereco'),
        SCEtCut = cms.double(3.0),
        z2MaxB = cms.double(0.09),
        fromTrackerSeeds = cms.bool(True),
        hcalRecHits = cms.InputTag("hltHbhereco"),
        z2MinB = cms.double(-0.09),
        hbheInstance = cms.string(''),
        PhiMax2 = cms.double(0.004),
        hOverEConeSize = cms.double(0.0),
        hOverEHBMinE = cms.double(999999.0),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        applyHOverECut = cms.bool(False),
        hOverEHFMinE = cms.double(999999.0)
    ),
    barrelSuperClusters = cms.InputTag("hltCorrectedHybridSuperClustersL1Isolated")
)


process.hltL1IsolatedPhotonEcalIsol = cms.EDProducer("EgammaHLTEcalRecIsolationProducer",
    useNumCrystals = cms.bool(True),
    etMinBarrel = cms.double(-9999.0),
    etMinEndcap = cms.double(0.1),
    tryBoth = cms.bool(True),
    eMinEndcap = cms.double(-9999.0),
    ecalEndcapRecHitCollection = cms.InputTag("EcalRecHitsEE"),
    intRadiusEndcap = cms.double(3.0),
    ecalEndcapRecHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    jurassicWidth = cms.double(3.0),
    ecalBarrelRecHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    extRadius = cms.double(0.3),
    useIsolEt = cms.bool(True),
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    ecalBarrelRecHitCollection = cms.InputTag("EcalRecHitsEB"),
    intRadiusBarrel = cms.double(3.0),
    subtract = cms.bool(False),
    eMinBarrel = cms.double(0.08)
)


process.hltL1IsolatedPhotonHcalForHE = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.14),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.0),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    doEtSum = cms.bool(False)
)


process.hltL1IsolatedPhotonHcalIsol = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.29),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.16),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    doEtSum = cms.bool(True)
)


process.hltL1IsolatedPhotonHollowTrackIsol = cms.EDProducer("EgammaHLTPhotonTrackIsolationProducersRegional",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoConeSize = cms.double(0.29),
    trackProducer = cms.InputTag("hltL1IsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    countTracks = cms.bool(False),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoVetoConeSize = cms.double(0.06),
    recoEcalCandidateProducer = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(999999.0)
)


process.hltL1MatchedJetsRegional = cms.EDProducer("HLTJetL1MatchProducer",
    L1TauJets = cms.InputTag("hltL1extraParticles","Tau"),
    DeltaR = cms.double(0.5),
    L1ForJets = cms.InputTag("hltL1extraParticles","Forward"),
    L1CenJets = cms.InputTag("hltL1extraParticles","Central"),
    jetsInput = cms.InputTag("hltAntiKT5L2L3CorrCaloJetsRegional")
)


process.hltL1NonIso3HitElectronTrackIsol = cms.EDProducer("EgammaHLTElectronTrackIsolationProducers",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoVetoConeSize = cms.double(0.03),
    trackProducer = cms.InputTag("hltL1NonIsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    electronProducer = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    egTrkIsoConeSize = cms.double(0.3),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(0.15)
)


process.hltL1NonIsoEgammaRegionalCTFFinalFitWithMaterial = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL1NonIsoEgammaRegionalCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltEgammaRegionalCTFFinalFitWithMaterial'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL1NonIsoEgammaRegionalCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltL1NonIsoEgammaRegionalPixelSeedGenerator"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltL1NonIsoEgammaRegionalPixelSeedGenerator = cms.EDProducer("EgammaHLTRegionalPixelSeedGeneratorProducers",
    deltaPhiRegion = cms.double(0.3),
    vertexZ = cms.double(0.0),
    originHalfLength = cms.double(15.0),
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    UseZInVertex = cms.bool(False),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    deltaEtaRegion = cms.double(0.3),
    ptMin = cms.double(1.5),
    candTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    candTagEle = cms.InputTag("pixelMatchElectrons"),
    originRadius = cms.double(0.02)
)


process.hltL1NonIsoElectronTrackIsol = cms.EDProducer("EgammaHLTElectronTrackIsolationProducers",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoVetoConeSize = cms.double(0.03),
    trackProducer = cms.InputTag("hltL1NonIsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    electronProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    egTrkIsoConeSize = cms.double(0.3),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(0.15)
)


process.hltL1NonIsoHLTClusterShape = cms.EDProducer("EgammaHLTClusterShapeProducer",
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE"),
    isIeta = cms.bool(True)
)


process.hltL1NonIsoR9ID = cms.EDProducer("EgammaHLTR9IDProducer",
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE")
)


process.hltL1NonIsoR9shape = cms.EDProducer("EgammaHLTR9Producer",
    ecalRechitEE = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEE"),
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRegionalEgammaRecHit","EcalRecHitsEB"),
    useSwissCross = cms.bool(False)
)


process.hltL1NonIsoRecoEcalCandidate = cms.EDProducer("EgammaHLTRecoEcalCandidateProducers",
    scIslandEndcapProducer = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated"),
    scHybridBarrelProducer = cms.InputTag("hltCorrectedHybridSuperClustersL1NonIsolated"),
    recoEcalCandidateCollection = cms.string('')
)


process.hltL1NonIsoStartUpElectronPixelSeeds = cms.EDProducer("ElectronSeedProducer",
    endcapSuperClusters = cms.InputTag("hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated"),
    SeedConfiguration = cms.PSet(
        searchInTIDTEC = cms.bool(True),
        HighPtThreshold = cms.double(35.0),
        r2MinF = cms.double(-0.15),
        OrderedHitsFactoryPSet = cms.PSet(
            maxElement = cms.uint32(0),
            ComponentName = cms.string('StandardHitPairGenerator'),
            SeedingLayers = cms.string('hltESPMixedLayerPairs'),
            useOnDemandTracker = cms.untracked.int32(0)
        ),
        DeltaPhi1Low = cms.double(0.23),
        DeltaPhi1High = cms.double(0.08),
        ePhiMin1 = cms.double(-0.08),
        PhiMin2 = cms.double(-0.004),
        LowPtThreshold = cms.double(3.0),
        RegionPSet = cms.PSet(
            deltaPhiRegion = cms.double(0.4),
            originHalfLength = cms.double(15.0),
            useZInVertex = cms.bool(True),
            deltaEtaRegion = cms.double(0.1),
            ptMin = cms.double(1.5),
            originRadius = cms.double(0.2),
            VertexProducer = cms.InputTag("dummyVertices")
        ),
        maxHOverE = cms.double(999999.0),
        dynamicPhiRoad = cms.bool(False),
        ePhiMax1 = cms.double(0.04),
        DeltaPhi2 = cms.double(0.004),
        measurementTrackerName = cms.string('hltESPMeasurementTracker'),
        SizeWindowENeg = cms.double(0.675),
        nSigmasDeltaZ1 = cms.double(5.0),
        rMaxI = cms.double(0.2),
        rMinI = cms.double(-0.2),
        preFilteredSeeds = cms.bool(True),
        r2MaxF = cms.double(0.15),
        pPhiMin1 = cms.double(-0.04),
        initialSeeds = cms.InputTag("noSeedsHere"),
        pPhiMax1 = cms.double(0.08),
        hbheModule = cms.string('hbhereco'),
        SCEtCut = cms.double(3.0),
        z2MaxB = cms.double(0.09),
        fromTrackerSeeds = cms.bool(True),
        hcalRecHits = cms.InputTag("hltHbhereco"),
        z2MinB = cms.double(-0.09),
        hbheInstance = cms.string(''),
        PhiMax2 = cms.double(0.004),
        hOverEConeSize = cms.double(0.0),
        hOverEHBMinE = cms.double(999999.0),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        applyHOverECut = cms.bool(False),
        hOverEHFMinE = cms.double(999999.0)
    ),
    barrelSuperClusters = cms.InputTag("hltCorrectedHybridSuperClustersL1NonIsolated")
)


process.hltL1NonIsolatedPhotonEcalIsol = cms.EDProducer("EgammaHLTEcalRecIsolationProducer",
    useNumCrystals = cms.bool(True),
    etMinBarrel = cms.double(-9999.0),
    etMinEndcap = cms.double(0.1),
    tryBoth = cms.bool(True),
    eMinEndcap = cms.double(-9999.0),
    ecalEndcapRecHitCollection = cms.InputTag("EcalRecHitsEE"),
    intRadiusEndcap = cms.double(3.0),
    ecalEndcapRecHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    jurassicWidth = cms.double(3.0),
    ecalBarrelRecHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    extRadius = cms.double(0.3),
    useIsolEt = cms.bool(True),
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    ecalBarrelRecHitCollection = cms.InputTag("EcalRecHitsEB"),
    intRadiusBarrel = cms.double(3.0),
    subtract = cms.bool(False),
    eMinBarrel = cms.double(0.08)
)


process.hltL1NonIsolatedPhotonHcalForHE = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.14),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.0),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    doEtSum = cms.bool(False)
)


process.hltL1NonIsolatedPhotonHcalIsol = cms.EDProducer("EgammaHLTHcalIsolationProducersRegional",
    eMinHE = cms.double(0.8),
    hbheRecHitProducer = cms.InputTag("hltHbhereco"),
    outerCone = cms.double(0.29),
    eMinHB = cms.double(0.7),
    innerCone = cms.double(0.16),
    etMinHE = cms.double(-1.0),
    etMinHB = cms.double(-1.0),
    depth = cms.int32(-1),
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    doEtSum = cms.bool(True)
)


process.hltL1NonIsolatedPhotonHollowTrackIsol = cms.EDProducer("EgammaHLTPhotonTrackIsolationProducersRegional",
    egTrkIsoStripEndcap = cms.double(0.03),
    egTrkIsoConeSize = cms.double(0.29),
    trackProducer = cms.InputTag("hltL1NonIsoEgammaRegionalCTFFinalFitWithMaterial"),
    egTrkIsoStripBarrel = cms.double(0.03),
    countTracks = cms.bool(False),
    egTrkIsoRSpan = cms.double(999999.0),
    egTrkIsoVetoConeSize = cms.double(0.06),
    recoEcalCandidateProducer = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    egTrkIsoPtMin = cms.double(1.0),
    egTrkIsoZSpan = cms.double(999999.0)
)


process.hltL1extraParticles = cms.EDProducer("L1ExtraParticlesProd",
    tauJetSource = cms.InputTag("hltGctDigis","tauJets"),
    etHadSource = cms.InputTag("hltGctDigis"),
    etTotalSource = cms.InputTag("hltGctDigis"),
    nonIsolatedEmSource = cms.InputTag("hltGctDigis","nonIsoEm"),
    centralJetSource = cms.InputTag("hltGctDigis","cenJets"),
    etMissSource = cms.InputTag("hltGctDigis"),
    produceMuonParticles = cms.bool(True),
    hfRingEtSumsSource = cms.InputTag("hltGctDigis"),
    forwardJetSource = cms.InputTag("hltGctDigis","forJets"),
    ignoreHtMiss = cms.bool(False),
    htMissSource = cms.InputTag("hltGctDigis"),
    produceCaloParticles = cms.bool(True),
    muonSource = cms.InputTag("hltGtDigis"),
    isolatedEmSource = cms.InputTag("hltGctDigis","isoEm"),
    centralBxOnly = cms.bool(True),
    hfRingBitCountsSource = cms.InputTag("hltGctDigis")
)


process.hltL2MuonCandidates = cms.EDProducer("L2MuonCandidateProducer",
    InputObjects = cms.InputTag("hltL2Muons","UpdatedAtVtx")
)


process.hltL2MuonCandidatesNoVtx = cms.EDProducer("L2MuonCandidateProducer",
    InputObjects = cms.InputTag("hltL2Muons")
)


process.hltL2MuonIsolations = cms.EDProducer("L2MuonIsolationProducer",
    IsolatorPSet = cms.PSet(
        ConeSizes = cms.vdouble(0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24),
        ComponentName = cms.string('SimpleCutsIsolator'),
        Thresholds = cms.vdouble(4.0, 3.7, 4.0, 3.5, 3.4,
            3.4, 3.2, 3.4, 3.1, 2.9,
            2.9, 2.7, 3.1, 3.0, 2.4,
            2.1, 2.0, 2.3, 2.2, 2.4,
            2.5, 2.5, 2.6, 2.9, 3.1,
            2.9),
        EtaBounds = cms.vdouble(0.0435, 0.1305, 0.2175, 0.3045, 0.3915,
            0.4785, 0.5655, 0.6525, 0.7395, 0.8265,
            0.9135, 1.0005, 1.0875, 1.1745, 1.2615,
            1.3485, 1.4355, 1.5225, 1.6095, 1.6965,
            1.785, 1.88, 1.9865, 2.1075, 2.247,
            2.411)
    ),
    StandAloneCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    ExtractorPSet = cms.PSet(
        DR_Veto_H = cms.double(0.1),
        Vertex_Constraint_Z = cms.bool(False),
        Threshold_H = cms.double(0.5),
        ComponentName = cms.string('CaloExtractor'),
        Threshold_E = cms.double(0.2),
        DR_Max = cms.double(0.24),
        DR_Veto_E = cms.double(0.07),
        Weight_E = cms.double(1.5),
        Vertex_Constraint_XY = cms.bool(False),
        DepositLabel = cms.untracked.string('EcalPlusHcal'),
        CaloTowerCollectionLabel = cms.InputTag("hltTowerMakerForMuons"),
        Weight_H = cms.double(1.0)
    )
)


process.hltL2MuonSeeds = cms.EDProducer("L2MuonSeedGenerator",
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('SteppingHelixPropagatorAny'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    InputObjects = cms.InputTag("hltL1extraParticles"),
    L1MaxEta = cms.double(2.5),
    L1MinPt = cms.double(0.0),
    L1MinQuality = cms.uint32(1),
    GMTReadoutCollection = cms.InputTag("hltGtDigis"),
    Propagator = cms.string('SteppingHelixPropagatorAny')
)


process.hltL2Muons = cms.EDProducer("L2MuonProducer",
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPFastSteppingHelixPropagatorAny',
            'hltESPFastSteppingHelixPropagatorOpposite'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    L2TrajBuilderParameters = cms.PSet(
        DoRefit = cms.bool(False),
        SeedPropagator = cms.string('hltESPFastSteppingHelixPropagatorAny'),
        FilterParameters = cms.PSet(
            NumberOfSigma = cms.double(3.0),
            FitDirection = cms.string('insideOut'),
            DTRecSegmentLabel = cms.InputTag("hltDt4DSegments"),
            MaxChi2 = cms.double(1000.0),
            MuonTrajectoryUpdatorParameters = cms.PSet(
                MaxChi2 = cms.double(25.0),
                RescaleErrorFactor = cms.double(100.0),
                Granularity = cms.int32(0),
                ExcludeRPCFromFit = cms.bool(False),
                UseInvalidHits = cms.bool(True),
                RescaleError = cms.bool(False)
            ),
            EnableRPCMeasurement = cms.bool(True),
            CSCRecSegmentLabel = cms.InputTag("hltCscSegments"),
            EnableDTMeasurement = cms.bool(True),
            RPCRecSegmentLabel = cms.InputTag("hltRpcRecHits"),
            Propagator = cms.string('hltESPFastSteppingHelixPropagatorAny'),
            EnableCSCMeasurement = cms.bool(True)
        ),
        NavigationType = cms.string('Standard'),
        SeedTransformerParameters = cms.PSet(
            Fitter = cms.string('hltESPKFFittingSmootherForL2Muon'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            Propagator = cms.string('hltESPFastSteppingHelixPropagatorAny'),
            UseSubRecHits = cms.bool(False),
            NMinRecHits = cms.uint32(2),
            RescaleError = cms.double(100.0)
        ),
        DoBackwardFilter = cms.bool(True),
        SeedPosition = cms.string('in'),
        BWFilterParameters = cms.PSet(
            NumberOfSigma = cms.double(3.0),
            CSCRecSegmentLabel = cms.InputTag("hltCscSegments"),
            FitDirection = cms.string('outsideIn'),
            DTRecSegmentLabel = cms.InputTag("hltDt4DSegments"),
            MaxChi2 = cms.double(100.0),
            MuonTrajectoryUpdatorParameters = cms.PSet(
                MaxChi2 = cms.double(25.0),
                RescaleErrorFactor = cms.double(100.0),
                Granularity = cms.int32(2),
                ExcludeRPCFromFit = cms.bool(False),
                UseInvalidHits = cms.bool(True),
                RescaleError = cms.bool(False)
            ),
            EnableRPCMeasurement = cms.bool(True),
            BWSeedType = cms.string('fromGenerator'),
            EnableDTMeasurement = cms.bool(True),
            RPCRecSegmentLabel = cms.InputTag("hltRpcRecHits"),
            Propagator = cms.string('hltESPFastSteppingHelixPropagatorAny'),
            EnableCSCMeasurement = cms.bool(True)
        ),
        DoSeedRefit = cms.bool(False)
    ),
    InputObjects = cms.InputTag("hltL2MuonSeeds"),
    TrackLoaderParameters = cms.PSet(
        Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
        DoSmoothing = cms.bool(False),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        MuonUpdatorAtVertexParameters = cms.PSet(
            MaxChi2 = cms.double(1000000.0),
            BeamSpotPosition = cms.vdouble(0.0, 0.0, 0.0),
            Propagator = cms.string('hltESPFastSteppingHelixPropagatorOpposite'),
            BeamSpotPositionErrors = cms.vdouble(0.1, 0.1, 5.3)
        ),
        VertexConstraint = cms.bool(True)
    )
)


process.hltL2TauJets = cms.EDProducer("L2TauJetsMerger",
    EtMin = cms.double(20.0),
    JetSrc = cms.VInputTag("hltIconeTau1Regional", "hltIconeTau2Regional", "hltIconeTau3Regional", "hltIconeTau4Regional", "hltIconeCentral1Regional",
        "hltIconeCentral2Regional", "hltIconeCentral3Regional", "hltIconeCentral4Regional")
)


process.hltL3MuonCandidates = cms.EDProducer("L3MuonCandidateProducer",
    InputObjects = cms.InputTag("hltL3Muons")
)


process.hltL3MuonCandidatesNoVtx = cms.EDProducer("L3MuonCandidateProducer",
    InputObjects = cms.InputTag("hltL3MuonsNoVtx")
)


process.hltL3MuonIsolations = cms.EDProducer("L3MuonIsolationProducer",
    OutputMuIsoDeposits = cms.bool(True),
    CutsPSet = cms.PSet(
        ConeSizes = cms.vdouble(0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24, 0.24, 0.24, 0.24, 0.24,
            0.24),
        ComponentName = cms.string('SimpleCuts'),
        Thresholds = cms.vdouble(1.1, 1.1, 1.1, 1.1, 1.2,
            1.1, 1.2, 1.1, 1.2, 1.0,
            1.1, 1.0, 1.0, 1.1, 1.0,
            1.0, 1.1, 0.9, 1.1, 0.9,
            1.1, 1.0, 1.0, 0.9, 0.8,
            0.1),
        maxNTracks = cms.int32(-1),
        EtaBounds = cms.vdouble(0.0435, 0.1305, 0.2175, 0.3045, 0.3915,
            0.4785, 0.5655, 0.6525, 0.7395, 0.8265,
            0.9135, 1.0005, 1.0875, 1.1745, 1.2615,
            1.3485, 1.4355, 1.5225, 1.6095, 1.6965,
            1.785, 1.88, 1.9865, 2.1075, 2.247,
            2.411),
        applyCutsORmaxNTracks = cms.bool(False)
    ),
    TrackPt_Min = cms.double(-1.0),
    ExtractorPSet = cms.PSet(
        Chi2Prob_Min = cms.double(-1.0),
        Diff_z = cms.double(0.2),
        inputTrackCollection = cms.InputTag("hltPixelTracks"),
        ReferenceRadius = cms.double(6.0),
        BeamSpotLabel = cms.InputTag("hltOnlineBeamSpot"),
        ComponentName = cms.string('PixelTrackExtractor'),
        DR_Max = cms.double(0.24),
        Diff_r = cms.double(0.1),
        PropagateTracksToRadius = cms.bool(True),
        DR_VetoPt = cms.double(0.025),
        DR_Veto = cms.double(0.01),
        NHits_Min = cms.uint32(0),
        Chi2Ndof_Max = cms.double(1e+64),
        Pt_Min = cms.double(-1.0),
        DepositLabel = cms.untracked.string('PXLS'),
        BeamlineOption = cms.string('BeamSpotFromEvent'),
        VetoLeadingTrack = cms.bool(True),
        PtVeto_Min = cms.double(2.0)
    ),
    inputMuonCollection = cms.InputTag("hltL3Muons")
)


process.hltL3Muons = cms.EDProducer("L3TrackCombiner",
    labels = cms.VInputTag("hltL3MuonsOIState", "hltL3MuonsOIHit", "hltL3MuonsIOHit")
)


process.hltL3MuonsIOHit = cms.EDProducer("L3MuonProducer",
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPSmartPropagatorAny',
            'SteppingHelixPropagatorAny',
            'hltESPSmartPropagator',
            'hltESPSteppingHelixPropagatorOpposite'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TrackLoaderParameters = cms.PSet(
        PutTkTrackIntoEvent = cms.untracked.bool(True),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        SmoothTkTrack = cms.untracked.bool(False),
        MuonSeededTracksInstance = cms.untracked.string('L2Seeded'),
        Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
        MuonUpdatorAtVertexParameters = cms.PSet(
            MaxChi2 = cms.double(1000000.0),
            Propagator = cms.string('hltESPSteppingHelixPropagatorOpposite'),
            BeamSpotPositionErrors = cms.vdouble(0.1, 0.1, 5.3)
        ),
        VertexConstraint = cms.bool(False),
        DoSmoothing = cms.bool(True)
    ),
    L3TrajBuilderParameters = cms.PSet(
        ScaleTECyFactor = cms.double(-1.0),
        GlbRefitterParameters = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            TrackerSkipSection = cms.int32(-1),
            Chi2CutCSC = cms.double(150.0),
            HitThreshold = cms.int32(1),
            MuonHitsOption = cms.int32(1),
            Chi2CutRPC = cms.double(1.0),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            DTRecSegmentLabel = cms.InputTag("hltDt4DSegments"),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            CSCRecSegmentLabel = cms.InputTag("hltCscSegments"),
            PropDirForCosmics = cms.bool(False),
            Chi2CutDT = cms.double(10.0),
            RefitRPCHits = cms.bool(True),
            SkipStation = cms.int32(-1),
            Propagator = cms.string('hltESPSmartPropagatorAny'),
            TrackerSkipSystem = cms.int32(-1)
        ),
        ScaleTECxFactor = cms.double(-1.0),
        TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
        MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
        MuonTrackingRegionBuilder = cms.PSet(
            EtaR_UpperLimit_Par1 = cms.double(0.25),
            DeltaR = cms.double(0.2),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            OnDemand = cms.double(-1.0),
            vertexCollection = cms.InputTag("pixelVertices"),
            Rescale_phi = cms.double(3.0),
            Eta_fixed = cms.double(0.2),
            DeltaZ_Region = cms.double(15.9),
            Rescale_eta = cms.double(3.0),
            PhiR_UpperLimit_Par2 = cms.double(0.2),
            Eta_min = cms.double(0.05),
            Phi_fixed = cms.double(0.2),
            Phi_min = cms.double(0.05),
            EscapePt = cms.double(1.5),
            UseFixedRegion = cms.bool(False),
            PhiR_UpperLimit_Par1 = cms.double(0.6),
            EtaR_UpperLimit_Par2 = cms.double(0.15),
            MeasurementTrackerName = cms.string('hltESPMeasurementTracker'),
            UseVertex = cms.bool(False),
            Rescale_Dz = cms.double(3.0)
        ),
        RefitRPCHits = cms.bool(True),
        PCut = cms.double(2.5),
        TrackTransformer = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            RefitRPCHits = cms.bool(True),
            Propagator = cms.string('hltESPSmartPropagatorAny')
        ),
        GlobalMuonTrackMatcher = cms.PSet(
            Pt_threshold1 = cms.double(0.0),
            DeltaDCut_3 = cms.double(15.0),
            MinP = cms.double(2.5),
            MinPt = cms.double(1.0),
            Chi2Cut_1 = cms.double(50.0),
            Pt_threshold2 = cms.double(999999999.0),
            LocChi2Cut = cms.double(0.001),
            Eta_threshold = cms.double(1.2),
            Quality_3 = cms.double(7.0),
            Quality_2 = cms.double(15.0),
            Chi2Cut_2 = cms.double(50.0),
            Chi2Cut_3 = cms.double(200.0),
            DeltaDCut_1 = cms.double(40.0),
            DeltaRCut_2 = cms.double(0.2),
            DeltaRCut_3 = cms.double(1.0),
            DeltaDCut_2 = cms.double(10.0),
            DeltaRCut_1 = cms.double(0.1),
            Propagator = cms.string('hltESPSmartPropagator'),
            Quality_1 = cms.double(20.0)
        ),
        PtCut = cms.double(1.0),
        TrackerPropagator = cms.string('SteppingHelixPropagatorAny'),
        tkTrajLabel = cms.InputTag("hltL3TkTracksFromL2IOHit")
    )
)


process.hltL3MuonsLinksCombination = cms.EDProducer("L3TrackLinksCombiner",
    labels = cms.VInputTag("hltL3MuonsOIState", "hltL3MuonsOIHit", "hltL3MuonsIOHit")
)


process.hltL3MuonsNoVtx = cms.EDProducer("L3TkMuonProducer",
    InputObjects = cms.InputTag("hltL3TkTracksFromL2NoVtx")
)


process.hltL3MuonsOIHit = cms.EDProducer("L3MuonProducer",
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPSmartPropagatorAny',
            'SteppingHelixPropagatorAny',
            'hltESPSmartPropagator',
            'hltESPSteppingHelixPropagatorOpposite'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TrackLoaderParameters = cms.PSet(
        PutTkTrackIntoEvent = cms.untracked.bool(True),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        SmoothTkTrack = cms.untracked.bool(False),
        MuonSeededTracksInstance = cms.untracked.string('L2Seeded'),
        Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
        MuonUpdatorAtVertexParameters = cms.PSet(
            MaxChi2 = cms.double(1000000.0),
            Propagator = cms.string('hltESPSteppingHelixPropagatorOpposite'),
            BeamSpotPositionErrors = cms.vdouble(0.1, 0.1, 5.3)
        ),
        VertexConstraint = cms.bool(False),
        DoSmoothing = cms.bool(True)
    ),
    L3TrajBuilderParameters = cms.PSet(
        ScaleTECyFactor = cms.double(-1.0),
        GlbRefitterParameters = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            TrackerSkipSection = cms.int32(-1),
            Chi2CutCSC = cms.double(150.0),
            HitThreshold = cms.int32(1),
            MuonHitsOption = cms.int32(1),
            Chi2CutRPC = cms.double(1.0),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            DTRecSegmentLabel = cms.InputTag("hltDt4DSegments"),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            CSCRecSegmentLabel = cms.InputTag("hltCscSegments"),
            PropDirForCosmics = cms.bool(False),
            Chi2CutDT = cms.double(10.0),
            RefitRPCHits = cms.bool(True),
            SkipStation = cms.int32(-1),
            Propagator = cms.string('hltESPSmartPropagatorAny'),
            TrackerSkipSystem = cms.int32(-1)
        ),
        ScaleTECxFactor = cms.double(-1.0),
        TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
        MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
        MuonTrackingRegionBuilder = cms.PSet(
            EtaR_UpperLimit_Par1 = cms.double(0.25),
            DeltaR = cms.double(0.2),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            OnDemand = cms.double(-1.0),
            vertexCollection = cms.InputTag("pixelVertices"),
            Rescale_phi = cms.double(3.0),
            Eta_fixed = cms.double(0.2),
            DeltaZ_Region = cms.double(15.9),
            Rescale_eta = cms.double(3.0),
            PhiR_UpperLimit_Par2 = cms.double(0.2),
            Eta_min = cms.double(0.05),
            Phi_fixed = cms.double(0.2),
            Phi_min = cms.double(0.05),
            EscapePt = cms.double(1.5),
            UseFixedRegion = cms.bool(False),
            PhiR_UpperLimit_Par1 = cms.double(0.6),
            EtaR_UpperLimit_Par2 = cms.double(0.15),
            MeasurementTrackerName = cms.string('hltESPMeasurementTracker'),
            UseVertex = cms.bool(False),
            Rescale_Dz = cms.double(3.0)
        ),
        RefitRPCHits = cms.bool(True),
        PCut = cms.double(2.5),
        TrackTransformer = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            RefitRPCHits = cms.bool(True),
            Propagator = cms.string('hltESPSmartPropagatorAny')
        ),
        GlobalMuonTrackMatcher = cms.PSet(
            Pt_threshold1 = cms.double(0.0),
            DeltaDCut_3 = cms.double(15.0),
            MinP = cms.double(2.5),
            MinPt = cms.double(1.0),
            Chi2Cut_1 = cms.double(50.0),
            Pt_threshold2 = cms.double(999999999.0),
            LocChi2Cut = cms.double(0.001),
            Eta_threshold = cms.double(1.2),
            Quality_3 = cms.double(7.0),
            Quality_2 = cms.double(15.0),
            Chi2Cut_2 = cms.double(50.0),
            Chi2Cut_3 = cms.double(200.0),
            DeltaDCut_1 = cms.double(40.0),
            DeltaRCut_2 = cms.double(0.2),
            DeltaRCut_3 = cms.double(1.0),
            DeltaDCut_2 = cms.double(10.0),
            DeltaRCut_1 = cms.double(0.1),
            Propagator = cms.string('hltESPSmartPropagator'),
            Quality_1 = cms.double(20.0)
        ),
        PtCut = cms.double(1.0),
        TrackerPropagator = cms.string('SteppingHelixPropagatorAny'),
        tkTrajLabel = cms.InputTag("hltL3TkTracksFromL2OIHit")
    )
)


process.hltL3MuonsOIState = cms.EDProducer("L3MuonProducer",
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPSmartPropagatorAny',
            'SteppingHelixPropagatorAny',
            'hltESPSmartPropagator',
            'hltESPSteppingHelixPropagatorOpposite'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TrackLoaderParameters = cms.PSet(
        PutTkTrackIntoEvent = cms.untracked.bool(True),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        SmoothTkTrack = cms.untracked.bool(False),
        MuonSeededTracksInstance = cms.untracked.string('L2Seeded'),
        Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
        MuonUpdatorAtVertexParameters = cms.PSet(
            MaxChi2 = cms.double(1000000.0),
            Propagator = cms.string('hltESPSteppingHelixPropagatorOpposite'),
            BeamSpotPositionErrors = cms.vdouble(0.1, 0.1, 5.3)
        ),
        VertexConstraint = cms.bool(False),
        DoSmoothing = cms.bool(True)
    ),
    L3TrajBuilderParameters = cms.PSet(
        ScaleTECyFactor = cms.double(-1.0),
        GlbRefitterParameters = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            TrackerSkipSection = cms.int32(-1),
            Chi2CutCSC = cms.double(150.0),
            HitThreshold = cms.int32(1),
            MuonHitsOption = cms.int32(1),
            Chi2CutRPC = cms.double(1.0),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            DTRecSegmentLabel = cms.InputTag("hltDt4DSegments"),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            CSCRecSegmentLabel = cms.InputTag("hltCscSegments"),
            PropDirForCosmics = cms.bool(False),
            Chi2CutDT = cms.double(10.0),
            RefitRPCHits = cms.bool(True),
            SkipStation = cms.int32(-1),
            Propagator = cms.string('hltESPSmartPropagatorAny'),
            TrackerSkipSystem = cms.int32(-1)
        ),
        ScaleTECxFactor = cms.double(-1.0),
        TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
        MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
        MuonTrackingRegionBuilder = cms.PSet(
            EtaR_UpperLimit_Par1 = cms.double(0.25),
            DeltaR = cms.double(0.2),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            OnDemand = cms.double(-1.0),
            vertexCollection = cms.InputTag("pixelVertices"),
            Rescale_phi = cms.double(3.0),
            Eta_fixed = cms.double(0.2),
            DeltaZ_Region = cms.double(15.9),
            Rescale_eta = cms.double(3.0),
            PhiR_UpperLimit_Par2 = cms.double(0.2),
            Eta_min = cms.double(0.05),
            Phi_fixed = cms.double(0.2),
            Phi_min = cms.double(0.05),
            EscapePt = cms.double(1.5),
            UseFixedRegion = cms.bool(False),
            PhiR_UpperLimit_Par1 = cms.double(0.6),
            EtaR_UpperLimit_Par2 = cms.double(0.15),
            MeasurementTrackerName = cms.string('hltESPMeasurementTracker'),
            UseVertex = cms.bool(False),
            Rescale_Dz = cms.double(3.0)
        ),
        RefitRPCHits = cms.bool(True),
        PCut = cms.double(2.5),
        TrackTransformer = cms.PSet(
            DoPredictionsOnly = cms.bool(False),
            Fitter = cms.string('hltESPL3MuKFTrajectoryFitter'),
            TrackerRecHitBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
            Smoother = cms.string('hltESPKFTrajectorySmootherForMuonTrackLoader'),
            MuonRecHitBuilder = cms.string('hltESPMuonTransientTrackingRecHitBuilder'),
            RefitDirection = cms.string('insideOut'),
            RefitRPCHits = cms.bool(True),
            Propagator = cms.string('hltESPSmartPropagatorAny')
        ),
        GlobalMuonTrackMatcher = cms.PSet(
            Pt_threshold1 = cms.double(0.0),
            DeltaDCut_3 = cms.double(15.0),
            MinP = cms.double(2.5),
            MinPt = cms.double(1.0),
            Chi2Cut_1 = cms.double(50.0),
            Pt_threshold2 = cms.double(999999999.0),
            LocChi2Cut = cms.double(0.001),
            Eta_threshold = cms.double(1.2),
            Quality_3 = cms.double(7.0),
            Quality_2 = cms.double(15.0),
            Chi2Cut_2 = cms.double(50.0),
            Chi2Cut_3 = cms.double(200.0),
            DeltaDCut_1 = cms.double(40.0),
            DeltaRCut_2 = cms.double(0.2),
            DeltaRCut_3 = cms.double(1.0),
            DeltaDCut_2 = cms.double(10.0),
            DeltaRCut_1 = cms.double(0.1),
            Propagator = cms.string('hltESPSmartPropagator'),
            Quality_1 = cms.double(20.0)
        ),
        PtCut = cms.double(1.0),
        TrackerPropagator = cms.string('SteppingHelixPropagatorAny'),
        tkTrajLabel = cms.InputTag("hltL3TkTracksFromL2OIState")
    )
)


process.hltL3TkFromL2OICombination = cms.EDProducer("L3TrackCombiner",
    labels = cms.VInputTag("hltL3MuonsOIState", "hltL3MuonsOIHit")
)


process.hltL3TkTracksFromL2 = cms.EDProducer("L3TrackCombiner",
    labels = cms.VInputTag("hltL3TkTracksFromL2IOHit", "hltL3TkTracksFromL2OIHit", "hltL3TkTracksFromL2OIState")
)


process.hltL3TkTracksFromL2IOHit = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL3TrackCandidateFromL2IOHit"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string(''),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL3TkTracksFromL2NoVtx = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL3TrackCandidateFromL2NoVtx"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string(''),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(False),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL3TkTracksFromL2OIHit = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL3TrackCandidateFromL2OIHit"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string(''),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL3TkTracksFromL2OIState = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltL3TrackCandidateFromL2OIState"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string(''),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('PropagatorWithMaterial')
)


process.hltL3TrackCandidateFromL2 = cms.EDProducer("L3TrackCandCombiner",
    labels = cms.VInputTag("hltL3TrackCandidateFromL2IOHit", "hltL3TrackCandidateFromL2OIHit", "hltL3TrackCandidateFromL2OIState")
)


process.hltL3TrackCandidateFromL2IOHit = cms.EDProducer("CkfTrajectoryMaker",
    src = cms.InputTag("hltL3TrajSeedIOHit"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPMuonCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits'),
    trackCandidateAlso = cms.bool(True)
)


process.hltL3TrackCandidateFromL2NoVtx = cms.EDProducer("CkfTrajectoryMaker",
    src = cms.InputTag("hltL3TrajectorySeedNoVtx"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('CosmicNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPMuonCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits'),
    trackCandidateAlso = cms.bool(True)
)


process.hltL3TrackCandidateFromL2OIHit = cms.EDProducer("CkfTrajectoryMaker",
    src = cms.InputTag("hltL3TrajSeedOIHit"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPMuonCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits'),
    trackCandidateAlso = cms.bool(True)
)


process.hltL3TrackCandidateFromL2OIState = cms.EDProducer("CkfTrajectoryMaker",
    src = cms.InputTag("hltL3TrajSeedOIState"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPMuonCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits'),
    trackCandidateAlso = cms.bool(True)
)


process.hltL3TrajSeedIOHit = cms.EDProducer("TSGFromL2Muon",
    TkSeedGenerator = cms.PSet(
        ComponentName = cms.string('DualByL2TSG'),
        L3TkCollectionA = cms.InputTag("hltL3TkFromL2OICombination"),
        iterativeTSG = cms.PSet(
            firstTSG = cms.PSet(
                ComponentName = cms.string('TSGFromOrderedHits'),
                OrderedHitsFactoryPSet = cms.PSet(
                    ComponentName = cms.string('StandardHitTripletGenerator'),
                    SeedingLayers = cms.string('hltESPPixelLayerTriplets'),
                    GeneratorPSet = cms.PSet(
                        useBending = cms.bool(True),
                        useFixedPreFiltering = cms.bool(False),
                        maxElement = cms.uint32(10000),
                        phiPreFiltering = cms.double(0.3),
                        extraHitRPhitolerance = cms.double(0.06),
                        useMultScattering = cms.bool(True),
                        ComponentName = cms.string('PixelTripletHLTGenerator'),
                        extraHitRZtolerance = cms.double(0.06)
                    )
                ),
                TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
            ),
            PSetNames = cms.vstring('firstTSG',
                'secondTSG'),
            ComponentName = cms.string('CombinedTSG'),
            thirdTSG = cms.PSet(
                PSetNames = cms.vstring('endcapTSG',
                    'barrelTSG'),
                ComponentName = cms.string('DualByEtaTSG'),
                endcapTSG = cms.PSet(
                    ComponentName = cms.string('TSGFromOrderedHits'),
                    OrderedHitsFactoryPSet = cms.PSet(
                        maxElement = cms.uint32(0),
                        ComponentName = cms.string('StandardHitPairGenerator'),
                        SeedingLayers = cms.string('hltESPMixedLayerPairs'),
                        useOnDemandTracker = cms.untracked.int32(0)
                    ),
                    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
                ),
                etaSeparation = cms.double(2.0),
                barrelTSG = cms.PSet(

                )
            ),
            secondTSG = cms.PSet(
                ComponentName = cms.string('TSGFromOrderedHits'),
                OrderedHitsFactoryPSet = cms.PSet(
                    maxElement = cms.uint32(0),
                    ComponentName = cms.string('StandardHitPairGenerator'),
                    SeedingLayers = cms.string('hltESPPixelLayerPairs'),
                    useOnDemandTracker = cms.untracked.int32(0)
                ),
                TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
            )
        ),
        skipTSG = cms.PSet(

        ),
        PSetNames = cms.vstring('skipTSG',
            'iterativeTSG')
    ),
    TSGFromCombinedHits = cms.PSet(

    ),
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('PropagatorWithMaterial'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    TSGFromPropagation = cms.PSet(

    ),
    TSGFromPixelTriplets = cms.PSet(

    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TSGForRoadSearchOI = cms.PSet(

    ),
    MuonTrackingRegionBuilder = cms.PSet(
        EtaR_UpperLimit_Par1 = cms.double(0.25),
        DeltaR = cms.double(0.2),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        OnDemand = cms.double(-1.0),
        vertexCollection = cms.InputTag("pixelVertices"),
        Rescale_phi = cms.double(3.0),
        Eta_fixed = cms.double(0.2),
        DeltaZ_Region = cms.double(15.9),
        Rescale_eta = cms.double(3.0),
        PhiR_UpperLimit_Par2 = cms.double(0.2),
        Eta_min = cms.double(0.1),
        Phi_fixed = cms.double(0.2),
        Phi_min = cms.double(0.1),
        EscapePt = cms.double(1.5),
        UseFixedRegion = cms.bool(False),
        PhiR_UpperLimit_Par1 = cms.double(0.6),
        EtaR_UpperLimit_Par2 = cms.double(0.15),
        MeasurementTrackerName = cms.string('hltESPMeasurementTracker'),
        UseVertex = cms.bool(False),
        Rescale_Dz = cms.double(3.0)
    ),
    TSGFromMixedPairs = cms.PSet(

    ),
    PCut = cms.double(2.5),
    TrackerSeedCleaner = cms.PSet(
        cleanerFromSharedHits = cms.bool(True),
        ptCleaner = cms.bool(True),
        TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        directionCleaner = cms.bool(True)
    ),
    PtCut = cms.double(1.0),
    TSGForRoadSearchIOpxl = cms.PSet(

    ),
    TSGFromPixelPairs = cms.PSet(

    )
)


process.hltL3TrajSeedOIHit = cms.EDProducer("TSGFromL2Muon",
    TkSeedGenerator = cms.PSet(
        ComponentName = cms.string('DualByL2TSG'),
        L3TkCollectionA = cms.InputTag("hltL3MuonsOIState"),
        iterativeTSG = cms.PSet(
            ErrorRescaling = cms.double(3.0),
            beamSpot = cms.InputTag("offlineBeamSpot"),
            ComponentName = cms.string('TSGFromPropagation'),
            errorMatrixPset = cms.PSet(
                action = cms.string('use'),
                atIP = cms.bool(True),
                errorMatrixValuesPSet = cms.PSet(
                    pf3_V12 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V13 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V11 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                            5.0, 10.0, 7.0, 10.0, 10.0,
                            10.0, 10.0)
                    ),
                    pf3_V14 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    yAxis = cms.vdouble(0.0, 1.0, 1.4, 10.0),
                    pf3_V34 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V15 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V35 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V45 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V44 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                            5.0, 10.0, 7.0, 10.0, 10.0,
                            10.0, 10.0)
                    ),
                    xAxis = cms.vdouble(0.0, 13.0, 30.0, 70.0, 1000.0),
                    pf3_V23 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V22 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                            5.0, 10.0, 7.0, 10.0, 10.0,
                            10.0, 10.0)
                    ),
                    pf3_V55 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                            5.0, 10.0, 7.0, 10.0, 10.0,
                            10.0, 10.0)
                    ),
                    zAxis = cms.vdouble(-3.14159, 3.14159),
                    pf3_V33 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                            5.0, 10.0, 7.0, 10.0, 10.0,
                            10.0, 10.0)
                    ),
                    pf3_V25 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    ),
                    pf3_V24 = cms.PSet(
                        action = cms.string('scale'),
                        values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0, 1.0, 1.0, 1.0,
                            1.0, 1.0)
                    )
                )
            ),
            UpdateState = cms.bool(True),
            MeasurementTrackerName = cms.string('hltESPMeasurementTracker'),
            SelectState = cms.bool(False),
            SigmaZ = cms.double(25.0),
            ResetMethod = cms.string('matrix'),
            MaxChi2 = cms.double(40.0),
            UseVertexState = cms.bool(True),
            Propagator = cms.string('hltESPSmartPropagatorAnyOpposite')
        ),
        skipTSG = cms.PSet(

        ),
        PSetNames = cms.vstring('skipTSG',
            'iterativeTSG')
    ),
    TSGFromCombinedHits = cms.PSet(

    ),
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('PropagatorWithMaterial',
            'hltESPSmartPropagatorAnyOpposite'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    TSGFromPropagation = cms.PSet(

    ),
    TSGFromPixelTriplets = cms.PSet(

    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TSGForRoadSearchOI = cms.PSet(

    ),
    MuonTrackingRegionBuilder = cms.PSet(

    ),
    TSGFromMixedPairs = cms.PSet(

    ),
    PCut = cms.double(2.5),
    TrackerSeedCleaner = cms.PSet(
        cleanerFromSharedHits = cms.bool(True),
        ptCleaner = cms.bool(True),
        TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
        beamSpot = cms.InputTag("hltOnlineBeamSpot"),
        directionCleaner = cms.bool(True)
    ),
    PtCut = cms.double(1.0),
    TSGForRoadSearchIOpxl = cms.PSet(

    ),
    TSGFromPixelPairs = cms.PSet(

    )
)


process.hltL3TrajSeedOIState = cms.EDProducer("TSGFromL2Muon",
    TkSeedGenerator = cms.PSet(
        propagatorCompatibleName = cms.string('hltESPSteppingHelixPropagatorOpposite'),
        option = cms.uint32(3),
        ComponentName = cms.string('TSGForRoadSearch'),
        errorMatrixPset = cms.PSet(
            action = cms.string('use'),
            atIP = cms.bool(True),
            errorMatrixValuesPSet = cms.PSet(
                pf3_V12 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V13 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V11 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V14 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                yAxis = cms.vdouble(0.0, 1.0, 1.4, 10.0),
                pf3_V34 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V15 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V35 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V45 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V44 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                xAxis = cms.vdouble(0.0, 13.0, 30.0, 70.0, 1000.0),
                pf3_V23 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V22 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V55 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                zAxis = cms.vdouble(-3.14159, 3.14159),
                pf3_V33 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V25 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V24 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                )
            )
        ),
        propagatorName = cms.string('hltESPSteppingHelixPropagatorAlong'),
        manySeeds = cms.bool(False),
        copyMuonRecHit = cms.bool(False),
        maxChi2 = cms.double(40.0)
    ),
    TSGFromCombinedHits = cms.PSet(

    ),
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPSteppingHelixPropagatorOpposite',
            'hltESPSteppingHelixPropagatorAlong'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    TSGFromPropagation = cms.PSet(

    ),
    TSGFromPixelTriplets = cms.PSet(

    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons","UpdatedAtVtx"),
    TSGForRoadSearchOI = cms.PSet(

    ),
    MuonTrackingRegionBuilder = cms.PSet(

    ),
    TSGFromMixedPairs = cms.PSet(

    ),
    PCut = cms.double(2.5),
    TrackerSeedCleaner = cms.PSet(

    ),
    PtCut = cms.double(1.0),
    TSGForRoadSearchIOpxl = cms.PSet(

    ),
    TSGFromPixelPairs = cms.PSet(

    )
)


process.hltL3TrajectorySeed = cms.EDProducer("L3MuonTrajectorySeedCombiner",
    labels = cms.VInputTag("hltL3TrajSeedIOHit", "hltL3TrajSeedOIState", "hltL3TrajSeedOIHit")
)


process.hltL3TrajectorySeedNoVtx = cms.EDProducer("TSGFromL2Muon",
    TkSeedGenerator = cms.PSet(
        propagatorCompatibleName = cms.string('hltESPSteppingHelixPropagatorOpposite'),
        option = cms.uint32(3),
        ComponentName = cms.string('TSGForRoadSearch'),
        errorMatrixPset = cms.PSet(
            action = cms.string('use'),
            atIP = cms.bool(True),
            errorMatrixValuesPSet = cms.PSet(
                pf3_V12 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V13 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V11 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V14 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V15 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V34 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                yAxis = cms.vdouble(0.0, 1.0, 1.4, 10.0),
                pf3_V35 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V45 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V44 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                xAxis = cms.vdouble(0.0, 13.0, 30.0, 70.0, 1000.0),
                pf3_V23 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V22 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V55 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                zAxis = cms.vdouble(-3.14159, 3.14159),
                pf3_V33 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(3.0, 3.0, 3.0, 5.0, 4.0,
                        5.0, 10.0, 7.0, 10.0, 10.0,
                        10.0, 10.0)
                ),
                pf3_V25 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                ),
                pf3_V24 = cms.PSet(
                    action = cms.string('scale'),
                    values = cms.vdouble(1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0, 1.0, 1.0, 1.0,
                        1.0, 1.0)
                )
            )
        ),
        propagatorName = cms.string('hltESPSteppingHelixPropagatorAlong'),
        manySeeds = cms.bool(False),
        copyMuonRecHit = cms.bool(False),
        maxChi2 = cms.double(40.0)
    ),
    TSGFromCombinedHits = cms.PSet(

    ),
    ServiceParameters = cms.PSet(
        Propagators = cms.untracked.vstring('hltESPSteppingHelixPropagatorOpposite',
            'hltESPSteppingHelixPropagatorAlong'),
        RPCLayers = cms.bool(True),
        UseMuonNavigation = cms.untracked.bool(True)
    ),
    TSGFromPropagation = cms.PSet(

    ),
    TSGFromPixelTriplets = cms.PSet(

    ),
    MuonCollectionLabel = cms.InputTag("hltL2Muons"),
    TSGForRoadSearchOI = cms.PSet(

    ),
    MuonTrackingRegionBuilder = cms.PSet(

    ),
    TSGFromMixedPairs = cms.PSet(

    ),
    PCut = cms.double(2.5),
    TrackerSeedCleaner = cms.PSet(

    ),
    PtCut = cms.double(1.0),
    TSGForRoadSearchIOpxl = cms.PSet(

    ),
    TSGFromPixelPairs = cms.PSet(

    )
)


process.hltLightPFTracks = cms.EDProducer("LightPFTrackProducer",
    TrackQuality = cms.string('none'),
    UseQuality = cms.bool(False),
    TkColList = cms.VInputTag("hltPFlowTrackSelectionHighPurity")
)


process.hltMet = cms.EDProducer("METProducer",
    HB_EtResPar = cms.vdouble(0.0, 1.22, 0.05),
    EE_EtResPar = cms.vdouble(0.2, 0.03, 0.005),
    HF_PhiResPar = cms.vdouble(0.05022),
    HE_PhiResPar = cms.vdouble(0.02511),
    HB_PhiResPar = cms.vdouble(0.02511),
    onlyFiducialParticles = cms.bool(False),
    noHF = cms.bool(True),
    HF_EtResPar = cms.vdouble(0.0, 1.82, 0.09),
    InputType = cms.string('CandidateCollection'),
    METType = cms.string('CaloMET'),
    correctShowerTracks = cms.bool(False),
    EB_EtResPar = cms.vdouble(0.2, 0.03, 0.005),
    rf_type = cms.int32(0),
    jets = cms.InputTag("unused"),
    EB_PhiResPar = cms.vdouble(0.00502),
    src = cms.InputTag("hltTowerMakerForAll"),
    HO_PhiResPar = cms.vdouble(0.02511),
    calculateSignificance = cms.bool(False),
    EE_PhiResPar = cms.vdouble(0.02511),
    HO_EtResPar = cms.vdouble(0.0, 1.3, 0.005),
    alias = cms.string('RawCaloMET'),
    globalThreshold = cms.double(0.3),
    HE_EtResPar = cms.vdouble(0.0, 1.3, 0.05)
)


process.hltMuTkMuJpsiTrackerMuonCands = cms.EDProducer("L3MuonCandidateProducerFromMuons",
    InputObjects = cms.InputTag("hltMuTkMuJpsiTrackerMuons")
)


process.hltMuTkMuJpsiTrackerMuons = cms.EDProducer("MuonIdProducer",
    TrackExtractorPSet = cms.PSet(

    ),
    maxAbsEta = cms.double(999.0),
    arbitrationCleanerOptions = cms.PSet(
        ME1a = cms.bool(True),
        Clustering = cms.bool(True),
        ClusterDPhi = cms.double(0.6),
        OverlapDTheta = cms.double(0.02),
        Overlap = cms.bool(True),
        OverlapDPhi = cms.double(0.0786),
        ClusterDTheta = cms.double(0.02)
    ),
    globalTrackQualityInputTag = cms.InputTag("glbTrackQual"),
    addExtraSoftMuons = cms.bool(False),
    debugWithTruthMatching = cms.bool(False),
    CaloExtractorPSet = cms.PSet(

    ),
    runArbitrationCleaner = cms.bool(False),
    fillEnergy = cms.bool(False),
    TimingFillerParameters = cms.PSet(
        DTTimingParameters = cms.PSet(
            HitError = cms.double(6.0),
            DoWireCorr = cms.bool(False),
            MatchParameters = cms.PSet(
                DTsegments = cms.InputTag("hltDthlt4DSegments"),
                CSCsegments = cms.InputTag("hltCscSegments"),
                DTradius = cms.double(0.01),
                TightMatchDT = cms.bool(False),
                TightMatchCSC = cms.bool(True)
            ),
            DTsegments = cms.InputTag("hltDthlt4DSegments"),
            debug = cms.bool(False),
            UseSegmentT0 = cms.bool(False),
            HitsMin = cms.int32(3),
            DTTimeOffset = cms.double(2.7),
            DropTheta = cms.bool(True),
            RequireBothProjections = cms.bool(False),
            ServiceParameters = cms.PSet(
                Propagators = cms.untracked.vstring('SteppingHelixPropagatorAny',
                    'PropagatorWithMaterial',
                    'PropagatorWithMaterialOpposite'),
                RPCLayers = cms.bool(True)
            ),
            PruneCut = cms.double(1000.0)
        ),
        ErrorDT = cms.double(3.1),
        EcalEnergyCut = cms.double(0.4),
        ErrorEB = cms.double(2.085),
        ErrorCSC = cms.double(7.0),
        CSCTimingParameters = cms.PSet(
            CSCsegments = cms.InputTag("hltCscSegments"),
            CSCStripError = cms.double(7.0),
            CSCTimeOffset = cms.double(213.0),
            MatchParameters = cms.PSet(
                DTsegments = cms.InputTag("hltDthlt4DSegments"),
                CSCsegments = cms.InputTag("hltCscSegments"),
                DTradius = cms.double(0.01),
                TightMatchDT = cms.bool(False),
                TightMatchCSC = cms.bool(True)
            ),
            debug = cms.bool(False),
            UseStripTime = cms.bool(True),
            CSCStripTimeOffset = cms.double(0.0),
            CSCWireError = cms.double(8.6),
            CSCWireTimeOffset = cms.double(0.0),
            ServiceParameters = cms.PSet(
                Propagators = cms.untracked.vstring('SteppingHelixPropagatorAny',
                    'PropagatorWithMaterial',
                    'PropagatorWithMaterialOpposite'),
                RPCLayers = cms.bool(True)
            ),
            PruneCut = cms.double(100.0),
            UseWireTime = cms.bool(True)
        ),
        UseDT = cms.bool(True),
        ErrorEE = cms.double(6.95),
        UseCSC = cms.bool(True),
        UseECAL = cms.bool(False)
    ),
    inputCollectionTypes = cms.vstring('inner tracks'),
    minCaloCompatibility = cms.double(0.6),
    ecalDepositName = cms.string('ecal'),
    minP = cms.double(2.7),
    fillIsolation = cms.bool(False),
    jetDepositName = cms.string('jets'),
    ptThresholdToFillCandidateP4WithGlobalFit = cms.double(200.0),
    writeIsoDeposits = cms.bool(False),
    maxAbsPullX = cms.double(3.0),
    maxAbsPullY = cms.double(3.0),
    minPt = cms.double(0.0),
    TrackAssociatorParameters = cms.PSet(
        muonMaxDistanceSigmaX = cms.double(0.0),
        muonMaxDistanceSigmaY = cms.double(0.0),
        CSCSegmentCollectionLabel = cms.InputTag("hltCscSegments"),
        dRHcal = cms.double(9999.0),
        dREcal = cms.double(9999.0),
        CaloTowerCollectionLabel = cms.InputTag("towerMaker"),
        useEcal = cms.bool(False),
        dRPreshowerPreselection = cms.double(0.2),
        dREcalPreselection = cms.double(0.05),
        HORecHitCollectionLabel = cms.InputTag("hltHoreco"),
        dRMuon = cms.double(9999.0),
        propagateAllDirections = cms.bool(True),
        muonMaxDistanceX = cms.double(5.0),
        muonMaxDistanceY = cms.double(5.0),
        useHO = cms.bool(False),
        trajectoryUncertaintyTolerance = cms.double(-1.0),
        usePreshower = cms.bool(False),
        DTRecSegment4DCollectionLabel = cms.InputTag("hltDt4DSegments"),
        EERecHitCollectionLabel = cms.InputTag("ecalRecHit","EcalRecHitsEE"),
        dRHcalPreselection = cms.double(0.2),
        useMuon = cms.bool(True),
        useCalo = cms.bool(False),
        accountForTrajectoryChangeCalo = cms.bool(False),
        EBRecHitCollectionLabel = cms.InputTag("ecalRecHit","EcalRecHitsEB"),
        dRMuonPreselection = cms.double(0.2),
        truthMatch = cms.bool(False),
        HBHERecHitCollectionLabel = cms.InputTag("hbhereco"),
        useHcal = cms.bool(False)
    ),
    JetExtractorPSet = cms.PSet(

    ),
    trackDepositName = cms.string('tracker'),
    minPCaloMuon = cms.double(1.0),
    maxAbsDy = cms.double(3.0),
    fillCaloCompatibility = cms.bool(False),
    fillMatching = cms.bool(True),
    MuonCaloCompatibility = cms.PSet(

    ),
    hcalDepositName = cms.string('hcal'),
    sigmaThresholdToFillCandidateP4WithGlobalFit = cms.double(2.0),
    inputCollectionLabels = cms.VInputTag("hltMuTrackJpsiCtfTracks"),
    fillGlobalTrackQuality = cms.bool(False),
    maxAbsDx = cms.double(3.0),
    hoDepositName = cms.string('ho'),
    minNumberOfMatches = cms.int32(1)
)


process.hltMuTrackJpsiCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltMuTrackJpsiTrackSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPMuTrackJpsiTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltMuTrackJpsiCtfTrackCands = cms.EDProducer("ConcreteChargedCandidateProducer",
    src = cms.InputTag("hltMuTrackJpsiCtfTracks"),
    particleType = cms.string('mu-')
)


process.hltMuTrackJpsiCtfTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltMuTrackJpsiCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltMuTrackJpsiCtfTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltMuTrackJpsiPixelTrackCands = cms.EDProducer("ConcreteChargedCandidateProducer",
    src = cms.InputTag("hltMuTrackJpsiPixelTrackSelector"),
    particleType = cms.string('mu-')
)


process.hltMuTrackJpsiPixelTrackSelector = cms.EDProducer("QuarkoniaTrackSelector",
    MinTrackPt = cms.double(0.0),
    muonCandidates = cms.InputTag("hltL3MuonCandidates"),
    MaxTrackEta = cms.double(999.0),
    tracks = cms.InputTag("hltPixelTracks"),
    MaxMasses = cms.vdouble(4.6),
    checkCharge = cms.bool(False),
    MinMasses = cms.vdouble(2.0),
    MinTrackP = cms.double(2.5)
)


process.hltMuTrackJpsiTrackSeeds = cms.EDProducer("SeedGeneratorFromProtoTracksEDProducer",
    InputCollection = cms.InputTag("hltMuTrackJpsiPixelTrackSelector"),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    useProtoTrackKinematics = cms.bool(False)
)


process.hltMulti5x5BasicClustersActivity = cms.EDProducer("Multi5x5ClusterProducer",
    endcapHitCollection = cms.string('EcalRecHitsEE'),
    barrelClusterCollection = cms.string('multi5x5BarrelBasicClusters'),
    IslandEndcapSeedThr = cms.double(0.18),
    doEndcap = cms.bool(True),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    ),
    RecHitFlagToBeExcluded = cms.vint32(),
    endcapHitProducer = cms.string('hltEcalRecHitAll'),
    VerbosityLevel = cms.string('ERROR'),
    barrelHitProducer = cms.string('hltEcalRecHitAll'),
    IslandBarrelSeedThr = cms.double(0.5),
    barrelHitCollection = cms.string('EcalRecHitsEB'),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    doBarrel = cms.bool(False)
)


process.hltMulti5x5BasicClustersL1Isolated = cms.EDProducer("EgammaHLTMulti5x5ClusterProducer",
    l1LowerThr = cms.double(5.0),
    Multi5x5BarrelSeedThr = cms.double(0.5),
    Multi5x5EndcapSeedThr = cms.double(0.18),
    endcapHitCollection = cms.string('EcalRecHitsEE'),
    VerbosityLevel = cms.string('ERROR'),
    barrelClusterCollection = cms.string('notused'),
    doEndcaps = cms.bool(True),
    regionEtaMargin = cms.double(0.3),
    regionPhiMargin = cms.double(0.4),
    RecHitFlagToBeExcluded = cms.vint32(),
    l1TagNonIsolated = cms.InputTag("hltL1extraParticles","NonIsolated"),
    endcapHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    l1UpperThr = cms.double(999.0),
    doIsolated = cms.bool(True),
    barrelHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    l1LowerThrIgnoreIsolation = cms.double(999.0),
    l1TagIsolated = cms.InputTag("hltL1extraParticles","Isolated"),
    barrelHitCollection = cms.string('EcalRecHitsEB'),
    doBarrel = cms.bool(False),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    )
)


process.hltMulti5x5BasicClustersL1NonIsolated = cms.EDProducer("EgammaHLTMulti5x5ClusterProducer",
    l1LowerThr = cms.double(5.0),
    Multi5x5BarrelSeedThr = cms.double(0.5),
    Multi5x5EndcapSeedThr = cms.double(0.18),
    endcapHitCollection = cms.string('EcalRecHitsEE'),
    VerbosityLevel = cms.string('ERROR'),
    barrelClusterCollection = cms.string('notused'),
    doEndcaps = cms.bool(True),
    regionEtaMargin = cms.double(0.3),
    regionPhiMargin = cms.double(0.4),
    RecHitFlagToBeExcluded = cms.vint32(),
    l1TagNonIsolated = cms.InputTag("hltL1extraParticles","NonIsolated"),
    endcapHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    l1UpperThr = cms.double(999.0),
    doIsolated = cms.bool(False),
    barrelHitProducer = cms.InputTag("hltEcalRegionalEgammaRecHit"),
    l1LowerThrIgnoreIsolation = cms.double(999.0),
    l1TagIsolated = cms.InputTag("hltL1extraParticles","Isolated"),
    barrelHitCollection = cms.string('EcalRecHitsEB'),
    doBarrel = cms.bool(False),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    )
)


process.hltMulti5x5EndcapSuperClustersWithPreshowerL1Isolated = cms.EDProducer("PreshowerClusterProducer",
    assocSClusterCollection = cms.string(''),
    preshStripEnergyCut = cms.double(0.0),
    preshClusterCollectionY = cms.string('preshowerYClusters'),
    preshClusterCollectionX = cms.string('preshowerXClusters'),
    etThresh = cms.double(5.0),
    preshRecHitProducer = cms.InputTag("hltESRegionalEgammaRecHit","EcalRecHitsES"),
    endcapSClusterProducer = cms.InputTag("hltMulti5x5SuperClustersL1Isolated","multi5x5EndcapSuperClusters"),
    preshNclust = cms.int32(4),
    debugLevel = cms.string(''),
    preshClusterEnergyCut = cms.double(0.0),
    preshSeededNstrip = cms.int32(15)
)


process.hltMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated = cms.EDProducer("PreshowerClusterProducer",
    assocSClusterCollection = cms.string(''),
    preshStripEnergyCut = cms.double(0.0),
    preshClusterCollectionY = cms.string('preshowerYClusters'),
    preshClusterCollectionX = cms.string('preshowerXClusters'),
    etThresh = cms.double(5.0),
    preshRecHitProducer = cms.InputTag("hltESRegionalEgammaRecHit","EcalRecHitsES"),
    endcapSClusterProducer = cms.InputTag("hltMulti5x5SuperClustersL1NonIsolated","multi5x5EndcapSuperClusters"),
    preshNclust = cms.int32(4),
    debugLevel = cms.string(''),
    preshClusterEnergyCut = cms.double(0.0),
    preshSeededNstrip = cms.int32(15)
)


process.hltMulti5x5SuperClustersActivity = cms.EDProducer("Multi5x5SuperClusterProducer",
    barrelSuperclusterCollection = cms.string('multi5x5BarrelSuperClusters'),
    endcapEtaSearchRoad = cms.double(0.14),
    barrelClusterCollection = cms.string('multi5x5BarrelBasicClusters'),
    barrelPhiSearchRoad = cms.double(0.8),
    endcapClusterProducer = cms.string('hltMulti5x5BasicClustersActivity'),
    dynamicPhiRoad = cms.bool(False),
    endcapPhiSearchRoad = cms.double(0.6),
    VerbosityLevel = cms.string('ERROR'),
    seedTransverseEnergyThreshold = cms.double(1.0),
    barrelClusterProducer = cms.string('hltMulti5x5BasicClustersActivity'),
    endcapSuperclusterCollection = cms.string('multi5x5EndcapSuperClusters'),
    barrelEtaSearchRoad = cms.double(0.06),
    doBarrel = cms.bool(False),
    doEndcaps = cms.bool(True),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    bremRecoveryPset = cms.PSet(
        barrel = cms.PSet(
            cryVec = cms.vint32(16, 13, 11, 10, 9,
                8, 7, 6, 5, 4,
                3),
            cryMin = cms.int32(2),
            etVec = cms.vdouble(5.0, 10.0, 15.0, 20.0, 30.0,
                40.0, 45.0, 55.0, 135.0, 195.0,
                225.0)
        ),
        endcap = cms.PSet(
            a = cms.double(47.85),
            c = cms.double(0.1201),
            b = cms.double(108.8)
        )
    )
)


process.hltMulti5x5SuperClustersL1Isolated = cms.EDProducer("Multi5x5SuperClusterProducer",
    barrelSuperclusterCollection = cms.string('multi5x5BarrelSuperClusters'),
    endcapEtaSearchRoad = cms.double(0.14),
    barrelClusterCollection = cms.string('multi5x5BarrelBasicClusters'),
    barrelPhiSearchRoad = cms.double(0.8),
    endcapClusterProducer = cms.string('hltMulti5x5BasicClustersL1Isolated'),
    dynamicPhiRoad = cms.bool(False),
    endcapPhiSearchRoad = cms.double(0.6),
    VerbosityLevel = cms.string('ERROR'),
    seedTransverseEnergyThreshold = cms.double(1.0),
    barrelClusterProducer = cms.string('notused'),
    endcapSuperclusterCollection = cms.string('multi5x5EndcapSuperClusters'),
    barrelEtaSearchRoad = cms.double(0.06),
    doBarrel = cms.bool(False),
    doEndcaps = cms.bool(True),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    bremRecoveryPset = cms.PSet(
        barrel = cms.PSet(

        ),
        endcap = cms.PSet(
            a = cms.double(47.85),
            c = cms.double(0.1201),
            b = cms.double(108.8)
        ),
        doEndcaps = cms.bool(True),
        doBarrel = cms.bool(False)
    )
)


process.hltMulti5x5SuperClustersL1NonIsolated = cms.EDProducer("Multi5x5SuperClusterProducer",
    barrelSuperclusterCollection = cms.string('multi5x5BarrelSuperClusters'),
    endcapEtaSearchRoad = cms.double(0.14),
    barrelClusterCollection = cms.string('multi5x5BarrelBasicClusters'),
    barrelPhiSearchRoad = cms.double(0.8),
    endcapClusterProducer = cms.string('hltMulti5x5BasicClustersL1NonIsolated'),
    dynamicPhiRoad = cms.bool(False),
    endcapPhiSearchRoad = cms.double(0.6),
    VerbosityLevel = cms.string('ERROR'),
    seedTransverseEnergyThreshold = cms.double(1.0),
    barrelClusterProducer = cms.string('notused'),
    endcapSuperclusterCollection = cms.string('multi5x5EndcapSuperClusters'),
    barrelEtaSearchRoad = cms.double(0.06),
    doBarrel = cms.bool(False),
    doEndcaps = cms.bool(True),
    endcapClusterCollection = cms.string('multi5x5EndcapBasicClusters'),
    bremRecoveryPset = cms.PSet(
        barrel = cms.PSet(

        ),
        endcap = cms.PSet(
            a = cms.double(47.85),
            c = cms.double(0.1201),
            b = cms.double(108.8)
        ),
        doEndcaps = cms.bool(True),
        doBarrel = cms.bool(False)
    )
)


process.hltMulti5x5SuperClustersWithPreshowerActivity = cms.EDProducer("PreshowerClusterProducer",
    assocSClusterCollection = cms.string(''),
    preshStripEnergyCut = cms.double(0.0),
    preshClusterCollectionY = cms.string('preshowerYClusters'),
    preshClusterCollectionX = cms.string('preshowerXClusters'),
    etThresh = cms.double(0.0),
    preshRecHitProducer = cms.InputTag("hltESRecHitAll","EcalRecHitsES"),
    endcapSClusterProducer = cms.InputTag("hltMulti5x5SuperClustersActivity","multi5x5EndcapSuperClusters"),
    preshNclust = cms.int32(4),
    debugLevel = cms.string('ERROR'),
    preshClusterEnergyCut = cms.double(0.0),
    preshSeededNstrip = cms.int32(15)
)


process.hltMuonCSCDigis = cms.EDProducer("CSCDCCUnpacker",
    PrintEventNumber = cms.untracked.bool(False),
    UseExaminer = cms.bool(True),
    ErrorMask = cms.uint32(0),
    InputObjects = cms.InputTag("rawDataCollector"),
    ExaminerMask = cms.uint32(535557110),
    UseFormatStatus = cms.bool(True),
    UnpackStatusDigis = cms.bool(False),
    UseSelectiveUnpacking = cms.bool(True)
)


process.hltMuonDTDigis = cms.EDProducer("DTUnpackingModule",
    useStandardFEDid = cms.bool(True),
    inputLabel = cms.InputTag("rawDataCollector"),
    dataType = cms.string('DDU'),
    fedbyType = cms.bool(False),
    readOutParameters = cms.PSet(
        debug = cms.untracked.bool(False),
        rosParameters = cms.PSet(
            writeSC = cms.untracked.bool(True),
            readingDDU = cms.untracked.bool(True),
            performDataIntegrityMonitor = cms.untracked.bool(False),
            readDDUIDfromDDU = cms.untracked.bool(True),
            debug = cms.untracked.bool(False),
            localDAQ = cms.untracked.bool(False)
        ),
        performDataIntegrityMonitor = cms.untracked.bool(False),
        localDAQ = cms.untracked.bool(False)
    ),
    rosParameters = cms.PSet(

    ),
    dqmOnly = cms.bool(False)
)


process.hltMuonRPCDigis = cms.EDProducer("RPCUnpackingModule",
    InputLabel = cms.InputTag("rawDataCollector"),
    doSynchro = cms.bool(False)
)


process.hltOfflineBeamSpot = cms.EDProducer("BeamSpotProducer")


process.hltOnlineBeamSpot = cms.EDProducer("BeamSpotOnlineProducer",
    maxZ = cms.double(40.0),
    gtEvmLabel = cms.InputTag(""),
    changeToCMSCoordinates = cms.bool(False),
    label = cms.InputTag("hltScalersRawToDigi"),
    setSigmaZ = cms.double(10.0),
    maxRadius = cms.double(2.0)
)


process.hltPFJetCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltPFJetPixelSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(100000),
    NavigationSchool = cms.string('SimpleNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPTrajectoryBuilderL3'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltPFJetCtfWithMaterialTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltPFJetCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPFittingSmootherRK'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('ctfWithMaterialTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('ctf'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltPFJetPixelSeeds = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(50000),
        doClusterCheck = cms.bool(False),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        MaxNumberOfPixelClusters = cms.uint32(10000)
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('TauRegionalPixelSeedGenerator'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            deltaPhiRegion = cms.double(0.5),
            originHalfLength = cms.double(0.3),
            originRadius = cms.double(0.2),
            deltaEtaRegion = cms.double(0.5),
            vertexSrc = cms.InputTag("hltPixelVertices"),
            JetSrc = cms.InputTag("hltAntiKT5CaloJetsEt5"),
            originZPos = cms.double(0.0),
            ptMin = cms.double(0.2)
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('SeedFromConsecutiveHitsCreator'),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        maxElement = cms.uint32(0),
        ComponentName = cms.string('StandardHitPairGenerator'),
        SeedingLayers = cms.string('hltESPPixelLayerPairs')
    ),
    TTRHBuilder = cms.string('WithTrackAngle')
)


process.hltPFTauIsolationDiscriminator = cms.EDProducer("PFRecoTauDiscriminationByIsolation",
    ApplyDiscriminationByECALIsolation = cms.bool(False),
    PVProducer = cms.InputTag("hltPixelVertices"),
    PFTauProducer = cms.InputTag("hltPFTaus"),
    maximumSumPtCut = cms.double(6.0),
    qualityCuts = cms.PSet(
        isolationQualityCuts = cms.PSet(
            minTrackHits = cms.uint32(3),
            minTrackPt = cms.double(1.0),
            maxTrackChi2 = cms.double(100.0),
            minTrackPixelHits = cms.uint32(0),
            minGammaEt = cms.double(1.5),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            maxDeltaZ = cms.double(0.2),
            maxTransverseImpactParameter = cms.double(0.05)
        ),
        signalQualityCuts = cms.PSet(
            maxDeltaZ = cms.double(0.5),
            minTrackPt = cms.double(0.0),
            maxTrackChi2 = cms.double(1000.0),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            minGammaEt = cms.double(0.5),
            minTrackPixelHits = cms.uint32(0),
            minTrackHits = cms.uint32(3),
            maxTransverseImpactParameter = cms.double(0.2)
        )
    ),
    maximumOccupancy = cms.uint32(0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    applyOccupancyCut = cms.bool(True),
    applySumPtCut = cms.bool(False),
    ApplyDiscriminationByTrackerIsolation = cms.bool(True),
    relativeSumPtCut = cms.double(0.0),
    applyRelativeSumPtCut = cms.bool(False)
)


process.hltPFTauJetTracksAssociator = cms.EDProducer("JetTracksAssociatorAtVertex",
    jets = cms.InputTag("hltAntiKT5PFJets"),
    tracks = cms.InputTag("hltPFJetCtfWithMaterialTracks"),
    coneSize = cms.double(0.5)
)


process.hltPFTauLooseIsolationDiscriminator = cms.EDProducer("PFRecoTauDiscriminationByIsolation",
    ApplyDiscriminationByECALIsolation = cms.bool(False),
    PVProducer = cms.InputTag("hltPixelVertices"),
    PFTauProducer = cms.InputTag("hltPFTaus"),
    maximumSumPtCut = cms.double(6.0),
    qualityCuts = cms.PSet(
        isolationQualityCuts = cms.PSet(
            minTrackHits = cms.uint32(3),
            minTrackPt = cms.double(1.5),
            maxTrackChi2 = cms.double(100.0),
            minTrackPixelHits = cms.uint32(0),
            minGammaEt = cms.double(1.5),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            maxDeltaZ = cms.double(0.2),
            maxTransverseImpactParameter = cms.double(0.05)
        ),
        signalQualityCuts = cms.PSet(
            maxDeltaZ = cms.double(0.5),
            minTrackPt = cms.double(0.0),
            maxTrackChi2 = cms.double(1000.0),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            minGammaEt = cms.double(0.5),
            minTrackPixelHits = cms.uint32(0),
            minTrackHits = cms.uint32(3),
            maxTransverseImpactParameter = cms.double(0.2)
        )
    ),
    maximumOccupancy = cms.uint32(0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    applyOccupancyCut = cms.bool(True),
    applySumPtCut = cms.bool(False),
    ApplyDiscriminationByTrackerIsolation = cms.bool(True),
    relativeSumPtCut = cms.double(0.0),
    applyRelativeSumPtCut = cms.bool(False)
)


process.hltPFTauTagInfo = cms.EDProducer("PFRecoTauTagInfoProducer",
    tkminTrackerHitsn = cms.int32(5),
    tkminPt = cms.double(0.0),
    tkmaxChi2 = cms.double(100.0),
    ChargedHadrCand_AssociationCone = cms.double(0.8),
    ChargedHadrCand_tkminTrackerHitsn = cms.int32(0),
    ChargedHadrCand_tkmaxChi2 = cms.double(100.0),
    tkPVmaxDZ = cms.double(0.4),
    GammaCand_EcalclusMinEt = cms.double(0.5),
    tkminPixelHitsn = cms.int32(2),
    PVProducer = cms.InputTag("hltPixelVertices"),
    PFCandidateProducer = cms.InputTag("hltParticleFlow"),
    ChargedHadrCand_tkminPt = cms.double(0.0),
    ChargedHadrCand_tkmaxipt = cms.double(0.2),
    ChargedHadrCand_tkminPixelHitsn = cms.int32(0),
    UsePVconstraint = cms.bool(True),
    NeutrHadrCand_HcalclusMinEt = cms.double(0.5),
    PFJetTracksAssociatorProducer = cms.InputTag("hltPFTauJetTracksAssociator"),
    smearedPVsigmaY = cms.double(0.0015),
    smearedPVsigmaX = cms.double(0.0015),
    smearedPVsigmaZ = cms.double(0.005),
    ChargedHadrCand_tkPVmaxDZ = cms.double(0.4),
    tkmaxipt = cms.double(0.2)
)


process.hltPFTauTightIsoIsolationDiscriminator = cms.EDProducer("PFRecoTauDiscriminationByIsolation",
    ApplyDiscriminationByECALIsolation = cms.bool(True),
    PVProducer = cms.InputTag("hltPixelVertices"),
    PFTauProducer = cms.InputTag("hltPFTausTightIso"),
    maximumSumPtCut = cms.double(6.0),
    qualityCuts = cms.PSet(
        isolationQualityCuts = cms.PSet(
            minTrackHits = cms.uint32(3),
            minTrackPt = cms.double(1.0),
            maxTrackChi2 = cms.double(100.0),
            minTrackPixelHits = cms.uint32(0),
            minGammaEt = cms.double(1.5),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            maxDeltaZ = cms.double(0.2),
            maxTransverseImpactParameter = cms.double(0.05)
        ),
        signalQualityCuts = cms.PSet(
            maxDeltaZ = cms.double(0.5),
            minTrackPt = cms.double(0.0),
            maxTrackChi2 = cms.double(1000.0),
            useTracksInsteadOfPFHadrons = cms.bool(False),
            minGammaEt = cms.double(0.5),
            minTrackPixelHits = cms.uint32(0),
            minTrackHits = cms.uint32(3),
            maxTransverseImpactParameter = cms.double(0.2)
        )
    ),
    maximumOccupancy = cms.uint32(0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    applyOccupancyCut = cms.bool(True),
    applySumPtCut = cms.bool(False),
    ApplyDiscriminationByTrackerIsolation = cms.bool(True),
    relativeSumPtCut = cms.double(0.0),
    applyRelativeSumPtCut = cms.bool(False)
)


process.hltPFTauTightIsoTrackFindingDiscriminator = cms.EDProducer("PFRecoTauDiscriminationByLeadingObjectPtCut",
    MinPtLeadingObject = cms.double(0.0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    PFTauProducer = cms.InputTag("hltPFTausTightIso"),
    UseOnlyChargedHadrons = cms.bool(True)
)


process.hltPFTauTightIsoTrackPt20Discriminator = cms.EDProducer("PFRecoTauDiscriminationByLeadingObjectPtCut",
    MinPtLeadingObject = cms.double(20.0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    PFTauProducer = cms.InputTag("hltPFTausTightIso"),
    UseOnlyChargedHadrons = cms.bool(True)
)


process.hltPFTauTightIsoTrackPt5Discriminator = cms.EDProducer("PFRecoTauDiscriminationByLeadingObjectPtCut",
    MinPtLeadingObject = cms.double(5.0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    PFTauProducer = cms.InputTag("hltPFTausTightIso"),
    UseOnlyChargedHadrons = cms.bool(True)
)


process.hltPFTauTrackFindingDiscriminator = cms.EDProducer("PFRecoTauDiscriminationByLeadingObjectPtCut",
    MinPtLeadingObject = cms.double(0.0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    PFTauProducer = cms.InputTag("hltPFTaus"),
    UseOnlyChargedHadrons = cms.bool(True)
)


process.hltPFTauTrackPt5Discriminator = cms.EDProducer("PFRecoTauDiscriminationByLeadingObjectPtCut",
    MinPtLeadingObject = cms.double(5.0),
    Prediscriminants = cms.PSet(
        BooleanOperator = cms.string('and')
    ),
    PFTauProducer = cms.InputTag("hltPFTaus"),
    UseOnlyChargedHadrons = cms.bool(True)
)


process.hltPFTaus = cms.EDProducer("PFRecoTauProducer",
    doOneProngTwoStrips = cms.bool(True),
    Rphi = cms.double(0.2),
    matchingCone = cms.double(0.2),
    MatchingConeMetric = cms.string('DR'),
    HCALIsolConeMetric = cms.string('DR'),
    minimumSignalCone = cms.double(0.0),
    TrackerIsolConeMetric = cms.string('DR'),
    TrackerSignalConeMetric = cms.string('DR'),
    ECALSignalConeMetric = cms.string('DR'),
    EcalStripSumE_deltaPhiOverQ_minValue = cms.double(0.0),
    EcalStripSumE_deltaEta = cms.double(0.0),
    HCALIsolConeSize_max = cms.double(0.5),
    leadPionThreshold = cms.double(1.0),
    HCALIsolConeSize_min = cms.double(0.0),
    TrackerIsolConeSizeFormula = cms.string('0.5'),
    TrackerSignalConeSizeFormula = cms.string('0.2'),
    gammaIsolationConeSize = cms.double(0.5),
    stripPtThreshold = cms.double(0.5),
    candOverlapCriterion = cms.string('None'),
    TrackerIsolConeSize_min = cms.double(0.0),
    LeadTrack_minPt = cms.double(0.0),
    ElectronPreIDProducer = cms.InputTag("elecpreid"),
    ChargedHadrCandLeadChargedHadrCand_tksmaxDZ = cms.double(0.4),
    TrackerIsolConeSize_max = cms.double(0.5),
    TrackerSignalConeSize_max = cms.double(0.2),
    MatchingConeSize_min = cms.double(0.0),
    AddEllipseGammas = cms.bool(False),
    maximumForElectrionPreIDOutput = cms.double(0.0),
    TrackerSignalConeSize_min = cms.double(0.0),
    doThreeProng = cms.bool(True),
    HCALIsolConeSizeFormula = cms.string('0.5'),
    AreaMetric_recoElements_maxabsEta = cms.double(2.5),
    MatchingConeSizeFormula = cms.string('0.2'),
    smearedPVsigmaZ = cms.double(0.005),
    doOneProngStrip = cms.bool(True),
    ECALSignalConeSizeFormula = cms.string('0.2'),
    Track_IsolAnnulus_minNhits = cms.uint32(0),
    HCALSignalConeMetric = cms.string('DR'),
    EcalStripSumE_deltaPhiOverQ_maxValue = cms.double(0.0),
    PFTauTagInfoProducer = cms.InputTag("hltPFTauTagInfo"),
    oneProngStripMassWindow = cms.vdouble(0.0, 0.0),
    maximumSignalCone = cms.double(1.8),
    coneMetric = cms.string('DR'),
    emMergingAlgorithm = cms.string('None'),
    ECALIsolConeSizeFormula = cms.string('0.5'),
    chargeHadrIsolationConeSize = cms.double(0.5),
    Algorithm = cms.string('ConeBased'),
    ECALIsolConeSize_max = cms.double(0.5),
    UseChargedHadrCandLeadChargedHadrCand_tksDZconstraint = cms.bool(True),
    PVProducer = cms.InputTag("hltPixelVertices"),
    JetPtMin = cms.double(0.0),
    ECALIsolConeMetric = cms.string('DR'),
    doOneProng = cms.bool(True),
    UseTrackLeadTrackDZconstraint = cms.bool(False),
    HCALSignalConeSize_max = cms.double(0.5),
    ECALSignalConeSize_min = cms.double(0.0),
    EcalStripSumE_minClusEnergy = cms.double(0.0),
    ElecPreIDLeadTkMatch_maxDR = cms.double(0.015),
    useIsolationAnnulus = cms.bool(False),
    oneProngTwoStripsPi0MassWindow = cms.vdouble(0.0, 0.0),
    LeadPFCand_minPt = cms.double(0.0),
    smearedPVsigmaY = cms.double(0.0015),
    HCALSignalConeSize_min = cms.double(0.0),
    threeProngMassWindow = cms.vdouble(0.0, 0.0),
    tauPtThreshold = cms.double(0.0),
    HCALSignalConeSizeFormula = cms.string('0.2'),
    TrackLeadTrack_maxDZ = cms.double(0.4),
    DataType = cms.string('AOD'),
    ECALIsolConeSize_min = cms.double(0.0),
    neutrHadrIsolationConeSize = cms.double(0.5),
    MaxEtInEllipse = cms.double(2.0),
    ChargedHadrCand_IsolAnnulus_minNhits = cms.uint32(0),
    smearedPVsigmaX = cms.double(0.0015),
    MatchingConeSize_max = cms.double(0.6),
    ECALSignalConeSize_max = cms.double(0.6),
    oneProngTwoStripsMassWindow = cms.vdouble(0.0, 0.0),
    coneSizeFormula = cms.string('2.8/ET')
)


process.hltPFTausTightIso = cms.EDProducer("PFRecoTauProducer",
    doOneProngTwoStrips = cms.bool(True),
    Rphi = cms.double(0.2),
    matchingCone = cms.double(0.2),
    MatchingConeMetric = cms.string('DR'),
    HCALIsolConeMetric = cms.string('DR'),
    minimumSignalCone = cms.double(0.0),
    TrackerIsolConeMetric = cms.string('DR'),
    TrackerSignalConeMetric = cms.string('DR'),
    ECALSignalConeMetric = cms.string('DR'),
    EcalStripSumE_deltaPhiOverQ_minValue = cms.double(0.0),
    EcalStripSumE_deltaEta = cms.double(0.0),
    HCALIsolConeSize_max = cms.double(0.5),
    leadPionThreshold = cms.double(1.0),
    HCALIsolConeSize_min = cms.double(0.0),
    TrackerIsolConeSizeFormula = cms.string('0.5'),
    TrackerSignalConeSizeFormula = cms.string('0.15'),
    gammaIsolationConeSize = cms.double(0.5),
    stripPtThreshold = cms.double(0.5),
    candOverlapCriterion = cms.string('None'),
    TrackerIsolConeSize_min = cms.double(0.0),
    LeadTrack_minPt = cms.double(0.0),
    ElectronPreIDProducer = cms.InputTag("elecpreid"),
    ChargedHadrCandLeadChargedHadrCand_tksmaxDZ = cms.double(0.4),
    TrackerIsolConeSize_max = cms.double(0.5),
    TrackerSignalConeSize_max = cms.double(0.2),
    MatchingConeSize_min = cms.double(0.0),
    AddEllipseGammas = cms.bool(False),
    maximumForElectrionPreIDOutput = cms.double(0.0),
    TrackerSignalConeSize_min = cms.double(0.0),
    doThreeProng = cms.bool(True),
    HCALIsolConeSizeFormula = cms.string('0.5'),
    AreaMetric_recoElements_maxabsEta = cms.double(2.5),
    MatchingConeSizeFormula = cms.string('0.2'),
    smearedPVsigmaZ = cms.double(0.005),
    doOneProngStrip = cms.bool(True),
    ECALSignalConeSizeFormula = cms.string('0.15'),
    Track_IsolAnnulus_minNhits = cms.uint32(0),
    HCALSignalConeMetric = cms.string('DR'),
    EcalStripSumE_deltaPhiOverQ_maxValue = cms.double(0.0),
    PFTauTagInfoProducer = cms.InputTag("hltPFTauTagInfo"),
    oneProngStripMassWindow = cms.vdouble(0.0, 0.0),
    maximumSignalCone = cms.double(1.8),
    coneMetric = cms.string('DR'),
    emMergingAlgorithm = cms.string('None'),
    ECALIsolConeSizeFormula = cms.string('0.5'),
    chargeHadrIsolationConeSize = cms.double(0.5),
    Algorithm = cms.string('ConeBased'),
    ECALIsolConeSize_max = cms.double(0.5),
    UseChargedHadrCandLeadChargedHadrCand_tksDZconstraint = cms.bool(True),
    PVProducer = cms.InputTag("hltPixelVertices"),
    JetPtMin = cms.double(0.0),
    ECALIsolConeMetric = cms.string('DR'),
    doOneProng = cms.bool(True),
    UseTrackLeadTrackDZconstraint = cms.bool(True),
    HCALSignalConeSize_max = cms.double(0.5),
    ECALSignalConeSize_min = cms.double(0.0),
    EcalStripSumE_minClusEnergy = cms.double(0.0),
    ElecPreIDLeadTkMatch_maxDR = cms.double(0.015),
    useIsolationAnnulus = cms.bool(False),
    oneProngTwoStripsPi0MassWindow = cms.vdouble(0.0, 0.0),
    LeadPFCand_minPt = cms.double(0.0),
    smearedPVsigmaY = cms.double(0.0015),
    HCALSignalConeSize_min = cms.double(0.0),
    threeProngMassWindow = cms.vdouble(0.0, 0.0),
    tauPtThreshold = cms.double(0.0),
    HCALSignalConeSizeFormula = cms.string('0.2'),
    TrackLeadTrack_maxDZ = cms.double(0.4),
    DataType = cms.string('AOD'),
    ECALIsolConeSize_min = cms.double(0.0),
    neutrHadrIsolationConeSize = cms.double(0.5),
    MaxEtInEllipse = cms.double(2.0),
    ChargedHadrCand_IsolAnnulus_minNhits = cms.uint32(0),
    smearedPVsigmaX = cms.double(0.0015),
    MatchingConeSize_max = cms.double(0.6),
    ECALSignalConeSize_max = cms.double(0.6),
    oneProngTwoStripsMassWindow = cms.vdouble(0.0, 0.0),
    coneSizeFormula = cms.string('2.8/ET')
)


process.hltPFlowTrackSelectionHighPurity = cms.EDProducer("AnalyticalTrackSelector",
    max_d0 = cms.double(100.0),
    minNumber3DLayers = cms.uint32(3),
    keepAllTracks = cms.bool(False),
    applyAbsCutsIfNoPV = cms.bool(False),
    qualityBit = cms.string('highPurity'),
    minNumberLayers = cms.uint32(3),
    chi2n_par = cms.double(0.6),
    nSigmaZ = cms.double(3.0),
    dz_par2 = cms.vdouble(4.0, 4.0),
    applyAdaptedPVCuts = cms.bool(False),
    dz_par1 = cms.vdouble(0.35, 4.0),
    copyTrajectories = cms.untracked.bool(True),
    vtxNumber = cms.int32(-1),
    max_d0NoPV = cms.double(100.0),
    maxNumberLostLayers = cms.uint32(2),
    beamspot = cms.InputTag("hltOnlineBeamSpot"),
    copyExtras = cms.untracked.bool(True),
    max_z0NoPV = cms.double(100.0),
    vertexCut = cms.string('ndof>=2&!isFake'),
    max_z0 = cms.double(100.0),
    src = cms.InputTag("hltPFJetCtfWithMaterialTracks"),
    vertices = cms.InputTag("hltPixelVertices"),
    d0_par2 = cms.vdouble(4.0, 4.0),
    d0_par1 = cms.vdouble(0.3, 4.0),
    res_par = cms.vdouble(0.003, 0.001)
)


process.hltParticleFlow = cms.EDProducer("PFProducer",
    sumPtTrackIsoForEgammaSC_endcap = cms.double(4.0),
    coneTrackIsoForEgammaSC = cms.double(0.3),
    calibHF_use = cms.bool(False),
    pfcluster_barrelEndcapEtaDiv = cms.double(1.4),
    minSignificance = cms.double(2.5),
    pf_calib_HCAL_offset = cms.double(1.73),
    pf_nsigma_ECAL = cms.double(0.0),
    usePFConversions = cms.bool(False),
    pf_calib_ECAL_HCAL_hslope = cms.double(1.06),
    useCalibrationsFromDB = cms.bool(True),
    pf_newCalib = cms.uint32(2),
    calibPFSCEle_endcap = cms.vdouble(1.153, -16.5975, 5.668, -0.1772, 16.22,
        7.326, 0.0483, -4.068, 9.406),
    usePFElectrons = cms.bool(False),
    postMuonCleaning = cms.bool(False),
    minSignificanceReduction = cms.double(1.4),
    calibPFSCEle_barrel = cms.vdouble(1.004, -1.536, 22.88, -1.467, 0.3555,
        0.6227, 14.65, 2051, 25, 0.9932,
        -0.5444, 0, 0.5438, 0.7109, 7.645,
        0.2904, 0),
    nTrackIsoForEgammaSC = cms.uint32(2),
    postHFCleaning = cms.bool(False),
    factors_45 = cms.vdouble(10.0, 100.0),
    pfcluster_etaCorrection = cms.vdouble(1.01, -0.0102, 0.0517, 0.563, -0.425,
        0.11),
    cleanedHF = cms.VInputTag("hltParticleFlowRecHitHCAL:Cleaned", "hltParticleFlowClusterHFHAD:Cleaned", "hltParticleFlowClusterHFEM:Cleaned"),
    iCfgCandConnector = cms.PSet(
        bCalibSecondary = cms.bool(False),
        bCalibPrimary = cms.bool(False),
        bCorrect = cms.bool(False),
        nuclCalibFactors = cms.vdouble(0.88, 0.28, 0.04)
    ),
    rejectTracks_Bad = cms.bool(False),
    coneEcalIsoForEgammaSC = cms.double(0.3),
    ecalHcalEcalEndcap = cms.vdouble(0.46, 3.0, 1.1, 0.4, -0.02,
        1.4),
    usePFPhotons = cms.bool(False),
    pfcluster_lowEP0 = cms.double(0.3249189),
    vertexCollection = cms.InputTag("hltPixelVertices"),
    pf_calib_ECAL_HCAL_offset = cms.double(6.11),
    egammaElectrons = cms.InputTag(""),
    calibHF_a_EMonly = cms.vdouble(0.96945, 0.96701, 0.76309, 0.82268, 0.87583),
    pfcluster_lowEP1 = cms.double(0.790799),
    maxDeltaPhiPt = cms.double(7.0),
    muons = cms.InputTag(""),
    ecalHcalEcalBarrel = cms.vdouble(0.67, 3.0, 1.15, 0.9, -0.06,
        1.4),
    pf_electronID_crackCorrection = cms.bool(False),
    minHFCleaningPt = cms.double(5.0),
    calibHF_b_HADonly = cms.vdouble(1.27541, 0.85361, 0.86333, 0.89091, 0.94348),
    pf_nsigma_HCAL = cms.double(1.0),
    calibPFSCEle_Fbrem_barrel = cms.vdouble(0.6, 6.0, -0.0255975, 0.0576727, 0.975442,
        -0.000546394, 1.26147, 25.0, -0.02025, 0.04537,
        0.9728, -0.0008962, 1.172),
    blocks = cms.InputTag("hltParticleFlowBlock"),
    pf_calib_ECAL_slope = cms.double(1.0),
    pf_clusterRecovery = cms.bool(False),
    useEGammaElectrons = cms.bool(False),
    pfcluster_allowNegative = cms.uint32(0),
    pf_calib_HCAL_damping = cms.double(2.49),
    nsigma_TRACK = cms.double(1.0),
    ecalHcalHcalEndcap = cms.vdouble(0.46, 3.0, 1.1, 0.3, -0.02,
        1.4),
    dptRel_DispVtx = cms.double(10.0),
    usePFMuonMomAssign = cms.bool(False),
    useVerticesForNeutral = cms.bool(True),
    useEGammaSupercluster = cms.bool(False),
    sumPtTrackIsoForEgammaSC_barrel = cms.double(4.0),
    sumEtEcalIsoForEgammaSC_endcap = cms.double(2.0),
    pf_calib_ECAL_offset = cms.double(0.0),
    usePFDecays = cms.bool(False),
    calibHF_b_EMHAD = cms.vdouble(1.27541, 0.85361, 0.86333, 0.89091, 0.94348),
    rejectTracks_Step45 = cms.bool(False),
    pf_electron_output_col = cms.string('electrons'),
    pfcluster_doCorrection = cms.uint32(1),
    sumEtEcalIsoForEgammaSC_barrel = cms.double(1.0),
    calibPFSCEle_Fbrem_endcap = cms.vdouble(0.9, 6.5, -0.0692932, 0.101776, 0.995338,
        -0.00236548, 0.874998, 1.653, -0.0750184, 0.147,
        0.923165, 0.000474665, 1.10782),
    pf_calib_HCAL_slope = cms.double(2.17),
    pf_calib_ECAL_HCAL_eslope = cms.double(1.05),
    usePFNuclearInteractions = cms.bool(False),
    pf_electronID_mvaWeightFile = cms.string('RecoParticleFlow/PFProducer/data/MVAnalysis_BDT.weights_PfElectrons23Jan_IntToFloat.txt'),
    maxSignificance = cms.double(2.5),
    minDeltaMet = cms.double(0.4),
    calibHF_a_EMHAD = cms.vdouble(1.42215, 1.00496, 0.68961, 0.81656, 0.98504),
    algoType = cms.uint32(0),
    pf_electron_mvaCut = cms.double(-0.1),
    ecalHcalHcalBarrel = cms.vdouble(0.46, 3.0, 1.15, 0.3, -0.02,
        1.4),
    muon_HCAL = cms.vdouble(3.0, 3.0),
    pt_Error = cms.double(1.0),
    pfcluster_doEtaCorrection = cms.uint32(1),
    muon_ECAL = cms.vdouble(0.5, 0.5),
    calibHF_eta_step = cms.vdouble(0.0, 2.9, 3.0, 3.2, 4.2,
        4.4, 4.6, 4.8, 5.2, 5.2),
    pfcluster_globalP0 = cms.double(-2.315),
    pfcluster_globalP1 = cms.double(1.01),
    usePFSCEleCalib = cms.bool(True)
)


process.hltParticleFlowBlock = cms.EDProducer("PFBlockProducer",
    PFClustersHCAL = cms.InputTag("hltParticleFlowClusterHCAL"),
    RecMuons = cms.InputTag("muons"),
    PFClustersHFHAD = cms.InputTag("hltParticleFlowClusterHFHAD"),
    PFConversions = cms.InputTag("pfConversions"),
    useConversions = cms.bool(False),
    useRecMuons = cms.bool(False),
    nuclearInteractionsPurity = cms.uint32(1),
    PFClustersECAL = cms.InputTag("hltParticleFlowClusterECAL"),
    useGsfRecTracks = cms.bool(False),
    usePFatHLT = cms.bool(True),
    useIterTracking = cms.bool(False),
    useConvBremPFRecTracks = cms.bool(False),
    useV0 = cms.bool(False),
    RecTracks = cms.InputTag("hltLightPFTracks"),
    ConvBremGsfRecTracks = cms.InputTag("pfTrackElec","Secondary"),
    PFClustersPS = cms.InputTag("hltParticleFlowClusterPS"),
    pf_DPtoverPt_Cut = cms.vdouble(-1.0, -1.0, -1.0, -1.0),
    GsfRecTracks = cms.InputTag("pfTrackElec"),
    useNuclear = cms.bool(False),
    useConvBremGsfTracks = cms.bool(False),
    PFNuclear = cms.InputTag("pfDisplacedTrackerVertex"),
    PFV0 = cms.InputTag("pfV0"),
    PFClustersHFEM = cms.InputTag("hltParticleFlowClusterHFEM"),
    useEGPhotons = cms.bool(False),
    pf_NHit_Cut = cms.vuint32(0, 0, 0, 0)
)


process.hltParticleFlowClusterECAL = cms.EDProducer("PFClusterProducer",
    posCalcNCrystal = cms.int32(5),
    showerSigma = cms.double(10.0),
    thresh_DoubleSpike_Barrel = cms.double(1000000000.0),
    thresh_Pt_Barrel = cms.double(0.0),
    thresh_Clean_Barrel = cms.double(100000.0),
    PFRecHits = cms.InputTag("hltParticleFlowRecHitECAL"),
    cleanRBXandHPDs = cms.bool(False),
    depthCor_B = cms.double(7.4),
    depthCor_A = cms.double(0.89),
    nNeighbours = cms.int32(4),
    thresh_DoubleSpike_Endcap = cms.double(1000000000.0),
    minS4S1_Clean_Barrel = cms.vdouble(0.04, -0.024),
    thresh_Pt_Seed_Barrel = cms.double(0.0),
    thresh_Pt_Endcap = cms.double(0.0),
    thresh_Barrel = cms.double(0.8),
    thresh_Clean_Endcap = cms.double(100000.0),
    thresh_Seed_Barrel = cms.double(0.8),
    depthCor_Mode = cms.int32(1),
    depthCor_B_preshower = cms.double(4.0),
    useCornerCells = cms.bool(True),
    depthCor_A_preshower = cms.double(0.89),
    thresh_Endcap = cms.double(0.8),
    thresh_Pt_Seed_Endcap = cms.double(0.0),
    minS4S1_Clean_Endcap = cms.vdouble(0.04, -0.025),
    thresh_Seed_Endcap = cms.double(1.1),
    minS6S2_DoubleSpike_Endcap = cms.double(-1.0),
    minS6S2_DoubleSpike_Barrel = cms.double(-1.0)
)


process.hltParticleFlowClusterHCAL = cms.EDProducer("PFClusterProducer",
    posCalcNCrystal = cms.int32(5),
    showerSigma = cms.double(10.0),
    thresh_DoubleSpike_Barrel = cms.double(1000000000.0),
    thresh_Pt_Barrel = cms.double(0.0),
    thresh_Clean_Barrel = cms.double(10000000.0),
    PFRecHits = cms.InputTag("hltParticleFlowRecHitHCAL"),
    cleanRBXandHPDs = cms.bool(True),
    depthCor_B = cms.double(7.4),
    depthCor_A = cms.double(0.89),
    nNeighbours = cms.int32(4),
    thresh_DoubleSpike_Endcap = cms.double(1000000000.0),
    minS4S1_Clean_Barrel = cms.vdouble(0.032, -0.045),
    thresh_Pt_Seed_Barrel = cms.double(0.0),
    thresh_Pt_Endcap = cms.double(0.0),
    thresh_Barrel = cms.double(0.8),
    thresh_Clean_Endcap = cms.double(1000000.0),
    thresh_Seed_Barrel = cms.double(0.8),
    depthCor_Mode = cms.int32(2),
    depthCor_B_preshower = cms.double(4.0),
    useCornerCells = cms.bool(True),
    depthCor_A_preshower = cms.double(0.89),
    thresh_Endcap = cms.double(0.8),
    thresh_Pt_Seed_Endcap = cms.double(0.0),
    minS4S1_Clean_Endcap = cms.vdouble(0.032, -0.045),
    thresh_Seed_Endcap = cms.double(1.1),
    minS6S2_DoubleSpike_Endcap = cms.double(-1.0),
    minS6S2_DoubleSpike_Barrel = cms.double(-1.0)
)


process.hltParticleFlowClusterHFEM = cms.EDProducer("PFClusterProducer",
    posCalcNCrystal = cms.int32(5),
    showerSigma = cms.double(10.0),
    thresh_DoubleSpike_Barrel = cms.double(1000000000.0),
    thresh_Pt_Barrel = cms.double(0.0),
    thresh_Clean_Barrel = cms.double(80.0),
    PFRecHits = cms.InputTag("hltParticleFlowRecHitHCAL","HFEM"),
    cleanRBXandHPDs = cms.bool(False),
    depthCor_B = cms.double(7.4),
    depthCor_A = cms.double(0.89),
    nNeighbours = cms.int32(0),
    thresh_DoubleSpike_Endcap = cms.double(1000000000.0),
    minS4S1_Clean_Barrel = cms.vdouble(0.11, -0.19),
    thresh_Pt_Seed_Barrel = cms.double(0.0),
    thresh_Pt_Endcap = cms.double(0.0),
    thresh_Barrel = cms.double(0.8),
    thresh_Clean_Endcap = cms.double(80.0),
    thresh_Seed_Barrel = cms.double(1.4),
    depthCor_Mode = cms.int32(1),
    depthCor_B_preshower = cms.double(4.0),
    useCornerCells = cms.bool(False),
    depthCor_A_preshower = cms.double(0.89),
    thresh_Endcap = cms.double(0.8),
    thresh_Pt_Seed_Endcap = cms.double(0.0),
    minS4S1_Clean_Endcap = cms.vdouble(0.11, -0.19),
    thresh_Seed_Endcap = cms.double(1.4),
    minS6S2_DoubleSpike_Endcap = cms.double(-1.0),
    minS6S2_DoubleSpike_Barrel = cms.double(-1.0)
)


process.hltParticleFlowClusterHFHAD = cms.EDProducer("PFClusterProducer",
    posCalcNCrystal = cms.int32(5),
    showerSigma = cms.double(10.0),
    thresh_DoubleSpike_Barrel = cms.double(1000000000.0),
    thresh_Pt_Barrel = cms.double(0.0),
    thresh_Clean_Barrel = cms.double(120.0),
    PFRecHits = cms.InputTag("hltParticleFlowRecHitHCAL","HFHAD"),
    cleanRBXandHPDs = cms.bool(False),
    depthCor_B = cms.double(7.4),
    depthCor_A = cms.double(0.89),
    nNeighbours = cms.int32(0),
    thresh_DoubleSpike_Endcap = cms.double(1000000000.0),
    minS4S1_Clean_Barrel = cms.vdouble(0.045, -0.08),
    thresh_Pt_Seed_Barrel = cms.double(0.0),
    thresh_Pt_Endcap = cms.double(0.0),
    thresh_Barrel = cms.double(0.8),
    thresh_Clean_Endcap = cms.double(120.0),
    thresh_Seed_Barrel = cms.double(1.4),
    depthCor_Mode = cms.int32(2),
    depthCor_B_preshower = cms.double(4.0),
    useCornerCells = cms.bool(False),
    depthCor_A_preshower = cms.double(0.89),
    thresh_Endcap = cms.double(0.8),
    thresh_Pt_Seed_Endcap = cms.double(0.0),
    minS4S1_Clean_Endcap = cms.vdouble(0.045, -0.08),
    thresh_Seed_Endcap = cms.double(1.4),
    minS6S2_DoubleSpike_Endcap = cms.double(-1.0),
    minS6S2_DoubleSpike_Barrel = cms.double(-1.0)
)


process.hltParticleFlowClusterPS = cms.EDProducer("PFClusterProducer",
    posCalcNCrystal = cms.int32(-1),
    showerSigma = cms.double(0.2),
    thresh_DoubleSpike_Barrel = cms.double(1000000000.0),
    thresh_Pt_Barrel = cms.double(0.0),
    thresh_Clean_Barrel = cms.double(100000.0),
    PFRecHits = cms.InputTag("hltParticleFlowRecHitPS"),
    cleanRBXandHPDs = cms.bool(False),
    depthCor_B = cms.double(7.4),
    depthCor_A = cms.double(0.89),
    nNeighbours = cms.int32(4),
    thresh_DoubleSpike_Endcap = cms.double(1000000000.0),
    minS4S1_Clean_Barrel = cms.vdouble(0.0, 0.0),
    thresh_Pt_Seed_Barrel = cms.double(0.0),
    thresh_Pt_Endcap = cms.double(0.0),
    thresh_Barrel = cms.double(6e-05),
    thresh_Clean_Endcap = cms.double(100000.0),
    thresh_Seed_Barrel = cms.double(0.00012),
    depthCor_Mode = cms.int32(1),
    depthCor_B_preshower = cms.double(4.0),
    useCornerCells = cms.bool(False),
    depthCor_A_preshower = cms.double(0.89),
    thresh_Endcap = cms.double(6e-05),
    thresh_Pt_Seed_Endcap = cms.double(0.0),
    minS4S1_Clean_Endcap = cms.vdouble(0.0, 0.0),
    thresh_Seed_Endcap = cms.double(0.00012),
    minS6S2_DoubleSpike_Endcap = cms.double(-1.0),
    minS6S2_DoubleSpike_Barrel = cms.double(-1.0)
)


process.hltParticleFlowRecHitECAL = cms.EDProducer("PFRecHitProducerECAL",
    crossBarrelEndcapBorder = cms.bool(False),
    verbose = cms.untracked.bool(False),
    ecalRecHitsEE = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE"),
    ecalRecHitsEB = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB"),
    thresh_Cleaning_EB = cms.double(2.0),
    timing_Cleaning = cms.bool(False),
    thresh_Barrel = cms.double(0.08),
    thresh_Cleaning_EE = cms.double(1000000000.0),
    topological_Cleaning = cms.bool(True),
    thresh_Endcap = cms.double(0.3)
)


process.hltParticleFlowRecHitHCAL = cms.EDProducer("PFRecHitProducerHCAL",
    ECAL_Compensate = cms.bool(False),
    ECAL_Dead_Code = cms.uint32(10),
    MinLongTiming_Cut = cms.double(-5.0),
    verbose = cms.untracked.bool(False),
    ECAL_Compensation = cms.double(0.5),
    MaxLongTiming_Cut = cms.double(5.0),
    weight_HFhad = cms.double(1.0),
    ApplyPulseDPG = cms.bool(False),
    ECAL_Threshold = cms.double(10.0),
    ApplyTimeDPG = cms.bool(False),
    caloTowers = cms.InputTag("hltTowerMakerForAll"),
    hcalRecHitsHBHE = cms.InputTag("hltHbhereco"),
    LongFibre_Fraction = cms.double(0.05),
    MaxShortTiming_Cut = cms.double(5.0),
    thresh_Barrel = cms.double(0.4),
    navigation_HF = cms.bool(True),
    HF_Calib_29 = cms.double(1.07),
    LongFibre_Cut = cms.double(120.0),
    EM_Depth = cms.double(22.0),
    weight_HFem = cms.double(1.0),
    LongShortFibre_Cut = cms.double(1000000000.0),
    MinShortTiming_Cut = cms.double(-5.0),
    HCAL_Calib = cms.bool(True),
    thresh_HF = cms.double(0.4),
    thresh_Endcap = cms.double(0.4),
    hcalRecHitsHF = cms.InputTag("hltHfreco"),
    ShortFibre_Cut = cms.double(60.0),
    ApplyLongShortDPG = cms.bool(False),
    HF_Calib = cms.bool(True),
    HAD_Depth = cms.double(47.0),
    ShortFibre_Fraction = cms.double(0.01),
    HCAL_Calib_29 = cms.double(1.35)
)


process.hltParticleFlowRecHitPS = cms.EDProducer("PFRecHitProducerPS",
    ecalRecHitsES = cms.InputTag("hltESRecHitAll","EcalRecHitsES"),
    thresh_Barrel = cms.double(7e-06),
    thresh_Endcap = cms.double(7e-06),
    verbose = cms.untracked.bool(False)
)


process.hltPixelCandsForHighMult = cms.EDProducer("ConcreteChargedCandidateProducer",
    src = cms.InputTag("hltPixelTracksForHighMult"),
    particleType = cms.string('pi+')
)


process.hltPixelMatch3HitElectronsActivity = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtf3HitActivityWithMaterialTracks")
)


process.hltPixelMatch3HitElectronsL1Iso = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtf3HitL1IsoWithMaterialTracks")
)


process.hltPixelMatch3HitElectronsL1NonIso = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtf3HitL1NonIsoWithMaterialTracks")
)


process.hltPixelMatchElectronsActivity = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtfActivityWithMaterialTracks")
)


process.hltPixelMatchElectronsL1Iso = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtfL1IsoWithMaterialTracks")
)


process.hltPixelMatchElectronsL1NonIso = cms.EDProducer("EgammaHLTPixelMatchElectronProducers",
    BSProducer = cms.InputTag("hltOnlineBeamSpot"),
    TrackProducer = cms.InputTag("hltCtfL1NonIsoWithMaterialTracks")
)


process.hltPixelTracks = cms.EDProducer("PixelTrackProducer",
    FilterPSet = cms.PSet(
        nSigmaTipMaxTolerance = cms.double(0.0),
        chi2 = cms.double(1000.0),
        ComponentName = cms.string('PixelTrackFilterByKinematics'),
        nSigmaInvPtTolerance = cms.double(0.0),
        ptMin = cms.double(0.1),
        tipMax = cms.double(1.0)
    ),
    useFilterWithES = cms.bool(False),
    FitterPSet = cms.PSet(
        ComponentName = cms.string('PixelFitterByHelixProjections'),
        TTRHBuilder = cms.string('hltESPTTRHBuilderPixelOnly')
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('GlobalRegionProducerFromBeamSpot'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            originRadius = cms.double(0.2),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            originHalfLength = cms.double(15.9),
            ptMin = cms.double(0.9)
        )
    ),
    CleanerPSet = cms.PSet(
        ComponentName = cms.string('PixelTrackCleanerBySharedHits')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            phiPreFiltering = cms.double(0.3),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTriplets')
    )
)


process.hltPixelTracksForHighMult = cms.EDProducer("PixelTrackProducer",
    FilterPSet = cms.PSet(
        nSigmaTipMaxTolerance = cms.double(0.0),
        chi2 = cms.double(1000.0),
        ComponentName = cms.string('PixelTrackFilterByKinematics'),
        nSigmaInvPtTolerance = cms.double(0.0),
        ptMin = cms.double(0.4),
        tipMax = cms.double(1.0)
    ),
    useFilterWithES = cms.bool(False),
    FitterPSet = cms.PSet(
        ComponentName = cms.string('PixelFitterByHelixProjections'),
        TTRHBuilder = cms.string('hltESPTTRHBuilderPixelOnly')
    ),
    RegionFactoryPSet = cms.PSet(
        ComponentName = cms.string('GlobalRegionProducerFromBeamSpot'),
        RegionPSet = cms.PSet(
            precise = cms.bool(True),
            beamSpot = cms.InputTag("hltOnlineBeamSpot"),
            originRadius = cms.double(0.0015),
            ptMin = cms.double(0.6),
            originHalfLength = cms.double(10.1)
        )
    ),
    CleanerPSet = cms.PSet(
        ComponentName = cms.string('PixelTrackCleanerBySharedHits')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('StandardHitTripletGenerator'),
        GeneratorPSet = cms.PSet(
            useBending = cms.bool(True),
            useFixedPreFiltering = cms.bool(False),
            maxElement = cms.uint32(10000),
            phiPreFiltering = cms.double(0.3),
            extraHitRPhitolerance = cms.double(0.06),
            useMultScattering = cms.bool(True),
            ComponentName = cms.string('PixelTripletHLTGenerator'),
            extraHitRZtolerance = cms.double(0.06)
        ),
        SeedingLayers = cms.string('hltESPPixelLayerTriplets')
    )
)


process.hltPixelVertices = cms.EDProducer("PixelVertexProducer",
    WtAverage = cms.bool(True),
    Method2 = cms.bool(True),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Verbosity = cms.int32(0),
    UseError = cms.bool(True),
    TrackCollection = cms.InputTag("hltPixelTracks"),
    ZSeparation = cms.double(0.05),
    NTrkMin = cms.int32(2),
    ZOffset = cms.double(5.0),
    Finder = cms.string('DivisiveVertexFinder'),
    PtMin = cms.double(1.0)
)


process.hltPixelVerticesForHighMult = cms.EDProducer("PixelVertexProducer",
    WtAverage = cms.bool(True),
    Method2 = cms.bool(True),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Verbosity = cms.int32(0),
    UseError = cms.bool(True),
    TrackCollection = cms.InputTag("hltPixelTracksForHighMult"),
    ZSeparation = cms.double(0.05),
    NTrkMin = cms.int32(50),
    ZOffset = cms.double(5.0),
    Finder = cms.string('DivisiveVertexFinder'),
    PtMin = cms.double(0.4)
)


process.hltRPCPointProducer = cms.EDProducer("RPCPointProducer",
    cscSegments = cms.InputTag("hltCscSegments"),
    tracks = cms.InputTag("NotUsed"),
    incltrack = cms.untracked.bool(False),
    dt4DSegments = cms.InputTag("hltDt4DSegments"),
    TrackTransformer = cms.PSet(

    )
)


process.hltRecoEcalSuperClusterActivityCandidate = cms.EDProducer("EgammaHLTRecoEcalCandidateProducers",
    scIslandEndcapProducer = cms.InputTag("hltCorrectedMulti5x5SuperClustersWithPreshowerActivity"),
    scHybridBarrelProducer = cms.InputTag("hltCorrectedHybridSuperClustersActivity"),
    recoEcalCandidateCollection = cms.string('')
)


process.hltRegionalCosmicCkfTrackCandidates = cms.EDProducer("CkfTrackCandidateMaker",
    src = cms.InputTag("hltRegionalCosmicTrackerSeeds"),
    TransientInitialStateEstimatorParameters = cms.PSet(
        propagatorAlongTISE = cms.string('PropagatorWithMaterial'),
        numberMeasurementsForFit = cms.int32(4),
        propagatorOppositeTISE = cms.string('PropagatorWithMaterialOpposite')
    ),
    RedundantSeedCleaner = cms.string('CachingSeedCleanerBySharedInput'),
    cleanTrajectoryAfterInOut = cms.bool(False),
    useHitsSplitting = cms.bool(False),
    doSeedingRegionRebuilding = cms.bool(False),
    maxNSeeds = cms.uint32(200),
    NavigationSchool = cms.string('CosmicNavigationSchool'),
    TrajectoryBuilder = cms.string('hltESPCkfTrajectoryBuilder'),
    TrajectoryCleaner = cms.string('hltESPTrajectoryCleanerBySharedHits')
)


process.hltRegionalCosmicTrackerSeeds = cms.EDProducer("SeedGeneratorFromRegionHitsEDProducer",
    SeedComparitorPSet = cms.PSet(
        ComponentName = cms.string('none')
    ),
    ClusterCheckPSet = cms.PSet(
        MaxNumberOfPixelClusters = cms.uint32(300000),
        PixelClusterCollectionLabel = cms.InputTag("hltSiPixelClusters"),
        MaxNumberOfCosmicClusters = cms.uint32(300000),
        ClusterCollectionLabel = cms.InputTag("hltSiStripClusters"),
        doClusterCheck = cms.bool(False)
    ),
    RegionFactoryPSet = cms.PSet(
        CollectionsPSet = cms.PSet(
            recoMuonsCollection = cms.InputTag("muons"),
            recoTrackMuonsCollection = cms.InputTag("cosmicMuons"),
            recoL2MuonsCollection = cms.InputTag("hltL2MuonCandidatesNoVtx")
        ),
        ComponentName = cms.string('CosmicRegionalSeedGenerator'),
        RegionInJetsCheckPSet = cms.PSet(
            deltaRExclusionSize = cms.double(0.3),
            recoCaloJetsCollection = cms.InputTag("hltIterativeCone5CaloJets"),
            jetsPtMin = cms.double(5.0),
            doJetsExclusionCheck = cms.bool(False)
        ),
        ToolsPSet = cms.PSet(
            regionBase = cms.string('seedOnL2Muon'),
            thePropagatorName = cms.string('hltESPAnalyticalPropagator')
        ),
        RegionPSet = cms.PSet(
            precise = cms.bool(False),
            deltaPhiRegion = cms.double(0.3),
            measurementTrackerName = cms.string('hltESPMeasurementTracker'),
            zVertex = cms.double(5.0),
            deltaEtaRegion = cms.double(0.3),
            ptMin = cms.double(5.0),
            rVertex = cms.double(5.0)
        )
    ),
    SeedCreatorPSet = cms.PSet(
        ComponentName = cms.string('CosmicSeedCreator'),
        maxseeds = cms.int32(100000),
        propagator = cms.string('PropagatorWithMaterial')
    ),
    OrderedHitsFactoryPSet = cms.PSet(
        ComponentName = cms.string('GenericPairGenerator'),
        LayerPSet = cms.PSet(
            TOB = cms.PSet(
                TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
            ),
            layerList = cms.vstring('TOB6+TOB5',
                'TOB6+TOB4',
                'TOB6+TOB3',
                'TOB5+TOB4',
                'TOB5+TOB3',
                'TOB4+TOB3')
        )
    ),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle')
)


process.hltRegionalCosmicTracks = cms.EDProducer("TrackProducer",
    src = cms.InputTag("hltRegionalCosmicCkfTrackCandidates"),
    clusterRemovalInfo = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    Fitter = cms.string('hltESPKFFittingSmoother'),
    useHitsSplitting = cms.bool(False),
    alias = cms.untracked.string('hltRegionalCosmicTracks'),
    NavigationSchool = cms.string(''),
    TrajectoryInEvent = cms.bool(True),
    TTRHBuilder = cms.string('hltESPTTRHBWithTrackAngle'),
    AlgorithmName = cms.string('undefAlgorithm'),
    Propagator = cms.string('hltESPRungeKuttaTrackerPropagator')
)


process.hltRpcRecHits = cms.EDProducer("RPCRecHitProducer",
    recAlgo = cms.string('RPCRecHitStandardAlgo'),
    deadvecfile = cms.FileInPath('RecoLocalMuon/RPCRecHit/data/RPCDeadVec.dat'),
    rpcDigiLabel = cms.InputTag("hltMuonRPCDigis"),
    maskvecfile = cms.FileInPath('RecoLocalMuon/RPCRecHit/data/RPCMaskVec.dat'),
    recAlgoConfig = cms.PSet(

    ),
    deadSource = cms.string('File'),
    maskSource = cms.string('File')
)


process.hltScalersRawToDigi = cms.EDProducer("ScalersRawToDigi",
    scalersInputTag = cms.InputTag("rawDataCollector")
)


process.hltSiPixelClusters = cms.EDProducer("SiPixelClusterProducer",
    src = cms.InputTag("hltSiPixelDigis"),
    ChannelThreshold = cms.int32(1000),
    maxNumberOfClusters = cms.int32(10000),
    SplitClusters = cms.bool(False),
    MissCalibrate = cms.untracked.bool(True),
    VCaltoElectronGain = cms.int32(65),
    VCaltoElectronOffset = cms.int32(-414),
    payloadType = cms.string('HLT'),
    SeedThreshold = cms.int32(1000),
    ClusterThreshold = cms.double(4000.0)
)


process.hltSiPixelDigis = cms.EDProducer("SiPixelRawToDigi",
    IncludeErrors = cms.bool(False),
    UseQualityInfo = cms.bool(False),
    InputLabel = cms.InputTag("rawDataCollector")
)


process.hltSiPixelRecHits = cms.EDProducer("SiPixelRecHitConverter",
    src = cms.InputTag("hltSiPixelClusters"),
    CPE = cms.string('hltESPPixelCPEGeneric')
)


process.hltSiStripClusters = cms.EDProducer("MeasurementTrackerSiStripRefGetterProducer",
    InputModuleLabel = cms.InputTag("hltSiStripRawToClustersFacility"),
    measurementTrackerName = cms.string('hltESPMeasurementTracker')
)


process.hltSiStripRawToClustersFacility = cms.EDProducer("SiStripRawToClusters",
    ProductLabel = cms.InputTag("rawDataCollector"),
    Algorithms = cms.PSet(
        SiStripFedZeroSuppressionMode = cms.uint32(4),
        CommonModeNoiseSubtractionMode = cms.string('Median'),
        PedestalSubtractionFedMode = cms.bool(True),
        TruncateInSuppressor = cms.bool(True)
    ),
    Clusterizer = cms.PSet(
        ChannelThreshold = cms.double(2.0),
        MaxSequentialBad = cms.uint32(1),
        Algorithm = cms.string('ThreeThresholdAlgorithm'),
        MaxSequentialHoles = cms.uint32(0),
        MaxAdjacentBad = cms.uint32(0),
        QualityLabel = cms.string(''),
        SeedThreshold = cms.double(3.0),
        ClusterThreshold = cms.double(5.0)
    )
)


process.hltSimple3x3Clusters = cms.EDProducer("EgammaHLTNxNClusterProducer",
    statusLevelRecHitsToUse = cms.int32(1),
    barrelClusterCollection = cms.string('Simple3x3ClustersBarrel'),
    useRecoFlag = cms.bool(False),
    maxNumberofClusters = cms.int32(30),
    clusPhiSize = cms.int32(3),
    posCalcParameters = cms.PSet(
        T0_barl = cms.double(7.4),
        LogWeighted = cms.bool(True),
        T0_endc = cms.double(3.1),
        T0_endcPresh = cms.double(1.2),
        W0 = cms.double(4.2),
        X0 = cms.double(0.89)
    ),
    clusEtaSize = cms.int32(3),
    flagLevelRecHitsToUse = cms.int32(1),
    endcapHitProducer = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEE"),
    maxNumberofSeeds = cms.int32(200),
    endcapClusterCollection = cms.string('Simple3x3ClustersEndcap'),
    debugLevel = cms.int32(0),
    barrelHitProducer = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEB"),
    clusSeedThrEndCap = cms.double(1.0),
    doBarrel = cms.bool(True),
    doEndcaps = cms.bool(True),
    useDBStatus = cms.bool(True),
    clusSeedThr = cms.double(0.5)
)


process.hltStoppedHSCPIterativeCone5CaloJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    subtractorName = cms.string(''),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('CaloJet'),
    MinVtxNdof = cms.int32(5),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    MaxVtxZ = cms.double(15.0),
    rParam = cms.double(0.5),
    UseOnlyVertexTracks = cms.bool(False),
    UseOnlyOnePV = cms.bool(False),
    DzTrVtxMax = cms.double(0.0),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("hltStoppedHSCPTowerMakerForAll"),
    sumRecHits = cms.bool(False),
    inputEtMin = cms.double(0.3),
    srcPVs = cms.InputTag("offlinePrimaryVertices"),
    jetPtMin = cms.double(1.0),
    radiusPU = cms.double(0.5),
    DxyTrVtxMax = cms.double(0.0),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hltStoppedHSCPTowerMakerForAll = cms.EDProducer("CaloTowersCreator",
    EBSumThreshold = cms.double(0.2),
    MomHBDepth = cms.double(0.2),
    EBWeight = cms.double(1.0),
    hfInput = cms.InputTag(""),
    AllowMissingInputs = cms.bool(True),
    UseSymEBTreshold = cms.bool(False),
    HBThreshold = cms.double(0.7),
    EESumThreshold = cms.double(0.45),
    HBGrid = cms.vdouble(),
    HF1Weight = cms.double(1.0),
    MomEEDepth = cms.double(0.0),
    EBThreshold = cms.double(0.07),
    UseEcalRecoveredHits = cms.bool(False),
    MomConstrMethod = cms.int32(1),
    MomHEDepth = cms.double(0.4),
    HcalThreshold = cms.double(-1000.0),
    HF2Weights = cms.vdouble(),
    HOWeights = cms.vdouble(),
    EEGrid = cms.vdouble(),
    HEDWeight = cms.double(1.0),
    EEWeights = cms.vdouble(),
    EEWeight = cms.double(1.0),
    UseHO = cms.bool(False),
    HBWeights = cms.vdouble(),
    HcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HF2Grid = cms.vdouble(),
    HEDWeights = cms.vdouble(),
    HESThreshold = cms.double(0.8),
    HF1Grid = cms.vdouble(),
    EBWeights = cms.vdouble(),
    EcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HESWeight = cms.double(1.0),
    hbheInput = cms.InputTag("hltHbhereco"),
    HF2Weight = cms.double(1.0),
    HF2Threshold = cms.double(0.85),
    HcalAcceptSeverityLevel = cms.uint32(11),
    EEThreshold = cms.double(0.3),
    HOThresholdPlus1 = cms.double(3.5),
    HOThresholdPlus2 = cms.double(3.5),
    HF1Weights = cms.vdouble(),
    hoInput = cms.InputTag(""),
    HF1Threshold = cms.double(0.5),
    HOThresholdMinus1 = cms.double(3.5),
    HESGrid = cms.vdouble(),
    UseRejectedRecoveredEcalHits = cms.bool(False),
    UseEtEETreshold = cms.bool(False),
    HOWeight = cms.double(1e-99),
    HESWeights = cms.vdouble(),
    UseSymEETreshold = cms.bool(False),
    HEDThreshold = cms.double(0.8),
    UseRejectedHitsOnly = cms.bool(False),
    UseEtEBTreshold = cms.bool(False),
    EcutTower = cms.double(-1000.0),
    HEDGrid = cms.vdouble(),
    UseHcalRecoveredHits = cms.bool(False),
    HOThresholdMinus2 = cms.double(3.5),
    HOThreshold0 = cms.double(3.5),
    ecalInputs = cms.VInputTag(),
    UseRejectedRecoveredHcalHits = cms.bool(False),
    MomEBDepth = cms.double(0.3),
    HBWeight = cms.double(1.0),
    EcalAcceptSeverityLevel = cms.uint32(3),
    HOGrid = cms.vdouble(),
    EBGrid = cms.vdouble()
)


process.hltTowerMakerForAll = cms.EDProducer("CaloTowersCreator",
    EBSumThreshold = cms.double(0.2),
    MomHBDepth = cms.double(0.2),
    EBWeight = cms.double(1.0),
    hfInput = cms.InputTag("hltHfreco"),
    AllowMissingInputs = cms.bool(False),
    UseSymEBTreshold = cms.bool(False),
    HBThreshold = cms.double(0.7),
    EESumThreshold = cms.double(0.45),
    HBGrid = cms.vdouble(),
    HF1Weight = cms.double(1.0),
    MomEEDepth = cms.double(0.0),
    EBThreshold = cms.double(0.07),
    UseEcalRecoveredHits = cms.bool(False),
    MomConstrMethod = cms.int32(1),
    MomHEDepth = cms.double(0.4),
    HcalThreshold = cms.double(-1000.0),
    HF2Weights = cms.vdouble(),
    HOWeights = cms.vdouble(),
    EEGrid = cms.vdouble(),
    HEDWeight = cms.double(1.0),
    EEWeights = cms.vdouble(),
    EEWeight = cms.double(1.0),
    UseHO = cms.bool(False),
    HBWeights = cms.vdouble(),
    HcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HF2Grid = cms.vdouble(),
    HEDWeights = cms.vdouble(),
    HESThreshold = cms.double(0.8),
    HF1Grid = cms.vdouble(),
    EBWeights = cms.vdouble(),
    EcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HESWeight = cms.double(1.0),
    hbheInput = cms.InputTag("hltHbhereco"),
    HF2Weight = cms.double(1.0),
    HF2Threshold = cms.double(0.85),
    HcalAcceptSeverityLevel = cms.uint32(11),
    EEThreshold = cms.double(0.3),
    HOThresholdPlus1 = cms.double(3.5),
    HOThresholdPlus2 = cms.double(3.5),
    HF1Weights = cms.vdouble(),
    hoInput = cms.InputTag("hltHoreco"),
    HF1Threshold = cms.double(0.5),
    HOThresholdMinus1 = cms.double(3.5),
    HESGrid = cms.vdouble(),
    UseRejectedRecoveredEcalHits = cms.bool(False),
    UseEtEETreshold = cms.bool(False),
    HOWeight = cms.double(1e-99),
    HESWeights = cms.vdouble(),
    UseSymEETreshold = cms.bool(False),
    HEDThreshold = cms.double(0.8),
    UseRejectedHitsOnly = cms.bool(False),
    UseEtEBTreshold = cms.bool(False),
    EcutTower = cms.double(-1000.0),
    HEDGrid = cms.vdouble(),
    UseHcalRecoveredHits = cms.bool(False),
    HOThresholdMinus2 = cms.double(3.5),
    HOThreshold0 = cms.double(3.5),
    ecalInputs = cms.VInputTag("hltEcalRecHitAll:EcalRecHitsEB", "hltEcalRecHitAll:EcalRecHitsEE"),
    UseRejectedRecoveredHcalHits = cms.bool(False),
    MomEBDepth = cms.double(0.3),
    HBWeight = cms.double(1.0),
    EcalAcceptSeverityLevel = cms.uint32(3),
    HOGrid = cms.vdouble(),
    EBGrid = cms.vdouble()
)


process.hltTowerMakerForHcal = cms.EDProducer("CaloTowersCreator",
    EBSumThreshold = cms.double(0.2),
    MomHBDepth = cms.double(0.2),
    EBWeight = cms.double(1e-99),
    hfInput = cms.InputTag("hltHfreco"),
    AllowMissingInputs = cms.bool(True),
    UseSymEBTreshold = cms.bool(False),
    HBThreshold = cms.double(0.7),
    EESumThreshold = cms.double(0.45),
    HBGrid = cms.vdouble(),
    HF1Weight = cms.double(1.0),
    MomEEDepth = cms.double(0.0),
    EBThreshold = cms.double(0.07),
    UseEcalRecoveredHits = cms.bool(False),
    MomConstrMethod = cms.int32(1),
    MomHEDepth = cms.double(0.4),
    HcalThreshold = cms.double(-1000.0),
    HF2Weights = cms.vdouble(),
    HOWeights = cms.vdouble(),
    EEGrid = cms.vdouble(),
    HEDWeight = cms.double(1.0),
    EEWeights = cms.vdouble(),
    EEWeight = cms.double(1e-99),
    UseHO = cms.bool(False),
    HBWeights = cms.vdouble(),
    HcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HF2Grid = cms.vdouble(),
    HEDWeights = cms.vdouble(),
    HESThreshold = cms.double(0.8),
    HF1Grid = cms.vdouble(),
    EBWeights = cms.vdouble(),
    EcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HESWeight = cms.double(1.0),
    hbheInput = cms.InputTag("hltHbhereco"),
    HF2Weight = cms.double(1.0),
    HF2Threshold = cms.double(0.85),
    HcalAcceptSeverityLevel = cms.uint32(11),
    EEThreshold = cms.double(0.3),
    HOThresholdPlus1 = cms.double(3.5),
    HOThresholdPlus2 = cms.double(3.5),
    HF1Weights = cms.vdouble(),
    hoInput = cms.InputTag("hltHoreco"),
    HF1Threshold = cms.double(0.5),
    HOThresholdMinus1 = cms.double(3.5),
    HESGrid = cms.vdouble(),
    UseRejectedRecoveredEcalHits = cms.bool(False),
    UseEtEETreshold = cms.bool(False),
    HOWeight = cms.double(1e-99),
    HESWeights = cms.vdouble(),
    UseSymEETreshold = cms.bool(False),
    HEDThreshold = cms.double(0.8),
    UseRejectedHitsOnly = cms.bool(False),
    UseEtEBTreshold = cms.bool(False),
    EcutTower = cms.double(-1000.0),
    HEDGrid = cms.vdouble(),
    UseHcalRecoveredHits = cms.bool(False),
    HOThresholdMinus2 = cms.double(3.5),
    HOThreshold0 = cms.double(3.5),
    ecalInputs = cms.VInputTag(),
    UseRejectedRecoveredHcalHits = cms.bool(False),
    MomEBDepth = cms.double(0.3),
    HBWeight = cms.double(1.0),
    EcalAcceptSeverityLevel = cms.uint32(3),
    HOGrid = cms.vdouble(),
    EBGrid = cms.vdouble()
)


process.hltTowerMakerForJets = cms.EDProducer("CaloTowersCreator",
    EBSumThreshold = cms.double(0.2),
    MomHBDepth = cms.double(0.2),
    EBWeight = cms.double(1.0),
    hfInput = cms.InputTag("hltHfreco"),
    AllowMissingInputs = cms.bool(False),
    UseSymEBTreshold = cms.bool(False),
    HBThreshold = cms.double(0.7),
    EESumThreshold = cms.double(0.45),
    HBGrid = cms.vdouble(),
    HF1Weight = cms.double(1.0),
    MomEEDepth = cms.double(0.0),
    EBThreshold = cms.double(0.07),
    UseEcalRecoveredHits = cms.bool(False),
    MomConstrMethod = cms.int32(1),
    MomHEDepth = cms.double(0.4),
    HcalThreshold = cms.double(-1000.0),
    HF2Weights = cms.vdouble(),
    HOWeights = cms.vdouble(),
    EEGrid = cms.vdouble(),
    HEDWeight = cms.double(1.0),
    EEWeights = cms.vdouble(),
    EEWeight = cms.double(1.0),
    UseHO = cms.bool(False),
    HBWeights = cms.vdouble(),
    HcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HF2Grid = cms.vdouble(),
    HEDWeights = cms.vdouble(),
    HESThreshold = cms.double(0.8),
    HF1Grid = cms.vdouble(),
    EBWeights = cms.vdouble(),
    EcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HESWeight = cms.double(1.0),
    hbheInput = cms.InputTag("hltHbhereco"),
    HF2Weight = cms.double(1.0),
    HF2Threshold = cms.double(0.85),
    HcalAcceptSeverityLevel = cms.uint32(11),
    EEThreshold = cms.double(0.3),
    HOThresholdPlus1 = cms.double(3.5),
    HOThresholdPlus2 = cms.double(3.5),
    HF1Weights = cms.vdouble(),
    hoInput = cms.InputTag("hltHoreco"),
    HF1Threshold = cms.double(0.5),
    HOThresholdMinus1 = cms.double(3.5),
    HESGrid = cms.vdouble(),
    UseRejectedRecoveredEcalHits = cms.bool(False),
    UseEtEETreshold = cms.bool(False),
    HOWeight = cms.double(1e-99),
    HESWeights = cms.vdouble(),
    UseSymEETreshold = cms.bool(False),
    HEDThreshold = cms.double(0.8),
    UseRejectedHitsOnly = cms.bool(False),
    UseEtEBTreshold = cms.bool(False),
    EcutTower = cms.double(-1000.0),
    HEDGrid = cms.vdouble(),
    UseHcalRecoveredHits = cms.bool(False),
    HOThresholdMinus2 = cms.double(3.5),
    HOThreshold0 = cms.double(3.5),
    ecalInputs = cms.VInputTag("hltEcalRegionalJetsRecHit:EcalRecHitsEB", "hltEcalRegionalJetsRecHit:EcalRecHitsEE"),
    UseRejectedRecoveredHcalHits = cms.bool(False),
    MomEBDepth = cms.double(0.3),
    HBWeight = cms.double(1.0),
    EcalAcceptSeverityLevel = cms.uint32(3),
    HOGrid = cms.vdouble(),
    EBGrid = cms.vdouble()
)


process.hltTowerMakerForMuons = cms.EDProducer("CaloTowersCreator",
    EBSumThreshold = cms.double(0.2),
    MomHBDepth = cms.double(0.2),
    EBWeight = cms.double(1.0),
    hfInput = cms.InputTag("hltHfreco"),
    AllowMissingInputs = cms.bool(False),
    UseSymEBTreshold = cms.bool(False),
    HBThreshold = cms.double(0.7),
    EESumThreshold = cms.double(0.45),
    HBGrid = cms.vdouble(),
    HF1Weight = cms.double(1.0),
    MomEEDepth = cms.double(0.0),
    EBThreshold = cms.double(0.07),
    UseEcalRecoveredHits = cms.bool(False),
    MomConstrMethod = cms.int32(1),
    MomHEDepth = cms.double(0.4),
    HcalThreshold = cms.double(-1000.0),
    HF2Weights = cms.vdouble(),
    HOWeights = cms.vdouble(),
    EEGrid = cms.vdouble(),
    HEDWeight = cms.double(1.0),
    EEWeights = cms.vdouble(),
    EEWeight = cms.double(1.0),
    UseHO = cms.bool(False),
    HBWeights = cms.vdouble(),
    HcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HF2Grid = cms.vdouble(),
    HEDWeights = cms.vdouble(),
    HESThreshold = cms.double(0.8),
    HF1Grid = cms.vdouble(),
    EBWeights = cms.vdouble(),
    EcalAcceptSeverityLevelForRejectedHit = cms.uint32(9999),
    HESWeight = cms.double(1.0),
    hbheInput = cms.InputTag("hltHbhereco"),
    HF2Weight = cms.double(1.0),
    HF2Threshold = cms.double(0.85),
    HcalAcceptSeverityLevel = cms.uint32(11),
    EEThreshold = cms.double(0.3),
    HOThresholdPlus1 = cms.double(3.5),
    HOThresholdPlus2 = cms.double(3.5),
    HF1Weights = cms.vdouble(),
    hoInput = cms.InputTag("hltHoreco"),
    HF1Threshold = cms.double(0.5),
    HOThresholdMinus1 = cms.double(3.5),
    HESGrid = cms.vdouble(),
    UseRejectedRecoveredEcalHits = cms.bool(False),
    UseEtEETreshold = cms.bool(False),
    HOWeight = cms.double(1e-99),
    HESWeights = cms.vdouble(),
    UseSymEETreshold = cms.bool(False),
    HEDThreshold = cms.double(0.8),
    UseRejectedHitsOnly = cms.bool(False),
    UseEtEBTreshold = cms.bool(False),
    EcutTower = cms.double(-1000.0),
    HEDGrid = cms.vdouble(),
    UseHcalRecoveredHits = cms.bool(False),
    HOThresholdMinus2 = cms.double(3.5),
    HOThreshold0 = cms.double(3.5),
    ecalInputs = cms.VInputTag("hltEcalRegionalMuonsRecHit:EcalRecHitsEB", "hltEcalRegionalMuonsRecHit:EcalRecHitsEE"),
    UseRejectedRecoveredHcalHits = cms.bool(False),
    MomEBDepth = cms.double(0.3),
    HBWeight = cms.double(1.0),
    EcalAcceptSeverityLevel = cms.uint32(3),
    HOGrid = cms.vdouble(),
    EBGrid = cms.vdouble()
)


process.hltTriggerSummaryAOD = cms.EDProducer("TriggerSummaryProducerAOD",
    processName = cms.string('@')
)


process.hltTriggerSummaryRAW = cms.EDProducer("TriggerSummaryProducerRAW",
    processName = cms.string('@')
)


process.hltUnseededR9shape = cms.EDProducer("EgammaHLTR9Producer",
    ecalRechitEE = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE"),
    recoEcalCandidateProducer = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    ecalRechitEB = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB"),
    useSwissCross = cms.bool(False)
)


process.iterativeCone3HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('IterativeCone'),
    rParam = cms.double(0.3)
)


process.iterativeCone4HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('IterativeCone'),
    rParam = cms.double(0.4)
)


process.iterativeCone5GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('IterativeCone'),
    rParam = cms.double(0.5)
)


process.iterativeCone5GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.iterativeCone5GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('IterativeCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.iterativeCone5HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('IterativeCone'),
    rParam = cms.double(0.5)
)


process.iterativeCone7HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('IterativeCone'),
    rParam = cms.double(0.7)
)


process.kt3HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('Kt'),
    rParam = cms.double(0.3)
)


process.kt4GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('Kt'),
    rParam = cms.double(0.4)
)


process.kt4GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('Kt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.4),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.kt4GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('Kt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.4),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.kt4HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('Kt'),
    rParam = cms.double(0.4)
)


process.kt6GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('Kt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJets"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.kt6GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('Kt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.kt6GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('Kt'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.6),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.kt6HiGenJets = cms.EDProducer("SubEventGenJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("hiGenParticlesForJets"),
    doAreaFastjet = cms.bool(True),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('Kt'),
    rParam = cms.double(0.6)
)


process.l1GtEvmPack = cms.EDProducer("L1GTEvmDigiToRaw",
    EvmGtFedId = cms.untracked.int32(812),
    EvmGtInputTag = cms.InputTag("simGtDigis"),
    ActiveBoardsMask = cms.uint32(65535)
)


process.l1GtPack = cms.EDProducer("L1GTDigiToRaw",
    DaqGtFedId = cms.untracked.int32(813),
    DaqGtInputTag = cms.InputTag("simGtDigis"),
    ActiveBoardsMask = cms.uint32(65535),
    MuGmtInputTag = cms.InputTag("simGmtDigis")
)


process.matchVtx = cms.EDProducer("MixEvtVtxGenerator",
    heavyIonLabel = cms.InputTag("generator"),
    signalLabel = cms.InputTag("hiSignal")
)


process.mergedtruth = cms.EDProducer("TrackingTruthProducer",
    vertexDistanceCut = cms.double(0.003),
    simHitCollections = cms.PSet(
        muon = cms.vstring('g4SimHitsMuonDTHits',
            'g4SimHitsMuonCSCHits',
            'g4SimHitsMuonRPCHits'),
        tracker = cms.vstring('g4SimHitsTrackerHitsTIBLowTof',
            'g4SimHitsTrackerHitsTIBHighTof',
            'g4SimHitsTrackerHitsTIDLowTof',
            'g4SimHitsTrackerHitsTIDHighTof',
            'g4SimHitsTrackerHitsTOBLowTof',
            'g4SimHitsTrackerHitsTOBHighTof',
            'g4SimHitsTrackerHitsTECLowTof',
            'g4SimHitsTrackerHitsTECHighTof'),
        pixel = cms.vstring('g4SimHitsTrackerHitsPixelBarrelLowTof',
            'g4SimHitsTrackerHitsPixelBarrelHighTof',
            'g4SimHitsTrackerHitsPixelEndcapLowTof',
            'g4SimHitsTrackerHitsPixelEndcapHighTof')
    ),
    simHitLabel = cms.string('g4SimHits'),
    volumeRadius = cms.double(1200.0),
    removeDeadModules = cms.bool(False),
    mergedBremsstrahlung = cms.bool(True),
    HepMCDataLabels = cms.vstring('VtxSmeared',
        'generator',
        'PythiaSource',
        'source'),
    useMultipleHepMCLabels = cms.bool(False),
    volumeZ = cms.double(3000.0)
)


process.mix = cms.EDProducer("MixingModule",
    mixProdStep1 = cms.bool(False),
    mixProdStep2 = cms.bool(False),
    maxBunch = cms.int32(3),
    useCurrentProcessOnly = cms.bool(False),
    LabelPlayback = cms.string(''),
    minBunch = cms.int32(-2),
    bunchspace = cms.int32(50),
    playback = cms.untracked.bool(False),
    input = cms.SecSource("PoolSource",
        nbPileupEvents = cms.PSet(
            histoFileName = cms.untracked.string('histProbFunction.root'),
            seed = cms.untracked.int32(54321),
            probFunctionVariable = cms.vint32(0, 1, 2, 3, 4,
                5, 6, 7, 8, 9,
                10, 11, 12, 13, 14,
                15, 16, 17, 18, 19,
                20, 21, 22, 23, 24),
            probValue = cms.vdouble(0.0698146584, 0.0698146584, 0.0698146584, 0.0698146584, 0.0698146584,
                0.0698146584, 0.0698146584, 0.0698146584, 0.0698146584, 0.0698146584,
                0.0698146584, 0.0630151648, 0.0526654164, 0.0402754482, 0.0292988928,
                0.0194384503, 0.0122016783, 0.007207042, 0.004003637, 0.0020278322,
                0.0010739954, 0.0004595759, 0.0002229748, 0.0001028162, 4.5833715281e-05)
        ),
        OOT_type = cms.untracked.string('Poisson'),
        fileNames = cms.untracked.vstring('/store/relval/CMSSW_4_2_0_pre4/RelValMinBias/GEN-SIM-DIGI-RAW-HLTDEBUG/MC_42_V1-v1/0001/4C824492-2639-E011-9506-001A928116F0.root',
            '/store/relval/CMSSW_4_2_0_pre4/RelValMinBias/GEN-SIM-DIGI-RAW-HLTDEBUG/MC_42_V1-v1/0000/9ED6309B-C238-E011-A1D6-003048678ADA.root',
            '/store/relval/CMSSW_4_2_0_pre4/RelValMinBias/GEN-SIM-DIGI-RAW-HLTDEBUG/MC_42_V1-v1/0000/487A3591-CA38-E011-92A8-00248C0BE013.root',
            '/store/relval/CMSSW_4_2_0_pre4/RelValMinBias/GEN-SIM-DIGI-RAW-HLTDEBUG/MC_42_V1-v1/0000/0E5A4D31-BD38-E011-93B7-0026189437F2.root'),
        manage_OOT = cms.untracked.bool(True),
        sequential = cms.untracked.bool(False),
        type = cms.string('probFunction'),
        seed = cms.int32(1234567)
    )
,
    mixObjects = cms.PSet(
        mixCH = cms.PSet(
            input = cms.VInputTag(cms.InputTag("g4SimHits","CaloHitsTk"), cms.InputTag("g4SimHits","CastorBU"), cms.InputTag("g4SimHits","CastorFI"), cms.InputTag("g4SimHits","CastorPL"), cms.InputTag("g4SimHits","CastorTU"),
                cms.InputTag("g4SimHits","EcalHitsEB"), cms.InputTag("g4SimHits","EcalHitsEE"), cms.InputTag("g4SimHits","EcalHitsES"), cms.InputTag("g4SimHits","EcalTBH4BeamHits"), cms.InputTag("g4SimHits","HcalHits"),
                cms.InputTag("g4SimHits","HcalTB06BeamHits"), cms.InputTag("g4SimHits","ZDCHITS")),
            type = cms.string('PCaloHit'),
            subdets = cms.vstring('CaloHitsTk',
                'CastorBU',
                'CastorFI',
                'CastorPL',
                'CastorTU',
                'EcalHitsEB',
                'EcalHitsEE',
                'EcalHitsES',
                'EcalTBH4BeamHits',
                'HcalHits',
                'HcalTB06BeamHits',
                'ZDCHITS')
        ),
        mixHepMC = cms.PSet(
            input = cms.VInputTag(cms.InputTag("generator")),
            type = cms.string('HepMCProduct')
        ),
        mixVertices = cms.PSet(
            input = cms.VInputTag(cms.InputTag("g4SimHits")),
            type = cms.string('SimVertex')
        ),
        mixSH = cms.PSet(
            input = cms.VInputTag(cms.InputTag("g4SimHits","BSCHits"), cms.InputTag("g4SimHits","FP420SI"), cms.InputTag("g4SimHits","MuonCSCHits"), cms.InputTag("g4SimHits","MuonDTHits"), cms.InputTag("g4SimHits","MuonRPCHits"),
                cms.InputTag("g4SimHits","TotemHitsRP"), cms.InputTag("g4SimHits","TotemHitsT1"), cms.InputTag("g4SimHits","TotemHitsT2Gem"), cms.InputTag("g4SimHits","TrackerHitsPixelBarrelHighTof"), cms.InputTag("g4SimHits","TrackerHitsPixelBarrelLowTof"),
                cms.InputTag("g4SimHits","TrackerHitsPixelEndcapHighTof"), cms.InputTag("g4SimHits","TrackerHitsPixelEndcapLowTof"), cms.InputTag("g4SimHits","TrackerHitsTECHighTof"), cms.InputTag("g4SimHits","TrackerHitsTECLowTof"), cms.InputTag("g4SimHits","TrackerHitsTIBHighTof"),
                cms.InputTag("g4SimHits","TrackerHitsTIBLowTof"), cms.InputTag("g4SimHits","TrackerHitsTIDHighTof"), cms.InputTag("g4SimHits","TrackerHitsTIDLowTof"), cms.InputTag("g4SimHits","TrackerHitsTOBHighTof"), cms.InputTag("g4SimHits","TrackerHitsTOBLowTof")),
            type = cms.string('PSimHit'),
            subdets = cms.vstring('BSCHits',
                'FP420SI',
                'MuonCSCHits',
                'MuonDTHits',
                'MuonRPCHits',
                'TotemHitsRP',
                'TotemHitsT1',
                'TotemHitsT2Gem',
                'TrackerHitsPixelBarrelHighTof',
                'TrackerHitsPixelBarrelLowTof',
                'TrackerHitsPixelEndcapHighTof',
                'TrackerHitsPixelEndcapLowTof',
                'TrackerHitsTECHighTof',
                'TrackerHitsTECLowTof',
                'TrackerHitsTIBHighTof',
                'TrackerHitsTIBLowTof',
                'TrackerHitsTIDHighTof',
                'TrackerHitsTIDLowTof',
                'TrackerHitsTOBHighTof',
                'TrackerHitsTOBLowTof')
        ),
        mixTracks = cms.PSet(
            input = cms.VInputTag(cms.InputTag("g4SimHits")),
            type = cms.string('SimTrack')
        )
    )
)


process.randomEngineStateProducer = cms.EDProducer("RandomEngineStateProducer")


process.rawDataCollector = cms.EDProducer("RawDataCollectorModule",
    currentProcessOnly = cms.bool(True)
)


process.rpcTriggerDigis = cms.EDProducer("RPCTrigger",
    RPCTriggerDebug = cms.untracked.int32(0),
    label = cms.string('muonRPCDigis')
)


process.rpcpacker = cms.EDProducer("RPCPackingModule",
    InputLabel = cms.InputTag("simMuonRPCDigis")
)


process.siPixelRawData = cms.EDProducer("SiPixelDigiToRaw",
    Timing = cms.untracked.bool(False),
    InputLabel = cms.InputTag("simSiPixelDigis")
)


process.simBscDigis = cms.EDProducer("BSCTrigger",
    theHits = cms.InputTag("mix","g4SimHitsBSCHits"),
    bitNumbers = cms.vuint32(32, 33, 34, 35, 36,
        37, 38, 39, 40, 41,
        42, 43),
    resolution = cms.double(3.0),
    bitNames = cms.vstring('L1Tech_BSC_minBias_inner_threshold1',
        'L1Tech_BSC_minBias_inner_threshold2',
        'L1Tech_BSC_minBias_OR',
        'L1Tech_BSC_HighMultiplicity',
        'L1Tech_BSC_halo_beam2_inner',
        'L1Tech_BSC_halo_beam2_outer',
        'L1Tech_BSC_halo_beam1_inner',
        'L1Tech_BSC_halo_beam1_outer',
        'L1Tech_BSC_minBias_threshold1',
        'L1Tech_BSC_minBias_threshold2',
        'L1Tech_BSC_splash_beam1',
        'L1Tech_BSC_splash_beam2'),
    coincidence = cms.double(72.85)
)


process.simCastorDigis = cms.EDProducer("CastorDigiProducer",
    doNoise = cms.bool(True),
    doTimeSlew = cms.bool(True),
    castor = cms.PSet(
        readoutFrameSize = cms.int32(6),
        binOfMaximum = cms.int32(4),
        samplingFactor = cms.double(16.75),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.double(4.24),
        simHitToPhotoelectrons = cms.double(1000.0),
        syncPhase = cms.bool(True),
        timePhase = cms.double(-4.0)
    )
)


process.simCscTriggerPrimitiveDigis = cms.EDProducer("CSCTriggerPrimitivesProducer",
    clctParamMTCC = cms.PSet(
        clctDriftDelay = cms.uint32(2),
        clctMinSeparation = cms.uint32(10),
        clctPidThreshPretrig = cms.uint32(2),
        clctFifoTbins = cms.uint32(12),
        verbosity = cms.untracked.int32(0),
        clctNplanesHitPretrig = cms.uint32(4),
        clctHitPersist = cms.uint32(6),
        clctFifoPretrig = cms.uint32(7),
        clctNplanesHitPattern = cms.uint32(1)
    ),
    MaxBX = cms.int32(9),
    CSCComparatorDigiProducer = cms.InputTag("simMuonCSCDigis","MuonCSCComparatorDigi"),
    alctParamMTCC = cms.PSet(
        alctAccelMode = cms.uint32(0),
        alctTrigMode = cms.uint32(2),
        verbosity = cms.untracked.int32(0),
        alctL1aWindowWidth = cms.uint32(3),
        alctNplanesHitAccelPretrig = cms.uint32(2),
        alctDriftDelay = cms.uint32(3),
        alctNplanesHitPattern = cms.uint32(4),
        alctNplanesHitAccelPattern = cms.uint32(4),
        alctFifoTbins = cms.uint32(16),
        alctNplanesHitPretrig = cms.uint32(2),
        alctFifoPretrig = cms.uint32(10)
    ),
    clctParamOldMC = cms.PSet(
        clctDriftDelay = cms.uint32(2),
        clctMinSeparation = cms.uint32(10),
        clctPidThreshPretrig = cms.uint32(2),
        clctFifoTbins = cms.uint32(12),
        verbosity = cms.untracked.int32(0),
        clctNplanesHitPretrig = cms.uint32(2),
        clctHitPersist = cms.uint32(6),
        clctFifoPretrig = cms.uint32(7),
        clctNplanesHitPattern = cms.uint32(4)
    ),
    MinBX = cms.int32(3),
    tmbParam = cms.PSet(
        alctTrigEnable = cms.uint32(0),
        verbosity = cms.untracked.int32(0),
        clctTrigEnable = cms.uint32(0),
        tmbL1aWindowSize = cms.uint32(7),
        matchTrigWindowSize = cms.uint32(7),
        mpcBlockMe1a = cms.uint32(0),
        matchTrigEnable = cms.uint32(1)
    ),
    commonParam = cms.PSet(
        isTMB07 = cms.bool(True),
        isMTCC = cms.bool(False)
    ),
    CSCWireDigiProducer = cms.InputTag("simMuonCSCDigis","MuonCSCWireDigi"),
    alctParam07 = cms.PSet(
        alctAccelMode = cms.uint32(0),
        alctTrigMode = cms.uint32(2),
        verbosity = cms.untracked.int32(0),
        alctL1aWindowWidth = cms.uint32(7),
        alctNplanesHitAccelPretrig = cms.uint32(2),
        alctDriftDelay = cms.uint32(2),
        alctNplanesHitPattern = cms.uint32(4),
        alctNplanesHitAccelPattern = cms.uint32(4),
        alctFifoTbins = cms.uint32(16),
        alctNplanesHitPretrig = cms.uint32(2),
        alctFifoPretrig = cms.uint32(10)
    ),
    alctParamOldMC = cms.PSet(
        alctAccelMode = cms.uint32(1),
        alctTrigMode = cms.uint32(3),
        verbosity = cms.untracked.int32(0),
        alctL1aWindowWidth = cms.uint32(5),
        alctNplanesHitAccelPretrig = cms.uint32(2),
        alctDriftDelay = cms.uint32(3),
        alctNplanesHitPattern = cms.uint32(4),
        alctNplanesHitAccelPattern = cms.uint32(4),
        alctFifoTbins = cms.uint32(16),
        alctNplanesHitPretrig = cms.uint32(2),
        alctFifoPretrig = cms.uint32(10)
    ),
    clctParam07 = cms.PSet(
        clctDriftDelay = cms.uint32(2),
        clctMinSeparation = cms.uint32(10),
        clctPidThreshPretrig = cms.uint32(2),
        clctFifoTbins = cms.uint32(12),
        verbosity = cms.untracked.int32(0),
        clctNplanesHitPretrig = cms.uint32(2),
        clctHitPersist = cms.uint32(6),
        clctFifoPretrig = cms.uint32(7),
        clctNplanesHitPattern = cms.uint32(4)
    )
)


process.simCsctfDigis = cms.EDProducer("CSCTFCandidateProducer",
    CSCTrackProducer = cms.untracked.InputTag("simCsctfTrackDigis"),
    MuonSorter = cms.PSet(
        MaxBX = cms.int32(9),
        MinBX = cms.int32(3)
    )
)


process.simCsctfTrackDigis = cms.EDProducer("CSCTFTrackProducer",
    isTMB07 = cms.bool(True),
    useDT = cms.bool(True),
    SectorReceiverInput = cms.untracked.InputTag("simCscTriggerPrimitiveDigis","MPCSORTED"),
    DtDirectProd = cms.untracked.InputTag("csctfunpacker","DT"),
    readDtDirect = cms.bool(False),
    DTproducer = cms.untracked.InputTag("simDtTriggerPrimitiveDigis"),
    SectorProcessor = cms.PSet(
        MaxBX = cms.int32(9),
        MinBX = cms.int32(3),
        maxdphi13_accp = cms.uint32(64),
        SRLUT = cms.PSet(
            UseMiniLUTs = cms.untracked.bool(True),
            ReadLUTs = cms.untracked.bool(False),
            LUTPath = cms.untracked.string('./'),
            Binary = cms.untracked.bool(False)
        ),
        mindphip_halo = cms.uint32(128),
        AllowALCTonly = cms.bool(False),
        PTLUT = cms.PSet(
            LowQualityFlag = cms.untracked.uint32(4),
            ReadPtLUT = cms.bool(False),
            PtMethod = cms.untracked.uint32(26)
        ),
        QualityEnableME1b = cms.uint32(65535),
        QualityEnableME1c = cms.uint32(65535),
        QualityEnableME1a = cms.uint32(65535),
        QualityEnableME1f = cms.uint32(65535),
        QualityEnableME1d = cms.uint32(65535),
        QualityEnableME1e = cms.uint32(65535),
        QualityEnableME3a = cms.uint32(65535),
        QualityEnableME3b = cms.uint32(65535),
        QualityEnableME3c = cms.uint32(65535),
        maxdphi112_accp = cms.uint32(64),
        rescaleSinglesPhi = cms.bool(True),
        mindeta112_accp = cms.uint32(14),
        maxdeta113_accp = cms.uint32(38),
        maxdeta13_accp = cms.uint32(27),
        maxdphi113_accp = cms.uint32(64),
        EtaMin = cms.vuint32(0, 0, 0, 0, 0,
            0, 0, 0),
        mindeta12_accp = cms.uint32(12),
        firmwareSP = cms.uint32(20110204),
        maxdphi12_accp = cms.uint32(64),
        trigger_on_ME1a = cms.bool(False),
        mbbPhiOff = cms.uint32(1982),
        mbaPhiOff = cms.uint32(0),
        EtaMax = cms.vuint32(127, 127, 127, 127, 127,
            24, 24, 127),
        CoreLatency = cms.uint32(7),
        PreTrigger = cms.uint32(2),
        mindetap = cms.uint32(7),
        trigger_on_MB1d = cms.bool(False),
        maxdeta112_accp = cms.uint32(29),
        mindeta13_accp = cms.uint32(13),
        run_core = cms.bool(True),
        firmwareFA = cms.uint32(20091026),
        trigger_on_MB1a = cms.bool(False),
        firmwareDD = cms.uint32(20091026),
        QualityEnableME2c = cms.uint32(65535),
        EtaWindows = cms.vuint32(4, 4, 6, 6, 6,
            6, 6),
        QualityEnableME2a = cms.uint32(65535),
        trigger_on_ME4 = cms.bool(False),
        initializeFromPSet = cms.bool(False),
        maxdeta12_accp = cms.uint32(17),
        QualityEnableME4a = cms.uint32(65535),
        QualityEnableME4c = cms.uint32(65535),
        straightp = cms.uint32(19),
        gangedME1a = cms.untracked.bool(True),
        trigger_on_ME1b = cms.bool(False),
        AllowCLCTonly = cms.bool(False),
        QualityEnableME4b = cms.uint32(65535),
        widePhi = cms.uint32(0),
        mindetap_halo = cms.uint32(8),
        curvedp = cms.uint32(15),
        singlesTrackOutput = cms.uint32(1),
        isCoreVerbose = cms.bool(False),
        mindphip = cms.uint32(180),
        mindeta113_accp = cms.uint32(21),
        kill_fiber = cms.uint32(0),
        firmwareVM = cms.uint32(20091026),
        trigger_on_ME2 = cms.bool(False),
        BXAdepth = cms.uint32(2),
        trigger_on_ME3 = cms.bool(False),
        QualityEnableME2b = cms.uint32(65535)
    )
)


process.simDtTriggerPrimitiveDigis = cms.EDProducer("DTTrigProd",
    lutDumpFlag = cms.untracked.bool(False),
    debug = cms.untracked.bool(False),
    lutBtic = cms.untracked.int32(31),
    digiTag = cms.InputTag("simMuonDTDigis"),
    DTTFSectorNumbering = cms.bool(True)
)


process.simDttfDigis = cms.EDProducer("DTTrackFinder",
    Open_LUTs = cms.untracked.bool(False),
    Extrapolation_nbits_PhiB = cms.untracked.int32(8),
    BX_max = cms.untracked.int32(7),
    BX_min = cms.untracked.int32(-9),
    EtaTrackFinder = cms.untracked.bool(True),
    CSCStub_Source = cms.InputTag("simCsctfTrackDigis"),
    Extrapolation_Filter = cms.untracked.int32(1),
    PT_Assignment_nbits_Phi = cms.untracked.int32(12),
    Overlap = cms.untracked.bool(True),
    PT_Assignment_nbits_PhiB = cms.untracked.int32(10),
    DTDigi_Source = cms.InputTag("simDtTriggerPrimitiveDigis"),
    Extrapolation_21 = cms.untracked.bool(False),
    PHI_Assignment_nbits_PhiB = cms.untracked.int32(10),
    Debug = cms.untracked.int32(0),
    OutOfTime_Filter = cms.untracked.bool(False),
    PHI_Assignment_nbits_Phi = cms.untracked.int32(10),
    Extrapolation_nbits_Phi = cms.untracked.int32(8),
    OutOfTime_Filter_Window = cms.untracked.int32(1)
)


process.simEcalDigis = cms.EDProducer("EcalSelectiveReadoutProducer",
    trigPrimCollection = cms.string(''),
    EESRPdigiCollection = cms.string('eeDigis'),
    dumpFlags = cms.untracked.int32(0),
    EEdigiCollection = cms.string(''),
    EBdigiCollection = cms.string(''),
    produceDigis = cms.untracked.bool(True),
    trigPrimProducer = cms.string('simEcalTriggerPrimitiveDigis'),
    EBSRPdigiCollection = cms.string('ebDigis'),
    defaultTtf = cms.int32(4),
    trigPrimBypassWithPeakFinder = cms.bool(True),
    configFromCondDB = cms.bool(True),
    EESrFlagCollection = cms.string('eeSrFlags'),
    digiProducer = cms.string('simEcalUnsuppressedDigis'),
    writeSrFlags = cms.untracked.bool(True),
    trigPrimBypassMode = cms.int32(0),
    trigPrimBypass = cms.bool(False),
    trigPrimBypassLTH = cms.double(1.0),
    EBSrFlagCollection = cms.string('ebSrFlags'),
    trigPrimBypassHTH = cms.double(1.0)
)


process.simEcalPreshowerDigis = cms.EDProducer("ESZeroSuppressionProducer",
    digiProducer = cms.string('simEcalUnsuppressedDigis'),
    ESdigiCollection = cms.string(''),
    ESZSdigiCollection = cms.string('')
)


process.simEcalTriggerPrimitiveDigis = cms.EDProducer("EcalTrigPrimProducer",
    BarrelOnly = cms.bool(False),
    InstanceEB = cms.string(''),
    InstanceEE = cms.string(''),
    binOfMaximum = cms.int32(6),
    Famos = cms.bool(False),
    TcpOutput = cms.bool(False),
    Debug = cms.bool(False),
    Label = cms.string('simEcalUnsuppressedDigis')
)


process.simEcalUnsuppressedDigis = cms.EDProducer("EcalDigiProducer",
    apdAddToBarrel = cms.bool(False),
    apdDoPEStats = cms.bool(True),
    apdSimToPELow = cms.double(2450000.0),
    apdShapeTau = cms.double(40.5),
    apdSimToPEHigh = cms.double(88200000.0),
    apdDigiTag = cms.string('APD'),
    apdTimeOffset = cms.double(-12.0),
    apdTimeOffWidth = cms.double(0.8),
    apdSeparateDigi = cms.bool(True),
    apdShapeTstart = cms.double(74.5),
    doNoise = cms.bool(True),
    ConstantTerm = cms.double(0.003),
    applyConstantTerm = cms.bool(True),
    cosmicsPhase = cms.bool(False),
    cosmicsShift = cms.double(0.0),
    simHitToPhotoelectronsEndcap = cms.double(1800.0),
    readoutFrameSize = cms.int32(10),
    binOfMaximum = cms.int32(6),
    photoelectronsToAnalogEndcap = cms.double(0.000555555),
    samplingFactor = cms.double(1.0),
    timePhase = cms.double(0.0),
    simHitToPhotoelectronsBarrel = cms.double(2250.0),
    syncPhase = cms.bool(True),
    doPhotostatistics = cms.bool(True),
    photoelectronsToAnalogBarrel = cms.double(0.000444444),
    EBs25notContainment = cms.double(0.97),
    EEs25notContainment = cms.double(0.975),
    doESNoise = cms.bool(True),
    numESdetId = cms.int32(137216),
    doFast = cms.bool(False),
    hitsProducer = cms.string('g4SimHits'),
    EECorrNoiseMatrixG01 = cms.vdouble(1.0, 0.72698, 0.62048, 0.55691, 0.51848,
        0.49147, 0.47813, 0.47007, 0.46621, 0.46265),
    EEdigiCollection = cms.string(''),
    EECorrNoiseMatrixG06 = cms.vdouble(1.0, 0.71217, 0.47464, 0.34056, 0.26282,
        0.20287, 0.17734, 0.16256, 0.15618, 0.14443),
    EBCorrNoiseMatrixG12 = cms.vdouble(1.0, 0.71073, 0.55721, 0.46089, 0.40449,
        0.35931, 0.33924, 0.32439, 0.31581, 0.30481),
    EECorrNoiseMatrixG12 = cms.vdouble(1.0, 0.71373, 0.44825, 0.30152, 0.21609,
        0.14786, 0.11772, 0.10165, 0.09465, 0.08098),
    EBdigiCollection = cms.string(''),
    ESdigiCollection = cms.string(''),
    EBCorrNoiseMatrixG01 = cms.vdouble(1.0, 0.73354, 0.64442, 0.58851, 0.55425,
        0.53082, 0.51916, 0.51097, 0.50732, 0.50409),
    EBCorrNoiseMatrixG06 = cms.vdouble(1.0, 0.70946, 0.58021, 0.49846, 0.45006,
        0.41366, 0.39699, 0.38478, 0.37847, 0.37055)
)


process.simGctDigis = cms.EDProducer("L1GctEmulator",
    useImprovedTauAlgorithm = cms.bool(True),
    ignoreRCTTauVetoBitsForIsolation = cms.bool(False),
    postSamples = cms.uint32(1),
    preSamples = cms.uint32(1),
    inputLabel = cms.InputTag("simRctDigis"),
    writeInternalData = cms.bool(False),
    jetFinderType = cms.string('hardwareJetFinder'),
    hardwareTest = cms.bool(False)
)


process.simGmtDigis = cms.EDProducer("L1MuGlobalMuonTrigger",
    BX_min_readout = cms.int32(-2),
    BX_min = cms.int32(-4),
    CSCCandidates = cms.InputTag("simCsctfDigis","CSC"),
    BX_max = cms.int32(4),
    BX_max_readout = cms.int32(2),
    RPCfCandidates = cms.InputTag("simRpcTriggerDigis","RPCf"),
    Debug = cms.untracked.int32(0),
    RPCbCandidates = cms.InputTag("simRpcTriggerDigis","RPCb"),
    DTCandidates = cms.InputTag("simDttfDigis","DT"),
    WriteLUTsAndRegs = cms.untracked.bool(False),
    SendMipIso = cms.untracked.bool(False),
    MipIsoData = cms.InputTag("simRctDigis")
)


process.simGtDigis = cms.EDProducer("L1GlobalTrigger",
    ProduceL1GtObjectMapRecord = cms.bool(True),
    EmulateBxInEvent = cms.int32(3),
    ProduceL1GtEvmRecord = cms.bool(True),
    ReadTechnicalTriggerRecords = cms.bool(True),
    RecordLength = cms.vint32(3, 0),
    ProduceL1GtDaqRecord = cms.bool(True),
    GmtInputTag = cms.InputTag("simGmtDigis"),
    AlternativeNrBxBoardEvm = cms.uint32(0),
    TechnicalTriggersInputTags = cms.VInputTag(cms.InputTag("simBscDigis"), cms.InputTag("simRpcTechTrigDigis"), cms.InputTag("simHcalTechTrigDigis")),
    CastorInputTag = cms.InputTag("castorL1Digis"),
    GctInputTag = cms.InputTag("simGctDigis"),
    AlternativeNrBxBoardDaq = cms.uint32(0),
    WritePsbL1GtDaqRecord = cms.bool(True),
    BstLengthBytes = cms.int32(-1)
)


process.simHcalDigis = cms.EDProducer("HcalRealisticZS",
    markAndPass = cms.bool(False),
    HBlevel = cms.int32(8),
    HOlevel = cms.int32(8),
    HFlevel = cms.int32(10),
    digiLabel = cms.InputTag("simHcalUnsuppressedDigis"),
    useConfigZSvalues = cms.int32(0),
    HElevel = cms.int32(9),
    mode = cms.int32(0)
)


process.simHcalTTPDigis = cms.EDProducer("HcalTTPDigiProducer",
    HFSoI = cms.int32(4),
    defTT10 = cms.string('hits>=3:hfp>=1:hfm>=1'),
    defTT9 = cms.string('hits>=2:hfp>=1:hfm>=1'),
    defTT8 = cms.string('hits>=2'),
    presamples = cms.int32(2),
    iEtaMin = cms.int32(33),
    fwAlgorithm = cms.int32(1),
    iEtaMax = cms.int32(41),
    defTTLocal = cms.string('hits>=4'),
    samples = cms.int32(5),
    threshold = cms.uint32(2),
    maskedChannels = cms.vuint32(),
    HFDigiCollection = cms.InputTag("simHcalDigis"),
    id = cms.untracked.int32(101)
)


process.simHcalTechTrigDigis = cms.EDProducer("HcalTTPTriggerRecord",
    ttpBitNames = cms.vstring('L1Tech_HCAL_HF_MM_or_PP_or_PM.v0',
        'L1Tech_HCAL_HF_coincidence_PM.v1',
        'L1Tech_HCAL_HF_MMP_or_MPP.v0'),
    ttpDigiCollection = cms.InputTag("simHcalTTPDigis"),
    ttpBits = cms.vuint32(8, 9, 10)
)


process.simHcalTriggerPrimitiveDigis = cms.EDProducer("HcalTrigPrimDigiProducer",
    latency = cms.int32(1),
    ZS_threshold = cms.uint32(1),
    PMTNoiseThreshold = cms.uint32(0),
    MinSignalThreshold = cms.uint32(0),
    inputLabel = cms.VInputTag(cms.InputTag("simHcalUnsuppressedDigis"), cms.InputTag("simHcalUnsuppressedDigis")),
    numberOfPresamples = cms.int32(2),
    numberOfSamples = cms.int32(4),
    weights = cms.vdouble(1.0, 1.0),
    RunZS = cms.untracked.bool(False),
    FG_threshold = cms.uint32(12),
    FrontEndFormatError = cms.untracked.bool(False),
    peakFilter = cms.bool(True)
)


process.simHcalUnsuppressedDigis = cms.EDProducer("HcalDigiProducer",
    HFTuningParameter = cms.double(1.025),
    HETuningParameter = cms.double(0.9),
    doHFWindow = cms.bool(True),
    doNoise = cms.bool(True),
    hb = cms.PSet(
        siPMCells = cms.vint32(),
        readoutFrameSize = cms.int32(10),
        firstRing = cms.int32(1),
        timeSmearing = cms.bool(True),
        binOfMaximum = cms.int32(5),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.vdouble(0.3305, 0.3305, 0.3305, 0.3305, 0.3305,
            0.3305, 0.3305, 0.3305, 0.3305, 0.3305,
            0.3305, 0.3305, 0.3305, 0.3305, 0.3305,
            0.3305),
        simHitToPhotoelectrons = cms.double(2000.0),
        samplingFactors = cms.vdouble(125.44, 125.54, 125.32, 125.13, 124.46,
            125.01, 125.22, 125.48, 124.45, 125.9,
            125.83, 127.01, 126.82, 129.73, 131.83,
            143.52),
        syncPhase = cms.bool(True),
        timePhase = cms.double(5.0)
    ),
    useOldHO = cms.bool(True),
    useOldHE = cms.bool(True),
    hoHamamatsu = cms.PSet(
        readoutFrameSize = cms.int32(10),
        firstRing = cms.int32(1),
        timeSmearing = cms.bool(False),
        siPMCode = cms.int32(2),
        timePhase = cms.double(5.0),
        simHitToPhotoelectrons = cms.double(4000.0),
        binOfMaximum = cms.int32(5),
        photoelectronsToAnalog = cms.vdouble(3.0, 3.0, 3.0, 3.0, 3.0,
            3.0, 3.0, 3.0, 3.0, 3.0,
            3.0, 3.0, 3.0, 3.0, 3.0,
            3.0),
        samplingFactors = cms.vdouble(231.0, 231.0, 231.0, 231.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0),
        syncPhase = cms.bool(True),
        doPhotoStatistics = cms.bool(True),
        pixels = cms.int32(960)
    ),
    useOldHF = cms.bool(True),
    injectTestHits = cms.bool(False),
    useOldHB = cms.bool(True),
    doEmpty = cms.bool(True),
    hf1 = cms.PSet(
        readoutFrameSize = cms.int32(10),
        binOfMaximum = cms.int32(5),
        samplingFactor = cms.double(0.383),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.double(2.79),
        simHitToPhotoelectrons = cms.double(6.0),
        syncPhase = cms.bool(True),
        timePhase = cms.double(9.0)
    ),
    hf2 = cms.PSet(
        readoutFrameSize = cms.int32(10),
        binOfMaximum = cms.int32(5),
        samplingFactor = cms.double(0.368),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.double(1.843),
        simHitToPhotoelectrons = cms.double(6.0),
        syncPhase = cms.bool(True),
        timePhase = cms.double(9.0)
    ),
    HBTuningParameter = cms.double(0.875),
    doThermalNoise = cms.bool(True),
    hoZecotek = cms.PSet(
        readoutFrameSize = cms.int32(10),
        firstRing = cms.int32(1),
        timeSmearing = cms.bool(False),
        siPMCode = cms.int32(2),
        timePhase = cms.double(5.0),
        simHitToPhotoelectrons = cms.double(4000.0),
        binOfMaximum = cms.int32(5),
        photoelectronsToAnalog = cms.vdouble(3.0, 3.0, 3.0, 3.0, 3.0,
            3.0, 3.0, 3.0, 3.0, 3.0,
            3.0, 3.0, 3.0, 3.0, 3.0,
            3.0),
        samplingFactors = cms.vdouble(231.0, 231.0, 231.0, 231.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0),
        syncPhase = cms.bool(True),
        doPhotoStatistics = cms.bool(True),
        pixels = cms.int32(36000)
    ),
    hitsProducer = cms.string('g4SimHits'),
    doTimeSlew = cms.bool(True),
    ho = cms.PSet(
        readoutFrameSize = cms.int32(10),
        firstRing = cms.int32(1),
        timeSmearing = cms.bool(False),
        siPMCode = cms.int32(2),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.vdouble(0.24, 0.24, 0.24, 0.24, 0.17,
            0.17, 0.17, 0.17, 0.17, 0.17,
            0.17, 0.17, 0.17, 0.17, 0.17),
        binOfMaximum = cms.int32(5),
        simHitToPhotoelectrons = cms.double(4000.0),
        samplingFactors = cms.vdouble(231.0, 231.0, 231.0, 231.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0,
            360.0, 360.0, 360.0, 360.0, 360.0),
        syncPhase = cms.bool(True),
        timePhase = cms.double(5.0)
    ),
    HOTuningParameter = cms.double(1),
    doIonFeedback = cms.bool(True),
    he = cms.PSet(
        readoutFrameSize = cms.int32(10),
        firstRing = cms.int32(16),
        timeSmearing = cms.bool(True),
        binOfMaximum = cms.int32(5),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.vdouble(0.3305, 0.3305, 0.3305, 0.3305, 0.3305,
            0.3305, 0.3305, 0.3305, 0.3305, 0.3305,
            0.3305, 0.3305, 0.3305, 0.3305),
        simHitToPhotoelectrons = cms.double(2000.0),
        samplingFactors = cms.vdouble(210.55, 197.93, 186.12, 189.64, 189.63,
            190.28, 189.61, 189.6, 190.12, 191.22,
            190.9, 193.06, 188.42, 188.42),
        syncPhase = cms.bool(True),
        timePhase = cms.double(5.0)
    ),
    doHPDNoise = cms.bool(False),
    zdc = cms.PSet(
        readoutFrameSize = cms.int32(10),
        binOfMaximum = cms.int32(5),
        samplingFactor = cms.double(1.0),
        doPhotoStatistics = cms.bool(True),
        photoelectronsToAnalog = cms.double(1.843),
        simHitToPhotoelectrons = cms.double(6.0),
        syncPhase = cms.bool(True),
        timePhase = cms.double(-4.0)
    )
)


process.simMuonCSCDigis = cms.EDProducer("CSCDigiProducer",
    digitizeBadChambers = cms.bool(False),
    wires = cms.PSet(
        signalStopTime = cms.double(300.0),
        signalStartTime = cms.double(-200.0),
        peakTimeSigma = cms.double(0.0),
        shapingTime = cms.int32(30),
        readBadChannels = cms.bool(False),
        timeBitForBxZero = cms.int32(6),
        signalSpeed = cms.vdouble(0.0, -700, 900, 160, 146,
            148, 117, 131, 107, 123,
            123),
        samplingTime = cms.double(5.0),
        bunchTimingOffsets = cms.vdouble(0.0, 23.0, 23.0, 31.0, 31.0,
            31.0, 31.0, 31.0, 31.0, 31.0,
            31.0),
        tailShaping = cms.int32(2),
        timingCalibrationError = cms.vdouble(0.0, 6.2, 6.2, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0),
        doNoise = cms.bool(True)
    ),
    layersNeeded = cms.uint32(3),
    doNeutrons = cms.bool(False),
    strips = cms.PSet(
        CSCUseTimingCorrections = cms.bool(False),
        peakTimeSigma = cms.double(3.0),
        timeBitForBxZero = cms.int32(6),
        signalSpeed = cms.vdouble(0.0, -78, -76, -188, -262,
            -97, -99, -90, -99, -99,
            -113),
        samplingTime = cms.double(25.0),
        tailShaping = cms.int32(2),
        doCrosstalk = cms.bool(True),
        timingCalibrationError = cms.vdouble(0.0, 4.2, 4.2, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0),
        pedestal = cms.double(600.0),
        gainsConstant = cms.double(0.27),
        signalStartTime = cms.double(-250.0),
        shapingTime = cms.int32(100),
        comparatorTimeOffset = cms.double(15.0),
        readBadChambers = cms.bool(True),
        bunchTimingOffsets = cms.vdouble(0.0, 27.53, 23.83, 57.13, 49.2,
            55.18, 52.78, 54.38, 52.95, 53.48,
            53.03),
        comparatorTimeBinOffset = cms.double(3.0),
        comparatorSamplingTime = cms.double(25.0),
        scaPeakBin = cms.int32(5),
        pedestalSigma = cms.double(1.5),
        signalStopTime = cms.double(500.0),
        scaTimingOffsets = cms.vdouble(0.0, 10.0, 10.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0,
            0.0),
        readBadChannels = cms.bool(False),
        gain = cms.double(2.0),
        capacativeCrosstalk = cms.double(35.0),
        doNoise = cms.bool(True),
        resistiveCrosstalkScaling = cms.double(1.8),
        me11gain = cms.double(4.0),
        doSuppression = cms.bool(False),
        nScaBins = cms.int32(8),
        ampGainSigma = cms.double(0.03),
        doCorrelatedNoise = cms.bool(True)
    ),
    GeometryType = cms.string('idealForDigi'),
    InputCollection = cms.string('g4SimHitsMuonCSCHits'),
    stripConditions = cms.string('Database')
)


process.simMuonDTDigis = cms.EDProducer("DTDigitizer",
    vPropWire = cms.double(24.4),
    SyncName = cms.string('DTDigiSyncTOFCorr'),
    MultipleLinks = cms.bool(True),
    IdealModelConstantDriftVelocity = cms.double(0.0055),
    interpolate = cms.bool(True),
    Smearing = cms.double(2.4),
    deadTime = cms.double(150.0),
    InputCollection = cms.string('g4SimHitsMuonDTHits'),
    debug = cms.untracked.bool(False),
    pset = cms.PSet(
        TOFCorrection = cms.int32(3),
        offset = cms.double(500.0)
    ),
    IdealModel = cms.bool(False),
    LinksTimeWindow = cms.double(10.0),
    GeometryType = cms.string('idealForDigi'),
    onlyMuHits = cms.bool(False)
)


process.simMuonRPCDigis = cms.EDProducer("RPCDigiProducer",
    digiModel = cms.string('RPCSimAverageNoiseEffCls'),
    Signal = cms.bool(True),
    Noise = cms.bool(True),
    digiModelConfig = cms.PSet(
        signalPropagationSpeed = cms.double(0.66),
        Frate = cms.double(1.0),
        timingRPCOffset = cms.double(50.0),
        printOutDigitizer = cms.bool(False),
        cosmics = cms.bool(False),
        deltatimeAdjacentStrip = cms.double(3.0),
        linkGateWidth = cms.double(20.0),
        Rate = cms.double(0.0),
        timeResolution = cms.double(2.5),
        averageClusterSize = cms.double(1.5),
        Gate = cms.double(25.0),
        averageEfficiency = cms.double(0.95),
        Nbxing = cms.int32(9),
        timeJitter = cms.double(1.0)
    ),
    InputCollection = cms.string('g4SimHitsMuonRPCHits')
)


process.simRctDigis = cms.EDProducer("L1RCTProducer",
    useDebugTpgScales = cms.bool(False),
    hcalDigis = cms.VInputTag(cms.InputTag("simHcalTriggerPrimitiveDigis")),
    ecalDigis = cms.VInputTag(cms.InputTag("simEcalTriggerPrimitiveDigis")),
    useEcal = cms.bool(True),
    useHcal = cms.bool(True),
    BunchCrossings = cms.vint32(0)
)


process.simRpcTechTrigDigis = cms.EDProducer("RPCTechnicalTrigger",
    BitNumbers = cms.vuint32(24, 25, 26, 27, 28,
        29, 30),
    RPCDigiLabel = cms.InputTag("simMuonRPCDigis"),
    Verbosity = cms.untracked.int32(0),
    UseEventSetup = cms.untracked.int32(0),
    ConfigFile = cms.string('hardware-pseudoconfig.txt'),
    RPCSimLinkInstance = cms.InputTag("RPCDigiSimLink"),
    BitNames = cms.vstring('L1Tech_RPC_TTU_barrel_Cosmics/v0',
        'L1Tech_RPC_TTU_pointing_Cosmics/v0',
        'L1Tech_RPC_TTU_RBplus2_Cosmics/v0',
        'L1Tech_RPC_TTU_RBplus1_Cosmics/v0',
        'L1Tech_RPC_TTU_RB0_Cosmics/v0',
        'L1Tech_RPC_TTU_RBminus1_Cosmics/v0',
        'L1Tech_RPC_TTU_RBminus2_Cosmics/v0'),
    UseRPCSimLink = cms.untracked.int32(0)
)


process.simRpcTriggerDigis = cms.EDProducer("RPCTrigger",
    label = cms.string('simMuonRPCDigis'),
    RPCTriggerDebug = cms.untracked.int32(0)
)


process.simSiPixelDigis = cms.EDProducer("SiPixelDigitizer",
    DeltaProductionCut = cms.double(0.03),
    FPix_SignalResponse_p2 = cms.double(93.6),
    FPix_SignalResponse_p3 = cms.double(134.6),
    FPix_SignalResponse_p0 = cms.double(0.0043),
    FPix_SignalResponse_p1 = cms.double(1.31),
    TofUpperCut = cms.double(12.5),
    AddNoisyPixels = cms.bool(True),
    TanLorentzAnglePerTesla_BPix = cms.double(0.106),
    TofLowerCut = cms.double(-12.5),
    ROUList = cms.vstring('g4SimHitsTrackerHitsPixelBarrelLowTof',
        'g4SimHitsTrackerHitsPixelBarrelHighTof',
        'g4SimHitsTrackerHitsPixelEndcapLowTof',
        'g4SimHitsTrackerHitsPixelEndcapHighTof'),
    AddThresholdSmearing = cms.bool(True),
    useDB = cms.bool(True),
    AdcFullScale = cms.int32(255),
    AddNoise = cms.bool(True),
    killModules = cms.bool(True),
    DeadModules = cms.VPSet(),
    TanLorentzAnglePerTesla_FPix = cms.double(0.106),
    Alpha2Order = cms.bool(True),
    AddPixelInefficiency = cms.int32(0),
    LorentzAngle_DB = cms.bool(True),
    BPix_SignalResponse_p2 = cms.double(97.4),
    BPix_SignalResponse_p3 = cms.double(126.5),
    BPix_SignalResponse_p0 = cms.double(0.0035),
    BPix_SignalResponse_p1 = cms.double(1.23),
    ReadoutNoiseInElec = cms.double(350.0),
    DeadModules_DB = cms.bool(True),
    GainSmearing = cms.double(0.0),
    OffsetSmearing = cms.double(0.0),
    NoiseInElectrons = cms.double(175.0),
    ChargeVCALSmearing = cms.bool(True),
    ElectronsPerVcal = cms.double(65.5),
    MissCalibrate = cms.bool(True),
    ThresholdInElectrons_BPix = cms.double(3500.0),
    ThresholdInElectrons_FPix = cms.double(3000.0),
    ElectronsPerVcal_Offset = cms.double(-414.0),
    ThresholdSmearing_FPix = cms.double(210.0),
    ElectronPerAdc = cms.double(135.0),
    GeometryType = cms.string('idealForDigi'),
    ThresholdSmearing_BPix = cms.double(245.0)
)


process.simSiStripDigis = cms.EDProducer("SiStripDigitizer",
    CouplingConstantPeakIB1 = cms.vdouble(0.9006, 0.0497),
    TOFCutForPeak = cms.double(100.0),
    DeltaProductionCut = cms.double(0.120425),
    RealPedestals = cms.bool(True),
    Temperature = cms.double(273.0),
    CouplingConstantPeakOB1 = cms.vdouble(0.8542, 0.0729),
    DepletionVoltage = cms.double(170.0),
    CouplingConstantDecW2b = cms.vdouble(0.888, 0.05, 0.006),
    CouplingConstantPeakIB2 = cms.vdouble(0.9342, 0.0328),
    CouplingConstantDecW2a = cms.vdouble(0.7962, 0.0914, 0.0104),
    BaselineShift = cms.bool(True),
    SingleStripNoise = cms.bool(True),
    CouplingConstantDecOB1 = cms.vdouble(0.6871, 0.1222, 0.0342),
    GeometryType = cms.string('idealForDigi'),
    CouplingConstantPeakOB2 = cms.vdouble(0.8719, 0.064),
    CouplingConstantPeakW2b = cms.vdouble(0.998, 0.001),
    Inefficiency = cms.double(0.0),
    CouplingConstantPeakW2a = cms.vdouble(1.0, 0.0),
    ZeroSuppression = cms.bool(True),
    cmnRMStec = cms.double(2.44),
    CouplingConstantDecIB2 = cms.vdouble(0.83, 0.0756, 0.0094),
    Noise = cms.bool(True),
    CouplingConstantPeakW6 = cms.vdouble(0.972, 0.014),
    noDiffusion = cms.bool(False),
    LandauFluctuations = cms.bool(True),
    FedAlgorithm = cms.int32(4),
    ChargeDistributionRMS = cms.double(6.5e-10),
    DigiModeList = cms.PSet(
        SCDigi = cms.string('ScopeMode'),
        ZSDigi = cms.string('ZeroSuppressed'),
        PRDigi = cms.string('ProcessedRaw'),
        VRDigi = cms.string('VirginRaw')
    ),
    Gain = cms.string(''),
    CouplingConstantDecW1a = cms.vdouble(0.786, 0.093, 0.014),
    APVSaturationProb = cms.double(0.001),
    electronPerAdcPeak = cms.double(262.0),
    CouplingConstantDecW6 = cms.vdouble(0.758, 0.093, 0.026),
    CouplingConstantDecW5 = cms.vdouble(0.7565, 0.0913, 0.0304),
    CouplingConstantDecW4 = cms.vdouble(0.876, 0.06, 0.002),
    CouplingConstantDecW1b = cms.vdouble(0.822, 0.08, 0.009),
    PedestalsOffset = cms.double(128),
    ROUList = cms.vstring('g4SimHitsTrackerHitsTIBLowTof',
        'g4SimHitsTrackerHitsTIBHighTof',
        'g4SimHitsTrackerHitsTIDLowTof',
        'g4SimHitsTrackerHitsTIDHighTof',
        'g4SimHitsTrackerHitsTOBLowTof',
        'g4SimHitsTrackerHitsTOBHighTof',
        'g4SimHitsTrackerHitsTECLowTof',
        'g4SimHitsTrackerHitsTECHighTof'),
    CouplingConstantDecIB1 = cms.vdouble(0.7748, 0.0962, 0.0165),
    GevPerElectron = cms.double(3.61e-09),
    CouplingConstantDecW3a = cms.vdouble(0.8164, 0.09, 0.0018),
    chargeDivisionsPerStrip = cms.int32(10),
    TOFCutForDeconvolution = cms.double(50.0),
    CouplingConstantPeakW3a = cms.vdouble(0.996, 0.002),
    CouplingConstantDecW7 = cms.vdouble(0.7828, 0.0862, 0.0224),
    cmnRMStid = cms.double(3.08),
    CouplingConstantPeakW3b = cms.vdouble(0.992, 0.004),
    AppliedVoltage = cms.double(300.0),
    CouplingConstantPeakW1b = cms.vdouble(0.976, 0.012),
    CouplingConstantPeakW1a = cms.vdouble(0.996, 0.002),
    NoiseSigmaThreshold = cms.double(2.0),
    CouplingConstantDecW3b = cms.vdouble(0.848, 0.06, 0.016),
    APVSaturationFromHIP = cms.bool(True),
    TrackerConfigurationFromDB = cms.bool(False),
    APVpeakmode = cms.bool(False),
    CosmicDelayShift = cms.untracked.double(0.0),
    cmnRMStob = cms.double(1.08),
    CouplingConstantPeakW7 = cms.vdouble(0.964, 0.018),
    LorentzAngle = cms.string(''),
    CouplingConstantPeakW5 = cms.vdouble(0.968, 0.016),
    CouplingConstantPeakW4 = cms.vdouble(0.992, 0.004),
    electronPerAdcDec = cms.double(247.0),
    cmnRMStib = cms.double(5.92),
    ChargeMobility = cms.double(310.0),
    CouplingConstantDecOB2 = cms.vdouble(0.725, 0.1102, 0.0273),
    CommonModeNoise = cms.bool(True)
)


process.sisCone5GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    src = cms.InputTag("genParticlesForJets"),
    doAreaFastjet = cms.bool(False),
    doPVCorrection = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    doRhoFastjet = cms.bool(False),
    srcPVs = cms.InputTag(""),
    inputEtMin = cms.double(0.0),
    nSigmaPU = cms.double(1.0),
    radiusPU = cms.double(0.5),
    Rho_EtaMax = cms.double(4.5),
    GhostArea = cms.double(0.01),
    jetPtMin = cms.double(3.0),
    jetType = cms.string('GenJet'),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0),
    maxRecoveredHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    maxProblematicEcalCells = cms.uint32(9999999),
    maxBadHcalCells = cms.uint32(9999999),
    maxBadEcalCells = cms.uint32(9999999),
    maxProblematicHcalCells = cms.uint32(9999999),
    jetAlgorithm = cms.string('SISCone'),
    rParam = cms.double(0.5)
)


process.sisCone5GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('SISCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.sisCone5GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('SISCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.5),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.sisCone7GenJets = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('SISCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJets"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.sisCone7GenJetsNoMuNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('SISCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoMuNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.sisCone7GenJetsNoNu = cms.EDProducer("FastjetJetProducer",
    Active_Area_Repeats = cms.int32(5),
    doAreaFastjet = cms.bool(False),
    Ghost_EtaMax = cms.double(6.0),
    maxBadHcalCells = cms.uint32(9999999),
    maxRecoveredEcalCells = cms.uint32(9999999),
    jetType = cms.string('GenJet'),
    doRhoFastjet = cms.bool(False),
    jetAlgorithm = cms.string('SISCone'),
    nSigmaPU = cms.double(1.0),
    GhostArea = cms.double(0.01),
    Rho_EtaMax = cms.double(4.5),
    maxBadEcalCells = cms.uint32(9999999),
    doPVCorrection = cms.bool(False),
    maxRecoveredHcalCells = cms.uint32(9999999),
    rParam = cms.double(0.7),
    maxProblematicHcalCells = cms.uint32(9999999),
    src = cms.InputTag("genParticlesForJetsNoNu"),
    inputEtMin = cms.double(0.0),
    srcPVs = cms.InputTag(""),
    jetPtMin = cms.double(3.0),
    radiusPU = cms.double(0.5),
    maxProblematicEcalCells = cms.uint32(9999999),
    doPUOffsetCorr = cms.bool(False),
    inputEMin = cms.double(0.0)
)


process.hlt1HighMult100 = cms.EDFilter("HLTSingleVertexPixelTrackFilter",
    MaxPt = cms.double(10000.0),
    MinPt = cms.double(0.4),
    MaxVz = cms.double(10.0),
    MaxEta = cms.double(2.4),
    trackCollection = cms.InputTag("hltPixelCandsForHighMult"),
    vertexCollection = cms.InputTag("hltPixelVerticesForHighMult"),
    MinTrks = cms.int32(100),
    MinSep = cms.double(0.05)
)


process.hlt1HighMult80 = cms.EDFilter("HLTSingleVertexPixelTrackFilter",
    MaxPt = cms.double(10000.0),
    MinPt = cms.double(0.4),
    MaxVz = cms.double(10.0),
    MaxEta = cms.double(2.4),
    trackCollection = cms.InputTag("hltPixelCandsForHighMult"),
    vertexCollection = cms.InputTag("hltPixelVerticesForHighMult"),
    MinTrks = cms.int32(80),
    MinSep = cms.double(0.05)
)


process.hlt2DisplacedHT250L25Filter = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltDisplacedHT250L25JetTags"),
    MinTag = cms.double(-99999.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(2)
)


process.hlt2DisplacedHT250L3Filter = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltDisplacedHT250L3JetTags"),
    MinTag = cms.double(-99999.0),
    MaxTag = cms.double(2.5),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(2)
)


process.hltAlCaEtaRecHitsFilter = cms.EDFilter("HLTEcalResonanceFilter",
    barrelSelection = cms.PSet(
        massLowPi0Cand = cms.double(0.084),
        selePtGamma = cms.double(1.2),
        seleMinvMaxBarrel = cms.double(0.8),
        selePtPair = cms.double(4.0),
        seleMinvMinBarrel = cms.double(0.3),
        seleS4S9Gamma = cms.double(0.87),
        seleS9S25Gamma = cms.double(0.8),
        seleIso = cms.double(0.5),
        seleBeltDR = cms.double(0.3),
        ptMinForIsolation = cms.double(0.5),
        store5x5RecHitEB = cms.bool(True),
        seleBeltDeta = cms.double(0.1),
        removePi0CandidatesForEta = cms.bool(True),
        barrelHitCollection = cms.string('etaEcalRecHitsEB'),
        massHighPi0Cand = cms.double(0.156)
    ),
    statusLevelRecHitsToUse = cms.int32(1),
    endcapHits = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEE"),
    doSelBarrel = cms.bool(True),
    useRecoFlag = cms.bool(False),
    preshRecHitProducer = cms.InputTag("hltESRegionalPi0EtaRecHit","EcalRecHitsES"),
    doSelEndcap = cms.bool(True),
    endcapClusters = cms.InputTag("hltSimple3x3Clusters","Simple3x3ClustersEndcap"),
    barrelClusters = cms.InputTag("hltSimple3x3Clusters","Simple3x3ClustersBarrel"),
    barrelHits = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEB"),
    flagLevelRecHitsToUse = cms.int32(1),
    storeRecHitES = cms.bool(True),
    debugLevel = cms.int32(0),
    endcapSelection = cms.PSet(
        selePtGammaEndCap_region1 = cms.double(1.0),
        region2_EndCap = cms.double(2.5),
        selePtGammaEndCap_region2 = cms.double(1.0),
        selePtPairEndCap_region3 = cms.double(3.0),
        seleMinvMaxEndCap = cms.double(0.9),
        region1_EndCap = cms.double(2.0),
        selePtGammaEndCap_region3 = cms.double(0.7),
        selePtPairMaxEndCap_region3 = cms.double(9999.0),
        seleMinvMinEndCap = cms.double(0.2),
        seleS4S9GammaEndCap = cms.double(0.9),
        seleS9S25GammaEndCap = cms.double(0.85),
        selePtPairEndCap_region1 = cms.double(3.0),
        seleBeltDREndCap = cms.double(0.3),
        endcapHitCollection = cms.string('etaEcalRecHitsEE'),
        selePtPairEndCap_region2 = cms.double(3.0),
        seleIsoEndCap = cms.double(0.5),
        ptMinForIsolationEndCap = cms.double(0.5),
        seleBeltDetaEndCap = cms.double(0.1),
        store5x5RecHitEE = cms.bool(True)
    ),
    preshowerSelection = cms.PSet(
        preshCalibGamma = cms.double(0.024),
        preshStripEnergyCut = cms.double(0.0),
        debugLevelES = cms.string(''),
        preshCalibPlaneY = cms.double(0.7),
        preshCalibPlaneX = cms.double(1.0),
        preshCalibMIP = cms.double(9e-05),
        ESCollection = cms.string('etaEcalRecHitsES'),
        preshNclust = cms.int32(4),
        preshClusterEnergyCut = cms.double(0.0),
        preshSeededNstrip = cms.int32(15)
    ),
    useDBStatus = cms.bool(True)
)


process.hltAlCaPhiSymStream = cms.EDFilter("HLTEcalPhiSymFilter",
    eCut_endcap = cms.double(0.75),
    endcapHitCollection = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEE"),
    eCut_endcap_high = cms.double(999999.0),
    eCut_barrel = cms.double(0.15),
    eCut_barrel_high = cms.double(999999.0),
    statusThreshold = cms.uint32(3),
    useRecoFlag = cms.bool(False),
    phiSymBarrelHitCollection = cms.string('phiSymEcalRecHitsEB'),
    barrelHitCollection = cms.InputTag("hltEcalRecHitAll","EcalRecHitsEB"),
    phiSymEndcapHitCollection = cms.string('phiSymEcalRecHitsEE')
)


process.hltAlCaPi0RecHitsFilter = cms.EDFilter("HLTEcalResonanceFilter",
    barrelSelection = cms.PSet(
        massLowPi0Cand = cms.double(0.084),
        selePtGamma = cms.double(1.3),
        seleMinvMaxBarrel = cms.double(0.23),
        selePtPair = cms.double(2.6),
        seleMinvMinBarrel = cms.double(0.04),
        seleS4S9Gamma = cms.double(0.83),
        seleS9S25Gamma = cms.double(0.0),
        seleIso = cms.double(0.5),
        seleBeltDR = cms.double(0.2),
        ptMinForIsolation = cms.double(0.5),
        store5x5RecHitEB = cms.bool(False),
        seleBeltDeta = cms.double(0.05),
        removePi0CandidatesForEta = cms.bool(False),
        barrelHitCollection = cms.string('pi0EcalRecHitsEB'),
        massHighPi0Cand = cms.double(0.156)
    ),
    statusLevelRecHitsToUse = cms.int32(1),
    endcapHits = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEE"),
    doSelBarrel = cms.bool(True),
    useRecoFlag = cms.bool(False),
    preshRecHitProducer = cms.InputTag("hltESRegionalPi0EtaRecHit","EcalRecHitsES"),
    doSelEndcap = cms.bool(True),
    endcapClusters = cms.InputTag("hltSimple3x3Clusters","Simple3x3ClustersEndcap"),
    barrelClusters = cms.InputTag("hltSimple3x3Clusters","Simple3x3ClustersBarrel"),
    barrelHits = cms.InputTag("hltEcalRegionalPi0EtaRecHit","EcalRecHitsEB"),
    flagLevelRecHitsToUse = cms.int32(1),
    storeRecHitES = cms.bool(True),
    debugLevel = cms.int32(0),
    endcapSelection = cms.PSet(
        selePtGammaEndCap_region1 = cms.double(0.6),
        region2_EndCap = cms.double(2.5),
        selePtGammaEndCap_region2 = cms.double(0.6),
        selePtPairEndCap_region3 = cms.double(1.0),
        seleMinvMaxEndCap = cms.double(0.3),
        region1_EndCap = cms.double(2.0),
        selePtGammaEndCap_region3 = cms.double(0.5),
        selePtPairMaxEndCap_region3 = cms.double(2.5),
        seleMinvMinEndCap = cms.double(0.05),
        seleS4S9GammaEndCap = cms.double(0.9),
        seleS9S25GammaEndCap = cms.double(0.0),
        selePtPairEndCap_region1 = cms.double(2.5),
        seleBeltDREndCap = cms.double(0.2),
        endcapHitCollection = cms.string('pi0EcalRecHitsEE'),
        selePtPairEndCap_region2 = cms.double(2.5),
        seleIsoEndCap = cms.double(0.5),
        ptMinForIsolationEndCap = cms.double(0.5),
        seleBeltDetaEndCap = cms.double(0.05),
        store5x5RecHitEE = cms.bool(False)
    ),
    preshowerSelection = cms.PSet(
        preshCalibGamma = cms.double(0.024),
        preshStripEnergyCut = cms.double(0.0),
        debugLevelES = cms.string(''),
        preshCalibPlaneY = cms.double(0.7),
        preshCalibPlaneX = cms.double(1.0),
        preshCalibMIP = cms.double(9e-05),
        ESCollection = cms.string('pi0EcalRecHitsES'),
        preshNclust = cms.int32(4),
        preshClusterEnergyCut = cms.double(0.0),
        preshSeededNstrip = cms.int32(15)
    ),
    useDBStatus = cms.bool(True)
)


process.hltAntiKT5CaloJetsEt5 = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltAntiKT5CaloJets"),
    etMin = cms.double(5.0)
)


process.hltAntiKT5L2L3CorrCaloJetsPt60Eta2 = cms.EDFilter("CaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    cut = cms.string('abs(eta)<2 && pt>60 && n90 >= 3 && emEnergyFraction > 0.01 && emEnergyFraction < 0.99')
)


process.hltBDiJet100Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(100.0),
    MinN = cms.int32(2)
)


process.hltBDiJet20Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(2)
)


process.hltBDiJet60Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(60.0),
    MinN = cms.int32(2)
)


process.hltBDiJet80Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(80.0),
    MinN = cms.int32(2)
)


process.hltBJet40Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(1)
)


process.hltBLifetimeL25Filter = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL25BJetTags"),
    MinTag = cms.double(0.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBLifetimeL25FilterEleJetSingleTop = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL25BJetTagsEleJetSingleTop"),
    MinTag = cms.double(0.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBLifetimeL25FilterSingleTop = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL25BJetTagsSingleTop"),
    MinTag = cms.double(0.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBLifetimeL25Jets = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelector4Jets"),
    etMin = cms.double(25.0)
)


process.hltBLifetimeL25JetsEleJetSingleTop = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelectorEleJetsSingleTop"),
    etMin = cms.double(20.0)
)


process.hltBLifetimeL25JetsSingleTop = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelectorJetsSingleTop"),
    etMin = cms.double(20.0)
)


process.hltBLifetimeL3Filter = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL3BJetTags"),
    MinTag = cms.double(2.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBLifetimeL3FilterEleJetSingleTop = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL3BJetTagsEleJetSingleTop"),
    MinTag = cms.double(2.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBLifetimeL3FilterSingleTop = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBLifetimeL3BJetTagsSingleTop"),
    MinTag = cms.double(2.0),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBPTXAntiCoincidence = cms.EDFilter("HLTLevel1Activity",
    technicalBits = cms.uint64(17),
    ignoreL1Mask = cms.bool(True),
    invert = cms.bool(True),
    physicsLoBits = cms.uint64(1),
    physicsHiBits = cms.uint64(0),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    daqPartitions = cms.uint32(1),
    bunchCrossings = cms.vint32(0, 1, -1)
)


process.hltBPTXCoincidence = cms.EDFilter("HLTLevel1Activity",
    technicalBits = cms.uint64(127),
    ignoreL1Mask = cms.bool(True),
    invert = cms.bool(False),
    physicsLoBits = cms.uint64(1),
    physicsHiBits = cms.uint64(0),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    daqPartitions = cms.uint32(1),
    bunchCrossings = cms.vint32(0, -1, 1)
)


process.hltBSoftMuonDiJet100L25FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet100L25BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet100L25Jets = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelector4JetsDiJet100"),
    etMin = cms.double(100.0)
)


process.hltBSoftMuonDiJet100Mu9L3 = cms.EDFilter("RecoTrackRefSelector",
    src = cms.InputTag("hltL3Muons"),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    algorithm = cms.vstring(),
    min3DHit = cms.int32(0),
    maxChi2 = cms.double(10000.0),
    tip = cms.double(120.0),
    minRapidity = cms.double(-5.0),
    lip = cms.double(300.0),
    ptMin = cms.double(9.0),
    maxRapidity = cms.double(5.0),
    quality = cms.vstring(),
    minHit = cms.int32(0)
)


process.hltBSoftMuonDiJet100Mu9SelL3FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet100Mu9SelL3BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet20L25FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet20L25BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet20L25Jets = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelector4JetsDiJet20"),
    etMin = cms.double(20.0)
)


process.hltBSoftMuonDiJet20Mu5L3 = cms.EDFilter("RecoTrackRefSelector",
    src = cms.InputTag("hltL3Muons"),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    algorithm = cms.vstring(),
    min3DHit = cms.int32(0),
    maxChi2 = cms.double(10000.0),
    tip = cms.double(120.0),
    minRapidity = cms.double(-5.0),
    lip = cms.double(300.0),
    ptMin = cms.double(5.0),
    maxRapidity = cms.double(5.0),
    quality = cms.vstring(),
    minHit = cms.int32(0)
)


process.hltBSoftMuonDiJet20Mu5SelL3FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet20Mu5SelL3BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet60L25FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet60L25BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet60L25Jets = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelector4JetsDiJet60"),
    etMin = cms.double(60.0)
)


process.hltBSoftMuonDiJet60Mu7L3 = cms.EDFilter("RecoTrackRefSelector",
    src = cms.InputTag("hltL3Muons"),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    algorithm = cms.vstring(),
    min3DHit = cms.int32(0),
    maxChi2 = cms.double(10000.0),
    tip = cms.double(120.0),
    minRapidity = cms.double(-5.0),
    lip = cms.double(300.0),
    ptMin = cms.double(7.0),
    maxRapidity = cms.double(5.0),
    quality = cms.vstring(),
    minHit = cms.int32(0)
)


process.hltBSoftMuonDiJet60Mu7SelL3FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet60Mu7SelL3BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet80L25FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet80L25BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(False),
    MinJets = cms.int32(1)
)


process.hltBSoftMuonDiJet80L25Jets = cms.EDFilter("EtMinCaloJetSelector",
    filter = cms.bool(False),
    src = cms.InputTag("hltSelector4JetsDiJet80"),
    etMin = cms.double(80.0)
)


process.hltBSoftMuonDiJet80Mu9L3 = cms.EDFilter("RecoTrackRefSelector",
    src = cms.InputTag("hltL3Muons"),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    algorithm = cms.vstring(),
    min3DHit = cms.int32(0),
    maxChi2 = cms.double(10000.0),
    tip = cms.double(120.0),
    minRapidity = cms.double(-5.0),
    lip = cms.double(300.0),
    ptMin = cms.double(9.0),
    maxRapidity = cms.double(5.0),
    quality = cms.vstring(),
    minHit = cms.int32(0)
)


process.hltBSoftMuonDiJet80Mu9SelL3FilterByDR = cms.EDFilter("HLTJetTag",
    JetTag = cms.InputTag("hltBSoftMuonDiJet80Mu9SelL3BJetTagsByDR"),
    MinTag = cms.double(0.5),
    MaxTag = cms.double(99999.0),
    SaveTag = cms.bool(True),
    MinJets = cms.int32(1)
)


process.hltBoolEnd = cms.EDFilter("HLTBool",
    result = cms.bool(True)
)


process.hltBoolFalse = cms.EDFilter("HLTBool",
    result = cms.bool(False)
)


process.hltBoolTrue = cms.EDFilter("HLTBool",
    result = cms.bool(True)
)


process.hltCalibrationEventsFilter = cms.EDFilter("HLTTriggerTypeFilter",
    SelectedTriggerType = cms.int32(2)
)


process.hltCenJet80CentralRegional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(80.0),
    MinN = cms.int32(1)
)


process.hltDTROMonitorFilter = cms.EDFilter("HLTDTROMonitorFilter",
    inputLabel = cms.InputTag("rawDataCollector")
)


process.hltDiJet30Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(2)
)


process.hltDiJet60 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(60.0),
    MinN = cms.int32(2)
)


process.hltDiJetAve100U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(100.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve140U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(140.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve15U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(15.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve180U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(180.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve300U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(300.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve30U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(30.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve50U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(50.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiJetAve70U = cms.EDFilter("HLTDiJetAveFilter",
    inputJetTag = cms.InputTag("hltJetIDPassedAK5Jets"),
    minPtAve = cms.double(70.0),
    minPtJet3 = cms.double(99999.0),
    minDphi = cms.double(-1.0)
)


process.hltDiMuon3L2PreFiltered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1DoubleMuon3L1Filtered0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltDiMuonL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1DoubleMu0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltDiMuonL2PreFiltered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL1Filtered0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltDiMuonL2PreFiltered1 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL1Filtered0"),
    MinPt = cms.double(1.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltDiMuonL2PreFiltered2 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL1Filtered0"),
    MinPt = cms.double(2.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltDiMuonL3PreFiltered2Bs = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered1"),
    MinPt = cms.double(2.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered3Jpsi = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered3LowMass = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered3Quarkonium = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered3Upsilon = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered4 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2DoubleMu3L2Filtered"),
    MinPt = cms.double(4.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered6 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuon3L2PreFiltered0"),
    MinPt = cms.double(6.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDiMuonL3PreFiltered7 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltDiMuon3L2PreFiltered0"),
    MinPt = cms.double(7.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltDoubleEG15EtFilterL1Mu3EG5 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1Mu3EG5"),
    etcutEB = cms.double(15.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(15.0)
)


process.hltDoubleEG8EtFilterL1DoubleEG5HTT50 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1DoubleEG5HTT50"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(8.0)
)


process.hltDoubleEG8EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(8.0)
)


process.hltDoubleEG8NoCandPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandHEFilter")
)


process.hltDoubleIsoEG17EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(17.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(17.0)
)


process.hltDoubleIsoEG18EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(18.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(18.0)
)


process.hltDoubleIsoEG18HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleIsoEG18R9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoubleIsoEG18HELastFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleIsoEG18R9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoubleIsoEG18R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltDoubleIsoEG18EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoubleIsoEG22EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(22.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(22.0)
)


process.hltDoubleIsoEG22R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltDoubleIsoEG22EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoubleIsoEG26EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(26.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(26.0)
)


process.hltDoubleIsoEG26R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltDoubleIsoEG26EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoubleIsoEG33EtFilterUnseededTight = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(33.0),
    ncandcut = cms.int32(2),
    etcutEE = cms.double(33.0)
)


process.hltDoubleJet30ForwardBackward = cms.EDFilter("HLTForwardBackwardJetsFilter",
    maxEta = cms.double(5.1),
    minEta = cms.double(3.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minPt = cms.double(30.0)
)


process.hltDoubleJet60ForwardBackward = cms.EDFilter("HLTForwardBackwardJetsFilter",
    maxEta = cms.double(5.1),
    minEta = cms.double(3.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minPt = cms.double(60.0)
)


process.hltDoubleJet60VeryCentral = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(60.0),
    MinN = cms.int32(2)
)


process.hltDoubleJet70ForwardBackward = cms.EDFilter("HLTForwardBackwardJetsFilter",
    maxEta = cms.double(5.1),
    minEta = cms.double(3.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minPt = cms.double(70.0)
)


process.hltDoubleJet80ForwardBackward = cms.EDFilter("HLTForwardBackwardJetsFilter",
    maxEta = cms.double(5.1),
    minEta = cms.double(3.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minPt = cms.double(80.0)
)


process.hltDoubleMu2BsL3Filtered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered1"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(999.0),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(6.0),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(4.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(4.8)
)


process.hltDoubleMu3JpsiL3Filtered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(999.0),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(4.0),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(0.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(2.5)
)


process.hltDoubleMu3LowMassL3Filtered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(999.0),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(5.0),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(0.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(1.5)
)


process.hltDoubleMu3QuarkoniumL3Filtered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(999.0),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(14.0),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(0.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(1.5)
)


process.hltDoubleMu3UpsilonL3Filtered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltDiMuonL2PreFiltered2"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(999.0),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(11.5),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(0.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(8.5)
)


process.hltDoubleMu4ExclL3PreFiltered = cms.EDFilter("HLTMuonDimuonL3Filter",
    MaxDzMuMu = cms.double(999999.0),
    ChargeOpt = cms.int32(-1),
    SaveTag = cms.untracked.bool(True),
    FastAccept = cms.bool(False),
    MaxDr = cms.double(2.0),
    PreviousCandTag = cms.InputTag("hltL2DoubleMu3L2Filtered"),
    MaxPtBalance = cms.double(999999.0),
    MaxAcop = cms.double(0.3),
    MinPtMin = cms.double(0.0),
    MaxInvMass = cms.double(9999.0),
    MinPtMax = cms.double(0.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    MaxDz = cms.double(9999.0),
    MinPtPair = cms.double(0.0),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MinAcop = cms.double(-999.0),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MinPtBalance = cms.double(-1.0),
    MaxEta = cms.double(2.5),
    MaxRapidityPair = cms.double(999999.0),
    MinInvMass = cms.double(0.0)
)


process.hltDoublePFTauTightIso20Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIsoTrackFinding"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(2)
)


process.hltDoublePFTauTightIso20Track5 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIsoTrackPt5"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(2)
)


process.hltDoublePhoton33EgammaLHEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoublePhoton33EgammaR9ShapeDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoublePhoton33EgammaR9ShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltDoubleIsoEG33EtFilterUnseededTight"),
    nonIsoTag = cms.InputTag("")
)


process.hltDoublePhoton5IsoVLEgammaEcalIsolFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltDoublePhoton5IsoVLEgammaHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltDoublePhoton5IsoVLEgammaHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.15),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoublePhoton5IsoVLEtPhiFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltDoublePhoton5IsoVLEgammaHcalIsolFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltDoublePhoton5IsoVLEgammaEcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltDoublePhoton5IsoVLEgammaTrackIsolFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltDoublePhoton5IsoVLEgammaHcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltDoublePhoton5IsoVLEtPhiFilter = cms.EDFilter("HLTEgammaDoubleEtDeltaPhiFilter",
    minDeltaPhi = cms.double(2.5),
    etcut = cms.double(5.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1DoubleEG2FwdVeto"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate")
)


process.hltDynAlCaDTErrors = cms.EDFilter("HLTDynamicPrescaler")


process.hltEG10CaloIdLClusterShapeFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG10R9ShapeFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG10CaloIdTCaloIsoVLEcalIsolFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG10CaloIdLClusterShapeFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEG10CaloIdTCaloIsoVLHEFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.1),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG10CaloIdTCaloIsoVLEcalIsolFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG10CaloIdTCaloIsoVLHcalIsolFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEG10CaloIdTCaloIsoVLHEFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEG10CaloIdTCaloIsoVLPixelMatchFilterEG5HTT75 = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG10CaloIdTCaloIsoVLHcalIsolFilterEG5HTT75")
)


process.hltEG10CaloIdTClusterShapeFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG10R9ShapeFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG10EtFilterL1EG5HTT75 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1EG5HTT75"),
    etcutEB = cms.double(10.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(10.0)
)


process.hltEG10EtFilterL1Mu3EG5 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1Mu3EG5"),
    etcutEB = cms.double(10.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(10.0)
)


process.hltEG10R9ShapeFilterEG5HTT75 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG10EtFilterL1EG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG125EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(125.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(125.0)
)


process.hltEG15CaloIdTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG15R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG15EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG12"),
    etcutEB = cms.double(15.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(15.0)
)


process.hltEG15R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG15EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG17CaloIdLCaloIsoVLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG17CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEG17CaloIdLCaloIsoVLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG17CaloIdLCaloIsoVLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG17CaloIdLCaloIsoVLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEG17CaloIdLCaloIsoVLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEG17CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG17R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG17EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG12"),
    etcutEB = cms.double(17.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(17.0)
)


process.hltEG17EtFilterL1Mu3EG5 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1Mu3EG5"),
    etcutEB = cms.double(17.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(17.0)
)


process.hltEG17R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG17EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG20CaloIdVLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.04),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.024),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG20R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG20EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG12"),
    etcutEB = cms.double(20.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(20.0)
)


process.hltEG20EtFilterMu3EG5 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1Mu3EG5"),
    etcutEB = cms.double(20.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(20.0)
)


process.hltEG20R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG20EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG20R9ShapeFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG20EtFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG25EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG12"),
    etcutEB = cms.double(25.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(25.0)
)


process.hltEG26CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG26HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG26CaloIdLIsoVLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG26CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEG26CaloIdLIsoVLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEG26CaloIdLIsoVLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEG26CaloIdLIsoVLHcalIsoLastFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.005),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEG26CaloIdLIsoVLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEG26CaloIdLIsoVLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltEG26CaloIdLIsoVLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltEG26EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG12"),
    etcutEB = cms.double(26.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(26.0)
)


process.hltEG26HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG26R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG26R9IdFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.8),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.8),
    lessThan = cms.bool(False),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltL1IsoR9ID"),
    candTag = cms.InputTag("hltEG26HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9ID")
)


process.hltEG26R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG26EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG27EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG15"),
    etcutEB = cms.double(27.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(27.0)
)


process.hltEG30CaloIdVLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.04),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.024),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG30R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG30CaloIdVLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG30CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG30EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG15"),
    etcutEB = cms.double(30.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(30.0)
)


process.hltEG30R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG30EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG32CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG32CaloIdLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG32CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG32R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG32EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(32.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(32.0)
)


process.hltEG32R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG32EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG33EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(33.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(33.0)
)


process.hltEG33HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG33R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG33R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG33EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG36CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG36CaloIdLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG36CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG36R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG36EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(36.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(36.0)
)


process.hltEG36R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG36EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG45EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(45.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(45.0)
)


process.hltEG50CaloIdVLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.04),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.024),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG50R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG50EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(50.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(50.0)
)


process.hltEG50R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG50EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG60CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG60R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG60CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG60CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG60EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(60.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(60.0)
)


process.hltEG60R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG60EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG70CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG70R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG70CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG70CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG70EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(70.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(70.0)
)


process.hltEG70R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG70EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG75CaloIdVLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.04),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.024),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG75R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG75EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(75.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(75.0)
)


process.hltEG75R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG75EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG8CaloIdLClusterShapeFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG8EtFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEG8CaloIdLHEFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG8CaloIdLR9ShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG8CaloIdLPixelMatchFilterMu3EG5 = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG8CaloIdLHEFilterMu3EG5")
)


process.hltEG8CaloIdLR9ShapeFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG8CaloIdLClusterShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG8EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG5"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(8.0)
)


process.hltEG8EtFilterMu3EG5 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1Mu3EG5"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(8.0)
)


process.hltEG8EtFilterUnseeded = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(8.0)
)


process.hltEG8HEFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG8R9ShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEG8PixelMatchFilterMu3EG5 = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG8HEFilterMu3EG5")
)


process.hltEG8R9ShapeFilterMu3EG5 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG8EtFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEG90EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1SingleEG20"),
    etcutEB = cms.double(90.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(90.0)
)


process.hltEGRegionalL1DoubleEG2FwdVeto = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1DoubleEG2FwdVeto"),
    ncandcut = cms.int32(2),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1DoubleEG5HTT50 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1DoubleEG5HTT50"),
    ncandcut = cms.int32(2),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1EG5HTT75 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1EG5HTT75"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1Mu3EG5 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1Mu3EG5"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1SingleEG12 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1SingleEG12"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1SingleEG15 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1SingleEG15"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1SingleEG20 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1SingleEG20"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1SingleEG5 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1SingleEG5"),
    ncandcut = cms.int32(1),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEGRegionalL1TripleEG5 = cms.EDFilter("HLTEgammaL1MatchFilterRegional",
    doIsolated = cms.bool(False),
    endcap_end = cms.double(2.65),
    region_eta_size_ecap = cms.double(1.0),
    barrel_end = cms.double(1.4791),
    l1IsolatedTag = cms.InputTag("hltL1extraParticles","Isolated"),
    candIsolatedTag = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    region_phi_size = cms.double(1.044),
    candNonIsolatedTag = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    region_eta_size = cms.double(0.522),
    L1SeedFilterTag = cms.InputTag("hltL1sL1TripleEG5"),
    ncandcut = cms.int32(3),
    l1NonIsolatedTag = cms.InputTag("hltL1extraParticles","NonIsolated")
)


process.hltEcalActivitySuperClusterWrapper = cms.EDFilter("HLTEgammaTriggerFilterObjectWrapper",
    doIsolated = cms.bool(True),
    candIsolatedTag = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    candNonIsolatedTag = cms.InputTag("none")
)


process.hltEgammaEcalActivityR9ShapeFilterSC7 = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("none"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.98),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltEgammaEcalActivityR9Shape"),
    candTag = cms.InputTag("hltEgammaSelectEcalSuperClustersActivityFilterSC7"),
    nonIsoTag = cms.InputTag("none")
)


process.hltEgammaSelectEcalSuperClustersActivityFilterSC7 = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("none"),
    L1IsoCand = cms.InputTag("none"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(7.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(7.0)
)


process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDetaFilterEG5HTT75 = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLOneOEMinusOneOPFilterEG5HTT75"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDphiFilterEG5HTT75 = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDetaFilterEG5HTT75"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLOneOEMinusOneOPFilterEG5HTT75 = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG10CaloIdTCaloIsoVLPixelMatchFilterEG5HTT75"),
    endcapcut = cms.double(999.9)
)


process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLTrackIsolFilterEG5HTT75 = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.2),
    candTag = cms.InputTag("hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDphiFilterEG5HTT75"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.2)
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTEcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG15CaloIdTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTEcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHcalIsolFilter")
)


process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTTrackIsolFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.075),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDphiFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.125)
)


process.hltEle15CaloIdVTTrkIdTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle15CaloIdVTTrkIdTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle15CaloIdVTTrkIdTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG15CaloIdTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle15CaloIdVTTrkIdTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle15CaloIdVTTrkIdTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle15CaloIdVTTrkIdTHEFilter")
)


process.hltEle17CaloIdIsoEle8CaloIdIsoClusterShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17CaloIdIsoEle8CaloIdIsoEcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle17CaloIdIsoEle8CaloIdIsoClusterShapeDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17CaloIdIsoEle8CaloIdIsoHEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle17CaloIdIsoEle8CaloIdIsoEcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17CaloIdIsoEle8CaloIdIsoHcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle17CaloIdIsoEle8CaloIdIsoHEDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17CaloIdIsoEle8CaloIdIsoPixelMatchDoubleFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltEle17CaloIdIsoEle8CaloIdIsoHcalIsolDoubleFilter")
)


process.hltEle17CaloIdLCaloIsoVLPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG17CaloIdLCaloIsoVLHcalIsoFilter")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG17R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8EcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8EcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8PixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8PMMassFilter = cms.EDFilter("HLTPMMassFilter",
    lowerMassCut = cms.double(30.0),
    L1NonIsoCand = cms.InputTag(""),
    beamSpot = cms.InputTag("hltOnlineBeamSpot"),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    isElectron1 = cms.untracked.bool(False),
    SaveTag = cms.untracked.bool(True),
    isElectron2 = cms.untracked.bool(False),
    upperMassCut = cms.double(999999.0),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEDoubleFilter"),
    nZcandcut = cms.int32(1)
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HcalIsolFilter")
)


process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8TrackIsolFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.05),
    candTag = cms.InputTag("hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DphiFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.05)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG17R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaDoubleFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(True),
    nonIsoTag = cms.InputTag(""),
    L1NonIsoCand = cms.InputTag(""),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hlt3HitElectronActivityDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPDoubleFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hlt3HitElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hlt3HitElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDphiDoubleFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(True),
    nonIsoTag = cms.InputTag(""),
    L1NonIsoCand = cms.InputTag(""),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hlt3HitElectronActivityDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaDoubleFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hlt3HitElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hlt3HitElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPDoubleFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(True),
    electronNonIsolatedProducer = cms.InputTag(""),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchDoubleFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchDoubleFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsolDoubleFilter")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsoFilter")
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoTrackIsolDoubleFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(True),
    nonIsoTag = cms.InputTag(""),
    L1NonIsoCand = cms.InputTag(""),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsActivity"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hlt3HitElectronActivityTrackIsol"),
    thrOverPtEE = cms.double(0.2),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPDoubleFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.2)
)


process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoTrackIsolFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIso3HitElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatch3HitElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1Iso3HitElectronTrackIsol"),
    thrOverPtEE = cms.double(0.2),
    candTag = cms.InputTag("hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.2)
)


process.hltEle25CaloIdVTTrkIdTCentralDiJet30Cleaned = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(2)
)


process.hltEle25CaloIdVTTrkIdTCentralJet30Cleaned = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltEle25CaloIdVTTrkIdTCentralTriJet30Cleaned = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(3)
)


process.hltEle25CaloIdVTTrkIdTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTR9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle25CaloIdVTTrkIdTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle25CaloIdVTTrkIdTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle25CaloIdVTTrkIdTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle25CaloIdVTTrkIdTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle25CaloIdVTTrkIdTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle25CaloIdVTTrkIdTHEFilter")
)


process.hltEle25CaloIdVTTrkIdTR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG25EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(999999.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG27EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTTrackIsoFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.075),
    candTag = cms.InputTag("hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.125)
)


process.hltEle32CaloIdLCaloIsoVLSC17ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG32EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle32CaloIdLCaloIsoVLSC17EcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle32CaloIdLCaloIsoVLSC17ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle32CaloIdLCaloIsoVLSC17HEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleIsoEG17EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle32CaloIdLCaloIsoVLSC17HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle32CaloIdLCaloIsoVLSC17EcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle32CaloIdLCaloIsoVLSC17HcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle32CaloIdLCaloIsoVLSC17HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle32CaloIdLCaloIsoVLSC17PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle32CaloIdLCaloIsoVLSC17HcalIsolFilter")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.125),
    thrRegularEB = cms.double(999999.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG32EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTTrackIsoFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.075),
    candTag = cms.InputTag("hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.125)
)


process.hltEle45CaloIdTTrkIdTDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.008),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.008),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle45CaloIdVTTrkIdTOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle45CaloIdVTTrkIdTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle45CaloIdVTTrkIdTR9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle45CaloIdVTTrkIdTDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.07),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle45CaloIdTTrkIdTDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle45CaloIdVTTrkIdTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle45CaloIdVTTrkIdTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle45CaloIdVTTrkIdTOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle45CaloIdVTTrkIdTPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle45CaloIdVTTrkIdTPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle45CaloIdVTTrkIdTHEFilter")
)


process.hltEle45CaloIdVTTrkIdTR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG45EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEle8CaloIdLCaloIsoVLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle8R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle8CaloIdLCaloIsoVLEcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltEle8CaloIdLCaloIsoVLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLEcalIsolFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle8CaloIdLCaloIsoVLHcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedR9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedEcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedClusterShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedEcalIsolFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedHcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedHEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedHcalIsolFilter")
)


process.hltEle8CaloIdLCaloIsoVLNoL1SeedR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.0),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltEG8EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltEle8CaloIdLCaloIsoVLPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLHcalIsolFilter")
)


process.hltEle8CaloIdLTrkIdVLDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle8CaloIdLTrkIdVLDetaFilterMu3EG5 = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilterRegionalMu3EG5"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle8CaloIdLTrkIdVLDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle8CaloIdLTrkIdVLDphiFilterMu3EG5 = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLDetaFilterMu3EG5"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltEle8CaloIdLTrkIdVLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle8CaloIdLCaloIsoVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilterRegionalMu3EG5 = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEG8CaloIdLPixelMatchFilterMu3EG5"),
    endcapcut = cms.double(999.9)
)


process.hltEle8CaloIdLTrkIdVLPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle8CaloIdLTrkIdVLHEFilter")
)


process.hltEle8HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle8R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle8PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle8HEFilter")
)


process.hltEle8R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG8EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltEle90NoSpikeFilterClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999.0),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(999.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEle90NoSpikeFilterR9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltEle90NoSpikeFilterHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEle90NoSpikeFilterClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltEle90NoSpikeFilterPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltEle90NoSpikeFilterHEFilter")
)


process.hltEle90NoSpikeFilterR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(999999.9),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG90EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltExclDiJet60HFAND = cms.EDFilter("HLTExclDiJetFilter",
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minHFe = cms.double(70.0),
    minPtJet = cms.double(60.0),
    saveTag = cms.untracked.bool(True),
    HF_OR = cms.bool(False)
)


process.hltExclDiJet60HFOR = cms.EDFilter("HLTExclDiJetFilter",
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minHFe = cms.double(70.0),
    minPtJet = cms.double(60.0),
    saveTag = cms.untracked.bool(True),
    HF_OR = cms.bool(True)
)


process.hltFilterDoubleIsoPFTau20Trk5LeadTrack5IsolationL1HLTMatched = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltL1HLTDoubleIsoPFTau20Trk5JetsMatch"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(2)
)


process.hltFilterIsoMu12IsoPFTau10LooseIsolation = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFindingLooseIsolation"),
    MinPt = cms.double(10.0),
    MinN = cms.int32(1)
)


process.hltFilterL2EtCutDoublePFIsoTau20Trk5 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltL2TauJets"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(2)
)


process.hltFilterL2EtCutSingleIsoPFTau35Trk20MET45 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltL2TauJets"),
    MinPt = cms.double(35.0),
    MinN = cms.int32(1)
)


process.hltFilterPFTauTrack5TightIsoL1QuadJet20CentralPFTau40 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltFilterPFTauTrack5TightIsoL1QuadJet20Central"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(1)
)


process.hltFilterSingleIsoPFTau35Trk20LeadTrackPt20 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTauTightIsoTrackPt20"),
    MinPt = cms.double(35.0),
    MinN = cms.int32(1)
)


process.hltFilterSingleIsoPFTau35Trk20MET45LeadTrack20MET45IsolationL1HLTMatched = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltL1HLTSingleIsoPFTau35Trk20Met45JetsMatch"),
    MinPt = cms.double(35.0),
    MinN = cms.int32(1)
)


process.hltHFAsymmetryFilter = cms.EDFilter("HLTHFAsymmetryFilter",
    ECut_HF = cms.double(3.0),
    SS_Asym_min = cms.double(0.8),
    HFHitCollection = cms.InputTag("hltHfreco"),
    OS_Asym_max = cms.double(0.2)
)


process.hltHFEMFilter = cms.EDFilter("HLT1Photon",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltHFRecoEcalCandidate"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1)
)


process.hltHT150 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(150.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT150AlphaT0p6 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.6),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(150.0)
)


process.hltHT150AlphaT0p7 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.7),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(150.0)
)


process.hltHT160 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(160.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT200 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(200.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT200AlphaT0p6 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.6),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(200.0)
)


process.hltHT200AlphaT0p65 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.65),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(200.0)
)


process.hltHT250 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(250.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT250AlphaT0p55 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.55),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(250.0)
)


process.hltHT250AlphaT0p62 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.62),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(250.0)
)


process.hltHT300 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(300.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT300AlphaT0p52 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.52),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(300.0)
)


process.hltHT300AlphaT0p54 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.54),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(300.0)
)


process.hltHT350 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(350.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT350AlphaT0p51 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.51),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(350.0)
)


process.hltHT350AlphaT0p53 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.53),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(350.0)
)


process.hltHT400 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(400.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT400AlphaT0p51 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltJetIDPassedCorrJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(40.0, 40.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.51),
    minNJet = cms.int32(0),
    usePt = cms.bool(False),
    minMht = cms.double(0.0),
    mode = cms.int32(5),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(400.0)
)


process.hltHT450 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(450.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT500 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(500.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHT550 = cms.EDFilter("HLTGlobalSumsMET",
    observable = cms.string('sumEt'),
    MinN = cms.int32(1),
    Min = cms.double(550.0),
    Max = cms.double(-1.0),
    inputTag = cms.InputTag("hltJet40Ht"),
    saveTag = cms.untracked.bool(True)
)


process.hltHcalCalibTypeFilter = cms.EDFilter("HLTHcalCalibTypeFilter",
    InputTag = cms.InputTag("rawDataCollector"),
    CalibTypes = cms.vint32(1, 2, 3, 4, 5,
        6)
)


process.hltHcalTowerFilter = cms.EDFilter("HLTHcalTowerFilter",
    MinE_HB = cms.double(1.5),
    MaxN_HB = cms.int32(2),
    inputTag = cms.InputTag("hltTowerMakerForHcal"),
    MaxN_HE = cms.int32(2),
    MinE_HE = cms.double(2.5),
    MinE_HF = cms.double(9.0),
    MaxN_HF = cms.int32(8)
)


process.hltIsoMu17CenJet40L3Filtered17 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltIsoMu7CenJet40L2IsoFiltered7"),
    MinPt = cms.double(17.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltIsoMu17CenJet40L3IsoFiltered17 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltIsoMu17CenJet40L3Filtered17"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltIsoMu7CenJet40L2IsoFiltered7 = cms.EDFilter("HLTMuonIsoFilter",
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL2MuonIsolations"),
    PreviousCandTag = cms.InputTag("hltL2Muon7"),
    MinN = cms.int32(1),
    CandTag = cms.InputTag("hltL2MuonCandidates")
)


process.hltIsolPixelTrackL2FilterHB = cms.EDFilter("HLTPixelIsolTrackFilter",
    MaxPtNearby = cms.double(2.0),
    MinEtaTrack = cms.double(0.0),
    MinEnergyTrack = cms.double(8.0),
    MinPtTrack = cms.double(3.5),
    DropMultiL2Event = cms.bool(False),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    MinDeltaPtL1Jet = cms.double(-40000.0),
    NMaxTrackCandidates = cms.int32(10),
    MaxEtaTrack = cms.double(1.15),
    candTag = cms.InputTag("hltIsolPixelTrackProdHB"),
    filterTrackEnergy = cms.bool(True)
)


process.hltIsolPixelTrackL2FilterHE = cms.EDFilter("HLTPixelIsolTrackFilter",
    MaxPtNearby = cms.double(2.0),
    MinEtaTrack = cms.double(1.1),
    MinEnergyTrack = cms.double(12.0),
    MinPtTrack = cms.double(3.5),
    DropMultiL2Event = cms.bool(False),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    MinDeltaPtL1Jet = cms.double(-40000.0),
    NMaxTrackCandidates = cms.int32(5),
    MaxEtaTrack = cms.double(2.2),
    candTag = cms.InputTag("hltIsolPixelTrackProdHE"),
    filterTrackEnergy = cms.bool(True)
)


process.hltIsolPixelTrackL3FilterHB = cms.EDFilter("HLTPixelIsolTrackFilter",
    MaxPtNearby = cms.double(2.0),
    MinEtaTrack = cms.double(0.0),
    MinEnergyTrack = cms.double(38.0),
    MinPtTrack = cms.double(20.0),
    DropMultiL2Event = cms.bool(False),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    MinDeltaPtL1Jet = cms.double(4.0),
    NMaxTrackCandidates = cms.int32(999),
    MaxEtaTrack = cms.double(1.15),
    candTag = cms.InputTag("hltHITIPTCorrectorHB"),
    filterTrackEnergy = cms.bool(True)
)


process.hltIsolPixelTrackL3FilterHE = cms.EDFilter("HLTPixelIsolTrackFilter",
    MaxPtNearby = cms.double(2.0),
    MinEtaTrack = cms.double(1.1),
    MinEnergyTrack = cms.double(38.0),
    MinPtTrack = cms.double(20.0),
    DropMultiL2Event = cms.bool(False),
    L1GTSeedLabel = cms.InputTag("hltL1sL1SingleJet52"),
    MinDeltaPtL1Jet = cms.double(4.0),
    NMaxTrackCandidates = cms.int32(999),
    MaxEtaTrack = cms.double(2.2),
    candTag = cms.InputTag("hltHITIPTCorrectorHE"),
    filterTrackEnergy = cms.bool(True)
)


process.hltJet30Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltJet40 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(1)
)


process.hltJet40Ele8CaloIdLCaloIsoVLRemoved = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CaloJetsEle8CaloIdLCaloIsoVLRemoved"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(1)
)


process.hltL1BeamHaloAntiCoincidence3BX = cms.EDFilter("HLTLevel1Activity",
    technicalBits = cms.uint64(0),
    ignoreL1Mask = cms.bool(True),
    invert = cms.bool(True),
    physicsLoBits = cms.uint64(18014398509481984),
    physicsHiBits = cms.uint64(0),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    daqPartitions = cms.uint32(1),
    bunchCrossings = cms.vint32(0, 1, -1)
)


process.hltL1DoubleMu3L1TriMuFiltered3 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1DoubleMu3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(3),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1DoubleMu3L2TriMuFiltered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1DoubleMu3L1TriMuFiltered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(3),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1DoubleMu3L3TriMuFiltered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1DoubleMu3L2TriMuFiltered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(3),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1DoubleMuon3L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1DoubleMu3"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1DoubleMuon3L1Filtered3 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1DoubleMu3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1EventNumberNZS = cms.EDFilter("HLTL1NumberFilter",
    invert = cms.bool(False),
    period = cms.uint32(4096),
    rawInput = cms.InputTag("rawDataCollector")
)


process.hltL1Mu0HTT50L1DiMuFiltered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu0HTT50"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu0HTT50L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu0HTT50"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu0HTT50L1MuFiltered3 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu0HTT50"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu0HTT50L1MuFiltered5 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu0HTT50"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu0HTT50L2DiMuFiltered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L1DiMuFiltered0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu0HTT50L2Filtered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L1Filtered0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu0HTT50L2MuFiltered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L1MuFiltered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu0HTT50L2MuFiltered5 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L1MuFiltered5"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu0HTT50L3DiMuFiltered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L2DiMuFiltered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu0HTT50L3Filtered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L2Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu0HTT50L3MuFiltered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L2MuFiltered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu0HTT50L3MuFiltered8 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu0HTT50L2MuFiltered5"),
    MinPt = cms.double(8.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3EG5L1DiMuFiltered3 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3EG5"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu3EG5L1Filtered12 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3EG5"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu3EG5L1Filtered3 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3EG5"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu3EG5L1Filtered5 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3EG5"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu3EG5L2DiMuFiltered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L1DiMuFiltered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu3EG5L2Filtered12 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L1Filtered12"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu3EG5L2Filtered5 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L1Filtered5"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL1Mu3EG5L3DiMuFiltered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L2DiMuFiltered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3EG5L3Filtered10 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L2Filtered5"),
    MinPt = cms.double(10.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3EG5L3Filtered15 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L2Filtered5"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3EG5L3Filtered17 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L2Filtered12"),
    MinPt = cms.double(17.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3EG5L3Filtered8 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L2Filtered5"),
    MinPt = cms.double(8.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL1Mu3Jet20L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3Jet20Central"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1Mu7CenJetL1MuFiltered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu7"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1MuORL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMuOpenCandidate"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1MuOpenL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMuOpen"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1MuOpenL1FilteredDT = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMuOpen"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(1.25),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1NonIsoHLT2CaloIdLTripleElectronEt10HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoTripleElectronEt10PixelMatchFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLT2CaloIdLTripleElectronEt10HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10EleIdDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLT2LegEleIdTripleElectronEt10OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10EleIdDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLT2LegEleIdTripleElectronEt10EleIdDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLT2LegEleIdTripleElectronEt10ClusterShapeFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(3),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoTripleElectronEt10PixelMatchFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10EleIdDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(3),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLT3LegEleIdTripleElectronEt10OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10EleIdDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(3),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLT3LegEleIdTripleElectronEt10EleIdDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(3),
    candTag = cms.InputTag("hltL1NonIsoHLT3LegEleIdTripleElectronEt10ClusterShapeFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterL1DoubleEG5HTT50"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLDoubleEle8HTT50R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLDoubleEle8HTT50HEFilter")
)


process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLDoubleEle8HTT50ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltL1NonIsoHLTCaloIdLMu10Ele10ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu10Ele10R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLTCaloIdLMu17Ele8ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG8R9ShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLTCaloIdLMu8Ele17ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu8Ele17R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoSingleEle8NoCandR9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLSingleEle8NoCandClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltActivityPhotonHcalForHE")
)


process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLSingleEle8NoCandHEFilter")
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50DetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50DphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50DetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLDoubleEle8HTT50PixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronActivityDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronActivityDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronActivityDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronActivityDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsActivity"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsActivity"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLSingleEle8NoCandPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterL1DoubleEG5HTT50"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.1),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTDoubleEle8HTT50R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTDoubleEle8HTT50HEFilter")
)


process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTDoubleEle8HTT50ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoSingleEle8NoCandR9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.075),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.1),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTSingleEle8NoCandClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltActivityPhotonHcalForHE")
)


process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandPixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(True),
    L1IsoPixelSeedsTag = cms.InputTag("hltActivityStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag(""),
    L1NonIsoPixelSeedsTag = cms.InputTag(""),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTSingleEle8NoCandHEFilter")
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50DetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50DphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50DetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(2),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTDoubleEle8HTT50PixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandDetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronActivityDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronActivityDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandDphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronActivityDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsActivity"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronActivityDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandDetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsActivity"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsActivity"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdTSingleEle8NoCandPixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG10CaloIdTCaloIsoVLEcalIsolFilterEG5HTT75"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HcalIsolFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.2),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.2),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HcalIsolFilter")
)


process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLSingleElectronEt10HT200OneOEMinusOneOPFilter = cms.EDFilter("HLTElectronOneOEMinusOneOPFilterRegional",
    doIsolated = cms.bool(False),
    electronNonIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    barrelcut = cms.double(999.9),
    electronIsolatedProducer = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200PixelMatchFilter"),
    endcapcut = cms.double(999.9)
)


process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DetaFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Deta"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.01),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.01),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Deta"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLSingleElectronEt10HT200OneOEMinusOneOPFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DphiFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltElectronL1NonIsoDetaDphi","Dphi"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    thrRegularEB = cms.double(0.15),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltElectronL1IsoDetaDphi","Dphi"),
    thrOverPtEE = cms.double(-1.0),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DetaFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(-1.0)
)


process.hltL1NonIsoHLTCaloIsolLTrkIsolLSingleElectronEt10HT200TrackIsolFilter = cms.EDFilter("HLTElectronGenericFilter",
    doIsolated = cms.bool(False),
    nonIsoTag = cms.InputTag("hltL1NonIsoElectronTrackIsol"),
    L1NonIsoCand = cms.InputTag("hltPixelMatchElectronsL1NonIso"),
    thrRegularEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltPixelMatchElectronsL1Iso"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoElectronTrackIsol"),
    thrOverPtEE = cms.double(0.2),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DphiFilter"),
    thrTimesPtEE = cms.double(-1.0),
    thrTimesPtEB = cms.double(-1.0),
    thrOverPtEB = cms.double(0.2)
)


process.hltL1NonIsoHLTNonIsoMu10Ele10HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLMu10Ele10ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTNonIsoMu10Ele10PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu10Ele10HEFilter")
)


process.hltL1NonIsoHLTNonIsoMu10Ele10R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG10EtFilterL1Mu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltL1NonIsoHLTNonIsoMu17Ele8HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLMu17Ele8ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTNonIsoMu17Ele8PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu17Ele8HEFilter")
)


process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(True),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandR9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltDoubleEG8EtFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltL1NonIsoHLTNonIsoMu8Ele17HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTCaloIdLMu8Ele17ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTNonIsoMu8Ele17PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(1),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoMu8Ele17HEFilter")
)


process.hltL1NonIsoHLTNonIsoMu8Ele17R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltEG17EtFilterL1Mu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltL1NonIsoHLTNonIsoSingleEle8NoCandEtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    inputTag = cms.InputTag("hltEcalActivitySuperClusterWrapper"),
    etcutEB = cms.double(8.0),
    ncandcut = cms.int32(1),
    etcutEE = cms.double(8.0)
)


process.hltL1NonIsoHLTNonIsoSingleEle8NoCandR9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltUnseededR9shape"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoSingleEle8NoCandEtFilter"),
    nonIsoTag = cms.InputTag("hltUnseededR9shape")
)


process.hltL1NonIsoHLTNonIsoTripleElectronEt10HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(3),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoTripleElectronEt10R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltL1NonIsoHLTNonIsoTripleElectronEt10PixelMatchFilter = cms.EDFilter("HLTElectronPixelMatchFilter",
    doIsolated = cms.bool(False),
    L1IsoPixelSeedsTag = cms.InputTag("hltL1IsoStartUpElectronPixelSeeds"),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1NonIsoPixelSeedsTag = cms.InputTag("hltL1NonIsoStartUpElectronPixelSeeds"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    npixelmatchcut = cms.double(1.0),
    ncandcut = cms.int32(3),
    candTag = cms.InputTag("hltL1NonIsoHLTNonIsoTripleElectronEt10HEFilter")
)


process.hltL1NonIsoHLTNonIsoTripleElectronEt10R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(3),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltTripleEG10EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltL1SingleMu10L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu10"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1SingleMu12L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu12"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1SingleMu20L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu20"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1SingleMu3EG5L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1Mu3EG5"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1SingleMu3L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu3"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1SingleMu7L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu7"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltL1TechBSChalo = cms.EDFilter("TriggerResultsFilter",
    l1tIgnoreMask = cms.bool(False),
    l1tResults = cms.InputTag("hltGtDigis"),
    l1techIgnorePrescales = cms.bool(True),
    hltResults = cms.InputTag(""),
    triggerConditions = cms.vstring('L1Tech_BSC_halo_beam2_inner',
        'L1Tech_BSC_halo_beam2_outer',
        'L1Tech_BSC_halo_beam1_inner',
        'L1Tech_BSC_halo_beam1_outer'),
    throw = cms.bool(True),
    daqPartitions = cms.uint32(1)
)


process.hltL1TechBSCminBiasthreshold1 = cms.EDFilter("TriggerResultsFilter",
    l1tIgnoreMask = cms.bool(False),
    l1tResults = cms.InputTag("hltGtDigis"),
    l1techIgnorePrescales = cms.bool(True),
    hltResults = cms.InputTag(""),
    triggerConditions = cms.vstring('L1Tech_BSC_minBias_threshold1'),
    throw = cms.bool(True),
    daqPartitions = cms.uint32(1)
)


process.hltL1TechCASTORHaloMuon = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('55'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(True)
)


process.hltL1sAlCaEcalPi0Eta = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleEG10 OR L1_DoubleEG2_FwdVeto OR L1_DoubleEG3 OR L1_DoubleEG5 OR L1_DoubleEG5_HTT50 OR L1_DoubleEG5_HTT75 OR L1_DoubleEG8 OR L1_DoubleEG_12_5 OR L1_DoubleForJet32_EtaOpp OR L1_DoubleForJet44_EtaOpp OR L1_DoubleIsoEG10 OR L1_DoubleJet36_Central OR L1_DoubleJet52 OR L1_EG5_HTT100 OR L1_EG5_HTT125 OR L1_EG5_HTT75 OR L1_SingleEG12 OR L1_SingleEG12_Eta2p17 OR L1_SingleEG15 OR L1_SingleEG20 OR L1_SingleEG30 OR L1_SingleEG5 OR L1_SingleIsoEG12 OR L1_SingleIsoEG12_Eta2p17 OR L1_SingleJet128 OR L1_SingleJet16 OR L1_SingleJet36 OR L1_SingleJet36_FwdVeto OR L1_SingleJet52 OR L1_SingleJet68 OR L1_SingleJet80_Central OR L1_SingleJet92 OR L1_TripleEG5 OR L1_TripleEG7 OR L1_TripleJet28_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sAlCaRPC = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu7 OR L1_SingleMu10 OR L1_SingleMu12 OR L1_SingleMu16 OR L1_SingleMu20'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sDoubleIsoTau20Trk5 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleTauJet28 OR L1_DoubleJet52'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sETT220 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_ETT220'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sGlobalRunHPDNoise = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet20_NotBptxOR_NotMuBeamHalo'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sHcalNZS = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet16 OR L1_SingleJet36 OR L1_SingleJet52 OR L1_SingleJet68 OR L1_SingleJet92 OR L1_SingleJet128 OR L1_SingleTauJet52 OR L1_SingleTauJet68 OR L1_SingleMu3 OR L1_SingleMu7 OR L1_SingleMu10 OR L1_SingleMu12 OR L1_SingleMu16 OR L1_SingleMu20 OR L1_SingleIsoEG12 OR L1_SingleEG5 OR L1_SingleEG12 OR L1_SingleEG15 OR L1_SingleEG20 OR L1_SingleEG30 OR L1_ZeroBias'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sHcalPhiSym = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleEG10 OR L1_DoubleEG2_FwdVeto OR L1_DoubleEG3 OR L1_DoubleEG5 OR L1_DoubleEG8 OR L1_DoubleEG_12_5 OR L1_DoubleIsoEG10 OR L1_SingleEG12 OR L1_SingleEG12_Eta2p17 OR L1_SingleEG15 OR L1_SingleEG20 OR L1_SingleEG30 OR L1_SingleEG5 OR L1_SingleIsoEG12 OR L1_SingleIsoEG12_Eta2p17 OR L1_SingleMu7 OR L1_SingleMu10 OR L1_SingleMu12 OR L1_SingleMu16 OR L1_SingleMu20 OR L1_SingleMu3 OR L1_SingleMu25 OR L1_DoubleMu0 OR L1_DoubleMu3 OR L1_DoubleMu5'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1BeamGasBsc = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_BeamGas_Bsc'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1BeamGasHf = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_BeamGas_Hf'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1BeamHalo = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_BeamHalo'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1BscMinBiasORBptxPlusANDMinus = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_BscMinBiasOR_BptxPlusANDMinus'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleEG2FwdVeto = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleEG2_FwdVeto'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleEG5HTT50 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleEG5_HTT50'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleForJet32EtaOpp = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleForJet32_EtaOpp'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleForJet44EtaOpp = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleForJet44_EtaOpp'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleJet36Central = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleJet36_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleMu0 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleMu0'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1DoubleMu3 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_DoubleMu3'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1EG5HTT75 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_EG5_HTT75'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1ETM20 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_ETM20'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1ETM30 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_ETM30'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1HTT100 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_HTT100'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1HTT50 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_HTT50'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1HTT75 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_HTT75'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1InterbunchBsc = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_InterBunch_Bsc'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1Mu0HTT50 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_Mu0_HTT50'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1Mu3EG5 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_Mu3_EG5'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1Mu3Jet16Central = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_Mu3_Jet16_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1Mu3Jet20Central = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_Mu3_Jet20_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1Mu3Jet28Central = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_Mu3_Jet28_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1PreCollisions = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_PreCollisions'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1QuadJet20Central = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_QuadJet20_Central'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleEG12 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleEG12'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleEG15 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleEG15'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleEG20 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleEG20'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleEG5 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleEG5'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet16 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet16'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet20NoBPTX = cms.EDFilter("HLTLevel1GTSeed",
    saveTags = cms.untracked.bool(False),
    L1SeedsLogicalExpression = cms.string('L1_SingleJet20_NotBptxOR'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(1),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet20NoBPTXNoHalo = cms.EDFilter("HLTLevel1GTSeed",
    saveTags = cms.untracked.bool(False),
    L1SeedsLogicalExpression = cms.string('L1_SingleJet20_NotBptxOR_NotMuBeamHalo'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(1),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet36 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet36'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet36FwdVeto = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet36_FwdVeto'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet52 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet52'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet68 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet68'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleJet92 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleJet92'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu10 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu10'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu12 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu12'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu20 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu20'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu3 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu3'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu5BQ7 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu5_Eta1p5_Q80'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMu7 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMu7'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMuOpen = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMuOpen'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1SingleMuOpenCandidate = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleMuOpen'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(False),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(1),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sL1TripleEG5 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_TripleEG5'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sSingleIsoTau35Trk20MET45 = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('L1_SingleTauJet52 OR L1_SingleJet68'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(False)
)


process.hltL1sTechTrigHCALNoise = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('11 OR 12'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(True)
)


process.hltL1sTrackerCosmics = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('25'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(True)
)


process.hltL1sZeroBias = cms.EDFilter("HLTLevel1GTSeed",
    L1SeedsLogicalExpression = cms.string('4'),
    L1MuonCollectionTag = cms.InputTag("hltL1extraParticles"),
    L1UseL1TriggerObjectMaps = cms.bool(True),
    L1UseAliasesForSeeding = cms.bool(True),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    L1CollectionsTag = cms.InputTag("hltL1extraParticles"),
    L1NrBxInEvent = cms.int32(3),
    L1GtObjectMapTag = cms.InputTag("hltL1GtObjectMap"),
    L1TechTriggerSeeding = cms.bool(True)
)


process.hltL2DoubleMu23NoVertexL2PreFiltered = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1DoubleMuon3L1Filtered0"),
    MinPt = cms.double(23.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(3.0),
    MinNhits = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidatesNoVtx"),
    MaxDr = cms.double(9999.0)
)


process.hltL2DoubleMu3L2Filtered = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1DoubleMuon3L1Filtered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(3.0),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu10L2Filtered10 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu10L1Filtered0"),
    MinPt = cms.double(10.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu12L2Filtered12 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu12L1Filtered0"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu20L2Filtered20 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu12L1Filtered0"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu3EG5L2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3EG5L1Filtered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu3L2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu3L1Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu7L2Filtered7 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu7L1Filtered0"),
    MinPt = cms.double(7.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Mu8Jet20L2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu3Jet20L1Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL2Muon7 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1Mu7CenJetL1MuFiltered0"),
    MinPt = cms.double(7.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltL3Mu8Jet20L3Filtered8 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu8Jet20L2Filtered3"),
    MinPt = cms.double(8.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL3Muon15 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu10L2Filtered10"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltL3Muon17 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Muon7"),
    MinPt = cms.double(17.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltLaserAlignmentEventFilter = cms.EDFilter("LaserAlignmentEventFilter",
    FED_IDs = cms.vint32(260, 261, 262, 263, 264,
        265, 266, 267, 269, 270,
        273, 274, 277, 278, 281,
        282, 284, 285, 288, 289,
        292, 293, 294, 295, 300,
        301, 304, 305, 308, 309,
        310, 311, 316, 317, 324,
        325, 329, 330, 331, 332,
        339, 340, 341, 342, 349,
        350, 351, 352, 164, 165,
        172, 173, 177, 178, 179,
        180, 187, 188, 189, 190,
        197, 198, 199, 200, 204,
        205, 208, 209, 212, 213,
        214, 215, 220, 221, 224,
        225, 228, 229, 230, 231,
        236, 237, 238, 239, 240,
        241, 242, 243, 245, 246,
        249, 250, 253, 254, 257,
        258, 478, 476, 477, 482,
        484, 480, 481, 474, 459,
        460, 461, 463, 485, 487,
        488, 489, 118, 119, 120,
        121, 122, 123, 124, 125,
        126, 127, 128, 129, 130,
        131, 132, 133, 288, 289,
        292, 293, 300, 301, 304,
        305, 310, 311, 316, 317,
        329, 330, 339, 340, 341,
        342, 349, 350, 164, 165,
        177, 178, 179, 180, 189,
        190, 197, 198, 204, 205,
        212, 213, 220, 221, 224,
        225, 230, 231),
    SINGLE_CHANNEL_THRESH = cms.uint32(11),
    FedInputTag = cms.InputTag("rawDataCollector"),
    CHANNEL_COUNT_THRESH = cms.uint32(8),
    SIGNAL_Filter = cms.bool(True),
    SIGNAL_IDs = cms.vint32(470389128, 470389384, 470389640, 470389896, 470390152,
        470390408, 470390664, 470390920, 470389192, 470389448,
        470389704, 470389960, 470390216, 470390472, 470390728,
        470390984, 470126984, 470127240, 470127496, 470127752,
        470128008, 470128264, 470128520, 470128776, 470127048,
        470127304, 470127560, 470127816, 470128072, 470128328,
        470128584, 470128840, 436232506, 436232826, 436233146,
        436233466, 369174604, 369174812, 369175068, 369175292,
        470307468, 470307716, 470308236, 470308748, 470308996,
        470045316, 470045580, 470046084, 470046596, 470046860)
)


process.hltLogMonitorFilter = cms.EDFilter("HLTLogMonitorFilter",
    default_threshold = cms.uint32(10),
    categories = cms.VPSet()
)


process.hltMET100 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(100.0),
    MinN = cms.int32(1)
)


process.hltMET120 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(120.0),
    MinN = cms.int32(1)
)


process.hltMET160 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(160.0),
    MinN = cms.int32(1)
)


process.hltMET200 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(200.0),
    MinN = cms.int32(1)
)


process.hltMET65 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(65.0),
    MinN = cms.int32(1)
)


process.hltMET80 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(80.0),
    MinN = cms.int32(1)
)


process.hltMHT30 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(30.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(30.0),
    mode = cms.int32(1),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMHT50 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(30.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(50.0),
    mode = cms.int32(1),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMHT60 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(30.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(60.0),
    mode = cms.int32(1),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMHT75 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(30.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(75.0),
    mode = cms.int32(1),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMR100 = cms.EDFilter("HLTRFilter",
    acceptNJ = cms.bool(True),
    doRPrime = cms.bool(False),
    inputTag = cms.InputTag("hltRHemisphere"),
    inputMetTag = cms.InputTag("hltMet"),
    minMR = cms.double(100.0),
    minR = cms.double(0.0)
)


process.hltMeff440 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(440.0),
    minPtJet = cms.vdouble(40.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(0.0),
    mode = cms.int32(2),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMeff520 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(520.0),
    minPtJet = cms.vdouble(40.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(0.0),
    mode = cms.int32(2),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMeff640 = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minMeff = cms.double(640.0),
    minPtJet = cms.vdouble(40.0, 30.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(0),
    usePt = cms.bool(True),
    minMht = cms.double(0.0),
    mode = cms.int32(2),
    etaJet = cms.vdouble(3.0, 3.0),
    minHt = cms.double(0.0)
)


process.hltMet45 = cms.EDFilter("HLT1CaloMET",
    MaxEta = cms.double(-1.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltMet"),
    MinPt = cms.double(45.0),
    MinN = cms.int32(1)
)


process.hltMu15DiPhoton15CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltMu15DiPhoton15R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltMu15DiPhoton15CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltMu15DiPhoton15CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltMu15DiPhoton15R9ShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(999999.9),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.98),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltL1IsoR9shape"),
    candTag = cms.InputTag("hltDoubleEG15EtFilterL1Mu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9shape")
)


process.hltMu15Photon20CaloIdLClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG20R9ShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltMu15Photon20CaloIdLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltMu15Photon20CaloIdLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltMu3EG5L3Filtered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu3EG5L2Filtered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu3Track2JpsiPixelMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu3TrackJpsiL3Filtered3"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiPixelTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(2.0),
    MaxDzMuonTrack = cms.double(999.0),
    MaxMasses = cms.vdouble(4.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(False),
    MinMasses = cms.vdouble(2.1),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(3),
    MinTrackP = cms.double(1.5),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu3Track3JpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu3Track2JpsiPixelMassFiltered"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiCtfTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(3.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(3.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.7),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.0),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu3TrackJpsiL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu3"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltMu3TrackJpsiL2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltMu3TrackJpsiL1Filtered0"),
    MinPt = cms.double(2.5),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltMu3TrackJpsiL3Filtered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu3TrackJpsiL2Filtered3"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu5L2Mu0L3Filtered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5L2Mu2L2PreFiltered0"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu5L2Mu2JpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5L2Mu2L3Filtered5"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltL2MuonCandidates"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(999999999.0),
    MinTrackPt = cms.double(2.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(4.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(1.8),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(2),
    MinTrackP = cms.double(0.0),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu5L2Mu2L1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1DoubleMu0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(2),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltMu5L2Mu2L2PreFiltered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5L2Mu2L1Filtered0"),
    MinPt = cms.double(2.0),
    MinN = cms.int32(2),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltMu5L2Mu2L3Filtered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5L2Mu2L2PreFiltered0"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu5NoVertexL3PreFiltered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleL2MuORL2PreFilteredNoVtx"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(6),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidatesNoVtx"),
    MaxDr = cms.double(9999.0)
)


process.hltMu5TkMuJpsiTkMuMassFilteredTight = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5TkMuJpsiTrackMassFiltered"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTkMuJpsiTrackerMuonCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(0.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(4.1),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.5),
    CutCowboys = cms.bool(True),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.7),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu5TkMuJpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiPixelMassFilteredEta15"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiCtfTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(0.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(4.1),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.5),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.7),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu5Track1JpsiPixelMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL3Filtered3"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiPixelTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(999999999.0),
    MinTrackPt = cms.double(1.0),
    MaxDzMuonTrack = cms.double(999.0),
    MaxMasses = cms.vdouble(4.6),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.0),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(3),
    MinTrackP = cms.double(1.0),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu5Track2JpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5Track1JpsiPixelMassFiltered"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiCtfTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(2.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(3.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.7),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.0),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu5TrackJpsiL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu3"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltMu5TrackJpsiL1Filtered0Eta15 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu5BQ7"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(1.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltMu5TrackJpsiL2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL1Filtered0"),
    MinPt = cms.double(4.5),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltMu5TrackJpsiL2Filtered5Eta15 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL1Filtered0Eta15"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(1.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltMu5TrackJpsiL3Filtered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL2Filtered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu5TrackJpsiL3Filtered5Eta15 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL2Filtered5Eta15"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(1.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltMu5TrackJpsiPixelMassFilteredEta15 = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu5TrackJpsiL3Filtered5Eta15"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiPixelTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(0.0),
    MaxDzMuonTrack = cms.double(999.0),
    MaxMasses = cms.vdouble(4.6),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(False),
    MinMasses = cms.vdouble(2.0),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(3),
    MinTrackP = cms.double(2.5),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu7Track4JpsiPixelMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu7TrackJpsiL3Filtered3"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiPixelTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(4.0),
    MaxDzMuonTrack = cms.double(999.0),
    MaxMasses = cms.vdouble(4.6),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(False),
    MinMasses = cms.vdouble(2.0),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(3),
    MinTrackP = cms.double(2.5),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu7Track5JpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu7Track4JpsiPixelMassFiltered"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiCtfTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(5.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(3.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.7),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.7),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu7Track6JpsiPixelMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu7TrackJpsiL3Filtered3"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiPixelTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(6.0),
    MaxDzMuonTrack = cms.double(999.0),
    MaxMasses = cms.vdouble(4.6),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(False),
    MinMasses = cms.vdouble(2.0),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(3),
    MinTrackP = cms.double(3.0),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu7Track7JpsiTrackMassFiltered = cms.EDFilter("HLTMuonTrackMassFilter",
    MaxTrackDxy = cms.double(999.0),
    PreviousCandTag = cms.InputTag("hltMu7Track6JpsiPixelMassFiltered"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    TrackTag = cms.InputTag("hltMuTrackJpsiCtfTrackCands"),
    MaxTrackDz = cms.double(999.0),
    MaxTrackNormChi2 = cms.double(10000000000.0),
    MinTrackPt = cms.double(7.0),
    MaxDzMuonTrack = cms.double(0.5),
    MaxMasses = cms.vdouble(3.5),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    SaveTag = cms.untracked.bool(True),
    checkCharge = cms.bool(True),
    MinMasses = cms.vdouble(2.7),
    CutCowboys = cms.bool(False),
    MinTrackHits = cms.int32(5),
    MinTrackP = cms.double(2.7),
    MaxTrackEta = cms.double(999.0)
)


process.hltMu7TrackJpsiL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMu7"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltMu7TrackJpsiL2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltMu7TrackJpsiL1Filtered0"),
    MinPt = cms.double(6.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltMu7TrackJpsiL3Filtered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltMu7TrackJpsiL2Filtered3"),
    MinPt = cms.double(7.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltOverlapFilterEle15CaloJet5 = cms.EDFilter("HLT2ElectronTau",
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(99999.0),
    inputTag1 = cms.InputTag("hltEle15CaloIdVTTrkIdTDphiFilter"),
    inputTag2 = cms.InputTag("hltTauJet5"),
    MaxDphi = cms.double(9999.0),
    MaxDeta = cms.double(9999.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterEle15IsoPFTau15 = cms.EDFilter("HLT2ElectronTau",
    saveTags = cms.untracked.bool(True),
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(1000.0),
    inputTag1 = cms.InputTag("hltEle15CaloIdVTTrkIdTDphiFilter"),
    inputTag2 = cms.InputTag("hltPFTau15TrackLooseIso"),
    MaxDphi = cms.double(1000.0),
    MaxDeta = cms.double(1000.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterIsoEle15CaloJet5 = cms.EDFilter("HLT2ElectronTau",
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(99999.0),
    inputTag1 = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTTrackIsolFilter"),
    inputTag2 = cms.InputTag("hltTauJet5"),
    MaxDphi = cms.double(9999.0),
    MaxDeta = cms.double(9999.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterIsoEle15IsoPFTau15 = cms.EDFilter("HLT2ElectronTau",
    saveTags = cms.untracked.bool(True),
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(1000.0),
    inputTag1 = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTTrackIsolFilter"),
    inputTag2 = cms.InputTag("hltPFTau15TrackLooseIso"),
    MaxDphi = cms.double(1000.0),
    MaxDeta = cms.double(1000.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterIsoEle15IsoPFTau20 = cms.EDFilter("HLT2ElectronTau",
    saveTags = cms.untracked.bool(True),
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(1000.0),
    inputTag1 = cms.InputTag("hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTTrackIsolFilter"),
    inputTag2 = cms.InputTag("hltPFTau20TrackLooseIso"),
    MaxDphi = cms.double(1000.0),
    MaxDeta = cms.double(1000.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterIsoMu12IsoPFTau10 = cms.EDFilter("HLT2MuonTau",
    saveTags = cms.untracked.bool(True),
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(1000.0),
    inputTag1 = cms.InputTag("hltSingleMuIsoL3IsoFiltered12"),
    inputTag2 = cms.InputTag("hltFilterIsoMu12IsoPFTau10LooseIsolation"),
    MaxDphi = cms.double(1000.0),
    MaxDeta = cms.double(1000.0),
    MinDphi = cms.double(0.0)
)


process.hltOverlapFilterMu15IsoPFTau20 = cms.EDFilter("HLT2MuonTau",
    saveTags = cms.untracked.bool(True),
    MinMinv = cms.double(0.0),
    MinDelR = cms.double(0.3),
    MinN = cms.int32(1),
    MaxMinv = cms.double(14000.0),
    MinDeta = cms.double(0.0),
    MaxDelR = cms.double(1000.0),
    inputTag1 = cms.InputTag("hltL3Muon15"),
    inputTag2 = cms.InputTag("hltPFTau20TrackLooseIso"),
    MaxDphi = cms.double(1000.0),
    MaxDeta = cms.double(1000.0),
    MinDphi = cms.double(0.0)
)


process.hltPFJet10 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5ConvPFJets"),
    MinPt = cms.double(10.0),
    MinN = cms.int32(1)
)


process.hltPFJet15 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5ConvPFJets"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1)
)


process.hltPFJet20 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5ConvPFJets"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1)
)


process.hltPFMHT150Filter = cms.EDFilter("HLTMhtHtFilter",
    minPT12 = cms.double(0.0),
    inputJetTag = cms.InputTag("hltAntiKT5ConvPFJets"),
    minMeff = cms.double(0.0),
    minPtJet = cms.vdouble(5.0, 5.0),
    saveTag = cms.untracked.bool(True),
    minAlphaT = cms.double(0.0),
    minNJet = cms.int32(3),
    usePt = cms.bool(True),
    minMht = cms.double(150.0),
    mode = cms.int32(1),
    etaJet = cms.vdouble(9999.0, 9999.0),
    minHt = cms.double(0.0)
)


process.hltPFTau10Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFinding"),
    MinPt = cms.double(10.0),
    MinN = cms.int32(1)
)


process.hltPFTau15 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTaus"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1)
)


process.hltPFTau15Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFinding"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1)
)


process.hltPFTau15TrackLooseIso = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFindingLooseIsolation"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1)
)


process.hltPFTau20 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTaus"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1)
)


process.hltPFTau20Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFinding"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1)
)


process.hltPFTau20TrackLooseIso = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTrackFindingLooseIsolation"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1)
)


process.hltPFTau5Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIsoTrackFinding"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1)
)


process.hltPFTau5Track5 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIsoTrackPt5"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1)
)


process.hltPFTauTightIso35 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIso"),
    MinPt = cms.double(35.0),
    MinN = cms.int32(1)
)


process.hltPFTauTightIso35Track = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltConvPFTausTightIsoTrackFinding"),
    MinPt = cms.double(35.0),
    MinN = cms.int32(1)
)


process.hltPentaJet40Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(5)
)


process.hltPhoton125HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(999999.9),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(999999.9),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG125EtFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton20CaloIdVLIsoLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.5),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG20CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton20CaloIdVLIsoLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton20CaloIdVLIsoLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton20CaloIdVLIsoLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVLIsoLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton20CaloIdVLIsoLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVLIsoLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton20CaloIdVTIsoTClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG20R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltPhoton20CaloIdVTIsoTEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton20CaloIdVTIsoTEle8CaloIdLCaloIsoVLDoubleLegCombFilter = cms.EDFilter("HLTEgammaDoubleLegCombFilter",
    maxMatchDR = cms.double(0.3),
    nrRequiredSecondLeg = cms.int32(1),
    secondLegLastFilter = cms.InputTag("hltEle8CaloIdLCaloIsoVLNoL1SeedPixelMatchFilter"),
    firstLegLastFilter = cms.InputTag("hltPhoton20CaloIdVTIsoTTrackIsoFilter"),
    nrRequiredFirstLeg = cms.int32(1)
)


process.hltPhoton20CaloIdVTIsoTHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton20CaloIdVTIsoTHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton20CaloIdVTIsoTMu8ClusterShapeFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.031),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.011),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsoHLTClusterShape"),
    candTag = cms.InputTag("hltEG20R9ShapeFilterMu3EG5"),
    nonIsoTag = cms.InputTag("hltL1NonIsoHLTClusterShape")
)


process.hltPhoton20CaloIdVTIsoTMu8EcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTMu8ClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton20CaloIdVTIsoTMu8HEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.05),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.05),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTMu8EcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton20CaloIdVTIsoTMu8HcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTMu8HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton20CaloIdVTIsoTMu8TrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTMu8HcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton20CaloIdVTIsoTTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton20CaloIdVTIsoTHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton20R9IdPhoton18R9IdEgammaLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG20R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton20R9IdPhoton18R9IdEgammaR9IDDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.8),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.8),
    lessThan = cms.bool(False),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltActivityR9ID"),
    candTag = cms.InputTag("hltDoubleIsoEG18HEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton20R9IdPhoton18R9IdEgammaR9IDFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.8),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.8),
    lessThan = cms.bool(False),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltL1IsoR9ID"),
    candTag = cms.InputTag("hltPhoton20R9IdPhoton18R9IdEgammaLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsoR9ID")
)


process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaClusterShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltDoubleIsoEG18HEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaEcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaClusterShapeDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaHcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaEcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaTrackIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltActivityPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaHcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26IsoVLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG26HEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton26IsoVLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton26IsoVLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton26IsoVLHcalIsoLastFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.005),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton26IsoVLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton26IsoVLPhoton18IsoVLEgammaEcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltDoubleIsoEG18HEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26IsoVLPhoton18IsoVLEgammaHcalIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton26IsoVLPhoton18IsoVLEgammaEcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26IsoVLPhoton18IsoVLEgammaTrackIsolDoubleFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltActivityPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton26IsoVLPhoton18IsoVLEgammaHcalIsolDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26IsoVLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton26IsoVLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton26Photon18EgammaLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG26R9ShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaClusterShapeFilterUnseeded = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(-1.0),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltDoubleIsoEG18HEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaEcalIsolFilterUnseeded = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(6.0),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(6.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonEcalIsol"),
    candTag = cms.InputTag("hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaClusterShapeFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaHcalIsolFilterUnseeded = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltActivityPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaEcalIsolFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaTrackIsolFilterUnseeded = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(4.0),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(4.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltActivityPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaHcalIsolFilterUnseeded"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton30CaloIdVLIsoLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.5),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG30CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton30CaloIdVLIsoLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton30CaloIdVLIsoLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton30CaloIdVLIsoLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton30CaloIdVLIsoLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton30CaloIdVLIsoLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton30CaloIdVLIsoLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton32CaloIdLPhoton26CaloIdLEgammaClusterShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltPhoton32CaloIdLPhoton26CaloIdLEgammaLHEDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton32CaloIdLPhoton26CaloIdLEgammaLHEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleIsoEG26R9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton36CaloIdLPhoton22CaloIdLEgammaClusterShapeDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.035),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.014),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltActivityPhotonClusterShape"),
    candTag = cms.InputTag("hltPhoton36CaloIdLPhoton22CaloIdLEgammaLHEDoubleFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton36CaloIdLPhoton22CaloIdLEgammaLHEDoubleFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(2),
    isoTag = cms.InputTag("hltActivityPhotonHcalForHE"),
    candTag = cms.InputTag("hltDoubleIsoEG22R9ShapeFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltPhoton50CaloIdVLIsoLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.5),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG50CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton50CaloIdVLIsoLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton50CaloIdVLIsoLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton50CaloIdVLIsoLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton50CaloIdVLIsoLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton50CaloIdVLIsoLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton50CaloIdVLIsoLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPhoton75CaloIdVLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.15),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltEG75CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton75CaloIdVLIsoLEcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(5.5),
    thrOverEEE = cms.double(0.012),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.012),
    thrRegularEB = cms.double(5.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonEcalIsol"),
    candTag = cms.InputTag("hltEG75CaloIdVLClusterShapeFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonEcalIsol")
)


process.hltPhoton75CaloIdVLIsoLHEFilter = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(-1.0),
    thrOverEEE = cms.double(0.1),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.15),
    thrRegularEB = cms.double(-1.0),
    lessThan = cms.bool(True),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalForHE"),
    candTag = cms.InputTag("hltPhoton75CaloIdVLIsoLEcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalForHE")
)


process.hltPhoton75CaloIdVLIsoLHcalIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.005),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    thrOverEEB = cms.double(0.005),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHcalIsol"),
    candTag = cms.InputTag("hltPhoton75CaloIdVLIsoLHEFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHcalIsol")
)


process.hltPhoton75CaloIdVLIsoLTrackIsoFilter = cms.EDFilter("HLTEgammaGenericQuadraticFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(0.0),
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    thrOverE2EB = cms.double(0.0),
    thrRegularEE = cms.double(3.5),
    thrOverEEE = cms.double(0.002),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(3.5),
    lessThan = cms.bool(True),
    useEt = cms.bool(True),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(0.002),
    isoTag = cms.InputTag("hltL1IsolatedPhotonHollowTrackIsol"),
    candTag = cms.InputTag("hltPhoton75CaloIdVLIsoLHcalIsoFilter"),
    nonIsoTag = cms.InputTag("hltL1NonIsolatedPhotonHollowTrackIsol")
)


process.hltPixelActivityFilter = cms.EDFilter("HLTPixelActivityFilter",
    maxClusters = cms.uint32(0),
    inputTag = cms.InputTag("hltSiPixelClusters"),
    minClusters = cms.uint32(3)
)


process.hltPixelActivityFilterForHalo = cms.EDFilter("HLTPixelActivityFilter",
    maxClusters = cms.uint32(10),
    inputTag = cms.InputTag("hltSiPixelClusters"),
    minClusters = cms.uint32(0)
)


process.hltPixelAsymmetryFilter = cms.EDFilter("HLTPixelAsymmetryFilter",
    MinBarrel = cms.double(10000.0),
    MaxAsym = cms.double(1.0),
    inputTag = cms.InputTag("hltSiPixelClusters"),
    MinAsym = cms.double(0.0),
    MinCharge = cms.double(4000.0)
)


process.hltPixelClusterShapeFilter = cms.EDFilter("HLTPixelClusterShapeFilter",
    maxZ = cms.double(10.1),
    inputTag = cms.InputTag("hltSiPixelRecHits"),
    clusterTrunc = cms.double(2.0),
    zStep = cms.double(0.2),
    minZ = cms.double(-10.1),
    nhitsTrunc = cms.int32(150),
    clusterPars = cms.vdouble(0.0, 0.0045)
)


process.hltPreActivityEcalSC7 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreAlCaDTErrors = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreAlCaEcalEta = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreAlCaEcalPhiSym = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreAlCaEcalPi0 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreBTagMuDiJet100Mu9 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreBTagMuDiJet20Mu5 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreBTagMuDiJet60Mu7 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreBTagMuDiJet80Mu9 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreCalibration = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreCenJet80MET100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreCenJet80MET160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreCenJet80MET65 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreCenJet80MET80 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJet60MET45 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve100U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve140U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve15U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve180U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve300U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve30U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve50U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDiJetAve70U = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleEle10CaloIdLTrkIdVLEle10 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleEle8CaloIdLTrkIdVLHT160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleEle8CaloIdTTrkIdVLHT160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleIsoTau20Trk5 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleJet30ForwardBackward = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleJet60ForwardBackward = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleJet70ForwardBackward = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleJet80ForwardBackward = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu0Bs = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu0Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu0Upsilon = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu3 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu3HT160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu3LowMass = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu3Quarkonium = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu4Excl = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu5Ele8 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu5Ele8CaloIdLTrkIdVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu6 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoubleMu7 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoublePhoton33 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreDoublePhoton5IsoVLCEP = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEcalCalibration = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle10CaloIdLCaloIsoVLTrkIdVLTrkIsoVLHT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle10CaloIdTCaloIsoVLTrkIdTTrkIsoVLHT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTLooseIsoPFTau15 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTLooseIsoPFTau20 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle15CaloIdVTTrkIdTLooseIsoPFTau15 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle17CaloIdLCaloIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle17CaloIdLCaloIsoVLEle15HFL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle17CaloIdLCaloIsoVLEle8CaloIdLCaloIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle17CaloIdTTrkIdTCaloIsoVLTrkIsoVLEle8CaloIdTTrkIdTCaloIsoVLTrkIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8Mass30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle25CaloIdVTTrkIdTCentralDiJet30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle25CaloIdVTTrkIdTCentralJet30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle25CaloIdVTTrkIdTCentralJet40BTagIP = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle25CaloIdVTTrkIdTCentralTriJet30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle27CaloIdVTCaloIsoTTrkIdTTrkIsoT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle32CaloIdLCaloIsoVLSC17 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle32CaloIdVTCaloIsoTTrkIdTTrkIsoT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle45CaloIdVTTrkIdT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle8 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle8CaloIdLCaloIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle8CaloIdLCaloIsoVLJet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle8CaloIdLTrkIdVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreEle90NoSpikeFilter = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreExclDiJet60HFAND = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreExclDiJet60HFOR = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreFEDIntegrity = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreGlobalRunHPDNoise = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT150AlphaT0p6 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT150AlphaT0p7 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT200AlphaT0p6 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT200AlphaT0p65 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT250AlphaT0p55 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT250AlphaT0p62 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT300AlphaT0p52 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT300AlphaT0p54 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT350AlphaT0p51 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT350AlphaT0p53 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHLTHT400AlphaT0p51 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT150 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT250 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT250DoubleDisplacedJet60 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT250MHT60 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT300 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT300MHT75 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT350 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT400 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT450 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT500 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHT550 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHcalCalibration = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHcalNZS = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreHcalPhiSym = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu12 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu12IsoPFTau10 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu15 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu17 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu17BTagIPCentJet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu24 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoMu30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoTrackHB = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreIsoTrackHE = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet110 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet150 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet190 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet240 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet370 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet370NoJetID = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet60 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJet80 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJetE30NoBPTX = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJetE30NoBPTX3BXNoHalo = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreJetE30NoBPTXNoHalo = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1BeamGasBsc = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1BeamGasHf = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1BeamHalo = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1DoubleMu0 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1Interbunch1 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1Mu10 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1Mu20 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1MuOpenAntiBPTX = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1PreCollisions = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1SingleEG12 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1SingleEG5 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1SingleJet36 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1SingleMuOpen = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1SingleMuOpenDT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1TechBSChalo = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1TechBSCminBiasthreshold1 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL1TechCASTORHaloMuon = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL2DoubleMu0 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL2DoubleMu23NoVertex = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL2Mu10 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL2Mu20 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreL3MuonsCosmicTracking = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreLogMonitor = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMET100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMET120 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMET200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMR100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMeff440 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMeff520 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMeff640 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu10Ele10CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu12 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu15 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu15DoublePhoton15CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu15IsoPFTau20 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu15Photon20CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu17BTagIPCenJet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu17Ele8CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu17TriCenJet30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu20 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu24 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu3 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu3Ele8CaloIdLTrkIdVLHT160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu3Ele8CaloIdTTrkIdVLHT160 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu3Track3Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5DoubleEle8 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5Ele8CaloIdLTrkIdVLEle8 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5HT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5L2Mu2 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5L2Mu2Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5TkMu0JpsiTightB5Q7 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu5Track2Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu7Track5Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu7Track7Jpsi = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu8 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu8Ele17CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu8HT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu8Jet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreMu8Photon20CaloIdVTIsoT = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePFMHT150 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton125NoSpikeFilter = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton20CaloIdVLIsoL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton20CaloIdVTIsoTEle8CaloIdLCaloIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton20R9IdPhoton18R9Id = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26CaloIdLIsoVLPhoton18 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26CaloIdLIsoVLPhoton18R9Id = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26IsoVLPhoton18 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26IsoVLPhoton18IsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26Photon18 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton26R9IdPhoton18CaloIdLIsoVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton30CaloIdVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton30CaloIdVLIsoL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton32CaloIdLPhoton26CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton36CaloIdLPhoton22CaloIdL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton50CaloIdVLIsoL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton60CaloIdLHT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton70CaloIdLHT200 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton70CaloIdLHT300 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton70CaloIdLMHT30 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton70CaloIdLMHT50 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton75CaloIdVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhoton75CaloIdVLIsoL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhysics = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePhysicsNanoDST = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePixelTracksMultiplicity100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPrePixelTracksMultiplicity80 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet40IsoPFTau40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet50 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet50Jet40 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet60 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreQuadJet70 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreR032 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreR032MR100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreR035MR100 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreRPCMuonNoHits = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreRPCMuonNoTriggers = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreRPCMuonNorma = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreRandom = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreRegionalCosmicTracking = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreSingleIsoTau35Trk20MET45 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreTechTrigHCALNoise = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreTrackerCalibration = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreTrackerCosmics = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreTripleEle10CaloIdLTrkIdVL = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreTripleMu3 = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltPreZeroBias = cms.EDFilter("HLTPrescaler",
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    offset = cms.uint32(0)
)


process.hltQuadJet40Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(4)
)


process.hltQuadJet40IsoPFTau40 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(4)
)


process.hltQuadJet50Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(50.0),
    MinN = cms.int32(4)
)


process.hltQuadJet60 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(60.0),
    MinN = cms.int32(4)
)


process.hltQuadJet70 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(70.0),
    MinN = cms.int32(4)
)


process.hltR032 = cms.EDFilter("HLTRFilter",
    acceptNJ = cms.bool(True),
    doRPrime = cms.bool(False),
    inputTag = cms.InputTag("hltRHemisphere"),
    inputMetTag = cms.InputTag("hltMet"),
    minMR = cms.double(0.0),
    minR = cms.double(0.32)
)


process.hltR032MR100 = cms.EDFilter("HLTRFilter",
    acceptNJ = cms.bool(True),
    doRPrime = cms.bool(False),
    inputTag = cms.InputTag("hltRHemisphere"),
    inputMetTag = cms.InputTag("hltMet"),
    minMR = cms.double(100.0),
    minR = cms.double(0.32)
)


process.hltR035MR100 = cms.EDFilter("HLTRFilter",
    acceptNJ = cms.bool(True),
    doRPrime = cms.bool(False),
    inputTag = cms.InputTag("hltRHemisphere"),
    inputMetTag = cms.InputTag("hltMet"),
    minMR = cms.double(100.0),
    minR = cms.double(0.35)
)


process.hltR9IdFilterUnseeded = cms.EDFilter("HLTEgammaGenericFilter",
    doIsolated = cms.bool(False),
    thrOverE2EE = cms.double(-1.0),
    L1NonIsoCand = cms.InputTag(""),
    thrOverE2EB = cms.double(-1.0),
    thrRegularEE = cms.double(0.8),
    thrOverEEE = cms.double(-1.0),
    L1IsoCand = cms.InputTag("hltRecoEcalSuperClusterActivityCandidate"),
    SaveTag = cms.untracked.bool(True),
    thrRegularEB = cms.double(0.8),
    lessThan = cms.bool(False),
    useEt = cms.bool(False),
    ncandcut = cms.int32(1),
    thrOverEEB = cms.double(-1.0),
    isoTag = cms.InputTag("hltActivityR9ID"),
    candTag = cms.InputTag("hltDoubleIsoEG18HEFilter"),
    nonIsoTag = cms.InputTag("")
)


process.hltRHemisphere = cms.EDFilter("HLTRHemisphere",
    acceptNJ = cms.bool(True),
    maxEta = cms.double(3.0),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    minJetPt = cms.double(56.0),
    maxNJ = cms.int32(7)
)


process.hltRPCFilter = cms.EDFilter("HLTRPCFilter",
    rpcDTPoints = cms.InputTag("hltRPCPointProducer","RPCDTExtrapolatedPoints"),
    rpcRecHits = cms.InputTag("hltRpcRecHits"),
    rpcCSCPoints = cms.InputTag("hltRPCPointProducer","RPCCSCExtrapolatedPoints")
)


process.hltRPCMuonNoTriggersL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sAlCaRPC"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(1.6),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(6),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltRPCMuonNormaL1Filtered0 = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sAlCaRPC"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(1.6),
    SaveTag = cms.untracked.bool(True),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltRandomEventsFilter = cms.EDFilter("HLTTriggerTypeFilter",
    SelectedTriggerType = cms.int32(3)
)


process.hltSelectedPFTauTightIsoTrackPt20 = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackPt20Discriminator"),
        selectionCut = cms.double(0.5)
    )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTauTightIsoTrackPt20Isolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackPt20Discriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauTightIsoIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTausTightIsoTrackFinding = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackFindingDiscriminator"),
        selectionCut = cms.double(0.5)
    )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTausTightIsoTrackFindingIsolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackFindingDiscriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauTightIsoIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTausTightIsoTrackPt5 = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackPt5Discriminator"),
        selectionCut = cms.double(0.5)
    )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTausTightIsoTrackPt5Isolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTightIsoTrackPt5Discriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauTightIsoIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTausTightIso")
)


process.hltSelectedPFTausTrackFinding = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTrackFindingDiscriminator"),
        selectionCut = cms.double(0.5)
    )),
    src = cms.InputTag("hltPFTaus")
)


process.hltSelectedPFTausTrackFindingIsolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTrackFindingDiscriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTaus")
)


process.hltSelectedPFTausTrackFindingLooseIsolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTrackFindingDiscriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauLooseIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTaus")
)


process.hltSelectedPFTausTrackPt5 = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTrackPt5Discriminator"),
        selectionCut = cms.double(0.5)
    )),
    src = cms.InputTag("hltPFTaus")
)


process.hltSelectedPFTausTrackPt5Isolation = cms.EDFilter("PFTauSelector",
    discriminators = cms.VPSet(cms.PSet(
        discriminator = cms.InputTag("hltPFTauTrackPt5Discriminator"),
        selectionCut = cms.double(0.5)
    ),
        cms.PSet(
            discriminator = cms.InputTag("hltPFTauIsolationDiscriminator"),
            selectionCut = cms.double(0.5)
        )),
    src = cms.InputTag("hltPFTaus")
)


process.hltSelector4Jets = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltAntiKT5L2L3CorrCaloJets")
)


process.hltSelector4JetsDiJet100 = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltBSoftMuonGetJetsFromDiJet100")
)


process.hltSelector4JetsDiJet20 = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltBSoftMuonGetJetsFromDiJet20")
)


process.hltSelector4JetsDiJet60 = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltBSoftMuonGetJetsFromDiJet60")
)


process.hltSelector4JetsDiJet80 = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltBSoftMuonGetJetsFromDiJet80")
)


process.hltSelectorEleJetsSingleTop = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltGetJetsfrom1EleCleanBJet40Central")
)


process.hltSelectorJetsSingleTop = cms.EDFilter("LargestEtCaloJetSelector",
    maxNumber = cms.uint32(4),
    filter = cms.bool(False),
    src = cms.InputTag("hltGetJetsfromBJet40Central")
)


process.hltSingleEleCleanBJet40Central = cms.EDFilter("HLT1CaloBJet",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets"),
    MinPt = cms.double(40.0),
    MinN = cms.int32(1)
)


process.hltSingleJet110Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(110.0),
    MinN = cms.int32(1)
)


process.hltSingleJet150Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(150.0),
    MinN = cms.int32(1)
)


process.hltSingleJet190Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(190.0),
    MinN = cms.int32(1)
)


process.hltSingleJet240Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(240.0),
    MinN = cms.int32(1)
)


process.hltSingleJet30 = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedCorrJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltSingleJet370Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(370.0),
    MinN = cms.int32(1)
)


process.hltSingleJet370RegionalNoJetID = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltL1MatchedJetsRegional"),
    MinPt = cms.double(370.0),
    MinN = cms.int32(1)
)


process.hltSingleJet60Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(60.0),
    MinN = cms.int32(1)
)


process.hltSingleJet80Regional = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(5.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltJetIDPassedJetsRegional"),
    MinPt = cms.double(80.0),
    MinN = cms.int32(1)
)


process.hltSingleL2MuORL2PreFilteredNoVtx = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1MuORL1Filtered0"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidatesNoVtx"),
    MaxDr = cms.double(9999.0)
)


process.hltSingleMu12L2Filtered12 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu12L1Filtered0"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltSingleMu12L3Filtered12 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu7L2Filtered7"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu20L3Filtered20 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMu12L2Filtered12"),
    MinPt = cms.double(20.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu24L3Filtered24 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu12L2Filtered12"),
    MinPt = cms.double(24.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu30L3Filtered30 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu12L2Filtered12"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu3L2Filtered0 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuOpenL1Filtered"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltSingleMu3L3Filtered3 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMu3L2Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu5EG5L2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu3EG5L1Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltSingleMu5L2Filtered3 = cms.EDFilter("HLTMuonL2PreFilter",
    PreviousCandTag = cms.InputTag("hltL1SingleMu3L1Filtered0"),
    MinPt = cms.double(3.0),
    MinN = cms.int32(1),
    SeedMapTag = cms.InputTag("hltL2Muons"),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL2MuonCandidates"),
    MaxDr = cms.double(9999.0)
)


process.hltSingleMu5L3Filtered5 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMu5L2Filtered3"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu8EG5L3Filtered8 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMu5EG5L2Filtered3"),
    MinPt = cms.double(8.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMu8L3Filtered8 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltL2Mu3L2Filtered3"),
    MinPt = cms.double(8.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    SaveTag = cms.untracked.bool(True),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuIsoL2IsoFiltered10 = cms.EDFilter("HLTMuonIsoFilter",
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL2MuonIsolations"),
    PreviousCandTag = cms.InputTag("hltL2Mu10L2Filtered10"),
    MinN = cms.int32(1),
    CandTag = cms.InputTag("hltL2MuonCandidates")
)


process.hltSingleMuIsoL2IsoFiltered12 = cms.EDFilter("HLTMuonIsoFilter",
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL2MuonIsolations"),
    PreviousCandTag = cms.InputTag("hltL2Mu12L2Filtered12"),
    MinN = cms.int32(1),
    CandTag = cms.InputTag("hltL2MuonCandidates")
)


process.hltSingleMuIsoL2IsoFiltered7 = cms.EDFilter("HLTMuonIsoFilter",
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL2MuonIsolations"),
    PreviousCandTag = cms.InputTag("hltL2Mu7L2Filtered7"),
    MinN = cms.int32(1),
    CandTag = cms.InputTag("hltL2MuonCandidates")
)


process.hltSingleMuIsoL3IsoFiltered12 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL3PreFiltered12"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltSingleMuIsoL3IsoFiltered15 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL3PreFiltered15"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltSingleMuIsoL3IsoFiltered17 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL3PreFiltered17"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltSingleMuIsoL3IsoFiltered24 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL3PreFiltered24"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltSingleMuIsoL3IsoFiltered30 = cms.EDFilter("HLTMuonIsoFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL3PreFiltered30"),
    MinN = cms.int32(1),
    SaveTag = cms.untracked.bool(True),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    IsolatorPSet = cms.PSet(

    ),
    DepTag = cms.VInputTag("hltL3MuonIsolations")
)


process.hltSingleMuIsoL3PreFiltered12 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL2IsoFiltered7"),
    MinPt = cms.double(12.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuIsoL3PreFiltered15 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL2IsoFiltered10"),
    MinPt = cms.double(15.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuIsoL3PreFiltered17 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL2IsoFiltered10"),
    MinPt = cms.double(17.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuIsoL3PreFiltered24 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL2IsoFiltered12"),
    MinPt = cms.double(24.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuIsoL3PreFiltered30 = cms.EDFilter("HLTMuonL3PreFilter",
    PreviousCandTag = cms.InputTag("hltSingleMuIsoL2IsoFiltered12"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    MinNhits = cms.int32(0),
    NSigmaPt = cms.double(0.0),
    MaxDz = cms.double(9999.0),
    BeamSpotTag = cms.InputTag("hltOnlineBeamSpot"),
    CandTag = cms.InputTag("hltL3MuonCandidates"),
    MaxDr = cms.double(2.0)
)


process.hltSingleMuOpenL1Filtered = cms.EDFilter("HLTMuonL1Filter",
    CSCTFtag = cms.InputTag("unused"),
    PreviousCandTag = cms.InputTag("hltL1sL1SingleMuOpen"),
    MinPt = cms.double(0.0),
    MinN = cms.int32(1),
    MaxEta = cms.double(2.5),
    SelectQualities = cms.vint32(),
    CandTag = cms.InputTag("hltL1extraParticles"),
    ExcludeSingleSegmentCSC = cms.bool(False)
)


process.hltStoppedHSCPControl1CaloJetEnergy30 = cms.EDFilter("HLT1CaloJetEnergy",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltStoppedHSCPIterativeCone5CaloJets"),
    MinE = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltStoppedHSCPHpdFilter = cms.EDFilter("HLTHPDFilter",
    rbxSpikeEnergy = cms.double(50.0),
    energy = cms.double(-99.0),
    inputTag = cms.InputTag("hltHbhereco"),
    hpdSpikeIsolationEnergy = cms.double(1.0),
    hpdSpikeEnergy = cms.double(10.0),
    rbxSpikeUnbalance = cms.double(0.2)
)


process.hltStoppedHSCPLoose1CaloJetEnergy30 = cms.EDFilter("HLT1CaloJetEnergy",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltStoppedHSCPIterativeCone5CaloJets"),
    MinE = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltStoppedHSCPTight1CaloJetEnergy30 = cms.EDFilter("HLT1CaloJetEnergy",
    MaxEta = cms.double(3.0),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltStoppedHSCPIterativeCone5CaloJets"),
    MinE = cms.double(30.0),
    MinN = cms.int32(1)
)


process.hltTauJet5 = cms.EDFilter("HLT1Tau",
    MaxEta = cms.double(2.5),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5CaloJetsEt5"),
    MinPt = cms.double(5.0),
    MinN = cms.int32(1)
)


process.hltTrackerCosmicsPattern = cms.EDFilter("HLTLevel1Pattern",
    ignoreL1Mask = cms.bool(False),
    triggerPattern = cms.vint32(1, 1, 1, 0, 0),
    triggerBit = cms.string('L1Tech_RPC_TTU_pointing_Cosmics.v0'),
    invert = cms.bool(False),
    L1GtReadoutRecordTag = cms.InputTag("hltGtDigis"),
    throw = cms.bool(True),
    daqPartitions = cms.uint32(1),
    bunchCrossings = cms.vint32(-2, -1, 0, 1, 2)
)


process.hltTrackerHaloFilter = cms.EDFilter("HLTTrackerHaloFilter",
    MaxAccus = cms.int32(4),
    MaxClustersTEC = cms.int32(60),
    MaxClustersTECm = cms.int32(50),
    SignalAccumulation = cms.int32(5),
    inputTag = cms.InputTag("hltSiStripClusters"),
    MaxClustersTECp = cms.int32(50),
    FastProcessing = cms.int32(1)
)


process.hltTriJet30Central = cms.EDFilter("HLT1CaloJet",
    MaxEta = cms.double(2.6),
    saveTag = cms.untracked.bool(True),
    inputTag = cms.InputTag("hltAntiKT5L2L3CorrCaloJets"),
    MinPt = cms.double(30.0),
    MinN = cms.int32(3)
)


process.hltTriggerType = cms.EDFilter("HLTTriggerTypeFilter",
    SelectedTriggerType = cms.int32(1)
)


process.hltTripleEG10EtFilter = cms.EDFilter("HLTEgammaEtFilter",
    L1NonIsoCand = cms.InputTag("hltL1NonIsoRecoEcalCandidate"),
    L1IsoCand = cms.InputTag("hltL1IsoRecoEcalCandidate"),
    inputTag = cms.InputTag("hltEGRegionalL1TripleEG5"),
    etcutEB = cms.double(10.0),
    ncandcut = cms.int32(3),
    etcutEE = cms.double(10.0)
)


process.MEtoMEComparitor = cms.EDAnalyzer("MEtoMEComparitor",
    Diffgoodness = cms.double(0.1),
    processRef = cms.string('HLT'),
    dirDepth = cms.uint32(1),
    KSgoodness = cms.double(0.9),
    runInstance = cms.string('MEtoEDMConverterRun'),
    MEtoEDMLabel = cms.string('MEtoEDMConverter'),
    autoProcess = cms.bool(True),
    processNew = cms.string('RERECO'),
    OverAllgoodness = cms.double(0.9),
    lumiInstance = cms.string('MEtoEDMConverterLumi')
)


process.hltCSCMonitorModule = cms.EDAnalyzer("CSCMonitorModule",
    BOOKING_XML_FILE = cms.FileInPath('DQM/CSCMonitorModule/data/emuDQMBooking.xml'),
    EventProcessor = cms.untracked.PSet(
        PROCESS_EFF_PARAMETERS = cms.untracked.bool(False),
        FRAEFF_AUTO_UPDATE = cms.untracked.bool(False),
        EFF_NODATA_THRESHOLD = cms.untracked.double(0.1),
        FRAEFF_AUTO_UPDATE_START = cms.untracked.uint32(5),
        BINCHECK_MASK = cms.untracked.uint32(384563190),
        BINCHECKER_CRC_CLCT = cms.untracked.bool(True),
        EFF_COLD_SIGFAIL = cms.untracked.double(5.0),
        PROCESS_DDU = cms.untracked.bool(False),
        EFF_NODATA_SIGFAIL = cms.untracked.double(5.0),
        BINCHECKER_MODE_DDU = cms.untracked.bool(False),
        BINCHECKER_CRC_ALCT = cms.untracked.bool(True),
        EFF_HOT_THRESHOLD = cms.untracked.double(0.1),
        FOLDER_DDU = cms.untracked.string(''),
        BINCHECKER_CRC_CFEB = cms.untracked.bool(True),
        EVENTS_ECHO = cms.untracked.uint32(1000),
        DDU_CHECK_MASK = cms.untracked.uint32(4294959103),
        FRAEFF_SEPARATE_THREAD = cms.untracked.bool(False),
        EFF_HOT_SIGFAIL = cms.untracked.double(5.0),
        FOLDER_PAR = cms.untracked.string(''),
        FRAEFF_AUTO_UPDATE_FREQ = cms.untracked.uint32(200),
        EFF_COLD_THRESHOLD = cms.untracked.double(0.1),
        FOLDER_EMU = cms.untracked.string('CSC/FEDIntegrity_EvF'),
        DDU_BINCHECK_MASK = cms.untracked.uint32(384563190),
        EFF_ERR_SIGFAIL = cms.untracked.double(5.0),
        PROCESS_CSC = cms.untracked.bool(False),
        PROCESS_EFF_HISTOS = cms.untracked.bool(False),
        MO_FILTER = cms.untracked.vstring('-/^.*$/',
            '+/FEDEntries/',
            '+/FEDFatal/',
            '+/FEDFormatFatal/',
            '+/FEDNonFatal/',
            '+/^CSC_Reporting$/',
            '+/^CSC_Format_Errors$/',
            '+/^CSC_Format_Warnings$/',
            '+/^CSC_L1A_out_of_sync$/',
            '+/^CSC_wo_ALCT$/',
            '+/^CSC_wo_CFEB$/',
            '+/^CSC_wo_CLCT$/'),
        FOLDER_CSC = cms.untracked.string(''),
        EFF_ERR_THRESHOLD = cms.untracked.double(0.1),
        BINCHECKER_OUTPUT = cms.untracked.bool(False)
    ),
    InputObjects = cms.untracked.InputTag("rawDataCollector")
)


process.hltEBHltTask = cms.EDAnalyzer("EBHltTask",
    FEDRawDataCollection = cms.InputTag("rawDataCollector"),
    EBDetIdCollection3 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityGainSwitchErrors"),
    EBDetIdCollection2 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityChIdErrors"),
    EBDetIdCollection1 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityGainErrors"),
    EBDetIdCollection0 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityDCCSizeErrors"),
    folderName = cms.untracked.string('FEDIntegrity_EvF'),
    prefixME = cms.untracked.string('EcalBarrel'),
    EcalElectronicsIdCollection5 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemChIdErrors"),
    EcalElectronicsIdCollection4 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemBlockSizeErrors"),
    EcalElectronicsIdCollection6 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemGainErrors"),
    EcalElectronicsIdCollection1 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityTTIdErrors"),
    EcalElectronicsIdCollection3 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemTtIdErrors"),
    EcalElectronicsIdCollection2 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityBlockSizeErrors")
)


process.hltEEHltTask = cms.EDAnalyzer("EEHltTask",
    FEDRawDataCollection = cms.InputTag("rawDataCollector"),
    folderName = cms.untracked.string('FEDIntegrity_EvF'),
    EEDetIdCollection0 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityDCCSizeErrors"),
    EEDetIdCollection1 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityGainErrors"),
    EEDetIdCollection2 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityChIdErrors"),
    EEDetIdCollection3 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityGainSwitchErrors"),
    prefixME = cms.untracked.string('EcalEndcap'),
    EcalElectronicsIdCollection5 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemChIdErrors"),
    EcalElectronicsIdCollection4 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemBlockSizeErrors"),
    EcalElectronicsIdCollection6 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemGainErrors"),
    EcalElectronicsIdCollection1 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityTTIdErrors"),
    EcalElectronicsIdCollection3 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityMemTtIdErrors"),
    EcalElectronicsIdCollection2 = cms.InputTag("hltEcalRawToRecHitByproductProducer","EcalIntegrityBlockSizeErrors")
)


process.hltESFEDIntegrityTask = cms.EDAnalyzer("ESFEDIntegrityTask",
    FEDDirName = cms.untracked.string('FEDIntegrity_EvF'),
    FEDRawDataCollection = cms.InputTag("rawDataCollector"),
    ESDCCCollections = cms.InputTag("NotUsed"),
    prefixME = cms.untracked.string('EcalPreshower'),
    ESKChipCollections = cms.InputTag("NotUsed")
)


process.hltHcalDataIntegrityMonitor = cms.EDAnalyzer("HcalDataIntegrityTask",
    RawDataLabel = cms.untracked.InputTag("rawDataCollector"),
    AllowedCalibTypes = cms.untracked.vint32(0, 1, 2, 3, 4,
        5, 6, 7),
    UnpackerReportLabel = cms.untracked.InputTag("hltHcalDigis"),
    TaskFolder = cms.untracked.string('FEDIntegrity_EvF')
)


process.hltL1tfed = cms.EDAnalyzer("L1TFED",
    FEDDirName = cms.untracked.string('L1T/FEDIntegrity_EvF'),
    disableROOToutput = cms.untracked.bool(True),
    rawTag = cms.InputTag("rawDataCollector"),
    DQMStore = cms.untracked.bool(True),
    L1FEDS = cms.vint32(745, 760, 780, 812, 813)
)


process.hltRPCFEDIntegrity = cms.EDAnalyzer("RPCFEDIntegrity",
    RPCRawCountsInputTag = cms.untracked.InputTag("hltMuonRPCDigis"),
    RPCPrefixDir = cms.untracked.string('RPC/FEDIntegrity_EvF')
)


process.hltSiPixelHLTSource = cms.EDAnalyzer("SiPixelHLTSource",
    outputFile = cms.string('Pixel_DQM_HLT.root'),
    ErrorInput = cms.InputTag("hltSiPixelDigis"),
    RawInput = cms.InputTag("rawDataCollector"),
    DirName = cms.untracked.string('Pixel/FEDIntegrity_EvF')
)


process.hltSiStripFEDCheck = cms.EDAnalyzer("SiStripFEDCheckPlugin",
    CheckChannelStatus = cms.untracked.bool(False),
    DoPayloadChecks = cms.untracked.bool(False),
    CheckChannelLengths = cms.untracked.bool(False),
    CheckFELengths = cms.untracked.bool(False),
    RawDataTag = cms.InputTag("rawDataCollector"),
    HistogramUpdateFrequency = cms.untracked.uint32(1000),
    CheckChannelPacketCodes = cms.untracked.bool(False),
    DirName = cms.untracked.string('SiStrip/FEDIntegrity_EvF')
)


process.RAWSIMoutput = cms.OutputModule("PoolOutputModule",
    splitLevel = cms.untracked.int32(0),
    eventAutoFlushCompressedSize = cms.untracked.int32(5242880),
    fileName = cms.untracked.string('step1.root'),
    outputCommands = cms.untracked.vstring('drop *',
        'drop *',
        'keep  FEDRawDataCollection_rawDataCollector_*_*',
        'keep  FEDRawDataCollection_source_*_*',
        'keep  FEDRawDataCollection_rawDataCollector_*_*',
        'keep  FEDRawDataCollection_source_*_*',
        'drop *_hlt*_*_*',
        'keep *_hltL1GtObjectMap_*_*',
        'keep FEDRawDataCollection_rawDataCollector_*_*',
        'keep FEDRawDataCollection_source_*_*',
        'keep edmTriggerResults_*_*_*',
        'keep triggerTriggerEvent_*_*_*',
        'keep *_g4SimHits_*_*',
        'keep edmHepMCProduct_source_*_*',
        'keep *_allTrackMCMatch_*_*',
        'keep StripDigiSimLinkedmDetSetVector_simMuonCSCDigis_*_*',
        'keep CSCDetIdCSCComparatorDigiMuonDigiCollection_simMuonCSCDigis_*_*',
        'keep DTLayerIdDTDigiSimLinkMuonDigiCollection_simMuonDTDigis_*_*',
        'keep RPCDigiSimLinkedmDetSetVector_simMuonRPCDigis_*_*',
        'keep EBSrFlagsSorted_simEcalDigis_*_*',
        'keep EESrFlagsSorted_simEcalDigis_*_*',
        'keep CrossingFramePlaybackInfoExtended_*_*_*',
        'keep PileupSummaryInfo_*_*_*',
        'keep PileupSummaryInfos_*_*_*',
        'keep LHERunInfoProduct_source_*_*',
        'keep LHEEventProduct_source_*_*',
        'keep GenRunInfoProduct_generator_*_*',
        'keep GenEventInfoProduct_generator_*_*',
        'keep edmHepMCProduct_generator_*_*',
        'keep GenFilterInfo_*_*_*',
        'keep *_genParticles_*_*',
        'keep recoGenJets_*_*_*',
        'keep *_genParticle_*_*',
        'keep recoGenMETs_*_*_*',
        'keep FEDRawDataCollection_source_*_*',
        'keep FEDRawDataCollection_rawDataCollector_*_*',
        'keep *_MEtoEDMConverter_*_*',
        'keep *_randomEngineStateProducer_*_*',
        'keep *_logErrorHarvester_*_*',
        'drop RandomEngineStates_*_*_*',
        'keep RandomEngineStates_*_*_HLT'),
    dataset = cms.untracked.PSet(
        filterName = cms.untracked.string('MyFilter'),
        dataTier = cms.untracked.string('GEN-SIM-RAW')
    )
)


process.HLTDoLocalPixelSequence = cms.Sequence(process.hltSiPixelDigis+process.hltSiPixelClusters+process.hltSiPixelRecHits)


process.HLTDoEgammaClusterShapeSequence = cms.Sequence(process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape)


process.HLTDoLocalHcalWithoutHOSequence = cms.Sequence(process.hltHcalDigis+process.hltHbhereco+process.hltHfreco)


process.HLTL1IsoEgammaRegionalRecoTrackerSequence = cms.Sequence(process.hltL1IsoEgammaRegionalPixelSeedGenerator+process.hltL1IsoEgammaRegionalCkfTrackCandidates+process.hltL1IsoEgammaRegionalCTFFinalFitWithMaterial)


process.castorDigiSequence = cms.Sequence(process.simCastorDigis)


process.trDigi = cms.Sequence(process.simSiPixelDigis+process.simSiStripDigis)


process.HLTEndSequence = cms.Sequence(process.hltBoolEnd)


process.hcalDigiSequence = cms.Sequence(process.simHcalUnsuppressedDigis+process.simHcalTriggerPrimitiveDigis+process.simHcalDigis+process.simHcalTTPDigis)


process.HLTHFEM15Sequence = cms.Sequence(process.hltHFEMClusters+process.hltHFRecoEcalCandidate+process.hltHFEMFilter)


process.HLTBeamSpot = cms.Sequence(process.hltScalersRawToDigi+process.hltOnlineBeamSpot+process.hltOfflineBeamSpot)


process.SimL1MuTriggerPrimitives = cms.Sequence(process.simDtTriggerPrimitiveDigis+process.simCscTriggerPrimitiveDigis)


process.HLTPixelMatchElectronActivityTrackingSequence = cms.Sequence(process.hltCkfActivityTrackCandidates+process.hltCtfActivityWithMaterialTracks+process.hltPixelMatchElectronsActivity)


process.DigiToRaw = cms.Sequence(process.csctfpacker+process.dttfpacker+process.gctDigiToRaw+process.l1GtPack+process.l1GtEvmPack+process.siPixelRawData+process.SiStripDigiToRaw+process.ecalPacker+process.esDigiToRaw+process.hcalRawData+process.cscpacker+process.dtpacker+process.rpcpacker+process.castorRawData+process.rawDataCollector)


process.HLTMuTkMuJpsiTkMuRecoSequence = cms.Sequence(process.hltMuTkMuJpsiTrackerMuons+process.hltMuTkMuJpsiTrackerMuonCands)


process.HLTPreshowerSequence = cms.Sequence(process.hltESRawToRecHitFacility+process.hltEcalRegionalESRestFEDs+process.hltESRecHitAll)


process.HLTEcalActivitySequence = cms.Sequence(process.hltEcalRawToRecHitFacility+process.hltESRawToRecHitFacility+process.hltEcalRegionalRestFEDs+process.hltEcalRegionalESRestFEDs+process.hltEcalRecHitAll+process.hltESRecHitAll+process.hltHybridSuperClustersActivity+process.hltCorrectedHybridSuperClustersActivity+process.hltMulti5x5BasicClustersActivity+process.hltMulti5x5SuperClustersActivity+process.hltMulti5x5SuperClustersWithPreshowerActivity+process.hltCorrectedMulti5x5SuperClustersWithPreshowerActivity+process.hltRecoEcalSuperClusterActivityCandidate+process.hltEcalActivitySuperClusterWrapper)


process.HLTDoElectronDetaDphiSequence = cms.Sequence(process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi)


process.HLTStoppedHSCPLocalHcalReco = cms.Sequence(process.hltHcalDigis+process.hltHbhereco)


process.ecalDigiSequence = cms.Sequence(process.simEcalUnsuppressedDigis+process.simEcalTriggerPrimitiveDigis+process.simEcalDigis+process.simEcalPreshowerDigis)


process.HLTMulti5x5SuperClusterL1Isolated = cms.Sequence(process.hltMulti5x5BasicClustersL1Isolated+process.hltMulti5x5SuperClustersL1Isolated+process.hltMulti5x5EndcapSuperClustersWithPreshowerL1Isolated+process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1Isolated)


process.VertexSmearing = cms.Sequence(cms.SequencePlaceholder("VtxSmeared"))


process.endOfProcess_withComparison = cms.Sequence(process.MEtoEDMConverter+process.MEtoMEComparitor)


process.GeneInfo = cms.Sequence(process.genParticles)


process.HLTEgammaR9ShapeSequence = cms.Sequence(process.hltL1IsoR9shape+process.hltL1NonIsoR9shape)


process.muonDigi = cms.Sequence(process.simMuonCSCDigis+process.simMuonDTDigis+process.simMuonRPCDigis)


process.genJetParticles = cms.Sequence(process.genParticlesForJets)


process.HLTDoEGammaHESequence = cms.Sequence(process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE)


process.trackingParticles = cms.Sequence(process.mergedtruth)


process.HLTL3muonisorecoSequence = cms.Sequence(process.hltPixelTracks+process.hltL3MuonIsolations)


process.HLTDoRegionalPi0EtaSequence = cms.Sequence(process.hltESRawToRecHitFacility+process.hltEcalRawToRecHitFacility+process.hltEcalRegionalPi0EtaFEDs+process.hltESRegionalPi0EtaRecHit+process.hltEcalRegionalPi0EtaRecHit)


process.SimL1TechnicalTriggers = cms.Sequence(process.simBscDigis+process.simRpcTechTrigDigis+process.simHcalTechTrigDigis)


process.genMETParticles = cms.Sequence(process.genCandidatesForMET+process.genParticlesForMETAllVisible)


process.HLTBeginSequenceRandom = cms.Sequence(process.hltRandomEventsFilter+process.hltGtDigis)


process.HLTL1UnpackerSequence = cms.Sequence(process.hltGtDigis+process.hltGctDigis+process.hltL1GtObjectMap+process.hltL1extraParticles)


process.HLTRecopixelvertexingForHighMultSequence = cms.Sequence(process.hltPixelTracksForHighMult+process.hltPixelVerticesForHighMult)


process.HLTPFTauTightIsoSequence = cms.Sequence(process.hltPFTauJetTracksAssociator+process.hltPFTauTagInfo+process.hltPFTausTightIso+process.hltPFTauTightIsoTrackFindingDiscriminator+process.hltPFTauTightIsoTrackPt5Discriminator+process.hltPFTauTightIsoIsolationDiscriminator+process.hltSelectedPFTausTightIsoTrackFinding+process.hltSelectedPFTausTightIsoTrackPt5+process.hltSelectedPFTausTightIsoTrackFindingIsolation+process.hltSelectedPFTausTightIsoTrackPt5Isolation+process.hltConvPFTausTightIsoTrackFinding+process.hltConvPFTausTightIsoTrackFindingIsolation+process.hltConvPFTausTightIso+process.hltConvPFTausTightIsoTrackPt5+process.hltConvPFTausTightIsoTrackPt5Isolation)


process.HLTDoLocalHcalSequence = cms.Sequence(process.hltHcalDigis+process.hltHbhereco+process.hltHfreco+process.hltHoreco)


process.HLTDoLocalPixelLight = cms.Sequence(process.hltSiPixelDigis+process.hltSiPixelClusters)


process.HLTEcalActivityEgammaRegionalRecoTrackerSequence = cms.Sequence(process.hltEcalActivityEgammaRegionalPixelSeedGenerator+process.hltEcalActivityEgammaRegionalCkfTrackCandidates+process.hltEcalActivityEgammaRegionalCTFFinalFitWithMaterial)


process.recoGenJets = cms.Sequence(process.kt4GenJets+process.kt6GenJets+process.iterativeCone5GenJets+process.ak5GenJets+process.ak7GenJets)


process.HLTBeginSequenceCalibration = cms.Sequence(process.hltCalibrationEventsFilter+process.hltGtDigis)


process.HLTDoRegionalEgammaEcalSequence = cms.Sequence(process.hltESRawToRecHitFacility+process.hltEcalRawToRecHitFacility+process.hltEcalRegionalEgammaFEDs+process.hltEcalRegionalEgammaRecHit+process.hltESRegionalEgammaRecHit)


process.HLTDoRegionalJetEcalSequence = cms.Sequence(process.hltEcalRawToRecHitFacility+process.hltEcalRegionalJetsFEDs+process.hltEcalRegionalJetsRecHit)


process.HLTPixelMatchElectronL1IsoTrackingSequence = cms.Sequence(process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso)


process.HLTMulti5x5SuperClusterL1NonIsolated = cms.Sequence(process.hltMulti5x5BasicClustersL1NonIsolated+process.hltMulti5x5SuperClustersL1NonIsolated+process.hltMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated+process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolatedTemp+process.hltCorrectedMulti5x5EndcapSuperClustersWithPreshowerL1NonIsolated)


process.HLTDoLocalStripSequence = cms.Sequence(process.hltSiStripRawToClustersFacility+process.hltSiStripClusters)


process.HLTRecopixelvertexingSequence = cms.Sequence(process.hltPixelTracks+process.hltPixelVertices)


process.HLTBeginSequenceBPTX = cms.Sequence(process.hltTriggerType+process.HLTL1UnpackerSequence+process.hltBPTXCoincidence+process.HLTBeamSpot)


process.pgen_genonly = cms.Sequence(cms.SequencePlaceholder("randomEngineStateProducer"))


process.HLTPixelMatchElectronL1NonIsoTrackingSequence = cms.Sequence(process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso)


process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence = cms.Sequence(process.hltL1NonIsoEgammaRegionalPixelSeedGenerator+process.hltL1NonIsoEgammaRegionalCkfTrackCandidates+process.hltL1NonIsoEgammaRegionalCTFFinalFitWithMaterial)


process.HLTBTagIPSequenceL25 = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.hltSelector4Jets+process.hltBLifetimeL25Jets+process.hltBLifetimeL25Associator+process.hltBLifetimeL25TagInfos+process.hltBLifetimeL25BJetTags)


process.recoAllGenJets = cms.Sequence(process.sisCone5GenJets+process.sisCone7GenJets+process.kt4GenJets+process.kt6GenJets+process.iterativeCone5GenJets+process.ak5GenJets+process.ak7GenJets+process.gk5GenJets+process.gk7GenJets+process.ca4GenJets+process.ca6GenJets)


process.HLTL2muonisorecoSequence = cms.Sequence(process.hltEcalRawToRecHitFacility+process.hltEcalRegionalMuonsFEDs+process.hltEcalRegionalMuonsRecHit+process.HLTDoLocalHcalSequence+process.hltTowerMakerForMuons+process.hltL2MuonIsolations)


process.HLTCaloTausCreatorRegionalSequence = cms.Sequence(process.HLTDoRegionalJetEcalSequence+process.HLTDoLocalHcalSequence+process.hltTowerMakerForJets+process.hltCaloTowersTau1Regional+process.hltIconeTau1Regional+process.hltCaloTowersTau2Regional+process.hltIconeTau2Regional+process.hltCaloTowersTau3Regional+process.hltIconeTau3Regional+process.hltCaloTowersTau4Regional+process.hltIconeTau4Regional+process.hltCaloTowersCentral1Regional+process.hltIconeCentral1Regional+process.hltCaloTowersCentral2Regional+process.hltIconeCentral2Regional+process.hltCaloTowersCentral3Regional+process.hltIconeCentral3Regional+process.hltCaloTowersCentral4Regional+process.hltIconeCentral4Regional)


process.endOfProcess = cms.Sequence(process.MEtoEDMConverter)


process.recoGenMET = cms.Sequence(process.genMetCalo+process.genMetCaloAndNonPrompt+process.genMetTrue+process.genMetIC5GenJets)


process.HLTMuTrackJpsiPixelRecoSequence = cms.Sequence(process.HLTDoLocalPixelSequence+process.hltPixelTracks+process.hltMuTrackJpsiPixelTrackSelector+process.hltMuTrackJpsiPixelTrackCands)


process.HLTmuonlocalrecoSequence = cms.Sequence(process.hltMuonDTDigis+process.hltDt1DRecHits+process.hltDt4DSegments+process.hltMuonCSCDigis+process.hltCsc2DRecHits+process.hltCscSegments+process.hltMuonRPCDigis+process.hltRpcRecHits)


process.recoAllGenJetsNoNu = cms.Sequence(process.sisCone5GenJetsNoNu+process.sisCone7GenJetsNoNu+process.kt4GenJetsNoNu+process.kt6GenJetsNoNu+process.iterativeCone5GenJetsNoNu+process.ak5GenJetsNoNu+process.ak7GenJetsNoNu+process.gk5GenJetsNoNu+process.gk7GenJetsNoNu+process.ca4GenJetsNoNu+process.ca6GenJetsNoNu)


process.HLTPFTauSequence = cms.Sequence(process.hltPFTauJetTracksAssociator+process.hltPFTauTagInfo+process.hltPFTaus+process.hltPFTauTrackFindingDiscriminator+process.hltPFTauTrackPt5Discriminator+process.hltPFTauLooseIsolationDiscriminator+process.hltPFTauIsolationDiscriminator+process.hltSelectedPFTausTrackFinding+process.hltSelectedPFTausTrackPt5+process.hltSelectedPFTausTrackFindingIsolation+process.hltSelectedPFTausTrackFindingLooseIsolation+process.hltSelectedPFTausTrackPt5Isolation+process.hltConvPFTausTrackFinding+process.hltConvPFTausTrackFindingIsolation+process.hltConvPFTausTrackFindingLooseIsolation+process.hltConvPFTaus+process.hltConvPFTausTrackPt5+process.hltConvPFTausTrackPt5Isolation)


process.hiRecoGenJets = cms.Sequence(process.iterativeCone5HiGenJets+process.iterativeCone7HiGenJets+process.ak5HiGenJets+process.ak7HiGenJets+process.kt4HiGenJets+process.kt6HiGenJets)


process.HLTL3muonTkCandidateSequence = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL3TrajSeedOIState+process.hltL3TrackCandidateFromL2OIState+process.hltL3TkTracksFromL2OIState+process.hltL3MuonsOIState+process.hltL3TrajSeedOIHit+process.hltL3TrackCandidateFromL2OIHit+process.hltL3TkTracksFromL2OIHit+process.hltL3MuonsOIHit+process.hltL3TkFromL2OICombination+process.hltL3TrajSeedIOHit+process.hltL3TrackCandidateFromL2IOHit+process.hltL3TkTracksFromL2IOHit+process.hltL3MuonsIOHit+process.hltL3TrajectorySeed+process.hltL3TrackCandidateFromL2)


process.HLTBeginSequence = cms.Sequence(process.hltTriggerType+process.HLTL1UnpackerSequence+process.HLTBeamSpot)


process.HLTDoJet40HTRecoSequence = cms.Sequence(process.hltJet40Ht)


process.HLTPFJetsSequence = cms.Sequence(process.hltAntiKT5PFJets+process.hltAntiKT5ConvPFJets)


process.recoAllGenJetsNoMuNoNu = cms.Sequence(process.sisCone5GenJetsNoMuNoNu+process.sisCone7GenJetsNoMuNoNu+process.kt4GenJetsNoMuNoNu+process.kt6GenJetsNoMuNoNu+process.iterativeCone5GenJetsNoMuNoNu+process.ak5GenJetsNoMuNoNu+process.ak7GenJetsNoMuNoNu+process.gk5GenJetsNoMuNoNu+process.gk7GenJetsNoMuNoNu+process.ca4GenJetsNoMuNoNu+process.ca6GenJetsNoMuNoNu)


process.HLTBeginSequenceNZS = cms.Sequence(process.hltTriggerType+process.hltL1EventNumberNZS+process.HLTL1UnpackerSequence+process.hltBPTXCoincidence+process.HLTBeamSpot)


process.HLTStoppedHSCPJetSequence = cms.Sequence(process.hltStoppedHSCPTowerMakerForAll+process.hltStoppedHSCPIterativeCone5CaloJets)


process.HLTDoEGammaPixelSequence = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds)


process.HLTL2TauJetsSequence = cms.Sequence(process.HLTCaloTausCreatorRegionalSequence+process.hltL2TauJets)


process.SimL1MuTrackFinders = cms.Sequence(process.simCsctfTrackDigis+process.simDttfDigis+process.simCsctfDigis)


process.HLTEgammaR9IDSequence = cms.Sequence(process.hltL1IsoR9ID+process.hltL1NonIsoR9ID)


process.HLTTrackReconstructionForJets = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.HLTDoLocalStripSequence+process.hltPFJetPixelSeeds+process.hltPFJetCkfTrackCandidates+process.hltPFJetCtfWithMaterialTracks+process.hltPFlowTrackSelectionHighPurity)


process.HLTBTagIPSequenceL3SingleTop = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltBLifetimeL3JetsSingleTop+process.hltBLifetimeRegionalPixelSeedGeneratorSingleTop+process.hltBLifetimeRegionalCkfTrackCandidatesSingleTop+process.hltBLifetimeRegionalCtfWithMaterialTracksSingleTop+process.hltBLifetimeL3AssociatorSingleTop+process.hltBLifetimeL3TagInfosSingleTop+process.hltBLifetimeL3BJetTagsSingleTop)


process.calDigi = cms.Sequence(process.ecalDigiSequence+process.hcalDigiSequence+process.castorDigiSequence)


process.HLTEle8CaloIdLCaloIsoVLNoL1SeedSequence = cms.Sequence(process.HLTEcalActivitySequence+process.hltEG8EtFilterUnseeded+process.hltUnseededR9shape+process.hltEle8CaloIdLCaloIsoVLNoL1SeedR9ShapeFilter+process.hltActivityPhotonClusterShape+process.hltEle8CaloIdLCaloIsoVLNoL1SeedClusterShapeFilter+process.hltActivityPhotonEcalIsol+process.hltEle8CaloIdLCaloIsoVLNoL1SeedEcalIsolFilter+process.hltActivityPhotonHcalForHE+process.hltEle8CaloIdLCaloIsoVLNoL1SeedHEFilter+process.hltActivityPhotonHcalIsol+process.hltEle8CaloIdLCaloIsoVLNoL1SeedHcalIsolFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltEle8CaloIdLCaloIsoVLNoL1SeedPixelMatchFilter)


process.HLTDoCaloSequence = cms.Sequence(process.hltEcalRawToRecHitFacility+process.hltEcalRegionalRestFEDs+process.hltEcalRecHitAll+process.HLTDoLocalHcalSequence+process.hltTowerMakerForAll)


process.HLTBTagIPSequenceL3 = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltBLifetimeRegionalPixelSeedGenerator+process.hltBLifetimeRegionalCkfTrackCandidates+process.hltBLifetimeRegionalCtfWithMaterialTracks+process.hltBLifetimeL3Associator+process.hltBLifetimeL3TagInfos+process.hltBLifetimeL3BJetTags)


process.HLTL2muonrecoNocandSequence = cms.Sequence(process.HLTmuonlocalrecoSequence+process.hltL2MuonSeeds+process.hltL2Muons)


process.HLTBTagIPSequenceL3EleJetSingleTop = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltBLifetimeL3EleJetsSingleTop+process.hltBLifetimeRegionalPixelSeedGeneratorEleJetSingleTop+process.hltBLifetimeRegionalCkfTrackCandidatesEleJetSingleTop+process.hltBLifetimeRegionalCtfWithMaterialTracksEleJetSingleTop+process.hltBLifetimeL3AssociatorEleJetSingleTop+process.hltBLifetimeL3TagInfosEleJetSingleTop+process.hltBLifetimeL3BJetTagsEleJetSingleTop)


process.HLTBTagIPSequenceL25SingleTop = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.hltGetJetsfromBJet40Central+process.hltSelectorJetsSingleTop+process.hltBLifetimeL25JetsSingleTop+process.hltBLifetimeL25AssociatorSingleTop+process.hltBLifetimeL25TagInfosSingleTop+process.hltBLifetimeL25BJetTagsSingleTop)


process.HLTMuTrackJpsiTrackRecoSequence = cms.Sequence(process.HLTDoLocalStripSequence+process.hltMuTrackJpsiTrackSeeds+process.hltMuTrackJpsiCkfTrackCandidates+process.hltMuTrackJpsiCtfTracks+process.hltMuTrackJpsiCtfTrackCands)


process.hiGenJets = cms.Sequence(process.hiGenParticlesForJets+process.hiRecoGenJets)


process.genJetMET = cms.Sequence(process.genJetParticles+process.recoGenJets+process.genMETParticles+process.recoGenMET)


process.HLTL1IsolatedEcalClustersSequence = cms.Sequence(process.hltHybridSuperClustersL1Isolated+process.hltCorrectedHybridSuperClustersL1Isolated+process.HLTMulti5x5SuperClusterL1Isolated)


process.pgen = cms.Sequence(cms.SequencePlaceholder("randomEngineStateProducer")+process.VertexSmearing+process.GeneInfo+process.genJetMET)


process.HLTParticleFlowSequence = cms.Sequence(process.HLTPreshowerSequence+process.hltParticleFlowRecHitECAL+process.hltParticleFlowRecHitHCAL+process.hltParticleFlowRecHitPS+process.hltParticleFlowClusterECAL+process.hltParticleFlowClusterHCAL+process.hltParticleFlowClusterHFEM+process.hltParticleFlowClusterHFHAD+process.hltParticleFlowClusterPS+process.hltLightPFTracks+process.hltParticleFlowBlock+process.hltParticleFlow)


process.HLTBTagIPSequenceL25EleJetSingleTop = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.hltGetJetsfrom1EleCleanBJet40Central+process.hltSelectorEleJetsSingleTop+process.hltBLifetimeL25JetsEleJetSingleTop+process.hltBLifetimeL25AssociatorEleJetSingleTop+process.hltBLifetimeL25TagInfosEleJetSingleTop+process.hltBLifetimeL25BJetTagsEleJetSingleTop)


process.HLTL3muonrecoNocandSequence = cms.Sequence(process.HLTL3muonTkCandidateSequence+process.hltL3TkTracksFromL2+process.hltL3MuonsLinksCombination+process.hltL3Muons)


process.pgen_hi = cms.Sequence(cms.SequencePlaceholder("randomEngineStateProducer")+process.VertexSmearing+process.hiGenParticles+process.hiGenJets)


process.HLTBeginSequenceAntiBPTX = cms.Sequence(process.hltTriggerType+process.HLTL1UnpackerSequence+process.hltBPTXAntiCoincidence+process.HLTBeamSpot)


process.HLTL1NonIsolatedEcalClustersSequence = cms.Sequence(process.hltHybridSuperClustersL1NonIsolated+process.hltCorrectedHybridSuperClustersL1NonIsolatedTemp+process.hltCorrectedHybridSuperClustersL1NonIsolated+process.HLTMulti5x5SuperClusterL1NonIsolated)


process.HLTBTagMuDiJet60SequenceL25 = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltBSoftMuonGetJetsFromDiJet60+process.hltSelector4JetsDiJet60+process.hltBSoftMuonDiJet60L25Jets+process.hltBSoftMuonDiJet60L25TagInfos+process.hltBSoftMuonDiJet60L25BJetTagsByDR)


process.HLTL2muonrecoSequence = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltL2MuonCandidates)


process.HLTSingleElectronEt17CaloIdIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG17EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG17R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG17CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG17CaloIdLCaloIsoVLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG17CaloIdLCaloIsoVLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG17CaloIdLCaloIsoVLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle17CaloIdLCaloIsoVLPixelMatchFilter)


process.HLTPhoton32CaloIdLPhoton26CaloIdLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG32EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG32R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG32CaloIdLHEFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG32CaloIdLClusterShapeFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG26EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG26R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltPhoton32CaloIdLPhoton26CaloIdLEgammaLHEDoubleFilter+process.hltActivityPhotonClusterShape+process.hltPhoton32CaloIdLPhoton26CaloIdLEgammaClusterShapeDoubleFilter)


process.HLTEle17CaloIdIsoEle8CaloIdIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG17EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG17R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG17CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG17CaloIdLCaloIsoVLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG17CaloIdLCaloIsoVLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG17CaloIdLCaloIsoVLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle17CaloIdLCaloIsoVLPixelMatchFilter+process.HLTEcalActivitySequence+process.hltDoubleEG8EtFilterUnseeded+process.hltActivityPhotonClusterShape+process.hltEle17CaloIdIsoEle8CaloIdIsoClusterShapeDoubleFilter+process.hltActivityPhotonEcalIsol+process.hltEle17CaloIdIsoEle8CaloIdIsoEcalIsolDoubleFilter+process.hltActivityPhotonHcalForHE+process.hltEle17CaloIdIsoEle8CaloIdIsoHEDoubleFilter+process.hltActivityPhotonHcalIsol+process.hltEle17CaloIdIsoEle8CaloIdIsoHcalIsolDoubleFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltEle17CaloIdIsoEle8CaloIdIsoPixelMatchDoubleFilter)


process.HLTDoEGammaStartupSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate)


process.HLTEle45CaloIdVTTrkIdTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG45EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle45CaloIdVTTrkIdTR9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle45CaloIdVTTrkIdTClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle45CaloIdVTTrkIdTHEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle45CaloIdVTTrkIdTPixelMatchFilter+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltEle45CaloIdVTTrkIdTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle45CaloIdTTrkIdTDetaFilter+process.hltEle45CaloIdVTTrkIdTDphiFilter)


process.HLTPFJetTriggerSequence = cms.Sequence(process.HLTTrackReconstructionForJets+process.HLTParticleFlowSequence+process.HLTPFJetsSequence)


process.HLTPhoton26R9IdPhoton18CaloIdLIsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsoR9ID+process.hltL1NonIsoR9ID+process.hltEG26R9IdFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HEFilter+process.hltActivityPhotonClusterShape+process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaClusterShapeFilterUnseeded+process.hltActivityPhotonEcalIsol+process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaEcalIsolFilterUnseeded+process.hltActivityPhotonHcalIsol+process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaHcalIsolFilterUnseeded+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTEcalActivityEgammaRegionalRecoTrackerSequence+process.hltActivityPhotonHollowTrackIsol+process.hltPhoton26R9IdPhoton18CaloIdLIsoVLEgammaTrackIsolFilterUnseeded)


process.HLTBTagMuDiJet20Mu5SelSequenceL3 = cms.Sequence(process.HLTL3muonrecoNocandSequence+process.hltBSoftMuonDiJet20Mu5L3+process.hltBSoftMuonDiJet20Mu5SelL3TagInfos+process.hltBSoftMuonDiJet20Mu5SelL3BJetTagsByDR)


process.HLTPhoton30CaloIdVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG15+process.hltEG30EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG30R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG30CaloIdVLClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG30CaloIdVLHEFilter)


process.HLTEle15CaloIdVTTrkIdTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG15EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG15R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG15CaloIdTClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle15CaloIdVTTrkIdTHEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle15CaloIdVTTrkIdTPixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle15CaloIdVTTrkIdTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle15CaloIdVTTrkIdTDetaFilter+process.hltEle15CaloIdVTTrkIdTDphiFilter)


process.HLTBTagMuDiJet20SequenceL25 = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltBSoftMuonGetJetsFromDiJet20+process.hltSelector4JetsDiJet20+process.hltBSoftMuonDiJet20L25Jets+process.hltBSoftMuonDiJet20L25TagInfos+process.hltBSoftMuonDiJet20L25BJetTagsByDR)


process.HLTPhoton75CaloIdVLIsoLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG75EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG75R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG75CaloIdVLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton75CaloIdVLIsoLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton75CaloIdVLIsoLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton75CaloIdVLIsoLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton75CaloIdVLIsoLTrackIsoFilter)


process.HLTPhoton20CaloIdVTIsoTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG20EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG20R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltPhoton20CaloIdVTIsoTClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton20CaloIdVTIsoTEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton20CaloIdVTIsoTHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton20CaloIdVTIsoTHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton20CaloIdVTIsoTTrackIsoFilter)


process.HLTEle90NoSpikeFilterSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG90EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle90NoSpikeFilterR9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle90NoSpikeFilterClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle90NoSpikeFilterHEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle90NoSpikeFilterPixelMatchFilter)


process.HLTSingleElectronEt10HT200L1NonIsoHLTCaloIdLTrkIdVLCaloIsolVLTrkIsolVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1EG5HTT75+process.hltEG10EtFilterL1EG5HTT75+process.HLTEgammaR9ShapeSequence+process.hltEG10R9ShapeFilterEG5HTT75+process.HLTDoEgammaClusterShapeSequence+process.hltEG10CaloIdLClusterShapeFilterEG5HTT75+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG10CaloIdTCaloIsoVLEcalIsolFilterEG5HTT75+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200HcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltL1NonIsoHLTCaloIsolLSingleElectronEt10HT200PixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLSingleElectronEt10HT200OneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DetaFilter+process.hltL1NonIsoHLTCaloIsolLTrkIsolLCaloIdLTrkIdLSingleElectronEt10HT200DphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltL1NonIsoHLTCaloIsolLTrkIsolLSingleElectronEt10HT200TrackIsolFilter)


process.HLT2DisplacedHT250SequenceL3 = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.HLTDoLocalStripSequence+process.hltDisplacedHT250RegionalPixelSeedGenerator+process.hltDisplacedHT250RegionalCkfTrackCandidates+process.hltDisplacedHT250RegionalCtfWithMaterialTracks+process.hltDisplacedHT250L3Associator+process.hltDisplacedHT250L3TagInfos+process.hltDisplacedHT250L3JetTags+process.hlt2DisplacedHT250L3Filter)


process.HLTSinglePhoton70CaloIdLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG70EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG70R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG70CaloIdLClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG70CaloIdLHEFilter)


process.HLTBTagMuDiJet80SequenceL25 = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltBSoftMuonGetJetsFromDiJet80+process.hltSelector4JetsDiJet80+process.hltBSoftMuonDiJet80L25Jets+process.hltBSoftMuonDiJet80L25TagInfos+process.hltBSoftMuonDiJet80L25BJetTagsByDR)


process.HLTPhoton26CaloIdLIsoVLPhoton18Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG26CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG26CaloIdLIsoVLEcalIsoFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG26CaloIdLIsoVLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltEG26CaloIdLIsoVLTrackIsoFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HELastFilter)


process.HLTRegionalTowerMakerForJetsSequence = cms.Sequence(process.HLTDoRegionalJetEcalSequence+process.HLTDoLocalHcalSequence+process.hltTowerMakerForJets)


process.HLTDoubleEle8HTT50L1NonIsoHLTCaloIdLSequence = cms.Sequence(process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1DoubleEG5HTT50+process.hltDoubleEG8EtFilterL1DoubleEG5HTT50+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50ClusterShapeFilter+process.HLTEgammaR9ShapeSequence+process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50R9ShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTCaloIdLDoubleEle8HTT50PixelMatchFilter)


process.HLTMu5DoubleEle8L1NonIsoHLTnonIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1Mu3EG5+process.hltEG8EtFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG8R9ShapeFilterMu3EG5+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG8HEFilterMu3EG5+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEG8PixelMatchFilterMu3EG5+process.HLTEcalActivitySequence+process.hltDoubleEG8EtFilterUnseeded+process.hltUnseededR9shape+process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandR9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandHEFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltDoubleEG8NoCandPixelMatchFilter)


process.doAllDigi = cms.Sequence(process.trDigi+process.calDigi+process.muonDigi)


process.HLTDoubleEle8HTT50L1NonIsoHLTCaloIdTSequence = cms.Sequence(process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1DoubleEG5HTT50+process.hltDoubleEG8EtFilterL1DoubleEG5HTT50+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50ClusterShapeFilter+process.HLTEgammaR9ShapeSequence+process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50R9ShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTCaloIdTDoubleEle8HTT50PixelMatchFilter)


process.HLTSinglePhoton60CaloIdLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG60EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG60R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG60CaloIdLClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG60CaloIdLHEFilter)


process.HLTPhoton50CaloIdVLIsoLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG50EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG50R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG50CaloIdVLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton50CaloIdVLIsoLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton50CaloIdVLIsoLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton50CaloIdVLIsoLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton50CaloIdVLIsoLTrackIsoFilter)


process.SimL1Emulator = cms.Sequence(process.simRctDigis+process.simGctDigis+process.SimL1MuTriggerPrimitives+process.SimL1MuTrackFinders+process.simRpcTriggerDigis+process.simGmtDigis+process.SimL1TechnicalTriggers+process.simGtDigis)


process.HLTPhoton20CaloIdVTIsoTMu8Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1Mu3EG5+process.hltEG20EtFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG20R9ShapeFilterMu3EG5+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltPhoton20CaloIdVTIsoTMu8ClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton20CaloIdVTIsoTMu8EcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton20CaloIdVTIsoTMu8HEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton20CaloIdVTIsoTMu8HcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton20CaloIdVTIsoTMu8TrackIsoFilter)


process.HLTBTagMuDiJet80Mu9SelSequenceL3 = cms.Sequence(process.HLTL3muonrecoNocandSequence+process.hltBSoftMuonDiJet80Mu9L3+process.hltBSoftMuonDiJet80Mu9SelL3TagInfos+process.hltBSoftMuonDiJet80Mu9SelL3BJetTagsByDR)


process.HLTDoubleMu5Ele8L1NonIsoHLTCaloIdLTrkIdVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1Mu3EG5+process.hltEG8EtFilterMu3EG5+process.HLTDoEgammaClusterShapeSequence+process.hltEG8CaloIdLClusterShapeFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG8CaloIdLR9ShapeFilterMu3EG5+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG8CaloIdLHEFilterMu3EG5+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEG8CaloIdLPixelMatchFilterMu3EG5+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilterRegionalMu3EG5+process.HLTDoElectronDetaDphiSequence+process.hltEle8CaloIdLTrkIdVLDetaFilterMu3EG5+process.hltEle8CaloIdLTrkIdVLDphiFilterMu3EG5)


process.HLTDoublePhoton33Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG33EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG33R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG33HEFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG33EtFilterUnseededTight+process.hltUnseededR9shape+process.hltDoublePhoton33EgammaR9ShapeDoubleFilter+process.hltActivityPhotonHcalForHE+process.hltDoublePhoton33EgammaLHEDoubleFilter)


process.HLTL2muonrecoSequenceNoVtx = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltL2MuonCandidatesNoVtx)


process.HLTEle8CaloIdLTrkIdVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG5+process.hltEG8EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle8R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle8CaloIdLCaloIsoVLClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle8CaloIdLTrkIdVLHEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle8CaloIdLTrkIdVLPixelMatchFilter+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltEle8CaloIdLTrkIdVLDetaFilter+process.hltEle8CaloIdLTrkIdVLDphiFilter)


process.HLTSingleElectronEt10HT200L1NonIsoHLTCaloIdTTrkIdTCaloIsolVLTrkIsolVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1EG5HTT75+process.hltEG10EtFilterL1EG5HTT75+process.HLTEgammaR9ShapeSequence+process.hltEG10R9ShapeFilterEG5HTT75+process.HLTDoEgammaClusterShapeSequence+process.hltEG10CaloIdTClusterShapeFilterEG5HTT75+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG10CaloIdTCaloIsoVLEcalIsolFilterEG5HTT75+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG10CaloIdTCaloIsoVLHEFilterEG5HTT75+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG10CaloIdTCaloIsoVLHcalIsolFilterEG5HTT75+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEG10CaloIdTCaloIsoVLPixelMatchFilterEG5HTT75+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLOneOEMinusOneOPFilterEG5HTT75+process.HLTDoElectronDetaDphiSequence+process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDetaFilterEG5HTT75+process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLDphiFilterEG5HTT75+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltEle10CaloIdTTrkIdTCaloIsoVLTrkIsoVLTrackIsolFilterEG5HTT75)


process.HLT2DisplacedHT250SequenceL25 = cms.Sequence(process.HLTDoLocalPixelSequence+process.HLTRecopixelvertexingSequence+process.hltDisplacedHT250L25Associator+process.hltDisplacedHT250L25TagInfos+process.hltDisplacedHT250L25JetTags+process.hlt2DisplacedHT250L25Filter)


process.HLTEle27CaloIdTCaloIsoTTrkIdTTrkIsoTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG15+process.hltEG27EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltEle27CaloIdTCaloIsoTTrkIdTTrkIsoTTrackIsoFilter)


process.pgen_himix = cms.Sequence(cms.SequencePlaceholder("randomEngineStateProducer")+process.matchVtx+process.hiGenParticles+process.hiGenJets)


process.HLTPhoton36CaloIdLPhoton22CaloIdLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG36EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG36R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG36CaloIdLHEFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG36CaloIdLClusterShapeFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG22EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG22R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltPhoton36CaloIdLPhoton22CaloIdLEgammaLHEDoubleFilter+process.hltActivityPhotonClusterShape+process.hltPhoton36CaloIdLPhoton22CaloIdLEgammaClusterShapeDoubleFilter)


process.HLTEle25CaloIdVTCaloTrkIdSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG25EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle25CaloIdVTTrkIdTR9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle25CaloIdVTTrkIdTClusterShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle25CaloIdVTTrkIdTHEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle25CaloIdVTTrkIdTPixelMatchFilter+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltEle25CaloIdVTTrkIdTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle25CaloIdVTTrkIdTDetaFilter+process.hltEle25CaloIdVTTrkIdTDphiFilter)


process.HLTDoubleMu5Ele8L1NonIsoHLTnonIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1Mu3EG5+process.hltEG8EtFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG8R9ShapeFilterMu3EG5+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG8HEFilterMu3EG5+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEG8PixelMatchFilterMu3EG5)


process.HLTEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG15EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG15R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG15CaloIdTClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTEcalIsolFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTHcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTPixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDetaFilter+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTDphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltEle15CaloIdVTTrkIdTCaloIsoTTrkIsoTTrackIsolFilter)


process.HLTBTagMuDiJet100SequenceL25 = cms.Sequence(process.HLTL2muonrecoNocandSequence+process.hltBSoftMuonGetJetsFromDiJet100+process.hltSelector4JetsDiJet100+process.hltBSoftMuonDiJet100L25Jets+process.hltBSoftMuonDiJet100L25TagInfos+process.hltBSoftMuonDiJet100L25BJetTagsByDR)


process.HLTRegionalRecoJetSequenceAK5Corrected = cms.Sequence(process.HLTRegionalTowerMakerForJetsSequence+process.hltAntiKT5CaloJetsRegional+process.hltAntiKT5L2L3CorrCaloJetsRegional+process.hltL1MatchedJetsRegional+process.hltJetIDPassedJetsRegional)


process.HLTEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8Mass30Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG17EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG17R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8ClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8EcalIsolFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8PixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8OneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DetaFilter+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8DphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8TrackIsolFilter+process.HLTEcalActivitySequence+process.hltDoubleEG8EtFilterUnseeded+process.hltActivityPhotonHcalForHE+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8HEDoubleFilter+process.hltEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8PMMassFilter)


process.HLTEle17CaloIdTTrkIdTCaloIsoVLTrkIsoVLEle8CaloIdTTrkIdTCaloIsoVLTrkIsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG17EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG17R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchFilter+process.hltCkf3HitL1IsoTrackCandidates+process.hltCtf3HitL1IsoWithMaterialTracks+process.hltPixelMatch3HitElectronsL1Iso+process.hltCkf3HitL1NonIsoTrackCandidates+process.hltCtf3HitL1NonIsoWithMaterialTracks+process.hltPixelMatch3HitElectronsL1NonIso+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPFilter+process.hlt3HitElectronL1IsoDetaDphi+process.hlt3HitElectronL1NonIsoDetaDphi+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaFilter+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1Iso3HitElectronTrackIsol+process.hltL1NonIso3HitElectronTrackIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoTrackIsolFilter+process.HLTEcalActivitySequence+process.hltDoubleEG8EtFilterUnseeded+process.hltActivityPhotonClusterShape+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoClusterShapeDoubleFilter+process.hltActivityPhotonEcalIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoEcalIsolDoubleFilter+process.hltActivityPhotonHcalForHE+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHEDoubleFilter+process.hltActivityPhotonHcalIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoHcalIsolDoubleFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoPixelMatchDoubleFilter+process.hltCkf3HitActivityTrackCandidates+process.hltCtf3HitActivityWithMaterialTracks+process.hltPixelMatch3HitElectronsActivity+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoOneOEMinusOneOPDoubleFilter+process.hlt3HitElectronActivityDetaDphi+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDetaDoubleFilter+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoDphiDoubleFilter+process.HLTEcalActivityEgammaRegionalRecoTrackerSequence+process.hlt3HitElectronActivityTrackIsol+process.hltEle17TightIdLooseIsoEle8TightIdLooseIsoTrackIsolDoubleFilter)


process.HLTRecoMETSequence = cms.Sequence(process.HLTDoCaloSequence+process.hltMet)


process.HLTPhoton20CaloIdVLIsoLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG20EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG20R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG20CaloIdVLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton20CaloIdVLIsoLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton20CaloIdVLIsoLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton20CaloIdVLIsoLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton20CaloIdVLIsoLTrackIsoFilter)


process.HLTTripleElectronEt10L1NonIsoHLTNonIsoSequence = cms.Sequence(process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1TripleEG5+process.hltTripleEG10EtFilter+process.HLTEgammaR9ShapeSequence+process.hltL1NonIsoHLTNonIsoTripleElectronEt10R9ShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTNonIsoTripleElectronEt10HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTNonIsoTripleElectronEt10PixelMatchFilter)


process.pdigi = cms.Sequence(cms.SequencePlaceholder("randomEngineStateProducer")+cms.SequencePlaceholder("mix")+process.doAllDigi+process.trackingParticles+process.addPileupInfo)


process.HLTPhoton26IsoVLPhoton18IsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton26IsoVLEcalIsoFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton26IsoVLHcalIsoLastFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HEFilter+process.hltActivityPhotonEcalIsol+process.hltPhoton26IsoVLPhoton18IsoVLEgammaEcalIsolDoubleFilter+process.hltActivityPhotonHcalIsol+process.hltPhoton26IsoVLPhoton18IsoVLEgammaHcalIsolDoubleFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTEcalActivityEgammaRegionalRecoTrackerSequence+process.hltActivityPhotonHollowTrackIsol+process.hltPhoton26IsoVLPhoton18IsoVLEgammaTrackIsolDoubleFilter)


process.HLTPhoton20R9IdPhoton18R9IdSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG20EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG20R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton20R9IdPhoton18R9IdEgammaLHEFilter+process.HLTEgammaR9IDSequence+process.hltPhoton20R9IdPhoton18R9IdEgammaR9IDFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HEFilter+process.hltActivityR9ID+process.hltPhoton20R9IdPhoton18R9IdEgammaR9IDDoubleFilter)


process.HLTPhoton75CaloIdVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG75EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG75R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG75CaloIdVLClusterShapeFilter+process.hltL1IsolatedPhotonHcalForHE+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton75CaloIdVLHEFilter)


process.HLTRecoJetSequenceAK5Uncorrected = cms.Sequence(process.HLTDoCaloSequence+process.hltAntiKT5CaloJets)


process.HLTEle8Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG5+process.hltEG8EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle8R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle8HEFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle8PixelMatchFilter)


process.HLTPhoton26CaloIdLIsoVLPhoton18R9IdSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG26CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG26CaloIdLIsoVLEcalIsoFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG26CaloIdLIsoVLHcalIsoFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HEFilter+process.hltActivityR9ID+process.hltR9IdFilterUnseeded+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltEG26CaloIdLIsoVLTrackIsoFilter)


process.HLTPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG26CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG26CaloIdLIsoVLEcalIsoFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG26CaloIdLIsoVLHcalIsoLastFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HEFilter+process.hltActivityPhotonClusterShape+process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaClusterShapeDoubleFilter+process.hltActivityPhotonEcalIsol+process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaEcalIsolDoubleFilter+process.hltActivityPhotonHcalIsol+process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaHcalIsolDoubleFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTEcalActivityEgammaRegionalRecoTrackerSequence+process.hltActivityPhotonHollowTrackIsol+process.hltPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLEgammaTrackIsolDoubleFilter)


process.HLTEle17CaloIdLCaloIsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG17EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG17R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG17CaloIdLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEG17CaloIdLCaloIsoVLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG17CaloIdLCaloIsoVLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEG17CaloIdLCaloIsoVLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle17CaloIdLCaloIsoVLPixelMatchFilter)


process.HLTEle32CaloIdLCaloIsoVLSC17Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG32EtFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle32CaloIdLCaloIsoVLSC17ClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle32CaloIdLCaloIsoVLSC17EcalIsolFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle32CaloIdLCaloIsoVLSC17HEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle32CaloIdLCaloIsoVLSC17HcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle32CaloIdLCaloIsoVLSC17PixelMatchFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG17EtFilterUnseeded+process.hltActivityPhotonHcalForHE+process.hltEle32CaloIdLCaloIsoVLSC17HEDoubleFilter)


process.HLTRecoJetSequenceAK5Corrected = cms.Sequence(process.HLTRecoJetSequenceAK5Uncorrected+process.hltAntiKT5L2L3CorrCaloJets+process.hltJetIDPassedCorrJets)


process.HLTEle8CaloIdLCaloIsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG5+process.hltEG8EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle8R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle8CaloIdLCaloIsoVLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle8CaloIdLCaloIsoVLEcalIsolFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle8CaloIdLCaloIsoVLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle8CaloIdLCaloIsoVLHcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle8CaloIdLCaloIsoVLPixelMatchFilter)


process.HLTBTagMuDiJet60Mu7SelSequenceL3 = cms.Sequence(process.HLTL3muonrecoNocandSequence+process.hltBSoftMuonDiJet60Mu7L3+process.hltBSoftMuonDiJet60Mu7SelL3TagInfos+process.hltBSoftMuonDiJet60Mu7SelL3BJetTagsByDR)


process.HLTDoublePhoton5IsoVLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1DoubleEG2FwdVeto+process.hltDoublePhoton5IsoVLEtPhiFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltDoublePhoton5IsoVLEgammaHEFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltDoublePhoton5IsoVLEgammaEcalIsolFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltDoublePhoton5IsoVLEgammaHcalIsolFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltDoublePhoton5IsoVLEgammaTrackIsolFilter)


process.HLTPhoton30CaloIdVLIsoLSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG15+process.hltEG30EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG30R9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEG30CaloIdVLClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton30CaloIdVLIsoLEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton30CaloIdVLIsoLHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton30CaloIdVLIsoLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton30CaloIdVLIsoLTrackIsoFilter)


process.HLTL3muonrecoSequence = cms.Sequence(process.HLTL3muonrecoNocandSequence+process.hltL3MuonCandidates)


process.HLTMu5Ele8CaloIdLTrkIdVLEle8L1NonIsoHLTnonIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1Mu3EG5+process.hltEG8EtFilterMu3EG5+process.HLTDoEgammaClusterShapeSequence+process.hltEG8CaloIdLClusterShapeFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG8CaloIdLR9ShapeFilterMu3EG5+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG8CaloIdLHEFilterMu3EG5+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEG8CaloIdLPixelMatchFilterMu3EG5+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltEle8CaloIdLTrkIdVLOneOEMinusOneOPFilterRegionalMu3EG5+process.HLTDoElectronDetaDphiSequence+process.hltEle8CaloIdLTrkIdVLDetaFilterMu3EG5+process.hltEle8CaloIdLTrkIdVLDphiFilterMu3EG5+process.HLTEcalActivitySequence+process.hltDoubleEG8EtFilterUnseeded+process.hltUnseededR9shape+process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandR9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltL1NonIsoHLTNonIsoMu5DoubleEle8NoCandHEFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltDoubleEG8NoCandPixelMatchFilter)


process.HLTBTagMuDiJet100Mu9SelSequenceL3 = cms.Sequence(process.HLTL3muonrecoNocandSequence+process.hltBSoftMuonDiJet100Mu9L3+process.hltBSoftMuonDiJet100Mu9SelL3TagInfos+process.hltBSoftMuonDiJet100Mu9SelL3BJetTagsByDR)


process.HLTPhoton26IsoVLPhoton18Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEG26HEFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltPhoton26IsoVLEcalIsoFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltPhoton26IsoVLHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsolatedPhotonHollowTrackIsol+process.hltL1NonIsolatedPhotonHollowTrackIsol+process.hltPhoton26IsoVLTrackIsoFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HELastFilter)


process.HLTEle32CaloIdTCaloIsoTTrkIdTTrkIsoTSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG32EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTR9ShapeFilter+process.hltL1IsoHLTClusterShape+process.hltL1NonIsoHLTClusterShape+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTClusterShapeFilter+process.hltL1IsolatedPhotonEcalIsol+process.hltL1NonIsolatedPhotonEcalIsol+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTEcalIsoFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHEFilter+process.hltL1IsolatedPhotonHcalIsol+process.hltL1NonIsolatedPhotonHcalIsol+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTHcalIsoFilter+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL1IsoStartUpElectronPixelSeeds+process.hltL1NonIsoStartUpElectronPixelSeeds+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTPixelMatchFilter+process.hltCkfL1IsoTrackCandidates+process.hltCtfL1IsoWithMaterialTracks+process.hltPixelMatchElectronsL1Iso+process.hltCkfL1NonIsoTrackCandidates+process.hltCtfL1NonIsoWithMaterialTracks+process.hltPixelMatchElectronsL1NonIso+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTOneOEMinusOneOPFilter+process.hltElectronL1IsoDetaDphi+process.hltElectronL1NonIsoDetaDphi+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDetaFilter+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTDphiFilter+process.HLTL1IsoEgammaRegionalRecoTrackerSequence+process.HLTL1NonIsoEgammaRegionalRecoTrackerSequence+process.hltL1IsoElectronTrackIsol+process.hltL1NonIsoElectronTrackIsol+process.hltEle32CaloIdTCaloIsoTTrkIdTTrkIsoTTrackIsoFilter)


process.HLTSinglePhoton125L1NonIsolatedHLTNonIsoSequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG20+process.hltEG125EtFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton125HEFilter)


process.HLTPhoton26Photon18Sequence = cms.Sequence(process.HLTDoRegionalEgammaEcalSequence+process.HLTL1IsolatedEcalClustersSequence+process.HLTL1NonIsolatedEcalClustersSequence+process.hltL1IsoRecoEcalCandidate+process.hltL1NonIsoRecoEcalCandidate+process.hltEGRegionalL1SingleEG12+process.hltEG26EtFilter+process.HLTEgammaR9ShapeSequence+process.hltEG26R9ShapeFilter+process.HLTDoLocalHcalWithoutHOSequence+process.hltL1IsolatedPhotonHcalForHE+process.hltL1NonIsolatedPhotonHcalForHE+process.hltPhoton26Photon18EgammaLHEFilter+process.HLTEcalActivitySequence+process.hltDoubleIsoEG18EtFilterUnseeded+process.hltUnseededR9shape+process.hltDoubleIsoEG18R9ShapeFilter+process.hltActivityPhotonHcalForHE+process.hltDoubleIsoEG18HELastFilter)


process.HLTRSequence = cms.Sequence(process.HLTRecoJetSequenceAK5Corrected+process.HLTRecoMETSequence+process.hltRHemisphere)


process.HLTRecoJetSequencePrePF = cms.Sequence(process.HLTRecoJetSequenceAK5Uncorrected+process.hltAntiKT5CaloJetsEt5)


process.HLT_JetE30_NoBPTX_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleJet20NoBPTX+process.hltPreJetE30NoBPTX+process.HLTStoppedHSCPLocalHcalReco+process.HLTStoppedHSCPJetSequence+process.hltStoppedHSCPControl1CaloJetEnergy30+process.HLTEndSequence)


process.HLT_HT150_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT50+process.hltPreHT150+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT150+process.HLTEndSequence)


process.HLT_HcalCalibration_v1 = cms.Path(process.hltCalibrationEventsFilter+process.hltGtDigis+process.hltPreHcalCalibration+process.hltHcalCalibTypeFilter+process.HLTEndSequence)


process.HLT_Photon32_CaloIdL_Photon26_CaloIdL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton32CaloIdLPhoton26CaloIdL+process.HLTPhoton32CaloIdLPhoton26CaloIdLSequence+process.HLTEndSequence)


process.HLT_IsoMu17_v5 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreIsoMu17+process.hltL1SingleMu10L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu10L2Filtered10+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered10+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered17+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered17+process.HLTEndSequence)


process.HLT_Photon30_CaloIdVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG15+process.hltPrePhoton30CaloIdVL+process.HLTPhoton30CaloIdVLSequence+process.HLTEndSequence)


process.HLT_Ele32_CaloIdL_CaloIsoVL_SC17_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPreEle32CaloIdLCaloIsoVLSC17+process.HLTEle32CaloIdLCaloIsoVLSC17Sequence+process.HLTEndSequence)


process.HLT_Meff440_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreMeff440+process.HLTRecoJetSequenceAK5Corrected+process.hltMeff440+process.HLTEndSequence)


process.HLT_Ele8_CaloIdL_TrkIdVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG5+process.hltPreEle8CaloIdLTrkIdVL+process.HLTEle8CaloIdLTrkIdVLSequence+process.HLTEndSequence)


process.HLT_DoubleMu3_Quarkonium_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu3Quarkonium+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered2+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered3Quarkonium+process.hltDoubleMu3QuarkoniumL3Filtered+process.HLTEndSequence)


process.HLT_Ele27_CaloIdVT_CaloIsoT_TrkIdT_TrkIsoT_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG15+process.hltPreEle27CaloIdVTCaloIsoTTrkIdTTrkIsoT+process.HLTEle27CaloIdTCaloIsoTTrkIdTTrkIsoTSequence+process.HLTEndSequence)


process.HLT_L1Tech_HBHEHO_totalOR_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sTechTrigHCALNoise+process.hltPreTechTrigHCALNoise+process.HLTEndSequence)


process.HLT_TrackerCalibration_v1 = cms.Path(process.HLTBeginSequenceCalibration+process.hltPreTrackerCalibration+process.hltLaserAlignmentEventFilter+process.HLTEndSequence)


process.HLT_IsoMu17_CentralJet40_BTagIP_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreIsoMu17BTagIPCentJet40+process.hltL1Mu7CenJetL1MuFiltered0+process.HLTL2muonrecoSequence+process.hltL2Muon7+process.HLTL2muonisorecoSequence+process.hltIsoMu7CenJet40L2IsoFiltered7+process.HLTRecoJetSequenceAK5Corrected+process.hltBJet40Central+process.HLTBTagIPSequenceL25SingleTop+process.hltBLifetimeL25FilterSingleTop+process.HLTL3muonrecoSequence+process.hltIsoMu17CenJet40L3Filtered17+process.HLTL3muonisorecoSequence+process.hltIsoMu17CenJet40L3IsoFiltered17+process.HLTBTagIPSequenceL3SingleTop+process.hltBLifetimeL3FilterSingleTop+process.HLTEndSequence)


process.HLT_HT200_AlphaT0p60_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT75+process.hltPreHLTHT200AlphaT0p6+process.HLTRecoJetSequenceAK5Corrected+process.hltHT200AlphaT0p6+process.HLTEndSequence)


process.HLT_Photon70_CaloIdL_MHT50_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton70CaloIdLMHT50+process.HLTSinglePhoton70CaloIdLSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltMHT50+process.HLTEndSequence)


process.HLT_HT300_AlphaT0p52_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT300AlphaT0p52+process.HLTRecoJetSequenceAK5Corrected+process.hltHT300AlphaT0p52+process.HLTEndSequence)


process.HLT_QuadJet50_Jet40_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet50Jet40+process.HLTRecoJetSequenceAK5Corrected+process.hltPentaJet40Central+process.hltQuadJet50Central+process.HLTEndSequence)


process.HLT_DoubleMu5_Ele8_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreDoubleMu5Ele8+process.hltL1Mu3EG5L1DiMuFiltered3+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2DiMuFiltered3+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3DiMuFiltered5+process.HLTDoubleMu5Ele8L1NonIsoHLTnonIsoSequence+process.HLTEndSequence)


process.HLT_IsoMu30_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreIsoMu30+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu12L2Filtered12+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered12+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered30+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered30+process.HLTEndSequence)


process.HLT_PFMHT150_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1ETM30+process.hltPrePFMHT150+process.HLTRecoMETSequence+process.hltMET80+process.HLTRecoJetSequencePrePF+process.HLTTrackReconstructionForJets+process.HLTParticleFlowSequence+process.HLTPFJetsSequence+process.hltPFMHT150Filter+process.HLTEndSequence)


process.HLT_Mu5_Track2_Jpsi_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu3+process.hltPreMu5Track2Jpsi+process.hltMu5TrackJpsiL1Filtered0+process.HLTL2muonrecoSequence+process.hltMu5TrackJpsiL2Filtered3+process.HLTL3muonrecoSequence+process.hltMu5TrackJpsiL3Filtered3+process.HLTMuTrackJpsiPixelRecoSequence+process.hltMu5Track1JpsiPixelMassFiltered+process.HLTMuTrackJpsiTrackRecoSequence+process.hltMu5Track2JpsiTrackMassFiltered+process.HLTEndSequence)


process.HLT_ExclDiJet60_HFAND_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet36FwdVeto+process.hltPreExclDiJet60HFAND+process.HLTRecoJetSequenceAK5Corrected+process.hltExclDiJet60HFAND+process.HLTEndSequence)


process.HLT_Ele17_CaloIdT_TrkIdVL_CaloIsoVL_TrkIsoVL_Ele8_CaloIdT_TrkIdVL_CaloIsoVL_TrkIsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle17CaloIdTTrkIdTCaloIsoVLTrkIsoVLEle8CaloIdTTrkIdTCaloIsoVLTrkIsoVL+process.HLTEle17CaloIdTTrkIdTCaloIsoVLTrkIsoVLEle8CaloIdTTrkIdTCaloIsoVLTrkIsoVLSequence+process.HLTEndSequence)


process.HLT_CentralJet80_MET100_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreCenJet80MET100+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltCenJet80CentralRegional+process.HLTRecoMETSequence+process.hltMET100+process.HLTEndSequence)


process.HLT_Physics_v1 = cms.Path(process.HLTBeginSequence+process.hltPrePhysics+process.HLTEndSequence)


process.HLT_MR100_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleJet36Central+process.hltPreMR100+process.HLTRSequence+process.hltMR100+process.HLTEndSequence)


process.HLT_DoubleMu3_HT160_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu0HTT50+process.hltPreDoubleMu3HT160+process.hltL1Mu0HTT50L1DiMuFiltered0+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2DiMuFiltered0+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3DiMuFiltered3+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT160+process.HLTEndSequence)


process.HLT_DoubleJet70_ForwardBackward_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleForJet32EtaOpp+process.hltPreDoubleJet70ForwardBackward+process.HLTRecoJetSequenceAK5Corrected+process.hltDoubleJet70ForwardBackward+process.HLTEndSequence)


process.HLT_L1SingleJet36_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet36+process.hltPreL1SingleJet36+process.HLTEndSequence)


process.HLT_Ele45_CaloIdVT_TrkIdT_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPreEle45CaloIdVTTrkIdT+process.HLTEle45CaloIdVTTrkIdTSequence+process.HLTEndSequence)


process.HLT_PixelTracks_Multiplicity80_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sETT220+process.hltPrePixelTracksMultiplicity80+process.HLTDoLocalPixelSequence+process.hltPixelClusterShapeFilter+process.HLTRecopixelvertexingForHighMultSequence+process.hltPixelCandsForHighMult+process.hlt1HighMult80+process.HLTEndSequence)


process.HLT_HT550_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT550+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT550+process.HLTEndSequence)


process.HLT_Mu17_DiCentralJet30_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu17TriCenJet30+process.hltL1Mu7CenJetL1MuFiltered0+process.HLTL2muonrecoSequence+process.hltL2Muon7+process.HLTL3muonrecoSequence+process.hltL3Muon17+process.HLTRecoJetSequenceAK5Corrected+process.hltDiJet30Central+process.HLTEndSequence)


process.HLT_Photon20_R9Id_Photon18_R9Id_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton20R9IdPhoton18R9Id+process.HLTPhoton20R9IdPhoton18R9IdSequence+process.HLTEndSequence)


process.HLT_Ele17_CaloIdL_CaloIsoVL_Ele15_HFL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle17CaloIdLCaloIsoVLEle15HFL+process.HLTSingleElectronEt17CaloIdIsoSequence+process.HLTHFEM15Sequence+process.HLTEndSequence)


process.HLT_HT150_AlphaT0p70_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT75+process.hltPreHLTHT150AlphaT0p7+process.HLTRecoJetSequenceAK5Corrected+process.hltHT150AlphaT0p7+process.HLTEndSequence)


process.HLT_Mu15_LooseIsoPFTau20_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreMu15IsoPFTau20+process.hltL1SingleMu10L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu10L2Filtered10+process.HLTL3muonrecoSequence+process.hltL3Muon15+process.HLTRecoJetSequencePrePF+process.hltTauJet5+process.HLTPFJetTriggerSequence+process.hltPFJet20+process.HLTPFTauSequence+process.hltPFTau20Track+process.hltPFTau20TrackLooseIso+process.hltOverlapFilterMu15IsoPFTau20+process.HLTEndSequence)


process.HLT_Mu5_Ele8_CaloIdL_TrkIdVL_Ele8_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu5Ele8CaloIdLTrkIdVLEle8+process.hltL1Mu3EG5L1Filtered3+process.HLTL2muonrecoSequence+process.hltL2Mu3EG5L2Filtered3+process.HLTL3muonrecoSequence+process.hltMu3EG5L3Filtered5+process.HLTMu5Ele8CaloIdLTrkIdVLEle8L1NonIsoHLTnonIsoSequence+process.HLTEndSequence)


process.HLT_Ele25_CaloIdVT_TrkIdT_CentralJet30_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle25CaloIdVTTrkIdTCentralJet30+process.HLTEle25CaloIdVTCaloTrkIdSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets+process.hltEle25CaloIdVTTrkIdTCentralJet30Cleaned+process.HLTEndSequence)


process.HLT_Ele8_CaloIdL_CaloIsoVL_Jet40_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG5+process.hltPreEle8CaloIdLCaloIsoVLJet40+process.HLTEle8CaloIdLCaloIsoVLSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltAntiKT5L2L3CaloJetsEle8CaloIdLCaloIsoVLRemoved+process.hltJet40Ele8CaloIdLCaloIsoVLRemoved+process.HLTEndSequence)


process.HLT_ExclDiJet60_HFOR_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet36+process.hltPreExclDiJet60HFOR+process.HLTRecoJetSequenceAK5Corrected+process.hltExclDiJet60HFOR+process.HLTEndSequence)


process.HLT_DiJetAve100U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreDiJetAve100U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve100U+process.HLTEndSequence)


process.HLT_CentralJet80_MET65_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreCenJet80MET65+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltCenJet80CentralRegional+process.HLTRecoMETSequence+process.hltMET65+process.HLTEndSequence)


process.HLT_LogMonitor_v1 = cms.Path(process.hltGtDigis+process.hltPreLogMonitor+process.hltLogMonitorFilter+process.HLTEndSequence)


process.HLT_Mu17_TriCentralJet30_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu17TriCenJet30+process.hltL1Mu7CenJetL1MuFiltered0+process.HLTL2muonrecoSequence+process.hltL2Muon7+process.HLTL3muonrecoSequence+process.hltL3Muon17+process.HLTRecoJetSequenceAK5Corrected+process.hltTriJet30Central+process.HLTEndSequence)


process.HLT_BTagMu_DiJet100_Mu9_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu3Jet28Central+process.hltPreBTagMuDiJet100Mu9+process.HLTRecoJetSequenceAK5Corrected+process.hltBDiJet100Central+process.HLTBTagMuDiJet100SequenceL25+process.hltBSoftMuonDiJet100L25FilterByDR+process.HLTBTagMuDiJet100Mu9SelSequenceL3+process.hltBSoftMuonDiJet100Mu9SelL3FilterByDR+process.HLTEndSequence)


process.HLT_DoubleMu3_HT200_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu0HTT50+process.hltPreDoubleMu3HT160+process.hltL1Mu0HTT50L1DiMuFiltered0+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2DiMuFiltered0+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3DiMuFiltered3+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_Ele10_CaloIdL_CaloIsoVL_TrkIdVL_TrkIsoVL_HT200_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1EG5HTT75+process.hltPreEle10CaloIdLCaloIsoVLTrkIdVLTrkIsoVLHT200+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTSingleElectronEt10HT200L1NonIsoHLTCaloIdLTrkIdVLCaloIsolVLTrkIsolVLSequence+process.HLTEndSequence)


process.HLT_BeamGas_HF_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1BeamGasHf+process.hltPreL1BeamGasHf+process.hltHcalDigis+process.hltHfreco+process.hltHFAsymmetryFilter+process.HLTEndSequence)


process.HLT_HT150_AlphaT0p60_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT75+process.hltPreHLTHT150AlphaT0p6+process.HLTRecoJetSequenceAK5Corrected+process.hltHT150AlphaT0p6+process.HLTEndSequence)


process.HLT_L1SingleMuOpen_AntiBPTX_v1 = cms.Path(process.HLTBeginSequenceAntiBPTX+process.hltL1sL1SingleMuOpen+process.hltPreL1MuOpenAntiBPTX+process.hltL1MuOpenL1Filtered0+process.HLTEndSequence)


process.HLT_Ele25_CaloIdVT_TrkIdT_CentralJet40_BTagIP_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle25CaloIdVTTrkIdTCentralJet40BTagIP+process.HLTEle25CaloIdVTCaloTrkIdSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets+process.hltSingleEleCleanBJet40Central+process.HLTBTagIPSequenceL25EleJetSingleTop+process.hltBLifetimeL25FilterEleJetSingleTop+process.HLTBTagIPSequenceL3EleJetSingleTop+process.hltBLifetimeL3FilterEleJetSingleTop+process.HLTEndSequence)


process.HLT_BTagMu_DiJet60_Mu7_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu3Jet28Central+process.hltPreBTagMuDiJet60Mu7+process.HLTRecoJetSequenceAK5Corrected+process.hltBDiJet60Central+process.HLTBTagMuDiJet60SequenceL25+process.hltBSoftMuonDiJet60L25FilterByDR+process.HLTBTagMuDiJet60Mu7SelSequenceL3+process.hltBSoftMuonDiJet60Mu7SelL3FilterByDR+process.HLTEndSequence)


process.HLT_QuadJet50_BTagIP_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet50+process.HLTRecoJetSequenceAK5Corrected+process.hltQuadJet50Central+process.HLTBTagIPSequenceL25+process.hltBLifetimeL25Filter+process.HLTBTagIPSequenceL3+process.hltBLifetimeL3Filter+process.HLTEndSequence)


process.HLT_QuadJet60_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet60+process.HLTRecoJetSequenceAK5Corrected+process.hltQuadJet60+process.HLTEndSequence)


process.HLT_DiJetAve15U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet16+process.hltPreDiJetAve15U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve15U+process.HLTEndSequence)


process.HLT_L1TrackerCosmics_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sTrackerCosmics+process.hltPreTrackerCosmics+process.hltTrackerCosmicsPattern+process.HLTEndSequence)


process.HLT_Ele32_CaloIdVT_CaloIsoT_TrkIdT_TrkIsoT_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPreEle32CaloIdVTCaloIsoTTrkIdTTrkIsoT+process.HLTEle32CaloIdTCaloIsoTTrkIdTTrkIsoTSequence+process.HLTEndSequence)


process.HLT_Photon75_CaloIdVL_IsoL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton75CaloIdVLIsoL+process.HLTPhoton75CaloIdVLIsoLSequence+process.HLTEndSequence)


process.HLT_DoubleMu7_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu3+process.hltPreDoubleMu7+process.hltL1DoubleMuon3L1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuon3L2PreFiltered0+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered7+process.HLTEndSequence)


process.HLT_Photon26_IsoVL_Photon18_IsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26IsoVLPhoton18IsoVL+process.HLTPhoton26IsoVLPhoton18IsoVLSequence+process.HLTEndSequence)


process.HLT_HT200_AlphaT0p65_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT75+process.hltPreHLTHT200AlphaT0p65+process.HLTRecoJetSequenceAK5Corrected+process.hltHT200AlphaT0p65+process.HLTEndSequence)


process.HLT_Mu7_Track5_Jpsi_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu7Track5Jpsi+process.hltMu7TrackJpsiL1Filtered0+process.HLTL2muonrecoSequence+process.hltMu7TrackJpsiL2Filtered3+process.HLTL3muonrecoSequence+process.hltMu7TrackJpsiL3Filtered3+process.HLTMuTrackJpsiPixelRecoSequence+process.hltMu7Track4JpsiPixelMassFiltered+process.HLTMuTrackJpsiTrackRecoSequence+process.hltMu7Track5JpsiTrackMassFiltered+process.HLTEndSequence)


process.HLT_DoubleMu3_Upsilon_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu0Upsilon+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered2+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered3Upsilon+process.hltDoubleMu3UpsilonL3Filtered+process.HLTEndSequence)


process.HLT_Photon20_CaloIdVL_IsoL_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton20CaloIdVLIsoL+process.HLTPhoton20CaloIdVLIsoLSequence+process.HLTEndSequence)


process.HLT_Mu8_Photon20_CaloIdVT_IsoT_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu8Photon20CaloIdVTIsoT+process.HLTPhoton20CaloIdVTIsoTMu8Sequence+process.hltL1SingleMu3EG5L1Filtered0+process.HLTL2muonrecoSequence+process.hltSingleMu5EG5L2Filtered3+process.HLTL3muonrecoSequence+process.hltSingleMu8EG5L3Filtered8+process.HLTEndSequence)


process.HLT_HT350_AlphaT0p53_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT350AlphaT0p53+process.HLTRecoJetSequenceAK5Corrected+process.hltHT350AlphaT0p53+process.HLTEndSequence)


process.HLT_QuadJet40_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet40+process.HLTRecoJetSequenceAK5Corrected+process.hltQuadJet40Central+process.HLTEndSequence)


process.HLT_Ele10_CaloIdT_CaloIsoVL_TrkIdT_TrkIsoVL_HT200_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1EG5HTT75+process.hltPreEle10CaloIdTCaloIsoVLTrkIdTTrkIsoVLHT200+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTSingleElectronEt10HT200L1NonIsoHLTCaloIdTTrkIdTCaloIsolVLTrkIsolVLSequence+process.HLTEndSequence)


process.HLT_DoubleMu6_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu3+process.hltPreDoubleMu6+process.hltL1DoubleMuon3L1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuon3L2PreFiltered0+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered6+process.HLTEndSequence)


process.HLT_Photon26_CaloIdL_IsoVL_Photon18_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26CaloIdLIsoVLPhoton18+process.HLTPhoton26CaloIdLIsoVLPhoton18Sequence+process.HLTEndSequence)


process.HLT_Mu5_DoubleEle8_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu5DoubleEle8+process.hltL1Mu3EG5L1Filtered3+process.HLTL2muonrecoSequence+process.hltL2Mu3EG5L2Filtered3+process.HLTL3muonrecoSequence+process.hltMu3EG5L3Filtered5+process.HLTMu5DoubleEle8L1NonIsoHLTnonIsoSequence+process.HLTEndSequence)


process.HLT_Photon70_CaloIdL_HT300_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton70CaloIdLHT300+process.HLTSinglePhoton70CaloIdLSequence+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT300+process.HLTEndSequence)


process.HLT_Photon70_CaloIdL_HT200_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton70CaloIdLHT200+process.HLTSinglePhoton70CaloIdLSequence+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_DoublePhoton5_IsoVL_CEP_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1DoubleEG2FwdVeto+process.hltPreDoublePhoton5IsoVLCEP+process.HLTDoublePhoton5IsoVLSequence+process.hltTowerMakerForHcal+process.hltHcalTowerFilter+process.HLTEndSequence)


process.HLT_TripleMu5_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu3+process.hltPreTripleMu3+process.hltL1DoubleMu3L1TriMuFiltered3+process.HLTL2muonrecoSequence+process.hltL1DoubleMu3L2TriMuFiltered3+process.HLTL3muonrecoSequence+process.hltL1DoubleMu3L3TriMuFiltered5+process.HLTEndSequence)


process.HLT_IsoMu24_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreIsoMu24+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu12L2Filtered12+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered12+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered24+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered24+process.HLTEndSequence)


process.HLT_L1SingleMu10_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreL1Mu10+process.hltL1SingleMu10L1Filtered0+process.HLTEndSequence)


process.HLT_HT350_AlphaT0p51_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT350AlphaT0p51+process.HLTRecoJetSequenceAK5Corrected+process.hltHT350AlphaT0p51+process.HLTEndSequence)


process.HLT_HT400_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT400+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT400+process.HLTEndSequence)


process.HLT_Mu7_Track7_Jpsi_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu7Track7Jpsi+process.hltMu7TrackJpsiL1Filtered0+process.HLTL2muonrecoSequence+process.hltMu7TrackJpsiL2Filtered3+process.HLTL3muonrecoSequence+process.hltMu7TrackJpsiL3Filtered3+process.HLTMuTrackJpsiPixelRecoSequence+process.hltMu7Track6JpsiPixelMassFiltered+process.HLTMuTrackJpsiTrackRecoSequence+process.hltMu7Track7JpsiTrackMassFiltered+process.HLTEndSequence)


process.HLT_Photon30_CaloIdVL_IsoL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG15+process.hltPrePhoton30CaloIdVLIsoL+process.HLTPhoton30CaloIdVLIsoLSequence+process.HLTEndSequence)


process.HLT_Ele15_CaloIdVT_CaloIsoT_TrkIdT_TrkIsoT_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoT+process.HLTEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTSequence+process.HLTEndSequence)


process.HLT_Photon26_Photon18_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26Photon18+process.HLTPhoton26Photon18Sequence+process.HLTEndSequence)


process.HLT_DiJetAve140U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreDiJetAve140U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve140U+process.HLTEndSequence)


process.HLT_IsoTrackHE_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleJet52+process.hltPreIsoTrackHE+process.HLTDoLocalPixelSequence+process.hltHITPixelTracksHB+process.hltHITPixelTracksHE+process.hltHITPixelVerticesHE+process.hltIsolPixelTrackProdHE+process.hltIsolPixelTrackL2FilterHE+process.HLTDoLocalStripSequence+process.hltHITPixelTripletSeedGeneratorHE+process.hltHITCkfTrackCandidatesHE+process.hltHITCtfWithMaterialTracksHE+process.hltHITIPTCorrectorHE+process.hltIsolPixelTrackL3FilterHE+process.HLTEndSequence)


process.HLT_Ele8_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG5+process.hltPreEle8+process.HLTEle8Sequence+process.HLTEndSequence)


process.HLT_DoublePhoton33_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPreDoublePhoton33+process.HLTDoublePhoton33Sequence+process.HLTEndSequence)


process.HLT_DoubleMu3_Jpsi_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu0Jpsi+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered2+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered3Jpsi+process.hltDoubleMu3JpsiL3Filtered+process.HLTEndSequence)


process.HLT_L1Tech_BSC_minBias_threshold1_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sZeroBias+process.hltPreL1TechBSCminBiasthreshold1+process.hltL1TechBSCminBiasthreshold1+process.HLTEndSequence)


process.AlCa_EcalPhiSym_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1BscMinBiasORBptxPlusANDMinus+process.hltPreAlCaEcalPhiSym+process.hltEcalRawToRecHitFacility+process.hltESRawToRecHitFacility+process.hltEcalRegionalRestFEDs+process.hltEcalRecHitAll+process.hltAlCaPhiSymStream+process.HLTEndSequence)


process.HLT_DoubleMu3_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu3+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered0+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered3+process.HLTEndSequence)


process.HLT_R035_MR100_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleJet36Central+process.hltPreR035MR100+process.HLTRSequence+process.hltR035MR100+process.HLTEndSequence)


process.HLT_DTErrors_v1 = cms.Path(process.hltGtDigis+process.hltPreAlCaDTErrors+process.hltDTROMonitorFilter+process.hltDynAlCaDTErrors+process.HLTEndSequence)


process.HLT_Mu5_L2Mu2_Jpsi_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreMu5L2Mu2Jpsi+process.hltMu5L2Mu2L1Filtered0+process.HLTL2muonrecoSequence+process.hltMu5L2Mu2L2PreFiltered0+process.HLTL3muonrecoSequence+process.hltMu5L2Mu2L3Filtered5+process.hltMu5L2Mu2JpsiTrackMassFiltered+process.HLTEndSequence)


process.HLT_L1DoubleMu0_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreL1DoubleMu0+process.hltDiMuonL1Filtered0+process.HLTEndSequence)


process.HLT_DoubleMu4_Acoplanarity03_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu3+process.hltPreDoubleMu4Excl+process.hltL1DoubleMuon3L1Filtered3+process.HLTL2muonrecoSequence+process.hltL2DoubleMu3L2Filtered+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered4+process.hltDoubleMu4ExclL3PreFiltered+process.HLTEndSequence)


process.HLT_Jet30_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet16+process.hltPreJet30+process.HLTRecoJetSequenceAK5Corrected+process.hltSingleJet30+process.HLTEndSequence)


process.HLT_Jet150_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreJet150+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet150Regional+process.HLTEndSequence)


process.HLT_Mu3_Track3_Jpsi_v5 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu3+process.hltPreMu3Track3Jpsi+process.hltMu3TrackJpsiL1Filtered0+process.HLTL2muonrecoSequence+process.hltMu3TrackJpsiL2Filtered3+process.HLTL3muonrecoSequence+process.hltMu3TrackJpsiL3Filtered3+process.HLTMuTrackJpsiPixelRecoSequence+process.hltMu3Track2JpsiPixelMassFiltered+process.HLTMuTrackJpsiTrackRecoSequence+process.hltMu3Track3JpsiTrackMassFiltered+process.HLTEndSequence)


process.HLT_Jet80_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreJet80+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet80Regional+process.HLTEndSequence)


process.HLT_Photon36_CaloIdL_Photon22_CaloIdL_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton36CaloIdLPhoton22CaloIdL+process.HLTPhoton36CaloIdLPhoton22CaloIdLSequence+process.HLTEndSequence)


process.HLT_DoubleEle8_CaloIdT_TrkIdVL_HT160_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1DoubleEG5HTT50+process.hltPreDoubleEle8CaloIdTTrkIdVLHT160+process.HLTDoubleEle8HTT50L1NonIsoHLTCaloIdTSequence+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50DetaFilter+process.hltL1NonIsoHLTCaloIdTTrkIdVLDoubleEle8HTT50DphiFilter+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT160+process.HLTEndSequence)


process.HLT_L3MuonsCosmicTracking_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sTrackerCosmics+process.hltPreL3MuonsCosmicTracking+process.hltTrackerCosmicsPattern+process.hltL1sL1SingleMuOpenCandidate+process.hltL1MuORL1Filtered0+process.HLTL2muonrecoSequenceNoVtx+process.hltSingleL2MuORL2PreFilteredNoVtx+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltL3TrajectorySeedNoVtx+process.hltL3TrackCandidateFromL2NoVtx+process.hltL3TkTracksFromL2NoVtx+process.hltL3MuonsNoVtx+process.hltL3MuonCandidatesNoVtx+process.hltMu5NoVertexL3PreFiltered5+process.HLTEndSequence)


process.HLT_Physics_NanoDST_v1 = cms.Path(process.HLTBeginSequence+process.hltPrePhysicsNanoDST+process.HLTEndSequence)


process.HLT_R032_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleJet36Central+process.hltPreR032+process.HLTRSequence+process.hltR032+process.HLTEndSequence)


process.HLT_DoubleMu3_LowMass_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu3LowMass+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered2+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered3LowMass+process.hltDoubleMu3LowMassL3Filtered+process.HLTEndSequence)


process.HLT_Ele8_CaloIdL_CaloIsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG5+process.hltPreEle8CaloIdLCaloIsoVL+process.HLTEle8CaloIdLCaloIsoVLSequence+process.HLTEndSequence)


process.HLT_Mu3_Ele8_CaloIdL_TrkIdVL_HT160_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu0HTT50+process.hltPreMu3Ele8CaloIdLTrkIdVLHT160+process.hltL1Mu0HTT50L1Filtered0+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2Filtered0+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3Filtered3+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT160+process.HLTEcalActivitySequence+process.hltL1NonIsoHLTNonIsoSingleEle8NoCandEtFilter+process.hltUnseededR9shape+process.hltL1NonIsoHLTNonIsoSingleEle8NoCandR9ShapeFilter+process.hltActivityPhotonClusterShape+process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandClusterShapeFilter+process.hltActivityPhotonHcalForHE+process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandHEFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltL1NonIsoHLTCaloIdLSingleEle8NoCandPixelMatchFilter+process.HLTPixelMatchElectronActivityTrackingSequence+process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter+process.hltElectronActivityDetaDphi+process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandDetaFilter+process.hltL1NonIsoHLTCaloIdLTrkIdVLSingleElectronEt8NoCandDphiFilter+process.HLTEndSequence)


process.HLT_BTagMu_DiJet20_Mu5_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu3Jet16Central+process.hltPreBTagMuDiJet20Mu5+process.HLTRecoJetSequenceAK5Corrected+process.hltBDiJet20Central+process.HLTBTagMuDiJet20SequenceL25+process.hltBSoftMuonDiJet20L25FilterByDR+process.HLTBTagMuDiJet20Mu5SelSequenceL3+process.hltBSoftMuonDiJet20Mu5SelL3FilterByDR+process.HLTEndSequence)


process.HLT_DiJetAve300U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreDiJetAve300U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve300U+process.HLTEndSequence)


process.HLT_L1_Interbunch_BSC_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1InterbunchBsc+process.hltPreL1Interbunch1+process.HLTEndSequence)


process.HLT_MET200_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1ETM30+process.hltPreMET200+process.HLTRecoMETSequence+process.hltMET200+process.HLTEndSequence)


process.HLT_Mu8_Ele17_CaloIdL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu8Ele17CaloIdL+process.hltL1Mu3EG5L1Filtered5+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2Filtered5+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3Filtered8+process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1Mu3EG5+process.hltEG17EtFilterL1Mu3EG5+process.HLTEgammaR9ShapeSequence+process.hltL1NonIsoHLTNonIsoMu8Ele17R9ShapeFilter+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLTCaloIdLMu8Ele17ClusterShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTNonIsoMu8Ele17HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTNonIsoMu8Ele17PixelMatchFilter+process.HLTEndSequence)


process.HLT_L1SingleEG5_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG5+process.hltPreL1SingleEG5+process.HLTEndSequence)


process.HLT_Photon125_NoSpikeFilter_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton125NoSpikeFilter+process.HLTSinglePhoton125L1NonIsolatedHLTNonIsoSequence+process.HLTEndSequence)


process.HLT_Meff640_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreMeff640+process.HLTRecoJetSequenceAK5Corrected+process.hltMeff640+process.HLTEndSequence)


process.HLT_Random_v1 = cms.Path(process.HLTBeginSequenceRandom+process.hltPreRandom+process.HLTEndSequence)


process.HLT_Photon26_IsoVL_Photon18_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26IsoVLPhoton18+process.HLTPhoton26IsoVLPhoton18Sequence+process.HLTEndSequence)


process.HLT_Mu8_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu3+process.hltPreMu8+process.hltL1SingleMu3L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu3L2Filtered3+process.HLTL3muonrecoSequence+process.hltSingleMu8L3Filtered8+process.HLTEndSequence)


process.HLT_DoubleJet30_ForwardBackward_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleForJet32EtaOpp+process.hltPreDoubleJet30ForwardBackward+process.HLTRecoJetSequenceAK5Corrected+process.hltDoubleJet30ForwardBackward+process.HLTEndSequence)


process.HLT_IsoPFTau35_Trk20_MET45_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sSingleIsoTau35Trk20MET45+process.hltPreSingleIsoTau35Trk20MET45+process.HLTL2TauJetsSequence+process.hltFilterL2EtCutSingleIsoPFTau35Trk20MET45+process.HLTRecoMETSequence+process.hltMet45+process.HLTRecoJetSequencePrePF+process.HLTTrackReconstructionForJets+process.HLTParticleFlowSequence+process.HLTPFJetsSequence+process.HLTPFTauTightIsoSequence+process.hltPFTauTightIso35+process.hltPFTauTightIso35Track+process.hltPFTauTightIsoTrackPt20Discriminator+process.hltSelectedPFTauTightIsoTrackPt20+process.hltConvPFTauTightIsoTrackPt20+process.hltFilterSingleIsoPFTau35Trk20LeadTrackPt20+process.hltSelectedPFTauTightIsoTrackPt20Isolation+process.hltConvPFTauTightIsoTrackPt20Isolation+process.hltL1HLTSingleIsoPFTau35Trk20Met45JetsMatch+process.hltFilterSingleIsoPFTau35Trk20MET45LeadTrack20MET45IsolationL1HLTMatched+process.HLTEndSequence)


process.HLT_IsoTrackHB_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleJet52+process.hltPreIsoTrackHB+process.HLTDoLocalPixelSequence+process.hltHITPixelTracksHB+process.hltHITPixelVerticesHB+process.hltIsolPixelTrackProdHB+process.hltIsolPixelTrackL2FilterHB+process.HLTDoLocalStripSequence+process.hltHITPixelTripletSeedGeneratorHB+process.hltHITCkfTrackCandidatesHB+process.hltHITCtfWithMaterialTracksHB+process.hltHITIPTCorrectorHB+process.hltIsolPixelTrackL3FilterHB+process.HLTEndSequence)


process.HLT_JetE30_NoBPTX3BX_NoHalo_v4 = cms.Path(process.HLTBeginSequenceAntiBPTX+process.hltL1sL1SingleJet20NoBPTXNoHalo+process.hltL1BeamHaloAntiCoincidence3BX+process.hltPreJetE30NoBPTX3BXNoHalo+process.HLTStoppedHSCPLocalHcalReco+process.hltStoppedHSCPHpdFilter+process.HLTStoppedHSCPJetSequence+process.hltStoppedHSCPTight1CaloJetEnergy30+process.HLTEndSequence)


process.DQM_FEDIntegrity_v3 = cms.Path(process.HLTBeginSequence+process.hltPreFEDIntegrity+process.hltCSCMonitorModule+process.hltDTDQMEvF+process.hltEcalRawToRecHitFacility+process.hltEcalRegionalRestFEDs+process.hltEcalRecHitAll+process.hltEcalRawToRecHitByproductProducer+process.hltEBHltTask+process.hltEEHltTask+process.hltESFEDIntegrityTask+process.hltHcalDigis+process.hltHcalDataIntegrityMonitor+process.hltL1tfed+process.hltSiPixelDigis+process.hltSiPixelHLTSource+process.hltSiStripFEDCheck+process.hltMuonRPCDigis+process.hltRPCFEDIntegrity+process.hltBoolFalse)


process.HLT_DiJetAve180U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreDiJetAve180U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve180U+process.HLTEndSequence)


process.HLT_HT350_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT350+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT350+process.HLTEndSequence)


process.HLT_Photon50_CaloIdVL_IsoL_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton50CaloIdVLIsoL+process.HLTPhoton50CaloIdVLIsoLSequence+process.HLTEndSequence)


process.HLT_Mu20_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreMu20+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltSingleMu12L2Filtered12+process.HLTL3muonrecoSequence+process.hltSingleMu20L3Filtered20+process.HLTEndSequence)


process.HLT_JetE30_NoBPTX_NoHalo_v4 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleJet20NoBPTXNoHalo+process.hltL1BeamHaloAntiCoincidence3BX+process.hltPreJetE30NoBPTXNoHalo+process.HLTStoppedHSCPLocalHcalReco+process.hltStoppedHSCPHpdFilter+process.HLTStoppedHSCPJetSequence+process.hltStoppedHSCPLoose1CaloJetEnergy30+process.HLTEndSequence)


process.HLT_DoubleEle8_CaloIdL_TrkIdVL_HT160_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1DoubleEG5HTT50+process.hltPreDoubleEle8CaloIdLTrkIdVLHT160+process.HLTDoubleEle8HTT50L1NonIsoHLTCaloIdLSequence+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50OneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50DetaFilter+process.hltL1NonIsoHLTCaloIdLTrkIdVLDoubleEle8HTT50DphiFilter+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT160+process.HLTEndSequence)


process.HLT_DiJet60_MET45_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1ETM20+process.hltPreDiJet60MET45+process.HLTRecoJetSequenceAK5Corrected+process.hltDiJet60+process.HLTRecoMETSequence+process.hltMet45+process.HLTEndSequence)


process.HLT_L1Tech_BSC_halo_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sZeroBias+process.hltPreL1TechBSChalo+process.hltL1TechBSChalo+process.HLTEndSequence)


process.HLT_Mu15_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreMu15+process.hltL1SingleMu10L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu10L2Filtered10+process.HLTL3muonrecoSequence+process.hltL3Muon15+process.HLTEndSequence)


process.HLT_L1SingleMuOpen_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMuOpen+process.hltPreL1SingleMuOpen+process.hltL1MuOpenL1Filtered0+process.HLTEndSequence)


process.HLT_DoubleIsoPFTau20_Trk5_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sDoubleIsoTau20Trk5+process.hltPreDoubleIsoTau20Trk5+process.HLTL2TauJetsSequence+process.hltFilterL2EtCutDoublePFIsoTau20Trk5+process.HLTRecoJetSequencePrePF+process.HLTTrackReconstructionForJets+process.HLTParticleFlowSequence+process.HLTPFJetsSequence+process.HLTPFTauTightIsoSequence+process.hltDoublePFTauTightIso20Track+process.hltDoublePFTauTightIso20Track5+process.hltL1HLTDoubleIsoPFTau20Trk5JetsMatch+process.hltFilterDoubleIsoPFTau20Trk5LeadTrack5IsolationL1HLTMatched+process.HLTEndSequence)


process.HLT_Activity_Ecal_SC7_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1BscMinBiasORBptxPlusANDMinus+process.hltPreActivityEcalSC7+process.HLTEcalActivitySequence+process.hltEgammaSelectEcalSuperClustersActivityFilterSC7+process.hltEgammaEcalActivityR9Shape+process.hltEgammaEcalActivityR9ShapeFilterSC7+process.HLTEndSequence)


process.HLT_L1_PreCollisions_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1PreCollisions+process.hltPreL1PreCollisions+process.HLTEndSequence)


process.HLT_Mu8_Jet40_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3Jet20Central+process.hltPreMu8Jet40+process.hltL1Mu3Jet20L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu8Jet20L2Filtered3+process.HLTL3muonrecoSequence+process.hltL3Mu8Jet20L3Filtered8+process.HLTRecoJetSequenceAK5Corrected+process.hltJet40+process.HLTEndSequence)


process.HLT_HT200_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT75+process.hltPreHT200+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_Mu15_Photon20_CaloIdL_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu15Photon20CaloIdL+process.hltL1Mu3EG5L1Filtered5+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2Filtered5+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3Filtered15+process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1Mu3EG5+process.hltEG20EtFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG20R9ShapeFilterMu3EG5+process.HLTDoEgammaClusterShapeSequence+process.hltMu15Photon20CaloIdLClusterShapeFilter+process.HLTDoEGammaHESequence+process.hltMu15Photon20CaloIdLHEFilter+process.HLTEndSequence)


process.HLT_Ele15_CaloIdVT_TrkIdT_LooseIsoPFTau15_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle15CaloIdVTTrkIdTLooseIsoPFTau15+process.HLTEle15CaloIdVTTrkIdTSequence+process.HLTRecoJetSequencePrePF+process.hltTauJet5+process.hltOverlapFilterEle15CaloJet5+process.HLTPFJetTriggerSequence+process.hltPFJet15+process.HLTPFTauSequence+process.hltPFTau15+process.hltPFTau15Track+process.hltPFTau15TrackLooseIso+process.hltOverlapFilterEle15IsoPFTau15+process.HLTEndSequence)


process.HLT_Mu10_Ele10_CaloIdL_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu10Ele10CaloIdL+process.hltL1Mu3EG5L1Filtered5+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2Filtered5+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3Filtered10+process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1Mu3EG5+process.hltEG10EtFilterL1Mu3EG5+process.HLTEgammaR9ShapeSequence+process.hltL1NonIsoHLTNonIsoMu10Ele10R9ShapeFilter+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLTCaloIdLMu10Ele10ClusterShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTNonIsoMu10Ele10HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTNonIsoMu10Ele10PixelMatchFilter+process.HLTEndSequence)


process.HLT_RegionalCosmicTracking_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sTrackerCosmics+process.hltPreRegionalCosmicTracking+process.hltTrackerCosmicsPattern+process.hltL1sL1SingleMuOpenCandidate+process.hltL1MuORL1Filtered0+process.HLTL2muonrecoSequenceNoVtx+process.hltSingleL2MuORL2PreFilteredNoVtx+process.HLTDoLocalPixelSequence+process.HLTDoLocalStripSequence+process.hltRegionalCosmicTrackerSeeds+process.hltRegionalCosmicCkfTrackCandidates+process.hltRegionalCosmicTracks+process.hltCosmicTrackSelector+process.HLTEndSequence)


process.HLT_Mu17_CentralJet40_BTagIP_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu17BTagIPCenJet40+process.hltL1Mu7CenJetL1MuFiltered0+process.HLTL2muonrecoSequence+process.hltL2Muon7+process.HLTRecoJetSequenceAK5Corrected+process.hltBJet40Central+process.HLTBTagIPSequenceL25SingleTop+process.hltBLifetimeL25FilterSingleTop+process.HLTL3muonrecoSequence+process.hltL3Muon17+process.HLTBTagIPSequenceL3SingleTop+process.hltBLifetimeL3FilterSingleTop+process.HLTEndSequence)


process.HLT_L2Mu10_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreL2Mu10+process.hltL1SingleMu10L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu10L2Filtered10+process.HLTEndSequence)


process.HLT_HT300_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT300+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT300+process.HLTEndSequence)


process.HLT_L2DoubleMu0_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreL2DoubleMu0+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered0+process.HLTEndSequence)


process.HLT_HT400_AlphaT0p51_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT400AlphaT0p51+process.HLTRecoJetSequenceAK5Corrected+process.hltHT400AlphaT0p51+process.HLTEndSequence)


process.HLT_Mu5_HT200_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu0HTT50+process.hltPreMu5HT200+process.hltL1Mu0HTT50L1MuFiltered3+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2MuFiltered3+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3MuFiltered5+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_Mu17_CentralJet30_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu17TriCenJet30+process.hltL1Mu7CenJetL1MuFiltered0+process.HLTL2muonrecoSequence+process.hltL2Muon7+process.HLTL3muonrecoSequence+process.hltL3Muon17+process.HLTRecoJetSequenceAK5Corrected+process.hltJet30Central+process.HLTEndSequence)


process.HLT_Meff520_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreMeff520+process.HLTRecoJetSequenceAK5Corrected+process.hltMeff520+process.HLTEndSequence)


process.HLT_PixelTracks_Multiplicity100_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sETT220+process.hltPrePixelTracksMultiplicity100+process.HLTDoLocalPixelSequence+process.hltPixelClusterShapeFilter+process.HLTRecopixelvertexingForHighMultSequence+process.hltPixelCandsForHighMult+process.hlt1HighMult100+process.HLTEndSequence)


process.HLT_Photon75_CaloIdVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton75CaloIdVL+process.HLTPhoton75CaloIdVLSequence+process.HLTEndSequence)


process.HLT_CentralJet80_MET80_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreCenJet80MET80+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltCenJet80CentralRegional+process.HLTRecoMETSequence+process.hltMET80+process.HLTEndSequence)


process.HLT_Photon26_CaloIdL_IsoVL_Photon18_CaloIdL_IsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVL+process.HLTPhoton26CaloIdLIsoVLPhoton18CaloIdLIsoVLSequence+process.HLTEndSequence)


process.HLT_Photon70_CaloIdL_MHT30_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton70CaloIdLMHT30+process.HLTSinglePhoton70CaloIdLSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltMHT30+process.HLTEndSequence)


process.HLT_Photon26_R9Id_Photon18_CaloIdL_IsoVL_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26R9IdPhoton18CaloIdLIsoVL+process.HLTPhoton26R9IdPhoton18CaloIdLIsoVLSequence+process.HLTEndSequence)


process.HLT_HcalPhiSym_v3 = cms.Path(process.HLTBeginSequenceNZS+process.hltL1sHcalPhiSym+process.hltPreHcalPhiSym+process.HLTEndSequence)


process.HLT_Ele17_CaloIdVT_CaloIsoVT_TrkIdT_TrkIsoVT_SC8_Mass30_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8Mass30+process.HLTEle17CaloIdVTCaloIsoVTTrkIdTTrkIsoVTSC8Mass30Sequence+process.HLTEndSequence)


process.HLT_Jet370_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreJet370+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet370Regional+process.HLTEndSequence)


process.HLT_Jet110_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet68+process.hltPreJet110+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet110Regional+process.HLTEndSequence)


process.HLT_IsoMu15_v5 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu10+process.hltPreIsoMu15+process.hltL1SingleMu10L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu10L2Filtered10+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered10+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered15+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered15+process.HLTEndSequence)


process.HLT_HT250_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT250+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT250+process.HLTEndSequence)


process.HLT_IsoMu12_LooseIsoPFTau10_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreIsoMu12IsoPFTau10+process.hltL1SingleMu7L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu7L2Filtered7+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered7+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered12+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered12+process.HLTRecoJetSequencePrePF+process.hltTauJet5+process.HLTPFJetTriggerSequence+process.hltPFJet10+process.HLTPFTauSequence+process.hltPFTau10Track+process.hltFilterIsoMu12IsoPFTau10LooseIsolation+process.hltOverlapFilterIsoMu12IsoPFTau10+process.HLTEndSequence)


process.HLT_Calibration_v1 = cms.Path(process.HLTBeginSequenceCalibration+process.hltPreCalibration+process.HLTEndSequence)


process.HLT_Photon20_CaloIdVT_IsoT_Ele8_CaloIdL_CaloIsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton20CaloIdVTIsoTEle8CaloIdLCaloIsoVL+process.HLTPhoton20CaloIdVTIsoTSequence+process.HLTEle8CaloIdLCaloIsoVLNoL1SeedSequence+process.hltPhoton20CaloIdVTIsoTEle8CaloIdLCaloIsoVLDoubleLegCombFilter+process.HLTEndSequence)


process.HLT_L1Tech_CASTOR_HaloMuon_v1 = cms.Path(process.HLTBeginSequence+process.hltL1TechCASTORHaloMuon+process.hltPreL1TechCASTORHaloMuon+process.HLTEndSequence)


process.HLT_Ele17_CaloIdL_CaloIsoVL_Ele8_CaloIdL_CaloIsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle17CaloIdLCaloIsoVLEle8CaloIdLCaloIsoVL+process.HLTEle17CaloIdIsoEle8CaloIdIsoSequence+process.HLTEndSequence)


process.HLT_DoubleMu5_Ele8_CaloIdL_TrkIdVL_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreDoubleMu5Ele8CaloIdLTrkIdVL+process.hltL1Mu3EG5L1DiMuFiltered3+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2DiMuFiltered3+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3DiMuFiltered5+process.HLTDoubleMu5Ele8L1NonIsoHLTCaloIdLTrkIdVLSequence+process.HLTEndSequence)


process.HLT_DoubleJet80_ForwardBackward_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleForJet44EtaOpp+process.hltPreDoubleJet80ForwardBackward+process.HLTRecoJetSequenceAK5Corrected+process.hltDoubleJet80ForwardBackward+process.HLTEndSequence)


process.HLTriggerFinalPath = cms.Path(process.hltGtDigis+process.hltFEDSelector+process.hltTriggerSummaryAOD+process.hltTriggerSummaryRAW+process.hltBoolTrue)


process.HLT_HT500_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT500+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT500+process.HLTEndSequence)


process.HLT_Mu30_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreMu30+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu12L2Filtered12+process.HLTL3muonrecoSequence+process.hltSingleMu30L3Filtered30+process.HLTEndSequence)


process.HLT_Ele90_NoSpikeFilter_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPreEle90NoSpikeFilter+process.HLTEle90NoSpikeFilterSequence+process.HLTEndSequence)


process.HLT_L1SingleMuOpen_DT_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMuOpen+process.hltPreL1SingleMuOpenDT+process.hltL1MuOpenL1FilteredDT+process.HLTEndSequence)


process.HLT_CentralJet80_MET160_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreCenJet80MET160+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltCenJet80CentralRegional+process.HLTRecoMETSequence+process.hltMET160+process.HLTEndSequence)


process.HLT_QuadJet40_IsoPFTau40_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet40IsoPFTau40+process.HLTRecoJetSequenceAK5Corrected+process.hltQuadJet40IsoPFTau40+process.HLTRecoJetSequencePrePF+process.HLTTrackReconstructionForJets+process.HLTParticleFlowSequence+process.HLTPFJetsSequence+process.HLTPFTauTightIsoSequence+process.hltPFTau5Track+process.hltPFTau5Track5+process.hltFilterPFTauTrack5TightIsoL1QuadJet20Central+process.hltFilterPFTauTrack5TightIsoL1QuadJet20CentralPFTau40+process.HLTEndSequence)


process.HLT_L2DoubleMu23_NoVertex_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu3+process.hltPreL2DoubleMu23NoVertex+process.hltL1DoubleMuon3L1Filtered0+process.HLTL2muonrecoSequenceNoVtx+process.hltL2DoubleMu23NoVertexL2PreFiltered+process.HLTEndSequence)


process.HLT_Mu5_L2Mu2_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreMu5L2Mu2+process.hltMu5L2Mu2L1Filtered0+process.HLTL2muonrecoSequence+process.hltMu5L2Mu2L2PreFiltered0+process.HLTL3muonrecoSequence+process.hltMu5L2Mu0L3Filtered5+process.HLTEndSequence)


process.HLT_TripleEle10_CaloIdL_TrkIdVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1TripleEG5+process.hltPreTripleEle10CaloIdLTrkIdVL+process.HLTTripleElectronEt10L1NonIsoHLTNonIsoSequence+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10ClusterShapeFilter+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10OneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10EleIdDetaFilter+process.hltL1NonIsoHLT3LegEleIdTripleElectronEt10EleIdDphiFilter+process.HLTEndSequence)


process.HLT_R032_MR100_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleJet36Central+process.hltPreR032MR100+process.HLTRSequence+process.hltR032MR100+process.HLTEndSequence)


process.HLT_MET100_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1ETM30+process.hltPreMET100+process.HLTRecoMETSequence+process.hltMET100+process.HLTEndSequence)


process.AlCa_EcalPi0_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sAlCaEcalPi0Eta+process.hltPreAlCaEcalPi0+process.HLTDoRegionalPi0EtaSequence+process.hltSimple3x3Clusters+process.hltAlCaPi0RecHitsFilter+process.HLTEndSequence)


process.HLT_HT450_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT450+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT450+process.HLTEndSequence)


process.HLT_HT250_AlphaT0p62_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT250AlphaT0p62+process.HLTRecoJetSequenceAK5Corrected+process.hltHT250AlphaT0p62+process.HLTEndSequence)


process.AlCa_RPCMuonNormalisation_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sAlCaRPC+process.hltPreRPCMuonNorma+process.hltRPCMuonNormaL1Filtered0+process.HLTmuonlocalrecoSequence+process.HLTEndSequence)


process.HLT_Ele15_CaloIdVT_CaloIsoT_TrkIdT_TrkIsoT_LooseIsoPFTau15_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTLooseIsoPFTau15+process.HLTEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTSequence+process.HLTRecoJetSequencePrePF+process.hltTauJet5+process.hltOverlapFilterIsoEle15CaloJet5+process.HLTPFJetTriggerSequence+process.hltPFJet15+process.HLTPFTauSequence+process.hltPFTau15+process.hltPFTau15Track+process.hltPFTau15TrackLooseIso+process.hltOverlapFilterIsoEle15IsoPFTau15+process.HLTEndSequence)


process.HLT_DiJetAve70U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet68+process.hltPreDiJetAve70U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve70U+process.HLTEndSequence)


process.HLT_BeamGas_BSC_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1BeamGasBsc+process.hltPreL1BeamGasBsc+process.HLTDoLocalPixelLight+process.hltPixelActivityFilter+process.hltPixelAsymmetryFilter+process.HLTEndSequence)


process.HLT_Mu15_DoublePhoton15_CaloIdL_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu15DoublePhoton15CaloIdL+process.hltL1Mu3EG5L1Filtered5+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2Filtered5+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3Filtered15+process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1Mu3EG5+process.hltDoubleEG15EtFilterL1Mu3EG5+process.HLTEgammaR9ShapeSequence+process.hltMu15DiPhoton15R9ShapeFilter+process.HLTDoEgammaClusterShapeSequence+process.hltMu15DiPhoton15CaloIdLClusterShapeFilter+process.HLTDoEGammaHESequence+process.hltMu15DiPhoton15CaloIdLHEFilter+process.HLTEndSequence)


process.HLT_Ele25_CaloIdVT_TrkIdT_CentralTriJet30_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle25CaloIdVTTrkIdTCentralTriJet30+process.HLTEle25CaloIdVTCaloTrkIdSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets+process.hltEle25CaloIdVTTrkIdTCentralTriJet30Cleaned+process.HLTEndSequence)


process.HLT_GlobalRunHPDNoise_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sGlobalRunHPDNoise+process.hltPreGlobalRunHPDNoise+process.HLTEndSequence)


process.HLT_BeamHalo_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1BeamHalo+process.hltPreL1BeamHalo+process.HLTDoLocalPixelLight+process.hltPixelActivityFilterForHalo+process.HLTDoLocalStripSequence+process.hltTrackerHaloFilter+process.HLTEndSequence)


process.HLT_Ele15_CaloIdVT_CaloIsoT_TrkIdT_TrkIsoT_LooseIsoPFTau20_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTLooseIsoPFTau20+process.HLTEle15CaloIdVTCaloIsoTTrkIdTTrkIsoTSequence+process.HLTRecoJetSequencePrePF+process.hltTauJet5+process.hltOverlapFilterIsoEle15CaloJet5+process.HLTPFJetTriggerSequence+process.hltPFJet20+process.HLTPFTauSequence+process.hltPFTau20+process.hltPFTau20Track+process.hltPFTau20TrackLooseIso+process.hltOverlapFilterIsoEle15IsoPFTau20+process.HLTEndSequence)


process.HLT_Mu5_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu3+process.hltPreMu5+process.hltL1SingleMu3L1Filtered0+process.HLTL2muonrecoSequence+process.hltSingleMu5L2Filtered3+process.HLTL3muonrecoSequence+process.hltSingleMu5L3Filtered5+process.HLTEndSequence)


process.HLT_ZeroBias_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sZeroBias+process.hltPreZeroBias+process.HLTEndSequence)


process.HLT_DiJetAve30U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet36+process.hltPreDiJetAve30U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve30U+process.HLTEndSequence)


process.HLT_HT250_AlphaT0p55_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT250AlphaT0p55+process.HLTRecoJetSequenceAK5Corrected+process.hltHT250AlphaT0p55+process.HLTEndSequence)


process.HLT_Jet370_NoJetID_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreJet370NoJetID+process.HLTRegionalTowerMakerForJetsSequence+process.hltAntiKT5CaloJetsRegional+process.hltAntiKT5L2L3CorrCaloJetsRegional+process.hltL1MatchedJetsRegional+process.hltSingleJet370RegionalNoJetID+process.HLTEndSequence)


process.HLT_DoubleMu2_Bs_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleMu0+process.hltPreDoubleMu0Bs+process.hltDiMuonL1Filtered0+process.HLTL2muonrecoSequence+process.hltDiMuonL2PreFiltered1+process.HLTL3muonrecoSequence+process.hltDiMuonL3PreFiltered2Bs+process.hltDoubleMu2BsL3Filtered+process.HLTEndSequence)


process.HLT_EcalCalibration_v1 = cms.Path(process.hltCalibrationEventsFilter+process.hltGtDigis+process.hltPreEcalCalibration+process.hltEcalCalibrationRaw+process.HLTEndSequence)


process.HLT_HT300_MHT75_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT300MHT75+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT300+process.hltMHT75+process.HLTEndSequence)


process.HLT_Photon60_CaloIdL_HT200_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG20+process.hltPrePhoton60CaloIdLHT200+process.HLTSinglePhoton60CaloIdLSequence+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_MET120_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1ETM30+process.hltPreMET120+process.HLTRecoMETSequence+process.hltMET120+process.HLTEndSequence)


process.HLT_Ele17_CaloIdL_CaloIsoVL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle17CaloIdLCaloIsoVL+process.HLTEle17CaloIdLCaloIsoVLSequence+process.HLTEndSequence)


process.HLT_L1SingleEG12_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreL1SingleEG12+process.HLTEndSequence)


process.HLT_HT250_DoubleDisplacedJet60_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT250DoubleDisplacedJet60+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT250+process.hltDoubleJet60VeryCentral+process.hltAntiKT5L2L3CorrCaloJetsPt60Eta2+process.HLT2DisplacedHT250SequenceL25+process.HLT2DisplacedHT250SequenceL3+process.HLTEndSequence)


process.HLT_Mu8_HT200_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu0HTT50+process.hltPreMu8HT200+process.hltL1Mu0HTT50L1MuFiltered5+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2MuFiltered5+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3MuFiltered8+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT200+process.HLTEndSequence)


process.HLT_HcalNZS_v3 = cms.Path(process.HLTBeginSequenceNZS+process.hltL1sHcalNZS+process.hltPreHcalNZS+process.HLTEndSequence)


process.HLT_IsoMu12_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreIsoMu12+process.hltL1SingleMu7L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu7L2Filtered7+process.HLTL2muonisorecoSequence+process.hltSingleMuIsoL2IsoFiltered7+process.HLTL3muonrecoSequence+process.hltSingleMuIsoL3PreFiltered12+process.HLTL3muonisorecoSequence+process.hltSingleMuIsoL3IsoFiltered12+process.HLTEndSequence)


process.HLT_DoubleEle10_CaloIdL_TrkIdVL_Ele10_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1TripleEG5+process.hltPreDoubleEle10CaloIdLTrkIdVLEle10+process.HLTTripleElectronEt10L1NonIsoHLTNonIsoSequence+process.hltL1NonIsoHLT2CaloIdLTripleElectronEt10HEFilter+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10ClusterShapeFilter+process.HLTPixelMatchElectronL1IsoTrackingSequence+process.HLTPixelMatchElectronL1NonIsoTrackingSequence+process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10OneOEMinusOneOPFilter+process.HLTDoElectronDetaDphiSequence+process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10EleIdDetaFilter+process.hltL1NonIsoHLT2LegEleIdTripleElectronEt10EleIdDphiFilter+process.HLTEndSequence)


process.HLT_Ele25_CaloIdVT_TrkIdT_CentralDiJet30_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPreEle25CaloIdVTTrkIdTCentralDiJet30+process.HLTEle25CaloIdVTCaloTrkIdSequence+process.HLTRecoJetSequenceAK5Corrected+process.hltCleanEle25CaloIdVTTrkIdTFromAK5CorrJets+process.hltEle25CaloIdVTTrkIdTCentralDiJet30Cleaned+process.HLTEndSequence)


process.HLT_L1SingleMu20_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu20+process.hltPreL1Mu20+process.hltL1SingleMu20L1Filtered0+process.HLTEndSequence)


process.HLT_Photon26_CaloIdL_IsoVL_Photon18_R9Id_v1 = cms.Path(process.HLTBeginSequence+process.hltL1sL1SingleEG12+process.hltPrePhoton26CaloIdLIsoVLPhoton18R9Id+process.HLTPhoton26CaloIdLIsoVLPhoton18R9IdSequence+process.HLTEndSequence)


process.HLT_Mu5_TkMu0_OST_Jpsi_Tight_B5Q7_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu5BQ7+process.hltPreMu5TkMu0JpsiTightB5Q7+process.hltMu5TrackJpsiL1Filtered0Eta15+process.HLTL2muonrecoSequence+process.hltMu5TrackJpsiL2Filtered5Eta15+process.HLTL3muonrecoSequence+process.hltMu5TrackJpsiL3Filtered5Eta15+process.HLTMuTrackJpsiPixelRecoSequence+process.hltMu5TrackJpsiPixelMassFilteredEta15+process.HLTMuTrackJpsiTrackRecoSequence+process.hltMu5TkMuJpsiTrackMassFiltered+process.HLTMuTkMuJpsiTkMuRecoSequence+process.hltMu5TkMuJpsiTkMuMassFilteredTight+process.HLTEndSequence)


process.HLT_L2Mu20_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreL2Mu20+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu20L2Filtered20+process.HLTEndSequence)


process.HLT_BTagMu_DiJet80_Mu9_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1Mu3Jet28Central+process.hltPreBTagMuDiJet80Mu9+process.HLTRecoJetSequenceAK5Corrected+process.hltBDiJet80Central+process.HLTBTagMuDiJet80SequenceL25+process.hltBSoftMuonDiJet80L25FilterByDR+process.HLTBTagMuDiJet80Mu9SelSequenceL3+process.hltBSoftMuonDiJet80Mu9SelL3FilterByDR+process.HLTEndSequence)


process.AlCa_EcalEta_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sAlCaEcalPi0Eta+process.hltPreAlCaEcalEta+process.HLTDoRegionalPi0EtaSequence+process.hltSimple3x3Clusters+process.hltAlCaEtaRecHitsFilter+process.HLTEndSequence)


process.HLT_HT300_AlphaT0p54_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHLTHT300AlphaT0p54+process.HLTRecoJetSequenceAK5Corrected+process.hltHT300AlphaT0p54+process.HLTEndSequence)


process.HLT_Mu3_Ele8_CaloIdT_TrkIdVL_HT160_v3 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu0HTT50+process.hltPreMu3Ele8CaloIdTTrkIdVLHT160+process.hltL1Mu0HTT50L1Filtered0+process.HLTL2muonrecoSequence+process.hltL1Mu0HTT50L2Filtered0+process.HLTL3muonrecoSequence+process.hltL1Mu0HTT50L3Filtered3+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT160+process.HLTEcalActivitySequence+process.hltL1NonIsoHLTNonIsoSingleEle8NoCandEtFilter+process.hltUnseededR9shape+process.hltL1NonIsoHLTNonIsoSingleEle8NoCandR9ShapeFilter+process.hltActivityPhotonClusterShape+process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandClusterShapeFilter+process.hltActivityPhotonHcalForHE+process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandHEFilter+process.hltActivityStartUpElectronPixelSeeds+process.hltL1NonIsoHLTCaloIdTSingleEle8NoCandPixelMatchFilter+process.HLTPixelMatchElectronActivityTrackingSequence+process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandOneOEMinusOneOPFilter+process.hltElectronActivityDetaDphi+process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandDetaFilter+process.hltL1NonIsoHLTCaloIdTTrkIdVLSingleElectronEt8NoCandDphiFilter+process.HLTEndSequence)


process.HLT_Jet240_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreJet240+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet240Regional+process.HLTEndSequence)


process.AlCa_RPCMuonNoHits_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sAlCaRPC+process.hltPreRPCMuonNoHits+process.HLTmuonlocalrecoSequence+process.hltRPCPointProducer+process.hltRPCFilter+process.HLTEndSequence)


process.HLT_DoubleJet60_ForwardBackward_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1DoubleForJet32EtaOpp+process.hltPreDoubleJet60ForwardBackward+process.HLTRecoJetSequenceAK5Corrected+process.hltDoubleJet60ForwardBackward+process.HLTEndSequence)


process.HLT_Jet190_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet92+process.hltPreJet190+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet190Regional+process.HLTEndSequence)


process.HLT_Mu24_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu12+process.hltPreMu24+process.hltL1SingleMu12L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu12L2Filtered12+process.HLTL3muonrecoSequence+process.hltSingleMu24L3Filtered24+process.HLTEndSequence)


process.HLT_Mu3_v3 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMuOpen+process.hltPreMu3+process.hltSingleMuOpenL1Filtered+process.HLTL2muonrecoSequence+process.hltSingleMu3L2Filtered0+process.HLTL3muonrecoSequence+process.hltSingleMu3L3Filtered3+process.HLTEndSequence)


process.HLT_Jet60_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet36+process.hltPreJet60+process.HLTRegionalRecoJetSequenceAK5Corrected+process.hltSingleJet60Regional+process.HLTEndSequence)


process.AlCa_RPCMuonNoTriggers_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sAlCaRPC+process.hltPreRPCMuonNoTriggers+process.hltRPCMuonNoTriggersL1Filtered0+process.HLTmuonlocalrecoSequence+process.HLTEndSequence)


process.HLT_HT250_MHT60_v2 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1HTT100+process.hltPreHT250MHT60+process.HLTRecoJetSequenceAK5Corrected+process.HLTDoJet40HTRecoSequence+process.hltHT250+process.hltMHT60+process.HLTEndSequence)


process.HLT_Mu17_Ele8_CaloIdL_v2 = cms.Path(process.HLTBeginSequence+process.hltL1sL1Mu3EG5+process.hltPreMu17Ele8CaloIdL+process.hltL1Mu3EG5L1Filtered12+process.HLTL2muonrecoSequence+process.hltL1Mu3EG5L2Filtered12+process.HLTL3muonrecoSequence+process.hltL1Mu3EG5L3Filtered17+process.HLTDoEGammaStartupSequence+process.hltEGRegionalL1Mu3EG5+process.hltEG8EtFilterMu3EG5+process.HLTEgammaR9ShapeSequence+process.hltEG8R9ShapeFilterMu3EG5+process.HLTDoEgammaClusterShapeSequence+process.hltL1NonIsoHLTCaloIdLMu17Ele8ClusterShapeFilter+process.HLTDoEGammaHESequence+process.hltL1NonIsoHLTNonIsoMu17Ele8HEFilter+process.HLTDoEGammaPixelSequence+process.hltL1NonIsoHLTNonIsoMu17Ele8PixelMatchFilter+process.HLTEndSequence)


process.HLT_DiJetAve50U_v4 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleJet52+process.hltPreDiJetAve50U+process.HLTRecoJetSequenceAK5Uncorrected+process.hltJetIDPassedAK5Jets+process.hltDiJetAve50U+process.HLTEndSequence)


process.HLT_QuadJet70_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1QuadJet20Central+process.hltPreQuadJet70+process.HLTRecoJetSequenceAK5Corrected+process.hltQuadJet70+process.HLTEndSequence)


process.HLT_Mu12_v1 = cms.Path(process.HLTBeginSequenceBPTX+process.hltL1sL1SingleMu7+process.hltPreMu12+process.hltL1SingleMu7L1Filtered0+process.HLTL2muonrecoSequence+process.hltL2Mu7L2Filtered7+process.HLTL3muonrecoSequence+process.hltSingleMu12L3Filtered12+process.HLTEndSequence)


process.digitisation_step = cms.Path(process.pdigi)


process.L1simulation_step = cms.Path(process.SimL1Emulator)


process.digi2raw_step = cms.Path(process.DigiToRaw)


process.fixGenInfo = cms.Path(process.GeneInfo+process.genJetMET)


process.endjob_step = cms.EndPath(process.endOfProcess)


process.RAWSIMoutput_step = cms.EndPath(process.RAWSIMoutput)


process.DQMStore = cms.Service("DQMStore")


process.DTDataIntegrityTask = cms.Service("DTDataIntegrityTask",
    processingMode = cms.untracked.string('HLT'),
    fedIntegrityFolder = cms.untracked.string('DT/FEDIntegrity_EvF'),
    getSCInfo = cms.untracked.bool(True)
)


process.MessageLogger = cms.Service("MessageLogger",
    suppressInfo = cms.untracked.vstring(),
    debugs = cms.untracked.PSet(
        placeholder = cms.untracked.bool(True)
    ),
    suppressDebug = cms.untracked.vstring(),
    cout = cms.untracked.PSet(
        placeholder = cms.untracked.bool(True)
    ),
    cerr_stats = cms.untracked.PSet(
        threshold = cms.untracked.string('WARNING'),
        output = cms.untracked.string('cerr'),
        optionalPSet = cms.untracked.bool(True)
    ),
    warnings = cms.untracked.PSet(
        placeholder = cms.untracked.bool(True)
    ),
    default = cms.untracked.PSet(

    ),
    statistics = cms.untracked.vstring('cerr_stats'),
    cerr = cms.untracked.PSet(
        INFO = cms.untracked.PSet(
            limit = cms.untracked.int32(0)
        ),
        noTimeStamps = cms.untracked.bool(False),
        FwkReport = cms.untracked.PSet(
            reportEvery = cms.untracked.int32(1),
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(10000000)
        ),
        default = cms.untracked.PSet(
            limit = cms.untracked.int32(10000000)
        ),
        Root_NoDictionary = cms.untracked.PSet(
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(0)
        ),
        threshold = cms.untracked.string('INFO'),
        FwkJob = cms.untracked.PSet(
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(0)
        ),
        FwkSummary = cms.untracked.PSet(
            reportEvery = cms.untracked.int32(1),
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(10000000)
        ),
        optionalPSet = cms.untracked.bool(True)
    ),
    FrameworkJobReport = cms.untracked.PSet(
        default = cms.untracked.PSet(
            limit = cms.untracked.int32(0)
        ),
        optionalPSet = cms.untracked.bool(True),
        FwkJob = cms.untracked.PSet(
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(10000000)
        )
    ),
    suppressWarning = cms.untracked.vstring(),
    errors = cms.untracked.PSet(
        placeholder = cms.untracked.bool(True)
    ),
    destinations = cms.untracked.vstring('warnings',
        'errors',
        'infos',
        'debugs',
        'cout',
        'cerr'),
    debugModules = cms.untracked.vstring(),
    infos = cms.untracked.PSet(
        optionalPSet = cms.untracked.bool(True),
        Root_NoDictionary = cms.untracked.PSet(
            optionalPSet = cms.untracked.bool(True),
            limit = cms.untracked.int32(0)
        ),
        placeholder = cms.untracked.bool(True)
    ),
    categories = cms.untracked.vstring('FwkJob',
        'FwkReport',
        'FwkSummary',
        'Root_NoDictionary'),
    fwkJobReports = cms.untracked.vstring('FrameworkJobReport')
)


process.RandomNumberGeneratorService = cms.Service("RandomNumberGeneratorService",
    hiSignalG4SimHits = cms.PSet(
        initialSeed = cms.untracked.uint32(11),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simCastorDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(12345678),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    generator = cms.PSet(
        initialSeed = cms.untracked.uint32(123456789),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simMuonRPCDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(1234567),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    hiSignal = cms.PSet(
        initialSeed = cms.untracked.uint32(123456789),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simEcalUnsuppressedDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(1234567),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    saveFileName = cms.untracked.string(''),
    simSiStripDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(1234567),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    mix = cms.PSet(
        initialSeed = cms.untracked.uint32(12345),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simHcalUnsuppressedDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(11223344),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    LHCTransport = cms.PSet(
        initialSeed = cms.untracked.uint32(87654321),
        engineName = cms.untracked.string('TRandom3')
    ),
    simMuonCSCDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(11223344),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    mixData = cms.PSet(
        initialSeed = cms.untracked.uint32(12345),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    VtxSmeared = cms.PSet(
        initialSeed = cms.untracked.uint32(98765432),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    g4SimHits = cms.PSet(
        initialSeed = cms.untracked.uint32(11),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simMuonDTDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(1234567),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    simSiPixelDigis = cms.PSet(
        initialSeed = cms.untracked.uint32(1234567),
        engineName = cms.untracked.string('HepJamesRandom')
    ),
    hiSignalLHCTransport = cms.PSet(
        initialSeed = cms.untracked.uint32(88776655),
        engineName = cms.untracked.string('TRandom3')
    ),
    restoreStateLabel = cms.untracked.string('randomEngineStateProducer')
)


process.UpdaterService = cms.Service("UpdaterService")


process.AnyDirectionAnalyticalPropagator = cms.ESProducer("AnalyticalPropagatorESProducer",
    MaxDPhi = cms.double(1.6),
    ComponentName = cms.string('AnyDirectionAnalyticalPropagator'),
    appendToDataLabel = cms.string(''),
    PropagationDirection = cms.string('anyDirection')
)


process.CSCGeometryESModule = cms.ESProducer("CSCGeometryESModule",
    appendToDataLabel = cms.string(''),
    useDDD = cms.bool(False),
    debugV = cms.untracked.bool(False),
    useGangedStripsInME1a = cms.bool(True),
    alignmentsLabel = cms.string(''),
    useOnlyWiresInME1a = cms.bool(False),
    useRealWireGeometry = cms.bool(True),
    useCentreTIOffsets = cms.bool(False),
    applyAlignment = cms.bool(True)
)


process.CaloGeometryBuilder = cms.ESProducer("CaloGeometryBuilder",
    SelectedCalos = cms.vstring('HCAL',
        'ZDC',
        'CASTOR',
        'EcalBarrel',
        'EcalEndcap',
        'EcalPreshower',
        'TOWER')
)


process.CaloTopologyBuilder = cms.ESProducer("CaloTopologyBuilder",
    appendToDataLabel = cms.string('')
)


process.CaloTowerConstituentsMapBuilder = cms.ESProducer("CaloTowerConstituentsMapBuilder",
    appendToDataLabel = cms.string(''),
    MapFile = cms.untracked.string('Geometry/CaloTopology/data/CaloTowerEEGeometric.map.gz')
)


process.CaloTowerGeometryFromDBEP = cms.ESProducer("CaloTowerGeometryFromDBEP",
    applyAlignment = cms.bool(False)
)


process.CastorDbProducer = cms.ESProducer("CastorDbProducer")


process.CastorGeometryFromDBEP = cms.ESProducer("CastorGeometryFromDBEP",
    applyAlignment = cms.bool(False)
)


process.DTGeometryESModule = cms.ESProducer("DTGeometryESModule",
    appendToDataLabel = cms.string(''),
    fromDDD = cms.bool(False),
    applyAlignment = cms.bool(True),
    alignmentsLabel = cms.string('')
)


process.EcalBarrelGeometryFromDBEP = cms.ESProducer("EcalBarrelGeometryFromDBEP",
    applyAlignment = cms.bool(True)
)


process.EcalElectronicsMappingBuilder = cms.ESProducer("EcalElectronicsMappingBuilder")


process.EcalEndcapGeometryFromDBEP = cms.ESProducer("EcalEndcapGeometryFromDBEP",
    applyAlignment = cms.bool(True)
)


process.EcalLaserCorrectionService = cms.ESProducer("EcalLaserCorrectionService")


process.EcalPreshowerGeometryFromDBEP = cms.ESProducer("EcalPreshowerGeometryFromDBEP",
    applyAlignment = cms.bool(True)
)


process.EcalTrigTowerConstituentsMapBuilder = cms.ESProducer("EcalTrigTowerConstituentsMapBuilder",
    MapFile = cms.untracked.string('Geometry/EcalMapping/data/EndCap_TTMap.txt')
)


process.EcalUnpackerWorkerESProducer = cms.ESProducer("EcalUnpackerWorkerESProducer",
    CalibRHAlgo = cms.PSet(
        flagsMapDBReco = cms.vint32(0, 0, 0, 0, 4,
            -1, -1, -1, 4, 4,
            6, 6, 6, 7, 8),
        Type = cms.string('EcalRecHitWorkerSimple'),
        killDeadChannels = cms.bool(True),
        ChannelStatusToBeExcluded = cms.vint32(10, 11, 12, 13, 14,
            78, 142),
        laserCorrection = cms.bool(False)
    ),
    appendToDataLabel = cms.string(''),
    ComponentName = cms.string(''),
    UncalibRHAlgo = cms.PSet(
        Type = cms.string('EcalUncalibRecHitWorkerWeights')
    ),
    DCCDataUnpacker = cms.PSet(
        orderedDCCIdList = cms.vint32(1, 2, 3, 4, 5,
            6, 7, 8, 9, 10,
            11, 12, 13, 14, 15,
            16, 17, 18, 19, 20,
            21, 22, 23, 24, 25,
            26, 27, 28, 29, 30,
            31, 32, 33, 34, 35,
            36, 37, 38, 39, 40,
            41, 42, 43, 44, 45,
            46, 47, 48, 49, 50,
            51, 52, 53, 54),
        tccUnpacking = cms.bool(False),
        srpUnpacking = cms.bool(False),
        syncCheck = cms.bool(False),
        feIdCheck = cms.bool(True),
        headerUnpacking = cms.bool(True),
        orderedFedList = cms.vint32(601, 602, 603, 604, 605,
            606, 607, 608, 609, 610,
            611, 612, 613, 614, 615,
            616, 617, 618, 619, 620,
            621, 622, 623, 624, 625,
            626, 627, 628, 629, 630,
            631, 632, 633, 634, 635,
            636, 637, 638, 639, 640,
            641, 642, 643, 644, 645,
            646, 647, 648, 649, 650,
            651, 652, 653, 654),
        feUnpacking = cms.bool(True),
        forceKeepFRData = cms.bool(False),
        memUnpacking = cms.bool(True)
    ),
    ElectronicsMapper = cms.PSet(
        numbXtalTSamples = cms.uint32(10),
        numbTriggerTSamples = cms.uint32(1)
    )
)


process.GlobalTrackingGeometryESProducer = cms.ESProducer("GlobalTrackingGeometryESProducer")


process.HcalAlignmentEP = cms.ESProducer("HcalAlignmentEP")


process.HcalGeometryFromDBEP = cms.ESProducer("HcalGeometryFromDBEP",
    applyAlignment = cms.bool(False)
)


process.HcalTPGCoderULUT = cms.ESProducer("HcalTPGCoderULUT",
    read_FG_LUTs = cms.bool(False),
    FGLUTs = cms.FileInPath('CalibCalorimetry/HcalTPGAlgos/data/HBHE_FG_LUT.dat'),
    MaskBit = cms.int32(32768),
    read_Ascii_LUTs = cms.bool(False),
    read_XML_LUTs = cms.bool(False),
    RCalibFile = cms.FileInPath('CalibCalorimetry/HcalTPGAlgos/data/RecHit-TPG-calib.dat'),
    LUTGenerationMode = cms.bool(True),
    inputLUTs = cms.FileInPath('CalibCalorimetry/HcalTPGAlgos/data/inputLUTcoder_physics.dat')
)


process.HcalTopologyIdealEP = cms.ESProducer("HcalTopologyIdealEP")


process.L1DTConfigFromDB = cms.ESProducer("DTConfigDBProducer",
    DTTPGMap = cms.untracked.PSet(
        wh0st2se11 = cms.untracked.vint32(60, 58, 60, 15),
        wh0st2se10 = cms.untracked.vint32(60, 58, 60, 15),
        wh0st2se12 = cms.untracked.vint32(60, 58, 60, 15),
        whm2st1se4 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st1se12 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st1se11 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st1se10 = cms.untracked.vint32(50, 58, 50, 13),
        whm2st1se1 = cms.untracked.vint32(50, 58, 50, 13),
        whm2st1se2 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st3se4 = cms.untracked.vint32(72, 58, 72, 18),
        wh1st3se4 = cms.untracked.vint32(72, 48, 72, 18),
        whm2st1se8 = cms.untracked.vint32(50, 58, 50, 13),
        whm2st1se9 = cms.untracked.vint32(50, 58, 50, 13),
        wh1st1se1 = cms.untracked.vint32(50, 58, 50, 13),
        wh0st2se6 = cms.untracked.vint32(60, 58, 60, 15),
        whm2st1se12 = cms.untracked.vint32(50, 58, 50, 13),
        whm2st1se10 = cms.untracked.vint32(50, 58, 50, 13),
        whm2st1se11 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st2se12 = cms.untracked.vint32(60, 58, 60, 15),
        wh0st2se1 = cms.untracked.vint32(60, 58, 60, 15),
        wh1st1se3 = cms.untracked.vint32(50, 58, 50, 13),
        wh1st1se2 = cms.untracked.vint32(50, 58, 50, 13),
        whm1st3se3 = cms.untracked.vint32(72, 48, 72, 18),
        whm1st1se7 = cms.untracked.vint32(50, 58, 50, 13),
        wh0st2se2 = cms.untracked.vint32(60, 58, 60, 15),
        whm1st1se6 = cms.untracked.vint32(50, 58, 50, 13),
        wh0st4se8 = cms.untracked.vint32(92, 0, 92, 23),
        whm1st3se11 = cms.untracked.vint32(72, 58, 72, 18),
        wh0st2se9 = cms.untracked.vint32(60, 58, 60, 15),
        wh0st2se8 = cms.untracked.vint32(60, 58, 60, 15),
        whm1st3se10 = cms.untracked.vint32(72, 58, 72, 18),
        whm1st3se5 = cms.untracked.vint32(72, 58, 