# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGatewayHostNameConfigurationResult',
    'AwaitableGetGatewayHostNameConfigurationResult',
    'get_gateway_host_name_configuration',
    'get_gateway_host_name_configuration_output',
]

@pulumi.output_type
class GetGatewayHostNameConfigurationResult:
    """
    A collection of values returned by getGatewayHostNameConfiguration.
    """
    def __init__(__self__, api_management_id=None, certificate_id=None, gateway_name=None, host_name=None, http2_enabled=None, id=None, name=None, request_client_certificate_enabled=None, tls10_enabled=None, tls11_enabled=None):
        if api_management_id and not isinstance(api_management_id, str):
            raise TypeError("Expected argument 'api_management_id' to be a str")
        pulumi.set(__self__, "api_management_id", api_management_id)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if gateway_name and not isinstance(gateway_name, str):
            raise TypeError("Expected argument 'gateway_name' to be a str")
        pulumi.set(__self__, "gateway_name", gateway_name)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if http2_enabled and not isinstance(http2_enabled, bool):
            raise TypeError("Expected argument 'http2_enabled' to be a bool")
        pulumi.set(__self__, "http2_enabled", http2_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if request_client_certificate_enabled and not isinstance(request_client_certificate_enabled, bool):
            raise TypeError("Expected argument 'request_client_certificate_enabled' to be a bool")
        pulumi.set(__self__, "request_client_certificate_enabled", request_client_certificate_enabled)
        if tls10_enabled and not isinstance(tls10_enabled, bool):
            raise TypeError("Expected argument 'tls10_enabled' to be a bool")
        pulumi.set(__self__, "tls10_enabled", tls10_enabled)
        if tls11_enabled and not isinstance(tls11_enabled, bool):
            raise TypeError("Expected argument 'tls11_enabled' to be a bool")
        pulumi.set(__self__, "tls11_enabled", tls11_enabled)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> _builtins.str:
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The ID of the certificate used for TLS connection establishment.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> _builtins.str:
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        The host name used for the API Management Gateway Host Name Configuration.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> _builtins.bool:
        """
        Whether HTTP/2.0 is supported.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requestClientCertificateEnabled")
    def request_client_certificate_enabled(self) -> _builtins.bool:
        """
        Whether the API Management Gateway requests a client certificate.
        """
        return pulumi.get(self, "request_client_certificate_enabled")

    @_builtins.property
    @pulumi.getter(name="tls10Enabled")
    def tls10_enabled(self) -> _builtins.bool:
        """
        Whether TLS 1.0 is supported.
        """
        return pulumi.get(self, "tls10_enabled")

    @_builtins.property
    @pulumi.getter(name="tls11Enabled")
    def tls11_enabled(self) -> _builtins.bool:
        """
        Whether TLS 1.1 is supported.
        """
        return pulumi.get(self, "tls11_enabled")


class AwaitableGetGatewayHostNameConfigurationResult(GetGatewayHostNameConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayHostNameConfigurationResult(
            api_management_id=self.api_management_id,
            certificate_id=self.certificate_id,
            gateway_name=self.gateway_name,
            host_name=self.host_name,
            http2_enabled=self.http2_enabled,
            id=self.id,
            name=self.name,
            request_client_certificate_enabled=self.request_client_certificate_enabled,
            tls10_enabled=self.tls10_enabled,
            tls11_enabled=self.tls11_enabled)


def get_gateway_host_name_configuration(api_management_id: Optional[_builtins.str] = None,
                                        gateway_name: Optional[_builtins.str] = None,
                                        name: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayHostNameConfigurationResult:
    """
    Use this data source to access information about an existing API Management Gateway Host Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="example-apim",
        resource_group_name="example-resources")
    example_get_gateway = azure.apimanagement.get_gateway(name="example-gateway",
        api_management_id=main["id"])
    example_get_gateway_host_name_configuration = azure.apimanagement.get_gateway_host_name_configuration(name="example-host-configuration",
        api_management_id=example.id,
        gateway_name=example_get_gateway.name)
    pulumi.export("hostName", example_get_gateway_host_name_configuration.host_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement`: 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service.
    :param _builtins.str gateway_name: The name of the API Management Gateway.
           *
    :param _builtins.str name: The name of the API Management Gateway Host Name Configuration.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['gatewayName'] = gateway_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getGatewayHostNameConfiguration:getGatewayHostNameConfiguration', __args__, opts=opts, typ=GetGatewayHostNameConfigurationResult).value

    return AwaitableGetGatewayHostNameConfigurationResult(
        api_management_id=pulumi.get(__ret__, 'api_management_id'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        gateway_name=pulumi.get(__ret__, 'gateway_name'),
        host_name=pulumi.get(__ret__, 'host_name'),
        http2_enabled=pulumi.get(__ret__, 'http2_enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        request_client_certificate_enabled=pulumi.get(__ret__, 'request_client_certificate_enabled'),
        tls10_enabled=pulumi.get(__ret__, 'tls10_enabled'),
        tls11_enabled=pulumi.get(__ret__, 'tls11_enabled'))
def get_gateway_host_name_configuration_output(api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                                               gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                                               name: Optional[pulumi.Input[_builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayHostNameConfigurationResult]:
    """
    Use this data source to access information about an existing API Management Gateway Host Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="example-apim",
        resource_group_name="example-resources")
    example_get_gateway = azure.apimanagement.get_gateway(name="example-gateway",
        api_management_id=main["id"])
    example_get_gateway_host_name_configuration = azure.apimanagement.get_gateway_host_name_configuration(name="example-host-configuration",
        api_management_id=example.id,
        gateway_name=example_get_gateway.name)
    pulumi.export("hostName", example_get_gateway_host_name_configuration.host_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement`: 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service.
    :param _builtins.str gateway_name: The name of the API Management Gateway.
           *
    :param _builtins.str name: The name of the API Management Gateway Host Name Configuration.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['gatewayName'] = gateway_name
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getGatewayHostNameConfiguration:getGatewayHostNameConfiguration', __args__, opts=opts, typ=GetGatewayHostNameConfigurationResult)
    return __ret__.apply(lambda __response__: GetGatewayHostNameConfigurationResult(
        api_management_id=pulumi.get(__response__, 'api_management_id'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        gateway_name=pulumi.get(__response__, 'gateway_name'),
        host_name=pulumi.get(__response__, 'host_name'),
        http2_enabled=pulumi.get(__response__, 'http2_enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        request_client_certificate_enabled=pulumi.get(__response__, 'request_client_certificate_enabled'),
        tls10_enabled=pulumi.get(__response__, 'tls10_enabled'),
        tls11_enabled=pulumi.get(__response__, 'tls11_enabled')))
