# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamedValueArgs', 'NamedValue']

@pulumi.input_type
class NamedValueArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_from_key_vault: Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']] = None):
        """
        The set of arguments for constructing a NamedValue resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The display name of this API Management Named Value.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Named Value. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] secret: Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.
               
               > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be applied to the API Management Named Value.
        :param pulumi.Input[_builtins.str] value: The value of this API Management Named Value.
        :param pulumi.Input['NamedValueValueFromKeyVaultArgs'] value_from_key_vault: A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from_key_vault is not None:
            pulumi.set(__self__, "value_from_key_vault", value_from_key_vault)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of this API Management Named Value.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Named Value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.

        > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to be applied to the API Management Named Value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of this API Management Named Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueFromKeyVault")
    def value_from_key_vault(self) -> Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']]:
        """
        A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        return pulumi.get(self, "value_from_key_vault")

    @value_from_key_vault.setter
    def value_from_key_vault(self, value: Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']]):
        pulumi.set(self, "value_from_key_vault", value)


@pulumi.input_type
class _NamedValueState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_from_key_vault: Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']] = None):
        """
        Input properties used for looking up and filtering NamedValue resources.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The display name of this API Management Named Value.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Named Value. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] secret: Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.
               
               > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be applied to the API Management Named Value.
        :param pulumi.Input[_builtins.str] value: The value of this API Management Named Value.
        :param pulumi.Input['NamedValueValueFromKeyVaultArgs'] value_from_key_vault: A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from_key_vault is not None:
            pulumi.set(__self__, "value_from_key_vault", value_from_key_vault)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of this API Management Named Value.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Named Value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.

        > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to be applied to the API Management Named Value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of this API Management Named Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueFromKeyVault")
    def value_from_key_vault(self) -> Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']]:
        """
        A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        return pulumi.get(self, "value_from_key_vault")

    @value_from_key_vault.setter
    def value_from_key_vault(self, value: Optional[pulumi.Input['NamedValueValueFromKeyVaultArgs']]):
        pulumi.set(self, "value_from_key_vault", value)


@pulumi.type_token("azure:apimanagement/namedValue:NamedValue")
class NamedValue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_from_key_vault: Optional[pulumi.Input[Union['NamedValueValueFromKeyVaultArgs', 'NamedValueValueFromKeyVaultArgsDict']]] = None,
                 __props__=None):
        """
        Manages an API Management Named Value.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_named_value = azure.apimanagement.NamedValue("example",
            name="example-apimg",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            display_name="ExampleProperty",
            value="Example Value")
        ```

        ## Import

        API Management Properties can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/namedValue:NamedValue example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ApiManagement/service/example-apim/namedValues/example-apimp
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The display name of this API Management Named Value.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Named Value. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] secret: Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.
               
               > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be applied to the API Management Named Value.
        :param pulumi.Input[_builtins.str] value: The value of this API Management Named Value.
        :param pulumi.Input[Union['NamedValueValueFromKeyVaultArgs', 'NamedValueValueFromKeyVaultArgsDict']] value_from_key_vault: A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamedValueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Named Value.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_named_value = azure.apimanagement.NamedValue("example",
            name="example-apimg",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            display_name="ExampleProperty",
            value="Example Value")
        ```

        ## Import

        API Management Properties can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/namedValue:NamedValue example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ApiManagement/service/example-apim/namedValues/example-apimp
        ```

        :param str resource_name: The name of the resource.
        :param NamedValueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamedValueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_from_key_vault: Optional[pulumi.Input[Union['NamedValueValueFromKeyVaultArgs', 'NamedValueValueFromKeyVaultArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamedValueArgs.__new__(NamedValueArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secret"] = secret
            __props__.__dict__["tags"] = tags
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
            __props__.__dict__["value_from_key_vault"] = value_from_key_vault
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NamedValue, __self__).__init__(
            'azure:apimanagement/namedValue:NamedValue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None,
            value_from_key_vault: Optional[pulumi.Input[Union['NamedValueValueFromKeyVaultArgs', 'NamedValueValueFromKeyVaultArgsDict']]] = None) -> 'NamedValue':
        """
        Get an existing NamedValue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The display name of this API Management Named Value.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Named Value. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] secret: Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.
               
               > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be applied to the API Management Named Value.
        :param pulumi.Input[_builtins.str] value: The value of this API Management Named Value.
        :param pulumi.Input[Union['NamedValueValueFromKeyVaultArgs', 'NamedValueValueFromKeyVaultArgsDict']] value_from_key_vault: A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamedValueState.__new__(_NamedValueState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secret"] = secret
        __props__.__dict__["tags"] = tags
        __props__.__dict__["value"] = value
        __props__.__dict__["value_from_key_vault"] = value_from_key_vault
        return NamedValue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Service in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of this API Management Named Value.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Named Value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Named Value should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the API Management Named Value is secret. Valid values are `true` or `false`. The default value is `false`.

        > **NOTE:** setting the field `secret` to `true` doesn't make this field sensitive in the provider, instead it marks the value as secret and encrypts the value in Azure.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to be applied to the API Management Named Value.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value of this API Management Named Value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFromKeyVault")
    def value_from_key_vault(self) -> pulumi.Output[Optional['outputs.NamedValueValueFromKeyVault']]:
        """
        A `value_from_key_vault` block as defined below. If specified, `secret` must also be set to `true`.
        """
        return pulumi.get(self, "value_from_key_vault")

