# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyFragmentArgs', 'PolicyFragment']

@pulumi.input_type
class PolicyFragmentArgs:
    def __init__(__self__, *,
                 api_management_id: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyFragment resource.
        :param pulumi.Input[_builtins.str] api_management_id: The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] value: The value of the Policy Fragment.
               
               > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        :param pulumi.Input[_builtins.str] description: The description for the Policy Fragment.
        :param pulumi.Input[_builtins.str] format: The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.
               
               > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        """
        pulumi.set(__self__, "api_management_id", api_management_id)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the Policy Fragment.

        > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Policy Fragment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.

        > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PolicyFragmentState:
    def __init__(__self__, *,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyFragment resources.
        :param pulumi.Input[_builtins.str] api_management_id: The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] description: The description for the Policy Fragment.
        :param pulumi.Input[_builtins.str] format: The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.
               
               > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] value: The value of the Policy Fragment.
               
               > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        if api_management_id is not None:
            pulumi.set(__self__, "api_management_id", api_management_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Policy Fragment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.

        > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the Policy Fragment.

        > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("azure:apimanagement/policyFragment:PolicyFragment")
class PolicyFragment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Api Management Policy Fragment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_policy_fragment = azure.apimanagement.PolicyFragment("example",
            api_management_id=example_service.id,
            name="example-policy-fragment",
            format="xml",
            value=std.file(input="policy-fragment-1.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        Api Management Policy Fragments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/policyFragment:PolicyFragment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/policyFragments/policyFragment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] description: The description for the Policy Fragment.
        :param pulumi.Input[_builtins.str] format: The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.
               
               > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] value: The value of the Policy Fragment.
               
               > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyFragmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Api Management Policy Fragment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_policy_fragment = azure.apimanagement.PolicyFragment("example",
            api_management_id=example_service.id,
            name="example-policy-fragment",
            format="xml",
            value=std.file(input="policy-fragment-1.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        Api Management Policy Fragments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/policyFragment:PolicyFragment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/policyFragments/policyFragment1
        ```

        :param str resource_name: The name of the resource.
        :param PolicyFragmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyFragmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyFragmentArgs.__new__(PolicyFragmentArgs)

            if api_management_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_id'")
            __props__.__dict__["api_management_id"] = api_management_id
            __props__.__dict__["description"] = description
            __props__.__dict__["format"] = format
            __props__.__dict__["name"] = name
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(PolicyFragment, __self__).__init__(
            'azure:apimanagement/policyFragment:PolicyFragment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicyFragment':
        """
        Get an existing PolicyFragment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] description: The description for the Policy Fragment.
        :param pulumi.Input[_builtins.str] format: The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.
               
               > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        :param pulumi.Input[_builtins.str] value: The value of the Policy Fragment.
               
               > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyFragmentState.__new__(_PolicyFragmentState)

        __props__.__dict__["api_management_id"] = api_management_id
        __props__.__dict__["description"] = description
        __props__.__dict__["format"] = format
        __props__.__dict__["name"] = name
        __props__.__dict__["value"] = value
        return PolicyFragment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the API Management Service. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Policy Fragment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of the Policy Fragment. Possible values are `xml` or `rawxml`. Default is `xml`.

        > **Note:** The `value` property will be updated to reflect the corresponding format when `format` is updated.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Api Management Policy Fragment. Changing this forces a new Api Management Policy Fragment to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the Policy Fragment.

        > **Note:** Be aware of the two format possibilities. If the `value` is not applied and continues to cause a diff the format could be wrong.
        """
        return pulumi.get(self, "value")

