# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProductTagArgs', 'ProductTag']

@pulumi.input_type
class ProductTagArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 api_management_product_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProductTag resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_management_product_id: The name of the API Management product. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "api_management_product_id", api_management_product_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="apiManagementProductId")
    def api_management_product_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management product. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_product_id")

    @api_management_product_id.setter
    def api_management_product_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_product_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ProductTagState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProductTag resources.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_management_product_id: The name of the API Management product. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if api_management_product_id is not None:
            pulumi.set(__self__, "api_management_product_id", api_management_product_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="apiManagementProductId")
    def api_management_product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management product. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_product_id")

    @api_management_product_id.setter
    def api_management_product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_product_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:apimanagement/productTag:ProductTag")
class ProductTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Product tag

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1")
        example_product = azure.apimanagement.Product("example",
            product_id="test-product",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            display_name="Test Product",
            subscription_required=True,
            approval_required=True,
            published=True)
        example_tag = azure.apimanagement.Tag("example",
            api_management_id=example_service.id,
            name="example-tag")
        example_product_tag = azure.apimanagement.ProductTag("example",
            api_management_product_id=example_product.product_id,
            api_management_name=example_service.name,
            resource_group_name=example.name,
            name=example_tag.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Products can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/productTag:ProductTag example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/products/myproduct/tags/mytag
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_management_product_id: The name of the API Management product. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Product tag

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1")
        example_product = azure.apimanagement.Product("example",
            product_id="test-product",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            display_name="Test Product",
            subscription_required=True,
            approval_required=True,
            published=True)
        example_tag = azure.apimanagement.Tag("example",
            api_management_id=example_service.id,
            name="example-tag")
        example_product_tag = azure.apimanagement.ProductTag("example",
            api_management_product_id=example_product.product_id,
            api_management_name=example_service.name,
            resource_group_name=example.name,
            name=example_tag.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Products can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/productTag:ProductTag example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/products/myproduct/tags/mytag
        ```

        :param str resource_name: The name of the resource.
        :param ProductTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductTagArgs.__new__(ProductTagArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if api_management_product_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_product_id'")
            __props__.__dict__["api_management_product_id"] = api_management_product_id
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(ProductTag, __self__).__init__(
            'azure:apimanagement/productTag:ProductTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            api_management_product_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProductTag':
        """
        Get an existing ProductTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_management_product_id: The name of the API Management product. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductTagState.__new__(_ProductTagState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["api_management_product_id"] = api_management_product_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return ProductTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="apiManagementProductId")
    def api_management_product_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management product. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_product_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this API Management Tag. Changing this forces a new API Management Tag to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

