# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudContainerDeploymentArgs', 'SpringCloudContainerDeployment']

@pulumi.input_type
class SpringCloudContainerDeploymentArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[_builtins.str],
                 server: pulumi.Input[_builtins.str],
                 spring_cloud_app_id: pulumi.Input[_builtins.str],
                 addon_json: Optional[pulumi.Input[_builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 language_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']] = None):
        """
        The set of arguments for constructing a SpringCloudContainerDeployment resource.
        :param pulumi.Input[_builtins.str] image: Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        :param pulumi.Input[_builtins.str] server: The name of the registry that contains the container image.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        :param pulumi.Input[_builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arguments: Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[_builtins.str] language_framework: Specifies the language framework of the container image. The only possible value is `springboot`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        :param pulumi.Input['SpringCloudContainerDeploymentQuotaArgs'] quota: A `quota` block as defined below.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if addon_json is not None:
            pulumi.set(__self__, "addon_json", addon_json)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if language_framework is not None:
            pulumi.set(__self__, "language_framework", language_framework)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the registry that contains the container image.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @_builtins.property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        """
        return pulumi.get(self, "addon_json")

    @addon_json.setter
    def addon_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_json", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="languageFramework")
    def language_framework(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the language framework of the container image. The only possible value is `springboot`.
        """
        return pulumi.get(self, "language_framework")

    @language_framework.setter
    def language_framework(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_framework", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class _SpringCloudContainerDeploymentState:
    def __init__(__self__, *,
                 addon_json: Optional[pulumi.Input[_builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 language_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudContainerDeployment resources.
        :param pulumi.Input[_builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arguments: Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] image: Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[_builtins.str] language_framework: Specifies the language framework of the container image. The only possible value is `springboot`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        :param pulumi.Input['SpringCloudContainerDeploymentQuotaArgs'] quota: A `quota` block as defined below.
        :param pulumi.Input[_builtins.str] server: The name of the registry that contains the container image.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        if addon_json is not None:
            pulumi.set(__self__, "addon_json", addon_json)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if language_framework is not None:
            pulumi.set(__self__, "language_framework", language_framework)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if spring_cloud_app_id is not None:
            pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)

    @_builtins.property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        """
        return pulumi.get(self, "addon_json")

    @addon_json.setter
    def addon_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_json", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="languageFramework")
    def language_framework(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the language framework of the container image. The only possible value is `springboot`.
        """
        return pulumi.get(self, "language_framework")

    @language_framework.setter
    def language_framework(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_framework", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudContainerDeploymentQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the registry that contains the container image.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_app_id", value)


@pulumi.type_token("azure:appplatform/springCloudContainerDeployment:SpringCloudContainerDeployment")
class SpringCloudContainerDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_json: Optional[pulumi.Input[_builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 language_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudContainerDeploymentQuotaArgs', 'SpringCloudContainerDeploymentQuotaArgsDict']]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud Container Deployment.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudContainerDeployment` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name)
        example_spring_cloud_container_deployment = azure.appplatform.SpringCloudContainerDeployment("example",
            name="example",
            spring_cloud_app_id=example_spring_cloud_app.id,
            instance_count=2,
            arguments=[
                "-cp",
                "/app/resources:/app/classes:/app/libs/*",
                "hello.Application",
            ],
            commands=["java"],
            environment_variables={
                "Foo": "Bar",
                "Env": "Staging",
            },
            server="docker.io",
            image="springio/gs-spring-boot-docker",
            language_framework="springboot")
        ```

        ## Import

        Spring Cloud Container Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudContainerDeployment:SpringCloudContainerDeployment example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/deployments/deploy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arguments: Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] image: Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[_builtins.str] language_framework: Specifies the language framework of the container image. The only possible value is `springboot`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        :param pulumi.Input[Union['SpringCloudContainerDeploymentQuotaArgs', 'SpringCloudContainerDeploymentQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[_builtins.str] server: The name of the registry that contains the container image.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudContainerDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud Container Deployment.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudContainerDeployment` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name)
        example_spring_cloud_container_deployment = azure.appplatform.SpringCloudContainerDeployment("example",
            name="example",
            spring_cloud_app_id=example_spring_cloud_app.id,
            instance_count=2,
            arguments=[
                "-cp",
                "/app/resources:/app/classes:/app/libs/*",
                "hello.Application",
            ],
            commands=["java"],
            environment_variables={
                "Foo": "Bar",
                "Env": "Staging",
            },
            server="docker.io",
            image="springio/gs-spring-boot-docker",
            language_framework="springboot")
        ```

        ## Import

        Spring Cloud Container Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudContainerDeployment:SpringCloudContainerDeployment example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/deployments/deploy1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudContainerDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudContainerDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_json: Optional[pulumi.Input[_builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 language_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudContainerDeploymentQuotaArgs', 'SpringCloudContainerDeploymentQuotaArgsDict']]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudContainerDeploymentArgs.__new__(SpringCloudContainerDeploymentArgs)

            __props__.__dict__["addon_json"] = addon_json
            __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
            __props__.__dict__["arguments"] = arguments
            __props__.__dict__["commands"] = commands
            __props__.__dict__["environment_variables"] = environment_variables
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["language_framework"] = language_framework
            __props__.__dict__["name"] = name
            __props__.__dict__["quota"] = quota
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            if spring_cloud_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_app_id'")
            __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        super(SpringCloudContainerDeployment, __self__).__init__(
            'azure:appplatform/springCloudContainerDeployment:SpringCloudContainerDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_json: Optional[pulumi.Input[_builtins.str]] = None,
            application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            arguments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            language_framework: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            quota: Optional[pulumi.Input[Union['SpringCloudContainerDeploymentQuotaArgs', 'SpringCloudContainerDeploymentQuotaArgsDict']]] = None,
            server: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudContainerDeployment':
        """
        Get an existing SpringCloudContainerDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arguments: Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] image: Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[_builtins.str] language_framework: Specifies the language framework of the container image. The only possible value is `springboot`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        :param pulumi.Input[Union['SpringCloudContainerDeploymentQuotaArgs', 'SpringCloudContainerDeploymentQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[_builtins.str] server: The name of the registry that contains the container image.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudContainerDeploymentState.__new__(_SpringCloudContainerDeploymentState)

        __props__.__dict__["addon_json"] = addon_json
        __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
        __props__.__dict__["arguments"] = arguments
        __props__.__dict__["commands"] = commands
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["image"] = image
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["language_framework"] = language_framework
        __props__.__dict__["name"] = name
        __props__.__dict__["quota"] = quota
        __props__.__dict__["server"] = server
        __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        return SpringCloudContainerDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> pulumi.Output[_builtins.str]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Container Deployment.
        """
        return pulumi.get(self, "addon_json")

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the arguments to the entrypoint. The docker image's `CMD` is used if not specified.
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the entrypoint array. It will not be executed within a shell. The docker image's `ENTRYPOINT` is used if not specified.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[_builtins.str]:
        """
        Container image of the custom container. This should be in the form of `<repository>:<tag>` without the server name of the registry.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="languageFramework")
    def language_framework(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the language framework of the container image. The only possible value is `springboot`.
        """
        return pulumi.get(self, "language_framework")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Container Deployment. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> pulumi.Output['outputs.SpringCloudContainerDeploymentQuota']:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @_builtins.property
    @pulumi.getter
    def server(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the registry that contains the container image.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Container Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

