# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HybridConnectionArgs', 'HybridConnection']

@pulumi.input_type
class HybridConnectionArgs:
    def __init__(__self__, *,
                 app_service_name: pulumi.Input[_builtins.str],
                 hostname: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 relay_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 send_key_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HybridConnection resource.
        :param pulumi.Input[_builtins.str] app_service_name: Specifies the name of the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the endpoint.
        :param pulumi.Input[_builtins.int] port: The port of the endpoint.
        :param pulumi.Input[_builtins.str] relay_id: The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] send_key_name: The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        """
        pulumi.set(__self__, "app_service_name", app_service_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "relay_id", relay_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if send_key_name is not None:
            pulumi.set(__self__, "send_key_name", send_key_name)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @app_service_name.setter
    def app_service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_name", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="relayId")
    def relay_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "relay_id")

    @relay_id.setter
    def relay_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "relay_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sendKeyName")
    def send_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "send_key_name")

    @send_key_name.setter
    def send_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "send_key_name", value)


@pulumi.input_type
class _HybridConnectionState:
    def __init__(__self__, *,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 relay_id: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 send_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 send_key_value: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_suffix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HybridConnection resources.
        :param pulumi.Input[_builtins.str] app_service_name: Specifies the name of the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the endpoint.
        :param pulumi.Input[_builtins.str] namespace_name: The name of the Relay Namespace.
        :param pulumi.Input[_builtins.int] port: The port of the endpoint.
        :param pulumi.Input[_builtins.str] relay_id: The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] send_key_name: The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] send_key_value: The value of the Service Bus Primary Access key.
        :param pulumi.Input[_builtins.str] service_bus_namespace: The name of the Service Bus namespace.
        :param pulumi.Input[_builtins.str] service_bus_suffix: The suffix for the service bus endpoint.
        """
        if app_service_name is not None:
            pulumi.set(__self__, "app_service_name", app_service_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if relay_id is not None:
            pulumi.set(__self__, "relay_id", relay_id)
        if relay_name is not None:
            pulumi.set(__self__, "relay_name", relay_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if send_key_name is not None:
            pulumi.set(__self__, "send_key_name", send_key_name)
        if send_key_value is not None:
            pulumi.set(__self__, "send_key_value", send_key_value)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if service_bus_suffix is not None:
            pulumi.set(__self__, "service_bus_suffix", service_bus_suffix)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @app_service_name.setter
    def app_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_name", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Relay Namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="relayId")
    def relay_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "relay_id")

    @relay_id.setter
    def relay_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_id", value)

    @_builtins.property
    @pulumi.getter(name="relayName")
    def relay_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "relay_name")

    @relay_name.setter
    def relay_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sendKeyName")
    def send_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "send_key_name")

    @send_key_name.setter
    def send_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "send_key_name", value)

    @_builtins.property
    @pulumi.getter(name="sendKeyValue")
    def send_key_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the Service Bus Primary Access key.
        """
        return pulumi.get(self, "send_key_value")

    @send_key_value.setter
    def send_key_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "send_key_value", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Bus namespace.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusSuffix")
    def service_bus_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The suffix for the service bus endpoint.
        """
        return pulumi.get(self, "service_bus_suffix")

    @service_bus_suffix.setter
    def service_bus_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_suffix", value)


@pulumi.type_token("azure:appservice/hybridConnection:HybridConnection")
class HybridConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 relay_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 send_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an App Service Hybrid Connection for an existing App Service, Relay and Service Bus.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.FunctionAppHybridConnection` and `appservice.WebAppHybridConnection` resources instead.

        ## Example Usage

        This example provisions an App Service, a Relay Hybrid Connection, and a Service Bus using their outputs to create the App Service Hybrid Connection.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exampleResourceGroup1",
            location="West Europe")
        example_plan = azure.appservice.Plan("example",
            name="exampleAppServicePlan1",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_app_service = azure.appservice.AppService("example",
            name="exampleAppService1",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id)
        example_namespace = azure.relay.Namespace("example",
            name="exampleRN1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_hybrid_connection = azure.relay.HybridConnection("example",
            name="exampleRHC1",
            resource_group_name=example.name,
            relay_namespace_name=example_namespace.name,
            user_metadata="examplemetadata")
        example_hybrid_connection2 = azure.appservice.HybridConnection("example",
            app_service_name=example_app_service.name,
            resource_group_name=example.name,
            relay_id=example_hybrid_connection.id,
            hostname="testhostname.example",
            port=8080,
            send_key_name="exampleSharedAccessKey")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Relay`: 2021-11-01

        ## Import

        App Service Hybrid Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/hybridConnection:HybridConnection example /subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/exampleResourceGroup1/providers/Microsoft.Web/sites/exampleAppService1/hybridConnectionNamespaces/exampleRN1/relays/exampleRHC1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_name: Specifies the name of the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the endpoint.
        :param pulumi.Input[_builtins.int] port: The port of the endpoint.
        :param pulumi.Input[_builtins.str] relay_id: The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] send_key_name: The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HybridConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an App Service Hybrid Connection for an existing App Service, Relay and Service Bus.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.FunctionAppHybridConnection` and `appservice.WebAppHybridConnection` resources instead.

        ## Example Usage

        This example provisions an App Service, a Relay Hybrid Connection, and a Service Bus using their outputs to create the App Service Hybrid Connection.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exampleResourceGroup1",
            location="West Europe")
        example_plan = azure.appservice.Plan("example",
            name="exampleAppServicePlan1",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_app_service = azure.appservice.AppService("example",
            name="exampleAppService1",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id)
        example_namespace = azure.relay.Namespace("example",
            name="exampleRN1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_hybrid_connection = azure.relay.HybridConnection("example",
            name="exampleRHC1",
            resource_group_name=example.name,
            relay_namespace_name=example_namespace.name,
            user_metadata="examplemetadata")
        example_hybrid_connection2 = azure.appservice.HybridConnection("example",
            app_service_name=example_app_service.name,
            resource_group_name=example.name,
            relay_id=example_hybrid_connection.id,
            hostname="testhostname.example",
            port=8080,
            send_key_name="exampleSharedAccessKey")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Relay`: 2021-11-01

        ## Import

        App Service Hybrid Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/hybridConnection:HybridConnection example /subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/exampleResourceGroup1/providers/Microsoft.Web/sites/exampleAppService1/hybridConnectionNamespaces/exampleRN1/relays/exampleRHC1
        ```

        :param str resource_name: The name of the resource.
        :param HybridConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HybridConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 relay_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 send_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HybridConnectionArgs.__new__(HybridConnectionArgs)

            if app_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_name'")
            __props__.__dict__["app_service_name"] = app_service_name
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if relay_id is None and not opts.urn:
                raise TypeError("Missing required property 'relay_id'")
            __props__.__dict__["relay_id"] = relay_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["send_key_name"] = send_key_name
            __props__.__dict__["namespace_name"] = None
            __props__.__dict__["relay_name"] = None
            __props__.__dict__["send_key_value"] = None
            __props__.__dict__["service_bus_namespace"] = None
            __props__.__dict__["service_bus_suffix"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sendKeyValue"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(HybridConnection, __self__).__init__(
            'azure:appservice/hybridConnection:HybridConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            relay_id: Optional[pulumi.Input[_builtins.str]] = None,
            relay_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            send_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            send_key_value: Optional[pulumi.Input[_builtins.str]] = None,
            service_bus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            service_bus_suffix: Optional[pulumi.Input[_builtins.str]] = None) -> 'HybridConnection':
        """
        Get an existing HybridConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_name: Specifies the name of the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the endpoint.
        :param pulumi.Input[_builtins.str] namespace_name: The name of the Relay Namespace.
        :param pulumi.Input[_builtins.int] port: The port of the endpoint.
        :param pulumi.Input[_builtins.str] relay_id: The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] send_key_name: The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] send_key_value: The value of the Service Bus Primary Access key.
        :param pulumi.Input[_builtins.str] service_bus_namespace: The name of the Service Bus namespace.
        :param pulumi.Input[_builtins.str] service_bus_suffix: The suffix for the service bus endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HybridConnectionState.__new__(_HybridConnectionState)

        __props__.__dict__["app_service_name"] = app_service_name
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["port"] = port
        __props__.__dict__["relay_id"] = relay_id
        __props__.__dict__["relay_name"] = relay_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["send_key_name"] = send_key_name
        __props__.__dict__["send_key_value"] = send_key_value
        __props__.__dict__["service_bus_namespace"] = service_bus_namespace
        __props__.__dict__["service_bus_suffix"] = service_bus_suffix
        return HybridConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Relay Namespace.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="relayId")
    def relay_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Service Bus Relay. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "relay_id")

    @_builtins.property
    @pulumi.getter(name="relayName")
    def relay_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "relay_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the App Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sendKeyName")
    def send_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Service Bus key which has Send permissions. Defaults to `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "send_key_name")

    @_builtins.property
    @pulumi.getter(name="sendKeyValue")
    def send_key_value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the Service Bus Primary Access key.
        """
        return pulumi.get(self, "send_key_value")

    @_builtins.property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Bus namespace.
        """
        return pulumi.get(self, "service_bus_namespace")

    @_builtins.property
    @pulumi.getter(name="serviceBusSuffix")
    def service_bus_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        The suffix for the service bus endpoint.
        """
        return pulumi.get(self, "service_bus_suffix")

