# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServicePlanArgs', 'ServicePlan']

@pulumi.input_type
class ServicePlanArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 app_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_elastic_worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 per_site_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 premium_plan_auto_scale_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_balancing_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ServicePlan resource.
        :param pulumi.Input[_builtins.str] os_type: The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.
               
               > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments
               
               > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        :param pulumi.Input[_builtins.str] app_service_environment_id: The ID of the App Service Environment to create this Service Plan in.
               
               > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.int] maximum_elastic_worker_count: The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.bool] per_site_scaling_enabled: Should Per Site Scaling be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] premium_plan_auto_scale_enabled: Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AppService.
        :param pulumi.Input[_builtins.int] worker_count: The number of Workers (instances) to be allocated.
        :param pulumi.Input[_builtins.bool] zone_balancing_enabled: Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.
               
               > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if app_service_environment_id is not None:
            pulumi.set(__self__, "app_service_environment_id", app_service_environment_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_elastic_worker_count is not None:
            pulumi.set(__self__, "maximum_elastic_worker_count", maximum_elastic_worker_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if per_site_scaling_enabled is not None:
            pulumi.set(__self__, "per_site_scaling_enabled", per_site_scaling_enabled)
        if premium_plan_auto_scale_enabled is not None:
            pulumi.set(__self__, "premium_plan_auto_scale_enabled", premium_plan_auto_scale_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)
        if zone_balancing_enabled is not None:
            pulumi.set(__self__, "zone_balancing_enabled", zone_balancing_enabled)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[_builtins.str]:
        """
        The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.

        > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments

        > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="appServiceEnvironmentId")
    def app_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service Environment to create this Service Plan in.

        > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        """
        return pulumi.get(self, "app_service_environment_id")

    @app_service_environment_id.setter
    def app_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumElasticWorkerCount")
    def maximum_elastic_worker_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        """
        return pulumi.get(self, "maximum_elastic_worker_count")

    @maximum_elastic_worker_count.setter
    def maximum_elastic_worker_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_elastic_worker_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="perSiteScalingEnabled")
    def per_site_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Per Site Scaling be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "per_site_scaling_enabled")

    @per_site_scaling_enabled.setter
    def per_site_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "per_site_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="premiumPlanAutoScaleEnabled")
    def premium_plan_auto_scale_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        """
        return pulumi.get(self, "premium_plan_auto_scale_enabled")

    @premium_plan_auto_scale_enabled.setter
    def premium_plan_auto_scale_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "premium_plan_auto_scale_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AppService.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Workers (instances) to be allocated.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_count", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalancingEnabled")
    def zone_balancing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.

        > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        return pulumi.get(self, "zone_balancing_enabled")

    @zone_balancing_enabled.setter
    def zone_balancing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balancing_enabled", value)


@pulumi.input_type
class _ServicePlanState:
    def __init__(__self__, *,
                 app_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_elastic_worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 per_site_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 premium_plan_auto_scale_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_balancing_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServicePlan resources.
        :param pulumi.Input[_builtins.str] app_service_environment_id: The ID of the App Service Environment to create this Service Plan in.
               
               > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        :param pulumi.Input[_builtins.str] kind: A string representing the Kind of Service Plan.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.int] maximum_elastic_worker_count: The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] os_type: The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] per_site_scaling_enabled: Should Per Site Scaling be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] premium_plan_auto_scale_enabled: Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        :param pulumi.Input[_builtins.bool] reserved: Whether this is a reserved Service Plan Type. `true` if `os_type` is `Linux`, otherwise `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.
               
               > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments
               
               > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AppService.
        :param pulumi.Input[_builtins.int] worker_count: The number of Workers (instances) to be allocated.
        :param pulumi.Input[_builtins.bool] zone_balancing_enabled: Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.
               
               > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        if app_service_environment_id is not None:
            pulumi.set(__self__, "app_service_environment_id", app_service_environment_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_elastic_worker_count is not None:
            pulumi.set(__self__, "maximum_elastic_worker_count", maximum_elastic_worker_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if per_site_scaling_enabled is not None:
            pulumi.set(__self__, "per_site_scaling_enabled", per_site_scaling_enabled)
        if premium_plan_auto_scale_enabled is not None:
            pulumi.set(__self__, "premium_plan_auto_scale_enabled", premium_plan_auto_scale_enabled)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)
        if zone_balancing_enabled is not None:
            pulumi.set(__self__, "zone_balancing_enabled", zone_balancing_enabled)

    @_builtins.property
    @pulumi.getter(name="appServiceEnvironmentId")
    def app_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service Environment to create this Service Plan in.

        > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        """
        return pulumi.get(self, "app_service_environment_id")

    @app_service_environment_id.setter
    def app_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string representing the Kind of Service Plan.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumElasticWorkerCount")
    def maximum_elastic_worker_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        """
        return pulumi.get(self, "maximum_elastic_worker_count")

    @maximum_elastic_worker_count.setter
    def maximum_elastic_worker_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_elastic_worker_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="perSiteScalingEnabled")
    def per_site_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Per Site Scaling be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "per_site_scaling_enabled")

    @per_site_scaling_enabled.setter
    def per_site_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "per_site_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="premiumPlanAutoScaleEnabled")
    def premium_plan_auto_scale_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        """
        return pulumi.get(self, "premium_plan_auto_scale_enabled")

    @premium_plan_auto_scale_enabled.setter
    def premium_plan_auto_scale_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "premium_plan_auto_scale_enabled", value)

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is a reserved Service Plan Type. `true` if `os_type` is `Linux`, otherwise `false`.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserved", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.

        > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments

        > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AppService.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Workers (instances) to be allocated.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_count", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalancingEnabled")
    def zone_balancing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.

        > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        return pulumi.get(self, "zone_balancing_enabled")

    @zone_balancing_enabled.setter
    def zone_balancing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balancing_enabled", value)


@pulumi.type_token("azure:appservice/servicePlan:ServicePlan")
class ServicePlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_elastic_worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 per_site_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 premium_plan_auto_scale_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_balancing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an App Service: Service Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="P1v2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        AppServices can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/servicePlan:ServicePlan example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/serverFarms/farm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_environment_id: The ID of the App Service Environment to create this Service Plan in.
               
               > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.int] maximum_elastic_worker_count: The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] os_type: The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] per_site_scaling_enabled: Should Per Site Scaling be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] premium_plan_auto_scale_enabled: Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.
               
               > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments
               
               > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AppService.
        :param pulumi.Input[_builtins.int] worker_count: The number of Workers (instances) to be allocated.
        :param pulumi.Input[_builtins.bool] zone_balancing_enabled: Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.
               
               > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an App Service: Service Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="P1v2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        AppServices can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/servicePlan:ServicePlan example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/serverFarms/farm1
        ```

        :param str resource_name: The name of the resource.
        :param ServicePlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_elastic_worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 per_site_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 premium_plan_auto_scale_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_count: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_balancing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePlanArgs.__new__(ServicePlanArgs)

            __props__.__dict__["app_service_environment_id"] = app_service_environment_id
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_elastic_worker_count"] = maximum_elastic_worker_count
            __props__.__dict__["name"] = name
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["per_site_scaling_enabled"] = per_site_scaling_enabled
            __props__.__dict__["premium_plan_auto_scale_enabled"] = premium_plan_auto_scale_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["worker_count"] = worker_count
            __props__.__dict__["zone_balancing_enabled"] = zone_balancing_enabled
            __props__.__dict__["kind"] = None
            __props__.__dict__["reserved"] = None
        super(ServicePlan, __self__).__init__(
            'azure:appservice/servicePlan:ServicePlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_elastic_worker_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            per_site_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            premium_plan_auto_scale_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            reserved: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            worker_count: Optional[pulumi.Input[_builtins.int]] = None,
            zone_balancing_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ServicePlan':
        """
        Get an existing ServicePlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_environment_id: The ID of the App Service Environment to create this Service Plan in.
               
               > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        :param pulumi.Input[_builtins.str] kind: A string representing the Kind of Service Plan.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.int] maximum_elastic_worker_count: The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] os_type: The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] per_site_scaling_enabled: Should Per Site Scaling be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] premium_plan_auto_scale_enabled: Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        :param pulumi.Input[_builtins.bool] reserved: Whether this is a reserved Service Plan Type. `true` if `os_type` is `Linux`, otherwise `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.
               
               > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments
               
               > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AppService.
        :param pulumi.Input[_builtins.int] worker_count: The number of Workers (instances) to be allocated.
        :param pulumi.Input[_builtins.bool] zone_balancing_enabled: Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.
               
               > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePlanState.__new__(_ServicePlanState)

        __props__.__dict__["app_service_environment_id"] = app_service_environment_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_elastic_worker_count"] = maximum_elastic_worker_count
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["per_site_scaling_enabled"] = per_site_scaling_enabled
        __props__.__dict__["premium_plan_auto_scale_enabled"] = premium_plan_auto_scale_enabled
        __props__.__dict__["reserved"] = reserved
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["worker_count"] = worker_count
        __props__.__dict__["zone_balancing_enabled"] = zone_balancing_enabled
        return ServicePlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appServiceEnvironmentId")
    def app_service_environment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the App Service Environment to create this Service Plan in.

        > **Note:** Requires an Isolated SKU for `appservice.EnvironmentV3`, supported values include `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, and `I6v2`.
        """
        return pulumi.get(self, "app_service_environment_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        A string representing the Kind of Service Plan.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumElasticWorkerCount")
    def maximum_elastic_worker_count(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of workers to use in an Elastic SKU Plan or Premium Plan that have `premium_plan_auto_scale_enabled` set to `true`. Cannot be set unless using an Elastic or Premium SKU.
        """
        return pulumi.get(self, "maximum_elastic_worker_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Service Plan. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        The O/S type for the App Services to be hosted in this plan. Possible values include `Windows`, `Linux`, and `WindowsContainer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="perSiteScalingEnabled")
    def per_site_scaling_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Per Site Scaling be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "per_site_scaling_enabled")

    @_builtins.property
    @pulumi.getter(name="premiumPlanAutoScaleEnabled")
    def premium_plan_auto_scale_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should automatic scaling be enabled for the Premium SKU Plan. Defaults to `false`. Cannot be set unless using a Premium SKU.
        """
        return pulumi.get(self, "premium_plan_auto_scale_enabled")

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this is a reserved Service Plan Type. `true` if `os_type` is `Linux`, otherwise `false`.
        """
        return pulumi.get(self, "reserved")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Service Plan should exist. Changing this forces a new Service Plan to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU for the plan. Possible values include `B1`, `B2`, `B3`, `D1`, `F1`, `I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`, `I4v2`, `I4mv2`, `I5v2`, `I5mv2`, `I6v2`, `P1v2`, `P2v2`, `P3v2`, `P0v3`, `P1v3`, `P2v3`, `P3v3`, `P1mv3`, `P2mv3`, `P3mv3`, `P4mv3`, `P5mv3`, `S1`, `S2`, `S3`, `SHARED`, `EP1`, `EP2`, `EP3`, `FC1`, `WS1`, `WS2`, `WS3`, and `Y1`.

        > **Note:** Isolated SKUs (`I1`, `I2`, `I3`, `I1v2`, `I1mv2`, `I2v2`, `I2mv2`, `I3v2`, `I3mv2`) can only be used with App Service Environments

        > **Note:** Elastic and Consumption SKUs (`Y1`, `FC1`, `EP1`, `EP2`, and `EP3`) are for use with Function Apps.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the AppService.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Workers (instances) to be allocated.
        """
        return pulumi.get(self, "worker_count")

    @_builtins.property
    @pulumi.getter(name="zoneBalancingEnabled")
    def zone_balancing_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Service Plan balance across Availability Zones in the region. Changing this forces a new resource to be created.

        > **Note:** If this setting is set to `true` and the `worker_count` value is specified, it should be set to a multiple of the number of availability zones in the region. Please see the Azure documentation for the number of Availability Zones in your region.
        """
        return pulumi.get(self, "zone_balancing_enabled")

