# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterExtensionArgs', 'ClusterExtension']

@pulumi.input_type
class ClusterExtensionArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 extension_type: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['ClusterExtensionIdentityArgs'],
                 configuration_protected_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 configuration_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 release_train: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterExtension resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] extension_type: Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input['ClusterExtensionIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_protected_settings: Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_settings: Configuration settings, as name-value pairs for configuring this extension.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_namespace: Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_train: The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] target_namespace: Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] version: User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "extension_type", extension_type)
        pulumi.set(__self__, "identity", identity)
        if configuration_protected_settings is not None:
            pulumi.set(__self__, "configuration_protected_settings", configuration_protected_settings)
        if configuration_settings is not None:
            pulumi.set(__self__, "configuration_settings", configuration_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_namespace is not None:
            pulumi.set(__self__, "release_namespace", release_namespace)
        if release_train is not None:
            pulumi.set(__self__, "release_train", release_train)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="extensionType")
    def extension_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "extension_type")

    @extension_type.setter
    def extension_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extension_type", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['ClusterExtensionIdentityArgs']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['ClusterExtensionIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="configurationProtectedSettings")
    def configuration_protected_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_protected_settings")

    @configuration_protected_settings.setter
    def configuration_protected_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration_protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="configurationSettings")
    def configuration_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configuration settings, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_settings")

    @configuration_settings.setter
    def configuration_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_namespace")

    @release_namespace.setter
    def release_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_namespace", value)

    @_builtins.property
    @pulumi.getter(name="releaseTrain")
    def release_train(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_train")

    @release_train.setter
    def release_train(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_train", value)

    @_builtins.property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_namespace", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ClusterExtensionState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_protected_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 configuration_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 current_version: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ClusterExtensionIdentityArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 release_train: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterExtension resources.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_protected_settings: Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_settings: Configuration settings, as name-value pairs for configuring this extension.
        :param pulumi.Input[_builtins.str] current_version: The current version of the extension.
        :param pulumi.Input[_builtins.str] extension_type: Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input['ClusterExtensionIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_namespace: Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_train: The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] target_namespace: Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] version: User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if configuration_protected_settings is not None:
            pulumi.set(__self__, "configuration_protected_settings", configuration_protected_settings)
        if configuration_settings is not None:
            pulumi.set(__self__, "configuration_settings", configuration_settings)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if extension_type is not None:
            pulumi.set(__self__, "extension_type", extension_type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_namespace is not None:
            pulumi.set(__self__, "release_namespace", release_namespace)
        if release_train is not None:
            pulumi.set(__self__, "release_train", release_train)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationProtectedSettings")
    def configuration_protected_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_protected_settings")

    @configuration_protected_settings.setter
    def configuration_protected_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration_protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="configurationSettings")
    def configuration_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configuration settings, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_settings")

    @configuration_settings.setter
    def configuration_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration_settings", value)

    @_builtins.property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current version of the extension.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_version", value)

    @_builtins.property
    @pulumi.getter(name="extensionType")
    def extension_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "extension_type")

    @extension_type.setter
    def extension_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extension_type", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ClusterExtensionIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ClusterExtensionIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_namespace")

    @release_namespace.setter
    def release_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_namespace", value)

    @_builtins.property
    @pulumi.getter(name="releaseTrain")
    def release_train(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_train")

    @release_train.setter
    def release_train(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_train", value)

    @_builtins.property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_namespace", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:arckubernetes/clusterExtension:ClusterExtension")
class ClusterExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_protected_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 configuration_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extension_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterExtensionIdentityArgs', 'ClusterExtensionIdentityArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 release_train: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Arc Kubernetes Cluster Extension.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.arckubernetes.Cluster("example",
            name="example-akcc",
            resource_group_name=example.name,
            location="West Europe",
            agent_public_key_certificate=std.filebase64(input="testdata/public.cer").result,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "ENV": "Test",
            })
        example_cluster_extension = azure.arckubernetes.ClusterExtension("example",
            name="example-ext",
            cluster_id=example_cluster.id,
            extension_type="microsoft.flux")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.KubernetesConfiguration`: 2022-11-01

        ## Import

        Arc Kubernetes Cluster Extension can be imported using the `resource id` for different `cluster_resource_name`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/clusterExtension:ClusterExtension example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Kubernetes/connectedClusters/cluster1/providers/Microsoft.KubernetesConfiguration/extensions/extension1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_protected_settings: Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_settings: Configuration settings, as name-value pairs for configuring this extension.
        :param pulumi.Input[_builtins.str] extension_type: Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Union['ClusterExtensionIdentityArgs', 'ClusterExtensionIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_namespace: Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_train: The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] target_namespace: Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] version: User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Arc Kubernetes Cluster Extension.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.arckubernetes.Cluster("example",
            name="example-akcc",
            resource_group_name=example.name,
            location="West Europe",
            agent_public_key_certificate=std.filebase64(input="testdata/public.cer").result,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "ENV": "Test",
            })
        example_cluster_extension = azure.arckubernetes.ClusterExtension("example",
            name="example-ext",
            cluster_id=example_cluster.id,
            extension_type="microsoft.flux")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.KubernetesConfiguration`: 2022-11-01

        ## Import

        Arc Kubernetes Cluster Extension can be imported using the `resource id` for different `cluster_resource_name`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/clusterExtension:ClusterExtension example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Kubernetes/connectedClusters/cluster1/providers/Microsoft.KubernetesConfiguration/extensions/extension1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_protected_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 configuration_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extension_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterExtensionIdentityArgs', 'ClusterExtensionIdentityArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 release_train: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterExtensionArgs.__new__(ClusterExtensionArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["configuration_protected_settings"] = configuration_protected_settings
            __props__.__dict__["configuration_settings"] = configuration_settings
            if extension_type is None and not opts.urn:
                raise TypeError("Missing required property 'extension_type'")
            __props__.__dict__["extension_type"] = extension_type
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["name"] = name
            __props__.__dict__["release_namespace"] = release_namespace
            __props__.__dict__["release_train"] = release_train
            __props__.__dict__["target_namespace"] = target_namespace
            __props__.__dict__["version"] = version
            __props__.__dict__["current_version"] = None
        super(ClusterExtension, __self__).__init__(
            'azure:arckubernetes/clusterExtension:ClusterExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_protected_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            configuration_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            current_version: Optional[pulumi.Input[_builtins.str]] = None,
            extension_type: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ClusterExtensionIdentityArgs', 'ClusterExtensionIdentityArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            release_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            release_train: Optional[pulumi.Input[_builtins.str]] = None,
            target_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterExtension':
        """
        Get an existing ClusterExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_protected_settings: Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration_settings: Configuration settings, as name-value pairs for configuring this extension.
        :param pulumi.Input[_builtins.str] current_version: The current version of the extension.
        :param pulumi.Input[_builtins.str] extension_type: Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[Union['ClusterExtensionIdentityArgs', 'ClusterExtensionIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_namespace: Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] release_train: The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] target_namespace: Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        :param pulumi.Input[_builtins.str] version: User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterExtensionState.__new__(_ClusterExtensionState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["configuration_protected_settings"] = configuration_protected_settings
        __props__.__dict__["configuration_settings"] = configuration_settings
        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["extension_type"] = extension_type
        __props__.__dict__["identity"] = identity
        __props__.__dict__["name"] = name
        __props__.__dict__["release_namespace"] = release_namespace
        __props__.__dict__["release_train"] = release_train
        __props__.__dict__["target_namespace"] = target_namespace
        __props__.__dict__["version"] = version
        return ClusterExtension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Cluster ID. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="configurationProtectedSettings")
    def configuration_protected_settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Configuration settings that are sensitive, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_protected_settings")

    @_builtins.property
    @pulumi.getter(name="configurationSettings")
    def configuration_settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Configuration settings, as name-value pairs for configuring this extension.
        """
        return pulumi.get(self, "configuration_settings")

    @_builtins.property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[_builtins.str]:
        """
        The current version of the extension.
        """
        return pulumi.get(self, "current_version")

    @_builtins.property
    @pulumi.getter(name="extensionType")
    def extension_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of extension. It must be one of the extension types registered with Microsoft.KubernetesConfiguration by the Extension publisher. For more information, please refer to [Available Extensions for Arc-enabled Kubernetes clusters](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/extensions-release). Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "extension_type")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ClusterExtensionIdentity']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster Extension. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace where the extension release must be placed for a cluster scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_namespace")

    @_builtins.property
    @pulumi.getter(name="releaseTrain")
    def release_train(self) -> pulumi.Output[_builtins.str]:
        """
        The release train used by this extension. Possible values include but are not limited to `Stable`, `Preview`. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "release_train")

    @_builtins.property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace where the extension will be created for a namespace scoped extension. If this namespace does not exist, it will be created. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "target_namespace")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-specified version that the extension should pin to. If it is not set, Azure will use the latest version and auto upgrade it. Changing this forces a new Arc Kubernetes Cluster Extension to be created.
        """
        return pulumi.get(self, "version")

