# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_node_count: pulumi.Input[_builtins.int],
                 sku_name: pulumi.Input[_builtins.str],
                 vmware_cloud_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.int] cluster_node_count: The count of the Azure VMware Solution Cluster nodes.
        :param pulumi.Input[_builtins.str] sku_name: The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] vmware_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        pulumi.set(__self__, "cluster_node_count", cluster_node_count)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "vmware_cloud_id", vmware_cloud_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clusterNodeCount")
    def cluster_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        The count of the Azure VMware Solution Cluster nodes.
        """
        return pulumi.get(self, "cluster_node_count")

    @cluster_node_count.setter
    def cluster_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cluster_node_count", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="vmwareCloudId")
    def vmware_cloud_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "vmware_cloud_id")

    @vmware_cloud_id.setter
    def vmware_cloud_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vmware_cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 cluster_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_number: Optional[pulumi.Input[_builtins.int]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cloud_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.int] cluster_node_count: The count of the Azure VMware Solution Cluster nodes.
        :param pulumi.Input[_builtins.int] cluster_number: A number that identifies this Cluster in its Azure VMware Solution Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: A list of hosts in the Azure VMware Solution Cluster.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] vmware_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        if cluster_node_count is not None:
            pulumi.set(__self__, "cluster_node_count", cluster_node_count)
        if cluster_number is not None:
            pulumi.set(__self__, "cluster_number", cluster_number)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if vmware_cloud_id is not None:
            pulumi.set(__self__, "vmware_cloud_id", vmware_cloud_id)

    @_builtins.property
    @pulumi.getter(name="clusterNodeCount")
    def cluster_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of the Azure VMware Solution Cluster nodes.
        """
        return pulumi.get(self, "cluster_node_count")

    @cluster_node_count.setter
    def cluster_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_node_count", value)

    @_builtins.property
    @pulumi.getter(name="clusterNumber")
    def cluster_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A number that identifies this Cluster in its Azure VMware Solution Private Cloud.
        """
        return pulumi.get(self, "cluster_number")

    @cluster_number.setter
    def cluster_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_number", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of hosts in the Azure VMware Solution Cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="vmwareCloudId")
    def vmware_cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "vmware_cloud_id")

    @vmware_cloud_id.setter
    def vmware_cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmware_cloud_id", value)


@pulumi.type_token("azure:avs/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure VMware Solution Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        example_cluster = azure.avs.Cluster("example",
            name="example-Cluster",
            vmware_cloud_id=example_private_cloud.id,
            cluster_node_count=3,
            sku_name="av36")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AVS/privateClouds/privateCloud1/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cluster_node_count: The count of the Azure VMware Solution Cluster nodes.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] vmware_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure VMware Solution Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        example_cluster = azure.avs.Cluster("example",
            name="example-Cluster",
            vmware_cloud_id=example_private_cloud.id,
            cluster_node_count=3,
            sku_name="av36")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AVS/privateClouds/privateCloud1/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if cluster_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_node_count'")
            __props__.__dict__["cluster_node_count"] = cluster_node_count
            __props__.__dict__["name"] = name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if vmware_cloud_id is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_cloud_id'")
            __props__.__dict__["vmware_cloud_id"] = vmware_cloud_id
            __props__.__dict__["cluster_number"] = None
            __props__.__dict__["hosts"] = None
        super(Cluster, __self__).__init__(
            'azure:avs/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_number: Optional[pulumi.Input[_builtins.int]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            vmware_cloud_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cluster_node_count: The count of the Azure VMware Solution Cluster nodes.
        :param pulumi.Input[_builtins.int] cluster_number: A number that identifies this Cluster in its Azure VMware Solution Private Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: A list of hosts in the Azure VMware Solution Cluster.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        :param pulumi.Input[_builtins.str] vmware_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["cluster_node_count"] = cluster_node_count
        __props__.__dict__["cluster_number"] = cluster_number
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["name"] = name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["vmware_cloud_id"] = vmware_cloud_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterNodeCount")
    def cluster_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The count of the Azure VMware Solution Cluster nodes.
        """
        return pulumi.get(self, "cluster_node_count")

    @_builtins.property
    @pulumi.getter(name="clusterNumber")
    def cluster_number(self) -> pulumi.Output[_builtins.int]:
        """
        A number that identifies this Cluster in its Azure VMware Solution Private Cloud.
        """
        return pulumi.get(self, "cluster_number")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of hosts in the Azure VMware Solution Cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure VMware Solution Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Cluster SKU to use. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av48`, `av48t`, `av36pt`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="vmwareCloudId")
    def vmware_cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Cluster. Changing this forces a new Azure VMware Solution Cluster to be created.
        """
        return pulumi.get(self, "vmware_cloud_id")

