# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExpressRouteAuthorizationArgs', 'ExpressRouteAuthorization']

@pulumi.input_type
class ExpressRouteAuthorizationArgs:
    def __init__(__self__, *,
                 private_cloud_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExpressRouteAuthorization resource.
        :param pulumi.Input[_builtins.str] private_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        pulumi.set(__self__, "private_cloud_id", private_cloud_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="privateCloudId")
    def private_cloud_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "private_cloud_id")

    @private_cloud_id.setter
    def private_cloud_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExpressRouteAuthorizationState:
    def __init__(__self__, *,
                 express_route_authorization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_cloud_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExpressRouteAuthorization resources.
        :param pulumi.Input[_builtins.str] express_route_authorization_id: The ID of the Azure VMware Solution ExpressRoute Circuit Authorization.
        :param pulumi.Input[_builtins.str] express_route_authorization_key: The key of the Azure VMware Solution ExpressRoute Circuit Authorization.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        :param pulumi.Input[_builtins.str] private_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        if express_route_authorization_id is not None:
            pulumi.set(__self__, "express_route_authorization_id", express_route_authorization_id)
        if express_route_authorization_key is not None:
            pulumi.set(__self__, "express_route_authorization_key", express_route_authorization_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_cloud_id is not None:
            pulumi.set(__self__, "private_cloud_id", private_cloud_id)

    @_builtins.property
    @pulumi.getter(name="expressRouteAuthorizationId")
    def express_route_authorization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure VMware Solution ExpressRoute Circuit Authorization.
        """
        return pulumi.get(self, "express_route_authorization_id")

    @express_route_authorization_id.setter
    def express_route_authorization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_authorization_id", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteAuthorizationKey")
    def express_route_authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the Azure VMware Solution ExpressRoute Circuit Authorization.
        """
        return pulumi.get(self, "express_route_authorization_key")

    @express_route_authorization_key.setter
    def express_route_authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_authorization_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateCloudId")
    def private_cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "private_cloud_id")

    @private_cloud_id.setter
    def private_cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_cloud_id", value)


@pulumi.type_token("azure:avs/expressRouteAuthorization:ExpressRouteAuthorization")
class ExpressRouteAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure VMware Solution ExpressRoute Circuit Authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        example_express_route_authorization = azure.avs.ExpressRouteAuthorization("example",
            name="example-authorization",
            private_cloud_id=example_private_cloud.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution ExpressRoute Circuit Authorizations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/expressRouteAuthorization:ExpressRouteAuthorization example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AVS/privateClouds/privateCloud1/authorizations/authorization1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        :param pulumi.Input[_builtins.str] private_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRouteAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure VMware Solution ExpressRoute Circuit Authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        example_express_route_authorization = azure.avs.ExpressRouteAuthorization("example",
            name="example-authorization",
            private_cloud_id=example_private_cloud.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution ExpressRoute Circuit Authorizations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/expressRouteAuthorization:ExpressRouteAuthorization example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AVS/privateClouds/privateCloud1/authorizations/authorization1
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRouteAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRouteAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRouteAuthorizationArgs.__new__(ExpressRouteAuthorizationArgs)

            __props__.__dict__["name"] = name
            if private_cloud_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_cloud_id'")
            __props__.__dict__["private_cloud_id"] = private_cloud_id
            __props__.__dict__["express_route_authorization_id"] = None
            __props__.__dict__["express_route_authorization_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["expressRouteAuthorizationKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExpressRouteAuthorization, __self__).__init__(
            'azure:avs/expressRouteAuthorization:ExpressRouteAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            express_route_authorization_id: Optional[pulumi.Input[_builtins.str]] = None,
            express_route_authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_cloud_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExpressRouteAuthorization':
        """
        Get an existing ExpressRouteAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] express_route_authorization_id: The ID of the Azure VMware Solution ExpressRoute Circuit Authorization.
        :param pulumi.Input[_builtins.str] express_route_authorization_key: The key of the Azure VMware Solution ExpressRoute Circuit Authorization.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        :param pulumi.Input[_builtins.str] private_cloud_id: The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRouteAuthorizationState.__new__(_ExpressRouteAuthorizationState)

        __props__.__dict__["express_route_authorization_id"] = express_route_authorization_id
        __props__.__dict__["express_route_authorization_key"] = express_route_authorization_key
        __props__.__dict__["name"] = name
        __props__.__dict__["private_cloud_id"] = private_cloud_id
        return ExpressRouteAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="expressRouteAuthorizationId")
    def express_route_authorization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure VMware Solution ExpressRoute Circuit Authorization.
        """
        return pulumi.get(self, "express_route_authorization_id")

    @_builtins.property
    @pulumi.getter(name="expressRouteAuthorizationKey")
    def express_route_authorization_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the Azure VMware Solution ExpressRoute Circuit Authorization.
        """
        return pulumi.get(self, "express_route_authorization_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateCloudId")
    def private_cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure VMware Solution Private Cloud in which to create this Azure VMware Solution ExpressRoute Circuit Authorization. Changing this forces a new Azure VMware Solution ExpressRoute Circuit Authorization to be created.
        """
        return pulumi.get(self, "private_cloud_id")

