# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEnrollmentAccountScopeResult',
    'AwaitableGetEnrollmentAccountScopeResult',
    'get_enrollment_account_scope',
    'get_enrollment_account_scope_output',
]

@pulumi.output_type
class GetEnrollmentAccountScopeResult:
    """
    A collection of values returned by getEnrollmentAccountScope.
    """
    def __init__(__self__, billing_account_name=None, enrollment_account_name=None, id=None):
        if billing_account_name and not isinstance(billing_account_name, str):
            raise TypeError("Expected argument 'billing_account_name' to be a str")
        pulumi.set(__self__, "billing_account_name", billing_account_name)
        if enrollment_account_name and not isinstance(enrollment_account_name, str):
            raise TypeError("Expected argument 'enrollment_account_name' to be a str")
        pulumi.set(__self__, "enrollment_account_name", enrollment_account_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="billingAccountName")
    def billing_account_name(self) -> _builtins.str:
        return pulumi.get(self, "billing_account_name")

    @_builtins.property
    @pulumi.getter(name="enrollmentAccountName")
    def enrollment_account_name(self) -> _builtins.str:
        return pulumi.get(self, "enrollment_account_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetEnrollmentAccountScopeResult(GetEnrollmentAccountScopeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnrollmentAccountScopeResult(
            billing_account_name=self.billing_account_name,
            enrollment_account_name=self.enrollment_account_name,
            id=self.id)


def get_enrollment_account_scope(billing_account_name: Optional[_builtins.str] = None,
                                 enrollment_account_name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnrollmentAccountScopeResult:
    """
    Use this data source to access information about an existing Enrollment Account Billing Scope.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.billing.get_enrollment_account_scope(billing_account_name="existing",
        enrollment_account_name="existing")
    pulumi.export("id", example.id)
    ```


    :param _builtins.str billing_account_name: The Billing Account Name of the Enterprise Account.
    :param _builtins.str enrollment_account_name: The Enrollment Account Name in the above Enterprise Account.
    """
    __args__ = dict()
    __args__['billingAccountName'] = billing_account_name
    __args__['enrollmentAccountName'] = enrollment_account_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:billing/getEnrollmentAccountScope:getEnrollmentAccountScope', __args__, opts=opts, typ=GetEnrollmentAccountScopeResult).value

    return AwaitableGetEnrollmentAccountScopeResult(
        billing_account_name=pulumi.get(__ret__, 'billing_account_name'),
        enrollment_account_name=pulumi.get(__ret__, 'enrollment_account_name'),
        id=pulumi.get(__ret__, 'id'))
def get_enrollment_account_scope_output(billing_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                                        enrollment_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnrollmentAccountScopeResult]:
    """
    Use this data source to access information about an existing Enrollment Account Billing Scope.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.billing.get_enrollment_account_scope(billing_account_name="existing",
        enrollment_account_name="existing")
    pulumi.export("id", example.id)
    ```


    :param _builtins.str billing_account_name: The Billing Account Name of the Enterprise Account.
    :param _builtins.str enrollment_account_name: The Enrollment Account Name in the above Enterprise Account.
    """
    __args__ = dict()
    __args__['billingAccountName'] = billing_account_name
    __args__['enrollmentAccountName'] = enrollment_account_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:billing/getEnrollmentAccountScope:getEnrollmentAccountScope', __args__, opts=opts, typ=GetEnrollmentAccountScopeResult)
    return __ret__.apply(lambda __response__: GetEnrollmentAccountScopeResult(
        billing_account_name=pulumi.get(__response__, 'billing_account_name'),
        enrollment_account_name=pulumi.get(__response__, 'enrollment_account_name'),
        id=pulumi.get(__response__, 'id')))
