# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorRouteArgs', 'FrontdoorRoute']

@pulumi.input_type
class FrontdoorRouteArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_endpoint_id: pulumi.Input[_builtins.str],
                 cdn_frontdoor_origin_group_id: pulumi.Input[_builtins.str],
                 cdn_frontdoor_origin_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 patterns_to_matches: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 supported_protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cache: Optional[pulumi.Input['FrontdoorRouteCacheArgs']] = None,
                 cdn_frontdoor_custom_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_origin_path: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 https_redirect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_to_default_domain: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FrontdoorRoute resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_endpoint_id: The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_origin_ids: One or more Front Door Origin resource IDs that this Front Door Route will link to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] patterns_to_matches: The route patterns of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_protocols: One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.
               
               > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        :param pulumi.Input['FrontdoorRouteCacheArgs'] cache: A `cache` block as defined below.
               
               > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_custom_domain_ids: The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_path: A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_rule_set_ids: A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        :param pulumi.Input[_builtins.bool] enabled: Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] forwarding_protocol: The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        :param pulumi.Input[_builtins.bool] https_redirect_enabled: Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.
               
               > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        :param pulumi.Input[_builtins.bool] link_to_default_domain: Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        """
        pulumi.set(__self__, "cdn_frontdoor_endpoint_id", cdn_frontdoor_endpoint_id)
        pulumi.set(__self__, "cdn_frontdoor_origin_group_id", cdn_frontdoor_origin_group_id)
        pulumi.set(__self__, "cdn_frontdoor_origin_ids", cdn_frontdoor_origin_ids)
        pulumi.set(__self__, "patterns_to_matches", patterns_to_matches)
        pulumi.set(__self__, "supported_protocols", supported_protocols)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if cdn_frontdoor_custom_domain_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_custom_domain_ids", cdn_frontdoor_custom_domain_ids)
        if cdn_frontdoor_origin_path is not None:
            pulumi.set(__self__, "cdn_frontdoor_origin_path", cdn_frontdoor_origin_path)
        if cdn_frontdoor_rule_set_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_rule_set_ids", cdn_frontdoor_rule_set_ids)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)
        if https_redirect_enabled is not None:
            pulumi.set(__self__, "https_redirect_enabled", https_redirect_enabled)
        if link_to_default_domain is not None:
            pulumi.set(__self__, "link_to_default_domain", link_to_default_domain)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorEndpointId")
    def cdn_frontdoor_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_endpoint_id")

    @cdn_frontdoor_endpoint_id.setter
    def cdn_frontdoor_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @cdn_frontdoor_origin_group_id.setter
    def cdn_frontdoor_origin_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginIds")
    def cdn_frontdoor_origin_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        One or more Front Door Origin resource IDs that this Front Door Route will link to.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_ids")

    @cdn_frontdoor_origin_ids.setter
    def cdn_frontdoor_origin_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "cdn_frontdoor_origin_ids", value)

    @_builtins.property
    @pulumi.getter(name="patternsToMatches")
    def patterns_to_matches(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_matches")

    @patterns_to_matches.setter
    def patterns_to_matches(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "patterns_to_matches", value)

    @_builtins.property
    @pulumi.getter(name="supportedProtocols")
    def supported_protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.

        > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        return pulumi.get(self, "supported_protocols")

    @supported_protocols.setter
    def supported_protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "supported_protocols", value)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['FrontdoorRouteCacheArgs']]:
        """
        A `cache` block as defined below.

        > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['FrontdoorRouteCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorCustomDomainIds")
    def cdn_frontdoor_custom_domain_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_ids")

    @cdn_frontdoor_custom_domain_ids.setter
    def cdn_frontdoor_custom_domain_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_custom_domain_ids", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginPath")
    def cdn_frontdoor_origin_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        """
        return pulumi.get(self, "cdn_frontdoor_origin_path")

    @cdn_frontdoor_origin_path.setter
    def cdn_frontdoor_origin_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_origin_path", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetIds")
    def cdn_frontdoor_rule_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_ids")

    @cdn_frontdoor_rule_set_ids.setter
    def cdn_frontdoor_rule_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_rule_set_ids", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        """
        return pulumi.get(self, "forwarding_protocol")

    @forwarding_protocol.setter
    def forwarding_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forwarding_protocol", value)

    @_builtins.property
    @pulumi.getter(name="httpsRedirectEnabled")
    def https_redirect_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.

        > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        """
        return pulumi.get(self, "https_redirect_enabled")

    @https_redirect_enabled.setter
    def https_redirect_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_redirect_enabled", value)

    @_builtins.property
    @pulumi.getter(name="linkToDefaultDomain")
    def link_to_default_domain(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "link_to_default_domain")

    @link_to_default_domain.setter
    def link_to_default_domain(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "link_to_default_domain", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FrontdoorRouteState:
    def __init__(__self__, *,
                 cache: Optional[pulumi.Input['FrontdoorRouteCacheArgs']] = None,
                 cdn_frontdoor_custom_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_origin_path: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 https_redirect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_to_default_domain: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patterns_to_matches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 supported_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FrontdoorRoute resources.
        :param pulumi.Input['FrontdoorRouteCacheArgs'] cache: A `cache` block as defined below.
               
               > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_custom_domain_ids: The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_endpoint_id: The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_origin_ids: One or more Front Door Origin resource IDs that this Front Door Route will link to.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_path: A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_rule_set_ids: A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        :param pulumi.Input[_builtins.bool] enabled: Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] forwarding_protocol: The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        :param pulumi.Input[_builtins.bool] https_redirect_enabled: Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.
               
               > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        :param pulumi.Input[_builtins.bool] link_to_default_domain: Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] patterns_to_matches: The route patterns of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_protocols: One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.
               
               > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if cdn_frontdoor_custom_domain_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_custom_domain_ids", cdn_frontdoor_custom_domain_ids)
        if cdn_frontdoor_endpoint_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_endpoint_id", cdn_frontdoor_endpoint_id)
        if cdn_frontdoor_origin_group_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_origin_group_id", cdn_frontdoor_origin_group_id)
        if cdn_frontdoor_origin_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_origin_ids", cdn_frontdoor_origin_ids)
        if cdn_frontdoor_origin_path is not None:
            pulumi.set(__self__, "cdn_frontdoor_origin_path", cdn_frontdoor_origin_path)
        if cdn_frontdoor_rule_set_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_rule_set_ids", cdn_frontdoor_rule_set_ids)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)
        if https_redirect_enabled is not None:
            pulumi.set(__self__, "https_redirect_enabled", https_redirect_enabled)
        if link_to_default_domain is not None:
            pulumi.set(__self__, "link_to_default_domain", link_to_default_domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_matches is not None:
            pulumi.set(__self__, "patterns_to_matches", patterns_to_matches)
        if supported_protocols is not None:
            pulumi.set(__self__, "supported_protocols", supported_protocols)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['FrontdoorRouteCacheArgs']]:
        """
        A `cache` block as defined below.

        > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['FrontdoorRouteCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorCustomDomainIds")
    def cdn_frontdoor_custom_domain_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_ids")

    @cdn_frontdoor_custom_domain_ids.setter
    def cdn_frontdoor_custom_domain_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_custom_domain_ids", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorEndpointId")
    def cdn_frontdoor_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_endpoint_id")

    @cdn_frontdoor_endpoint_id.setter
    def cdn_frontdoor_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @cdn_frontdoor_origin_group_id.setter
    def cdn_frontdoor_origin_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginIds")
    def cdn_frontdoor_origin_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more Front Door Origin resource IDs that this Front Door Route will link to.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_ids")

    @cdn_frontdoor_origin_ids.setter
    def cdn_frontdoor_origin_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_origin_ids", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginPath")
    def cdn_frontdoor_origin_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        """
        return pulumi.get(self, "cdn_frontdoor_origin_path")

    @cdn_frontdoor_origin_path.setter
    def cdn_frontdoor_origin_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_origin_path", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetIds")
    def cdn_frontdoor_rule_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_ids")

    @cdn_frontdoor_rule_set_ids.setter
    def cdn_frontdoor_rule_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_rule_set_ids", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        """
        return pulumi.get(self, "forwarding_protocol")

    @forwarding_protocol.setter
    def forwarding_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forwarding_protocol", value)

    @_builtins.property
    @pulumi.getter(name="httpsRedirectEnabled")
    def https_redirect_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.

        > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        """
        return pulumi.get(self, "https_redirect_enabled")

    @https_redirect_enabled.setter
    def https_redirect_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_redirect_enabled", value)

    @_builtins.property
    @pulumi.getter(name="linkToDefaultDomain")
    def link_to_default_domain(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "link_to_default_domain")

    @link_to_default_domain.setter
    def link_to_default_domain(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "link_to_default_domain", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="patternsToMatches")
    def patterns_to_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_matches")

    @patterns_to_matches.setter
    def patterns_to_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "patterns_to_matches", value)

    @_builtins.property
    @pulumi.getter(name="supportedProtocols")
    def supported_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.

        > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        return pulumi.get(self, "supported_protocols")

    @supported_protocols.setter
    def supported_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "supported_protocols", value)


@pulumi.type_token("azure:cdn/frontdoorRoute:FrontdoorRoute")
class FrontdoorRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Union['FrontdoorRouteCacheArgs', 'FrontdoorRouteCacheArgsDict']]] = None,
                 cdn_frontdoor_custom_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_origin_path: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 https_redirect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_to_default_domain: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patterns_to_matches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 supported_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Route.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="example.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-originGroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="ExampleRuleSet",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        contoso = azure.cdn.FrontdoorCustomDomain("contoso",
            name="contoso-custom-domain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "contoso",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        fabrikam = azure.cdn.FrontdoorCustomDomain("fabrikam",
            name="fabrikam-custom-domain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "fabrikam",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        example_frontdoor_route = azure.cdn.FrontdoorRoute("example",
            name="example-route",
            cdn_frontdoor_endpoint_id=example_frontdoor_endpoint.id,
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            cdn_frontdoor_origin_ids=[example_frontdoor_origin.id],
            cdn_frontdoor_rule_set_ids=[example_frontdoor_rule_set.id],
            enabled=True,
            forwarding_protocol="HttpsOnly",
            https_redirect_enabled=True,
            patterns_to_matches=["/*"],
            supported_protocols=[
                "Http",
                "Https",
            ],
            cdn_frontdoor_custom_domain_ids=[
                contoso.id,
                fabrikam.id,
            ],
            link_to_default_domain=False,
            cache={
                "query_string_caching_behavior": "IgnoreSpecifiedQueryStrings",
                "query_strings": [
                    "account",
                    "settings",
                ],
                "compression_enabled": True,
                "content_types_to_compresses": [
                    "text/html",
                    "text/javascript",
                    "text/xml",
                ],
            })
        contoso_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("contoso",
            cdn_frontdoor_custom_domain_id=contoso.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        fabrikam_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("fabrikam",
            cdn_frontdoor_custom_domain_id=fabrikam.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        ```

        ## Import

        Front Door Routes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorRoute:FrontdoorRoute example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/afdEndpoints/endpoint1/routes/route1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FrontdoorRouteCacheArgs', 'FrontdoorRouteCacheArgsDict']] cache: A `cache` block as defined below.
               
               > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_custom_domain_ids: The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_endpoint_id: The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_origin_ids: One or more Front Door Origin resource IDs that this Front Door Route will link to.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_path: A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_rule_set_ids: A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        :param pulumi.Input[_builtins.bool] enabled: Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] forwarding_protocol: The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        :param pulumi.Input[_builtins.bool] https_redirect_enabled: Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.
               
               > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        :param pulumi.Input[_builtins.bool] link_to_default_domain: Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] patterns_to_matches: The route patterns of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_protocols: One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.
               
               > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Route.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="example.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-originGroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="ExampleRuleSet",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        contoso = azure.cdn.FrontdoorCustomDomain("contoso",
            name="contoso-custom-domain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "contoso",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        fabrikam = azure.cdn.FrontdoorCustomDomain("fabrikam",
            name="fabrikam-custom-domain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "fabrikam",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        example_frontdoor_route = azure.cdn.FrontdoorRoute("example",
            name="example-route",
            cdn_frontdoor_endpoint_id=example_frontdoor_endpoint.id,
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            cdn_frontdoor_origin_ids=[example_frontdoor_origin.id],
            cdn_frontdoor_rule_set_ids=[example_frontdoor_rule_set.id],
            enabled=True,
            forwarding_protocol="HttpsOnly",
            https_redirect_enabled=True,
            patterns_to_matches=["/*"],
            supported_protocols=[
                "Http",
                "Https",
            ],
            cdn_frontdoor_custom_domain_ids=[
                contoso.id,
                fabrikam.id,
            ],
            link_to_default_domain=False,
            cache={
                "query_string_caching_behavior": "IgnoreSpecifiedQueryStrings",
                "query_strings": [
                    "account",
                    "settings",
                ],
                "compression_enabled": True,
                "content_types_to_compresses": [
                    "text/html",
                    "text/javascript",
                    "text/xml",
                ],
            })
        contoso_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("contoso",
            cdn_frontdoor_custom_domain_id=contoso.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        fabrikam_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("fabrikam",
            cdn_frontdoor_custom_domain_id=fabrikam.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        ```

        ## Import

        Front Door Routes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorRoute:FrontdoorRoute example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/afdEndpoints/endpoint1/routes/route1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Union['FrontdoorRouteCacheArgs', 'FrontdoorRouteCacheArgsDict']]] = None,
                 cdn_frontdoor_custom_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_origin_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cdn_frontdoor_origin_path: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 https_redirect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_to_default_domain: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 patterns_to_matches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 supported_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorRouteArgs.__new__(FrontdoorRouteArgs)

            __props__.__dict__["cache"] = cache
            __props__.__dict__["cdn_frontdoor_custom_domain_ids"] = cdn_frontdoor_custom_domain_ids
            if cdn_frontdoor_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_endpoint_id'")
            __props__.__dict__["cdn_frontdoor_endpoint_id"] = cdn_frontdoor_endpoint_id
            if cdn_frontdoor_origin_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_origin_group_id'")
            __props__.__dict__["cdn_frontdoor_origin_group_id"] = cdn_frontdoor_origin_group_id
            if cdn_frontdoor_origin_ids is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_origin_ids'")
            __props__.__dict__["cdn_frontdoor_origin_ids"] = cdn_frontdoor_origin_ids
            __props__.__dict__["cdn_frontdoor_origin_path"] = cdn_frontdoor_origin_path
            __props__.__dict__["cdn_frontdoor_rule_set_ids"] = cdn_frontdoor_rule_set_ids
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["forwarding_protocol"] = forwarding_protocol
            __props__.__dict__["https_redirect_enabled"] = https_redirect_enabled
            __props__.__dict__["link_to_default_domain"] = link_to_default_domain
            __props__.__dict__["name"] = name
            if patterns_to_matches is None and not opts.urn:
                raise TypeError("Missing required property 'patterns_to_matches'")
            __props__.__dict__["patterns_to_matches"] = patterns_to_matches
            if supported_protocols is None and not opts.urn:
                raise TypeError("Missing required property 'supported_protocols'")
            __props__.__dict__["supported_protocols"] = supported_protocols
        super(FrontdoorRoute, __self__).__init__(
            'azure:cdn/frontdoorRoute:FrontdoorRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache: Optional[pulumi.Input[Union['FrontdoorRouteCacheArgs', 'FrontdoorRouteCacheArgsDict']]] = None,
            cdn_frontdoor_custom_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cdn_frontdoor_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_origin_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cdn_frontdoor_origin_path: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            forwarding_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            https_redirect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            link_to_default_domain: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            patterns_to_matches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            supported_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'FrontdoorRoute':
        """
        Get an existing FrontdoorRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FrontdoorRouteCacheArgs', 'FrontdoorRouteCacheArgsDict']] cache: A `cache` block as defined below.
               
               > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_custom_domain_ids: The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_endpoint_id: The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_origin_ids: One or more Front Door Origin resource IDs that this Front Door Route will link to.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_path: A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cdn_frontdoor_rule_set_ids: A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        :param pulumi.Input[_builtins.bool] enabled: Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] forwarding_protocol: The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        :param pulumi.Input[_builtins.bool] https_redirect_enabled: Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.
               
               > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        :param pulumi.Input[_builtins.bool] link_to_default_domain: Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] patterns_to_matches: The route patterns of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_protocols: One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.
               
               > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorRouteState.__new__(_FrontdoorRouteState)

        __props__.__dict__["cache"] = cache
        __props__.__dict__["cdn_frontdoor_custom_domain_ids"] = cdn_frontdoor_custom_domain_ids
        __props__.__dict__["cdn_frontdoor_endpoint_id"] = cdn_frontdoor_endpoint_id
        __props__.__dict__["cdn_frontdoor_origin_group_id"] = cdn_frontdoor_origin_group_id
        __props__.__dict__["cdn_frontdoor_origin_ids"] = cdn_frontdoor_origin_ids
        __props__.__dict__["cdn_frontdoor_origin_path"] = cdn_frontdoor_origin_path
        __props__.__dict__["cdn_frontdoor_rule_set_ids"] = cdn_frontdoor_rule_set_ids
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["forwarding_protocol"] = forwarding_protocol
        __props__.__dict__["https_redirect_enabled"] = https_redirect_enabled
        __props__.__dict__["link_to_default_domain"] = link_to_default_domain
        __props__.__dict__["name"] = name
        __props__.__dict__["patterns_to_matches"] = patterns_to_matches
        __props__.__dict__["supported_protocols"] = supported_protocols
        return FrontdoorRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> pulumi.Output[Optional['outputs.FrontdoorRouteCache']]:
        """
        A `cache` block as defined below.

        > **Note:** To disable caching, do not provide the `cache` block in the configuration file.
        """
        return pulumi.get(self, "cache")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorCustomDomainIds")
    def cdn_frontdoor_custom_domain_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of the Front Door Custom Domains which are associated with this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_ids")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorEndpointId")
    def cdn_frontdoor_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Front Door Endpoint where this Front Door Route should exist. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Front Door Origin Group where this Front Door Route should be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginIds")
    def cdn_frontdoor_origin_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more Front Door Origin resource IDs that this Front Door Route will link to.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_ids")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginPath")
    def cdn_frontdoor_origin_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A directory path on the Front Door Origin that can be used to retrieve content (e.g. `contoso.cloudapp.net/originpath`).
        """
        return pulumi.get(self, "cdn_frontdoor_origin_path")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetIds")
    def cdn_frontdoor_rule_set_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the Front Door Rule Set IDs which should be assigned to this Front Door Route.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_ids")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is this Front Door Route enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Protocol that will be use when forwarding traffic to backends. Possible values are `HttpOnly`, `HttpsOnly` or `MatchRequest`. Defaults to `MatchRequest`.
        """
        return pulumi.get(self, "forwarding_protocol")

    @_builtins.property
    @pulumi.getter(name="httpsRedirectEnabled")
    def https_redirect_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatically redirect HTTP traffic to HTTPS traffic? Possible values are `true` or `false`. Defaults to `true`.

        > **Note:** The `https_redirect_enabled` rule is the first rule that will be executed.
        """
        return pulumi.get(self, "https_redirect_enabled")

    @_builtins.property
    @pulumi.getter(name="linkToDefaultDomain")
    def link_to_default_domain(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Front Door Route be linked to the default endpoint? Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "link_to_default_domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Route. Valid values must begin with a letter or number, end with a letter or number and may only contain letters, numbers and hyphens with a maximum length of 90 characters. Changing this forces a new Front Door Route to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="patternsToMatches")
    def patterns_to_matches(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_matches")

    @_builtins.property
    @pulumi.getter(name="supportedProtocols")
    def supported_protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more Protocols supported by this Front Door Route. Possible values are `Http` or `Https`.

        > **Note:** If `https_redirect_enabled` is set to `true` the `supported_protocols` field must contain both `Http` and `Https` values.
        """
        return pulumi.get(self, "supported_protocols")

