# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFrontdoorFirewallPolicyResult',
    'AwaitableGetFrontdoorFirewallPolicyResult',
    'get_frontdoor_firewall_policy',
    'get_frontdoor_firewall_policy_output',
]

@pulumi.output_type
class GetFrontdoorFirewallPolicyResult:
    """
    A collection of values returned by getFrontdoorFirewallPolicy.
    """
    def __init__(__self__, enabled=None, frontend_endpoint_ids=None, id=None, js_challenge_cookie_expiration_in_minutes=None, mode=None, name=None, redirect_url=None, resource_group_name=None, sku_name=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if frontend_endpoint_ids and not isinstance(frontend_endpoint_ids, list):
            raise TypeError("Expected argument 'frontend_endpoint_ids' to be a list")
        pulumi.set(__self__, "frontend_endpoint_ids", frontend_endpoint_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if js_challenge_cookie_expiration_in_minutes and not isinstance(js_challenge_cookie_expiration_in_minutes, int):
            raise TypeError("Expected argument 'js_challenge_cookie_expiration_in_minutes' to be a int")
        pulumi.set(__self__, "js_challenge_cookie_expiration_in_minutes", js_challenge_cookie_expiration_in_minutes)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if redirect_url and not isinstance(redirect_url, str):
            raise TypeError("Expected argument 'redirect_url' to be a str")
        pulumi.set(__self__, "redirect_url", redirect_url)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The enabled state of the Front Door Firewall Policy.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> Sequence[_builtins.str]:
        """
        The Front Door Profiles frontend endpoints associated with this Front Door Firewall Policy.
        """
        return pulumi.get(self, "frontend_endpoint_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> _builtins.int:
        """
        The Front Door Firewall Policy JavaScript challenge cookie lifetime in minutes.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The Front Door Firewall Policy mode.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> _builtins.str:
        """
        The redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The sku's pricing tier for this Front Door Firewall Policy.
        """
        return pulumi.get(self, "sku_name")


class AwaitableGetFrontdoorFirewallPolicyResult(GetFrontdoorFirewallPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFrontdoorFirewallPolicyResult(
            enabled=self.enabled,
            frontend_endpoint_ids=self.frontend_endpoint_ids,
            id=self.id,
            js_challenge_cookie_expiration_in_minutes=self.js_challenge_cookie_expiration_in_minutes,
            mode=self.mode,
            name=self.name,
            redirect_url=self.redirect_url,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name)


def get_frontdoor_firewall_policy(name: Optional[_builtins.str] = None,
                                  resource_group_name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFrontdoorFirewallPolicyResult:
    """
    Use this data source to access information about an existing Front Door (standard/premium) Firewall Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cdn.get_frontdoor_firewall_policy(name="examplecdnfdwafpolicy",
        resource_group_name=example_azurerm_resource_group["name"])
    ```


    :param _builtins.str name: The name of the Front Door Firewall Policy.
    :param _builtins.str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cdn/getFrontdoorFirewallPolicy:getFrontdoorFirewallPolicy', __args__, opts=opts, typ=GetFrontdoorFirewallPolicyResult).value

    return AwaitableGetFrontdoorFirewallPolicyResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        frontend_endpoint_ids=pulumi.get(__ret__, 'frontend_endpoint_ids'),
        id=pulumi.get(__ret__, 'id'),
        js_challenge_cookie_expiration_in_minutes=pulumi.get(__ret__, 'js_challenge_cookie_expiration_in_minutes'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        redirect_url=pulumi.get(__ret__, 'redirect_url'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'))
def get_frontdoor_firewall_policy_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                         resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFrontdoorFirewallPolicyResult]:
    """
    Use this data source to access information about an existing Front Door (standard/premium) Firewall Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cdn.get_frontdoor_firewall_policy(name="examplecdnfdwafpolicy",
        resource_group_name=example_azurerm_resource_group["name"])
    ```


    :param _builtins.str name: The name of the Front Door Firewall Policy.
    :param _builtins.str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cdn/getFrontdoorFirewallPolicy:getFrontdoorFirewallPolicy', __args__, opts=opts, typ=GetFrontdoorFirewallPolicyResult)
    return __ret__.apply(lambda __response__: GetFrontdoorFirewallPolicyResult(
        enabled=pulumi.get(__response__, 'enabled'),
        frontend_endpoint_ids=pulumi.get(__response__, 'frontend_endpoint_ids'),
        id=pulumi.get(__response__, 'id'),
        js_challenge_cookie_expiration_in_minutes=pulumi.get(__response__, 'js_challenge_cookie_expiration_in_minutes'),
        mode=pulumi.get(__response__, 'mode'),
        name=pulumi.get(__response__, 'name'),
        redirect_url=pulumi.get(__response__, 'redirect_url'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name')))
