# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountRaiBlocklistArgs', 'AccountRaiBlocklist']

@pulumi.input_type
class AccountRaiBlocklistArgs:
    def __init__(__self__, *,
                 cognitive_account_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountRaiBlocklist resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        :param pulumi.Input[_builtins.str] description: A short description for the Cognitive Account Rai Blocklist.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short description for the Cognitive Account Rai Blocklist.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AccountRaiBlocklistState:
    def __init__(__self__, *,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountRaiBlocklist resources.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        :param pulumi.Input[_builtins.str] description: A short description for the Cognitive Account Rai Blocklist.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        if cognitive_account_id is not None:
            pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short description for the Cognitive Account Rai Blocklist.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:cognitive/accountRaiBlocklist:AccountRaiBlocklist")
class AccountRaiBlocklist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cognitive Account Rai Blocklist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="Brazil South")
        example_account = azure.cognitive.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            kind="OpenAI",
            sku_name="S0")
        example_account_rai_blocklist = azure.cognitive.AccountRaiBlocklist("example",
            name="example-crb",
            cognitive_account_id=example_account.id,
            description="Azure OpenAI Rai Blocklist")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices`: 2024-10-01

        ## Import

        Cognitive Account Rai Blocklist can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/accountRaiBlocklist:AccountRaiBlocklist example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.CognitiveServices/accounts/account1/raiBlocklists/raiblocklist1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        :param pulumi.Input[_builtins.str] description: A short description for the Cognitive Account Rai Blocklist.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountRaiBlocklistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cognitive Account Rai Blocklist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="Brazil South")
        example_account = azure.cognitive.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            kind="OpenAI",
            sku_name="S0")
        example_account_rai_blocklist = azure.cognitive.AccountRaiBlocklist("example",
            name="example-crb",
            cognitive_account_id=example_account.id,
            description="Azure OpenAI Rai Blocklist")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices`: 2024-10-01

        ## Import

        Cognitive Account Rai Blocklist can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/accountRaiBlocklist:AccountRaiBlocklist example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.CognitiveServices/accounts/account1/raiBlocklists/raiblocklist1
        ```

        :param str resource_name: The name of the resource.
        :param AccountRaiBlocklistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountRaiBlocklistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountRaiBlocklistArgs.__new__(AccountRaiBlocklistArgs)

            if cognitive_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'cognitive_account_id'")
            __props__.__dict__["cognitive_account_id"] = cognitive_account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(AccountRaiBlocklist, __self__).__init__(
            'azure:cognitive/accountRaiBlocklist:AccountRaiBlocklist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountRaiBlocklist':
        """
        Get an existing AccountRaiBlocklist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        :param pulumi.Input[_builtins.str] description: A short description for the Cognitive Account Rai Blocklist.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountRaiBlocklistState.__new__(_AccountRaiBlocklistState)

        __props__.__dict__["cognitive_account_id"] = cognitive_account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return AccountRaiBlocklist(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A short description for the Cognitive Account Rai Blocklist.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cognitive Account Rai Blocklist. Changing this forces a new Cognitive Account Rai Blocklist to be created.
        """
        return pulumi.get(self, "name")

