# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BastionHostArgs', 'BastionHost']

@pulumi.input_type
class BastionHostArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 copy_paste_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_copy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input['BastionHostIpConfigurationArgs']] = None,
                 ip_connect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_units: Optional[pulumi.Input[_builtins.int]] = None,
                 session_recording_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shareable_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunneling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a BastionHost resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] copy_paste_enabled: Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] file_copy_enabled: Is File Copy feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input['BastionHostIpConfigurationArgs'] ip_configuration: A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ip_connect_enabled: Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] scale_units: The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.
               
               > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        :param pulumi.Input[_builtins.bool] session_recording_enabled: Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        :param pulumi.Input[_builtins.bool] shareable_link_enabled: Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
               
               > **Note:** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] tunneling_enabled: Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if copy_paste_enabled is not None:
            pulumi.set(__self__, "copy_paste_enabled", copy_paste_enabled)
        if file_copy_enabled is not None:
            pulumi.set(__self__, "file_copy_enabled", file_copy_enabled)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if ip_connect_enabled is not None:
            pulumi.set(__self__, "ip_connect_enabled", ip_connect_enabled)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scale_units is not None:
            pulumi.set(__self__, "scale_units", scale_units)
        if session_recording_enabled is not None:
            pulumi.set(__self__, "session_recording_enabled", session_recording_enabled)
        if shareable_link_enabled is not None:
            pulumi.set(__self__, "shareable_link_enabled", shareable_link_enabled)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunneling_enabled is not None:
            pulumi.set(__self__, "tunneling_enabled", tunneling_enabled)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="copyPasteEnabled")
    def copy_paste_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        """
        return pulumi.get(self, "copy_paste_enabled")

    @copy_paste_enabled.setter
    def copy_paste_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_paste_enabled", value)

    @_builtins.property
    @pulumi.getter(name="fileCopyEnabled")
    def file_copy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is File Copy feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "file_copy_enabled")

    @file_copy_enabled.setter
    def file_copy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "file_copy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['BastionHostIpConfigurationArgs']]:
        """
        A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['BastionHostIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @_builtins.property
    @pulumi.getter(name="ipConnectEnabled")
    def ip_connect_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "ip_connect_enabled")

    @ip_connect_enabled.setter
    def ip_connect_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_connect_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.

        > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        """
        return pulumi.get(self, "scale_units")

    @scale_units.setter
    def scale_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_units", value)

    @_builtins.property
    @pulumi.getter(name="sessionRecordingEnabled")
    def session_recording_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        """
        return pulumi.get(self, "session_recording_enabled")

    @session_recording_enabled.setter
    def session_recording_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "session_recording_enabled", value)

    @_builtins.property
    @pulumi.getter(name="shareableLinkEnabled")
    def shareable_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "shareable_link_enabled")

    @shareable_link_enabled.setter
    def shareable_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shareable_link_enabled", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.

        > **Note:** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelingEnabled")
    def tunneling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "tunneling_enabled")

    @tunneling_enabled.setter
    def tunneling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunneling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _BastionHostState:
    def __init__(__self__, *,
                 copy_paste_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_copy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input['BastionHostIpConfigurationArgs']] = None,
                 ip_connect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_units: Optional[pulumi.Input[_builtins.int]] = None,
                 session_recording_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shareable_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunneling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BastionHost resources.
        :param pulumi.Input[_builtins.bool] copy_paste_enabled: Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The FQDN for the Bastion Host.
        :param pulumi.Input[_builtins.bool] file_copy_enabled: Is File Copy feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input['BastionHostIpConfigurationArgs'] ip_configuration: A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ip_connect_enabled: Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] scale_units: The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.
               
               > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        :param pulumi.Input[_builtins.bool] session_recording_enabled: Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        :param pulumi.Input[_builtins.bool] shareable_link_enabled: Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
               
               > **Note:** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] tunneling_enabled: Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        if copy_paste_enabled is not None:
            pulumi.set(__self__, "copy_paste_enabled", copy_paste_enabled)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if file_copy_enabled is not None:
            pulumi.set(__self__, "file_copy_enabled", file_copy_enabled)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if ip_connect_enabled is not None:
            pulumi.set(__self__, "ip_connect_enabled", ip_connect_enabled)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scale_units is not None:
            pulumi.set(__self__, "scale_units", scale_units)
        if session_recording_enabled is not None:
            pulumi.set(__self__, "session_recording_enabled", session_recording_enabled)
        if shareable_link_enabled is not None:
            pulumi.set(__self__, "shareable_link_enabled", shareable_link_enabled)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunneling_enabled is not None:
            pulumi.set(__self__, "tunneling_enabled", tunneling_enabled)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="copyPasteEnabled")
    def copy_paste_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        """
        return pulumi.get(self, "copy_paste_enabled")

    @copy_paste_enabled.setter
    def copy_paste_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_paste_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN for the Bastion Host.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="fileCopyEnabled")
    def file_copy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is File Copy feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "file_copy_enabled")

    @file_copy_enabled.setter
    def file_copy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "file_copy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['BastionHostIpConfigurationArgs']]:
        """
        A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['BastionHostIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @_builtins.property
    @pulumi.getter(name="ipConnectEnabled")
    def ip_connect_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "ip_connect_enabled")

    @ip_connect_enabled.setter
    def ip_connect_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_connect_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.

        > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        """
        return pulumi.get(self, "scale_units")

    @scale_units.setter
    def scale_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_units", value)

    @_builtins.property
    @pulumi.getter(name="sessionRecordingEnabled")
    def session_recording_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        """
        return pulumi.get(self, "session_recording_enabled")

    @session_recording_enabled.setter
    def session_recording_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "session_recording_enabled", value)

    @_builtins.property
    @pulumi.getter(name="shareableLinkEnabled")
    def shareable_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "shareable_link_enabled")

    @shareable_link_enabled.setter
    def shareable_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shareable_link_enabled", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.

        > **Note:** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelingEnabled")
    def tunneling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "tunneling_enabled")

    @tunneling_enabled.setter
    def tunneling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tunneling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:compute/bastionHost:BastionHost")
class BastionHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_paste_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_copy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[Union['BastionHostIpConfigurationArgs', 'BastionHostIpConfigurationArgsDict']]] = None,
                 ip_connect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_units: Optional[pulumi.Input[_builtins.int]] = None,
                 session_recording_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shareable_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunneling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Bastion Host.

        ## Example Usage

        This example deploys an Azure Bastion Host Instance to a target virtual network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevnet",
            address_spaces=["192.168.1.0/24"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="AzureBastionSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.1.224/27"])
        example_public_ip = azure.network.PublicIp("example",
            name="examplepip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_bastion_host = azure.compute.BastionHost("example",
            name="examplebastion",
            location=example.location,
            resource_group_name=example.name,
            ip_configuration={
                "name": "configuration",
                "subnet_id": example_subnet.id,
                "public_ip_address_id": example_public_ip.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-01-01

        ## Import

        Bastion Hosts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/bastionHost:BastionHost example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/bastionHosts/instance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] copy_paste_enabled: Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] file_copy_enabled: Is File Copy feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[Union['BastionHostIpConfigurationArgs', 'BastionHostIpConfigurationArgsDict']] ip_configuration: A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ip_connect_enabled: Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] scale_units: The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.
               
               > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        :param pulumi.Input[_builtins.bool] session_recording_enabled: Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        :param pulumi.Input[_builtins.bool] shareable_link_enabled: Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
               
               > **Note:** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] tunneling_enabled: Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BastionHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Bastion Host.

        ## Example Usage

        This example deploys an Azure Bastion Host Instance to a target virtual network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevnet",
            address_spaces=["192.168.1.0/24"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="AzureBastionSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.1.224/27"])
        example_public_ip = azure.network.PublicIp("example",
            name="examplepip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_bastion_host = azure.compute.BastionHost("example",
            name="examplebastion",
            location=example.location,
            resource_group_name=example.name,
            ip_configuration={
                "name": "configuration",
                "subnet_id": example_subnet.id,
                "public_ip_address_id": example_public_ip.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-01-01

        ## Import

        Bastion Hosts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/bastionHost:BastionHost example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/bastionHosts/instance1
        ```

        :param str resource_name: The name of the resource.
        :param BastionHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BastionHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_paste_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_copy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[Union['BastionHostIpConfigurationArgs', 'BastionHostIpConfigurationArgsDict']]] = None,
                 ip_connect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_units: Optional[pulumi.Input[_builtins.int]] = None,
                 session_recording_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shareable_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunneling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BastionHostArgs.__new__(BastionHostArgs)

            __props__.__dict__["copy_paste_enabled"] = copy_paste_enabled
            __props__.__dict__["file_copy_enabled"] = file_copy_enabled
            __props__.__dict__["ip_configuration"] = ip_configuration
            __props__.__dict__["ip_connect_enabled"] = ip_connect_enabled
            __props__.__dict__["kerberos_enabled"] = kerberos_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scale_units"] = scale_units
            __props__.__dict__["session_recording_enabled"] = session_recording_enabled
            __props__.__dict__["shareable_link_enabled"] = shareable_link_enabled
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tunneling_enabled"] = tunneling_enabled
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["zones"] = zones
            __props__.__dict__["dns_name"] = None
        super(BastionHost, __self__).__init__(
            'azure:compute/bastionHost:BastionHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            copy_paste_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            file_copy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_configuration: Optional[pulumi.Input[Union['BastionHostIpConfigurationArgs', 'BastionHostIpConfigurationArgsDict']]] = None,
            ip_connect_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scale_units: Optional[pulumi.Input[_builtins.int]] = None,
            session_recording_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            shareable_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tunneling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'BastionHost':
        """
        Get an existing BastionHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] copy_paste_enabled: Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The FQDN for the Bastion Host.
        :param pulumi.Input[_builtins.bool] file_copy_enabled: Is File Copy feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[Union['BastionHostIpConfigurationArgs', 'BastionHostIpConfigurationArgsDict']] ip_configuration: A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ip_connect_enabled: Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] scale_units: The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.
               
               > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        :param pulumi.Input[_builtins.bool] session_recording_enabled: Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        :param pulumi.Input[_builtins.bool] shareable_link_enabled: Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
               
               > **Note:** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] tunneling_enabled: Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.
               
               > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BastionHostState.__new__(_BastionHostState)

        __props__.__dict__["copy_paste_enabled"] = copy_paste_enabled
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["file_copy_enabled"] = file_copy_enabled
        __props__.__dict__["ip_configuration"] = ip_configuration
        __props__.__dict__["ip_connect_enabled"] = ip_connect_enabled
        __props__.__dict__["kerberos_enabled"] = kerberos_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scale_units"] = scale_units
        __props__.__dict__["session_recording_enabled"] = session_recording_enabled
        __props__.__dict__["shareable_link_enabled"] = shareable_link_enabled
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tunneling_enabled"] = tunneling_enabled
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        __props__.__dict__["zones"] = zones
        return BastionHost(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="copyPasteEnabled")
    def copy_paste_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Copy/Paste feature enabled for the Bastion Host. Defaults to `true`.
        """
        return pulumi.get(self, "copy_paste_enabled")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN for the Bastion Host.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="fileCopyEnabled")
    def file_copy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is File Copy feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `file_copy_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "file_copy_enabled")

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> pulumi.Output[Optional['outputs.BastionHostIpConfiguration']]:
        """
        A `ip_configuration` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_configuration")

    @_builtins.property
    @pulumi.getter(name="ipConnectEnabled")
    def ip_connect_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is IP Connect feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `ip_connect_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "ip_connect_enabled")

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Kerberos authentication feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `kerberos_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "kerberos_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. Review [Azure Bastion Host FAQ](https://docs.microsoft.com/azure/bastion/bastion-faq) for supported locations.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of scale units with which to provision the Bastion Host. Possible values are between `2` and `50`. Defaults to `2`.

        > **Note:** `scale_units` only can be changed when `sku` is `Standard` or `Premium`. `scale_units` is always `2` when `sku` is `Basic`.
        """
        return pulumi.get(self, "scale_units")

    @_builtins.property
    @pulumi.getter(name="sessionRecordingEnabled")
    def session_recording_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Session Recording feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `session_recording_enabled` is only supported when `sku` is `Premium`.
        """
        return pulumi.get(self, "session_recording_enabled")

    @_builtins.property
    @pulumi.getter(name="shareableLinkEnabled")
    def shareable_link_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Shareable Link feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `shareable_link_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "shareable_link_enabled")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SKU of the Bastion Host. Accepted values are `Developer`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.

        > **Note:** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tunnelingEnabled")
    def tunneling_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Tunneling feature enabled for the Bastion Host. Defaults to `false`.

        > **Note:** `tunneling_enabled` is only supported when `sku` is `Standard` or `Premium`.
        """
        return pulumi.get(self, "tunneling_enabled")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Virtual Network for the Developer Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Public Bastion Host should be located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

