# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiskEncryptionSetArgs', 'DiskEncryptionSet']

@pulumi.input_type
class DiskEncryptionSetArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['DiskEncryptionSetIdentityArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 auto_key_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DiskEncryptionSet resource.
        :param pulumi.Input['DiskEncryptionSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] encryption_type: The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] federated_client_id: Multi-tenant application client id to access key vault in a different tenant.
        :param pulumi.Input[_builtins.str] key_vault_key_id: Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
               
               > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).
               
               > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
               In this case, `keyvault.AccessPolicy` is not needed.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        :param pulumi.Input[_builtins.str] name: The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Disk Encryption Set.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if auto_key_rotation_enabled is not None:
            pulumi.set(__self__, "auto_key_rotation_enabled", auto_key_rotation_enabled)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if federated_client_id is not None:
            pulumi.set(__self__, "federated_client_id", federated_client_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['DiskEncryptionSetIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['DiskEncryptionSetIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationEnabled")
    def auto_key_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_key_rotation_enabled")

    @auto_key_rotation_enabled.setter
    def auto_key_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_key_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-tenant application client id to access key vault in a different tenant.
        """
        return pulumi.get(self, "federated_client_id")

    @federated_client_id.setter
    def federated_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federated_client_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.

        > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).

        > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
        In this case, `keyvault.AccessPolicy` is not needed.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Disk Encryption Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DiskEncryptionSetState:
    def __init__(__self__, *,
                 auto_key_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['DiskEncryptionSetIdentityArgs']] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DiskEncryptionSet resources.
        :param pulumi.Input[_builtins.str] encryption_type: The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] federated_client_id: Multi-tenant application client id to access key vault in a different tenant.
        :param pulumi.Input['DiskEncryptionSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_key_id: Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
               
               > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).
               
               > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
               In this case, `keyvault.AccessPolicy` is not needed.
        :param pulumi.Input[_builtins.str] key_vault_key_url: The URL for the Key Vault Key or Key Vault Secret that is currently being used by the service.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        :param pulumi.Input[_builtins.str] name: The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Disk Encryption Set.
        """
        if auto_key_rotation_enabled is not None:
            pulumi.set(__self__, "auto_key_rotation_enabled", auto_key_rotation_enabled)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if federated_client_id is not None:
            pulumi.set(__self__, "federated_client_id", federated_client_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if key_vault_key_url is not None:
            pulumi.set(__self__, "key_vault_key_url", key_vault_key_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationEnabled")
    def auto_key_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_key_rotation_enabled")

    @auto_key_rotation_enabled.setter
    def auto_key_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_key_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-tenant application client id to access key vault in a different tenant.
        """
        return pulumi.get(self, "federated_client_id")

    @federated_client_id.setter
    def federated_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federated_client_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DiskEncryptionSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DiskEncryptionSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.

        > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).

        > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
        In this case, `keyvault.AccessPolicy` is not needed.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyUrl")
    def key_vault_key_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the Key Vault Key or Key Vault Secret that is currently being used by the service.
        """
        return pulumi.get(self, "key_vault_key_url")

    @key_vault_key_url.setter
    def key_vault_key_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_url", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Disk Encryption Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:compute/diskEncryptionSet:DiskEncryptionSet")
class DiskEncryptionSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_key_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['DiskEncryptionSetIdentityArgs', 'DiskEncryptionSetIdentityArgsDict']]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Disk Encryption Set.

        > **NOTE:** At this time the Key Vault used to store the Active Key for this Disk Encryption Set must have both Soft Delete & Purge Protection enabled - which are not yet supported by this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="des-example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            enabled_for_disk_encryption=True,
            purge_protection_enabled=True)
        example_user = azure.keyvault.AccessPolicy("example-user",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="des-example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_user]))
        example_disk_encryption_set = azure.compute.DiskEncryptionSet("example",
            name="des",
            resource_group_name=example.name,
            location=example.location,
            key_vault_key_id=example_key.id,
            identity={
                "type": "SystemAssigned",
            })
        example_disk = azure.keyvault.AccessPolicy("example-disk",
            key_vault_id=example_key_vault.id,
            tenant_id=example_disk_encryption_set.identity.tenant_id,
            object_id=example_disk_encryption_set.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
            ])
        example_disk_assignment = azure.authorization.Assignment("example-disk",
            scope=example_key_vault.id,
            role_definition_name="Key Vault Crypto Service Encryption User",
            principal_id=example_disk_encryption_set.identity.principal_id)
        ```

        ### With Automatic Key Rotation Enabled

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="des-example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            enabled_for_disk_encryption=True,
            purge_protection_enabled=True)
        example_user = azure.keyvault.AccessPolicy("example-user",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="des-example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_user]))
        example_disk_encryption_set = azure.compute.DiskEncryptionSet("example",
            name="des",
            resource_group_name=example.name,
            location=example.location,
            key_vault_key_id=example_key.versionless_id,
            auto_key_rotation_enabled=True,
            identity={
                "type": "SystemAssigned",
            })
        example_disk = azure.keyvault.AccessPolicy("example-disk",
            key_vault_id=example_key_vault.id,
            tenant_id=example_disk_encryption_set.identity.tenant_id,
            object_id=example_disk_encryption_set.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
            ])
        example_disk_assignment = azure.authorization.Assignment("example-disk",
            scope=example_key_vault.id,
            role_definition_name="Key Vault Crypto Service Encryption User",
            principal_id=example_disk_encryption_set.identity.principal_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-02

        ## Import

        Disk Encryption Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/diskEncryptionSet:DiskEncryptionSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/diskEncryptionSets/encryptionSet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] encryption_type: The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] federated_client_id: Multi-tenant application client id to access key vault in a different tenant.
        :param pulumi.Input[Union['DiskEncryptionSetIdentityArgs', 'DiskEncryptionSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_key_id: Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
               
               > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).
               
               > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
               In this case, `keyvault.AccessPolicy` is not needed.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        :param pulumi.Input[_builtins.str] name: The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Disk Encryption Set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskEncryptionSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Disk Encryption Set.

        > **NOTE:** At this time the Key Vault used to store the Active Key for this Disk Encryption Set must have both Soft Delete & Purge Protection enabled - which are not yet supported by this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="des-example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            enabled_for_disk_encryption=True,
            purge_protection_enabled=True)
        example_user = azure.keyvault.AccessPolicy("example-user",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="des-example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_user]))
        example_disk_encryption_set = azure.compute.DiskEncryptionSet("example",
            name="des",
            resource_group_name=example.name,
            location=example.location,
            key_vault_key_id=example_key.id,
            identity={
                "type": "SystemAssigned",
            })
        example_disk = azure.keyvault.AccessPolicy("example-disk",
            key_vault_id=example_key_vault.id,
            tenant_id=example_disk_encryption_set.identity.tenant_id,
            object_id=example_disk_encryption_set.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
            ])
        example_disk_assignment = azure.authorization.Assignment("example-disk",
            scope=example_key_vault.id,
            role_definition_name="Key Vault Crypto Service Encryption User",
            principal_id=example_disk_encryption_set.identity.principal_id)
        ```

        ### With Automatic Key Rotation Enabled

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="des-example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            enabled_for_disk_encryption=True,
            purge_protection_enabled=True)
        example_user = azure.keyvault.AccessPolicy("example-user",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="des-example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_user]))
        example_disk_encryption_set = azure.compute.DiskEncryptionSet("example",
            name="des",
            resource_group_name=example.name,
            location=example.location,
            key_vault_key_id=example_key.versionless_id,
            auto_key_rotation_enabled=True,
            identity={
                "type": "SystemAssigned",
            })
        example_disk = azure.keyvault.AccessPolicy("example-disk",
            key_vault_id=example_key_vault.id,
            tenant_id=example_disk_encryption_set.identity.tenant_id,
            object_id=example_disk_encryption_set.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "List",
                "Decrypt",
                "Sign",
            ])
        example_disk_assignment = azure.authorization.Assignment("example-disk",
            scope=example_key_vault.id,
            role_definition_name="Key Vault Crypto Service Encryption User",
            principal_id=example_disk_encryption_set.identity.principal_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-02

        ## Import

        Disk Encryption Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/diskEncryptionSet:DiskEncryptionSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/diskEncryptionSets/encryptionSet1
        ```

        :param str resource_name: The name of the resource.
        :param DiskEncryptionSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskEncryptionSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_key_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['DiskEncryptionSetIdentityArgs', 'DiskEncryptionSetIdentityArgsDict']]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskEncryptionSetArgs.__new__(DiskEncryptionSetArgs)

            __props__.__dict__["auto_key_rotation_enabled"] = auto_key_rotation_enabled
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["federated_client_id"] = federated_client_id
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["key_vault_key_url"] = None
        super(DiskEncryptionSet, __self__).__init__(
            'azure:compute/diskEncryptionSet:DiskEncryptionSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_key_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
            federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['DiskEncryptionSetIdentityArgs', 'DiskEncryptionSetIdentityArgsDict']]] = None,
            key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DiskEncryptionSet':
        """
        Get an existing DiskEncryptionSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] encryption_type: The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] federated_client_id: Multi-tenant application client id to access key vault in a different tenant.
        :param pulumi.Input[Union['DiskEncryptionSetIdentityArgs', 'DiskEncryptionSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_key_id: Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
               
               > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).
               
               > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
               In this case, `keyvault.AccessPolicy` is not needed.
        :param pulumi.Input[_builtins.str] key_vault_key_url: The URL for the Key Vault Key or Key Vault Secret that is currently being used by the service.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        :param pulumi.Input[_builtins.str] name: The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Disk Encryption Set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskEncryptionSetState.__new__(_DiskEncryptionSetState)

        __props__.__dict__["auto_key_rotation_enabled"] = auto_key_rotation_enabled
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["federated_client_id"] = federated_client_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["key_vault_key_url"] = key_vault_key_url
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return DiskEncryptionSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationEnabled")
    def auto_key_rotation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "auto_key_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of key used to encrypt the data of the disk. Possible values are `EncryptionAtRestWithCustomerKey`, `EncryptionAtRestWithPlatformAndCustomerKeys` and `ConfidentialVmEncryptedWithCustomerKey`. Defaults to `EncryptionAtRestWithCustomerKey`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Multi-tenant application client id to access key vault in a different tenant.
        """
        return pulumi.get(self, "federated_client_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.DiskEncryptionSetIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the URL to a Key Vault Key (either from a Key Vault Key, or the Key URL for the Key Vault Secret). Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.

        > **Note:** Access to the KeyVault must be granted for this Disk Encryption Set, if you want to further use this Disk Encryption Set in a Managed Disk or Virtual Machine, or Virtual Machine Scale Set. For instructions, please refer to the doc of [Server side encryption of Azure managed disks](https://docs.microsoft.com/azure/virtual-machines/linux/disk-encryption).

        > **Note:** A KeyVault or Managed HSM using enable_rbac_authorization requires to use `authorization.Assignment` to assign the role `Key Vault Crypto Service Encryption User` to this Disk Encryption Set.
        In this case, `keyvault.AccessPolicy` is not needed.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyUrl")
    def key_vault_key_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the Key Vault Key or Key Vault Secret that is currently being used by the service.
        """
        return pulumi.get(self, "key_vault_key_url")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Disk Encryption Set exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_key_id` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Disk Encryption Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Disk Encryption Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Disk Encryption Set.
        """
        return pulumi.get(self, "tags")

