# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSshPublicKeyResult',
    'AwaitableGetSshPublicKeyResult',
    'get_ssh_public_key',
    'get_ssh_public_key_output',
]

@pulumi.output_type
class GetSshPublicKeyResult:
    """
    A collection of values returned by getSshPublicKey.
    """
    def __init__(__self__, id=None, name=None, public_key=None, resource_group_name=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The SSH public key used to authenticate to a virtual machine through ssh.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetSshPublicKeyResult(GetSshPublicKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshPublicKeyResult(
            id=self.id,
            name=self.name,
            public_key=self.public_key,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_ssh_public_key(name: Optional[_builtins.str] = None,
                       resource_group_name: Optional[_builtins.str] = None,
                       tags: Optional[Mapping[str, _builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshPublicKeyResult:
    """
    Use this data source to access information about an existing SSH Public Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_ssh_public_key(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str name: The name of this SSH Public Key.
    :param _builtins.str resource_group_name: The name of the Resource Group where the SSH Public Key exists.
    :param Mapping[str, _builtins.str] tags: A mapping of tags which should be assigned to the SSH Public Key.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getSshPublicKey:getSshPublicKey', __args__, opts=opts, typ=GetSshPublicKeyResult).value

    return AwaitableGetSshPublicKeyResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ssh_public_key_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSshPublicKeyResult]:
    """
    Use this data source to access information about an existing SSH Public Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_ssh_public_key(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str name: The name of this SSH Public Key.
    :param _builtins.str resource_group_name: The name of the Resource Group where the SSH Public Key exists.
    :param Mapping[str, _builtins.str] tags: A mapping of tags which should be assigned to the SSH Public Key.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getSshPublicKey:getSshPublicKey', __args__, opts=opts, typ=GetSshPublicKeyResult)
    return __ret__.apply(lambda __response__: GetSshPublicKeyResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
