# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualMachineScaleSetResult',
    'AwaitableGetVirtualMachineScaleSetResult',
    'get_virtual_machine_scale_set',
    'get_virtual_machine_scale_set_output',
]

@pulumi.output_type
class GetVirtualMachineScaleSetResult:
    """
    A collection of values returned by getVirtualMachineScaleSet.
    """
    def __init__(__self__, id=None, identities=None, instances=None, location=None, name=None, network_interfaces=None, resource_group_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetVirtualMachineScaleSetIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetVirtualMachineScaleSetInstanceResult']:
        """
        A list of `instances` blocks as defined below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region in which this Virtual Machine Scale Set exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the public IP address configuration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceResult']:
        """
        A list of `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")


class AwaitableGetVirtualMachineScaleSetResult(GetVirtualMachineScaleSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualMachineScaleSetResult(
            id=self.id,
            identities=self.identities,
            instances=self.instances,
            location=self.location,
            name=self.name,
            network_interfaces=self.network_interfaces,
            resource_group_name=self.resource_group_name)


def get_virtual_machine_scale_set(name: Optional[_builtins.str] = None,
                                  resource_group_name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualMachineScaleSetResult:
    """
    Use this data source to access information about an existing Virtual Machine Scale Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_virtual_machine_scale_set(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-11-01, 2024-03-01, 2023-09-01


    :param _builtins.str name: The name of this Virtual Machine Scale Set.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Virtual Machine Scale Set exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getVirtualMachineScaleSet:getVirtualMachineScaleSet', __args__, opts=opts, typ=GetVirtualMachineScaleSetResult).value

    return AwaitableGetVirtualMachineScaleSetResult(
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        instances=pulumi.get(__ret__, 'instances'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        network_interfaces=pulumi.get(__ret__, 'network_interfaces'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'))
def get_virtual_machine_scale_set_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                         resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualMachineScaleSetResult]:
    """
    Use this data source to access information about an existing Virtual Machine Scale Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_virtual_machine_scale_set(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-11-01, 2024-03-01, 2023-09-01


    :param _builtins.str name: The name of this Virtual Machine Scale Set.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Virtual Machine Scale Set exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getVirtualMachineScaleSet:getVirtualMachineScaleSet', __args__, opts=opts, typ=GetVirtualMachineScaleSetResult)
    return __ret__.apply(lambda __response__: GetVirtualMachineScaleSetResult(
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        instances=pulumi.get(__response__, 'instances'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        network_interfaces=pulumi.get(__response__, 'network_interfaces'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name')))
